<?php
// This file was auto-generated from sdk-root/src/data/mgn/2020-02-26/api-2.json
return [ 'version' => '2.0', 'metadata' => [ 'apiVersion' => '2020-02-26', 'auth' => [ 'aws.auth#sigv4', ], 'endpointPrefix' => 'mgn', 'protocol' => 'rest-json', 'protocols' => [ 'rest-json', ], 'serviceAbbreviation' => 'mgn', 'serviceFullName' => 'Application Migration Service', 'serviceId' => 'mgn', 'signatureVersion' => 'v4', 'signingName' => 'mgn', 'uid' => 'mgn-2020-02-26', ], 'operations' => [ 'ArchiveApplication' => [ 'name' => 'ArchiveApplication', 'http' => [ 'method' => 'POST', 'requestUri' => '/ArchiveApplication', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ArchiveApplicationRequest', ], 'output' => [ 'shape' => 'Application', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'ConflictException', ], ], ], 'ArchiveWave' => [ 'name' => 'ArchiveWave', 'http' => [ 'method' => 'POST', 'requestUri' => '/ArchiveWave', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ArchiveWaveRequest', ], 'output' => [ 'shape' => 'Wave', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'ConflictException', ], ], ], 'AssociateApplications' => [ 'name' => 'AssociateApplications', 'http' => [ 'method' => 'POST', 'requestUri' => '/AssociateApplications', 'responseCode' => 200, ], 'input' => [ 'shape' => 'AssociateApplicationsRequest', ], 'output' => [ 'shape' => 'AssociateApplicationsResponse', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'ConflictException', ], ], 'idempotent' => true, ], 'AssociateSourceServers' => [ 'name' => 'AssociateSourceServers', 'http' => [ 'method' => 'POST', 'requestUri' => '/AssociateSourceServers', 'responseCode' => 200, ], 'input' => [ 'shape' => 'AssociateSourceServersRequest', ], 'output' => [ 'shape' => 'AssociateSourceServersResponse', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'ConflictException', ], ], 'idempotent' => true, ], 'ChangeServerLifeCycleState' => [ 'name' => 'ChangeServerLifeCycleState', 'http' => [ 'method' => 'POST', 'requestUri' => '/ChangeServerLifeCycleState', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ChangeServerLifeCycleStateRequest', ], 'output' => [ 'shape' => 'SourceServer', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ConflictException', ], ], ], 'CreateApplication' => [ 'name' => 'CreateApplication', 'http' => [ 'method' => 'POST', 'requestUri' => '/CreateApplication', 'responseCode' => 201, ], 'input' => [ 'shape' => 'CreateApplicationRequest', ], 'output' => [ 'shape' => 'Application', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'ConflictException', ], ], 'idempotent' => true, ], 'CreateConnector' => [ 'name' => 'CreateConnector', 'http' => [ 'method' => 'POST', 'requestUri' => '/CreateConnector', 'responseCode' => 201, ], 'input' => [ 'shape' => 'CreateConnectorRequest', ], 'output' => [ 'shape' => 'Connector', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ValidationException', ], ], 'idempotent' => true, ], 'CreateLaunchConfigurationTemplate' => [ 'name' => 'CreateLaunchConfigurationTemplate', 'http' => [ 'method' => 'POST', 'requestUri' => '/CreateLaunchConfigurationTemplate', 'responseCode' => 201, ], 'input' => [ 'shape' => 'CreateLaunchConfigurationTemplateRequest', ], 'output' => [ 'shape' => 'LaunchConfigurationTemplate', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], ], ], 'CreateReplicationConfigurationTemplate' => [ 'name' => 'CreateReplicationConfigurationTemplate', 'http' => [ 'method' => 'POST', 'requestUri' => '/CreateReplicationConfigurationTemplate', 'responseCode' => 201, ], 'input' => [ 'shape' => 'CreateReplicationConfigurationTemplateRequest', ], 'output' => [ 'shape' => 'ReplicationConfigurationTemplate', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], ], ], 'CreateWave' => [ 'name' => 'CreateWave', 'http' => [ 'method' => 'POST', 'requestUri' => '/CreateWave', 'responseCode' => 201, ], 'input' => [ 'shape' => 'CreateWaveRequest', ], 'output' => [ 'shape' => 'Wave', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'ConflictException', ], ], 'idempotent' => true, ], 'DeleteApplication' => [ 'name' => 'DeleteApplication', 'http' => [ 'method' => 'POST', 'requestUri' => '/DeleteApplication', 'responseCode' => 204, ], 'input' => [ 'shape' => 'DeleteApplicationRequest', ], 'output' => [ 'shape' => 'DeleteApplicationResponse', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], ], 'idempotent' => true, ], 'DeleteConnector' => [ 'name' => 'DeleteConnector', 'http' => [ 'method' => 'POST', 'requestUri' => '/DeleteConnector', 'responseCode' => 204, ], 'input' => [ 'shape' => 'DeleteConnectorRequest', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ValidationException', ], ], 'idempotent' => true, ], 'DeleteJob' => [ 'name' => 'DeleteJob', 'http' => [ 'method' => 'POST', 'requestUri' => '/DeleteJob', 'responseCode' => 204, ], 'input' => [ 'shape' => 'DeleteJobRequest', ], 'output' => [ 'shape' => 'DeleteJobResponse', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], ], 'idempotent' => true, ], 'DeleteLaunchConfigurationTemplate' => [ 'name' => 'DeleteLaunchConfigurationTemplate', 'http' => [ 'method' => 'POST', 'requestUri' => '/DeleteLaunchConfigurationTemplate', 'responseCode' => 204, ], 'input' => [ 'shape' => 'DeleteLaunchConfigurationTemplateRequest', ], 'output' => [ 'shape' => 'DeleteLaunchConfigurationTemplateResponse', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], ], 'idempotent' => true, ], 'DeleteReplicationConfigurationTemplate' => [ 'name' => 'DeleteReplicationConfigurationTemplate', 'http' => [ 'method' => 'POST', 'requestUri' => '/DeleteReplicationConfigurationTemplate', 'responseCode' => 204, ], 'input' => [ 'shape' => 'DeleteReplicationConfigurationTemplateRequest', ], 'output' => [ 'shape' => 'DeleteReplicationConfigurationTemplateResponse', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], ], 'idempotent' => true, ], 'DeleteSourceServer' => [ 'name' => 'DeleteSourceServer', 'http' => [ 'method' => 'POST', 'requestUri' => '/DeleteSourceServer', 'responseCode' => 204, ], 'input' => [ 'shape' => 'DeleteSourceServerRequest', ], 'output' => [ 'shape' => 'DeleteSourceServerResponse', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], ], 'idempotent' => true, ], 'DeleteVcenterClient' => [ 'name' => 'DeleteVcenterClient', 'http' => [ 'method' => 'POST', 'requestUri' => '/DeleteVcenterClient', 'responseCode' => 204, ], 'input' => [ 'shape' => 'DeleteVcenterClientRequest', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ValidationException', ], ], 'idempotent' => true, ], 'DeleteWave' => [ 'name' => 'DeleteWave', 'http' => [ 'method' => 'POST', 'requestUri' => '/DeleteWave', 'responseCode' => 204, ], 'input' => [ 'shape' => 'DeleteWaveRequest', ], 'output' => [ 'shape' => 'DeleteWaveResponse', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], ], 'idempotent' => true, ], 'DescribeJobLogItems' => [ 'name' => 'DescribeJobLogItems', 'http' => [ 'method' => 'POST', 'requestUri' => '/DescribeJobLogItems', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DescribeJobLogItemsRequest', ], 'output' => [ 'shape' => 'DescribeJobLogItemsResponse', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ValidationException', ], ], 'readonly' => true, ], 'DescribeJobs' => [ 'name' => 'DescribeJobs', 'http' => [ 'method' => 'POST', 'requestUri' => '/DescribeJobs', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DescribeJobsRequest', ], 'output' => [ 'shape' => 'DescribeJobsResponse', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ValidationException', ], ], 'readonly' => true, ], 'DescribeLaunchConfigurationTemplates' => [ 'name' => 'DescribeLaunchConfigurationTemplates', 'http' => [ 'method' => 'POST', 'requestUri' => '/DescribeLaunchConfigurationTemplates', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DescribeLaunchConfigurationTemplatesRequest', ], 'output' => [ 'shape' => 'DescribeLaunchConfigurationTemplatesResponse', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ValidationException', ], ], 'readonly' => true, ], 'DescribeReplicationConfigurationTemplates' => [ 'name' => 'DescribeReplicationConfigurationTemplates', 'http' => [ 'method' => 'POST', 'requestUri' => '/DescribeReplicationConfigurationTemplates', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DescribeReplicationConfigurationTemplatesRequest', ], 'output' => [ 'shape' => 'DescribeReplicationConfigurationTemplatesResponse', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ValidationException', ], ], 'readonly' => true, ], 'DescribeSourceServers' => [ 'name' => 'DescribeSourceServers', 'http' => [ 'method' => 'POST', 'requestUri' => '/DescribeSourceServers', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DescribeSourceServersRequest', ], 'output' => [ 'shape' => 'DescribeSourceServersResponse', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ValidationException', ], ], 'readonly' => true, ], 'DescribeVcenterClients' => [ 'name' => 'DescribeVcenterClients', 'http' => [ 'method' => 'GET', 'requestUri' => '/DescribeVcenterClients', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DescribeVcenterClientsRequest', ], 'output' => [ 'shape' => 'DescribeVcenterClientsResponse', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ValidationException', ], ], 'readonly' => true, ], 'DisassociateApplications' => [ 'name' => 'DisassociateApplications', 'http' => [ 'method' => 'POST', 'requestUri' => '/DisassociateApplications', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DisassociateApplicationsRequest', ], 'output' => [ 'shape' => 'DisassociateApplicationsResponse', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], ], 'idempotent' => true, ], 'DisassociateSourceServers' => [ 'name' => 'DisassociateSourceServers', 'http' => [ 'method' => 'POST', 'requestUri' => '/DisassociateSourceServers', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DisassociateSourceServersRequest', ], 'output' => [ 'shape' => 'DisassociateSourceServersResponse', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], ], 'idempotent' => true, ], 'DisconnectFromService' => [ 'name' => 'DisconnectFromService', 'http' => [ 'method' => 'POST', 'requestUri' => '/DisconnectFromService', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DisconnectFromServiceRequest', ], 'output' => [ 'shape' => 'SourceServer', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], ], ], 'FinalizeCutover' => [ 'name' => 'FinalizeCutover', 'http' => [ 'method' => 'POST', 'requestUri' => '/FinalizeCutover', 'responseCode' => 200, ], 'input' => [ 'shape' => 'FinalizeCutoverRequest', ], 'output' => [ 'shape' => 'SourceServer', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ConflictException', ], ], ], 'GetLaunchConfiguration' => [ 'name' => 'GetLaunchConfiguration', 'http' => [ 'method' => 'POST', 'requestUri' => '/GetLaunchConfiguration', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetLaunchConfigurationRequest', ], 'output' => [ 'shape' => 'LaunchConfiguration', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ResourceNotFoundException', ], ], 'readonly' => true, ], 'GetReplicationConfiguration' => [ 'name' => 'GetReplicationConfiguration', 'http' => [ 'method' => 'POST', 'requestUri' => '/GetReplicationConfiguration', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetReplicationConfigurationRequest', ], 'output' => [ 'shape' => 'ReplicationConfiguration', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ResourceNotFoundException', ], ], 'readonly' => true, ], 'InitializeService' => [ 'name' => 'InitializeService', 'http' => [ 'method' => 'POST', 'requestUri' => '/InitializeService', 'responseCode' => 204, ], 'input' => [ 'shape' => 'InitializeServiceRequest', ], 'output' => [ 'shape' => 'InitializeServiceResponse', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], ], ], 'ListApplications' => [ 'name' => 'ListApplications', 'http' => [ 'method' => 'POST', 'requestUri' => '/ListApplications', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListApplicationsRequest', ], 'output' => [ 'shape' => 'ListApplicationsResponse', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], ], 'readonly' => true, ], 'ListConnectors' => [ 'name' => 'ListConnectors', 'http' => [ 'method' => 'POST', 'requestUri' => '/ListConnectors', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListConnectorsRequest', ], 'output' => [ 'shape' => 'ListConnectorsResponse', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ValidationException', ], ], 'readonly' => true, ], 'ListExportErrors' => [ 'name' => 'ListExportErrors', 'http' => [ 'method' => 'POST', 'requestUri' => '/ListExportErrors', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListExportErrorsRequest', ], 'output' => [ 'shape' => 'ListExportErrorsResponse', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ValidationException', ], ], 'readonly' => true, ], 'ListExports' => [ 'name' => 'ListExports', 'http' => [ 'method' => 'POST', 'requestUri' => '/ListExports', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListExportsRequest', ], 'output' => [ 'shape' => 'ListExportsResponse', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], ], 'readonly' => true, ], 'ListImportErrors' => [ 'name' => 'ListImportErrors', 'http' => [ 'method' => 'POST', 'requestUri' => '/ListImportErrors', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListImportErrorsRequest', ], 'output' => [ 'shape' => 'ListImportErrorsResponse', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ValidationException', ], ], 'readonly' => true, ], 'ListImports' => [ 'name' => 'ListImports', 'http' => [ 'method' => 'POST', 'requestUri' => '/ListImports', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListImportsRequest', ], 'output' => [ 'shape' => 'ListImportsResponse', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ValidationException', ], ], 'readonly' => true, ], 'ListManagedAccounts' => [ 'name' => 'ListManagedAccounts', 'http' => [ 'method' => 'POST', 'requestUri' => '/ListManagedAccounts', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListManagedAccountsRequest', ], 'output' => [ 'shape' => 'ListManagedAccountsResponse', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ValidationException', ], ], 'readonly' => true, ], 'ListSourceServerActions' => [ 'name' => 'ListSourceServerActions', 'http' => [ 'method' => 'POST', 'requestUri' => '/ListSourceServerActions', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListSourceServerActionsRequest', ], 'output' => [ 'shape' => 'ListSourceServerActionsResponse', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ResourceNotFoundException', ], ], 'readonly' => true, ], 'ListTagsForResource' => [ 'name' => 'ListTagsForResource', 'http' => [ 'method' => 'GET', 'requestUri' => '/tags/{resourceArn}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListTagsForResourceRequest', ], 'output' => [ 'shape' => 'ListTagsForResourceResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], ], 'readonly' => true, ], 'ListTemplateActions' => [ 'name' => 'ListTemplateActions', 'http' => [ 'method' => 'POST', 'requestUri' => '/ListTemplateActions', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListTemplateActionsRequest', ], 'output' => [ 'shape' => 'ListTemplateActionsResponse', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ResourceNotFoundException', ], ], 'readonly' => true, ], 'ListWaves' => [ 'name' => 'ListWaves', 'http' => [ 'method' => 'POST', 'requestUri' => '/ListWaves', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListWavesRequest', ], 'output' => [ 'shape' => 'ListWavesResponse', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], ], 'readonly' => true, ], 'MarkAsArchived' => [ 'name' => 'MarkAsArchived', 'http' => [ 'method' => 'POST', 'requestUri' => '/MarkAsArchived', 'responseCode' => 200, ], 'input' => [ 'shape' => 'MarkAsArchivedRequest', ], 'output' => [ 'shape' => 'SourceServer', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], ], ], 'PauseReplication' => [ 'name' => 'PauseReplication', 'http' => [ 'method' => 'POST', 'requestUri' => '/PauseReplication', 'responseCode' => 200, ], 'input' => [ 'shape' => 'PauseReplicationRequest', ], 'output' => [ 'shape' => 'SourceServer', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'ConflictException', ], ], ], 'PutSourceServerAction' => [ 'name' => 'PutSourceServerAction', 'http' => [ 'method' => 'POST', 'requestUri' => '/PutSourceServerAction', 'responseCode' => 200, ], 'input' => [ 'shape' => 'PutSourceServerActionRequest', ], 'output' => [ 'shape' => 'SourceServerActionDocument', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ConflictException', ], ], ], 'PutTemplateAction' => [ 'name' => 'PutTemplateAction', 'http' => [ 'method' => 'POST', 'requestUri' => '/PutTemplateAction', 'responseCode' => 200, ], 'input' => [ 'shape' => 'PutTemplateActionRequest', ], 'output' => [ 'shape' => 'TemplateActionDocument', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ConflictException', ], ], ], 'RemoveSourceServerAction' => [ 'name' => 'RemoveSourceServerAction', 'http' => [ 'method' => 'POST', 'requestUri' => '/RemoveSourceServerAction', 'responseCode' => 204, ], 'input' => [ 'shape' => 'RemoveSourceServerActionRequest', ], 'output' => [ 'shape' => 'RemoveSourceServerActionResponse', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ValidationException', ], ], ], 'RemoveTemplateAction' => [ 'name' => 'RemoveTemplateAction', 'http' => [ 'method' => 'POST', 'requestUri' => '/RemoveTemplateAction', 'responseCode' => 204, ], 'input' => [ 'shape' => 'RemoveTemplateActionRequest', ], 'output' => [ 'shape' => 'RemoveTemplateActionResponse', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ValidationException', ], ], ], 'ResumeReplication' => [ 'name' => 'ResumeReplication', 'http' => [ 'method' => 'POST', 'requestUri' => '/ResumeReplication', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ResumeReplicationRequest', ], 'output' => [ 'shape' => 'SourceServer', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'ConflictException', ], ], ], 'RetryDataReplication' => [ 'name' => 'RetryDataReplication', 'http' => [ 'method' => 'POST', 'requestUri' => '/RetryDataReplication', 'responseCode' => 200, ], 'input' => [ 'shape' => 'RetryDataReplicationRequest', ], 'output' => [ 'shape' => 'SourceServer', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ValidationException', ], ], ], 'StartCutover' => [ 'name' => 'StartCutover', 'http' => [ 'method' => 'POST', 'requestUri' => '/StartCutover', 'responseCode' => 202, ], 'input' => [ 'shape' => 'StartCutoverRequest', ], 'output' => [ 'shape' => 'StartCutoverResponse', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ConflictException', ], ], ], 'StartExport' => [ 'name' => 'StartExport', 'http' => [ 'method' => 'POST', 'requestUri' => '/StartExport', 'responseCode' => 202, ], 'input' => [ 'shape' => 'StartExportRequest', ], 'output' => [ 'shape' => 'StartExportResponse', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ServiceQuotaExceededException', ], ], ], 'StartImport' => [ 'name' => 'StartImport', 'http' => [ 'method' => 'POST', 'requestUri' => '/StartImport', 'responseCode' => 202, ], 'input' => [ 'shape' => 'StartImportRequest', ], 'output' => [ 'shape' => 'StartImportResponse', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'ConflictException', ], ], ], 'StartReplication' => [ 'name' => 'StartReplication', 'http' => [ 'method' => 'POST', 'requestUri' => '/StartReplication', 'responseCode' => 200, ], 'input' => [ 'shape' => 'StartReplicationRequest', ], 'output' => [ 'shape' => 'SourceServer', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'ConflictException', ], ], ], 'StartTest' => [ 'name' => 'StartTest', 'http' => [ 'method' => 'POST', 'requestUri' => '/StartTest', 'responseCode' => 202, ], 'input' => [ 'shape' => 'StartTestRequest', ], 'output' => [ 'shape' => 'StartTestResponse', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ConflictException', ], ], ], 'StopReplication' => [ 'name' => 'StopReplication', 'http' => [ 'method' => 'POST', 'requestUri' => '/StopReplication', 'responseCode' => 200, ], 'input' => [ 'shape' => 'StopReplicationRequest', ], 'output' => [ 'shape' => 'SourceServer', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'ConflictException', ], ], ], 'TagResource' => [ 'name' => 'TagResource', 'http' => [ 'method' => 'POST', 'requestUri' => '/tags/{resourceArn}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'TagResourceRequest', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], ], 'idempotent' => true, ], 'TerminateTargetInstances' => [ 'name' => 'TerminateTargetInstances', 'http' => [ 'method' => 'POST', 'requestUri' => '/TerminateTargetInstances', 'responseCode' => 202, ], 'input' => [ 'shape' => 'TerminateTargetInstancesRequest', ], 'output' => [ 'shape' => 'TerminateTargetInstancesResponse', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ConflictException', ], ], ], 'UnarchiveApplication' => [ 'name' => 'UnarchiveApplication', 'http' => [ 'method' => 'POST', 'requestUri' => '/UnarchiveApplication', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UnarchiveApplicationRequest', ], 'output' => [ 'shape' => 'Application', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ServiceQuotaExceededException', ], ], ], 'UnarchiveWave' => [ 'name' => 'UnarchiveWave', 'http' => [ 'method' => 'POST', 'requestUri' => '/UnarchiveWave', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UnarchiveWaveRequest', ], 'output' => [ 'shape' => 'Wave', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ServiceQuotaExceededException', ], ], ], 'UntagResource' => [ 'name' => 'UntagResource', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/tags/{resourceArn}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UntagResourceRequest', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], ], 'idempotent' => true, ], 'UpdateApplication' => [ 'name' => 'UpdateApplication', 'http' => [ 'method' => 'POST', 'requestUri' => '/UpdateApplication', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateApplicationRequest', ], 'output' => [ 'shape' => 'Application', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], ], 'idempotent' => true, ], 'UpdateConnector' => [ 'name' => 'UpdateConnector', 'http' => [ 'method' => 'POST', 'requestUri' => '/UpdateConnector', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateConnectorRequest', ], 'output' => [ 'shape' => 'Connector', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ValidationException', ], ], 'idempotent' => true, ], 'UpdateLaunchConfiguration' => [ 'name' => 'UpdateLaunchConfiguration', 'http' => [ 'method' => 'POST', 'requestUri' => '/UpdateLaunchConfiguration', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateLaunchConfigurationRequest', ], 'output' => [ 'shape' => 'LaunchConfiguration', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ConflictException', ], ], 'idempotent' => true, ], 'UpdateLaunchConfigurationTemplate' => [ 'name' => 'UpdateLaunchConfigurationTemplate', 'http' => [ 'method' => 'POST', 'requestUri' => '/UpdateLaunchConfigurationTemplate', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateLaunchConfigurationTemplateRequest', ], 'output' => [ 'shape' => 'LaunchConfigurationTemplate', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], ], ], 'UpdateReplicationConfiguration' => [ 'name' => 'UpdateReplicationConfiguration', 'http' => [ 'method' => 'POST', 'requestUri' => '/UpdateReplicationConfiguration', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateReplicationConfigurationRequest', ], 'output' => [ 'shape' => 'ReplicationConfiguration', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ConflictException', ], ], 'idempotent' => true, ], 'UpdateReplicationConfigurationTemplate' => [ 'name' => 'UpdateReplicationConfigurationTemplate', 'http' => [ 'method' => 'POST', 'requestUri' => '/UpdateReplicationConfigurationTemplate', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateReplicationConfigurationTemplateRequest', ], 'output' => [ 'shape' => 'ReplicationConfigurationTemplate', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], ], ], 'UpdateSourceServer' => [ 'name' => 'UpdateSourceServer', 'http' => [ 'method' => 'POST', 'requestUri' => '/UpdateSourceServer', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateSourceServerRequest', ], 'output' => [ 'shape' => 'SourceServer', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], ], 'idempotent' => true, ], 'UpdateSourceServerReplicationType' => [ 'name' => 'UpdateSourceServerReplicationType', 'http' => [ 'method' => 'POST', 'requestUri' => '/UpdateSourceServerReplicationType', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateSourceServerReplicationTypeRequest', ], 'output' => [ 'shape' => 'SourceServer', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ConflictException', ], ], ], 'UpdateWave' => [ 'name' => 'UpdateWave', 'http' => [ 'method' => 'POST', 'requestUri' => '/UpdateWave', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateWaveRequest', ], 'output' => [ 'shape' => 'Wave', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], ], 'idempotent' => true, ], ], 'shapes' => [ 'ARN' => [ 'type' => 'string', 'max' => 2048, 'min' => 20, ], 'AccessDeniedException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'LargeBoundedString', ], 'code' => [ 'shape' => 'LargeBoundedString', ], ], 'error' => [ 'httpStatusCode' => 403, 'senderFault' => true, ], 'exception' => true, ], 'AccountID' => [ 'type' => 'string', 'max' => 12, 'min' => 12, 'pattern' => '.*[0-9]{12,}.*', ], 'ActionCategory' => [ 'type' => 'string', 'enum' => [ 'DISASTER_RECOVERY', 'OPERATING_SYSTEM', 'LICENSE_AND_SUBSCRIPTION', 'VALIDATION', 'OBSERVABILITY', 'REFACTORING', 'SECURITY', 'NETWORKING', 'CONFIGURATION', 'BACKUP', 'OTHER', ], ], 'ActionDescription' => [ 'type' => 'string', 'max' => 256, 'min' => 0, 'pattern' => '[0-9a-zA-Z ():/.,\'-_#*; ]*', ], 'ActionID' => [ 'type' => 'string', 'max' => 64, 'min' => 1, 'pattern' => '.*[0-9a-zA-Z]', ], 'ActionIDs' => [ 'type' => 'list', 'member' => [ 'shape' => 'ActionID', ], 'max' => 100, 'min' => 0, ], 'ActionName' => [ 'type' => 'string', 'max' => 256, 'min' => 1, 'pattern' => '[^\\s\\x00]( *[^\\s\\x00])*', ], 'Application' => [ 'type' => 'structure', 'members' => [ 'applicationID' => [ 'shape' => 'ApplicationID', ], 'arn' => [ 'shape' => 'ARN', ], 'name' => [ 'shape' => 'ApplicationName', ], 'description' => [ 'shape' => 'ApplicationDescription', ], 'isArchived' => [ 'shape' => 'Boolean', ], 'applicationAggregatedStatus' => [ 'shape' => 'ApplicationAggregatedStatus', ], 'creationDateTime' => [ 'shape' => 'ISO8601DatetimeString', ], 'lastModifiedDateTime' => [ 'shape' => 'ISO8601DatetimeString', ], 'tags' => [ 'shape' => 'TagsMap', ], 'waveID' => [ 'shape' => 'WaveID', ], ], ], 'ApplicationAggregatedStatus' => [ 'type' => 'structure', 'members' => [ 'lastUpdateDateTime' => [ 'shape' => 'ISO8601DatetimeString', ], 'healthStatus' => [ 'shape' => 'ApplicationHealthStatus', ], 'progressStatus' => [ 'shape' => 'ApplicationProgressStatus', ], 'totalSourceServers' => [ 'shape' => 'PositiveInteger', ], ], ], 'ApplicationDescription' => [ 'type' => 'string', 'max' => 600, 'min' => 0, 'pattern' => '[^\\x00]*', ], 'ApplicationHealthStatus' => [ 'type' => 'string', 'enum' => [ 'HEALTHY', 'LAGGING', 'ERROR', ], ], 'ApplicationID' => [ 'type' => 'string', 'max' => 21, 'min' => 21, 'pattern' => 'app-[0-9a-zA-Z]{17}', ], 'ApplicationIDs' => [ 'type' => 'list', 'member' => [ 'shape' => 'ApplicationID', ], 'max' => 50, 'min' => 1, ], 'ApplicationIDsFilter' => [ 'type' => 'list', 'member' => [ 'shape' => 'ApplicationID', ], 'max' => 200, 'min' => 0, ], 'ApplicationName' => [ 'type' => 'string', 'max' => 256, 'min' => 1, 'pattern' => '[^\\s\\x00]( *[^\\s\\x00])*', ], 'ApplicationProgressStatus' => [ 'type' => 'string', 'enum' => [ 'NOT_STARTED', 'IN_PROGRESS', 'COMPLETED', ], ], 'ApplicationsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'Application', ], ], 'ArchiveApplicationRequest' => [ 'type' => 'structure', 'required' => [ 'applicationID', ], 'members' => [ 'applicationID' => [ 'shape' => 'ApplicationID', ], 'accountID' => [ 'shape' => 'AccountID', ], ], ], 'ArchiveWaveRequest' => [ 'type' => 'structure', 'required' => [ 'waveID', ], 'members' => [ 'waveID' => [ 'shape' => 'WaveID', ], 'accountID' => [ 'shape' => 'AccountID', ], ], ], 'AssociateApplicationsRequest' => [ 'type' => 'structure', 'required' => [ 'waveID', 'applicationIDs', ], 'members' => [ 'waveID' => [ 'shape' => 'WaveID', ], 'applicationIDs' => [ 'shape' => 'ApplicationIDs', ], 'accountID' => [ 'shape' => 'AccountID', ], ], ], 'AssociateApplicationsResponse' => [ 'type' => 'structure', 'members' => [], ], 'AssociateSourceServersRequest' => [ 'type' => 'structure', 'required' => [ 'applicationID', 'sourceServerIDs', ], 'members' => [ 'applicationID' => [ 'shape' => 'ApplicationID', ], 'sourceServerIDs' => [ 'shape' => 'AssociateSourceServersRequestSourceServerIDs', ], 'accountID' => [ 'shape' => 'AccountID', ], ], ], 'AssociateSourceServersRequestSourceServerIDs' => [ 'type' => 'list', 'member' => [ 'shape' => 'SourceServerID', ], 'max' => 50, 'min' => 1, ], 'AssociateSourceServersResponse' => [ 'type' => 'structure', 'members' => [], ], 'BandwidthThrottling' => [ 'type' => 'long', 'max' => 10000, 'min' => 0, ], 'Boolean' => [ 'type' => 'boolean', 'box' => true, ], 'BootMode' => [ 'type' => 'string', 'enum' => [ 'LEGACY_BIOS', 'UEFI', 'USE_SOURCE', ], ], 'BoundedString' => [ 'type' => 'string', 'max' => 256, 'min' => 0, ], 'CPU' => [ 'type' => 'structure', 'members' => [ 'cores' => [ 'shape' => 'PositiveInteger', ], 'modelName' => [ 'shape' => 'BoundedString', ], ], ], 'ChangeServerLifeCycleStateRequest' => [ 'type' => 'structure', 'required' => [ 'sourceServerID', 'lifeCycle', ], 'members' => [ 'sourceServerID' => [ 'shape' => 'SourceServerID', ], 'lifeCycle' => [ 'shape' => 'ChangeServerLifeCycleStateSourceServerLifecycle', ], 'accountID' => [ 'shape' => 'AccountID', ], ], ], 'ChangeServerLifeCycleStateSourceServerLifecycle' => [ 'type' => 'structure', 'required' => [ 'state', ], 'members' => [ 'state' => [ 'shape' => 'ChangeServerLifeCycleStateSourceServerLifecycleState', ], ], ], 'ChangeServerLifeCycleStateSourceServerLifecycleState' => [ 'type' => 'string', 'enum' => [ 'READY_FOR_TEST', 'READY_FOR_CUTOVER', 'CUTOVER', ], ], 'ClientIdempotencyToken' => [ 'type' => 'string', 'max' => 64, 'min' => 0, ], 'CloudWatchLogGroupName' => [ 'type' => 'string', 'max' => 512, 'min' => 1, 'pattern' => '[\\.\\-_/#A-Za-z0-9]+', ], 'ConflictException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'LargeBoundedString', ], 'code' => [ 'shape' => 'LargeBoundedString', ], 'resourceId' => [ 'shape' => 'LargeBoundedString', ], 'resourceType' => [ 'shape' => 'LargeBoundedString', ], 'errors' => [ 'shape' => 'ConflictExceptionErrors', ], ], 'error' => [ 'httpStatusCode' => 409, 'senderFault' => true, ], 'exception' => true, ], 'ConflictExceptionErrors' => [ 'type' => 'list', 'member' => [ 'shape' => 'ErrorDetails', ], ], 'Connector' => [ 'type' => 'structure', 'members' => [ 'connectorID' => [ 'shape' => 'ConnectorID', ], 'name' => [ 'shape' => 'ConnectorName', ], 'ssmInstanceID' => [ 'shape' => 'SsmInstanceID', ], 'arn' => [ 'shape' => 'ARN', ], 'tags' => [ 'shape' => 'TagsMap', ], 'ssmCommandConfig' => [ 'shape' => 'ConnectorSsmCommandConfig', ], ], ], 'ConnectorArn' => [ 'type' => 'string', 'max' => 100, 'min' => 27, 'pattern' => 'arn:[\\w-]+:mgn:([a-z]{2}-(gov-)?[a-z]+-\\d{1})?:(\\d{12})?:connector\\/(connector-[0-9a-zA-Z]{17})', ], 'ConnectorID' => [ 'type' => 'string', 'max' => 27, 'min' => 27, 'pattern' => 'connector-[0-9a-zA-Z]{17}', ], 'ConnectorIDsFilter' => [ 'type' => 'list', 'member' => [ 'shape' => 'ConnectorID', ], 'max' => 20, 'min' => 0, ], 'ConnectorName' => [ 'type' => 'string', 'max' => 256, 'min' => 1, 'pattern' => '[A-Za-z0-9_-]+', ], 'ConnectorSsmCommandConfig' => [ 'type' => 'structure', 'required' => [ 's3OutputEnabled', 'cloudWatchOutputEnabled', ], 'members' => [ 's3OutputEnabled' => [ 'shape' => 'Boolean', ], 'outputS3BucketName' => [ 'shape' => 'S3BucketName', ], 'cloudWatchOutputEnabled' => [ 'shape' => 'Boolean', ], 'cloudWatchLogGroupName' => [ 'shape' => 'CloudWatchLogGroupName', ], ], ], 'ConnectorsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'Connector', ], ], 'Cpus' => [ 'type' => 'list', 'member' => [ 'shape' => 'CPU', ], 'max' => 256, 'min' => 0, ], 'CreateApplicationRequest' => [ 'type' => 'structure', 'required' => [ 'name', ], 'members' => [ 'name' => [ 'shape' => 'ApplicationName', ], 'description' => [ 'shape' => 'ApplicationDescription', ], 'tags' => [ 'shape' => 'TagsMap', ], 'accountID' => [ 'shape' => 'AccountID', ], ], ], 'CreateConnectorRequest' => [ 'type' => 'structure', 'required' => [ 'name', 'ssmInstanceID', ], 'members' => [ 'name' => [ 'shape' => 'ConnectorName', ], 'ssmInstanceID' => [ 'shape' => 'SsmInstanceID', ], 'tags' => [ 'shape' => 'TagsMap', ], 'ssmCommandConfig' => [ 'shape' => 'ConnectorSsmCommandConfig', ], ], ], 'CreateLaunchConfigurationTemplateRequest' => [ 'type' => 'structure', 'members' => [ 'postLaunchActions' => [ 'shape' => 'PostLaunchActions', ], 'enableMapAutoTagging' => [ 'shape' => 'Boolean', ], 'mapAutoTaggingMpeID' => [ 'shape' => 'TagValue', ], 'tags' => [ 'shape' => 'TagsMap', ], 'launchDisposition' => [ 'shape' => 'LaunchDisposition', ], 'targetInstanceTypeRightSizingMethod' => [ 'shape' => 'TargetInstanceTypeRightSizingMethod', ], 'copyPrivateIp' => [ 'shape' => 'Boolean', ], 'associatePublicIpAddress' => [ 'shape' => 'Boolean', ], 'copyTags' => [ 'shape' => 'Boolean', ], 'licensing' => [ 'shape' => 'Licensing', ], 'bootMode' => [ 'shape' => 'BootMode', ], 'smallVolumeMaxSize' => [ 'shape' => 'PositiveInteger', ], 'smallVolumeConf' => [ 'shape' => 'LaunchTemplateDiskConf', ], 'largeVolumeConf' => [ 'shape' => 'LaunchTemplateDiskConf', ], 'enableParametersEncryption' => [ 'shape' => 'Boolean', ], 'parametersEncryptionKey' => [ 'shape' => 'KmsKeyArn', ], ], ], 'CreateReplicationConfigurationTemplateRequest' => [ 'type' => 'structure', 'required' => [ 'stagingAreaSubnetId', 'associateDefaultSecurityGroup', 'replicationServersSecurityGroupsIDs', 'replicationServerInstanceType', 'useDedicatedReplicationServer', 'defaultLargeStagingDiskType', 'ebsEncryption', 'bandwidthThrottling', 'dataPlaneRouting', 'createPublicIP', 'stagingAreaTags', ], 'members' => [ 'stagingAreaSubnetId' => [ 'shape' => 'SubnetID', ], 'associateDefaultSecurityGroup' => [ 'shape' => 'Boolean', ], 'replicationServersSecurityGroupsIDs' => [ 'shape' => 'ReplicationServersSecurityGroupsIDs', ], 'replicationServerInstanceType' => [ 'shape' => 'EC2InstanceType', ], 'useDedicatedReplicationServer' => [ 'shape' => 'Boolean', ], 'defaultLargeStagingDiskType' => [ 'shape' => 'ReplicationConfigurationDefaultLargeStagingDiskType', ], 'ebsEncryption' => [ 'shape' => 'ReplicationConfigurationEbsEncryption', ], 'ebsEncryptionKeyArn' => [ 'shape' => 'ARN', ], 'bandwidthThrottling' => [ 'shape' => 'BandwidthThrottling', ], 'dataPlaneRouting' => [ 'shape' => 'ReplicationConfigurationDataPlaneRouting', ], 'createPublicIP' => [ 'shape' => 'Boolean', ], 'stagingAreaTags' => [ 'shape' => 'TagsMap', ], 'useFipsEndpoint' => [ 'shape' => 'Boolean', ], 'tags' => [ 'shape' => 'TagsMap', ], 'internetProtocol' => [ 'shape' => 'InternetProtocol', ], ], ], 'CreateWaveRequest' => [ 'type' => 'structure', 'required' => [ 'name', ], 'members' => [ 'name' => [ 'shape' => 'WaveName', ], 'description' => [ 'shape' => 'WaveDescription', ], 'tags' => [ 'shape' => 'TagsMap', ], 'accountID' => [ 'shape' => 'AccountID', ], ], ], 'DataReplicationError' => [ 'type' => 'structure', 'members' => [ 'error' => [ 'shape' => 'DataReplicationErrorString', ], 'rawError' => [ 'shape' => 'LargeBoundedString', ], ], ], 'DataReplicationErrorString' => [ 'type' => 'string', 'enum' => [ 'AGENT_NOT_SEEN', 'SNAPSHOTS_FAILURE', 'NOT_CONVERGING', 'UNSTABLE_NETWORK', 'FAILED_TO_CREATE_SECURITY_GROUP', 'FAILED_TO_LAUNCH_REPLICATION_SERVER', 'FAILED_TO_BOOT_REPLICATION_SERVER', 'FAILED_TO_AUTHENTICATE_WITH_SERVICE', 'FAILED_TO_DOWNLOAD_REPLICATION_SOFTWARE', 'FAILED_TO_CREATE_STAGING_DISKS', 'FAILED_TO_ATTACH_STAGING_DISKS', 'FAILED_TO_PAIR_REPLICATION_SERVER_WITH_AGENT', 'FAILED_TO_CONNECT_AGENT_TO_REPLICATION_SERVER', 'FAILED_TO_START_DATA_TRANSFER', 'UNSUPPORTED_VM_CONFIGURATION', 'LAST_SNAPSHOT_JOB_FAILED', ], ], 'DataReplicationInfo' => [ 'type' => 'structure', 'members' => [ 'lagDuration' => [ 'shape' => 'ISO8601DurationString', ], 'etaDateTime' => [ 'shape' => 'ISO8601DatetimeString', ], 'replicatedDisks' => [ 'shape' => 'DataReplicationInfoReplicatedDisks', ], 'dataReplicationState' => [ 'shape' => 'DataReplicationState', ], 'dataReplicationInitiation' => [ 'shape' => 'DataReplicationInitiation', ], 'dataReplicationError' => [ 'shape' => 'DataReplicationError', ], 'lastSnapshotDateTime' => [ 'shape' => 'ISO8601DatetimeString', ], 'replicatorId' => [ 'shape' => 'ReplicatorID', ], ], ], 'DataReplicationInfoReplicatedDisk' => [ 'type' => 'structure', 'members' => [ 'deviceName' => [ 'shape' => 'BoundedString', ], 'totalStorageBytes' => [ 'shape' => 'PositiveInteger', ], 'replicatedStorageBytes' => [ 'shape' => 'PositiveInteger', ], 'rescannedStorageBytes' => [ 'shape' => 'PositiveInteger', ], 'backloggedStorageBytes' => [ 'shape' => 'PositiveInteger', ], ], ], 'DataReplicationInfoReplicatedDisks' => [ 'type' => 'list', 'member' => [ 'shape' => 'DataReplicationInfoReplicatedDisk', ], 'max' => 60, 'min' => 0, ], 'DataReplicationInitiation' => [ 'type' => 'structure', 'members' => [ 'startDateTime' => [ 'shape' => 'ISO8601DatetimeString', ], 'nextAttemptDateTime' => [ 'shape' => 'ISO8601DatetimeString', ], 'steps' => [ 'shape' => 'DataReplicationInitiationSteps', ], ], ], 'DataReplicationInitiationStep' => [ 'type' => 'structure', 'members' => [ 'name' => [ 'shape' => 'DataReplicationInitiationStepName', ], 'status' => [ 'shape' => 'DataReplicationInitiationStepStatus', ], ], ], 'DataReplicationInitiationStepName' => [ 'type' => 'string', 'enum' => [ 'WAIT', 'CREATE_SECURITY_GROUP', 'LAUNCH_REPLICATION_SERVER', 'BOOT_REPLICATION_SERVER', 'AUTHENTICATE_WITH_SERVICE', 'DOWNLOAD_REPLICATION_SOFTWARE', 'CREATE_STAGING_DISKS', 'ATTACH_STAGING_DISKS', 'PAIR_REPLICATION_SERVER_WITH_AGENT', 'CONNECT_AGENT_TO_REPLICATION_SERVER', 'START_DATA_TRANSFER', ], ], 'DataReplicationInitiationStepStatus' => [ 'type' => 'string', 'enum' => [ 'NOT_STARTED', 'IN_PROGRESS', 'SUCCEEDED', 'FAILED', 'SKIPPED', ], ], 'DataReplicationInitiationSteps' => [ 'type' => 'list', 'member' => [ 'shape' => 'DataReplicationInitiationStep', ], ], 'DataReplicationState' => [ 'type' => 'string', 'enum' => [ 'STOPPED', 'INITIATING', 'INITIAL_SYNC', 'BACKLOG', 'CREATING_SNAPSHOT', 'CONTINUOUS', 'PAUSED', 'RESCAN', 'STALLED', 'DISCONNECTED', 'PENDING_SNAPSHOT_SHIPPING', 'SHIPPING_SNAPSHOT', ], ], 'DeleteApplicationRequest' => [ 'type' => 'structure', 'required' => [ 'applicationID', ], 'members' => [ 'applicationID' => [ 'shape' => 'ApplicationID', ], 'accountID' => [ 'shape' => 'AccountID', ], ], ], 'DeleteApplicationResponse' => [ 'type' => 'structure', 'members' => [], ], 'DeleteConnectorRequest' => [ 'type' => 'structure', 'required' => [ 'connectorID', ], 'members' => [ 'connectorID' => [ 'shape' => 'ConnectorID', ], ], ], 'DeleteJobRequest' => [ 'type' => 'structure', 'required' => [ 'jobID', ], 'members' => [ 'jobID' => [ 'shape' => 'JobID', ], 'accountID' => [ 'shape' => 'AccountID', ], ], ], 'DeleteJobResponse' => [ 'type' => 'structure', 'members' => [], ], 'DeleteLaunchConfigurationTemplateRequest' => [ 'type' => 'structure', 'required' => [ 'launchConfigurationTemplateID', ], 'members' => [ 'launchConfigurationTemplateID' => [ 'shape' => 'LaunchConfigurationTemplateID', ], ], ], 'DeleteLaunchConfigurationTemplateResponse' => [ 'type' => 'structure', 'members' => [], ], 'DeleteReplicationConfigurationTemplateRequest' => [ 'type' => 'structure', 'required' => [ 'replicationConfigurationTemplateID', ], 'members' => [ 'replicationConfigurationTemplateID' => [ 'shape' => 'ReplicationConfigurationTemplateID', ], ], ], 'DeleteReplicationConfigurationTemplateResponse' => [ 'type' => 'structure', 'members' => [], ], 'DeleteSourceServerRequest' => [ 'type' => 'structure', 'required' => [ 'sourceServerID', ], 'members' => [ 'sourceServerID' => [ 'shape' => 'SourceServerID', ], 'accountID' => [ 'shape' => 'AccountID', ], ], ], 'DeleteSourceServerResponse' => [ 'type' => 'structure', 'members' => [], ], 'DeleteVcenterClientRequest' => [ 'type' => 'structure', 'required' => [ 'vcenterClientID', ], 'members' => [ 'vcenterClientID' => [ 'shape' => 'VcenterClientID', ], ], ], 'DeleteWaveRequest' => [ 'type' => 'structure', 'required' => [ 'waveID', ], 'members' => [ 'waveID' => [ 'shape' => 'WaveID', ], 'accountID' => [ 'shape' => 'AccountID', ], ], ], 'DeleteWaveResponse' => [ 'type' => 'structure', 'members' => [], ], 'DescribeJobLogItemsRequest' => [ 'type' => 'structure', 'required' => [ 'jobID', ], 'members' => [ 'jobID' => [ 'shape' => 'JobID', ], 'maxResults' => [ 'shape' => 'MaxResultsType', ], 'nextToken' => [ 'shape' => 'PaginationToken', ], 'accountID' => [ 'shape' => 'AccountID', ], ], ], 'DescribeJobLogItemsResponse' => [ 'type' => 'structure', 'members' => [ 'items' => [ 'shape' => 'JobLogs', ], 'nextToken' => [ 'shape' => 'PaginationToken', ], ], ], 'DescribeJobsRequest' => [ 'type' => 'structure', 'members' => [ 'filters' => [ 'shape' => 'DescribeJobsRequestFilters', ], 'maxResults' => [ 'shape' => 'MaxResultsType', ], 'nextToken' => [ 'shape' => 'PaginationToken', ], 'accountID' => [ 'shape' => 'AccountID', ], ], ], 'DescribeJobsRequestFilters' => [ 'type' => 'structure', 'members' => [ 'jobIDs' => [ 'shape' => 'DescribeJobsRequestFiltersJobIDs', ], 'fromDate' => [ 'shape' => 'ISO8601DatetimeString', ], 'toDate' => [ 'shape' => 'ISO8601DatetimeString', ], ], ], 'DescribeJobsRequestFiltersJobIDs' => [ 'type' => 'list', 'member' => [ 'shape' => 'JobID', ], 'max' => 1000, 'min' => 0, ], 'DescribeJobsResponse' => [ 'type' => 'structure', 'members' => [ 'items' => [ 'shape' => 'JobsList', ], 'nextToken' => [ 'shape' => 'PaginationToken', ], ], ], 'DescribeLaunchConfigurationTemplatesRequest' => [ 'type' => 'structure', 'members' => [ 'launchConfigurationTemplateIDs' => [ 'shape' => 'LaunchConfigurationTemplateIDs', ], 'maxResults' => [ 'shape' => 'MaxResultsType', ], 'nextToken' => [ 'shape' => 'PaginationToken', ], ], ], 'DescribeLaunchConfigurationTemplatesResponse' => [ 'type' => 'structure', 'members' => [ 'items' => [ 'shape' => 'LaunchConfigurationTemplates', ], 'nextToken' => [ 'shape' => 'PaginationToken', ], ], ], 'DescribeReplicationConfigurationTemplatesRequest' => [ 'type' => 'structure', 'members' => [ 'replicationConfigurationTemplateIDs' => [ 'shape' => 'ReplicationConfigurationTemplateIDs', ], 'maxResults' => [ 'shape' => 'MaxResultsType', ], 'nextToken' => [ 'shape' => 'PaginationToken', ], ], ], 'DescribeReplicationConfigurationTemplatesResponse' => [ 'type' => 'structure', 'members' => [ 'items' => [ 'shape' => 'ReplicationConfigurationTemplates', ], 'nextToken' => [ 'shape' => 'PaginationToken', ], ], ], 'DescribeSourceServersRequest' => [ 'type' => 'structure', 'members' => [ 'filters' => [ 'shape' => 'DescribeSourceServersRequestFilters', ], 'maxResults' => [ 'shape' => 'MaxResultsType', ], 'nextToken' => [ 'shape' => 'PaginationToken', ], 'accountID' => [ 'shape' => 'AccountID', ], ], ], 'DescribeSourceServersRequestApplicationIDs' => [ 'type' => 'list', 'member' => [ 'shape' => 'ApplicationID', ], 'max' => 200, 'min' => 0, ], 'DescribeSourceServersRequestFilters' => [ 'type' => 'structure', 'members' => [ 'sourceServerIDs' => [ 'shape' => 'DescribeSourceServersRequestFiltersIDs', ], 'isArchived' => [ 'shape' => 'Boolean', ], 'replicationTypes' => [ 'shape' => 'ReplicationTypes', ], 'lifeCycleStates' => [ 'shape' => 'LifeCycleStates', ], 'applicationIDs' => [ 'shape' => 'DescribeSourceServersRequestApplicationIDs', ], ], ], 'DescribeSourceServersRequestFiltersIDs' => [ 'type' => 'list', 'member' => [ 'shape' => 'SourceServerID', ], 'max' => 200, 'min' => 0, ], 'DescribeSourceServersResponse' => [ 'type' => 'structure', 'members' => [ 'items' => [ 'shape' => 'SourceServersList', ], 'nextToken' => [ 'shape' => 'PaginationToken', ], ], ], 'DescribeVcenterClientsRequest' => [ 'type' => 'structure', 'members' => [ 'maxResults' => [ 'shape' => 'MaxResultsType', 'location' => 'querystring', 'locationName' => 'maxResults', ], 'nextToken' => [ 'shape' => 'PaginationToken', 'location' => 'querystring', 'locationName' => 'nextToken', ], ], ], 'DescribeVcenterClientsResponse' => [ 'type' => 'structure', 'members' => [ 'items' => [ 'shape' => 'VcenterClientList', ], 'nextToken' => [ 'shape' => 'PaginationToken', ], ], ], 'DisassociateApplicationsRequest' => [ 'type' => 'structure', 'required' => [ 'waveID', 'applicationIDs', ], 'members' => [ 'waveID' => [ 'shape' => 'WaveID', ], 'applicationIDs' => [ 'shape' => 'ApplicationIDs', ], 'accountID' => [ 'shape' => 'AccountID', ], ], ], 'DisassociateApplicationsResponse' => [ 'type' => 'structure', 'members' => [], ], 'DisassociateSourceServersRequest' => [ 'type' => 'structure', 'required' => [ 'applicationID', 'sourceServerIDs', ], 'members' => [ 'applicationID' => [ 'shape' => 'ApplicationID', ], 'sourceServerIDs' => [ 'shape' => 'DisassociateSourceServersRequestSourceServerIDs', ], 'accountID' => [ 'shape' => 'AccountID', ], ], ], 'DisassociateSourceServersRequestSourceServerIDs' => [ 'type' => 'list', 'member' => [ 'shape' => 'SourceServerID', ], 'max' => 50, 'min' => 1, ], 'DisassociateSourceServersResponse' => [ 'type' => 'structure', 'members' => [], ], 'DisconnectFromServiceRequest' => [ 'type' => 'structure', 'required' => [ 'sourceServerID', ], 'members' => [ 'sourceServerID' => [ 'shape' => 'SourceServerID', ], 'accountID' => [ 'shape' => 'AccountID', ], ], ], 'Disk' => [ 'type' => 'structure', 'members' => [ 'deviceName' => [ 'shape' => 'BoundedString', ], 'bytes' => [ 'shape' => 'PositiveInteger', ], ], ], 'Disks' => [ 'type' => 'list', 'member' => [ 'shape' => 'Disk', ], 'max' => 1000, 'min' => 0, ], 'DocumentVersion' => [ 'type' => 'string', 'pattern' => '(\\$DEFAULT|\\$LATEST|[0-9]+)', ], 'EC2InstanceID' => [ 'type' => 'string', 'max' => 255, 'min' => 0, 'pattern' => 'i-[0-9a-fA-F]{8,}', ], 'EC2InstanceType' => [ 'type' => 'string', 'max' => 255, 'min' => 0, ], 'EC2LaunchConfigurationTemplateID' => [ 'type' => 'string', 'max' => 20, 'min' => 20, 'pattern' => 'lt-[0-9a-z]{17}', ], 'ErrorDetails' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'LargeBoundedString', ], 'code' => [ 'shape' => 'BoundedString', ], 'resourceId' => [ 'shape' => 'LargeBoundedString', ], 'resourceType' => [ 'shape' => 'LargeBoundedString', ], ], ], 'ExportErrorData' => [ 'type' => 'structure', 'members' => [ 'rawError' => [ 'shape' => 'LargeBoundedString', ], ], ], 'ExportErrors' => [ 'type' => 'list', 'member' => [ 'shape' => 'ExportTaskError', ], ], 'ExportID' => [ 'type' => 'string', 'max' => 24, 'min' => 24, 'pattern' => 'export-[0-9a-zA-Z]{17}', ], 'ExportStatus' => [ 'type' => 'string', 'enum' => [ 'PENDING', 'STARTED', 'FAILED', 'SUCCEEDED', ], ], 'ExportTask' => [ 'type' => 'structure', 'members' => [ 'exportID' => [ 'shape' => 'ExportID', ], 'arn' => [ 'shape' => 'ARN', ], 's3Bucket' => [ 'shape' => 'S3BucketName', ], 's3Key' => [ 'shape' => 'S3Key', ], 's3BucketOwner' => [ 'shape' => 'AccountID', ], 'creationDateTime' => [ 'shape' => 'ISO8601DatetimeString', ], 'endDateTime' => [ 'shape' => 'ISO8601DatetimeString', ], 'status' => [ 'shape' => 'ExportStatus', ], 'progressPercentage' => [ 'shape' => 'Float', ], 'summary' => [ 'shape' => 'ExportTaskSummary', ], 'tags' => [ 'shape' => 'TagsMap', ], ], ], 'ExportTaskError' => [ 'type' => 'structure', 'members' => [ 'errorDateTime' => [ 'shape' => 'ISO8601DatetimeString', ], 'errorData' => [ 'shape' => 'ExportErrorData', ], ], ], 'ExportTaskSummary' => [ 'type' => 'structure', 'members' => [ 'serversCount' => [ 'shape' => 'PositiveInteger', ], 'applicationsCount' => [ 'shape' => 'PositiveInteger', ], 'wavesCount' => [ 'shape' => 'PositiveInteger', ], ], ], 'ExportsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'ExportTask', ], ], 'FinalizeCutoverRequest' => [ 'type' => 'structure', 'required' => [ 'sourceServerID', ], 'members' => [ 'sourceServerID' => [ 'shape' => 'SourceServerID', ], 'accountID' => [ 'shape' => 'AccountID', ], ], ], 'FirstBoot' => [ 'type' => 'string', 'enum' => [ 'WAITING', 'SUCCEEDED', 'UNKNOWN', 'STOPPED', ], ], 'Float' => [ 'type' => 'float', 'box' => true, ], 'GetLaunchConfigurationRequest' => [ 'type' => 'structure', 'required' => [ 'sourceServerID', ], 'members' => [ 'sourceServerID' => [ 'shape' => 'SourceServerID', ], 'accountID' => [ 'shape' => 'AccountID', ], ], ], 'GetReplicationConfigurationRequest' => [ 'type' => 'structure', 'required' => [ 'sourceServerID', ], 'members' => [ 'sourceServerID' => [ 'shape' => 'SourceServerID', ], 'accountID' => [ 'shape' => 'AccountID', ], ], ], 'IPsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'BoundedString', ], ], 'ISO8601DatetimeString' => [ 'type' => 'string', 'max' => 32, 'min' => 19, 'pattern' => '[1-9][0-9]*-(0[1-9]|1[0-2])-(0[1-9]|[12][0-9]|3[01])T([0-1][0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9](\\.[0-9]+)?Z', ], 'ISO8601DurationString' => [ 'type' => 'string', 'max' => 64, 'min' => 1, ], 'IdentificationHints' => [ 'type' => 'structure', 'members' => [ 'fqdn' => [ 'shape' => 'BoundedString', ], 'hostname' => [ 'shape' => 'BoundedString', ], 'vmWareUuid' => [ 'shape' => 'BoundedString', ], 'awsInstanceID' => [ 'shape' => 'EC2InstanceID', ], 'vmPath' => [ 'shape' => 'BoundedString', ], ], ], 'ImportErrorData' => [ 'type' => 'structure', 'members' => [ 'sourceServerID' => [ 'shape' => 'SourceServerID', ], 'applicationID' => [ 'shape' => 'ApplicationID', ], 'waveID' => [ 'shape' => 'WaveID', ], 'ec2LaunchTemplateID' => [ 'shape' => 'BoundedString', ], 'rowNumber' => [ 'shape' => 'PositiveInteger', ], 'rawError' => [ 'shape' => 'LargeBoundedString', ], 'accountID' => [ 'shape' => 'AccountID', ], ], ], 'ImportErrorType' => [ 'type' => 'string', 'enum' => [ 'VALIDATION_ERROR', 'PROCESSING_ERROR', ], ], 'ImportErrors' => [ 'type' => 'list', 'member' => [ 'shape' => 'ImportTaskError', ], ], 'ImportID' => [ 'type' => 'string', 'max' => 24, 'min' => 24, 'pattern' => 'import-[0-9a-zA-Z]{17}', ], 'ImportIDsFilter' => [ 'type' => 'list', 'member' => [ 'shape' => 'ImportID', ], 'max' => 10, 'min' => 0, ], 'ImportList' => [ 'type' => 'list', 'member' => [ 'shape' => 'ImportTask', ], ], 'ImportStatus' => [ 'type' => 'string', 'enum' => [ 'PENDING', 'STARTED', 'FAILED', 'SUCCEEDED', ], ], 'ImportTask' => [ 'type' => 'structure', 'members' => [ 'importID' => [ 'shape' => 'ImportID', ], 'arn' => [ 'shape' => 'ARN', ], 's3BucketSource' => [ 'shape' => 'S3BucketSource', ], 'creationDateTime' => [ 'shape' => 'ISO8601DatetimeString', ], 'endDateTime' => [ 'shape' => 'ISO8601DatetimeString', ], 'status' => [ 'shape' => 'ImportStatus', ], 'progressPercentage' => [ 'shape' => 'Float', ], 'summary' => [ 'shape' => 'ImportTaskSummary', ], 'tags' => [ 'shape' => 'TagsMap', ], ], ], 'ImportTaskError' => [ 'type' => 'structure', 'members' => [ 'errorDateTime' => [ 'shape' => 'ISO8601DatetimeString', ], 'errorType' => [ 'shape' => 'ImportErrorType', ], 'errorData' => [ 'shape' => 'ImportErrorData', ], ], ], 'ImportTaskSummary' => [ 'type' => 'structure', 'members' => [ 'waves' => [ 'shape' => 'ImportTaskSummaryWaves', ], 'applications' => [ 'shape' => 'ImportTaskSummaryApplications', ], 'servers' => [ 'shape' => 'ImportTaskSummaryServers', ], ], ], 'ImportTaskSummaryApplications' => [ 'type' => 'structure', 'members' => [ 'createdCount' => [ 'shape' => 'PositiveInteger', ], 'modifiedCount' => [ 'shape' => 'PositiveInteger', ], ], ], 'ImportTaskSummaryServers' => [ 'type' => 'structure', 'members' => [ 'createdCount' => [ 'shape' => 'PositiveInteger', ], 'modifiedCount' => [ 'shape' => 'PositiveInteger', ], ], ], 'ImportTaskSummaryWaves' => [ 'type' => 'structure', 'members' => [ 'createdCount' => [ 'shape' => 'PositiveInteger', ], 'modifiedCount' => [ 'shape' => 'PositiveInteger', ], ], ], 'InitializeServiceRequest' => [ 'type' => 'structure', 'members' => [], ], 'InitializeServiceResponse' => [ 'type' => 'structure', 'members' => [], ], 'InitiatedBy' => [ 'type' => 'string', 'enum' => [ 'START_TEST', 'START_CUTOVER', 'DIAGNOSTIC', 'TERMINATE', ], ], 'InternalServerException' => [ 'type' => 'structure', 'required' => [ 'message', ], 'members' => [ 'message' => [ 'shape' => 'LargeBoundedString', ], 'retryAfterSeconds' => [ 'shape' => 'PositiveInteger', 'location' => 'header', 'locationName' => 'Retry-After', ], ], 'error' => [ 'httpStatusCode' => 500, ], 'exception' => true, 'fault' => true, ], 'InternetProtocol' => [ 'type' => 'string', 'enum' => [ 'IPV4', 'IPV6', ], ], 'Iops' => [ 'type' => 'long', 'box' => true, 'max' => 64000, 'min' => 100, ], 'JmesPathString' => [ 'type' => 'string', 'max' => 1011, 'min' => 1, 'pattern' => '[a-zA-Z0-9_]+(\\.[a-zA-Z0-9_\\[\\]]+)*', ], 'Job' => [ 'type' => 'structure', 'required' => [ 'jobID', ], 'members' => [ 'jobID' => [ 'shape' => 'JobID', ], 'arn' => [ 'shape' => 'ARN', ], 'type' => [ 'shape' => 'JobType', ], 'initiatedBy' => [ 'shape' => 'InitiatedBy', ], 'creationDateTime' => [ 'shape' => 'ISO8601DatetimeString', ], 'endDateTime' => [ 'shape' => 'ISO8601DatetimeString', ], 'status' => [ 'shape' => 'JobStatus', ], 'participatingServers' => [ 'shape' => 'ParticipatingServers', ], 'tags' => [ 'shape' => 'TagsMap', ], ], ], 'JobID' => [ 'type' => 'string', 'max' => 24, 'min' => 24, 'pattern' => 'mgnjob-[0-9a-zA-Z]{17}', ], 'JobLog' => [ 'type' => 'structure', 'members' => [ 'logDateTime' => [ 'shape' => 'ISO8601DatetimeString', ], 'event' => [ 'shape' => 'JobLogEvent', ], 'eventData' => [ 'shape' => 'JobLogEventData', ], ], ], 'JobLogEvent' => [ 'type' => 'string', 'enum' => [ 'JOB_START', 'SERVER_SKIPPED', 'CLEANUP_START', 'CLEANUP_END', 'CLEANUP_FAIL', 'SNAPSHOT_START', 'SNAPSHOT_END', 'SNAPSHOT_FAIL', 'USING_PREVIOUS_SNAPSHOT', 'CONVERSION_START', 'CONVERSION_END', 'CONVERSION_FAIL', 'LAUNCH_START', 'LAUNCH_FAILED', 'JOB_CANCEL', 'JOB_END', ], ], 'JobLogEventData' => [ 'type' => 'structure', 'members' => [ 'sourceServerID' => [ 'shape' => 'SourceServerID', ], 'conversionServerID' => [ 'shape' => 'EC2InstanceID', ], 'targetInstanceID' => [ 'shape' => 'EC2InstanceID', ], 'rawError' => [ 'shape' => 'LargeBoundedString', ], 'attemptCount' => [ 'shape' => 'StrictlyPositiveInteger', ], 'maxAttemptsCount' => [ 'shape' => 'StrictlyPositiveInteger', ], ], ], 'JobLogs' => [ 'type' => 'list', 'member' => [ 'shape' => 'JobLog', ], ], 'JobPostLaunchActionsLaunchStatus' => [ 'type' => 'structure', 'members' => [ 'ssmDocument' => [ 'shape' => 'SsmDocument', ], 'ssmDocumentType' => [ 'shape' => 'SsmDocumentType', ], 'executionID' => [ 'shape' => 'BoundedString', ], 'executionStatus' => [ 'shape' => 'PostLaunchActionExecutionStatus', ], 'failureReason' => [ 'shape' => 'BoundedString', ], ], ], 'JobStatus' => [ 'type' => 'string', 'enum' => [ 'PENDING', 'STARTED', 'COMPLETED', ], ], 'JobType' => [ 'type' => 'string', 'enum' => [ 'LAUNCH', 'TERMINATE', ], ], 'JobsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'Job', ], ], 'KmsKeyArn' => [ 'type' => 'string', 'max' => 276, 'min' => 0, 'pattern' => '((arn:[\\w-]+:kms:([a-z]{2}-(gov-)?[a-z]+-\\d{1})?:(\\d{12})?:((alias|key)/[a-zA-Z0-9:/_-]{1,256}))|())', ], 'LargeBoundedString' => [ 'type' => 'string', 'max' => 65536, 'min' => 0, ], 'LaunchConfiguration' => [ 'type' => 'structure', 'members' => [ 'sourceServerID' => [ 'shape' => 'SourceServerID', ], 'name' => [ 'shape' => 'SmallBoundedString', ], 'ec2LaunchTemplateID' => [ 'shape' => 'BoundedString', ], 'launchDisposition' => [ 'shape' => 'LaunchDisposition', ], 'targetInstanceTypeRightSizingMethod' => [ 'shape' => 'TargetInstanceTypeRightSizingMethod', ], 'copyPrivateIp' => [ 'shape' => 'Boolean', ], 'copyTags' => [ 'shape' => 'Boolean', ], 'licensing' => [ 'shape' => 'Licensing', ], 'bootMode' => [ 'shape' => 'BootMode', ], 'postLaunchActions' => [ 'shape' => 'PostLaunchActions', ], 'enableMapAutoTagging' => [ 'shape' => 'Boolean', ], 'mapAutoTaggingMpeID' => [ 'shape' => 'TagValue', ], ], ], 'LaunchConfigurationTemplate' => [ 'type' => 'structure', 'required' => [ 'launchConfigurationTemplateID', ], 'members' => [ 'launchConfigurationTemplateID' => [ 'shape' => 'LaunchConfigurationTemplateID', ], 'arn' => [ 'shape' => 'ARN', ], 'postLaunchActions' => [ 'shape' => 'PostLaunchActions', ], 'enableMapAutoTagging' => [ 'shape' => 'Boolean', ], 'mapAutoTaggingMpeID' => [ 'shape' => 'TagValue', ], 'tags' => [ 'shape' => 'TagsMap', ], 'ec2LaunchTemplateID' => [ 'shape' => 'EC2LaunchConfigurationTemplateID', ], 'launchDisposition' => [ 'shape' => 'LaunchDisposition', ], 'targetInstanceTypeRightSizingMethod' => [ 'shape' => 'TargetInstanceTypeRightSizingMethod', ], 'copyPrivateIp' => [ 'shape' => 'Boolean', ], 'associatePublicIpAddress' => [ 'shape' => 'Boolean', ], 'copyTags' => [ 'shape' => 'Boolean', ], 'licensing' => [ 'shape' => 'Licensing', ], 'bootMode' => [ 'shape' => 'BootMode', ], 'smallVolumeMaxSize' => [ 'shape' => 'PositiveInteger', ], 'smallVolumeConf' => [ 'shape' => 'LaunchTemplateDiskConf', ], 'largeVolumeConf' => [ 'shape' => 'LaunchTemplateDiskConf', ], 'enableParametersEncryption' => [ 'shape' => 'Boolean', ], 'parametersEncryptionKey' => [ 'shape' => 'ARN', ], ], ], 'LaunchConfigurationTemplateID' => [ 'type' => 'string', 'max' => 21, 'min' => 21, 'pattern' => 'lct-[0-9a-zA-Z]{17}', ], 'LaunchConfigurationTemplateIDs' => [ 'type' => 'list', 'member' => [ 'shape' => 'LaunchConfigurationTemplateID', ], 'max' => 200, 'min' => 0, ], 'LaunchConfigurationTemplates' => [ 'type' => 'list', 'member' => [ 'shape' => 'LaunchConfigurationTemplate', ], 'max' => 200, 'min' => 0, ], 'LaunchDisposition' => [ 'type' => 'string', 'enum' => [ 'STOPPED', 'STARTED', ], ], 'LaunchStatus' => [ 'type' => 'string', 'enum' => [ 'PENDING', 'IN_PROGRESS', 'LAUNCHED', 'FAILED', 'TERMINATED', ], ], 'LaunchTemplateDiskConf' => [ 'type' => 'structure', 'members' => [ 'volumeType' => [ 'shape' => 'VolumeType', ], 'iops' => [ 'shape' => 'Iops', ], 'throughput' => [ 'shape' => 'Throughput', ], ], ], 'LaunchedInstance' => [ 'type' => 'structure', 'members' => [ 'ec2InstanceID' => [ 'shape' => 'EC2InstanceID', ], 'jobID' => [ 'shape' => 'JobID', ], 'firstBoot' => [ 'shape' => 'FirstBoot', ], ], ], 'Licensing' => [ 'type' => 'structure', 'members' => [ 'osByol' => [ 'shape' => 'Boolean', ], ], ], 'LifeCycle' => [ 'type' => 'structure', 'members' => [ 'addedToServiceDateTime' => [ 'shape' => 'ISO8601DatetimeString', ], 'firstByteDateTime' => [ 'shape' => 'ISO8601DatetimeString', ], 'elapsedReplicationDuration' => [ 'shape' => 'ISO8601DurationString', ], 'lastSeenByServiceDateTime' => [ 'shape' => 'ISO8601DatetimeString', ], 'lastTest' => [ 'shape' => 'LifeCycleLastTest', ], 'lastCutover' => [ 'shape' => 'LifeCycleLastCutover', ], 'state' => [ 'shape' => 'LifeCycleState', ], ], ], 'LifeCycleLastCutover' => [ 'type' => 'structure', 'members' => [ 'initiated' => [ 'shape' => 'LifeCycleLastCutoverInitiated', ], 'reverted' => [ 'shape' => 'LifeCycleLastCutoverReverted', ], 'finalized' => [ 'shape' => 'LifeCycleLastCutoverFinalized', ], ], ], 'LifeCycleLastCutoverFinalized' => [ 'type' => 'structure', 'members' => [ 'apiCallDateTime' => [ 'shape' => 'ISO8601DatetimeString', ], ], ], 'LifeCycleLastCutoverInitiated' => [ 'type' => 'structure', 'members' => [ 'apiCallDateTime' => [ 'shape' => 'ISO8601DatetimeString', ], 'jobID' => [ 'shape' => 'JobID', ], ], ], 'LifeCycleLastCutoverReverted' => [ 'type' => 'structure', 'members' => [ 'apiCallDateTime' => [ 'shape' => 'ISO8601DatetimeString', ], ], ], 'LifeCycleLastTest' => [ 'type' => 'structure', 'members' => [ 'initiated' => [ 'shape' => 'LifeCycleLastTestInitiated', ], 'reverted' => [ 'shape' => 'LifeCycleLastTestReverted', ], 'finalized' => [ 'shape' => 'LifeCycleLastTestFinalized', ], ], ], 'LifeCycleLastTestFinalized' => [ 'type' => 'structure', 'members' => [ 'apiCallDateTime' => [ 'shape' => 'ISO8601DatetimeString', ], ], ], 'LifeCycleLastTestInitiated' => [ 'type' => 'structure', 'members' => [ 'apiCallDateTime' => [ 'shape' => 'ISO8601DatetimeString', ], 'jobID' => [ 'shape' => 'JobID', ], ], ], 'LifeCycleLastTestReverted' => [ 'type' => 'structure', 'members' => [ 'apiCallDateTime' => [ 'shape' => 'ISO8601DatetimeString', ], ], ], 'LifeCycleState' => [ 'type' => 'string', 'enum' => [ 'STOPPED', 'NOT_READY', 'READY_FOR_TEST', 'TESTING', 'READY_FOR_CUTOVER', 'CUTTING_OVER', 'CUTOVER', 'DISCONNECTED', 'DISCOVERED', 'PENDING_INSTALLATION', ], ], 'LifeCycleStates' => [ 'type' => 'list', 'member' => [ 'shape' => 'LifeCycleState', ], 'max' => 10, 'min' => 0, ], 'ListApplicationsRequest' => [ 'type' => 'structure', 'members' => [ 'filters' => [ 'shape' => 'ListApplicationsRequestFilters', ], 'maxResults' => [ 'shape' => 'MaxResultsType', ], 'nextToken' => [ 'shape' => 'PaginationToken', ], 'accountID' => [ 'shape' => 'AccountID', ], ], ], 'ListApplicationsRequestFilters' => [ 'type' => 'structure', 'members' => [ 'applicationIDs' => [ 'shape' => 'ApplicationIDsFilter', ], 'isArchived' => [ 'shape' => 'Boolean', ], 'waveIDs' => [ 'shape' => 'WaveIDsFilter', ], ], ], 'ListApplicationsResponse' => [ 'type' => 'structure', 'members' => [ 'items' => [ 'shape' => 'ApplicationsList', ], 'nextToken' => [ 'shape' => 'PaginationToken', ], ], ], 'ListConnectorsRequest' => [ 'type' => 'structure', 'members' => [ 'filters' => [ 'shape' => 'ListConnectorsRequestFilters', ], 'maxResults' => [ 'shape' => 'MaxResultsType', ], 'nextToken' => [ 'shape' => 'PaginationToken', ], ], ], 'ListConnectorsRequestFilters' => [ 'type' => 'structure', 'members' => [ 'connectorIDs' => [ 'shape' => 'ConnectorIDsFilter', ], ], ], 'ListConnectorsResponse' => [ 'type' => 'structure', 'members' => [ 'items' => [ 'shape' => 'ConnectorsList', ], 'nextToken' => [ 'shape' => 'PaginationToken', ], ], ], 'ListExportErrorsRequest' => [ 'type' => 'structure', 'required' => [ 'exportID', ], 'members' => [ 'exportID' => [ 'shape' => 'ExportID', ], 'maxResults' => [ 'shape' => 'MaxResultsType', ], 'nextToken' => [ 'shape' => 'PaginationToken', ], ], ], 'ListExportErrorsResponse' => [ 'type' => 'structure', 'members' => [ 'items' => [ 'shape' => 'ExportErrors', ], 'nextToken' => [ 'shape' => 'PaginationToken', ], ], ], 'ListExportsRequest' => [ 'type' => 'structure', 'members' => [ 'filters' => [ 'shape' => 'ListExportsRequestFilters', ], 'maxResults' => [ 'shape' => 'MaxResultsType', ], 'nextToken' => [ 'shape' => 'PaginationToken', ], ], ], 'ListExportsRequestFilters' => [ 'type' => 'structure', 'members' => [ 'exportIDs' => [ 'shape' => 'ListExportsRequestFiltersExportIDs', ], ], ], 'ListExportsRequestFiltersExportIDs' => [ 'type' => 'list', 'member' => [ 'shape' => 'ExportID', ], 'max' => 10, 'min' => 0, ], 'ListExportsResponse' => [ 'type' => 'structure', 'members' => [ 'items' => [ 'shape' => 'ExportsList', ], 'nextToken' => [ 'shape' => 'PaginationToken', ], ], ], 'ListImportErrorsRequest' => [ 'type' => 'structure', 'required' => [ 'importID', ], 'members' => [ 'importID' => [ 'shape' => 'ImportID', ], 'maxResults' => [ 'shape' => 'MaxResultsType', ], 'nextToken' => [ 'shape' => 'PaginationToken', ], ], ], 'ListImportErrorsResponse' => [ 'type' => 'structure', 'members' => [ 'items' => [ 'shape' => 'ImportErrors', ], 'nextToken' => [ 'shape' => 'PaginationToken', ], ], ], 'ListImportsRequest' => [ 'type' => 'structure', 'members' => [ 'filters' => [ 'shape' => 'ListImportsRequestFilters', ], 'maxResults' => [ 'shape' => 'MaxResultsType', ], 'nextToken' => [ 'shape' => 'PaginationToken', ], ], ], 'ListImportsRequestFilters' => [ 'type' => 'structure', 'members' => [ 'importIDs' => [ 'shape' => 'ImportIDsFilter', ], ], ], 'ListImportsResponse' => [ 'type' => 'structure', 'members' => [ 'items' => [ 'shape' => 'ImportList', ], 'nextToken' => [ 'shape' => 'PaginationToken', ], ], ], 'ListManagedAccountsRequest' => [ 'type' => 'structure', 'members' => [ 'maxResults' => [ 'shape' => 'MaxResultsType', ], 'nextToken' => [ 'shape' => 'PaginationToken', ], ], ], 'ListManagedAccountsResponse' => [ 'type' => 'structure', 'required' => [ 'items', ], 'members' => [ 'items' => [ 'shape' => 'ManagedAccounts', ], 'nextToken' => [ 'shape' => 'PaginationToken', ], ], ], 'ListSourceServerActionsRequest' => [ 'type' => 'structure', 'required' => [ 'sourceServerID', ], 'members' => [ 'sourceServerID' => [ 'shape' => 'SourceServerID', ], 'filters' => [ 'shape' => 'SourceServerActionsRequestFilters', ], 'maxResults' => [ 'shape' => 'MaxResultsType', ], 'nextToken' => [ 'shape' => 'PaginationToken', ], 'accountID' => [ 'shape' => 'AccountID', ], ], ], 'ListSourceServerActionsResponse' => [ 'type' => 'structure', 'members' => [ 'items' => [ 'shape' => 'SourceServerActionDocuments', ], 'nextToken' => [ 'shape' => 'PaginationToken', ], ], ], 'ListTagsForResourceRequest' => [ 'type' => 'structure', 'required' => [ 'resourceArn', ], 'members' => [ 'resourceArn' => [ 'shape' => 'ARN', 'location' => 'uri', 'locationName' => 'resourceArn', ], ], ], 'ListTagsForResourceResponse' => [ 'type' => 'structure', 'members' => [ 'tags' => [ 'shape' => 'TagsMap', ], ], ], 'ListTemplateActionsRequest' => [ 'type' => 'structure', 'required' => [ 'launchConfigurationTemplateID', ], 'members' => [ 'launchConfigurationTemplateID' => [ 'shape' => 'LaunchConfigurationTemplateID', ], 'filters' => [ 'shape' => 'TemplateActionsRequestFilters', ], 'maxResults' => [ 'shape' => 'MaxResultsType', ], 'nextToken' => [ 'shape' => 'PaginationToken', ], ], ], 'ListTemplateActionsResponse' => [ 'type' => 'structure', 'members' => [ 'items' => [ 'shape' => 'TemplateActionDocuments', ], 'nextToken' => [ 'shape' => 'PaginationToken', ], ], ], 'ListWavesRequest' => [ 'type' => 'structure', 'members' => [ 'filters' => [ 'shape' => 'ListWavesRequestFilters', ], 'maxResults' => [ 'shape' => 'MaxResultsType', ], 'nextToken' => [ 'shape' => 'PaginationToken', ], 'accountID' => [ 'shape' => 'AccountID', ], ], ], 'ListWavesRequestFilters' => [ 'type' => 'structure', 'members' => [ 'waveIDs' => [ 'shape' => 'WaveIDsFilter', ], 'isArchived' => [ 'shape' => 'Boolean', ], ], ], 'ListWavesResponse' => [ 'type' => 'structure', 'members' => [ 'items' => [ 'shape' => 'WavesList', ], 'nextToken' => [ 'shape' => 'PaginationToken', ], ], ], 'ManagedAccount' => [ 'type' => 'structure', 'members' => [ 'accountId' => [ 'shape' => 'AccountID', ], ], ], 'ManagedAccounts' => [ 'type' => 'list', 'member' => [ 'shape' => 'ManagedAccount', ], 'max' => 1000, 'min' => 0, ], 'MarkAsArchivedRequest' => [ 'type' => 'structure', 'required' => [ 'sourceServerID', ], 'members' => [ 'sourceServerID' => [ 'shape' => 'SourceServerID', ], 'accountID' => [ 'shape' => 'AccountID', ], ], ], 'MaxResultsType' => [ 'type' => 'integer', 'box' => true, 'max' => 1000, 'min' => 1, ], 'NetworkInterface' => [ 'type' => 'structure', 'members' => [ 'macAddress' => [ 'shape' => 'BoundedString', ], 'ips' => [ 'shape' => 'IPsList', ], 'isPrimary' => [ 'shape' => 'Boolean', ], ], ], 'NetworkInterfaces' => [ 'type' => 'list', 'member' => [ 'shape' => 'NetworkInterface', ], 'max' => 32, 'min' => 0, ], 'OS' => [ 'type' => 'structure', 'members' => [ 'fullString' => [ 'shape' => 'BoundedString', ], ], ], 'OperatingSystemString' => [ 'type' => 'string', 'pattern' => '(linux|windows)', ], 'OrderType' => [ 'type' => 'integer', 'box' => true, 'max' => 10000, 'min' => 1001, ], 'PaginationToken' => [ 'type' => 'string', 'max' => 2048, 'min' => 0, ], 'ParticipatingServer' => [ 'type' => 'structure', 'required' => [ 'sourceServerID', ], 'members' => [ 'sourceServerID' => [ 'shape' => 'SourceServerID', ], 'launchStatus' => [ 'shape' => 'LaunchStatus', ], 'launchedEc2InstanceID' => [ 'shape' => 'EC2InstanceID', ], 'postLaunchActionsStatus' => [ 'shape' => 'PostLaunchActionsStatus', ], ], ], 'ParticipatingServers' => [ 'type' => 'list', 'member' => [ 'shape' => 'ParticipatingServer', ], ], 'PauseReplicationRequest' => [ 'type' => 'structure', 'required' => [ 'sourceServerID', ], 'members' => [ 'sourceServerID' => [ 'shape' => 'SourceServerID', ], 'accountID' => [ 'shape' => 'AccountID', ], ], ], 'PositiveInteger' => [ 'type' => 'long', 'min' => 0, ], 'PostLaunchActionExecutionStatus' => [ 'type' => 'string', 'enum' => [ 'IN_PROGRESS', 'SUCCESS', 'FAILED', ], ], 'PostLaunchActions' => [ 'type' => 'structure', 'members' => [ 'deployment' => [ 'shape' => 'PostLaunchActionsDeploymentType', ], 's3LogBucket' => [ 'shape' => 'S3LogBucketName', ], 's3OutputKeyPrefix' => [ 'shape' => 'BoundedString', ], 'cloudWatchLogGroupName' => [ 'shape' => 'CloudWatchLogGroupName', ], 'ssmDocuments' => [ 'shape' => 'SsmDocuments', ], ], ], 'PostLaunchActionsDeploymentType' => [ 'type' => 'string', 'enum' => [ 'TEST_AND_CUTOVER', 'CUTOVER_ONLY', 'TEST_ONLY', ], ], 'PostLaunchActionsLaunchStatusList' => [ 'type' => 'list', 'member' => [ 'shape' => 'JobPostLaunchActionsLaunchStatus', ], ], 'PostLaunchActionsStatus' => [ 'type' => 'structure', 'members' => [ 'ssmAgentDiscoveryDatetime' => [ 'shape' => 'ISO8601DatetimeString', ], 'postLaunchActionsLaunchStatusList' => [ 'shape' => 'PostLaunchActionsLaunchStatusList', ], ], ], 'PutSourceServerActionRequest' => [ 'type' => 'structure', 'required' => [ 'sourceServerID', 'actionName', 'documentIdentifier', 'order', 'actionID', ], 'members' => [ 'sourceServerID' => [ 'shape' => 'SourceServerID', ], 'actionName' => [ 'shape' => 'ActionName', ], 'documentIdentifier' => [ 'shape' => 'BoundedString', ], 'order' => [ 'shape' => 'OrderType', ], 'actionID' => [ 'shape' => 'ActionID', ], 'documentVersion' => [ 'shape' => 'DocumentVersion', ], 'active' => [ 'shape' => 'Boolean', ], 'timeoutSeconds' => [ 'shape' => 'StrictlyPositiveInteger', ], 'mustSucceedForCutover' => [ 'shape' => 'Boolean', ], 'parameters' => [ 'shape' => 'SsmDocumentParameters', ], 'externalParameters' => [ 'shape' => 'SsmDocumentExternalParameters', ], 'description' => [ 'shape' => 'ActionDescription', ], 'category' => [ 'shape' => 'ActionCategory', ], 'accountID' => [ 'shape' => 'AccountID', ], ], ], 'PutTemplateActionRequest' => [ 'type' => 'structure', 'required' => [ 'launchConfigurationTemplateID', 'actionName', 'documentIdentifier', 'order', 'actionID', ], 'members' => [ 'launchConfigurationTemplateID' => [ 'shape' => 'LaunchConfigurationTemplateID', ], 'actionName' => [ 'shape' => 'BoundedString', ], 'documentIdentifier' => [ 'shape' => 'BoundedString', ], 'order' => [ 'shape' => 'OrderType', ], 'actionID' => [ 'shape' => 'ActionID', ], 'documentVersion' => [ 'shape' => 'DocumentVersion', ], 'active' => [ 'shape' => 'Boolean', ], 'timeoutSeconds' => [ 'shape' => 'StrictlyPositiveInteger', ], 'mustSucceedForCutover' => [ 'shape' => 'Boolean', ], 'parameters' => [ 'shape' => 'SsmDocumentParameters', ], 'operatingSystem' => [ 'shape' => 'OperatingSystemString', ], 'externalParameters' => [ 'shape' => 'SsmDocumentExternalParameters', ], 'description' => [ 'shape' => 'ActionDescription', ], 'category' => [ 'shape' => 'ActionCategory', ], ], ], 'RemoveSourceServerActionRequest' => [ 'type' => 'structure', 'required' => [ 'sourceServerID', 'actionID', ], 'members' => [ 'sourceServerID' => [ 'shape' => 'SourceServerID', ], 'actionID' => [ 'shape' => 'ActionID', ], 'accountID' => [ 'shape' => 'AccountID', ], ], ], 'RemoveSourceServerActionResponse' => [ 'type' => 'structure', 'members' => [], ], 'RemoveTemplateActionRequest' => [ 'type' => 'structure', 'required' => [ 'launchConfigurationTemplateID', 'actionID', ], 'members' => [ 'launchConfigurationTemplateID' => [ 'shape' => 'LaunchConfigurationTemplateID', ], 'actionID' => [ 'shape' => 'ActionID', ], ], ], 'RemoveTemplateActionResponse' => [ 'type' => 'structure', 'members' => [], ], 'ReplicationConfiguration' => [ 'type' => 'structure', 'members' => [ 'sourceServerID' => [ 'shape' => 'SourceServerID', ], 'name' => [ 'shape' => 'SmallBoundedString', ], 'stagingAreaSubnetId' => [ 'shape' => 'SubnetID', ], 'associateDefaultSecurityGroup' => [ 'shape' => 'Boolean', ], 'replicationServersSecurityGroupsIDs' => [ 'shape' => 'ReplicationServersSecurityGroupsIDs', ], 'replicationServerInstanceType' => [ 'shape' => 'EC2InstanceType', ], 'useDedicatedReplicationServer' => [ 'shape' => 'Boolean', ], 'defaultLargeStagingDiskType' => [ 'shape' => 'ReplicationConfigurationDefaultLargeStagingDiskType', ], 'replicatedDisks' => [ 'shape' => 'ReplicationConfigurationReplicatedDisks', ], 'ebsEncryption' => [ 'shape' => 'ReplicationConfigurationEbsEncryption', ], 'ebsEncryptionKeyArn' => [ 'shape' => 'ARN', ], 'bandwidthThrottling' => [ 'shape' => 'BandwidthThrottling', ], 'dataPlaneRouting' => [ 'shape' => 'ReplicationConfigurationDataPlaneRouting', ], 'createPublicIP' => [ 'shape' => 'Boolean', ], 'stagingAreaTags' => [ 'shape' => 'TagsMap', ], 'useFipsEndpoint' => [ 'shape' => 'Boolean', ], 'internetProtocol' => [ 'shape' => 'InternetProtocol', ], ], ], 'ReplicationConfigurationDataPlaneRouting' => [ 'type' => 'string', 'enum' => [ 'PRIVATE_IP', 'PUBLIC_IP', ], ], 'ReplicationConfigurationDefaultLargeStagingDiskType' => [ 'type' => 'string', 'enum' => [ 'GP2', 'ST1', 'GP3', ], ], 'ReplicationConfigurationEbsEncryption' => [ 'type' => 'string', 'enum' => [ 'DEFAULT', 'CUSTOM', ], ], 'ReplicationConfigurationReplicatedDisk' => [ 'type' => 'structure', 'members' => [ 'deviceName' => [ 'shape' => 'BoundedString', ], 'isBootDisk' => [ 'shape' => 'Boolean', ], 'stagingDiskType' => [ 'shape' => 'ReplicationConfigurationReplicatedDiskStagingDiskType', ], 'iops' => [ 'shape' => 'PositiveInteger', ], 'throughput' => [ 'shape' => 'PositiveInteger', ], ], ], 'ReplicationConfigurationReplicatedDiskStagingDiskType' => [ 'type' => 'string', 'enum' => [ 'AUTO', 'GP2', 'IO1', 'SC1', 'ST1', 'STANDARD', 'GP3', 'IO2', ], ], 'ReplicationConfigurationReplicatedDisks' => [ 'type' => 'list', 'member' => [ 'shape' => 'ReplicationConfigurationReplicatedDisk', ], 'max' => 60, 'min' => 0, ], 'ReplicationConfigurationTemplate' => [ 'type' => 'structure', 'required' => [ 'replicationConfigurationTemplateID', ], 'members' => [ 'replicationConfigurationTemplateID' => [ 'shape' => 'ReplicationConfigurationTemplateID', ], 'arn' => [ 'shape' => 'ARN', ], 'stagingAreaSubnetId' => [ 'shape' => 'SubnetID', ], 'associateDefaultSecurityGroup' => [ 'shape' => 'Boolean', ], 'replicationServersSecurityGroupsIDs' => [ 'shape' => 'ReplicationServersSecurityGroupsIDs', ], 'replicationServerInstanceType' => [ 'shape' => 'EC2InstanceType', ], 'useDedicatedReplicationServer' => [ 'shape' => 'Boolean', ], 'defaultLargeStagingDiskType' => [ 'shape' => 'ReplicationConfigurationDefaultLargeStagingDiskType', ], 'ebsEncryption' => [ 'shape' => 'ReplicationConfigurationEbsEncryption', ], 'ebsEncryptionKeyArn' => [ 'shape' => 'ARN', ], 'bandwidthThrottling' => [ 'shape' => 'BandwidthThrottling', ], 'dataPlaneRouting' => [ 'shape' => 'ReplicationConfigurationDataPlaneRouting', ], 'createPublicIP' => [ 'shape' => 'Boolean', ], 'stagingAreaTags' => [ 'shape' => 'TagsMap', ], 'useFipsEndpoint' => [ 'shape' => 'Boolean', ], 'tags' => [ 'shape' => 'TagsMap', ], 'internetProtocol' => [ 'shape' => 'InternetProtocol', ], ], ], 'ReplicationConfigurationTemplateID' => [ 'type' => 'string', 'max' => 21, 'min' => 21, 'pattern' => 'rct-[0-9a-zA-Z]{17}', ], 'ReplicationConfigurationTemplateIDs' => [ 'type' => 'list', 'member' => [ 'shape' => 'ReplicationConfigurationTemplateID', ], 'max' => 200, 'min' => 0, ], 'ReplicationConfigurationTemplates' => [ 'type' => 'list', 'member' => [ 'shape' => 'ReplicationConfigurationTemplate', ], ], 'ReplicationServersSecurityGroupsIDs' => [ 'type' => 'list', 'member' => [ 'shape' => 'SecurityGroupID', ], 'max' => 32, 'min' => 0, ], 'ReplicationType' => [ 'type' => 'string', 'enum' => [ 'AGENT_BASED', 'SNAPSHOT_SHIPPING', ], ], 'ReplicationTypes' => [ 'type' => 'list', 'member' => [ 'shape' => 'ReplicationType', ], 'max' => 2, 'min' => 0, ], 'ReplicatorID' => [ 'type' => 'string', 'max' => 19, 'min' => 19, 'pattern' => 'i-[0-9a-zA-Z]{17}', ], 'ResourceNotFoundException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'LargeBoundedString', ], 'code' => [ 'shape' => 'LargeBoundedString', ], 'resourceId' => [ 'shape' => 'LargeBoundedString', ], 'resourceType' => [ 'shape' => 'LargeBoundedString', ], ], 'error' => [ 'httpStatusCode' => 404, 'senderFault' => true, ], 'exception' => true, ], 'ResumeReplicationRequest' => [ 'type' => 'structure', 'required' => [ 'sourceServerID', ], 'members' => [ 'sourceServerID' => [ 'shape' => 'SourceServerID', ], 'accountID' => [ 'shape' => 'AccountID', ], ], ], 'RetryDataReplicationRequest' => [ 'type' => 'structure', 'required' => [ 'sourceServerID', ], 'members' => [ 'sourceServerID' => [ 'shape' => 'SourceServerID', ], 'accountID' => [ 'shape' => 'AccountID', ], ], ], 'S3BucketName' => [ 'type' => 'string', 'pattern' => '[a-zA-Z0-9.\\-_]{1,255}', ], 'S3BucketSource' => [ 'type' => 'structure', 'required' => [ 's3Bucket', 's3Key', ], 'members' => [ 's3Bucket' => [ 'shape' => 'S3BucketName', ], 's3Key' => [ 'shape' => 'S3Key', ], 's3BucketOwner' => [ 'shape' => 'AccountID', ], ], ], 'S3Key' => [ 'type' => 'string', 'pattern' => '[^\\x00]{1,1020}\\.csv', ], 'S3LogBucketName' => [ 'type' => 'string', 'max' => 63, 'min' => 3, ], 'SecretArn' => [ 'type' => 'string', 'max' => 100, 'min' => 20, 'pattern' => 'arn:[\\w-]+:secretsmanager:([a-z]{2}-(gov-)?[a-z]+-\\d{1})?:(\\d{12})?:secret:(.+)', ], 'SecurityGroupID' => [ 'type' => 'string', 'max' => 255, 'min' => 0, 'pattern' => 'sg-[0-9a-fA-F]{8,}', ], 'ServiceQuotaExceededException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'LargeBoundedString', ], 'code' => [ 'shape' => 'LargeBoundedString', ], 'resourceId' => [ 'shape' => 'LargeBoundedString', ], 'resourceType' => [ 'shape' => 'LargeBoundedString', ], 'serviceCode' => [ 'shape' => 'LargeBoundedString', ], 'quotaCode' => [ 'shape' => 'LargeBoundedString', ], 'quotaValue' => [ 'shape' => 'StrictlyPositiveInteger', ], ], 'error' => [ 'httpStatusCode' => 402, 'senderFault' => true, ], 'exception' => true, ], 'SmallBoundedString' => [ 'type' => 'string', 'max' => 128, 'min' => 0, ], 'SourceProperties' => [ 'type' => 'structure', 'members' => [ 'lastUpdatedDateTime' => [ 'shape' => 'ISO8601DatetimeString', ], 'recommendedInstanceType' => [ 'shape' => 'EC2InstanceType', ], 'identificationHints' => [ 'shape' => 'IdentificationHints', ], 'networkInterfaces' => [ 'shape' => 'NetworkInterfaces', ], 'disks' => [ 'shape' => 'Disks', ], 'cpus' => [ 'shape' => 'Cpus', ], 'ramBytes' => [ 'shape' => 'PositiveInteger', ], 'os' => [ 'shape' => 'OS', ], ], ], 'SourceServer' => [ 'type' => 'structure', 'members' => [ 'sourceServerID' => [ 'shape' => 'SourceServerID', ], 'arn' => [ 'shape' => 'ARN', ], 'isArchived' => [ 'shape' => 'Boolean', ], 'tags' => [ 'shape' => 'TagsMap', ], 'launchedInstance' => [ 'shape' => 'LaunchedInstance', ], 'dataReplicationInfo' => [ 'shape' => 'DataReplicationInfo', ], 'lifeCycle' => [ 'shape' => 'LifeCycle', ], 'sourceProperties' => [ 'shape' => 'SourceProperties', ], 'replicationType' => [ 'shape' => 'ReplicationType', ], 'vcenterClientID' => [ 'shape' => 'VcenterClientID', ], 'applicationID' => [ 'shape' => 'ApplicationID', ], 'userProvidedID' => [ 'shape' => 'UserProvidedId', ], 'fqdnForActionFramework' => [ 'shape' => 'BoundedString', ], 'connectorAction' => [ 'shape' => 'SourceServerConnectorAction', ], ], ], 'SourceServerActionDocument' => [ 'type' => 'structure', 'members' => [ 'actionID' => [ 'shape' => 'ActionID', ], 'actionName' => [ 'shape' => 'ActionName', ], 'documentIdentifier' => [ 'shape' => 'BoundedString', ], 'order' => [ 'shape' => 'OrderType', ], 'documentVersion' => [ 'shape' => 'DocumentVersion', ], 'active' => [ 'shape' => 'Boolean', ], 'timeoutSeconds' => [ 'shape' => 'StrictlyPositiveInteger', ], 'mustSucceedForCutover' => [ 'shape' => 'Boolean', ], 'parameters' => [ 'shape' => 'SsmDocumentParameters', ], 'externalParameters' => [ 'shape' => 'SsmDocumentExternalParameters', ], 'description' => [ 'shape' => 'ActionDescription', ], 'category' => [ 'shape' => 'ActionCategory', ], ], ], 'SourceServerActionDocuments' => [ 'type' => 'list', 'member' => [ 'shape' => 'SourceServerActionDocument', ], 'max' => 100, 'min' => 0, ], 'SourceServerActionsRequestFilters' => [ 'type' => 'structure', 'members' => [ 'actionIDs' => [ 'shape' => 'ActionIDs', ], ], ], 'SourceServerConnectorAction' => [ 'type' => 'structure', 'members' => [ 'credentialsSecretArn' => [ 'shape' => 'SecretArn', ], 'connectorArn' => [ 'shape' => 'ConnectorArn', ], ], ], 'SourceServerID' => [ 'type' => 'string', 'max' => 19, 'min' => 19, 'pattern' => 's-[0-9a-zA-Z]{17}', ], 'SourceServersList' => [ 'type' => 'list', 'member' => [ 'shape' => 'SourceServer', ], ], 'SsmDocument' => [ 'type' => 'structure', 'required' => [ 'actionName', 'ssmDocumentName', ], 'members' => [ 'actionName' => [ 'shape' => 'BoundedString', ], 'ssmDocumentName' => [ 'shape' => 'SsmDocumentName', ], 'timeoutSeconds' => [ 'shape' => 'StrictlyPositiveInteger', ], 'mustSucceedForCutover' => [ 'shape' => 'Boolean', ], 'parameters' => [ 'shape' => 'SsmDocumentParameters', ], 'externalParameters' => [ 'shape' => 'SsmDocumentExternalParameters', ], ], ], 'SsmDocumentExternalParameters' => [ 'type' => 'map', 'key' => [ 'shape' => 'SsmDocumentParameterName', ], 'value' => [ 'shape' => 'SsmExternalParameter', ], 'max' => 20, 'min' => 0, ], 'SsmDocumentName' => [ 'type' => 'string', 'max' => 172, 'min' => 3, 'pattern' => '([A-Za-z0-9/:_\\.-])+', ], 'SsmDocumentParameterName' => [ 'type' => 'string', 'max' => 1011, 'min' => 1, 'pattern' => '([A-Za-z0-9])+', ], 'SsmDocumentParameters' => [ 'type' => 'map', 'key' => [ 'shape' => 'SsmDocumentParameterName', ], 'value' => [ 'shape' => 'SsmParameterStoreParameters', ], 'max' => 20, 'min' => 0, ], 'SsmDocumentType' => [ 'type' => 'string', 'enum' => [ 'AUTOMATION', 'COMMAND', ], ], 'SsmDocuments' => [ 'type' => 'list', 'member' => [ 'shape' => 'SsmDocument', ], 'max' => 10, 'min' => 0, ], 'SsmExternalParameter' => [ 'type' => 'structure', 'members' => [ 'dynamicPath' => [ 'shape' => 'JmesPathString', ], ], 'union' => true, ], 'SsmInstanceID' => [ 'type' => 'string', 'max' => 20, 'min' => 19, 'pattern' => '.*(^i-[0-9a-zA-Z]{17}$)|(^mi-[0-9a-zA-Z]{17}$).*', ], 'SsmParameterStoreParameter' => [ 'type' => 'structure', 'required' => [ 'parameterType', 'parameterName', ], 'members' => [ 'parameterType' => [ 'shape' => 'SsmParameterStoreParameterType', ], 'parameterName' => [ 'shape' => 'SsmParameterStoreParameterName', ], ], ], 'SsmParameterStoreParameterName' => [ 'type' => 'string', 'max' => 1011, 'min' => 1, 'pattern' => '([A-Za-z0-9_\\.-])+', ], 'SsmParameterStoreParameterType' => [ 'type' => 'string', 'enum' => [ 'STRING', 'SECURE_STRING', ], ], 'SsmParameterStoreParameters' => [ 'type' => 'list', 'member' => [ 'shape' => 'SsmParameterStoreParameter', ], 'max' => 10, 'min' => 0, ], 'StartCutoverRequest' => [ 'type' => 'structure', 'required' => [ 'sourceServerIDs', ], 'members' => [ 'sourceServerIDs' => [ 'shape' => 'StartCutoverRequestSourceServerIDs', ], 'tags' => [ 'shape' => 'TagsMap', ], 'accountID' => [ 'shape' => 'AccountID', ], ], ], 'StartCutoverRequestSourceServerIDs' => [ 'type' => 'list', 'member' => [ 'shape' => 'SourceServerID', ], 'max' => 200, 'min' => 1, ], 'StartCutoverResponse' => [ 'type' => 'structure', 'members' => [ 'job' => [ 'shape' => 'Job', ], ], ], 'StartExportRequest' => [ 'type' => 'structure', 'required' => [ 's3Bucket', 's3Key', ], 'members' => [ 's3Bucket' => [ 'shape' => 'S3BucketName', ], 's3Key' => [ 'shape' => 'S3Key', ], 's3BucketOwner' => [ 'shape' => 'AccountID', ], 'tags' => [ 'shape' => 'TagsMap', ], ], ], 'StartExportResponse' => [ 'type' => 'structure', 'members' => [ 'exportTask' => [ 'shape' => 'ExportTask', ], ], ], 'StartImportRequest' => [ 'type' => 'structure', 'required' => [ 's3BucketSource', ], 'members' => [ 'clientToken' => [ 'shape' => 'ClientIdempotencyToken', 'idempotencyToken' => true, ], 's3BucketSource' => [ 'shape' => 'S3BucketSource', ], 'tags' => [ 'shape' => 'TagsMap', ], ], ], 'StartImportResponse' => [ 'type' => 'structure', 'members' => [ 'importTask' => [ 'shape' => 'ImportTask', ], ], ], 'StartReplicationRequest' => [ 'type' => 'structure', 'required' => [ 'sourceServerID', ], 'members' => [ 'sourceServerID' => [ 'shape' => 'SourceServerID', ], 'accountID' => [ 'shape' => 'AccountID', ], ], ], 'StartTestRequest' => [ 'type' => 'structure', 'required' => [ 'sourceServerIDs', ], 'members' => [ 'sourceServerIDs' => [ 'shape' => 'StartTestRequestSourceServerIDs', ], 'tags' => [ 'shape' => 'TagsMap', ], 'accountID' => [ 'shape' => 'AccountID', ], ], ], 'StartTestRequestSourceServerIDs' => [ 'type' => 'list', 'member' => [ 'shape' => 'SourceServerID', ], 'max' => 200, 'min' => 1, ], 'StartTestResponse' => [ 'type' => 'structure', 'members' => [ 'job' => [ 'shape' => 'Job', ], ], ], 'StopReplicationRequest' => [ 'type' => 'structure', 'required' => [ 'sourceServerID', ], 'members' => [ 'sourceServerID' => [ 'shape' => 'SourceServerID', ], 'accountID' => [ 'shape' => 'AccountID', ], ], ], 'StrictlyPositiveInteger' => [ 'type' => 'integer', 'box' => true, 'min' => 1, ], 'SubnetID' => [ 'type' => 'string', 'max' => 255, 'min' => 0, 'pattern' => 'subnet-[0-9a-fA-F]{8,}', ], 'TagKey' => [ 'type' => 'string', 'max' => 256, 'min' => 0, ], 'TagKeys' => [ 'type' => 'list', 'member' => [ 'shape' => 'TagKey', ], 'sensitive' => true, ], 'TagResourceRequest' => [ 'type' => 'structure', 'required' => [ 'resourceArn', 'tags', ], 'members' => [ 'resourceArn' => [ 'shape' => 'ARN', 'location' => 'uri', 'locationName' => 'resourceArn', ], 'tags' => [ 'shape' => 'TagsMap', ], ], ], 'TagValue' => [ 'type' => 'string', 'max' => 256, 'min' => 0, ], 'TagsMap' => [ 'type' => 'map', 'key' => [ 'shape' => 'TagKey', ], 'value' => [ 'shape' => 'TagValue', ], 'max' => 50, 'min' => 0, 'sensitive' => true, ], 'TargetInstanceTypeRightSizingMethod' => [ 'type' => 'string', 'enum' => [ 'NONE', 'BASIC', ], ], 'TemplateActionDocument' => [ 'type' => 'structure', 'members' => [ 'actionID' => [ 'shape' => 'ActionID', ], 'actionName' => [ 'shape' => 'BoundedString', ], 'documentIdentifier' => [ 'shape' => 'BoundedString', ], 'order' => [ 'shape' => 'OrderType', ], 'documentVersion' => [ 'shape' => 'DocumentVersion', ], 'active' => [ 'shape' => 'Boolean', ], 'timeoutSeconds' => [ 'shape' => 'StrictlyPositiveInteger', ], 'mustSucceedForCutover' => [ 'shape' => 'Boolean', ], 'parameters' => [ 'shape' => 'SsmDocumentParameters', ], 'operatingSystem' => [ 'shape' => 'OperatingSystemString', ], 'externalParameters' => [ 'shape' => 'SsmDocumentExternalParameters', ], 'description' => [ 'shape' => 'ActionDescription', ], 'category' => [ 'shape' => 'ActionCategory', ], ], ], 'TemplateActionDocuments' => [ 'type' => 'list', 'member' => [ 'shape' => 'TemplateActionDocument', ], 'max' => 100, 'min' => 0, ], 'TemplateActionsRequestFilters' => [ 'type' => 'structure', 'members' => [ 'actionIDs' => [ 'shape' => 'ActionIDs', ], ], ], 'TerminateTargetInstancesRequest' => [ 'type' => 'structure', 'required' => [ 'sourceServerIDs', ], 'members' => [ 'sourceServerIDs' => [ 'shape' => 'TerminateTargetInstancesRequestSourceServerIDs', ], 'tags' => [ 'shape' => 'TagsMap', ], 'accountID' => [ 'shape' => 'AccountID', ], ], ], 'TerminateTargetInstancesRequestSourceServerIDs' => [ 'type' => 'list', 'member' => [ 'shape' => 'SourceServerID', ], 'max' => 200, 'min' => 1, ], 'TerminateTargetInstancesResponse' => [ 'type' => 'structure', 'members' => [ 'job' => [ 'shape' => 'Job', ], ], ], 'ThrottlingException' => [ 'type' => 'structure', 'required' => [ 'message', ], 'members' => [ 'message' => [ 'shape' => 'LargeBoundedString', ], 'serviceCode' => [ 'shape' => 'LargeBoundedString', ], 'quotaCode' => [ 'shape' => 'LargeBoundedString', ], 'retryAfterSeconds' => [ 'shape' => 'LargeBoundedString', 'location' => 'header', 'locationName' => 'Retry-After', ], ], 'error' => [ 'httpStatusCode' => 429, 'senderFault' => true, ], 'exception' => true, ], 'Throughput' => [ 'type' => 'long', 'box' => true, 'max' => 1000, 'min' => 125, ], 'UnarchiveApplicationRequest' => [ 'type' => 'structure', 'required' => [ 'applicationID', ], 'members' => [ 'applicationID' => [ 'shape' => 'ApplicationID', ], 'accountID' => [ 'shape' => 'AccountID', ], ], ], 'UnarchiveWaveRequest' => [ 'type' => 'structure', 'required' => [ 'waveID', ], 'members' => [ 'waveID' => [ 'shape' => 'WaveID', ], 'accountID' => [ 'shape' => 'AccountID', ], ], ], 'UninitializedAccountException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'LargeBoundedString', ], 'code' => [ 'shape' => 'LargeBoundedString', ], ], 'error' => [ 'httpStatusCode' => 400, 'senderFault' => true, ], 'exception' => true, ], 'UntagResourceRequest' => [ 'type' => 'structure', 'required' => [ 'resourceArn', 'tagKeys', ], 'members' => [ 'resourceArn' => [ 'shape' => 'ARN', 'location' => 'uri', 'locationName' => 'resourceArn', ], 'tagKeys' => [ 'shape' => 'TagKeys', 'location' => 'querystring', 'locationName' => 'tagKeys', ], ], ], 'UpdateApplicationRequest' => [ 'type' => 'structure', 'required' => [ 'applicationID', ], 'members' => [ 'applicationID' => [ 'shape' => 'ApplicationID', ], 'name' => [ 'shape' => 'ApplicationName', ], 'description' => [ 'shape' => 'ApplicationDescription', ], 'accountID' => [ 'shape' => 'AccountID', ], ], ], 'UpdateConnectorRequest' => [ 'type' => 'structure', 'required' => [ 'connectorID', ], 'members' => [ 'connectorID' => [ 'shape' => 'ConnectorID', ], 'name' => [ 'shape' => 'ConnectorName', ], 'ssmCommandConfig' => [ 'shape' => 'ConnectorSsmCommandConfig', ], ], ], 'UpdateLaunchConfigurationRequest' => [ 'type' => 'structure', 'required' => [ 'sourceServerID', ], 'members' => [ 'sourceServerID' => [ 'shape' => 'SourceServerID', ], 'name' => [ 'shape' => 'SmallBoundedString', ], 'launchDisposition' => [ 'shape' => 'LaunchDisposition', ], 'targetInstanceTypeRightSizingMethod' => [ 'shape' => 'TargetInstanceTypeRightSizingMethod', ], 'copyPrivateIp' => [ 'shape' => 'Boolean', ], 'copyTags' => [ 'shape' => 'Boolean', ], 'licensing' => [ 'shape' => 'Licensing', ], 'bootMode' => [ 'shape' => 'BootMode', ], 'postLaunchActions' => [ 'shape' => 'PostLaunchActions', ], 'enableMapAutoTagging' => [ 'shape' => 'Boolean', ], 'mapAutoTaggingMpeID' => [ 'shape' => 'TagValue', ], 'accountID' => [ 'shape' => 'AccountID', ], ], ], 'UpdateLaunchConfigurationTemplateRequest' => [ 'type' => 'structure', 'required' => [ 'launchConfigurationTemplateID', ], 'members' => [ 'launchConfigurationTemplateID' => [ 'shape' => 'LaunchConfigurationTemplateID', ], 'postLaunchActions' => [ 'shape' => 'PostLaunchActions', ], 'enableMapAutoTagging' => [ 'shape' => 'Boolean', ], 'mapAutoTaggingMpeID' => [ 'shape' => 'TagValue', ], 'launchDisposition' => [ 'shape' => 'LaunchDisposition', ], 'targetInstanceTypeRightSizingMethod' => [ 'shape' => 'TargetInstanceTypeRightSizingMethod', ], 'copyPrivateIp' => [ 'shape' => 'Boolean', ], 'associatePublicIpAddress' => [ 'shape' => 'Boolean', ], 'copyTags' => [ 'shape' => 'Boolean', ], 'licensing' => [ 'shape' => 'Licensing', ], 'bootMode' => [ 'shape' => 'BootMode', ], 'smallVolumeMaxSize' => [ 'shape' => 'PositiveInteger', ], 'smallVolumeConf' => [ 'shape' => 'LaunchTemplateDiskConf', ], 'largeVolumeConf' => [ 'shape' => 'LaunchTemplateDiskConf', ], 'enableParametersEncryption' => [ 'shape' => 'Boolean', ], 'parametersEncryptionKey' => [ 'shape' => 'ARN', ], ], ], 'UpdateReplicationConfigurationRequest' => [ 'type' => 'structure', 'required' => [ 'sourceServerID', ], 'members' => [ 'sourceServerID' => [ 'shape' => 'SourceServerID', ], 'name' => [ 'shape' => 'SmallBoundedString', ], 'stagingAreaSubnetId' => [ 'shape' => 'SubnetID', ], 'associateDefaultSecurityGroup' => [ 'shape' => 'Boolean', ], 'replicationServersSecurityGroupsIDs' => [ 'shape' => 'ReplicationServersSecurityGroupsIDs', ], 'replicationServerInstanceType' => [ 'shape' => 'EC2InstanceType', ], 'useDedicatedReplicationServer' => [ 'shape' => 'Boolean', ], 'defaultLargeStagingDiskType' => [ 'shape' => 'ReplicationConfigurationDefaultLargeStagingDiskType', ], 'replicatedDisks' => [ 'shape' => 'ReplicationConfigurationReplicatedDisks', ], 'ebsEncryption' => [ 'shape' => 'ReplicationConfigurationEbsEncryption', ], 'ebsEncryptionKeyArn' => [ 'shape' => 'ARN', ], 'bandwidthThrottling' => [ 'shape' => 'BandwidthThrottling', ], 'dataPlaneRouting' => [ 'shape' => 'ReplicationConfigurationDataPlaneRouting', ], 'createPublicIP' => [ 'shape' => 'Boolean', ], 'stagingAreaTags' => [ 'shape' => 'TagsMap', ], 'useFipsEndpoint' => [ 'shape' => 'Boolean', ], 'accountID' => [ 'shape' => 'AccountID', ], 'internetProtocol' => [ 'shape' => 'InternetProtocol', ], ], ], 'UpdateReplicationConfigurationTemplateRequest' => [ 'type' => 'structure', 'required' => [ 'replicationConfigurationTemplateID', ], 'members' => [ 'replicationConfigurationTemplateID' => [ 'shape' => 'ReplicationConfigurationTemplateID', ], 'arn' => [ 'shape' => 'ARN', ], 'stagingAreaSubnetId' => [ 'shape' => 'SubnetID', ], 'associateDefaultSecurityGroup' => [ 'shape' => 'Boolean', ], 'replicationServersSecurityGroupsIDs' => [ 'shape' => 'ReplicationServersSecurityGroupsIDs', ], 'replicationServerInstanceType' => [ 'shape' => 'EC2InstanceType', ], 'useDedicatedReplicationServer' => [ 'shape' => 'Boolean', ], 'defaultLargeStagingDiskType' => [ 'shape' => 'ReplicationConfigurationDefaultLargeStagingDiskType', ], 'ebsEncryption' => [ 'shape' => 'ReplicationConfigurationEbsEncryption', ], 'ebsEncryptionKeyArn' => [ 'shape' => 'ARN', ], 'bandwidthThrottling' => [ 'shape' => 'BandwidthThrottling', ], 'dataPlaneRouting' => [ 'shape' => 'ReplicationConfigurationDataPlaneRouting', ], 'createPublicIP' => [ 'shape' => 'Boolean', ], 'stagingAreaTags' => [ 'shape' => 'TagsMap', ], 'useFipsEndpoint' => [ 'shape' => 'Boolean', ], 'internetProtocol' => [ 'shape' => 'InternetProtocol', ], ], ], 'UpdateSourceServerReplicationTypeRequest' => [ 'type' => 'structure', 'required' => [ 'sourceServerID', 'replicationType', ], 'members' => [ 'sourceServerID' => [ 'shape' => 'SourceServerID', ], 'replicationType' => [ 'shape' => 'ReplicationType', ], 'accountID' => [ 'shape' => 'AccountID', ], ], ], 'UpdateSourceServerRequest' => [ 'type' => 'structure', 'required' => [ 'sourceServerID', ], 'members' => [ 'accountID' => [ 'shape' => 'AccountID', ], 'sourceServerID' => [ 'shape' => 'SourceServerID', ], 'connectorAction' => [ 'shape' => 'SourceServerConnectorAction', ], ], ], 'UpdateWaveRequest' => [ 'type' => 'structure', 'required' => [ 'waveID', ], 'members' => [ 'waveID' => [ 'shape' => 'WaveID', ], 'name' => [ 'shape' => 'WaveName', ], 'description' => [ 'shape' => 'WaveDescription', ], 'accountID' => [ 'shape' => 'AccountID', ], ], ], 'UserProvidedId' => [ 'type' => 'string', 'max' => 256, 'min' => 1, 'pattern' => '[^\\s\\x00]( *[^\\s\\x00])*', ], 'ValidationException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'LargeBoundedString', ], 'code' => [ 'shape' => 'LargeBoundedString', ], 'reason' => [ 'shape' => 'ValidationExceptionReason', ], 'fieldList' => [ 'shape' => 'ValidationExceptionFieldList', ], ], 'error' => [ 'httpStatusCode' => 400, 'senderFault' => true, ], 'exception' => true, ], 'ValidationExceptionField' => [ 'type' => 'structure', 'members' => [ 'name' => [ 'shape' => 'LargeBoundedString', ], 'message' => [ 'shape' => 'LargeBoundedString', ], ], ], 'ValidationExceptionFieldList' => [ 'type' => 'list', 'member' => [ 'shape' => 'ValidationExceptionField', ], ], 'ValidationExceptionReason' => [ 'type' => 'string', 'enum' => [ 'unknownOperation', 'cannotParse', 'fieldValidationFailed', 'other', ], ], 'VcenterClient' => [ 'type' => 'structure', 'members' => [ 'vcenterClientID' => [ 'shape' => 'VcenterClientID', ], 'arn' => [ 'shape' => 'ARN', ], 'hostname' => [ 'shape' => 'BoundedString', ], 'vcenterUUID' => [ 'shape' => 'BoundedString', ], 'datacenterName' => [ 'shape' => 'BoundedString', ], 'lastSeenDatetime' => [ 'shape' => 'ISO8601DatetimeString', ], 'sourceServerTags' => [ 'shape' => 'TagsMap', ], 'tags' => [ 'shape' => 'TagsMap', ], ], ], 'VcenterClientID' => [ 'type' => 'string', 'max' => 21, 'min' => 21, 'pattern' => 'vcc-[0-9a-zA-Z]{17}', ], 'VcenterClientList' => [ 'type' => 'list', 'member' => [ 'shape' => 'VcenterClient', ], ], 'VolumeType' => [ 'type' => 'string', 'enum' => [ 'io1', 'io2', 'gp3', 'gp2', 'st1', 'sc1', 'standard', ], ], 'Wave' => [ 'type' => 'structure', 'members' => [ 'waveID' => [ 'shape' => 'WaveID', ], 'arn' => [ 'shape' => 'ARN', ], 'name' => [ 'shape' => 'WaveName', ], 'description' => [ 'shape' => 'WaveDescription', ], 'isArchived' => [ 'shape' => 'Boolean', ], 'waveAggregatedStatus' => [ 'shape' => 'WaveAggregatedStatus', ], 'creationDateTime' => [ 'shape' => 'ISO8601DatetimeString', ], 'lastModifiedDateTime' => [ 'shape' => 'ISO8601DatetimeString', ], 'tags' => [ 'shape' => 'TagsMap', ], ], ], 'WaveAggregatedStatus' => [ 'type' => 'structure', 'members' => [ 'lastUpdateDateTime' => [ 'shape' => 'ISO8601DatetimeString', ], 'replicationStartedDateTime' => [ 'shape' => 'ISO8601DatetimeString', ], 'healthStatus' => [ 'shape' => 'WaveHealthStatus', ], 'progressStatus' => [ 'shape' => 'WaveProgressStatus', ], 'totalApplications' => [ 'shape' => 'PositiveInteger', ], ], ], 'WaveDescription' => [ 'type' => 'string', 'max' => 600, 'min' => 0, 'pattern' => '[^\\x00]*', ], 'WaveHealthStatus' => [ 'type' => 'string', 'enum' => [ 'HEALTHY', 'LAGGING', 'ERROR', ], ], 'WaveID' => [ 'type' => 'string', 'max' => 22, 'min' => 22, 'pattern' => 'wave-[0-9a-zA-Z]{17}', ], 'WaveIDsFilter' => [ 'type' => 'list', 'member' => [ 'shape' => 'WaveID', ], 'max' => 200, 'min' => 0, ], 'WaveName' => [ 'type' => 'string', 'max' => 256, 'min' => 1, 'pattern' => '[^\\s\\x00]( *[^\\s\\x00])*', ], 'WaveProgressStatus' => [ 'type' => 'string', 'enum' => [ 'NOT_STARTED', 'IN_PROGRESS', 'COMPLETED', ], ], 'WavesList' => [ 'type' => 'list', 'member' => [ 'shape' => 'Wave', ], ], ],];
