<?php
// This file was auto-generated from sdk-root/src/data/connect/2017-08-08/api-2.json
return [ 'version' => '2.0', 'metadata' => [ 'apiVersion' => '2017-08-08', 'endpointPrefix' => 'connect', 'jsonVersion' => '1.1', 'protocol' => 'rest-json', 'serviceAbbreviation' => 'Amazon Connect', 'serviceFullName' => 'Amazon Connect Service', 'serviceId' => 'Connect', 'signatureVersion' => 'v4', 'signingName' => 'connect', 'uid' => 'connect-2017-08-08', ], 'operations' => [ 'AssociateRoutingProfileQueues' => [ 'name' => 'AssociateRoutingProfileQueues', 'http' => [ 'method' => 'POST', 'requestUri' => '/routing-profiles/{InstanceId}/{RoutingProfileId}/associate-queues', ], 'input' => [ 'shape' => 'AssociateRoutingProfileQueuesRequest', ], 'errors' => [ [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServiceException', ], ], ], 'CreateContactFlow' => [ 'name' => 'CreateContactFlow', 'http' => [ 'method' => 'PUT', 'requestUri' => '/contact-flows/{InstanceId}', ], 'input' => [ 'shape' => 'CreateContactFlowRequest', ], 'output' => [ 'shape' => 'CreateContactFlowResponse', ], 'errors' => [ [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'InvalidContactFlowException', ], [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'DuplicateResourceException', ], [ 'shape' => 'LimitExceededException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServiceException', ], ], ], 'CreateRoutingProfile' => [ 'name' => 'CreateRoutingProfile', 'http' => [ 'method' => 'PUT', 'requestUri' => '/routing-profiles/{InstanceId}', ], 'input' => [ 'shape' => 'CreateRoutingProfileRequest', ], 'output' => [ 'shape' => 'CreateRoutingProfileResponse', ], 'errors' => [ [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'DuplicateResourceException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'LimitExceededException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServiceException', ], ], ], 'CreateUser' => [ 'name' => 'CreateUser', 'http' => [ 'method' => 'PUT', 'requestUri' => '/users/{InstanceId}', ], 'input' => [ 'shape' => 'CreateUserRequest', ], 'output' => [ 'shape' => 'CreateUserResponse', ], 'errors' => [ [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'LimitExceededException', ], [ 'shape' => 'DuplicateResourceException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServiceException', ], ], ], 'CreateUserHierarchyGroup' => [ 'name' => 'CreateUserHierarchyGroup', 'http' => [ 'method' => 'PUT', 'requestUri' => '/user-hierarchy-groups/{InstanceId}', ], 'input' => [ 'shape' => 'CreateUserHierarchyGroupRequest', ], 'output' => [ 'shape' => 'CreateUserHierarchyGroupResponse', ], 'errors' => [ [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'DuplicateResourceException', ], [ 'shape' => 'LimitExceededException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServiceException', ], ], ], 'DeleteUser' => [ 'name' => 'DeleteUser', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/users/{InstanceId}/{UserId}', ], 'input' => [ 'shape' => 'DeleteUserRequest', ], 'errors' => [ [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServiceException', ], ], ], 'DeleteUserHierarchyGroup' => [ 'name' => 'DeleteUserHierarchyGroup', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/user-hierarchy-groups/{InstanceId}/{HierarchyGroupId}', ], 'input' => [ 'shape' => 'DeleteUserHierarchyGroupRequest', ], 'errors' => [ [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ResourceInUseException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServiceException', ], ], ], 'DescribeContactFlow' => [ 'name' => 'DescribeContactFlow', 'http' => [ 'method' => 'GET', 'requestUri' => '/contact-flows/{InstanceId}/{ContactFlowId}', ], 'input' => [ 'shape' => 'DescribeContactFlowRequest', ], 'output' => [ 'shape' => 'DescribeContactFlowResponse', ], 'errors' => [ [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ContactFlowNotPublishedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServiceException', ], ], ], 'DescribeRoutingProfile' => [ 'name' => 'DescribeRoutingProfile', 'http' => [ 'method' => 'GET', 'requestUri' => '/routing-profiles/{InstanceId}/{RoutingProfileId}', ], 'input' => [ 'shape' => 'DescribeRoutingProfileRequest', ], 'output' => [ 'shape' => 'DescribeRoutingProfileResponse', ], 'errors' => [ [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServiceException', ], ], ], 'DescribeUser' => [ 'name' => 'DescribeUser', 'http' => [ 'method' => 'GET', 'requestUri' => '/users/{InstanceId}/{UserId}', ], 'input' => [ 'shape' => 'DescribeUserRequest', ], 'output' => [ 'shape' => 'DescribeUserResponse', ], 'errors' => [ [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServiceException', ], ], ], 'DescribeUserHierarchyGroup' => [ 'name' => 'DescribeUserHierarchyGroup', 'http' => [ 'method' => 'GET', 'requestUri' => '/user-hierarchy-groups/{InstanceId}/{HierarchyGroupId}', ], 'input' => [ 'shape' => 'DescribeUserHierarchyGroupRequest', ], 'output' => [ 'shape' => 'DescribeUserHierarchyGroupResponse', ], 'errors' => [ [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServiceException', ], ], ], 'DescribeUserHierarchyStructure' => [ 'name' => 'DescribeUserHierarchyStructure', 'http' => [ 'method' => 'GET', 'requestUri' => '/user-hierarchy-structure/{InstanceId}', ], 'input' => [ 'shape' => 'DescribeUserHierarchyStructureRequest', ], 'output' => [ 'shape' => 'DescribeUserHierarchyStructureResponse', ], 'errors' => [ [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServiceException', ], ], ], 'DisassociateRoutingProfileQueues' => [ 'name' => 'DisassociateRoutingProfileQueues', 'http' => [ 'method' => 'POST', 'requestUri' => '/routing-profiles/{InstanceId}/{RoutingProfileId}/disassociate-queues', ], 'input' => [ 'shape' => 'DisassociateRoutingProfileQueuesRequest', ], 'errors' => [ [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServiceException', ], ], ], 'GetContactAttributes' => [ 'name' => 'GetContactAttributes', 'http' => [ 'method' => 'GET', 'requestUri' => '/contact/attributes/{InstanceId}/{InitialContactId}', ], 'input' => [ 'shape' => 'GetContactAttributesRequest', ], 'output' => [ 'shape' => 'GetContactAttributesResponse', ], 'errors' => [ [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServiceException', ], ], ], 'GetCurrentMetricData' => [ 'name' => 'GetCurrentMetricData', 'http' => [ 'method' => 'POST', 'requestUri' => '/metrics/current/{InstanceId}', ], 'input' => [ 'shape' => 'GetCurrentMetricDataRequest', ], 'output' => [ 'shape' => 'GetCurrentMetricDataResponse', ], 'errors' => [ [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'InternalServiceException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'GetFederationToken' => [ 'name' => 'GetFederationToken', 'http' => [ 'method' => 'GET', 'requestUri' => '/user/federate/{InstanceId}', ], 'input' => [ 'shape' => 'GetFederationTokenRequest', ], 'output' => [ 'shape' => 'GetFederationTokenResponse', ], 'errors' => [ [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'UserNotFoundException', ], [ 'shape' => 'InternalServiceException', ], [ 'shape' => 'DuplicateResourceException', ], ], ], 'GetMetricData' => [ 'name' => 'GetMetricData', 'http' => [ 'method' => 'POST', 'requestUri' => '/metrics/historical/{InstanceId}', ], 'input' => [ 'shape' => 'GetMetricDataRequest', ], 'output' => [ 'shape' => 'GetMetricDataResponse', ], 'errors' => [ [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'InternalServiceException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'ListContactFlows' => [ 'name' => 'ListContactFlows', 'http' => [ 'method' => 'GET', 'requestUri' => '/contact-flows-summary/{InstanceId}', ], 'input' => [ 'shape' => 'ListContactFlowsRequest', ], 'output' => [ 'shape' => 'ListContactFlowsResponse', ], 'errors' => [ [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServiceException', ], ], ], 'ListHoursOfOperations' => [ 'name' => 'ListHoursOfOperations', 'http' => [ 'method' => 'GET', 'requestUri' => '/hours-of-operations-summary/{InstanceId}', ], 'input' => [ 'shape' => 'ListHoursOfOperationsRequest', ], 'output' => [ 'shape' => 'ListHoursOfOperationsResponse', ], 'errors' => [ [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServiceException', ], ], ], 'ListPhoneNumbers' => [ 'name' => 'ListPhoneNumbers', 'http' => [ 'method' => 'GET', 'requestUri' => '/phone-numbers-summary/{InstanceId}', ], 'input' => [ 'shape' => 'ListPhoneNumbersRequest', ], 'output' => [ 'shape' => 'ListPhoneNumbersResponse', ], 'errors' => [ [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServiceException', ], ], ], 'ListPrompts' => [ 'name' => 'ListPrompts', 'http' => [ 'method' => 'GET', 'requestUri' => '/prompts-summary/{InstanceId}', ], 'input' => [ 'shape' => 'ListPromptsRequest', ], 'output' => [ 'shape' => 'ListPromptsResponse', ], 'errors' => [ [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServiceException', ], ], ], 'ListQueues' => [ 'name' => 'ListQueues', 'http' => [ 'method' => 'GET', 'requestUri' => '/queues-summary/{InstanceId}', ], 'input' => [ 'shape' => 'ListQueuesRequest', ], 'output' => [ 'shape' => 'ListQueuesResponse', ], 'errors' => [ [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServiceException', ], ], ], 'ListRoutingProfileQueues' => [ 'name' => 'ListRoutingProfileQueues', 'http' => [ 'method' => 'GET', 'requestUri' => '/routing-profiles/{InstanceId}/{RoutingProfileId}/queues', ], 'input' => [ 'shape' => 'ListRoutingProfileQueuesRequest', ], 'output' => [ 'shape' => 'ListRoutingProfileQueuesResponse', ], 'errors' => [ [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServiceException', ], ], ], 'ListRoutingProfiles' => [ 'name' => 'ListRoutingProfiles', 'http' => [ 'method' => 'GET', 'requestUri' => '/routing-profiles-summary/{InstanceId}', ], 'input' => [ 'shape' => 'ListRoutingProfilesRequest', ], 'output' => [ 'shape' => 'ListRoutingProfilesResponse', ], 'errors' => [ [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServiceException', ], ], ], 'ListSecurityProfiles' => [ 'name' => 'ListSecurityProfiles', 'http' => [ 'method' => 'GET', 'requestUri' => '/security-profiles-summary/{InstanceId}', ], 'input' => [ 'shape' => 'ListSecurityProfilesRequest', ], 'output' => [ 'shape' => 'ListSecurityProfilesResponse', ], 'errors' => [ [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServiceException', ], ], ], 'ListTagsForResource' => [ 'name' => 'ListTagsForResource', 'http' => [ 'method' => 'GET', 'requestUri' => '/tags/{resourceArn}', ], 'input' => [ 'shape' => 'ListTagsForResourceRequest', ], 'output' => [ 'shape' => 'ListTagsForResourceResponse', ], 'errors' => [ [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'InternalServiceException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'ListUserHierarchyGroups' => [ 'name' => 'ListUserHierarchyGroups', 'http' => [ 'method' => 'GET', 'requestUri' => '/user-hierarchy-groups-summary/{InstanceId}', ], 'input' => [ 'shape' => 'ListUserHierarchyGroupsRequest', ], 'output' => [ 'shape' => 'ListUserHierarchyGroupsResponse', ], 'errors' => [ [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServiceException', ], ], ], 'ListUsers' => [ 'name' => 'ListUsers', 'http' => [ 'method' => 'GET', 'requestUri' => '/users-summary/{InstanceId}', ], 'input' => [ 'shape' => 'ListUsersRequest', ], 'output' => [ 'shape' => 'ListUsersResponse', ], 'errors' => [ [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServiceException', ], ], ], 'ResumeContactRecording' => [ 'name' => 'ResumeContactRecording', 'http' => [ 'method' => 'POST', 'requestUri' => '/contact/resume-recording', ], 'input' => [ 'shape' => 'ResumeContactRecordingRequest', ], 'output' => [ 'shape' => 'ResumeContactRecordingResponse', ], 'errors' => [ [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServiceException', ], ], ], 'StartChatContact' => [ 'name' => 'StartChatContact', 'http' => [ 'method' => 'PUT', 'requestUri' => '/contact/chat', ], 'input' => [ 'shape' => 'StartChatContactRequest', ], 'output' => [ 'shape' => 'StartChatContactResponse', ], 'errors' => [ [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServiceException', ], [ 'shape' => 'LimitExceededException', ], ], ], 'StartContactRecording' => [ 'name' => 'StartContactRecording', 'http' => [ 'method' => 'POST', 'requestUri' => '/contact/start-recording', ], 'input' => [ 'shape' => 'StartContactRecordingRequest', ], 'output' => [ 'shape' => 'StartContactRecordingResponse', ], 'errors' => [ [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServiceException', ], ], ], 'StartOutboundVoiceContact' => [ 'name' => 'StartOutboundVoiceContact', 'http' => [ 'method' => 'PUT', 'requestUri' => '/contact/outbound-voice', ], 'input' => [ 'shape' => 'StartOutboundVoiceContactRequest', ], 'output' => [ 'shape' => 'StartOutboundVoiceContactResponse', ], 'errors' => [ [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServiceException', ], [ 'shape' => 'LimitExceededException', ], [ 'shape' => 'DestinationNotAllowedException', ], [ 'shape' => 'OutboundContactNotPermittedException', ], ], ], 'StopContact' => [ 'name' => 'StopContact', 'http' => [ 'method' => 'POST', 'requestUri' => '/contact/stop', ], 'input' => [ 'shape' => 'StopContactRequest', ], 'output' => [ 'shape' => 'StopContactResponse', ], 'errors' => [ [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'ContactNotFoundException', ], [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServiceException', ], ], ], 'StopContactRecording' => [ 'name' => 'StopContactRecording', 'http' => [ 'method' => 'POST', 'requestUri' => '/contact/stop-recording', ], 'input' => [ 'shape' => 'StopContactRecordingRequest', ], 'output' => [ 'shape' => 'StopContactRecordingResponse', ], 'errors' => [ [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServiceException', ], ], ], 'SuspendContactRecording' => [ 'name' => 'SuspendContactRecording', 'http' => [ 'method' => 'POST', 'requestUri' => '/contact/suspend-recording', ], 'input' => [ 'shape' => 'SuspendContactRecordingRequest', ], 'output' => [ 'shape' => 'SuspendContactRecordingResponse', ], 'errors' => [ [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServiceException', ], ], ], 'TagResource' => [ 'name' => 'TagResource', 'http' => [ 'method' => 'POST', 'requestUri' => '/tags/{resourceArn}', ], 'input' => [ 'shape' => 'TagResourceRequest', ], 'errors' => [ [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'InternalServiceException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'UntagResource' => [ 'name' => 'UntagResource', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/tags/{resourceArn}', ], 'input' => [ 'shape' => 'UntagResourceRequest', ], 'errors' => [ [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'InternalServiceException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'UpdateContactAttributes' => [ 'name' => 'UpdateContactAttributes', 'http' => [ 'method' => 'POST', 'requestUri' => '/contact/attributes', ], 'input' => [ 'shape' => 'UpdateContactAttributesRequest', ], 'output' => [ 'shape' => 'UpdateContactAttributesResponse', ], 'errors' => [ [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServiceException', ], ], ], 'UpdateContactFlowContent' => [ 'name' => 'UpdateContactFlowContent', 'http' => [ 'method' => 'POST', 'requestUri' => '/contact-flows/{InstanceId}/{ContactFlowId}/content', ], 'input' => [ 'shape' => 'UpdateContactFlowContentRequest', ], 'errors' => [ [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'InvalidContactFlowException', ], [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServiceException', ], ], ], 'UpdateContactFlowName' => [ 'name' => 'UpdateContactFlowName', 'http' => [ 'method' => 'POST', 'requestUri' => '/contact-flows/{InstanceId}/{ContactFlowId}/name', ], 'input' => [ 'shape' => 'UpdateContactFlowNameRequest', ], 'errors' => [ [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'DuplicateResourceException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServiceException', ], ], ], 'UpdateRoutingProfileConcurrency' => [ 'name' => 'UpdateRoutingProfileConcurrency', 'http' => [ 'method' => 'POST', 'requestUri' => '/routing-profiles/{InstanceId}/{RoutingProfileId}/concurrency', ], 'input' => [ 'shape' => 'UpdateRoutingProfileConcurrencyRequest', ], 'errors' => [ [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServiceException', ], ], ], 'UpdateRoutingProfileDefaultOutboundQueue' => [ 'name' => 'UpdateRoutingProfileDefaultOutboundQueue', 'http' => [ 'method' => 'POST', 'requestUri' => '/routing-profiles/{InstanceId}/{RoutingProfileId}/default-outbound-queue', ], 'input' => [ 'shape' => 'UpdateRoutingProfileDefaultOutboundQueueRequest', ], 'errors' => [ [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServiceException', ], ], ], 'UpdateRoutingProfileName' => [ 'name' => 'UpdateRoutingProfileName', 'http' => [ 'method' => 'POST', 'requestUri' => '/routing-profiles/{InstanceId}/{RoutingProfileId}/name', ], 'input' => [ 'shape' => 'UpdateRoutingProfileNameRequest', ], 'errors' => [ [ 'shape' => 'DuplicateResourceException', ], [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServiceException', ], ], ], 'UpdateRoutingProfileQueues' => [ 'name' => 'UpdateRoutingProfileQueues', 'http' => [ 'method' => 'POST', 'requestUri' => '/routing-profiles/{InstanceId}/{RoutingProfileId}/queues', ], 'input' => [ 'shape' => 'UpdateRoutingProfileQueuesRequest', ], 'errors' => [ [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServiceException', ], ], ], 'UpdateUserHierarchy' => [ 'name' => 'UpdateUserHierarchy', 'http' => [ 'method' => 'POST', 'requestUri' => '/users/{InstanceId}/{UserId}/hierarchy', ], 'input' => [ 'shape' => 'UpdateUserHierarchyRequest', ], 'errors' => [ [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServiceException', ], ], ], 'UpdateUserHierarchyGroupName' => [ 'name' => 'UpdateUserHierarchyGroupName', 'http' => [ 'method' => 'POST', 'requestUri' => '/user-hierarchy-groups/{InstanceId}/{HierarchyGroupId}/name', ], 'input' => [ 'shape' => 'UpdateUserHierarchyGroupNameRequest', ], 'errors' => [ [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'DuplicateResourceException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServiceException', ], ], ], 'UpdateUserHierarchyStructure' => [ 'name' => 'UpdateUserHierarchyStructure', 'http' => [ 'method' => 'POST', 'requestUri' => '/user-hierarchy-structure/{InstanceId}', ], 'input' => [ 'shape' => 'UpdateUserHierarchyStructureRequest', ], 'errors' => [ [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ResourceInUseException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServiceException', ], ], ], 'UpdateUserIdentityInfo' => [ 'name' => 'UpdateUserIdentityInfo', 'http' => [ 'method' => 'POST', 'requestUri' => '/users/{InstanceId}/{UserId}/identity-info', ], 'input' => [ 'shape' => 'UpdateUserIdentityInfoRequest', ], 'errors' => [ [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServiceException', ], ], ], 'UpdateUserPhoneConfig' => [ 'name' => 'UpdateUserPhoneConfig', 'http' => [ 'method' => 'POST', 'requestUri' => '/users/{InstanceId}/{UserId}/phone-config', ], 'input' => [ 'shape' => 'UpdateUserPhoneConfigRequest', ], 'errors' => [ [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServiceException', ], ], ], 'UpdateUserRoutingProfile' => [ 'name' => 'UpdateUserRoutingProfile', 'http' => [ 'method' => 'POST', 'requestUri' => '/users/{InstanceId}/{UserId}/routing-profile', ], 'input' => [ 'shape' => 'UpdateUserRoutingProfileRequest', ], 'errors' => [ [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServiceException', ], ], ], 'UpdateUserSecurityProfiles' => [ 'name' => 'UpdateUserSecurityProfiles', 'http' => [ 'method' => 'POST', 'requestUri' => '/users/{InstanceId}/{UserId}/security-profiles', ], 'input' => [ 'shape' => 'UpdateUserSecurityProfilesRequest', ], 'errors' => [ [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServiceException', ], ], ], ], 'shapes' => [ 'ARN' => [ 'type' => 'string', ], 'AfterContactWorkTimeLimit' => [ 'type' => 'integer', 'min' => 0, ], 'AgentFirstName' => [ 'type' => 'string', 'max' => 100, 'min' => 1, ], 'AgentLastName' => [ 'type' => 'string', 'max' => 100, 'min' => 1, ], 'AgentUsername' => [ 'type' => 'string', 'max' => 100, 'min' => 1, ], 'AssociateRoutingProfileQueuesRequest' => [ 'type' => 'structure', 'required' => [ 'InstanceId', 'RoutingProfileId', 'QueueConfigs', ], 'members' => [ 'InstanceId' => [ 'shape' => 'InstanceId', 'location' => 'uri', 'locationName' => 'InstanceId', ], 'RoutingProfileId' => [ 'shape' => 'RoutingProfileId', 'location' => 'uri', 'locationName' => 'RoutingProfileId', ], 'QueueConfigs' => [ 'shape' => 'RoutingProfileQueueConfigList', ], ], ], 'AttributeName' => [ 'type' => 'string', 'max' => 32767, 'min' => 1, ], 'AttributeValue' => [ 'type' => 'string', 'max' => 32767, 'min' => 0, ], 'Attributes' => [ 'type' => 'map', 'key' => [ 'shape' => 'AttributeName', ], 'value' => [ 'shape' => 'AttributeValue', ], ], 'AutoAccept' => [ 'type' => 'boolean', ], 'Channel' => [ 'type' => 'string', 'enum' => [ 'VOICE', 'CHAT', ], ], 'Channels' => [ 'type' => 'list', 'member' => [ 'shape' => 'Channel', ], 'max' => 1, ], 'ChatContent' => [ 'type' => 'string', 'max' => 1024, 'min' => 1, ], 'ChatContentType' => [ 'type' => 'string', 'max' => 100, 'min' => 1, ], 'ChatMessage' => [ 'type' => 'structure', 'required' => [ 'ContentType', 'Content', ], 'members' => [ 'ContentType' => [ 'shape' => 'ChatContentType', ], 'Content' => [ 'shape' => 'ChatContent', ], ], ], 'ClientToken' => [ 'type' => 'string', 'max' => 500, ], 'Comparison' => [ 'type' => 'string', 'enum' => [ 'LT', ], ], 'Concurrency' => [ 'type' => 'integer', 'max' => 5, 'min' => 1, ], 'ContactFlow' => [ 'type' => 'structure', 'members' => [ 'Arn' => [ 'shape' => 'ARN', ], 'Id' => [ 'shape' => 'ContactFlowId', ], 'Name' => [ 'shape' => 'ContactFlowName', ], 'Type' => [ 'shape' => 'ContactFlowType', ], 'Description' => [ 'shape' => 'ContactFlowDescription', ], 'Content' => [ 'shape' => 'ContactFlowContent', ], 'Tags' => [ 'shape' => 'TagMap', ], ], ], 'ContactFlowContent' => [ 'type' => 'string', ], 'ContactFlowDescription' => [ 'type' => 'string', ], 'ContactFlowId' => [ 'type' => 'string', 'max' => 500, ], 'ContactFlowName' => [ 'type' => 'string', 'min' => 1, ], 'ContactFlowNotPublishedException' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'Message', ], ], 'error' => [ 'httpStatusCode' => 404, ], 'exception' => true, ], 'ContactFlowSummary' => [ 'type' => 'structure', 'members' => [ 'Id' => [ 'shape' => 'ContactFlowId', ], 'Arn' => [ 'shape' => 'ARN', ], 'Name' => [ 'shape' => 'ContactFlowName', ], 'ContactFlowType' => [ 'shape' => 'ContactFlowType', ], ], ], 'ContactFlowSummaryList' => [ 'type' => 'list', 'member' => [ 'shape' => 'ContactFlowSummary', ], ], 'ContactFlowType' => [ 'type' => 'string', 'enum' => [ 'CONTACT_FLOW', 'CUSTOMER_QUEUE', 'CUSTOMER_HOLD', 'CUSTOMER_WHISPER', 'AGENT_HOLD', 'AGENT_WHISPER', 'OUTBOUND_WHISPER', 'AGENT_TRANSFER', 'QUEUE_TRANSFER', ], ], 'ContactFlowTypes' => [ 'type' => 'list', 'member' => [ 'shape' => 'ContactFlowType', ], 'max' => 10, ], 'ContactId' => [ 'type' => 'string', 'max' => 256, 'min' => 1, ], 'ContactNotFoundException' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'Message', ], ], 'error' => [ 'httpStatusCode' => 410, ], 'exception' => true, ], 'CreateContactFlowRequest' => [ 'type' => 'structure', 'required' => [ 'InstanceId', 'Name', 'Type', 'Content', ], 'members' => [ 'InstanceId' => [ 'shape' => 'InstanceId', 'location' => 'uri', 'locationName' => 'InstanceId', ], 'Name' => [ 'shape' => 'ContactFlowName', ], 'Type' => [ 'shape' => 'ContactFlowType', ], 'Description' => [ 'shape' => 'ContactFlowDescription', ], 'Content' => [ 'shape' => 'ContactFlowContent', ], 'Tags' => [ 'shape' => 'TagMap', ], ], ], 'CreateContactFlowResponse' => [ 'type' => 'structure', 'members' => [ 'ContactFlowId' => [ 'shape' => 'ContactFlowId', ], 'ContactFlowArn' => [ 'shape' => 'ARN', ], ], ], 'CreateRoutingProfileRequest' => [ 'type' => 'structure', 'required' => [ 'InstanceId', 'Name', 'Description', 'DefaultOutboundQueueId', 'MediaConcurrencies', ], 'members' => [ 'InstanceId' => [ 'shape' => 'InstanceId', 'location' => 'uri', 'locationName' => 'InstanceId', ], 'Name' => [ 'shape' => 'RoutingProfileName', ], 'Description' => [ 'shape' => 'RoutingProfileDescription', ], 'DefaultOutboundQueueId' => [ 'shape' => 'QueueId', ], 'QueueConfigs' => [ 'shape' => 'RoutingProfileQueueConfigList', ], 'MediaConcurrencies' => [ 'shape' => 'MediaConcurrencies', ], 'Tags' => [ 'shape' => 'TagMap', ], ], ], 'CreateRoutingProfileResponse' => [ 'type' => 'structure', 'members' => [ 'RoutingProfileArn' => [ 'shape' => 'ARN', ], 'RoutingProfileId' => [ 'shape' => 'RoutingProfileId', ], ], ], 'CreateUserHierarchyGroupRequest' => [ 'type' => 'structure', 'required' => [ 'Name', 'InstanceId', ], 'members' => [ 'Name' => [ 'shape' => 'HierarchyGroupName', ], 'ParentGroupId' => [ 'shape' => 'HierarchyGroupId', ], 'InstanceId' => [ 'shape' => 'InstanceId', 'location' => 'uri', 'locationName' => 'InstanceId', ], ], ], 'CreateUserHierarchyGroupResponse' => [ 'type' => 'structure', 'members' => [ 'HierarchyGroupId' => [ 'shape' => 'HierarchyGroupId', ], 'HierarchyGroupArn' => [ 'shape' => 'ARN', ], ], ], 'CreateUserRequest' => [ 'type' => 'structure', 'required' => [ 'Username', 'PhoneConfig', 'SecurityProfileIds', 'RoutingProfileId', 'InstanceId', ], 'members' => [ 'Username' => [ 'shape' => 'AgentUsername', ], 'Password' => [ 'shape' => 'Password', ], 'IdentityInfo' => [ 'shape' => 'UserIdentityInfo', ], 'PhoneConfig' => [ 'shape' => 'UserPhoneConfig', ], 'DirectoryUserId' => [ 'shape' => 'DirectoryUserId', ], 'SecurityProfileIds' => [ 'shape' => 'SecurityProfileIds', ], 'RoutingProfileId' => [ 'shape' => 'RoutingProfileId', ], 'HierarchyGroupId' => [ 'shape' => 'HierarchyGroupId', ], 'InstanceId' => [ 'shape' => 'InstanceId', 'location' => 'uri', 'locationName' => 'InstanceId', ], 'Tags' => [ 'shape' => 'TagMap', ], ], ], 'CreateUserResponse' => [ 'type' => 'structure', 'members' => [ 'UserId' => [ 'shape' => 'UserId', ], 'UserArn' => [ 'shape' => 'ARN', ], ], ], 'Credentials' => [ 'type' => 'structure', 'members' => [ 'AccessToken' => [ 'shape' => 'SecurityToken', ], 'AccessTokenExpiration' => [ 'shape' => 'timestamp', ], 'RefreshToken' => [ 'shape' => 'SecurityToken', ], 'RefreshTokenExpiration' => [ 'shape' => 'timestamp', ], ], ], 'CurrentMetric' => [ 'type' => 'structure', 'members' => [ 'Name' => [ 'shape' => 'CurrentMetricName', ], 'Unit' => [ 'shape' => 'Unit', ], ], ], 'CurrentMetricData' => [ 'type' => 'structure', 'members' => [ 'Metric' => [ 'shape' => 'CurrentMetric', ], 'Value' => [ 'shape' => 'Value', 'box' => true, ], ], ], 'CurrentMetricDataCollections' => [ 'type' => 'list', 'member' => [ 'shape' => 'CurrentMetricData', ], ], 'CurrentMetricName' => [ 'type' => 'string', 'enum' => [ 'AGENTS_ONLINE', 'AGENTS_AVAILABLE', 'AGENTS_ON_CALL', 'AGENTS_NON_PRODUCTIVE', 'AGENTS_AFTER_CONTACT_WORK', 'AGENTS_ERROR', 'AGENTS_STAFFED', 'CONTACTS_IN_QUEUE', 'OLDEST_CONTACT_AGE', 'CONTACTS_SCHEDULED', 'AGENTS_ON_CONTACT', 'SLOTS_ACTIVE', 'SLOTS_AVAILABLE', ], ], 'CurrentMetricResult' => [ 'type' => 'structure', 'members' => [ 'Dimensions' => [ 'shape' => 'Dimensions', ], 'Collections' => [ 'shape' => 'CurrentMetricDataCollections', ], ], ], 'CurrentMetricResults' => [ 'type' => 'list', 'member' => [ 'shape' => 'CurrentMetricResult', ], ], 'CurrentMetrics' => [ 'type' => 'list', 'member' => [ 'shape' => 'CurrentMetric', ], ], 'Delay' => [ 'type' => 'integer', 'max' => 9999, 'min' => 0, ], 'DeleteUserHierarchyGroupRequest' => [ 'type' => 'structure', 'required' => [ 'HierarchyGroupId', 'InstanceId', ], 'members' => [ 'HierarchyGroupId' => [ 'shape' => 'HierarchyGroupId', 'location' => 'uri', 'locationName' => 'HierarchyGroupId', ], 'InstanceId' => [ 'shape' => 'InstanceId', 'location' => 'uri', 'locationName' => 'InstanceId', ], ], ], 'DeleteUserRequest' => [ 'type' => 'structure', 'required' => [ 'InstanceId', 'UserId', ], 'members' => [ 'InstanceId' => [ 'shape' => 'InstanceId', 'location' => 'uri', 'locationName' => 'InstanceId', ], 'UserId' => [ 'shape' => 'UserId', 'location' => 'uri', 'locationName' => 'UserId', ], ], ], 'DescribeContactFlowRequest' => [ 'type' => 'structure', 'required' => [ 'InstanceId', 'ContactFlowId', ], 'members' => [ 'InstanceId' => [ 'shape' => 'InstanceId', 'location' => 'uri', 'locationName' => 'InstanceId', ], 'ContactFlowId' => [ 'shape' => 'ContactFlowId', 'location' => 'uri', 'locationName' => 'ContactFlowId', ], ], ], 'DescribeContactFlowResponse' => [ 'type' => 'structure', 'members' => [ 'ContactFlow' => [ 'shape' => 'ContactFlow', ], ], ], 'DescribeRoutingProfileRequest' => [ 'type' => 'structure', 'required' => [ 'InstanceId', 'RoutingProfileId', ], 'members' => [ 'InstanceId' => [ 'shape' => 'InstanceId', 'location' => 'uri', 'locationName' => 'InstanceId', ], 'RoutingProfileId' => [ 'shape' => 'RoutingProfileId', 'location' => 'uri', 'locationName' => 'RoutingProfileId', ], ], ], 'DescribeRoutingProfileResponse' => [ 'type' => 'structure', 'members' => [ 'RoutingProfile' => [ 'shape' => 'RoutingProfile', ], ], ], 'DescribeUserHierarchyGroupRequest' => [ 'type' => 'structure', 'required' => [ 'HierarchyGroupId', 'InstanceId', ], 'members' => [ 'HierarchyGroupId' => [ 'shape' => 'HierarchyGroupId', 'location' => 'uri', 'locationName' => 'HierarchyGroupId', ], 'InstanceId' => [ 'shape' => 'InstanceId', 'location' => 'uri', 'locationName' => 'InstanceId', ], ], ], 'DescribeUserHierarchyGroupResponse' => [ 'type' => 'structure', 'members' => [ 'HierarchyGroup' => [ 'shape' => 'HierarchyGroup', ], ], ], 'DescribeUserHierarchyStructureRequest' => [ 'type' => 'structure', 'required' => [ 'InstanceId', ], 'members' => [ 'InstanceId' => [ 'shape' => 'InstanceId', 'location' => 'uri', 'locationName' => 'InstanceId', ], ], ], 'DescribeUserHierarchyStructureResponse' => [ 'type' => 'structure', 'members' => [ 'HierarchyStructure' => [ 'shape' => 'HierarchyStructure', ], ], ], 'DescribeUserRequest' => [ 'type' => 'structure', 'required' => [ 'UserId', 'InstanceId', ], 'members' => [ 'UserId' => [ 'shape' => 'UserId', 'location' => 'uri', 'locationName' => 'UserId', ], 'InstanceId' => [ 'shape' => 'InstanceId', 'location' => 'uri', 'locationName' => 'InstanceId', ], ], ], 'DescribeUserResponse' => [ 'type' => 'structure', 'members' => [ 'User' => [ 'shape' => 'User', ], ], ], 'DestinationNotAllowedException' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'Message', ], ], 'error' => [ 'httpStatusCode' => 403, ], 'exception' => true, ], 'Dimensions' => [ 'type' => 'structure', 'members' => [ 'Queue' => [ 'shape' => 'QueueReference', ], 'Channel' => [ 'shape' => 'Channel', ], ], ], 'DirectoryUserId' => [ 'type' => 'string', ], 'DisassociateRoutingProfileQueuesRequest' => [ 'type' => 'structure', 'required' => [ 'InstanceId', 'RoutingProfileId', 'QueueReferences', ], 'members' => [ 'InstanceId' => [ 'shape' => 'InstanceId', 'location' => 'uri', 'locationName' => 'InstanceId', ], 'RoutingProfileId' => [ 'shape' => 'RoutingProfileId', 'location' => 'uri', 'locationName' => 'RoutingProfileId', ], 'QueueReferences' => [ 'shape' => 'RoutingProfileQueueReferenceList', ], ], ], 'DisplayName' => [ 'type' => 'string', 'max' => 256, 'min' => 1, ], 'DuplicateResourceException' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'Message', ], ], 'error' => [ 'httpStatusCode' => 409, ], 'exception' => true, ], 'Email' => [ 'type' => 'string', ], 'Filters' => [ 'type' => 'structure', 'members' => [ 'Queues' => [ 'shape' => 'Queues', ], 'Channels' => [ 'shape' => 'Channels', ], ], ], 'GetContactAttributesRequest' => [ 'type' => 'structure', 'required' => [ 'InstanceId', 'InitialContactId', ], 'members' => [ 'InstanceId' => [ 'shape' => 'InstanceId', 'location' => 'uri', 'locationName' => 'InstanceId', ], 'InitialContactId' => [ 'shape' => 'ContactId', 'location' => 'uri', 'locationName' => 'InitialContactId', ], ], ], 'GetContactAttributesResponse' => [ 'type' => 'structure', 'members' => [ 'Attributes' => [ 'shape' => 'Attributes', ], ], ], 'GetCurrentMetricDataRequest' => [ 'type' => 'structure', 'required' => [ 'InstanceId', 'Filters', 'CurrentMetrics', ], 'members' => [ 'InstanceId' => [ 'shape' => 'InstanceId', 'location' => 'uri', 'locationName' => 'InstanceId', ], 'Filters' => [ 'shape' => 'Filters', ], 'Groupings' => [ 'shape' => 'Groupings', ], 'CurrentMetrics' => [ 'shape' => 'CurrentMetrics', ], 'NextToken' => [ 'shape' => 'NextToken', ], 'MaxResults' => [ 'shape' => 'MaxResult100', 'box' => true, ], ], ], 'GetCurrentMetricDataResponse' => [ 'type' => 'structure', 'members' => [ 'NextToken' => [ 'shape' => 'NextToken', ], 'MetricResults' => [ 'shape' => 'CurrentMetricResults', ], 'DataSnapshotTime' => [ 'shape' => 'timestamp', ], ], ], 'GetFederationTokenRequest' => [ 'type' => 'structure', 'required' => [ 'InstanceId', ], 'members' => [ 'InstanceId' => [ 'shape' => 'InstanceId', 'location' => 'uri', 'locationName' => 'InstanceId', ], ], ], 'GetFederationTokenResponse' => [ 'type' => 'structure', 'members' => [ 'Credentials' => [ 'shape' => 'Credentials', ], ], ], 'GetMetricDataRequest' => [ 'type' => 'structure', 'required' => [ 'InstanceId', 'StartTime', 'EndTime', 'Filters', 'HistoricalMetrics', ], 'members' => [ 'InstanceId' => [ 'shape' => 'InstanceId', 'location' => 'uri', 'locationName' => 'InstanceId', ], 'StartTime' => [ 'shape' => 'timestamp', ], 'EndTime' => [ 'shape' => 'timestamp', ], 'Filters' => [ 'shape' => 'Filters', ], 'Groupings' => [ 'shape' => 'Groupings', ], 'HistoricalMetrics' => [ 'shape' => 'HistoricalMetrics', ], 'NextToken' => [ 'shape' => 'NextToken', ], 'MaxResults' => [ 'shape' => 'MaxResult100', 'box' => true, ], ], ], 'GetMetricDataResponse' => [ 'type' => 'structure', 'members' => [ 'NextToken' => [ 'shape' => 'NextToken', ], 'MetricResults' => [ 'shape' => 'HistoricalMetricResults', ], ], ], 'Grouping' => [ 'type' => 'string', 'enum' => [ 'QUEUE', 'CHANNEL', ], ], 'Groupings' => [ 'type' => 'list', 'member' => [ 'shape' => 'Grouping', ], 'max' => 2, ], 'HierarchyGroup' => [ 'type' => 'structure', 'members' => [ 'Id' => [ 'shape' => 'HierarchyGroupId', ], 'Arn' => [ 'shape' => 'ARN', ], 'Name' => [ 'shape' => 'HierarchyGroupName', ], 'LevelId' => [ 'shape' => 'HierarchyLevelId', ], 'HierarchyPath' => [ 'shape' => 'HierarchyPath', ], ], ], 'HierarchyGroupId' => [ 'type' => 'string', ], 'HierarchyGroupName' => [ 'type' => 'string', ], 'HierarchyGroupSummary' => [ 'type' => 'structure', 'members' => [ 'Id' => [ 'shape' => 'HierarchyGroupId', ], 'Arn' => [ 'shape' => 'ARN', ], 'Name' => [ 'shape' => 'HierarchyGroupName', ], ], ], 'HierarchyGroupSummaryList' => [ 'type' => 'list', 'member' => [ 'shape' => 'HierarchyGroupSummary', ], ], 'HierarchyLevel' => [ 'type' => 'structure', 'members' => [ 'Id' => [ 'shape' => 'HierarchyLevelId', ], 'Arn' => [ 'shape' => 'ARN', ], 'Name' => [ 'shape' => 'HierarchyLevelName', ], ], ], 'HierarchyLevelId' => [ 'type' => 'string', ], 'HierarchyLevelName' => [ 'type' => 'string', ], 'HierarchyLevelUpdate' => [ 'type' => 'structure', 'required' => [ 'Name', ], 'members' => [ 'Name' => [ 'shape' => 'HierarchyLevelName', ], ], ], 'HierarchyPath' => [ 'type' => 'structure', 'members' => [ 'LevelOne' => [ 'shape' => 'HierarchyGroupSummary', ], 'LevelTwo' => [ 'shape' => 'HierarchyGroupSummary', ], 'LevelThree' => [ 'shape' => 'HierarchyGroupSummary', ], 'LevelFour' => [ 'shape' => 'HierarchyGroupSummary', ], 'LevelFive' => [ 'shape' => 'HierarchyGroupSummary', ], ], ], 'HierarchyStructure' => [ 'type' => 'structure', 'members' => [ 'LevelOne' => [ 'shape' => 'HierarchyLevel', ], 'LevelTwo' => [ 'shape' => 'HierarchyLevel', ], 'LevelThree' => [ 'shape' => 'HierarchyLevel', ], 'LevelFour' => [ 'shape' => 'HierarchyLevel', ], 'LevelFive' => [ 'shape' => 'HierarchyLevel', ], ], ], 'HierarchyStructureUpdate' => [ 'type' => 'structure', 'members' => [ 'LevelOne' => [ 'shape' => 'HierarchyLevelUpdate', ], 'LevelTwo' => [ 'shape' => 'HierarchyLevelUpdate', ], 'LevelThree' => [ 'shape' => 'HierarchyLevelUpdate', ], 'LevelFour' => [ 'shape' => 'HierarchyLevelUpdate', ], 'LevelFive' => [ 'shape' => 'HierarchyLevelUpdate', ], ], ], 'HistoricalMetric' => [ 'type' => 'structure', 'members' => [ 'Name' => [ 'shape' => 'HistoricalMetricName', ], 'Threshold' => [ 'shape' => 'Threshold', 'box' => true, ], 'Statistic' => [ 'shape' => 'Statistic', ], 'Unit' => [ 'shape' => 'Unit', ], ], ], 'HistoricalMetricData' => [ 'type' => 'structure', 'members' => [ 'Metric' => [ 'shape' => 'HistoricalMetric', ], 'Value' => [ 'shape' => 'Value', 'box' => true, ], ], ], 'HistoricalMetricDataCollections' => [ 'type' => 'list', 'member' => [ 'shape' => 'HistoricalMetricData', ], ], 'HistoricalMetricName' => [ 'type' => 'string', 'enum' => [ 'CONTACTS_QUEUED', 'CONTACTS_HANDLED', 'CONTACTS_ABANDONED', 'CONTACTS_CONSULTED', 'CONTACTS_AGENT_HUNG_UP_FIRST', 'CONTACTS_HANDLED_INCOMING', 'CONTACTS_HANDLED_OUTBOUND', 'CONTACTS_HOLD_ABANDONS', 'CONTACTS_TRANSFERRED_IN', 'CONTACTS_TRANSFERRED_OUT', 'CONTACTS_TRANSFERRED_IN_FROM_QUEUE', 'CONTACTS_TRANSFERRED_OUT_FROM_QUEUE', 'CONTACTS_MISSED', 'CALLBACK_CONTACTS_HANDLED', 'API_CONTACTS_HANDLED', 'OCCUPANCY', 'HANDLE_TIME', 'AFTER_CONTACT_WORK_TIME', 'QUEUED_TIME', 'ABANDON_TIME', 'QUEUE_ANSWER_TIME', 'HOLD_TIME', 'INTERACTION_TIME', 'INTERACTION_AND_HOLD_TIME', 'SERVICE_LEVEL', ], ], 'HistoricalMetricResult' => [ 'type' => 'structure', 'members' => [ 'Dimensions' => [ 'shape' => 'Dimensions', ], 'Collections' => [ 'shape' => 'HistoricalMetricDataCollections', ], ], ], 'HistoricalMetricResults' => [ 'type' => 'list', 'member' => [ 'shape' => 'HistoricalMetricResult', ], ], 'HistoricalMetrics' => [ 'type' => 'list', 'member' => [ 'shape' => 'HistoricalMetric', ], ], 'HoursOfOperationId' => [ 'type' => 'string', ], 'HoursOfOperationName' => [ 'type' => 'string', ], 'HoursOfOperationSummary' => [ 'type' => 'structure', 'members' => [ 'Id' => [ 'shape' => 'HoursOfOperationId', ], 'Arn' => [ 'shape' => 'ARN', ], 'Name' => [ 'shape' => 'HoursOfOperationName', ], ], ], 'HoursOfOperationSummaryList' => [ 'type' => 'list', 'member' => [ 'shape' => 'HoursOfOperationSummary', ], ], 'InstanceId' => [ 'type' => 'string', 'max' => 100, 'min' => 1, ], 'InternalServiceException' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'Message', ], ], 'error' => [ 'httpStatusCode' => 500, ], 'exception' => true, ], 'InvalidContactFlowException' => [ 'type' => 'structure', 'members' => [ 'problems' => [ 'shape' => 'Problems', ], ], 'error' => [ 'httpStatusCode' => 400, ], 'exception' => true, ], 'InvalidParameterException' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'Message', ], ], 'error' => [ 'httpStatusCode' => 400, ], 'exception' => true, ], 'InvalidRequestException' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'Message', ], ], 'error' => [ 'httpStatusCode' => 400, ], 'exception' => true, ], 'LimitExceededException' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'Message', ], ], 'error' => [ 'httpStatusCode' => 429, ], 'exception' => true, ], 'ListContactFlowsRequest' => [ 'type' => 'structure', 'required' => [ 'InstanceId', ], 'members' => [ 'InstanceId' => [ 'shape' => 'InstanceId', 'location' => 'uri', 'locationName' => 'InstanceId', ], 'ContactFlowTypes' => [ 'shape' => 'ContactFlowTypes', 'location' => 'querystring', 'locationName' => 'contactFlowTypes', ], 'NextToken' => [ 'shape' => 'NextToken', 'location' => 'querystring', 'locationName' => 'nextToken', ], 'MaxResults' => [ 'shape' => 'MaxResult1000', 'location' => 'querystring', 'locationName' => 'maxResults', ], ], ], 'ListContactFlowsResponse' => [ 'type' => 'structure', 'members' => [ 'ContactFlowSummaryList' => [ 'shape' => 'ContactFlowSummaryList', ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListHoursOfOperationsRequest' => [ 'type' => 'structure', 'required' => [ 'InstanceId', ], 'members' => [ 'InstanceId' => [ 'shape' => 'InstanceId', 'location' => 'uri', 'locationName' => 'InstanceId', ], 'NextToken' => [ 'shape' => 'NextToken', 'location' => 'querystring', 'locationName' => 'nextToken', ], 'MaxResults' => [ 'shape' => 'MaxResult1000', 'location' => 'querystring', 'locationName' => 'maxResults', ], ], ], 'ListHoursOfOperationsResponse' => [ 'type' => 'structure', 'members' => [ 'HoursOfOperationSummaryList' => [ 'shape' => 'HoursOfOperationSummaryList', ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListPhoneNumbersRequest' => [ 'type' => 'structure', 'required' => [ 'InstanceId', ], 'members' => [ 'InstanceId' => [ 'shape' => 'InstanceId', 'location' => 'uri', 'locationName' => 'InstanceId', ], 'PhoneNumberTypes' => [ 'shape' => 'PhoneNumberTypes', 'location' => 'querystring', 'locationName' => 'phoneNumberTypes', ], 'PhoneNumberCountryCodes' => [ 'shape' => 'PhoneNumberCountryCodes', 'location' => 'querystring', 'locationName' => 'phoneNumberCountryCodes', ], 'NextToken' => [ 'shape' => 'NextToken', 'location' => 'querystring', 'locationName' => 'nextToken', ], 'MaxResults' => [ 'shape' => 'MaxResult1000', 'location' => 'querystring', 'locationName' => 'maxResults', ], ], ], 'ListPhoneNumbersResponse' => [ 'type' => 'structure', 'members' => [ 'PhoneNumberSummaryList' => [ 'shape' => 'PhoneNumberSummaryList', ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListPromptsRequest' => [ 'type' => 'structure', 'required' => [ 'InstanceId', ], 'members' => [ 'InstanceId' => [ 'shape' => 'InstanceId', 'location' => 'uri', 'locationName' => 'InstanceId', ], 'NextToken' => [ 'shape' => 'NextToken', 'location' => 'querystring', 'locationName' => 'nextToken', ], 'MaxResults' => [ 'shape' => 'MaxResult1000', 'box' => true, 'location' => 'querystring', 'locationName' => 'maxResults', ], ], ], 'ListPromptsResponse' => [ 'type' => 'structure', 'members' => [ 'PromptSummaryList' => [ 'shape' => 'PromptSummaryList', ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListQueuesRequest' => [ 'type' => 'structure', 'required' => [ 'InstanceId', ], 'members' => [ 'InstanceId' => [ 'shape' => 'InstanceId', 'location' => 'uri', 'locationName' => 'InstanceId', ], 'QueueTypes' => [ 'shape' => 'QueueTypes', 'location' => 'querystring', 'locationName' => 'queueTypes', ], 'NextToken' => [ 'shape' => 'NextToken', 'location' => 'querystring', 'locationName' => 'nextToken', ], 'MaxResults' => [ 'shape' => 'MaxResult1000', 'location' => 'querystring', 'locationName' => 'maxResults', ], ], ], 'ListQueuesResponse' => [ 'type' => 'structure', 'members' => [ 'QueueSummaryList' => [ 'shape' => 'QueueSummaryList', ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListRoutingProfileQueuesRequest' => [ 'type' => 'structure', 'required' => [ 'InstanceId', 'RoutingProfileId', ], 'members' => [ 'InstanceId' => [ 'shape' => 'InstanceId', 'location' => 'uri', 'locationName' => 'InstanceId', ], 'RoutingProfileId' => [ 'shape' => 'RoutingProfileId', 'location' => 'uri', 'locationName' => 'RoutingProfileId', ], 'NextToken' => [ 'shape' => 'NextToken', 'location' => 'querystring', 'locationName' => 'nextToken', ], 'MaxResults' => [ 'shape' => 'MaxResult100', 'box' => true, 'location' => 'querystring', 'locationName' => 'maxResults', ], ], ], 'ListRoutingProfileQueuesResponse' => [ 'type' => 'structure', 'members' => [ 'NextToken' => [ 'shape' => 'NextToken', ], 'RoutingProfileQueueConfigSummaryList' => [ 'shape' => 'RoutingProfileQueueConfigSummaryList', ], ], ], 'ListRoutingProfilesRequest' => [ 'type' => 'structure', 'required' => [ 'InstanceId', ], 'members' => [ 'InstanceId' => [ 'shape' => 'InstanceId', 'location' => 'uri', 'locationName' => 'InstanceId', ], 'NextToken' => [ 'shape' => 'NextToken', 'location' => 'querystring', 'locationName' => 'nextToken', ], 'MaxResults' => [ 'shape' => 'MaxResult1000', 'box' => true, 'location' => 'querystring', 'locationName' => 'maxResults', ], ], ], 'ListRoutingProfilesResponse' => [ 'type' => 'structure', 'members' => [ 'RoutingProfileSummaryList' => [ 'shape' => 'RoutingProfileSummaryList', ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListSecurityProfilesRequest' => [ 'type' => 'structure', 'required' => [ 'InstanceId', ], 'members' => [ 'InstanceId' => [ 'shape' => 'InstanceId', 'location' => 'uri', 'locationName' => 'InstanceId', ], 'NextToken' => [ 'shape' => 'NextToken', 'location' => 'querystring', 'locationName' => 'nextToken', ], 'MaxResults' => [ 'shape' => 'MaxResult1000', 'box' => true, 'location' => 'querystring', 'locationName' => 'maxResults', ], ], ], 'ListSecurityProfilesResponse' => [ 'type' => 'structure', 'members' => [ 'SecurityProfileSummaryList' => [ 'shape' => 'SecurityProfileSummaryList', ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListTagsForResourceRequest' => [ 'type' => 'structure', 'required' => [ 'resourceArn', ], 'members' => [ 'resourceArn' => [ 'shape' => 'ARN', 'location' => 'uri', 'locationName' => 'resourceArn', ], ], ], 'ListTagsForResourceResponse' => [ 'type' => 'structure', 'members' => [ 'tags' => [ 'shape' => 'TagMap', ], ], ], 'ListUserHierarchyGroupsRequest' => [ 'type' => 'structure', 'required' => [ 'InstanceId', ], 'members' => [ 'InstanceId' => [ 'shape' => 'InstanceId', 'location' => 'uri', 'locationName' => 'InstanceId', ], 'NextToken' => [ 'shape' => 'NextToken', 'location' => 'querystring', 'locationName' => 'nextToken', ], 'MaxResults' => [ 'shape' => 'MaxResult1000', 'box' => true, 'location' => 'querystring', 'locationName' => 'maxResults', ], ], ], 'ListUserHierarchyGroupsResponse' => [ 'type' => 'structure', 'members' => [ 'UserHierarchyGroupSummaryList' => [ 'shape' => 'HierarchyGroupSummaryList', ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListUsersRequest' => [ 'type' => 'structure', 'required' => [ 'InstanceId', ], 'members' => [ 'InstanceId' => [ 'shape' => 'InstanceId', 'location' => 'uri', 'locationName' => 'InstanceId', ], 'NextToken' => [ 'shape' => 'NextToken', 'location' => 'querystring', 'locationName' => 'nextToken', ], 'MaxResults' => [ 'shape' => 'MaxResult1000', 'box' => true, 'location' => 'querystring', 'locationName' => 'maxResults', ], ], ], 'ListUsersResponse' => [ 'type' => 'structure', 'members' => [ 'UserSummaryList' => [ 'shape' => 'UserSummaryList', ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'MaxResult100' => [ 'type' => 'integer', 'max' => 100, 'min' => 1, ], 'MaxResult1000' => [ 'type' => 'integer', 'max' => 1000, 'min' => 1, ], 'MediaConcurrencies' => [ 'type' => 'list', 'member' => [ 'shape' => 'MediaConcurrency', ], ], 'MediaConcurrency' => [ 'type' => 'structure', 'required' => [ 'Channel', 'Concurrency', ], 'members' => [ 'Channel' => [ 'shape' => 'Channel', ], 'Concurrency' => [ 'shape' => 'Concurrency', ], ], ], 'Message' => [ 'type' => 'string', ], 'NextToken' => [ 'type' => 'string', ], 'OutboundContactNotPermittedException' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'Message', ], ], 'error' => [ 'httpStatusCode' => 403, ], 'exception' => true, ], 'ParticipantDetails' => [ 'type' => 'structure', 'required' => [ 'DisplayName', ], 'members' => [ 'DisplayName' => [ 'shape' => 'DisplayName', ], ], ], 'ParticipantId' => [ 'type' => 'string', 'max' => 256, 'min' => 1, ], 'ParticipantToken' => [ 'type' => 'string', 'max' => 1000, 'min' => 1, ], 'Password' => [ 'type' => 'string', 'pattern' => '/^(?=.*[a-z])(?=.*[A-Z])(?=.*\\d)[a-zA-Z\\d\\S]{8,64}$/', ], 'PhoneNumber' => [ 'type' => 'string', ], 'PhoneNumberCountryCode' => [ 'type' => 'string', 'enum' => [ 'AF', 'AL', 'DZ', 'AS', 'AD', 'AO', 'AI', 'AQ', 'AG', 'AR', 'AM', 'AW', 'AU', 'AT', 'AZ', 'BS', 'BH', 'BD', 'BB', 'BY', 'BE', 'BZ', 'BJ', 'BM', 'BT', 'BO', 'BA', 'BW', 'BR', 'IO', 'VG', 'BN', 'BG', 'BF', 'BI', 'KH', 'CM', 'CA', 'CV', 'KY', 'CF', 'TD', 'CL', 'CN', 'CX', 'CC', 'CO', 'KM', 'CK', 'CR', 'HR', 'CU', 'CW', 'CY', 'CZ', 'CD', 'DK', 'DJ', 'DM', 'DO', 'TL', 'EC', 'EG', 'SV', 'GQ', 'ER', 'EE', 'ET', 'FK', 'FO', 'FJ', 'FI', 'FR', 'PF', 'GA', 'GM', 'GE', 'DE', 'GH', 'GI', 'GR', 'GL', 'GD', 'GU', 'GT', 'GG', 'GN', 'GW', 'GY', 'HT', 'HN', 'HK', 'HU', 'IS', 'IN', 'ID', 'IR', 'IQ', 'IE', 'IM', 'IL', 'IT', 'CI', 'JM', 'JP', 'JE', 'JO', 'KZ', 'KE', 'KI', 'KW', 'KG', 'LA', 'LV', 'LB', 'LS', 'LR', 'LY', 'LI', 'LT', 'LU', 'MO', 'MK', 'MG', 'MW', 'MY', 'MV', 'ML', 'MT', 'MH', 'MR', 'MU', 'YT', 'MX', 'FM', 'MD', 'MC', 'MN', 'ME', 'MS', 'MA', 'MZ', 'MM', 'NA', 'NR', 'NP', 'NL', 'AN', 'NC', 'NZ', 'NI', 'NE', 'NG', 'NU', 'KP', 'MP', 'NO', 'OM', 'PK', 'PW', 'PA', 'PG', 'PY', 'PE', 'PH', 'PN', 'PL', 'PT', 'PR', 'QA', 'CG', 'RE', 'RO', 'RU', 'RW', 'BL', 'SH', 'KN', 'LC', 'MF', 'PM', 'VC', 'WS', 'SM', 'ST', 'SA', 'SN', 'RS', 'SC', 'SL', 'SG', 'SX', 'SK', 'SI', 'SB', 'SO', 'ZA', 'KR', 'ES', 'LK', 'SD', 'SR', 'SJ', 'SZ', 'SE', 'CH', 'SY', 'TW', 'TJ', 'TZ', 'TH', 'TG', 'TK', 'TO', 'TT', 'TN', 'TR', 'TM', 'TC', 'TV', 'VI', 'UG', 'UA', 'AE', 'GB', 'US', 'UY', 'UZ', 'VU', 'VA', 'VE', 'VN', 'WF', 'EH', 'YE', 'ZM', 'ZW', ], ], 'PhoneNumberCountryCodes' => [ 'type' => 'list', 'member' => [ 'shape' => 'PhoneNumberCountryCode', ], 'max' => 10, ], 'PhoneNumberId' => [ 'type' => 'string', ], 'PhoneNumberSummary' => [ 'type' => 'structure', 'members' => [ 'Id' => [ 'shape' => 'PhoneNumberId', ], 'Arn' => [ 'shape' => 'ARN', ], 'PhoneNumber' => [ 'shape' => 'PhoneNumber', ], 'PhoneNumberType' => [ 'shape' => 'PhoneNumberType', ], 'PhoneNumberCountryCode' => [ 'shape' => 'PhoneNumberCountryCode', ], ], ], 'PhoneNumberSummaryList' => [ 'type' => 'list', 'member' => [ 'shape' => 'PhoneNumberSummary', ], ], 'PhoneNumberType' => [ 'type' => 'string', 'enum' => [ 'TOLL_FREE', 'DID', ], ], 'PhoneNumberTypes' => [ 'type' => 'list', 'member' => [ 'shape' => 'PhoneNumberType', ], 'max' => 2, ], 'PhoneType' => [ 'type' => 'string', 'enum' => [ 'SOFT_PHONE', 'DESK_PHONE', ], ], 'Priority' => [ 'type' => 'integer', 'max' => 99, 'min' => 1, ], 'ProblemDetail' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'ProblemMessageString', ], ], ], 'ProblemMessageString' => [ 'type' => 'string', 'max' => 256, 'min' => 1, ], 'Problems' => [ 'type' => 'list', 'member' => [ 'shape' => 'ProblemDetail', ], 'max' => 50, 'min' => 1, ], 'PromptId' => [ 'type' => 'string', 'max' => 256, 'min' => 1, ], 'PromptName' => [ 'type' => 'string', 'max' => 256, 'min' => 1, ], 'PromptSummary' => [ 'type' => 'structure', 'members' => [ 'Id' => [ 'shape' => 'PromptId', ], 'Arn' => [ 'shape' => 'ARN', ], 'Name' => [ 'shape' => 'PromptName', ], ], ], 'PromptSummaryList' => [ 'type' => 'list', 'member' => [ 'shape' => 'PromptSummary', ], ], 'QueueId' => [ 'type' => 'string', ], 'QueueName' => [ 'type' => 'string', 'max' => 256, 'min' => 1, ], 'QueueReference' => [ 'type' => 'structure', 'members' => [ 'Id' => [ 'shape' => 'QueueId', ], 'Arn' => [ 'shape' => 'ARN', ], ], ], 'QueueSummary' => [ 'type' => 'structure', 'members' => [ 'Id' => [ 'shape' => 'QueueId', ], 'Arn' => [ 'shape' => 'ARN', ], 'Name' => [ 'shape' => 'QueueName', ], 'QueueType' => [ 'shape' => 'QueueType', ], ], ], 'QueueSummaryList' => [ 'type' => 'list', 'member' => [ 'shape' => 'QueueSummary', ], ], 'QueueType' => [ 'type' => 'string', 'enum' => [ 'STANDARD', 'AGENT', ], ], 'QueueTypes' => [ 'type' => 'list', 'member' => [ 'shape' => 'QueueType', ], 'max' => 2, ], 'Queues' => [ 'type' => 'list', 'member' => [ 'shape' => 'QueueId', ], 'max' => 100, 'min' => 1, ], 'ResourceInUseException' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'Message', ], 'ResourceType' => [ 'shape' => 'ResourceType', ], 'ResourceId' => [ 'shape' => 'ARN', ], ], 'error' => [ 'httpStatusCode' => 409, ], 'exception' => true, ], 'ResourceNotFoundException' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'Message', ], ], 'error' => [ 'httpStatusCode' => 404, ], 'exception' => true, ], 'ResourceType' => [ 'type' => 'string', 'enum' => [ 'CONTACT', 'CONTACT_FLOW', 'INSTANCE', 'PARTICIPANT', 'HIERARCHY_LEVEL', 'HIERARCHY_GROUP', 'USER', ], ], 'ResumeContactRecordingRequest' => [ 'type' => 'structure', 'required' => [ 'InstanceId', 'ContactId', 'InitialContactId', ], 'members' => [ 'InstanceId' => [ 'shape' => 'InstanceId', ], 'ContactId' => [ 'shape' => 'ContactId', ], 'InitialContactId' => [ 'shape' => 'ContactId', ], ], ], 'ResumeContactRecordingResponse' => [ 'type' => 'structure', 'members' => [], ], 'RoutingProfile' => [ 'type' => 'structure', 'members' => [ 'InstanceId' => [ 'shape' => 'InstanceId', ], 'Name' => [ 'shape' => 'RoutingProfileName', ], 'RoutingProfileArn' => [ 'shape' => 'ARN', ], 'RoutingProfileId' => [ 'shape' => 'RoutingProfileId', ], 'Description' => [ 'shape' => 'RoutingProfileDescription', ], 'MediaConcurrencies' => [ 'shape' => 'MediaConcurrencies', ], 'DefaultOutboundQueueId' => [ 'shape' => 'QueueId', ], 'Tags' => [ 'shape' => 'TagMap', ], ], ], 'RoutingProfileDescription' => [ 'type' => 'string', 'max' => 250, 'min' => 1, ], 'RoutingProfileId' => [ 'type' => 'string', ], 'RoutingProfileName' => [ 'type' => 'string', 'max' => 127, 'min' => 1, ], 'RoutingProfileQueueConfig' => [ 'type' => 'structure', 'required' => [ 'QueueReference', 'Priority', 'Delay', ], 'members' => [ 'QueueReference' => [ 'shape' => 'RoutingProfileQueueReference', ], 'Priority' => [ 'shape' => 'Priority', 'box' => true, ], 'Delay' => [ 'shape' => 'Delay', 'box' => true, ], ], ], 'RoutingProfileQueueConfigList' => [ 'type' => 'list', 'member' => [ 'shape' => 'RoutingProfileQueueConfig', ], 'max' => 10, 'min' => 1, ], 'RoutingProfileQueueConfigSummary' => [ 'type' => 'structure', 'required' => [ 'QueueId', 'QueueArn', 'QueueName', 'Priority', 'Delay', 'Channel', ], 'members' => [ 'QueueId' => [ 'shape' => 'QueueId', ], 'QueueArn' => [ 'shape' => 'ARN', ], 'QueueName' => [ 'shape' => 'QueueName', ], 'Priority' => [ 'shape' => 'Priority', ], 'Delay' => [ 'shape' => 'Delay', ], 'Channel' => [ 'shape' => 'Channel', ], ], ], 'RoutingProfileQueueConfigSummaryList' => [ 'type' => 'list', 'member' => [ 'shape' => 'RoutingProfileQueueConfigSummary', ], ], 'RoutingProfileQueueReference' => [ 'type' => 'structure', 'required' => [ 'QueueId', 'Channel', ], 'members' => [ 'QueueId' => [ 'shape' => 'QueueId', ], 'Channel' => [ 'shape' => 'Channel', ], ], ], 'RoutingProfileQueueReferenceList' => [ 'type' => 'list', 'member' => [ 'shape' => 'RoutingProfileQueueReference', ], ], 'RoutingProfileSummary' => [ 'type' => 'structure', 'members' => [ 'Id' => [ 'shape' => 'RoutingProfileId', ], 'Arn' => [ 'shape' => 'ARN', ], 'Name' => [ 'shape' => 'RoutingProfileName', ], ], ], 'RoutingProfileSummaryList' => [ 'type' => 'list', 'member' => [ 'shape' => 'RoutingProfileSummary', ], ], 'SecurityProfileId' => [ 'type' => 'string', ], 'SecurityProfileIds' => [ 'type' => 'list', 'member' => [ 'shape' => 'SecurityProfileId', ], 'max' => 10, 'min' => 1, ], 'SecurityProfileName' => [ 'type' => 'string', ], 'SecurityProfileSummary' => [ 'type' => 'structure', 'members' => [ 'Id' => [ 'shape' => 'SecurityProfileId', ], 'Arn' => [ 'shape' => 'ARN', ], 'Name' => [ 'shape' => 'SecurityProfileName', ], ], ], 'SecurityProfileSummaryList' => [ 'type' => 'list', 'member' => [ 'shape' => 'SecurityProfileSummary', ], ], 'SecurityToken' => [ 'type' => 'string', 'sensitive' => true, ], 'StartChatContactRequest' => [ 'type' => 'structure', 'required' => [ 'InstanceId', 'ContactFlowId', 'ParticipantDetails', ], 'members' => [ 'InstanceId' => [ 'shape' => 'InstanceId', ], 'ContactFlowId' => [ 'shape' => 'ContactFlowId', ], 'Attributes' => [ 'shape' => 'Attributes', ], 'ParticipantDetails' => [ 'shape' => 'ParticipantDetails', ], 'InitialMessage' => [ 'shape' => 'ChatMessage', ], 'ClientToken' => [ 'shape' => 'ClientToken', 'idempotencyToken' => true, ], ], ], 'StartChatContactResponse' => [ 'type' => 'structure', 'members' => [ 'ContactId' => [ 'shape' => 'ContactId', ], 'ParticipantId' => [ 'shape' => 'ParticipantId', ], 'ParticipantToken' => [ 'shape' => 'ParticipantToken', ], ], ], 'StartContactRecordingRequest' => [ 'type' => 'structure', 'required' => [ 'InstanceId', 'ContactId', 'InitialContactId', 'VoiceRecordingConfiguration', ], 'members' => [ 'InstanceId' => [ 'shape' => 'InstanceId', ], 'ContactId' => [ 'shape' => 'ContactId', ], 'InitialContactId' => [ 'shape' => 'ContactId', ], 'VoiceRecordingConfiguration' => [ 'shape' => 'VoiceRecordingConfiguration', ], ], ], 'StartContactRecordingResponse' => [ 'type' => 'structure', 'members' => [], ], 'StartOutboundVoiceContactRequest' => [ 'type' => 'structure', 'required' => [ 'DestinationPhoneNumber', 'ContactFlowId', 'InstanceId', ], 'members' => [ 'DestinationPhoneNumber' => [ 'shape' => 'PhoneNumber', ], 'ContactFlowId' => [ 'shape' => 'ContactFlowId', ], 'InstanceId' => [ 'shape' => 'InstanceId', ], 'ClientToken' => [ 'shape' => 'ClientToken', 'idempotencyToken' => true, ], 'SourcePhoneNumber' => [ 'shape' => 'PhoneNumber', ], 'QueueId' => [ 'shape' => 'QueueId', ], 'Attributes' => [ 'shape' => 'Attributes', ], ], ], 'StartOutboundVoiceContactResponse' => [ 'type' => 'structure', 'members' => [ 'ContactId' => [ 'shape' => 'ContactId', ], ], ], 'Statistic' => [ 'type' => 'string', 'enum' => [ 'SUM', 'MAX', 'AVG', ], ], 'StopContactRecordingRequest' => [ 'type' => 'structure', 'required' => [ 'InstanceId', 'ContactId', 'InitialContactId', ], 'members' => [ 'InstanceId' => [ 'shape' => 'InstanceId', ], 'ContactId' => [ 'shape' => 'ContactId', ], 'InitialContactId' => [ 'shape' => 'ContactId', ], ], ], 'StopContactRecordingResponse' => [ 'type' => 'structure', 'members' => [], ], 'StopContactRequest' => [ 'type' => 'structure', 'required' => [ 'ContactId', 'InstanceId', ], 'members' => [ 'ContactId' => [ 'shape' => 'ContactId', ], 'InstanceId' => [ 'shape' => 'InstanceId', ], ], ], 'StopContactResponse' => [ 'type' => 'structure', 'members' => [], ], 'SuspendContactRecordingRequest' => [ 'type' => 'structure', 'required' => [ 'InstanceId', 'ContactId', 'InitialContactId', ], 'members' => [ 'InstanceId' => [ 'shape' => 'InstanceId', ], 'ContactId' => [ 'shape' => 'ContactId', ], 'InitialContactId' => [ 'shape' => 'ContactId', ], ], ], 'SuspendContactRecordingResponse' => [ 'type' => 'structure', 'members' => [], ], 'TagKey' => [ 'type' => 'string', 'max' => 128, 'min' => 1, 'pattern' => '^(?!aws:)[a-zA-Z+-=._:/]+$', ], 'TagKeyList' => [ 'type' => 'list', 'member' => [ 'shape' => 'TagKey', ], 'max' => 200, 'min' => 1, ], 'TagMap' => [ 'type' => 'map', 'key' => [ 'shape' => 'TagKey', ], 'value' => [ 'shape' => 'TagValue', ], 'max' => 200, 'min' => 1, ], 'TagResourceRequest' => [ 'type' => 'structure', 'required' => [ 'resourceArn', 'tags', ], 'members' => [ 'resourceArn' => [ 'shape' => 'ARN', 'location' => 'uri', 'locationName' => 'resourceArn', ], 'tags' => [ 'shape' => 'TagMap', ], ], ], 'TagValue' => [ 'type' => 'string', 'max' => 256, ], 'Threshold' => [ 'type' => 'structure', 'members' => [ 'Comparison' => [ 'shape' => 'Comparison', ], 'ThresholdValue' => [ 'shape' => 'ThresholdValue', 'box' => true, ], ], ], 'ThresholdValue' => [ 'type' => 'double', ], 'ThrottlingException' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'Message', ], ], 'error' => [ 'httpStatusCode' => 429, ], 'exception' => true, ], 'Unit' => [ 'type' => 'string', 'enum' => [ 'SECONDS', 'COUNT', 'PERCENT', ], ], 'UntagResourceRequest' => [ 'type' => 'structure', 'required' => [ 'resourceArn', 'tagKeys', ], 'members' => [ 'resourceArn' => [ 'shape' => 'ARN', 'location' => 'uri', 'locationName' => 'resourceArn', ], 'tagKeys' => [ 'shape' => 'TagKeyList', 'location' => 'querystring', 'locationName' => 'tagKeys', ], ], ], 'UpdateContactAttributesRequest' => [ 'type' => 'structure', 'required' => [ 'InitialContactId', 'InstanceId', 'Attributes', ], 'members' => [ 'InitialContactId' => [ 'shape' => 'ContactId', ], 'InstanceId' => [ 'shape' => 'InstanceId', ], 'Attributes' => [ 'shape' => 'Attributes', ], ], ], 'UpdateContactAttributesResponse' => [ 'type' => 'structure', 'members' => [], ], 'UpdateContactFlowContentRequest' => [ 'type' => 'structure', 'required' => [ 'InstanceId', 'ContactFlowId', 'Content', ], 'members' => [ 'InstanceId' => [ 'shape' => 'InstanceId', 'location' => 'uri', 'locationName' => 'InstanceId', ], 'ContactFlowId' => [ 'shape' => 'ContactFlowId', 'location' => 'uri', 'locationName' => 'ContactFlowId', ], 'Content' => [ 'shape' => 'ContactFlowContent', ], ], ], 'UpdateContactFlowNameRequest' => [ 'type' => 'structure', 'required' => [ 'InstanceId', 'ContactFlowId', ], 'members' => [ 'InstanceId' => [ 'shape' => 'InstanceId', 'location' => 'uri', 'locationName' => 'InstanceId', ], 'ContactFlowId' => [ 'shape' => 'ContactFlowId', 'location' => 'uri', 'locationName' => 'ContactFlowId', ], 'Name' => [ 'shape' => 'ContactFlowName', ], 'Description' => [ 'shape' => 'ContactFlowDescription', ], ], ], 'UpdateRoutingProfileConcurrencyRequest' => [ 'type' => 'structure', 'required' => [ 'InstanceId', 'RoutingProfileId', 'MediaConcurrencies', ], 'members' => [ 'InstanceId' => [ 'shape' => 'InstanceId', 'location' => 'uri', 'locationName' => 'InstanceId', ], 'RoutingProfileId' => [ 'shape' => 'RoutingProfileId', 'location' => 'uri', 'locationName' => 'RoutingProfileId', ], 'MediaConcurrencies' => [ 'shape' => 'MediaConcurrencies', ], ], ], 'UpdateRoutingProfileDefaultOutboundQueueRequest' => [ 'type' => 'structure', 'required' => [ 'InstanceId', 'RoutingProfileId', 'DefaultOutboundQueueId', ], 'members' => [ 'InstanceId' => [ 'shape' => 'InstanceId', 'location' => 'uri', 'locationName' => 'InstanceId', ], 'RoutingProfileId' => [ 'shape' => 'RoutingProfileId', 'location' => 'uri', 'locationName' => 'RoutingProfileId', ], 'DefaultOutboundQueueId' => [ 'shape' => 'QueueId', ], ], ], 'UpdateRoutingProfileNameRequest' => [ 'type' => 'structure', 'required' => [ 'InstanceId', 'RoutingProfileId', ], 'members' => [ 'InstanceId' => [ 'shape' => 'InstanceId', 'location' => 'uri', 'locationName' => 'InstanceId', ], 'RoutingProfileId' => [ 'shape' => 'RoutingProfileId', 'location' => 'uri', 'locationName' => 'RoutingProfileId', ], 'Name' => [ 'shape' => 'RoutingProfileName', ], 'Description' => [ 'shape' => 'RoutingProfileDescription', ], ], ], 'UpdateRoutingProfileQueuesRequest' => [ 'type' => 'structure', 'required' => [ 'InstanceId', 'RoutingProfileId', 'QueueConfigs', ], 'members' => [ 'InstanceId' => [ 'shape' => 'InstanceId', 'location' => 'uri', 'locationName' => 'InstanceId', ], 'RoutingProfileId' => [ 'shape' => 'RoutingProfileId', 'location' => 'uri', 'locationName' => 'RoutingProfileId', ], 'QueueConfigs' => [ 'shape' => 'RoutingProfileQueueConfigList', ], ], ], 'UpdateUserHierarchyGroupNameRequest' => [ 'type' => 'structure', 'required' => [ 'Name', 'HierarchyGroupId', 'InstanceId', ], 'members' => [ 'Name' => [ 'shape' => 'HierarchyGroupName', ], 'HierarchyGroupId' => [ 'shape' => 'HierarchyGroupId', 'location' => 'uri', 'locationName' => 'HierarchyGroupId', ], 'InstanceId' => [ 'shape' => 'InstanceId', 'location' => 'uri', 'locationName' => 'InstanceId', ], ], ], 'UpdateUserHierarchyRequest' => [ 'type' => 'structure', 'required' => [ 'UserId', 'InstanceId', ], 'members' => [ 'HierarchyGroupId' => [ 'shape' => 'HierarchyGroupId', ], 'UserId' => [ 'shape' => 'UserId', 'location' => 'uri', 'locationName' => 'UserId', ], 'InstanceId' => [ 'shape' => 'InstanceId', 'location' => 'uri', 'locationName' => 'InstanceId', ], ], ], 'UpdateUserHierarchyStructureRequest' => [ 'type' => 'structure', 'required' => [ 'HierarchyStructure', 'InstanceId', ], 'members' => [ 'HierarchyStructure' => [ 'shape' => 'HierarchyStructureUpdate', ], 'InstanceId' => [ 'shape' => 'InstanceId', 'location' => 'uri', 'locationName' => 'InstanceId', ], ], ], 'UpdateUserIdentityInfoRequest' => [ 'type' => 'structure', 'required' => [ 'IdentityInfo', 'UserId', 'InstanceId', ], 'members' => [ 'IdentityInfo' => [ 'shape' => 'UserIdentityInfo', ], 'UserId' => [ 'shape' => 'UserId', 'location' => 'uri', 'locationName' => 'UserId', ], 'InstanceId' => [ 'shape' => 'InstanceId', 'location' => 'uri', 'locationName' => 'InstanceId', ], ], ], 'UpdateUserPhoneConfigRequest' => [ 'type' => 'structure', 'required' => [ 'PhoneConfig', 'UserId', 'InstanceId', ], 'members' => [ 'PhoneConfig' => [ 'shape' => 'UserPhoneConfig', ], 'UserId' => [ 'shape' => 'UserId', 'location' => 'uri', 'locationName' => 'UserId', ], 'InstanceId' => [ 'shape' => 'InstanceId', 'location' => 'uri', 'locationName' => 'InstanceId', ], ], ], 'UpdateUserRoutingProfileRequest' => [ 'type' => 'structure', 'required' => [ 'RoutingProfileId', 'UserId', 'InstanceId', ], 'members' => [ 'RoutingProfileId' => [ 'shape' => 'RoutingProfileId', ], 'UserId' => [ 'shape' => 'UserId', 'location' => 'uri', 'locationName' => 'UserId', ], 'InstanceId' => [ 'shape' => 'InstanceId', 'location' => 'uri', 'locationName' => 'InstanceId', ], ], ], 'UpdateUserSecurityProfilesRequest' => [ 'type' => 'structure', 'required' => [ 'SecurityProfileIds', 'UserId', 'InstanceId', ], 'members' => [ 'SecurityProfileIds' => [ 'shape' => 'SecurityProfileIds', ], 'UserId' => [ 'shape' => 'UserId', 'location' => 'uri', 'locationName' => 'UserId', ], 'InstanceId' => [ 'shape' => 'InstanceId', 'location' => 'uri', 'locationName' => 'InstanceId', ], ], ], 'User' => [ 'type' => 'structure', 'members' => [ 'Id' => [ 'shape' => 'UserId', ], 'Arn' => [ 'shape' => 'ARN', ], 'Username' => [ 'shape' => 'AgentUsername', ], 'IdentityInfo' => [ 'shape' => 'UserIdentityInfo', ], 'PhoneConfig' => [ 'shape' => 'UserPhoneConfig', ], 'DirectoryUserId' => [ 'shape' => 'DirectoryUserId', ], 'SecurityProfileIds' => [ 'shape' => 'SecurityProfileIds', ], 'RoutingProfileId' => [ 'shape' => 'RoutingProfileId', ], 'HierarchyGroupId' => [ 'shape' => 'HierarchyGroupId', ], 'Tags' => [ 'shape' => 'TagMap', ], ], ], 'UserId' => [ 'type' => 'string', ], 'UserIdentityInfo' => [ 'type' => 'structure', 'members' => [ 'FirstName' => [ 'shape' => 'AgentFirstName', ], 'LastName' => [ 'shape' => 'AgentLastName', ], 'Email' => [ 'shape' => 'Email', ], ], ], 'UserNotFoundException' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'Message', ], ], 'error' => [ 'httpStatusCode' => 404, ], 'exception' => true, ], 'UserPhoneConfig' => [ 'type' => 'structure', 'required' => [ 'PhoneType', ], 'members' => [ 'PhoneType' => [ 'shape' => 'PhoneType', ], 'AutoAccept' => [ 'shape' => 'AutoAccept', ], 'AfterContactWorkTimeLimit' => [ 'shape' => 'AfterContactWorkTimeLimit', ], 'DeskPhoneNumber' => [ 'shape' => 'PhoneNumber', ], ], ], 'UserSummary' => [ 'type' => 'structure', 'members' => [ 'Id' => [ 'shape' => 'UserId', ], 'Arn' => [ 'shape' => 'ARN', ], 'Username' => [ 'shape' => 'AgentUsername', ], ], ], 'UserSummaryList' => [ 'type' => 'list', 'member' => [ 'shape' => 'UserSummary', ], ], 'Value' => [ 'type' => 'double', ], 'VoiceRecordingConfiguration' => [ 'type' => 'structure', 'members' => [ 'VoiceRecordingTrack' => [ 'shape' => 'VoiceRecordingTrack', ], ], ], 'VoiceRecordingTrack' => [ 'type' => 'string', 'enum' => [ 'FROM_AGENT', 'TO_AGENT', 'ALL', ], ], 'timestamp' => [ 'type' => 'timestamp', ], ],];
