<?php
// This file was auto-generated from sdk-root/src/data/bedrock-agent/2023-06-05/api-2.json
return [ 'version' => '2.0', 'metadata' => [ 'apiVersion' => '2023-06-05', 'auth' => [ 'aws.auth#sigv4', ], 'endpointPrefix' => 'bedrock-agent', 'protocol' => 'rest-json', 'protocols' => [ 'rest-json', ], 'serviceFullName' => 'Agents for Amazon Bedrock', 'serviceId' => 'Bedrock Agent', 'signatureVersion' => 'v4', 'signingName' => 'bedrock', 'uid' => 'bedrock-agent-2023-06-05', ], 'operations' => [ 'AssociateAgentCollaborator' => [ 'name' => 'AssociateAgentCollaborator', 'http' => [ 'method' => 'PUT', 'requestUri' => '/agents/{agentId}/agentversions/{agentVersion}/agentcollaborators/', 'responseCode' => 200, ], 'input' => [ 'shape' => 'AssociateAgentCollaboratorRequest', ], 'output' => [ 'shape' => 'AssociateAgentCollaboratorResponse', ], 'errors' => [ [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ServiceQuotaExceededException', ], ], 'idempotent' => true, ], 'AssociateAgentKnowledgeBase' => [ 'name' => 'AssociateAgentKnowledgeBase', 'http' => [ 'method' => 'PUT', 'requestUri' => '/agents/{agentId}/agentversions/{agentVersion}/knowledgebases/', 'responseCode' => 200, ], 'input' => [ 'shape' => 'AssociateAgentKnowledgeBaseRequest', ], 'output' => [ 'shape' => 'AssociateAgentKnowledgeBaseResponse', ], 'errors' => [ [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ServiceQuotaExceededException', ], ], 'idempotent' => true, ], 'CreateAgent' => [ 'name' => 'CreateAgent', 'http' => [ 'method' => 'PUT', 'requestUri' => '/agents/', 'responseCode' => 202, ], 'input' => [ 'shape' => 'CreateAgentRequest', ], 'output' => [ 'shape' => 'CreateAgentResponse', ], 'errors' => [ [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ServiceQuotaExceededException', ], ], 'idempotent' => true, ], 'CreateAgentActionGroup' => [ 'name' => 'CreateAgentActionGroup', 'http' => [ 'method' => 'PUT', 'requestUri' => '/agents/{agentId}/agentversions/{agentVersion}/actiongroups/', 'responseCode' => 200, ], 'input' => [ 'shape' => 'CreateAgentActionGroupRequest', ], 'output' => [ 'shape' => 'CreateAgentActionGroupResponse', ], 'errors' => [ [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ServiceQuotaExceededException', ], ], 'idempotent' => true, ], 'CreateAgentAlias' => [ 'name' => 'CreateAgentAlias', 'http' => [ 'method' => 'PUT', 'requestUri' => '/agents/{agentId}/agentaliases/', 'responseCode' => 202, ], 'input' => [ 'shape' => 'CreateAgentAliasRequest', ], 'output' => [ 'shape' => 'CreateAgentAliasResponse', ], 'errors' => [ [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ServiceQuotaExceededException', ], ], 'idempotent' => true, ], 'CreateDataSource' => [ 'name' => 'CreateDataSource', 'http' => [ 'method' => 'PUT', 'requestUri' => '/knowledgebases/{knowledgeBaseId}/datasources/', 'responseCode' => 200, ], 'input' => [ 'shape' => 'CreateDataSourceRequest', ], 'output' => [ 'shape' => 'CreateDataSourceResponse', ], 'errors' => [ [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ServiceQuotaExceededException', ], ], 'idempotent' => true, ], 'CreateFlow' => [ 'name' => 'CreateFlow', 'http' => [ 'method' => 'POST', 'requestUri' => '/flows/', 'responseCode' => 201, ], 'input' => [ 'shape' => 'CreateFlowRequest', ], 'output' => [ 'shape' => 'CreateFlowResponse', ], 'errors' => [ [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ServiceQuotaExceededException', ], ], 'idempotent' => true, ], 'CreateFlowAlias' => [ 'name' => 'CreateFlowAlias', 'http' => [ 'method' => 'POST', 'requestUri' => '/flows/{flowIdentifier}/aliases', 'responseCode' => 201, ], 'input' => [ 'shape' => 'CreateFlowAliasRequest', ], 'output' => [ 'shape' => 'CreateFlowAliasResponse', ], 'errors' => [ [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ServiceQuotaExceededException', ], ], 'idempotent' => true, ], 'CreateFlowVersion' => [ 'name' => 'CreateFlowVersion', 'http' => [ 'method' => 'POST', 'requestUri' => '/flows/{flowIdentifier}/versions', 'responseCode' => 201, ], 'input' => [ 'shape' => 'CreateFlowVersionRequest', ], 'output' => [ 'shape' => 'CreateFlowVersionResponse', ], 'errors' => [ [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ServiceQuotaExceededException', ], ], 'idempotent' => true, ], 'CreateKnowledgeBase' => [ 'name' => 'CreateKnowledgeBase', 'http' => [ 'method' => 'PUT', 'requestUri' => '/knowledgebases/', 'responseCode' => 202, ], 'input' => [ 'shape' => 'CreateKnowledgeBaseRequest', ], 'output' => [ 'shape' => 'CreateKnowledgeBaseResponse', ], 'errors' => [ [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ServiceQuotaExceededException', ], ], 'idempotent' => true, ], 'CreatePrompt' => [ 'name' => 'CreatePrompt', 'http' => [ 'method' => 'POST', 'requestUri' => '/prompts/', 'responseCode' => 201, ], 'input' => [ 'shape' => 'CreatePromptRequest', ], 'output' => [ 'shape' => 'CreatePromptResponse', ], 'errors' => [ [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ServiceQuotaExceededException', ], ], 'idempotent' => true, ], 'CreatePromptVersion' => [ 'name' => 'CreatePromptVersion', 'http' => [ 'method' => 'POST', 'requestUri' => '/prompts/{promptIdentifier}/versions', 'responseCode' => 201, ], 'input' => [ 'shape' => 'CreatePromptVersionRequest', ], 'output' => [ 'shape' => 'CreatePromptVersionResponse', ], 'errors' => [ [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ServiceQuotaExceededException', ], ], 'idempotent' => true, ], 'DeleteAgent' => [ 'name' => 'DeleteAgent', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/agents/{agentId}/', 'responseCode' => 202, ], 'input' => [ 'shape' => 'DeleteAgentRequest', ], 'output' => [ 'shape' => 'DeleteAgentResponse', ], 'errors' => [ [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], ], 'idempotent' => true, ], 'DeleteAgentActionGroup' => [ 'name' => 'DeleteAgentActionGroup', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/agents/{agentId}/agentversions/{agentVersion}/actiongroups/{actionGroupId}/', 'responseCode' => 204, ], 'input' => [ 'shape' => 'DeleteAgentActionGroupRequest', ], 'output' => [ 'shape' => 'DeleteAgentActionGroupResponse', ], 'errors' => [ [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], ], 'idempotent' => true, ], 'DeleteAgentAlias' => [ 'name' => 'DeleteAgentAlias', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/agents/{agentId}/agentaliases/{agentAliasId}/', 'responseCode' => 202, ], 'input' => [ 'shape' => 'DeleteAgentAliasRequest', ], 'output' => [ 'shape' => 'DeleteAgentAliasResponse', ], 'errors' => [ [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], ], 'idempotent' => true, ], 'DeleteAgentVersion' => [ 'name' => 'DeleteAgentVersion', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/agents/{agentId}/agentversions/{agentVersion}/', 'responseCode' => 202, ], 'input' => [ 'shape' => 'DeleteAgentVersionRequest', ], 'output' => [ 'shape' => 'DeleteAgentVersionResponse', ], 'errors' => [ [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], ], 'idempotent' => true, ], 'DeleteDataSource' => [ 'name' => 'DeleteDataSource', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/knowledgebases/{knowledgeBaseId}/datasources/{dataSourceId}', 'responseCode' => 202, ], 'input' => [ 'shape' => 'DeleteDataSourceRequest', ], 'output' => [ 'shape' => 'DeleteDataSourceResponse', ], 'errors' => [ [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], ], 'idempotent' => true, ], 'DeleteFlow' => [ 'name' => 'DeleteFlow', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/flows/{flowIdentifier}/', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DeleteFlowRequest', ], 'output' => [ 'shape' => 'DeleteFlowResponse', ], 'errors' => [ [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], ], 'idempotent' => true, ], 'DeleteFlowAlias' => [ 'name' => 'DeleteFlowAlias', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/flows/{flowIdentifier}/aliases/{aliasIdentifier}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DeleteFlowAliasRequest', ], 'output' => [ 'shape' => 'DeleteFlowAliasResponse', ], 'errors' => [ [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], ], 'idempotent' => true, ], 'DeleteFlowVersion' => [ 'name' => 'DeleteFlowVersion', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/flows/{flowIdentifier}/versions/{flowVersion}/', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DeleteFlowVersionRequest', ], 'output' => [ 'shape' => 'DeleteFlowVersionResponse', ], 'errors' => [ [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], ], 'idempotent' => true, ], 'DeleteKnowledgeBase' => [ 'name' => 'DeleteKnowledgeBase', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/knowledgebases/{knowledgeBaseId}', 'responseCode' => 202, ], 'input' => [ 'shape' => 'DeleteKnowledgeBaseRequest', ], 'output' => [ 'shape' => 'DeleteKnowledgeBaseResponse', ], 'errors' => [ [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], ], 'idempotent' => true, ], 'DeleteKnowledgeBaseDocuments' => [ 'name' => 'DeleteKnowledgeBaseDocuments', 'http' => [ 'method' => 'POST', 'requestUri' => '/knowledgebases/{knowledgeBaseId}/datasources/{dataSourceId}/documents/deleteDocuments', 'responseCode' => 202, ], 'input' => [ 'shape' => 'DeleteKnowledgeBaseDocumentsRequest', ], 'output' => [ 'shape' => 'DeleteKnowledgeBaseDocumentsResponse', ], 'errors' => [ [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ServiceQuotaExceededException', ], ], 'idempotent' => true, ], 'DeletePrompt' => [ 'name' => 'DeletePrompt', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/prompts/{promptIdentifier}/', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DeletePromptRequest', ], 'output' => [ 'shape' => 'DeletePromptResponse', ], 'errors' => [ [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], ], 'idempotent' => true, ], 'DisassociateAgentCollaborator' => [ 'name' => 'DisassociateAgentCollaborator', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/agents/{agentId}/agentversions/{agentVersion}/agentcollaborators/{collaboratorId}/', 'responseCode' => 204, ], 'input' => [ 'shape' => 'DisassociateAgentCollaboratorRequest', ], 'output' => [ 'shape' => 'DisassociateAgentCollaboratorResponse', ], 'errors' => [ [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], ], 'idempotent' => true, ], 'DisassociateAgentKnowledgeBase' => [ 'name' => 'DisassociateAgentKnowledgeBase', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/agents/{agentId}/agentversions/{agentVersion}/knowledgebases/{knowledgeBaseId}/', 'responseCode' => 204, ], 'input' => [ 'shape' => 'DisassociateAgentKnowledgeBaseRequest', ], 'output' => [ 'shape' => 'DisassociateAgentKnowledgeBaseResponse', ], 'errors' => [ [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], ], 'idempotent' => true, ], 'GetAgent' => [ 'name' => 'GetAgent', 'http' => [ 'method' => 'GET', 'requestUri' => '/agents/{agentId}/', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetAgentRequest', ], 'output' => [ 'shape' => 'GetAgentResponse', ], 'errors' => [ [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'GetAgentActionGroup' => [ 'name' => 'GetAgentActionGroup', 'http' => [ 'method' => 'GET', 'requestUri' => '/agents/{agentId}/agentversions/{agentVersion}/actiongroups/{actionGroupId}/', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetAgentActionGroupRequest', ], 'output' => [ 'shape' => 'GetAgentActionGroupResponse', ], 'errors' => [ [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'GetAgentAlias' => [ 'name' => 'GetAgentAlias', 'http' => [ 'method' => 'GET', 'requestUri' => '/agents/{agentId}/agentaliases/{agentAliasId}/', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetAgentAliasRequest', ], 'output' => [ 'shape' => 'GetAgentAliasResponse', ], 'errors' => [ [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'GetAgentCollaborator' => [ 'name' => 'GetAgentCollaborator', 'http' => [ 'method' => 'GET', 'requestUri' => '/agents/{agentId}/agentversions/{agentVersion}/agentcollaborators/{collaboratorId}/', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetAgentCollaboratorRequest', ], 'output' => [ 'shape' => 'GetAgentCollaboratorResponse', ], 'errors' => [ [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'GetAgentKnowledgeBase' => [ 'name' => 'GetAgentKnowledgeBase', 'http' => [ 'method' => 'GET', 'requestUri' => '/agents/{agentId}/agentversions/{agentVersion}/knowledgebases/{knowledgeBaseId}/', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetAgentKnowledgeBaseRequest', ], 'output' => [ 'shape' => 'GetAgentKnowledgeBaseResponse', ], 'errors' => [ [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'GetAgentVersion' => [ 'name' => 'GetAgentVersion', 'http' => [ 'method' => 'GET', 'requestUri' => '/agents/{agentId}/agentversions/{agentVersion}/', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetAgentVersionRequest', ], 'output' => [ 'shape' => 'GetAgentVersionResponse', ], 'errors' => [ [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'GetDataSource' => [ 'name' => 'GetDataSource', 'http' => [ 'method' => 'GET', 'requestUri' => '/knowledgebases/{knowledgeBaseId}/datasources/{dataSourceId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetDataSourceRequest', ], 'output' => [ 'shape' => 'GetDataSourceResponse', ], 'errors' => [ [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'GetFlow' => [ 'name' => 'GetFlow', 'http' => [ 'method' => 'GET', 'requestUri' => '/flows/{flowIdentifier}/', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetFlowRequest', ], 'output' => [ 'shape' => 'GetFlowResponse', ], 'errors' => [ [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'GetFlowAlias' => [ 'name' => 'GetFlowAlias', 'http' => [ 'method' => 'GET', 'requestUri' => '/flows/{flowIdentifier}/aliases/{aliasIdentifier}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetFlowAliasRequest', ], 'output' => [ 'shape' => 'GetFlowAliasResponse', ], 'errors' => [ [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'GetFlowVersion' => [ 'name' => 'GetFlowVersion', 'http' => [ 'method' => 'GET', 'requestUri' => '/flows/{flowIdentifier}/versions/{flowVersion}/', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetFlowVersionRequest', ], 'output' => [ 'shape' => 'GetFlowVersionResponse', ], 'errors' => [ [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'GetIngestionJob' => [ 'name' => 'GetIngestionJob', 'http' => [ 'method' => 'GET', 'requestUri' => '/knowledgebases/{knowledgeBaseId}/datasources/{dataSourceId}/ingestionjobs/{ingestionJobId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetIngestionJobRequest', ], 'output' => [ 'shape' => 'GetIngestionJobResponse', ], 'errors' => [ [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'GetKnowledgeBase' => [ 'name' => 'GetKnowledgeBase', 'http' => [ 'method' => 'GET', 'requestUri' => '/knowledgebases/{knowledgeBaseId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetKnowledgeBaseRequest', ], 'output' => [ 'shape' => 'GetKnowledgeBaseResponse', ], 'errors' => [ [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'GetKnowledgeBaseDocuments' => [ 'name' => 'GetKnowledgeBaseDocuments', 'http' => [ 'method' => 'POST', 'requestUri' => '/knowledgebases/{knowledgeBaseId}/datasources/{dataSourceId}/documents/getDocuments', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetKnowledgeBaseDocumentsRequest', ], 'output' => [ 'shape' => 'GetKnowledgeBaseDocumentsResponse', ], 'errors' => [ [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ServiceQuotaExceededException', ], ], ], 'GetPrompt' => [ 'name' => 'GetPrompt', 'http' => [ 'method' => 'GET', 'requestUri' => '/prompts/{promptIdentifier}/', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetPromptRequest', ], 'output' => [ 'shape' => 'GetPromptResponse', ], 'errors' => [ [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'IngestKnowledgeBaseDocuments' => [ 'name' => 'IngestKnowledgeBaseDocuments', 'http' => [ 'method' => 'PUT', 'requestUri' => '/knowledgebases/{knowledgeBaseId}/datasources/{dataSourceId}/documents', 'responseCode' => 202, ], 'input' => [ 'shape' => 'IngestKnowledgeBaseDocumentsRequest', ], 'output' => [ 'shape' => 'IngestKnowledgeBaseDocumentsResponse', ], 'errors' => [ [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ServiceQuotaExceededException', ], ], 'idempotent' => true, ], 'ListAgentActionGroups' => [ 'name' => 'ListAgentActionGroups', 'http' => [ 'method' => 'POST', 'requestUri' => '/agents/{agentId}/agentversions/{agentVersion}/actiongroups/', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListAgentActionGroupsRequest', ], 'output' => [ 'shape' => 'ListAgentActionGroupsResponse', ], 'errors' => [ [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'ListAgentAliases' => [ 'name' => 'ListAgentAliases', 'http' => [ 'method' => 'POST', 'requestUri' => '/agents/{agentId}/agentaliases/', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListAgentAliasesRequest', ], 'output' => [ 'shape' => 'ListAgentAliasesResponse', ], 'errors' => [ [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'ListAgentCollaborators' => [ 'name' => 'ListAgentCollaborators', 'http' => [ 'method' => 'POST', 'requestUri' => '/agents/{agentId}/agentversions/{agentVersion}/agentcollaborators/', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListAgentCollaboratorsRequest', ], 'output' => [ 'shape' => 'ListAgentCollaboratorsResponse', ], 'errors' => [ [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'ListAgentKnowledgeBases' => [ 'name' => 'ListAgentKnowledgeBases', 'http' => [ 'method' => 'POST', 'requestUri' => '/agents/{agentId}/agentversions/{agentVersion}/knowledgebases/', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListAgentKnowledgeBasesRequest', ], 'output' => [ 'shape' => 'ListAgentKnowledgeBasesResponse', ], 'errors' => [ [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'ListAgentVersions' => [ 'name' => 'ListAgentVersions', 'http' => [ 'method' => 'POST', 'requestUri' => '/agents/{agentId}/agentversions/', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListAgentVersionsRequest', ], 'output' => [ 'shape' => 'ListAgentVersionsResponse', ], 'errors' => [ [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'ListAgents' => [ 'name' => 'ListAgents', 'http' => [ 'method' => 'POST', 'requestUri' => '/agents/', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListAgentsRequest', ], 'output' => [ 'shape' => 'ListAgentsResponse', ], 'errors' => [ [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], ], ], 'ListDataSources' => [ 'name' => 'ListDataSources', 'http' => [ 'method' => 'POST', 'requestUri' => '/knowledgebases/{knowledgeBaseId}/datasources/', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListDataSourcesRequest', ], 'output' => [ 'shape' => 'ListDataSourcesResponse', ], 'errors' => [ [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'ListFlowAliases' => [ 'name' => 'ListFlowAliases', 'http' => [ 'method' => 'GET', 'requestUri' => '/flows/{flowIdentifier}/aliases', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListFlowAliasesRequest', ], 'output' => [ 'shape' => 'ListFlowAliasesResponse', ], 'errors' => [ [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'ListFlowVersions' => [ 'name' => 'ListFlowVersions', 'http' => [ 'method' => 'GET', 'requestUri' => '/flows/{flowIdentifier}/versions', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListFlowVersionsRequest', ], 'output' => [ 'shape' => 'ListFlowVersionsResponse', ], 'errors' => [ [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'ListFlows' => [ 'name' => 'ListFlows', 'http' => [ 'method' => 'GET', 'requestUri' => '/flows/', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListFlowsRequest', ], 'output' => [ 'shape' => 'ListFlowsResponse', ], 'errors' => [ [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], ], ], 'ListIngestionJobs' => [ 'name' => 'ListIngestionJobs', 'http' => [ 'method' => 'POST', 'requestUri' => '/knowledgebases/{knowledgeBaseId}/datasources/{dataSourceId}/ingestionjobs/', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListIngestionJobsRequest', ], 'output' => [ 'shape' => 'ListIngestionJobsResponse', ], 'errors' => [ [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'ListKnowledgeBaseDocuments' => [ 'name' => 'ListKnowledgeBaseDocuments', 'http' => [ 'method' => 'POST', 'requestUri' => '/knowledgebases/{knowledgeBaseId}/datasources/{dataSourceId}/documents', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListKnowledgeBaseDocumentsRequest', ], 'output' => [ 'shape' => 'ListKnowledgeBaseDocumentsResponse', ], 'errors' => [ [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ServiceQuotaExceededException', ], ], ], 'ListKnowledgeBases' => [ 'name' => 'ListKnowledgeBases', 'http' => [ 'method' => 'POST', 'requestUri' => '/knowledgebases/', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListKnowledgeBasesRequest', ], 'output' => [ 'shape' => 'ListKnowledgeBasesResponse', ], 'errors' => [ [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], ], ], 'ListPrompts' => [ 'name' => 'ListPrompts', 'http' => [ 'method' => 'GET', 'requestUri' => '/prompts/', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListPromptsRequest', ], 'output' => [ 'shape' => 'ListPromptsResponse', ], 'errors' => [ [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'ListTagsForResource' => [ 'name' => 'ListTagsForResource', 'http' => [ 'method' => 'GET', 'requestUri' => '/tags/{resourceArn}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListTagsForResourceRequest', ], 'output' => [ 'shape' => 'ListTagsForResourceResponse', ], 'errors' => [ [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'PrepareAgent' => [ 'name' => 'PrepareAgent', 'http' => [ 'method' => 'POST', 'requestUri' => '/agents/{agentId}/', 'responseCode' => 202, ], 'input' => [ 'shape' => 'PrepareAgentRequest', ], 'output' => [ 'shape' => 'PrepareAgentResponse', ], 'errors' => [ [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ServiceQuotaExceededException', ], ], ], 'PrepareFlow' => [ 'name' => 'PrepareFlow', 'http' => [ 'method' => 'POST', 'requestUri' => '/flows/{flowIdentifier}/', 'responseCode' => 202, ], 'input' => [ 'shape' => 'PrepareFlowRequest', ], 'output' => [ 'shape' => 'PrepareFlowResponse', ], 'errors' => [ [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ServiceQuotaExceededException', ], ], ], 'StartIngestionJob' => [ 'name' => 'StartIngestionJob', 'http' => [ 'method' => 'PUT', 'requestUri' => '/knowledgebases/{knowledgeBaseId}/datasources/{dataSourceId}/ingestionjobs/', 'responseCode' => 202, ], 'input' => [ 'shape' => 'StartIngestionJobRequest', ], 'output' => [ 'shape' => 'StartIngestionJobResponse', ], 'errors' => [ [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ServiceQuotaExceededException', ], ], 'idempotent' => true, ], 'StopIngestionJob' => [ 'name' => 'StopIngestionJob', 'http' => [ 'method' => 'POST', 'requestUri' => '/knowledgebases/{knowledgeBaseId}/datasources/{dataSourceId}/ingestionjobs/{ingestionJobId}/stop', 'responseCode' => 202, ], 'input' => [ 'shape' => 'StopIngestionJobRequest', ], 'output' => [ 'shape' => 'StopIngestionJobResponse', ], 'errors' => [ [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], ], 'idempotent' => true, ], 'TagResource' => [ 'name' => 'TagResource', 'http' => [ 'method' => 'POST', 'requestUri' => '/tags/{resourceArn}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'TagResourceRequest', ], 'output' => [ 'shape' => 'TagResourceResponse', ], 'errors' => [ [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ServiceQuotaExceededException', ], ], ], 'UntagResource' => [ 'name' => 'UntagResource', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/tags/{resourceArn}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UntagResourceRequest', ], 'output' => [ 'shape' => 'UntagResourceResponse', ], 'errors' => [ [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], ], 'idempotent' => true, ], 'UpdateAgent' => [ 'name' => 'UpdateAgent', 'http' => [ 'method' => 'PUT', 'requestUri' => '/agents/{agentId}/', 'responseCode' => 202, ], 'input' => [ 'shape' => 'UpdateAgentRequest', ], 'output' => [ 'shape' => 'UpdateAgentResponse', ], 'errors' => [ [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ServiceQuotaExceededException', ], ], 'idempotent' => true, ], 'UpdateAgentActionGroup' => [ 'name' => 'UpdateAgentActionGroup', 'http' => [ 'method' => 'PUT', 'requestUri' => '/agents/{agentId}/agentversions/{agentVersion}/actiongroups/{actionGroupId}/', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateAgentActionGroupRequest', ], 'output' => [ 'shape' => 'UpdateAgentActionGroupResponse', ], 'errors' => [ [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ServiceQuotaExceededException', ], ], 'idempotent' => true, ], 'UpdateAgentAlias' => [ 'name' => 'UpdateAgentAlias', 'http' => [ 'method' => 'PUT', 'requestUri' => '/agents/{agentId}/agentaliases/{agentAliasId}/', 'responseCode' => 202, ], 'input' => [ 'shape' => 'UpdateAgentAliasRequest', ], 'output' => [ 'shape' => 'UpdateAgentAliasResponse', ], 'errors' => [ [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ServiceQuotaExceededException', ], ], 'idempotent' => true, ], 'UpdateAgentCollaborator' => [ 'name' => 'UpdateAgentCollaborator', 'http' => [ 'method' => 'PUT', 'requestUri' => '/agents/{agentId}/agentversions/{agentVersion}/agentcollaborators/{collaboratorId}/', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateAgentCollaboratorRequest', ], 'output' => [ 'shape' => 'UpdateAgentCollaboratorResponse', ], 'errors' => [ [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ServiceQuotaExceededException', ], ], 'idempotent' => true, ], 'UpdateAgentKnowledgeBase' => [ 'name' => 'UpdateAgentKnowledgeBase', 'http' => [ 'method' => 'PUT', 'requestUri' => '/agents/{agentId}/agentversions/{agentVersion}/knowledgebases/{knowledgeBaseId}/', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateAgentKnowledgeBaseRequest', ], 'output' => [ 'shape' => 'UpdateAgentKnowledgeBaseResponse', ], 'errors' => [ [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], ], 'idempotent' => true, ], 'UpdateDataSource' => [ 'name' => 'UpdateDataSource', 'http' => [ 'method' => 'PUT', 'requestUri' => '/knowledgebases/{knowledgeBaseId}/datasources/{dataSourceId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateDataSourceRequest', ], 'output' => [ 'shape' => 'UpdateDataSourceResponse', ], 'errors' => [ [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], ], 'idempotent' => true, ], 'UpdateFlow' => [ 'name' => 'UpdateFlow', 'http' => [ 'method' => 'PUT', 'requestUri' => '/flows/{flowIdentifier}/', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateFlowRequest', ], 'output' => [ 'shape' => 'UpdateFlowResponse', ], 'errors' => [ [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ServiceQuotaExceededException', ], ], 'idempotent' => true, ], 'UpdateFlowAlias' => [ 'name' => 'UpdateFlowAlias', 'http' => [ 'method' => 'PUT', 'requestUri' => '/flows/{flowIdentifier}/aliases/{aliasIdentifier}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateFlowAliasRequest', ], 'output' => [ 'shape' => 'UpdateFlowAliasResponse', ], 'errors' => [ [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ServiceQuotaExceededException', ], ], 'idempotent' => true, ], 'UpdateKnowledgeBase' => [ 'name' => 'UpdateKnowledgeBase', 'http' => [ 'method' => 'PUT', 'requestUri' => '/knowledgebases/{knowledgeBaseId}', 'responseCode' => 202, ], 'input' => [ 'shape' => 'UpdateKnowledgeBaseRequest', ], 'output' => [ 'shape' => 'UpdateKnowledgeBaseResponse', ], 'errors' => [ [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], ], 'idempotent' => true, ], 'UpdatePrompt' => [ 'name' => 'UpdatePrompt', 'http' => [ 'method' => 'PUT', 'requestUri' => '/prompts/{promptIdentifier}/', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdatePromptRequest', ], 'output' => [ 'shape' => 'UpdatePromptResponse', ], 'errors' => [ [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ServiceQuotaExceededException', ], ], 'idempotent' => true, ], 'ValidateFlowDefinition' => [ 'name' => 'ValidateFlowDefinition', 'http' => [ 'method' => 'POST', 'requestUri' => '/flows/validate-definition', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ValidateFlowDefinitionRequest', ], 'output' => [ 'shape' => 'ValidateFlowDefinitionResponse', ], 'errors' => [ [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], ], ], ], 'shapes' => [ 'APISchema' => [ 'type' => 'structure', 'members' => [ 's3' => [ 'shape' => 'S3Identifier', ], 'payload' => [ 'shape' => 'Payload', ], ], 'union' => true, ], 'AccessDeniedException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'NonBlankString', ], ], 'error' => [ 'httpStatusCode' => 403, 'senderFault' => true, ], 'exception' => true, ], 'ActionGroupExecutor' => [ 'type' => 'structure', 'members' => [ 'lambda' => [ 'shape' => 'LambdaArn', ], 'customControl' => [ 'shape' => 'CustomControlMethod', ], ], 'union' => true, ], 'ActionGroupSignature' => [ 'type' => 'string', 'enum' => [ 'AMAZON.UserInput', 'AMAZON.CodeInterpreter', 'ANTHROPIC.Computer', 'ANTHROPIC.Bash', 'ANTHROPIC.TextEditor', ], ], 'ActionGroupSignatureParams' => [ 'type' => 'map', 'key' => [ 'shape' => 'ActionGroupSignatureParamsKeyString', ], 'value' => [ 'shape' => 'ActionGroupSignatureParamsValueString', ], ], 'ActionGroupSignatureParamsKeyString' => [ 'type' => 'string', 'max' => 100, 'min' => 0, ], 'ActionGroupSignatureParamsValueString' => [ 'type' => 'string', 'max' => 100, 'min' => 0, ], 'ActionGroupState' => [ 'type' => 'string', 'enum' => [ 'ENABLED', 'DISABLED', ], ], 'ActionGroupSummaries' => [ 'type' => 'list', 'member' => [ 'shape' => 'ActionGroupSummary', ], 'max' => 10, 'min' => 0, ], 'ActionGroupSummary' => [ 'type' => 'structure', 'required' => [ 'actionGroupId', 'actionGroupName', 'actionGroupState', 'updatedAt', ], 'members' => [ 'actionGroupId' => [ 'shape' => 'Id', ], 'actionGroupName' => [ 'shape' => 'Name', ], 'actionGroupState' => [ 'shape' => 'ActionGroupState', ], 'description' => [ 'shape' => 'Description', ], 'updatedAt' => [ 'shape' => 'DateTimestamp', ], ], ], 'AdditionalModelRequestFields' => [ 'type' => 'map', 'key' => [ 'shape' => 'AdditionalModelRequestFieldsKey', ], 'value' => [ 'shape' => 'AdditionalModelRequestFieldsValue', ], ], 'AdditionalModelRequestFieldsKey' => [ 'type' => 'string', 'max' => 100, 'min' => 1, ], 'AdditionalModelRequestFieldsValue' => [ 'type' => 'structure', 'members' => [], 'document' => true, ], 'Agent' => [ 'type' => 'structure', 'required' => [ 'agentId', 'agentName', 'agentArn', 'agentVersion', 'agentStatus', 'idleSessionTTLInSeconds', 'agentResourceRoleArn', 'createdAt', 'updatedAt', ], 'members' => [ 'agentId' => [ 'shape' => 'Id', ], 'agentName' => [ 'shape' => 'Name', ], 'agentArn' => [ 'shape' => 'AgentArn', ], 'agentVersion' => [ 'shape' => 'DraftVersion', ], 'clientToken' => [ 'shape' => 'ClientToken', ], 'instruction' => [ 'shape' => 'Instruction', ], 'agentStatus' => [ 'shape' => 'AgentStatus', ], 'foundationModel' => [ 'shape' => 'ModelIdentifier', ], 'description' => [ 'shape' => 'Description', ], 'orchestrationType' => [ 'shape' => 'OrchestrationType', ], 'customOrchestration' => [ 'shape' => 'CustomOrchestration', ], 'idleSessionTTLInSeconds' => [ 'shape' => 'SessionTTL', ], 'agentResourceRoleArn' => [ 'shape' => 'AgentRoleArn', ], 'customerEncryptionKeyArn' => [ 'shape' => 'KmsKeyArn', ], 'createdAt' => [ 'shape' => 'DateTimestamp', ], 'updatedAt' => [ 'shape' => 'DateTimestamp', ], 'preparedAt' => [ 'shape' => 'DateTimestamp', ], 'failureReasons' => [ 'shape' => 'FailureReasons', ], 'recommendedActions' => [ 'shape' => 'RecommendedActions', ], 'promptOverrideConfiguration' => [ 'shape' => 'PromptOverrideConfiguration', ], 'guardrailConfiguration' => [ 'shape' => 'GuardrailConfiguration', ], 'memoryConfiguration' => [ 'shape' => 'MemoryConfiguration', ], 'agentCollaboration' => [ 'shape' => 'AgentCollaboration', ], ], ], 'AgentActionGroup' => [ 'type' => 'structure', 'required' => [ 'agentId', 'agentVersion', 'actionGroupId', 'actionGroupName', 'createdAt', 'updatedAt', 'actionGroupState', ], 'members' => [ 'agentId' => [ 'shape' => 'Id', ], 'agentVersion' => [ 'shape' => 'Version', ], 'actionGroupId' => [ 'shape' => 'Id', ], 'actionGroupName' => [ 'shape' => 'Name', ], 'clientToken' => [ 'shape' => 'ClientToken', ], 'description' => [ 'shape' => 'Description', ], 'createdAt' => [ 'shape' => 'DateTimestamp', ], 'updatedAt' => [ 'shape' => 'DateTimestamp', ], 'parentActionSignature' => [ 'shape' => 'ActionGroupSignature', ], 'parentActionGroupSignatureParams' => [ 'shape' => 'ActionGroupSignatureParams', ], 'actionGroupExecutor' => [ 'shape' => 'ActionGroupExecutor', ], 'apiSchema' => [ 'shape' => 'APISchema', ], 'functionSchema' => [ 'shape' => 'FunctionSchema', ], 'actionGroupState' => [ 'shape' => 'ActionGroupState', ], ], ], 'AgentAlias' => [ 'type' => 'structure', 'required' => [ 'agentId', 'agentAliasId', 'agentAliasName', 'agentAliasArn', 'routingConfiguration', 'createdAt', 'updatedAt', 'agentAliasStatus', ], 'members' => [ 'agentId' => [ 'shape' => 'Id', ], 'agentAliasId' => [ 'shape' => 'AgentAliasId', ], 'agentAliasName' => [ 'shape' => 'Name', ], 'agentAliasArn' => [ 'shape' => 'AgentAliasArn', ], 'clientToken' => [ 'shape' => 'ClientToken', ], 'description' => [ 'shape' => 'Description', ], 'routingConfiguration' => [ 'shape' => 'AgentAliasRoutingConfiguration', ], 'createdAt' => [ 'shape' => 'DateTimestamp', ], 'updatedAt' => [ 'shape' => 'DateTimestamp', ], 'agentAliasHistoryEvents' => [ 'shape' => 'AgentAliasHistoryEvents', ], 'agentAliasStatus' => [ 'shape' => 'AgentAliasStatus', ], 'failureReasons' => [ 'shape' => 'FailureReasons', ], 'aliasInvocationState' => [ 'shape' => 'AliasInvocationState', ], ], ], 'AgentAliasArn' => [ 'type' => 'string', 'max' => 2048, 'min' => 0, 'pattern' => 'arn:aws:bedrock:[a-z0-9-]{1,20}:[0-9]{12}:agent-alias/[0-9a-zA-Z]{10}/[0-9a-zA-Z]{10}', ], 'AgentAliasHistoryEvent' => [ 'type' => 'structure', 'members' => [ 'routingConfiguration' => [ 'shape' => 'AgentAliasRoutingConfiguration', ], 'endDate' => [ 'shape' => 'DateTimestamp', ], 'startDate' => [ 'shape' => 'DateTimestamp', ], ], ], 'AgentAliasHistoryEvents' => [ 'type' => 'list', 'member' => [ 'shape' => 'AgentAliasHistoryEvent', ], 'max' => 10, 'min' => 0, ], 'AgentAliasId' => [ 'type' => 'string', 'max' => 10, 'min' => 10, 'pattern' => '(\\bTSTALIASID\\b|[0-9a-zA-Z]+)', ], 'AgentAliasRoutingConfiguration' => [ 'type' => 'list', 'member' => [ 'shape' => 'AgentAliasRoutingConfigurationListItem', ], 'max' => 1, 'min' => 0, ], 'AgentAliasRoutingConfigurationListItem' => [ 'type' => 'structure', 'members' => [ 'agentVersion' => [ 'shape' => 'Version', ], 'provisionedThroughput' => [ 'shape' => 'ProvisionedModelIdentifier', ], ], ], 'AgentAliasStatus' => [ 'type' => 'string', 'enum' => [ 'CREATING', 'PREPARED', 'FAILED', 'UPDATING', 'DELETING', 'DISSOCIATED', ], ], 'AgentAliasSummaries' => [ 'type' => 'list', 'member' => [ 'shape' => 'AgentAliasSummary', ], 'max' => 10, 'min' => 0, ], 'AgentAliasSummary' => [ 'type' => 'structure', 'required' => [ 'agentAliasId', 'agentAliasName', 'agentAliasStatus', 'createdAt', 'updatedAt', ], 'members' => [ 'agentAliasId' => [ 'shape' => 'AgentAliasId', ], 'agentAliasName' => [ 'shape' => 'Name', ], 'description' => [ 'shape' => 'Description', ], 'routingConfiguration' => [ 'shape' => 'AgentAliasRoutingConfiguration', ], 'agentAliasStatus' => [ 'shape' => 'AgentAliasStatus', ], 'createdAt' => [ 'shape' => 'DateTimestamp', ], 'updatedAt' => [ 'shape' => 'DateTimestamp', ], 'aliasInvocationState' => [ 'shape' => 'AliasInvocationState', ], ], ], 'AgentArn' => [ 'type' => 'string', 'max' => 2048, 'min' => 0, 'pattern' => 'arn:aws:bedrock:[a-z0-9-]{1,20}:[0-9]{12}:agent/[0-9a-zA-Z]{10}', ], 'AgentCollaboration' => [ 'type' => 'string', 'enum' => [ 'SUPERVISOR', 'SUPERVISOR_ROUTER', 'DISABLED', ], ], 'AgentCollaborator' => [ 'type' => 'structure', 'required' => [ 'agentId', 'agentVersion', 'agentDescriptor', 'collaboratorId', 'collaborationInstruction', 'collaboratorName', 'createdAt', 'lastUpdatedAt', ], 'members' => [ 'agentId' => [ 'shape' => 'Id', ], 'agentVersion' => [ 'shape' => 'Version', ], 'agentDescriptor' => [ 'shape' => 'AgentDescriptor', ], 'collaboratorId' => [ 'shape' => 'Id', ], 'collaborationInstruction' => [ 'shape' => 'CollaborationInstruction', ], 'collaboratorName' => [ 'shape' => 'Name', ], 'createdAt' => [ 'shape' => 'DateTimestamp', ], 'lastUpdatedAt' => [ 'shape' => 'DateTimestamp', ], 'relayConversationHistory' => [ 'shape' => 'RelayConversationHistory', ], 'clientToken' => [ 'shape' => 'ClientToken', ], ], ], 'AgentCollaboratorSummaries' => [ 'type' => 'list', 'member' => [ 'shape' => 'AgentCollaboratorSummary', ], 'max' => 10, 'min' => 0, ], 'AgentCollaboratorSummary' => [ 'type' => 'structure', 'required' => [ 'agentId', 'agentVersion', 'collaboratorId', 'agentDescriptor', 'collaborationInstruction', 'relayConversationHistory', 'collaboratorName', 'createdAt', 'lastUpdatedAt', ], 'members' => [ 'agentId' => [ 'shape' => 'Id', ], 'agentVersion' => [ 'shape' => 'Version', ], 'collaboratorId' => [ 'shape' => 'Id', ], 'agentDescriptor' => [ 'shape' => 'AgentDescriptor', ], 'collaborationInstruction' => [ 'shape' => 'CollaborationInstruction', ], 'relayConversationHistory' => [ 'shape' => 'RelayConversationHistory', ], 'collaboratorName' => [ 'shape' => 'Name', ], 'createdAt' => [ 'shape' => 'DateTimestamp', ], 'lastUpdatedAt' => [ 'shape' => 'DateTimestamp', ], ], ], 'AgentDescriptor' => [ 'type' => 'structure', 'members' => [ 'aliasArn' => [ 'shape' => 'AgentAliasArn', ], ], ], 'AgentFlowNodeConfiguration' => [ 'type' => 'structure', 'required' => [ 'agentAliasArn', ], 'members' => [ 'agentAliasArn' => [ 'shape' => 'FlowAgentAliasArn', ], ], ], 'AgentKnowledgeBase' => [ 'type' => 'structure', 'required' => [ 'agentId', 'agentVersion', 'knowledgeBaseId', 'description', 'createdAt', 'updatedAt', 'knowledgeBaseState', ], 'members' => [ 'agentId' => [ 'shape' => 'Id', ], 'agentVersion' => [ 'shape' => 'Version', ], 'knowledgeBaseId' => [ 'shape' => 'Id', ], 'description' => [ 'shape' => 'Description', ], 'createdAt' => [ 'shape' => 'DateTimestamp', ], 'updatedAt' => [ 'shape' => 'DateTimestamp', ], 'knowledgeBaseState' => [ 'shape' => 'KnowledgeBaseState', ], ], ], 'AgentKnowledgeBaseSummaries' => [ 'type' => 'list', 'member' => [ 'shape' => 'AgentKnowledgeBaseSummary', ], 'max' => 10, 'min' => 0, ], 'AgentKnowledgeBaseSummary' => [ 'type' => 'structure', 'required' => [ 'knowledgeBaseId', 'knowledgeBaseState', 'updatedAt', ], 'members' => [ 'knowledgeBaseId' => [ 'shape' => 'Id', ], 'description' => [ 'shape' => 'Description', ], 'knowledgeBaseState' => [ 'shape' => 'KnowledgeBaseState', ], 'updatedAt' => [ 'shape' => 'DateTimestamp', ], ], ], 'AgentRoleArn' => [ 'type' => 'string', 'max' => 2048, 'min' => 0, 'pattern' => 'arn:aws(-[^:]+)?:iam::([0-9]{12})?:role/.+', ], 'AgentStatus' => [ 'type' => 'string', 'enum' => [ 'CREATING', 'PREPARING', 'PREPARED', 'NOT_PREPARED', 'DELETING', 'FAILED', 'VERSIONING', 'UPDATING', ], ], 'AgentSummaries' => [ 'type' => 'list', 'member' => [ 'shape' => 'AgentSummary', ], 'max' => 10, 'min' => 0, ], 'AgentSummary' => [ 'type' => 'structure', 'required' => [ 'agentId', 'agentName', 'agentStatus', 'updatedAt', ], 'members' => [ 'agentId' => [ 'shape' => 'Id', ], 'agentName' => [ 'shape' => 'Name', ], 'agentStatus' => [ 'shape' => 'AgentStatus', ], 'description' => [ 'shape' => 'Description', ], 'updatedAt' => [ 'shape' => 'DateTimestamp', ], 'latestAgentVersion' => [ 'shape' => 'Version', ], 'guardrailConfiguration' => [ 'shape' => 'GuardrailConfiguration', ], ], ], 'AgentVersion' => [ 'type' => 'structure', 'required' => [ 'agentId', 'agentName', 'agentArn', 'version', 'agentStatus', 'idleSessionTTLInSeconds', 'agentResourceRoleArn', 'createdAt', 'updatedAt', ], 'members' => [ 'agentId' => [ 'shape' => 'Id', ], 'agentName' => [ 'shape' => 'Name', ], 'agentArn' => [ 'shape' => 'AgentArn', ], 'version' => [ 'shape' => 'NumericalVersion', ], 'instruction' => [ 'shape' => 'Instruction', ], 'agentStatus' => [ 'shape' => 'AgentStatus', ], 'foundationModel' => [ 'shape' => 'ModelIdentifier', ], 'description' => [ 'shape' => 'Description', ], 'idleSessionTTLInSeconds' => [ 'shape' => 'SessionTTL', ], 'agentResourceRoleArn' => [ 'shape' => 'AgentRoleArn', ], 'customerEncryptionKeyArn' => [ 'shape' => 'KmsKeyArn', ], 'createdAt' => [ 'shape' => 'DateTimestamp', ], 'updatedAt' => [ 'shape' => 'DateTimestamp', ], 'failureReasons' => [ 'shape' => 'FailureReasons', ], 'recommendedActions' => [ 'shape' => 'RecommendedActions', ], 'promptOverrideConfiguration' => [ 'shape' => 'PromptOverrideConfiguration', ], 'guardrailConfiguration' => [ 'shape' => 'GuardrailConfiguration', ], 'memoryConfiguration' => [ 'shape' => 'MemoryConfiguration', ], 'agentCollaboration' => [ 'shape' => 'AgentCollaboration', ], ], ], 'AgentVersionSummaries' => [ 'type' => 'list', 'member' => [ 'shape' => 'AgentVersionSummary', ], 'max' => 10, 'min' => 0, ], 'AgentVersionSummary' => [ 'type' => 'structure', 'required' => [ 'agentName', 'agentStatus', 'agentVersion', 'createdAt', 'updatedAt', ], 'members' => [ 'agentName' => [ 'shape' => 'Name', ], 'agentStatus' => [ 'shape' => 'AgentStatus', ], 'agentVersion' => [ 'shape' => 'Version', ], 'createdAt' => [ 'shape' => 'DateTimestamp', ], 'updatedAt' => [ 'shape' => 'DateTimestamp', ], 'description' => [ 'shape' => 'Description', ], 'guardrailConfiguration' => [ 'shape' => 'GuardrailConfiguration', ], ], ], 'AliasInvocationState' => [ 'type' => 'string', 'enum' => [ 'ACCEPT_INVOCATIONS', 'REJECT_INVOCATIONS', ], ], 'AnyToolChoice' => [ 'type' => 'structure', 'members' => [], ], 'AssociateAgentCollaboratorRequest' => [ 'type' => 'structure', 'required' => [ 'agentId', 'agentVersion', 'agentDescriptor', 'collaboratorName', 'collaborationInstruction', ], 'members' => [ 'agentId' => [ 'shape' => 'Id', 'location' => 'uri', 'locationName' => 'agentId', ], 'agentVersion' => [ 'shape' => 'DraftVersion', 'location' => 'uri', 'locationName' => 'agentVersion', ], 'agentDescriptor' => [ 'shape' => 'AgentDescriptor', ], 'collaboratorName' => [ 'shape' => 'Name', ], 'collaborationInstruction' => [ 'shape' => 'CollaborationInstruction', ], 'relayConversationHistory' => [ 'shape' => 'RelayConversationHistory', ], 'clientToken' => [ 'shape' => 'ClientToken', 'idempotencyToken' => true, ], ], ], 'AssociateAgentCollaboratorResponse' => [ 'type' => 'structure', 'required' => [ 'agentCollaborator', ], 'members' => [ 'agentCollaborator' => [ 'shape' => 'AgentCollaborator', ], ], ], 'AssociateAgentKnowledgeBaseRequest' => [ 'type' => 'structure', 'required' => [ 'agentId', 'agentVersion', 'knowledgeBaseId', 'description', ], 'members' => [ 'agentId' => [ 'shape' => 'Id', 'location' => 'uri', 'locationName' => 'agentId', ], 'agentVersion' => [ 'shape' => 'DraftVersion', 'location' => 'uri', 'locationName' => 'agentVersion', ], 'knowledgeBaseId' => [ 'shape' => 'Id', ], 'description' => [ 'shape' => 'Description', ], 'knowledgeBaseState' => [ 'shape' => 'KnowledgeBaseState', ], ], ], 'AssociateAgentKnowledgeBaseResponse' => [ 'type' => 'structure', 'required' => [ 'agentKnowledgeBase', ], 'members' => [ 'agentKnowledgeBase' => [ 'shape' => 'AgentKnowledgeBase', ], ], ], 'AutoToolChoice' => [ 'type' => 'structure', 'members' => [], ], 'AwsDataCatalogTableName' => [ 'type' => 'string', 'max' => 200, 'min' => 1, 'pattern' => '.*\\.*', ], 'AwsDataCatalogTableNames' => [ 'type' => 'list', 'member' => [ 'shape' => 'AwsDataCatalogTableName', ], 'max' => 1000, 'min' => 1, ], 'BasePromptTemplate' => [ 'type' => 'string', 'max' => 100000, 'min' => 1, 'sensitive' => true, ], 'BedrockDataAutomationConfiguration' => [ 'type' => 'structure', 'members' => [ 'parsingModality' => [ 'shape' => 'ParsingModality', ], ], ], 'BedrockEmbeddingModelArn' => [ 'type' => 'string', 'max' => 2048, 'min' => 20, 'pattern' => '(arn:aws(-[^:]{1,12})?:(bedrock|sagemaker):[a-z0-9-]{1,20}:([0-9]{12})?:([a-z-]+/)?)?([a-zA-Z0-9.-]{1,63}){0,2}(([:][a-z0-9-]{1,63}){0,2})?(/[a-z0-9]{1,12})?', ], 'BedrockEmbeddingModelConfiguration' => [ 'type' => 'structure', 'members' => [ 'dimensions' => [ 'shape' => 'Dimensions', ], 'embeddingDataType' => [ 'shape' => 'EmbeddingDataType', ], ], ], 'BedrockFoundationModelConfiguration' => [ 'type' => 'structure', 'required' => [ 'modelArn', ], 'members' => [ 'modelArn' => [ 'shape' => 'BedrockModelArn', ], 'parsingPrompt' => [ 'shape' => 'ParsingPrompt', ], 'parsingModality' => [ 'shape' => 'ParsingModality', ], ], ], 'BedrockFoundationModelContextEnrichmentConfiguration' => [ 'type' => 'structure', 'required' => [ 'enrichmentStrategyConfiguration', 'modelArn', ], 'members' => [ 'enrichmentStrategyConfiguration' => [ 'shape' => 'EnrichmentStrategyConfiguration', ], 'modelArn' => [ 'shape' => 'BedrockModelArn', ], ], ], 'BedrockModelArn' => [ 'type' => 'string', 'max' => 2048, 'min' => 1, 'pattern' => '(arn:aws(-[^:]{1,12})?:(bedrock):[a-z0-9-]{1,20}:([0-9]{12})?:([a-z-]+/)?)?([a-zA-Z0-9.-]{1,63}){0,2}(([:][a-z0-9-]{1,63}){0,2})?(/[a-z0-9]{1,12})?', ], 'BedrockRerankingModelArn' => [ 'type' => 'string', 'max' => 2048, 'min' => 1, 'pattern' => '(arn:aws(-[^:]+)?:bedrock:[a-z0-9-]{1,20}::foundation-model/(.*))?', ], 'Boolean' => [ 'type' => 'boolean', 'box' => true, ], 'BucketOwnerAccountId' => [ 'type' => 'string', 'max' => 12, 'min' => 12, 'pattern' => '[0-9]{12}', ], 'ByteContentBlob' => [ 'type' => 'blob', 'max' => 5242880, 'min' => 1, 'sensitive' => true, ], 'ByteContentDoc' => [ 'type' => 'structure', 'required' => [ 'mimeType', 'data', ], 'members' => [ 'mimeType' => [ 'shape' => 'ByteContentDocMimeTypeString', ], 'data' => [ 'shape' => 'ByteContentBlob', ], ], ], 'ByteContentDocMimeTypeString' => [ 'type' => 'string', 'pattern' => '.*[a-z]{1,20}/.{1,20}.*', ], 'CachePointBlock' => [ 'type' => 'structure', 'required' => [ 'type', ], 'members' => [ 'type' => [ 'shape' => 'CachePointType', ], ], ], 'CachePointType' => [ 'type' => 'string', 'enum' => [ 'default', ], ], 'ChatPromptTemplateConfiguration' => [ 'type' => 'structure', 'required' => [ 'messages', ], 'members' => [ 'messages' => [ 'shape' => 'Messages', ], 'system' => [ 'shape' => 'SystemContentBlocks', ], 'inputVariables' => [ 'shape' => 'PromptInputVariablesList', ], 'toolConfiguration' => [ 'shape' => 'ToolConfiguration', ], ], 'sensitive' => true, ], 'ChunkingConfiguration' => [ 'type' => 'structure', 'required' => [ 'chunkingStrategy', ], 'members' => [ 'chunkingStrategy' => [ 'shape' => 'ChunkingStrategy', ], 'fixedSizeChunkingConfiguration' => [ 'shape' => 'FixedSizeChunkingConfiguration', ], 'hierarchicalChunkingConfiguration' => [ 'shape' => 'HierarchicalChunkingConfiguration', ], 'semanticChunkingConfiguration' => [ 'shape' => 'SemanticChunkingConfiguration', ], ], ], 'ChunkingStrategy' => [ 'type' => 'string', 'enum' => [ 'FIXED_SIZE', 'NONE', 'HIERARCHICAL', 'SEMANTIC', ], ], 'ClientToken' => [ 'type' => 'string', 'max' => 256, 'min' => 33, 'pattern' => '[a-zA-Z0-9](-*[a-zA-Z0-9]){0,256}', ], 'CollaborationInstruction' => [ 'type' => 'string', 'max' => 4000, 'min' => 1, 'sensitive' => true, ], 'CollectorFlowNodeConfiguration' => [ 'type' => 'structure', 'members' => [], ], 'ColumnName' => [ 'type' => 'string', 'max' => 63, 'min' => 0, 'pattern' => '[a-zA-Z0-9_\\-]+', ], 'ConcurrencyType' => [ 'type' => 'string', 'enum' => [ 'Automatic', 'Manual', ], ], 'ConditionFlowNodeConfiguration' => [ 'type' => 'structure', 'required' => [ 'conditions', ], 'members' => [ 'conditions' => [ 'shape' => 'FlowConditions', ], ], ], 'ConflictException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'NonBlankString', ], ], 'error' => [ 'httpStatusCode' => 409, 'senderFault' => true, ], 'exception' => true, ], 'ConfluenceAuthType' => [ 'type' => 'string', 'enum' => [ 'BASIC', 'OAUTH2_CLIENT_CREDENTIALS', ], ], 'ConfluenceCrawlerConfiguration' => [ 'type' => 'structure', 'members' => [ 'filterConfiguration' => [ 'shape' => 'CrawlFilterConfiguration', ], ], ], 'ConfluenceDataSourceConfiguration' => [ 'type' => 'structure', 'required' => [ 'sourceConfiguration', ], 'members' => [ 'sourceConfiguration' => [ 'shape' => 'ConfluenceSourceConfiguration', ], 'crawlerConfiguration' => [ 'shape' => 'ConfluenceCrawlerConfiguration', ], ], ], 'ConfluenceHostType' => [ 'type' => 'string', 'enum' => [ 'SAAS', ], ], 'ConfluenceSourceConfiguration' => [ 'type' => 'structure', 'required' => [ 'hostUrl', 'hostType', 'authType', 'credentialsSecretArn', ], 'members' => [ 'hostUrl' => [ 'shape' => 'HttpsUrl', ], 'hostType' => [ 'shape' => 'ConfluenceHostType', ], 'authType' => [ 'shape' => 'ConfluenceAuthType', ], 'credentialsSecretArn' => [ 'shape' => 'SecretArn', ], ], ], 'ContentBlock' => [ 'type' => 'structure', 'members' => [ 'text' => [ 'shape' => 'String', ], 'cachePoint' => [ 'shape' => 'CachePointBlock', ], ], 'sensitive' => true, 'union' => true, ], 'ContentBlocks' => [ 'type' => 'list', 'member' => [ 'shape' => 'ContentBlock', ], ], 'ContentDataSourceType' => [ 'type' => 'string', 'enum' => [ 'CUSTOM', 'S3', ], ], 'ContextEnrichmentConfiguration' => [ 'type' => 'structure', 'required' => [ 'type', ], 'members' => [ 'type' => [ 'shape' => 'ContextEnrichmentType', ], 'bedrockFoundationModelConfiguration' => [ 'shape' => 'BedrockFoundationModelContextEnrichmentConfiguration', ], ], ], 'ContextEnrichmentType' => [ 'type' => 'string', 'enum' => [ 'BEDROCK_FOUNDATION_MODEL', ], ], 'ConversationRole' => [ 'type' => 'string', 'enum' => [ 'user', 'assistant', ], ], 'CrawlFilterConfiguration' => [ 'type' => 'structure', 'required' => [ 'type', ], 'members' => [ 'type' => [ 'shape' => 'CrawlFilterConfigurationType', ], 'patternObjectFilter' => [ 'shape' => 'PatternObjectFilterConfiguration', ], ], ], 'CrawlFilterConfigurationType' => [ 'type' => 'string', 'enum' => [ 'PATTERN', ], ], 'CreateAgentActionGroupRequest' => [ 'type' => 'structure', 'required' => [ 'agentId', 'agentVersion', 'actionGroupName', ], 'members' => [ 'agentId' => [ 'shape' => 'Id', 'location' => 'uri', 'locationName' => 'agentId', ], 'agentVersion' => [ 'shape' => 'DraftVersion', 'location' => 'uri', 'locationName' => 'agentVersion', ], 'actionGroupName' => [ 'shape' => 'Name', ], 'clientToken' => [ 'shape' => 'ClientToken', 'idempotencyToken' => true, ], 'description' => [ 'shape' => 'Description', ], 'parentActionGroupSignature' => [ 'shape' => 'ActionGroupSignature', ], 'parentActionGroupSignatureParams' => [ 'shape' => 'ActionGroupSignatureParams', ], 'actionGroupExecutor' => [ 'shape' => 'ActionGroupExecutor', ], 'apiSchema' => [ 'shape' => 'APISchema', ], 'actionGroupState' => [ 'shape' => 'ActionGroupState', ], 'functionSchema' => [ 'shape' => 'FunctionSchema', ], ], ], 'CreateAgentActionGroupResponse' => [ 'type' => 'structure', 'required' => [ 'agentActionGroup', ], 'members' => [ 'agentActionGroup' => [ 'shape' => 'AgentActionGroup', ], ], ], 'CreateAgentAliasRequest' => [ 'type' => 'structure', 'required' => [ 'agentId', 'agentAliasName', ], 'members' => [ 'agentId' => [ 'shape' => 'Id', 'location' => 'uri', 'locationName' => 'agentId', ], 'agentAliasName' => [ 'shape' => 'Name', ], 'clientToken' => [ 'shape' => 'ClientToken', 'idempotencyToken' => true, ], 'description' => [ 'shape' => 'Description', ], 'routingConfiguration' => [ 'shape' => 'AgentAliasRoutingConfiguration', ], 'tags' => [ 'shape' => 'TagsMap', ], ], ], 'CreateAgentAliasResponse' => [ 'type' => 'structure', 'required' => [ 'agentAlias', ], 'members' => [ 'agentAlias' => [ 'shape' => 'AgentAlias', ], ], ], 'CreateAgentRequest' => [ 'type' => 'structure', 'required' => [ 'agentName', ], 'members' => [ 'agentName' => [ 'shape' => 'Name', ], 'clientToken' => [ 'shape' => 'ClientToken', 'idempotencyToken' => true, ], 'instruction' => [ 'shape' => 'Instruction', ], 'foundationModel' => [ 'shape' => 'ModelIdentifier', ], 'description' => [ 'shape' => 'Description', ], 'orchestrationType' => [ 'shape' => 'OrchestrationType', ], 'customOrchestration' => [ 'shape' => 'CustomOrchestration', ], 'idleSessionTTLInSeconds' => [ 'shape' => 'SessionTTL', ], 'agentResourceRoleArn' => [ 'shape' => 'AgentRoleArn', ], 'customerEncryptionKeyArn' => [ 'shape' => 'KmsKeyArn', ], 'tags' => [ 'shape' => 'TagsMap', ], 'promptOverrideConfiguration' => [ 'shape' => 'PromptOverrideConfiguration', ], 'guardrailConfiguration' => [ 'shape' => 'GuardrailConfiguration', ], 'memoryConfiguration' => [ 'shape' => 'MemoryConfiguration', ], 'agentCollaboration' => [ 'shape' => 'AgentCollaboration', ], ], ], 'CreateAgentResponse' => [ 'type' => 'structure', 'required' => [ 'agent', ], 'members' => [ 'agent' => [ 'shape' => 'Agent', ], ], ], 'CreateDataSourceRequest' => [ 'type' => 'structure', 'required' => [ 'knowledgeBaseId', 'name', 'dataSourceConfiguration', ], 'members' => [ 'knowledgeBaseId' => [ 'shape' => 'Id', 'location' => 'uri', 'locationName' => 'knowledgeBaseId', ], 'clientToken' => [ 'shape' => 'ClientToken', 'idempotencyToken' => true, ], 'name' => [ 'shape' => 'Name', ], 'description' => [ 'shape' => 'Description', ], 'dataSourceConfiguration' => [ 'shape' => 'DataSourceConfiguration', ], 'dataDeletionPolicy' => [ 'shape' => 'DataDeletionPolicy', ], 'serverSideEncryptionConfiguration' => [ 'shape' => 'ServerSideEncryptionConfiguration', ], 'vectorIngestionConfiguration' => [ 'shape' => 'VectorIngestionConfiguration', ], ], ], 'CreateDataSourceResponse' => [ 'type' => 'structure', 'required' => [ 'dataSource', ], 'members' => [ 'dataSource' => [ 'shape' => 'DataSource', ], ], ], 'CreateFlowAliasRequest' => [ 'type' => 'structure', 'required' => [ 'name', 'routingConfiguration', 'flowIdentifier', ], 'members' => [ 'name' => [ 'shape' => 'Name', ], 'description' => [ 'shape' => 'Description', ], 'routingConfiguration' => [ 'shape' => 'FlowAliasRoutingConfiguration', ], 'concurrencyConfiguration' => [ 'shape' => 'FlowAliasConcurrencyConfiguration', ], 'flowIdentifier' => [ 'shape' => 'FlowIdentifier', 'location' => 'uri', 'locationName' => 'flowIdentifier', ], 'clientToken' => [ 'shape' => 'ClientToken', 'idempotencyToken' => true, ], 'tags' => [ 'shape' => 'TagsMap', ], ], ], 'CreateFlowAliasResponse' => [ 'type' => 'structure', 'required' => [ 'name', 'routingConfiguration', 'flowId', 'id', 'arn', 'createdAt', 'updatedAt', ], 'members' => [ 'name' => [ 'shape' => 'Name', ], 'description' => [ 'shape' => 'Description', ], 'routingConfiguration' => [ 'shape' => 'FlowAliasRoutingConfiguration', ], 'concurrencyConfiguration' => [ 'shape' => 'FlowAliasConcurrencyConfiguration', ], 'flowId' => [ 'shape' => 'FlowId', ], 'id' => [ 'shape' => 'FlowAliasId', ], 'arn' => [ 'shape' => 'FlowAliasArn', ], 'createdAt' => [ 'shape' => 'DateTimestamp', ], 'updatedAt' => [ 'shape' => 'DateTimestamp', ], ], ], 'CreateFlowRequest' => [ 'type' => 'structure', 'required' => [ 'name', 'executionRoleArn', ], 'members' => [ 'name' => [ 'shape' => 'FlowName', ], 'description' => [ 'shape' => 'FlowDescription', ], 'executionRoleArn' => [ 'shape' => 'FlowExecutionRoleArn', ], 'customerEncryptionKeyArn' => [ 'shape' => 'KmsKeyArn', ], 'definition' => [ 'shape' => 'FlowDefinition', ], 'clientToken' => [ 'shape' => 'ClientToken', 'idempotencyToken' => true, ], 'tags' => [ 'shape' => 'TagsMap', ], ], ], 'CreateFlowResponse' => [ 'type' => 'structure', 'required' => [ 'name', 'executionRoleArn', 'id', 'arn', 'status', 'createdAt', 'updatedAt', 'version', ], 'members' => [ 'name' => [ 'shape' => 'FlowName', ], 'description' => [ 'shape' => 'FlowDescription', ], 'executionRoleArn' => [ 'shape' => 'FlowExecutionRoleArn', ], 'customerEncryptionKeyArn' => [ 'shape' => 'KmsKeyArn', ], 'id' => [ 'shape' => 'FlowId', ], 'arn' => [ 'shape' => 'FlowArn', ], 'status' => [ 'shape' => 'FlowStatus', ], 'createdAt' => [ 'shape' => 'DateTimestamp', ], 'updatedAt' => [ 'shape' => 'DateTimestamp', ], 'version' => [ 'shape' => 'DraftVersion', ], 'definition' => [ 'shape' => 'FlowDefinition', ], ], ], 'CreateFlowVersionRequest' => [ 'type' => 'structure', 'required' => [ 'flowIdentifier', ], 'members' => [ 'flowIdentifier' => [ 'shape' => 'FlowIdentifier', 'location' => 'uri', 'locationName' => 'flowIdentifier', ], 'description' => [ 'shape' => 'FlowDescription', ], 'clientToken' => [ 'shape' => 'ClientToken', 'idempotencyToken' => true, ], ], ], 'CreateFlowVersionResponse' => [ 'type' => 'structure', 'required' => [ 'name', 'executionRoleArn', 'id', 'arn', 'status', 'createdAt', 'version', ], 'members' => [ 'name' => [ 'shape' => 'FlowName', ], 'description' => [ 'shape' => 'FlowDescription', ], 'executionRoleArn' => [ 'shape' => 'FlowExecutionRoleArn', ], 'customerEncryptionKeyArn' => [ 'shape' => 'KmsKeyArn', ], 'id' => [ 'shape' => 'FlowId', ], 'arn' => [ 'shape' => 'FlowArn', ], 'status' => [ 'shape' => 'FlowStatus', ], 'createdAt' => [ 'shape' => 'DateTimestamp', ], 'version' => [ 'shape' => 'NumericalVersion', ], 'definition' => [ 'shape' => 'FlowDefinition', ], ], ], 'CreateKnowledgeBaseRequest' => [ 'type' => 'structure', 'required' => [ 'name', 'roleArn', 'knowledgeBaseConfiguration', ], 'members' => [ 'clientToken' => [ 'shape' => 'ClientToken', 'idempotencyToken' => true, ], 'name' => [ 'shape' => 'Name', ], 'description' => [ 'shape' => 'Description', ], 'roleArn' => [ 'shape' => 'KnowledgeBaseRoleArn', ], 'knowledgeBaseConfiguration' => [ 'shape' => 'KnowledgeBaseConfiguration', ], 'storageConfiguration' => [ 'shape' => 'StorageConfiguration', ], 'tags' => [ 'shape' => 'TagsMap', ], ], ], 'CreateKnowledgeBaseResponse' => [ 'type' => 'structure', 'required' => [ 'knowledgeBase', ], 'members' => [ 'knowledgeBase' => [ 'shape' => 'KnowledgeBase', ], ], ], 'CreatePromptRequest' => [ 'type' => 'structure', 'required' => [ 'name', ], 'members' => [ 'name' => [ 'shape' => 'PromptName', ], 'description' => [ 'shape' => 'PromptDescription', ], 'customerEncryptionKeyArn' => [ 'shape' => 'KmsKeyArn', ], 'defaultVariant' => [ 'shape' => 'PromptVariantName', ], 'variants' => [ 'shape' => 'PromptVariantList', ], 'clientToken' => [ 'shape' => 'ClientToken', 'idempotencyToken' => true, ], 'tags' => [ 'shape' => 'TagsMap', ], ], ], 'CreatePromptResponse' => [ 'type' => 'structure', 'required' => [ 'name', 'id', 'arn', 'version', 'createdAt', 'updatedAt', ], 'members' => [ 'name' => [ 'shape' => 'PromptName', ], 'description' => [ 'shape' => 'PromptDescription', ], 'customerEncryptionKeyArn' => [ 'shape' => 'KmsKeyArn', ], 'defaultVariant' => [ 'shape' => 'PromptVariantName', ], 'variants' => [ 'shape' => 'PromptVariantList', ], 'id' => [ 'shape' => 'PromptId', ], 'arn' => [ 'shape' => 'PromptArn', ], 'version' => [ 'shape' => 'Version', ], 'createdAt' => [ 'shape' => 'DateTimestamp', ], 'updatedAt' => [ 'shape' => 'DateTimestamp', ], ], ], 'CreatePromptVersionRequest' => [ 'type' => 'structure', 'required' => [ 'promptIdentifier', ], 'members' => [ 'promptIdentifier' => [ 'shape' => 'PromptIdentifier', 'location' => 'uri', 'locationName' => 'promptIdentifier', ], 'description' => [ 'shape' => 'PromptDescription', ], 'clientToken' => [ 'shape' => 'ClientToken', 'idempotencyToken' => true, ], 'tags' => [ 'shape' => 'TagsMap', ], ], ], 'CreatePromptVersionResponse' => [ 'type' => 'structure', 'required' => [ 'name', 'id', 'arn', 'version', 'createdAt', 'updatedAt', ], 'members' => [ 'name' => [ 'shape' => 'PromptName', ], 'description' => [ 'shape' => 'PromptDescription', ], 'customerEncryptionKeyArn' => [ 'shape' => 'KmsKeyArn', ], 'defaultVariant' => [ 'shape' => 'PromptVariantName', ], 'variants' => [ 'shape' => 'PromptVariantList', ], 'id' => [ 'shape' => 'PromptId', ], 'arn' => [ 'shape' => 'PromptArn', ], 'version' => [ 'shape' => 'Version', ], 'createdAt' => [ 'shape' => 'DateTimestamp', ], 'updatedAt' => [ 'shape' => 'DateTimestamp', ], ], ], 'CreationMode' => [ 'type' => 'string', 'enum' => [ 'DEFAULT', 'OVERRIDDEN', ], ], 'CuratedQueries' => [ 'type' => 'list', 'member' => [ 'shape' => 'CuratedQuery', ], 'max' => 10, 'min' => 0, ], 'CuratedQuery' => [ 'type' => 'structure', 'required' => [ 'naturalLanguage', 'sql', ], 'members' => [ 'naturalLanguage' => [ 'shape' => 'NaturalLanguageString', ], 'sql' => [ 'shape' => 'SqlString', ], ], ], 'CustomContent' => [ 'type' => 'structure', 'required' => [ 'customDocumentIdentifier', 'sourceType', ], 'members' => [ 'customDocumentIdentifier' => [ 'shape' => 'CustomDocumentIdentifier', ], 'sourceType' => [ 'shape' => 'CustomSourceType', ], 's3Location' => [ 'shape' => 'CustomS3Location', ], 'inlineContent' => [ 'shape' => 'InlineContent', ], ], ], 'CustomControlMethod' => [ 'type' => 'string', 'enum' => [ 'RETURN_CONTROL', ], ], 'CustomDocumentIdentifier' => [ 'type' => 'structure', 'required' => [ 'id', ], 'members' => [ 'id' => [ 'shape' => 'CustomDocumentIdentifierIdString', ], ], ], 'CustomDocumentIdentifierIdString' => [ 'type' => 'string', 'max' => 2048, 'min' => 1, ], 'CustomOrchestration' => [ 'type' => 'structure', 'members' => [ 'executor' => [ 'shape' => 'OrchestrationExecutor', ], ], ], 'CustomS3Location' => [ 'type' => 'structure', 'required' => [ 'uri', ], 'members' => [ 'uri' => [ 'shape' => 'S3ObjectUri', ], 'bucketOwnerAccountId' => [ 'shape' => 'BucketOwnerAccountId', ], ], ], 'CustomSourceType' => [ 'type' => 'string', 'enum' => [ 'IN_LINE', 'S3_LOCATION', ], ], 'CustomTransformationConfiguration' => [ 'type' => 'structure', 'required' => [ 'intermediateStorage', 'transformations', ], 'members' => [ 'intermediateStorage' => [ 'shape' => 'IntermediateStorage', ], 'transformations' => [ 'shape' => 'Transformations', ], ], ], 'CyclicConnectionFlowValidationDetails' => [ 'type' => 'structure', 'required' => [ 'connection', ], 'members' => [ 'connection' => [ 'shape' => 'FlowConnectionName', ], ], ], 'Data' => [ 'type' => 'string', 'max' => 5242880, 'min' => 1, 'sensitive' => true, ], 'DataDeletionPolicy' => [ 'type' => 'string', 'enum' => [ 'RETAIN', 'DELETE', ], ], 'DataSource' => [ 'type' => 'structure', 'required' => [ 'knowledgeBaseId', 'dataSourceId', 'name', 'status', 'dataSourceConfiguration', 'createdAt', 'updatedAt', ], 'members' => [ 'knowledgeBaseId' => [ 'shape' => 'Id', ], 'dataSourceId' => [ 'shape' => 'Id', ], 'name' => [ 'shape' => 'Name', ], 'status' => [ 'shape' => 'DataSourceStatus', ], 'description' => [ 'shape' => 'Description', ], 'dataSourceConfiguration' => [ 'shape' => 'DataSourceConfiguration', ], 'serverSideEncryptionConfiguration' => [ 'shape' => 'ServerSideEncryptionConfiguration', ], 'vectorIngestionConfiguration' => [ 'shape' => 'VectorIngestionConfiguration', ], 'dataDeletionPolicy' => [ 'shape' => 'DataDeletionPolicy', ], 'createdAt' => [ 'shape' => 'DateTimestamp', ], 'updatedAt' => [ 'shape' => 'DateTimestamp', ], 'failureReasons' => [ 'shape' => 'FailureReasons', ], ], ], 'DataSourceConfiguration' => [ 'type' => 'structure', 'required' => [ 'type', ], 'members' => [ 'type' => [ 'shape' => 'DataSourceType', ], 's3Configuration' => [ 'shape' => 'S3DataSourceConfiguration', ], 'webConfiguration' => [ 'shape' => 'WebDataSourceConfiguration', ], 'confluenceConfiguration' => [ 'shape' => 'ConfluenceDataSourceConfiguration', ], 'salesforceConfiguration' => [ 'shape' => 'SalesforceDataSourceConfiguration', ], 'sharePointConfiguration' => [ 'shape' => 'SharePointDataSourceConfiguration', ], ], ], 'DataSourceStatus' => [ 'type' => 'string', 'enum' => [ 'AVAILABLE', 'DELETING', 'DELETE_UNSUCCESSFUL', ], ], 'DataSourceSummaries' => [ 'type' => 'list', 'member' => [ 'shape' => 'DataSourceSummary', ], ], 'DataSourceSummary' => [ 'type' => 'structure', 'required' => [ 'knowledgeBaseId', 'dataSourceId', 'name', 'status', 'updatedAt', ], 'members' => [ 'knowledgeBaseId' => [ 'shape' => 'Id', ], 'dataSourceId' => [ 'shape' => 'Id', ], 'name' => [ 'shape' => 'Name', ], 'status' => [ 'shape' => 'DataSourceStatus', ], 'description' => [ 'shape' => 'Description', ], 'updatedAt' => [ 'shape' => 'DateTimestamp', ], ], ], 'DataSourceType' => [ 'type' => 'string', 'enum' => [ 'S3', 'WEB', 'CONFLUENCE', 'SALESFORCE', 'SHAREPOINT', 'CUSTOM', 'REDSHIFT_METADATA', ], ], 'DateTimestamp' => [ 'type' => 'timestamp', 'timestampFormat' => 'iso8601', ], 'DeleteAgentActionGroupRequest' => [ 'type' => 'structure', 'required' => [ 'agentId', 'agentVersion', 'actionGroupId', ], 'members' => [ 'agentId' => [ 'shape' => 'Id', 'location' => 'uri', 'locationName' => 'agentId', ], 'agentVersion' => [ 'shape' => 'DraftVersion', 'location' => 'uri', 'locationName' => 'agentVersion', ], 'actionGroupId' => [ 'shape' => 'Id', 'location' => 'uri', 'locationName' => 'actionGroupId', ], 'skipResourceInUseCheck' => [ 'shape' => 'Boolean', 'location' => 'querystring', 'locationName' => 'skipResourceInUseCheck', ], ], ], 'DeleteAgentActionGroupResponse' => [ 'type' => 'structure', 'members' => [], ], 'DeleteAgentAliasRequest' => [ 'type' => 'structure', 'required' => [ 'agentId', 'agentAliasId', ], 'members' => [ 'agentId' => [ 'shape' => 'Id', 'location' => 'uri', 'locationName' => 'agentId', ], 'agentAliasId' => [ 'shape' => 'AgentAliasId', 'location' => 'uri', 'locationName' => 'agentAliasId', ], ], ], 'DeleteAgentAliasResponse' => [ 'type' => 'structure', 'required' => [ 'agentId', 'agentAliasId', 'agentAliasStatus', ], 'members' => [ 'agentId' => [ 'shape' => 'Id', ], 'agentAliasId' => [ 'shape' => 'AgentAliasId', ], 'agentAliasStatus' => [ 'shape' => 'AgentAliasStatus', ], ], ], 'DeleteAgentRequest' => [ 'type' => 'structure', 'required' => [ 'agentId', ], 'members' => [ 'agentId' => [ 'shape' => 'Id', 'location' => 'uri', 'locationName' => 'agentId', ], 'skipResourceInUseCheck' => [ 'shape' => 'Boolean', 'location' => 'querystring', 'locationName' => 'skipResourceInUseCheck', ], ], ], 'DeleteAgentResponse' => [ 'type' => 'structure', 'required' => [ 'agentId', 'agentStatus', ], 'members' => [ 'agentId' => [ 'shape' => 'Id', ], 'agentStatus' => [ 'shape' => 'AgentStatus', ], ], ], 'DeleteAgentVersionRequest' => [ 'type' => 'structure', 'required' => [ 'agentId', 'agentVersion', ], 'members' => [ 'agentId' => [ 'shape' => 'Id', 'location' => 'uri', 'locationName' => 'agentId', ], 'agentVersion' => [ 'shape' => 'NumericalVersion', 'location' => 'uri', 'locationName' => 'agentVersion', ], 'skipResourceInUseCheck' => [ 'shape' => 'Boolean', 'location' => 'querystring', 'locationName' => 'skipResourceInUseCheck', ], ], ], 'DeleteAgentVersionResponse' => [ 'type' => 'structure', 'required' => [ 'agentId', 'agentVersion', 'agentStatus', ], 'members' => [ 'agentId' => [ 'shape' => 'Id', ], 'agentVersion' => [ 'shape' => 'NumericalVersion', ], 'agentStatus' => [ 'shape' => 'AgentStatus', ], ], ], 'DeleteDataSourceRequest' => [ 'type' => 'structure', 'required' => [ 'knowledgeBaseId', 'dataSourceId', ], 'members' => [ 'knowledgeBaseId' => [ 'shape' => 'Id', 'location' => 'uri', 'locationName' => 'knowledgeBaseId', ], 'dataSourceId' => [ 'shape' => 'Id', 'location' => 'uri', 'locationName' => 'dataSourceId', ], ], ], 'DeleteDataSourceResponse' => [ 'type' => 'structure', 'required' => [ 'knowledgeBaseId', 'dataSourceId', 'status', ], 'members' => [ 'knowledgeBaseId' => [ 'shape' => 'Id', ], 'dataSourceId' => [ 'shape' => 'Id', ], 'status' => [ 'shape' => 'DataSourceStatus', ], ], ], 'DeleteFlowAliasRequest' => [ 'type' => 'structure', 'required' => [ 'flowIdentifier', 'aliasIdentifier', ], 'members' => [ 'flowIdentifier' => [ 'shape' => 'FlowIdentifier', 'location' => 'uri', 'locationName' => 'flowIdentifier', ], 'aliasIdentifier' => [ 'shape' => 'FlowAliasIdentifier', 'location' => 'uri', 'locationName' => 'aliasIdentifier', ], ], ], 'DeleteFlowAliasResponse' => [ 'type' => 'structure', 'required' => [ 'flowId', 'id', ], 'members' => [ 'flowId' => [ 'shape' => 'FlowId', ], 'id' => [ 'shape' => 'FlowAliasId', ], ], ], 'DeleteFlowRequest' => [ 'type' => 'structure', 'required' => [ 'flowIdentifier', ], 'members' => [ 'flowIdentifier' => [ 'shape' => 'FlowIdentifier', 'location' => 'uri', 'locationName' => 'flowIdentifier', ], 'skipResourceInUseCheck' => [ 'shape' => 'Boolean', 'location' => 'querystring', 'locationName' => 'skipResourceInUseCheck', ], ], ], 'DeleteFlowResponse' => [ 'type' => 'structure', 'required' => [ 'id', ], 'members' => [ 'id' => [ 'shape' => 'FlowId', ], ], ], 'DeleteFlowVersionRequest' => [ 'type' => 'structure', 'required' => [ 'flowIdentifier', 'flowVersion', ], 'members' => [ 'flowIdentifier' => [ 'shape' => 'FlowIdentifier', 'location' => 'uri', 'locationName' => 'flowIdentifier', ], 'flowVersion' => [ 'shape' => 'NumericalVersion', 'location' => 'uri', 'locationName' => 'flowVersion', ], 'skipResourceInUseCheck' => [ 'shape' => 'Boolean', 'location' => 'querystring', 'locationName' => 'skipResourceInUseCheck', ], ], ], 'DeleteFlowVersionResponse' => [ 'type' => 'structure', 'required' => [ 'id', 'version', ], 'members' => [ 'id' => [ 'shape' => 'Id', ], 'version' => [ 'shape' => 'NumericalVersion', ], ], ], 'DeleteKnowledgeBaseDocumentsRequest' => [ 'type' => 'structure', 'required' => [ 'knowledgeBaseId', 'dataSourceId', 'documentIdentifiers', ], 'members' => [ 'knowledgeBaseId' => [ 'shape' => 'Id', 'location' => 'uri', 'locationName' => 'knowledgeBaseId', ], 'dataSourceId' => [ 'shape' => 'Id', 'location' => 'uri', 'locationName' => 'dataSourceId', ], 'clientToken' => [ 'shape' => 'ClientToken', 'idempotencyToken' => true, ], 'documentIdentifiers' => [ 'shape' => 'DocumentIdentifiers', ], ], ], 'DeleteKnowledgeBaseDocumentsResponse' => [ 'type' => 'structure', 'members' => [ 'documentDetails' => [ 'shape' => 'KnowledgeBaseDocumentDetails', ], ], ], 'DeleteKnowledgeBaseRequest' => [ 'type' => 'structure', 'required' => [ 'knowledgeBaseId', ], 'members' => [ 'knowledgeBaseId' => [ 'shape' => 'Id', 'location' => 'uri', 'locationName' => 'knowledgeBaseId', ], ], ], 'DeleteKnowledgeBaseResponse' => [ 'type' => 'structure', 'required' => [ 'knowledgeBaseId', 'status', ], 'members' => [ 'knowledgeBaseId' => [ 'shape' => 'Id', ], 'status' => [ 'shape' => 'KnowledgeBaseStatus', ], ], ], 'DeletePromptRequest' => [ 'type' => 'structure', 'required' => [ 'promptIdentifier', ], 'members' => [ 'promptIdentifier' => [ 'shape' => 'PromptIdentifier', 'location' => 'uri', 'locationName' => 'promptIdentifier', ], 'promptVersion' => [ 'shape' => 'NumericalVersion', 'location' => 'querystring', 'locationName' => 'promptVersion', ], ], ], 'DeletePromptResponse' => [ 'type' => 'structure', 'required' => [ 'id', ], 'members' => [ 'id' => [ 'shape' => 'PromptId', ], 'version' => [ 'shape' => 'NumericalVersion', ], ], ], 'Description' => [ 'type' => 'string', 'max' => 200, 'min' => 1, ], 'DescriptionString' => [ 'type' => 'string', 'max' => 200, 'min' => 1, ], 'Dimensions' => [ 'type' => 'integer', 'box' => true, 'max' => 4096, 'min' => 0, ], 'DisassociateAgentCollaboratorRequest' => [ 'type' => 'structure', 'required' => [ 'agentId', 'agentVersion', 'collaboratorId', ], 'members' => [ 'agentId' => [ 'shape' => 'Id', 'location' => 'uri', 'locationName' => 'agentId', ], 'agentVersion' => [ 'shape' => 'DraftVersion', 'location' => 'uri', 'locationName' => 'agentVersion', ], 'collaboratorId' => [ 'shape' => 'Id', 'location' => 'uri', 'locationName' => 'collaboratorId', ], ], ], 'DisassociateAgentCollaboratorResponse' => [ 'type' => 'structure', 'members' => [], ], 'DisassociateAgentKnowledgeBaseRequest' => [ 'type' => 'structure', 'required' => [ 'agentId', 'agentVersion', 'knowledgeBaseId', ], 'members' => [ 'agentId' => [ 'shape' => 'Id', 'location' => 'uri', 'locationName' => 'agentId', ], 'agentVersion' => [ 'shape' => 'DraftVersion', 'location' => 'uri', 'locationName' => 'agentVersion', ], 'knowledgeBaseId' => [ 'shape' => 'Id', 'location' => 'uri', 'locationName' => 'knowledgeBaseId', ], ], ], 'DisassociateAgentKnowledgeBaseResponse' => [ 'type' => 'structure', 'members' => [], ], 'Document' => [ 'type' => 'structure', 'members' => [], 'document' => true, ], 'DocumentContent' => [ 'type' => 'structure', 'required' => [ 'dataSourceType', ], 'members' => [ 'dataSourceType' => [ 'shape' => 'ContentDataSourceType', ], 'custom' => [ 'shape' => 'CustomContent', ], 's3' => [ 'shape' => 'S3Content', ], ], ], 'DocumentIdentifier' => [ 'type' => 'structure', 'required' => [ 'dataSourceType', ], 'members' => [ 'dataSourceType' => [ 'shape' => 'ContentDataSourceType', ], 's3' => [ 'shape' => 'S3Location', ], 'custom' => [ 'shape' => 'CustomDocumentIdentifier', ], ], ], 'DocumentIdentifiers' => [ 'type' => 'list', 'member' => [ 'shape' => 'DocumentIdentifier', ], 'max' => 10, 'min' => 1, ], 'DocumentMetadata' => [ 'type' => 'structure', 'required' => [ 'type', ], 'members' => [ 'type' => [ 'shape' => 'MetadataSourceType', ], 'inlineAttributes' => [ 'shape' => 'DocumentMetadataInlineAttributesList', ], 's3Location' => [ 'shape' => 'CustomS3Location', ], ], ], 'DocumentMetadataInlineAttributesList' => [ 'type' => 'list', 'member' => [ 'shape' => 'MetadataAttribute', ], 'max' => 50, 'min' => 1, ], 'DocumentStatus' => [ 'type' => 'string', 'enum' => [ 'INDEXED', 'PARTIALLY_INDEXED', 'PENDING', 'FAILED', 'METADATA_PARTIALLY_INDEXED', 'METADATA_UPDATE_FAILED', 'IGNORED', 'NOT_FOUND', 'STARTING', 'IN_PROGRESS', 'DELETING', 'DELETE_IN_PROGRESS', ], ], 'DraftVersion' => [ 'type' => 'string', 'max' => 5, 'min' => 5, 'pattern' => 'DRAFT', ], 'DuplicateConditionExpressionFlowValidationDetails' => [ 'type' => 'structure', 'required' => [ 'node', 'expression', ], 'members' => [ 'node' => [ 'shape' => 'FlowNodeName', ], 'expression' => [ 'shape' => 'FlowConditionExpression', ], ], ], 'DuplicateConnectionsFlowValidationDetails' => [ 'type' => 'structure', 'required' => [ 'source', 'target', ], 'members' => [ 'source' => [ 'shape' => 'FlowNodeName', ], 'target' => [ 'shape' => 'FlowNodeName', ], ], ], 'EmbeddingDataType' => [ 'type' => 'string', 'enum' => [ 'FLOAT32', 'BINARY', ], ], 'EmbeddingModelConfiguration' => [ 'type' => 'structure', 'members' => [ 'bedrockEmbeddingModelConfiguration' => [ 'shape' => 'BedrockEmbeddingModelConfiguration', ], ], ], 'EnabledMemoryTypes' => [ 'type' => 'list', 'member' => [ 'shape' => 'MemoryType', ], 'max' => 1, 'min' => 1, ], 'EnrichmentStrategyConfiguration' => [ 'type' => 'structure', 'required' => [ 'method', ], 'members' => [ 'method' => [ 'shape' => 'EnrichmentStrategyMethod', ], ], ], 'EnrichmentStrategyMethod' => [ 'type' => 'string', 'enum' => [ 'CHUNK_ENTITY_EXTRACTION', ], ], 'ErrorMessage' => [ 'type' => 'string', 'max' => 2048, 'min' => 0, ], 'FailureReason' => [ 'type' => 'string', 'max' => 2048, 'min' => 0, ], 'FailureReasons' => [ 'type' => 'list', 'member' => [ 'shape' => 'FailureReason', ], 'max' => 2048, 'min' => 0, ], 'FieldForReranking' => [ 'type' => 'structure', 'required' => [ 'fieldName', ], 'members' => [ 'fieldName' => [ 'shape' => 'FieldForRerankingFieldNameString', ], ], ], 'FieldForRerankingFieldNameString' => [ 'type' => 'string', 'max' => 2000, 'min' => 1, ], 'FieldName' => [ 'type' => 'string', 'max' => 2048, 'min' => 0, 'pattern' => '.*', ], 'FieldsForReranking' => [ 'type' => 'list', 'member' => [ 'shape' => 'FieldForReranking', ], 'max' => 100, 'min' => 1, 'sensitive' => true, ], 'FilterList' => [ 'type' => 'list', 'member' => [ 'shape' => 'FilterPattern', ], 'max' => 25, 'min' => 1, 'sensitive' => true, ], 'FilterPattern' => [ 'type' => 'string', 'max' => 1000, 'min' => 1, 'sensitive' => true, ], 'FilteredObjectType' => [ 'type' => 'string', 'max' => 50, 'min' => 1, 'sensitive' => true, ], 'FixedSizeChunkingConfiguration' => [ 'type' => 'structure', 'required' => [ 'maxTokens', 'overlapPercentage', ], 'members' => [ 'maxTokens' => [ 'shape' => 'FixedSizeChunkingConfigurationMaxTokensInteger', ], 'overlapPercentage' => [ 'shape' => 'FixedSizeChunkingConfigurationOverlapPercentageInteger', ], ], ], 'FixedSizeChunkingConfigurationMaxTokensInteger' => [ 'type' => 'integer', 'box' => true, 'min' => 1, ], 'FixedSizeChunkingConfigurationOverlapPercentageInteger' => [ 'type' => 'integer', 'box' => true, 'max' => 99, 'min' => 1, ], 'FlowAgentAliasArn' => [ 'type' => 'string', 'max' => 2048, 'min' => 0, 'pattern' => '$|^arn:aws(-cn|-us-gov|-eusc|-iso(-[b-f])?)?:bedrock:[a-z0-9-]{1,20}:[0-9]{12}:agent-alias/[0-9a-zA-Z]{10}/[0-9a-zA-Z]{10}', ], 'FlowAliasArn' => [ 'type' => 'string', 'pattern' => 'arn:aws:bedrock:[a-z0-9-]{1,20}:[0-9]{12}:flow/[0-9a-zA-Z]{10}/alias/(TSTALIASID|[0-9a-zA-Z]{10})', ], 'FlowAliasConcurrencyConfiguration' => [ 'type' => 'structure', 'required' => [ 'type', ], 'members' => [ 'type' => [ 'shape' => 'ConcurrencyType', ], 'maxConcurrency' => [ 'shape' => 'FlowAliasConcurrencyConfigurationMaxConcurrencyInteger', ], ], ], 'FlowAliasConcurrencyConfigurationMaxConcurrencyInteger' => [ 'type' => 'integer', 'box' => true, 'max' => 100, 'min' => 1, ], 'FlowAliasId' => [ 'type' => 'string', 'pattern' => '(TSTALIASID|[0-9a-zA-Z]{10})', ], 'FlowAliasIdentifier' => [ 'type' => 'string', 'pattern' => '(arn:aws:bedrock:[a-z0-9-]{1,20}:[0-9]{12}:flow/[0-9a-zA-Z]{10}/alias/[0-9a-zA-Z]{10})|(TSTALIASID|[0-9a-zA-Z]{10})', ], 'FlowAliasRoutingConfiguration' => [ 'type' => 'list', 'member' => [ 'shape' => 'FlowAliasRoutingConfigurationListItem', ], 'max' => 1, 'min' => 1, ], 'FlowAliasRoutingConfigurationListItem' => [ 'type' => 'structure', 'members' => [ 'flowVersion' => [ 'shape' => 'Version', ], ], ], 'FlowAliasSummaries' => [ 'type' => 'list', 'member' => [ 'shape' => 'FlowAliasSummary', ], 'max' => 10, 'min' => 0, ], 'FlowAliasSummary' => [ 'type' => 'structure', 'required' => [ 'name', 'routingConfiguration', 'flowId', 'id', 'arn', 'createdAt', 'updatedAt', ], 'members' => [ 'name' => [ 'shape' => 'Name', ], 'description' => [ 'shape' => 'Description', ], 'routingConfiguration' => [ 'shape' => 'FlowAliasRoutingConfiguration', ], 'concurrencyConfiguration' => [ 'shape' => 'FlowAliasConcurrencyConfiguration', ], 'flowId' => [ 'shape' => 'FlowId', ], 'id' => [ 'shape' => 'FlowAliasId', ], 'arn' => [ 'shape' => 'FlowAliasArn', ], 'createdAt' => [ 'shape' => 'DateTimestamp', ], 'updatedAt' => [ 'shape' => 'DateTimestamp', ], ], ], 'FlowArn' => [ 'type' => 'string', 'pattern' => 'arn:aws:bedrock:[a-z0-9-]{1,20}:[0-9]{12}:flow/[0-9a-zA-Z]{10}', ], 'FlowCondition' => [ 'type' => 'structure', 'required' => [ 'name', ], 'members' => [ 'name' => [ 'shape' => 'FlowConditionName', ], 'expression' => [ 'shape' => 'FlowConditionExpression', ], ], ], 'FlowConditionExpression' => [ 'type' => 'string', 'max' => 64, 'min' => 1, 'sensitive' => true, ], 'FlowConditionName' => [ 'type' => 'string', 'pattern' => '[a-zA-Z]([_]?[0-9a-zA-Z]){1,50}', ], 'FlowConditionalConnectionConfiguration' => [ 'type' => 'structure', 'required' => [ 'condition', ], 'members' => [ 'condition' => [ 'shape' => 'FlowConditionName', ], ], ], 'FlowConditions' => [ 'type' => 'list', 'member' => [ 'shape' => 'FlowCondition', ], 'max' => 5, 'min' => 1, ], 'FlowConnection' => [ 'type' => 'structure', 'required' => [ 'type', 'name', 'source', 'target', ], 'members' => [ 'type' => [ 'shape' => 'FlowConnectionType', ], 'name' => [ 'shape' => 'FlowConnectionName', ], 'source' => [ 'shape' => 'FlowNodeName', ], 'target' => [ 'shape' => 'FlowNodeName', ], 'configuration' => [ 'shape' => 'FlowConnectionConfiguration', ], ], ], 'FlowConnectionConfiguration' => [ 'type' => 'structure', 'members' => [ 'data' => [ 'shape' => 'FlowDataConnectionConfiguration', ], 'conditional' => [ 'shape' => 'FlowConditionalConnectionConfiguration', ], ], 'union' => true, ], 'FlowConnectionName' => [ 'type' => 'string', 'pattern' => '[a-zA-Z]([_]?[0-9a-zA-Z]){1,100}', ], 'FlowConnectionType' => [ 'type' => 'string', 'enum' => [ 'Data', 'Conditional', ], ], 'FlowConnections' => [ 'type' => 'list', 'member' => [ 'shape' => 'FlowConnection', ], 'max' => 20, 'min' => 0, ], 'FlowDataConnectionConfiguration' => [ 'type' => 'structure', 'required' => [ 'sourceOutput', 'targetInput', ], 'members' => [ 'sourceOutput' => [ 'shape' => 'FlowNodeOutputName', ], 'targetInput' => [ 'shape' => 'FlowNodeInputName', ], ], ], 'FlowDefinition' => [ 'type' => 'structure', 'members' => [ 'nodes' => [ 'shape' => 'FlowNodes', ], 'connections' => [ 'shape' => 'FlowConnections', ], ], 'sensitive' => true, ], 'FlowDescription' => [ 'type' => 'string', 'max' => 200, 'min' => 1, ], 'FlowExecutionRoleArn' => [ 'type' => 'string', 'max' => 2048, 'min' => 0, 'pattern' => 'arn:aws(-[^:]+)?:iam::([0-9]{12})?:role/(service-role/)?.+', ], 'FlowId' => [ 'type' => 'string', 'pattern' => '[0-9a-zA-Z]{10}', ], 'FlowIdentifier' => [ 'type' => 'string', 'pattern' => '(arn:aws:bedrock:[a-z0-9-]{1,20}:[0-9]{12}:flow/[0-9a-zA-Z]{10})|([0-9a-zA-Z]{10})', ], 'FlowKnowledgeBaseId' => [ 'type' => 'string', 'max' => 10, 'min' => 0, 'pattern' => '$|^[0-9a-zA-Z]+', ], 'FlowLambdaArn' => [ 'type' => 'string', 'max' => 2048, 'min' => 0, 'pattern' => '$|^arn:aws(-cn|-us-gov|-eusc|-iso(-[b-f])?)?:lambda:([a-z]{2,}-){2,}\\d:\\d{12}:function:[a-zA-Z0-9-_\\.]+(:(\\$LATEST|[a-zA-Z0-9-_]+))?', ], 'FlowLexBotAliasArn' => [ 'type' => 'string', 'max' => 78, 'min' => 0, 'pattern' => '$|^arn:aws(-cn|-us-gov|-eusc|-iso(-[b-f])?)?:lex:([a-z]{2,}-){2,}\\d:\\d{12}:bot-alias/[0-9a-zA-Z]+/[0-9a-zA-Z]+', ], 'FlowLexBotLocaleId' => [ 'type' => 'string', 'max' => 10, 'min' => 0, ], 'FlowName' => [ 'type' => 'string', 'pattern' => '([0-9a-zA-Z][_-]?){1,100}', ], 'FlowNode' => [ 'type' => 'structure', 'required' => [ 'name', 'type', ], 'members' => [ 'name' => [ 'shape' => 'FlowNodeName', ], 'type' => [ 'shape' => 'FlowNodeType', ], 'configuration' => [ 'shape' => 'FlowNodeConfiguration', ], 'inputs' => [ 'shape' => 'FlowNodeInputs', ], 'outputs' => [ 'shape' => 'FlowNodeOutputs', ], ], ], 'FlowNodeConfiguration' => [ 'type' => 'structure', 'members' => [ 'input' => [ 'shape' => 'InputFlowNodeConfiguration', ], 'output' => [ 'shape' => 'OutputFlowNodeConfiguration', ], 'knowledgeBase' => [ 'shape' => 'KnowledgeBaseFlowNodeConfiguration', ], 'condition' => [ 'shape' => 'ConditionFlowNodeConfiguration', ], 'lex' => [ 'shape' => 'LexFlowNodeConfiguration', ], 'prompt' => [ 'shape' => 'PromptFlowNodeConfiguration', ], 'lambdaFunction' => [ 'shape' => 'LambdaFunctionFlowNodeConfiguration', ], 'storage' => [ 'shape' => 'StorageFlowNodeConfiguration', ], 'agent' => [ 'shape' => 'AgentFlowNodeConfiguration', ], 'retrieval' => [ 'shape' => 'RetrievalFlowNodeConfiguration', ], 'iterator' => [ 'shape' => 'IteratorFlowNodeConfiguration', ], 'collector' => [ 'shape' => 'CollectorFlowNodeConfiguration', ], 'inlineCode' => [ 'shape' => 'InlineCodeFlowNodeConfiguration', ], 'loop' => [ 'shape' => 'LoopFlowNodeConfiguration', ], 'loopInput' => [ 'shape' => 'LoopInputFlowNodeConfiguration', ], 'loopController' => [ 'shape' => 'LoopControllerFlowNodeConfiguration', ], ], 'union' => true, ], 'FlowNodeIODataType' => [ 'type' => 'string', 'enum' => [ 'String', 'Number', 'Boolean', 'Object', 'Array', ], ], 'FlowNodeInput' => [ 'type' => 'structure', 'required' => [ 'name', 'type', 'expression', ], 'members' => [ 'name' => [ 'shape' => 'FlowNodeInputName', ], 'type' => [ 'shape' => 'FlowNodeIODataType', ], 'expression' => [ 'shape' => 'FlowNodeInputExpression', ], 'category' => [ 'shape' => 'FlowNodeInputCategory', ], ], ], 'FlowNodeInputCategory' => [ 'type' => 'string', 'enum' => [ 'LoopCondition', 'ReturnValueToLoopStart', 'ExitLoop', ], ], 'FlowNodeInputExpression' => [ 'type' => 'string', 'max' => 64, 'min' => 1, 'sensitive' => true, ], 'FlowNodeInputName' => [ 'type' => 'string', 'pattern' => '[a-zA-Z]([_]?[0-9a-zA-Z]){1,50}', ], 'FlowNodeInputs' => [ 'type' => 'list', 'member' => [ 'shape' => 'FlowNodeInput', ], 'max' => 20, 'min' => 0, ], 'FlowNodeName' => [ 'type' => 'string', 'pattern' => '[a-zA-Z]([_]?[0-9a-zA-Z]){1,50}', ], 'FlowNodeOutput' => [ 'type' => 'structure', 'required' => [ 'name', 'type', ], 'members' => [ 'name' => [ 'shape' => 'FlowNodeOutputName', ], 'type' => [ 'shape' => 'FlowNodeIODataType', ], ], ], 'FlowNodeOutputName' => [ 'type' => 'string', 'pattern' => '[a-zA-Z]([_]?[0-9a-zA-Z]){1,50}', ], 'FlowNodeOutputs' => [ 'type' => 'list', 'member' => [ 'shape' => 'FlowNodeOutput', ], 'max' => 5, 'min' => 0, ], 'FlowNodeType' => [ 'type' => 'string', 'enum' => [ 'Input', 'Output', 'KnowledgeBase', 'Condition', 'Lex', 'Prompt', 'LambdaFunction', 'Storage', 'Agent', 'Retrieval', 'Iterator', 'Collector', 'InlineCode', 'Loop', 'LoopInput', 'LoopController', ], ], 'FlowNodes' => [ 'type' => 'list', 'member' => [ 'shape' => 'FlowNode', ], 'max' => 40, 'min' => 0, ], 'FlowPromptArn' => [ 'type' => 'string', 'pattern' => '$|^(arn:aws(-cn|-us-gov|-eusc|-iso(-[b-f])?)?:bedrock:[a-z0-9-]{1,20}:[0-9]{12}:prompt/[0-9a-zA-Z]{10}(?::[0-9]{1,5})?)', ], 'FlowPromptModelIdentifier' => [ 'type' => 'string', 'max' => 2048, 'min' => 0, 'pattern' => '$|^(arn:aws(-cn|-us-gov|-eusc|-iso(-[b-f])?)?:(bedrock|sagemaker):[a-z0-9-]{1,20}:([0-9]{12})?:([a-z-]+/)?)?([a-zA-Z0-9.-]{1,63}){0,2}(([:][a-z0-9-]{1,63}){0,2})?(/[a-z0-9]{1,12})?', ], 'FlowS3BucketName' => [ 'type' => 'string', 'max' => 63, 'min' => 0, 'pattern' => '$|^[a-z0-9][\\.\\-a-z0-9]{1,61}[a-z0-9]', ], 'FlowStatus' => [ 'type' => 'string', 'enum' => [ 'Failed', 'Prepared', 'Preparing', 'NotPrepared', ], ], 'FlowSummaries' => [ 'type' => 'list', 'member' => [ 'shape' => 'FlowSummary', ], 'max' => 10, 'min' => 0, ], 'FlowSummary' => [ 'type' => 'structure', 'required' => [ 'name', 'id', 'arn', 'status', 'createdAt', 'updatedAt', 'version', ], 'members' => [ 'name' => [ 'shape' => 'FlowName', ], 'description' => [ 'shape' => 'FlowDescription', ], 'id' => [ 'shape' => 'FlowId', ], 'arn' => [ 'shape' => 'FlowArn', ], 'status' => [ 'shape' => 'FlowStatus', ], 'createdAt' => [ 'shape' => 'DateTimestamp', ], 'updatedAt' => [ 'shape' => 'DateTimestamp', ], 'version' => [ 'shape' => 'DraftVersion', ], ], ], 'FlowValidation' => [ 'type' => 'structure', 'required' => [ 'message', 'severity', ], 'members' => [ 'message' => [ 'shape' => 'NonBlankString', ], 'severity' => [ 'shape' => 'FlowValidationSeverity', ], 'details' => [ 'shape' => 'FlowValidationDetails', ], 'type' => [ 'shape' => 'FlowValidationType', ], ], ], 'FlowValidationDetails' => [ 'type' => 'structure', 'members' => [ 'cyclicConnection' => [ 'shape' => 'CyclicConnectionFlowValidationDetails', ], 'duplicateConnections' => [ 'shape' => 'DuplicateConnectionsFlowValidationDetails', ], 'duplicateConditionExpression' => [ 'shape' => 'DuplicateConditionExpressionFlowValidationDetails', ], 'unreachableNode' => [ 'shape' => 'UnreachableNodeFlowValidationDetails', ], 'unknownConnectionSource' => [ 'shape' => 'UnknownConnectionSourceFlowValidationDetails', ], 'unknownConnectionSourceOutput' => [ 'shape' => 'UnknownConnectionSourceOutputFlowValidationDetails', ], 'unknownConnectionTarget' => [ 'shape' => 'UnknownConnectionTargetFlowValidationDetails', ], 'unknownConnectionTargetInput' => [ 'shape' => 'UnknownConnectionTargetInputFlowValidationDetails', ], 'unknownConnectionCondition' => [ 'shape' => 'UnknownConnectionConditionFlowValidationDetails', ], 'malformedConditionExpression' => [ 'shape' => 'MalformedConditionExpressionFlowValidationDetails', ], 'malformedNodeInputExpression' => [ 'shape' => 'MalformedNodeInputExpressionFlowValidationDetails', ], 'mismatchedNodeInputType' => [ 'shape' => 'MismatchedNodeInputTypeFlowValidationDetails', ], 'mismatchedNodeOutputType' => [ 'shape' => 'MismatchedNodeOutputTypeFlowValidationDetails', ], 'incompatibleConnectionDataType' => [ 'shape' => 'IncompatibleConnectionDataTypeFlowValidationDetails', ], 'missingConnectionConfiguration' => [ 'shape' => 'MissingConnectionConfigurationFlowValidationDetails', ], 'missingDefaultCondition' => [ 'shape' => 'MissingDefaultConditionFlowValidationDetails', ], 'missingEndingNodes' => [ 'shape' => 'MissingEndingNodesFlowValidationDetails', ], 'missingNodeConfiguration' => [ 'shape' => 'MissingNodeConfigurationFlowValidationDetails', ], 'missingNodeInput' => [ 'shape' => 'MissingNodeInputFlowValidationDetails', ], 'missingNodeOutput' => [ 'shape' => 'MissingNodeOutputFlowValidationDetails', ], 'missingStartingNodes' => [ 'shape' => 'MissingStartingNodesFlowValidationDetails', ], 'multipleNodeInputConnections' => [ 'shape' => 'MultipleNodeInputConnectionsFlowValidationDetails', ], 'unfulfilledNodeInput' => [ 'shape' => 'UnfulfilledNodeInputFlowValidationDetails', ], 'unsatisfiedConnectionConditions' => [ 'shape' => 'UnsatisfiedConnectionConditionsFlowValidationDetails', ], 'unspecified' => [ 'shape' => 'UnspecifiedFlowValidationDetails', ], 'unknownNodeInput' => [ 'shape' => 'UnknownNodeInputFlowValidationDetails', ], 'unknownNodeOutput' => [ 'shape' => 'UnknownNodeOutputFlowValidationDetails', ], 'missingLoopInputNode' => [ 'shape' => 'MissingLoopInputNodeFlowValidationDetails', ], 'missingLoopControllerNode' => [ 'shape' => 'MissingLoopControllerNodeFlowValidationDetails', ], 'multipleLoopInputNodes' => [ 'shape' => 'MultipleLoopInputNodesFlowValidationDetails', ], 'multipleLoopControllerNodes' => [ 'shape' => 'MultipleLoopControllerNodesFlowValidationDetails', ], 'loopIncompatibleNodeType' => [ 'shape' => 'LoopIncompatibleNodeTypeFlowValidationDetails', ], 'invalidLoopBoundary' => [ 'shape' => 'InvalidLoopBoundaryFlowValidationDetails', ], ], 'union' => true, ], 'FlowValidationSeverity' => [ 'type' => 'string', 'enum' => [ 'Warning', 'Error', ], ], 'FlowValidationType' => [ 'type' => 'string', 'enum' => [ 'CyclicConnection', 'DuplicateConnections', 'DuplicateConditionExpression', 'UnreachableNode', 'UnknownConnectionSource', 'UnknownConnectionSourceOutput', 'UnknownConnectionTarget', 'UnknownConnectionTargetInput', 'UnknownConnectionCondition', 'MalformedConditionExpression', 'MalformedNodeInputExpression', 'MismatchedNodeInputType', 'MismatchedNodeOutputType', 'IncompatibleConnectionDataType', 'MissingConnectionConfiguration', 'MissingDefaultCondition', 'MissingEndingNodes', 'MissingNodeConfiguration', 'MissingNodeInput', 'MissingNodeOutput', 'MissingStartingNodes', 'MultipleNodeInputConnections', 'UnfulfilledNodeInput', 'UnsatisfiedConnectionConditions', 'Unspecified', 'UnknownNodeInput', 'UnknownNodeOutput', 'MissingLoopInputNode', 'MissingLoopControllerNode', 'MultipleLoopInputNodes', 'MultipleLoopControllerNodes', 'LoopIncompatibleNodeType', 'InvalidLoopBoundary', ], ], 'FlowValidations' => [ 'type' => 'list', 'member' => [ 'shape' => 'FlowValidation', ], 'max' => 100, 'min' => 0, ], 'FlowVersionSummaries' => [ 'type' => 'list', 'member' => [ 'shape' => 'FlowVersionSummary', ], 'max' => 10, 'min' => 0, ], 'FlowVersionSummary' => [ 'type' => 'structure', 'required' => [ 'id', 'arn', 'status', 'createdAt', 'version', ], 'members' => [ 'id' => [ 'shape' => 'FlowId', ], 'arn' => [ 'shape' => 'FlowArn', ], 'status' => [ 'shape' => 'FlowStatus', ], 'createdAt' => [ 'shape' => 'DateTimestamp', ], 'version' => [ 'shape' => 'NumericalVersion', ], ], ], 'Function' => [ 'type' => 'structure', 'required' => [ 'name', ], 'members' => [ 'name' => [ 'shape' => 'Name', ], 'description' => [ 'shape' => 'FunctionDescription', ], 'parameters' => [ 'shape' => 'ParameterMap', ], 'requireConfirmation' => [ 'shape' => 'RequireConfirmation', ], ], ], 'FunctionDescription' => [ 'type' => 'string', 'max' => 1200, 'min' => 1, ], 'FunctionSchema' => [ 'type' => 'structure', 'members' => [ 'functions' => [ 'shape' => 'Functions', ], ], 'union' => true, ], 'Functions' => [ 'type' => 'list', 'member' => [ 'shape' => 'Function', ], ], 'GetAgentActionGroupRequest' => [ 'type' => 'structure', 'required' => [ 'agentId', 'agentVersion', 'actionGroupId', ], 'members' => [ 'agentId' => [ 'shape' => 'Id', 'location' => 'uri', 'locationName' => 'agentId', ], 'agentVersion' => [ 'shape' => 'Version', 'location' => 'uri', 'locationName' => 'agentVersion', ], 'actionGroupId' => [ 'shape' => 'Id', 'location' => 'uri', 'locationName' => 'actionGroupId', ], ], ], 'GetAgentActionGroupResponse' => [ 'type' => 'structure', 'required' => [ 'agentActionGroup', ], 'members' => [ 'agentActionGroup' => [ 'shape' => 'AgentActionGroup', ], ], ], 'GetAgentAliasRequest' => [ 'type' => 'structure', 'required' => [ 'agentId', 'agentAliasId', ], 'members' => [ 'agentId' => [ 'shape' => 'Id', 'location' => 'uri', 'locationName' => 'agentId', ], 'agentAliasId' => [ 'shape' => 'AgentAliasId', 'location' => 'uri', 'locationName' => 'agentAliasId', ], ], ], 'GetAgentAliasResponse' => [ 'type' => 'structure', 'required' => [ 'agentAlias', ], 'members' => [ 'agentAlias' => [ 'shape' => 'AgentAlias', ], ], ], 'GetAgentCollaboratorRequest' => [ 'type' => 'structure', 'required' => [ 'agentId', 'agentVersion', 'collaboratorId', ], 'members' => [ 'agentId' => [ 'shape' => 'Id', 'location' => 'uri', 'locationName' => 'agentId', ], 'agentVersion' => [ 'shape' => 'Version', 'location' => 'uri', 'locationName' => 'agentVersion', ], 'collaboratorId' => [ 'shape' => 'Id', 'location' => 'uri', 'locationName' => 'collaboratorId', ], ], ], 'GetAgentCollaboratorResponse' => [ 'type' => 'structure', 'required' => [ 'agentCollaborator', ], 'members' => [ 'agentCollaborator' => [ 'shape' => 'AgentCollaborator', ], ], ], 'GetAgentKnowledgeBaseRequest' => [ 'type' => 'structure', 'required' => [ 'agentId', 'agentVersion', 'knowledgeBaseId', ], 'members' => [ 'agentId' => [ 'shape' => 'Id', 'location' => 'uri', 'locationName' => 'agentId', ], 'agentVersion' => [ 'shape' => 'Version', 'location' => 'uri', 'locationName' => 'agentVersion', ], 'knowledgeBaseId' => [ 'shape' => 'Id', 'location' => 'uri', 'locationName' => 'knowledgeBaseId', ], ], ], 'GetAgentKnowledgeBaseResponse' => [ 'type' => 'structure', 'required' => [ 'agentKnowledgeBase', ], 'members' => [ 'agentKnowledgeBase' => [ 'shape' => 'AgentKnowledgeBase', ], ], ], 'GetAgentRequest' => [ 'type' => 'structure', 'required' => [ 'agentId', ], 'members' => [ 'agentId' => [ 'shape' => 'Id', 'location' => 'uri', 'locationName' => 'agentId', ], ], ], 'GetAgentResponse' => [ 'type' => 'structure', 'required' => [ 'agent', ], 'members' => [ 'agent' => [ 'shape' => 'Agent', ], ], ], 'GetAgentVersionRequest' => [ 'type' => 'structure', 'required' => [ 'agentId', 'agentVersion', ], 'members' => [ 'agentId' => [ 'shape' => 'Id', 'location' => 'uri', 'locationName' => 'agentId', ], 'agentVersion' => [ 'shape' => 'NumericalVersion', 'location' => 'uri', 'locationName' => 'agentVersion', ], ], ], 'GetAgentVersionResponse' => [ 'type' => 'structure', 'required' => [ 'agentVersion', ], 'members' => [ 'agentVersion' => [ 'shape' => 'AgentVersion', ], ], ], 'GetDataSourceRequest' => [ 'type' => 'structure', 'required' => [ 'knowledgeBaseId', 'dataSourceId', ], 'members' => [ 'knowledgeBaseId' => [ 'shape' => 'Id', 'location' => 'uri', 'locationName' => 'knowledgeBaseId', ], 'dataSourceId' => [ 'shape' => 'Id', 'location' => 'uri', 'locationName' => 'dataSourceId', ], ], ], 'GetDataSourceResponse' => [ 'type' => 'structure', 'required' => [ 'dataSource', ], 'members' => [ 'dataSource' => [ 'shape' => 'DataSource', ], ], ], 'GetFlowAliasRequest' => [ 'type' => 'structure', 'required' => [ 'flowIdentifier', 'aliasIdentifier', ], 'members' => [ 'flowIdentifier' => [ 'shape' => 'FlowIdentifier', 'location' => 'uri', 'locationName' => 'flowIdentifier', ], 'aliasIdentifier' => [ 'shape' => 'FlowAliasIdentifier', 'location' => 'uri', 'locationName' => 'aliasIdentifier', ], ], ], 'GetFlowAliasResponse' => [ 'type' => 'structure', 'required' => [ 'name', 'routingConfiguration', 'flowId', 'id', 'arn', 'createdAt', 'updatedAt', ], 'members' => [ 'name' => [ 'shape' => 'Name', ], 'description' => [ 'shape' => 'Description', ], 'routingConfiguration' => [ 'shape' => 'FlowAliasRoutingConfiguration', ], 'concurrencyConfiguration' => [ 'shape' => 'FlowAliasConcurrencyConfiguration', ], 'flowId' => [ 'shape' => 'FlowId', ], 'id' => [ 'shape' => 'FlowAliasId', ], 'arn' => [ 'shape' => 'FlowAliasArn', ], 'createdAt' => [ 'shape' => 'DateTimestamp', ], 'updatedAt' => [ 'shape' => 'DateTimestamp', ], ], ], 'GetFlowRequest' => [ 'type' => 'structure', 'required' => [ 'flowIdentifier', ], 'members' => [ 'flowIdentifier' => [ 'shape' => 'FlowIdentifier', 'location' => 'uri', 'locationName' => 'flowIdentifier', ], ], ], 'GetFlowResponse' => [ 'type' => 'structure', 'required' => [ 'name', 'executionRoleArn', 'id', 'arn', 'status', 'createdAt', 'updatedAt', 'version', ], 'members' => [ 'name' => [ 'shape' => 'FlowName', ], 'description' => [ 'shape' => 'FlowDescription', ], 'executionRoleArn' => [ 'shape' => 'FlowExecutionRoleArn', ], 'customerEncryptionKeyArn' => [ 'shape' => 'KmsKeyArn', ], 'id' => [ 'shape' => 'FlowId', ], 'arn' => [ 'shape' => 'FlowArn', ], 'status' => [ 'shape' => 'FlowStatus', ], 'createdAt' => [ 'shape' => 'DateTimestamp', ], 'updatedAt' => [ 'shape' => 'DateTimestamp', ], 'version' => [ 'shape' => 'DraftVersion', ], 'definition' => [ 'shape' => 'FlowDefinition', ], 'validations' => [ 'shape' => 'FlowValidations', ], ], ], 'GetFlowVersionRequest' => [ 'type' => 'structure', 'required' => [ 'flowIdentifier', 'flowVersion', ], 'members' => [ 'flowIdentifier' => [ 'shape' => 'FlowIdentifier', 'location' => 'uri', 'locationName' => 'flowIdentifier', ], 'flowVersion' => [ 'shape' => 'NumericalVersion', 'location' => 'uri', 'locationName' => 'flowVersion', ], ], ], 'GetFlowVersionResponse' => [ 'type' => 'structure', 'required' => [ 'name', 'executionRoleArn', 'id', 'arn', 'status', 'createdAt', 'version', ], 'members' => [ 'name' => [ 'shape' => 'FlowName', ], 'description' => [ 'shape' => 'FlowDescription', ], 'executionRoleArn' => [ 'shape' => 'FlowExecutionRoleArn', ], 'customerEncryptionKeyArn' => [ 'shape' => 'KmsKeyArn', ], 'id' => [ 'shape' => 'FlowId', ], 'arn' => [ 'shape' => 'FlowArn', ], 'status' => [ 'shape' => 'FlowStatus', ], 'createdAt' => [ 'shape' => 'DateTimestamp', ], 'version' => [ 'shape' => 'NumericalVersion', ], 'definition' => [ 'shape' => 'FlowDefinition', ], ], ], 'GetIngestionJobRequest' => [ 'type' => 'structure', 'required' => [ 'knowledgeBaseId', 'dataSourceId', 'ingestionJobId', ], 'members' => [ 'knowledgeBaseId' => [ 'shape' => 'Id', 'location' => 'uri', 'locationName' => 'knowledgeBaseId', ], 'dataSourceId' => [ 'shape' => 'Id', 'location' => 'uri', 'locationName' => 'dataSourceId', ], 'ingestionJobId' => [ 'shape' => 'Id', 'location' => 'uri', 'locationName' => 'ingestionJobId', ], ], ], 'GetIngestionJobResponse' => [ 'type' => 'structure', 'required' => [ 'ingestionJob', ], 'members' => [ 'ingestionJob' => [ 'shape' => 'IngestionJob', ], ], ], 'GetKnowledgeBaseDocumentsRequest' => [ 'type' => 'structure', 'required' => [ 'knowledgeBaseId', 'dataSourceId', 'documentIdentifiers', ], 'members' => [ 'knowledgeBaseId' => [ 'shape' => 'Id', 'location' => 'uri', 'locationName' => 'knowledgeBaseId', ], 'dataSourceId' => [ 'shape' => 'Id', 'location' => 'uri', 'locationName' => 'dataSourceId', ], 'documentIdentifiers' => [ 'shape' => 'DocumentIdentifiers', ], ], ], 'GetKnowledgeBaseDocumentsResponse' => [ 'type' => 'structure', 'members' => [ 'documentDetails' => [ 'shape' => 'KnowledgeBaseDocumentDetails', ], ], ], 'GetKnowledgeBaseRequest' => [ 'type' => 'structure', 'required' => [ 'knowledgeBaseId', ], 'members' => [ 'knowledgeBaseId' => [ 'shape' => 'Id', 'location' => 'uri', 'locationName' => 'knowledgeBaseId', ], ], ], 'GetKnowledgeBaseResponse' => [ 'type' => 'structure', 'required' => [ 'knowledgeBase', ], 'members' => [ 'knowledgeBase' => [ 'shape' => 'KnowledgeBase', ], ], ], 'GetPromptRequest' => [ 'type' => 'structure', 'required' => [ 'promptIdentifier', ], 'members' => [ 'promptIdentifier' => [ 'shape' => 'PromptIdentifier', 'location' => 'uri', 'locationName' => 'promptIdentifier', ], 'promptVersion' => [ 'shape' => 'Version', 'location' => 'querystring', 'locationName' => 'promptVersion', ], ], ], 'GetPromptResponse' => [ 'type' => 'structure', 'required' => [ 'name', 'id', 'arn', 'version', 'createdAt', 'updatedAt', ], 'members' => [ 'name' => [ 'shape' => 'PromptName', ], 'description' => [ 'shape' => 'PromptDescription', ], 'customerEncryptionKeyArn' => [ 'shape' => 'KmsKeyArn', ], 'defaultVariant' => [ 'shape' => 'PromptVariantName', ], 'variants' => [ 'shape' => 'PromptVariantList', ], 'id' => [ 'shape' => 'PromptId', ], 'arn' => [ 'shape' => 'PromptArn', ], 'version' => [ 'shape' => 'Version', ], 'createdAt' => [ 'shape' => 'DateTimestamp', ], 'updatedAt' => [ 'shape' => 'DateTimestamp', ], ], ], 'GraphArn' => [ 'type' => 'string', 'max' => 255, 'min' => 1, 'pattern' => 'arn:aws(|-cn|-us-gov):neptune-graph:[a-zA-Z0-9-]*:[0-9]{12}:graph/g-[a-zA-Z0-9]{10}', 'sensitive' => true, ], 'GuardrailConfiguration' => [ 'type' => 'structure', 'members' => [ 'guardrailIdentifier' => [ 'shape' => 'GuardrailIdentifier', ], 'guardrailVersion' => [ 'shape' => 'GuardrailVersion', ], ], ], 'GuardrailIdentifier' => [ 'type' => 'string', 'max' => 2048, 'min' => 0, 'pattern' => '(([a-z0-9]+)|(arn:aws(-[^:]+)?:bedrock:[a-z0-9-]{1,20}:[0-9]{12}:guardrail/[a-z0-9]+))', ], 'GuardrailVersion' => [ 'type' => 'string', 'pattern' => '(([0-9]{1,8})|(DRAFT))', ], 'HierarchicalChunkingConfiguration' => [ 'type' => 'structure', 'required' => [ 'levelConfigurations', 'overlapTokens', ], 'members' => [ 'levelConfigurations' => [ 'shape' => 'HierarchicalChunkingLevelConfigurations', ], 'overlapTokens' => [ 'shape' => 'HierarchicalChunkingConfigurationOverlapTokensInteger', ], ], ], 'HierarchicalChunkingConfigurationOverlapTokensInteger' => [ 'type' => 'integer', 'box' => true, 'min' => 1, ], 'HierarchicalChunkingLevelConfiguration' => [ 'type' => 'structure', 'required' => [ 'maxTokens', ], 'members' => [ 'maxTokens' => [ 'shape' => 'HierarchicalChunkingLevelConfigurationMaxTokensInteger', ], ], ], 'HierarchicalChunkingLevelConfigurationMaxTokensInteger' => [ 'type' => 'integer', 'box' => true, 'max' => 8192, 'min' => 1, ], 'HierarchicalChunkingLevelConfigurations' => [ 'type' => 'list', 'member' => [ 'shape' => 'HierarchicalChunkingLevelConfiguration', ], 'max' => 2, 'min' => 2, ], 'HttpsUrl' => [ 'type' => 'string', 'pattern' => 'https://[A-Za-z0-9][^\\s]*', ], 'Id' => [ 'type' => 'string', 'pattern' => '[0-9a-zA-Z]{10}', ], 'IncludeExclude' => [ 'type' => 'string', 'enum' => [ 'INCLUDE', 'EXCLUDE', ], ], 'IncompatibleConnectionDataTypeFlowValidationDetails' => [ 'type' => 'structure', 'required' => [ 'connection', ], 'members' => [ 'connection' => [ 'shape' => 'FlowConnectionName', ], ], ], 'IncompatibleLoopNodeType' => [ 'type' => 'string', 'enum' => [ 'Input', 'Condition', 'Iterator', 'Collector', ], ], 'IndexArn' => [ 'type' => 'string', 'sensitive' => true, ], 'IndexName' => [ 'type' => 'string', 'max' => 63, 'min' => 3, 'sensitive' => true, ], 'InferenceConfiguration' => [ 'type' => 'structure', 'members' => [ 'temperature' => [ 'shape' => 'Temperature', ], 'topP' => [ 'shape' => 'TopP', ], 'topK' => [ 'shape' => 'TopK', ], 'maximumLength' => [ 'shape' => 'MaximumLength', ], 'stopSequences' => [ 'shape' => 'StopSequences', ], ], ], 'IngestKnowledgeBaseDocumentsRequest' => [ 'type' => 'structure', 'required' => [ 'knowledgeBaseId', 'dataSourceId', 'documents', ], 'members' => [ 'knowledgeBaseId' => [ 'shape' => 'Id', 'location' => 'uri', 'locationName' => 'knowledgeBaseId', ], 'dataSourceId' => [ 'shape' => 'Id', 'location' => 'uri', 'locationName' => 'dataSourceId', ], 'clientToken' => [ 'shape' => 'ClientToken', 'idempotencyToken' => true, ], 'documents' => [ 'shape' => 'KnowledgeBaseDocuments', ], ], ], 'IngestKnowledgeBaseDocumentsResponse' => [ 'type' => 'structure', 'members' => [ 'documentDetails' => [ 'shape' => 'KnowledgeBaseDocumentDetails', ], ], ], 'IngestionJob' => [ 'type' => 'structure', 'required' => [ 'knowledgeBaseId', 'dataSourceId', 'ingestionJobId', 'status', 'startedAt', 'updatedAt', ], 'members' => [ 'knowledgeBaseId' => [ 'shape' => 'Id', ], 'dataSourceId' => [ 'shape' => 'Id', ], 'ingestionJobId' => [ 'shape' => 'Id', ], 'description' => [ 'shape' => 'Description', ], 'status' => [ 'shape' => 'IngestionJobStatus', ], 'statistics' => [ 'shape' => 'IngestionJobStatistics', ], 'failureReasons' => [ 'shape' => 'FailureReasons', ], 'startedAt' => [ 'shape' => 'DateTimestamp', ], 'updatedAt' => [ 'shape' => 'DateTimestamp', ], ], ], 'IngestionJobFilter' => [ 'type' => 'structure', 'required' => [ 'attribute', 'operator', 'values', ], 'members' => [ 'attribute' => [ 'shape' => 'IngestionJobFilterAttribute', ], 'operator' => [ 'shape' => 'IngestionJobFilterOperator', ], 'values' => [ 'shape' => 'IngestionJobFilterValues', ], ], ], 'IngestionJobFilterAttribute' => [ 'type' => 'string', 'enum' => [ 'STATUS', ], ], 'IngestionJobFilterOperator' => [ 'type' => 'string', 'enum' => [ 'EQ', ], ], 'IngestionJobFilterValue' => [ 'type' => 'string', 'max' => 100, 'min' => 0, 'pattern' => '.*', ], 'IngestionJobFilterValues' => [ 'type' => 'list', 'member' => [ 'shape' => 'IngestionJobFilterValue', ], 'max' => 10, 'min' => 0, ], 'IngestionJobFilters' => [ 'type' => 'list', 'member' => [ 'shape' => 'IngestionJobFilter', ], 'max' => 1, 'min' => 1, ], 'IngestionJobSortBy' => [ 'type' => 'structure', 'required' => [ 'attribute', 'order', ], 'members' => [ 'attribute' => [ 'shape' => 'IngestionJobSortByAttribute', ], 'order' => [ 'shape' => 'SortOrder', ], ], ], 'IngestionJobSortByAttribute' => [ 'type' => 'string', 'enum' => [ 'STATUS', 'STARTED_AT', ], ], 'IngestionJobStatistics' => [ 'type' => 'structure', 'members' => [ 'numberOfDocumentsScanned' => [ 'shape' => 'PrimitiveLong', ], 'numberOfMetadataDocumentsScanned' => [ 'shape' => 'PrimitiveLong', ], 'numberOfNewDocumentsIndexed' => [ 'shape' => 'PrimitiveLong', ], 'numberOfModifiedDocumentsIndexed' => [ 'shape' => 'PrimitiveLong', ], 'numberOfMetadataDocumentsModified' => [ 'shape' => 'PrimitiveLong', ], 'numberOfDocumentsDeleted' => [ 'shape' => 'PrimitiveLong', ], 'numberOfDocumentsFailed' => [ 'shape' => 'PrimitiveLong', ], ], ], 'IngestionJobStatus' => [ 'type' => 'string', 'enum' => [ 'STARTING', 'IN_PROGRESS', 'COMPLETE', 'FAILED', 'STOPPING', 'STOPPED', ], ], 'IngestionJobSummaries' => [ 'type' => 'list', 'member' => [ 'shape' => 'IngestionJobSummary', ], ], 'IngestionJobSummary' => [ 'type' => 'structure', 'required' => [ 'knowledgeBaseId', 'dataSourceId', 'ingestionJobId', 'status', 'startedAt', 'updatedAt', ], 'members' => [ 'knowledgeBaseId' => [ 'shape' => 'Id', ], 'dataSourceId' => [ 'shape' => 'Id', ], 'ingestionJobId' => [ 'shape' => 'Id', ], 'description' => [ 'shape' => 'Description', ], 'status' => [ 'shape' => 'IngestionJobStatus', ], 'startedAt' => [ 'shape' => 'DateTimestamp', ], 'updatedAt' => [ 'shape' => 'DateTimestamp', ], 'statistics' => [ 'shape' => 'IngestionJobStatistics', ], ], ], 'InlineCode' => [ 'type' => 'string', 'max' => 5000000, 'min' => 0, 'sensitive' => true, ], 'InlineCodeFlowNodeConfiguration' => [ 'type' => 'structure', 'required' => [ 'code', 'language', ], 'members' => [ 'code' => [ 'shape' => 'InlineCode', ], 'language' => [ 'shape' => 'SupportedLanguages', ], ], ], 'InlineContent' => [ 'type' => 'structure', 'required' => [ 'type', ], 'members' => [ 'type' => [ 'shape' => 'InlineContentType', ], 'byteContent' => [ 'shape' => 'ByteContentDoc', ], 'textContent' => [ 'shape' => 'TextContentDoc', ], ], ], 'InlineContentType' => [ 'type' => 'string', 'enum' => [ 'BYTE', 'TEXT', ], ], 'InputFlowNodeConfiguration' => [ 'type' => 'structure', 'members' => [], ], 'Instruction' => [ 'type' => 'string', 'max' => 4000, 'min' => 40, 'sensitive' => true, ], 'IntermediateStorage' => [ 'type' => 'structure', 'required' => [ 's3Location', ], 'members' => [ 's3Location' => [ 'shape' => 'S3Location', ], ], ], 'InternalServerException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'NonBlankString', ], ], 'error' => [ 'httpStatusCode' => 500, ], 'exception' => true, 'fault' => true, ], 'InvalidLoopBoundaryFlowValidationDetails' => [ 'type' => 'structure', 'required' => [ 'connection', 'source', 'target', ], 'members' => [ 'connection' => [ 'shape' => 'FlowConnectionName', ], 'source' => [ 'shape' => 'FlowNodeName', ], 'target' => [ 'shape' => 'FlowNodeName', ], ], ], 'IteratorFlowNodeConfiguration' => [ 'type' => 'structure', 'members' => [], ], 'KendraIndexArn' => [ 'type' => 'string', 'pattern' => 'arn:aws(|-cn|-us-gov):kendra:[a-z0-9-]{1,20}:([0-9]{12}|):index/([a-zA-Z0-9][a-zA-Z0-9-]{35}|[a-zA-Z0-9][a-zA-Z0-9-]{35}-[a-zA-Z0-9][a-zA-Z0-9-]{35})', ], 'KendraKnowledgeBaseConfiguration' => [ 'type' => 'structure', 'required' => [ 'kendraIndexArn', ], 'members' => [ 'kendraIndexArn' => [ 'shape' => 'KendraIndexArn', ], ], ], 'Key' => [ 'type' => 'string', 'max' => 200, 'min' => 1, 'sensitive' => true, ], 'KmsKeyArn' => [ 'type' => 'string', 'max' => 2048, 'min' => 1, 'pattern' => 'arn:aws(|-cn|-us-gov):kms:[a-zA-Z0-9-]*:[0-9]{12}:key/[a-zA-Z0-9-]{36}', ], 'KnowledgeBase' => [ 'type' => 'structure', 'required' => [ 'knowledgeBaseId', 'name', 'knowledgeBaseArn', 'roleArn', 'knowledgeBaseConfiguration', 'status', 'createdAt', 'updatedAt', ], 'members' => [ 'knowledgeBaseId' => [ 'shape' => 'Id', ], 'name' => [ 'shape' => 'Name', ], 'knowledgeBaseArn' => [ 'shape' => 'KnowledgeBaseArn', ], 'description' => [ 'shape' => 'Description', ], 'roleArn' => [ 'shape' => 'KnowledgeBaseRoleArn', ], 'knowledgeBaseConfiguration' => [ 'shape' => 'KnowledgeBaseConfiguration', ], 'storageConfiguration' => [ 'shape' => 'StorageConfiguration', ], 'status' => [ 'shape' => 'KnowledgeBaseStatus', ], 'createdAt' => [ 'shape' => 'DateTimestamp', ], 'updatedAt' => [ 'shape' => 'DateTimestamp', ], 'failureReasons' => [ 'shape' => 'FailureReasons', ], ], ], 'KnowledgeBaseArn' => [ 'type' => 'string', 'max' => 128, 'min' => 0, 'pattern' => 'arn:aws(|-cn|-us-gov):bedrock:[a-zA-Z0-9-]*:[0-9]{12}:knowledge-base/[0-9a-zA-Z]+', ], 'KnowledgeBaseConfiguration' => [ 'type' => 'structure', 'required' => [ 'type', ], 'members' => [ 'type' => [ 'shape' => 'KnowledgeBaseType', ], 'vectorKnowledgeBaseConfiguration' => [ 'shape' => 'VectorKnowledgeBaseConfiguration', ], 'kendraKnowledgeBaseConfiguration' => [ 'shape' => 'KendraKnowledgeBaseConfiguration', ], 'sqlKnowledgeBaseConfiguration' => [ 'shape' => 'SqlKnowledgeBaseConfiguration', ], ], ], 'KnowledgeBaseDocument' => [ 'type' => 'structure', 'required' => [ 'content', ], 'members' => [ 'metadata' => [ 'shape' => 'DocumentMetadata', ], 'content' => [ 'shape' => 'DocumentContent', ], ], ], 'KnowledgeBaseDocumentDetail' => [ 'type' => 'structure', 'required' => [ 'knowledgeBaseId', 'dataSourceId', 'status', 'identifier', ], 'members' => [ 'knowledgeBaseId' => [ 'shape' => 'Id', ], 'dataSourceId' => [ 'shape' => 'Id', ], 'status' => [ 'shape' => 'DocumentStatus', ], 'identifier' => [ 'shape' => 'DocumentIdentifier', ], 'statusReason' => [ 'shape' => 'String', ], 'updatedAt' => [ 'shape' => 'DateTimestamp', ], ], ], 'KnowledgeBaseDocumentDetails' => [ 'type' => 'list', 'member' => [ 'shape' => 'KnowledgeBaseDocumentDetail', ], ], 'KnowledgeBaseDocuments' => [ 'type' => 'list', 'member' => [ 'shape' => 'KnowledgeBaseDocument', ], 'max' => 10, 'min' => 1, ], 'KnowledgeBaseFlowNodeConfiguration' => [ 'type' => 'structure', 'required' => [ 'knowledgeBaseId', ], 'members' => [ 'knowledgeBaseId' => [ 'shape' => 'FlowKnowledgeBaseId', ], 'modelId' => [ 'shape' => 'KnowledgeBaseModelIdentifier', ], 'guardrailConfiguration' => [ 'shape' => 'GuardrailConfiguration', ], 'numberOfResults' => [ 'shape' => 'KnowledgeBaseFlowNodeConfigurationNumberOfResultsInteger', ], 'promptTemplate' => [ 'shape' => 'KnowledgeBasePromptTemplate', ], 'inferenceConfiguration' => [ 'shape' => 'PromptInferenceConfiguration', ], 'rerankingConfiguration' => [ 'shape' => 'VectorSearchRerankingConfiguration', ], 'orchestrationConfiguration' => [ 'shape' => 'KnowledgeBaseOrchestrationConfiguration', ], ], ], 'KnowledgeBaseFlowNodeConfigurationNumberOfResultsInteger' => [ 'type' => 'integer', 'box' => true, 'max' => 100, 'min' => 1, ], 'KnowledgeBaseModelIdentifier' => [ 'type' => 'string', 'max' => 2048, 'min' => 1, 'pattern' => '(arn:aws(-[^:]{1,12})?:(bedrock|sagemaker):[a-z0-9-]{1,20}:([0-9]{12})?:([a-z-]+/)?)?([a-zA-Z0-9.-]{1,63}){0,2}(([:][a-z0-9-]{1,63}){0,2})?(/[a-z0-9]{1,12})?', ], 'KnowledgeBaseOrchestrationConfiguration' => [ 'type' => 'structure', 'members' => [ 'promptTemplate' => [ 'shape' => 'KnowledgeBasePromptTemplate', ], 'inferenceConfig' => [ 'shape' => 'PromptInferenceConfiguration', ], 'additionalModelRequestFields' => [ 'shape' => 'AdditionalModelRequestFields', ], 'performanceConfig' => [ 'shape' => 'PerformanceConfiguration', ], ], ], 'KnowledgeBasePromptTemplate' => [ 'type' => 'structure', 'members' => [ 'textPromptTemplate' => [ 'shape' => 'KnowledgeBaseTextPrompt', ], ], ], 'KnowledgeBaseRoleArn' => [ 'type' => 'string', 'max' => 2048, 'min' => 0, 'pattern' => 'arn:aws(-[^:]+)?:iam::([0-9]{12})?:role/.+', ], 'KnowledgeBaseState' => [ 'type' => 'string', 'enum' => [ 'ENABLED', 'DISABLED', ], ], 'KnowledgeBaseStatus' => [ 'type' => 'string', 'enum' => [ 'CREATING', 'ACTIVE', 'DELETING', 'UPDATING', 'FAILED', 'DELETE_UNSUCCESSFUL', ], ], 'KnowledgeBaseStorageType' => [ 'type' => 'string', 'enum' => [ 'OPENSEARCH_SERVERLESS', 'PINECONE', 'REDIS_ENTERPRISE_CLOUD', 'RDS', 'MONGO_DB_ATLAS', 'NEPTUNE_ANALYTICS', 'OPENSEARCH_MANAGED_CLUSTER', 'S3_VECTORS', ], ], 'KnowledgeBaseSummaries' => [ 'type' => 'list', 'member' => [ 'shape' => 'KnowledgeBaseSummary', ], ], 'KnowledgeBaseSummary' => [ 'type' => 'structure', 'required' => [ 'knowledgeBaseId', 'name', 'status', 'updatedAt', ], 'members' => [ 'knowledgeBaseId' => [ 'shape' => 'Id', ], 'name' => [ 'shape' => 'Name', ], 'description' => [ 'shape' => 'Description', ], 'status' => [ 'shape' => 'KnowledgeBaseStatus', ], 'updatedAt' => [ 'shape' => 'DateTimestamp', ], ], ], 'KnowledgeBaseTextPrompt' => [ 'type' => 'string', 'max' => 100000, 'min' => 1, 'sensitive' => true, ], 'KnowledgeBaseType' => [ 'type' => 'string', 'enum' => [ 'VECTOR', 'KENDRA', 'SQL', ], ], 'LambdaArn' => [ 'type' => 'string', 'max' => 2048, 'min' => 0, 'pattern' => 'arn:(aws[a-zA-Z-]*)?:lambda:[a-z]{2}(-gov)?-[a-z]+-\\d{1}:\\d{12}:function:[a-zA-Z0-9-_\\.]+(:(\\$LATEST|[a-zA-Z0-9-_]+))?', ], 'LambdaFunctionFlowNodeConfiguration' => [ 'type' => 'structure', 'required' => [ 'lambdaArn', ], 'members' => [ 'lambdaArn' => [ 'shape' => 'FlowLambdaArn', ], ], ], 'LexFlowNodeConfiguration' => [ 'type' => 'structure', 'required' => [ 'botAliasArn', 'localeId', ], 'members' => [ 'botAliasArn' => [ 'shape' => 'FlowLexBotAliasArn', ], 'localeId' => [ 'shape' => 'FlowLexBotLocaleId', ], ], ], 'ListAgentActionGroupsRequest' => [ 'type' => 'structure', 'required' => [ 'agentId', 'agentVersion', ], 'members' => [ 'agentId' => [ 'shape' => 'Id', 'location' => 'uri', 'locationName' => 'agentId', ], 'agentVersion' => [ 'shape' => 'Version', 'location' => 'uri', 'locationName' => 'agentVersion', ], 'maxResults' => [ 'shape' => 'MaxResults', ], 'nextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListAgentActionGroupsResponse' => [ 'type' => 'structure', 'required' => [ 'actionGroupSummaries', ], 'members' => [ 'actionGroupSummaries' => [ 'shape' => 'ActionGroupSummaries', ], 'nextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListAgentAliasesRequest' => [ 'type' => 'structure', 'required' => [ 'agentId', ], 'members' => [ 'agentId' => [ 'shape' => 'Id', 'location' => 'uri', 'locationName' => 'agentId', ], 'maxResults' => [ 'shape' => 'MaxResults', ], 'nextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListAgentAliasesResponse' => [ 'type' => 'structure', 'required' => [ 'agentAliasSummaries', ], 'members' => [ 'agentAliasSummaries' => [ 'shape' => 'AgentAliasSummaries', ], 'nextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListAgentCollaboratorsRequest' => [ 'type' => 'structure', 'required' => [ 'agentId', 'agentVersion', ], 'members' => [ 'agentId' => [ 'shape' => 'Id', 'location' => 'uri', 'locationName' => 'agentId', ], 'agentVersion' => [ 'shape' => 'Version', 'location' => 'uri', 'locationName' => 'agentVersion', ], 'maxResults' => [ 'shape' => 'MaxResults', ], 'nextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListAgentCollaboratorsResponse' => [ 'type' => 'structure', 'required' => [ 'agentCollaboratorSummaries', ], 'members' => [ 'agentCollaboratorSummaries' => [ 'shape' => 'AgentCollaboratorSummaries', ], 'nextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListAgentKnowledgeBasesRequest' => [ 'type' => 'structure', 'required' => [ 'agentId', 'agentVersion', ], 'members' => [ 'agentId' => [ 'shape' => 'Id', 'location' => 'uri', 'locationName' => 'agentId', ], 'agentVersion' => [ 'shape' => 'Version', 'location' => 'uri', 'locationName' => 'agentVersion', ], 'maxResults' => [ 'shape' => 'MaxResults', ], 'nextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListAgentKnowledgeBasesResponse' => [ 'type' => 'structure', 'required' => [ 'agentKnowledgeBaseSummaries', ], 'members' => [ 'agentKnowledgeBaseSummaries' => [ 'shape' => 'AgentKnowledgeBaseSummaries', ], 'nextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListAgentVersionsRequest' => [ 'type' => 'structure', 'required' => [ 'agentId', ], 'members' => [ 'agentId' => [ 'shape' => 'Id', 'location' => 'uri', 'locationName' => 'agentId', ], 'maxResults' => [ 'shape' => 'MaxResults', ], 'nextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListAgentVersionsResponse' => [ 'type' => 'structure', 'required' => [ 'agentVersionSummaries', ], 'members' => [ 'agentVersionSummaries' => [ 'shape' => 'AgentVersionSummaries', ], 'nextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListAgentsRequest' => [ 'type' => 'structure', 'members' => [ 'maxResults' => [ 'shape' => 'MaxResults', ], 'nextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListAgentsResponse' => [ 'type' => 'structure', 'required' => [ 'agentSummaries', ], 'members' => [ 'agentSummaries' => [ 'shape' => 'AgentSummaries', ], 'nextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListDataSourcesRequest' => [ 'type' => 'structure', 'required' => [ 'knowledgeBaseId', ], 'members' => [ 'knowledgeBaseId' => [ 'shape' => 'Id', 'location' => 'uri', 'locationName' => 'knowledgeBaseId', ], 'maxResults' => [ 'shape' => 'MaxResults', ], 'nextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListDataSourcesResponse' => [ 'type' => 'structure', 'required' => [ 'dataSourceSummaries', ], 'members' => [ 'dataSourceSummaries' => [ 'shape' => 'DataSourceSummaries', ], 'nextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListFlowAliasesRequest' => [ 'type' => 'structure', 'required' => [ 'flowIdentifier', ], 'members' => [ 'flowIdentifier' => [ 'shape' => 'FlowIdentifier', 'location' => 'uri', 'locationName' => 'flowIdentifier', ], 'maxResults' => [ 'shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'maxResults', ], 'nextToken' => [ 'shape' => 'NextToken', 'location' => 'querystring', 'locationName' => 'nextToken', ], ], ], 'ListFlowAliasesResponse' => [ 'type' => 'structure', 'required' => [ 'flowAliasSummaries', ], 'members' => [ 'flowAliasSummaries' => [ 'shape' => 'FlowAliasSummaries', ], 'nextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListFlowVersionsRequest' => [ 'type' => 'structure', 'required' => [ 'flowIdentifier', ], 'members' => [ 'flowIdentifier' => [ 'shape' => 'FlowIdentifier', 'location' => 'uri', 'locationName' => 'flowIdentifier', ], 'maxResults' => [ 'shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'maxResults', ], 'nextToken' => [ 'shape' => 'NextToken', 'location' => 'querystring', 'locationName' => 'nextToken', ], ], ], 'ListFlowVersionsResponse' => [ 'type' => 'structure', 'required' => [ 'flowVersionSummaries', ], 'members' => [ 'flowVersionSummaries' => [ 'shape' => 'FlowVersionSummaries', ], 'nextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListFlowsRequest' => [ 'type' => 'structure', 'members' => [ 'maxResults' => [ 'shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'maxResults', ], 'nextToken' => [ 'shape' => 'NextToken', 'location' => 'querystring', 'locationName' => 'nextToken', ], ], ], 'ListFlowsResponse' => [ 'type' => 'structure', 'required' => [ 'flowSummaries', ], 'members' => [ 'flowSummaries' => [ 'shape' => 'FlowSummaries', ], 'nextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListIngestionJobsRequest' => [ 'type' => 'structure', 'required' => [ 'knowledgeBaseId', 'dataSourceId', ], 'members' => [ 'knowledgeBaseId' => [ 'shape' => 'Id', 'location' => 'uri', 'locationName' => 'knowledgeBaseId', ], 'dataSourceId' => [ 'shape' => 'Id', 'location' => 'uri', 'locationName' => 'dataSourceId', ], 'filters' => [ 'shape' => 'IngestionJobFilters', ], 'sortBy' => [ 'shape' => 'IngestionJobSortBy', ], 'maxResults' => [ 'shape' => 'MaxResults', ], 'nextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListIngestionJobsResponse' => [ 'type' => 'structure', 'required' => [ 'ingestionJobSummaries', ], 'members' => [ 'ingestionJobSummaries' => [ 'shape' => 'IngestionJobSummaries', ], 'nextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListKnowledgeBaseDocumentsRequest' => [ 'type' => 'structure', 'required' => [ 'knowledgeBaseId', 'dataSourceId', ], 'members' => [ 'knowledgeBaseId' => [ 'shape' => 'Id', 'location' => 'uri', 'locationName' => 'knowledgeBaseId', ], 'dataSourceId' => [ 'shape' => 'Id', 'location' => 'uri', 'locationName' => 'dataSourceId', ], 'maxResults' => [ 'shape' => 'MaxResults', ], 'nextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListKnowledgeBaseDocumentsResponse' => [ 'type' => 'structure', 'required' => [ 'documentDetails', ], 'members' => [ 'documentDetails' => [ 'shape' => 'KnowledgeBaseDocumentDetails', ], 'nextToken' => [ 'shape' => 'String', ], ], ], 'ListKnowledgeBasesRequest' => [ 'type' => 'structure', 'members' => [ 'maxResults' => [ 'shape' => 'MaxResults', ], 'nextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListKnowledgeBasesResponse' => [ 'type' => 'structure', 'required' => [ 'knowledgeBaseSummaries', ], 'members' => [ 'knowledgeBaseSummaries' => [ 'shape' => 'KnowledgeBaseSummaries', ], 'nextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListPromptsRequest' => [ 'type' => 'structure', 'members' => [ 'promptIdentifier' => [ 'shape' => 'PromptIdentifier', 'location' => 'querystring', 'locationName' => 'promptIdentifier', ], 'maxResults' => [ 'shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'maxResults', ], 'nextToken' => [ 'shape' => 'NextToken', 'location' => 'querystring', 'locationName' => 'nextToken', ], ], ], 'ListPromptsResponse' => [ 'type' => 'structure', 'required' => [ 'promptSummaries', ], 'members' => [ 'promptSummaries' => [ 'shape' => 'PromptSummaries', ], 'nextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListTagsForResourceRequest' => [ 'type' => 'structure', 'required' => [ 'resourceArn', ], 'members' => [ 'resourceArn' => [ 'shape' => 'TaggableResourcesArn', 'location' => 'uri', 'locationName' => 'resourceArn', ], ], ], 'ListTagsForResourceResponse' => [ 'type' => 'structure', 'members' => [ 'tags' => [ 'shape' => 'TagsMap', ], ], ], 'LoopControllerFlowNodeConfiguration' => [ 'type' => 'structure', 'required' => [ 'continueCondition', ], 'members' => [ 'continueCondition' => [ 'shape' => 'FlowCondition', ], 'maxIterations' => [ 'shape' => 'LoopControllerFlowNodeConfigurationMaxIterationsInteger', ], ], ], 'LoopControllerFlowNodeConfigurationMaxIterationsInteger' => [ 'type' => 'integer', 'box' => true, 'max' => 1000, 'min' => 1, ], 'LoopFlowNodeConfiguration' => [ 'type' => 'structure', 'required' => [ 'definition', ], 'members' => [ 'definition' => [ 'shape' => 'FlowDefinition', ], ], ], 'LoopIncompatibleNodeTypeFlowValidationDetails' => [ 'type' => 'structure', 'required' => [ 'node', 'incompatibleNodeType', 'incompatibleNodeName', ], 'members' => [ 'node' => [ 'shape' => 'FlowNodeName', ], 'incompatibleNodeType' => [ 'shape' => 'IncompatibleLoopNodeType', ], 'incompatibleNodeName' => [ 'shape' => 'FlowNodeName', ], ], ], 'LoopInputFlowNodeConfiguration' => [ 'type' => 'structure', 'members' => [], ], 'MalformedConditionExpressionFlowValidationDetails' => [ 'type' => 'structure', 'required' => [ 'node', 'condition', 'cause', ], 'members' => [ 'node' => [ 'shape' => 'FlowNodeName', ], 'condition' => [ 'shape' => 'FlowConditionName', ], 'cause' => [ 'shape' => 'ErrorMessage', ], ], ], 'MalformedNodeInputExpressionFlowValidationDetails' => [ 'type' => 'structure', 'required' => [ 'node', 'input', 'cause', ], 'members' => [ 'node' => [ 'shape' => 'FlowNodeName', ], 'input' => [ 'shape' => 'FlowNodeInputName', ], 'cause' => [ 'shape' => 'ErrorMessage', ], ], ], 'MaxRecentSessions' => [ 'type' => 'integer', 'box' => true, 'min' => 1, ], 'MaxResults' => [ 'type' => 'integer', 'box' => true, 'max' => 1000, 'min' => 1, ], 'MaximumLength' => [ 'type' => 'integer', 'box' => true, 'min' => 0, ], 'MemoryConfiguration' => [ 'type' => 'structure', 'required' => [ 'enabledMemoryTypes', ], 'members' => [ 'enabledMemoryTypes' => [ 'shape' => 'EnabledMemoryTypes', ], 'storageDays' => [ 'shape' => 'StorageDays', ], 'sessionSummaryConfiguration' => [ 'shape' => 'SessionSummaryConfiguration', ], ], ], 'MemoryType' => [ 'type' => 'string', 'enum' => [ 'SESSION_SUMMARY', ], ], 'Message' => [ 'type' => 'structure', 'required' => [ 'role', 'content', ], 'members' => [ 'role' => [ 'shape' => 'ConversationRole', ], 'content' => [ 'shape' => 'ContentBlocks', ], ], ], 'Messages' => [ 'type' => 'list', 'member' => [ 'shape' => 'Message', ], ], 'MetadataAttribute' => [ 'type' => 'structure', 'required' => [ 'key', 'value', ], 'members' => [ 'key' => [ 'shape' => 'Key', ], 'value' => [ 'shape' => 'MetadataAttributeValue', ], ], ], 'MetadataAttributeValue' => [ 'type' => 'structure', 'required' => [ 'type', ], 'members' => [ 'type' => [ 'shape' => 'MetadataValueType', ], 'numberValue' => [ 'shape' => 'NumberValue', ], 'booleanValue' => [ 'shape' => 'Boolean', ], 'stringValue' => [ 'shape' => 'StringValue', ], 'stringListValue' => [ 'shape' => 'MetadataAttributeValueStringListValueList', ], ], ], 'MetadataAttributeValueStringListValueList' => [ 'type' => 'list', 'member' => [ 'shape' => 'StringValue', ], 'max' => 10, 'min' => 1, ], 'MetadataConfigurationForReranking' => [ 'type' => 'structure', 'required' => [ 'selectionMode', ], 'members' => [ 'selectionMode' => [ 'shape' => 'RerankingMetadataSelectionMode', ], 'selectiveModeConfiguration' => [ 'shape' => 'RerankingMetadataSelectiveModeConfiguration', ], ], ], 'MetadataSourceType' => [ 'type' => 'string', 'enum' => [ 'IN_LINE_ATTRIBUTE', 'S3_LOCATION', ], ], 'MetadataValueType' => [ 'type' => 'string', 'enum' => [ 'BOOLEAN', 'NUMBER', 'STRING', 'STRING_LIST', ], ], 'Microsoft365TenantId' => [ 'type' => 'string', 'max' => 36, 'min' => 36, 'pattern' => '[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}', ], 'MismatchedNodeInputTypeFlowValidationDetails' => [ 'type' => 'structure', 'required' => [ 'node', 'input', 'expectedType', ], 'members' => [ 'node' => [ 'shape' => 'FlowNodeName', ], 'input' => [ 'shape' => 'FlowNodeInputName', ], 'expectedType' => [ 'shape' => 'FlowNodeIODataType', ], ], ], 'MismatchedNodeOutputTypeFlowValidationDetails' => [ 'type' => 'structure', 'required' => [ 'node', 'output', 'expectedType', ], 'members' => [ 'node' => [ 'shape' => 'FlowNodeName', ], 'output' => [ 'shape' => 'FlowNodeOutputName', ], 'expectedType' => [ 'shape' => 'FlowNodeIODataType', ], ], ], 'MissingConnectionConfigurationFlowValidationDetails' => [ 'type' => 'structure', 'required' => [ 'connection', ], 'members' => [ 'connection' => [ 'shape' => 'FlowConnectionName', ], ], ], 'MissingDefaultConditionFlowValidationDetails' => [ 'type' => 'structure', 'required' => [ 'node', ], 'members' => [ 'node' => [ 'shape' => 'FlowNodeName', ], ], ], 'MissingEndingNodesFlowValidationDetails' => [ 'type' => 'structure', 'members' => [], ], 'MissingLoopControllerNodeFlowValidationDetails' => [ 'type' => 'structure', 'required' => [ 'loopNode', ], 'members' => [ 'loopNode' => [ 'shape' => 'FlowNodeName', ], ], ], 'MissingLoopInputNodeFlowValidationDetails' => [ 'type' => 'structure', 'required' => [ 'loopNode', ], 'members' => [ 'loopNode' => [ 'shape' => 'FlowNodeName', ], ], ], 'MissingNodeConfigurationFlowValidationDetails' => [ 'type' => 'structure', 'required' => [ 'node', ], 'members' => [ 'node' => [ 'shape' => 'FlowNodeName', ], ], ], 'MissingNodeInputFlowValidationDetails' => [ 'type' => 'structure', 'required' => [ 'node', 'input', ], 'members' => [ 'node' => [ 'shape' => 'FlowNodeName', ], 'input' => [ 'shape' => 'FlowNodeInputName', ], ], ], 'MissingNodeOutputFlowValidationDetails' => [ 'type' => 'structure', 'required' => [ 'node', 'output', ], 'members' => [ 'node' => [ 'shape' => 'FlowNodeName', ], 'output' => [ 'shape' => 'FlowNodeOutputName', ], ], ], 'MissingStartingNodesFlowValidationDetails' => [ 'type' => 'structure', 'members' => [], ], 'ModelIdentifier' => [ 'type' => 'string', 'max' => 2048, 'min' => 1, 'pattern' => '(arn:aws(-[^:]{1,12})?:(bedrock|sagemaker):[a-z0-9-]{1,20}:([0-9]{12})?:([a-z-]+/)?)?([a-zA-Z0-9.-]{1,63}){0,2}(([:][a-z0-9-]{1,63}){0,2})?(/[a-z0-9]{1,12})?', ], 'MongoDbAtlasCollectionName' => [ 'type' => 'string', 'max' => 63, 'min' => 0, 'pattern' => '.*', ], 'MongoDbAtlasConfiguration' => [ 'type' => 'structure', 'required' => [ 'endpoint', 'databaseName', 'collectionName', 'vectorIndexName', 'credentialsSecretArn', 'fieldMapping', ], 'members' => [ 'endpoint' => [ 'shape' => 'MongoDbAtlasEndpoint', ], 'databaseName' => [ 'shape' => 'MongoDbAtlasDatabaseName', ], 'collectionName' => [ 'shape' => 'MongoDbAtlasCollectionName', ], 'vectorIndexName' => [ 'shape' => 'MongoDbAtlasIndexName', ], 'credentialsSecretArn' => [ 'shape' => 'SecretArn', ], 'fieldMapping' => [ 'shape' => 'MongoDbAtlasFieldMapping', ], 'endpointServiceName' => [ 'shape' => 'MongoDbAtlasEndpointServiceName', ], 'textIndexName' => [ 'shape' => 'MongoDbAtlasIndexName', ], ], ], 'MongoDbAtlasDatabaseName' => [ 'type' => 'string', 'max' => 63, 'min' => 0, 'pattern' => '.*', ], 'MongoDbAtlasEndpoint' => [ 'type' => 'string', 'max' => 2048, 'min' => 0, 'pattern' => '.*', ], 'MongoDbAtlasEndpointServiceName' => [ 'type' => 'string', 'max' => 255, 'min' => 1, 'pattern' => '(?:arn:aws(?:-us-gov|-cn|-iso|-iso-[a-z])*:.+:.*:\\d+:.+/.+$|[a-zA-Z0-9*]+[a-zA-Z0-9._-]*)', ], 'MongoDbAtlasFieldMapping' => [ 'type' => 'structure', 'required' => [ 'vectorField', 'textField', 'metadataField', ], 'members' => [ 'vectorField' => [ 'shape' => 'FieldName', ], 'textField' => [ 'shape' => 'FieldName', ], 'metadataField' => [ 'shape' => 'FieldName', ], ], ], 'MongoDbAtlasIndexName' => [ 'type' => 'string', 'max' => 2048, 'min' => 0, 'pattern' => '.*', ], 'MultipleLoopControllerNodesFlowValidationDetails' => [ 'type' => 'structure', 'required' => [ 'loopNode', ], 'members' => [ 'loopNode' => [ 'shape' => 'FlowNodeName', ], ], ], 'MultipleLoopInputNodesFlowValidationDetails' => [ 'type' => 'structure', 'required' => [ 'loopNode', ], 'members' => [ 'loopNode' => [ 'shape' => 'FlowNodeName', ], ], ], 'MultipleNodeInputConnectionsFlowValidationDetails' => [ 'type' => 'structure', 'required' => [ 'node', 'input', ], 'members' => [ 'node' => [ 'shape' => 'FlowNodeName', ], 'input' => [ 'shape' => 'FlowNodeInputName', ], ], ], 'Name' => [ 'type' => 'string', 'pattern' => '([0-9a-zA-Z][_-]?){1,100}', ], 'NaturalLanguageString' => [ 'type' => 'string', 'max' => 1000, 'min' => 1, ], 'NeptuneAnalyticsConfiguration' => [ 'type' => 'structure', 'required' => [ 'graphArn', 'fieldMapping', ], 'members' => [ 'graphArn' => [ 'shape' => 'GraphArn', ], 'fieldMapping' => [ 'shape' => 'NeptuneAnalyticsFieldMapping', ], ], ], 'NeptuneAnalyticsFieldMapping' => [ 'type' => 'structure', 'required' => [ 'textField', 'metadataField', ], 'members' => [ 'textField' => [ 'shape' => 'FieldName', ], 'metadataField' => [ 'shape' => 'FieldName', ], ], ], 'NextToken' => [ 'type' => 'string', 'max' => 2048, 'min' => 1, 'pattern' => '\\S*', ], 'NonBlankString' => [ 'type' => 'string', 'pattern' => '[\\s\\S]+', ], 'NonEmptyString' => [ 'type' => 'string', 'min' => 1, ], 'NumberValue' => [ 'type' => 'double', 'box' => true, 'sensitive' => true, ], 'NumericalVersion' => [ 'type' => 'string', 'pattern' => '[0-9]{1,5}', ], 'OpenSearchManagedClusterConfiguration' => [ 'type' => 'structure', 'required' => [ 'domainEndpoint', 'domainArn', 'vectorIndexName', 'fieldMapping', ], 'members' => [ 'domainEndpoint' => [ 'shape' => 'OpenSearchManagedClusterDomainEndpoint', ], 'domainArn' => [ 'shape' => 'OpenSearchManagedClusterDomainArn', ], 'vectorIndexName' => [ 'shape' => 'OpenSearchManagedClusterIndexName', ], 'fieldMapping' => [ 'shape' => 'OpenSearchManagedClusterFieldMapping', ], ], ], 'OpenSearchManagedClusterDomainArn' => [ 'type' => 'string', 'max' => 2048, 'min' => 0, 'pattern' => 'arn:aws(|-cn|-us-gov|-iso):es:[a-z]{2}(-gov)?-[a-z]+-\\d{1}:\\d{12}:domain/[a-z][a-z0-9-]{3,28}', ], 'OpenSearchManagedClusterDomainEndpoint' => [ 'type' => 'string', 'max' => 2048, 'min' => 0, 'pattern' => 'https://.*', ], 'OpenSearchManagedClusterFieldMapping' => [ 'type' => 'structure', 'required' => [ 'vectorField', 'textField', 'metadataField', ], 'members' => [ 'vectorField' => [ 'shape' => 'FieldName', ], 'textField' => [ 'shape' => 'FieldName', ], 'metadataField' => [ 'shape' => 'FieldName', ], ], ], 'OpenSearchManagedClusterIndexName' => [ 'type' => 'string', 'max' => 2048, 'min' => 1, 'pattern' => '(?![\\-_+.])[a-z0-9][a-z0-9\\-_\\.]*', 'sensitive' => true, ], 'OpenSearchServerlessCollectionArn' => [ 'type' => 'string', 'max' => 2048, 'min' => 0, 'pattern' => 'arn:aws:aoss:[a-z]{2}(-gov)?-[a-z]+-\\d{1}:\\d{12}:collection/[a-z0-9-]{3,32}', ], 'OpenSearchServerlessConfiguration' => [ 'type' => 'structure', 'required' => [ 'collectionArn', 'vectorIndexName', 'fieldMapping', ], 'members' => [ 'collectionArn' => [ 'shape' => 'OpenSearchServerlessCollectionArn', ], 'vectorIndexName' => [ 'shape' => 'OpenSearchServerlessIndexName', ], 'fieldMapping' => [ 'shape' => 'OpenSearchServerlessFieldMapping', ], ], ], 'OpenSearchServerlessFieldMapping' => [ 'type' => 'structure', 'required' => [ 'vectorField', 'textField', 'metadataField', ], 'members' => [ 'vectorField' => [ 'shape' => 'FieldName', ], 'textField' => [ 'shape' => 'FieldName', ], 'metadataField' => [ 'shape' => 'FieldName', ], ], ], 'OpenSearchServerlessIndexName' => [ 'type' => 'string', 'max' => 2048, 'min' => 0, 'pattern' => '.*', ], 'OrchestrationExecutor' => [ 'type' => 'structure', 'members' => [ 'lambda' => [ 'shape' => 'LambdaArn', ], ], 'union' => true, ], 'OrchestrationType' => [ 'type' => 'string', 'enum' => [ 'DEFAULT', 'CUSTOM_ORCHESTRATION', ], ], 'OutputFlowNodeConfiguration' => [ 'type' => 'structure', 'members' => [], ], 'ParameterDescription' => [ 'type' => 'string', 'max' => 500, 'min' => 1, ], 'ParameterDetail' => [ 'type' => 'structure', 'required' => [ 'type', ], 'members' => [ 'description' => [ 'shape' => 'ParameterDescription', ], 'type' => [ 'shape' => 'Type', ], 'required' => [ 'shape' => 'Boolean', ], ], ], 'ParameterMap' => [ 'type' => 'map', 'key' => [ 'shape' => 'Name', ], 'value' => [ 'shape' => 'ParameterDetail', ], ], 'ParsingConfiguration' => [ 'type' => 'structure', 'required' => [ 'parsingStrategy', ], 'members' => [ 'parsingStrategy' => [ 'shape' => 'ParsingStrategy', ], 'bedrockFoundationModelConfiguration' => [ 'shape' => 'BedrockFoundationModelConfiguration', ], 'bedrockDataAutomationConfiguration' => [ 'shape' => 'BedrockDataAutomationConfiguration', ], ], ], 'ParsingModality' => [ 'type' => 'string', 'enum' => [ 'MULTIMODAL', ], ], 'ParsingPrompt' => [ 'type' => 'structure', 'required' => [ 'parsingPromptText', ], 'members' => [ 'parsingPromptText' => [ 'shape' => 'ParsingPromptText', ], ], ], 'ParsingPromptText' => [ 'type' => 'string', 'max' => 10000, 'min' => 1, ], 'ParsingStrategy' => [ 'type' => 'string', 'enum' => [ 'BEDROCK_FOUNDATION_MODEL', 'BEDROCK_DATA_AUTOMATION', ], ], 'PatternObjectFilter' => [ 'type' => 'structure', 'required' => [ 'objectType', ], 'members' => [ 'objectType' => [ 'shape' => 'FilteredObjectType', ], 'inclusionFilters' => [ 'shape' => 'FilterList', ], 'exclusionFilters' => [ 'shape' => 'FilterList', ], ], ], 'PatternObjectFilterConfiguration' => [ 'type' => 'structure', 'required' => [ 'filters', ], 'members' => [ 'filters' => [ 'shape' => 'PatternObjectFilterList', ], ], ], 'PatternObjectFilterList' => [ 'type' => 'list', 'member' => [ 'shape' => 'PatternObjectFilter', ], 'max' => 25, 'min' => 1, 'sensitive' => true, ], 'Payload' => [ 'type' => 'string', 'sensitive' => true, ], 'PerformanceConfigLatency' => [ 'type' => 'string', 'enum' => [ 'standard', 'optimized', ], ], 'PerformanceConfiguration' => [ 'type' => 'structure', 'members' => [ 'latency' => [ 'shape' => 'PerformanceConfigLatency', ], ], ], 'PineconeConfiguration' => [ 'type' => 'structure', 'required' => [ 'connectionString', 'credentialsSecretArn', 'fieldMapping', ], 'members' => [ 'connectionString' => [ 'shape' => 'PineconeConnectionString', ], 'credentialsSecretArn' => [ 'shape' => 'SecretArn', ], 'namespace' => [ 'shape' => 'PineconeNamespace', ], 'fieldMapping' => [ 'shape' => 'PineconeFieldMapping', ], ], ], 'PineconeConnectionString' => [ 'type' => 'string', 'max' => 2048, 'min' => 0, 'pattern' => '.*', ], 'PineconeFieldMapping' => [ 'type' => 'structure', 'required' => [ 'textField', 'metadataField', ], 'members' => [ 'textField' => [ 'shape' => 'FieldName', ], 'metadataField' => [ 'shape' => 'FieldName', ], ], ], 'PineconeNamespace' => [ 'type' => 'string', 'max' => 2048, 'min' => 0, 'pattern' => '.*', ], 'PrepareAgentRequest' => [ 'type' => 'structure', 'required' => [ 'agentId', ], 'members' => [ 'agentId' => [ 'shape' => 'Id', 'location' => 'uri', 'locationName' => 'agentId', ], ], ], 'PrepareAgentResponse' => [ 'type' => 'structure', 'required' => [ 'agentId', 'agentStatus', 'agentVersion', 'preparedAt', ], 'members' => [ 'agentId' => [ 'shape' => 'Id', ], 'agentStatus' => [ 'shape' => 'AgentStatus', ], 'agentVersion' => [ 'shape' => 'Version', ], 'preparedAt' => [ 'shape' => 'DateTimestamp', ], ], ], 'PrepareFlowRequest' => [ 'type' => 'structure', 'required' => [ 'flowIdentifier', ], 'members' => [ 'flowIdentifier' => [ 'shape' => 'FlowIdentifier', 'location' => 'uri', 'locationName' => 'flowIdentifier', ], ], ], 'PrepareFlowResponse' => [ 'type' => 'structure', 'required' => [ 'id', 'status', ], 'members' => [ 'id' => [ 'shape' => 'FlowId', ], 'status' => [ 'shape' => 'FlowStatus', ], ], ], 'PrimitiveLong' => [ 'type' => 'long', ], 'PromptAgentResource' => [ 'type' => 'structure', 'required' => [ 'agentIdentifier', ], 'members' => [ 'agentIdentifier' => [ 'shape' => 'AgentAliasArn', ], ], 'sensitive' => true, ], 'PromptArn' => [ 'type' => 'string', 'pattern' => '(arn:aws:bedrock:[a-z0-9-]{1,20}:[0-9]{12}:prompt/[0-9a-zA-Z]{10}(?::[0-9]{1,5})?)', ], 'PromptConfiguration' => [ 'type' => 'structure', 'members' => [ 'promptType' => [ 'shape' => 'PromptType', ], 'promptCreationMode' => [ 'shape' => 'CreationMode', ], 'promptState' => [ 'shape' => 'PromptState', ], 'basePromptTemplate' => [ 'shape' => 'BasePromptTemplate', ], 'inferenceConfiguration' => [ 'shape' => 'InferenceConfiguration', ], 'parserMode' => [ 'shape' => 'CreationMode', ], 'foundationModel' => [ 'shape' => 'ModelIdentifier', ], 'additionalModelRequestFields' => [ 'shape' => 'Document', ], ], ], 'PromptConfigurations' => [ 'type' => 'list', 'member' => [ 'shape' => 'PromptConfiguration', ], 'max' => 10, 'min' => 0, ], 'PromptDescription' => [ 'type' => 'string', 'max' => 200, 'min' => 1, ], 'PromptFlowNodeConfiguration' => [ 'type' => 'structure', 'required' => [ 'sourceConfiguration', ], 'members' => [ 'sourceConfiguration' => [ 'shape' => 'PromptFlowNodeSourceConfiguration', ], 'guardrailConfiguration' => [ 'shape' => 'GuardrailConfiguration', ], ], ], 'PromptFlowNodeInlineConfiguration' => [ 'type' => 'structure', 'required' => [ 'templateType', 'templateConfiguration', 'modelId', ], 'members' => [ 'templateType' => [ 'shape' => 'PromptTemplateType', ], 'templateConfiguration' => [ 'shape' => 'PromptTemplateConfiguration', ], 'modelId' => [ 'shape' => 'FlowPromptModelIdentifier', ], 'inferenceConfiguration' => [ 'shape' => 'PromptInferenceConfiguration', ], 'additionalModelRequestFields' => [ 'shape' => 'Document', ], ], ], 'PromptFlowNodeResourceConfiguration' => [ 'type' => 'structure', 'required' => [ 'promptArn', ], 'members' => [ 'promptArn' => [ 'shape' => 'FlowPromptArn', ], ], ], 'PromptFlowNodeSourceConfiguration' => [ 'type' => 'structure', 'members' => [ 'resource' => [ 'shape' => 'PromptFlowNodeResourceConfiguration', ], 'inline' => [ 'shape' => 'PromptFlowNodeInlineConfiguration', ], ], 'union' => true, ], 'PromptGenAiResource' => [ 'type' => 'structure', 'members' => [ 'agent' => [ 'shape' => 'PromptAgentResource', ], ], 'sensitive' => true, 'union' => true, ], 'PromptId' => [ 'type' => 'string', 'pattern' => '[0-9a-zA-Z]{10}', ], 'PromptIdentifier' => [ 'type' => 'string', 'pattern' => '([0-9a-zA-Z]{10})|(arn:aws:bedrock:[a-z0-9-]{1,20}:[0-9]{12}:prompt/[0-9a-zA-Z]{10})(?::[0-9]{1,5})?', ], 'PromptInferenceConfiguration' => [ 'type' => 'structure', 'members' => [ 'text' => [ 'shape' => 'PromptModelInferenceConfiguration', ], ], 'union' => true, ], 'PromptInputVariable' => [ 'type' => 'structure', 'members' => [ 'name' => [ 'shape' => 'PromptInputVariableName', ], ], ], 'PromptInputVariableName' => [ 'type' => 'string', 'pattern' => '([0-9a-zA-Z][_-]?){1,100}', ], 'PromptInputVariablesList' => [ 'type' => 'list', 'member' => [ 'shape' => 'PromptInputVariable', ], 'max' => 20, 'min' => 0, 'sensitive' => true, ], 'PromptMetadataEntry' => [ 'type' => 'structure', 'required' => [ 'key', 'value', ], 'members' => [ 'key' => [ 'shape' => 'PromptMetadataKey', ], 'value' => [ 'shape' => 'PromptMetadataValue', ], ], 'sensitive' => true, ], 'PromptMetadataKey' => [ 'type' => 'string', 'max' => 128, 'min' => 1, 'pattern' => '[a-zA-Z0-9\\s._:/=+@-]*', 'sensitive' => true, ], 'PromptMetadataList' => [ 'type' => 'list', 'member' => [ 'shape' => 'PromptMetadataEntry', ], 'max' => 50, 'min' => 0, 'sensitive' => true, ], 'PromptMetadataValue' => [ 'type' => 'string', 'max' => 1024, 'min' => 0, 'pattern' => '[a-zA-Z0-9\\s._:/=+@-]*', 'sensitive' => true, ], 'PromptModelIdentifier' => [ 'type' => 'string', 'max' => 2048, 'min' => 1, 'pattern' => '(arn:aws(-[^:]{1,12})?:(bedrock|sagemaker):[a-z0-9-]{1,20}:([0-9]{12})?:([a-z-]+/)?)?([a-zA-Z0-9.-]{1,63}){0,2}(([:][a-z0-9-]{1,63}){0,2})?(/[a-z0-9]{1,12})?', ], 'PromptModelInferenceConfiguration' => [ 'type' => 'structure', 'members' => [ 'temperature' => [ 'shape' => 'Temperature', ], 'topP' => [ 'shape' => 'TopP', ], 'maxTokens' => [ 'shape' => 'MaximumLength', ], 'stopSequences' => [ 'shape' => 'StopSequences', ], ], ], 'PromptName' => [ 'type' => 'string', 'pattern' => '([0-9a-zA-Z][_-]?){1,100}', ], 'PromptOverrideConfiguration' => [ 'type' => 'structure', 'required' => [ 'promptConfigurations', ], 'members' => [ 'promptConfigurations' => [ 'shape' => 'PromptConfigurations', ], 'overrideLambda' => [ 'shape' => 'LambdaArn', ], ], 'sensitive' => true, ], 'PromptState' => [ 'type' => 'string', 'enum' => [ 'ENABLED', 'DISABLED', ], ], 'PromptSummaries' => [ 'type' => 'list', 'member' => [ 'shape' => 'PromptSummary', ], 'max' => 10, 'min' => 0, ], 'PromptSummary' => [ 'type' => 'structure', 'required' => [ 'name', 'id', 'arn', 'version', 'createdAt', 'updatedAt', ], 'members' => [ 'name' => [ 'shape' => 'PromptName', ], 'description' => [ 'shape' => 'PromptDescription', ], 'id' => [ 'shape' => 'PromptId', ], 'arn' => [ 'shape' => 'PromptArn', ], 'version' => [ 'shape' => 'Version', ], 'createdAt' => [ 'shape' => 'DateTimestamp', ], 'updatedAt' => [ 'shape' => 'DateTimestamp', ], ], ], 'PromptTemplateConfiguration' => [ 'type' => 'structure', 'members' => [ 'text' => [ 'shape' => 'TextPromptTemplateConfiguration', ], 'chat' => [ 'shape' => 'ChatPromptTemplateConfiguration', ], ], 'union' => true, ], 'PromptTemplateType' => [ 'type' => 'string', 'enum' => [ 'TEXT', 'CHAT', ], ], 'PromptType' => [ 'type' => 'string', 'enum' => [ 'PRE_PROCESSING', 'ORCHESTRATION', 'POST_PROCESSING', 'KNOWLEDGE_BASE_RESPONSE_GENERATION', 'MEMORY_SUMMARIZATION', ], ], 'PromptVariant' => [ 'type' => 'structure', 'required' => [ 'name', 'templateType', 'templateConfiguration', ], 'members' => [ 'name' => [ 'shape' => 'PromptVariantName', ], 'templateType' => [ 'shape' => 'PromptTemplateType', ], 'templateConfiguration' => [ 'shape' => 'PromptTemplateConfiguration', ], 'modelId' => [ 'shape' => 'PromptModelIdentifier', ], 'inferenceConfiguration' => [ 'shape' => 'PromptInferenceConfiguration', ], 'metadata' => [ 'shape' => 'PromptMetadataList', ], 'additionalModelRequestFields' => [ 'shape' => 'Document', ], 'genAiResource' => [ 'shape' => 'PromptGenAiResource', ], ], 'sensitive' => true, ], 'PromptVariantList' => [ 'type' => 'list', 'member' => [ 'shape' => 'PromptVariant', ], 'max' => 1, 'min' => 0, 'sensitive' => true, ], 'PromptVariantName' => [ 'type' => 'string', 'pattern' => '([0-9a-zA-Z][_-]?){1,100}', ], 'ProvisionedModelIdentifier' => [ 'type' => 'string', 'max' => 2048, 'min' => 1, 'pattern' => '((([0-9a-zA-Z][_-]?){1,63})|(arn:aws(-[^:]+)?:bedrock:[a-z0-9-]{1,20}:[0-9]{12}:provisioned-model/[a-z0-9]{12}))', ], 'QueryEngineType' => [ 'type' => 'string', 'enum' => [ 'REDSHIFT', ], ], 'QueryExecutionTimeoutSeconds' => [ 'type' => 'integer', 'box' => true, 'max' => 200, 'min' => 1, ], 'QueryGenerationColumn' => [ 'type' => 'structure', 'members' => [ 'name' => [ 'shape' => 'QueryGenerationColumnName', ], 'description' => [ 'shape' => 'DescriptionString', ], 'inclusion' => [ 'shape' => 'IncludeExclude', ], ], ], 'QueryGenerationColumnName' => [ 'type' => 'string', 'max' => 127, 'min' => 1, ], 'QueryGenerationColumns' => [ 'type' => 'list', 'member' => [ 'shape' => 'QueryGenerationColumn', ], ], 'QueryGenerationConfiguration' => [ 'type' => 'structure', 'members' => [ 'executionTimeoutSeconds' => [ 'shape' => 'QueryExecutionTimeoutSeconds', ], 'generationContext' => [ 'shape' => 'QueryGenerationContext', ], ], ], 'QueryGenerationContext' => [ 'type' => 'structure', 'members' => [ 'tables' => [ 'shape' => 'QueryGenerationTables', ], 'curatedQueries' => [ 'shape' => 'CuratedQueries', ], ], 'sensitive' => true, ], 'QueryGenerationTable' => [ 'type' => 'structure', 'required' => [ 'name', ], 'members' => [ 'name' => [ 'shape' => 'QueryGenerationTableName', ], 'description' => [ 'shape' => 'DescriptionString', ], 'inclusion' => [ 'shape' => 'IncludeExclude', ], 'columns' => [ 'shape' => 'QueryGenerationColumns', ], ], ], 'QueryGenerationTableName' => [ 'type' => 'string', 'pattern' => '.*\\..*\\..*', ], 'QueryGenerationTables' => [ 'type' => 'list', 'member' => [ 'shape' => 'QueryGenerationTable', ], 'max' => 50, 'min' => 0, ], 'RdsArn' => [ 'type' => 'string', 'pattern' => 'arn:aws(|-cn|-us-gov):rds:[a-zA-Z0-9-]*:[0-9]{12}:cluster:[a-zA-Z0-9-]{1,63}', ], 'RdsConfiguration' => [ 'type' => 'structure', 'required' => [ 'resourceArn', 'credentialsSecretArn', 'databaseName', 'tableName', 'fieldMapping', ], 'members' => [ 'resourceArn' => [ 'shape' => 'RdsArn', ], 'credentialsSecretArn' => [ 'shape' => 'SecretArn', ], 'databaseName' => [ 'shape' => 'RdsDatabaseName', ], 'tableName' => [ 'shape' => 'RdsTableName', ], 'fieldMapping' => [ 'shape' => 'RdsFieldMapping', ], ], ], 'RdsDatabaseName' => [ 'type' => 'string', 'max' => 63, 'min' => 0, 'pattern' => '[a-zA-Z0-9_\\-]+', ], 'RdsFieldMapping' => [ 'type' => 'structure', 'required' => [ 'primaryKeyField', 'vectorField', 'textField', 'metadataField', ], 'members' => [ 'primaryKeyField' => [ 'shape' => 'ColumnName', ], 'vectorField' => [ 'shape' => 'ColumnName', ], 'textField' => [ 'shape' => 'ColumnName', ], 'metadataField' => [ 'shape' => 'ColumnName', ], 'customMetadataField' => [ 'shape' => 'ColumnName', ], ], ], 'RdsTableName' => [ 'type' => 'string', 'max' => 63, 'min' => 0, 'pattern' => '[a-zA-Z0-9_\\.\\-]+', ], 'RecommendedAction' => [ 'type' => 'string', 'max' => 2048, 'min' => 0, ], 'RecommendedActions' => [ 'type' => 'list', 'member' => [ 'shape' => 'RecommendedAction', ], 'max' => 2048, 'min' => 0, ], 'RedisEnterpriseCloudConfiguration' => [ 'type' => 'structure', 'required' => [ 'endpoint', 'vectorIndexName', 'credentialsSecretArn', 'fieldMapping', ], 'members' => [ 'endpoint' => [ 'shape' => 'RedisEnterpriseCloudEndpoint', ], 'vectorIndexName' => [ 'shape' => 'RedisEnterpriseCloudIndexName', ], 'credentialsSecretArn' => [ 'shape' => 'SecretArn', ], 'fieldMapping' => [ 'shape' => 'RedisEnterpriseCloudFieldMapping', ], ], ], 'RedisEnterpriseCloudEndpoint' => [ 'type' => 'string', 'max' => 2048, 'min' => 0, 'pattern' => '.*', ], 'RedisEnterpriseCloudFieldMapping' => [ 'type' => 'structure', 'required' => [ 'vectorField', 'textField', 'metadataField', ], 'members' => [ 'vectorField' => [ 'shape' => 'FieldName', ], 'textField' => [ 'shape' => 'FieldName', ], 'metadataField' => [ 'shape' => 'FieldName', ], ], ], 'RedisEnterpriseCloudIndexName' => [ 'type' => 'string', 'max' => 2048, 'min' => 0, 'pattern' => '.*', ], 'RedshiftClusterIdentifier' => [ 'type' => 'string', 'max' => 63, 'min' => 1, ], 'RedshiftConfiguration' => [ 'type' => 'structure', 'required' => [ 'storageConfigurations', 'queryEngineConfiguration', ], 'members' => [ 'storageConfigurations' => [ 'shape' => 'RedshiftQueryEngineStorageConfigurations', ], 'queryEngineConfiguration' => [ 'shape' => 'RedshiftQueryEngineConfiguration', ], 'queryGenerationConfiguration' => [ 'shape' => 'QueryGenerationConfiguration', ], ], ], 'RedshiftDatabase' => [ 'type' => 'string', 'max' => 200, 'min' => 1, ], 'RedshiftProvisionedAuthConfiguration' => [ 'type' => 'structure', 'required' => [ 'type', ], 'members' => [ 'type' => [ 'shape' => 'RedshiftProvisionedAuthType', ], 'databaseUser' => [ 'shape' => 'String', ], 'usernamePasswordSecretArn' => [ 'shape' => 'SecretArn', ], ], ], 'RedshiftProvisionedAuthType' => [ 'type' => 'string', 'enum' => [ 'IAM', 'USERNAME_PASSWORD', 'USERNAME', ], ], 'RedshiftProvisionedConfiguration' => [ 'type' => 'structure', 'required' => [ 'clusterIdentifier', 'authConfiguration', ], 'members' => [ 'clusterIdentifier' => [ 'shape' => 'RedshiftClusterIdentifier', ], 'authConfiguration' => [ 'shape' => 'RedshiftProvisionedAuthConfiguration', ], ], ], 'RedshiftQueryEngineAwsDataCatalogStorageConfiguration' => [ 'type' => 'structure', 'required' => [ 'tableNames', ], 'members' => [ 'tableNames' => [ 'shape' => 'AwsDataCatalogTableNames', ], ], ], 'RedshiftQueryEngineConfiguration' => [ 'type' => 'structure', 'required' => [ 'type', ], 'members' => [ 'type' => [ 'shape' => 'RedshiftQueryEngineType', ], 'serverlessConfiguration' => [ 'shape' => 'RedshiftServerlessConfiguration', ], 'provisionedConfiguration' => [ 'shape' => 'RedshiftProvisionedConfiguration', ], ], ], 'RedshiftQueryEngineRedshiftStorageConfiguration' => [ 'type' => 'structure', 'required' => [ 'databaseName', ], 'members' => [ 'databaseName' => [ 'shape' => 'RedshiftDatabase', ], ], ], 'RedshiftQueryEngineStorageConfiguration' => [ 'type' => 'structure', 'required' => [ 'type', ], 'members' => [ 'type' => [ 'shape' => 'RedshiftQueryEngineStorageType', ], 'awsDataCatalogConfiguration' => [ 'shape' => 'RedshiftQueryEngineAwsDataCatalogStorageConfiguration', ], 'redshiftConfiguration' => [ 'shape' => 'RedshiftQueryEngineRedshiftStorageConfiguration', ], ], ], 'RedshiftQueryEngineStorageConfigurations' => [ 'type' => 'list', 'member' => [ 'shape' => 'RedshiftQueryEngineStorageConfiguration', ], 'max' => 1, 'min' => 1, ], 'RedshiftQueryEngineStorageType' => [ 'type' => 'string', 'enum' => [ 'REDSHIFT', 'AWS_DATA_CATALOG', ], ], 'RedshiftQueryEngineType' => [ 'type' => 'string', 'enum' => [ 'SERVERLESS', 'PROVISIONED', ], ], 'RedshiftServerlessAuthConfiguration' => [ 'type' => 'structure', 'required' => [ 'type', ], 'members' => [ 'type' => [ 'shape' => 'RedshiftServerlessAuthType', ], 'usernamePasswordSecretArn' => [ 'shape' => 'SecretArn', ], ], ], 'RedshiftServerlessAuthType' => [ 'type' => 'string', 'enum' => [ 'IAM', 'USERNAME_PASSWORD', ], ], 'RedshiftServerlessConfiguration' => [ 'type' => 'structure', 'required' => [ 'workgroupArn', 'authConfiguration', ], 'members' => [ 'workgroupArn' => [ 'shape' => 'WorkgroupArn', ], 'authConfiguration' => [ 'shape' => 'RedshiftServerlessAuthConfiguration', ], ], ], 'RelayConversationHistory' => [ 'type' => 'string', 'enum' => [ 'TO_COLLABORATOR', 'DISABLED', ], ], 'RequireConfirmation' => [ 'type' => 'string', 'enum' => [ 'ENABLED', 'DISABLED', ], ], 'RerankingMetadataSelectionMode' => [ 'type' => 'string', 'enum' => [ 'SELECTIVE', 'ALL', ], ], 'RerankingMetadataSelectiveModeConfiguration' => [ 'type' => 'structure', 'members' => [ 'fieldsToInclude' => [ 'shape' => 'FieldsForReranking', ], 'fieldsToExclude' => [ 'shape' => 'FieldsForReranking', ], ], 'union' => true, ], 'ResourceNotFoundException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'NonBlankString', ], ], 'error' => [ 'httpStatusCode' => 404, 'senderFault' => true, ], 'exception' => true, ], 'RetrievalFlowNodeConfiguration' => [ 'type' => 'structure', 'required' => [ 'serviceConfiguration', ], 'members' => [ 'serviceConfiguration' => [ 'shape' => 'RetrievalFlowNodeServiceConfiguration', ], ], ], 'RetrievalFlowNodeS3Configuration' => [ 'type' => 'structure', 'required' => [ 'bucketName', ], 'members' => [ 'bucketName' => [ 'shape' => 'FlowS3BucketName', ], ], ], 'RetrievalFlowNodeServiceConfiguration' => [ 'type' => 'structure', 'members' => [ 's3' => [ 'shape' => 'RetrievalFlowNodeS3Configuration', ], ], 'union' => true, ], 'S3BucketArn' => [ 'type' => 'string', 'max' => 2048, 'min' => 1, 'pattern' => 'arn:aws(|-cn|-us-gov):s3:::[a-z0-9][a-z0-9.-]{1,61}[a-z0-9]', ], 'S3BucketName' => [ 'type' => 'string', 'max' => 63, 'min' => 3, 'pattern' => '[a-z0-9][\\.\\-a-z0-9]{1,61}[a-z0-9]', ], 'S3BucketUri' => [ 'type' => 'string', 'max' => 2048, 'min' => 1, 'pattern' => 's3://.{1,128}', ], 'S3Content' => [ 'type' => 'structure', 'required' => [ 's3Location', ], 'members' => [ 's3Location' => [ 'shape' => 'S3Location', ], ], ], 'S3DataSourceConfiguration' => [ 'type' => 'structure', 'required' => [ 'bucketArn', ], 'members' => [ 'bucketArn' => [ 'shape' => 'S3BucketArn', ], 'inclusionPrefixes' => [ 'shape' => 'S3Prefixes', ], 'bucketOwnerAccountId' => [ 'shape' => 'BucketOwnerAccountId', ], ], ], 'S3Identifier' => [ 'type' => 'structure', 'members' => [ 's3BucketName' => [ 'shape' => 'S3BucketName', ], 's3ObjectKey' => [ 'shape' => 'S3ObjectKey', ], ], ], 'S3Location' => [ 'type' => 'structure', 'required' => [ 'uri', ], 'members' => [ 'uri' => [ 'shape' => 'S3BucketUri', ], ], ], 'S3ObjectKey' => [ 'type' => 'string', 'max' => 1024, 'min' => 1, 'pattern' => '[\\.\\-\\!\\*\\_\\\'\\(\\)a-zA-Z0-9][\\.\\-\\!\\*\\_\\\'\\(\\)\\/a-zA-Z0-9]*', ], 'S3ObjectUri' => [ 'type' => 'string', 'max' => 1024, 'min' => 1, 'pattern' => 's3://[a-z0-9][a-z0-9.-]{1,61}[a-z0-9]/.{1,1024}', ], 'S3Prefix' => [ 'type' => 'string', 'max' => 300, 'min' => 1, 'sensitive' => true, ], 'S3Prefixes' => [ 'type' => 'list', 'member' => [ 'shape' => 'S3Prefix', ], 'max' => 1, 'min' => 1, ], 'S3VectorsConfiguration' => [ 'type' => 'structure', 'members' => [ 'vectorBucketArn' => [ 'shape' => 'VectorBucketArn', ], 'indexArn' => [ 'shape' => 'IndexArn', ], 'indexName' => [ 'shape' => 'IndexName', ], ], ], 'SalesforceAuthType' => [ 'type' => 'string', 'enum' => [ 'OAUTH2_CLIENT_CREDENTIALS', ], ], 'SalesforceCrawlerConfiguration' => [ 'type' => 'structure', 'members' => [ 'filterConfiguration' => [ 'shape' => 'CrawlFilterConfiguration', ], ], ], 'SalesforceDataSourceConfiguration' => [ 'type' => 'structure', 'required' => [ 'sourceConfiguration', ], 'members' => [ 'sourceConfiguration' => [ 'shape' => 'SalesforceSourceConfiguration', ], 'crawlerConfiguration' => [ 'shape' => 'SalesforceCrawlerConfiguration', ], ], ], 'SalesforceSourceConfiguration' => [ 'type' => 'structure', 'required' => [ 'hostUrl', 'authType', 'credentialsSecretArn', ], 'members' => [ 'hostUrl' => [ 'shape' => 'HttpsUrl', ], 'authType' => [ 'shape' => 'SalesforceAuthType', ], 'credentialsSecretArn' => [ 'shape' => 'SecretArn', ], ], ], 'SecretArn' => [ 'type' => 'string', 'pattern' => 'arn:aws(|-cn|-us-gov):secretsmanager:[a-z0-9-]{1,20}:([0-9]{12}|):secret:[a-zA-Z0-9!/_+=.@-]{1,512}', ], 'SeedUrl' => [ 'type' => 'structure', 'members' => [ 'url' => [ 'shape' => 'Url', ], ], ], 'SeedUrls' => [ 'type' => 'list', 'member' => [ 'shape' => 'SeedUrl', ], 'max' => 100, 'min' => 1, ], 'SemanticChunkingConfiguration' => [ 'type' => 'structure', 'required' => [ 'maxTokens', 'bufferSize', 'breakpointPercentileThreshold', ], 'members' => [ 'maxTokens' => [ 'shape' => 'SemanticChunkingConfigurationMaxTokensInteger', ], 'bufferSize' => [ 'shape' => 'SemanticChunkingConfigurationBufferSizeInteger', ], 'breakpointPercentileThreshold' => [ 'shape' => 'SemanticChunkingConfigurationBreakpointPercentileThresholdInteger', ], ], ], 'SemanticChunkingConfigurationBreakpointPercentileThresholdInteger' => [ 'type' => 'integer', 'box' => true, 'max' => 99, 'min' => 50, ], 'SemanticChunkingConfigurationBufferSizeInteger' => [ 'type' => 'integer', 'box' => true, 'max' => 1, 'min' => 0, ], 'SemanticChunkingConfigurationMaxTokensInteger' => [ 'type' => 'integer', 'box' => true, 'min' => 1, ], 'ServerSideEncryptionConfiguration' => [ 'type' => 'structure', 'members' => [ 'kmsKeyArn' => [ 'shape' => 'KmsKeyArn', ], ], ], 'ServiceQuotaExceededException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'NonBlankString', ], ], 'error' => [ 'httpStatusCode' => 402, 'senderFault' => true, ], 'exception' => true, ], 'SessionSummaryConfiguration' => [ 'type' => 'structure', 'members' => [ 'maxRecentSessions' => [ 'shape' => 'MaxRecentSessions', ], ], ], 'SessionTTL' => [ 'type' => 'integer', 'box' => true, 'max' => 5400, 'min' => 60, ], 'SharePointAuthType' => [ 'type' => 'string', 'enum' => [ 'OAUTH2_CLIENT_CREDENTIALS', 'OAUTH2_SHAREPOINT_APP_ONLY_CLIENT_CREDENTIALS', ], ], 'SharePointCrawlerConfiguration' => [ 'type' => 'structure', 'members' => [ 'filterConfiguration' => [ 'shape' => 'CrawlFilterConfiguration', ], ], ], 'SharePointDataSourceConfiguration' => [ 'type' => 'structure', 'required' => [ 'sourceConfiguration', ], 'members' => [ 'sourceConfiguration' => [ 'shape' => 'SharePointSourceConfiguration', ], 'crawlerConfiguration' => [ 'shape' => 'SharePointCrawlerConfiguration', ], ], ], 'SharePointDomain' => [ 'type' => 'string', 'max' => 50, 'min' => 1, ], 'SharePointHostType' => [ 'type' => 'string', 'enum' => [ 'ONLINE', ], ], 'SharePointSiteUrls' => [ 'type' => 'list', 'member' => [ 'shape' => 'HttpsUrl', ], 'max' => 100, 'min' => 1, ], 'SharePointSourceConfiguration' => [ 'type' => 'structure', 'required' => [ 'domain', 'siteUrls', 'hostType', 'authType', 'credentialsSecretArn', ], 'members' => [ 'tenantId' => [ 'shape' => 'Microsoft365TenantId', ], 'domain' => [ 'shape' => 'SharePointDomain', ], 'siteUrls' => [ 'shape' => 'SharePointSiteUrls', ], 'hostType' => [ 'shape' => 'SharePointHostType', ], 'authType' => [ 'shape' => 'SharePointAuthType', ], 'credentialsSecretArn' => [ 'shape' => 'SecretArn', ], ], ], 'SortOrder' => [ 'type' => 'string', 'enum' => [ 'ASCENDING', 'DESCENDING', ], ], 'SpecificToolChoice' => [ 'type' => 'structure', 'required' => [ 'name', ], 'members' => [ 'name' => [ 'shape' => 'ToolName', ], ], ], 'SqlKnowledgeBaseConfiguration' => [ 'type' => 'structure', 'required' => [ 'type', ], 'members' => [ 'type' => [ 'shape' => 'QueryEngineType', ], 'redshiftConfiguration' => [ 'shape' => 'RedshiftConfiguration', ], ], ], 'SqlString' => [ 'type' => 'string', 'max' => 1000, 'min' => 1, ], 'StartIngestionJobRequest' => [ 'type' => 'structure', 'required' => [ 'knowledgeBaseId', 'dataSourceId', ], 'members' => [ 'knowledgeBaseId' => [ 'shape' => 'Id', 'location' => 'uri', 'locationName' => 'knowledgeBaseId', ], 'dataSourceId' => [ 'shape' => 'Id', 'location' => 'uri', 'locationName' => 'dataSourceId', ], 'clientToken' => [ 'shape' => 'ClientToken', 'idempotencyToken' => true, ], 'description' => [ 'shape' => 'Description', ], ], ], 'StartIngestionJobResponse' => [ 'type' => 'structure', 'required' => [ 'ingestionJob', ], 'members' => [ 'ingestionJob' => [ 'shape' => 'IngestionJob', ], ], ], 'StepType' => [ 'type' => 'string', 'enum' => [ 'POST_CHUNKING', ], ], 'StopIngestionJobRequest' => [ 'type' => 'structure', 'required' => [ 'knowledgeBaseId', 'dataSourceId', 'ingestionJobId', ], 'members' => [ 'knowledgeBaseId' => [ 'shape' => 'Id', 'location' => 'uri', 'locationName' => 'knowledgeBaseId', ], 'dataSourceId' => [ 'shape' => 'Id', 'location' => 'uri', 'locationName' => 'dataSourceId', ], 'ingestionJobId' => [ 'shape' => 'Id', 'location' => 'uri', 'locationName' => 'ingestionJobId', ], ], ], 'StopIngestionJobResponse' => [ 'type' => 'structure', 'required' => [ 'ingestionJob', ], 'members' => [ 'ingestionJob' => [ 'shape' => 'IngestionJob', ], ], ], 'StopSequences' => [ 'type' => 'list', 'member' => [ 'shape' => 'String', ], 'max' => 4, 'min' => 0, ], 'StorageConfiguration' => [ 'type' => 'structure', 'required' => [ 'type', ], 'members' => [ 'type' => [ 'shape' => 'KnowledgeBaseStorageType', ], 'opensearchServerlessConfiguration' => [ 'shape' => 'OpenSearchServerlessConfiguration', ], 'opensearchManagedClusterConfiguration' => [ 'shape' => 'OpenSearchManagedClusterConfiguration', ], 'pineconeConfiguration' => [ 'shape' => 'PineconeConfiguration', ], 'redisEnterpriseCloudConfiguration' => [ 'shape' => 'RedisEnterpriseCloudConfiguration', ], 'rdsConfiguration' => [ 'shape' => 'RdsConfiguration', ], 'mongoDbAtlasConfiguration' => [ 'shape' => 'MongoDbAtlasConfiguration', ], 'neptuneAnalyticsConfiguration' => [ 'shape' => 'NeptuneAnalyticsConfiguration', ], 's3VectorsConfiguration' => [ 'shape' => 'S3VectorsConfiguration', ], ], ], 'StorageDays' => [ 'type' => 'integer', 'box' => true, 'max' => 365, 'min' => 0, ], 'StorageFlowNodeConfiguration' => [ 'type' => 'structure', 'required' => [ 'serviceConfiguration', ], 'members' => [ 'serviceConfiguration' => [ 'shape' => 'StorageFlowNodeServiceConfiguration', ], ], ], 'StorageFlowNodeS3Configuration' => [ 'type' => 'structure', 'required' => [ 'bucketName', ], 'members' => [ 'bucketName' => [ 'shape' => 'FlowS3BucketName', ], ], ], 'StorageFlowNodeServiceConfiguration' => [ 'type' => 'structure', 'members' => [ 's3' => [ 'shape' => 'StorageFlowNodeS3Configuration', ], ], 'union' => true, ], 'String' => [ 'type' => 'string', ], 'StringValue' => [ 'type' => 'string', 'max' => 2048, 'min' => 1, 'sensitive' => true, ], 'SupplementalDataStorageConfiguration' => [ 'type' => 'structure', 'required' => [ 'storageLocations', ], 'members' => [ 'storageLocations' => [ 'shape' => 'SupplementalDataStorageLocations', ], ], ], 'SupplementalDataStorageLocation' => [ 'type' => 'structure', 'required' => [ 'type', ], 'members' => [ 'type' => [ 'shape' => 'SupplementalDataStorageLocationType', ], 's3Location' => [ 'shape' => 'S3Location', ], ], ], 'SupplementalDataStorageLocationType' => [ 'type' => 'string', 'enum' => [ 'S3', ], ], 'SupplementalDataStorageLocations' => [ 'type' => 'list', 'member' => [ 'shape' => 'SupplementalDataStorageLocation', ], 'max' => 1, 'min' => 1, ], 'SupportedLanguages' => [ 'type' => 'string', 'enum' => [ 'Python_3', ], ], 'SystemContentBlock' => [ 'type' => 'structure', 'members' => [ 'text' => [ 'shape' => 'NonEmptyString', ], 'cachePoint' => [ 'shape' => 'CachePointBlock', ], ], 'sensitive' => true, 'union' => true, ], 'SystemContentBlocks' => [ 'type' => 'list', 'member' => [ 'shape' => 'SystemContentBlock', ], ], 'TagKey' => [ 'type' => 'string', 'max' => 128, 'min' => 1, 'pattern' => '[a-zA-Z0-9\\s._:/=+@-]*', ], 'TagKeyList' => [ 'type' => 'list', 'member' => [ 'shape' => 'TagKey', ], 'max' => 200, 'min' => 0, ], 'TagResourceRequest' => [ 'type' => 'structure', 'required' => [ 'resourceArn', 'tags', ], 'members' => [ 'resourceArn' => [ 'shape' => 'TaggableResourcesArn', 'location' => 'uri', 'locationName' => 'resourceArn', ], 'tags' => [ 'shape' => 'TagsMap', ], ], ], 'TagResourceResponse' => [ 'type' => 'structure', 'members' => [], ], 'TagValue' => [ 'type' => 'string', 'max' => 256, 'min' => 0, 'pattern' => '[a-zA-Z0-9\\s._:/=+@-]*', ], 'TaggableResourcesArn' => [ 'type' => 'string', 'max' => 1011, 'min' => 20, 'pattern' => '.*(^arn:aws:bedrock:[a-zA-Z0-9-]+:/d{12}:(agent|agent-alias|knowledge-base|flow|prompt)/[A-Z0-9]{10}(?:/[A-Z0-9]{10})?$|^arn:aws:bedrock:[a-zA-Z0-9-]+:/d{12}:flow/([A-Z0-9]{10})/alias/([A-Z0-9]{10})$|^arn:aws:bedrock:[a-zA-Z0-9-]+:/d{12}:prompt/([A-Z0-9]{10})?(?::/d+)?$).*', ], 'TagsMap' => [ 'type' => 'map', 'key' => [ 'shape' => 'TagKey', ], 'value' => [ 'shape' => 'TagValue', ], ], 'Temperature' => [ 'type' => 'float', 'box' => true, 'max' => 1, 'min' => 0, ], 'TextContentDoc' => [ 'type' => 'structure', 'required' => [ 'data', ], 'members' => [ 'data' => [ 'shape' => 'Data', ], ], ], 'TextPrompt' => [ 'type' => 'string', 'min' => 1, 'sensitive' => true, ], 'TextPromptTemplateConfiguration' => [ 'type' => 'structure', 'required' => [ 'text', ], 'members' => [ 'text' => [ 'shape' => 'TextPrompt', ], 'cachePoint' => [ 'shape' => 'CachePointBlock', ], 'inputVariables' => [ 'shape' => 'PromptInputVariablesList', ], ], 'sensitive' => true, ], 'ThrottlingException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'NonBlankString', ], ], 'error' => [ 'httpStatusCode' => 429, 'senderFault' => true, ], 'exception' => true, ], 'Tool' => [ 'type' => 'structure', 'members' => [ 'toolSpec' => [ 'shape' => 'ToolSpecification', ], 'cachePoint' => [ 'shape' => 'CachePointBlock', ], ], 'union' => true, ], 'ToolChoice' => [ 'type' => 'structure', 'members' => [ 'auto' => [ 'shape' => 'AutoToolChoice', ], 'any' => [ 'shape' => 'AnyToolChoice', ], 'tool' => [ 'shape' => 'SpecificToolChoice', ], ], 'sensitive' => true, 'union' => true, ], 'ToolConfiguration' => [ 'type' => 'structure', 'required' => [ 'tools', ], 'members' => [ 'tools' => [ 'shape' => 'ToolConfigurationToolsList', ], 'toolChoice' => [ 'shape' => 'ToolChoice', ], ], ], 'ToolConfigurationToolsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'Tool', ], 'min' => 1, 'sensitive' => true, ], 'ToolInputSchema' => [ 'type' => 'structure', 'members' => [ 'json' => [ 'shape' => 'Document', ], ], 'union' => true, ], 'ToolName' => [ 'type' => 'string', 'max' => 64, 'min' => 1, 'pattern' => '[a-zA-Z][a-zA-Z0-9_]*', ], 'ToolSpecification' => [ 'type' => 'structure', 'required' => [ 'name', 'inputSchema', ], 'members' => [ 'name' => [ 'shape' => 'ToolName', ], 'description' => [ 'shape' => 'NonEmptyString', ], 'inputSchema' => [ 'shape' => 'ToolInputSchema', ], ], ], 'TopK' => [ 'type' => 'integer', 'box' => true, 'max' => 500, 'min' => 0, ], 'TopP' => [ 'type' => 'float', 'box' => true, 'max' => 1, 'min' => 0, ], 'Transformation' => [ 'type' => 'structure', 'required' => [ 'transformationFunction', 'stepToApply', ], 'members' => [ 'transformationFunction' => [ 'shape' => 'TransformationFunction', ], 'stepToApply' => [ 'shape' => 'StepType', ], ], ], 'TransformationFunction' => [ 'type' => 'structure', 'required' => [ 'transformationLambdaConfiguration', ], 'members' => [ 'transformationLambdaConfiguration' => [ 'shape' => 'TransformationLambdaConfiguration', ], ], ], 'TransformationLambdaConfiguration' => [ 'type' => 'structure', 'required' => [ 'lambdaArn', ], 'members' => [ 'lambdaArn' => [ 'shape' => 'LambdaArn', ], ], ], 'Transformations' => [ 'type' => 'list', 'member' => [ 'shape' => 'Transformation', ], 'max' => 1, 'min' => 1, ], 'Type' => [ 'type' => 'string', 'enum' => [ 'string', 'number', 'integer', 'boolean', 'array', ], ], 'UnfulfilledNodeInputFlowValidationDetails' => [ 'type' => 'structure', 'required' => [ 'node', 'input', ], 'members' => [ 'node' => [ 'shape' => 'FlowNodeName', ], 'input' => [ 'shape' => 'FlowNodeInputName', ], ], ], 'UnknownConnectionConditionFlowValidationDetails' => [ 'type' => 'structure', 'required' => [ 'connection', ], 'members' => [ 'connection' => [ 'shape' => 'FlowConnectionName', ], ], ], 'UnknownConnectionSourceFlowValidationDetails' => [ 'type' => 'structure', 'required' => [ 'connection', ], 'members' => [ 'connection' => [ 'shape' => 'FlowConnectionName', ], ], ], 'UnknownConnectionSourceOutputFlowValidationDetails' => [ 'type' => 'structure', 'required' => [ 'connection', ], 'members' => [ 'connection' => [ 'shape' => 'FlowConnectionName', ], ], ], 'UnknownConnectionTargetFlowValidationDetails' => [ 'type' => 'structure', 'required' => [ 'connection', ], 'members' => [ 'connection' => [ 'shape' => 'FlowConnectionName', ], ], ], 'UnknownConnectionTargetInputFlowValidationDetails' => [ 'type' => 'structure', 'required' => [ 'connection', ], 'members' => [ 'connection' => [ 'shape' => 'FlowConnectionName', ], ], ], 'UnknownNodeInputFlowValidationDetails' => [ 'type' => 'structure', 'required' => [ 'node', 'input', ], 'members' => [ 'node' => [ 'shape' => 'FlowNodeName', ], 'input' => [ 'shape' => 'FlowNodeInputName', ], ], ], 'UnknownNodeOutputFlowValidationDetails' => [ 'type' => 'structure', 'required' => [ 'node', 'output', ], 'members' => [ 'node' => [ 'shape' => 'FlowNodeName', ], 'output' => [ 'shape' => 'FlowNodeOutputName', ], ], ], 'UnreachableNodeFlowValidationDetails' => [ 'type' => 'structure', 'required' => [ 'node', ], 'members' => [ 'node' => [ 'shape' => 'FlowNodeName', ], ], ], 'UnsatisfiedConnectionConditionsFlowValidationDetails' => [ 'type' => 'structure', 'required' => [ 'connection', ], 'members' => [ 'connection' => [ 'shape' => 'FlowConnectionName', ], ], ], 'UnspecifiedFlowValidationDetails' => [ 'type' => 'structure', 'members' => [], ], 'UntagResourceRequest' => [ 'type' => 'structure', 'required' => [ 'resourceArn', 'tagKeys', ], 'members' => [ 'resourceArn' => [ 'shape' => 'TaggableResourcesArn', 'location' => 'uri', 'locationName' => 'resourceArn', ], 'tagKeys' => [ 'shape' => 'TagKeyList', 'location' => 'querystring', 'locationName' => 'tagKeys', ], ], ], 'UntagResourceResponse' => [ 'type' => 'structure', 'members' => [], ], 'UpdateAgentActionGroupRequest' => [ 'type' => 'structure', 'required' => [ 'agentId', 'agentVersion', 'actionGroupId', 'actionGroupName', ], 'members' => [ 'agentId' => [ 'shape' => 'Id', 'location' => 'uri', 'locationName' => 'agentId', ], 'agentVersion' => [ 'shape' => 'DraftVersion', 'location' => 'uri', 'locationName' => 'agentVersion', ], 'actionGroupId' => [ 'shape' => 'Id', 'location' => 'uri', 'locationName' => 'actionGroupId', ], 'actionGroupName' => [ 'shape' => 'Name', ], 'description' => [ 'shape' => 'Description', ], 'parentActionGroupSignature' => [ 'shape' => 'ActionGroupSignature', ], 'parentActionGroupSignatureParams' => [ 'shape' => 'ActionGroupSignatureParams', ], 'actionGroupExecutor' => [ 'shape' => 'ActionGroupExecutor', ], 'actionGroupState' => [ 'shape' => 'ActionGroupState', ], 'apiSchema' => [ 'shape' => 'APISchema', ], 'functionSchema' => [ 'shape' => 'FunctionSchema', ], ], ], 'UpdateAgentActionGroupResponse' => [ 'type' => 'structure', 'required' => [ 'agentActionGroup', ], 'members' => [ 'agentActionGroup' => [ 'shape' => 'AgentActionGroup', ], ], ], 'UpdateAgentAliasRequest' => [ 'type' => 'structure', 'required' => [ 'agentId', 'agentAliasId', 'agentAliasName', ], 'members' => [ 'agentId' => [ 'shape' => 'Id', 'location' => 'uri', 'locationName' => 'agentId', ], 'agentAliasId' => [ 'shape' => 'AgentAliasId', 'location' => 'uri', 'locationName' => 'agentAliasId', ], 'agentAliasName' => [ 'shape' => 'Name', ], 'description' => [ 'shape' => 'Description', ], 'routingConfiguration' => [ 'shape' => 'AgentAliasRoutingConfiguration', ], 'aliasInvocationState' => [ 'shape' => 'AliasInvocationState', ], ], ], 'UpdateAgentAliasResponse' => [ 'type' => 'structure', 'required' => [ 'agentAlias', ], 'members' => [ 'agentAlias' => [ 'shape' => 'AgentAlias', ], ], ], 'UpdateAgentCollaboratorRequest' => [ 'type' => 'structure', 'required' => [ 'agentId', 'agentVersion', 'collaboratorId', 'agentDescriptor', 'collaboratorName', 'collaborationInstruction', ], 'members' => [ 'agentId' => [ 'shape' => 'Id', 'location' => 'uri', 'locationName' => 'agentId', ], 'agentVersion' => [ 'shape' => 'DraftVersion', 'location' => 'uri', 'locationName' => 'agentVersion', ], 'collaboratorId' => [ 'shape' => 'Id', 'location' => 'uri', 'locationName' => 'collaboratorId', ], 'agentDescriptor' => [ 'shape' => 'AgentDescriptor', ], 'collaboratorName' => [ 'shape' => 'Name', ], 'collaborationInstruction' => [ 'shape' => 'CollaborationInstruction', ], 'relayConversationHistory' => [ 'shape' => 'RelayConversationHistory', ], ], ], 'UpdateAgentCollaboratorResponse' => [ 'type' => 'structure', 'required' => [ 'agentCollaborator', ], 'members' => [ 'agentCollaborator' => [ 'shape' => 'AgentCollaborator', ], ], ], 'UpdateAgentKnowledgeBaseRequest' => [ 'type' => 'structure', 'required' => [ 'agentId', 'agentVersion', 'knowledgeBaseId', ], 'members' => [ 'agentId' => [ 'shape' => 'Id', 'location' => 'uri', 'locationName' => 'agentId', ], 'agentVersion' => [ 'shape' => 'DraftVersion', 'location' => 'uri', 'locationName' => 'agentVersion', ], 'knowledgeBaseId' => [ 'shape' => 'Id', 'location' => 'uri', 'locationName' => 'knowledgeBaseId', ], 'description' => [ 'shape' => 'Description', ], 'knowledgeBaseState' => [ 'shape' => 'KnowledgeBaseState', ], ], ], 'UpdateAgentKnowledgeBaseResponse' => [ 'type' => 'structure', 'required' => [ 'agentKnowledgeBase', ], 'members' => [ 'agentKnowledgeBase' => [ 'shape' => 'AgentKnowledgeBase', ], ], ], 'UpdateAgentRequest' => [ 'type' => 'structure', 'required' => [ 'agentId', 'agentName', 'foundationModel', 'agentResourceRoleArn', ], 'members' => [ 'agentId' => [ 'shape' => 'Id', 'location' => 'uri', 'locationName' => 'agentId', ], 'agentName' => [ 'shape' => 'Name', ], 'instruction' => [ 'shape' => 'Instruction', ], 'foundationModel' => [ 'shape' => 'ModelIdentifier', ], 'description' => [ 'shape' => 'Description', ], 'orchestrationType' => [ 'shape' => 'OrchestrationType', ], 'customOrchestration' => [ 'shape' => 'CustomOrchestration', ], 'idleSessionTTLInSeconds' => [ 'shape' => 'SessionTTL', ], 'agentResourceRoleArn' => [ 'shape' => 'AgentRoleArn', ], 'customerEncryptionKeyArn' => [ 'shape' => 'KmsKeyArn', ], 'promptOverrideConfiguration' => [ 'shape' => 'PromptOverrideConfiguration', ], 'guardrailConfiguration' => [ 'shape' => 'GuardrailConfiguration', ], 'memoryConfiguration' => [ 'shape' => 'MemoryConfiguration', ], 'agentCollaboration' => [ 'shape' => 'AgentCollaboration', ], ], ], 'UpdateAgentResponse' => [ 'type' => 'structure', 'required' => [ 'agent', ], 'members' => [ 'agent' => [ 'shape' => 'Agent', ], ], ], 'UpdateDataSourceRequest' => [ 'type' => 'structure', 'required' => [ 'knowledgeBaseId', 'dataSourceId', 'name', 'dataSourceConfiguration', ], 'members' => [ 'knowledgeBaseId' => [ 'shape' => 'Id', 'location' => 'uri', 'locationName' => 'knowledgeBaseId', ], 'dataSourceId' => [ 'shape' => 'Id', 'location' => 'uri', 'locationName' => 'dataSourceId', ], 'name' => [ 'shape' => 'Name', ], 'description' => [ 'shape' => 'Description', ], 'dataSourceConfiguration' => [ 'shape' => 'DataSourceConfiguration', ], 'dataDeletionPolicy' => [ 'shape' => 'DataDeletionPolicy', ], 'serverSideEncryptionConfiguration' => [ 'shape' => 'ServerSideEncryptionConfiguration', ], 'vectorIngestionConfiguration' => [ 'shape' => 'VectorIngestionConfiguration', ], ], ], 'UpdateDataSourceResponse' => [ 'type' => 'structure', 'required' => [ 'dataSource', ], 'members' => [ 'dataSource' => [ 'shape' => 'DataSource', ], ], ], 'UpdateFlowAliasRequest' => [ 'type' => 'structure', 'required' => [ 'name', 'routingConfiguration', 'flowIdentifier', 'aliasIdentifier', ], 'members' => [ 'name' => [ 'shape' => 'Name', ], 'description' => [ 'shape' => 'Description', ], 'routingConfiguration' => [ 'shape' => 'FlowAliasRoutingConfiguration', ], 'concurrencyConfiguration' => [ 'shape' => 'FlowAliasConcurrencyConfiguration', ], 'flowIdentifier' => [ 'shape' => 'FlowIdentifier', 'location' => 'uri', 'locationName' => 'flowIdentifier', ], 'aliasIdentifier' => [ 'shape' => 'FlowAliasIdentifier', 'location' => 'uri', 'locationName' => 'aliasIdentifier', ], ], ], 'UpdateFlowAliasResponse' => [ 'type' => 'structure', 'required' => [ 'name', 'routingConfiguration', 'flowId', 'id', 'arn', 'createdAt', 'updatedAt', ], 'members' => [ 'name' => [ 'shape' => 'Name', ], 'description' => [ 'shape' => 'Description', ], 'routingConfiguration' => [ 'shape' => 'FlowAliasRoutingConfiguration', ], 'concurrencyConfiguration' => [ 'shape' => 'FlowAliasConcurrencyConfiguration', ], 'flowId' => [ 'shape' => 'FlowId', ], 'id' => [ 'shape' => 'FlowAliasId', ], 'arn' => [ 'shape' => 'FlowAliasArn', ], 'createdAt' => [ 'shape' => 'DateTimestamp', ], 'updatedAt' => [ 'shape' => 'DateTimestamp', ], ], ], 'UpdateFlowRequest' => [ 'type' => 'structure', 'required' => [ 'name', 'executionRoleArn', 'flowIdentifier', ], 'members' => [ 'name' => [ 'shape' => 'FlowName', ], 'description' => [ 'shape' => 'FlowDescription', ], 'executionRoleArn' => [ 'shape' => 'FlowExecutionRoleArn', ], 'customerEncryptionKeyArn' => [ 'shape' => 'KmsKeyArn', ], 'definition' => [ 'shape' => 'FlowDefinition', ], 'flowIdentifier' => [ 'shape' => 'FlowIdentifier', 'location' => 'uri', 'locationName' => 'flowIdentifier', ], ], ], 'UpdateFlowResponse' => [ 'type' => 'structure', 'required' => [ 'name', 'executionRoleArn', 'id', 'arn', 'status', 'createdAt', 'updatedAt', 'version', ], 'members' => [ 'name' => [ 'shape' => 'FlowName', ], 'description' => [ 'shape' => 'FlowDescription', ], 'executionRoleArn' => [ 'shape' => 'FlowExecutionRoleArn', ], 'customerEncryptionKeyArn' => [ 'shape' => 'KmsKeyArn', ], 'id' => [ 'shape' => 'FlowId', ], 'arn' => [ 'shape' => 'FlowArn', ], 'status' => [ 'shape' => 'FlowStatus', ], 'createdAt' => [ 'shape' => 'DateTimestamp', ], 'updatedAt' => [ 'shape' => 'DateTimestamp', ], 'version' => [ 'shape' => 'DraftVersion', ], 'definition' => [ 'shape' => 'FlowDefinition', ], ], ], 'UpdateKnowledgeBaseRequest' => [ 'type' => 'structure', 'required' => [ 'knowledgeBaseId', 'name', 'roleArn', 'knowledgeBaseConfiguration', ], 'members' => [ 'knowledgeBaseId' => [ 'shape' => 'Id', 'location' => 'uri', 'locationName' => 'knowledgeBaseId', ], 'name' => [ 'shape' => 'Name', ], 'description' => [ 'shape' => 'Description', ], 'roleArn' => [ 'shape' => 'KnowledgeBaseRoleArn', ], 'knowledgeBaseConfiguration' => [ 'shape' => 'KnowledgeBaseConfiguration', ], 'storageConfiguration' => [ 'shape' => 'StorageConfiguration', ], ], ], 'UpdateKnowledgeBaseResponse' => [ 'type' => 'structure', 'required' => [ 'knowledgeBase', ], 'members' => [ 'knowledgeBase' => [ 'shape' => 'KnowledgeBase', ], ], ], 'UpdatePromptRequest' => [ 'type' => 'structure', 'required' => [ 'name', 'promptIdentifier', ], 'members' => [ 'name' => [ 'shape' => 'PromptName', ], 'description' => [ 'shape' => 'PromptDescription', ], 'customerEncryptionKeyArn' => [ 'shape' => 'KmsKeyArn', ], 'defaultVariant' => [ 'shape' => 'PromptVariantName', ], 'variants' => [ 'shape' => 'PromptVariantList', ], 'promptIdentifier' => [ 'shape' => 'PromptIdentifier', 'location' => 'uri', 'locationName' => 'promptIdentifier', ], ], ], 'UpdatePromptResponse' => [ 'type' => 'structure', 'required' => [ 'name', 'id', 'arn', 'version', 'createdAt', 'updatedAt', ], 'members' => [ 'name' => [ 'shape' => 'PromptName', ], 'description' => [ 'shape' => 'PromptDescription', ], 'customerEncryptionKeyArn' => [ 'shape' => 'KmsKeyArn', ], 'defaultVariant' => [ 'shape' => 'PromptVariantName', ], 'variants' => [ 'shape' => 'PromptVariantList', ], 'id' => [ 'shape' => 'PromptId', ], 'arn' => [ 'shape' => 'PromptArn', ], 'version' => [ 'shape' => 'Version', ], 'createdAt' => [ 'shape' => 'DateTimestamp', ], 'updatedAt' => [ 'shape' => 'DateTimestamp', ], ], ], 'Url' => [ 'type' => 'string', 'pattern' => 'https?://[A-Za-z0-9][^\\s]*', ], 'UrlConfiguration' => [ 'type' => 'structure', 'members' => [ 'seedUrls' => [ 'shape' => 'SeedUrls', ], ], ], 'UserAgent' => [ 'type' => 'string', 'max' => 40, 'min' => 15, 'sensitive' => true, ], 'UserAgentHeader' => [ 'type' => 'string', 'max' => 86, 'min' => 61, 'sensitive' => true, ], 'ValidateFlowDefinitionRequest' => [ 'type' => 'structure', 'required' => [ 'definition', ], 'members' => [ 'definition' => [ 'shape' => 'FlowDefinition', ], ], ], 'ValidateFlowDefinitionResponse' => [ 'type' => 'structure', 'required' => [ 'validations', ], 'members' => [ 'validations' => [ 'shape' => 'FlowValidations', ], ], ], 'ValidationException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'NonBlankString', ], 'fieldList' => [ 'shape' => 'ValidationExceptionFieldList', ], ], 'error' => [ 'httpStatusCode' => 400, 'senderFault' => true, ], 'exception' => true, ], 'ValidationExceptionField' => [ 'type' => 'structure', 'required' => [ 'name', 'message', ], 'members' => [ 'name' => [ 'shape' => 'NonBlankString', ], 'message' => [ 'shape' => 'NonBlankString', ], ], ], 'ValidationExceptionFieldList' => [ 'type' => 'list', 'member' => [ 'shape' => 'ValidationExceptionField', ], ], 'VectorBucketArn' => [ 'type' => 'string', 'sensitive' => true, ], 'VectorIngestionConfiguration' => [ 'type' => 'structure', 'members' => [ 'chunkingConfiguration' => [ 'shape' => 'ChunkingConfiguration', ], 'customTransformationConfiguration' => [ 'shape' => 'CustomTransformationConfiguration', ], 'parsingConfiguration' => [ 'shape' => 'ParsingConfiguration', ], 'contextEnrichmentConfiguration' => [ 'shape' => 'ContextEnrichmentConfiguration', ], ], ], 'VectorKnowledgeBaseConfiguration' => [ 'type' => 'structure', 'required' => [ 'embeddingModelArn', ], 'members' => [ 'embeddingModelArn' => [ 'shape' => 'BedrockEmbeddingModelArn', ], 'embeddingModelConfiguration' => [ 'shape' => 'EmbeddingModelConfiguration', ], 'supplementalDataStorageConfiguration' => [ 'shape' => 'SupplementalDataStorageConfiguration', ], ], ], 'VectorSearchBedrockRerankingConfiguration' => [ 'type' => 'structure', 'required' => [ 'modelConfiguration', ], 'members' => [ 'modelConfiguration' => [ 'shape' => 'VectorSearchBedrockRerankingModelConfiguration', ], 'numberOfRerankedResults' => [ 'shape' => 'VectorSearchBedrockRerankingConfigurationNumberOfRerankedResultsInteger', ], 'metadataConfiguration' => [ 'shape' => 'MetadataConfigurationForReranking', ], ], ], 'VectorSearchBedrockRerankingConfigurationNumberOfRerankedResultsInteger' => [ 'type' => 'integer', 'box' => true, 'max' => 100, 'min' => 1, ], 'VectorSearchBedrockRerankingModelConfiguration' => [ 'type' => 'structure', 'required' => [ 'modelArn', ], 'members' => [ 'modelArn' => [ 'shape' => 'BedrockRerankingModelArn', ], 'additionalModelRequestFields' => [ 'shape' => 'AdditionalModelRequestFields', ], ], ], 'VectorSearchRerankingConfiguration' => [ 'type' => 'structure', 'required' => [ 'type', ], 'members' => [ 'type' => [ 'shape' => 'VectorSearchRerankingConfigurationType', ], 'bedrockRerankingConfiguration' => [ 'shape' => 'VectorSearchBedrockRerankingConfiguration', ], ], ], 'VectorSearchRerankingConfigurationType' => [ 'type' => 'string', 'enum' => [ 'BEDROCK_RERANKING_MODEL', ], ], 'Version' => [ 'type' => 'string', 'max' => 5, 'min' => 1, 'pattern' => '(DRAFT|[0-9]{0,4}[1-9][0-9]{0,4})', ], 'WebCrawlerConfiguration' => [ 'type' => 'structure', 'members' => [ 'crawlerLimits' => [ 'shape' => 'WebCrawlerLimits', ], 'inclusionFilters' => [ 'shape' => 'FilterList', ], 'exclusionFilters' => [ 'shape' => 'FilterList', ], 'scope' => [ 'shape' => 'WebScopeType', ], 'userAgent' => [ 'shape' => 'UserAgent', ], 'userAgentHeader' => [ 'shape' => 'UserAgentHeader', ], ], ], 'WebCrawlerLimits' => [ 'type' => 'structure', 'members' => [ 'rateLimit' => [ 'shape' => 'WebCrawlerLimitsRateLimitInteger', ], 'maxPages' => [ 'shape' => 'WebCrawlerLimitsMaxPagesInteger', ], ], ], 'WebCrawlerLimitsMaxPagesInteger' => [ 'type' => 'integer', 'box' => true, 'min' => 1, ], 'WebCrawlerLimitsRateLimitInteger' => [ 'type' => 'integer', 'box' => true, 'max' => 300, 'min' => 1, ], 'WebDataSourceConfiguration' => [ 'type' => 'structure', 'required' => [ 'sourceConfiguration', ], 'members' => [ 'sourceConfiguration' => [ 'shape' => 'WebSourceConfiguration', ], 'crawlerConfiguration' => [ 'shape' => 'WebCrawlerConfiguration', ], ], ], 'WebScopeType' => [ 'type' => 'string', 'enum' => [ 'HOST_ONLY', 'SUBDOMAINS', ], ], 'WebSourceConfiguration' => [ 'type' => 'structure', 'required' => [ 'urlConfiguration', ], 'members' => [ 'urlConfiguration' => [ 'shape' => 'UrlConfiguration', ], ], ], 'WorkgroupArn' => [ 'type' => 'string', 'pattern' => '(arn:(aws(-[a-z]+)*):redshift-serverless:[a-z]{2}(-gov)?-[a-z]+-\\d{1}:\\d{12}:workgroup/[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12})', ], ],];
