<?php

declare(strict_types=1);

namespace Doctrine\Migrations\Tools\Console\Command;

use Symfony\Component\Console\Attribute\AsCommand;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

#[AsCommand(name: 'migrations:sync-metadata-storage', description: 'Ensures that the metadata storage is at the latest version.')]
final class SyncMetadataCommand extends DoctrineCommand
{
    /** @var string|null */
    protected static $defaultName = 'migrations:sync-metadata-storage';

    protected function configure(): void
    {
        parent::configure();

        $this
            ->setAliases(['sync-metadata-storage'])
            ->setDescription('Ensures that the metadata storage is at the latest version.')
            ->setHelp(<<<'EOT'
The way metadata is stored in the database can change between releases.
The <info>%command.name%</info> command updates metadata storage to the latest version,
ensuring it is ready to receive migrations generated by the current version of Doctrine Migrations.


    <info>%command.full_name%</info>
EOT);
    }

    public function execute(
        InputInterface $input,
        OutputInterface $output
    ): int {
        $this->getDependencyFactory()->getMetadataStorage()->ensureInitialized();

        $this->io->success('Metadata storage synchronized');

        return 0;
    }
}
