# Changelog

All notable changes to this project will be documented in this file, in reverse chronological order by release.

## 2.9.2 - 2017-07-20

### Added

- Nothing.

### Deprecated

- Nothing.

### Removed

- Nothing.

### Fixed

- [zendframework/zend-validator#180](https://github.com/zendframework/zend-validator/pull/180) fixes how
  `Laminas\Validator\File\MimeType` "closes" the open FileInfo handle for the file
  being validated, using `unset()` instead of `finfo_close()`; this resolves a
  segfault that occurs on older PHP versions.
- [zendframework/zend-validator#174](https://github.com/zendframework/zend-validator/pull/174) fixes how
  `Laminas\Validator\Between` handles two situations: (1) when a non-numeric value
  is validated against numeric min/max values, and (2) when a numeric value is
  validated against non-numeric min/max values. Previously, these incorrectly
  validated as true; now they are marked invalid.

## 2.9.1 - 2017-05-17

### Added

- Nothing.

### Changes

- [zendframework/zend-validator#154](https://github.com/zendframework/zend-validator/pull/154) updates the
  `CreditCard` validator to allow 19 digit Discover card values, and 13 and 19
  digit Visa card values, which are now allowed (see
  https://en.wikipedia.org/wiki/Payment_card_number).
- [zendframework/zend-validator#162](https://github.com/zendframework/zend-validator/pull/162) updates the
  `Hostname` validator to support `.hr` (Croatia) IDN domains.
- [zendframework/zend-validator#163](https://github.com/zendframework/zend-validator/pull/163) updates the
  `Iban` validator to support Belarus.

### Deprecated

- Nothing.

### Removed

- Nothing.

### Fixed

- [zendframework/zend-validator#168](https://github.com/zendframework/zend-validator/pull/168) fixes how the
  `ValidatorPluginManagerFactory` factory initializes the plugin manager instance,
  ensuring it is injecting the relevant configuration from the `config` service
  and thus seeding it with configured validator services. This means
  that the `validators` configuration will now be honored in non-laminas-mvc contexts.

## 2.9.0 - 2017-03-17

### Added

- [zendframework/zend-validator#78](https://github.com/zendframework/zend-validator/pull/78) added
  `%length%` as an optional message variable in StringLength validator

### Deprecated

- Nothing.

### Removed

- [zendframework/zend-validator#151](https://github.com/zendframework/zend-validator/pull/151) dropped
  php 5.5 support

### Fixed

- [zendframework/zend-validator#147](https://github.com/zendframework/zend-validator/issues/147)
  [zendframework/zend-validator#148](https://github.com/zendframework/zend-validator/pull/148) adds further
  `"suggest"` clauses in `composer.json`, since some dependencies are not always
  required, and may lead to runtime failures.
- [zendframework/zend-validator#66](https://github.com/zendframework/zend-validator/pull/66) fixed
  EmailAddress validator applying IDNA conversion to local part 
- [zendframework/zend-validator#88](https://github.com/zendframework/zend-validator/pull/88) fixed NotEmpty
  validator incorrectly applying types bitmaps
- [zendframework/zend-validator#150](https://github.com/zendframework/zend-validator/pull/150) fixed Hostname
  validator not allowing some characters in .dk IDN

## 2.8.2 - 2017-01-29

### Added

- [zendframework/zend-validator#110](https://github.com/zendframework/zend-validator/pull/110) adds new
  Mastercard 2-series BINs

### Deprecated

- Nothing.

### Removed

- Nothing.

### Fixed

- [zendframework/zend-validator#81](https://github.com/zendframework/zend-validator/pull/81) registers the
  Uuid validator into ValidatorPluginManager.

## 2.8.1 - 2016-06-23

### Added

- Nothing.

### Deprecated

- Nothing.

### Removed

- Nothing.

### Fixed

- [zendframework/zend-validator#92](https://github.com/zendframework/zend-validator/pull/92) adds message
  templates to the `ExcludeMimeType` validator, to allow differentiating
  validation error messages from the `MimeType` validator.

## 2.8.0 - 2016-05-16

### Added

- [zendframework/zend-validator#58](https://github.com/zendframework/zend-validator/pull/58) adds a new
  `Uuid` validator, capable of validating if Versions 1-5 UUIDs are well-formed.
- [zendframework/zend-validator#64](https://github.com/zendframework/zend-validator/pull/64) ports
  `Laminas\ModuleManager\Feature\ValidatorProviderInterface` to
  `Laminas\Validator\ValidatorProviderInterface`, and updates the `Module::init()`
  to typehint against the new interface instead of the one from
  laminas-modulemanager. Applications targeting laminas-mvc v3 can start updating
  their code to implement the new interface, or simply duck-type against it.

### Deprecated

- Nothing.

### Removed

- Nothing.

### Fixed

- Nothing.

## 2.7.3 - 2016-05-16

### Added

- [zendframework/zend-validator#67](https://github.com/zendframework/zend-validator/pull/67) adds support
  for Punycoded top-level domains in the `Hostname` validator.
- [zendframework/zend-validator#79](https://github.com/zendframework/zend-validator/pull/79) adds and
  publishes the documentation to https://docs.laminas.dev/laminas-validator/

### Deprecated

- Nothing.

### Removed

- Nothing.

### Fixed

- Nothing.

## 2.7.2 - 2016-04-18

### Added

- Nothing.

### Deprecated

- Nothing.

### Removed

- Nothing.

### Fixed

- [zendframework/zend-validator#65](https://github.com/zendframework/zend-validator/pull/65) fixes the
  `Module::init()` method to properly receive a `ModuleManager` instance, and
  not expect a `ModuleEvent`.

## 2.7.1 - 2016-04-06

### Added

- Nothing.

### Deprecated

- Nothing.

### Removed

- Nothing.

### Fixed

- This release updates the TLD list to the latest version from the IANA.

## 2.7.0 - 2016-04-06

### Added

- [zendframework/zend-validator#63](https://github.com/zendframework/zend-validator/pull/63) exposes the
  package as a Laminas component and/or generic configuration provider, by adding the
  following:
  - `ValidatorPluginManagerFactory`, which can be consumed by container-interop /
    laminas-servicemanager to create and return a `ValidatorPluginManager` instance.
  - `ConfigProvider`, which maps the service `ValidatorManager` to the above
    factory.
  - `Module`, which does the same as `ConfigProvider`, but specifically for
    laminas-mvc applications. It also provices a specification to
    `Laminas\ModuleManager\Listener\ServiceListener` to allow modules to provide
    validator configuration.

### Deprecated

- Nothing.

### Removed

- Nothing.

### Fixed

- Nothing.

## 2.6.0 - 2016-02-17

### Added

- [zendframework/zend-validator#18](https://github.com/zendframework/zend-validator/pull/18) adds a `GpsPoint`
  validator for validating GPS coordinates.
- [zendframework/zend-validator#47](https://github.com/zendframework/zend-validator/pull/47) adds two new
  classes, `Laminas\Validator\Isbn\Isbn10` and `Isbn13`; these classes are the
  result of an extract class refactoring, and contain the logic specific to
  calcualting the checksum for each ISBN style. `Laminas\Validator\Isbn` now
  instantiates the appropriate one and invokes it.
- [zendframework/zend-validator#46](https://github.com/zendframework/zend-validator/pull/46) updates
  `Laminas\Validator\Db\AbstractDb` to implement `Laminas\Db\Adapter\AdapterAwareInterface`,
  by composing `Laminas\Db\Adapter\AdapterAwareTrait`.

### Deprecated

- Nothing.

### Removed

- [zendframework/zend-validator#55](https://github.com/zendframework/zend-validator/pull/55) removes some
  checks for `safe_mode` within the `MimeType` validator, as `safe_mode` became
  obsolete starting with PHP 5.4.

### Fixed

- [zendframework/zend-validator#45](https://github.com/zendframework/zend-validator/pull/45) fixes aliases
  mapping the deprecated `Float` and `Int` validators to their `Is*` counterparts.
- [zendframework/zend-validator#49](https://github.com/zendframework/zend-validator/pull/49)
  [zendframework/zend-validator#50](https://github.com/zendframework/zend-validator/pull/50), and
  [zendframework/zend-validator#51](https://github.com/zendframework/zend-validator/pull/51) update the
  code to be forwards-compatible with laminas-servicemanager and laminas-stdlib v3.
- [zendframework/zend-validator#56](https://github.com/zendframework/zend-validator/pull/56) fixes the regex
  in the `Ip` validator to escape `.` characters used as IP delimiters.

## 2.5.4 - 2016-02-17

### Added

- Nothing.

### Deprecated

- Nothing.

### Removed

- Nothing.

### Fixed

- [zendframework/zend-validator#44](https://github.com/zendframework/zend-validator/pull/44) corrects the
  grammar on the `NOT_GREATER_INCLUSIVE` validation error message.
- [zendframework/zend-validator#45](https://github.com/zendframework/zend-validator/pull/45) adds normalized
  aliases for the i18n isfloat/isint validators.
- Updates the hostname validator regexes per the canonical service on which they
  are based.
- [zendframework/zend-validator#52](https://github.com/zendframework/zend-validator/pull/52) updates the
  `Barcode` validator to cast empty options passed to the constructor to an
  empty array, fixing type mismatch errors.
- [zendframework/zend-validator#54](https://github.com/zendframework/zend-validator/pull/54) fixes the IP
  address detection in the `Hostname` validator to ensure that IPv6 is detected
  correctly.
- [zendframework/zend-validator#56](https://github.com/zendframework/zend-validator/pull/56) updates the
  regexes used by the `IP` validator when comparing ipv4 addresses to ensure a
  literal `.` is tested between network segments.

## 2.5.3 - 2015-09-03

### Added

- [zendframework/zend-validator#30](https://github.com/zendframework/zend-validator/pull/30) adds tooling to
  ensure that the Hostname TLD list stays up-to-date as changes are pushed for
  the repository.

### Deprecated

- Nothing.

### Removed

- Nothing.

### Fixed

- [zendframework/zend-validator#17](https://github.com/zendframework/zend-validator/pull/17) and
  [zendframework/zend-validator#29](https://github.com/zendframework/zend-validator/pull/29) provide more
  test coverage, and fix a number of edge cases, primarily in validator option
  verifications.
- [zendframework/zend-validator#26](https://github.com/zendframework/zend-validator/pull/26) fixes tests for
  `StaticValidator` such that they make correct assertions now. In doing so, we
  determined that it was possible to pass an indexed array of options, which
  could lead to unexpected results, often leading to false positives when
  validating. To correct this situation, `StaticValidator::execute()` now raises
  an `InvalidArgumentException` when an indexed array is detected for the
  `$options` argument.
- [zendframework/zend-validator#35](https://github.com/zendframework/zend-validator/pull/35) modifies the
  `NotEmpty` validator to no longer treat the float `0.0` as an empty value for
  purposes of validation.
- [zendframework/zend-validator#25](https://github.com/zendframework/zend-validator/pull/25) fixes the
  `Date` validator to check against `DateTimeImmutable` and not
  `DateTimeInterface` (as PHP has restrictions currently on how the latter can
  be used).

## 2.5.2 - 2015-07-16

### Added

- [zendframework/zend-validator#8](https://github.com/zendframework/zend-validator/pull/8) adds a "strict"
  configuration option; when enabled (the default), the length of the address is
  checked to ensure it follows the specification.

### Deprecated

- Nothing.

### Removed

- Nothing.

### Fixed

- [zendframework/zend-validator#8](https://github.com/zendframework/zend-validator/pull/8) fixes bad
  behavior on the part of the `idn_to_utf8()` function, returning the original
  address in the case that the function fails.
- [zendframework/zend-validator#11](https://github.com/zendframework/zend-validator/pull/11) fixes
  `ValidatorChain::prependValidator()` so that it works on HHVM.
- [zendframework/zend-validator#12](https://github.com/zendframework/zend-validator/pull/12) adds "6772" to
  the Maestro range of the `CreditCard` validator.
