# Contributing

Contributions are **welcome** and will be fully **credited**.

We accept contributions via Pull Requests on [Github](https://github.com/thephpleague/tactician).

## Pull Requests

- **[PSR-2 Coding Standard](https://github.com/php-fig/fig-standards/blob/master/accepted/PSR-2-coding-style-guide.md)** - The easiest way to apply the conventions is to install [PHP Code Sniffer](http://pear.php.net/package/PHP_CodeSniffer).

- **Add tests!** - to ensure a high quality code base, your code patch can't be accepted if it doesn't have tests.

- **Document any change in behaviour** - Make sure the `CHANGELOG.md`, `README.md` and any other relevant documentation are kept up-to-date.

- **Consider our release cycle** - Since we're using semantic versioning ([SemVer v2.0.0](http://semver.org/)). Changes to the API must be done with great consideration, and prevented if at all possible.

- **Create feature branches** - Master is the stable branch, create a new branch for each feature.

- **One pull request per feature** - If you want to do more than one thing, send multiple pull requests.

- **Be respectful** - Be excellent to other contributors.

**Happy coding**!
