<?php namespace MathParser;

/*
* @package     Parsing
* @author      Frank Wikström <frank@mossadal.se>
* @copyright   2015 Frank Wikström
* @license     http://www.opensource.org/licenses/lgpl-license.php LGPL
*
*/



use MathParser\Parsing\Parser;
use MathParser\Lexing\ComplexLexer;

class ComplexMathParser
{
    /** StdMathLexer $lexer instance of StdMathLexer used for tokenizing */
    private $lexer;
    /** Parser $parser instance of Parsed used for the actual parsing */
    private $parser;
    /** Token[] $tokens list of tokens generated by the Lexer */
    private $tokens;
    /** Node $tree AST generated by the parser */
    private $tree;

    public function __construct()
    {
        $this->lexer = new ComplexLexer();
        $this->parser = new Parser();
        $this->parser->setRationalFactory(true);

    }

    public function setSimplifying($flag)
    {
        $this->parser->setSimplifying($flag);
    }

    /**
     * Parse the given mathematical expression into an abstract syntax tree.
     *
     * @param string $text Input
     * @retval Node
     */
    public function parse($text)
    {
        $this->tokens = $this->lexer->tokenize($text);
        $this->tree = $this->parser->parse($this->tokens);

        return $this->tree;
    }

    /**
     * Return the token list for the last parsed expression.
     * @retval Token[]
     */
    public function getTokenList()
    {
        return $this->tokens;
    }

    /**
     * Return the AST of the last parsed expression.
     * @retval Node
     */
    public function getTree()
    {
        return $this->tree;
    }
}
