<?php
/**
 * BucketsApi
 * PHP version 5
 *
 * @category Class
 * @package  Autodesk\Forge\Client
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * Forge SDK
 *
 * The Forge Platform contains an expanding collection of web service components that can be used with Autodesk cloud-based products or your own technologies. Take advantage of Autodesk’s expertise in design and engineering.
 *
 * OpenAPI spec version: 0.1.0
 * Contact: forge.help@autodesk.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace Autodesk\Forge\Client\Api;

use \Autodesk\Forge\Client\ApiException;

/**
 * BucketsApi Class Doc Comment
 *
 * @category Class
 * @package  Autodesk\Forge\Client
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class BucketsApi extends AbstractApi
{
    /**
     * Operation createBucket
     *
     * 
     *
     * @param \Autodesk\Forge\Client\Model\PostBucketsPayload $post_buckets Body Structure (required)
     * @param string $x_ads_region The region where the bucket resides Acceptable values: &#x60;US&#x60;, &#x60;EMEA&#x60; Default is &#x60;US&#x60; (optional, default to US)
     * @throws \Autodesk\Forge\Client\ApiException on non-2xx response
     * @return \Autodesk\Forge\Client\Model\Bucket
     */
    public function createBucket($post_buckets, $x_ads_region = null)
    {
        list($response) = $this->createBucketWithHttpInfo($post_buckets, $x_ads_region);
        return $response;
    }

    /**
     * Operation createBucketWithHttpInfo
     *
     * 
     *
     * @param \Autodesk\Forge\Client\Model\PostBucketsPayload $post_buckets Body Structure (required)
     * @param string $x_ads_region The region where the bucket resides Acceptable values: &#x60;US&#x60;, &#x60;EMEA&#x60; Default is &#x60;US&#x60; (optional, default to US)
     * @throws \Autodesk\Forge\Client\ApiException on non-2xx response
     * @return array of \Autodesk\Forge\Client\Model\Bucket, HTTP status code, HTTP response headers (array of strings)
     */
    public function createBucketWithHttpInfo($post_buckets, $x_ads_region = null)
    {
        // verify the required parameter 'post_buckets' is set
        if ($post_buckets === null) {
            throw new \InvalidArgumentException('Missing the required parameter $post_buckets when calling createBucket');
        }
        // parse inputs
        $resourcePath = "/oss/v2/buckets";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/vnd.api+json', 'application/json']);
        if ( ! is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // header params
        if ($x_ads_region !== null) {
            $headerParams['x-ads-region'] = $this->apiClient->getSerializer()->toHeaderValue($x_ads_region);
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($post_buckets)) {
            $_tempBody = $post_buckets;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\Autodesk\Forge\Client\Model\Bucket',
                '/oss/v2/buckets'
            );

            return [
                $this->apiClient->getSerializer()->deserialize($response, '\Autodesk\Forge\Client\Model\Bucket', $httpHeader),
                $statusCode,
                $httpHeader,
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Autodesk\Forge\Client\Model\Bucket', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 409:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Autodesk\Forge\Client\Model\Reason', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteBucket
     *
     * 
     *
     * @param string $bucket_key URL-encoded bucket key (required)
     * @throws \Autodesk\Forge\Client\ApiException on non-2xx response
     * @return void
     */
    public function deleteBucket($bucket_key)
    {
        list($response) = $this->deleteBucketWithHttpInfo($bucket_key);
        return $response;
    }

    /**
     * Operation deleteBucketWithHttpInfo
     *
     * 
     *
     * @param string $bucket_key URL-encoded bucket key (required)
     * @throws \Autodesk\Forge\Client\ApiException on non-2xx response
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteBucketWithHttpInfo($bucket_key)
    {
        // verify the required parameter 'bucket_key' is set
        if ($bucket_key === null) {
            throw new \InvalidArgumentException('Missing the required parameter $bucket_key when calling deleteBucket');
        }
        if (!preg_match("/^[-_.a-z0-9]{3,128}$/", $bucket_key)) {
            throw new \InvalidArgumentException("invalid value for \"bucket_key\" when calling BucketsApi.deleteBucket, must conform to the pattern /^[-_.a-z0-9]{3,128}$/.");
        }

        // parse inputs
        $resourcePath = "/oss/v2/buckets/{bucketKey}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/vnd.api+json', 'application/json']);
        if ( ! is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // path params
        if ($bucket_key !== null) {
            $resourcePath = str_replace(
                "{" . "bucketKey" . "}",
                $this->apiClient->getSerializer()->toPathValue($bucket_key),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/oss/v2/buckets/{bucketKey}'
            );

            return [null, $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }

            throw $e;
        }
    }

    /**
     * Operation getBucketDetails
     *
     * 
     *
     * @param string $bucket_key URL-encoded bucket key (required)
     * @throws \Autodesk\Forge\Client\ApiException on non-2xx response
     * @return \Autodesk\Forge\Client\Model\Bucket
     */
    public function getBucketDetails($bucket_key)
    {
        list($response) = $this->getBucketDetailsWithHttpInfo($bucket_key);
        return $response;
    }

    /**
     * Operation getBucketDetailsWithHttpInfo
     *
     * 
     *
     * @param string $bucket_key URL-encoded bucket key (required)
     * @throws \Autodesk\Forge\Client\ApiException on non-2xx response
     * @return array of \Autodesk\Forge\Client\Model\Bucket, HTTP status code, HTTP response headers (array of strings)
     */
    public function getBucketDetailsWithHttpInfo($bucket_key)
    {
        // verify the required parameter 'bucket_key' is set
        if ($bucket_key === null) {
            throw new \InvalidArgumentException('Missing the required parameter $bucket_key when calling getBucketDetails');
        }
        if (!preg_match("/^[-_.a-z0-9]{3,128}$/", $bucket_key)) {
            throw new \InvalidArgumentException("invalid value for \"bucket_key\" when calling BucketsApi.getBucketDetails, must conform to the pattern /^[-_.a-z0-9]{3,128}$/.");
        }

        // parse inputs
        $resourcePath = "/oss/v2/buckets/{bucketKey}/details";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/vnd.api+json', 'application/json']);
        if ( ! is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // path params
        if ($bucket_key !== null) {
            $resourcePath = str_replace(
                "{" . "bucketKey" . "}",
                $this->apiClient->getSerializer()->toPathValue($bucket_key),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\Autodesk\Forge\Client\Model\Bucket',
                '/oss/v2/buckets/{bucketKey}/details'
            );

            return [
                $this->apiClient->getSerializer()->deserialize($response, '\Autodesk\Forge\Client\Model\Bucket', $httpHeader),
                $statusCode,
                $httpHeader,
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Autodesk\Forge\Client\Model\Bucket', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getBuckets
     *
     * 
     *
     * @param string $region The region where the bucket resides Acceptable values: &#x60;US&#x60;, &#x60;EMEA&#x60; Default is &#x60;US&#x60; (optional, default to US)
     * @param int $limit Limit to the response size, Acceptable values: 1-100 Default &#x3D; 10 (optional, default to 10)
     * @param string $start_at Key to use as an offset to continue pagination This is typically the last bucket key found in a preceding GET buckets response (optional)
     * @throws \Autodesk\Forge\Client\ApiException on non-2xx response
     * @return \Autodesk\Forge\Client\Model\Buckets
     */
    public function getBuckets($region = null, $limit = null, $start_at = null)
    {
        list($response) = $this->getBucketsWithHttpInfo($region, $limit, $start_at);
        return $response;
    }

    /**
     * Operation getBucketsWithHttpInfo
     *
     * 
     *
     * @param string $region The region where the bucket resides Acceptable values: &#x60;US&#x60;, &#x60;EMEA&#x60; Default is &#x60;US&#x60; (optional, default to US)
     * @param int $limit Limit to the response size, Acceptable values: 1-100 Default &#x3D; 10 (optional, default to 10)
     * @param string $start_at Key to use as an offset to continue pagination This is typically the last bucket key found in a preceding GET buckets response (optional)
     * @throws \Autodesk\Forge\Client\ApiException on non-2xx response
     * @return array of \Autodesk\Forge\Client\Model\Buckets, HTTP status code, HTTP response headers (array of strings)
     */
    public function getBucketsWithHttpInfo($region = null, $limit = null, $start_at = null)
    {
        // parse inputs
        $resourcePath = "/oss/v2/buckets";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/vnd.api+json', 'application/json']);
        if ( ! is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        if ($region !== null) {
            $queryParams['region'] = $this->apiClient->getSerializer()->toQueryValue($region);
        }
        // query params
        if ($limit !== null) {
            $queryParams['limit'] = $this->apiClient->getSerializer()->toQueryValue($limit);
        }
        // query params
        if ($start_at !== null) {
            $queryParams['startAt'] = $this->apiClient->getSerializer()->toQueryValue($start_at);
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\Autodesk\Forge\Client\Model\Buckets',
                '/oss/v2/buckets'
            );

            return [
                $this->apiClient->getSerializer()->deserialize($response, '\Autodesk\Forge\Client\Model\Buckets', $httpHeader),
                $statusCode,
                $httpHeader,
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Autodesk\Forge\Client\Model\Buckets', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

}
