<?php
/**
 * ItemsApi
 * PHP version 5
 *
 * @category Class
 * @package  Autodesk\Forge\Client
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * Forge SDK
 *
 * The Forge Platform contains an expanding collection of web service components that can be used with Autodesk cloud-based products or your own technologies. Take advantage of Autodesk’s expertise in design and engineering.
 *
 * OpenAPI spec version: 0.1.0
 * Contact: forge.help@autodesk.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace Autodesk\Forge\Client\Api;

use \Autodesk\Forge\Client\ApiException;

/**
 * ItemsApi Class Doc Comment
 *
 * @category Class
 * @package  Autodesk\Forge\Client
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class ItemsApi extends AbstractApi
{
    /**
     * Operation getItem
     *
     * 
     *
     * @param string $project_id the &#x60;project id&#x60; (required)
     * @param string $item_id the &#x60;item id&#x60; (required)
     * @throws \Autodesk\Forge\Client\ApiException on non-2xx response
     * @return \Autodesk\Forge\Client\Model\Item
     */
    public function getItem($project_id, $item_id)
    {
        list($response) = $this->getItemWithHttpInfo($project_id, $item_id);
        return $response;
    }

    /**
     * Operation getItemWithHttpInfo
     *
     * 
     *
     * @param string $project_id the &#x60;project id&#x60; (required)
     * @param string $item_id the &#x60;item id&#x60; (required)
     * @throws \Autodesk\Forge\Client\ApiException on non-2xx response
     * @return array of \Autodesk\Forge\Client\Model\Item, HTTP status code, HTTP response headers (array of strings)
     */
    public function getItemWithHttpInfo($project_id, $item_id)
    {
        // verify the required parameter 'project_id' is set
        if ($project_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $project_id when calling getItem');
        }
        // verify the required parameter 'item_id' is set
        if ($item_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $item_id when calling getItem');
        }
        // parse inputs
        $resourcePath = "/data/v1/projects/{project_id}/items/{item_id}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/vnd.api+json', 'application/json']);
        if ( ! is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/vnd.api+json']);

        // path params
        if ($project_id !== null) {
            $resourcePath = str_replace(
                "{" . "project_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($project_id),
                $resourcePath
            );
        }
        // path params
        if ($item_id !== null) {
            $resourcePath = str_replace(
                "{" . "item_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($item_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\Autodesk\Forge\Client\Model\Item',
                '/data/v1/projects/{project_id}/items/{item_id}'
            );

            return [
                $this->apiClient->getSerializer()->deserialize($response, '\Autodesk\Forge\Client\Model\Item', $httpHeader),
                $statusCode,
                $httpHeader,
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Autodesk\Forge\Client\Model\Item', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Autodesk\Forge\Client\Model\BadInput', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Autodesk\Forge\Client\Model\Forbidden', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Autodesk\Forge\Client\Model\NotFound', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getItemParentFolder
     *
     * 
     *
     * @param string $project_id the &#x60;project id&#x60; (required)
     * @param string $item_id the &#x60;item id&#x60; (required)
     * @throws \Autodesk\Forge\Client\ApiException on non-2xx response
     * @return \Autodesk\Forge\Client\Model\Folder
     */
    public function getItemParentFolder($project_id, $item_id)
    {
        list($response) = $this->getItemParentFolderWithHttpInfo($project_id, $item_id);
        return $response;
    }

    /**
     * Operation getItemParentFolderWithHttpInfo
     *
     * 
     *
     * @param string $project_id the &#x60;project id&#x60; (required)
     * @param string $item_id the &#x60;item id&#x60; (required)
     * @throws \Autodesk\Forge\Client\ApiException on non-2xx response
     * @return array of \Autodesk\Forge\Client\Model\Folder, HTTP status code, HTTP response headers (array of strings)
     */
    public function getItemParentFolderWithHttpInfo($project_id, $item_id)
    {
        // verify the required parameter 'project_id' is set
        if ($project_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $project_id when calling getItemParentFolder');
        }
        // verify the required parameter 'item_id' is set
        if ($item_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $item_id when calling getItemParentFolder');
        }
        // parse inputs
        $resourcePath = "/data/v1/projects/{project_id}/items/{item_id}/parent";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/vnd.api+json', 'application/json']);
        if ( ! is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/vnd.api+json']);

        // path params
        if ($project_id !== null) {
            $resourcePath = str_replace(
                "{" . "project_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($project_id),
                $resourcePath
            );
        }
        // path params
        if ($item_id !== null) {
            $resourcePath = str_replace(
                "{" . "item_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($item_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\Autodesk\Forge\Client\Model\Folder',
                '/data/v1/projects/{project_id}/items/{item_id}/parent'
            );

            return [
                $this->apiClient->getSerializer()->deserialize($response, '\Autodesk\Forge\Client\Model\Folder', $httpHeader),
                $statusCode,
                $httpHeader,
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Autodesk\Forge\Client\Model\Folder', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Autodesk\Forge\Client\Model\BadInput', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Autodesk\Forge\Client\Model\Forbidden', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Autodesk\Forge\Client\Model\NotFound', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getItemRefs
     *
     * 
     *
     * @param string $project_id the &#x60;project id&#x60; (required)
     * @param string $item_id the &#x60;item id&#x60; (required)
     * @param string[] $filter_type filter by the &#x60;type&#x60; of the &#x60;ref&#x60; target (optional)
     * @param string[] $filter_id filter by the &#x60;id&#x60; of the &#x60;ref&#x60; target (optional)
     * @param string[] $filter_extension_type filter by the extension type (optional)
     * @throws \Autodesk\Forge\Client\ApiException on non-2xx response
     * @return \Autodesk\Forge\Client\Model\JsonApiCollection
     */
    public function getItemRefs($project_id, $item_id, $filter_type = null, $filter_id = null, $filter_extension_type = null)
    {
        list($response) = $this->getItemRefsWithHttpInfo($project_id, $item_id, $filter_type, $filter_id, $filter_extension_type);
        return $response;
    }

    /**
     * Operation getItemRefsWithHttpInfo
     *
     * 
     *
     * @param string $project_id the &#x60;project id&#x60; (required)
     * @param string $item_id the &#x60;item id&#x60; (required)
     * @param string[] $filter_type filter by the &#x60;type&#x60; of the &#x60;ref&#x60; target (optional)
     * @param string[] $filter_id filter by the &#x60;id&#x60; of the &#x60;ref&#x60; target (optional)
     * @param string[] $filter_extension_type filter by the extension type (optional)
     * @throws \Autodesk\Forge\Client\ApiException on non-2xx response
     * @return array of \Autodesk\Forge\Client\Model\JsonApiCollection, HTTP status code, HTTP response headers (array of strings)
     */
    public function getItemRefsWithHttpInfo($project_id, $item_id, $filter_type = null, $filter_id = null, $filter_extension_type = null)
    {
        // verify the required parameter 'project_id' is set
        if ($project_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $project_id when calling getItemRefs');
        }
        // verify the required parameter 'item_id' is set
        if ($item_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $item_id when calling getItemRefs');
        }
        // parse inputs
        $resourcePath = "/data/v1/projects/{project_id}/items/{item_id}/refs";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/vnd.api+json', 'application/json']);
        if ( ! is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/vnd.api+json']);

        // query params
        if (is_array($filter_type)) {
            $filter_type = $this->apiClient->getSerializer()->serializeCollection($filter_type, 'csv', true);
        }
        if ($filter_type !== null) {
            $queryParams['filter[type]'] = $this->apiClient->getSerializer()->toQueryValue($filter_type);
        }
        // query params
        if (is_array($filter_id)) {
            $filter_id = $this->apiClient->getSerializer()->serializeCollection($filter_id, 'csv', true);
        }
        if ($filter_id !== null) {
            $queryParams['filter[id]'] = $this->apiClient->getSerializer()->toQueryValue($filter_id);
        }
        // query params
        if (is_array($filter_extension_type)) {
            $filter_extension_type = $this->apiClient->getSerializer()->serializeCollection($filter_extension_type, 'csv', true);
        }
        if ($filter_extension_type !== null) {
            $queryParams['filter[extension.type]'] = $this->apiClient->getSerializer()->toQueryValue($filter_extension_type);
        }
        // path params
        if ($project_id !== null) {
            $resourcePath = str_replace(
                "{" . "project_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($project_id),
                $resourcePath
            );
        }
        // path params
        if ($item_id !== null) {
            $resourcePath = str_replace(
                "{" . "item_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($item_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\Autodesk\Forge\Client\Model\JsonApiCollection',
                '/data/v1/projects/{project_id}/items/{item_id}/refs'
            );

            return [
                $this->apiClient->getSerializer()->deserialize($response, '\Autodesk\Forge\Client\Model\JsonApiCollection', $httpHeader),
                $statusCode,
                $httpHeader,
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Autodesk\Forge\Client\Model\JsonApiCollection', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Autodesk\Forge\Client\Model\BadInput', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Autodesk\Forge\Client\Model\Forbidden', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Autodesk\Forge\Client\Model\NotFound', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getItemRelationshipsRefs
     *
     * 
     *
     * @param string $project_id the &#x60;project id&#x60; (required)
     * @param string $item_id the &#x60;item id&#x60; (required)
     * @param string[] $filter_type filter by the &#x60;type&#x60; of the &#x60;ref&#x60; target (optional)
     * @param string[] $filter_id filter by the &#x60;id&#x60; of the &#x60;ref&#x60; target (optional)
     * @param string[] $filter_ref_type filter by &#x60;refType&#x60; (optional)
     * @param string $filter_direction filter by the direction of the reference (optional)
     * @param string[] $filter_extension_type filter by the extension type (optional)
     * @throws \Autodesk\Forge\Client\ApiException on non-2xx response
     * @return \Autodesk\Forge\Client\Model\Refs
     */
    public function getItemRelationshipsRefs($project_id, $item_id, $filter_type = null, $filter_id = null, $filter_ref_type = null, $filter_direction = null, $filter_extension_type = null)
    {
        list($response) = $this->getItemRelationshipsRefsWithHttpInfo($project_id, $item_id, $filter_type, $filter_id, $filter_ref_type, $filter_direction, $filter_extension_type);
        return $response;
    }

    /**
     * Operation getItemRelationshipsRefsWithHttpInfo
     *
     * 
     *
     * @param string $project_id the &#x60;project id&#x60; (required)
     * @param string $item_id the &#x60;item id&#x60; (required)
     * @param string[] $filter_type filter by the &#x60;type&#x60; of the &#x60;ref&#x60; target (optional)
     * @param string[] $filter_id filter by the &#x60;id&#x60; of the &#x60;ref&#x60; target (optional)
     * @param string[] $filter_ref_type filter by &#x60;refType&#x60; (optional)
     * @param string $filter_direction filter by the direction of the reference (optional)
     * @param string[] $filter_extension_type filter by the extension type (optional)
     * @throws \Autodesk\Forge\Client\ApiException on non-2xx response
     * @return array of \Autodesk\Forge\Client\Model\Refs, HTTP status code, HTTP response headers (array of strings)
     */
    public function getItemRelationshipsRefsWithHttpInfo($project_id, $item_id, $filter_type = null, $filter_id = null, $filter_ref_type = null, $filter_direction = null, $filter_extension_type = null)
    {
        // verify the required parameter 'project_id' is set
        if ($project_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $project_id when calling getItemRelationshipsRefs');
        }
        // verify the required parameter 'item_id' is set
        if ($item_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $item_id when calling getItemRelationshipsRefs');
        }
        // parse inputs
        $resourcePath = "/data/v1/projects/{project_id}/items/{item_id}/relationships/refs";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/vnd.api+json', 'application/json']);
        if ( ! is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/vnd.api+json']);

        // query params
        if (is_array($filter_type)) {
            $filter_type = $this->apiClient->getSerializer()->serializeCollection($filter_type, 'csv', true);
        }
        if ($filter_type !== null) {
            $queryParams['filter[type]'] = $this->apiClient->getSerializer()->toQueryValue($filter_type);
        }
        // query params
        if (is_array($filter_id)) {
            $filter_id = $this->apiClient->getSerializer()->serializeCollection($filter_id, 'csv', true);
        }
        if ($filter_id !== null) {
            $queryParams['filter[id]'] = $this->apiClient->getSerializer()->toQueryValue($filter_id);
        }
        // query params
        if (is_array($filter_ref_type)) {
            $filter_ref_type = $this->apiClient->getSerializer()->serializeCollection($filter_ref_type, 'csv', true);
        }
        if ($filter_ref_type !== null) {
            $queryParams['filter[refType]'] = $this->apiClient->getSerializer()->toQueryValue($filter_ref_type);
        }
        // query params
        if ($filter_direction !== null) {
            $queryParams['filter[direction]'] = $this->apiClient->getSerializer()->toQueryValue($filter_direction);
        }
        // query params
        if (is_array($filter_extension_type)) {
            $filter_extension_type = $this->apiClient->getSerializer()->serializeCollection($filter_extension_type, 'csv', true);
        }
        if ($filter_extension_type !== null) {
            $queryParams['filter[extension.type]'] = $this->apiClient->getSerializer()->toQueryValue($filter_extension_type);
        }
        // path params
        if ($project_id !== null) {
            $resourcePath = str_replace(
                "{" . "project_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($project_id),
                $resourcePath
            );
        }
        // path params
        if ($item_id !== null) {
            $resourcePath = str_replace(
                "{" . "item_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($item_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\Autodesk\Forge\Client\Model\Refs',
                '/data/v1/projects/{project_id}/items/{item_id}/relationships/refs'
            );

            return [
                $this->apiClient->getSerializer()->deserialize($response, '\Autodesk\Forge\Client\Model\Refs', $httpHeader),
                $statusCode,
                $httpHeader,
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Autodesk\Forge\Client\Model\Refs', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Autodesk\Forge\Client\Model\BadInput', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Autodesk\Forge\Client\Model\Forbidden', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Autodesk\Forge\Client\Model\NotFound', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getItemTip
     *
     * 
     *
     * @param string $project_id the &#x60;project id&#x60; (required)
     * @param string $item_id the &#x60;item id&#x60; (required)
     * @throws \Autodesk\Forge\Client\ApiException on non-2xx response
     * @return \Autodesk\Forge\Client\Model\Version
     */
    public function getItemTip($project_id, $item_id)
    {
        list($response) = $this->getItemTipWithHttpInfo($project_id, $item_id);
        return $response;
    }

    /**
     * Operation getItemTipWithHttpInfo
     *
     * 
     *
     * @param string $project_id the &#x60;project id&#x60; (required)
     * @param string $item_id the &#x60;item id&#x60; (required)
     * @throws \Autodesk\Forge\Client\ApiException on non-2xx response
     * @return array of \Autodesk\Forge\Client\Model\Version, HTTP status code, HTTP response headers (array of strings)
     */
    public function getItemTipWithHttpInfo($project_id, $item_id)
    {
        // verify the required parameter 'project_id' is set
        if ($project_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $project_id when calling getItemTip');
        }
        // verify the required parameter 'item_id' is set
        if ($item_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $item_id when calling getItemTip');
        }
        // parse inputs
        $resourcePath = "/data/v1/projects/{project_id}/items/{item_id}/tip";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/vnd.api+json', 'application/json']);
        if ( ! is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/vnd.api+json']);

        // path params
        if ($project_id !== null) {
            $resourcePath = str_replace(
                "{" . "project_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($project_id),
                $resourcePath
            );
        }
        // path params
        if ($item_id !== null) {
            $resourcePath = str_replace(
                "{" . "item_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($item_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\Autodesk\Forge\Client\Model\Version',
                '/data/v1/projects/{project_id}/items/{item_id}/tip'
            );

            return [
                $this->apiClient->getSerializer()->deserialize($response, '\Autodesk\Forge\Client\Model\Version', $httpHeader),
                $statusCode,
                $httpHeader,
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Autodesk\Forge\Client\Model\Version', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Autodesk\Forge\Client\Model\BadInput', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Autodesk\Forge\Client\Model\Forbidden', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Autodesk\Forge\Client\Model\NotFound', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getItemVersions
     *
     * 
     *
     * @param string $project_id the &#x60;project id&#x60; (required)
     * @param string $item_id the &#x60;item id&#x60; (required)
     * @param string[] $filter_type filter by the &#x60;type&#x60; of the &#x60;ref&#x60; target (optional)
     * @param string[] $filter_id filter by the &#x60;id&#x60; of the &#x60;ref&#x60; target (optional)
     * @param string[] $filter_extension_type filter by the extension type (optional)
     * @param int[] $filter_version_number filter by &#x60;versionNumber&#x60; (optional)
     * @param int $page_number specify the page number (optional)
     * @param int $page_limit specify the maximal number of elements per page (optional)
     * @throws \Autodesk\Forge\Client\ApiException on non-2xx response
     * @return \Autodesk\Forge\Client\Model\Versions
     */
    public function getItemVersions($project_id, $item_id, $filter_type = null, $filter_id = null, $filter_extension_type = null, $filter_version_number = null, $page_number = null, $page_limit = null)
    {
        list($response) = $this->getItemVersionsWithHttpInfo($project_id, $item_id, $filter_type, $filter_id, $filter_extension_type, $filter_version_number, $page_number, $page_limit);
        return $response;
    }

    /**
     * Operation getItemVersionsWithHttpInfo
     *
     * 
     *
     * @param string $project_id the &#x60;project id&#x60; (required)
     * @param string $item_id the &#x60;item id&#x60; (required)
     * @param string[] $filter_type filter by the &#x60;type&#x60; of the &#x60;ref&#x60; target (optional)
     * @param string[] $filter_id filter by the &#x60;id&#x60; of the &#x60;ref&#x60; target (optional)
     * @param string[] $filter_extension_type filter by the extension type (optional)
     * @param int[] $filter_version_number filter by &#x60;versionNumber&#x60; (optional)
     * @param int $page_number specify the page number (optional)
     * @param int $page_limit specify the maximal number of elements per page (optional)
     * @throws \Autodesk\Forge\Client\ApiException on non-2xx response
     * @return array of \Autodesk\Forge\Client\Model\Versions, HTTP status code, HTTP response headers (array of strings)
     */
    public function getItemVersionsWithHttpInfo($project_id, $item_id, $filter_type = null, $filter_id = null, $filter_extension_type = null, $filter_version_number = null, $page_number = null, $page_limit = null)
    {
        // verify the required parameter 'project_id' is set
        if ($project_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $project_id when calling getItemVersions');
        }
        // verify the required parameter 'item_id' is set
        if ($item_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $item_id when calling getItemVersions');
        }
        // parse inputs
        $resourcePath = "/data/v1/projects/{project_id}/items/{item_id}/versions";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/vnd.api+json', 'application/json']);
        if ( ! is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/vnd.api+json']);

        // query params
        if (is_array($filter_type)) {
            $filter_type = $this->apiClient->getSerializer()->serializeCollection($filter_type, 'csv', true);
        }
        if ($filter_type !== null) {
            $queryParams['filter[type]'] = $this->apiClient->getSerializer()->toQueryValue($filter_type);
        }
        // query params
        if (is_array($filter_id)) {
            $filter_id = $this->apiClient->getSerializer()->serializeCollection($filter_id, 'csv', true);
        }
        if ($filter_id !== null) {
            $queryParams['filter[id]'] = $this->apiClient->getSerializer()->toQueryValue($filter_id);
        }
        // query params
        if (is_array($filter_extension_type)) {
            $filter_extension_type = $this->apiClient->getSerializer()->serializeCollection($filter_extension_type, 'csv', true);
        }
        if ($filter_extension_type !== null) {
            $queryParams['filter[extension.type]'] = $this->apiClient->getSerializer()->toQueryValue($filter_extension_type);
        }
        // query params
        if (is_array($filter_version_number)) {
            $filter_version_number = $this->apiClient->getSerializer()->serializeCollection($filter_version_number, 'csv', true);
        }
        if ($filter_version_number !== null) {
            $queryParams['filter[versionNumber]'] = $this->apiClient->getSerializer()->toQueryValue($filter_version_number);
        }
        // query params
        if ($page_number !== null) {
            $queryParams['page[number]'] = $this->apiClient->getSerializer()->toQueryValue($page_number);
        }
        // query params
        if ($page_limit !== null) {
            $queryParams['page[limit]'] = $this->apiClient->getSerializer()->toQueryValue($page_limit);
        }
        // path params
        if ($project_id !== null) {
            $resourcePath = str_replace(
                "{" . "project_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($project_id),
                $resourcePath
            );
        }
        // path params
        if ($item_id !== null) {
            $resourcePath = str_replace(
                "{" . "item_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($item_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\Autodesk\Forge\Client\Model\Versions',
                '/data/v1/projects/{project_id}/items/{item_id}/versions'
            );

            return [
                $this->apiClient->getSerializer()->deserialize($response, '\Autodesk\Forge\Client\Model\Versions', $httpHeader),
                $statusCode,
                $httpHeader,
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Autodesk\Forge\Client\Model\Versions', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Autodesk\Forge\Client\Model\BadInput', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Autodesk\Forge\Client\Model\Forbidden', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Autodesk\Forge\Client\Model\NotFound', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postItem
     *
     * 
     *
     * @param string $project_id the &#x60;project id&#x60; (required)
     * @param \Autodesk\Forge\Client\Model\CreateItem $body describe the item to be created (required)
     * @throws \Autodesk\Forge\Client\ApiException on non-2xx response
     * @return \Autodesk\Forge\Client\Model\ItemCreated
     */
    public function postItem($project_id, $body)
    {
        list($response) = $this->postItemWithHttpInfo($project_id, $body);
        return $response;
    }

    /**
     * Operation postItemWithHttpInfo
     *
     * 
     *
     * @param string $project_id the &#x60;project id&#x60; (required)
     * @param \Autodesk\Forge\Client\Model\CreateItem $body describe the item to be created (required)
     * @throws \Autodesk\Forge\Client\ApiException on non-2xx response
     * @return array of \Autodesk\Forge\Client\Model\ItemCreated, HTTP status code, HTTP response headers (array of strings)
     */
    public function postItemWithHttpInfo($project_id, $body)
    {
        // verify the required parameter 'project_id' is set
        if ($project_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $project_id when calling postItem');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling postItem');
        }
        // parse inputs
        $resourcePath = "/data/v1/projects/{project_id}/items";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/vnd.api+json', 'application/json']);
        if ( ! is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/vnd.api+json']);

        // path params
        if ($project_id !== null) {
            $resourcePath = str_replace(
                "{" . "project_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($project_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\Autodesk\Forge\Client\Model\ItemCreated',
                '/data/v1/projects/{project_id}/items'
            );

            return [
                $this->apiClient->getSerializer()->deserialize($response, '\Autodesk\Forge\Client\Model\ItemCreated', $httpHeader),
                $statusCode,
                $httpHeader,
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Autodesk\Forge\Client\Model\ItemCreated', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Autodesk\Forge\Client\Model\BadInput', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Autodesk\Forge\Client\Model\Forbidden', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Autodesk\Forge\Client\Model\NotFound', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 409:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Autodesk\Forge\Client\Model\Conflict', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postItemRelationshipsRef
     *
     * 
     *
     * @param string $project_id the &#x60;project id&#x60; (required)
     * @param string $item_id the &#x60;item id&#x60; (required)
     * @param \Autodesk\Forge\Client\Model\CreateRef $body describe the ref to be created (required)
     * @throws \Autodesk\Forge\Client\ApiException on non-2xx response
     * @return void
     */
    public function postItemRelationshipsRef($project_id, $item_id, $body)
    {
        list($response) = $this->postItemRelationshipsRefWithHttpInfo($project_id, $item_id, $body);
        return $response;
    }

    /**
     * Operation postItemRelationshipsRefWithHttpInfo
     *
     * 
     *
     * @param string $project_id the &#x60;project id&#x60; (required)
     * @param string $item_id the &#x60;item id&#x60; (required)
     * @param \Autodesk\Forge\Client\Model\CreateRef $body describe the ref to be created (required)
     * @throws \Autodesk\Forge\Client\ApiException on non-2xx response
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function postItemRelationshipsRefWithHttpInfo($project_id, $item_id, $body)
    {
        // verify the required parameter 'project_id' is set
        if ($project_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $project_id when calling postItemRelationshipsRef');
        }
        // verify the required parameter 'item_id' is set
        if ($item_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $item_id when calling postItemRelationshipsRef');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling postItemRelationshipsRef');
        }
        // parse inputs
        $resourcePath = "/data/v1/projects/{project_id}/items/{item_id}/relationships/refs";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/vnd.api+json', 'application/json']);
        if ( ! is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/vnd.api+json']);

        // path params
        if ($project_id !== null) {
            $resourcePath = str_replace(
                "{" . "project_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($project_id),
                $resourcePath
            );
        }
        // path params
        if ($item_id !== null) {
            $resourcePath = str_replace(
                "{" . "item_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($item_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/data/v1/projects/{project_id}/items/{item_id}/relationships/refs'
            );

            return [null, $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Autodesk\Forge\Client\Model\BadInput', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Autodesk\Forge\Client\Model\Forbidden', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Autodesk\Forge\Client\Model\NotFound', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

}
