<?php
/**
 * ObjectsApi
 * PHP version 5
 *
 * @category Class
 * @package  Autodesk\Forge\Client
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * Forge SDK
 *
 * The Forge Platform contains an expanding collection of web service components that can be used with Autodesk cloud-based products or your own technologies. Take advantage of Autodesk’s expertise in design and engineering.
 *
 * OpenAPI spec version: 0.1.0
 * Contact: forge.help@autodesk.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace Autodesk\Forge\Client\Api;

use \Autodesk\Forge\Client\ApiException;

/**
 * ObjectsApi Class Doc Comment
 *
 * @category Class
 * @package  Autodesk\Forge\Client
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class ObjectsApi extends AbstractApi
{
    /**
     * Operation copyTo
     *
     *
     *
     * @param string $bucket_key URL-encoded bucket key (required)
     * @param string $object_name URL-encoded object name (required)
     * @param string $new_obj_name URL-encoded Object key to use as the destination (required)
     * @throws \Autodesk\Forge\Client\ApiException on non-2xx response
     * @return \Autodesk\Forge\Client\Model\ObjectDetails
     */
    public function copyTo($bucket_key, $object_name, $new_obj_name)
    {
        list($response) = $this->copyToWithHttpInfo($bucket_key, $object_name, $new_obj_name);
        return $response;
    }

    /**
     * Operation copyToWithHttpInfo
     *
     *
     *
     * @param string $bucket_key URL-encoded bucket key (required)
     * @param string $object_name URL-encoded object name (required)
     * @param string $new_obj_name URL-encoded Object key to use as the destination (required)
     * @throws \Autodesk\Forge\Client\ApiException on non-2xx response
     * @return array of \Autodesk\Forge\Client\Model\ObjectDetails, HTTP status code, HTTP response headers (array of strings)
     */
    public function copyToWithHttpInfo($bucket_key, $object_name, $new_obj_name)
    {
        // verify the required parameter 'bucket_key' is set
        if ($bucket_key === null) {
            throw new \InvalidArgumentException('Missing the required parameter $bucket_key when calling copyTo');
        }
        if (!preg_match("/^[-_.a-z0-9]{3,128}$/", $bucket_key)) {
            throw new \InvalidArgumentException("invalid value for \"bucket_key\" when calling ObjectsApi.copyTo, must conform to the pattern /^[-_.a-z0-9]{3,128}$/.");
        }

        // verify the required parameter 'object_name' is set
        if ($object_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $object_name when calling copyTo');
        }
        // verify the required parameter 'new_obj_name' is set
        if ($new_obj_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $new_obj_name when calling copyTo');
        }
        // parse inputs
        $resourcePath = "/oss/v2/buckets/{bucketKey}/objects/{objectName}/copyto/{newObjName}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/vnd.api+json', 'application/json']);
        if ( ! is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // path params
        if ($bucket_key !== null) {
            $resourcePath = str_replace(
                "{" . "bucketKey" . "}",
                $this->apiClient->getSerializer()->toPathValue($bucket_key),
                $resourcePath
            );
        }
        // path params
        if ($object_name !== null) {
            $resourcePath = str_replace(
                "{" . "objectName" . "}",
                $this->apiClient->getSerializer()->toPathValue($object_name),
                $resourcePath
            );
        }
        // path params
        if ($new_obj_name !== null) {
            $resourcePath = str_replace(
                "{" . "newObjName" . "}",
                $this->apiClient->getSerializer()->toPathValue($new_obj_name),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);


        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\Autodesk\Forge\Client\Model\ObjectDetails',
                '/oss/v2/buckets/{bucketKey}/objects/{objectName}/copyto/{newObjName}'
            );

            return [
                $this->apiClient->getSerializer()->deserialize($response, '\Autodesk\Forge\Client\Model\ObjectDetails', $httpHeader),
                $statusCode,
                $httpHeader,
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Autodesk\Forge\Client\Model\ObjectDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation createSignedResource
     *
     *
     *
     * @param string $bucket_key URL-encoded bucket key (required)
     * @param string $object_name URL-encoded object name (required)
     * @param \Autodesk\Forge\Client\Model\PostBucketsSigned $post_buckets_signed Body Structure (required)
     * @param string $access Access for signed resource Acceptable values: &#x60;read&#x60;, &#x60;write&#x60;, &#x60;readwrite&#x60;. Default value: &#x60;read&#x60; (optional, default to read)
     * @throws \Autodesk\Forge\Client\ApiException on non-2xx response
     * @return \Autodesk\Forge\Client\Model\PostObjectSigned
     */
    public function createSignedResource($bucket_key, $object_name, $post_buckets_signed, $access = null)
    {
        list($response) = $this->createSignedResourceWithHttpInfo($bucket_key, $object_name, $post_buckets_signed, $access);
        return $response;
    }

    /**
     * Operation createSignedResourceWithHttpInfo
     *
     *
     *
     * @param string $bucket_key URL-encoded bucket key (required)
     * @param string $object_name URL-encoded object name (required)
     * @param \Autodesk\Forge\Client\Model\PostBucketsSigned $post_buckets_signed Body Structure (required)
     * @param string $access Access for signed resource Acceptable values: &#x60;read&#x60;, &#x60;write&#x60;, &#x60;readwrite&#x60;. Default value: &#x60;read&#x60; (optional, default to read)
     * @throws \Autodesk\Forge\Client\ApiException on non-2xx response
     * @return array of \Autodesk\Forge\Client\Model\PostObjectSigned, HTTP status code, HTTP response headers (array of strings)
     */
    public function createSignedResourceWithHttpInfo($bucket_key, $object_name, $post_buckets_signed, $access = null)
    {
        // verify the required parameter 'bucket_key' is set
        if ($bucket_key === null) {
            throw new \InvalidArgumentException('Missing the required parameter $bucket_key when calling createSignedResource');
        }
        if (!preg_match("/^[-_.a-z0-9]{3,128}$/", $bucket_key)) {
            throw new \InvalidArgumentException("invalid value for \"bucket_key\" when calling ObjectsApi.createSignedResource, must conform to the pattern /^[-_.a-z0-9]{3,128}$/.");
        }

        // verify the required parameter 'object_name' is set
        if ($object_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $object_name when calling createSignedResource');
        }
        // verify the required parameter 'post_buckets_signed' is set
        if ($post_buckets_signed === null) {
            throw new \InvalidArgumentException('Missing the required parameter $post_buckets_signed when calling createSignedResource');
        }
        // parse inputs
        $resourcePath = "/oss/v2/buckets/{bucketKey}/objects/{objectName}/signed";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/vnd.api+json', 'application/json']);
        if ( ! is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        if ($access !== null) {
            $queryParams['access'] = $this->apiClient->getSerializer()->toQueryValue($access);
        }
        // path params
        if ($bucket_key !== null) {
            $resourcePath = str_replace(
                "{" . "bucketKey" . "}",
                $this->apiClient->getSerializer()->toPathValue($bucket_key),
                $resourcePath
            );
        }
        // path params
        if ($object_name !== null) {
            $resourcePath = str_replace(
                "{" . "objectName" . "}",
                $this->apiClient->getSerializer()->toPathValue($object_name),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($post_buckets_signed)) {
            $_tempBody = $post_buckets_signed;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\Autodesk\Forge\Client\Model\PostObjectSigned',
                '/oss/v2/buckets/{bucketKey}/objects/{objectName}/signed'
            );

            return [
                $this->apiClient->getSerializer()->deserialize($response, '\Autodesk\Forge\Client\Model\PostObjectSigned', $httpHeader),
                $statusCode,
                $httpHeader,
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Autodesk\Forge\Client\Model\PostObjectSigned', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteObject
     *
     *
     *
     * @param string $bucket_key URL-encoded bucket key (required)
     * @param string $object_name URL-encoded object name (required)
     * @throws \Autodesk\Forge\Client\ApiException on non-2xx response
     * @return void
     */
    public function deleteObject($bucket_key, $object_name)
    {
        list($response) = $this->deleteObjectWithHttpInfo($bucket_key, $object_name);
        return $response;
    }

    /**
     * Operation deleteObjectWithHttpInfo
     *
     *
     *
     * @param string $bucket_key URL-encoded bucket key (required)
     * @param string $object_name URL-encoded object name (required)
     * @throws \Autodesk\Forge\Client\ApiException on non-2xx response
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteObjectWithHttpInfo($bucket_key, $object_name)
    {
        // verify the required parameter 'bucket_key' is set
        if ($bucket_key === null) {
            throw new \InvalidArgumentException('Missing the required parameter $bucket_key when calling deleteObject');
        }
        if (!preg_match("/^[-_.a-z0-9]{3,128}$/", $bucket_key)) {
            throw new \InvalidArgumentException("invalid value for \"bucket_key\" when calling ObjectsApi.deleteObject, must conform to the pattern /^[-_.a-z0-9]{3,128}$/.");
        }

        // verify the required parameter 'object_name' is set
        if ($object_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $object_name when calling deleteObject');
        }
        // parse inputs
        $resourcePath = "/oss/v2/buckets/{bucketKey}/objects/{objectName}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept([]);
        if ( ! is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // path params
        if ($bucket_key !== null) {
            $resourcePath = str_replace(
                "{" . "bucketKey" . "}",
                $this->apiClient->getSerializer()->toPathValue($bucket_key),
                $resourcePath
            );
        }
        // path params
        if ($object_name !== null) {
            $resourcePath = str_replace(
                "{" . "objectName" . "}",
                $this->apiClient->getSerializer()->toPathValue($object_name),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);


        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/oss/v2/buckets/{bucketKey}/objects/{objectName}'
            );

            return [null, $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }

            throw $e;
        }
    }

    /**
     * Operation deleteSignedResource
     *
     *
     *
     * @param string $id Id of signed resource (required)
     * @param string $region The region where the bucket resides Acceptable values: &#x60;US&#x60;, &#x60;EMEA&#x60; Default is &#x60;US&#x60; (optional, default to US)
     * @throws \Autodesk\Forge\Client\ApiException on non-2xx response
     * @return void
     */
    public function deleteSignedResource($id, $region = null)
    {
        list($response) = $this->deleteSignedResourceWithHttpInfo($id, $region);
        return $response;
    }

    /**
     * Operation deleteSignedResourceWithHttpInfo
     *
     *
     *
     * @param string $id Id of signed resource (required)
     * @param string $region The region where the bucket resides Acceptable values: &#x60;US&#x60;, &#x60;EMEA&#x60; Default is &#x60;US&#x60; (optional, default to US)
     * @throws \Autodesk\Forge\Client\ApiException on non-2xx response
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteSignedResourceWithHttpInfo($id, $region = null)
    {
        // verify the required parameter 'id' is set
        if ($id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id when calling deleteSignedResource');
        }
        // parse inputs
        $resourcePath = "/oss/v2/signedresources/{id}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['text/plain']);
        if ( ! is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        if ($region !== null) {
            $queryParams['region'] = $this->apiClient->getSerializer()->toQueryValue($region);
        }
        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                "{" . "id" . "}",
                $this->apiClient->getSerializer()->toPathValue($id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);


        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/oss/v2/signedresources/{id}'
            );

            return [null, $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }

            throw $e;
        }
    }

    /**
     * Operation getObject
     *
     *
     *
     * @param string $bucket_key URL-encoded bucket key (required)
     * @param string $object_name URL-encoded object name (required)
     * @param string $range A range of bytes to download from the specified object. (optional)
     * @param string $if_none_match The value of this header is compared to the ETAG of the object. If they match, the body will not be included in the response. Only the object information will be included. (optional)
     * @param \DateTime $if_modified_since If the requested object has not been modified since the time specified in this field, an entity will not be returned from the server; instead, a 304 (not modified) response will be returned without any message body. (optional)
     * @param string $accept_encoding When gzip is specified, a gzip compressed stream of the object’s bytes will be returned in the response. Cannot use “Accept-Encoding:gzip” with Range header containing an end byte range. End byte range will not be honored if “Accept-Encoding: gzip” header is used. (optional)
     * @throws \Autodesk\Forge\Client\ApiException on non-2xx response
     * @return \SplFileObject
     */
    public function getObject($bucket_key, $object_name, $range = null, $if_none_match = null, $if_modified_since = null, $accept_encoding = null)
    {
        list($response) = $this->getObjectWithHttpInfo($bucket_key, $object_name, $range, $if_none_match, $if_modified_since, $accept_encoding);
        return $response;
    }

    /**
     * Operation getObjectWithHttpInfo
     *
     *
     *
     * @param string $bucket_key URL-encoded bucket key (required)
     * @param string $object_name URL-encoded object name (required)
     * @param string $range A range of bytes to download from the specified object. (optional)
     * @param string $if_none_match The value of this header is compared to the ETAG of the object. If they match, the body will not be included in the response. Only the object information will be included. (optional)
     * @param \DateTime $if_modified_since If the requested object has not been modified since the time specified in this field, an entity will not be returned from the server; instead, a 304 (not modified) response will be returned without any message body. (optional)
     * @param string $accept_encoding When gzip is specified, a gzip compressed stream of the object’s bytes will be returned in the response. Cannot use “Accept-Encoding:gzip” with Range header containing an end byte range. End byte range will not be honored if “Accept-Encoding: gzip” header is used. (optional)
     * @throws \Autodesk\Forge\Client\ApiException on non-2xx response
     * @return array of \SplFileObject, HTTP status code, HTTP response headers (array of strings)
     */
    public function getObjectWithHttpInfo($bucket_key, $object_name, $range = null, $if_none_match = null, $if_modified_since = null, $accept_encoding = null)
    {
        // verify the required parameter 'bucket_key' is set
        if ($bucket_key === null) {
            throw new \InvalidArgumentException('Missing the required parameter $bucket_key when calling getObject');
        }
        if (!preg_match("/^[-_.a-z0-9]{3,128}$/", $bucket_key)) {
            throw new \InvalidArgumentException("invalid value for \"bucket_key\" when calling ObjectsApi.getObject, must conform to the pattern /^[-_.a-z0-9]{3,128}$/.");
        }

        // verify the required parameter 'object_name' is set
        if ($object_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $object_name when calling getObject');
        }
        if ( ! is_null($range) && !preg_match("/^bytes=[0-9]+\\-[0-9]*$/", $range)) {
            throw new \InvalidArgumentException("invalid value for \"range\" when calling ObjectsApi.getObject, must conform to the pattern /^bytes=[0-9]+\\-[0-9]*$/.");
        }

        // parse inputs
        $resourcePath = "/oss/v2/buckets/{bucketKey}/objects/{objectName}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/octet-stream']);
        if ( ! is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // header params
        if ($range !== null) {
            $headerParams['Range'] = $this->apiClient->getSerializer()->toHeaderValue($range);
        }
        // header params
        if ($if_none_match !== null) {
            $headerParams['If-None-Match'] = $this->apiClient->getSerializer()->toHeaderValue($if_none_match);
        }
        // header params
        if ($if_modified_since !== null) {
            $headerParams['If-Modified-Since'] = $this->apiClient->getSerializer()->toHeaderValue($if_modified_since);
        }
        // header params
        if ($accept_encoding !== null) {
            $headerParams['Accept-Encoding'] = $this->apiClient->getSerializer()->toHeaderValue($accept_encoding);
        }
        // path params
        if ($bucket_key !== null) {
            $resourcePath = str_replace(
                "{" . "bucketKey" . "}",
                $this->apiClient->getSerializer()->toPathValue($bucket_key),
                $resourcePath
            );
        }
        // path params
        if ($object_name !== null) {
            $resourcePath = str_replace(
                "{" . "objectName" . "}",
                $this->apiClient->getSerializer()->toPathValue($object_name),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);


        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\SplFileObject',
                '/oss/v2/buckets/{bucketKey}/objects/{objectName}'
            );

            return [
                $this->apiClient->getSerializer()->deserialize($response, '\SplFileObject', $httpHeader),
                $statusCode,
                $httpHeader,
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\SplFileObject', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getObjectDetails
     *
     *
     *
     * @param string $bucket_key URL-encoded bucket key (required)
     * @param string $object_name URL-encoded object name (required)
     * @param \DateTime $if_modified_since If the requested object has not been modified since the time specified in this field, an entity will not be returned from the server; instead, a 304 (not modified) response will be returned without any message body. (optional)
     * @param string $with Extra information in details; multiple uses are supported Acceptable values: &#x60;createdDate&#x60;, &#x60;lastAccessedDate&#x60;, &#x60;lastModifiedDate&#x60; (optional)
     * @throws \Autodesk\Forge\Client\ApiException on non-2xx response
     * @return \Autodesk\Forge\Client\Model\ObjectFullDetails
     */
    public function getObjectDetails($bucket_key, $object_name, $if_modified_since = null, $with = null)
    {
        list($response) = $this->getObjectDetailsWithHttpInfo($bucket_key, $object_name, $if_modified_since, $with);
        return $response;
    }

    /**
     * Operation getObjectDetailsWithHttpInfo
     *
     *
     *
     * @param string $bucket_key URL-encoded bucket key (required)
     * @param string $object_name URL-encoded object name (required)
     * @param \DateTime $if_modified_since If the requested object has not been modified since the time specified in this field, an entity will not be returned from the server; instead, a 304 (not modified) response will be returned without any message body. (optional)
     * @param string $with Extra information in details; multiple uses are supported Acceptable values: &#x60;createdDate&#x60;, &#x60;lastAccessedDate&#x60;, &#x60;lastModifiedDate&#x60; (optional)
     * @throws \Autodesk\Forge\Client\ApiException on non-2xx response
     * @return array of \Autodesk\Forge\Client\Model\ObjectFullDetails, HTTP status code, HTTP response headers (array of strings)
     */
    public function getObjectDetailsWithHttpInfo($bucket_key, $object_name, $if_modified_since = null, $with = null)
    {
        // verify the required parameter 'bucket_key' is set
        if ($bucket_key === null) {
            throw new \InvalidArgumentException('Missing the required parameter $bucket_key when calling getObjectDetails');
        }
        if (!preg_match("/^[-_.a-z0-9]{3,128}$/", $bucket_key)) {
            throw new \InvalidArgumentException("invalid value for \"bucket_key\" when calling ObjectsApi.getObjectDetails, must conform to the pattern /^[-_.a-z0-9]{3,128}$/.");
        }

        // verify the required parameter 'object_name' is set
        if ($object_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $object_name when calling getObjectDetails');
        }
        // parse inputs
        $resourcePath = "/oss/v2/buckets/{bucketKey}/objects/{objectName}/details";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/vnd.api+json', 'application/json']);
        if ( ! is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        if ($with !== null) {
            $queryParams['with'] = $this->apiClient->getSerializer()->toQueryValue($with);
        }
        // header params
        if ($if_modified_since !== null) {
            $headerParams['If-Modified-Since'] = $this->apiClient->getSerializer()->toHeaderValue($if_modified_since);
        }
        // path params
        if ($bucket_key !== null) {
            $resourcePath = str_replace(
                "{" . "bucketKey" . "}",
                $this->apiClient->getSerializer()->toPathValue($bucket_key),
                $resourcePath
            );
        }
        // path params
        if ($object_name !== null) {
            $resourcePath = str_replace(
                "{" . "objectName" . "}",
                $this->apiClient->getSerializer()->toPathValue($object_name),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);


        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\Autodesk\Forge\Client\Model\ObjectFullDetails',
                '/oss/v2/buckets/{bucketKey}/objects/{objectName}/details'
            );

            return [
                $this->apiClient->getSerializer()->deserialize($response, '\Autodesk\Forge\Client\Model\ObjectFullDetails', $httpHeader),
                $statusCode,
                $httpHeader,
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Autodesk\Forge\Client\Model\ObjectFullDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getObjects
     *
     *
     *
     * @param string $bucket_key URL-encoded bucket key (required)
     * @param int $limit Limit to the response size, Acceptable values: 1-100 Default &#x3D; 10 (optional, default to 10)
     * @param string $begins_with Provides a way to filter the based on object key name (optional)
     * @param string $start_at Key to use as an offset to continue pagination This is typically the last bucket key found in a preceding GET buckets response (optional)
     * @throws \Autodesk\Forge\Client\ApiException on non-2xx response
     * @return \Autodesk\Forge\Client\Model\BucketObjects
     */
    public function getObjects($bucket_key, $limit = null, $begins_with = null, $start_at = null)
    {
        list($response) = $this->getObjectsWithHttpInfo($bucket_key, $limit, $begins_with, $start_at);
        return $response;
    }

    /**
     * Operation getObjectsWithHttpInfo
     *
     *
     *
     * @param string $bucket_key URL-encoded bucket key (required)
     * @param int $limit Limit to the response size, Acceptable values: 1-100 Default &#x3D; 10 (optional, default to 10)
     * @param string $begins_with Provides a way to filter the based on object key name (optional)
     * @param string $start_at Key to use as an offset to continue pagination This is typically the last bucket key found in a preceding GET buckets response (optional)
     * @throws \Autodesk\Forge\Client\ApiException on non-2xx response
     * @return array of \Autodesk\Forge\Client\Model\BucketObjects, HTTP status code, HTTP response headers (array of strings)
     */
    public function getObjectsWithHttpInfo($bucket_key, $limit = null, $begins_with = null, $start_at = null)
    {
        // verify the required parameter 'bucket_key' is set
        if ($bucket_key === null) {
            throw new \InvalidArgumentException('Missing the required parameter $bucket_key when calling getObjects');
        }
        if (!preg_match("/^[-_.a-z0-9]{3,128}$/", $bucket_key)) {
            throw new \InvalidArgumentException("invalid value for \"bucket_key\" when calling ObjectsApi.getObjects, must conform to the pattern /^[-_.a-z0-9]{3,128}$/.");
        }

        // parse inputs
        $resourcePath = "/oss/v2/buckets/{bucketKey}/objects";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/vnd.api+json', 'application/json']);
        if ( ! is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        if ($limit !== null) {
            $queryParams['limit'] = $this->apiClient->getSerializer()->toQueryValue($limit);
        }
        // query params
        if ($begins_with !== null) {
            $queryParams['beginsWith'] = $this->apiClient->getSerializer()->toQueryValue($begins_with);
        }
        // query params
        if ($start_at !== null) {
            $queryParams['startAt'] = $this->apiClient->getSerializer()->toQueryValue($start_at);
        }
        // path params
        if ($bucket_key !== null) {
            $resourcePath = str_replace(
                "{" . "bucketKey" . "}",
                $this->apiClient->getSerializer()->toPathValue($bucket_key),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);


        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\Autodesk\Forge\Client\Model\BucketObjects',
                '/oss/v2/buckets/{bucketKey}/objects'
            );

            return [
                $this->apiClient->getSerializer()->deserialize($response, '\Autodesk\Forge\Client\Model\BucketObjects', $httpHeader),
                $statusCode,
                $httpHeader,
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Autodesk\Forge\Client\Model\BucketObjects', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getSignedResource
     *
     *
     *
     * @param string $id Id of signed resource (required)
     * @param string $range A range of bytes to download from the specified object. (optional)
     * @param string $if_none_match The value of this header is compared to the ETAG of the object. If they match, the body will not be included in the response. Only the object information will be included. (optional)
     * @param \DateTime $if_modified_since If the requested object has not been modified since the time specified in this field, an entity will not be returned from the server; instead, a 304 (not modified) response will be returned without any message body. (optional)
     * @param string $accept_encoding When gzip is specified, a gzip compressed stream of the object’s bytes will be returned in the response. Cannot use “Accept-Encoding:gzip” with Range header containing an end byte range. End byte range will not be honored if “Accept-Encoding: gzip” header is used. (optional)
     * @param string $region The region where the bucket resides Acceptable values: &#x60;US&#x60;, &#x60;EMEA&#x60; Default is &#x60;US&#x60; (optional, default to US)
     * @throws \Autodesk\Forge\Client\ApiException on non-2xx response
     * @return \SplFileObject
     */
    public function getSignedResource($id, $range = null, $if_none_match = null, $if_modified_since = null, $accept_encoding = null, $region = null)
    {
        list($response) = $this->getSignedResourceWithHttpInfo($id, $range, $if_none_match, $if_modified_since, $accept_encoding, $region);
        return $response;
    }

    /**
     * Operation getSignedResourceWithHttpInfo
     *
     *
     *
     * @param string $id Id of signed resource (required)
     * @param string $range A range of bytes to download from the specified object. (optional)
     * @param string $if_none_match The value of this header is compared to the ETAG of the object. If they match, the body will not be included in the response. Only the object information will be included. (optional)
     * @param \DateTime $if_modified_since If the requested object has not been modified since the time specified in this field, an entity will not be returned from the server; instead, a 304 (not modified) response will be returned without any message body. (optional)
     * @param string $accept_encoding When gzip is specified, a gzip compressed stream of the object’s bytes will be returned in the response. Cannot use “Accept-Encoding:gzip” with Range header containing an end byte range. End byte range will not be honored if “Accept-Encoding: gzip” header is used. (optional)
     * @param string $region The region where the bucket resides Acceptable values: &#x60;US&#x60;, &#x60;EMEA&#x60; Default is &#x60;US&#x60; (optional, default to US)
     * @throws \Autodesk\Forge\Client\ApiException on non-2xx response
     * @return array of \SplFileObject, HTTP status code, HTTP response headers (array of strings)
     */
    public function getSignedResourceWithHttpInfo($id, $range = null, $if_none_match = null, $if_modified_since = null, $accept_encoding = null, $region = null)
    {
        // verify the required parameter 'id' is set
        if ($id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id when calling getSignedResource');
        }
        if ( ! is_null($range) && !preg_match("/^bytes=[0-9]+\\-[0-9]*$/", $range)) {
            throw new \InvalidArgumentException("invalid value for \"range\" when calling ObjectsApi.getSignedResource, must conform to the pattern /^bytes=[0-9]+\\-[0-9]*$/.");
        }

        // parse inputs
        $resourcePath = "/oss/v2/signedresources/{id}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/octet-stream']);
        if ( ! is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        if ($region !== null) {
            $queryParams['region'] = $this->apiClient->getSerializer()->toQueryValue($region);
        }
        // header params
        if ($range !== null) {
            $headerParams['Range'] = $this->apiClient->getSerializer()->toHeaderValue($range);
        }
        // header params
        if ($if_none_match !== null) {
            $headerParams['If-None-Match'] = $this->apiClient->getSerializer()->toHeaderValue($if_none_match);
        }
        // header params
        if ($if_modified_since !== null) {
            $headerParams['If-Modified-Since'] = $this->apiClient->getSerializer()->toHeaderValue($if_modified_since);
        }
        // header params
        if ($accept_encoding !== null) {
            $headerParams['Accept-Encoding'] = $this->apiClient->getSerializer()->toHeaderValue($accept_encoding);
        }
        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                "{" . "id" . "}",
                $this->apiClient->getSerializer()->toPathValue($id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);


        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\SplFileObject',
                '/oss/v2/signedresources/{id}'
            );

            return [
                $this->apiClient->getSerializer()->deserialize($response, '\SplFileObject', $httpHeader),
                $statusCode,
                $httpHeader,
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\SplFileObject', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 412:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Autodesk\Forge\Client\Model\Reason', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getStatusBySessionId
     *
     *
     *
     * @param string $bucket_key URL-encoded bucket key (required)
     * @param string $object_name URL-encoded object name (required)
     * @param string $session_id Unique identifier of a session of a file being uploaded (required)
     * @throws \Autodesk\Forge\Client\ApiException on non-2xx response
     * @return void
     */
    public function getStatusBySessionId($bucket_key, $object_name, $session_id)
    {
        list($response) = $this->getStatusBySessionIdWithHttpInfo($bucket_key, $object_name, $session_id);
        return $response;
    }

    /**
     * Operation getStatusBySessionIdWithHttpInfo
     *
     *
     *
     * @param string $bucket_key URL-encoded bucket key (required)
     * @param string $object_name URL-encoded object name (required)
     * @param string $session_id Unique identifier of a session of a file being uploaded (required)
     * @throws \Autodesk\Forge\Client\ApiException on non-2xx response
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function getStatusBySessionIdWithHttpInfo($bucket_key, $object_name, $session_id)
    {
        // verify the required parameter 'bucket_key' is set
        if ($bucket_key === null) {
            throw new \InvalidArgumentException('Missing the required parameter $bucket_key when calling getStatusBySessionId');
        }
        if (!preg_match("/^[-_.a-z0-9]{3,128}$/", $bucket_key)) {
            throw new \InvalidArgumentException("invalid value for \"bucket_key\" when calling ObjectsApi.getStatusBySessionId, must conform to the pattern /^[-_.a-z0-9]{3,128}$/.");
        }

        // verify the required parameter 'object_name' is set
        if ($object_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $object_name when calling getStatusBySessionId');
        }
        // verify the required parameter 'session_id' is set
        if ($session_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $session_id when calling getStatusBySessionId');
        }
        // parse inputs
        $resourcePath = "/oss/v2/buckets/{bucketKey}/objects/{objectName}/status/{sessionId}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/vnd.api+json', 'application/json']);
        if ( ! is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // path params
        if ($bucket_key !== null) {
            $resourcePath = str_replace(
                "{" . "bucketKey" . "}",
                $this->apiClient->getSerializer()->toPathValue($bucket_key),
                $resourcePath
            );
        }
        // path params
        if ($object_name !== null) {
            $resourcePath = str_replace(
                "{" . "objectName" . "}",
                $this->apiClient->getSerializer()->toPathValue($object_name),
                $resourcePath
            );
        }
        // path params
        if ($session_id !== null) {
            $resourcePath = str_replace(
                "{" . "sessionId" . "}",
                $this->apiClient->getSerializer()->toPathValue($session_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);


        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/oss/v2/buckets/{bucketKey}/objects/{objectName}/status/{sessionId}'
            );

            return [null, $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 409:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Autodesk\Forge\Client\Model\Reason', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 416:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Autodesk\Forge\Client\Model\Reason', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation uploadChunk
     *
     *
     *
     * @param string $bucket_key URL-encoded bucket key (required)
     * @param string $object_name URL-encoded object name (required)
     * @param int $content_length Indicates the size of the request body. (required)
     * @param string $content_range Byte range of a segment being uploaded (required)
     * @param string $session_id Unique identifier of a session of a file being uploaded (required)
     * @param string $body File content (required)
     * @param string $content_disposition The suggested default filename when downloading this object to a file after it has been uploaded. (optional)
     * @param string $if_match If-Match header containing a SHA-1 hash of the bytes in the request body can be sent by the calling service or client application with the request. If present, OSS will use the value of If-Match header to verify that a SHA-1 calculated for the uploaded bytes server side matches what was sent in the header. If not, the request is failed with a status 412 Precondition Failed and the data is not written. (optional)
     * @throws \Autodesk\Forge\Client\ApiException on non-2xx response
     * @return \Autodesk\Forge\Client\Model\ObjectDetails
     */
    public function uploadChunk($bucket_key, $object_name, $content_length, $content_range, $session_id, $body, $content_disposition = null, $if_match = null)
    {
        list($response) = $this->uploadChunkWithHttpInfo($bucket_key, $object_name, $content_length, $content_range, $session_id, $body, $content_disposition, $if_match);
        return $response;
    }

    /**
     * Operation uploadChunkWithHttpInfo
     *
     *
     *
     * @param string $bucket_key URL-encoded bucket key (required)
     * @param string $object_name URL-encoded object name (required)
     * @param int $content_length Indicates the size of the request body. (required)
     * @param string $content_range Byte range of a segment being uploaded (required)
     * @param string $session_id Unique identifier of a session of a file being uploaded (required)
     * @param string $body Chunk content(required)
     * @param string $content_disposition The suggested default filename when downloading this object to a file after it has been uploaded. (optional)
     * @param string $if_match If-Match header containing a SHA-1 hash of the bytes in the request body can be sent by the calling service or client application with the request. If present, OSS will use the value of If-Match header to verify that a SHA-1 calculated for the uploaded bytes server side matches what was sent in the header. If not, the request is failed with a status 412 Precondition Failed and the data is not written. (optional)
     * @throws \Autodesk\Forge\Client\ApiException on non-2xx response
     * @return array of \Autodesk\Forge\Client\Model\ObjectDetails, HTTP status code, HTTP response headers (array of strings)
     */
    public function uploadChunkWithHttpInfo($bucket_key, $object_name, $content_length, $content_range, $session_id, $body, $content_disposition = null, $if_match = null)
    {
        // verify the required parameter 'bucket_key' is set
        if ($bucket_key === null) {
            throw new \InvalidArgumentException('Missing the required parameter $bucket_key when calling uploadChunk');
        }
        if (!preg_match("/^[-_.a-z0-9]{3,128}$/", $bucket_key)) {
            throw new \InvalidArgumentException("invalid value for \"bucket_key\" when calling ObjectsApi.uploadChunk, must conform to the pattern /^[-_.a-z0-9]{3,128}$/.");
        }

        // verify the required parameter 'object_name' is set
        if ($object_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $object_name when calling uploadChunk');
        }
        // verify the required parameter 'content_length' is set
        if ($content_length === null) {
            throw new \InvalidArgumentException('Missing the required parameter $content_length when calling uploadChunk');
        }
        // verify the required parameter 'content_range' is set
        if ($content_range === null) {
            throw new \InvalidArgumentException('Missing the required parameter $content_range when calling uploadChunk');
        }
        if (!preg_match("/^bytes [0-9]+\\-[0-9]+/[0-9]+$/", $content_range)) {
            throw new \InvalidArgumentException("invalid value for \"content_range\" when calling ObjectsApi.uploadChunk, must conform to the pattern /^bytes [0-9]+\\-[0-9]+/[0-9]+$/.");
        }

        // verify the required parameter 'session_id' is set
        if ($session_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $session_id when calling uploadChunk');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling uploadChunk');
        }
        // parse inputs
        $resourcePath = "/oss/v2/buckets/{bucketKey}/objects/{objectName}/resumable";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/vnd.api+json', 'application/json']);
        if ( ! is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/octet-stream']);

        // header params
        if ($content_length !== null) {
            $headerParams['Content-Length'] = $this->apiClient->getSerializer()->toHeaderValue($content_length);
        }
        // header params
        if ($content_range !== null) {
            $headerParams['Content-Range'] = $this->apiClient->getSerializer()->toHeaderValue($content_range);
        }
        // header params
        if ($content_disposition !== null) {
            $headerParams['Content-Disposition'] = $this->apiClient->getSerializer()->toHeaderValue($content_disposition);
        }
        // header params
        if ($if_match !== null) {
            $headerParams['If-Match'] = $this->apiClient->getSerializer()->toHeaderValue($if_match);
        }
        // header params
        if ($session_id !== null) {
            $headerParams['Session-Id'] = $this->apiClient->getSerializer()->toHeaderValue($session_id);
        }
        // path params
        if ($bucket_key !== null) {
            $resourcePath = str_replace(
                "{" . "bucketKey" . "}",
                $this->apiClient->getSerializer()->toPathValue($bucket_key),
                $resourcePath
            );
        }
        // path params
        if ($object_name !== null) {
            $resourcePath = str_replace(
                "{" . "objectName" . "}",
                $this->apiClient->getSerializer()->toPathValue($object_name),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\Autodesk\Forge\Client\Model\ObjectDetails',
                '/oss/v2/buckets/{bucketKey}/objects/{objectName}/resumable'
            );

            return [
                $this->apiClient->getSerializer()->deserialize($response, '\Autodesk\Forge\Client\Model\ObjectDetails', $httpHeader),
                $statusCode,
                $httpHeader,
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Autodesk\Forge\Client\Model\ObjectDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 202:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Autodesk\Forge\Client\Model\Result', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 409:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Autodesk\Forge\Client\Model\Reason', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 416:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Autodesk\Forge\Client\Model\Reason', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation uploadObject
     *
     *
     *
     * @param string $bucket_key URL-encoded bucket key (required)
     * @param string $object_name URL-encoded object name (required)
     * @param int $content_length Indicates the size of the request body. (required)
     * @param string $body File content (required)
     * @param string $content_disposition The suggested default filename when downloading this object to a file after it has been uploaded. (optional)
     * @param string $if_match If-Match header containing a SHA-1 hash of the bytes in the request body can be sent by the calling service or client application with the request. If present, OSS will use the value of If-Match header to verify that a SHA-1 calculated for the uploaded bytes server side matches what was sent in the header. If not, the request is failed with a status 412 Precondition Failed and the data is not written. (optional)
     * @throws \Autodesk\Forge\Client\ApiException on non-2xx response
     * @return \Autodesk\Forge\Client\Model\ObjectDetails
     */
    public function uploadObject($bucket_key, $object_name, $content_length, $body, $content_disposition = null, $if_match = null)
    {
        list($response) = $this->uploadObjectWithHttpInfo($bucket_key, $object_name, $content_length, $body, $content_disposition, $if_match);
        return $response;
    }

    /**
     * Operation uploadObjectWithHttpInfo
     *
     *
     *
     * @param string $bucket_key URL-encoded bucket key (required)
     * @param string $object_name URL-encoded object name (required)
     * @param int $content_length Indicates the size of the request body. (required)
     * @param string $body File content (required)
     * @param string $content_disposition The suggested default filename when downloading this object to a file after it has been uploaded. (optional)
     * @param string $if_match If-Match header containing a SHA-1 hash of the bytes in the request body can be sent by the calling service or client application with the request. If present, OSS will use the value of If-Match header to verify that a SHA-1 calculated for the uploaded bytes server side matches what was sent in the header. If not, the request is failed with a status 412 Precondition Failed and the data is not written. (optional)
     * @throws \Autodesk\Forge\Client\ApiException on non-2xx response
     * @return array of \Autodesk\Forge\Client\Model\ObjectDetails, HTTP status code, HTTP response headers (array of strings)
     */
    public function uploadObjectWithHttpInfo($bucket_key, $object_name, $content_length, $body, $content_disposition = null, $if_match = null)
    {
        // verify the required parameter 'bucket_key' is set
        if ($bucket_key === null) {
            throw new \InvalidArgumentException('Missing the required parameter $bucket_key when calling uploadObject');
        }
        if (!preg_match("/^[-_.a-z0-9]{3,128}$/", $bucket_key)) {
            throw new \InvalidArgumentException("invalid value for \"bucket_key\" when calling ObjectsApi.uploadObject, must conform to the pattern /^[-_.a-z0-9]{3,128}$/.");
        }

        // verify the required parameter 'object_name' is set
        if ($object_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $object_name when calling uploadObject');
        }
        // verify the required parameter 'content_length' is set
        if ($content_length === null) {
            throw new \InvalidArgumentException('Missing the required parameter $content_length when calling uploadObject');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling uploadObject');
        }
        // parse inputs
        $resourcePath = "/oss/v2/buckets/{bucketKey}/objects/{objectName}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/vnd.api+json', 'application/json']);
        if ( ! is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/octet-stream']);

        // header params
        if ($content_length !== null) {
            $headerParams['Content-Length'] = $this->apiClient->getSerializer()->toHeaderValue($content_length);
        }
        // header params
        if ($content_disposition !== null) {
            $headerParams['Content-Disposition'] = $this->apiClient->getSerializer()->toHeaderValue($content_disposition);
        }
        // header params
        if ($if_match !== null) {
            $headerParams['If-Match'] = $this->apiClient->getSerializer()->toHeaderValue($if_match);
        }
        // path params
        if ($bucket_key !== null) {
            $resourcePath = str_replace(
                "{" . "bucketKey" . "}",
                $this->apiClient->getSerializer()->toPathValue($bucket_key),
                $resourcePath
            );
        }
        // path params
        if ($object_name !== null) {
            $resourcePath = str_replace(
                "{" . "objectName" . "}",
                $this->apiClient->getSerializer()->toPathValue($object_name),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\Autodesk\Forge\Client\Model\ObjectDetails',
                '/oss/v2/buckets/{bucketKey}/objects/{objectName}'
            );

            return [
                $this->apiClient->getSerializer()->deserialize($response, '\Autodesk\Forge\Client\Model\ObjectDetails', $httpHeader),
                $statusCode,
                $httpHeader,
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Autodesk\Forge\Client\Model\ObjectDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 412:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Autodesk\Forge\Client\Model\Reason', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }


    /**
     * Operation signed3upload
     *
     *
     *
     * @param string $bucket_key URL-encoded bucket key (required)
     * @param string $object_name URL-encoded object name (required)
     * @param int $parts Indicates how many parts the object has.
     * @param int $minutes_expiration When access to the generatet urls will expire.
     * @throws \Autodesk\Forge\Client\ApiException on non-2xx response
     * @return \Autodesk\Forge\Client\Model\SignedUploadDetails
     */
    public function getSignedUploadObject($bucket_key, $object_name, $parts = 1, $minutesExpiration = 5)
    {
        list($response) = $this->getSignedUploadObjectWithHttpInfo($bucket_key, $object_name, $parts, $minutesExpiration);
        return $response;
    }

    /**
     * Operation getSignedUploadObjectWithHttpInfo
     *
     *
     * @param string $bucket_key URL-encoded bucket key (required)
     * @param string $object_name URL-encoded object name (required)
     * @param int $parts Indicates how many parts the object has.
     * @param int $minutes_expiration When access to the generatet urls will expire.
     * @throws \Autodesk\Forge\Client\ApiException on non-2xx response
     * @return array of \Autodesk\Forge\Client\Model\SignedUploadDetails, HTTP status code, HTTP response headers (array of strings)
     */
    public function getSignedUploadObjectWithHttpInfo($bucket_key, $object_name, $parts = 1, $minutesExpiration = 5)
    {
        // verify the required parameter 'bucket_key' is set
        if ($bucket_key === null) {
            throw new \InvalidArgumentException('Missing the required parameter $bucket_key when calling uploadObject');
        }
        if (!preg_match("/^[-_.a-z0-9]{3,128}$/", $bucket_key)) {
            throw new \InvalidArgumentException("invalid value for \"bucket_key\" when calling ObjectsApi.uploadObject, must conform to the pattern /^[-_.a-z0-9]{3,128}$/.");
        }

        // verify the required parameter 'object_name' is set
        if ($object_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $object_name when calling uploadObject');
        }

        // parse inputs
        $resourcePath = "/oss/v2/buckets/{bucketKey}/objects/{objectName}/signeds3upload";
        $queryParams = [];
        $headerParams = [];

        // path params
        if ($bucket_key !== null) {
            $resourcePath = str_replace(
                "{" . "bucketKey" . "}",
                $this->apiClient->getSerializer()->toPathValue($bucket_key),
                $resourcePath
            );
        }
        // path params
        if ($object_name !== null) {
            $resourcePath = str_replace(
                "{" . "objectName" . "}",
                $this->apiClient->getSerializer()->toPathValue($object_name),
                $resourcePath
            );
        }

        if ($parts !== null) {
            $queryParams['parts'] = $this->apiClient->getSerializer()->toQueryValue($parts);
        }

        if ($minutesExpiration !== null) {
            $queryParams['minutesExpiration'] = $this->apiClient->getSerializer()->toQueryValue($minutesExpiration);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                null,
                $headerParams,
                '\Autodesk\Forge\Client\Model\SignedUploadDetails',
                '/oss/v2/buckets/{bucketKey}/objects/{objectName}/signeds3upload'
            );

            return [
                $this->apiClient->getSerializer()->deserialize($response, '\Autodesk\Forge\Client\Model\SignedUploadDetails', $httpHeader),
                $statusCode,
                $httpHeader,
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Autodesk\Forge\Client\Model\SignedUploadDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 412:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Autodesk\Forge\Client\Model\Reason', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation confirmSigned3upload
     *
     *
     *
     * @param string $bucket_key URL-encoded bucket key (required)
     * @param string $object_name URL-encoded object name (required)
     * @param string $uploadKey Upload key (required)
     * @throws \Autodesk\Forge\Client\ApiException on non-2xx response
     * @return \Autodesk\Forge\Client\Model\ObjectDetails
     */
    public function confirmSignedUploadObject($bucket_key, $object_name, $uploadKey)
    {
        list($response) = $this->confirmSignedUploadObjectWithHttpInfo($bucket_key, $object_name, $uploadKey);
        return $response;
    }

    /**
     * Operation confirmSignedUploadObjectWithHttpInfo
     *
     *
     * @param string $bucket_key URL-encoded bucket key (required)
     * @param string $object_name URL-encoded object name (required)
     * @param string $uploadKey Upload key (required)
     * @throws \Autodesk\Forge\Client\ApiException on non-2xx response
     * @return array of \Autodesk\Forge\Client\Model\ObjectDetails, HTTP status code, HTTP response headers (array of strings)
     */
    public function confirmSignedUploadObjectWithHttpInfo($bucket_key, $object_name, $uploadKey)
    {
        // verify the required parameter 'bucket_key' is set
        if ($bucket_key === null) {
            throw new \InvalidArgumentException('Missing the required parameter $bucket_key when calling uploadObject');
        }
        if (!preg_match("/^[-_.a-z0-9]{3,128}$/", $bucket_key)) {
            throw new \InvalidArgumentException("invalid value for \"bucket_key\" when calling ObjectsApi.uploadObject, must conform to the pattern /^[-_.a-z0-9]{3,128}$/.");
        }

        // verify the required parameter 'object_name' is set
        if ($object_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $object_name when calling uploadObject');
        }

        // parse inputs
        $resourcePath = "/oss/v2/buckets/{bucketKey}/objects/{objectName}/signeds3upload";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];

        // path params
        if ($bucket_key !== null) {
            $resourcePath = str_replace(
                "{" . "bucketKey" . "}",
                $this->apiClient->getSerializer()->toPathValue($bucket_key),
                $resourcePath
            );
        }
        // path params
        if ($object_name !== null) {
            $resourcePath = str_replace(
                "{" . "objectName" . "}",
                $this->apiClient->getSerializer()->toPathValue($object_name),
                $resourcePath
            );
        }

        if ($uploadKey !== null) {
            $httpBody = json_encode([
                'uploadKey' => $uploadKey,
            ]);
        }

        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\Autodesk\Forge\Client\Model\ObjectDetails',
                '/oss/v2/buckets/{bucketKey}/objects/{objectName}/signeds3upload'
            );

            return [
                $this->apiClient->getSerializer()->deserialize($response, '\Autodesk\Forge\Client\Model\ObjectDetails', $httpHeader),
                $statusCode,
                $httpHeader,
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Autodesk\Forge\Client\Model\ObjectDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 412:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Autodesk\Forge\Client\Model\Reason', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }
    /**
     * Operation uploadSignedResource
     *
     *
     *
     * @param string $id Id of signed resource (required)
     * @param int $content_length Indicates the size of the request body. (required)
     * @param string $body File content (required) or file resource handle
     * @param string $content_disposition The suggested default filename when downloading this object to a file after it has been uploaded. (optional)
     * @param string $x_ads_region The region where the bucket resides Acceptable values: &#x60;US&#x60;, &#x60;EMEA&#x60; Default is &#x60;US&#x60; (optional, default to US)
     * @param string $if_match If-Match header containing a SHA-1 hash of the bytes in the request body can be sent by the calling service or client application with the request. If present, OSS will use the value of If-Match header to verify that a SHA-1 calculated for the uploaded bytes server side matches what was sent in the header. If not, the request is failed with a status 412 Precondition Failed and the data is not written. (optional)
     * @throws \Autodesk\Forge\Client\ApiException on non-2xx response
     * @return \Autodesk\Forge\Client\Model\ObjectDetails
     */
    public function uploadSignedResource($id, $content_length, $body, $content_disposition = null, $x_ads_region = null, $if_match = null)
    {
        list($response) = $this->uploadSignedResourceWithHttpInfo($id, $content_length, $body, $content_disposition, $x_ads_region, $if_match);
        return $response;
    }

    /**
     * Operation uploadSignedResourceWithHttpInfo
     *
     *
     *
     * @param string $id Id of signed resource (required)
     * @param int $content_length Indicates the size of the request body. (required)
     * @param string $body File content (required) or file resource handle
     * @param string $content_disposition The suggested default filename when downloading this object to a file after it has been uploaded. (optional)
     * @param string $x_ads_region The region where the bucket resides Acceptable values: &#x60;US&#x60;, &#x60;EMEA&#x60; Default is &#x60;US&#x60; (optional, default to US)
     * @param string $if_match If-Match header containing a SHA-1 hash of the bytes in the request body can be sent by the calling service or client application with the request. If present, OSS will use the value of If-Match header to verify that a SHA-1 calculated for the uploaded bytes server side matches what was sent in the header. If not, the request is failed with a status 412 Precondition Failed and the data is not written. (optional)
     * @throws \Autodesk\Forge\Client\ApiException on non-2xx response
     * @return array of \Autodesk\Forge\Client\Model\ObjectDetails, HTTP status code, HTTP response headers (array of strings)
     */
    public function uploadSignedResourceWithHttpInfo($id, $content_length, $body, $content_disposition = null, $x_ads_region = null, $if_match = null)
    {
        // verify the required parameter 'id' is set
        if ($id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id when calling uploadSignedResource');
        }
        // verify the required parameter 'content_length' is set
        if ($content_length === null) {
            throw new \InvalidArgumentException('Missing the required parameter $content_length when calling uploadSignedResource');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling uploadSignedResource');
        }
        // parse inputs
        $resourcePath = "/oss/v2/signedresources/{id}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/vnd.api+json', 'application/json']);
        if ( ! is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/octet-stream']);

        // header params
        if ($content_length !== null) {
            $headerParams['Content-Length'] = $this->apiClient->getSerializer()->toHeaderValue($content_length);
        }
        // header params
        if ($content_disposition !== null) {
            $headerParams['Content-Disposition'] = $this->apiClient->getSerializer()->toHeaderValue($content_disposition);
        }
        // header params
        if ($x_ads_region !== null) {
            $headerParams['x-ads-region'] = $this->apiClient->getSerializer()->toHeaderValue($x_ads_region);
        }
        // header params
        if ($if_match !== null) {
            $headerParams['If-Match'] = $this->apiClient->getSerializer()->toHeaderValue($if_match);
        }
        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                "{" . "id" . "}",
                $this->apiClient->getSerializer()->toPathValue($id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\Autodesk\Forge\Client\Model\ObjectDetails',
                '/oss/v2/signedresources/{id}'
            );

            return [
                $this->apiClient->getSerializer()->deserialize($response, '\Autodesk\Forge\Client\Model\ObjectDetails', $httpHeader),
                $statusCode,
                $httpHeader,
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Autodesk\Forge\Client\Model\ObjectDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 412:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Autodesk\Forge\Client\Model\Reason', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation uploadSignedResourcesChunk
     *
     *
     *
     * @param string $id Id of signed resource (required)
     * @param string $content_range Byte range of a segment being uploaded (required)
     * @param string $session_id Unique identifier of a session of a file being uploaded (required)
     * @param string $body File content (required) or file resource handle
     * @param string $content_disposition The suggested default filename when downloading this object to a file after it has been uploaded. (optional)
     * @param string $x_ads_region The region where the bucket resides Acceptable values: &#x60;US&#x60;, &#x60;EMEA&#x60; Default is &#x60;US&#x60; (optional, default to US)
     * @throws \Autodesk\Forge\Client\ApiException on non-2xx response
     * @return \Autodesk\Forge\Client\Model\ObjectDetails
     */
    public function uploadSignedResourcesChunk($id, $content_range, $session_id, $body, $content_disposition = null, $x_ads_region = null)
    {
        list($response) = $this->uploadSignedResourcesChunkWithHttpInfo($id, $content_range, $session_id, $body, $content_disposition, $x_ads_region);
        return $response;
    }

    /**
     * Operation uploadSignedResourcesChunkWithHttpInfo
     *
     *
     *
     * @param string $id Id of signed resource (required)
     * @param string $content_range Byte range of a segment being uploaded (required)
     * @param string $session_id Unique identifier of a session of a file being uploaded (required)
     * @param string $body File content (required) or file resource handle
     * @param string $content_disposition The suggested default filename when downloading this object to a file after it has been uploaded. (optional)
     * @param string $x_ads_region The region where the bucket resides Acceptable values: &#x60;US&#x60;, &#x60;EMEA&#x60; Default is &#x60;US&#x60; (optional, default to US)
     * @throws \Autodesk\Forge\Client\ApiException on non-2xx response
     * @return array of \Autodesk\Forge\Client\Model\ObjectDetails, HTTP status code, HTTP response headers (array of strings)
     */
    public function uploadSignedResourcesChunkWithHttpInfo($id, $content_range, $session_id, $body, $content_disposition = null, $x_ads_region = null)
    {
        // verify the required parameter 'id' is set
        if ($id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id when calling uploadSignedResourcesChunk');
        }
        // verify the required parameter 'content_range' is set
        if ($content_range === null) {
            throw new \InvalidArgumentException('Missing the required parameter $content_range when calling uploadSignedResourcesChunk');
        }
        if (!preg_match("/^bytes [0-9]+\\-[0-9]+/[0-9]+$/", $content_range)) {
            throw new \InvalidArgumentException("invalid value for \"content_range\" when calling ObjectsApi.uploadSignedResourcesChunk, must conform to the pattern /^bytes [0-9]+\\-[0-9]+/[0-9]+$/.");
        }

        // verify the required parameter 'session_id' is set
        if ($session_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $session_id when calling uploadSignedResourcesChunk');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling uploadSignedResourcesChunk');
        }
        // parse inputs
        $resourcePath = "/oss/v2/signedresources/{id}/resumable";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/vnd.api+json', 'application/json']);
        if ( ! is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/octet-stream']);

        // header params
        if ($content_range !== null) {
            $headerParams['Content-Range'] = $this->apiClient->getSerializer()->toHeaderValue($content_range);
        }
        // header params
        if ($content_disposition !== null) {
            $headerParams['Content-Disposition'] = $this->apiClient->getSerializer()->toHeaderValue($content_disposition);
        }
        // header params
        if ($x_ads_region !== null) {
            $headerParams['x-ads-region'] = $this->apiClient->getSerializer()->toHeaderValue($x_ads_region);
        }
        // header params
        if ($session_id !== null) {
            $headerParams['Session-Id'] = $this->apiClient->getSerializer()->toHeaderValue($session_id);
        }
        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                "{" . "id" . "}",
                $this->apiClient->getSerializer()->toPathValue($id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\Autodesk\Forge\Client\Model\ObjectDetails',
                '/oss/v2/signedresources/{id}/resumable'
            );

            return [
                $this->apiClient->getSerializer()->deserialize($response, '\Autodesk\Forge\Client\Model\ObjectDetails', $httpHeader),
                $statusCode,
                $httpHeader,
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Autodesk\Forge\Client\Model\ObjectDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 202:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Autodesk\Forge\Client\Model\Result', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 409:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Autodesk\Forge\Client\Model\Reason', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 416:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Autodesk\Forge\Client\Model\Reason', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

}
