<?php
/**
 * Activity
 *
 * PHP version 5
 *
 * @category Class
 * @package  Autodesk\Forge\Client
 * @author   Swaagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * Forge SDK
 *
 * The Forge Platform contains an expanding collection of web service components that can be used with Autodesk cloud-based products or your own technologies. Take advantage of Autodesk’s expertise in design and engineering.
 *
 * OpenAPI spec version: 0.1.0
 * Contact: forge.help@autodesk.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace Autodesk\Forge\Client\Model;

use \ArrayAccess;

/**
 * Activity Class Doc Comment
 *
 * @category    Class
 * @package     Autodesk\Forge\Client
 * @author      Swagger Codegen team
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class Activity implements ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
     * The original name of the model.
     * @var string
     */
    protected static $swaggerModelName = 'Activity';

    /**
     * Array of property to type mappings. Used for (de)serialization
     * @var string[]
     */
    protected static $swaggerTypes = [
        'id' => 'string',
        'instruction' => 'object',
        'app_packages' => 'string[]',
        'required_engine_version' => 'string',
        'parameters' => 'object',
        'allowed_child_processes' => 'object[]',
        'version' => 'int',
        'description' => 'string',
        'host_application' => 'string',
        'is_public' => 'bool',
    ];

    /**
     * @return \string[]
     */
    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = [
        'id' => 'Id',
        'instruction' => 'Instruction',
        'app_packages' => 'AppPackages',
        'required_engine_version' => 'RequiredEngineVersion',
        'parameters' => 'Parameters',
        'allowed_child_processes' => 'AllowedChildProcesses',
        'version' => 'Version',
        'description' => 'Description',
        'host_application' => 'HostApplication',
        'is_public' => 'IsPublic',
    ];


    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = [
        'id' => 'setId',
        'instruction' => 'setInstruction',
        'app_packages' => 'setAppPackages',
        'required_engine_version' => 'setRequiredEngineVersion',
        'parameters' => 'setParameters',
        'allowed_child_processes' => 'setAllowedChildProcesses',
        'version' => 'setVersion',
        'description' => 'setDescription',
        'host_application' => 'setHostApplication',
        'is_public' => 'setIsPublic',
    ];


    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = [
        'id' => 'getId',
        'instruction' => 'getInstruction',
        'app_packages' => 'getAppPackages',
        'required_engine_version' => 'getRequiredEngineVersion',
        'parameters' => 'getParameters',
        'allowed_child_processes' => 'getAllowedChildProcesses',
        'version' => 'getVersion',
        'description' => 'getDescription',
        'host_application' => 'getHostApplication',
        'is_public' => 'getIsPublic',
    ];

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    public static function setters()
    {
        return self::$setters;
    }

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     * @param mixed[] $data Associated array of property values initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['instruction'] = isset($data['instruction']) ? $data['instruction'] : null;
        $this->container['app_packages'] = isset($data['app_packages']) ? $data['app_packages'] : null;
        $this->container['required_engine_version'] = isset($data['required_engine_version']) ? $data['required_engine_version'] : null;
        $this->container['parameters'] = isset($data['parameters']) ? $data['parameters'] : null;
        $this->container['allowed_child_processes'] = isset($data['allowed_child_processes']) ? $data['allowed_child_processes'] : null;
        $this->container['version'] = isset($data['version']) ? $data['version'] : null;
        $this->container['description'] = isset($data['description']) ? $data['description'] : null;
        $this->container['host_application'] = isset($data['host_application']) ? $data['host_application'] : null;
        $this->container['is_public'] = isset($data['is_public']) ? $data['is_public'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = [];

        if ($this->container['id'] === null) {
            $invalid_properties[] = "'id' can't be null";
        }
        if ($this->container['instruction'] === null) {
            $invalid_properties[] = "'instruction' can't be null";
        }
        if ($this->container['app_packages'] === null) {
            $invalid_properties[] = "'app_packages' can't be null";
        }
        if ($this->container['required_engine_version'] === null) {
            $invalid_properties[] = "'required_engine_version' can't be null";
        }
        if ($this->container['parameters'] === null) {
            $invalid_properties[] = "'parameters' can't be null";
        }
        if ($this->container['allowed_child_processes'] === null) {
            $invalid_properties[] = "'allowed_child_processes' can't be null";
        }
        if ($this->container['version'] === null) {
            $invalid_properties[] = "'version' can't be null";
        }
        if ($this->container['is_public'] === null) {
            $invalid_properties[] = "'is_public' can't be null";
        }
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {

        if ($this->container['id'] === null) {
            return false;
        }
        if ($this->container['instruction'] === null) {
            return false;
        }
        if ($this->container['app_packages'] === null) {
            return false;
        }
        if ($this->container['required_engine_version'] === null) {
            return false;
        }
        if ($this->container['parameters'] === null) {
            return false;
        }
        if ($this->container['allowed_child_processes'] === null) {
            return false;
        }
        if ($this->container['version'] === null) {
            return false;
        }
        if ($this->container['is_public'] === null) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets instruction
     * @return object
     */
    public function getInstruction()
    {
        return $this->container['instruction'];
    }

    /**
     * Sets instruction
     * @param object $instruction
     * @return $this
     */
    public function setInstruction($instruction)
    {
        $this->container['instruction'] = $instruction;

        return $this;
    }

    /**
     * Gets app_packages
     * @return string[]
     */
    public function getAppPackages()
    {
        return $this->container['app_packages'];
    }

    /**
     * Sets app_packages
     * @param string[] $app_packages
     * @return $this
     */
    public function setAppPackages($app_packages)
    {
        $this->container['app_packages'] = $app_packages;

        return $this;
    }

    /**
     * Gets required_engine_version
     * @return string
     */
    public function getRequiredEngineVersion()
    {
        return $this->container['required_engine_version'];
    }

    /**
     * Sets required_engine_version
     * @param string $required_engine_version
     * @return $this
     */
    public function setRequiredEngineVersion($required_engine_version)
    {
        $this->container['required_engine_version'] = $required_engine_version;

        return $this;
    }

    /**
     * Gets parameters
     * @return object
     */
    public function getParameters()
    {
        return $this->container['parameters'];
    }

    /**
     * Sets parameters
     * @param object $parameters
     * @return $this
     */
    public function setParameters($parameters)
    {
        $this->container['parameters'] = $parameters;

        return $this;
    }

    /**
     * Gets allowed_child_processes
     * @return object[]
     */
    public function getAllowedChildProcesses()
    {
        return $this->container['allowed_child_processes'];
    }

    /**
     * Sets allowed_child_processes
     * @param object[] $allowed_child_processes
     * @return $this
     */
    public function setAllowedChildProcesses($allowed_child_processes)
    {
        $this->container['allowed_child_processes'] = $allowed_child_processes;

        return $this;
    }

    /**
     * Gets version
     * @return int
     */
    public function getVersion()
    {
        return $this->container['version'];
    }

    /**
     * Sets version
     * @param int $version
     * @return $this
     */
    public function setVersion($version)
    {
        $this->container['version'] = $version;

        return $this;
    }

    /**
     * Gets description
     * @return string
     */
    public function getDescription()
    {
        return $this->container['description'];
    }

    /**
     * Sets description
     * @param string $description
     * @return $this
     */
    public function setDescription($description)
    {
        $this->container['description'] = $description;

        return $this;
    }

    /**
     * Gets host_application
     * @return string
     */
    public function getHostApplication()
    {
        return $this->container['host_application'];
    }

    /**
     * Sets host_application
     * @param string $host_application
     * @return $this
     */
    public function setHostApplication($host_application)
    {
        $this->container['host_application'] = $host_application;

        return $this;
    }

    /**
     * Gets is_public
     * @return bool
     */
    public function getIsPublic()
    {
        return $this->container['is_public'];
    }

    /**
     * Sets is_public
     * @param bool $is_public
     * @return $this
     */
    public function setIsPublic($is_public)
    {
        $this->container['is_public'] = $is_public;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\Autodesk\Forge\Client\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\Autodesk\Forge\Client\ObjectSerializer::sanitizeForSerialization($this));
    }
}


