<?php
/**
 * BaseAttributesCreatedUpdatedAttributes
 *
 * PHP version 5
 *
 * @category Class
 * @package  Autodesk\Forge\Client
 * @author   Swaagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * Forge SDK
 *
 * The Forge Platform contains an expanding collection of web service components that can be used with Autodesk cloud-based products or your own technologies. Take advantage of Autodesk’s expertise in design and engineering.
 *
 * OpenAPI spec version: 0.1.0
 * Contact: forge.help@autodesk.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace Autodesk\Forge\Client\Model;

use \ArrayAccess;

/**
 * BaseAttributesCreatedUpdatedAttributes Class Doc Comment
 *
 * @category    Class
 * @package     Autodesk\Forge\Client
 * @author      Swagger Codegen team
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class BaseAttributesCreatedUpdatedAttributes implements ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
     * The original name of the model.
     * @var string
     */
    protected static $swaggerModelName = 'base_attributes_created_updated_attributes';

    /**
     * Array of property to type mappings. Used for (de)serialization
     * @var string[]
     */
    protected static $swaggerTypes = [
        'create_time' => '\DateTime',
        'create_user_id' => 'string',
        'last_modified_time' => '\DateTime',
        'last_modified_user_id' => 'string',
    ];

    /**
     * @return \string[]
     */
    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = [
        'create_time' => 'createTime',
        'create_user_id' => 'createUserId',
        'last_modified_time' => 'lastModifiedTime',
        'last_modified_user_id' => 'lastModifiedUserId',
    ];


    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = [
        'create_time' => 'setCreateTime',
        'create_user_id' => 'setCreateUserId',
        'last_modified_time' => 'setLastModifiedTime',
        'last_modified_user_id' => 'setLastModifiedUserId',
    ];


    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = [
        'create_time' => 'getCreateTime',
        'create_user_id' => 'getCreateUserId',
        'last_modified_time' => 'getLastModifiedTime',
        'last_modified_user_id' => 'getLastModifiedUserId',
    ];

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    public static function setters()
    {
        return self::$setters;
    }

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     * @param mixed[] $data Associated array of property values initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['create_time'] = isset($data['create_time']) ? $data['create_time'] : null;
        $this->container['create_user_id'] = isset($data['create_user_id']) ? $data['create_user_id'] : null;
        $this->container['last_modified_time'] = isset($data['last_modified_time']) ? $data['last_modified_time'] : null;
        $this->container['last_modified_user_id'] = isset($data['last_modified_user_id']) ? $data['last_modified_user_id'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = [];

        if ($this->container['create_time'] === null) {
            $invalid_properties[] = "'create_time' can't be null";
        }
        if ($this->container['create_user_id'] === null) {
            $invalid_properties[] = "'create_user_id' can't be null";
        }
        if ($this->container['last_modified_time'] === null) {
            $invalid_properties[] = "'last_modified_time' can't be null";
        }
        if ($this->container['last_modified_user_id'] === null) {
            $invalid_properties[] = "'last_modified_user_id' can't be null";
        }
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {

        if ($this->container['create_time'] === null) {
            return false;
        }
        if ($this->container['create_user_id'] === null) {
            return false;
        }
        if ($this->container['last_modified_time'] === null) {
            return false;
        }
        if ($this->container['last_modified_user_id'] === null) {
            return false;
        }
        return true;
    }


    /**
     * Gets create_time
     * @return \DateTime
     */
    public function getCreateTime()
    {
        return $this->container['create_time'];
    }

    /**
     * Sets create_time
     * @param \DateTime $create_time
     * @return $this
     */
    public function setCreateTime($create_time)
    {
        $this->container['create_time'] = $create_time;

        return $this;
    }

    /**
     * Gets create_user_id
     * @return string
     */
    public function getCreateUserId()
    {
        return $this->container['create_user_id'];
    }

    /**
     * Sets create_user_id
     * @param string $create_user_id
     * @return $this
     */
    public function setCreateUserId($create_user_id)
    {
        $this->container['create_user_id'] = $create_user_id;

        return $this;
    }

    /**
     * Gets last_modified_time
     * @return \DateTime
     */
    public function getLastModifiedTime()
    {
        return $this->container['last_modified_time'];
    }

    /**
     * Sets last_modified_time
     * @param \DateTime $last_modified_time
     * @return $this
     */
    public function setLastModifiedTime($last_modified_time)
    {
        $this->container['last_modified_time'] = $last_modified_time;

        return $this;
    }

    /**
     * Gets last_modified_user_id
     * @return string
     */
    public function getLastModifiedUserId()
    {
        return $this->container['last_modified_user_id'];
    }

    /**
     * Sets last_modified_user_id
     * @param string $last_modified_user_id
     * @return $this
     */
    public function setLastModifiedUserId($last_modified_user_id)
    {
        $this->container['last_modified_user_id'] = $last_modified_user_id;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\Autodesk\Forge\Client\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\Autodesk\Forge\Client\ObjectSerializer::sanitizeForSerialization($this));
    }
}


