<?php
/**
 * JobObjOutputPayloadAdvanced
 *
 * PHP version 5
 *
 * @category Class
 * @package  Autodesk\Forge\Client
 * @author   Swaagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * Forge SDK
 *
 * The Forge Platform contains an expanding collection of web service components that can be used with Autodesk cloud-based products or your own technologies. Take advantage of Autodesk’s expertise in design and engineering.
 *
 * OpenAPI spec version: 0.1.0
 * Contact: forge.help@autodesk.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace Autodesk\Forge\Client\Model;

use \ArrayAccess;

/**
 * JobObjOutputPayloadAdvanced Class Doc Comment
 *
 * @category    Class
 * @description Advanced options for &#x60;obj&#x60; type.
 * @package     Autodesk\Forge\Client
 * @author      Swagger Codegen team
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class JobObjOutputPayloadAdvanced implements ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
     * The original name of the model.
     * @var string
     */
    protected static $swaggerModelName = 'jobObjOutputPayload_advanced';

    /**
     * Array of property to type mappings. Used for (de)serialization
     * @var string[]
     */
    protected static $swaggerTypes = [
        'export_file_structure' => 'string',
        'model_guid' => 'string',
        'object_ids' => 'string[]',
    ];

    /**
     * @return \string[]
     */
    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = [
        'export_file_structure' => 'exportFileStructure',
        'model_guid' => 'modelGuid',
        'object_ids' => 'objectIds',
    ];


    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = [
        'export_file_structure' => 'setExportFileStructure',
        'model_guid' => 'setModelGuid',
        'object_ids' => 'setObjectIds',
    ];


    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = [
        'export_file_structure' => 'getExportFileStructure',
        'model_guid' => 'getModelGuid',
        'object_ids' => 'getObjectIds',
    ];

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    public static function setters()
    {
        return self::$setters;
    }

    public static function getters()
    {
        return self::$getters;
    }

    const EXPORT_FILE_STRUCTURE_SINGLE = 'single';
    const EXPORT_FILE_STRUCTURE_MULTIPLE = 'multiple';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getExportFileStructureAllowableValues()
    {
        return [
            self::EXPORT_FILE_STRUCTURE_SINGLE,
            self::EXPORT_FILE_STRUCTURE_MULTIPLE,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     * @param mixed[] $data Associated array of property values initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['export_file_structure'] = isset($data['export_file_structure']) ? $data['export_file_structure'] : 'single';
        $this->container['model_guid'] = isset($data['model_guid']) ? $data['model_guid'] : null;
        $this->container['object_ids'] = isset($data['object_ids']) ? $data['object_ids'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = [];

        $allowed_values = ["single", "multiple"];
        if (!in_array($this->container['export_file_structure'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'export_file_structure', must be one of 'single', 'multiple'.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {

        $allowed_values = ["single", "multiple"];
        if (!in_array($this->container['export_file_structure'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets export_file_structure
     * @return string
     */
    public function getExportFileStructure()
    {
        return $this->container['export_file_structure'];
    }

    /**
     * Sets export_file_structure
     * @param string $export_file_structure `single` (default): creates one OBJ file for all the input files (assembly file)  `multiple`: creates a separate OBJ file for each object
     * @return $this
     */
    public function setExportFileStructure($export_file_structure)
    {
        $allowed_values = array('single', 'multiple');
        if (!is_null($export_file_structure) && (!in_array($export_file_structure, $allowed_values))) {
            throw new \InvalidArgumentException("Invalid value for 'export_file_structure', must be one of 'single', 'multiple'");
        }
        $this->container['export_file_structure'] = $export_file_structure;

        return $this;
    }

    /**
     * Gets model_guid
     * @return string
     */
    public function getModelGuid()
    {
        return $this->container['model_guid'];
    }

    /**
     * Sets model_guid
     * @param string $model_guid Required for geometry extractions. The model view ID (guid).
     * @return $this
     */
    public function setModelGuid($model_guid)
    {
        $this->container['model_guid'] = $model_guid;

        return $this;
    }

    /**
     * Gets object_ids
     * @return string[]
     */
    public function getObjectIds()
    {
        return $this->container['object_ids'];
    }

    /**
     * Sets object_ids
     * @param string[] $object_ids Required for geometry extractions. List object ids to be translated. -1 will extract the entire model.
     * @return $this
     */
    public function setObjectIds($object_ids)
    {
        $this->container['object_ids'] = $object_ids;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\Autodesk\Forge\Client\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\Autodesk\Forge\Client\ObjectSerializer::sanitizeForSerialization($this));
    }
}


