<?php
/**
 * JobStepOutputPayloadAdvanced
 *
 * PHP version 5
 *
 * @category Class
 * @package  Autodesk\Forge\Client
 * @author   Swaagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * Forge SDK
 *
 * The Forge Platform contains an expanding collection of web service components that can be used with Autodesk cloud-based products or your own technologies. Take advantage of Autodesk’s expertise in design and engineering.
 *
 * OpenAPI spec version: 0.1.0
 * Contact: forge.help@autodesk.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace Autodesk\Forge\Client\Model;

use \ArrayAccess;

/**
 * JobStepOutputPayloadAdvanced Class Doc Comment
 *
 * @category    Class
 * @description Advanced options for &#x60;step&#x60; type.
 * @package     Autodesk\Forge\Client
 * @author      Swagger Codegen team
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class JobStepOutputPayloadAdvanced implements ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
     * The original name of the model.
     * @var string
     */
    protected static $swaggerModelName = 'jobStepOutputPayload_advanced';

    /**
     * Array of property to type mappings. Used for (de)serialization
     * @var string[]
     */
    protected static $swaggerTypes = [
        'application_protocol' => 'string',
        'tolerance' => 'float',
    ];

    /**
     * @return \string[]
     */
    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = [
        'application_protocol' => 'applicationProtocol',
        'tolerance' => 'tolerance',
    ];


    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = [
        'application_protocol' => 'setApplicationProtocol',
        'tolerance' => 'setTolerance',
    ];


    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = [
        'application_protocol' => 'getApplicationProtocol',
        'tolerance' => 'getTolerance',
    ];

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    public static function setters()
    {
        return self::$setters;
    }

    public static function getters()
    {
        return self::$getters;
    }

    const APPLICATION_PROTOCOL__203 = '203';
    const APPLICATION_PROTOCOL__214 = '214';
    const APPLICATION_PROTOCOL__242 = '242';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getApplicationProtocolAllowableValues()
    {
        return [
            self::APPLICATION_PROTOCOL__203,
            self::APPLICATION_PROTOCOL__214,
            self::APPLICATION_PROTOCOL__242,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     * @param mixed[] $data Associated array of property values initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['application_protocol'] = isset($data['application_protocol']) ? $data['application_protocol'] : '214';
        $this->container['tolerance'] = isset($data['tolerance']) ? $data['tolerance'] : 0.001;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = [];

        $allowed_values = ["203", "214", "242"];
        if (!in_array($this->container['application_protocol'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'application_protocol', must be one of '203', '214', '242'.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {

        $allowed_values = ["203", "214", "242"];
        if (!in_array($this->container['application_protocol'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets application_protocol
     * @return string
     */
    public function getApplicationProtocol()
    {
        return $this->container['application_protocol'];
    }

    /**
     * Sets application_protocol
     * @param string $application_protocol A STEP file can be generated with the following Application Protocols: `203` for configuration controlled design, `214` for core data for automotive mechanical design processes, `242` for managed model based 3D engineering. By default, `214` will be exported.
     * @return $this
     */
    public function setApplicationProtocol($application_protocol)
    {
        $allowed_values = array('203', '214', '242');
        if (!is_null($application_protocol) && (!in_array($application_protocol, $allowed_values))) {
            throw new \InvalidArgumentException("Invalid value for 'application_protocol', must be one of '203', '214', '242'");
        }
        $this->container['application_protocol'] = $application_protocol;

        return $this;
    }

    /**
     * Gets tolerance
     * @return float
     */
    public function getTolerance()
    {
        return $this->container['tolerance'];
    }

    /**
     * Sets tolerance
     * @param float $tolerance Possible values are between `0` and `1`. By default it is set at 0.001.
     * @return $this
     */
    public function setTolerance($tolerance)
    {
        $this->container['tolerance'] = $tolerance;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\Autodesk\Forge\Client\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\Autodesk\Forge\Client\ObjectSerializer::sanitizeForSerialization($this));
    }
}


