<?php

namespace WhichBrowser\Data;

use WhichBrowser\Constants\DeviceType;
use WhichBrowser\Constants\DeviceSubType;
use WhichBrowser\Constants\Flag;

DeviceModels::$ANDROID_MODELS = [

    /* Generic identifiers */
    'Android'                                   => [ null, null ],
    'google sdk'                                => [ null, null, DeviceType::EMULATOR ],
    'sdk'                                       => [ null, null, DeviceType::EMULATOR ],
    'generic'                                   => [ null, null ],
    'generic x86'                               => [ null, null ],
    'VirtualBox!'                               => [ null, null, DeviceType::EMULATOR ],

    /* Development boards and kits */
    'amd brazos'                                => [ 'AMD', 'Fusion based device', DeviceType::DEVBOARD ],
    'amd persimmon'                             => [ 'AMD', 'Persimmon based device', DeviceType::DEVBOARD ],
    'Amlogic M1 reference board'                => [ 'Amlogic', 'M1 reference board', DeviceType::DEVBOARD ],
    'AML8726M'                                  => [ 'Amlogic', 'AML8726-M based device', DeviceType::DEVBOARD ],
    'AMLOGIC8726MX'                             => [ 'Amlogic', 'AML8726-MX based device', DeviceType::DEVBOARD ],
    'vexpress a9'                               => [ 'ARM', 'Versatile Express development platform', DeviceType::DEVBOARD ],
    'sama5d3'                                   => [ 'Atmel', 'SAMA5D3 based device', DeviceType::DEVBOARD ],
    'BEAGLEBONE'                                => [ 'BeagleBoard', 'BeagleBone', DeviceType::DEVBOARD ],
    'BeagleBone Black'                          => [ 'BeagleBoard', 'BeagleBone Black', DeviceType::DEVBOARD ],
    'BEAGLEBONEBLACK'                           => [ 'BeagleBoard', 'BeagleBone Black', DeviceType::DEVBOARD ],
    'BEAGLEBONEBLACK.A5C'                       => [ 'BeagleBoard', 'BeagleBone Black', DeviceType::DEVBOARD ],
    'NITROGEN6X'                                => [ 'Boundary Devices', 'Nitrogen6X', DeviceType::DEVBOARD ],
    'bcm platform'                              => [ 'Broadcom', 'BCM based device', DeviceType::DEVBOARD ],
    'bcm7231'                                   => [ 'Broadcom', 'BCM7231 based device', DeviceType::DEVBOARD ],
    'bcm7425'                                   => [ 'Broadcom', 'BCM7425 based device', DeviceType::DEVBOARD ],
    'bcm7429'                                   => [ 'Broadcom', 'BCM7429 based device', DeviceType::DEVBOARD ],
    'bcm7435'                                   => [ 'Broadcom', 'BCM7435 based device', DeviceType::DEVBOARD ],
    'bcm7439'                                   => [ 'Broadcom', 'BCM7439 based device', DeviceType::DEVBOARD ],
    'bcm7445'                                   => [ 'Broadcom', 'BCM7445 based device', DeviceType::DEVBOARD ],
    'bcm7584'                                   => [ 'Broadcom', 'BCM7584 based device', DeviceType::DEVBOARD ],
    'BCM21654!'                                 => [ 'Broadcom', 'BCM21654 based device', DeviceType::DEVBOARD ],
    'BCM21664!'                                 => [ 'Broadcom', 'BCM21664 based device', DeviceType::DEVBOARD ],
    'BCM23550!'                                 => [ 'Broadcom', 'BCM23550 based device', DeviceType::DEVBOARD ],
    'BCM28145!'                                 => [ 'Broadcom', 'BCM28145 based device', DeviceType::DEVBOARD ],
    'BCM28155!'                                 => [ 'Broadcom', 'BCM28155 based device', DeviceType::DEVBOARD ],
    'imx50!'                                    => [ 'Freescale', 'i.MX50 based device', DeviceType::DEVBOARD ],
    'imx51!'                                    => [ 'Freescale', 'i.MX51 based device', DeviceType::DEVBOARD ],
    'imx53!'                                    => [ 'Freescale', 'i.MX53 based device', DeviceType::DEVBOARD ],
    'imx6q!'                                    => [ 'Freescale', 'i.MX6Q based device', DeviceType::DEVBOARD ],
    'SABRESD-MX6DQ'                             => [ 'Freescale', 'i.MX6DQ based device', DeviceType::DEVBOARD ],
    'odroida'                                   => [ 'Hardkernel', 'ODROID-A developer tablet', DeviceType::TABLET ],
    'ODROID-A'                                  => [ 'Hardkernel', 'ODROID-A developer tablet', DeviceType::TABLET ],
    'ODROIDC'                                   => [ 'Hardkernel', 'ODROID-C1 developer tablet', DeviceType::TABLET ],
    'ODROIDC2'                                  => [ 'Hardkernel', 'ODROID-C2 developer tablet', DeviceType::TABLET ],
    'ODROID-U'                                  => [ 'Hardkernel', 'ODROID-U developer board', DeviceType::DEVBOARD ],
    'ODROID-U2'                                 => [ 'Hardkernel', 'ODROID-U2 developer board', DeviceType::DEVBOARD ],
    'ODROID-X'                                  => [ 'Hardkernel', 'ODROID-X developer board', DeviceType::DEVBOARD ],
    'ODROID-XU'                                 => [ 'Hardkernel', 'ODROID-XU developer board', DeviceType::DEVBOARD ],
    'ODROID-XU3'                                => [ 'Hardkernel', 'ODROID-XU3 developer board', DeviceType::DEVBOARD ],
    'ODROID-XU3-ATV'                            => [ 'Hardkernel', 'ODROID-XU3 developer board', DeviceType::DEVBOARD ],
    'ODROID-XU4'                                => [ 'Hardkernel', 'ODROID-XU4 developer board', DeviceType::DEVBOARD ],
    'ODROID-X2'                                 => [ 'Hardkernel', 'ODROID-X2 developer board', DeviceType::DEVBOARD ],
    'Bay Trail Generic Platform'                => [ 'Intel', 'Bay Trail based device', DeviceType::DEVBOARD ],
    'Bayley Bay'                                => [ 'Intel', 'Bay Trail based device', DeviceType::DEVBOARD ],
    'cedartrail'                                => [ 'Intel', 'Cedar Trail based device', DeviceType::DEVBOARD ],
    'mfld (dv10|dv20|gi|lw00|pr2|pr3)!'         => [ 'Intel', 'Medfield based device', DeviceType::DEVBOARD ],
    'redhookbay'                                => [ 'Intel', 'Merrifield based device', DeviceType::DEVBOARD ],
    'saltbay'                                   => [ 'Intel', 'Merrifield based device', DeviceType::DEVBOARD ],
    'victoriabay'                               => [ 'Intel', 'Merrifield based device', DeviceType::DEVBOARD ],
    'Shark Bay Client platform'                 => [ 'Intel', 'Haswell based device', DeviceType::DEVBOARD ],
    'BP710A'                                    => [ 'Intel', 'Yukka Beach based device', DeviceType::DEVBOARD ],
    'yukkabeach'                                => [ 'Intel', 'Yukka Beach based device', DeviceType::DEVBOARD ],
    'berlin'                                    => [ 'Marvell', 'Armada based device', DeviceType::DEVBOARD ],
    'berlin bg2!'                               => [ 'Marvell', 'Armada based device', DeviceType::DEVBOARD ],
    'berlin generic!'                           => [ 'Marvell', 'Armada based device', DeviceType::DEVBOARD ],
    'bg2 !'                                     => [ 'Marvell', 'Armada based device', DeviceType::DEVBOARD ],
    'bg2ct !'                                   => [ 'Marvell', 'Armada based device', DeviceType::DEVBOARD ],
    'bg2q4k !'                                  => [ 'Marvell', 'Armada based device', DeviceType::DEVBOARD ],
    'bg2qa0v4 !'                                => [ 'Marvell', 'Armada based device', DeviceType::DEVBOARD ],
    'bg2qv4 !'                                  => [ 'Marvell', 'Armada based device', DeviceType::DEVBOARD ],
    'MStar Amber3'                              => [ 'MStar', 'Amber3 based device', DeviceType::DEVBOARD ],
    'Konka Amber3'                              => [ 'MStar', 'Amber3 based device', DeviceType::DEVBOARD ],
    'mt5396!'                                   => [ 'Mediatek', 'MT5396 based device', DeviceType::DEVBOARD ],
    'mt5399!'                                   => [ 'Mediatek', 'MT5399 based device', DeviceType::DEVBOARD ],
    'mt5861!'                                   => [ 'Mediatek', 'MT5861 based device', DeviceType::DEVBOARD ],
    'mt5880!'                                   => [ 'Mediatek', 'MT5880 based device', DeviceType::DEVBOARD ],
    'mt5882!'                                   => [ 'Mediatek', 'MT5882 based device', DeviceType::DEVBOARD ],
    'mt5890!'                                   => [ 'Mediatek', 'MT5890 based device', DeviceType::DEVBOARD ],
    'mt6515!'                                   => [ 'Mediatek', 'MT6515 based device', DeviceType::DEVBOARD ],
    'MTK6515'                                   => [ 'Mediatek', 'MT6515 based device', DeviceType::DEVBOARD ],
    'mt6517!'                                   => [ 'Mediatek', 'MT6517 based device', DeviceType::DEVBOARD ],
    'mt6571!'                                   => [ 'Mediatek', 'MT6571 based device', DeviceType::DEVBOARD ],
    'mt6572!'                                   => [ 'Mediatek', 'MT6572 based device', DeviceType::DEVBOARD ],
    'baoxue'                                    => [ 'Mediatek', 'MT6573 based device', DeviceType::DEVBOARD ],
    'bird75v2'                                  => [ 'Mediatek', 'MT6575 based device', DeviceType::DEVBOARD ],
    'eagle75v1 2'                               => [ 'Mediatek', 'MT6575 based device', DeviceType::DEVBOARD ],
    'mt6575!'                                   => [ 'Mediatek', 'MT6575 based device', DeviceType::DEVBOARD ],
    'mt6577!'                                   => [ 'Mediatek', 'MT6577 based device', DeviceType::DEVBOARD ],
    'mt6582!'                                   => [ 'Mediatek', 'MT6582 based device', DeviceType::DEVBOARD ],
    'mt6589!'                                   => [ 'Mediatek', 'MT6589 based device', DeviceType::DEVBOARD ],
    'MTK-MT6589'                                => [ 'Mediatek', 'MT6589 based device', DeviceType::DEVBOARD ],
    'MTK6589!'                                  => [ 'Mediatek', 'MT6589 based device', DeviceType::DEVBOARD ],
    'mt6592!'                                   => [ 'Mediatek', 'MT6592 based device', DeviceType::DEVBOARD ],
    'MTK-MT6592'                                => [ 'Mediatek', 'MT6592 based device', DeviceType::DEVBOARD ],
    'MTK6592'                                   => [ 'Mediatek', 'MT6592 based device', DeviceType::DEVBOARD ],
    'mt6595!'                                   => [ 'Mediatek', 'MT6595 based device', DeviceType::DEVBOARD ],
    'mt6599!'                                   => [ 'Mediatek', 'MT6599 based device', DeviceType::DEVBOARD ],
    'mt8125!'                                   => [ 'Mediatek', 'MT8125 based device', DeviceType::DEVBOARD ],
    'mt8127!'                                   => [ 'Mediatek', 'MT8127 based device', DeviceType::DEVBOARD ],
    'mt8135!'                                   => [ 'Mediatek', 'MT8135 based device', DeviceType::DEVBOARD ],
    'MTK--8312'                                 => [ 'Mediatek', 'MT8312 based device', DeviceType::DEVBOARD ],
    'mt8377!'                                   => [ 'Mediatek', 'MT8377 based device', DeviceType::DEVBOARD ],
    'mt8389!'                                   => [ 'Mediatek', 'MT8389 based device', DeviceType::DEVBOARD ],
    'mt8580!'                                   => [ 'Mediatek', 'MT8580 based device', DeviceType::DEVBOARD ],
    'mt8658!'                                   => [ 'Mediatek', 'MT8658 based device', DeviceType::DEVBOARD ],
    'MBX DVBT reference board (c03ref)'         => [ 'MBX', 'DVBT reference board', DeviceType::DEVBOARD ],
    'MBX Dongle board!'                         => [ 'MBX', 'Dongle board', DeviceType::DEVBOARD ],
    'MBX reference board!'                      => [ 'MBX', 'Reference board', DeviceType::DEVBOARD ],
    'NS115'                                     => [ 'Nufront', 'NuSmart 115 based device', DeviceType::DEVBOARD ],
    'NS2816'                                    => [ 'Nufront', 'NuSmart 2816 based device', DeviceType::DEVBOARD ],
    'Ventana'                                   => [ 'Nvidia', 'Tegra Ventana development kit', DeviceType::DEVBOARD ],
    'Cardhu'                                    => [ 'Nvidia', 'Tegra 3 based device', DeviceType::DEVBOARD ],
    'Panda(Board)?!'                            => [ 'Pandaboard', 'Development Kit', DeviceType::DEVBOARD ],
    'Omap5panda'                                => [ 'Pandaboard', 'Development Kit', DeviceType::DEVBOARD ],
    'MSM'                                       => [ 'Qualcomm', 'Snapdragon based device', DeviceType::DEVBOARD ],
    'msm(7227|7627)!'                           => [ 'Qualcomm', 'Snapdragon S1 based device', DeviceType::DEVBOARD ],
    'msm7630!'                                  => [ 'Qualcomm', 'Snapdragon S2 based device', DeviceType::DEVBOARD ],
    'msm8660!'                                  => [ 'Qualcomm', 'Snapdragon S3 based device', DeviceType::DEVBOARD ],
    'msm(8x25|8625|8960)!'                      => [ 'Qualcomm', 'Snapdragon S4 based device', DeviceType::DEVBOARD ],
    'msm8x30!'                                  => [ 'Qualcomm', 'Snapdragon S4 Plus based device', DeviceType::DEVBOARD ],
    'msm8610!'                                  => [ 'Qualcomm', 'Snapdragon 200 based device', DeviceType::DEVBOARD ],
    'msm8909!'                                  => [ 'Qualcomm', 'Snapdragon 210 based device', DeviceType::DEVBOARD ],
    'msm(8226|8228)!'                           => [ 'Qualcomm', 'Snapdragon 400 based device', DeviceType::DEVBOARD ],
    'MSM8926!'                                  => [ 'Qualcomm', 'Snapdragon 400 based device', DeviceType::DEVBOARD ],
    'msm8916!'                                  => [ 'Qualcomm', 'Snapdragon 410 based device', DeviceType::DEVBOARD ],
    'msm8952!'                                  => [ 'Qualcomm', 'Snapdragon 615 based device', DeviceType::DEVBOARD ],
    'msm8974!'                                  => [ 'Qualcomm', 'Snapdragon 800 based device', DeviceType::DEVBOARD ],
    'MSM8992!'                                  => [ 'Qualcomm', 'Snapdragon 808 based device', DeviceType::DEVBOARD ],
    'msm8994!'                                  => [ 'Qualcomm', 'Snapdragon 810 based device', DeviceType::DEVBOARD ],
    'rksdk'                                     => [ 'Rockchip', 'based device', DeviceType::DEVBOARD ],
    'rk2808(sdk)?!'                             => [ 'Rockchip', 'RK2808 based device', DeviceType::DEVBOARD ],
    'rk2818(sdk)?!'                             => [ 'Rockchip', 'RK2818 based device', DeviceType::DEVBOARD ],
    'Android-for-Rockchip-2818'                 => [ 'Rockchip', 'RK2818 based device', DeviceType::DEVBOARD ],
    'RK2906'                                    => [ 'Rockchip', 'RK2906 based device', DeviceType::DEVBOARD ],
    'RK2918'                                    => [ 'Rockchip', 'RK2918 based device', DeviceType::DEVBOARD ],
    'rk2926-q8'                                 => [ 'Rockchip', 'RK2926 based device', DeviceType::DEVBOARD ],
    'rk2928sdk'                                 => [ 'Rockchip', 'RK2928 based device', DeviceType::DEVBOARD ],
    'rk29sdk'                                   => [ 'Rockchip', 'RK29 based device', DeviceType::DEVBOARD ],
    'rk30sdk!'                                  => [ 'Rockchip', 'RK30 based device', DeviceType::DEVBOARD ],
    'rk30mtk'                                   => [ 'Rockchip', 'RK30 based device', DeviceType::DEVBOARD ],
    'rk3026'                                    => [ 'Rockchip', 'RK3026 based device', DeviceType::DEVBOARD ],
    'rk3028a'                                   => [ 'Rockchip', 'RK3028 based device', DeviceType::DEVBOARD ],
    'rk3028sdk'                                 => [ 'Rockchip', 'RK3028 based device', DeviceType::DEVBOARD ],
    'rk3036'                                    => [ 'Rockchip', 'RK3036 based device', DeviceType::DEVBOARD ],
    'rk3066'                                    => [ 'Rockchip', 'RK3066 based device', DeviceType::DEVBOARD ],
    'rk31sdk'                                   => [ 'Rockchip', 'RK31 based device', DeviceType::DEVBOARD ],
    'rk31 5931'                                 => [ 'Rockchip', 'RK31 based device', DeviceType::DEVBOARD ],
    'rk31 8089'                                 => [ 'Rockchip', 'RK31 based device', DeviceType::DEVBOARD ],
    'rk31 872xu'                                => [ 'Rockchip', 'RK31 based device', DeviceType::DEVBOARD ],
    'rk31au'                                    => [ 'Rockchip', 'RK31 based device', DeviceType::DEVBOARD ],
    'rk31rtl'                                   => [ 'Rockchip', 'RK31 based device', DeviceType::DEVBOARD ],
    'rk312x'                                    => [ 'Rockchip', 'RK312X based device', DeviceType::DEVBOARD ],
    'rk3188!'                                   => [ 'Rockchip', 'RK3188 based device', DeviceType::DEVBOARD ],
    'rk3288!'                                   => [ 'Rockchip', 'RK3288 based device', DeviceType::DEVBOARD ],
    'rk3990!'                                   => [ 'Rockchip', 'RK3990 based device', DeviceType::DEVBOARD ],
    's3c6410'                                   => [ 'Samsung', 'S3C6410 based device', DeviceType::DEVBOARD ],
    'smdk6410'                                  => [ 'Samsung', 'S3C6410 based device', DeviceType::DEVBOARD ],
    'SMDKC110'                                  => [ 'Samsung', 'Exynos 3110 based device', DeviceType::DEVBOARD ],
    'SMDKV210'                                  => [ 'Samsung', 'Exynos 4210 based device', DeviceType::DEVBOARD ],
    'S5PV210'                                   => [ 'Samsung', 'Exynos 4210 based device', DeviceType::DEVBOARD ],
    'sec smdkc210'                              => [ 'Samsung', 'Exynos 4210 based device', DeviceType::DEVBOARD ],
    'sec smdkv210'                              => [ 'Samsung', 'Exynos 4210 based device', DeviceType::DEVBOARD ],
    'SMDK4x12'                                  => [ 'Samsung', 'Exynos 4212 or 4412 based device', DeviceType::DEVBOARD ],
    'SMDK4412'                                  => [ 'Samsung', 'Exynos 4412 based device', DeviceType::DEVBOARD ],
    'SMDK5250'                                  => [ 'Samsung', 'Exynos 5250 based device', DeviceType::DEVBOARD ],
    'SMDK5410'                                  => [ 'Samsung', 'Exynos 5410 based device', DeviceType::DEVBOARD ],
    'Exynos5410'                                => [ 'Samsung', 'Exynos 5410 based device', DeviceType::DEVBOARD ],
    'smp86xx'                                   => [ 'Sigma', 'SMP86xx based device', DeviceType::DEVBOARD ],
    'smp8734'                                   => [ 'Sigma', 'SMP8734 based device', DeviceType::DEVBOARD ],
    'smp8756'                                   => [ 'Sigma', 'SMP8756 based device', DeviceType::DEVBOARD ],
    'sv8860'                                    => [ 'Skyviia', 'SV8860 based device', DeviceType::DEVBOARD ],
    'ste l8540!'                                => [ 'ST Ericsson', 'Novathor L8540 based device', DeviceType::DEVBOARD ],
    'ste u8500'                                 => [ 'ST Ericsson', 'Novathor U8500 based device', DeviceType::DEVBOARD ],
    'ste u9540'                                 => [ 'ST Ericsson', 'Novathor U9540 based device', DeviceType::DEVBOARD ],
    'Telechips M801 Evaluation Board'           => [ 'Telechips', 'M801 based device', DeviceType::DEVBOARD ],
    'Telechips TCC8800 eMMC Evaluation Board'   => [ 'Telechips', 'TCC8800 based device', DeviceType::DEVBOARD ],
    'Telechips TCC8800 Evaluation Board'        => [ 'Telechips', 'TCC8800 based device', DeviceType::DEVBOARD ],
    'Telechips TCC8900 Evaluation Board'        => [ 'Telechips', 'TCC8900 based device', DeviceType::DEVBOARD ],
    'Telechips TCC8900 Evaluation Board (US)'   => [ 'Telechips', 'TCC8900 based device', DeviceType::DEVBOARD ],
    'Telechips TCC8902 Tablet-PC (DE)'          => [ 'Telechips', 'TCC8902 based device', DeviceType::DEVBOARD ],
    'TCC8920 STB!'                              => [ 'Telechips', 'TCC8920 based device', DeviceType::DEVBOARD ],
    'TCC893X!'                                  => [ 'Telechips', 'TCC893X based device', DeviceType::DEVBOARD ],
    'TCC8935 HDMI!'                             => [ 'Telechips', 'TCC8935 based device', DeviceType::DEVBOARD ],
    'TCC8975 STB!'                              => [ 'Telechips', 'TCC8975 based device', DeviceType::DEVBOARD ],
    'Telechips TCC9300 Evaluation Board'        => [ 'Telechips', 'TCC9300 based device', DeviceType::DEVBOARD ],
    'OMAP'                                      => [ 'Texas Instruments', 'OMAP based device', DeviceType::DEVBOARD ],
    'OMAP SS'                                   => [ 'Texas Instruments', 'OMAP based device', DeviceType::DEVBOARD ],
    'LogicPD Zoom2'                             => [ 'Texas Instruments', 'OMAP based device', DeviceType::DEVBOARD ],
    'omap3evm'                                  => [ 'Texas Instruments', 'OMAP3 based device', DeviceType::DEVBOARD ],
    'OMAP3ETPP'                                 => [ 'Texas Instruments', 'OMAP3 based device', DeviceType::DEVBOARD ],
    'Omap5sevm'                                 => [ 'Texas Instruments', 'OMAP5 based device', DeviceType::DEVBOARD ],
    'AM335XEVM'                                 => [ 'Texas Instruments', 'Sitara AM335 based device', DeviceType::DEVBOARD ],
    'AM335XEVM SK'                              => [ 'Texas Instruments', 'Sitara AM335 based device', DeviceType::DEVBOARD ],
    'am3517evm'                                 => [ 'Texas Instruments', 'Sitara AM351 based device', DeviceType::DEVBOARD ],
    'AM437XEVM'                                 => [ 'Texas Instruments', 'Sitara AM437 based device', DeviceType::DEVBOARD ],
    'Colibri-T20'                               => [ 'Toradex', 'Colibri T20', DeviceType::DEVBOARD ],
    'pnx8473 kiryung'                           => [ 'Trident', 'PNX8473 based device', DeviceType::DEVBOARD ],

    /* Official Google development devices */
    'Bravo'                                     => [ 'HTC', 'Desire' ],
    'Dream'                                     => [ 'HTC', 'Dream' ],
    'Vogue'                                     => [ 'HTC', 'Touch' ],
    'Vendor Optimus'                            => [ 'LG', 'Optimus' ],
    'Stingray'                                  => [ 'Motorola', 'XOOM', DeviceType::TABLET ],
    'Wingray'                                   => [ 'Motorola', 'XOOM', DeviceType::TABLET ],
    'Blaze'                                     => [ 'Texas Instruments', 'Blaze Tablet', DeviceType::TABLET ],
    'Blaze Tablet'                              => [ 'Texas Instruments', 'Blaze Tablet', DeviceType::TABLET ],
    'Google Ion'                                => [ 'Google', 'Ion' ],
    'Project Tango Tablet Development Kit'      => [ 'Google', 'Project Tango' ],
    'Yellowstone'                               => [ 'Google', 'Project Tango' ],

    /* Nexus Devices (without official model no. */
    'Passion'                                   => [ 'HTC', 'Nexus One' ],
    '(HTC )?Nexus ?One!'                        => [ 'HTC', 'Nexus One' ],
    'Crespo!'                                   => [ 'Samsung', 'Nexus S' ],
    '(Google )?Nexus S!'                        => [ 'Samsung', 'Nexus S' ],
    'Dooderbutt!'                               => [ 'Samsung', 'Nexus S' ],
    'LGE-lap crespo'                            => [ 'Samsung', 'Nexus S' ],
    'Maguro'                                    => [ 'Samsung', 'Galaxy Nexus' ],
    'Toro'                                      => [ 'Samsung', 'Galaxy Nexus' ],
    'Toro-VZW'                                  => [ 'Samsung', 'Galaxy Nexus' ],
    '(Google )?Galaxy Nexus!'                   => [ 'Samsung', 'Galaxy Nexus' ],
    'LGE-lap maguro'                            => [ 'Samsung', 'Galaxy Nexus' ],
    'LGE-maguro cappuccino'                     => [ 'Samsung', 'Galaxy Nexus' ],
    '(Google )?Nexus ?4!'                       => [ 'LG', 'Nexus 4' ],
    'Mako'                                      => [ 'LG', 'Nexus 4' ],
    'LGE-lap mako'                              => [ 'LG', 'Nexus 4' ],
    'Nexus 5X'                                  => [ 'LG', 'Nexus 5X' ],
    '(Google )?Nexus ?5!'                       => [ 'LG', 'Nexus 5' ],
    'HammerHead'                                => [ 'LG', 'Nexus 5' ],
    'LG-Nexus5'                                 => [ 'LG', 'Nexus 5' ],
    'Nexus 6P'                                  => [ 'Huawei', 'Nexus 6P' ],
    '(Google )?Nexus ?6P!'                      => [ 'Huawei', 'Nexus 6P' ],
    'shamu'                                     => [ 'Motorola', 'Nexus 6' ],
    '(Google )?Nexus ?6!'                       => [ 'Motorola', 'Nexus 6' ],
    '(Google )?Nexus ?7 2013!'                  => [ 'Asus', 'Nexus 7 (2013)', DeviceType::TABLET ],
    'Flo'                                       => [ 'Asus', 'Nexus 7 (2013)', DeviceType::TABLET ],
    'Grouper'                                   => [ 'Asus', 'Nexus 7', DeviceType::TABLET ],
    'Tilapia'                                   => [ 'Asus', 'Nexus 7', DeviceType::TABLET ],
    '(Google )?Nexus ?7!'                       => [ 'Asus', 'Nexus 7', DeviceType::TABLET ],
    'Flounder'                                  => [ 'HTC', 'Nexus 9', DeviceType::TABLET ],
    'Volantis'                                  => [ 'HTC', 'Nexus 9', DeviceType::TABLET ],
    'Volantisg'                                 => [ 'HTC', 'Nexus 9', DeviceType::TABLET ],
    '(Google )?Nexus ?9!'                       => [ 'HTC', 'Nexus 9', DeviceType::TABLET ],
    'manta'                                     => [ 'Samsung', 'Nexus 10', DeviceType::TABLET ],
    '(Google )?Nexus ?10!'                      => [ 'Samsung', 'Nexus 10', DeviceType::TABLET ],

    /* Pixel Devices */
    'Pixel C'                                   => [ 'Google', 'Pixel C', DeviceType::TABLET ],
    'Pixel'                                     => [ 'Google', 'Pixel' ],
    'Google Pixel'                              => [ 'Google', 'Pixel' ],
    'Pixel XL'                                  => [ 'Google', 'Pixel XL' ],
    'Google Pixel XL'                           => [ 'Google', 'Pixel XL' ],
    'Pixel 2'                                   => [ 'Google', 'Pixel 2' ],
    'Google Pixel 2'                            => [ 'Google', 'Pixel 2' ],
    'Pixel 2XL'                                 => [ 'Google', 'Pixel 2 XL' ],
    'Pixel 2 XL'                                => [ 'Google', 'Pixel 2 XL' ],
    'Google Pixel 2XL'                          => [ 'Google', 'Pixel 2 XL' ],

    'Google Chromebook Pixel (2015)'            => [ 'Google', 'Chromebook Pixel (2015)', DeviceType::DESKTOP ],

    /* Google Edition */
    'HTC One'                                   => [ 'HTC', 'One (Google Edition)' ],
    'Moto E'                                    => [ 'Motorola', 'Moto E (Google Edition)' ],
    'Moto G'                                    => [ 'Motorola', 'Moto G (Google Edition)' ],
    'Moto G LTE'                                => [ 'Motorola', 'Moto G (Google Edition)' ],
    'Moto G 2014'                               => [ 'Motorola', 'Moto G (Google Edition, 2014)' ],
    'Moto G 2014 LTE'                           => [ 'Motorola', 'Moto G (Google Edition, 2014)' ],
    'Moto G (2014)'                             => [ 'Motorola', 'Moto G (Google Edition, 2014)' ],
    'Moto X'                                    => [ 'Motorola', 'Moto X (Google Edition)' ],
    'GT-I9505G'                                 => [ 'Samsung', 'Galaxy S4 (Google Edition)' ],
    'Galaxy S4 Google Editon'                   => [ 'Samsung', 'Galaxy S4 (Google Edition)' ],
    'SM-G900FG'                                 => [ 'Samsung', 'Galaxy S5 (Google Edition)' ],
    'Xperia Z Ultra'                            => [ 'Sony', 'Xperia Z Ultra (Google Edition)' ],

    /* Google Glass */
    'Glass 1'                                   => [ 'Google', 'Glass', DeviceType::HEADSET, Flag::GOOGLEGLASS ],

    /* Android Wear */
    'ZenWatch'                                  => [ 'Asus', 'ZenWatch', DeviceType::WATCH, Flag::ANDROIDWEAR ],
    'ZenWatch 2'                                => [ 'Asus', 'ZenWatch 2', DeviceType::WATCH, Flag::ANDROIDWEAR ],
    'HUAWEI WATCH'                              => [ 'Huawei', 'Watch', DeviceType::WATCH, Flag::ANDROIDWEAR ],
    'G Watch'                                   => [ 'LG', 'G Watch', DeviceType::WATCH, Flag::ANDROIDWEAR ],
    'G Watch R'                                 => [ 'LG', 'G Watch R', DeviceType::WATCH, Flag::ANDROIDWEAR ],
    'LG-Watch Urbane'                           => [ 'LG', 'G Watch Urbane', DeviceType::WATCH, Flag::ANDROIDWEAR ],
    'Moto 360'                                  => [ 'Motorola', 'Moto 360', DeviceType::WATCH, Flag::ANDROIDWEAR ],
    'Gear Live'                                 => [ 'Samsung', 'Gear Live', DeviceType::WATCH, Flag::ANDROIDWEAR ],
    'SmartWatch 3'                              => [ 'Sony', 'SmartWatch 3', DeviceType::WATCH, Flag::ANDROIDWEAR ],

    /* Android TV */
    'Nexus Player'                              => [ 'Asus', 'Nexus Player', DeviceType::TELEVISION, Flag::ANDROIDTV],
    'SVP-DTV15'                                 => [ 'Sony', 'Bravia Android TV (2015)', DeviceType::TELEVISION, Flag::ANDROIDTV],
    'BRAVIA 2015'                               => [ 'Sony', 'Bravia Android TV (2015)', DeviceType::TELEVISION, Flag::ANDROIDTV],
    'BRAVIA 4K 2015'                            => [ 'Sony', 'Bravia Android TV (2015)', DeviceType::TELEVISION, Flag::ANDROIDTV ],
    'BRAVIA 4K GB'                              => [ 'Sony', 'Bravia Android TV (2016)', DeviceType::TELEVISION, Flag::ANDROIDTV ],
    'QV151E'                                    => [ 'Philips', 'Android TV (2015)', DeviceType::TELEVISION, Flag::ANDROIDTV],
    'QM151E'                                    => [ 'Philips', 'Android TV (2015)', DeviceType::TELEVISION, Flag::ANDROIDTV],
    'QM152E'                                    => [ 'Philips', 'Android TV (2015)', DeviceType::TELEVISION, Flag::ANDROIDTV],
    'QM163E'                                    => [ 'Philips', 'Android TV (2016)', DeviceType::TELEVISION, Flag::ANDROIDTV],
    'PH7M EU 5596'                              => [ 'Philips', 'Android TV (2016)', DeviceType::TELEVISION, Flag::ANDROIDTV],
    'SHIELD Console'                            => [ 'Nvidia', 'SHIELD Android TV', DeviceType::TELEVISION, Flag::ANDROIDTV],
    'SHIELD Android TV'                         => [ 'Nvidia', 'SHIELD Android TV', DeviceType::TELEVISION, Flag::ANDROIDTV],
    'SHIELD Andr0id TV'                         => [ 'Nvidia', 'SHIELD Android TV', DeviceType::TELEVISION, Flag::ANDROIDTV],

    /* Middleware and emulators */
    'BlueStacks!'                               => [ 'BlueStacks', 'App Player', DeviceType::DESKTOP ],
    'App Runtime for Chrome'                    => [ 'Google', 'App Runtime for Chrome', DeviceType::DESKTOP ],
    'youwave custom'                            => [ 'Youwave', 'Android on PC', DeviceType::DESKTOP ],
    'BlackBerry Runtime for Android Apps'       => [ 'RIM', 'BlackBerry (Android Runtime)', DeviceType::MOBILE ],
    'alien jolla bionic'                        => [ 'Jolla', 'Sailfish (Android Runtime)', DeviceType::MOBILE ],
    'Jolla'                                     => [ 'Jolla', 'Sailfish (Android Runtime)', DeviceType::MOBILE ],
    'alien ubuntu qt'                           => [ 'Ubuntu', 'Touch (Android Runtime)', DeviceType::MOBILE ],
    'full Android on Microsoft Windows, pad, pc, n*books' => [ 'SocketeQ', 'WindowsAndroid', DeviceType::DESKTOP ],
    'VMware Virtual Platform'                   => [ 'VMWare', 'Virtual Platform', DeviceType::DESKTOP ],
    'Xamarin Android Player!'                   => [ 'Xamarin', 'Android Player', DeviceType::EMULATOR ],

    /* TV sticks */
    'CX-919'                                    => [ null, 'CX-919', DeviceType::TELEVISION ],
    'CX-921'                                    => [ null, 'CX-921', DeviceType::TELEVISION ],
    'CX-921B'                                   => [ null, 'CX-921B', DeviceType::TELEVISION ],
    'CX-929'                                    => [ null, 'CX-929', DeviceType::TELEVISION ],
    'CX-950'                                    => [ null, 'CX-950', DeviceType::TELEVISION ],
    'CX-958'                                    => [ null, 'CX-958', DeviceType::TELEVISION ],
    'VEOLO'                                     => [ 'A.C. Ryan', 'VEOLO Smart Android Hub', DeviceType::TELEVISION ],
    'VEOLO2'                                    => [ 'A.C. Ryan', 'VEOLO2 Smart Android Hub', DeviceType::TELEVISION ],
    'Astone A108'                               => [ 'Astone', 'A108', DeviceType::TELEVISION ],
    'BenQ JD-130'                               => [ 'BenQ', 'JD-130', DeviceType::TELEVISION ],
    'BenQ Android TV'                           => [ 'BenQ', 'JD-130', DeviceType::TELEVISION ],
    'EVOKE HDI Box'                             => [ 'Evoke', 'HDI TV Box', DeviceType::TELEVISION ],
    'Ezcast'                                    => [ 'Ezcast', 'Dongle', DeviceType::TELEVISION ],
    'JT SmartPC02'                              => [ 'Joy-IT', 'Smart PC', DeviceType::TELEVISION ],
    'M3 Enjoy TV Box'                           => [ 'Geniatech', 'Enjoy TV', DeviceType::TELEVISION ],
    'MX Enjoy TV BOX'                           => [ 'Geniatech', 'Enjoy TV', DeviceType::TELEVISION ],
    'TOUCAN Stick HD'                           => [ 'iconBit', 'Toucan Stick HD', DeviceType::TELEVISION ],
    'TOUCAN Stick G4'                           => [ 'iconBit', 'Toucan Stick G4', DeviceType::TELEVISION ],
    'Toucan Stick 4K'                           => [ 'iconBit', 'Toucan Stick 4K', DeviceType::TELEVISION ],
    'TOUCAN Stick 3D mk2'                       => [ 'iconBit', 'Toucan Stick 3D', DeviceType::TELEVISION ],
    'TOUCAN Stick 3D Pro'                       => [ 'iconBit', 'Toucan Stick 3D Pro', DeviceType::TELEVISION ],
    'NEO-G4'                                    => [ 'Minix', 'Neo G4', DeviceType::TELEVISION ],
    'NEO-G4-108A'                               => [ 'Minix', 'Neo G4', DeviceType::TELEVISION ],
    'NEO-G4 a'                                  => [ 'Minix', 'Neo G4 a', DeviceType::TELEVISION ],
    'NEO-U9-H'                                  => [ 'Minix', 'Neo U9-H', DeviceType::TELEVISION ],
    'NEO-X5'                                    => [ 'Minix', 'Neo X5', DeviceType::TELEVISION ],
    'NEO X5'                                    => [ 'Minix', 'Neo X5', DeviceType::TELEVISION ],
    'Neo-X5-B'                                  => [ 'Minix', 'Neo X5', DeviceType::TELEVISION ],
    'NEO-X5-116A'                               => [ 'Minix', 'Neo X5', DeviceType::TELEVISION ],
    'NEO-X5-mini'                               => [ 'Minix', 'Neo X5 mini', DeviceType::TELEVISION ],
    'NEO X5 mini'                               => [ 'Minix', 'Neo X5 mini', DeviceType::TELEVISION ],
    'NEO-X6'                                    => [ 'Minix', 'Neo X6', DeviceType::TELEVISION ],
    'NEO-X7-216A'                               => [ 'Minix', 'Neo X7', DeviceType::TELEVISION ],
    'NEO-X7-mini'                               => [ 'Minix', 'Neo X7 mini', DeviceType::TELEVISION ],
    'NEO-X8'                                    => [ 'Minix', 'Neo X8', DeviceType::TELEVISION ],
    'NEO-X8-H'                                  => [ 'Minix', 'Neo X8', DeviceType::TELEVISION ],
    'NEO-X8H-PLUS'                              => [ 'Minix', 'Neo X8+', DeviceType::TELEVISION ],
    'RKM MK602'                                 => [ 'Rikomagic', 'MK602', DeviceType::TELEVISION ],
    'Rikomagic MK802'                           => [ 'Rikomagic', 'MK802', DeviceType::TELEVISION ],
    'Rikomagic MK802 ?II!'                      => [ 'Rikomagic', 'MK802 II', DeviceType::TELEVISION ],
    'Rikomagic MK802III'                        => [ 'Rikomagic', 'MK802 III', DeviceType::TELEVISION ],
    'Rikomagic MK802IIIS'                       => [ 'Rikomagic', 'MK802 IIIS', DeviceType::TELEVISION ],
    'RKM MK802IIIS'                             => [ 'Rikomagic', 'MK802 IIIS', DeviceType::TELEVISION ],
    'RKM MK802IV'                               => [ 'Rikomagic', 'MK802 IV', DeviceType::TELEVISION ],
    'MK808'                                     => [ 'Rikomagic', 'MK808', DeviceType::TELEVISION ],
    'MK808B'                                    => [ 'Rikomagic', 'MK808 B', DeviceType::TELEVISION ],
    'MK809'                                     => [ 'Rikomagic', 'MK809', DeviceType::TELEVISION ],
    'MK809B'                                    => [ 'Rikomagic', 'MK809 B', DeviceType::TELEVISION ],
    'MK809IV'                                   => [ 'Rikomagic', 'MK809 IV', DeviceType::TELEVISION ],
    'MK818B'                                    => [ 'Rikomagic', 'MK818 B', DeviceType::TELEVISION ],
    'RKM MK902'                                 => [ 'Rikomagic', 'MK902', DeviceType::TELEVISION ],
    'RKM MK902II'                               => [ 'Rikomagic', 'MK902 II', DeviceType::TELEVISION ],
    'MK908'                                     => [ 'Rikomagic', 'MK908', DeviceType::TELEVISION ],
    'MK908II'                                   => [ 'Rikomagic', 'MK908 II', DeviceType::TELEVISION ],
    'GK802'                                     => [ 'Rikomagic', 'GK802', DeviceType::TELEVISION ],
    'XW-I8'                                     => [ 'Sambao', 'XW-I8', DeviceType::TELEVISION ],
    'TCC8920 EVM'                               => [ 'Telechips', 'TCC8920', DeviceType::TELEVISION ],
    'TCC8925 HDMI DONGLE'                       => [ 'Telechips', 'TCC8925', DeviceType::TELEVISION ],
    'TCC8930 STB EV'                            => [ 'Telechips', 'TCC8930', DeviceType::TELEVISION ],
    'TCC8930 STB1'                              => [ 'Telechips', 'TCC8930', DeviceType::TELEVISION ],
    'TCC8935 HDMI DONGLE'                       => [ 'Telechips', 'TCC8935', DeviceType::TELEVISION ],

    /* Game consoles */
    'OUYA( Console)?!'                          => [ 'OUYA', 'OUYA', [ DeviceType::GAMING, DeviceSubType::CONSOLE ] ],
    'SHIELD'                                    => [ 'Nvidia', 'SHIELD', [ DeviceType::GAMING, DeviceSubType::CONSOLE ] ],
    'shieldtablet'                              => [ 'Nvidia', 'SHIELD Tablet', [ DeviceType::GAMING, DeviceSubType::PORTABLE ] ],
    'SHIELD Tablet'                             => [ 'Nvidia', 'SHIELD Tablet', [ DeviceType::GAMING, DeviceSubType::PORTABLE ] ],
    'SHIELD Tablet K1'                          => [ 'Nvidia', 'SHIELD Tablet K1', [ DeviceType::GAMING, DeviceSubType::PORTABLE ] ],
    'SHIELD Tablet X1'                          => [ 'Nvidia', 'SHIELD Tablet X1', [ DeviceType::GAMING, DeviceSubType::PORTABLE ] ],
    'SHIELD Tablet II'                          => [ 'Nvidia', 'SHIELD Tablet II', [ DeviceType::GAMING, DeviceSubType::PORTABLE ] ],

    'EMBT3C'                                    => [ 'EPSON', 'MOVERIO BT-300', DeviceType::HEADSET ],

    /* Regular devices */
    'EL72B'                                     => [ '3Q', 'Qoo! Q-Book EL72B', DeviceType::TABLET ],

    '(AC|BC|LC|MT|RC|QS|VM|TS|OC)[0-9]{4,4}[A-Z]!!' => [
        'AC0731B'                                   => [ '3Q', 'Qoo! Q-Pad AC0731B', DeviceType::TABLET ],
        'AC1024C'                                   => [ '3Q', 'Qoo! Q-Pad AC1024C', DeviceType::TABLET ],
        'AC7803C'                                   => [ '3Q', 'Qoo! Q-Pad AC7803C', DeviceType::TABLET ],
        'BC9710A'                                   => [ '3Q', 'Qoo! Q-Pad BC9710A', DeviceType::TABLET ],
        'BC9710AM'                                  => [ '3Q', 'Qoo! Q-Pad BC9710A', DeviceType::TABLET ],
        'LC0720C'                                   => [ '3Q', 'Qoo! Q-Pad LC0720C', DeviceType::TABLET ],
        'LC0723B'                                   => [ '3Q', 'Qoo! Q-Pad LC0723B', DeviceType::TABLET ],
        'LC0725B'                                   => [ '3Q', 'Qoo! Q-Pad LC0725B', DeviceType::TABLET ],
        'LC0804B'                                   => [ '3Q', 'Qoo! Q-Pad LC0804B', DeviceType::TABLET ],
        'LC0808B'                                   => [ '3Q', 'Qoo! Q-Pad LC0808B', DeviceType::TABLET ],
        'LC0809B'                                   => [ '3Q', 'Qoo! Q-Pad LC0809B', DeviceType::TABLET ],
        'LC0810C'                                   => [ '3Q', 'Qoo! Q-Pad LC0810C', DeviceType::TABLET ],
        'LC0816C'                                   => [ '3Q', 'Qoo! Q-Pad LC0816C', DeviceType::TABLET ],
        'LC0901D'                                   => [ '3Q', 'Qoo! Q-Pad LC0901D', DeviceType::TABLET ],
        'LC1016C'                                   => [ '3Q', 'Qoo! Q-Pad LC1016C', DeviceType::TABLET ],
        'LC9721C'                                   => [ '3Q', 'Qoo! Q-Pad LC9721C', DeviceType::TABLET ],
        'MT0724B'                                   => [ '3Q', 'Qoo! Q-Pad MT0724B', DeviceType::TABLET ],
        'MT0729B'                                   => [ '3Q', 'Qoo! Q-Pad MT0729B', DeviceType::TABLET ],
        'MT0729D'                                   => [ '3Q', 'Qoo! Q-Pad MT0729D', DeviceType::TABLET ],
        'MT0811B'                                   => [ '3Q', 'Qoo! Q-Pad MT0811B', DeviceType::TABLET ],
        'MT7801C'                                   => [ '3Q', 'Qoo! Q-Pad MT7801C', DeviceType::TABLET ],
        'RC0709B'                                   => [ '3Q', 'Qoo! Q-Pad RC0709B', DeviceType::TABLET ],
        'RC0710B'                                   => [ '3Q', 'Qoo! Q-Pad RC0710B', DeviceType::TABLET ],
        'RC0718C'                                   => [ '3Q', 'Qoo! Q-Pad RC0718C', DeviceType::TABLET ],
        'RC0719H'                                   => [ '3Q', 'Qoo! Q-Pad RC0719H', DeviceType::TABLET ],
        'RC0721B'                                   => [ '3Q', 'Qoo! Q-Pad RC0721B', DeviceType::TABLET ],
        'RC0722C'                                   => [ '3Q', 'Qoo! Q-Pad RC0722C', DeviceType::TABLET ],
        'RC0726B'                                   => [ '3Q', 'Qoo! Q-Pad RC0726B', DeviceType::TABLET ],
        'RC0734H'                                   => [ '3Q', 'Qoo! Q-Pad RC0734H', DeviceType::TABLET ],
        'RC0738C'                                   => [ '3Q', 'Qoo! Q-Pad RC0738C', DeviceType::TABLET ],
        'RC0743H'                                   => [ '3Q', 'Qoo! Q-Pad RC0743H', DeviceType::TABLET ],
        'RC0813C'                                   => [ '3Q', 'Qoo! Q-Pad RC0813C', DeviceType::TABLET ],
        'RC0813CM'                                  => [ '3Q', 'Qoo! Q-Pad RC0813CM', DeviceType::TABLET ],
        'RC0817C'                                   => [ '3Q', 'Qoo! Q-Pad RC0817C', DeviceType::TABLET ],
        'RC1018C'                                   => [ '3Q', 'Qoo! Q-Pad RC1018C', DeviceType::TABLET ],
        'RC1019G'                                   => [ '3Q', 'Qoo! Q-Pad RC1019G', DeviceType::TABLET ],
        'RC1025F'                                   => [ '3Q', 'Qoo! Q-Pad RC1025F', DeviceType::TABLET ],
        'RC1301C'                                   => [ '3Q', 'Qoo! Q-Pad RC1301C', DeviceType::TABLET ],
        'RC7802F'                                   => [ '3Q', 'Qoo! Q-Pad RC7802F', DeviceType::TABLET ],
        'RC9711B'                                   => [ '3Q', 'Qoo! Q-Pad RC9711B', DeviceType::TABLET ],
        'RC9712C'                                   => [ '3Q', 'Qoo! Q-Pad RC9712C', DeviceType::TABLET ],
        'RC9716B'                                   => [ '3Q', 'Qoo! Q-Pad RC9716B', DeviceType::TABLET ],
        'RC9717B'                                   => [ '3Q', 'Qoo! Q-Pad RC9717B', DeviceType::TABLET ],
        'RC9724C'                                   => [ '3Q', 'Qoo! Q-Pad RC9724C', DeviceType::TABLET ],
        'RC9726C'                                   => [ '3Q', 'Qoo! Q-Pad RC9726C', DeviceType::TABLET ],
        'RC9727F'                                   => [ '3Q', 'Qoo! Q-Pad RC9727F', DeviceType::TABLET ],
        'RC9730C'                                   => [ '3Q', 'Qoo! Q-Pad RC9730C', DeviceType::TABLET ],
        'RC9731C'                                   => [ '3Q', 'Qoo! Q-Pad RC9731C', DeviceType::TABLET ],
        'QS0715C'                                   => [ '3Q', 'Qoo! Q-Pad QS0715C', DeviceType::TABLET ],
        'QS0716D'                                   => [ '3Q', 'Qoo! Q-Pad QS0716D', DeviceType::TABLET ],
        'QS0717D'                                   => [ '3Q', 'Qoo! Q-Pad QS0717D', DeviceType::TABLET ],
        'QS0728C'                                   => [ '3Q', 'Qoo! Q-Pad QS0728C', DeviceType::TABLET ],
        'QS0730C'                                   => [ '3Q', 'Qoo! Q-Pad QS0730C', DeviceType::TABLET ],
        'QS0815C'                                   => [ '3Q', 'Qoo! Q-Pad QS0815C', DeviceType::TABLET ],
        'QS9718C'                                   => [ '3Q', 'Qoo! Q-Pad QS9718C', DeviceType::TABLET ],
        'VM1017A'                                   => [ '3Q', 'Qoo! Q-Pad VM1017A', DeviceType::TABLET ],
        'TS0807B'                                   => [ '3Q', 'Qoo! Q-Note TS0807B', DeviceType::TABLET ],
        'TS1003T'                                   => [ '3Q', 'Qoo! Surf Tablet TS1003T', DeviceType::TABLET ],
        'TS1004T'                                   => [ '3Q', 'Qoo! Surf Tablet TS1004T', DeviceType::TABLET ],
        'TS1009B'                                   => [ '3Q', 'Qoo! Surf Tablet TS1009B', DeviceType::TABLET ],
        'TS1013B'                                   => [ '3Q', 'Qoo! Surf Tablet TS1013B', DeviceType::TABLET ],
        'TS9708B'                                   => [ '3Q', 'Qoo! Surf Tablet TS9708B', DeviceType::TABLET ],
        'OC1020A'                                   => [ '3Q', 'Qoo! Surf Tablet OC1020A', DeviceType::TABLET ],
        'QS9715F'                                   => [ '3Q', 'Qoo! Surf Tablet QS9715F', DeviceType::TABLET ],
        'QS9719D'                                   => [ '3Q', 'Qoo! Surf Tablet QS9719D', DeviceType::TABLET ],
        'QS1023H'                                   => [ '3Q', 'Qoo! Surf Tablet QS1023H', DeviceType::TABLET ],
        'VM0711A'                                   => [ '3Q', 'Qoo! Surf Tablet VM0711A', DeviceType::TABLET ],
    ],

    'BioniQ!!' => [
        'BioniQ 700'                                => [ 'a-rival', 'BioniQ 700', DeviceType::TABLET ],
        'BioniQ700HX'                               => [ 'a-rival', 'BioniQ 700 HX', DeviceType::TABLET ],
        'BioniQ 800'                                => [ 'a-rival', 'BioniQ 800', DeviceType::TABLET ],
        'BioniQ 1001'                               => [ 'a-rival', 'BioniQ 1001', DeviceType::TABLET ],
        'BioniQ 8008'                               => [ 'a-rival', 'BioniQ 8008', DeviceType::TABLET ],
    ],

    'RTC-700A'                                  => [ 'Aaeon', 'RTC-700A', DeviceType::TABLET ],
    'aspire1000s'                               => [ 'Acer', '1000 Series', DeviceType::DESKTOP ],

    'A[0-9]{3,3}!!' => [
        'A100'                                      => [ 'Acer', 'Iconia Tab A100', DeviceType::TABLET ],
        'A101'                                      => [ 'Acer', 'Iconia Tab A101', DeviceType::TABLET ],
        'A110'                                      => [ 'Acer', 'Iconia Tab A110', DeviceType::TABLET ],
        'A200'                                      => [ 'Acer', 'Iconia Tab A200', DeviceType::TABLET ],
        'A200 3G'                                   => [ 'Acer', 'Iconia Tab A200', DeviceType::TABLET ],
        'A210'                                      => [ 'Acer', 'Iconia Tab A210', DeviceType::TABLET ],
        'A211'                                      => [ 'Acer', 'Iconia Tab A211', DeviceType::TABLET ],
        'A500'                                      => [ 'Acer', 'Iconia Tab A500', DeviceType::TABLET ],
        'A501'                                      => [ 'Acer', 'Iconia Tab A501', DeviceType::TABLET ],
        'A510'                                      => [ 'Acer', 'Iconia Tab A510', DeviceType::TABLET ],
        'A511'                                      => [ 'Acer', 'Iconia Tab A511', DeviceType::TABLET ],
        'A700'                                      => [ 'Acer', 'Iconia Tab A700', DeviceType::TABLET ],
        'A701'                                      => [ 'Acer', 'Iconia Tab A701', DeviceType::TABLET ],
        'A800'                                      => [ 'Acer', 'Iconia Tab A800', DeviceType::TABLET ],
    ],

    'P2A700'                                    => [ 'Acer', 'Iconia Tab A700', DeviceType::TABLET ],

    'A1-[0-9]{3,3}!!' => [
        'A1-713'                                    => [ 'Acer', 'Iconia Tab 7 A1-713', DeviceType::TABLET ],
        'A1-713HD'                                  => [ 'Acer', 'Iconia Tab 7 A1-713 HD', DeviceType::TABLET ],
        'A1-724'                                    => [ 'Acer', 'Iconia TalkTab 7 A1-724', DeviceType::TABLET ],
        'A1-734'                                    => [ 'Acer', 'Iconia Talk S A1-734', DeviceType::TABLET ],
        'A1-810'                                    => [ 'Acer', 'Iconia A1-810', DeviceType::TABLET ],
        'A1-811'                                    => [ 'Acer', 'Iconia A1-811', DeviceType::TABLET ],
        'A1-812'                                    => [ 'Acer', 'Iconia A1-812', DeviceType::TABLET ],
        'A1-820'                                    => [ 'Acer', 'Iconia A1-820', DeviceType::TABLET ],
        'A1-830'                                    => [ 'Acer', 'Iconia A1-830', DeviceType::TABLET ],
        'A1-840'                                    => [ 'Acer', 'Iconia Tab 8 A1-840', DeviceType::TABLET ],
        'A1-840FHD'                                 => [ 'Acer', 'Iconia Tab 8 A1-840 FHD', DeviceType::TABLET ],
        'A1-841'                                    => [ 'Acer', 'Iconia Tab 8 A1-841', DeviceType::TABLET ],
        'A1-850'                                    => [ 'Acer', 'Iconia One 8 A1-850', DeviceType::TABLET ],
        'A1-860'                                    => [ 'Acer', 'Iconia Tab 8 A1-860', DeviceType::TABLET ],
    ],

    'A3-A[0-9]{2,2}!!' => [
        'A3-A10'                                    => [ 'Acer', 'Iconia A3-A10', DeviceType::TABLET ],
        'A3-A11'                                    => [ 'Acer', 'Iconia A3-A11', DeviceType::TABLET ],
        'A3-A20'                                    => [ 'Acer', 'Iconia Tab 10 A3-A20', DeviceType::TABLET ],
        'A3-A20FHD'                                 => [ 'Acer', 'Iconia Tab 10 A3-A20 FHD', DeviceType::TABLET ],
        'A3-A30'                                    => [ 'Acer', 'Iconia Tab 10 A3-A30', DeviceType::TABLET ],
        'A3-A40'                                    => [ 'Acer', 'Iconia Tab 10 A3-A40', DeviceType::TABLET ],
    ],

    'B1-[A0-9][0-9]{2,2}!!' => [
        'B1-A71'                                    => [ 'Acer', 'Iconia B1-A71', DeviceType::TABLET ],
        'B1-710'                                    => [ 'Acer', 'Iconia B1-710', DeviceType::TABLET ],
        'B1-711'                                    => [ 'Acer', 'Iconia B1-711', DeviceType::TABLET ],
        'B1-713'                                    => [ 'Acer', 'Iconia B1-713', DeviceType::TABLET ],
        'B1-720'                                    => [ 'Acer', 'Iconia B1-720', DeviceType::TABLET ],
        'B1-721'                                    => [ 'Acer', 'Iconia B1-721', DeviceType::TABLET ],
        'B1-723'                                    => [ 'Acer', 'Iconia B1-723', DeviceType::TABLET ],
        'B1-730'                                    => [ 'Acer', 'Iconia One 7 B1-730', DeviceType::TABLET ],
        'B1-730HD'                                  => [ 'Acer', 'Iconia One 7 B1-730 HD', DeviceType::TABLET ],
        'B1-750'                                    => [ 'Acer', 'Iconia One 7 B1-750', DeviceType::TABLET ],
        'B1-760'                                    => [ 'Acer', 'Iconia One 7 B1-760', DeviceType::TABLET ],
        'B1-760HD'                                  => [ 'Acer', 'Iconia One 7 B1-760 HD', DeviceType::TABLET ],
        'B1-770'                                    => [ 'Acer', 'Iconia One 7 B1-770', DeviceType::TABLET ],
        'B1-780'                                    => [ 'Acer', 'Iconia One 7 B1-780', DeviceType::TABLET ],
        'B1-810'                                    => [ 'Acer', 'Iconia One 8 B1-810', DeviceType::TABLET ],
        'B1-820'                                    => [ 'Acer', 'Iconia One 8 B1-820', DeviceType::TABLET ],
        'B1-830'                                    => [ 'Acer', 'Iconia One 8 B1-830', DeviceType::TABLET ],
        'B1-850'                                    => [ 'Acer', 'Iconia One 8 B1-850', DeviceType::TABLET ],
    ],

    'B3-A20'                                    => [ 'Acer', 'Iconia One 10 B3-A20', DeviceType::TABLET ],
    'B3-A30'                                    => [ 'Acer', 'Iconia One 10 B3-A30', DeviceType::TABLET ],

    'Acer One 7 M77GHG'                         => [ 'Acer', 'Iconia One 7 M77GHG', DeviceType::TABLET ],
    'TD070VA1'                                  => [ 'Acer', 'Iconia One 7 TD070VA1', DeviceType::TABLET ],

    'ICONIA!!' => [
        'ICONIA Tab W500'                           => [ 'Acer', 'Iconia W500', DeviceType::TABLET ],
        'ICONIA Tab W500P'                          => [ 'Acer', 'Iconia W500P', DeviceType::TABLET ],
        'ICONIA Tab W501'                           => [ 'Acer', 'Iconia W501', DeviceType::TABLET ],
        'ICONIA W700'                               => [ 'Acer', 'Iconia W700', DeviceType::TABLET ],
    ],

    'GT-810'                                    => [ 'Acer', 'Predator 8', DeviceType::TABLET ],

    'E[0-9]{2,2}0?!!' => [
        'E110'                                      => [ 'Acer', 'beTouch E110' ],
        'E120'                                      => [ 'Acer', 'beTouch E120' ],
        'E130'                                      => [ 'Acer', 'beTouch E130' ],
        'E140'                                      => [ 'Acer', 'beTouch E140' ],
        'E210'                                      => [ 'Acer', 'beTouch E210' ],
        'E310'                                      => [ 'Acer', 'Liquid mini' ],
        'E320'                                      => [ 'Acer', 'Liquid Express' ],
        'E330'                                      => [ 'Acer', 'Liquid Glow' ],
        'E350'                                      => [ 'Acer', 'Liquid Gallant' ],
        'E380'                                      => [ 'Acer', 'Liquid E3' ],
        'E400'                                      => [ 'Acer', 'beTouch E400' ],
        'E600'                                      => [ 'Acer', 'Liquid E600' ],
        'E39'                                       => [ 'Acer', 'Liquid E700' ],
    ],

    'I110'                                      => [ 'Acer', 'Liquid C1' ],

    'S[0-9]{2,2}0?!!' => [
        'S100'                                      => [ 'Acer', 'Liquid' ],
        'S110'                                      => [ 'Acer', 'Stream' ],
        'S120'                                      => [ 'Acer', 'Liquid mt' ],
        'S300'                                      => [ 'Acer', 'Iconia Smart' ],
        'S500'                                      => [ 'Acer', 'CloudMobile' ],
        'S510'                                      => [ 'Acer', 'Liquid S' ],
        'S520'                                      => [ 'Acer', 'Liquid S2' ],
        'S53'                                       => [ 'Acer', 'Liquid S3' ],
        'S55'                                       => [ 'Acer', 'Liquid Jade' ],
        'S56'                                       => [ 'Acer', 'Liquid Jade S' ],
        'S57'                                       => [ 'Acer', 'Liquid Jade Z' ],
        'S59'                                       => [ 'Acer', 'Liquid X2' ],
    ],

    'V[0-9]{2,2}0!!' => [
        'V360'                                      => [ 'Acer', 'Liquid E1' ],
        'V370'                                      => [ 'Acer', 'Liquid E2' ],
        'V380'                                      => [ 'Acer', 'Liquid E3' ],
    ],

    'Z[0-9]{3,3}!!' => [
        'Z110'                                      => [ 'Acer', 'Liquid Z' ],
        'Z120'                                      => [ 'Acer', 'Liquid Z2' ],
        'Z130'                                      => [ 'Acer', 'Liquid Z3' ],
        'Z140'                                      => [ 'Acer', 'Liquid Z4' ],
        'Z150'                                      => [ 'Acer', 'Liquid Z5' ],
        'Z160'                                      => [ 'Acer', 'Liquid Z4' ],
        'Z200'                                      => [ 'Acer', 'Liquid Z200' ],
        'Z205'                                      => [ 'Acer', 'Liquid Z205' ],
        'Z205P'                                     => [ 'Acer', 'Liquid Z205' ],
        'Z220'                                      => [ 'Acer', 'Liquid Z220' ],
        'Z410'                                      => [ 'Acer', 'Liquid Z410' ],
        'Z500'                                      => [ 'Acer', 'Liquid Z500' ],
        'Z520'                                      => [ 'Acer', 'Liquid Z520' ],
        'Z530'                                      => [ 'Acer', 'Liquid Z530' ],
    ],

    'Z4'                                        => [ 'Acer', 'Liquid Z4' ],
    'T01'                                       => [ 'Acer', 'Liquid Z330' ],
    'T012'                                      => [ 'Acer', 'Liquid Z330' ],
    'T02'                                       => [ 'Acer', 'Liquid Z530' ],
    'T05'                                       => [ 'Acer', 'Liquid Z530S' ],
    'T03'                                       => [ 'Acer', 'Liquid Z630' ],
    'T04'                                       => [ 'Acer', 'Liquid Z630S' ],
    'TD600'                                     => [ 'Acer', 'beTouch TD600' ],
    'AK330'                                     => [ 'Acer', 'Liquid Gallant Duo' ],
    'AK330s'                                    => [ 'Acer', 'Liquid Gallant Duo' ],
    'AT390'                                     => [ 'Acer', 'Liquid C' ],
    'E1 v360'                                   => [ 'Acer', 'Liquid E1' ],
    'v360 E1'                                   => [ 'Acer', 'Liquid E1' ],

    'Liquid!!' => [
        'Liquid'                                    => [ 'Acer', 'Liquid' ],
        'Liquid E'                                  => [ 'Acer', 'Liquid E' ],
        'LIQUID E1'                                 => [ 'Acer', 'Liquid E1 ' ],
        'LIQUID E2'                                 => [ 'Acer', 'Liquid E2 ' ],
        'LIQUID E3'                                 => [ 'Acer', 'Liquid E3 ' ],
        'Liquid MT'                                 => [ 'Acer', 'Liquid mt' ],
        'Liquid Metal'                              => [ 'Acer', 'Liquid mt' ],
        'Liquid Z205'                               => [ 'Acer', 'Liquid Z205' ],
    ],

    'Stream'                                    => [ 'Acer', 'Stream' ],
    'M3-2200'                                   => [ 'Acer', 'M3-2200', DeviceType::TABLET ],
    'MWND1'                                     => [ 'Acer', 'MWND1 Android Dongle', DeviceType::TELEVISION ],

    'DA2[0-9]{2,2}[A-Z]+!!' => [
        'DA220HQL'                                  => [ 'Acer', 'Touch and 3D Monitor DA220HQL', DeviceType::MONITOR ],
        'DA221HQL'                                  => [ 'Acer', 'Touch and 3D Monitor DA221HQL', DeviceType::MONITOR ],
        'DA222HQL'                                  => [ 'Acer', 'Touch and 3D Monitor DA222HQL', DeviceType::MONITOR ],
        'DA222HQLA'                                 => [ 'Acer', 'Touch and 3D Monitor DA222HQL', DeviceType::MONITOR ],
        'DA223HQL'                                  => [ 'Acer', 'All-in-One DA223HQL', DeviceType::MONITOR ],
        'DA226HQ'                                   => [ 'Acer', 'All-in-One DA226HQ', DeviceType::MONITOR ],
        'DA241HL'                                   => [ 'Acer', 'All-in-One DA241HL', DeviceType::MONITOR ],
        'DA245HQL'                                  => [ 'Acer', 'Touch and 3D Monitor DA245HQL', DeviceType::MONITOR ],
    ],

    'TA272HUL'                                  => [ 'Acer', 'All-in-One TA272HUL', DeviceType::MONITOR ],

    'AA3-600'                                   => [ 'Acer', 'Aspire A3', DeviceType::DESKTOP ],

    'Aspire!!' => [
        'Aspire (A[0-9])!'                          => [ 'Acer', 'Aspire $1', DeviceType::DESKTOP ],
        'Aspire ([0-9]{4,4}[A-Z]?)!'                => [ 'Acer', 'Aspire $1', DeviceType::DESKTOP ],
        'Aspire ([A-Z][A-Z0-9]-[0-9]{3,3}[A-Z]?)!'  => [ 'Acer', 'Aspire $1', DeviceType::DESKTOP ],
        'Aspire ([A-Z][0-9]{4,4}[A-Z]?)!'           => [ 'Acer', 'Aspire $1', DeviceType::DESKTOP ],
        'Aspire ([A-Z]{2,2}[0-9]-[0-9]{3,3})!'      => [ 'Acer', 'Aspire $1', DeviceType::DESKTOP ],
        'Aspire one'                                => [ 'Acer', 'Aspire One', DeviceType::DESKTOP ],
        'Aspire one Pro'                            => [ 'Acer', 'Aspire One Pro', DeviceType::DESKTOP ],
    ],

    'C908'                                      => [ 'Acho', 'C908', DeviceType::TABLET ],

    'ADVAN Q7A'                                 => [ 'Advan', 'Vandroid Q7A' ],
    'ADVAN E1C+'                                => [ 'Advan', 'Vandroid E1-C+', DeviceType::TABLET ],
    'ADVAN S3'                                  => [ 'Advan', 'Vandroid S3', DeviceType::TABLET ],
    'ADVAN S3+'                                 => [ 'Advan', 'Vandroid S3+', DeviceType::TABLET ],
    'ADVAN S3A'                                 => [ 'Advan', 'Vandroid S3-A', DeviceType::TABLET ],
    'ADVAN S3C'                                 => [ 'Advan', 'Vandroid S3-C', DeviceType::TABLET ],
    'ADVAN S3C 3502'                            => [ 'Advan', 'Vandroid S3-C', DeviceType::TABLET ],
    'ADVAN S4'                                  => [ 'Advan', 'Vandroid S4', DeviceType::TABLET ],
    'ADVAN S4+'                                 => [ 'Advan', 'Vandroid S4+', DeviceType::TABLET ],
    'ADVAN S4A'                                 => [ 'Advan', 'Vandroid S4-A', DeviceType::TABLET ],
    'ADVAN S4C'                                 => [ 'Advan', 'Vandroid S4-C', DeviceType::TABLET ],
    'ADVAN S4E'                                 => [ 'Advan', 'Vandroid S4-E', DeviceType::TABLET ],
    'Advan S4P [Official]'                      => [ 'Advan', 'Vandroid S4-P', DeviceType::TABLET ],
    'ADVAN S5E'                                 => [ 'Advan', 'Vandroid S5-E', DeviceType::TABLET ],
    'Vandroid S5E'                              => [ 'Advan', 'Vandroid S5-E', DeviceType::TABLET ],
    'ADVAN S5E Pro'                             => [ 'Advan', 'Vandroid S5-E Pro', DeviceType::TABLET ],
    'S5-F'                                      => [ 'Advan', 'Vandroid S5-F', DeviceType::TABLET ],
    'ADVAN S5F+'                                => [ 'Advan', 'Vandroid S5-F+', DeviceType::TABLET ],
    'ADVAN S5H'                                 => [ 'Advan', 'Vandroid S5-H', DeviceType::TABLET ],
    'ADVAN S5I'                                 => [ 'Advan', 'Vandroid S5-I', DeviceType::TABLET ],
    'Advan S5K'                                 => [ 'Advan', 'Vandroid S5-K', DeviceType::TABLET ],
    'ADVAN S5M'                                 => [ 'Advan', 'Vandroid S5-M', DeviceType::TABLET ],
    'ADVAN S5Q'                                 => [ 'Advan', 'Vandroid S5-Q', DeviceType::TABLET ],
    'ADVAN S6A'                                 => [ 'Advan', 'Vandroid S6-A', DeviceType::TABLET ],
    'T1-B'                                      => [ 'Advan', 'Vandroid T1-B', DeviceType::TABLET ],
    'T1-D'                                      => [ 'Advan', 'Vandroid T1-D', DeviceType::TABLET ],
    'T1-E'                                      => [ 'Advan', 'Vandroid T1-E', DeviceType::TABLET ],
    'ADVAN T1G'                                 => [ 'Advan', 'Vandroid T1-G', DeviceType::TABLET ],
    'ADVAN T1J'                                 => [ 'Advan', 'Vandroid T1-J', DeviceType::TABLET ],
    'Vandroid T1J'                              => [ 'Advan', 'Vandroid T1-J', DeviceType::TABLET ],
    'ADVAN T1J+'                                => [ 'Advan', 'Vandroid T1-J+', DeviceType::TABLET ],
    'T1K Plus'                                  => [ 'Advan', 'Vandroid T1-K Plus', DeviceType::TABLET ],
    'ADVAN T1L'                                 => [ 'Advan', 'Vandroid T1-L', DeviceType::TABLET ],
    'ADVAN T1M'                                 => [ 'Advan', 'Vandroid T1-M', DeviceType::TABLET ],
    'ADVAN T1X'                                 => [ 'Advan', 'Vandroid T1-X', DeviceType::TABLET ],
    'ADVAN T2E'                                 => [ 'Advan', 'Vandroid T2-E', DeviceType::TABLET ],
    'ADVAN T2F'                                 => [ 'Advan', 'Vandroid T2-F', DeviceType::TABLET ],
    'Vandroid T3-A'                             => [ 'Advan', 'Vandroid T3-A', DeviceType::TABLET ],
    'ADVAN T3E+'                                => [ 'Advan', 'Vandroid T3-E+', DeviceType::TABLET ],
    'Vandroid T3i'                              => [ 'Advan', 'Vandroid T3i', DeviceType::TABLET ],
    'ADVAN T5C'                                 => [ 'Advan', 'Vandroid T5-C', DeviceType::TABLET ],
    'Vandroid T'                                => [ 'Advan', 'Vandroid T', DeviceType::TABLET ],
    'Vega'                                      => [ 'Advent', 'Vega', DeviceType::TABLET ],
    'VegaBean!'                                 => [ 'Advent', 'Vega', DeviceType::TABLET ],
    'Advent Vega'                               => [ 'Advent', 'Vega', DeviceType::TABLET ],
    'Boost'                                     => [ 'AG Mobile', 'Boost' ],
    'Chacer'                                    => [ 'AG Mobile', 'Chacer' ],
    'AG Chrome Selfie'                          => [ 'AG Mobile', 'Chrome Selfie' ],
    'AG CHROME ULTRA'                           => [ 'AG Mobile', 'Chrome Ultra' ],
    'Ghost'                                     => [ 'AG Mobile', 'Ghost' ],
    'Neon'                                      => [ 'AG Mobile', 'Neon' ],
    'Quest'                                     => [ 'AG Mobile', 'Quest' ],
    'Rage'                                      => [ 'AG Mobile', 'Rage' ],
    'Shine'                                     => [ 'AG Mobile', 'Shine' ],
    'Status'                                    => [ 'AG Mobile', 'Status' ],
    'Style'                                     => [ 'AG Mobile', 'Style' ],
    'Swift'                                     => [ 'AG Mobile', 'Swift' ],
    'Swift Plus'                                => [ 'AG Mobile', 'Swift Plus' ],
    'Ultra'                                     => [ 'AG Mobile', 'Ultra' ],
    'Zenith'                                    => [ 'AG Mobile', 'Zenith' ],
    'Zoom'                                      => [ 'AG Mobile', 'Zoom' ],
    'AG Tab 7 0'                                => [ 'AG Mobile', 'Tab 7.0', DeviceType::TABLET ],
    'AG Go-Tab Access'                          => [ 'AG Mobile', 'Go-Tab Access', DeviceType::TABLET ],
    'AG Chrome Go Tab 7.0'                      => [ 'AG Mobile', 'Go-Tab Chrome', DeviceType::TABLET ],
    'aigoPad'                                   => [ 'aigo', 'aigoPad', DeviceType::TABLET ],
    'aigoPadM60'                                => [ 'aigo', 'aigoPad M60', DeviceType::TABLET ],
    'AigoPad M60'                               => [ 'aigo', 'aigoPad M60', DeviceType::TABLET ],
    'aigoPad M80D'                              => [ 'aigo', 'aigoPad M80', DeviceType::TABLET ],
    'aigoPad M80E'                              => [ 'aigo', 'aigoPad M80', DeviceType::TABLET ],
    'M801'                                      => [ 'aigo', 'aigoPad M801', DeviceType::TABLET ],
    'N700'                                      => [ 'aigo', 'aigoPad N700', DeviceType::TABLET ],
    'AT102HC'                                   => [ 'Aikun', 'iTouch AT102HC', DeviceType::TABLET ],
    'AT104GS'                                   => [ 'Aikun', 'iTouch AT104GS', DeviceType::TABLET ],

    'Numy!!' => [
        'Numy 3G AW1'                               => [ 'Ainol', 'Numy 3G AW1', DeviceType::TABLET ],
        'Numy 3G AX1'                               => [ 'Ainol', 'Numy 3G AX1', DeviceType::TABLET ],
        'Numy 3G AX10t'                             => [ 'Ainol', 'Numy 3G AX10t', DeviceType::TABLET ],
        'Numy 3G AX3'                               => [ 'Ainol', 'Numy 3G AX3', DeviceType::TABLET ],
        'Numy 3G BW1'                               => [ 'Ainol', 'Numy 3G BW1', DeviceType::TABLET ],
        'Numy 3G Vegas'                             => [ 'Ainol', 'Numy 3G Vegas', DeviceType::TABLET ],
        'Numy Note 9'                               => [ 'Ainol', 'Numy Note 9', DeviceType::TABLET ],
    ],

    'Novo7'                                     => [ 'Ainovo', 'Novo7', DeviceType::TABLET ],
    'Novo7 -?Aurora!'                           => [ 'Ainovo', 'Novo7 Aurora', DeviceType::TABLET ],
    'novo Aurora'                               => [ 'Ainovo', 'Novo7 Aurora', DeviceType::TABLET ],
    'Novo 7 Aurora'                             => [ 'Ainovo', 'Novo7 Aurora', DeviceType::TABLET ],
    'Ainovo Aurora-II'                          => [ 'Ainovo', 'Novo7 Aurora II', DeviceType::TABLET ],
    'Aurora-II'                                 => [ 'Ainovo', 'Novo7 Aurora II', DeviceType::TABLET ],
    'Novo7 Advanced'                            => [ 'Ainovo', 'Novo7 Advanced', DeviceType::TABLET ],
    'Novo7Advanced!'                            => [ 'Ainovo', 'Novo7 Advanced', DeviceType::TABLET ],
    'Novo7 Advanced2'                           => [ 'Ainovo', 'Novo7 Advanced 2', DeviceType::TABLET ],
    'Novo7 Basic'                               => [ 'Ainovo', 'Novo7 Basic', DeviceType::TABLET ],
    'NovoCrystal'                               => [ 'Ainovo', 'Novo7 Crystal', DeviceType::TABLET ],
    'Novo 7 Crystal!'                           => [ 'Ainovo', 'Novo7 Crystal', DeviceType::TABLET ],
    'Novo7 ELF'                                 => [ 'Ainovo', 'Novo7 Elf', DeviceType::TABLET ],
    'ELF-II'                                    => [ 'Ainovo', 'Novo7 Elf II', DeviceType::TABLET ],
    'Novo7 Fire'                                => [ 'Ainovo', 'Novo7 Fire', DeviceType::TABLET ],
    'Novo7 Flame'                               => [ 'Ainovo', 'Novo7 Flame', DeviceType::TABLET ],
    'Ainovo Flame (Nexus 7)'                    => [ 'Ainovo', 'Novo7 Flame', DeviceType::TABLET ],
    'Novo7 Grace'                               => [ 'Ainovo', 'Novo7 Grace', DeviceType::TABLET ],
    'Novo7 Legend'                              => [ 'Ainovo', 'Novo7 Legend', DeviceType::TABLET ],
    'novo7Legend!'                              => [ 'Ainovo', 'Novo7 Legend', DeviceType::TABLET ],
    'NOVO7 Mars'                                => [ 'Ainovo', 'Novo7 Mars', DeviceType::TABLET ],
    'Novo7 PALADIN'                             => [ 'Ainovo', 'Novo7 Paladin', DeviceType::TABLET ],
    'npm702-NOVO7PALADIN'                       => [ 'Ainovo', 'Novo7 Paladin', DeviceType::TABLET ],
    'Novo7 Rainbow'                             => [ 'Ainovo', 'Novo7 Rainbow', DeviceType::TABLET ],
    'Novo7 -Rainbow'                            => [ 'Ainovo', 'Novo7 Rainbow', DeviceType::TABLET ],
    'NOVO7 Tornados'                            => [ 'Ainovo', 'Novo7 Tornados', DeviceType::TABLET ],
    'Novo7 Venus'                               => [ 'Ainovo', 'Novo7 Venus', DeviceType::TABLET ],
    'Novo 7 Venus'                              => [ 'Ainovo', 'Novo7 Venus', DeviceType::TABLET ],
    'Novo7 Venus QuadCore'                      => [ 'Ainovo', 'Novo7 Venus', DeviceType::TABLET ],
    'Novo 7 Venus QuadCore'                     => [ 'Ainovo', 'Novo7 Venus', DeviceType::TABLET ],
    'Novo8 Advanced'                            => [ 'Ainovo', 'Novo8 Advanced', DeviceType::TABLET ],
    'Novo8 Discover Quadcore'                   => [ 'Ainovo', 'Novo8 Discover', DeviceType::TABLET ],
    'Novo8 Disover Quadcore'                    => [ 'Ainovo', 'Novo8 Discover', DeviceType::TABLET ],
    'Novo8 Dream QuadCore'                      => [ 'Ainovo', 'Novo8 Dream', DeviceType::TABLET ],
    'Novo8mini'                                 => [ 'Ainovo', 'Novo8 Mini', DeviceType::TABLET ],
    'novo9-Spark'                               => [ 'Ainovo', 'Novo9 Spark', DeviceType::TABLET ],
    'NOVO9 Spark II'                            => [ 'Ainovo', 'Novo9 Spark II', DeviceType::TABLET ],
    'Novo 10 Hero'                              => [ 'Ainovo', 'Novo10 Hero', DeviceType::TABLET ],
    'Novo10 ?Hero!'                             => [ 'Ainovo', 'Novo10 Hero', DeviceType::TABLET ],
    'Novo 10 Hero QuadCore'                     => [ 'Ainovo', 'Novo10 Hero', DeviceType::TABLET ],
    'Novo Captain'                              => [ 'Ainovo', 'Novo10 Captain', DeviceType::TABLET ],
    'Novo10 captain QuadCore'                   => [ 'Ainovo', 'Novo10 Captain', DeviceType::TABLET ],
    'AIRIS GN135'                               => [ 'Airis', 'GN135' ],
    'AIRIS S211'                                => [ 'Airis', 'S211' ],
    'AIRIS TM([0-9]+[A-Z]*)!'                   => [ 'Airis', 'TM$1' ],
    'TM400'                                     => [ 'Airis', 'TM400' ],
    'AIRIS OnePAD 725'                          => [ 'Airis', 'OnePAD 725' ],
    'AIRIS OnePAD700'                           => [ 'Airis', 'OnePAD 700' ],
    'AIRIS OnePAD 730'                          => [ 'Airis', 'OnePAD 730' ],
    'OnePAD 785I'                               => [ 'Airis', 'OnePAD 785I' ],
    'OnePAD 900HD'                              => [ 'Airis', 'OnePAD 900HD' ],
    'OnePAD 970'                                => [ 'Airis', 'OnePAD 970' ],
    'AirisOnePad1000'                           => [ 'Airis', 'OnePAD 1000' ],
    'OnePAD 1100x2'                             => [ 'Airis', 'OnePAD 1100x2' ],
    'AKAI NEO'                                  => [ 'AKAI', 'Neo' ],
    'AKAI N8800'                                => [ 'AKAI', 'N8800' ],
    'PHA-3850'                                  => [ 'AKAI', 'PHA-3850' ],
    'PHA-3880'                                  => [ 'AKAI', 'PHA-3880 Glory F1' ],
    'AKAI PHA-4800'                             => [ 'AKAI', 'PHA-4800 Glory G1' ],
    'PHA-4850'                                  => [ 'AKAI', 'PHA-4850 Glory L1' ],
    'AKAIPHA 5800'                              => [ 'AKAI', 'PHA-5800' ],
    'PHA-5850'                                  => [ 'AKAI', 'PHA-5850 Glory O1' ],
    'AKAI MIDMA-7002S'                          => [ 'AKAI', 'MIDMA 7002S', DeviceType::TABLET ],
    'MID1040C'                                  => [ 'AKAI', 'MID1040C', DeviceType::TABLET ],
    'A206G'                                     => [ 'Alcatel', 'A206G' ],
    'A450TL'                                    => [ 'Alcatel', 'One Touch Pixi Charm' ],
    'A460G'                                     => [ 'Alcatel', 'One Touch Pixi Pulsar' ],
    'A460T'                                     => [ 'Alcatel', 'One Touch Pixi 3' ],
    'A462C'                                     => [ 'Alcatel', 'One Touch Pixi Eclipse' ],
    'A463BG'                                    => [ 'Alcatel', 'One Touch Pixi Glitz' ],
    'A464BG'                                    => [ 'Alcatel', 'One Touch Pixi Glitz' ],
    'A466BG'                                    => [ 'Alcatel', 'One Touch Pixi Unite' ],
    'A466T'                                     => [ 'Alcatel', 'Lume' ],
    'A480G'                                     => [ 'Alcatel', 'One Touch Pop C1' ],
    'A520L'                                     => [ 'Alcatel', 'One Touch Pop Nova' ],
    'A520R'                                     => [ 'Alcatel', 'One Touch Pop Nova' ],
    'A521L'                                     => [ 'Alcatel', 'One Touch Pop Star 2' ],
    'A554C'                                     => [ 'Alcatel', 'One Touch Juke' ],
    'A556C'                                     => [ 'Alcatel', 'A556C' ],
    'A560G'                                     => [ 'Alcatel', 'A560G' ],
    'A562G'                                     => [ 'Alcatel', 'A562G' ],
    'A564R'                                     => [ 'Alcatel', 'One Touch Pop Icon' ],
    'A564C'                                     => [ 'Alcatel', 'One Touch Pop Icon' ],
    'A570BL'                                    => [ 'Alcatel', 'One Touch Pixi Avion' ],
    'A571VL'                                    => [ 'Alcatel', 'One Touch Pixi Avion' ],
    'A573VC'                                    => [ 'Alcatel', 'One Touch Pixi Bond' ],
    'A621BL'                                    => [ 'Alcatel', 'One Touch Pixi Glory' ],
    'A621R'                                     => [ 'Alcatel', 'One Touch Pop 3 (5.5)' ],
    'A622GL'                                    => [ 'Alcatel', 'Jitterbug Smart' ],
    'A622VL'                                    => [ 'Alcatel', 'One Touch Pixi 3 (5.5)' ],
    'A845L'                                     => [ 'Alcatel', 'One Touch Pop Star' ],
    'A846L'                                     => [ 'Alcatel', 'One Touch Pop Icon 2' ],
    'Alcatel A851L'                             => [ 'Alcatel', 'One Touch Sonic' ],
    'A851L'                                     => [ 'Alcatel', 'One Touch Sonic' ],
    'A995L'                                     => [ 'Alcatel', 'One Touch Pop Mega' ],
    'ONETOUCH Flash Plus'                       => [ 'Alcatel', 'One Touch Flash Plus' ],
    'one touch 890!'                            => [ 'Alcatel', 'One Touch 890' ],
    'one touch 891!'                            => [ 'Alcatel', 'One Touch 891' ],
    'one touch 900!'                            => [ 'Alcatel', 'One Touch 900' ],
    'one touch 903!'                            => [ 'Alcatel', 'One Touch 903' ],
    'one touch 906!'                            => [ 'Alcatel', 'One Touch 906' ],
    'Alcatel one touch 908F'                    => [ 'Alcatel', 'One Touch 908' ],
    'one touch 908!'                            => [ 'Alcatel', 'One Touch 908' ],
    'one touch 909!'                            => [ 'Alcatel', 'One Touch 909' ],
    'USCC ALCATEL one touch 909B'               => [ 'Alcatel', 'One Touch 909' ],
    'one touch 910!'                            => [ 'Alcatel', 'One Touch 910' ],
    'one touch 913!'                            => [ 'Alcatel', 'One Touch 913' ],
    'one touch 916!'                            => [ 'Alcatel', 'One Touch 916' ],
    'one touch 918!'                            => [ 'Alcatel', 'One Touch 918' ],
    'Alcatel one touch 918'                     => [ 'Alcatel', 'One Touch 918' ],
    'Alcatel ONETOUCH 918'                      => [ 'Alcatel', 'One Touch 918' ],
    'OT 918'                                    => [ 'Alcatel', 'One Touch 918' ],
    'ALCATEL OT 919'                            => [ 'Alcatel', 'One Touch 919' ],
    'OT 919'                                    => [ 'Alcatel', 'One Touch 919' ],
    'OT 919 HelloKitty'                         => [ 'Alcatel', 'One Touch 919 Hello Kitty' ],
    'one touch 922!'                            => [ 'Alcatel', 'One Touch 922' ],
    'one touch 927!'                            => [ 'Alcatel', 'One Touch 927' ],
    'one touch 928!'                            => [ 'Alcatel', 'One Touch 928' ],
    'one touch 930!'                            => [ 'Alcatel', 'One Touch 930' ],
    'one touch 960!'                            => [ 'Alcatel', 'One Touch 960' ],
    'one touch 976!'                            => [ 'Alcatel', 'One Touch 976' ],
    'one touch 978!'                            => [ 'Alcatel', 'One Touch 978' ],
    'one touch 979 HelloKitty'                  => [ 'Alcatel', 'One Touch 979 Hello Kitty' ],
    'one touch 979!'                            => [ 'Alcatel', 'One Touch 979' ],
    'one touch 980!'                            => [ 'Alcatel', 'One Touch 980' ],
    'one touch 981!'                            => [ 'Alcatel', 'One Touch 981' ],
    'one touch 983!'                            => [ 'Alcatel', 'One Touch 983' ],
    'one touch 985!'                            => [ 'Alcatel', 'One Touch 985' ],
    'one touch 986!'                            => [ 'Alcatel', 'One Touch 986' ],
    'one touch 988!'                            => [ 'Alcatel', 'One Touch 988' ],
    'USCC ALCATEL one touch 988'                => [ 'Alcatel', 'One Touch 988' ],
    'one touch 990!'                            => [ 'Alcatel', 'One Touch 990' ],
    'Alcatel one touch 990'                     => [ 'Alcatel', 'One Touch 990' ],
    'Alcatel one touch 990S'                    => [ 'Alcatel', 'One Touch 990' ],
    'TCL ONE TOUCH 990'                         => [ 'Alcatel', 'One Touch 990' ],
    'OT-990C'                                   => [ 'Alcatel', 'One Touch 990' ],
    'OT 990M'                                   => [ 'Alcatel', 'One Touch 990' ],
    'one touch 991!'                            => [ 'Alcatel', 'One Touch 991' ],
    'one touch 992!'                            => [ 'Alcatel', 'One Touch 992' ],
    'ONE TOCH 992D'                             => [ 'Alcatel', 'One Touch 992' ],
    'one touch 993!'                            => [ 'Alcatel', 'One Touch 993' ],
    'one touch 995!'                            => [ 'Alcatel', 'One Touch 995' ],
    'OT-995'                                    => [ 'Alcatel', 'One Touch 995' ],
    'one touch 997!'                            => [ 'Alcatel', 'One Touch 997' ],
    'one touch 998!'                            => [ 'Alcatel', 'One Touch 998' ],
    'one touch D662'                            => [ 'Alcatel', 'One Touch D662' ],
    'one touch D668'                            => [ 'Alcatel', 'One Touch D668' ],
    'one touch D820'                            => [ 'Alcatel', 'One Touch D820' ],
    'one touch D920'                            => [ 'Alcatel', 'One Touch D920' ],
    'one touch J320'                            => [ 'Alcatel', 'One Touch J320' ],
    '1216[X]!'                                  => [ 'Alcatel', 'One Touch Pixi 3 (7)' ],
    '4002[X]!'                                  => [ 'Alcatel', 'One Touch Pop Fit' ],
    '4003[AJ]!'                                 => [ 'Alcatel', 'One Touch Pixi 3 (4)' ],
    'one ?touch 40(05|10|11)!'                  => [ 'Alcatel', 'One Touch T\'Pop' ],
    'one ?touch 4007!'                          => [ 'Alcatel', 'One Touch Pixi' ],
    '4007[D]!'                                  => [ 'Alcatel', 'One Touch Pixi' ],
    'one ?touch 4008!'                          => [ 'Alcatel', 'One Touch Pixi 3 (3.5)' ],
    '4008[A]!'                                  => [ 'Alcatel', 'One Touch Pixi 3 (3.5)' ],
    'one ?touch 4009!'                          => [ 'Alcatel', 'One Touch Pixi 3 (3.5)' ],
    '4009[ADEFIKMSX]!'                          => [ 'Alcatel', 'One Touch Pixi 3 (3.5)' ],
    'one ?touch 4013!'                          => [ 'Alcatel', 'One Touch Pixi 3 (4)' ],
    '4013[ADEJKMX]!'                            => [ 'Alcatel', 'One Touch Pixi 3 (4)' ],
    'one ?touch 4014!'                          => [ 'Alcatel', 'One Touch Pixi 3 (4)' ],
    '4014[AMX]!'                                => [ 'Alcatel', 'One Touch Pixi 3 (4)' ],
    'one ?touch 40(15|16)!'                     => [ 'Alcatel', 'One Touch Pop C1' ],
    '4015[ANTX]!'                               => [ 'Alcatel', 'One Touch Pop C1' ],
    '4015[D]!'                                  => [ 'Alcatel', 'One Touch Pixi 2' ],
    '4016[ADX]!'                                => [ 'Alcatel', 'One Touch Pop C1' ],
    '4017[ADEFX]!'                              => [ 'Alcatel', 'One Touch Pixi 4 (3.5)' ],
    '4018[ADEFMX]!'                             => [ 'Alcatel', 'One Touch Pop D1' ],
    'one ?touch 4024!'                          => [ 'Alcatel', 'One Touch Pixi First' ],
    '4024[DEX]!'                                => [ 'Alcatel', 'One Touch Pixi First' ],
    'one ?touch 4027!'                          => [ 'Alcatel', 'One Touch Pixi 3 (4.5)' ],
    '4027[ADNX]!'                               => [ 'Alcatel', 'One Touch Pixi 3 (4.5)' ],
    '4028[AEJS]!'                               => [ 'Alcatel', 'One Touch Pixi 3 (4.5)' ],
    'one ?touch 4029!'                          => [ 'Alcatel', 'One Touch S\'Pop' ],
    'one ?touch 4030!'                          => [ 'Alcatel', 'One Touch S\'Pop' ],
    'one ?touch 4031!'                          => [ 'Alcatel', 'One Touch Flash Mini' ],
    'one ?touch 4032!'                          => [ 'Alcatel', 'One Touch Pop C2' ],
    '4032[ADEX]!'                               => [ 'Alcatel', 'One Touch Pop C2' ],
    'one ?touch 4033!'                          => [ 'Alcatel', 'One Touch Pop C3' ],
    '4033[AL]!'                                 => [ 'Alcatel', 'One Touch Pop C3' ],
    'ONETOUCH POPC3'                            => [ 'Alcatel', 'One Touch Pop C3' ],
    '4034[ADEFGX]!'                             => [ 'Alcatel', 'One Touch Pixi 4 (4)' ],
    'one ?touch 40(35|36|37)!'                  => [ 'Alcatel', 'One Touch Pop D3' ],
    '4035[ADYX]!'                               => [ 'Alcatel', 'One Touch Pop D3' ],
    '4036[E]!'                                  => [ 'Alcatel', 'One Touch Pop D3' ],
    '4037[AX]!'                                 => [ 'Alcatel', 'One Touch Pop D3' ],
    '4037[T]!'                                  => [ 'Alcatel', 'One Touch Evolve 2' ],
    '4037[V]!'                                  => [ 'Alcatel', 'One Touch Elevate' ],
    'one ?touch 5045!'                          => [ 'Alcatel', 'One Touch Pop 2 (4)' ],
    '4045[ADELOX]!'                             => [ 'Alcatel', 'One Touch Pop 2 (4)' ],
    '4055[JU]!'                                 => [ 'Alcatel', 'One Touch Pixi 5 (4)' ],
    '4060[A]!'                                  => [ 'Alcatel', 'IDEAL' ],
    '4060[W]!'                                  => [ 'Alcatel', 'One Touch Pixi 4 (5)' ],
    '5010[DEGSUX]!'                             => [ 'Alcatel', 'One Touch Pixi 4 (5)' ],
    '5012[G]!'                                  => [ 'Alcatel', 'One Touch Pixi 4 (5.5)' ],
    '5015[ADEX]!'                               => [ 'Alcatel', 'One Touch Pixi 3 (5)' ],
    '5016[AJ]!'                                 => [ 'Alcatel', 'One Touch Pixi 3 (5)' ],
    '5017[B]!'                                  => [ 'Alcatel', 'One Touch Elevate' ],
    '5017[ADEOX]!'                              => [ 'Alcatel', 'One Touch Pixi 3 (4.5)' ],
    '5019[D]!'                                  => [ 'Alcatel', 'One Touch Pixi 3 (4.5)' ],
    'one ?touch 5020!'                          => [ 'Alcatel', 'One Touch M\'Pop' ],
    'Alcatel OT M\'pop 5020D'                   => [ 'Alcatel', 'One Touch M\'Pop' ],
    'M POP 5020A'                               => [ 'Alcatel', 'One Touch M\'Pop' ],
    'M POP'                                     => [ 'Alcatel', 'One Touch M\'Pop' ],
    '5020[A]!'                                  => [ 'Alcatel', 'One Touch M\'Pop' ],
    'one ?touch 5021!'                          => [ 'Alcatel', 'One Touch Soleil' ],
    '5022[DEX]!'                                => [ 'Alcatel', 'One Touch Pop Star' ],
    '5023[F]!'                                  => [ 'Alcatel', 'One Touch Pixi 4 Plus Power' ],
    '5025[DEGX]!'                               => [ 'Alcatel', 'One Touch Pop 3' ],
    '5027[B]!'                                  => [ 'Alcatel', 'One Touch Dawn' ],
    'one ?touch 5035!'                          => [ 'Alcatel', 'One Touch X\'Pop' ],
    '5036[D]!'                                  => [ 'Alcatel', 'One Touch Pop C5' ],
    'one ?touch 50(36|37)!'                     => [ 'Alcatel', 'One Touch Pop C5' ],
    'ONETOUCH POPC5'                            => [ 'Alcatel', 'One Touch Pop C5' ],
    'one ?touch 50(38)!'                        => [ 'Alcatel', 'One Touch Pop D5' ],
    '5038[ADEX]!'                               => [ 'Alcatel', 'One Touch Pop D5' ],
    'one ?touch 5042!'                          => [ 'Alcatel', 'One Touch Pop 2 (4.5)' ],
    '5042[ADEFGTWXY]!'                          => [ 'Alcatel', 'One Touch Pop 2 (4.5)' ],
    '5044[DOY]!'                                => [ 'Alcatel', 'U5' ],
    '5045[ADGJTX]!'                             => [ 'Alcatel', 'One Touch Pixi 4 (5.0)' ],
    '5046[Y]!'                                  => [ 'Alcatel', 'A3' ],
    'one ?touch 5050!'                          => [ 'Alcatel', 'One Touch Pop S3' ],
    '5050[ASYX]!'                               => [ 'Alcatel', 'One Touch Pop S3' ],
    '5051[ADJMX]!'                              => [ 'Alcatel', 'One Touch Pop 4 (5.0)' ],
    '5054[ADOSTX]!'                             => [ 'Alcatel', 'One Touch Pixi 3 (5.5)' ],
    '5054[NW]!'                                 => [ 'Alcatel', 'One Touch Fierce XL' ],
    '5056[ADENUWX]!'                            => [ 'Alcatel', 'One Touch Pop 4+' ],
    '5056[O]!'                                  => [ 'Alcatel', 'One Touch Allura' ],
    '5057[M]!'                                  => [ 'Alcatel', 'One Touch Pop Mirage' ],
    '5065[ADJNWX]!'                             => [ 'Alcatel', 'One Touch Pixi 3 (5)' ],
    '5070[DJX]!'                                => [ 'Alcatel', 'One Touch Pop Star' ],
    '5080[DX]!'                                 => [ 'Alcatel', 'One Touch Pixi 4 (6)' ],
    '5085[CD]!'                                 => [ 'Alcatel', 'A5 LED' ],
    '5095[BIKY]!'                               => [ 'Alcatel', 'One Touch Pop 4S' ],
    '5096[A]!'                                  => [ 'Alcatel', 'One Touch Net' ],
    '5098[OS]!'                                 => [ 'Alcatel', 'One Touch Pixi 4 (6)' ],
    'one ?touch 6010!'                          => [ 'Alcatel', 'One Touch Star' ],
    'one ?touch 6012!'                          => [ 'Alcatel', 'One Touch Idol Mini' ],
    'ONE TOUCH IDOL MINI'                       => [ 'Alcatel', 'One Touch Idol Mini' ],
    'one ?touch 6014!'                          => [ 'Alcatel', 'One Touch Idol Mini' ],
    '6014[DX]!'                                 => [ 'Alcatel', 'One Touch Idol Mini' ],
    'one ?touch 6016!'                          => [ 'Alcatel', 'One Touch Idol 2 Mini' ],
    '6016[ADEX]!'                               => [ 'Alcatel', 'One Touch Idol 2 Mini' ],
    'one ?touch 6030!'                          => [ 'Alcatel', 'One Touch Idol' ],
    '6031[X]!'                                  => [ 'Alcatel', 'One Touch Idol Ultra' ],
    'one ?touch 6032!'                          => [ 'Alcatel', 'One Touch Idol α' ],
    'one ?touch 6033!'                          => [ 'Alcatel', 'One Touch Idol Ultra' ],
    'one ?touch 60(34|35)!'                     => [ 'Alcatel', 'One Touch Idol S' ],
    'one ?touch 6036!'                          => [ 'Alcatel', 'One Touch Idol 2 Mini S' ],
    '6036[AYX]!'                                => [ 'Alcatel', 'One Touch Idol 2 Mini S' ],
    'one ?touch 6037!'                          => [ 'Alcatel', 'One Touch Idol 2 Dual' ],
    '6037[BIKY]!'                               => [ 'Alcatel', 'One Touch Idol 2 Dual' ],
    'one ?touch 6039!'                          => [ 'Alcatel', 'One Touch Idol 3 (4.7)' ],
    '6039[AHJKSY]!'                             => [ 'Alcatel', 'One Touch Idol 3 (4.7)' ],
    'one ?touch 6040!'                          => [ 'Alcatel', 'One Touch Idol X' ],
    '6042[D]!'                                  => [ 'Alcatel', 'One Touch Flash' ],
    'one ?touch 6043!'                          => [ 'Alcatel', 'One Touch Idol X+' ],
    '6043[AD]!'                                 => [ 'Alcatel', 'One Touch Idol X+' ],
    '6044D'                                     => [ 'Alcatel', 'One Touch Pop Up' ],
    'one ?touch 6045!'                          => [ 'Alcatel', 'One Touch Idol 3 (5.5)' ],
    '6045[BFGIKOXY]!'                           => [ 'Alcatel', 'One Touch Idol 3 (5.5)' ],
    'one ?touch 6050!'                          => [ 'Alcatel', 'One Touch Idol 2S' ],
    '6050[AFWY]!'                               => [ 'Alcatel', 'One Touch Idol 2S' ],
    '6055[ABDHIKPUY]!'                          => [ 'Alcatel', 'One Touch Idol 4' ],
    '6070[KOY]!'                                => [ 'Alcatel', 'One Touch Idol 4s' ],
    'one ?touch 7024!'                          => [ 'Alcatel', 'One Touch Fierce' ],
    'one touch fierce!'                         => [ 'Alcatel', 'One Touch Fierce' ],
    'one ?touch 70(25|30)!'                     => [ 'Alcatel', 'One Touch Snap' ],
    '7030[L]!'                                  => [ 'Alcatel', 'One Touch Snap' ],
    'one ?touch 70(40|41)!'                     => [ 'Alcatel', 'One Touch Pop C7' ],
    '7040[NR]!'                                 => [ 'Alcatel', 'One Touch Pop C7' ],
    '7040[T]!'                                  => [ 'Alcatel', 'One Touch Fierce 2' ],
    'one ?touch 7042!'                          => [ 'Alcatel', 'One Touch Snap' ],
    'one ?touch 7043!'                          => [ 'Alcatel', 'One Touch Pop 2 (5)' ],
    '7043[AEKY]!'                               => [ 'Alcatel', 'One Touch Pop 2 (5)' ],
    'one ?touch 7044!'                          => [ 'Alcatel', 'One Touch Pop 2 (5) Premium' ],
    '7044[AXY]!'                                => [ 'Alcatel', 'One Touch Pop 2 (5) Premium' ],
    'one ?touch 7045!'                          => [ 'Alcatel', 'One Touch Pop S7' ],
    '7045[Y]!'                                  => [ 'Alcatel', 'One Touch Pop S7' ],
    '7046[T]!'                                  => [ 'Alcatel', 'One Touch Conquest' ],
    'one ?touch 7047!'                          => [ 'Alcatel', 'One Touch Pop C9' ],
    '7048[ASWX]!'                               => [ 'Alcatel', 'One Touch Go Play' ],
    'one ?touch 7050!'                          => [ 'Alcatel', 'One Touch Pop S9' ],
    '7050[Y]!'                                  => [ 'Alcatel', 'One Touch Pop S9' ],
    '7051[X]!'                                  => [ 'Alcatel', 'One Touch Pop 3 (5)' ],
    '7053[D]!'                                  => [ 'Alcatel', 'X1' ],
    '7055[AW]!'                                 => [ 'Alcatel', 'One Touch Hero 2C' ],
    '7051[X]!'                                  => [ 'Alcatel', 'One Touch Pop 2 (5) Premium' ],
    'one ?touch 8000!'                          => [ 'Alcatel', 'One Touch Scribe Easy' ],
    'one ?touch 8008!'                          => [ 'Alcatel', 'One Touch Scribe HD' ],
    'one ?touch 8020!'                          => [ 'Alcatel', 'One Touch Hero' ],
    '8020[D]!'                                  => [ 'Alcatel', 'One Touch Hero' ],
    'one ?touch 8030!'                          => [ 'Alcatel', 'One Touch Hero 2' ],
    '8030[BY]!'                                 => [ 'Alcatel', 'One Touch Hero 2' ],
    '9001[DX]!'                                 => [ 'Alcatel', 'One Touch Pixi 4 (6)' ],
    '9002[AWX]!'                                => [ 'Alcatel', 'One Touch Pixi 3 (7)', DeviceType::TABLET ],
    '9003[AX]!'                                 => [ 'Alcatel', 'One Touch Pixi 4 (7)', DeviceType::TABLET ],
    '9005[X]!'                                  => [ 'Alcatel', 'One Touch Pixi 3 (8)', DeviceType::TABLET ],
    '9006[W]!'                                  => [ 'Alcatel', 'One Touch Pixi 4 (7)', DeviceType::TABLET ],
    '9007[ATX]!'                                => [ 'Alcatel', 'One Touch Pixi 3 (7)', DeviceType::TABLET ],
    '9008[AIJTUX]!'                             => [ 'Alcatel', 'A3 XL', DeviceType::TABLET ],
    '9010[X]!'                                  => [ 'Alcatel', 'One Touch Pixi 3 (10)', DeviceType::TABLET ],
    '9015[BJW]!'                                => [ 'Alcatel', 'One Touch POP7', DeviceType::TABLET ],
    '9022[SX]!'                                 => [ 'Alcatel', 'One Touch Pixi 3 (8)', DeviceType::TABLET ],
    '9024[W]!'                                  => [ 'Alcatel', 'A30', DeviceType::TABLET ],
    '9025[MQ]!'                                 => [ 'Alcatel', 'One Touch Pop 4 (7)', DeviceType::TABLET ],
    'one ?touch T10!'                           => [ 'Alcatel', 'One Touch T10', DeviceType::TABLET ],
    'one ?touch T20!'                           => [ 'Alcatel', 'One Touch T20', DeviceType::TABLET ],
    'one ?touch T60!'                           => [ 'Alcatel', 'One Touch T60', DeviceType::TABLET ],
    'ONE TOUCH TAB 7'                           => [ 'Alcatel', 'One Touch Tab 7', DeviceType::TABLET ],
    'ONE TOUCH TAB 7HD'                         => [ 'Alcatel', 'One Touch Tab 7HD', DeviceType::TABLET ],
    'ONE TOUCH TAB 8HD'                         => [ 'Alcatel', 'One Touch Tab 8HD', DeviceType::TABLET ],
    'ONE TOUCH EVO7'                            => [ 'Alcatel', 'One Touch Evo 7', DeviceType::TABLET ],
    'onetouch EVO7'                             => [ 'Alcatel', 'One Touch Evo 7', DeviceType::TABLET ],
    'ONE TOUCH E710'                            => [ 'Alcatel', 'One Touch Evo 7 HD', DeviceType::TABLET ],
    'ONE TOUCH EVO 7HD'                         => [ 'Alcatel', 'One Touch Evo 7 HD', DeviceType::TABLET ],
    'ONE TOUCH EVO7HD'                          => [ 'Alcatel', 'One Touch Evo 7 HD', DeviceType::TABLET ],
    'ONE TOUCH EVO8HD'                          => [ 'Alcatel', 'One Touch Evo 8 HD', DeviceType::TABLET ],
    'D820X'                                     => [ 'Alcatel', 'One Touch Hero 8', DeviceType::TABLET ],
    'ONETOUCH POP 7 LTE'                        => [ 'Alcatel', 'One Touch POP7', DeviceType::TABLET ],
    'ONE ?TOUCH P310(A|X)!'                     => [ 'Alcatel', 'One Touch POP7', DeviceType::TABLET ],
    'ONE ?TOUCH P320(A|X)!'                     => [ 'Alcatel', 'One Touch POP8', DeviceType::TABLET ],
    'ONE ?TOUCH P321!'                          => [ 'Alcatel', 'One Touch POP8', DeviceType::TABLET ],
    '9021A'                                     => [ 'Alcatel', 'One Touch POP8', DeviceType::TABLET ],
    'P330X'                                     => [ 'Alcatel', 'One Touch POP7S', DeviceType::TABLET ],
    'P350X'                                     => [ 'Alcatel', 'One Touch POP8S', DeviceType::TABLET ],
    'ONE ?TOUCH POP 8S P350X!'                  => [ 'Alcatel', 'One Touch POP8S', DeviceType::TABLET ],
    'P360X'                                     => [ 'Alcatel', 'One Touch POP10', DeviceType::TABLET ],
    'ADR3010'                                   => [ 'Alcatel', 'Authority' ],
    'Venture'                                   => [ 'Alcatel', 'Venture' ],
    'Mobile Sosh'                               => [ 'Alcatel', 'Le mobile Sosh' ],
    'Alcor Access Q913M'                        => [ 'Alcor', 'Access Q913M', DeviceType::TABLET ],
    'Alcor Zest Q813I'                          => [ 'Alcor', 'Zest Q813I', DeviceType::TABLET ],
    'Alcor Zest Q813IS'                         => [ 'Alcor', 'Zest Q813IS', DeviceType::TABLET ],
    'Alcor Zest Q813IX'                         => [ 'Alcor', 'Zest Q813IX', DeviceType::TABLET ],
    'Alcor Zest Q933R'                          => [ 'Alcor', 'Zest Q933R', DeviceType::TABLET ],
    'ALLVIEW A4ALL'                             => [ 'Allview', 'A4 All' ],
    'A5 Easy'                                   => [ 'Allview', 'A5 Easy' ],
    'A5 Easy TM'                                => [ 'Allview', 'A5 Easy' ],
    'A5 Lite'                                   => [ 'Allview', 'A5 Lite' ],
    'A5 Quad Plus'                              => [ 'Allview', 'A5 Quad Plus' ],
    'A5 Quad Plus TM'                           => [ 'Allview', 'A5 Quad Plus' ],
    'A6 Duo'                                    => [ 'Allview', 'A6 Duo' ],
    'A6 Lite'                                   => [ 'Allview', 'A6 Lite' ],
    'ALLVIEW A6 Quad'                           => [ 'Allview', 'A6 Quad' ],
    'A7 Lite'                                   => [ 'Allview', 'A7 Lite' ],
    'AX3Party'                                  => [ 'Allview', 'AX3 Party' ],
    'AX4Nano plus'                              => [ 'Allview', 'AX4 Nano Plus' ],
    'C6 Duo'                                    => [ 'Allview', 'C6 Duo' ],
    'C6Quad 4G'                                 => [ 'Allview', 'C6 Quad' ],
    'E2 Jump'                                   => [ 'Allview', 'E2 Jump' ],
    'E3 Living'                                 => [ 'Allview', 'E3 Living' ],
    'E3 Sign'                                   => [ 'Allview', 'E3 Sign' ],
    'E4'                                        => [ 'Allview', 'E4' ],
    'E4 Lite'                                   => [ 'Allview', 'E4 Lite' ],
    'ALLVIEW P1'                                => [ 'Allview', 'P1 Alldro' ],
    'Allview P2'                                => [ 'Allview', 'P2 Alldro' ],
    'ALLVIEW P4'                                => [ 'Allview', 'P4 Alldro' ],
    'ALLVIEW P4i'                               => [ 'Allview', 'P4 Duo' ],
    'P4i'                                       => [ 'Allview', 'P4 Duo' ],
    'Allview P5'                                => [ 'Allview', 'P5' ],
    'P5 Energy'                                 => [ 'Allview', 'P5 Energy' ],
    'P5Life'                                    => [ 'Allview', 'P5 Life' ],
    'P5Life TM'                                 => [ 'Allview', 'P5 Life' ],
    'Allview P5-Mini'                           => [ 'Allview', 'P5 Mini' ],
    'ALLVIEW P5 Quad'                           => [ 'Allview', 'P5 Quad' ],
    'ALLVIEW P5 Qmax'                           => [ 'Allview', 'P5 Qmax' ],
    'ALLVIEW P6'                                => [ 'Allview', 'P6' ],
    'P6 Energy'                                 => [ 'Allview', 'P6 Energy' ],
    'P6 Energy TM'                              => [ 'Allview', 'P6 Energy' ],
    'P6 Pro'                                    => [ 'Allview', 'P6 Pro' ],
    'P6 Qmax'                                   => [ 'Allview', 'P6 Qmax' ],
    'ALLVIEW P6 Quad'                           => [ 'Allview', 'P6 Quad' ],
    'P6 Quad'                                   => [ 'Allview', 'P6 Quad' ],
    'P8 Energy'                                 => [ 'Allview', 'P8 Energy' ],
    'P8 Energy mini'                            => [ 'Allview', 'P8 Energy Mini' ],
    'P8 Energy mini TM'                         => [ 'Allview', 'P8 Energy Mini' ],
    'ALLVIEW TX1 Quasar'                        => [ 'Allview', 'TX1 Quasar' ],
    'V1 Viper'                                  => [ 'Allview', 'V1 Viper' ],
    'V1 Viper E'                                => [ 'Allview', 'V1 Viper E' ],
    'V1 Viper I'                                => [ 'Allview', 'V1 Viper I' ],
    'V1 Viper I4G'                              => [ 'Allview', 'V1 Viper I' ],
    'V1 Viper I4G PL'                           => [ 'Allview', 'V1 Viper I' ],
    'V1 Viper I4G TM'                           => [ 'Allview', 'V1 Viper I' ],
    'V1 Viper L'                                => [ 'Allview', 'V1 Viper L' ],
    'V1 ViperS'                                 => [ 'Allview', 'V1 Viper S' ],
    'V1 Viper S4G'                              => [ 'Allview', 'V1 Viper S' ],
    'V1 Viper S4G TM'                           => [ 'Allview', 'V1 Viper S' ],
    'V2 Viper'                                  => [ 'Allview', 'V2 Viper' ],
    'V2 Viper I'                                => [ 'Allview', 'V2 Viper I' ],
    'V2 Viper I TM'                             => [ 'Allview', 'V2 Viper I' ],
    'V2 Viper I4G'                              => [ 'Allview', 'V2 Viper I' ],
    'V2 Viper S'                                => [ 'Allview', 'V2 Viper S' ],
    'V2 Viper X'                                => [ 'Allview', 'V2 Viper X' ],
    'V2 Viper X plus'                           => [ 'Allview', 'V2 Viper X Plus' ],
    'Viva C701'                                 => [ 'Allview', 'Viva C701' ],
    'Viva H701'                                 => [ 'Allview', 'Viva H701' ],
    'Viva H701 LTE CZ'                          => [ 'Allview', 'Viva H701' ],
    'VivaH7LTE'                                 => [ 'Allview', 'Viva H7' ],
    'VivaH8LTE'                                 => [ 'Allview', 'Viva H8' ],
    'H8 Life'                                   => [ 'Allview', 'Viva H8 Life' ],
    'VivaH10LTE'                                => [ 'Allview', 'Viva H10' ],
    'Viva i7G'                                  => [ 'Allview', 'Viva i7G', DeviceType::TABLET ],
    'VIVA i7'                                   => [ 'Allview', 'Viva i9', DeviceType::TABLET ],
    'Viva i10HD'                                => [ 'Allview', 'Viva i10 HD', DeviceType::TABLET ],
    'Viva i701G TM'                             => [ 'Allview', 'Viva i701G', DeviceType::TABLET ],
    'X1 Soul'                                   => [ 'Allview', 'X1 Soul' ],
    'X1 Soul Mini'                              => [ 'Allview', 'X1 Soul Mini' ],
    'X1 mini Soul'                              => [ 'Allview', 'X1 Soul Mini' ],
    'X1 Soul Xtreme'                            => [ 'Allview', 'X1 Soul Xtreme' ],
    'X1 Xtreme Mini'                            => [ 'Allview', 'X1 Xtreme Mini' ],
    'Xtreme X2'                                 => [ 'Allview', 'X2 Extreme' ],
    'X2 Soul'                                   => [ 'Allview', 'X2 Soul' ],
    'ALLVIEW X2 Soul'                           => [ 'Allview', 'X2 Soul' ],
    'X2 Soul Lite'                              => [ 'Allview', 'X2 Soul Lite' ],
    'X2 Soul Lite TM'                           => [ 'Allview', 'X2 Soul Lite' ],
    'X2 Soul Mini'                              => [ 'Allview', 'X2 Soul Mini' ],
    'X2 Soul Mini TM'                           => [ 'Allview', 'X2 Soul Mini' ],
    'X2 Soul PRO'                               => [ 'Allview', 'X2 Soul Pro' ],
    'X2 Soul Style'                             => [ 'Allview', 'X2 Soul Style' ],
    'X2 Soul Style TM'                          => [ 'Allview', 'X2 Soul Style' ],
    'X2 Soul Style Plus'                        => [ 'Allview', 'X2 Soul Style Plus' ],
    'X2 Soul Xtreme'                            => [ 'Allview', 'X2 Soul Xtreme' ],
    'X2 Twin'                                   => [ 'Allview', 'X2 Twin' ],
    'X3 Soul'                                   => [ 'Allview', 'X3 Soul' ],
    'ALLVIEW-X3 Soul'                           => [ 'Allview', 'X3 Soul' ],
    'X3 Soul Lite'                              => [ 'Allview', 'X3 Soul Lite' ],
    'X3 Soul Lite TM'                           => [ 'Allview', 'X3 Soul Lite' ],
    'X3 Soul mini'                              => [ 'Allview', 'X3 Soul Mini' ],
    'X3 Soul PLUS'                              => [ 'Allview', 'X3 Soul Plus' ],
    'X3 Soul PRO'                               => [ 'Allview', 'X3 Soul Pro' ],
    'X3 Soul Style'                             => [ 'Allview', 'X3 Soul Style' ],

    '(Allview|Alldro)!!' => [
        'Allview AX1 Shine'                         => [ 'Allview', 'AX1 Shine', DeviceType::TABLET ],
        'AllviewAX2'                                => [ 'Allview', 'AX2 Frenzy', DeviceType::TABLET ],
        'AllviewAX2Frenzy'                          => [ 'Allview', 'AX2 Frenzy', DeviceType::TABLET ],
        'ALLVIEW SPEEDI'                            => [ 'Allview', 'Alldro Speed', DeviceType::TABLET ],
        'AllviewSpeed'                              => [ 'Allview', 'Alldro Speed', DeviceType::TABLET ],
        'ALLDROSPEED'                               => [ 'Allview', 'Alldro Speed', DeviceType::TABLET ],
        'AllviewSpeedi'                             => [ 'Allview', 'Alldro Speed i', DeviceType::TABLET ],
        'AllviewSpeedDuo'                           => [ 'Allview', 'Alldro Speed Duo', DeviceType::TABLET ],
        'AllviewSpeedEco'                           => [ 'Allview', 'Alldro Speed Eco', DeviceType::TABLET ],
        'AllviewSpeedSatellite'                     => [ 'Allview', 'Alldro Speed Satellite', DeviceType::TABLET ],
        'AllviewSpeedSatelite'                      => [ 'Allview', 'Alldro Speed Satellite', DeviceType::TABLET ],
        'ALLDRO2SPEED'                              => [ 'Allview', 'Alldro Speed 2', DeviceType::TABLET ],
        'Allview2SpeedDuo'                          => [ 'Allview', 'Alldro Speed 2 Duo', DeviceType::TABLET ],
        'Allview 2 Speed QUAD'                      => [ 'Allview', 'Alldro Speed 2 Quad', DeviceType::TABLET ],
        'AllviewSpeed2'                             => [ 'Allview', 'Alldro Speed 2', DeviceType::TABLET ],
        'AllviewSpeed2+'                            => [ 'Allview', 'Alldro Speed 2', DeviceType::TABLET ],
        'AllviewSpeed3'                             => [ 'Allview', 'Alldro Speed 3', DeviceType::TABLET ],
        'AllviewSpeed3G'                            => [ 'Allview', 'Alldro Speed 3G', DeviceType::TABLET ],
        'AllviewSpeed3HD'                           => [ 'Allview', 'Alldro Speed 3HD', DeviceType::TABLET ],
        'AllviewSpeed3T'                            => [ 'Allview', 'Alldro Speed 3T', DeviceType::TABLET ],
        'Alldro3Speed DUO'                          => [ 'Allview', 'Alldro Speed 3 Duo', DeviceType::TABLET ],
        'Allview3SpeedQuad'                         => [ 'Allview', 'Alldro Speed 3 Quad', DeviceType::TABLET ],
        'Allview3SpeedQUADHD'                       => [ 'Allview', 'Alldro Speed 3 Quad HD', DeviceType::TABLET ],
        'AllviewCity'                               => [ 'Allview', 'Alldro City', DeviceType::TABLET ],
        'AllviewCityPlus'                           => [ 'Allview', 'Alldro City Plus', DeviceType::TABLET ],
        'AllviewCityLife'                           => [ 'Allview', 'Alldro City Life', DeviceType::TABLET ],
        'ALLVIEW VIPER I'                           => [ 'Allview', 'Viper I', DeviceType::TABLET ],
        'Allview Viva H8'                           => [ 'Allview', 'Viva H8', DeviceType::TABLET ],
        'ALLVIEW3CONECT'                            => [ 'Allview', '3 Conect', DeviceType::TABLET ],
    ],

    'A10'                                       => [ 'AllWinner', 'A10', DeviceType::TABLET ],
    'Allwinner A10'                             => [ 'AllWinner', 'A10', DeviceType::TABLET ],
    '97FC'                                      => [ 'AllWinner', 'A10 97FC', DeviceType::TABLET ],
    'A13-?MID!'                                 => [ 'AllWinner', 'A13', DeviceType::TABLET ],
    'SoftwinerEvb'                              => [ 'AllWinner', 'A13', DeviceType::TABLET ],
    'SoftwinerEvb0308'                          => [ 'AllWinner', 'A13', DeviceType::TABLET ],
    'SoftwinerEvd'                              => [ 'AllWinner', 'A13', DeviceType::TABLET ],
    'Softwinerkf026'                            => [ 'AllWinner', 'A13', DeviceType::TABLET ],
    'Softwinerf721'                             => [ 'AllWinner', 'F721', DeviceType::TABLET ],
    'Softwinerf761'                             => [ 'AllWinner', 'F761', DeviceType::TABLET ],
    'Softwinerf761I'                            => [ 'AllWinner', 'F761', DeviceType::TABLET ],
    'Softwinerf900'                             => [ 'AllWinner', 'F900', DeviceType::TABLET ],
    'SoftwinerEvbV13'                           => [ 'AllWinner', 'V13', DeviceType::TABLET ],
    'GT-I7105'                                  => [ 'Alps', 'GT-I7105' ],
    'GT-I9810'                                  => [ 'Alps', 'GT-I9810' ],
    'AT107F'                                    => [ 'Aluratek', 'Cinepad AT107F', DeviceType::TABLET ],
    'AT108F'                                    => [ 'Aluratek', 'Cinepad AT108F', DeviceType::TABLET ],
    'AT197F'                                    => [ 'Aluratek', 'Cinepad AT197F', DeviceType::TABLET ],
    'Amazon Kindle Fire!'                       => [ 'Amazon', 'Kindle Fire', DeviceType::TABLET ],                             // 1st generation or unknown variant using unofficial firmware
    'Amazon Otter'                              => [ 'Amazon', 'Kindle Fire', DeviceType::TABLET ],                                 // "Otter"  1st generation 7" (1024 x 600)
    'Amazon OtterX'                             => [ 'Amazon', 'Kindle Fire', DeviceType::TABLET ],                                 // "Otter"  1st generation 7" (1024 x 600)
    'Amazon Otter2'                             => [ 'Amazon', 'Kindle Fire', DeviceType::TABLET ],                                 // "Otter2" 2nd generation 7" (1024 x 600)
    'Amazon Tate'                               => [ 'Amazon', 'Kindle Fire HD', DeviceType::TABLET ],                              // "Tate"   2nd generation 7" HD (1280 x 800)
    'Amazon Jem'                                => [ 'Amazon', 'Kindle Fire HD 8.9"', DeviceType::TABLET ],                         // "Jem"    2nd generation 8.9" HD (1920 x 1200)
    'soho'                                      => [ 'Amazon', 'Kindle Fire HD (2013)', DeviceType::TABLET ],                       // "Soho"   3rd generation 7" HD (1280 x 800)
    'thor'                                      => [ 'Amazon', 'Kindle Fire HDX', DeviceType::TABLET ],                             // "Thor"   3rd generation 7" HDX (1920 x 1200)
    'apollo'                                    => [ 'Amazon', 'Kindle Fire HDX 8.9"', DeviceType::TABLET ],                        // "Apollo" 3rd generation 8.9" HDX (2560 x 1600)
    'Kindle Fire'                               => [ 'Amazon', 'Kindle Fire', DeviceType::TABLET, Flag::FIREOS ],                   // "Otter"  1st generation 7" (1024 x 600)
    'KFOTE?!'                                   => [ 'Amazon', 'Kindle Fire', DeviceType::TABLET, Flag::FIREOS ],                   // "Otter2" 2nd generation 7" (1024 x 600)
    'KFTT'                                      => [ 'Amazon', 'Kindle Fire HD', DeviceType::TABLET, Flag::FIREOS ],                // "Tate"   2nd generation 7" HD (1280 x 800)
    'KFJW(I|A)!'                                => [ 'Amazon', 'Kindle Fire HD 8.9"', DeviceType::TABLET, Flag::FIREOS ],           // "Jem"    2nd generation 8.9" HD (1920 x 1200)
    'KFJMWI'                                    => [ 'Amazon', 'Kindle Fire', DeviceType::TABLET, Flag::FIREOS ],                   //          3rd generation (1280 x 800)
    'KFSOWI'                                    => [ 'Amazon', 'Kindle Fire HD (2013)', DeviceType::TABLET, Flag::FIREOS ],         // "Soho"   3rd generation 7" HD (1280 x 800)
    'KFTHW(I|A)!'                               => [ 'Amazon', 'Kindle Fire HDX', DeviceType::TABLET, Flag::FIREOS ],               // "Thor"   3rd generation 7" HDX (1920 x 1200)
    'KFAPW(I|A)!'                               => [ 'Amazon', 'Kindle Fire HDX 8.9"', DeviceType::TABLET, Flag::FIREOS ],          // "Apollo" 3rd generation 8.9" HDX (2560 x 1600)
    'KFARWI'                                    => [ 'Amazon', 'Fire HD 6', DeviceType::TABLET, Flag::FIREOS ],                     // 4th generation 6" HD (1280 x 800)
    'KFASWI'                                    => [ 'Amazon', 'Fire HD 7', DeviceType::TABLET, Flag::FIREOS ],                     // 4th generation 7" HD (1280 x 800)
    'KFSAW(I|A)!'                               => [ 'Amazon', 'Fire HDX 8.9" (2014)', DeviceType::TABLET, Flag::FIREOS ],          // 4th generation 8.9" HDX (2560 x 1600)
    'KFFOWI'                                    => [ 'Amazon', 'Fire', DeviceType::TABLET, Flag::FIREOS ],                          // 5th generation 7" (1024 x 600)
    'KFMEWI'                                    => [ 'Amazon', 'Fire HD 8', DeviceType::TABLET, Flag::FIREOS ],                     // 5th generation 8" HD (1280 x 800)
    'KFTBWI'                                    => [ 'Amazon', 'Fire HD 10', DeviceType::TABLET, Flag::FIREOS ],                    // 5th generation 10" HD (1280 x 800)
    // 'KFAUWI'
    // 'KFDOWI'
    // 'KFGIWI'
    // 'KFSLWI'
    // 'KFSUWI'
    'SD4930UR'                                  => [ 'Amazon', 'Fire Phone', DeviceType::MOBILE, Flag::FIREOS ],
    'AFTB'                                      => [ 'Amazon', 'Fire TV', DeviceType::TELEVISION, Flag::FIREOS ],
    'AFTS'                                      => [ 'Amazon', 'Fire TV (2015)', DeviceType::TELEVISION, Flag::FIREOS ],
    'AFTM'                                      => [ 'Amazon', 'Fire TV stick', DeviceType::TELEVISION, Flag::FIREOS ],
    'AFTT'                                      => [ 'Amazon', 'Fire TV stick (2017)', DeviceType::TELEVISION, Flag::FIREOS ],
    'AMI-TT2'                                   => [ 'Amicroe', 'TouchTab II', DeviceType::TABLET ],
    'AMI-TT2C'                                  => [ 'Amicroe', 'TouchTab IIC', DeviceType::TABLET ],
    'AMI-TT2E'                                  => [ 'Amicroe', 'TouchTab IIE', DeviceType::TABLET ],
    'AMI-TT4'                                   => [ 'Amicroe', 'TouchTab IV', DeviceType::TABLET ],
    'AMI-TTS'                                   => [ 'Amicroe', 'TouchTab S', DeviceType::TABLET ],
    'AMI-TTLITE'                                => [ 'Amicroe', 'TouchTab Lite', DeviceType::TABLET ],
    'AMI-TTFORCE'                               => [ 'Amicroe', 'TouchTab Force', DeviceType::TABLET ],
    'AML-MX REF'                                => [ 'AmLogic', 'MX', DeviceType::TABLET ],

    '(AMO-)?AMOI!!' => [
        'AMOI 1570W'                                => [ 'Amoi', '1570W' ],
        'AMOI-A702'                                 => [ 'Amoi', 'A702' ],
        'AMOI A726T'                                => [ 'Amoi', 'A726T' ],
        'AMOI A860w'                                => [ 'Amoi', 'A860W' ],
        'AMOI-A862W'                                => [ 'Amoi', 'A862W' ],
        'AMOI A900T'                                => [ 'Amoi', 'A900T' ],
        'AMOI A900W'                                => [ 'Amoi', 'A900W' ],
        'AMOI A918T'                                => [ 'Amoi', 'A918T' ],
        'AMOI A920'                                 => [ 'Amoi', 'A920' ],
        'AMOI A920T'                                => [ 'Amoi', 'A920T' ],
        'AMOI A920W'                                => [ 'Amoi', 'A920W' ],
        'AMOI A928W'                                => [ 'Amoi', 'A928W' ],
        'AMOI A955T'                                => [ 'Amoi', 'A955T' ],
        'AMO-AMOI E700C'                            => [ 'Amoi', 'E700C' ],
        'AMOI E800C'                                => [ 'Amoi', 'E800C' ],
        'AMOI N79+'                                 => [ 'Amoi', 'N79' ],
        'AMOI N89'                                  => [ 'Amoi', 'N89' ],
        'AMOI N807'                                 => [ 'Amoi', 'N807' ],
        'AMOI N808'                                 => [ 'Amoi', 'N808' ],
        'AMOI N816'                                 => [ 'Amoi', 'N816' ],
        'AMOI N818'                                 => [ 'Amoi', 'N818' ],
        'AMOI N820'                                 => [ 'Amoi', 'N820' ],
        'AMOI N821'                                 => [ 'Amoi', 'N821' ],
        'AMOI[ -]N828!'                             => [ 'Amoi', 'N828' ],
        'AMOI N850'                                 => [ 'Amoi', 'N850' ],
        'AMOI N890'                                 => [ 'Amoi', 'N890' ],
        'AMOI M8228'                                => [ 'Amoi', 'M8228' ],
        'AMOI M8448'                                => [ 'Amoi', 'M8448' ],
        'AMOI M8458'                                => [ 'Amoi', 'M8458' ],
        'AMOI-X4'                                   => [ 'Amoi', 'X4' ],
        'Amoi Q50H'                                 => [ 'Amoi', 'Q50H', DeviceType::TABLET ],
    ],

    'A862W'                                     => [ 'Amoi', 'A862W' ],
    'AMD120'                                    => [ 'AnyDATA', 'AnyTAB AMD120', DeviceType::TABLET ],
    'mw07'                                      => [ 'AOC', 'Breeze MW07', DeviceType::TABLET ],
    'MW0710'                                    => [ 'AOC', 'Breeze MW0710', DeviceType::TABLET ],
    'MW0711'                                    => [ 'AOC', 'Breeze MW0711', DeviceType::TABLET ],
    'MW0712'                                    => [ 'AOC', 'Breeze MW0712', DeviceType::TABLET ],
    'MW0731'                                    => [ 'AOC', 'Breeze MW0731', DeviceType::TABLET ],
    'MW0731PLUS'                                => [ 'AOC', 'Breeze MW0731 Plus', DeviceType::TABLET ],
    'MW0733'                                    => [ 'AOC', 'Breeze MW0733', DeviceType::TABLET ],
    'MW0811'                                    => [ 'AOC', 'Breeze MW0811', DeviceType::TABLET ],
    'MW0812'                                    => [ 'AOC', 'Breeze MW0812', DeviceType::TABLET ],
    'MW0812 V2.0'                               => [ 'AOC', 'Breeze MW0812', DeviceType::TABLET ],
    'MW0821'                                    => [ 'AOC', 'Breeze MW0821', DeviceType::TABLET ],
    'MW0821 V2.0'                               => [ 'AOC', 'Breeze MW0821', DeviceType::TABLET ],
    'MW0821+'                                   => [ 'AOC', 'Breeze MW0821 Plus', DeviceType::TABLET ],
    'MW0831'                                    => [ 'AOC', 'Breeze MW0831', DeviceType::TABLET ],
    'MW0831Plus'                                => [ 'AOC', 'Breeze MW0831 Plus', DeviceType::TABLET ],
    'MW0922'                                    => [ 'AOC', 'Breeze MW0922', DeviceType::TABLET ],
    'MW0931'                                    => [ 'AOC', 'Breeze MW0931', DeviceType::TABLET ],
    'AOLE 828'                                  => [ 'Aole', '828' ],
    'AOSON G18'                                 => [ 'Aoson', 'G18', DeviceType::TABLET ],
    'Aoson M11'                                 => [ 'Aoson', 'M11', DeviceType::TABLET ],
    'M19'                                       => [ 'Aoson', 'M19', DeviceType::TABLET ],
    'Aoson M19'                                 => [ 'Aoson', 'M19', DeviceType::TABLET ],
    'aoson m33'                                 => [ 'Aoson', 'M33', DeviceType::TABLET ],
    'aoson M33 3G'                              => [ 'Aoson', 'M33', DeviceType::TABLET ],
    'AOSON M82T'                                => [ 'Aoson', 'M82T', DeviceType::TABLET ],
    'AOSON M97F'                                => [ 'Aoson', 'M97F', DeviceType::TABLET ],
    'AOSON M106NB'                              => [ 'Aoson', 'M106NB', DeviceType::TABLET ],
    'AOSON M701TG-C'                            => [ 'Aoson', 'M701TG-C', DeviceType::TABLET ],
    'AOSON M706T'                               => [ 'Aoson', 'M706T', DeviceType::TABLET ],
    'AOSON M721S'                               => [ 'Aoson', 'M721S', DeviceType::TABLET ],
    'aoson M787T'                               => [ 'Aoson', 'M787T', DeviceType::TABLET ],
    'AOSON M1016'                               => [ 'Aoson', 'M1016', DeviceType::TABLET ],
    'Apanda.A60!'                               => [ 'Apanda', 'A60' ],
    'apanda-A80S'                               => [ 'Apanda', 'A80S' ],
    'apanda A80S'                               => [ 'Apanda', 'A80S' ],
    'apanda-A80T'                               => [ 'Apanda', 'A80T' ],
    'apanda-A100'                               => [ 'Apanda', 'A100' ],
    'apanda-A101'                               => [ 'Apanda', 'A101' ],
    'Quicki[ -]?([0-9]+)!'                      => [ 'Apollo', 'Quicki $1', DeviceType::TABLET ],
    'Aprix D97+'                                => [ 'Aprix', 'D97+', DeviceType::TABLET ],
    'ARCHM901'                                  => [ 'Archos', 'Arnova M901', DeviceType::TABLET ],
    'AN7CG2'                                    => [ 'Archos', 'Arnova 7c G2', DeviceType::TABLET ],
    'Arnova 7G2'                                => [ 'Archos', 'Arnova 7 G2', DeviceType::TABLET ],
    'AN7G2'                                     => [ 'Archos', 'Arnova 7 G2', DeviceType::TABLET ],
    'AN7G2DTE'                                  => [ 'Archos', 'Arnova 7 G2', DeviceType::TABLET ],
    'AN7G2I'                                    => [ 'Archos', 'Arnova 7 G2', DeviceType::TABLET ],
    'AN7G3'                                     => [ 'Archos', 'Arnova 7 G3', DeviceType::TABLET ],
    'AN7BG2'                                    => [ 'Archos', 'Arnova 7b G2', DeviceType::TABLET ],
    'AN7BG2DT'                                  => [ 'Archos', 'Arnova 7b G2', DeviceType::TABLET ],
    'AN7BG3'                                    => [ 'Archos', 'Arnova 7b G3', DeviceType::TABLET ],
    'AN7CG3'                                    => [ 'Archos', 'Arnova 7c G3', DeviceType::TABLET ],
    'AN7DG3'                                    => [ 'Archos', 'Arnova 7d G3', DeviceType::TABLET ],
    'AN7DG3B'                                   => [ 'Archos', 'Arnova 7d G3', DeviceType::TABLET ],
    'AN7DG3-CP'                                 => [ 'Archos', 'Arnova Childpad', DeviceType::TABLET ],
    'AN7DG3ST-CP'                               => [ 'Archos', 'Arnova Childpad', DeviceType::TABLET ],
    'AN7FG3'                                    => [ 'Archos', 'Arnova 7f G3', DeviceType::TABLET ],
    'AN7HG3'                                    => [ 'Archos', 'Arnova 7h G3', DeviceType::TABLET ],
    'AN7IG3'                                    => [ 'Archos', 'Arnova 7i G3', DeviceType::TABLET ],
    'AN7SP'                                     => [ 'Archos', 'Arnova Soundpad', DeviceType::TABLET ],
    'A80KSC!'                                   => [ 'Archos', 'Arnova 8', DeviceType::TABLET ],
    'ARNOVA8G2'                                 => [ 'Archos', 'Arnova 8 G2', DeviceType::TABLET ],
    'AN8G2'                                     => [ 'Archos', 'Arnova 8 G2', DeviceType::TABLET ],
    'AN8G2I'                                    => [ 'Archos', 'Arnova 8 G2', DeviceType::TABLET ],
    'AN8G3'                                     => [ 'Archos', 'Arnova 8 G3', DeviceType::TABLET ],
    'AN8BG2'                                    => [ 'Archos', 'Arnova 8b G2', DeviceType::TABLET ],
    'AN8BG3'                                    => [ 'Archos', 'Arnova 8b G3', DeviceType::TABLET ],
    'AN8CG3'                                    => [ 'Archos', 'Arnova 8c G3', DeviceType::TABLET ],
    'AN9G2'                                     => [ 'Archos', 'Arnova 9 G2', DeviceType::TABLET ],
    'AN9G2I'                                    => [ 'Archos', 'Arnova 9i G2', DeviceType::TABLET ],
    'AN9G3'                                     => [ 'Archos', 'Arnova 9 G3', DeviceType::TABLET ],
    'A101B'                                     => [ 'Archos', 'Arnova 10', DeviceType::TABLET ],
    'Arnova 10G2'                               => [ 'Archos', 'Arnova 10 G2', DeviceType::TABLET ],
    'A101C'                                     => [ 'Archos', 'Arnova 10 G2', DeviceType::TABLET ],
    'AN10G2'                                    => [ 'Archos', 'Arnova 10 G2', DeviceType::TABLET ],
    'AN10G2-KN'                                 => [ 'Archos', 'Arnova 10 G2', DeviceType::TABLET ],
    'AN10G2-LN'                                 => [ 'Archos', 'Arnova 10 G2', DeviceType::TABLET ],
    'AN10G2I'                                   => [ 'Archos', 'Arnova 10 G2', DeviceType::TABLET ],
    'AN10BG2'                                   => [ 'Archos', 'Arnova 10b G2', DeviceType::TABLET ],
    'AN10BG2DT'                                 => [ 'Archos', 'Arnova 10b G2', DeviceType::TABLET ],
    'AN10BG2I'                                  => [ 'Archos', 'Arnova 10b G2', DeviceType::TABLET ],
    'AN10BG3'                                   => [ 'Archos', 'Arnova 10b G3', DeviceType::TABLET ],
    'AN10BG3DT'                                 => [ 'Archos', 'Arnova 10b G3', DeviceType::TABLET ],
    'AN10CG3'                                   => [ 'Archos', 'Arnova 10c G3', DeviceType::TABLET ],
    'AN10DG3'                                   => [ 'Archos', 'Arnova 10d G3', DeviceType::TABLET ],
    'AN13FP'                                    => [ 'Archos', 'Arnova Familypad', DeviceType::TABLET ],
    'ARNOVA 90G3'                               => [ 'Archos', 'Arnova 90 G3', DeviceType::TABLET ],
    'ARNOVA 90 G4'                              => [ 'Archos', 'Arnova 90 G4', DeviceType::TABLET ],
    'ARNOVA 97G4'                               => [ 'Archos', 'Arnova 97 G4', DeviceType::TABLET ],
    'ARNOVA 101 G4'                             => [ 'Archos', 'Arnova 101 G4', DeviceType::TABLET ],
    'AN8BG3-LZ'                                 => [ 'Archos', 'Lazer 8.0', DeviceType::TABLET ],
    'A101B2-LZ'                                 => [ 'Archos', 'Lazer 10.1', DeviceType::TABLET ],
    'AN10G2-LZ'                                 => [ 'Archos', 'Lazer 10.1', DeviceType::TABLET ],
    'AN10BG3-LZ'                                => [ 'Archos', 'Lazer 10.1', DeviceType::TABLET ],
    'AN7DG3C'                                   => [ 'Archos', 'Tabeo', DeviceType::TABLET ],
    'A32'                                       => [ 'Archos', '32', 'media' ],
    'A35DE'                                     => [ 'Archos', '35 Smart Home Phone' ],
    'A43'                                       => [ 'Archos', '43', 'media' ],
    'ARCHOS 50PL'                               => [ 'Archos', '50PL', 'media' ],
    'ARCHOS 79XE'                               => [ 'Archos', '79XE', 'media' ],
    'Archos5'                                   => [ 'Archos', '5', 'media' ],
    'A70HB'                                     => [ 'Archos', '7 Home Tablet', DeviceType::TABLET ],                   // G7
    'A70BHT'                                    => [ 'Archos', '7 Home Tablet', DeviceType::TABLET ],
    'A70BHT-LZ'                                 => [ 'Archos', '7 Home Tablet', DeviceType::TABLET ],
    'A70BHT-PR'                                 => [ 'Archos', '7 Home Tablet', DeviceType::TABLET ],
    'A70CHT'                                    => [ 'Archos', '7c Home Tablet', DeviceType::TABLET ],
    'A80HF'                                     => [ 'Archos', '8 Home Tablet', DeviceType::TABLET ],
    'A70H'                                      => [ 'Archos', '70 Internet Tablet', DeviceType::TABLET ],          // G8
    'A70S'                                      => [ 'Archos', '70s Internet Tablet', DeviceType::TABLET ],
    'A7EB'                                      => [ 'Archos', '70b eReader', DeviceType::TABLET ],
    'ARCHOS 70it2'                              => [ 'Archos', '70b Internet Tablet', DeviceType::TABLET ],
    'ARCHOS 70it2G8'                            => [ 'Archos', '70b Internet Tablet', DeviceType::TABLET ],
    'Archos 80 Internet Tablet'                 => [ 'Archos', '80 Internet Tablet', DeviceType::TABLET ],
    'A101IT'                                    => [ 'Archos', '101 Internet Tablet', DeviceType::TABLET ],
    'Archos 101 Internet Tablet'                => [ 'Archos', '101 Internet Tablet', DeviceType::TABLET ],
    'AC45BHE'                                   => [ 'Archos', '45b Helium' ],
    'AC50BHE'                                   => [ 'Archos', '50b Helium' ],
    'AC50DHE'                                   => [ 'Archos', '50d Helium' ],
    'AC45NE'                                    => [ 'Archos', '45 Neon' ],

    'Archos!!' => [
        'ARCHOS 80G9'                               => [ 'Archos', '80 G9', DeviceType::TABLET ],
        'ARCHOS 101G9'                              => [ 'Archos', '101 G9', DeviceType::TABLET ],
        'ARCHOS 97XSLG10'                           => [ 'Archos', '97 XS', DeviceType::TABLET ],
        'ARCHOS 80XSK'                              => [ 'Archos', '80 XS', DeviceType::TABLET ],
        'ARCHOS 101G10'                             => [ 'Archos', '101 XS', DeviceType::TABLET ],
        'ARCHOS 101 XS 2'                           => [ 'Archos', '101 XS 2', DeviceType::TABLET ],
        'Archos 101 XS 2 Moi'                       => [ 'Archos', '101 XS 2', DeviceType::TABLET ],
        'Archos 101XS3'                             => [ 'Archos', '101 XS 3', DeviceType::TABLET ],
        'ARCHOS 101b XS2'                           => [ 'Archos', '101b XS 2', DeviceType::TABLET ],
        'Archos 70 Carbon'                          => [ 'Archos', '70 Carbon', DeviceType::TABLET ],
        'ARCHOS 80 Carbon'                          => [ 'Archos', '80 Carbon', DeviceType::TABLET ],
        'ARCHOS 97 CARBON'                          => [ 'Archos', '97 Carbon', DeviceType::TABLET ],
        'Archos 50 Cobalt'                          => [ 'Archos', '50 Cobalt' ],
        'Archos 55 Cobalt Plus'                     => [ 'Archos', '55 Cobalt Plus' ],
        'Archos 55B Cobalt'                         => [ 'Archos', '55b Cobalt' ],
        'ARCHOS 70 Cobalt'                          => [ 'Archos', '70 Cobalt', DeviceType::TABLET ],
        'Archos 70b Cobalt'                         => [ 'Archos', '70b Cobalt', DeviceType::TABLET ],
        'Archos 70c Cobalt'                         => [ 'Archos', '70c Cobalt', DeviceType::TABLET ],
        'Archos 79 Cobalt'                          => [ 'Archos', '79 Cobalt', DeviceType::TABLET ],
        'ARCHOS 80 COBALT'                          => [ 'Archos', '80 Cobalt', DeviceType::TABLET ],
        'Archos 97 Cobalt'                          => [ 'Archos', '97 Cobalt', DeviceType::TABLET ],
        'Archos 101 Cobalt'                         => [ 'Archos', '101 Cobalt', DeviceType::TABLET ],
        'Archos 70 Copper'                          => [ 'Archos', '70 Copper', DeviceType::TABLET ],
        'Archos 70b Copper'                         => [ 'Archos', '70b Copper', DeviceType::TABLET ],
        'Archos 90 Copper'                          => [ 'Archos', '90 Copper', DeviceType::TABLET ],
        'Archos 90b Copper'                         => [ 'Archos', '90b Copper', DeviceType::TABLET ],
        'Archos 101 Copper'                         => [ 'Archos', '101 Copper', DeviceType::TABLET ],
        'Archos 101b Copper'                        => [ 'Archos', '101b Copper', DeviceType::TABLET ],
        'Archos 101c Copper'                        => [ 'Archos', '101c Copper', DeviceType::TABLET ],
        'Archos 50 Diamond'                         => [ 'Archos', '50 Diamond' ],
        'Archos 55 Diamond 2 Plus'                  => [ 'Archos', '55 Diamond 2 Plus' ],
        'Archos 55 diamond Selfie'                  => [ 'Archos', '55 Diamond Selfie' ],
        'Archos Diamond S'                          => [ 'Archos', 'Diamond S' ],
        'Archos Diamond Plus'                       => [ 'Archos', 'Diamond Plus' ],
        'Archos 40 Helium'                          => [ 'Archos', '40 Helium' ],
        'Archos 45 Helium 4G'                       => [ 'Archos', '45 Helium' ],
        'ARCHOS 45b Helium'                         => [ 'Archos', '45b Helium' ],
        'Archos 45c Helium'                         => [ 'Archos', '45c Helium' ],
        'Archos 50 Helium 4G'                       => [ 'Archos', '50 Helium' ],
        'Archos 50b Helium 4G'                      => [ 'Archos', '50b Helium' ],
        'Archos 50c Helium'                         => [ 'Archos', '50c Helium' ],
        'Archos 50d Helium'                         => [ 'Archos', '50d Helium' ],
        'Archos 50e Helium'                         => [ 'Archos', '50e Helium' ],
        'Archos 50f Helium'                         => [ 'Archos', '50f Helium' ],
        'Archos 50 Helium Plus'                     => [ 'Archos', '50 Helium Plus' ],
        'Archos 55 Helium'                          => [ 'Archos', '55 Helium' ],
        'Archos 55 Helium Plus'                     => [ 'Archos', '55 Helium Plus' ],
        'Archos 70 Helium'                          => [ 'Archos', '70 Helium', DeviceType::TABLET ],
        'Archos 70b Helium'                         => [ 'Archos', '70b Helium', DeviceType::TABLET ],
        'Archos 80 Helium 4G'                       => [ 'Archos', '80 Helium', DeviceType::TABLET ],
        'Archos 80b Helium'                         => [ 'Archos', '80b Helium', DeviceType::TABLET ],
        'Archos 80b Helium v2'                      => [ 'Archos', '80b Helium', DeviceType::TABLET ],
        'Archos 101 Helium'                         => [ 'Archos', '101 Helium', DeviceType::TABLET ],
        'Archos 101c Helium'                        => [ 'Archos', '101c Helium', DeviceType::TABLET ],
        'ARCHOS 101 Magnus'                         => [ 'Archos', '101 Magnus', DeviceType::TABLET ],
        'Archos 40 Neon'                            => [ 'Archos', '40 Neon' ],
        'Archos 45 Neon'                            => [ 'Archos', '45 Neon' ],
        'Archos 45b Neon'                           => [ 'Archos', '45b Neon' ],
        'Archos 50 Neon'                            => [ 'Archos', '50 Neon' ],
        'ARCHOS 50c Neon'                           => [ 'Archos', '50c Neon' ],
        'Archos 50b Neon'                           => [ 'Archos', '50b Neon' ],
        'Archos 50d Neon'                           => [ 'Archos', '50d Neon' ],
        'Archos 50e Neon'                           => [ 'Archos', '50e Neon' ],
        'Archos 50f Neon'                           => [ 'Archos', '50f Neon' ],
        'Archos 70 Neon'                            => [ 'Archos', '70 Neon', DeviceType::TABLET ],
        'Archos 70b Neon'                           => [ 'Archos', '70b Neon', DeviceType::TABLET ],
        'Archos 70c Neon'                           => [ 'Archos', '70c Neon', DeviceType::TABLET ],
        'Archos 79 Neon'                            => [ 'Archos', '79 Neon', DeviceType::TABLET ],
        'Archos 79b Neon'                           => [ 'Archos', '79b Neon', DeviceType::TABLET ],
        'Archos 79c Neon'                           => [ 'Archos', '79c Neon', DeviceType::TABLET ],
        'Archos 90 Neon'                            => [ 'Archos', '90 Neon', DeviceType::TABLET ],
        'Archos 90b Neon'                           => [ 'Archos', '90b Neon', DeviceType::TABLET ],
        'Archos 97 Neon'                            => [ 'Archos', '97 Neon', DeviceType::TABLET ],
        'Archos 101 Neon'                           => [ 'Archos', '101 Neon', DeviceType::TABLET ],
        'Archos 101b Neon'                          => [ 'Archos', '101b Neon', DeviceType::TABLET ],
        'Archos 101c Neon'                          => [ 'Archos', '101c Neon', DeviceType::TABLET ],
        'Archos 101d Neon'                          => [ 'Archos', '101d Neon', DeviceType::TABLET ],
        'Archos 101e Neon'                          => [ 'Archos', '101e Neon', DeviceType::TABLET ],
        'Archos 116 Neon'                           => [ 'Archos', '116 Neon', DeviceType::TABLET ],
        'Archos 121 Neon'                           => [ 'Archos', '121 Neon', DeviceType::TABLET ],
        'Archos 50 Oxygen'                          => [ 'Archos', '50 Oxygen' ],
        'Archos 50b Oxygen'                         => [ 'Archos', '50b Oxygen' ],
        'Archos 50c Oxygen'                         => [ 'Archos', '50c Oxygen' ],
        'Archos 50d Oxygen'                         => [ 'Archos', '50d Oxygen' ],
        'Archos 50 Oxygen Plus'                     => [ 'Archos', '50 Oxygen Plus' ],
        'Archos 70 Oxygen'                          => [ 'Archos', '70 Oxygen', DeviceType::TABLET ],
        'Archos 80 Oxygen'                          => [ 'Archos', '80 Oxygen', DeviceType::TABLET ],
        'Archos 101 Oxygen'                         => [ 'Archos', '101 Oxygen', DeviceType::TABLET ],
        'Archos 101b Oxygen'                        => [ 'Archos', '101b Oxygen', DeviceType::TABLET ],
        'Archos 133 Oxygen'                         => [ 'Archos', '133 Oxygen', DeviceType::TABLET ],
        'Archos 156 Oxygen'                         => [ 'Archos', '156 Oxygen', DeviceType::TABLET ],
        'Archos 45 Platinum'                        => [ 'Archos', '45 Platinum' ],
        'Archos 45b Platinum'                       => [ 'Archos', '45b Platinum' ],
        'Archos 45c Platinum'                       => [ 'Archos', '45c Platinum' ],
        'Archos 45d Platinum'                       => [ 'Archos', '45d Platinum' ],
        'Archos 50 Platinum'                        => [ 'Archos', '50 Platinum' ],
        'Archos 50 Platinum 4G'                     => [ 'Archos', '50 Platinum' ],
        'Archos 50b Platinum'                       => [ 'Archos', '50b Platinum' ],
        'Archos 50c Platinum'                       => [ 'Archos', '50c Platinum' ],
        'Archos 52 Platinum'                        => [ 'Archos', '52 Platinum' ],
        'Archos 53 Platinum'                        => [ 'Archos', '53 Platinum' ],
        'Archos 5.3s Platinum'                      => [ 'Archos', '53s Platinum' ],
        'Archos 55 Platinum'                        => [ 'Archos', '55 Platinum' ],
        'Archos 55b Platinum'                       => [ 'Archos', '55b Platinum' ],
        'Archos 70 Platinum'                        => [ 'Archos', '70 Platinum', DeviceType::TABLET ],
        'Archos 70 Platinum 3G'                     => [ 'Archos', '70 Platinum', DeviceType::TABLET ],
        'Archos 70 Platinum v3'                     => [ 'Archos', '70 Platinum', DeviceType::TABLET ],
        'ARCHOS 79 Platinum'                        => [ 'Archos', '79 Platinum', DeviceType::TABLET ],
        'ARCHOS 80 Platinum'                        => [ 'Archos', '80 Platinum', DeviceType::TABLET ],
        'ARCHOS 80b PLATINUM'                       => [ 'Archos', '80b Platinum', DeviceType::TABLET ],
        'Archos 80c Platinum'                       => [ 'Archos', '80c Platinum', DeviceType::TABLET ],
        'ARCHOS 97 Platinum'                        => [ 'Archos', '97 Platinum', DeviceType::TABLET ],
        'ARCHOS 97b PLATINUM'                       => [ 'Archos', '97b Platinum', DeviceType::TABLET ],
        'Archos 97c Platinum'                       => [ 'Archos', '97c Platinum', DeviceType::TABLET ],
        'ARCHOS 101 PLATINUM'                       => [ 'Archos', '101 Platinum', DeviceType::TABLET ],
        'Archos 101 Platinum 3G'                    => [ 'Archos', '101 Platinum', DeviceType::TABLET ],
        'Archos 101 Platinium 3G'                   => [ 'Archos', '101 Platinum', DeviceType::TABLET ],
        'Archos 101b Platinium'                     => [ 'Archos', '101b Platinum', DeviceType::TABLET ],
        'Archos 101c Platinum'                      => [ 'Archos', '101c Platinum', DeviceType::TABLET ],
        'Archos 101d Platinum v3'                   => [ 'Archos', '101d Platinum', DeviceType::TABLET ],
        'Archos 40 Power'                           => [ 'Archos', '40 Power' ],
        'Archos 50 Power'                           => [ 'Archos', '50 Power' ],
        'Archos 50 Saphir'                          => [ 'Archos', '50 Saphir' ],
        'Archos 35 Titanium'                        => [ 'Archos', '35 Titanium' ],
        'Archos 35b Titanium'                       => [ 'Archos', '35b Titanium' ],
        'Archos 40 Titanium'                        => [ 'Archos', '40 Titanium' ],
        'Archos 40b Titanium Surround'              => [ 'Archos', '40b Titanium' ],
        'Archos 40c Titanium'                       => [ 'Archos', '40c Titanium' ],
        'ARCHOS 40C TIv2'                           => [ 'Archos', '40c Titanium' ],
        'ARCHOS 40d Titanium'                       => [ 'Archos', '40d Titanium' ],
        'Archos 45 Titanium'                        => [ 'Archos', '45 Titanium' ],
        'Archos 45B Titanium'                       => [ 'Archos', '45b Titanium' ],
        'Archos 45c Titanium'                       => [ 'Archos', '45c Titanium' ],
        'Archos 50 Titanium'                        => [ 'Archos', '50 Titanium' ],
        'Archos 50b Titanium 4G'                    => [ 'Archos', '50b Titanium' ],
        'Archos 53 Titanium'                        => [ 'Archos', '53 Titanium' ],
        'Archos 59 Titanium'                        => [ 'Archos', '59 Titanium' ],
        'ARCHOS 70 Titanium'                        => [ 'Archos', '70 Titanium', DeviceType::TABLET ],
        'ARCHOS 70b TITANIUM'                       => [ 'Archos', '70b Titanium', DeviceType::TABLET ],
        'Archos 70c Titanium'                       => [ 'Archos', '70c Titanium', DeviceType::TABLET ],
        'ARCHOS 80 TITANIUM'                        => [ 'Archos', '80 Titanium', DeviceType::TABLET ],
        'ARCHOS 97 TITANIUMHD'                      => [ 'Archos', '97 Titanium', DeviceType::TABLET ],
        'ARCHOS 97B TITANIUM'                       => [ 'Archos', '97b Titanium', DeviceType::TABLET ],
        'ARCHOS 101 Titanium'                       => [ 'Archos', '101 Titanium', DeviceType::TABLET ],
        'Archos 59 Xenon'                           => [ 'Archos', '59 Xenon' ],
        'Archos 62 Xenon'                           => [ 'Archos', '62 Xenon' ],
        'Archos 64 Xenon'                           => [ 'Archos', '64 Xenon' ],
        'Archos 70 Xenon'                           => [ 'Archos', '70 Xenon', DeviceType::TABLET ],
        'Archos 70b Xenon'                          => [ 'Archos', '70b Xenon', DeviceType::TABLET ],
        'Archos 70c Xenon'                          => [ 'Archos', '70c Xenon', DeviceType::TABLET ],
        'Archos 70 Xenon Color'                     => [ 'Archos', '70 Xenon Color', DeviceType::TABLET ],
        'Archos 79 Xenon'                           => [ 'Archos', '79 Xenon', DeviceType::TABLET ],
        'Archos 80 Xenon'                           => [ 'Archos', '80 Xenon', DeviceType::TABLET ],
        'Archos 80b Xenon'                          => [ 'Archos', '80b Xenon', DeviceType::TABLET ],
        'Archos 80c Xenon'                          => [ 'Archos', '80c Xenon', DeviceType::TABLET ],
        'Archos 80d Xenon'                          => [ 'Archos', '80d Xenon', DeviceType::TABLET ],
        'Archos 96 Xenon'                           => [ 'Archos', '96 Xenon', DeviceType::TABLET ],
        'ARCHOS 97 XENON'                           => [ 'Archos', '97 Xenon', DeviceType::TABLET ],
        'Archos 101 Xenon'                          => [ 'Archos', '101 Xenon', DeviceType::TABLET ],
        'Archos 101 Xenon v2'                       => [ 'Archos', '101 Xenon', DeviceType::TABLET ],
        'Archos 101b Xenon v2'                      => [ 'Archos', '101b Xenon', DeviceType::TABLET ],
        'Archos 101c Xenon'                         => [ 'Archos', '101c Xenon', DeviceType::TABLET ],
        'ARCHOS 101 Xenon Lite'                     => [ 'Archos', '101 Xenon Lite', DeviceType::TABLET ],
        'ARCHOS 80 CHILDPAD'                        => [ 'Archos', '80 Childpad', DeviceType::TABLET ],
        'ARCHOS 101 CHILDPAD'                       => [ 'Archos', '101 Childpad', DeviceType::TABLET ],
        'Archos Access 45 4G'                       => [ 'Archos', 'Access 45' ],
        'Archos Chefpad'                            => [ 'Archos', 'ChefPad', DeviceType::TABLET ],
        'ARCHOS GAMEPAD'                            => [ 'Archos', 'Gamepad', [ DeviceType::GAMING, DeviceSubType::PORTABLE ] ],
        'ARCHOS GAMEPAD2'                           => [ 'Archos', 'Gamepad 2', [ DeviceType::GAMING, DeviceSubType::PORTABLE ] ],
        'ARCHOS FAMILYPAD 2'                        => [ 'Archos', 'Familypad 2', DeviceType::TABLET ],
        'Archos 101 DB'                             => [ 'Archos', 'ArcBook', DeviceType::TABLET ],
        'Archos Smart Home Tablet'                  => [ 'Archos', 'Smart Home Tablet', DeviceType::TABLET ],
        'ARCHOS LUDOG10'                            => [ 'Archos', 'TV Connect', DeviceType::TELEVISION ],
    ],

    'Artes D708'                                => [ 'Artes', 'D708', DeviceType::TABLET ],
    'Artes D821'                                => [ 'Artes', 'D821', DeviceType::TABLET ],
    'D9702'                                     => [ 'Artes', 'D9702', DeviceType::TABLET ],
    'Artes i701'                                => [ 'Artes', 'i701', DeviceType::TABLET ],
    'ARTES I709'                                => [ 'Artes', 'i709', DeviceType::TABLET ],
    'Artes Q812'                                => [ 'Artes', 'Q812', DeviceType::TABLET ],
    'AT10H-A10WP'                               => [ 'Artview', 'AT10H-A10WP', DeviceType::TABLET ],
    'Arya A1+'                                  => [ 'Arya', 'A1 Plus' ],
    'Arya Z2'                                   => [ 'Arya', 'Z2' ],

    'ASK SP[0-9]{3,3}!!' => [
        'ASK SP440 3G'                              => [ 'ASK', 'SP440' ],
        'ASK SP460 HD'                              => [ 'ASK', 'SP460 HD' ],
        'ASK SP461 3G'                              => [ 'ASK', 'SP461' ],
        'ASK SP510 HD'                              => [ 'ASK', 'SP510 HD' ],
        'ASK SP516 IPS'                             => [ 'ASK', 'SP516' ],
        'ASK SP516+ IPS'                            => [ 'ASK', 'SP516+' ],
        'ASK SP551 HD'                              => [ 'ASK', 'SP551 HD' ],
        'ASK SP551+HD'                              => [ 'ASK', 'SP551+ HD' ],
        'ASK SP553 HD'                              => [ 'ASK', 'SP553 HD' ],
        'ASK SP554 HD'                              => [ 'ASK', 'SP554 HD' ],
        'ASK SP554+ HD'                             => [ 'ASK', 'SP554+ HD' ],
        'ASK SP581 HD'                              => [ 'ASK', 'SP581 HD' ],
        'ASK SP583 HD'                              => [ 'ASK', 'SP583 HD' ],
        'ASK SP584 FHD'                             => [ 'ASK', 'SP584 FHD' ],
        'ASK SP591'                                 => [ 'ASK', 'SP591' ],
        'ASK SP628 HD'                              => [ 'ASK', 'SP628 HD' ],
    ],

    'ASTRI'                                     => [ 'ASTRI', 'e-reader', DeviceType::EREADER ],
    'eeepc'                                     => [ 'Asus', 'Eee Pc' ],
    'asus laptop'                               => [ 'Asus', 'Eee Pc' ],
    'eee 701'                                   => [ 'Asus', 'Eee Pc' ],
    'OMS TTD'                                   => [ 'Asus', 'Eee Pc T10' ],
    'ASUS T20'                                  => [ 'Asus', 'Eee Pc T20' ],
    'ME102A'                                    => [ 'Asus', 'MeMO Pad 10 (ME102A)', DeviceType::TABLET ],
    'ME180A'                                    => [ 'Asus', 'MeMO Pad HD 8 (ME180A)', DeviceType::TABLET ],
    'ME171'                                     => [ 'Asus', 'Eee Pad MeMO (ME171)', DeviceType::TABLET ],
    'ME172V'                                    => [ 'Asus', 'MeMO Pad (ME172V)', DeviceType::TABLET ],
    'ME173X'                                    => [ 'Asus', 'MeMO Pad HD 7 (ME173X)', DeviceType::TABLET ],
    'ME301T'                                    => [ 'Asus', 'MeMO Pad Smart 10 (ME301T)', DeviceType::TABLET ],
    'ME302C'                                    => [ 'Asus', 'MeMO Pad 10 (ME302C)', DeviceType::TABLET ],
    'ME302KL'                                   => [ 'Asus', 'MeMO Pad FHD 10 (ME302KL)', DeviceType::TABLET ],
    'ASUS Pad ME370T'                           => [ 'Asus', 'Eee Pad MeMO (ME370T)', DeviceType::TABLET ],
    'ME370T'                                    => [ 'Asus', 'Eee Pad MeMO (ME370T)', DeviceType::TABLET ],
    'ME371MG'                                   => [ 'Asus', 'Fonepad (ME371MG)', DeviceType::TABLET ],
    'Asus Fonepad ME371MG 8GB'                  => [ 'Asus', 'Fonepad (ME371MG)', DeviceType::TABLET ],
    'ME372CG'                                   => [ 'Asus', 'Fonepad 7 (ME372CG)', DeviceType::TABLET ],
    'ME372CL-FF'                                => [ 'Asus', 'Fonepad 7 (ME372CL)', DeviceType::TABLET ],
    'ME560CG'                                   => [ 'Asus', 'Fonepad Note 6 (ME560CG)', DeviceType::TABLET ],
    'ME581CL'                                   => [ 'Asus', 'MeMO Pad 8 (ME581CL)', DeviceType::TABLET ],
    'Slider SL101'                              => [ 'Asus', 'Eee Pad Slider', DeviceType::TABLET ],
    'EPAD'                                      => [ 'Asus', 'Eee Pad Transformer', DeviceType::TABLET ],
    'TF101'                                     => [ 'Asus', 'Eee Pad Transformer', DeviceType::TABLET ],
    'TF101-WiMAX'                               => [ 'Asus', 'Eee Pad Transformer', DeviceType::TABLET ],
    'Transformer'                               => [ 'Asus', 'Eee Pad Transformer', DeviceType::TABLET ],
    'Transformer TF101(G)?!'                    => [ 'Asus', 'Eee Pad Transformer', DeviceType::TABLET ],
    'TF201'                                     => [ 'Asus', 'Eee Pad Transformer Prime', DeviceType::TABLET ],
    'tf201t'                                    => [ 'Asus', 'Eee Pad Transformer Prime', DeviceType::TABLET ],
    '(Eee Pad )?Transformer Prime TF201!'       => [ 'Asus', 'Eee Pad Transformer Prime', DeviceType::TABLET ],
    'Transformer TF201'                         => [ 'Asus', 'Eee Pad Transformer Prime', DeviceType::TABLET ],
    'Transformer TF201G'                        => [ 'Asus', 'Eee Pad Transformer Prime', DeviceType::TABLET ],
    'Transformer Prime'                         => [ 'Asus', 'Eee Pad Transformer Prime', DeviceType::TABLET ],
    'Transformer Prime TF300T'                  => [ 'Asus', 'Eee Pad Transformer Prime', DeviceType::TABLET ],
    'Transformer 300'                           => [ 'Asus', 'Transformer Pad 300', DeviceType::TABLET ],
    'Transformer Pad'                           => [ 'Asus', 'Transformer Pad 300', DeviceType::TABLET ],
    '(Transformer )?(Pad )?TF300(T|TG|TL)!'     => [ 'Asus', 'Transformer Pad 300', DeviceType::TABLET ],
    '(Transformer )?(Pad )?TF502(T)!'           => [ 'Asus', 'Transformer Pad 502', DeviceType::TABLET ],
    'Transformer Pad TF600T'                    => [ 'Asus', 'Transformer Pad 600', DeviceType::TABLET ],
    '(Transformer )?(Pad )?TF700(T|K)!'         => [ 'Asus', 'Transformer Pad Infinity 700', DeviceType::TABLET ],
    'Transformer (Pad )?Infinity!'              => [ 'Asus', 'Transformer Pad Infinity 700', DeviceType::TABLET ],
    'Tablet P1801-T'                            => [ 'Asus', 'Transformer AiO P1801', DeviceType::TABLET ],
    'Tablet P1802-T'                            => [ 'Asus', 'Transformer AiO P1802', DeviceType::TABLET ],
    'PadFone'                                   => [ 'Asus', 'PadFone', DeviceType::TABLET ],
    'PadFone 2'                                 => [ 'Asus', 'PadFone 2', DeviceType::TABLET ],
    'PadFone Infinity'                          => [ 'Asus', 'PadFone Infinity', DeviceType::TABLET ],
    'PadFone Infinity A86'                      => [ 'Asus', 'PadFone Infinity', DeviceType::TABLET ],
    'PadFone T004'                              => [ 'Asus', 'PadFone Infinity', DeviceType::TABLET ],
    'PadFone-T004'                              => [ 'Asus', 'PadFone Infinity', DeviceType::TABLET ],
    'PadFone T008'                              => [ 'Asus', 'PadFone E', DeviceType::TABLET ],
    'PadFone T00C'                              => [ 'Asus', 'PadFone mini', DeviceType::TABLET ],
    'PadFone X'                                 => [ 'Asus', 'PadFone X', DeviceType::TABLET ],
    'PadFone X mini'                            => [ 'Asus', 'PadFone X mini (PF450CL)', DeviceType::TABLET ],
    'ETBW11AA'                                  => [ 'Asus', 'Tough' ],
    'K00C'                                      => [ 'Asus', 'Transformer Pad Infinity', DeviceType::TABLET ],
    'K010'                                      => [ 'Asus', 'Transformer Pad TF103', DeviceType::TABLET ],
    'K010E'                                     => [ 'Asus', 'Transformer Pad TF103', DeviceType::TABLET ],
    'K018'                                      => [ 'Asus', 'Transformer Pad TF103', DeviceType::TABLET ],
    'K014'                                      => [ 'Asus', 'Transformer Pad TF303', DeviceType::TABLET ],
    'K01B'                                      => [ 'Asus', 'Transformer Pad TF303', DeviceType::TABLET ],
    'K00G'                                      => [ 'Asus', 'Fonepad Note 6 (ME560CG)', DeviceType::TABLET ],
    'K00E'                                      => [ 'Asus', 'Fonepad 7 (ME372CG)', DeviceType::TABLET ],
    'K00Y'                                      => [ 'Asus', 'Fonepad 7 (ME372CL)', DeviceType::TABLET ],
    'K00Z'                                      => [ 'Asus', 'Fonepad 7 (ME175CG)', DeviceType::TABLET ],
    'K012'                                      => [ 'Asus', 'Fonepad 7 (FE170CG)', DeviceType::TABLET ],
    'K019'                                      => [ 'Asus', 'Fonepad 7 (FE375CG)', DeviceType::TABLET ],
    'K01F'                                      => [ 'Asus', 'Fonepad 7 (FE171MG)', DeviceType::TABLET ],
    'K01N'                                      => [ 'Asus', 'Fonepad 7 (FE171CG)', DeviceType::TABLET ],
    'K01Q'                                      => [ 'Asus', 'Fonepad 7 (FE375CL)', DeviceType::TABLET ],
    'K016'                                      => [ 'Asus', 'Fonepad 8 (FE380CG)', DeviceType::TABLET ],
    'K01E'                                      => [ 'Asus', 'MeMO Pad (ME103K)', DeviceType::TABLET ],
    'K00X'                                      => [ 'Asus', 'MeMO Pad 7 (ME7530CL)', DeviceType::TABLET ],
    'K00R'                                      => [ 'Asus', 'MeMO Pad 7 (ME572CL)', DeviceType::TABLET ],
    'K007'                                      => [ 'Asus', 'MeMO Pad 7 (ME572C)', DeviceType::TABLET ],
    'K013'                                      => [ 'Asus', 'MeMO Pad 7 (ME176C)', DeviceType::TABLET ],
    'K013C'                                     => [ 'Asus', 'MeMO Pad 7 (ME176C)', DeviceType::TABLET ],
    'K017'                                      => [ 'Asus', 'MeMO Pad 7 (ME170C)', DeviceType::TABLET ],
    'K01A'                                      => [ 'Asus', 'MeMO Pad 7 (ME70C)', DeviceType::TABLET ],
    'MeMO Pad 7'                                => [ 'Asus', 'MeMo Pad 7 (ME375CL)', DeviceType::TABLET ],
    'K012 2'                                    => [ 'Asus', 'MeMO Pad 7 (FE7010CG)', DeviceType::TABLET ],
    'K01U'                                      => [ 'Asus', 'MeMO Pad 7 (ME171C)', DeviceType::TABLET ],
    'K00S'                                      => [ 'Asus', 'MeMO Pad HD 7 (ME175KG)', DeviceType::TABLET ],
    'K00U'                                      => [ 'Asus', 'MeMO Pad HD 7 (ME173XX)', DeviceType::TABLET ],
    'K011'                                      => [ 'Asus', 'MeMO Pad 8 (ME181C)', DeviceType::TABLET ],
    'AST21'                                     => [ 'Asus', 'MeMO Pad 8 AST21', DeviceType::TABLET, 'carrier' => 'au' ],
    'K015'                                      => [ 'Asus', 'MeMO Pad 8 AST21', DeviceType::TABLET, 'carrier' => 'au' ],
    'K01H'                                      => [ 'Asus', 'MeMO Pad 8 (ME581C)', DeviceType::TABLET ],
    'K00L'                                      => [ 'Asus', 'MeMO Pad HD 8 (ME180A)', DeviceType::TABLET ],
    'K00F'                                      => [ 'Asus', 'MeMO Pad 10 (ME102A)', DeviceType::TABLET ],
    'T00C'                                      => [ 'Asus', 'PadFone mini', DeviceType::TABLET ],
    'T00E'                                      => [ 'Asus', 'PadFone mini (PF400CG)', DeviceType::TABLET ],
    'T00N'                                      => [ 'Asus', 'PadFone S (PF500KL)', DeviceType::TABLET ],
    'T00D'                                      => [ 'Asus', 'PadFone X mini (PF450CL)', DeviceType::TABLET ],
    'T00S'                                      => [ 'Asus', 'PadFone X mini (PF450CL)', DeviceType::TABLET ],
    'T00T'                                      => [ 'Asus', 'PadFone X mini (PF450CL)', DeviceType::TABLET ],
    'T001'                                      => [ 'Asus', 'ZenFone 4 (A400CG)' ],
    'T00I'                                      => [ 'Asus', 'ZenFone 4 (A400CG)' ],
    'T00I-D'                                    => [ 'Asus', 'ZenFone 4 (A400CG)' ],
    'A400CG'                                    => [ 'Asus', 'ZenFone 4 (A400CG)' ],
    'T00F'                                      => [ 'Asus', 'ZenFone 5 (A500CG)' ],
    'A500CG'                                    => [ 'Asus', 'ZenFone 5 (A500CG)' ],
    'T00J'                                      => [ 'Asus', 'ZenFone 5 (A501CG)' ],
    'T00J-D'                                    => [ 'Asus', 'ZenFone 5 (A501CG)' ],
    'T00K'                                      => [ 'Asus', 'ZenFone 5 (A502CG)' ],
    'T00P'                                      => [ 'Asus', 'ZenFone 5 LTE (A500KL)' ],
    'Zenfone 5 LTE'                             => [ 'Asus', 'ZenFone 5 LTE (A500KL)' ],
    'T00G'                                      => [ 'Asus', 'ZenFone 6 (A600CG)' ],
    'T00Q'                                      => [ 'Asus', 'ZenFone 4 (A450CG)' ],
    'P001'                                      => [ 'Asus', 'ZenPad C 7.0 (Z170MG)', DeviceType::TABLET ],
    'P001 2'                                    => [ 'Asus', 'ZenPad C 7.0 (Z170MG)', DeviceType::TABLET ],
    'P002'                                      => [ 'Asus', 'ZenPad 7.0 (Z370KL)', DeviceType::TABLET ],
    'P00C'                                      => [ 'Asus', 'ZenPad 10 (Z300M)', DeviceType::TABLET ],
    'P00I'                                      => [ 'Asus', 'ZenPad Z10 (Z500KL)', DeviceType::TABLET ],
    'P01M'                                      => [ 'Asus', 'ZenPad S 8.0 (Z580C)', DeviceType::TABLET ],
    'P01MA'                                     => [ 'Asus', 'ZenPad S 8.0 (Z580CA)', DeviceType::TABLET ],
    'P01T'                                      => [ 'Asus', 'ZenPad 10 (Z300CL)', DeviceType::TABLET ],
    'P01T 1'                                    => [ 'Asus', 'ZenPad 10 (Z300CL)', DeviceType::TABLET ],
    'P01V'                                      => [ 'Asus', 'ZenPad 7.0 (Z370CG)', DeviceType::TABLET ],
    'P01W'                                      => [ 'Asus', 'ZenPad 7.0 (Z370C)', DeviceType::TABLET ],
    'P01Y'                                      => [ 'Asus', 'ZenPad C 7.0 (Z170CG)', DeviceType::TABLET ],
    'P01Z'                                      => [ 'Asus', 'ZenPad C 7.0 (Z170C)', DeviceType::TABLET ],
    'P021'                                      => [ 'Asus', 'ZenPad 10 (Z300CG)', DeviceType::TABLET ],
    'P022'                                      => [ 'Asus', 'ZenPad 8.0 (Z380C)', DeviceType::TABLET ],
    'P023'                                      => [ 'Asus', 'ZenPad 10 (Z300C)', DeviceType::TABLET ],
    'P024'                                      => [ 'Asus', 'ZenPad 8.0 (Z380KL)', DeviceType::TABLET ],
    // ''                                    => [ 'Asus', 'ZenPad 10 (Z300CNL)', DeviceType::TABLET ],
    'A001'                                      => [ 'Asus', 'ZenFone 3 Ultra (ZU680KL)' ],
    'X007D'                                     => [ 'Asus', 'ZenFone Go (ZB552KL)' ],
    'X008D'                                     => [ 'Asus', 'ZenFone 3 Max (ZC520TL)' ],
    'X008DA'                                    => [ 'Asus', 'ZenFone 3 Max (ZC520TL)' ],
    'X008DB'                                    => [ 'Asus', 'ZenFone 3 Max (ZC520TL)' ],
    'X008DC'                                    => [ 'Asus', 'ZenFone 3 Max (ZC520TL)' ],
    'X009D'                                     => [ 'Asus', 'ZenFone Go (ZB450KL)' ],
    'X009DA'                                    => [ 'Asus', 'ZenFone Go (ZB450KL)' ],
    'X009DB'                                    => [ 'Asus', 'ZenFone Go (ZB450KL)' ],
    'X009DD'                                    => [ 'Asus', 'ZenFone Go (ZB450KL)' ],
    'X00AD'                                     => [ 'Asus', 'ZenFone Go (ZB500KL)' ],
    'X00ADC'                                    => [ 'Asus', 'ZenFone Go (ZB500KL)' ],
    'X00BD'                                     => [ 'Asus', 'ZenFone Go (ZB500KG)' ],
    'X00DD'                                     => [ 'Asus', 'ZenFone 3 Max (ZC553KL)' ],
    'X00DDA'                                    => [ 'Asus', 'ZenFone 3 Max (ZC553KL)' ],
    'X00DDB'                                    => [ 'Asus', 'ZenFone 3 Max (ZC553KL)' ],
    'X013D'                                     => [ 'Asus', 'ZenFone Go (ZB551KL)' ],
    'X013DA'                                    => [ 'Asus', 'ZenFone Go (ZB551KL)' ],
    'X013DB'                                    => [ 'Asus', 'ZenFone Go (ZB551KL)' ],
    'X013DC'                                    => [ 'Asus', 'ZenFone Go (ZB551KL)' ],
    'X015D'                                     => [ 'Asus', 'ZenFone 3 Max (ZC550TL)' ],
    'X013DB'                                    => [ 'Asus', 'ZenFone Go TV (ZB551KL)' ],
    'X013DC'                                    => [ 'Asus', 'ZenFone Go (ZB551KL)' ],
    'ZB551KL'                                   => [ 'Asus', 'ZenFone Go (ZB551KL)' ],
    'X014D'                                     => [ 'Asus', 'ZenFone Go (ZB452KG)' ],
    'Z002'                                      => [ 'Asus', 'ZenFone 6 (A601CG)' ],
    'Z007'                                      => [ 'Asus', 'ZenFone C (ZC451CG)' ],
    'ZenFone 2'                                 => [ 'Asus', 'ZenFone 2 (ZE550ML)' ],
    'Z008'                                      => [ 'Asus', 'ZenFone 2 (ZE550ML)' ],
    'Z008D'                                     => [ 'Asus', 'ZenFone 2 (ZE550ML)' ],
    'Z00A'                                      => [ 'Asus', 'ZenFone 2 (ZE551ML)' ],
    'Z00AD'                                     => [ 'Asus', 'ZenFone 2 (ZE551ML)' ],
    'Z00ADA'                                    => [ 'Asus', 'ZenFone 2 (ZE551ML)' ],
    'Z00ADB'                                    => [ 'Asus', 'ZenFone 2 (ZE551ML)' ],
    'Z00AS'                                     => [ 'Asus', 'ZenFone 2 (ZE551ML)' ],
    'Z00D'                                      => [ 'Asus', 'ZenFone 2 (ZE500CL)' ],
    'ZenFone 2E'                                => [ 'Asus', 'ZenFone 2E' ],
    'Z00ED'                                     => [ 'Asus', 'ZenFone 2 Laser (ZE500KL)' ],
    'Z00EDB'                                    => [ 'Asus', 'ZenFone 2 Laser (ZE500KL)' ],
    'Z00LD'                                     => [ 'Asus', 'ZenFone 2 Laser (ZE550KL)' ],
    'Z00LDC'                                    => [ 'Asus', 'ZenFone 2 Laser (ZE550KL)' ],
    'Z00LDD'                                    => [ 'Asus', 'ZenFone 2 Laser (ZE550KL)' ],
    'Z00MD'                                     => [ 'Asus', 'ZenFone 2 Laser (ZE600KL)' ],
    'Z00RD'                                     => [ 'Asus', 'ZenFone 2 Laser (ZE500KG)' ],
    'Z00TD'                                     => [ 'Asus', 'ZenFone 2 Laser (ZE551KL)' ],
    'Z00TDA'                                    => [ 'Asus', 'ZenFone 2 Laser (ZE551KL)' ],
    'Z00WD'                                     => [ 'Asus', 'ZenFone 2 Laser (ZE550KG)' ],
    'Z011D'                                     => [ 'Asus', 'ZenFone 2 Laser (ZE601KL)' ],
    'Z011DD'                                    => [ 'Asus', 'ZenFone 2 Laser (ZE601KL)' ],
    'Z00UD'                                     => [ 'Asus', 'ZenFone Selfie (ZD551KL)' ],
    'Z00UDA'                                    => [ 'Asus', 'ZenFone Selfie (ZD551KL)' ],
    'Z00UDB'                                    => [ 'Asus', 'ZenFone Selfie (ZD551KL)' ],
    'Z00UDC'                                    => [ 'Asus', 'ZenFone Selfie (ZD551KL)' ],
    'Z00UDH'                                    => [ 'Asus', 'ZenFone Selfie (ZD551KL)' ],
    'Z00SD'                                     => [ 'Asus', 'ZenFone Go (ZC451TG)' ],
    'Z00VD'                                     => [ 'Asus', 'ZenFone Go (ZC500TG)' ],
    'Z00XS'                                     => [ 'Asus', 'ZenFone Zoom (ZX551ML)' ],
    'Z00XSA'                                    => [ 'Asus', 'ZenFone Zoom (ZX551ML)' ],
    'Z00XSB'                                    => [ 'Asus', 'ZenFone Zoom (ZX551ML)' ],
    'Z010D'                                     => [ 'Asus', 'ZenFone Max (ZC550KL)' ],
    'Z010DA'                                    => [ 'Asus', 'ZenFone Max (ZC550KL)' ],
    'Z010DB'                                    => [ 'Asus', 'ZenFone Max (ZC550KL)' ],
    'Z010DD'                                    => [ 'Asus', 'ZenFone Max (ZC550KL)' ],
    'Z012D'                                     => [ 'Asus', 'ZenFone 3 (ZE552KL)' ],
    'Z012DA'                                    => [ 'Asus', 'ZenFone 3 (ZE552KL)' ],
    'Z012DB'                                    => [ 'Asus', 'ZenFone 3 (ZE552KL)' ],
    'Z012DC'                                    => [ 'Asus', 'ZenFone 3 (ZE552KL)' ],
    'Z012DE'                                    => [ 'Asus', 'ZenFone 3 (ZE552KL)' ],
    'Z012S'                                     => [ 'Asus', 'ZenFone 3 (ZE552KL)' ],
    'Z016D'                                     => [ 'Asus', 'ZenFone 3 Deluxe (ZS570KL)' ],
    'Z016S'                                     => [ 'Asus', 'ZenFone 3 Deluxe (ZS570KL)' ],
    'Z017D'                                     => [ 'Asus', 'ZenFone 3 Deluxe (ZS570KL)' ],
    'Z017DA'                                    => [ 'Asus', 'ZenFone 3 Deluxe (ZS570KL)' ],
    'Z017DB'                                    => [ 'Asus', 'ZenFone 3 Deluxe (ZS570KL)' ],
    'Z017DC'                                    => [ 'Asus', 'ZenFone 3 Deluxe (ZS570KL)' ],
    'Z01BD'                                     => [ 'Asus', 'ZenFone 3 Laser (ZC551KL)' ],
    'Z01BDA'                                    => [ 'Asus', 'ZenFone 3 Laser (ZC551KL)' ],
    'Z01BDB'                                    => [ 'Asus', 'ZenFone 3 Laser (ZC551KL)' ],
    'Z01BDC'                                    => [ 'Asus', 'ZenFone 3 Laser (ZC551KL)' ],
    'Z01BS'                                     => [ 'Asus', 'ZenFone 3 Laser (ZC551KL)' ],
    'Z01FD'                                     => [ 'Asus', 'ZenFone 3 Deluxe (ZS550KL)' ],
    'Z01HD'                                     => [ 'Asus', 'ZenFone 3 Zoom (ZE553KL)' ],
    'Z01HDA'                                    => [ 'Asus', 'ZenFone 3 Zoom (ZE553KL)' ],
    'Z00YD'                                     => [ 'Asus', 'Live' ],
    'X002'                                      => [ 'Asus', 'Pegasus' ],
    'X003'                                      => [ 'Asus', 'Pegasus' ],
    'X005'                                      => [ 'Asus', 'Pegasus 2 Plus' ],
    'X008'                                      => [ 'Asus', 'Pegasus 3' ],
    'X550'                                      => [ 'Asus', 'Pegasus 2 Plus' ],
    'TX201LA'                                   => [ 'Asus', 'Transformer Book Trio', DeviceType::TABLET ],
    'TX201LAF'                                  => [ 'Asus', 'Transformer Book Trio', DeviceType::TABLET ],
    'asus google cube'                          => [ 'Asus', 'Cube with Google TV', DeviceType::TELEVISION, Flag::GOOGLETV ],
    'google cube'                               => [ 'Asus', 'Cube with Google TV', DeviceType::TELEVISION, Flag::GOOGLETV ],

    'RTC-700A'                                  => [ 'Asus', 'AAEON RTC-700A', DeviceType::TABLET ],

    'Qilive!!' => [
        'Qilive 40'                                 => [ 'Auchan', 'QiLive 4” Smartphone' ],
        'Qilive 45'                                 => [ 'Auchan', 'QiLive 4.5” Smartphone' ],
        'Qilive 50'                                 => [ 'Auchan', 'QiLive 5” Smartphone' ],
        'Qilive 50 QC'                              => [ 'Auchan', 'QiLive 5” Smartphone' ],
        'Qilive 53'                                 => [ 'Auchan', 'QiLive 5.3” Smartphone' ],
        'Qilive 7'                                  => [ 'Auchan', 'QiLive 7” Dual core tablet', DeviceType::TABLET ],
        'Qilive 70v2'                               => [ 'Auchan', 'QiLive 7” Dual core tablet', DeviceType::TABLET ],
        'Qilive 79'                                 => [ 'Auchan', 'QiLive 7.9” Dual core tablet', DeviceType::TABLET ],
        'Qilive 97R-2'                              => [ 'Auchan', 'QiLive 7.9” Quad core tablet', DeviceType::TABLET ],
        'QiLive 8'                                  => [ 'Auchan', 'QiLive 8” Dual core tablet', DeviceType::TABLET ],
        'QiLive 8QC'                                => [ 'Auchan', 'QiLive 8” Quad core tablet', DeviceType::TABLET ],
        'QiLive 97'                                 => [ 'Auchan', 'QiLive 9.7” Dual core tablet', DeviceType::TABLET ],
        'QiLive 97R'                                => [ 'Auchan', 'QiLive 9.7R Quad core tablet', DeviceType::TABLET ],
        'QILIVE 101'                                => [ 'Auchan', 'QiLive 10.1” Dual core tablet', DeviceType::TABLET ],
    ],

    'T-07B'                                     => [ 'AudioSonic', 'T07B', DeviceType::TABLET ],
    'T-800'                                     => [ 'AudioSonic', 'T800', DeviceType::TABLET ],

    'AUX!!' => [
        'AUX 909+P'                                 => [ 'AUX', '909+P' ],
        'AUX 910+'                                  => [ 'AUX', '910+' ],
        'AUX 939+'                                  => [ 'AUX', '939+' ],
        'AUX M959P'                                 => [ 'AUX', 'M959P' ],
        'AUX T5100L'                                => [ 'AUX', 'T5100L' ],
        'AUX V900'                                  => [ 'AUX', 'V900' ],
        'AUX V900P'                                 => [ 'AUX', 'V900P' ],
        'AUX V920'                                  => [ 'AUX', 'V920' ],
        'AUX V920P'                                 => [ 'AUX', 'V920P' ],
        'AUX V926T'                                 => [ 'AUX', 'V926T' ],
        'AUX V950'                                  => [ 'AUX', 'V950' ],
        'AUX V950P'                                 => [ 'AUX', 'V950P' ],
        'AUX V965T'                                 => [ 'AUX', 'V965T' ],
        'AUX W6'                                    => [ 'AUX', 'W6' ],
    ],

    'Numy!!' => [
        'Avea inTouch 2'                            => [ 'Avea', 'inTouch 2', DeviceType::TABLET ],
        'Avea inTouch 3'                            => [ 'Avea', 'inTouch 3', DeviceType::TABLET ],
        'Avea inTouch 3 Large'                      => [ 'Avea', 'inTouch 3', DeviceType::TABLET ],
        'Avea inTouch 4'                            => [ 'Avea', 'inTouch 4', DeviceType::TABLET ],
    ],

    '(Ilium )?Avvio!!' => [
        'Avvio 489'                                 => [ 'Avvio', '489' ],
        'Avvio 710'                                 => [ 'Avvio', '710' ],
        'Avvio 735s'                                => [ 'Avvio', '735' ],
        'Avvio 750'                                 => [ 'Avvio', '750' ],
        'Ilium AVVIO 760'                           => [ 'Avvio', '760' ],
        'AVVIO 765!'                                => [ 'Avvio', '765' ],
        'Avvio 768'                                 => [ 'Avvio', '768' ],
        'Avvio 775'                                 => [ 'Avvio', '775' ],
        'Avvio-775s'                                => [ 'Avvio', '775s' ],
        'Avvio 778'                                 => [ 'Avvio', '778' ],
        'Avvio 780'                                 => [ 'Avvio', '780' ],
        'Avvio 785'                                 => [ 'Avvio', '785' ],
        'Avvio786'                                  => [ 'Avvio', '786' ],
        'Avvio 790'                                 => [ 'Avvio', '790' ],
        'Avvio 790s'                                => [ 'Avvio', '790s' ],
        'Avvio 792'                                 => [ 'Avvio', '792' ],
        'Avvio 792s'                                => [ 'Avvio', '792s' ],
        'Avvio 793'                                 => [ 'Avvio', '793' ],
        'Avvio 794Q'                                => [ 'Avvio', '794Q' ],
        'Avvio L500 Claro'                          => [ 'Avvio', 'L500' ],
        'Avvio PAD'                                 => [ 'Avvio', 'Pad', DeviceType::TABLET ],
        'Avvio PAD10.1'                             => [ 'Avvio', 'Pad', DeviceType::TABLET ],
    ],

    '(Axioo[\- ])?PICO!!' => [
        'PICOphone 2'                               => [ 'Axioo', 'PICOphone 2' ],
        'PICOphone 4'                               => [ 'Axioo', 'PICOphone 4' ],
        'Picophone4'                                => [ 'Axioo', 'PICOphone 4' ],
        'PICOphone4 GDF'                            => [ 'Axioo', 'PICOphone 4' ],
        'PICOphone4 GDX'                            => [ 'Axioo', 'PICOphone 4' ],
        'PICOphone M1'                              => [ 'Axioo', 'PICOphone M1' ],
        'PICOphone M2 (M)'                          => [ 'Axioo', 'PICOphone M2' ],
        'PICOphone M4N M3'                          => [ 'Axioo', 'PICOphone M4N' ],
        'PICOphone M4P M3'                          => [ 'Axioo', 'PICOphone M4P' ],
        'PICOphone M4S(M2/M)'                       => [ 'Axioo', 'PICOphone M4S' ],
        'PICOphone M4U M2 M'                        => [ 'Axioo', 'PICOphone M4U' ],
        'PICOpad S1(7 3G)'                          => [ 'Axioo', 'PICOpad S1', DeviceType::TABLET ],
        'PICOpad 7H(7 3G)'                          => [ 'Axioo', 'PICOpad 7H', DeviceType::TABLET ],
        'PICOpad 7H2 7H(7 3G)'                      => [ 'Axioo', 'PICOpad 7H2', DeviceType::TABLET ],
        'PICOpadGCE'                                => [ 'Axioo', 'PICOpad GCE', DeviceType::TABLET ],
        'Axioo PICOpad GDK'                         => [ 'Axioo', 'PICOpad GDK', DeviceType::TABLET ],
        'PICOpad GDK'                               => [ 'Axioo', 'PICOpad GDK', DeviceType::TABLET ],
        'PICOpad GDS'                               => [ 'Axioo', 'PICOpad GDS', DeviceType::TABLET ],
        'PICOpad GEA'                               => [ 'Axioo', 'PICOpad GEA', DeviceType::TABLET ],
        'PICOpad GEW'                               => [ 'Axioo', 'PICOpad GEW', DeviceType::TABLET ],
        'PICOpad GFI'                               => [ 'Axioo', 'PICOpad GFI', DeviceType::TABLET ],
        'PICOpad GGA'                               => [ 'Axioo', 'PICOpad GGA', DeviceType::TABLET ],
        'PICOpad GGD'                               => [ 'Axioo', 'PICOpad GGD', DeviceType::TABLET ],
        'PICOpad GGG'                               => [ 'Axioo', 'PICOpad GGG', DeviceType::TABLET ],
        'PICOpad GHM'                               => [ 'Axioo', 'PICOpad GHM', DeviceType::TABLET ],
        'Axioo PICOpad GIM'                         => [ 'Axioo', 'PICOpad GIM', DeviceType::TABLET ],
        'PICOpad GJE'                               => [ 'Axioo', 'PICOpad GJE', DeviceType::TABLET ],
        'PICOpad GJT'                               => [ 'Axioo', 'PICOpad GJT', DeviceType::TABLET ],
        'PICOpad-QGN'                               => [ 'Axioo', 'PICOpad QGN', DeviceType::TABLET ],
        'Axioo-VIGO350'                             => [ 'Axioo', 'Vigo 350' ],
        'Axioo-VIGO410'                             => [ 'Axioo', 'Vigo 410' ],
    ],

    '(AXPAD|Axxion)!!' => [
        'AXPAD 7E01'                                => [ 'Axtrom', 'Axpad 7" Series-7E01', DeviceType::TABLET ],
        'AXPAD 7E02'                                => [ 'Axtrom', 'Axpad 7" Series-7E02', DeviceType::TABLET ],
        'AXPAD 7I04'                                => [ 'Axtrom', 'Axpad 7" Series-7I04', DeviceType::TABLET ],
        'AXPAD 9P01'                                => [ 'Axtrom', 'Axpad 9" Series-9P01', DeviceType::TABLET ],
        'Axxion ATAB-701'                           => [ 'Axxion', 'ATAB-701', DeviceType::TABLET ],
        'Axxion ATAB-902'                           => [ 'Axxion', 'ATAB-902', DeviceType::TABLET ],
    ],

    'A10 MID'                                   => [ 'Azhuo', 'A10 MID', DeviceType::TABLET ],
    'A10MID'                                    => [ 'Azhuo', 'A10 MID', DeviceType::TABLET ],

    'Azumi!!' => [
        'Azumi A35C Lite'                           => [ 'Azumi', 'A35c Lite' ],
        'Azumi A35S'                                => [ 'Azumi', 'A35s' ],
        'Azumi A40C'                                => [ 'Azumi', 'A40c' ],
        'Azumi A45T'                                => [ 'Azumi', 'A45t' ],
        'AZUMI A50'                                 => [ 'Azumi', 'A50' ],
        'Azumi A50c'                                => [ 'Azumi', 'A50c' ],
        'AZUMI A50c+'                               => [ 'Azumi', 'A50c+' ],
        'Azumi LT50'                                => [ 'Azumi', 'LT50' ],
        'Azumi KL32'                                => [ 'Azumi', 'KL32' ],
        'Azumi AT7'                                 => [ 'Azumi', 'AT7', DeviceType::TABLET ],
    ],

    '(BDS|BHX|BKO)\-!!' => [
        'BDS-S100'                                  => [ 'B box', 'B tv BDS-S100', DeviceType::TELEVISION ],
        'BDS-S200'                                  => [ 'B box', 'B tv BDS-S200', DeviceType::TELEVISION ],
        'BHX-S100'                                  => [ 'B box', 'B tv BHX-S100', DeviceType::TELEVISION ],
        'BHX-S100 TV'                               => [ 'B box', 'B tv BHX-S100', DeviceType::TELEVISION ],
        'BHX-UH200'                                 => [ 'B box', 'B tv UHD BHX-UH200', DeviceType::TELEVISION ],
        'BKO-S200'                                  => [ 'B box', 'B tv BKO-S200', DeviceType::TELEVISION ],
        'BKO-S200 TV'                               => [ 'B box', 'B tv BKO-S200', DeviceType::TELEVISION ],
    ],

    'Aero A2-110'                               => [ 'Banghó', 'Aero A2 110', DeviceType::TABLET ],
    'NOOK'                                      => [ 'Barnes & Noble', 'NOOK', DeviceType::EREADER ],
    'Nook ?Color!'                              => [ 'Barnes & Noble', 'NOOK Color', DeviceType::EREADER ],
    '(NOOK )?BNRV(200|300)!'                    => [ 'Barnes & Noble', 'NOOK Color', DeviceType::EREADER ],
    'Nook ?Tablet!'                             => [ 'Barnes & Noble', 'NOOK Tablet', DeviceType::EREADER ],
    'NOOK Slate'                                => [ 'Barnes & Noble', 'NOOK Tablet', DeviceType::EREADER ],
    'Barnes & Noble Nook Tablet'                => [ 'Barnes & Noble', 'NOOK Tablet', DeviceType::EREADER ],
    '(NOOK )?BNTV250!'                          => [ 'Barnes & Noble', 'NOOK Tablet', DeviceType::EREADER ],
    '(NOOK )?BNRV350!'                          => [ 'Barnes & Noble', 'NOOK Simple Touch', DeviceType::EREADER ],
    '(NOOK )?BNTV(400)!'                        => [ 'Barnes & Noble', 'NOOK HD Tablet', DeviceType::EREADER ],
    '(NOOK )?BNTV(600)!'                        => [ 'Barnes & Noble', 'NOOK HD+ Tablet', DeviceType::EREADER ],
    '(NOOK )?BNTV(800)!'                        => [ 'Barnes & Noble', 'NOOK BNTV800 Tablet', DeviceType::EREADER ],
    'Barnes & Noble Nook HD'                    => [ 'Barnes & Noble', 'NOOK HD Tablet', DeviceType::EREADER ],
    'Barnes & Noble Nook HD+'                   => [ 'Barnes & Noble', 'NOOK HD+ Tablet', DeviceType::EREADER ],
    'Nook HD'                                   => [ 'Barnes & Noble', 'NOOK HD Tablet', DeviceType::EREADER ],
    'BN Nook HD'                                => [ 'Barnes & Noble', 'NOOK HD Tablet', DeviceType::EREADER ],
    'BN NookHD+'                                => [ 'Barnes & Noble', 'NOOK HD+ Tablet', DeviceType::EREADER ],
    'Nook HD+'                                  => [ 'Barnes & Noble', 'NOOK HD+ Tablet', DeviceType::EREADER ],
    'HY5001'                                    => [ 'Bedove', 'HY5001' ],
    'BenWee 5100'                               => [ 'BenWee', '5100' ],
    'ASP-4300W'                                 => [ 'Bauhn', 'ASP-4300W' ],
    'ASP-4500Z'                                 => [ 'Bauhn', 'ASP-4500Z' ],
    'ASP-5000H'                                 => [ 'Bauhn', 'ASP-5000H' ],
    'AT101-014'                                 => [ 'Bauhn', 'AT101-014', DeviceType::TABLET ],
    'AT101T-114'                                => [ 'Bauhn', 'AT101T-114', DeviceType::TABLET ],
    'WL-101GQC'                                 => [ 'Bauhn', 'WL-101GQC', DeviceType::TABLET ],
    'BEE 9500'                                  => [ 'Bee Mobile', 'Bee 9500' ],

    'BF[ \-]!!' => [
        'BF A8'                                     => [ 'Bellefonte', 'A8' ],
        'BF-A10'                                    => [ 'Bellefonte', 'A10' ],
        'BF A11'                                    => [ 'Bellefonte', 'A11' ],
        'BF A12P'                                   => [ 'Bellefonte', 'A12P' ],
        'BF A16'                                    => [ 'Bellefonte', 'A16' ],
        'BF C7'                                     => [ 'Bellefonte', 'C7' ],
        'BF G11'                                    => [ 'Bellefonte', 'G11' ],
        'BF V5T!'                                   => [ 'Bellefonte', 'V5T' ],
    ],

    'BenQ!!' => [
        'BenQ F5'                                   => [ 'BenQ', 'F5' ],
        'BenQ T3'                                   => [ 'BenQ', 'T3' ],
        'BenQ R71'                                  => [ 'BenQ', 'R71', DeviceType::TABLET ],
    ],

    'BenWee!!' => [
        'BenWee 550S'                               => [ 'BenWee', '550S' ],
        'BenWee 5100S'                              => [ 'BenWee', '5100S' ],
        'BenWee N7'                                 => [ 'BenWee', 'N7' ],
        'BenWee N9'                                 => [ 'BenWee', 'N9' ],
    ],

    'BePhone UN030'                             => [ 'BePhone', 'UN030' ],

    'Best ?sonny!!' => [
        'Best sonny L82'                            => [ 'Best Sonny', 'L82' ],
        'Best sonny LT986'                          => [ 'Best Sonny', 'LT986' ],
        'Best sonny T898'                           => [ 'Best Sonny', 'T898' ],
        'BestsonnyT961'                             => [ 'Best Sonny', 'T961' ],
        'BestsonnyT962'                             => [ 'Best Sonny', 'T962' ],
    ],

    'CA907AAC0G'                                => [ 'Besta', 'CA907AAC0G' ],

    'BFB!!' => [
        'BFB S7'                                    => [ 'BFB', 'S7' ],
        'BFB W9000'                                 => [ 'BFB', 'W9000' ],
        'BFB W9900'                                 => [ 'BFB', 'W9900' ],
    ],

    'BF[0-9]{2,2}00!!' => [
        'BF5200'                                    => [ 'Bifer', 'BF5200' ],
        'BF9100'                                    => [ 'Bifer', 'BF9100' ],
        'BF9200'                                    => [ 'Bifer', 'BF9200' ],
    ],

    'Bird!!' => [
        'BIRD A11C'                                 => [ 'Bird', 'A11C' ],
        'BIRD E700'                                 => [ 'Bird', 'E700' ],
        'Bird-Doeasy E700'                          => [ 'Bird', 'Doeasy E700' ],
        'Bird i7'                                   => [ 'Bird', 'I7' ],
        'Bird i8'                                   => [ 'Bird', 'I8' ],
        'Bird i9'                                   => [ 'Bird', 'I9' ],
        'Bird i500'                                 => [ 'Bird', 'I500' ],
        'Bird i580'                                 => [ 'Bird', 'I580' ],
        'Bird i600'                                 => [ 'Bird', 'I600' ],
        'BIRD I720 WIFI 3000'                       => [ 'Bird', 'I720' ],
        'Bird i900'                                 => [ 'Bird', 'I900' ],
        'Bird L9'                                   => [ 'Bird', 'L9' ],
        'BIRD L108'                                 => [ 'Bird', 'L108' ],
        'Bird LT01'                                 => [ 'Bird', 'LT01' ],
        'Bird LT02'                                 => [ 'Bird', 'LT02' ],
        'BIRD S6'                                   => [ 'Bird', 'S6' ],
        'BIRD T40'                                  => [ 'Bird', 'T40' ],
        'BIRD T900'                                 => [ 'Bird', 'T900' ],
        'Bird T9500'                                => [ 'Bird', 'T9500' ],
        'Bird T9508'                                => [ 'Bird', 'T9508' ],
        'BIRD T9600'                                => [ 'Bird', 'T9600' ],
        'Bird T9608'                                => [ 'Bird', 'T9608' ],
        'BIRD-V8'                                   => [ 'Bird', 'V8' ],
        'BIRD-W3'                                   => [ 'Bird', 'W3' ],
        'BIRD W5'                                   => [ 'Bird', 'W5' ],
        'Bird W188'                                 => [ 'Bird', 'W188' ],
        'Bird XL100'                                => [ 'Bird', 'XL100' ],
    ],

    'T9108'                                     => [ 'Bird', 'T9108' ],
    'BB EH7'                                    => [ 'BestBuy', 'EH7', DeviceType::TABLET ],
    'BB EH7LE'                                  => [ 'BestBuy', 'EH7LE', DeviceType::TABLET ],
    '(BB )?Q5$!'                                => [ 'BlackBerry', 'Q5' ],
    '(BB )?Q10$!'                               => [ 'BlackBerry', 'Q10' ],
    '(BB )?Z10$!'                               => [ 'BlackBerry', 'Z10' ],
    '(BB )?Z30$!'                               => [ 'BlackBerry', 'Z30' ],
    'BLACKBERRY P\'9982'                        => [ 'BlackBerry', 'Porsche Design P\'9982' ],
    'STV100-[0-9]!'                             => [ 'BlackBerry', 'PRIV' ],
    'STH100-[0-9]!'                             => [ 'BlackBerry', 'DTEK50' ],
    'BBA100-[0-9]!'                             => [ 'BlackBerry', 'DTEK60' ],
    'BBB100-[0-9]!'                             => [ 'BlackBerry', 'KEYone' ],
    'BBC100-[0-9]!'                             => [ 'BlackBerry', 'Aurora' ],
    'BBD100-[0-9]!'                             => [ 'BlackBerry', 'Motion' ],
    
    'Endeavour!!' => [
        'Endeavour101'                              => [ 'Blaupunkt', 'Endeavour 101', DeviceType::TABLET ],
        'Endeavour 101G'                            => [ 'Blaupunkt', 'Endeavour 101 G', DeviceType::TABLET ],
        'Endeavour 101M'                            => [ 'Blaupunkt', 'Endeavour 101 M', DeviceType::TABLET ],
        'Endeavour 700BN'                           => [ 'Blaupunkt', 'Endeavour 700 BN', DeviceType::TABLET ],
        'Endeavour 785'                             => [ 'Blaupunkt', 'Endeavour 785', DeviceType::TABLET ],
        'Endeavour 800NG'                           => [ 'Blaupunkt', 'Endeavour 800 NG', DeviceType::TABLET ],
        'Endeavour 1000WS'                          => [ 'Blaupunkt', 'Endeavour 1000 WS', DeviceType::TABLET ],
        'Endeavour 1000QC'                          => [ 'Blaupunkt', 'Endeavour 1000 QC', DeviceType::TABLET ],
        'Endeavour 1001'                            => [ 'Blaupunkt', 'Endeavour 1001', DeviceType::TABLET ],
        'Endeavour 1001 DVB-T'                      => [ 'Blaupunkt', 'Endeavour 1001 DVB-T', DeviceType::TABLET ],
        'Endeavour 1010'                            => [ 'Blaupunkt', 'Endeavour 1010', DeviceType::TABLET ],
        'Endeavour 1013'                            => [ 'Blaupunkt', 'Endeavour 1013', DeviceType::TABLET ],
        'Endeavour 1100'                            => [ 'Blaupunkt', 'Endeavour 1100', DeviceType::TABLET ],
    ],

    '(BLU|DASH|LIFE|NEO|STUDIO|VIVO)!!' => [
        'BLU ADVANCE 3.5'                           => [ 'BLU', 'Advance 3.5' ],
        'BLU ADVANCE 4.0'                           => [ 'BLU', 'Advance 4.0' ],
        'BLU ADVANCE 4.0 L'                         => [ 'BLU', 'Advance 4.0 L' ],
        'BLU ADVANCE 4.0 L2'                        => [ 'BLU', 'Advance 4.0 L2' ],
        'BLU Advance 5.0'                           => [ 'BLU', 'Advance 5.0' ],
        'BLU AMOUR'                                 => [ 'BLU', 'Amour' ],
        'BLU DASH'                                  => [ 'BLU', 'Dash' ],
        'DASH JR'                                   => [ 'BLU', 'Dash Jr' ],
        'BLU DASH JR'                               => [ 'BLU', 'Dash Jr' ],
        'DASH JR 3G'                                => [ 'BLU', 'Dash Jr' ],
        'BLU DASH JR SOCIAL'                        => [ 'BLU', 'Dash Jr Social' ],
        'DASH JR K'                                 => [ 'BLU', 'Dash Jr K' ],
        'DASHJRTV'                                  => [ 'BLU', 'Dash Jr TV' ],
        'DASH JR. 4.0'                              => [ 'BLU', 'Dash Jr 4.0' ],
        'BLU DASH JR 4.0 K'                         => [ 'BLU', 'Dash Jr 4.0 K' ],
        '(BLU )?DASH 3.2!'                          => [ 'BLU', 'Dash 3.2' ],
        'Blu Dash3.5'                               => [ 'BLU', 'Dash 3.5' ],
        'BLU DASH 3.5!'                             => [ 'BLU', 'Dash 3.5' ],
        'DASH 3.5'                                  => [ 'BLU', 'Dash 3.5' ],
        'DASH 3.5 II'                               => [ 'BLU', 'Dash 3.5 II' ],
        'BLU DASH 4.0'                              => [ 'BLU', 'Dash 4.0' ],
        'BLU Dash 4.0 Ce'                           => [ 'BLU', 'Dash 4.0 CE' ],
        'BLU DASH 4.5'                              => [ 'BLU', 'Dash 4.5' ],
        'BLU DASH 5.0'                              => [ 'BLU', 'Dash 5.0' ],
        'DASH 5.0+'                                 => [ 'BLU', 'Dash 5.0+' ],
        'Dash 5.5'                                  => [ 'BLU', 'Dash 5.5' ],
        'BLU DASH5.5'                               => [ 'BLU', 'Dash 5.5' ],
        'BLU DASH MUSIC 4.0'                        => [ 'BLU', 'Dash Music 4.0' ],
        'BLU DASH MUSIC 4.5'                        => [ 'BLU', 'Dash Music 4.5' ],
        'BLU DASH MUSIC II'                         => [ 'BLU', 'Dash Music II' ],
        'DASH MUSIC JR'                             => [ 'BLU', 'Dash Music Jr' ],
        'DASHMUSICJR'                               => [ 'BLU', 'Dash Music Jr' ],
        'DASH C MUSIC'                              => [ 'BLU', 'Dash C Music' ],
        'BLU DASH J'                                => [ 'BLU', 'Dash J' ],
        'BLU DASH L'                                => [ 'BLU', 'Dash L' ],
        'BLU DASH M'                                => [ 'BLU', 'Dash M' ],
        'BLU DASH M2'                               => [ 'BLU', 'Dash M2' ],
        'BLU DASH X'                                => [ 'BLU', 'Dash X' ],
        'BLU DASH X LTE'                            => [ 'BLU', 'Dash X' ],
        'DASH X PLUS'                               => [ 'BLU', 'Dash X Plus' ],
        'DASH X PLUS LTE'                           => [ 'BLU', 'Dash X Plus' ],
        'BLU DASH X2'                               => [ 'BLU', 'Dash X2' ],
        'BLU Elite 3.8'                             => [ 'BLU', 'Elite 3.8' ],
        'BLU ENERGY DIAMOND'                        => [ 'BLU', 'Energy Diamond' ],
        'BLU ENERGY X PLUS'                         => [ 'BLU', 'Energy X Plus' ],
        'BLU LIFE 8'                                => [ 'BLU', 'Life 8' ],
        'BLU LIFE 8 XL'                             => [ 'BLU', 'Life 8 XL' ],
        'BLU LIFE MARK'                             => [ 'BLU', 'Life Mark' ],
        'BLU Life One'                              => [ 'BLU', 'Life One' ],
        'BLU LIFE ONE M'                            => [ 'BLU', 'Life One M' ],
        'BLU LIFE ONE X'                            => [ 'BLU', 'Life One X' ],
        'BLU LIFE ONE XL'                           => [ 'BLU', 'Life One XL' ],
        'LIFE PLAY'                                 => [ 'BLU', 'Life Play' ],
        'LIFE PLAY 2'                               => [ 'BLU', 'Life Play 2' ],
        'BLU LIFE PLAY S'                           => [ 'BLU', 'Life Play S' ],
        'LIFE PLAY X'                               => [ 'BLU', 'Life Play X' ],
        'BLU LIFE PLAY MINI'                        => [ 'BLU', 'Life Play Mini' ],
        'LIFE PRO'                                  => [ 'BLU', 'Life Pro' ],
        'LIFE PURE'                                 => [ 'BLU', 'Life Pure' ],
        'LIFE PURE MINI'                            => [ 'BLU', 'Life Pure Mini' ],
        'LIFE PURE XL'                              => [ 'BLU', 'Life Pure XL' ],
        'BLU Life View'                             => [ 'BLU', 'Life View' ],
        'BLU LIFE XL'                               => [ 'BLU', 'Life XL' ],
        'BLU Magic'                                 => [ 'BLU', 'Magic' ],
        'BLU Neo 3.5'                               => [ 'BLU', 'Neo 3.5' ],
        'Neo 3.5'                                   => [ 'BLU', 'Neo 3.5' ],
        'BLU NEO 5.0'                               => [ 'BLU', 'Neo 5.0' ],
        'BLU Neo JR'                                => [ 'BLU', 'Neo Jr' ],
        'BLU PURE XL'                               => [ 'BLU', 'Pure XL' ],
        'BLU Quattro 4.5'                           => [ 'BLU', 'Quattro 4.5' ],
        'BLU Quattro 4.5 HD'                        => [ 'BLU', 'Quattro 4.5 HD' ],
        'BLU Quattro 5.7HD'                         => [ 'BLU', 'Quattro 5.7 HD' ],
        'BLU SPORT 4.5'                             => [ 'BLU', 'Sport 4.5' ],
        'BLU STAR4.0'                               => [ 'BLU', 'Star 4.0' ],
        'BLU STUDIO 5.0'                            => [ 'BLU', 'Studio 5.0' ],
        'BLU STUDIO 5.0 C'                          => [ 'BLU', 'Studio 5.0c' ],
        'BLU STUDIO 5.0 Ce'                         => [ 'BLU', 'Studio 5.0ce' ],
        'BLU STUDIO 5.0 C HD'                       => [ 'BLU', 'Studio 5.0c HD' ],
        'STUDIO 5.0e'                               => [ 'BLU', 'Studio 5.0e' ],
        'STUDIO 5.0K'                               => [ 'BLU', 'Studio 5.0k' ],
        'Studio 5.0s'                               => [ 'BLU', 'Studio 5.0s' ],
        'BLU Studio 5.0 S II'                       => [ 'BLU', 'Studio 5.0s II' ],
        'Studio 5.0 S II'                           => [ 'BLU', 'Studio 5.0s II' ],
        'Studio-5.0sII'                             => [ 'BLU', 'Studio 5.0s II' ],
        'Studio-5.0-s-II'                           => [ 'BLU', 'Studio 5.0s II' ],
        'BLU STUDIO 5.0 II'                         => [ 'BLU', 'Studio 5.0 II' ],
        'Studio 5.0LTE'                             => [ 'BLU', 'Studio 5.0 LTE' ],
        'Studio 5.0 HD LTE'                         => [ 'BLU', 'Studio 5.0 HD LTE' ],
        'BLU Studio 5.3'                            => [ 'BLU', 'Studio 5.3' ],
        'Studio 5.3s'                               => [ 'BLU', 'Studio 5.3s' ],
        'BLU STUDIO 5.3 II'                         => [ 'BLU', 'Studio 5.3 II' ],
        'STUDIO 5.5'                                => [ 'BLU', 'Studio 5.5' ],
        'BLU STUDIO 5.5 C'                          => [ 'BLU', 'Studio 5.5c' ],
        'BLU STUDIO 5.5 S'                          => [ 'BLU', 'Studio 5.5s' ],
        'STUDIO6 0HD'                               => [ 'BLU', 'Studio 6.0 HD' ],
        'STUDIO6.0HD'                               => [ 'BLU', 'Studio 6.0 HD' ],
        'BLU STUDIO 6.0 HD'                         => [ 'BLU', 'Studio 6.0 HD' ],
        'Studio 6.0 LTE'                            => [ 'BLU', 'Studio 6.0 LTE' ],
        'BLU STUDIO 7.0'                            => [ 'BLU', 'Studio 7.0' ],
        'STUDIO 7.0 LTE'                            => [ 'BLU', 'Studio 7.0 LTE' ],
        'BLU STUDIO 7.0 LTE'                        => [ 'BLU', 'Studio 7.0 LTE' ],
        'BLU STUDIO 7.0 II'                         => [ 'BLU', 'Studio 7.0 II' ],
        'STUDIO C'                                  => [ 'BLU', 'Studio C' ],
        'BLU STUDIO C'                              => [ 'BLU', 'Studio C' ],
        'BLU STUDIO C MINI'                         => [ 'BLU', 'Studio C Mini' ],
        'BLU STUDIO C HD'                           => [ 'BLU', 'Studio C HD' ],
        'Studio C HD'                               => [ 'BLU', 'Studio C HD' ],
        'BLU STUDIO C 5+5'                          => [ 'BLU', 'Studio C 5+5' ],
        'BLU STUDIO C 5+5 LTE'                      => [ 'BLU', 'Studio C 5+5' ],
        'BLU STUDIO C SUPER CAMERA'                 => [ 'BLU', 'Studio C Super Camera' ],
        'STUDIO C8'                                 => [ 'BLU', 'Studio C8' ],
        'BLU STUDIO G'                              => [ 'BLU', 'Studio G' ],
        'Studio G HD LTE'                           => [ 'BLU', 'Studio G HD' ],
        'BLU STUDIO G PLUS'                         => [ 'BLU', 'Studio G Plus' ],
        'STUDIO G PLUS'                             => [ 'BLU', 'Studio G Plus' ],
        'STUDIO M LTE'                              => [ 'BLU', 'Studio M' ],
        'STUDIO M HD'                               => [ 'BLU', 'Studio M HD' ],
        'BLU STUDIO X'                              => [ 'BLU', 'Studio X' ],
        'STUDIO-X'                                  => [ 'BLU', 'Studio X' ],
        'STUDIO X PLUS'                             => [ 'BLU', 'Studio X Plus' ],
        'STUDIO X5'                                 => [ 'BLU', 'Studio X5' ],
        'BLU STUDIO X8 HD'                          => [ 'BLU', 'Studio X8 HD' ],
        'STUDIO XL'                                 => [ 'BLU', 'Studio XL' ],
        'BLU STUDIO XL'                             => [ 'BLU', 'Studio XL' ],
        'Studio XL 2'                               => [ 'BLU', 'Studio XL 2' ],
        'STUDIO ENERGY'                             => [ 'BLU', 'Studio Energy' ],
        'STUDIO ENERGY 2'                           => [ 'BLU', 'Studio Energy 2' ],
        'Studio Mini LTE'                           => [ 'BLU', 'Studio Mini LTE' ],
        'BLU STUDIO ONE PLUS'                       => [ 'BLU', 'Studio One Plus' ],
        'STUDIO SELFIE'                             => [ 'BLU', 'Studio Selfie' ],
        'BLU STUDIO SELFIE LTE'                     => [ 'BLU', 'Studio Selfie LTE' ],
        'BLU Tank4.5'                               => [ 'BLU', 'Tank 4.5' ],
        'BLU Tigo'                                  => [ 'BLU', 'Tigo' ],
        'BLU TOUCH BOOK 7.0'                        => [ 'BLU', 'Touch Book 7.0', DeviceType::TABLET ],
        'BLU Touch Book 7.0 LITE'                   => [ 'BLU', 'Touch Book 7.0 Lite', DeviceType::TABLET ],
        'BLU P100i'                                 => [ 'BLU', 'Touch Book 7.0 Plus', DeviceType::TABLET ],
        '(BLU )?VIVO 4.3!'                          => [ 'BLU', 'Vivo 4.3' ],
        '(BLU )?VIVO 4.65!'                         => [ 'BLU', 'Vivo 4.65' ],
        'VIVO 4.8 HD'                               => [ 'BLU', 'Vivo 4.8 HD' ],
        'VIVO 5'                                    => [ 'BLU', 'Vivo 5' ],
        'Vivo 5R'                                   => [ 'BLU', 'Vivo 5R' ],
        'Vivo 6'                                    => [ 'BLU', 'Vivo 6' ],
        'VIVO IV'                                   => [ 'BLU', 'Vivo IV' ],
        'VIVO AIR'                                  => [ 'BLU', 'Vivo Air' ],
        'BLU VIVO AIR LTE'                          => [ 'BLU', 'Vivo Air' ],
        'BLU VIVO SELFIE'                           => [ 'BLU', 'Vivo Selfie' ],
        'VIVO XL'                                   => [ 'BLU', 'Vivo XL' ],
    ],

    'PURE XL'                                   => [ 'BLU', 'Pure XL' ],
    'TOUCHBOOK7.0 3G'                           => [ 'BLU', 'Touch Book 7.0', DeviceType::TABLET ],
    'BMOBILE DASH 3.5'                          => [ 'BLU', 'Dash 3.5' ],
    'B3000'                                     => [ 'BlueBo', 'B3000' ],

    '(Bmobile )?AX[0-9]{3,4}!!' => [
        'AX410'                                     => [ 'Bmobile', 'AX410' ],
        'Bmobile AX512'                             => [ 'Bmobile', 'AX512' ],
        'AX512'                                     => [ 'Bmobile', 'AX512' ],
        'AX515'                                     => [ 'Bmobile', 'AX515' ],
        'AX520'                                     => [ 'Bmobile', 'AX520' ],
        'AX525'                                     => [ 'Bmobile', 'AX525' ],
        'AX530'                                     => [ 'Bmobile', 'AX530' ],
        'AX535'                                     => [ 'Bmobile', 'AX535' ],
        'Bmobile AX524'                             => [ 'Bmobile', 'AX524' ],
        'Bmobile AX530'                             => [ 'Bmobile', 'AX530' ],
        'Bmobile AX535'                             => [ 'Bmobile', 'AX535' ],
        'AX540'                                     => [ 'Bmobile', 'AX540' ],
        'Bmobile AX540'                             => [ 'Bmobile', 'AX540' ],
        'AX570'                                     => [ 'Bmobile', 'AX570' ],
        'Bmobile AX570'                             => [ 'Bmobile', 'AX570' ],
        'Bmobile AX600'                             => [ 'Bmobile', 'AX600' ],
        'AX600'                                     => [ 'Bmobile', 'AX600' ],
        'Bmobile AX605'                             => [ 'Bmobile', 'AX605' ],
        'AX610'                                     => [ 'Bmobile', 'AX610' ],
        'Bmobile AX610'                             => [ 'Bmobile', 'AX610' ],
        'AX620'                                     => [ 'Bmobile', 'AX620' ],
        'Bmobile AX620'                             => [ 'Bmobile', 'AX620' ],
        'Bmobile AX650'                             => [ 'Bmobile', 'AX650' ],
        'AX650'                                     => [ 'Bmobile', 'AX650' ],
        'Bmobile AX660'                             => [ 'Bmobile', 'AX660' ],
        'AX660'                                     => [ 'Bmobile', 'AX660' ],
        'Bmobile AX670'                             => [ 'Bmobile', 'AX670' ],
        'Bmobile AX675'                             => [ 'Bmobile', 'AX675' ],
        'Bmobile AX680'                             => [ 'Bmobile', 'AX680' ],
        'Bmobile AX685'                             => [ 'Bmobile', 'AX685' ],
        'Bmobile AX710'                             => [ 'Bmobile', 'AX710' ],
        'AX745'                                     => [ 'Bmobile', 'AX745' ],
        'Bmobile AX745'                             => [ 'Bmobile', 'AX745' ],
        'Bmobile AX800'                             => [ 'Bmobile', 'AX800' ],
        'Bmobile AX810'                             => [ 'Bmobile', 'AX810' ],
        'Bmobile  AX960'                            => [ 'Bmobile', 'AX960' ],
        'AX1020'                                    => [ 'Bmobile', 'AX1020' ],
        'BMOBILE AX1020'                            => [ 'Bmobile', 'AX1020' ],
        'Bmobile AX1030'                            => [ 'Bmobile', 'AX1030' ],
        'Bmobile AX1035'                            => [ 'Bmobile', 'AX1035' ],
        'Bmobile AX1050'                            => [ 'Bmobile', 'AX1050' ],
        'Bmobile AX1055'                            => [ 'Bmobile', 'AX1055' ],
        'AX1055'                                    => [ 'Bmobile', 'AX1055' ],
        'BMOBILE AX1060'                            => [ 'Bmobile', 'AX1060' ],
        'AX1060'                                    => [ 'Bmobile', 'AX1060' ],
        'Bmobile AX1065'                            => [ 'Bmobile', 'AX1065' ],
    ],

    'AX7OO'                                     => [ 'Bmobile', 'AX700' ],
    'Bmobile T35AC'                             => [ 'Bmobile', 'T35AC' ],
    'JC-S9220'                                  => [ 'Bmorn', 'Phone One' ],
    'BM999'                                     => [ 'Bmorn', 'BM999', DeviceType::TABLET ],
    'V11'                                       => [ 'Bmorn', 'V11', DeviceType::TABLET ],
    'V99'                                       => [ 'Bmorn', 'V99', DeviceType::TABLET ],
    'BO-FRSP4'                                  => [ 'Bogo', 'Friendly 4DC' ],
    'BO-LFSPBS5'                                => [ 'Bogo', 'Lifestyle 5BS' ],
    'BOVO S-F16'                                => [ 'Bovo', 'Walker S-F16' ],
    'S-F16'                                     => [ 'Bovo', 'Walker S-F16' ],

    'BOWAY!!' => [
        'BOWAY F3'                                  => [ 'Boway', 'F3' ],
        'BOWAY I3'                                  => [ 'Boway', 'I3' ],
        'BOWAY I5'                                  => [ 'Boway', 'I5' ],
        'BOWAY I9'                                  => [ 'Boway', 'I9' ],
        'BOWAY L3'                                  => [ 'Boway', 'L3' ],
        'BOWAY P1'                                  => [ 'Boway', 'P1' ],
        'BOWAY TL100'                               => [ 'Boway', 'TL100' ],
        'BOWAY TL600'                               => [ 'Boway', 'TL600' ],
        'BOWAY U1'                                  => [ 'Boway', 'U1' ],
        'BOWAY-BOWAY-U1'                            => [ 'Boway', 'U1' ],
        'BOWAY U2'                                  => [ 'Boway', 'U2' ],
        'BOWAY-BOWAY-U2'                            => [ 'Boway', 'U2' ],
        'BOWAY U3'                                  => [ 'Boway', 'U3' ],
        'BOWAY U6'                                  => [ 'Boway', 'U6' ],
        'BOWAY U7'                                  => [ 'Boway', 'U7' ],
        'BOWAY U11'                                 => [ 'Boway', 'U11' ],
        'BOWAY U12'                                 => [ 'Boway', 'U12' ],
        'BOWAY V2C'                                 => [ 'Boway', 'V2C' ],
        'BOWAY V7'                                  => [ 'Boway', 'V7' ],
        'BOWAY V7A'                                 => [ 'Boway', 'V7A' ],
        'BOWAY V9'                                  => [ 'Boway', 'V9' ],
        'BOWAY V70'                                 => [ 'Boway', 'V70' ],
        'BOWAY V80'                                 => [ 'Boway', 'V80' ],
        'BOWAY V95Pro'                              => [ 'Boway', 'V95 Pro' ],
        'BOWAY X6'                                  => [ 'Boway', 'X6' ],
    ],

    'BroadSign Xpress!'                         => [ 'BroadSign', 'Xpress', DeviceType::SIGNAGE ],
    'Broncho M7'                                => [ 'Broncho', 'M7', DeviceType::TABLET ],
    'CENTURION'                                 => [ 'Brondi', 'CENTURION' ],
    'CENTURION 3'                               => [ 'Brondi', 'CENTURION 3' ],
    'GLADIATOR'                                 => [ 'Brondi', 'GLADIATOR' ],
    'GLADIATOR-2'                               => [ 'Brondi', 'GLADIATOR 2' ],
    'GLADIATOR 3'                               => [ 'Brondi', 'GLADIATOR 3' ],
    'GLADIATOR 4'                               => [ 'Brondi', 'GLADIATOR 4' ],
    'Glory'                                     => [ 'Brondi', 'GLORY' ],
    'Glory 2'                                   => [ 'Brondi', 'GLORY 2' ],
    'Glory3'                                    => [ 'Brondi', 'GLORY 3' ],
    'GLORY 4'                                   => [ 'Brondi', 'GLORY 4' ],
    'LUXURY'                                    => [ 'Brondi', 'LUXURY' ],
    'LUXURY 3'                                  => [ 'Brondi', 'LUXURY 3' ],
    'LUXURY 4'                                  => [ 'Brondi', 'LUXURY 4' ],
    'LUXURY 5'                                  => [ 'Brondi', 'LUXURY 5' ],
    'SENSUELLE'                                 => [ 'Brondi', 'SENSUELLE' ],
    'VICTORY'                                   => [ 'Brondi', 'VICTORY' ],
    'Victory 2'                                 => [ 'Brondi', 'VICTORY 2' ],
    'Victory 3'                                 => [ 'Brondi', 'VICTORY 3' ],
    'VICTORY 4'                                 => [ 'Brondi', 'VICTORY 4' ],
    'Victory 5'                                 => [ 'Brondi', 'VICTORY 5' ],
    'Surfing TAB B 9.7 3G'                      => [ 'Brondi', 'SURFING TAB B', DeviceType::TABLET ],
    'Surfing Tab C 3G'                          => [ 'Brondi', 'SURFING TAB C', DeviceType::TABLET ],

    '(BRS-)?BROR!!' => [
        'BROR F2'                                   => [ 'BROR', 'F2' ],
        'BROR G2'                                   => [ 'BROR', 'G2' ],
        'BRS-BROR S3'                               => [ 'BROR', 'S3' ],
        'BROR S9'                                   => [ 'BROR', 'S9' ],
        'BRS-BROR S9'                               => [ 'BROR', 'S9' ],
        'BROR T5'                                   => [ 'BROR', 'T5' ],
        'BROR T70'                                  => [ 'BROR', 'T70' ],
        'BRS-BROR W58'                              => [ 'BROR', 'W58' ],
        'BROR W58'                                  => [ 'BROR', 'W58' ],
        'BROR W60'                                  => [ 'BROR', 'W60' ],
        'BROR W60+'                                 => [ 'BROR', 'W60+' ],
        'BROR W61'                                  => [ 'BROR', 'W61' ],
        'BROR W65'                                  => [ 'BROR', 'W65' ],
        'BROR W68'                                  => [ 'BROR', 'W68' ],
        'BRS-BROR W70'                              => [ 'BROR', 'W70' ],
        'BROR W80'                                  => [ 'BROR', 'W80' ],
        'BRS-BROR W80'                              => [ 'BROR', 'W80' ],
    ],

    '(bq|Aquaris|Edison|Maxwell)!!' => [
        'bq Aquaris'                                => [ 'bq', 'Aquaris' ],
        'bq Aquaris 3.5'                            => [ 'bq', 'Aquaris 3.5' ],
        'bq Aquaris 4'                              => [ 'bq', 'Aquaris 4' ],
        'bq Aquaris 5'                              => [ 'bq', 'Aquaris 5' ],
        'bq Aquaris5'                               => [ 'bq', 'Aquaris 5' ],
        'BqAquaris5'                                => [ 'bq', 'Aquaris 5' ],
        'bq Aquaris 5 HD'                           => [ 'bq', 'Aquaris 5 HD' ],
        'bq Aquaris 5.7'                            => [ 'bq', 'Aquaris 5.7' ],
        'Aquaris A4.5'                              => [ 'bq', 'Aquaris A4.5' ],
        'Aquaris E4'                                => [ 'bq', 'Aquaris E4' ],
        'Aquaris E4.5'                              => [ 'bq', 'Aquaris E4.5' ],
        'Aquaris E5'                                => [ 'bq', 'Aquaris E5' ],
        'Aquaris E5 HD'                             => [ 'bq', 'Aquaris E5 HD' ],
        'Aquaris E5 FHD'                            => [ 'bq', 'Aquaris E5 FHD' ],
        'Aquaris E6'                                => [ 'bq', 'Aquaris E6' ],
        'Aquaris E10'                               => [ 'bq', 'Aquaris E10', DeviceType::TABLET ],
        'Aquaris E10 3G'                            => [ 'bq', 'Aquaris E10', DeviceType::TABLET ],
        'Aquaris M4.5'                              => [ 'bq', 'Aquaris M4.5' ],
        'Aquaris M5'                                => [ 'bq', 'Aquaris M5' ],
        'Aquaris M5.5'                              => [ 'bq', 'Aquaris M5.5' ],
        'Aquaris M8'                                => [ 'bq', 'Aquaris M8', DeviceType::TABLET ],
        'Aquaris M10'                               => [ 'bq', 'Aquaris M10', DeviceType::TABLET ],
        'Aquaris M10 FHD'                           => [ 'bq', 'Aquaris M10 FHD', DeviceType::TABLET ],
        'Aquaris U'                                 => [ 'bq', 'Aquaris U' ],
        'Aquaris U Lite'                            => [ 'bq', 'Aquaris U Lite' ],
        'Aquaris U Plus'                            => [ 'bq', 'Aquaris U Plus' ],
        'Aquaris X'                                 => [ 'bq', 'Aquaris X' ],
        'Aquaris X5'                                => [ 'bq', 'Aquaris X5' ],
        'Aquaris X5 Plus'                           => [ 'bq', 'Aquaris X5 Plus' ],
        'bq Curie'                                  => [ 'bq', 'Curie', DeviceType::TABLET ],
        'bq Curie 2'                                => [ 'bq', 'Curie 2', DeviceType::TABLET ],
        'bq Curie 2 3G'                             => [ 'bq', 'Curie 2', DeviceType::TABLET ],
        'bq Curie 2 Quad Core'                      => [ 'bq', 'Curie 2', DeviceType::TABLET ],
        'bq Curie 2 Quad Core 3G'                   => [ 'bq', 'Curie 2', DeviceType::TABLET ],
        'Bq Darwin'                                 => [ 'bq', 'Darwin', DeviceType::TABLET ],
        'bq DaVinci'                                => [ 'bq', 'DaVinci', DeviceType::TABLET ],
        'bq Elcano'                                 => [ 'bq', 'Elcano', DeviceType::TABLET ],
        'bq Elcano 2 Quad Core'                     => [ 'bq', 'Elcano 2', DeviceType::TABLET ],
        'bq Edison'                                 => [ 'bq', 'Edison', DeviceType::TABLET ],
        'bq Edison 3G'                              => [ 'bq', 'Edison', DeviceType::TABLET ],
        'bq Edison 2'                               => [ 'bq', 'Edison 2', DeviceType::TABLET ],
        'bq Edison 2 3G'                            => [ 'bq', 'Edison 2', DeviceType::TABLET ],
        'bq Edison 2 Quad Core'                     => [ 'bq', 'Edison 2', DeviceType::TABLET ],
        'bq Edison 2 Quad Core 3G'                  => [ 'bq', 'Edison 2', DeviceType::TABLET ],
        'Edison 3'                                  => [ 'bq', 'Edison 3', DeviceType::TABLET ],
        'Edison 3 3G'                               => [ 'bq', 'Edison 3', DeviceType::TABLET ],
        'Edison 3 mini'                             => [ 'bq', 'Edison 3 mini', DeviceType::TABLET ],
        'bq Livingstone 2'                          => [ 'bq', 'Livingstone 2', DeviceType::TABLET ],
        'bq Livingstone 3n!'                        => [ 'bq', 'Livingstone 3n', DeviceType::TABLET ],
        'Maxwell'                                   => [ 'bq', 'Maxwell', DeviceType::TABLET ],
        'Maxwell Lite'                              => [ 'bq', 'Maxwell Lite', DeviceType::TABLET ],
        'bq Maxwell Plus'                           => [ 'bq', 'Maxwell Plus', DeviceType::TABLET ],
        'bq Maxwell 2'                              => [ 'bq', 'Maxwell 2', DeviceType::TABLET ],
        'bq Maxwell 2 Lite'                         => [ 'bq', 'Maxwell 2 Lite', DeviceType::TABLET ],
        'bq Maxwell 2 Plus'                         => [ 'bq', 'Maxwell 2 Plus', DeviceType::TABLET ],
        'bq Maxwell 2 Quad Core'                    => [ 'bq', 'Maxwell 2', DeviceType::TABLET ],
        'bq Pascal 2!'                              => [ 'bq', 'Pascal 2', DeviceType::TABLET ],
        'bq Verne Plus'                             => [ 'bq', 'Verne Plus', DeviceType::TABLET ],
        'bq Verne Plus 3G'                          => [ 'bq', 'Verne Plus', DeviceType::TABLET ],
        'bq Voltaire'                               => [ 'bq', 'Voltaire', DeviceType::TABLET ],
    ],

    'BUSH!!' => [
        'Bush 4 Android'                            => [ 'Bush', '4' ],
        'BUSH 5 Android'                            => [ 'Bush', '5' ],
        'Bush 5" Android'                           => [ 'Bush', '5' ],
        'Bush 5" 4G'                                => [ 'Bush', '5 4G' ],
        'Bush Spira C2 5" Smartphone'               => [ 'Bush', '5 4G' ],
        'Bush 5.5" 4G'                              => [ 'Bush', '5.5 4G' ],
        'Bush Spira D2 5.5" Smartphone'             => [ 'Bush', '5.5 4G' ],
        'BUSH 7.0 TABLET'                           => [ 'Bush', '7.0 Tablet', DeviceType::TABLET ],
        'BUSH 7.85 TABLET'                          => [ 'Bush', '7.85 Tablet', DeviceType::TABLET ],
        'Bush 8.0 MyTablet'                         => [ 'Bush', '8.0 MyTablet', DeviceType::TABLET ],
        'BUSH 10.1 TABLET'                          => [ 'Bush', '10.1 Tablet', DeviceType::TABLET ],
        'Bush 7.0 MyTablet'                         => [ 'Bush', '7.0 MyTablet', DeviceType::TABLET ],
        'Bush 10.0 MyTablet'                        => [ 'Bush', '10.0 MyTablet', DeviceType::TABLET ],
        'Bush Mytablet 2'                           => [ 'Bush', 'MyTablet 2', DeviceType::TABLET ],
    ],

    'CT[0-9]{3,4}!!' => [
        'CT700'                                     => [ 'Carrefour', 'Touch Tablet CT700', DeviceType::TABLET ],
        'CT701'                                     => [ 'Carrefour', 'Touch Tablet CT701', DeviceType::TABLET ],
        'CT704'                                     => [ 'Carrefour', 'Touch Tablet CT704', DeviceType::TABLET ],
        'CT705'                                     => [ 'Carrefour', 'Touch Tablet CT705', DeviceType::TABLET ],
        'CT705FR'                                   => [ 'Carrefour', 'Touch Tablet CT705', DeviceType::TABLET ],
        'CT710'                                     => [ 'Carrefour', 'Touch Tablet CT710', DeviceType::TABLET ],
        'CT715'                                     => [ 'Carrefour', 'Touch Tablet CT715', DeviceType::TABLET ],
        'CT720'                                     => [ 'Carrefour', 'Touch Tablet CT720', DeviceType::TABLET ],
        'CT726'                                     => [ 'Carrefour', 'Touch Tablet CT726', DeviceType::TABLET ],
        'CT820'                                     => [ 'Carrefour', 'Touch Tablet CT820', DeviceType::TABLET ],
        'CT826'                                     => [ 'Carrefour', 'Touch Tablet CT826', DeviceType::TABLET ],
        'CT1000'                                    => [ 'Carrefour', 'Touch Tablet CT1000', DeviceType::TABLET ],
        'CT1002'                                    => [ 'Carrefour', 'Touch Tablet CT1002', DeviceType::TABLET ],
        'CT1002PLUS'                                => [ 'Carrefour', 'Touch Tablet CT1002 plus', DeviceType::TABLET ],
        'CT1010'                                    => [ 'Carrefour', 'Touch Tablet CT1010', DeviceType::TABLET ],
        'CT1020W'                                   => [ 'Carrefour', 'Touch Tablet CT1020W', DeviceType::TABLET ],
    ],

    'EM63'                                      => [ 'Carrefour', 'Touch Tablet CT720', DeviceType::TABLET ],
    'A101B-CF'                                  => [ 'Carrefour', 'Touch Tablet CT1001', DeviceType::TABLET ],
    'TVE9603I'                                  => [ 'Carrefour', 'Touch Tablet CT1050', DeviceType::TABLET ],
    'Camangi-Mangrove7'                         => [ 'Camangi', 'Mangrove 7', DeviceType::TABLET ],
    'WS171'                                     => [ 'Camangi', 'WebStation', DeviceType::TABLET ],

    'CAPTIVA!!' => [
        'CAPTIVA PAD 7'                             => [ 'Captiva', 'Pad 7', DeviceType::TABLET ],
        'CAPTIVA PAD 8'                             => [ 'Captiva', 'Pad 8', DeviceType::TABLET ],
        'CAPTIVA PAD 8 Pro'                         => [ 'Captiva', 'Pad 8 Pro', DeviceType::TABLET ],
        'CAPTIVA PAD 8 GPS'                         => [ 'Captiva', 'Pad 8 GPS', DeviceType::TABLET ],
        'CAPTIVA 9.7 Super FHD'                     => [ 'Captiva', 'Pad 9.7 Super FHD', DeviceType::TABLET ],
        'CAPTIVA PAD 10'                            => [ 'Captiva', 'Pad 10.1', DeviceType::TABLET ],
        'CAPTIVA PAD 10.1'                          => [ 'Captiva', 'Pad 10.1', DeviceType::TABLET ],
        'CAPTIVA 10.1 HD'                           => [ 'Captiva', 'Pad 10.1 HD', DeviceType::TABLET ],
        'CAPTIVA PAD 10.1 Quad FHD'                 => [ 'Captiva', 'Pad 10.1 Quad FHD', DeviceType::TABLET ],
        'CAPTIVA PAD 10.1 Quad FHD 3G'              => [ 'Captiva', 'Pad 10.1 Quad FHD', DeviceType::TABLET ],
    ],

    'Carpad T5'                                 => [ 'Carpad', 'T5' ],
    'Carpad T61 2g'                             => [ 'Carpad', 'T61' ],
    'CAL21'                                     => [ 'Casio', 'GzOne Type-L CAL21', 'carrier' => 'au' ],
    'CA201SP'                                   => [ 'Casio', 'GzOne CA-201SP' ],
    'CA-201L'                                   => [ 'Casio', 'GzOne CA-201L' ],
    'IS11CA'                                    => [ 'Casio', 'GzOne Commando IS11CA', 'carrier' => 'au' ],
    'C771'                                      => [ 'Casio', 'GzOne Commando' ],
    'C811 4G'                                   => [ 'Casio', 'GzOne Commando 811' ],
    'VX-100'                                    => [ 'Casio', 'VX-100 EPOS Terminal', DeviceType::POS ],

    'Casper VIA!!' => [
        'Casper VIA A3216'                          => [ 'Casper', 'VIA A3216' ],
        'Casper VIA A6108'                          => [ 'Casper', 'VIA A6108' ],
        'Casper VIA V4'                             => [ 'Casper', 'VIA V4' ],
        'Casper VIA V5'                             => [ 'Casper', 'VIA V5' ],
        'Casper VIA V8'                             => [ 'Casper', 'VIA V8' ],
    ],

    'B15'                                       => [ 'CAT', 'B15' ],
    'B15Q'                                      => [ 'CAT', 'B15Q' ],
    'S30'                                       => [ 'CAT', 'S30' ],
    'S40'                                       => [ 'CAT', 'S40' ],
    'S50'                                       => [ 'CAT', 'S50' ],
    'S50c'                                      => [ 'CAT', 'S50c' ],

    'CAT!!' => [
        'Cat Comet'                                 => [ 'CAT', 'COMET', DeviceType::TABLET ],
        'CAT NOVA'                                  => [ 'CAT', 'NOVA', DeviceType::TABLET ],
        'Cat Tablet Android 4.0.4'                  => [ 'CAT', 'NOVA', DeviceType::TABLET ],
        'CatNova8'                                  => [ 'CAT', 'NOVA8', DeviceType::TABLET ],
        'Cat Tablet PHOENIX 8J0'                    => [ 'CAT', 'PHOENIX', DeviceType::TABLET ],
        'Cat Tablet PHOENIX 8.1J0'                  => [ 'CAT', 'PHOENIX', DeviceType::TABLET ],
        'Cat Tablet Galactica 9[.,]7CA!'            => [ 'CAT', 'GALACTICA', DeviceType::TABLET ],
        'Cat Tablet Galactica X 9[.,]7CA!'          => [ 'CAT', 'GALACTICA X', DeviceType::TABLET ],
        'Cat Tablet GalacticaX 9.7JA'               => [ 'CAT', 'GALACTICA X', DeviceType::TABLET ],
        'Cat Tablet PEGASUS T 8J0'                  => [ 'CAT', 'PEGASUS', DeviceType::TABLET ],
        'Cat StarGate'                              => [ 'CAT', 'STARGATE', DeviceType::TABLET ],
        'Cat Tablet CSG 7J0'                        => [ 'CAT', 'STARGATE', DeviceType::TABLET ],
        'Cat Tablet StarGate 2'                     => [ 'CAT', 'STARGATE 2', DeviceType::TABLET ],
        'Cat Tablet CSG2 7.1J0'                     => [ 'CAT', 'STARGATE 2', DeviceType::TABLET ],
    ],

    'SK351'                                     => [ 'CCE', 'Motion.Plus SK351' ],
    'CCE SK352'                                 => [ 'CCE', 'Motion.Plus SK352' ],

    'Celkon!!' => [
        'Celkon A8+'                                => [ 'Celkon', 'A8+' ],
        'CELKON A9 Dual'                            => [ 'Celkon', 'A9' ],
        'CELKON A9+'                                => [ 'Celkon', 'A9+' ],
        'Celkon A10'                                => [ 'Celkon', 'Campus A10' ],
        'Celkon A15'                                => [ 'Celkon', 'Campus A15' ],
        'Celkon A15K'                               => [ 'Celkon', 'Campus A15K' ],
        'Celkon A20'                                => [ 'Celkon', 'Campus A20' ],
        'Celkon A21'                                => [ 'Celkon', 'A21' ],
        'Celkon A 22'                               => [ 'Celkon', 'A22' ],
        'Celkon A27'                                => [ 'Celkon', 'A27' ],
        'Celkon A35K'                               => [ 'Celkon', 'A35K' ],
        'Celkon A43'                                => [ 'Celkon', 'A43' ],
        'Celkon A58'                                => [ 'Celkon', 'A58' ],
        'Celkon A 59'                               => [ 'Celkon', 'A59' ],
        'Celkon A62'                                => [ 'Celkon', 'A62' ],
        'Celkon A 63'                               => [ 'Celkon', 'A63' ],
        'CELKON A64'                                => [ 'Celkon', 'A64' ],
        'Celkon A66'                                => [ 'Celkon', 'A66' ],
        'Celkon A67'                                => [ 'Celkon', 'A67' ],
        'Celkon A75'                                => [ 'Celkon', 'A75' ],
        'Celkon A 77'                               => [ 'Celkon', 'A77' ],
        'Celkon A79'                                => [ 'Celkon', 'A79' ],
        'CELKON A83'                                => [ 'Celkon', 'A83' ],
        'Celkon A 85'                               => [ 'Celkon', 'A85' ],
        'Celkon*A86'                                => [ 'Celkon', 'A86' ],
        'Celkon A88'                                => [ 'Celkon', 'A88' ],
        'CELKON A 90'                               => [ 'Celkon', 'A90' ],
        'Celkon*A95*Pro'                            => [ 'Celkon', 'A95 Pro' ],
        'Celkon A97'                                => [ 'Celkon', 'A97' ],
        'Celkon A98'                                => [ 'Celkon', 'A98' ],
        'Celkon A101'                               => [ 'Celkon', 'A101' ],
        'Celkon A105+'                              => [ 'Celkon', 'Signature Vista A105+' ],
        'Celkon A107'                               => [ 'Celkon', 'Signature One A107' ],
        'Celkon A107+'                              => [ 'Celkon', 'Signature One A107+' ],
        'Celkon A112'                               => [ 'Celkon', 'Signature Swift A112' ],
        'Celkon A118'                               => [ 'Celkon', 'Signature HD A118' ],
        'Celkon A119'                               => [ 'Celkon', 'Signature HD A119' ],
        'Celkon A119Q'                              => [ 'Celkon', 'Signature HD A119Q' ],
        'Celkon A125'                               => [ 'Celkon', 'Campus A125' ],
        'Celkon A 200'                              => [ 'Celkon', 'A200' ],
        'Celkon A200'                               => [ 'Celkon', 'A200' ],
        'Celkon A 220'                              => [ 'Celkon', 'A220' ],
        'Celkon A 225'                              => [ 'Celkon', 'A225' ],
        'Celkon A404'                               => [ 'Celkon', 'Campus Buddy A404' ],
        'Celkon A500'                               => [ 'Celkon', 'Signature Two A500' ],
        'Celkon A900'                               => [ 'Celkon', 'A900' ],
        'Celkon A.R 40'                             => [ 'Celkon', 'AR40' ],
        'Celkon A.R 45'                             => [ 'Celkon', 'AR45' ],
        'Celkon A.R 50'                             => [ 'Celkon', 'AR50' ],
        'Celkon C720'                               => [ 'Celkon', 'C720', DeviceType::TABLET ],
        'CELKON CT2'                                => [ 'Celkon', 'CT2', DeviceType::TABLET ],
        'Celkon CT3'                                => [ 'Celkon', 'CT3', DeviceType::TABLET ],
        'Celkon CT7'                                => [ 'Celkon', 'CT7', DeviceType::TABLET ],
        'Celkon CT 9'                               => [ 'Celkon', 'CT9', DeviceType::TABLET ],
        'CELKON CT 888'                             => [ 'Celkon', 'CT888', DeviceType::TABLET ],
        'Celkon CT 910'                             => [ 'Celkon', 'CT910', DeviceType::TABLET ],
        'Celkon CT 910+'                            => [ 'Celkon', 'CT910+', DeviceType::TABLET ],
        'Celkon IQ180'                              => [ 'Celkon', 'IQ180' ],
        'Celkon S1'                                 => [ 'Celkon', 'S1' ],
        'Celkon Q4GPlus'                            => [ 'Celkon', 'Diamond 4G Plus' ],
        'Celkon Q405'                               => [ 'Celkon', 'Campus Q405' ],
        'CELKON Q450'                               => [ 'Celkon', 'Millennia Q450' ],
        'Celkon Q455'                               => [ 'Celkon', 'Millennium Vogue Q455' ],
        'Celkon Q470'                               => [ 'Celkon', 'Millennium Elite Q470' ],
        'Celkon Q500'                               => [ 'Celkon', 'Millennium Ultra Q500' ],
        'Celkon Q550'                               => [ 'Celkon', 'Millennia Epic Q550' ],
        'Celkon Q567'                               => [ 'Celkon', 'Millennia Q567' ],
        'Celkon Q3000'                              => [ 'Celkon', 'Millennia Power Q3000' ],
        'Celkon 4G TAB-8'                           => [ 'Celkon', '4G Tab-8', DeviceType::TABLET ],
    ],

    'A89'                                       => [ 'Celkon', 'A89' ],
    'A95'                                       => [ 'Celkon', 'A95' ],
    'A97i'                                      => [ 'Celkon', 'A97i' ],
    'CT-1'                                      => [ 'Celkon', 'CT1', DeviceType::TABLET ],
    'CT910'                                     => [ 'Celkon', 'CT910', DeviceType::TABLET ],
    'W820'                                      => [ 'Cellon', 'HW-W820' ],

    'ChangHong!!' => [
        'ChangHong-Z-ME'                            => [ 'ChangHong', 'Z-me' ],
        'ChanghongA898T'                            => [ 'ChangHong', 'A898T' ],
        'ChanghongC100'                             => [ 'ChangHong', 'C100' ],
        'ChanghongC600'                             => [ 'ChangHong', 'C600' ],
        'ChanghongC770'                             => [ 'ChangHong', 'C770' ],
        'ChanghongC800'                             => [ 'ChangHong', 'C800' ],
        'Changhong H5018'                           => [ 'ChangHong', 'H5018' ],
        'ChangHongV5t'                              => [ 'ChangHong', 'V5t' ],
        'ChangHong ?V7!'                            => [ 'ChangHong', 'V7' ],
        'ChonghongV8'                               => [ 'ChangHong', 'V8' ],
        'ChangHongV11t'                             => [ 'ChangHong', 'V11t' ],
        'ChangHongW3'                               => [ 'ChangHong', 'W3' ],
        'ChangHong W3'                              => [ 'ChangHong', 'W3' ],
        'ChanghongW6'                               => [ 'ChangHong', 'W6' ],
        'ChanghongW7'                               => [ 'ChangHong', 'W7' ],
        'ChangHong W8'                              => [ 'ChangHong', 'W8' ],
        'ChangHong W22'                             => [ 'ChangHong', 'W22' ],
        'ChangHong ?Z1!'                            => [ 'ChangHong', 'Z1' ],
        'ChanghongZ3t'                              => [ 'ChangHong', 'Z3t' ],
        'ChangHongZ9'                               => [ 'ChangHong', 'Z9' ],
        'changhong TV'                              => [ 'ChangHong', null ],
    ],

    'CHER!!' => [
        'CHER A50'                                  => [ 'Cher', 'A50' ],
        'CHER A55w'                                 => [ 'Cher', 'A55w' ],
        'CHER A90'                                  => [ 'Cher', 'A90' ],
        'CHER A91'                                  => [ 'Cher', 'A91' ],
    ],

    'PC1038'                                    => [ 'Cherry', 'Pro-Line 2', DeviceType::TABLET ],
    'Candy TV'                                  => [ 'Cherry Mobile', 'Candy TV' ],
    'Titan TV S320'                             => [ 'Cherry Mobile', 'Titan TV' ],
    'Flame2'                                    => [ 'Cherry Mobile', 'Flame 2.0' ],
    'Flare S100'                                => [ 'Cherry Mobile', 'Flare' ],
    'Flare 2.0'                                 => [ 'Cherry Mobile', 'Flare 2.0' ],
    'Flare 2.1'                                 => [ 'Cherry Mobile', 'Flare 2.1' ],
    'Flare2X'                                   => [ 'Cherry Mobile', 'Flare 2X' ],
    'Flare J1'                                  => [ 'Cherry Mobile', 'Flare J1' ],
    'FLARE J1 PLUS'                             => [ 'Cherry Mobile', 'Flare J1 Plus' ],
    'Flare J3 Plus'                             => [ 'Cherry Mobile', 'Flare J3 Plus' ],
    'Flare S4 Max'                              => [ 'Cherry Mobile', 'Flare S4 Max' ],
    'Blaze S180'                                => [ 'Cherry Mobile', 'Blaze S180' ],
    'Burst S280'                                => [ 'Cherry Mobile', 'Burst W280' ],
    'Cherry Mobile Burst'                       => [ 'Cherry Mobile', 'Burst W280' ],
    'Cherry Life'                               => [ 'Cherry Mobile', 'Life' ],
    'Cherry Razor'                              => [ 'Cherry Mobile', 'Razor' ],
    'Cherry Mobile Razor'                       => [ 'Cherry Mobile', 'Razor' ],
    'CHERRY SNAP'                               => [ 'Cherry Mobile', 'Snap' ],
    'Cherry Sonic'                              => [ 'Cherry Mobile', 'Sonic' ],
    'Cherry thunder2.0'                         => [ 'Cherry Mobile', 'Thunder 2.0' ],
    'Thunder S220'                              => [ 'Cherry Mobile', 'Thunder S220' ],
    'Ultra Flare v2'                            => [ 'Cherry Mobile', 'Ultra Flare' ],
    'H120'                                      => [ 'Cherry Mobile', 'H120' ],
    'W200'                                      => [ 'Cherry Mobile', 'W200' ],
    'Cherry Mobile Amber W380'                  => [ 'Cherry Mobile', 'Amber W380' ],
    'Cherry w500'                               => [ 'Cherry Mobile', 'W500' ],
    'W900'                                      => [ 'Cherry Mobile', 'W900' ],
    'Fusion Bolt'                               => [ 'Cherry Mobile', 'Fusion Bolt', DeviceType::TABLET ],

    'LA-!!' => [
        'LA-E'                                      => [ 'Chili', 'E' ],
        'LA-I'                                      => [ 'Chili', 'I' ],
        'LA-I2'                                     => [ 'Chili', 'I2' ],
        'LA-M1'                                     => [ 'Chili', 'M1' ],
        'LA-M1Y'                                    => [ 'Chili', 'M1Y' ],
        'LA-M2'                                     => [ 'Chili', 'M2' ],
        'LA-Q1'                                     => [ 'Chili', 'Q1' ],
    ],

    'M701C'                                     => [ 'China Tablet', 'M701C', DeviceType::TABLET ],
    'TR720F'                                    => [ 'China Tablet', 'TR720F', DeviceType::TABLET ],
    'ARMM2V'                                    => [ 'chinaleap', 'ARMM2V', DeviceType::TABLET ],
    'ARMM3V'                                    => [ 'chinaleap', 'ARMM3V', DeviceType::TABLET ],
    'V936'                                      => [ 'Chiva', 'V936' ],

    'CHUWI!!' => [
        'CHUWI V3'                                  => [ 'Chuwi', 'V3', DeviceType::TABLET ],
        'CHUWI-V8-HD'                               => [ 'Chuwi', 'V8 HD', DeviceType::TABLET ],
        'CHUWI V9'                                  => [ 'Chuwi', 'V9', DeviceType::TABLET ],
    ],

    'cius'                                      => [ 'Cisco', 'Cius', DeviceType::TABLET ],
    'CIUS-7!'                                   => [ 'Cisco', 'Cius', DeviceType::TABLET ],

    'CP-DX!!' => [
        'CP-DX70'                                   => [ 'Cisco', 'DX70', DeviceType::TABLET ],
        'CP-DX80'                                   => [ 'Cisco', 'DX80', DeviceType::TABLET ],
        'CP-DX650'                                  => [ 'Cisco', 'DX650', DeviceType::TABLET ],
    ],

    'Citycall!!' => [
        'Citycall A1'                               => [ 'Citycall', 'A1' ],
        'Citycall i310+'                            => [ 'Citycall', 'i310+' ],
        'Citycall i930+'                            => [ 'Citycall', 'i930+' ],
    ],

    'Clarion Mirage 2'                          => [ 'Clarion', 'Mirage 2', DeviceType::CAR ],

    '(Cloudfone|CloudPad|Excite|Thrill)!!' => [
        'Cloudfone Excite320e'                      => [ 'Cloudfone', 'Excite 320e' ],
        'Cloudfone Excite320g'                      => [ 'Cloudfone', 'Excite 320g' ],
        'Cloudfone Excite350e'                      => [ 'Cloudfone', 'Excite 350e' ],
        'Cloudfone Excite350g'                      => [ 'Cloudfone', 'Excite 350g' ],
        'Cloudfone Excite 350g'                     => [ 'Cloudfone', 'Excite 350g' ],
        'Cloudfone Excite 350i'                     => [ 'Cloudfone', 'Excite 350i' ],
        'Cloudfone Excite 354g'                     => [ 'Cloudfone', 'Excite 354g' ],
        'Cloudfone Excite 400d'                     => [ 'Cloudfone', 'Excite 400d' ],
        'Cloudfone Excite 402d'                     => [ 'Cloudfone', 'Excite 402d' ],
        'Excite 402d'                               => [ 'Cloudfone', 'Excite 402d' ],
        'Cloudfone Excite 452q'                     => [ 'Cloudfone', 'Excite 452q' ],
        'Cloudfone Excite 500d'                     => [ 'Cloudfone', 'Excite 500d' ],
        'Excite 501o'                               => [ 'Cloudfone', 'Excite 501o' ],
        'Cloudfone Excite 502q'                     => [ 'Cloudfone', 'Excite 502q' ],
        'Cloudfone Excite 504d'                     => [ 'Cloudfone', 'Excite 504d' ],
        'Cloudfone GEO 400q+'                       => [ 'Cloudfone', 'Geo 400q' ],
        'Cloudfone GEO 402q'                        => [ 'Cloudfone', 'Geo 402q' ],
        'Cloudfone ICE 2Gs'                         => [ 'Cloudfone', 'Ice 2Gs' ],
        'cloudfone ice 350e!'                       => [ 'Cloudfone', 'Ice 350e' ],
        'Cloudfone ICE 500e'                        => [ 'Cloudfone', 'Ice 500e' ],
        'Cloudfone Thrill 400g'                     => [ 'Cloudfone', 'Thrill 400g' ],
        'Cloudfone Thrill 430d'                     => [ 'Cloudfone', 'Thrill 430d' ],
        'Cloudfone Thrill 430g'                     => [ 'Cloudfone', 'Thrill 430g' ],
        'Thrill 430x'                               => [ 'Cloudfone', 'Thrill 430x' ],
        'Cloudfone Thrill 500g'                     => [ 'Cloudfone', 'Thrill 500g' ],
        'Thrill 530qx'                              => [ 'Cloudfone', 'Thrill 530qx' ],
        'Thrill HD'                                 => [ 'Cloudfone', 'Thrill HD' ],
        'Thrill Access'                             => [ 'Cloudfone', 'Thrill Access' ],
        'Thrill Boost'                              => [ 'Cloudfone', 'Thrill Boost' ],
        'Thrill Lite'                               => [ 'Cloudfone', 'Thrill Lite' ],
        'Thrill Plus 16GB'                          => [ 'Cloudfone', 'Thrill Plus' ],
        'CloudPad 700d'                             => [ 'Cloudfone', 'CloudPad 700d' ],
        'CloudPad 700w'                             => [ 'Cloudfone', 'CloudPad 700w' ],
        'CloudPad 700TV'                            => [ 'Cloudfone', 'CloudPad 700tv' ],
        'CloudPad 701tv'                            => [ 'Cloudfone', 'CloudPad 701tv' ],
        'Cloudpad 705w'                             => [ 'Cloudfone', 'CloudPad 705w' ],
        'CloudPad 707qw'                            => [ 'Cloudfone', 'CloudPad 707qw' ],
        'Cloudpad 800d'                             => [ 'Cloudfone', 'CloudPad 800d' ],
    ],

    'CW[- ]!!' => [
        'CW  V7 SIM'                                => [ 'Chuwi', 'V7' ],
        'CW V8 Dual'                                => [ 'Chuwi', 'V8' ],
        'CW-V9 DUAL'                                => [ 'Chuwi', 'V9' ],
        'CW-V17HD'                                  => [ 'Chuwi', 'V17HD' ],
        'CW-V18'                                    => [ 'Chuwi', 'V18' ],
        'CW V70'                                    => [ 'Chuwi', 'V70' ],
        'CW V80'                                    => [ 'Chuwi', 'V80' ],
        'CW-V88-QUAD'                               => [ 'Chuwi', 'V88' ],
        'CW-V88S'                                   => [ 'Chuwi', 'V88s' ],
        'CW-V88S-QUAD'                              => [ 'Chuwi', 'V88s' ],
        'CW-V99'                                    => [ 'Chuwi', 'V99' ],
        'CW-V99-QUAD'                               => [ 'Chuwi', 'V99' ],
        'CW-VX8-3G'                                 => [ 'Chuwi', 'VX8 3G' ],
        'CW-Hi8Pro'                                 => [ 'Chuwi', 'Hi8 Pro', DeviceType::TABLET ],
    ],

    'V17HD'                                     => [ 'Chuwi', 'V17HD' ],
    'Aquila 070-0508'                           => [ 'CMX', 'Aquila 070-0508', DeviceType::TABLET ],
    'Aquila 070-0508 3G'                        => [ 'CMX', 'Aquila 070-0508', DeviceType::TABLET ],
    'Aquila 080-0508'                           => [ 'CMX', 'Aquila 080-0508', DeviceType::TABLET ],
    'AQUILA 080-1008'                           => [ 'CMX', 'Aquila 080-1008', DeviceType::TABLET ],
    'Aquila 097-0508'                           => [ 'CMX', 'Aquila 097-0508', DeviceType::TABLET ],
    'AQUILA 097-1006'                           => [ 'CMX', 'Aquila 097-1006', DeviceType::TABLET ],
    'AQUILA 097-1016'                           => [ 'CMX', 'Aquila 097-1016', DeviceType::TABLET ],
    'AQUILA 097-1016 BT + 3G'                   => [ 'CMX', 'Aquila 097-1016', DeviceType::TABLET ],
    'AQUILA 097-1016 BT 3G'                     => [ 'CMX', 'Aquila 097-1016', DeviceType::TABLET ],
    'Aquila 101'                                => [ 'CMX', 'Aquila 101', DeviceType::TABLET ],
    'Aquila 101-1008 3G'                        => [ 'CMX', 'Aquila 101-1008', DeviceType::TABLET ],
    'Aquila LE 080-0508'                        => [ 'CMX', 'Aquila LE 080-0508', DeviceType::TABLET ],
    'Aquila SE 090-0508'                        => [ 'CMX', 'Aquila SE 090-0508', DeviceType::TABLET ],
    'Clanga 079-1016'                           => [ 'CMX', 'Clanga 079-1016', DeviceType::TABLET ],
    'Clanga 097-2016'                           => [ 'CMX', 'Clanga 097-2016', DeviceType::TABLET ],
    'Clanga SE 097-1008'                        => [ 'CMX', 'Clanga SE 097-1008', DeviceType::TABLET ],
    'RAPAXSE080-0508'                           => [ 'CMX', 'Rapax SE 080-0508', DeviceType::TABLET ],

    'CnM!!' => [
        'CnM TouchPad 7'                            => [ 'CnM', 'TouchPad 7', DeviceType::TABLET ],
        'CnM-TOUCHPAD 7'                            => [ 'CnM', 'TouchPad 7', DeviceType::TABLET ],
        'CnM-TOUCHPAD7'                             => [ 'CnM', 'TouchPad 7', DeviceType::TABLET ],
        'CnM TouchPad 7DC'                          => [ 'CnM', 'TouchPad 7 DC', DeviceType::TABLET ],
        'CnM-TP-8DC-16-B'                           => [ 'CnM', 'TouchPad 7 DC', DeviceType::TABLET ],
        'CnM TouchPad 9DC'                          => [ 'CnM', 'TouchPad 8 DC', DeviceType::TABLET ],
        'CnM TOUCHPAD 9'                            => [ 'CnM', 'TouchPad 9', DeviceType::TABLET ],
        'CnM-TOUCHPAD9'                             => [ 'CnM', 'TouchPad 9', DeviceType::TABLET ],
        'Cnm TOUCHPAD 9.7'                          => [ 'CnM', 'TouchPad 9.7', DeviceType::TABLET ],
        'CnM-TP-10DC-16-B'                          => [ 'CnM', 'TouchPad 10 DC', DeviceType::TABLET ],
        'CnM TouchPad 10.1DC'                       => [ 'CnM', 'TouchPad 10.1 DC', DeviceType::TABLET ],
    ],

    'MID[0-9]{4,4}!!' => [
        'MID1024'                                   => [ 'Coby', 'Kyros MID1024', DeviceType::TABLET ],
        'MID1042'                                   => [ 'Coby', 'Kyros MID1042', DeviceType::TABLET ],
        'MID1045'                                   => [ 'Coby', 'Kyros MID1045', DeviceType::TABLET ],
        'MID1048'                                   => [ 'Coby', 'Kyros MID1048', DeviceType::TABLET ],
        'MID1060'                                   => [ 'Coby', 'Kyros MID1060', DeviceType::TABLET ],
        'MID1065'                                   => [ 'Coby', 'Kyros MID1065', DeviceType::TABLET ],
        'MID1125'                                   => [ 'Coby', 'Kyros MID1125', DeviceType::TABLET ],
        'MID1126'                                   => [ 'Coby', 'Kyros MID1126', DeviceType::TABLET ],
        'MID4331'                                   => [ 'Coby', 'Kyros MID4331', DeviceType::MEDIA ],
        'MID7002'                                   => [ 'Coby', 'Kyros MID7002', DeviceType::TABLET ],
        'MID7005'                                   => [ 'Coby', 'Kyros MID7005', DeviceType::TABLET ],
        'MID7010'                                   => [ 'Coby', 'Kyros MID7010', DeviceType::TABLET ],
        'MID7011'                                   => [ 'Coby', 'Kyros MID7011', DeviceType::TABLET ],
        'MID7012'                                   => [ 'Coby', 'Kyros MID7012', DeviceType::TABLET ],
        'MID7014'                                   => [ 'Coby', 'Kyros MID7014', DeviceType::TABLET ],
        'MID7015!'                                  => [ 'Coby', 'Kyros MID7015', DeviceType::TABLET ],
        'MID7016'                                   => [ 'Coby', 'Kyros MID7016', DeviceType::TABLET ],
        'MID7020'                                   => [ 'Coby', 'Kyros MID7020', DeviceType::TABLET ],
        'MID7022'                                   => [ 'Coby', 'Kyros MID7022', DeviceType::TABLET ],
        'MID7024'                                   => [ 'Coby', 'Kyros MID7024', DeviceType::TABLET ],
        'MID7025'                                   => [ 'Coby', 'Kyros MID7025', DeviceType::TABLET ],
        'MID7032'                                   => [ 'Coby', 'Kyros MID7032', DeviceType::TABLET ],
        'MID7033'                                   => [ 'Coby', 'Kyros MID7033', DeviceType::TABLET ],
        'MID7034'                                   => [ 'Coby', 'Kyros MID7034', DeviceType::TABLET ],
        'MID7035'                                   => [ 'Coby', 'Kyros MID7035', DeviceType::TABLET ],
        'MID7036'                                   => [ 'Coby', 'Kyros MID7036', DeviceType::TABLET ],
        'MID7038'                                   => [ 'Coby', 'Kyros MID7038', DeviceType::TABLET ],
        'MID7042'                                   => [ 'Coby', 'Kyros MID7042', DeviceType::TABLET ],
        'MID7046'                                   => [ 'Coby', 'Kyros MID7046', DeviceType::TABLET ],
        'MID7047'                                   => [ 'Coby', 'Kyros MID7047', DeviceType::TABLET ],
        'MID7048'                                   => [ 'Coby', 'Kyros MID7048', DeviceType::TABLET ],
        'MID7051'                                   => [ 'Coby', 'Kyros MID7051', DeviceType::TABLET ],
        'MID7052'                                   => [ 'Coby', 'Kyros MID7052', DeviceType::TABLET ],
        'MID7055'                                   => [ 'Coby', 'Kyros MID7052', DeviceType::TABLET ],
        'MID7065'                                   => [ 'Coby', 'Kyros MID7065', DeviceType::TABLET ],
        'MID7120'                                   => [ 'Coby', 'Kyros MID7120', DeviceType::TABLET ],
        'MID7125'                                   => [ 'Coby', 'Kyros MID7125', DeviceType::TABLET ],
        'MID7127'                                   => [ 'Coby', 'Kyros MID7127', DeviceType::TABLET ],
        'MID8024'                                   => [ 'Coby', 'Kyros MID8024', DeviceType::TABLET ],
        'MID8042'                                   => [ 'Coby', 'Kyros MID8042', DeviceType::TABLET ],
        'MID8048'                                   => [ 'Coby', 'Kyros MID8048', DeviceType::TABLET ],
        'MID8065'                                   => [ 'Coby', 'Kyros MID8065', DeviceType::TABLET ],
        'MID8120'                                   => [ 'Coby', 'Kyros MID8120', DeviceType::TABLET ],
        'MID8125'                                   => [ 'Coby', 'Kyros MID8125', DeviceType::TABLET ],
        'MID8127'                                   => [ 'Coby', 'Kyros MID8127', DeviceType::TABLET ],
        'MID8128'                                   => [ 'Coby', 'Kyros MID8128', DeviceType::TABLET ],
        'MID9042'                                   => [ 'Coby', 'Kyros MID9042', DeviceType::TABLET ],
        'MID9724'                                   => [ 'Coby', 'Kyros MID9724', DeviceType::TABLET ],
        'MID9740'                                   => [ 'Coby', 'Kyros MID9740', DeviceType::TABLET ],
        'MID9742'                                   => [ 'Coby', 'Kyros MID9742', DeviceType::TABLET ],
        'MID9760'                                   => [ 'Coby', 'Kyros MID9760', DeviceType::TABLET ],
    ],

    'Ultimix!!' => [
        'Ultimix77'                                 => [ 'Codegen', 'Ultimix 77', DeviceType::TABLET ],
        'Ultimix 88'                                => [ 'Codegen', 'Ultimix 88', DeviceType::TABLET ],
        'Ultimix94'                                 => [ 'Codegen', 'Ultimix 94', DeviceType::TABLET ],
        'Ultimix95'                                 => [ 'Codegen', 'Ultimix 95', DeviceType::TABLET ],
        'Ultimix99'                                 => [ 'Codegen', 'Ultimix 99', DeviceType::TABLET ],
    ],

    'BLADE LE 70'                               => [ 'COMMAX', 'BLADE LE 70', DeviceType::TABLET ],

    'Commodore!!' => [
        'Commodore  IS-7107C'                       => [ 'Commodore', 'IS-7107C', DeviceType::TABLET ],
        'Commodore IS-7107C'                        => [ 'Commodore', 'IS-7107C', DeviceType::TABLET ],
    ],

    'Z71'                                       => [ 'Commtiva', 'Z71' ],
    'V-T100'                                    => [ 'Commtiva', 'V-T100' ],
    'FIH-FB0'                                   => [ 'Commtiva', 'HD700'],
    'Commtiva-HD710'                            => [ 'Commtiva', 'HD710'],
    'Commtiva-N700'                             => [ 'Commtiva', 'N700'],
    'Connspeed IP71'                            => [ 'Connspeed', 'IP71' ],

    '(Colorfly|CT[0-9]{3,3})!!' => [
        'Colorfly CT102 Qise 3'                     => [ 'Colorfly', 'CT102 Qise 3', DeviceType::TABLET ],
        'CT704 D·Bok'                               => [ 'Colorfly', 'CT704 D·Bok', DeviceType::TABLET ],
        'CT801 Eyas'                                => [ 'Colorfly', 'CT801 Eyas', DeviceType::TABLET ],
        'CT801 Q.Ait'                               => [ 'Colorfly', 'CT801 Q·Ait', DeviceType::TABLET ],
        'Colorfly CT972Q·Vanilla'                   => [ 'Colorfly', 'CT972 Q·Vanilla', DeviceType::TABLET ],
        'Colorfly CT972QÂ·Vanilla'                  => [ 'Colorfly', 'CT972 Q·Vanilla', DeviceType::TABLET ],
        'Colorfly CT972QÃ‚Â·Vanilla'                => [ 'Colorfly', 'CT972 Q·Vanilla', DeviceType::TABLET ],
        'CT972 Q.Vanilla 2'                         => [ 'Colorfly', 'CT972 Q·Vanilla 2', DeviceType::TABLET ],
        'CT974 Ivory 3'                             => [ 'Colorfly', 'CT974 Ivory 3', DeviceType::TABLET ],
        'Colorfly E708'                             => [ 'Colorfly', 'E708', DeviceType::TABLET ],
        'Colorfly E708 Q1'                          => [ 'Colorfly', 'E708 Q1', DeviceType::TABLET ],
        'Colorfly E708 Q1s'                         => [ 'Colorfly', 'E708 Q1s', DeviceType::TABLET ],
        'Colorfly E708 Q2'                          => [ 'Colorfly', 'E708 Q2', DeviceType::TABLET ],
        'Colorfly G708'                             => [ 'Colorfly', 'G708', DeviceType::TABLET ],
        'Colorfly S782 Q1'                          => [ 'Colorfly', 'S782 Q1', DeviceType::TABLET ],
        'Colorfly U781 Q1'                          => [ 'Colorfly', 'U781 Q1', DeviceType::TABLET ],
    ],

    'K11'                                       => [ 'Colors', 'K11' ],
    'XT751'                                     => [ 'Colors', 'XT751' ],

    'Colors!!' => [
        'Colors K22'                                => [ 'Colors', 'K22' ],
        'Colors X27'                                => [ 'Colors', 'Xfactor Wave X27' ],
        'Colors X45'                                => [ 'Colors', 'X45' ],
        'Colors X115'                               => [ 'Colors', 'Xfactor Quad II X115' ],
    ],

    'ConCorde!!' => [
        'ConCorde SmartPhone 4300'                  => [ 'ConCorde', 'SmartPhone 4300' ],
        'ConCorde SmartPhone5000'                   => [ 'ConCorde', 'SmartPhone 5000' ],
        'ConCorde Smartphone 5005 NFC'              => [ 'ConCorde', 'SmartPhone 5005 NFC' ],
        'ConCorde SmartPhone5700'                   => [ 'ConCorde', 'SmartPhone 5700' ],
        'ConCorde SmartPhone6500'                   => [ 'ConCorde', 'SmartPhone 6500' ],
        'ConCorde tab 9.7IPS PLUS'                  => [ 'ConCorde', 'tab 9.7IPS Plus', DeviceType::TABLET ],
        'ConCorde tab NOVUM'                        => [ 'ConCorde', 'tab NOVUM', DeviceType::TABLET ],
        'Concorde Tab Omega 3G'                     => [ 'ConCorde', 'tab OMEGA', DeviceType::TABLET ],
        'ConCorde tab PLAY'                         => [ 'ConCorde', 'tab PLAY', DeviceType::TABLET ],
        'ConCorde tab Speed'                        => [ 'ConCorde', 'tab SPEED', DeviceType::TABLET ],
        'ConCorde Tab T10'                          => [ 'ConCorde', 'tab T10', DeviceType::TABLET ],
    ],

    'Coolgen!!' => [
        'Coolgen E68+'                              => [ 'Coolgen', 'E68+' ],
        'Coolgen E69+'                              => [ 'Coolgen', 'E69+' ],
        'Coolgen E70'                               => [ 'Coolgen', 'E70' ],
        'Coolgen E70 G'                             => [ 'Coolgen', 'E70 G' ],
        'Coolgen E71'                               => [ 'Coolgen', 'E71' ],
        'Coolgen E72 Note 3G'                       => [ 'Coolgen', 'E72' ],
        'Coolgen E72 Note8'                         => [ 'Coolgen', 'E72' ],
    ],

    'Coolpad!!' => [
        'Coolpad A8-531'                            => [ 'Coolpad', 'A8-531' ],
        'Coolpad A8-930'                            => [ 'Coolpad', 'Max A8-930' ],
        'Coolpad A8-931'                            => [ 'Coolpad', 'Max A8-931' ],
        'Coolpad A8-932'                            => [ 'Coolpad', 'Max A8-932' ],
        'Coolpad B770'                              => [ 'Coolpad', 'B770' ],
        'Coolpad D510'                              => [ 'Coolpad', 'D510' ],
        'Coolpad D530'                              => [ 'Coolpad', 'D530' ],
        'Coolpad D530TW'                            => [ 'Coolpad', 'D530' ],
        'Coolpad D539'                              => [ 'Coolpad', 'D539' ],
        'Coolpad E239'                              => [ 'Coolpad', 'E239' ],
        'Coolpad E501!'                             => [ 'Coolpad', 'E501' ],
        'Coolpad E560'                              => [ 'Coolpad', 'E560' ],
        'Coolpad F101'                              => [ 'Coolpad', 'F101' ],
        'Coolpad F103'                              => [ 'Coolpad', 'F103' ],
        'Coolpad N930'                              => [ 'Coolpad', 'N930' ],
        'Coolpad N950'                              => [ 'Coolpad', 'N950' ],
        'Coolpad R106'                              => [ 'Coolpad', 'R106' ],
        'Coolpad S6-NT'                             => [ 'Coolpad', 'S6-NT' ],
        'Coolpad T1'                                => [ 'Coolpad', 'T1' ],
        'Coolpad T2-00'                             => [ 'Coolpad', 'T2' ],
        'Coolpad T2-C01'                            => [ 'Coolpad', 'T2' ],
        'Coolpad V1-C'                              => [ 'Coolpad', 'Bodun' ],
        'Coolpad W706!'                             => [ 'Coolpad', 'W706' ],
        'Coolpad W708'                              => [ 'Coolpad', 'W708' ],
        'Coolpad Y1'                                => [ 'Coolpad', 'Y1' ],
        'Coolpad Y60!'                              => [ 'Coolpad', 'Y60' ],
        'Coolpad Y70!'                              => [ 'Coolpad', 'Y70' ],
        'Coolpad Y71!'                              => [ 'Coolpad', 'Y71' ],
        'Coolpad Y75!'                              => [ 'Coolpad', 'Y75' ],
        'Coolpad Y76!'                              => [ 'Coolpad', 'Y76' ],
        'Coolpad Y80!'                              => [ 'Coolpad', 'Y80' ],
        'Coolpad Y82!'                              => [ 'Coolpad', 'Y82' ],
        'Coolpad Y90!'                              => [ 'Coolpad', 'Y90' ],
        'Coolpad 3300A'                             => [ 'Coolpad', '3300A' ],
        'Coolpad 3320A'                             => [ 'Coolpad', '3320A' ],
        'Coolpad 5010'                              => [ 'Coolpad', '5010' ],
        'Coolpad 5108'                              => [ 'Coolpad', '5108' ],
        'Coolpad 5109'                              => [ 'Coolpad', '5109' ],
        'Coolpad 5110'                              => [ 'Coolpad', '5110' ],
        'Coolpad 5200'                              => [ 'Coolpad', '5200' ],
        'Coolpad 5200S'                             => [ 'Coolpad', '5200S' ],
        'Coolpad 5210!'                             => [ 'Coolpad', '5210' ],
        'Coolpad 5211'                              => [ 'Coolpad', '5211' ],
        'Coolpad 5213'                              => [ 'Coolpad', '5213' ],
        'Coolpad 5216!'                             => [ 'Coolpad', '5216' ],
        'Coolpad 5217'                              => [ 'Coolpad', '5217' ],
        'Coolpad 5218!'                             => [ 'Coolpad', '5218' ],
        'Coolpad 5219'                              => [ 'Coolpad', '5219' ],
        'Coolpad 5230!'                             => [ 'Coolpad', '5230' ],
        'Coolpad 5261!'                             => [ 'Coolpad', '5261' ],
        'Coolpad 5263!'                             => [ 'Coolpad', '5263' ],
        'Coolpad 5310'                              => [ 'Coolpad', '5310' ],
        'Coolpad 5311'                              => [ 'Coolpad', '5311' ],
        'Coolpad 5313'                              => [ 'Coolpad', '5313' ],
        'Coolpad 5313S'                             => [ 'Coolpad', '5313S' ],
        'Coolpad 5316'                              => [ 'Coolpad', '5316' ],
        'Coolpad 5360'                              => [ 'Coolpad', '5360' ],
        'Coolpad 5820'                              => [ 'Coolpad', '5820' ],
        'Coolpad 5832'                              => [ 'Coolpad', '5832' ],
        'Coolpad 5860!'                             => [ 'Coolpad', '5860' ],
        'Coolpad 5870'                              => [ 'Coolpad', '5870' ],
        'Coolpad 5872'                              => [ 'Coolpad', '5872' ],
        'Coolpad 5876'                              => [ 'Coolpad', '5876' ],
        'Coolpad 5879'                              => [ 'Coolpad', '5879' ],
        'Coolpad 5879T'                             => [ 'Coolpad', '5879T' ],
        'Coolpad 5880'                              => [ 'Coolpad', '5880' ],
        'Coolpad 5890'                              => [ 'Coolpad', '5890' ],
        'Coolpad 5891!'                             => [ 'Coolpad', '5891' ],
        'Coolpad 5892!'                             => [ 'Coolpad', '5892' ],
        'Coolpad 5910'                              => [ 'Coolpad', '5910' ],
        'Coolpad 5930!'                             => [ 'Coolpad', '5930' ],
        'Coolpad 5950'                              => [ 'Coolpad', '5950' ],
        'Coolpad 5950T'                             => [ 'Coolpad', '5950T' ],
        'Coolpad 5951'                              => [ 'Coolpad', '5951' ],
        'Coolpad 5952'                              => [ 'Coolpad', '5952' ],
        'Coolpad 5956'                              => [ 'Coolpad', '5956' ],
        'Coolpad 7005'                              => [ 'Coolpad', '7005' ],
        'Coolpad 7011'                              => [ 'Coolpad', '7011' ],
        'Coolpad 7019!'                             => [ 'Coolpad', '7019' ],
        'Coolpad 7020'                              => [ 'Coolpad', '7020' ],
        'Coolpad 7060!'                             => [ 'Coolpad', '7060' ],
        'Coolpad 7061'                              => [ 'Coolpad', '7061' ],
        'Coolpad 7105'                              => [ 'Coolpad', '7105' ],
        'Coolpad 7230!'                             => [ 'Coolpad', '7230' ],
        'Coolpad 7231'                              => [ 'Coolpad', '7231' ],
        'Coolpad 7232'                              => [ 'Coolpad', '7232' ],
        'Coolpad 7235'                              => [ 'Coolpad', '7235' ],
        'Coolpad 7236'                              => [ 'Coolpad', '7236' ],
        'Coolpad 7251'                              => [ 'Coolpad', '7251' ],
        'Coolpad 7260!'                             => [ 'Coolpad', '7260' ],
        'Coolpad 7266'                              => [ 'Coolpad', '7266' ],
        'Coolpad 7268'                              => [ 'Coolpad', '7268' ],
        'Coolpad 7269'                              => [ 'Coolpad', '7269' ],
        'Coolpad 7270'                              => [ 'Coolpad', '7270' ],
        'Coolpad 7270 W00'                          => [ 'Coolpad', '7270' ],
        'Coolpad 7275'                              => [ 'Coolpad', '7275' ],
        'Coolpad 7290'                              => [ 'Coolpad', '7290' ],
        'Coolpad 7295!'                             => [ 'Coolpad', '7295' ],
        'Coolpad 7296'                              => [ 'Coolpad', '7296' ],
        'Coolpad 7296S'                             => [ 'Coolpad', '7296S' ],
        'Coolpad 7298A'                             => [ 'Coolpad', '7298A' ],
        'Coolpad 7298D'                             => [ 'Coolpad', '7298D' ],
        'Coolpad 7320'                              => [ 'Coolpad', '7320' ],
        'Coolpad 7560U'                             => [ 'Coolpad', '7560U' ],
        'Coolpad 7620L!'                            => [ 'Coolpad', '7620L' ],
        'Coolpad 7722'                              => [ 'Coolpad', '7722' ],
        'Coolpad 7728'                              => [ 'Coolpad', '7728' ],
        'Coolpad 8010'                              => [ 'Coolpad', '8010' ],
        'Coolpad 8012'                              => [ 'Coolpad', '8012' ],
        'Coolpad 8013'                              => [ 'Coolpad', '8013' ],
        'Coolpad 8017!'                             => [ 'Coolpad', '8017' ],
        'Coolpad 8020!'                             => [ 'Coolpad', '8020' ],
        'Coolpad 8021'                              => [ 'Coolpad', '8021' ],
        'Coolpad 8022'                              => [ 'Coolpad', '8022' ],
        'Coolpad 8026'                              => [ 'Coolpad', '8026' ],
        'Coolpad 8028'                              => [ 'Coolpad', '8028' ],
        'Coolpad 8029'                              => [ 'Coolpad', '8029' ],
        'Coolpad 8050'                              => [ 'Coolpad', '8050' ],
        'Coolpad 8056'                              => [ 'Coolpad', '8056' ],
        'Coolpad -8056'                             => [ 'Coolpad', '8056' ],
        'Coolpad 8060'                              => [ 'Coolpad', '8060' ],
        'Coolpad 8070'                              => [ 'Coolpad', '8070' ],
        'Coolpad 8070D'                             => [ 'Coolpad', '8070D' ],
        'Coolpad 8071'                              => [ 'Coolpad', '8071' ],
        'Coolpad 8076'                              => [ 'Coolpad', '8076' ],
        'Coolpad -8076!'                            => [ 'Coolpad', '8076' ],
        'Coolpad 8076D'                             => [ 'Coolpad', '8076' ],
        'Coolpad 8079'                              => [ 'Coolpad', '8079' ],
        'Coolpad 8085'                              => [ 'Coolpad', '8085' ],
        'Coolpad 8085Q'                             => [ 'Coolpad', '8085' ],
        'Coolpad 8089'                              => [ 'Coolpad', '8089' ],
        'Coolpad 8105'                              => [ 'Coolpad', '8105' ],
        'Coolpad 8122'                              => [ 'Coolpad', '8122' ],
        'Coolpad 8150S'                             => [ 'Coolpad', '8150' ],
        'Coolpad -?8190!'                           => [ 'Coolpad', '8190' ],
        'Coolpad 8198T'                             => [ 'Coolpad', '8198T' ],
        'Coolpad 8295M'                             => [ 'Coolpad', '8295M' ],
        'Coolpad 8295!'                             => [ 'Coolpad', '8295' ],
        'Coolpad 8297!'                             => [ 'Coolpad', 'Dashen F1' ],
        'Coolpad F1 8297W'                          => [ 'Coolpad', 'Dashen F1' ],
        'Coolpad 8670'                              => [ 'Coolpad', 'Note 8670' ],
        'Coolpad 8675!'                             => [ 'Coolpad', 'Dashen F2' ],
        'Coolpad 8676!'                             => [ 'Coolpad', 'Note 3 8676' ],
        'Coolpad 8690!'                             => [ 'Coolpad', 'Dashen X7' ],
        'Coolpad 8702'                              => [ 'Coolpad', '8702' ],
        'Coolpad 8702D'                             => [ 'Coolpad', '8702D' ],
        'Coolpad 8705'                              => [ 'Coolpad', '8705' ],
        'Coolpad 8707'                              => [ 'Coolpad', '8707' ],
        'Coolpad 8713'                              => [ 'Coolpad', '8713' ],
        'Coolpad 8720L'                             => [ 'Coolpad', '8720L' ],
        'Coolpad 8720Q'                             => [ 'Coolpad', '8720Q' ],
        'Coolpad 8722V'                             => [ 'Coolpad', '8722V' ],
        'Coolpad 8729'                              => [ 'Coolpad', '8729' ],
        'Coolpad 8730L'                             => [ 'Coolpad', '8730L' ],
        'Coolpad 8732'                              => [ 'Coolpad', '8732' ],
        'Coolpad 8735'                              => [ 'Coolpad', '8735' ],
        'Coolpad 8736'                              => [ 'Coolpad', '8736' ],
        'Coolpad 8750'                              => [ 'Coolpad', 'Xuan Ying SII 8750' ],
        'Coolpad 8809'                              => [ 'Coolpad', '8809' ],
        'Coolpad 8810'                              => [ 'Coolpad', '8810' ],
        'Coolpad 8811'                              => [ 'Coolpad', '8811' ],
        'Coolpad 8860!'                             => [ 'Coolpad', '8860' ],
        'Coolpad 8870!'                             => [ 'Coolpad', '8870' ],
        'Coolpad 8908'                              => [ 'Coolpad', '8908' ],
        'Coolpad 8920'                              => [ 'Coolpad', 'Quattro II 8920' ],
        'Coolpad 8970L'                             => [ 'Coolpad', 'Grand 4 8970' ],
        'Coolpad 8971'                              => [ 'Coolpad', '8971' ],
        'Coolpad 9070'                              => [ 'Coolpad', '9070+XO' ],
        'Coolpad 9080W'                             => [ 'Coolpad', '9080' ],
        'Coolpad 9100'                              => [ 'Coolpad', '9100' ],
        'Coolpad 9120'                              => [ 'Coolpad', '9120' ],
        'Coolpad 9150'                              => [ 'Coolpad', 'Air 9150' ],
        'Coolpad 9150W'                             => [ 'Coolpad', 'Air 9150' ],
        'Coolpad 9190L!'                            => [ 'Coolpad', 'S6 9190' ],
        'Coolpad 9190 T00'                          => [ 'Coolpad', 'S6 9190' ],
        'Coolpad 9900'                              => [ 'Coolpad', '9900' ],
        'Coolpad 9960'                              => [ 'Coolpad', 'Grand HD 9960' ],
        'Coolpad 9970'                              => [ 'Coolpad', 'Grand 4 9970' ],
        'Coolpad 9976!'                             => [ 'Coolpad', '9976' ],
        'Coolpad Flo'                               => [ 'Coolpad', 'Flo' ],
    ],

    'D530'                                      => [ 'Coolpad', 'D530' ],
    'D539'                                      => [ 'Coolpad', 'D539' ],
    'E239'                                      => [ 'Coolpad', 'E239' ],
    'N930'                                      => [ 'Coolpad', 'N930' ],
    'W711'                                      => [ 'Coolpad', 'W711' ],
    'CP3700A'                                   => [ 'Coolpad', '3700A' ],
    '5560S'                                     => [ 'Coolpad', '5560S' ],
    '5832'                                      => [ 'Coolpad', '5832' ],
    '5855'                                      => [ 'Coolpad', '5855' ],
    '5860'                                      => [ 'Coolpad', '5860' ],
    '5860A'                                     => [ 'Coolpad', '5860A' ],
    '5860E'                                     => [ 'Coolpad', 'Quattro 4G 5860E' ],
    '5860S'                                     => [ 'Coolpad', '5860S' ],
    '5870'                                      => [ 'Coolpad', '5870' ],
    '7260'                                      => [ 'Coolpad', '7260' ],
    '7266'                                      => [ 'Coolpad', '7266' ],
    '8022'                                      => [ 'Coolpad', '8022' ],
    '8190Q'                                     => [ 'Coolpad', '8190' ],
    '8720'                                      => [ 'Coolpad', '8720' ],
    '8720L'                                     => [ 'Coolpad', '8720' ],
    '8810'                                      => [ 'Coolpad', '8810' ],
    '801ES'                                     => [ 'Coolpad', 'Quattro II 4G' ],
    'CP8298 I00'                                => [ 'Coolpad', 'Note 3 Lite' ],

    'COSHIP F2'                                 => [ 'Coship', 'F2' ],

    'COWON!!' => [
        'COWON D3'                                  => [ 'Cowon', 'D3 Plenue', DeviceType::MEDIA ],
        'COWON Z2'                                  => [ 'Cowon', 'Z2 Plenue', DeviceType::MEDIA ],
    ],

    'COZCO C1 Plus'                             => [ 'Cozco', 'C1 Plus' ],
    'CLP281X'                                   => [ 'Craig', 'CLP281x', DeviceType::TABLET ],

    'CMP!!' => [
        'CMP741d'                                   => [ 'Craig', 'CMP741d', DeviceType::TABLET ],
        'CMP741E'                                   => [ 'Craig', 'CMP741e', DeviceType::TABLET ],
        'CMP745E'                                   => [ 'Craig', 'CMP745e', DeviceType::TABLET ],
        'CMP748'                                    => [ 'Craig', 'CMP748', DeviceType::TABLET ],
        'CMP749'                                    => [ 'Craig', 'CMP749', DeviceType::TABLET ],
        'CMP756'                                    => [ 'Craig', 'CMP756', DeviceType::TABLET ],
        'CMP 765'                                   => [ 'Craig', 'CMP765', DeviceType::TABLET ],
    ],

    'ZEN Touch 2'                               => [ 'Creative', 'ZEN Touch 2', DeviceType::MEDIA ],

    'Zii!!' => [
        'ZiiO7'                                     => [ 'Creative', 'ZiiO 7', DeviceType::TABLET ],
        'ZiiLABS ZiiO7'                             => [ 'Creative', 'ZiiO 7', DeviceType::TABLET ],
        'ZiiLABS ZiiO10'                            => [ 'Creative', 'ZiiO 10', DeviceType::TABLET ],
        'ZiiLABS ZiiO10 '                           => [ 'Creative', 'ZiiO 10', DeviceType::TABLET ],
        'ZiiLABS ZiiO10+'                           => [ 'Creative', 'ZiiO 10', DeviceType::TABLET ],
        'ZiiLABS ZiiO Shenbi'                       => [ 'Creative', 'ZiiO ShenBi', DeviceType::TABLET ],
        'Zii EGG'                                   => [ 'Creative', 'Zii Egg', DeviceType::MEDIA ],
    ],

    'CTP828BT'                                  => [ 'Cresta', 'CTP828BT', DeviceType::TABLET ],
    'CRESTA.CTP888'                             => [ 'Cresta', 'CTP888', DeviceType::TABLET ],

    'Cross!!' => [
        'CROSS-A1'                                  => [ 'Cross', 'A1' ],
        'Cross A2'                                  => [ 'Cross', 'A2' ],
        'CROSS A5'                                  => [ 'Cross', 'A5' ],
        'CROSS A5B'                                 => [ 'Cross', 'A5B' ],
        'Cross A7*'                                 => [ 'Cross', 'A7' ],
        'CROSS A7#'                                 => [ 'Cross', 'A7' ],
        'Cross Andromeda A7*'                       => [ 'Cross', 'A7' ],
        'CROSS A7S'                                 => [ 'Cross', 'A7S' ],
        'CROSSA7S'                                  => [ 'Cross', 'A7S' ],
        'CROSS A10'                                 => [ 'Cross', 'A10' ],
        'CROSS A11'                                 => [ 'Cross', 'A11' ],
        'CrossA18'                                  => [ 'Cross', 'A18' ],
        'CROSS-A20G'                                => [ 'Cross', 'A20G' ],
        'Cross A22'                                 => [ 'Cross', 'A22' ],
        'Cross A25'                                 => [ 'Cross', 'A25' ],
        'CROSS A26'                                 => [ 'Cross', 'A26' ],
        'CROSS A27'                                 => [ 'Cross', 'A27' ],
        'CROSS A28'                                 => [ 'Cross', 'A28' ],
        'CROSS A66'                                 => [ 'Cross', 'A66' ],
        'CROSS A88'                                 => [ 'Cross', 'A88' ],
        'CROSS AT1'                                 => [ 'Cross', 'AT1', DeviceType::TABLET ],
        'CROSS AT1G'                                => [ 'Cross', 'AT1G', DeviceType::TABLET ],
        'CROSS AT1G*'                               => [ 'Cross', 'AT1G', DeviceType::TABLET ],
    ],

    'Crosscall!!' => [
        'Crosscall ELEMENT'                         => [ 'Crosscall', 'ELEMENT' ],
        'CROSSCALL WILD'                            => [ 'Crosscall', 'WILD' ],
    ],

    'Novapad!!' => [
        'Novapad 70 D124 FC'                        => [ 'Crypto', 'NovaPad 70 D124', DeviceType::TABLET ],
        'Novapad 70 S124 FC'                        => [ 'Crypto', 'NovaPad 70 S124', DeviceType::TABLET ],
        'NovaPad80C104'                             => [ 'Crypto', 'NovaPad 80 C104', DeviceType::TABLET ],
        'NovaPad 80 C124'                           => [ 'Crypto', 'NovaPad 80 C124', DeviceType::TABLET ],
        'Novapad D7000'                             => [ 'Crypto', 'NovaPad D7000', DeviceType::TABLET ],
        'Novapad D7001'                             => [ 'Crypto', 'NovaPad D7001', DeviceType::TABLET ],
        'Novapad D7002'                             => [ 'Crypto', 'NovaPad D7002', DeviceType::TABLET ],
    ],

    'CUBOT!!' => [
        'CUBOT C7'                                  => [ 'Cubot', 'C7' ],
        'CUBOT C7+'                                 => [ 'Cubot', 'C7+' ],
        'CUBOT C9+'                                 => [ 'Cubot', 'C9+' ],
        'CUBOT C9W'                                 => [ 'Cubot', 'C9W' ],
        'CUBOT C11'                                 => [ 'Cubot', 'C11' ],
        'CUBOT GT72E'                               => [ 'Cubot', 'GT72E' ],
        'CUBOT GT99'                                => [ 'Cubot', 'GT99' ],
        'CUBOT ONE'                                 => [ 'Cubot', 'One' ],
        'CUBOT ONE-S'                               => [ 'Cubot', 'One S' ],
        'CUBOT P7'                                  => [ 'Cubot', 'P7' ],
        'CUBOT P9'                                  => [ 'Cubot', 'P9' ],
        'CUBOT S108'                                => [ 'Cubot', 'S108' ],
        'CUBOT S222'                                => [ 'Cubot', 'S222' ],
        'CUBOT X6'                                  => [ 'Cubot', 'X6' ],
    ],

    'S222'                                      => [ 'Cubot', 'S222' ],
    'S308'                                      => [ 'Cubot', 'S308' ],

    '(CUBE ?)?(K8|U1|U2|U3|U5|U6|U8|U9)[0-9]?GT!!' => [
        'CUBE K8GT'                                 => [ 'Cube', 'K8GT', DeviceType::TABLET ],
        'CUBE K8GT A'                               => [ 'Cube', 'K8GT A', DeviceType::TABLET ],
        'CUBE K8GT B'                               => [ 'Cube', 'K8GT B', DeviceType::TABLET ],
        'K8GT C'                                    => [ 'Cube', 'K8GT C', DeviceType::TABLET ],
        'K8GT H'                                    => [ 'Cube', 'K8GT H', DeviceType::TABLET ],
        'CUBE K8GT H'                               => [ 'Cube', 'K8GT H', DeviceType::TABLET ],
        'K8GT W'                                    => [ 'Cube', 'K8GT W', DeviceType::TABLET ],
        'CUBE U8GT'                                 => [ 'Cube', 'U8GT', DeviceType::TABLET ],
        'CUBE U9GT'                                 => [ 'Cube', 'U9GT', DeviceType::TABLET ],
        'CUBE U9 GT'                                => [ 'Cube', 'U9GT', DeviceType::TABLET ],
        'U9GT'                                      => [ 'Cube', 'U9GT', DeviceType::TABLET ],
        'U9GT S'                                    => [ 'Cube', 'U9GT S', DeviceType::TABLET ],
        'U9GT-S'                                    => [ 'Cube', 'U9GT S', DeviceType::TABLET ],
        'U9GT S A'                                  => [ 'Cube', 'U9GT SA', DeviceType::TABLET ],
        'U9GTS A'                                   => [ 'Cube', 'U9GT SA', DeviceType::TABLET ],
        'U9GT-SA'                                   => [ 'Cube', 'U9GT SA', DeviceType::TABLET ],
        'U9GT V'                                    => [ 'Cube', 'U9GT V', DeviceType::TABLET ],
        'U9GT V Core 4'                             => [ 'Cube', 'U9GT V', DeviceType::TABLET ],
        'CUBE U9GT ?2!'                             => [ 'Cube', 'U9GT2', DeviceType::TABLET ],
        'Cube U9GT-2'                               => [ 'Cube', 'U9GT2', DeviceType::TABLET ],
        'U9GT2!'                                    => [ 'Cube', 'U9GT2', DeviceType::TABLET ],
        'N90 From moage.com'                        => [ 'Cube', 'U9GT2', DeviceType::TABLET ],
        'U9GT3'                                     => [ 'Cube', 'U9GT3', DeviceType::TABLET ],
        'U9GT3-S'                                   => [ 'Cube', 'U9GT3 S', DeviceType::TABLET ],
        'U9GT4'                                     => [ 'Cube', 'U9GT4', DeviceType::TABLET ],
        'U10GT A'                                   => [ 'Cube', 'U10GT A', DeviceType::TABLET ],
        'U10GT-A'                                   => [ 'Cube', 'U10GT A', DeviceType::TABLET ],
        'U10GT S'                                   => [ 'Cube', 'U10GT S', DeviceType::TABLET ],
        'U10GT 2'                                   => [ 'Cube', 'U10GT2', DeviceType::TABLET ],
        'CUBE U15GT'                                => [ 'Cube', 'U15GT', DeviceType::TABLET ],
        'U18GT'                                     => [ 'Cube', 'U18GT', DeviceType::TABLET ],
        'U18GT-H'                                   => [ 'Cube', 'U18GT H', DeviceType::TABLET ],
        'U18GT-S'                                   => [ 'Cube', 'U18GT S', DeviceType::TABLET ],
        'U18GT-W'                                   => [ 'Cube', 'U18GT W', DeviceType::TABLET ],
        'U18GTW'                                    => [ 'Cube', 'U18GT W', DeviceType::TABLET ],
        'U18GT2'                                    => [ 'Cube', 'U18GT2', DeviceType::TABLET ],
        'U19GT-W'                                   => [ 'Cube', 'U19GT W', DeviceType::TABLET ],
        'U21GT'                                     => [ 'Cube', 'U21GT', DeviceType::TABLET ],
        'U20GT'                                     => [ 'Cube', 'U20GT', DeviceType::TABLET ],
        'U20GT WS'                                  => [ 'Cube', 'U20GT WS', DeviceType::TABLET ],
        'U23GT'                                     => [ 'Cube', 'U23GT', DeviceType::TABLET ],
        'U23GT-S'                                   => [ 'Cube', 'U23GT S', DeviceType::TABLET ],
        'U23GTC4'                                   => [ 'Cube', 'U23GT C4', DeviceType::TABLET ],
        'U25GT'                                     => [ 'Cube', 'U25GT', DeviceType::TABLET ],
        'CUBE U25GT'                                => [ 'Cube', 'U25GT', DeviceType::TABLET ],
        'U25GT PRO'                                 => [ 'Cube', 'U25GT Pro', DeviceType::TABLET ],
        'U25GT-W'                                   => [ 'Cube', 'U25GT W', DeviceType::TABLET ],
        'U25GT-W4'                                  => [ 'Cube', 'U25GT W4', DeviceType::TABLET ],
        'U25GT-BN'                                  => [ 'Cube', 'U25GT BN', DeviceType::TABLET ],
        'U25GT-C4'                                  => [ 'Cube', 'U25GT C4', DeviceType::TABLET ],
        'U25GT-C4W'                                 => [ 'Cube', 'U25GT C4W', DeviceType::TABLET ],
        'U25GT-C4WB'                                => [ 'Cube', 'U25GT C4WB', DeviceType::TABLET ],
        'U25GT-C4Y'                                 => [ 'Cube', 'U25GT C4Y', DeviceType::TABLET ],
        'U25GT-YR'                                  => [ 'Cube', 'U25GT YR', DeviceType::TABLET ],
        'U25GT2-H'                                  => [ 'Cube', 'U25GT2 H', DeviceType::TABLET ],
        'U25GT2-T'                                  => [ 'Cube', 'U25GT2 T', DeviceType::TABLET ],
        'U27GT'                                     => [ 'Cube', 'U27GT', DeviceType::TABLET ],
        'U27GT-C8'                                  => [ 'Cube', 'U27GT C8', DeviceType::TABLET ],
        'U27GT-C8P'                                 => [ 'Cube', 'U27GT C8P', DeviceType::TABLET ],
        'U27GT-SD'                                  => [ 'Cube', 'U27GT SD', DeviceType::TABLET ],
        'U27GT-3G'                                  => [ 'Cube', 'U27GT 3G', DeviceType::TABLET ],
        'U27GT-3GH'                                 => [ 'Cube', 'U27GT 3GH', DeviceType::TABLET ],
        'U27GT-3GHY'                                => [ 'Cube', 'U27GT 3GHY', DeviceType::TABLET ],
        'U28GT'                                     => [ 'Cube', 'U28GT', DeviceType::TABLET ],
        'U30GT'                                     => [ 'Cube', 'U30GT', DeviceType::TABLET ],
        'U30GT C4'                                  => [ 'Cube', 'U30GT C4', DeviceType::TABLET ],
        'U30GT-H'                                   => [ 'Cube', 'U30GT H', DeviceType::TABLET ],
        'U30GT-H By BiscuitTeam'                    => [ 'Cube', 'U30GT H', DeviceType::TABLET ],
        'U30GT-HS'                                  => [ 'Cube', 'U30GT HS', DeviceType::TABLET ],
        'U30GT-M'                                   => [ 'Cube', 'U30GT M', DeviceType::TABLET ],
        'U30GT-MS'                                  => [ 'Cube', 'U30GT MS', DeviceType::TABLET ],
        'U30GTm2'                                   => [ 'Cube', 'U30GT M2', DeviceType::TABLET ],
        'U30GT MINI'                                => [ 'Cube', 'U30GT Mini', DeviceType::TABLET ],
        'U30GT-mini'                                => [ 'Cube', 'U30GT Mini', DeviceType::TABLET ],
        'U30GT-W'                                   => [ 'Cube', 'U30GT W', DeviceType::TABLET ],
        'u30gt2'                                    => [ 'Cube', 'U30GT2', DeviceType::TABLET ],
        'U30GT 2'                                   => [ 'Cube', 'U30GT2', DeviceType::TABLET ],
        'U30GT-2'                                   => [ 'Cube', 'U30GT2', DeviceType::TABLET ],
        'U30GT 2MH'                                 => [ 'Cube', 'U30GT2 MH', DeviceType::TABLET ],
        'U31GT'                                     => [ 'Cube', 'U31GT', DeviceType::TABLET ],
        'U33GT'                                     => [ 'Cube', 'U33GT', DeviceType::TABLET ],
        'U35GT'                                     => [ 'Cube', 'U35GT', DeviceType::TABLET ],
        'U35GT-W'                                   => [ 'Cube', 'U35GT W', DeviceType::TABLET ],
        'U35GT2'                                    => [ 'Cube', 'U35GT2', DeviceType::TABLET ],
        'U39GT'                                     => [ 'Cube', 'U39GT', DeviceType::TABLET ],
        'U39GT-W'                                   => [ 'Cube', 'U39GT W', DeviceType::TABLET ],
        'U39GT-3G'                                  => [ 'Cube', 'U39GT 3G', DeviceType::TABLET ],
        'U51GT'                                     => [ 'Cube', 'U51GT', DeviceType::TABLET ],
        'U51GT-S'                                   => [ 'Cube', 'U51GT S', DeviceType::TABLET ],
        'U51GT-W'                                   => [ 'Cube', 'U51GT W', DeviceType::TABLET ],
        'U51GT C4'                                  => [ 'Cube', 'U51GT C4', DeviceType::TABLET ],
        'U51GT-C4'                                  => [ 'Cube', 'U51GT C4', DeviceType::TABLET ],
        'U51GT-C4B'                                 => [ 'Cube', 'U51GT C4B', DeviceType::TABLET ],
        'U51GT-C4BD'                                => [ 'Cube', 'U51GT C4BD', DeviceType::TABLET ],
        'U51GT-C8'                                  => [ 'Cube', 'U51GT C8', DeviceType::TABLET ],
        'U51GT-C8P'                                 => [ 'Cube', 'U51GT C8S', DeviceType::TABLET ],
        'U51GT-C8S'                                 => [ 'Cube', 'U51GT C8S', DeviceType::TABLET ],
        'U51GT-4G'                                  => [ 'Cube', 'U51GT 4G', DeviceType::TABLET ],
        'U55GT'                                     => [ 'Cube', 'U55GT', DeviceType::TABLET ],
        'U55GT C8'                                  => [ 'Cube', 'U55GT C8', DeviceType::TABLET ],
        'U55GT S'                                   => [ 'Cube', 'U55GT S', DeviceType::TABLET ],
        'U59GT-C4'                                  => [ 'Cube', 'U59GT C4', DeviceType::TABLET ],
        'U65GT'                                     => [ 'Cube', 'U65GT', DeviceType::TABLET ],
    ],

    'CUBE!!' => [
        'CUBE Q7PRO'                                => [ 'Cube', 'Q7 Pro', DeviceType::TABLET ],
        'CUBE Q7PRO J'                              => [ 'Cube', 'Q7 Pro', DeviceType::TABLET ],
        'CUBE TALK7X'                               => [ 'Cube', 'Talk 7X', DeviceType::TABLET ],
        'CUBE TALK7X C4'                            => [ 'Cube', 'Talk 7X C4', DeviceType::TABLET ],
    ],

    'LT[0-9]{4,4}!!' => [
        'LT7033'                                    => [ 'Curtis', 'Klu LT7033', DeviceType::TABLET ],
        'LT7035-F'                                  => [ 'Curtis', 'Klu LT7035-F', DeviceType::TABLET ],
        'LT7035-J'                                  => [ 'Curtis', 'Klu LT7035-J', DeviceType::TABLET ],
        'LT7035-L'                                  => [ 'Curtis', 'Klu LT7035-L', DeviceType::TABLET ],
        'LT7052'                                    => [ 'Curtis', 'Klu LT7052', DeviceType::TABLET ],
        'LT8088'                                    => [ 'Curtis', 'Klu LT8088', DeviceType::TABLET ],
    ],

    'Cydle M7!'                                 => [ 'Cydle', 'M7 MultiPAD', DeviceType::TABLET ],
    'EVDO1000'                                  => [ 'Cyrus', 'EVDO 1000' ],
    'GloryG1000'                                => [ 'Cyrus', 'Glory G1000' ],
    'TVPAD Slim K3409'                          => [ 'Cyrus', 'TVPad Slim K3409', DeviceType::TABLET ],

    'D2-[0-9]{3,3}!!' => [
        'D2-711'                                    => [ 'D2pad', 'D2-711', DeviceType::TABLET ],
        'D2-712'                                    => [ 'D2pad', 'D2-712', DeviceType::TABLET ],
        'D2-721'                                    => [ 'D2pad', 'D2-721', DeviceType::TABLET ],
        'D2-721G'                                   => [ 'D2pad', 'D2-721G', DeviceType::TABLET ],
        'D2-727'                                    => [ 'D2pad', 'D2-727', DeviceType::TABLET ],
        'D2-751G'                                   => [ 'D2pad', 'D2-751G', DeviceType::TABLET ],
        'D2-911'                                    => [ 'D2pad', 'D2-911', DeviceType::TABLET ],
        'D2-912'                                    => [ 'D2pad', 'D2-912', DeviceType::TABLET ],
        'D2-927G'                                   => [ 'D2pad', 'D2-927G', DeviceType::TABLET ],
        'D2-961G'                                   => [ 'D2pad', 'D2-961G', DeviceType::TABLET ],
    ],

    'Dakele A380'                               => [ 'Dakele', 'A380' ],
    'DAKELE MC001'                              => [ 'Dakele', 'MC001' ],
    'MC002'                                     => [ 'Dakele', 'MC002' ],

    'Dslide!!' => [
        'Dslide 700'                                => [ 'Danew', 'DSlide 700', DeviceType::TABLET ],
        'Dslide 702'                                => [ 'Danew', 'DSlide 702', DeviceType::TABLET ],
        'Dslide 703R'                               => [ 'Danew', 'DSlide 703R', DeviceType::TABLET ],
        'Dslide 704'                                => [ 'Danew', 'DSlide 704', DeviceType::TABLET ],
        'Dslide 706'                                => [ 'Danew', 'DSlide 706', DeviceType::TABLET ],
        'Dslide 707'                                => [ 'Danew', 'DSlide 707', DeviceType::TABLET ],
        'Dslide800'                                 => [ 'Danew', 'DSlide 800', DeviceType::TABLET ],
        'Dslide801'                                 => [ 'Danew', 'DSlide 801', DeviceType::TABLET ],
        'Dslide900'                                 => [ 'Danew', 'DSlide 900', DeviceType::TABLET ],
        'Dslide 971'                                => [ 'Danew', 'DSlide 971', DeviceType::TABLET ],
        'Dslide971DC'                               => [ 'Danew', 'DSlide 971', DeviceType::TABLET ],
        'DSlide972'                                 => [ 'Danew', 'DSlide 972', DeviceType::TABLET ],
        'DSlide973'                                 => [ 'Danew', 'DSlide 973', DeviceType::TABLET ],
        'Dslide973QC'                               => [ 'Danew', 'DSlide 973', DeviceType::TABLET ],
        'DSlide 1013'                               => [ 'Danew', 'DSlide 1013', DeviceType::TABLET ],
    ],

    'Genius!!' => [
        'Genius TAB GIII'                           => [ 'Dany', 'Genius Tab G3', DeviceType::TABLET ],
        'GENIUS-G4'                                 => [ 'Dany', 'Genius Tab G4', DeviceType::TABLET ],
        'Genius TAB G4'                             => [ 'Dany', 'Genius Tab G4', DeviceType::TABLET ],
        'Genius Tab Q4'                             => [ 'Dany', 'Genius Tab Q4', DeviceType::TABLET ],
    ],

    'EvoPAD!!' => [
        'EvoPAD A7000'                              => [ 'Dark', 'EvoPad A7000', DeviceType::TABLET ],
        'EvoPad-R1020'                              => [ 'Dark', 'EvoPad R1020', DeviceType::TABLET ],
        'EVOPad R8000'                              => [ 'Dark', 'EvoPad R8000', DeviceType::TABLET ],
        'EVOPad R8020'                              => [ 'Dark', 'EvoPad R8020', DeviceType::TABLET ],
        'EVOPad R9720'                              => [ 'Dark', 'EvoPad R9720', DeviceType::TABLET ],
        'EvoPAD R9740'                              => [ 'Dark', 'EvoPad R9740', DeviceType::TABLET ],
        'EvoPAD-R9722'                              => [ 'Dark', 'EvoPad R9722', DeviceType::TABLET ],
        'Evopad R9730'                              => [ 'Dark', 'EvoPad R9730', DeviceType::TABLET ],
    ],

    'HB-100 DASAN'                              => [ 'Dasan', 'HB-100', DeviceType::TELEVISION ],
    'HB-100 DASAN Networks, Inc.'               => [ 'Dasan', 'HB-100', DeviceType::TELEVISION ],

    'Mini 3iG'                                  => [ 'Dell', 'Aero' ],
    'BizSmartPhone'                             => [ 'Dell', 'Biz SmartPhone' ],
    '001DL'                                     => [ 'Dell', 'STREAK 001DL', DeviceType::TABLET, 'carrier' => 'Softbank' ],
    '101DL'                                     => [ 'Dell', 'STREAK PRO 101DL', DeviceType::TABLET, 'carrier' => 'Softbank' ],
    'GS01'                                      => [ 'Dell', 'STREAK PRO GS01', DeviceType::TABLET, 'carrier' => 'EMOBILE' ],
    'streak7'                                   => [ 'Dell', 'Streak 7', DeviceType::TABLET ],
    'CS-1A13'                                   => [ 'Dell', 'Wyse Cloud Connect', DeviceType::TELEVISION ],

    'Dell!!' => [
        'Dell Aero'                                 => [ 'Dell', 'Aero' ],
        'Dell Grappa'                               => [ 'Dell', 'Aero' ],
        'Dell M01M'                                 => [ 'Dell', 'Streak', DeviceType::TABLET ],
        'Dell Mini 5'                               => [ 'Dell', 'Streak', DeviceType::TABLET ],
        'Dell Streak mini5'                         => [ 'Dell', 'Streak', DeviceType::TABLET ],
        'Dell Streak'                               => [ 'Dell', 'Streak', DeviceType::TABLET ],
        'Dell V04B'                                 => [ 'Dell', 'Streak Pro', DeviceType::TABLET ],
        'Dell Streak Pro'                           => [ 'Dell', 'Streak Pro', DeviceType::TABLET ],
        'Dell Streak Pro (D43)'                     => [ 'Dell', 'Streak Pro', DeviceType::TABLET ],
        'Dell Streak Pro (GS01)'                    => [ 'Dell', 'Streak Pro', DeviceType::TABLET ],
        'Dell Streak Pro D43'                       => [ 'Dell', 'Streak Pro', DeviceType::TABLET ],
        'Dell Streak 7'                             => [ 'Dell', 'Streak 7', DeviceType::TABLET ],
        'Dell Streak 10 Pro'                        => [ 'Dell', 'Streak 10 Pro', DeviceType::TABLET ],
        'Dell streak 10 Pro 940'                    => [ 'Dell', 'Streak 10 Pro', DeviceType::TABLET ],
        'Dell Venue'                                => [ 'Dell', 'Venue' ],
    ],

    'Venue!!' => [
        'venue 7'                                   => [ 'Dell', 'Venue 7', DeviceType::TABLET ],
        'Venue 7 3730'                              => [ 'Dell', 'Venue 7', DeviceType::TABLET ],
        'Venue 7 3736'                              => [ 'Dell', 'Venue 7', DeviceType::TABLET ],
        'Venue 7 3740'                              => [ 'Dell', 'Venue 7', DeviceType::TABLET ],
        'Venue7 3740'                               => [ 'Dell', 'Venue 7', DeviceType::TABLET ],
        'Venue7 3740 LTE'                           => [ 'Dell', 'Venue 7', DeviceType::TABLET ],
        'Venue7 3740 HSPA+'                         => [ 'Dell', 'Venue 7', DeviceType::TABLET ],
        'Venue 3740 LTE'                            => [ 'Dell', 'Venue 7', DeviceType::TABLET ],
        'Venue 7 3741'                              => [ 'Dell', 'Venue 7', DeviceType::TABLET ],
        'Venue 7 HSPA+'                             => [ 'Dell', 'Venue 7', DeviceType::TABLET ],
        'Venue 7 WWAN'                              => [ 'Dell', 'Venue 7', DeviceType::TABLET ],
        'Venue 8 HSPA+'                             => [ 'Dell', 'Venue 8', DeviceType::TABLET ],
        'Venue 8 WiFi'                              => [ 'Dell', 'Venue 8', DeviceType::TABLET ],
        'Venue 8 3830'                              => [ 'Dell', 'Venue 8', DeviceType::TABLET ],
        'Venue 8 3840'                              => [ 'Dell', 'Venue 8', DeviceType::TABLET ],
        'Venue8 3840'                               => [ 'Dell', 'Venue 8', DeviceType::TABLET ],
        'Venue8 3840 LTE'                           => [ 'Dell', 'Venue 8', DeviceType::TABLET ],
        'Venue 8 7040'                              => [ 'Dell', 'Venue 8', DeviceType::TABLET ],
        'Venue 8 7840'                              => [ 'Dell', 'Venue 8', DeviceType::TABLET ],
        'Venue 8 7840 LTE'                          => [ 'Dell', 'Venue 8', DeviceType::TABLET ],
        'Venue 10 5050'                             => [ 'Dell', 'Venue 10', DeviceType::TABLET ],
        'Venue 10 7040'                             => [ 'Dell', 'Venue 10', DeviceType::TABLET ],
        'Venue 11 Pro 7130 MS'                      => [ 'Dell', 'Venue 11', DeviceType::TABLET ],
    ],

    'XCD 28'                                    => [ 'Dell', 'XCD28' ],
    'Dell XCD35'                                => [ 'Dell', 'XCD35' ],
    'XCD35'                                     => [ 'Dell', 'XCD35' ],
    'DEM752HCF'                                 => [ 'Denver', 'TAC-7018', DeviceType::TABLET ],

    '(DENVER-)?TA[CD]-[0-9]{4,5}!!' => [
        'TAC-7028'                                  => [ 'Denver', 'TAC-7028', DeviceType::TABLET ],
        'TAC-10011'                                 => [ 'Denver', 'TAC-10011', DeviceType::TABLET ],
        'TAC-10031'                                 => [ 'Denver', 'TAC-10031', DeviceType::TABLET ],
        'TAC-10031 MK2'                             => [ 'Denver', 'TAC-10031', DeviceType::TABLET ],
        'TAC-70031'                                 => [ 'Denver', 'TAC-70031', DeviceType::TABLET ],
        'TAC-70041'                                 => [ 'Denver', 'TAC-70041', DeviceType::TABLET ],
        'TAC-70051'                                 => [ 'Denver', 'TAC-70051', DeviceType::TABLET ],
        'TAC-70061'                                 => [ 'Denver', 'TAC-70061', DeviceType::TABLET ],
        'TAC-70072'                                 => [ 'Denver', 'TAC-70072', DeviceType::TABLET ],
        'TAC-70072kc'                               => [ 'Denver', 'TAC-70072', DeviceType::TABLET ],
        'TAD-70092 PINK MK2 PO8318'                 => [ 'Denver', 'TAC-70092', DeviceType::TABLET ],
        'TAD-70102G'                                => [ 'Denver', 'TAC-70102G', DeviceType::TABLET ],
        'TAC-70111'                                 => [ 'Denver', 'TAC-70111', DeviceType::TABLET ],
        'TAC-70111 PO8195'                          => [ 'Denver', 'TAC-70111', DeviceType::TABLET ],
        'TAC-70111 PO8241'                          => [ 'Denver', 'TAC-70111', DeviceType::TABLET ],
        'TAC-70111 PO8242'                          => [ 'Denver', 'TAC-70111', DeviceType::TABLET ],
        'TAD-70111 PO8306'                          => [ 'Denver', 'TAC-70111', DeviceType::TABLET ],
        'TAD-70111MK2'                              => [ 'Denver', 'TAC-70111', DeviceType::TABLET ],
        'TAD-70112 PO8278'                          => [ 'Denver', 'TAC-70112', DeviceType::TABLET ],
        'TAD-70112KC PO8347'                        => [ 'Denver', 'TAC-70112', DeviceType::TABLET ],
        'TAD-70132 PO8575'                          => [ 'Denver', 'TAC-70132', DeviceType::TABLET ],
        'TAC-80011'                                 => [ 'Denver', 'TAC-80011', DeviceType::TABLET ],
        'TAC-90011'                                 => [ 'Denver', 'TAC-90011', DeviceType::TABLET ],
        'TAC-90012'                                 => [ 'Denver', 'TAC-90012', DeviceType::TABLET ],
        'TAC-97032'                                 => [ 'Denver', 'TAC-97032', DeviceType::TABLET ],
        'TAC-97052'                                 => [ 'Denver', 'TAC-97052', DeviceType::TABLET ],
        'TAD-10021'                                 => [ 'Denver', 'TAD-10021', DeviceType::TABLET ],
        'TAD-10023'                                 => [ 'Denver', 'TAD-10023', DeviceType::TABLET ],
        'TAD-10062'                                 => [ 'Denver', 'TAD-10062', DeviceType::TABLET ],
        'TAD-10063 MK2 PO8311'                      => [ 'Denver', 'TAD-10063', DeviceType::TABLET ],
        'DENVER-TAD-10082'                          => [ 'Denver', 'TAD-10082', DeviceType::TABLET ],
        'TAD-70091'                                 => [ 'Denver', 'TAD-70091', DeviceType::TABLET ],
        'TAD-70092'                                 => [ 'Denver', 'TAD-70092', DeviceType::TABLET ],
        'TAD-70092 BLACK MK2 PO8341'                => [ 'Denver', 'TAD-70092', DeviceType::TABLET ],
        'TAD-70111PO8275'                           => [ 'Denver', 'TAD-70111', DeviceType::TABLET ],
        'TAD-70111 PO8307'                          => [ 'Denver', 'TAD-70111', DeviceType::TABLET ],
        'TAD-70112PO8197'                           => [ 'Denver', 'TAD-70112', DeviceType::TABLET ],
        'TAD-70112 PO8292'                          => [ 'Denver', 'TAD-70112', DeviceType::TABLET ],
        'TAD-70112KC PO8360'                        => [ 'Denver', 'TAD-70112', DeviceType::TABLET ],
        'TAD-90021'                                 => [ 'Denver', 'TAD-90021', DeviceType::TABLET ],
        'TAD-90022'                                 => [ 'Denver', 'TAD-90022', DeviceType::TABLET ],
        'TAD-97052'                                 => [ 'Denver', 'TAD-97052', DeviceType::TABLET ],
        'TAD-97052mk2'                              => [ 'Denver', 'TAD-97052', DeviceType::TABLET ],
        'TAD-97072G'                                => [ 'Denver', 'TAD-97072', DeviceType::TABLET ],
        'TAD-97082!'                                => [ 'Denver', 'TAD-97082', DeviceType::TABLET ],
    ],

    'deovo V5'                                  => [ 'deovo', 'V5' ],

    'DESAY!!' => [
        'DESAY TS808'                               => [ 'Desay', 'TS808' ],
        'DESAY TS908'                               => [ 'Desay', 'TS908' ],
        'DESAY TS928'                               => [ 'Desay', 'TS928' ],
        'DESAY TS1008'                              => [ 'Desay', 'TS1008' ],
        'DESAY TS1018'                              => [ 'Desay', 'TS1018' ],
        'DESAY TS1218'                              => [ 'Desay', 'TS1218' ],
    ],

    'iP977'                                     => [ 'Dex', 'iP977', DeviceType::TABLET ],

    'Dialog!!' => [
        'Dialog i35'                                => [ 'Dialog', 'i35' ],
        'Dialog i43'                                => [ 'Dialog', 'i43' ],
        'Dialog i43(ICS)'                           => [ 'Dialog', 'i43' ],
        'Dialog K35'                                => [ 'Dialog', 'K35' ],
        'Dialog K45'                                => [ 'Dialog', 'K45' ],
        'Dialog K235'                               => [ 'Dialog', 'K235' ],
        'Dialog Q143L'                              => [ 'Dialog', 'Q143L' ],
        'Dialog Q178'                               => [ 'Dialog', 'Q178' ],
        'Dialog Q243'                               => [ 'Dialog', 'Q243' ],
    ],

    'DIT[0-9]{4,6}!!' => [
        'DIT1010'                                   => [ 'Difrnce', 'DIT1010', DeviceType::TABLET ],
        'DIT7000'                                   => [ 'Difrnce', 'DIT7000', DeviceType::TABLET ],
        'DIT7070'                                   => [ 'Difrnce', 'DIT7070', DeviceType::TABLET ],
        'DIT8070'                                   => [ 'Difrnce', 'DIT8070', DeviceType::TABLET ],
        'DIT9720'                                   => [ 'Difrnce', 'DIT9720', DeviceType::TABLET ],
        'DIT101201'                                 => [ 'Difrnce', 'DIT101201', DeviceType::TABLET ],
        'DIT102201'                                 => [ 'Difrnce', 'DIT102201', DeviceType::TABLET ],
        'DIT102202'                                 => [ 'Difrnce', 'DIT102202', DeviceType::TABLET ],
        'DIT701101'                                 => [ 'Difrnce', 'DIT701101', DeviceType::TABLET ],
        'DIT702101'                                 => [ 'Difrnce', 'DIT702101', DeviceType::TABLET ],
        'DIT902101'                                 => [ 'Difrnce', 'DIT902101', DeviceType::TABLET ],
        'DIT902102'                                 => [ 'Difrnce', 'DIT902102', DeviceType::TABLET ],
        'DIT902103'                                 => [ 'Difrnce', 'DIT902103', DeviceType::TABLET ],
    ],

    'NID 7010'                                  => [ 'Difrnce', 'DIT702201', DeviceType::TABLET ],
    'DIGICELDL1plus'                            => [ 'Digicel', 'DL1 Plus' ],
    'DIGICEL DL800'                             => [ 'Digicel', 'DL800' ],
    'DIGICEL DL1000'                            => [ 'Digicel', 'DL1000' ],

    '(Digma )?iD[jmnsx][DQ]?[0-9]*!!' => [
        'Digma iDj7!'                               => [ 'Digma', 'iDj7', DeviceType::TABLET ],
        'iDj7n'                                     => [ 'Digma', 'iDj7n', DeviceType::TABLET ],
        'Digma iDm7'                                => [ 'Digma', 'iDm7', DeviceType::TABLET ],
        'Digma iDn7'                                => [ 'Digma', 'iDn7', DeviceType::TABLET ],
        'ids7'                                      => [ 'Digma', 'iDs7', DeviceType::TABLET ],
        'ids10'                                     => [ 'Digma', 'iDs10', DeviceType::TABLET ],
        'DIGMA iDs10!'                              => [ 'Digma', 'iDs10', DeviceType::TABLET ],
        'iDx5'                                      => [ 'Digma', 'iDx5' ],
        'iDx7'                                      => [ 'Digma', 'iDx7', DeviceType::TABLET ],
        'iDx7 Type2 4'                              => [ 'Digma', 'iDx7', DeviceType::TABLET ],
        'iDx10!'                                    => [ 'Digma', 'iDx10', DeviceType::TABLET ],
        'iDnD7'                                     => [ 'Digma', 'iDnD7', DeviceType::TABLET ],
        'DIGMA IDSD'                                => [ 'Digma', 'iDsD', DeviceType::TABLET ],
        'DIGMA iDsD7!'                              => [ 'Digma', 'iDsD7', DeviceType::TABLET ],
        'DIGMA iDsD8!'                              => [ 'Digma', 'iDsD8', DeviceType::TABLET ],
        'DIGMA iDsD10!'                             => [ 'Digma', 'iDsD10', DeviceType::TABLET ],
        'iDxD4'                                     => [ 'Digma', 'iDxD4' ],
        'IDXD8'                                     => [ 'Digma', 'iDxD8', DeviceType::TABLET ],
        'iDxD8 3G'                                  => [ 'Digma', 'iDxD8', DeviceType::TABLET ],
        'iDxD7 3G'                                  => [ 'Digma', 'iDxD7', DeviceType::TABLET ],
        'IDXD10'                                    => [ 'Digma', 'iDxD10', DeviceType::TABLET ],
        'iDxD10 3G'                                 => [ 'Digma', 'iDxD10', DeviceType::TABLET ],
        'iDxQ5'                                     => [ 'Digma', 'iDxQ5' ],
    ],

    'DISTAB9000R'                               => [ 'Disgo', 'Distab 9000R', DeviceType::TABLET ],
    'DishTV Smartvu A2020'                      => [ 'DishTV', 'SmartVU-mini', DeviceType::TELEVISION ],

    'DM0[0-9]{2,2}(K|SH)!!' => [
        'DM009SH'                                   => [ 'Sharp', 'DM009SH', 'carrier' => 'Disney Mobile' ],
        'DM010SH'                                   => [ 'Sharp', 'DM010SH', 'carrier' => 'Disney Mobile' ],
        'DM011SH'                                   => [ 'Sharp', 'DM011SH', 'carrier' => 'Disney Mobile' ],
        'DM012SH'                                   => [ 'Sharp', 'DM012SH', 'carrier' => 'Disney Mobile' ],
        'DM013SH'                                   => [ 'Sharp', 'DM013SH', 'carrier' => 'Disney Mobile' ],
        'DM014SH'                                   => [ 'Sharp', 'DM014SH', 'carrier' => 'Disney Mobile' ],
        'DM015K'                                    => [ 'Kyocera', 'DM015K', 'carrier' => 'Disney Mobile' ],
        'DM016SH'                                   => [ 'Sharp', 'DM016SH', 'carrier' => 'Disney Mobile' ],
    ],

    'DJC Touchtab3'                             => [ 'DJC', 'Touchtab3', DeviceType::TABLET ],
    'DJC Touchtab4'                             => [ 'DJC', 'Touchtab4', DeviceType::TABLET ],
    'AirBook TTJ702'                            => [ 'DNS', 'Airbook TTJ702', DeviceType::TABLET ],
    'DNS Airbook TYT701'                        => [ 'DNS', 'Airbook TYT701', DeviceType::TABLET ],

    '(DNS )?(Airtab )?(E|ES|M|MA|MC|MF|MW|P|PC|PF)[0-9]{2,4}!!' => [
        'DNS Airtab E73'                            => [ 'DNS', 'AirTab E73', DeviceType::TABLET ],
        'AirTab ES70'                               => [ 'DNS', 'AirTab ES70', DeviceType::TABLET ],
        'AirTab M81g'                               => [ 'DNS', 'AirTab M81g', DeviceType::TABLET ],
        'AirTab M81w'                               => [ 'DNS', 'AirTab M81w', DeviceType::TABLET ],
        'M83w'                                      => [ 'DNS', 'AirTab M83w', DeviceType::TABLET ],
        'M84g'                                      => [ 'DNS', 'AirTab M84g', DeviceType::TABLET ],
        'M100qw'                                    => [ 'DNS', 'AirTab M100qw', DeviceType::TABLET ],
        'M101g'                                     => [ 'DNS', 'AirTab M101g', DeviceType::TABLET ],
        'AirTab M104G'                              => [ 'DNS', 'AirTab M104g', DeviceType::TABLET ],
        'AirTab m971g'                              => [ 'DNS', 'AirTab M971g', DeviceType::TABLET ],
        'M971w'                                     => [ 'DNS', 'AirTab M971w', DeviceType::TABLET ],
        'M972g'                                     => [ 'DNS', 'AirTab M972g', DeviceType::TABLET ],
        'M972w'                                     => [ 'DNS', 'AirTab M972w', DeviceType::TABLET ],
        'DNS AirTab M974w'                          => [ 'DNS', 'AirTab M974w', DeviceType::TABLET ],
        'AirTab M975w'                              => [ 'DNS', 'AirTab M975w', DeviceType::TABLET ],
        'DNS M975W'                                 => [ 'DNS', 'AirTab M975W', DeviceType::TABLET ],
        'AirTab MA7001'                             => [ 'DNS', 'AirTab MA7001', DeviceType::TABLET ],
        'AirTab MC1011'                             => [ 'DNS', 'AirTab MC1011', DeviceType::TABLET ],
        'DNS AirTab MF1011'                         => [ 'DNS', 'AirTab MF1011', DeviceType::TABLET ],
        'AirTab MW1011'                             => [ 'DNS', 'AirTab MW1011', DeviceType::TABLET ],
        'AirTab MW7851'                             => [ 'DNS', 'AirTab MW7851', DeviceType::TABLET ],
        'AirTab P70qw'                              => [ 'DNS', 'AirTab P70qw', DeviceType::TABLET ],
        'AirTab P71g'                               => [ 'DNS', 'AirTab P71g', DeviceType::TABLET ],
        'DNS AirTab P71g'                           => [ 'DNS', 'AirTab P71g', DeviceType::TABLET ],
        'AirTab P83'                                => [ 'DNS', 'AirTab P83', DeviceType::TABLET ],
        'DNS AirTab P101w'                          => [ 'DNS', 'AirTab P101w', DeviceType::TABLET ],
        'AirTab P970g'                              => [ 'DNS', 'AirTab P970g', DeviceType::TABLET ],
        'AirTab P970w'                              => [ 'DNS', 'AirTab P970w', DeviceType::TABLET ],
        'AirTab PC9701'                             => [ 'DNS', 'AirTab PC9701', DeviceType::TABLET ],
        'DNS AirTab PF7001'                         => [ 'DNS', 'AirTab PF7001', DeviceType::TABLET ],
    ],

    'DNS S!!' => [
        'DNS S3501'                                 => [ 'DNS', 'S3501' ],
        'DNS s4003'                                 => [ 'DNS', 'S4003' ],
        'DNS S4006'                                 => [ 'DNS', 'S4006' ],
        'DNS S4008'                                 => [ 'DNS', 'S4008' ],
        'DNS S4502'                                 => [ 'DNS', 'S4502' ],
        'DNS S4502M'                                => [ 'DNS', 'S4502M' ],
        'DNS S4507'                                 => [ 'DNS', 'S4507' ],
        'DNS S4508'                                 => [ 'DNS', 'S4508' ],
        'DNS S4705'                                 => [ 'DNS', 'S4705' ],
        'DNS S5005'                                 => [ 'DNS', 'S5005' ],
        'DNS S5008'                                 => [ 'DNS', 'S5008' ],
        'DNS S5701'                                 => [ 'DNS', 'S5701' ],
    ],

    'DNS4502M'                                  => [ 'DNS', 'S4502M' ],
    'S4503Q'                                    => [ 'DNS', 'S4503Q' ],
    'S4505M'                                    => [ 'DNS', 'S4505M' ],

    'DPS Dream 7'                               => [ 'DPS', 'Dream 7', DeviceType::TABLET ],
    'DPS Dream 9'                               => [ 'DPS', 'Dream 9', DeviceType::TABLET ],
    'domod G20'                                 => [ 'Domod', 'G20' ],
    'Collo DG100'                               => [ 'Doogee', 'Collo DG100' ],
    'Collo 2 DG120'                             => [ 'Doogee', 'Collo 2 DG120' ],
    'DOOGEE-TITANS-DG150'                       => [ 'Doogee', 'Titans DG150' ],
    'VOYAGER DG300'                             => [ 'Doogee', 'Voyager DG300' ],
    'VOYAGER2 DG310'                            => [ 'Doogee', 'Voyager 2 DG310' ],
    'MINT-DG330'                                => [ 'Doogee', 'Mint DG330' ],
    'Discovery DG500'                           => [ 'Doogee', 'Discovery DG500' ],
    'Discovery2-DG500C'                         => [ 'Doogee', 'Discovery 2 DG500C' ],
    'TURBO DG2014'                              => [ 'Doogee', 'Turbo DG2014' ],

    'DOOV!!' => [
        'DOOV C1'                                   => [ 'DOOV', 'C1' ],
        'DOOV C7'                                   => [ 'DOOV', 'C7' ],
        'DOOV D2'                                   => [ 'DOOV', 'D2' ],
        'DOOV D3'                                   => [ 'DOOV', 'D3' ],
        'DOOV D5'                                   => [ 'DOOV', 'D5' ],
        'DOOV D7'                                   => [ 'DOOV', 'D7' ],
        'DOOV D8'                                   => [ 'DOOV', 'D8' ],
        'DOOV D9'                                   => [ 'DOOV', 'D9' ],
        'DOOV D10'                                  => [ 'DOOV', 'D10' ],
        'DOOV D30'                                  => [ 'DOOV', 'D30' ],
        'DOOV-DOOV D300'                            => [ 'DOOV', 'D300' ],
        'DOOV D300'                                 => [ 'DOOV', 'D300' ],
        'DOOV D350'                                 => [ 'DOOV', 'D350' ],
        'DOOV D360'                                 => [ 'DOOV', 'D360' ],
        'DOOV D500'                                 => [ 'DOOV', 'D500' ],
        'DOOV D700'                                 => [ 'DOOV', 'D700' ],
        'DOOV D708'                                 => [ 'DOOV', 'D708' ],
        'DOOV D710'                                 => [ 'DOOV', 'D710' ],
        'DOOV D720'                                 => [ 'DOOV', 'D720' ],
        'DOOV D770'                                 => [ 'DOOV', 'D770' ],
        'DOOV D800'                                 => [ 'DOOV', 'D800' ],
        'DOOV D910T'                                => [ 'DOOV', 'D910T' ],
        'DOOV D920'                                 => [ 'DOOV', 'D920' ],
        'DOOV L1'                                   => [ 'DOOV', 'L1' ],
        'DOOV L1M'                                  => [ 'DOOV', 'L1M' ],
        'DOOV L3'                                   => [ 'DOOV', 'L3' ],
        'DOOV L5'                                   => [ 'DOOV', 'L5' ],
        'DOOV L5Pro'                                => [ 'DOOV', 'L5 Pro' ],
        'DOOV S1'                                   => [ 'DOOV', 'S1' ],
        'DOOV S2'                                   => [ 'DOOV', 'S2' ],
        'DOOV S2y'                                  => [ 'DOOV', 'S2y' ],
        'DOOV S3'                                   => [ 'DOOV', 'S3' ],
        'DOOV S5'                                   => [ 'DOOV', 'S5' ],
        'DOOV T20L'                                 => [ 'DOOV', 'T20L' ],
        'DOOV T35'                                  => [ 'DOOV', 'T35' ],
        'DOOV T60'                                  => [ 'DOOV', 'T60' ],
        'DOOV T90'                                  => [ 'DOOV', 'T90' ],
    ],

    'Doro Liberto!!' => [
        'Doro Liberto 810'                          => [ 'Doro', 'Liberto 810' ],
        'Doro Liberto 820'                          => [ 'Doro', 'Liberto 820' ],
        'Doro Liberto 820 Mini'                     => [ 'Doro', 'Liberto 820 Mini' ],
        'Doro Liberto 822'                          => [ 'Doro', 'Liberto 822' ],
        'Doro Liberto 825'                          => [ 'Doro', 'Liberto 825' ],
    ],

    'Doro 8030'                                 => [ 'Doro', 'Liberto 822' ],
    'Doro 824'                                  => [ 'Doro', 'Liberto 824' ],
    '825 T-Mobile'                              => [ 'Doro', 'Liberto 825' ],
    'M975'                                      => [ 'Double Power', 'M975', DeviceType::TABLET ],
    'TD-1010'                                   => [ 'Double Power', 'TD-1010', DeviceType::TABLET ],
    'Tablet-P27'                                => [ 'DracoTek', 'P27 Tablet', DeviceType::TABLET ],
    'dyno 7.80'                                 => [ 'Dyno', '7.80', DeviceType::TABLET ],
    'dyno 7.85'                                 => [ 'Dyno', '7.85', DeviceType::TABLET ],
    'ACM3066-8'                                 => [ 'MY|eebo', 'Color Tablet', DeviceType::TABLET ],

    '(E-Boda|Eruption|Essential|Supreme|Storm|Revo)!!' => [
        'Eruption V200'                             => [ 'E-Boda', 'Eruption V200', DeviceType::TABLET ],
        'E-Boda Essential A150'                     => [ 'E-Boda', 'Essential A150', DeviceType::TABLET ],
        'Essential A330'                            => [ 'E-Boda', 'Essential A330', DeviceType::TABLET ],
        'E-Boda IMPRESSPE3D E1'                     => [ 'E-Boda', 'Impresspeed E1', DeviceType::TABLET ],
        'E-Boda IMPRESSPEED E 250DC'                => [ 'E-Boda', 'Impresspeed E250', DeviceType::TABLET ],
        'E-Boda Impresspeed E300'                   => [ 'E-Boda', 'Impresspeed E300', DeviceType::TABLET ],
        'E-Boda Supreme X80 Dual Core'              => [ 'E-Boda', 'Supreme X80', DeviceType::TABLET ],
        'E-Boda Supreme Dual Core X190'             => [ 'E-Boda', 'Supreme X190', DeviceType::TABLET ],
        'SUPREME IPS Dual Core X200'                => [ 'E-Boda', 'Supreme X200', DeviceType::TABLET ],
        'E-Boda Supreme X400 Quad Core'             => [ 'E-Boda', 'Supreme X400', DeviceType::TABLET ],
        'E-Boda Supreme XL200IPS'                   => [ 'E-Boda', 'Supreme XL200', DeviceType::TABLET ],
        'E-Boda Supreme XL400QC'                    => [ 'E-Boda', 'Supreme XL400', DeviceType::TABLET ],
        'E-Boda Rainbow V47'                        => [ 'E-Boda', 'Rainbow V47' ],
        'Revo R80'                                  => [ 'E-Boda', 'Revo R80' ],
        'E-Boda Storm V50'                          => [ 'E-Boda', 'Storm V50' ],
        'Storm V100'                                => [ 'E-Boda', 'Storm V100' ],
        'Storm X450'                                => [ 'E-Boda', 'Storm X450' ],
    ],

    'Etel!!' => [
        'Etel i3'                                   => [ 'E-tel', 'Curiosity i3' ],
        'Etel i4'                                   => [ 'E-tel', 'Curiosity i4' ],
        'Etel i6'                                   => [ 'E-tel', 'Curiosity i6' ],
        'Etel i8'                                   => [ 'E-tel', 'Curiosity i8' ],
    ],

    'EasyPhone EP5'                             => [ 'Easypix', 'EasyPhone EP5' ],
    'EasyPad 971'                               => [ 'Easypix', 'EasyPad 971', DeviceType::TABLET ],

    'EBEN!!' => [
        'EBEN A3'                                   => [ 'EBEN', 'A3', DeviceType::TABLET ],
        'EBEN S1'                                   => [ 'EBEN', 'S1', DeviceType::TABLET ],
        'EBEN T6'                                   => [ 'EBEN', 'T6', DeviceType::TABLET ],
        'EBEN T7'                                   => [ 'EBEN', 'T7', DeviceType::TABLET ],
        'EBEN T8'                                   => [ 'EBEN', 'T8', DeviceType::TABLET ],
    ],

    'EBEST!!' => [
        'EBEST A35'                                 => [ 'EBEST', 'A35' ],
        'EBEST F5'                                  => [ 'EBEST', 'F5' ],
        'EBEST N4'                                  => [ 'EBEST', 'N4' ],
        'EBEST T5'                                  => [ 'EBEST', 'T5' ],
        'EBEST T7'                                  => [ 'EBEST', 'T7' ],
        'EBEST U1'                                  => [ 'EBEST', 'U1' ],
        'EBEST V5'                                  => [ 'EBEST', 'V5' ],
        'EBEST V6'                                  => [ 'EBEST', 'V6' ],
        'EBEST V7'                                  => [ 'EBEST', 'V7' ],
        'EBEST V8'                                  => [ 'EBEST', 'V8' ],
        'EBEST W16A'                                => [ 'EBEST', 'W16A' ],
        'EBEST W18'                                 => [ 'EBEST', 'W18' ],
        'EBEST W66'                                 => [ 'EBEST', 'W66' ],
        'EBEST W66A'                                => [ 'EBEST', 'W66A' ],
        'EBEST W70'                                 => [ 'EBEST', 'W70' ],
        'EBEST Z5'                                  => [ 'EBEST', 'Z5' ],
        'EBEST Z7'                                  => [ 'EBEST', 'Z7' ],
    ],

    'TA10CA3'                                   => [ 'ECS', 'TA10CA3', DeviceType::TABLET ],
    'TM105'                                     => [ 'ECS', 'TM105', DeviceType::TABLET ],
    'TM105A'                                    => [ 'ECS', 'TM105A', DeviceType::TABLET ],
    'TR10CS1'                                   => [ 'ECS', 'TR10CS1', DeviceType::TABLET ],

    'Elephone!!' => [
        'Elephone G1'                               => [ 'Elephone', 'G1' ],
        'Elephone G2'                               => [ 'Elephone', 'G2' ],
        'Elephone G3'                               => [ 'Elephone', 'G3' ],
        'Elephone G4'                               => [ 'Elephone', 'G4' ],
        'Elephone G5'                               => [ 'Elephone', 'G5' ],
        'Elephone G6'                               => [ 'Elephone', 'G6' ],
        'Elephone G7'                               => [ 'Elephone', 'G7' ],
        'Elephone G9'                               => [ 'Elephone', 'G9' ],
        'Elephone P6'                               => [ 'Elephone', 'P6' ],
        'Elephone P8'                               => [ 'Elephone', 'P8' ],
        'Elephone P8 Pro'                           => [ 'Elephone', 'P8 Pro' ],
        'Elephone P10'                              => [ 'Elephone', 'P10' ],
        'Elephone-P10C'                             => [ 'Elephone', 'P10C' ],
        'Elephone-P2000'                            => [ 'Elephone', 'P2000' ],
        'Elephone P2000'                            => [ 'Elephone', 'P2000' ],
        'Elephone-P2000C'                           => [ 'Elephone', 'P2000C' ],
        'Elephone P3000!'                           => [ 'Elephone', 'P3000' ],
        'Elephone P4000!'                           => [ 'Elephone', 'P4000' ],
        'Elephone P5000!'                           => [ 'Elephone', 'P5000' ],
        'Elephone P6000!'                           => [ 'Elephone', 'P6000' ],
        'Elephone P7000'                            => [ 'Elephone', 'P7000' ],
        'Elephone P8000!'                           => [ 'Elephone', 'P8000' ],
        'Elephone S2'                               => [ 'Elephone', 'S2' ],
        'Elephone S2 Plus'                          => [ 'Elephone', 'S2 Plus' ],
    ],

    'D709'                                      => [ 'Empire Electronix', 'Tablet D709', DeviceType::TABLET ],
    'C8660'                                     => [ 'Enspire', 'C8660' ],
    'edgejr'                                    => [ 'EnTourage', 'Pocket eDGe', DeviceType::TABLET ],
    'l97D'                                      => [ 'EPad', 'l97D', DeviceType::TABLET ],
    'A1001T'                                    => [ 'Elijah', 'A1001T', DeviceType::TABLET ],
    'ELIYA S1'                                  => [ 'Eliya', 'S1' ],

    'epade!!' => [
        'epade A3'                                  => [ 'epade', 'A3' ],
        'epade A7'                                  => [ 'epade', 'A7' ],
        'epade A45'                                 => [ 'epade', 'A45' ],
        'epade A300'                                => [ 'epade', 'A300' ],
        'epade A360S'                               => [ 'epade', 'A360S' ],
        'epade A718'                                => [ 'epade', 'A718' ],
        'epade N01'                                 => [ 'epade', 'N01' ],
        'epade Q3'                                  => [ 'epade', 'Q3' ],
        'epade S300'                                => [ 'epade', 'S300' ],
        'EPADE S3'                                  => [ 'epade', 'S3' ],
        'epade S5'                                  => [ 'epade', 'S5' ],
        'epade S7'                                  => [ 'epade', 'S7' ],
        'epade V05'                                 => [ 'epade', 'V05' ],
    ],

    'equiso.smart.tv.pro'                       => [ 'Equiso', 'SmartTV', DeviceType::TELEVISION ],

    'PH-1'                                      => [ 'Essential', 'Phone' ],

    'ST7001'                                    => [ 'Essentiel B', 'Black Diamond' ],
    'ST8000'                                    => [ 'Essentiel B', 'Smart\'Tab 8000', DeviceType::TABLET ],
    'ST9001'                                    => [ 'Essentiel B', 'Smart\'Tab 9001', DeviceType::TABLET ],

    'eSTAR!!' => [
        'eSTAR BEAUTY HD Quad core'                 => [ 'eSTAR', 'Beauty HD', DeviceType::TABLET ],
        'eSTAR CRYSTAL'                             => [ 'eSTAR', 'Crystal', DeviceType::TABLET ],
        'eSTAR Easy'                                => [ 'eSTAR', 'Easy', DeviceType::TABLET ],
        'eSTAR GO!'                                 => [ 'eSTAR', 'Go!', DeviceType::TABLET ],
        'eSTAR GRAND'                               => [ 'eSTAR', 'Grand', DeviceType::TABLET ],
        'eSTAR GRAND HD'                            => [ 'eSTAR', 'Grand HD', DeviceType::TABLET ],
        'eSTAR GRAND HD Quad 3G'                    => [ 'eSTAR', 'Grand HD 3G', DeviceType::TABLET ],
        'eSTAR GRAND HD Intel Quad core 3G'         => [ 'eSTAR', 'Grand HD 3G', DeviceType::TABLET ],
        'eSTAR Gemini'                              => [ 'eSTAR', 'Gemini', DeviceType::TABLET ],
        'eSTAR MINI'                                => [ 'eSTAR', 'Mini', DeviceType::TABLET ],
        'eSTAR MINI 3G'                             => [ 'eSTAR', 'Mini 3G', DeviceType::TABLET ],
        'eSTAR Zoom Quad'                           => [ 'eSTAR', 'Zoom', DeviceType::TABLET ],
        'eSTAR ZOOM HD Duo'                         => [ 'eSTAR', 'Zoom HD', DeviceType::TABLET ],
        'eSTAR Zoom HD Quad'                        => [ 'eSTAR', 'Zoom HD', DeviceType::TABLET ],
    ],

    'MID1018'                                   => [ 'eSTAR', 'MID1018', DeviceType::TABLET ],
    'MID1028'                                   => [ 'eSTAR', 'MID1028', DeviceType::TABLET ],
    'M4301'                                     => [ 'Eston', 'MID M4301', 'media' ],

    '(EVAS )?EVERCOSS[- ]A!!' => [
        'EVERCOSS A5'                               => [ 'EVERCOSS', 'A5' ],
        'EVERCOSS A5A*'                             => [ 'EVERCOSS', 'A5A' ],
        'EVERCOSS A5C'                              => [ 'EVERCOSS', 'A5C' ],
        'EVERCOSS A5K'                              => [ 'EVERCOSS', 'A5K' ],
        'EVERCOSS A5P'                              => [ 'EVERCOSS', 'A5P' ],
        'EVERCOSS A5P*'                             => [ 'EVERCOSS', 'A5P' ],
        'EVERCOSS A5V'                              => [ 'EVERCOSS', 'A5V' ],
        'EVERCOSS A5Z'                              => [ 'EVERCOSS', 'A5Z' ],
        'EVERCOSS A7A'                              => [ 'EVERCOSS', 'A7A' ],
        'EVERCOSS A7A*'                             => [ 'EVERCOSS', 'A7A' ],
        'EVERCOSS A7B'                              => [ 'EVERCOSS', 'A7B' ],
        'EVERCOSS A7F'                              => [ 'EVERCOSS', 'A7F' ],
        'EVERCOSS A7K'                              => [ 'EVERCOSS', 'A7K' ],
        'EVERCOSS A7L'                              => [ 'EVERCOSS', 'A7L' ],
        'EVERCOSS A7N'                              => [ 'EVERCOSS', 'A7N' ],
        'EVERCOSS A7R'                              => [ 'EVERCOSS', 'A7R' ],
        'EVERCOSS A7S'                              => [ 'EVERCOSS', 'A7S' ],
        'EVAS evercoss-a7s'                         => [ 'EVERCOSS', 'A7S' ],
        'EVERCOSS A7T'                              => [ 'EVERCOSS', 'A7T' ],
        'EVERCOSS A7T*'                             => [ 'EVERCOSS', 'A7T' ],
        'EVERCOSS A7V'                              => [ 'EVERCOSS', 'A7V' ],
        'EVERCOSS A7V+'                             => [ 'EVERCOSS', 'A7V' ],
        'EVERCOSS A7Z'                              => [ 'EVERCOSS', 'A7Z' ],
        'EVERCOSS A28A'                             => [ 'EVERCOSS', 'A28A' ],
        'EVERCOSS A28M'                             => [ 'EVERCOSS', 'A28M' ],
        'EVERCOSS A53B'                             => [ 'EVERCOSS', 'A53B' ],
        'EVERCOSS A54'                              => [ 'EVERCOSS', 'A54' ],
        'EVERCOSS A65'                              => [ 'EVERCOSS', 'A65' ],
        'Evercoss A66A'                             => [ 'EVERCOSS', 'A66A' ],
        'EVERCOSS A66S'                             => [ 'EVERCOSS', 'A66S' ],
        'EVERCOSS A66V'                             => [ 'EVERCOSS', 'A66V' ],
        'EVERCOSS A74A'                             => [ 'EVERCOSS', 'A74A' ],
        'EVERCOSS A74C'                             => [ 'EVERCOSS', 'A74C' ],
        'EVERCOSS A74D'                             => [ 'EVERCOSS', 'A74D' ],
        'EVERCOSS-A75L'                             => [ 'EVERCOSS', 'A75L' ],
        'EVERCOSS A75W'                             => [ 'EVERCOSS', 'A75W' ],
        'EVERCOSS A80A'                             => [ 'EVERCOSS', 'A80A' ],
        'EVERCOSS A200'                             => [ 'EVERCOSS', 'A200' ],
        'EVERCOSS AT1A'                             => [ 'EVERCOSS', 'AT1A', DeviceType::TABLET ],
        'EVERCOSS AT1A*'                            => [ 'EVERCOSS', 'AT1A', DeviceType::TABLET ],
        'EVERCOSS AT1G'                             => [ 'EVERCOSS', 'AT1G', DeviceType::TABLET ],
        'EVERCOSS AT8D'                             => [ 'EVERCOSS', 'AT8D', DeviceType::TABLET ],
    ],

    'AT1A*'                                     => [ 'EVERCOSS', 'AT1A', DeviceType::TABLET ],
    'AT1C'                                      => [ 'EVERCOSS', 'AT1C', DeviceType::TABLET ],
    'AT1C*'                                     => [ 'EVERCOSS', 'AT1C', DeviceType::TABLET ],
    'AT1D'                                      => [ 'EVERCOSS', 'AT1D', DeviceType::TABLET ],
    'AT1G*'                                     => [ 'EVERCOSS', 'AT1G', DeviceType::TABLET ],
    'AT7E'                                      => [ 'EVERCOSS', 'AT7E', DeviceType::TABLET ],

    'EVERPAD SC-710'                            => [ 'Everest', 'Everpad SC-710', DeviceType::TABLET ],

    'Ever!!' => [
        'EverClassic'                               => [ 'Evertek', 'EverClassic' ],
        'EverFancy D40'                             => [ 'Evertek', 'EverFancy D40' ],
        'EverGlory'                                 => [ 'Evertek', 'EverGlory' ],
        'EverMagic'                                 => [ 'Evertek', 'EverMagic' ],
        'EverMellow D45'                            => [ 'Evertek', 'EverMellow D45' ],
        'EverMellow D50'                            => [ 'Evertek', 'EverMellow D50' ],
        'EverMiracle'                               => [ 'Evertek', 'EverMiracle' ],
        'EverMiracle mini'                          => [ 'Evertek', 'EverMiracle Mini' ],
        'EverMiracle Nano'                          => [ 'Evertek', 'EverMiracle Nano' ],
        'EverShine'                                 => [ 'Evertek', 'EverShine' ],
        'EverTrendy'                                => [ 'Evertek', 'EverTrendy' ],
    ],

    'E70[0-9]{2,2}H[DG]!!' => [
        'E7020HD'                                   => [ 'Evertek', 'Everpad E7020HD', DeviceType::TABLET ],
        'E7050HD'                                   => [ 'Evertek', 'Everpad E7050HD', DeviceType::TABLET ],
    ],

    'E80[0-9]{2,2}H[DG]!!' => [
        'E8050HG'                                   => [ 'Evertek', 'Everpad E8050HG', DeviceType::TABLET ],
        'E8051HD'                                   => [ 'Evertek', 'Everpad E8051HD', DeviceType::TABLET ],
    ],

    'P10AN'                                     => [ 'Exper', 'Easypad P10AN', DeviceType::TABLET ],

    '(Explay|X-tremer|ActiveD|Informer|Surfer)!!' => [
        'Explay A320'                               => [ 'Explay', 'A320' ],
        'Explay Advance'                            => [ 'Explay', 'Advance' ],
        'Explay Dream'                              => [ 'Explay', 'Dream' ],
        'Explay Fresh'                              => [ 'Explay', 'Fresh' ],
        'Explay Indigo'                             => [ 'Explay', 'Indigo' ],
        'Explay Infinity'                           => [ 'Explay', 'Infinity' ],
        'Explay A350'                               => [ 'Explay', 'Star' ],
        'Explay Star'                               => [ 'Explay', 'Star' ],
        'Explay Vega'                               => [ 'Explay', 'Vega' ],
        'X-tremer'                                  => [ 'Explay', 'X-tremer' ],
        'Explay X-tremer'                           => [ 'Explay', 'X-tremer' ],
        'ActiveD 7.4 3G'                            => [ 'Explay', 'ActiveD 7.4 3G', DeviceType::TABLET ],
        'Explay Informer 701'                       => [ 'Explay', 'Informer 701', DeviceType::TABLET ],
        'Informer 701'                              => [ 'Explay', 'Informer 701', DeviceType::TABLET ],
        'Explay Informer 702'                       => [ 'Explay', 'Informer 702', DeviceType::TABLET ],
        'Informer-702'                              => [ 'Explay', 'Informer 702', DeviceType::TABLET ],
        'Explay Informer 703'                       => [ 'Explay', 'Informer 703', DeviceType::TABLET ],
        'Informer 703'                              => [ 'Explay', 'Informer 703', DeviceType::TABLET ],
        'Informer 704'                              => [ 'Explay', 'Informer 704', DeviceType::TABLET ],
        'Informer 705'                              => [ 'Explay', 'Informer 705', DeviceType::TABLET ],
        'Explay Informer 705'                       => [ 'Explay', 'Informer 705', DeviceType::TABLET ],
        'Informer-801'                              => [ 'Explay', 'Informer 801', DeviceType::TABLET ],
        'Explay Informer 801'                       => [ 'Explay', 'Informer 801', DeviceType::TABLET ],
        'Explay Informer 804'                       => [ 'Explay', 'Informer 804', DeviceType::TABLET ],
        'informer 901'                              => [ 'Explay', 'Informer 901', DeviceType::TABLET ],
        'informer 920'                              => [ 'Explay', 'Informer 920', DeviceType::TABLET ],
        'informer 921'                              => [ 'Explay', 'Informer 921', DeviceType::TABLET ],
        'Explay Surfer 7.02'                        => [ 'Explay', 'Surfer 7.02', DeviceType::TABLET ],
        'Surfer7.03'                                => [ 'Explay', 'Surfer 7.03', DeviceType::TABLET ],
        'Surfer 7.04'                               => [ 'Explay', 'Surfer 7.04', DeviceType::TABLET ],
        'Surfer 7.31 3G'                            => [ 'Explay', 'Surfer 7.31 3G', DeviceType::TABLET ],
        'Surfer 7.32 3G'                            => [ 'Explay', 'Surfer 7.32 3G', DeviceType::TABLET ],
        'Surfer 7.34'                               => [ 'Explay', 'Surfer 7.34', DeviceType::TABLET ],
        'Explay surfer 8.01'                        => [ 'Explay', 'Surfer 8.01', DeviceType::TABLET ],
        'Surfer 8 02'                               => [ 'Explay', 'Surfer 8.02', DeviceType::TABLET ],
        'Surfer 8.02'                               => [ 'Explay', 'Surfer 8.02', DeviceType::TABLET ],
        'Surfer 8.31 3G'                            => [ 'Explay', 'Surfer 8.31 3G', DeviceType::TABLET ],
        'Surfer 10.11'                              => [ 'Explay', 'Surfer 10.11', DeviceType::TABLET ],
    ],

    'Smart!!' => [
        'Smart402'                                  => [ 'Fareastone', 'Smart 402' ],
        'Smart 403'                                 => [ 'Fareastone', 'Smart 403' ],
        'Smart501'                                  => [ 'Fareastone', 'Smart 501' ],
        'Smart 502'                                 => [ 'Fareastone', 'Smart 502' ],
        'Smart503'                                  => [ 'Fareastone', 'Smart 503' ],
        'Smart 505'                                 => [ 'Fareastone', 'Smart 505' ],
        'Smart 701'                                 => [ 'Fareastone', 'Smart 701', DeviceType::TABLET ],
    ],

    'FP1'                                       => [ 'Fairphone', '1' ],
    'FP1U'                                      => [ 'Fairphone', '1' ],
    'FP2'                                       => [ 'Fairphone', '2' ],

    'FDT!!' => [
        'FDT C838'                                  => [ 'FDT', 'C838' ],
        'FDT E5'                                    => [ 'FDT', 'E5' ],
        'FDT E6'                                    => [ 'FDT', 'E6' ],
        'FDT E829'                                  => [ 'FDT', 'E829' ],
        'FDT E969'                                  => [ 'FDT', 'E969' ],
        'FDT G18'                                   => [ 'FDT', 'G18' ],
        'FDT G505'                                  => [ 'FDT', 'G505' ],
    ],

    'GT-[HN][0-9]{4,4}!!' => [
        'GT-H9001'                                  => [ 'Feiteng', 'GT-H9001' ],
        'GT-H9500'                                  => [ 'Feiteng', 'GT-H9500' ],
        'GT-N9300'                                  => [ 'Feiteng', 'GT-N9300' ],
    ],

    'GT-9000'                                   => [ 'Feiteng', 'H5W' ],
    '9300'                                      => [ 'Feiteng', 'GT-N9300' ],

    'iOCEAN!!' => [
        'iOCEAN X7'                                 => [ 'FHD', 'iOCEAN X7' ],
        'iOCEAN X7 HD'                              => [ 'FHD', 'iOCEAN X7 HD' ],
        'iOCEAN X7S'                                => [ 'FHD', 'iOCEAN X7S' ],
        'iOCEAN X7T'                                => [ 'FHD', 'iOCEAN X7T' ],
        'iOCEAN X8'                                 => [ 'FHD', 'iOCEAN X8' ],
    ],

    'FIH-!!' => [
        'FIH-F0X'                                   => [ 'FIH', 'F0X' ],
        'FIH-FBO'                                   => [ 'FIH', 'FBO' ],
        'FIH-FD1'                                   => [ 'FIH', 'FD1' ],
        'FIH-VKY'                                   => [ 'FIH', 'VKY' ],
    ],

    'Vibo-A688'                                 => [ 'FIH', 'Vibo A688' ],

    'XT[0-9]{3,3}!!' => [
        'XT712'                                     => [ 'Flipkart', 'Digiflip Pro XT712', DeviceType::TABLET ],
        'XT801'                                     => [ 'Flipkart', 'Digiflip Pro XT801', DeviceType::TABLET ],
        'XT811'                                     => [ 'Flipkart', 'Digiflip Pro XT811', DeviceType::TABLET ],
    ],

    'Fly F[0-9]{2,3}!!' => [
        'Fly F40'                                   => [ 'Fly', 'F40' ],
        'FLY F45s'                                  => [ 'Fly', 'F45s' ],
        'FLY F50s'                                  => [ 'Fly', 'F50s' ],
        'Fly F350'                                  => [ 'Fly', 'F350' ],
    ],

    'F50Q'                                      => [ 'Fly', 'F50Q' ],
    'FS403'                                     => [ 'Fly', 'FS403 Cumulus 1' ],
    'FS407'                                     => [ 'Fly', 'FS407 Stratus 6' ],
    'Fly Phoenix 2'                             => [ 'Fly', 'IQ4410i Phoenix 2' ],
    'Fly Ego Art 2'                             => [ 'Fly', 'IQ455 Ego Art 2' ],

    '(Fly )?IQ ?[0-9]{3,4}!!' => [
        '(Fly )?IQ4413!'                            => [ 'Fly', 'IQ4413 Evo Chic 3' ],
        '(Fly )?IQ4417!'                            => [ 'Fly', 'IQ4417 Quad Era Energy 3' ],
        '(Fly )?IQ4516!'                            => [ 'Fly', 'IQ4516 Tornado Slim' ],
        '(Fly )?IQ230!'                             => [ 'Fly', 'IQ230 Compact' ],
        '(Fly )?IQ235!'                             => [ 'Fly', 'IQ235 Uno' ],
        '(Fly )?IQ236!'                             => [ 'Fly', 'IQ236 Victory' ],
        '(Fly )?IQ237!'                             => [ 'Fly', 'IQ237 Dynamic' ],
        '(Fly )?IQ238!'                             => [ 'Fly', 'IQ238 Jazz' ],
        '(Fly )?IQ239!'                             => [ 'Fly', 'IQ239 Era Nano 2' ],
        '(Fly )?IQ240!'                             => [ 'Fly', 'IQ240 Whizz' ],
        '(Fly )?IQ245!'                             => [ 'Fly', 'IQ245 Wizard' ],
        '(Fly )?IQ245 Plus!'                        => [ 'Fly', 'IQ245 Wizard Plus' ],
        '(Fly )?IQ246!'                             => [ 'Fly', 'IQ246 Power' ],
        '(Fly )?IQ250!'                             => [ 'Fly', 'IQ250 Swift' ],
        '(Fly )?IQ255!'                             => [ 'Fly', 'IQ255 Pride' ],
        '(Fly )?IQ256!'                             => [ 'Fly', 'IQ256 Vogue' ],
        '(Fly )?IQ260!'                             => [ 'Fly', 'IQ260 BlackBird' ],
        '(Fly )?IQ270!'                             => [ 'Fly', 'IQ270 Firebird' ],
        '(Fly )?IQ275!'                             => [ 'Fly', 'IQ275 Marathon' ],
        '(Fly )?IQ280!'                             => [ 'Fly', 'IQ280 Tech' ],
        '(Fly )?IQ285!'                             => [ 'Fly', 'IQ285 Turbo' ],
        '(Fly )?IQ310!'                             => [ 'Fly', 'IQ310 Panorama', DeviceType::TABLET ],
        '(Fly )?IQ320!'                             => [ 'Fly', 'IQ320', DeviceType::TABLET ],
        '(Fly )?IQ430!'                             => [ 'Fly', 'IQ430 Evoke' ],
        'IQ 430'                                    => [ 'Fly', 'IQ430 Evoke' ],
        '(Fly )?IQ431!'                             => [ 'Fly', 'IQ431 Glory' ],
        '(Fly )?IQ432!'                             => [ 'Fly', 'IQ432 Era Nano 1' ],
        '(Fly )?IQ434!'                             => [ 'Fly', 'IQ434 Era Nano 5' ],
        '(Fly )?IQ436!'                             => [ 'Fly', 'IQ434 Era Nano 9' ],
        '(Fly )?IQ440!'                             => [ 'Fly', 'IQ440 Energie' ],
        '(Fly )?IQ441!'                             => [ 'Fly', 'IQ441 Radiance' ],
        '(Fly )?IQ442!'                             => [ 'Fly', 'IQ442 Miracle' ],
        '(Fly )?IQ443!'                             => [ 'Fly', 'IQ443 Trend' ],
        '(Fly )?IQ444!'                             => [ 'Fly', 'IQ444 Diamond' ],
        '(Fly )?IQ445!'                             => [ 'Fly', 'IQ445 Genius' ],
        '(Fly )?IQ446!'                             => [ 'Fly', 'IQ446 Magic' ],
        'IQ 446'                                    => [ 'Fly', 'IQ446 Magic' ],
        '(Fly )?IQ447!'                             => [ 'Fly', 'IQ447 Era Life 1' ],
        '(Fly )?IQ448!'                             => [ 'Fly', 'IQ448 Chic' ],
        '(Fly )?IQ449!'                             => [ 'Fly', 'IQ449 Pronto' ],
        '(Fly )?IQ450!'                             => [ 'Fly', 'IQ450 Horizon' ],
        '(Fly )?IQ451!'                             => [ 'Fly', 'IQ451 Vista' ],
        'IQ 451'                                    => [ 'Fly', 'IQ451 Vista' ],
        '(Fly )?IQ452!'                             => [ 'Fly', 'IQ452 Ego Vision 1' ],
        '(Fly )?IQ453!'                             => [ 'Fly', 'IQ453 Luminor' ],
        '(Fly )?IQ454!'                             => [ 'Fly', 'IQ454 Evo Tech 1' ],
        '(Fly )?IQ455!'                             => [ 'Fly', 'IQ455 Ego Art 2' ],
        'IQ456'                                     => [ 'Fly', 'IQ456 Era Life 2' ],
        '(Fly )?IQ458!'                             => [ 'Fly', 'IQ458 Evo Tech 2' ],
        '(Fly )?IQ459!'                             => [ 'Fly', 'IQ459 Evo Chic 2' ],
        'IQ588'                                     => [ 'Fly', 'IQ588 Nimbuzz' ],
        'IQ4601'                                    => [ 'Fly', 'IQ4601 Era Style 2' ],
        'IQ4602 Quad'                               => [ 'Fly', 'IQ4602 Thunder' ],
    ],

    'Flylife!!' => [
        'Flylife Connect 7 3G'                      => [ 'Fly', 'Flylife Connect 7 3G', DeviceType::TABLET ],
        'Flylife Connect 7 3G 2'                    => [ 'Fly', 'Flylife Connect 7 3G 2', DeviceType::TABLET ],
        'Flylife Connect 7.85 3G 2'                 => [ 'Fly', 'Flylife Connect 7.85 3G 2', DeviceType::TABLET ],
        'Flylife Connect 7.85 3G Slim'              => [ 'Fly', 'Flylife Connect 7.85 3G Slim', DeviceType::TABLET ],
        'Flylife Connect 10.1 3G'                   => [ 'Fly', 'Flylife Connect 10.1 3G', DeviceType::TABLET ],
        'Flylife Web 7'                             => [ 'Fly', 'Flylife Web 7', DeviceType::TABLET ],
        'Flylife Web 7.85 Slim'                     => [ 'Fly', 'Flylife Web 7.85 Slim', DeviceType::TABLET ],
    ],

    'Fly Flylife Web 7.85 Slim'                 => [ 'Fly', 'Flylife Web 7.85 Slim', DeviceType::TABLET ],
    'F600'                                      => [ 'Flying', 'F600' ],
    'BC1003'                                    => [ 'Flytouch', 'BC1003', DeviceType::TABLET ],

    '(tablet )?fnac!!' => [
        'fnac 3.5'                                  => [ 'Fnac', 'Smartphone 3.5' ],
        'fnac 4'                                    => [ 'Fnac', 'Smartphone 4' ],
        'fnac 4.5'                                  => [ 'Fnac', 'Smartphone 4.5' ],
        'fnac 5'                                    => [ 'Fnac', 'Smartphone 5' ],
        'fnac 5 HD'                                 => [ 'Fnac', 'Smartphone 5 HD' ],
        'fnac 5.7'                                  => [ 'Fnac', 'Smartphone 5.7' ],
        'tablet Fnac 7'                             => [ 'Fnac', 'Tablet 7', DeviceType::TABLET ],
        'tablet Fnac 8'                             => [ 'Fnac', 'Tablet 8', DeviceType::TABLET ],
        'fnac 8 3G v2'                              => [ 'Fnac', 'Tablet 8 3G v2', DeviceType::TABLET ],
        'tablet Fnac 10'                            => [ 'Fnac', 'Tablet 10', DeviceType::TABLET ],
        'tablet Fnac 10 3G'                         => [ 'Fnac', 'Tablet 10 3G', DeviceType::TABLET ],
        'fnac 10 v2'                                => [ 'Fnac', 'Tablet 10 v2', DeviceType::TABLET ],
        'fnac 3.0 8'                                => [ 'Fnac', 'Tablet 3.0 8', DeviceType::TABLET ],
        'fnac 3.0 10 Plus'                          => [ 'Fnac', 'Tablet 3.0 10', DeviceType::TABLET ],
    ],

    'ifive!!' => [
        'ifive 2'                                   => [ 'FNF', 'iFive 2', DeviceType::TABLET ],
        'ifive2S'                                   => [ 'FNF', 'iFive 2S', DeviceType::TABLET ],
        'ifive3'                                    => [ 'FNF', 'iFive 3', DeviceType::TABLET ],
        'ifive MX'                                  => [ 'FNF', 'iFive MX', DeviceType::TABLET ],
        'ifive MX100'                               => [ 'FNF', 'iFive MX100', DeviceType::TABLET ],
        'ifive X'                                   => [ 'FNF', 'iFive X', DeviceType::TABLET ],
        'ifiveX2'                                   => [ 'FNF', 'iFive X2', DeviceType::TABLET ],
        'ifive X2'                                  => [ 'FNF', 'iFive X2', DeviceType::TABLET ],
        'ifiveX3'                                   => [ 'FNF', 'iFive X3', DeviceType::TABLET ],
        'ifive MINI 2'                              => [ 'FNF', 'iFive Mini 2', DeviceType::TABLET ],
        'IfiveMini3'                                => [ 'FNF', 'iFive Mini 3', DeviceType::TABLET ],
        'ifive mini 3GS'                            => [ 'FNF', 'iFive Mini 3GS', DeviceType::TABLET ],
        'IfiveMini4'                                => [ 'FNF', 'iFive Mini 4', DeviceType::TABLET ],
    ],

    'Freelander I20'                            => [ 'Freelander', 'i20' ],
    'PD10-DYD'                                  => [ 'Freelander', 'PD10', DeviceType::TABLET ],

    'SXZ-PD!!' => [
        'SXZ-PD10'                                  => [ 'Freelander', 'PD10', DeviceType::TABLET ],
        'SXZ-PDX0-01'                               => [ 'Freelander', 'PD20', DeviceType::TABLET ],
        'SXZ-PDX0-03'                               => [ 'Freelander', 'PD90', DeviceType::TABLET ],
        'SXZ-PDX-03'                                => [ 'Freelander', 'PD90', DeviceType::TABLET ],
    ],

    'NABI!!' => [
        'NABI-A'                                    => [ 'Fuhu', 'nabi Kids tablet', DeviceType::TABLET ],
        'NABIJR-NV5A'                               => [ 'Fuhu', 'nabi Jr.', DeviceType::TABLET ],
        'NABIJR-NV5B'                               => [ 'Fuhu', 'nabi Jr.', DeviceType::TABLET ],
        'NABI2-NV3D'                                => [ 'Fuhu', 'nabi 2', DeviceType::TABLET ],
        'NABI2-NV7A'                                => [ 'Fuhu', 'nabi 2', DeviceType::TABLET ],
        'NABI2-NV7A-D'                              => [ 'Fuhu', 'nabi 2', DeviceType::TABLET ],
        'NABI2-NV7A-IE'                             => [ 'Fuhu', 'nabi 2', DeviceType::TABLET ],
        'NABI2-NV7A-UK'                             => [ 'Fuhu', 'nabi 2', DeviceType::TABLET ],
        'NABI2-NV7A-3D'                             => [ 'Fuhu', 'nabi 2', DeviceType::TABLET ],
        'NABIXD-NV10A'                              => [ 'Fuhu', 'nabi XD', DeviceType::TABLET ],
        'NABIXD-NV10B'                              => [ 'Fuhu', 'nabi XD', DeviceType::TABLET ],
        'NABIXD-NV10C'                              => [ 'Fuhu', 'nabi XD', DeviceType::TABLET ],
    ],

    '[0-9]0[0-9]F!!' => [
        '101F'                                      => [ 'Fujitsu', 'ARROWS A 101F', 'carrier' => 'Softbank' ],
        '201F'                                      => [ 'Fujitsu', 'ARROWS A 201F', 'carrier' => 'Softbank' ],
        '202F'                                      => [ 'Fujitsu', 'ARROWS A 202F', 'carrier' => 'Softbank' ],
        '301F'                                      => [ 'Fujitsu', 'ARROWS A 301F', 'carrier' => 'Softbank' ],
    ],

    'ISW?[0-9]{2,2}F!!' => [
        'ISW11F'                                    => [ 'Fujitsu', 'ARROWS Z ISW11F', 'carrier' => 'au' ],
        'ISW13F'                                    => [ 'Fujitsu', 'ARROWS Z ISW13F', 'carrier' => 'au' ],
        'IS12F'                                     => [ 'Fujitsu', 'ARROWS ES IS12F', 'carrier' => 'au' ],
    ],

    'F-[0-9]{2,2}[A-Z]!!' => [
        'F-01D'                                     => [ 'Fujitsu', 'ARROWS Tab LTE F-01D', DeviceType::TABLET, 'carrier' => 'DoCoMo' ],
        'F-01F'                                     => [ 'Fujitsu', 'ARROWS NX F-01F', 'carrier' => 'DoCoMo' ],
        'F-01H'                                     => [ 'Fujitsu', 'arrows Fit F-01H', 'carrier' => 'DoCoMo' ],
        'F-01J'                                     => [ 'Fujitsu', 'arrows NX F-01J', 'carrier' => 'DoCoMo' ],
        'F-02E'                                     => [ 'Fujitsu', 'ARROWS X F-02E', 'carrier' => 'DoCoMo' ],
        'F-02F'                                     => [ 'Fujitsu', 'ARROWS Tab F-02F', DeviceType::TABLET, 'carrier' => 'DoCoMo' ],
        'F-02G'                                     => [ 'Fujitsu', 'ARROWS NX F-02G', 'carrier' => 'DoCoMo' ],
        'F-02H'                                     => [ 'Fujitsu', 'arrows NX F-02H', 'carrier' => 'DoCoMo' ],
        'F-03D'                                     => [ 'Fujitsu', 'ARROWS Kiss F-03D', 'carrier' => 'DoCoMo' ],
        'F-03E'                                     => [ 'Fujitsu', 'ARROWS Kiss with JILL STUART F-03E', 'carrier' => 'DoCoMo' ],
        'F-03F'                                     => [ 'Fujitsu', 'F-03F', 'carrier' => 'Disney Mobile' ],
        'F-03G'                                     => [ 'Fujitsu', 'ARROWS Tab F-03G', DeviceType::TABLET, 'carrier' => 'DoCoMo' ],
        'F-03H'                                     => [ 'Fujitsu', 'arrows SV F-03H', 'carrier' => 'DoCoMo' ],
        'F-04E'                                     => [ 'Fujitsu', 'ARROWS V F-04E', 'carrier' => 'DoCoMo' ],
        'F-04F'                                     => [ 'Fujitsu', 'Business Smartphone F-04F', 'carrier' => 'DoCoMo' ],
        'F-04G'                                     => [ 'Fujitsu', 'ARROWS NX F-04G', 'carrier' => 'DoCoMo' ],
        'F-04H'                                     => [ 'Fujitsu', 'ARROWS Tab F-04H', DeviceType::TABLET, 'carrier' => 'DoCoMo' ],
        'F-05D'                                     => [ 'Fujitsu', 'ARROWS X LTE F-05D', 'carrier' => 'DoCoMo' ],
        'F-05E'                                     => [ 'Fujitsu', 'ARROWS Tab F-05E', 'carrier' => 'DoCoMo' ],
        'F-05F'                                     => [ 'Fujitsu', 'ARROWS NX F-05F', 'carrier' => 'DoCoMo' ],
        'F-05G'                                     => [ 'Fujitsu', 'ARROWS F-05G', 'carrier' => 'DoCoMo' ],
        'F-05J'                                     => [ 'Fujitsu', 'ARROWS Be F-05J', 'carrier' => 'DoCoMo' ],
        'F-06E'                                     => [ 'Fujitsu', 'ARROWS NX F-06E', 'carrier' => 'DoCoMo' ],
        'F-06F'                                     => [ 'Fujitsu', 'Easy Smartphone 3 F-06F', 'carrier' => 'DoCoMo' ],
        'F-07D'                                     => [ 'Fujitsu', 'ARROWS μ F-07D', 'carrier' => 'DoCoMo' ],
        'F-07E'                                     => [ 'Fujitsu', 'F-07E', 'carrier' => 'Disney Mobile' ],
        'F-08D'                                     => [ 'Fujitsu', 'F-08D', 'carrier' => 'Disney Mobile' ],
        'F-08E'                                     => [ 'Fujitsu', 'Easy Smartphone 2 F-08E', 'carrier' => 'DoCoMo' ],
        'F-09D'                                     => [ 'Fujitsu', 'ANTEPRIMA F-09D', 'carrier' => 'DoCoMo' ],
        'F-09E'                                     => [ 'Fujitsu', 'Easy Smartphone Premium F-09E', 'carrier' => 'DoCoMo' ],
        'F-10D'                                     => [ 'Fujitsu', 'ARROWS X F-10D', 'carrier' => 'DoCoMo' ],
        'F-11D'                                     => [ 'Fujitsu', 'ARROWS Me F-11D', 'carrier' => 'DoCoMo' ],
        'F-12C'                                     => [ 'Fujitsu', 'GLOBE-TROTTER F-12C', 'carrier' => 'DoCoMo' ],
        'F-12D'                                     => [ 'Fujitsu', 'Easy Smartphone F-12D', 'carrier' => 'DoCoMo' ],
    ],

    'f12[a-z]{3,3}!!' => [
        'f12arc'                                    => [ 'Fujitsu', 'F12arc' ],
        'f12bob'                                    => [ 'Fujitsu', 'F12bob' ],
    ],

    'FJ[LT][0-9]{2,2}!!' => [
        'FJL21'                                     => [ 'Fujitsu', 'ARROWS ef FJL21', 'carrier' => 'au' ],
        'FJL22'                                     => [ 'Fujitsu', 'ARROWS Z FJL22', 'carrier' => 'au' ],
        'FJT21'                                     => [ 'Fujitsu', 'ARROWS Tab FJT21', DeviceType::TABLET, 'carrier' => 'au' ],
    ],

    'SZJ-JS101'                                 => [ 'Fujitsu', 'SZJ-JS101' ],

    'FHMD001'                                   => [ 'Fujitsu', 'FHMD001', DeviceType::HEADSET ],

    'F-074'                                     => [ 'Fujitsu', 'ARROWS μ F-07D', 'carrier' => 'DoCoMo' ],
    'FJJB091'                                   => [ 'Fujitsu', 'ARROWS μ F-07D', 'carrier' => 'DoCoMo' ],
    'EM01F'                                     => [ 'Fujitsu', 'ARROWS S EM01F', 'carrier' => 'EMOBILE' ],
    'M01'                                       => [ 'Fujitsu', 'ARROWS M01' ],
    'M02'                                       => [ 'Fujitsu', 'ARROWS M02' ],
    'RM02'                                      => [ 'Fujitsu', 'ARROWS M02' ],
    'M305'                                      => [ 'Fujitsu', 'ARROWS M305' ],
    'M01T'                                      => [ 'Fujitsu', 'ARROWS Tab M01T', DeviceType::TABLET ],
    'M555'                                      => [ 'Fujitsu', 'ARROWS Tab M555', DeviceType::TABLET ],
    'FAR7'                                      => [ 'Fujitsu', 'ARROWS Tab FAR70A', DeviceType::TABLET ],
    'FAR70B'                                    => [ 'Fujitsu', 'ARROWS Tab FAR70B', DeviceType::TABLET ],
    'FARTM933KZ'                                => [ 'Fujitsu', 'ARROWS Tab M504', DeviceType::TABLET ],

    'M350'                                      => [ 'Fujitsu', 'Stylistic M350', DeviceType::TABLET ],
    'M532'                                      => [ 'Fujitsu', 'Stylistic M532', DeviceType::TABLET ],
    'M363'                                      => [ 'Fujitsu', 'Stylistic M363', DeviceType::TABLET ],
    'M702'                                      => [ 'Fujitsu', 'Stylistic M702', DeviceType::TABLET ],
    'MH350'                                     => [ 'Fujitsu', 'Stylistic MH350', DeviceType::TABLET ],
    'S01'                                       => [ 'Fujitsu', 'Stylistic S01', DeviceType::TABLET ],

    'Patio100'                                  => [ 'Fujitsu', 'Patio100', DeviceType::POS ],
    'Patio100 3G'                               => [ 'Fujitsu', 'Patio100', DeviceType::POS ],

    'F&U ETB!!' => [
        'F&U ETB7506'                               => [ 'F&U', 'ETB7506', DeviceType::TABLET ],
        'F&U ETB7818'                               => [ 'F&U', 'ETB7818', DeviceType::TABLET ],
        'F&U ETB9543'                               => [ 'F&U', 'ETB9543', DeviceType::TABLET ],
        'F&U ETB9544'                               => [ 'F&U', 'ETB9544', DeviceType::TABLET ],
        'F&U ETB1063'                               => [ 'F&U', 'ETB1063', DeviceType::TABLET ],
        'F&U ETB1065'                               => [ 'F&U', 'ETB1065', DeviceType::TABLET ],
    ],

    'Asus A10'                                  => [ 'Garmin-Asus', 'Nuvifone A10' ],
    'Monterra'                                  => [ 'Garmin', 'Monterra', DeviceType::GPS ],

    'Garmin!!' => [
        'Garminfone'                                => [ 'Garmin-Asus', 'Garminfone' ],
        'Garmin-Asus A10'                           => [ 'Garmin-Asus', 'Nuvifone A10' ],
        'Garmin-Asus A50'                           => [ 'Garmin-Asus', 'Nuvifone A50' ],
    ],

    'nuvi!!' => [
        'nuvi 3590'                                 => [ 'Garmin', 'Nuvi 3590', DeviceType::GPS ],
        'nuvi 3592'                                 => [ 'Garmin', 'Nuvi 3592', DeviceType::GPS ],
        'nuvi 3595'                                 => [ 'Garmin', 'Nuvi 3595', DeviceType::GPS ],
        'nuvifone A50'                              => [ 'Garmin-Asus', 'Nuvifone A50' ],
    ],

    'G1-715'                                    => [ 'Gateway', 'G1-715', DeviceType::TABLET ],
    'G1-725'                                    => [ 'Gateway', 'G1-725', DeviceType::TABLET ],
    'N3-2200'                                   => [ 'Gateway', 'N3-2200', DeviceType::TABLET ],
    'TPA60W'                                    => [ 'Gateway', 'TPA60W', DeviceType::TABLET ],

    '(GP-|Geeksphone)!!' => [
        'GP-KEON'                                   => [ 'Geeksphone', 'Keon'],
        'GP-PEAK'                                   => [ 'Geeksphone', 'Peak'],
        'Geeksphone ZERO'                           => [ 'Geeksphone', 'ZERO'],
        'Geeksphone ONE'                            => [ 'Geeksphone', 'ONE'],
    ],

    'Gemei!!' => [
        'Gemei G2'                                  => [ 'Gemei', 'G2', DeviceType::TABLET ],
        'Gemei G3'                                  => [ 'Gemei', 'G3', DeviceType::TABLET ],
        'gemei G6'                                  => [ 'Gemei', 'G6', DeviceType::TABLET ],
        'Gemei G9'                                  => [ 'Gemei', 'G9', DeviceType::TABLET ],
        'gemei G9T'                                 => [ 'Gemei', 'G9T', DeviceType::TABLET ],
    ],

    'GEM[0-9]{4,4}!!' => [
        'GEM7008'                                   => [ 'Gemini', 'JoyTab GEM7008', DeviceType::TABLET ],
        'GEM7020'                                   => [ 'Gemini', 'JoyTab GEM7020', DeviceType::TABLET ],
        'GEM7032G-rev2'                             => [ 'Gemini', 'JoyTab GEM7032', DeviceType::TABLET ],
        'GEM10313BK'                                => [ 'Gemini', 'JoyTab GEM10313', DeviceType::TABLET ],
        'GEM10313S'                                 => [ 'Gemini', 'JoyTab GEM10313', DeviceType::TABLET ],
    ],

    'GP-431'                                    => [ 'Genesis', 'GP-431' ],

    'GT-[0-9]{4,4}!!' => [
        'GT-7200'                                   => [ 'Genesis', 'Tab GT-7200', DeviceType::TABLET ],
        'GT-7204'                                   => [ 'Genesis', 'Tab GT-7204', DeviceType::TABLET ],
        'GT-7204R'                                  => [ 'Genesis', 'Tab GT-7204R', DeviceType::TABLET ],
        'GT-7240'                                   => [ 'Genesis', 'Tab GT-7240', DeviceType::TABLET ],
        'GT-7240R'                                  => [ 'Genesis', 'Tab GT-7240R', DeviceType::TABLET ],
        'GT-7245'                                   => [ 'Genesis', 'Tab GT-7245', DeviceType::TABLET ],
        'GT-7326'                                   => [ 'Genesis', 'Tab GT-7326', DeviceType::TABLET ],
    ],

    'GP-720'                                    => [ 'Genius', 'GP-720', DeviceType::TABLET ],

    'G9'                                        => [ 'GFive', 'G9' ],

    'GFIVE!!' => [
        'GFIVE A5'                                  => [ 'GFive', 'A5' ],
        'GFIVE A800'                                => [ 'GFive', 'A800' ],
        'GFIVE Aurora(A79)'                         => [ 'GFive', 'Aurora' ],
        'GFIVE A68'                                 => [ 'GFive', 'Beam' ],
        'GFIVE Blade (F500)'                        => [ 'GFive', 'Blade' ],
        'GFIVE Bravo'                               => [ 'GFive', 'Bravo' ],
        'GFIVE Bravo(G95)'                          => [ 'GFive', 'Bravo' ],
        'GFIVE A77'                                 => [ 'GFive', 'Bravo' ],
        'GFIVE A57'                                 => [ 'GFive', 'Fanse' ],
        'GFIVE Glory'                               => [ 'GFive', 'Glory' ],
        'GFIVE Glory(A86)'                          => [ 'GFive', 'Glory' ],
        'GFIVE A86'                                 => [ 'GFive', 'Glory' ],
        'GFIVE Glory Bee(E670)'                     => [ 'GFive', 'Glory Bee' ],
        'GFIVE Prado'                               => [ 'GFive', 'Prado' ],
        'GFIVE President A97'                       => [ 'GFive', 'President' ],
        'GFIVE president(G6)'                       => [ 'GFive', 'President' ],
        'GFIVE President(G7)'                       => [ 'GFive', 'President' ],
        'GFIVE President(G9)'                       => [ 'GFive', 'President' ],
        'GFIVE G9'                                  => [ 'GFive', 'President' ],
        'GFIVE.G9'                                  => [ 'GFive', 'President' ],
        'GFIVE President G10 Fashion'               => [ 'GFive', 'President' ],
        'GFIVE Spark(A1)'                           => [ 'GFive', 'Spark' ],
        'GFIVE GPad701'                             => [ 'GFive', 'GPad 701', DeviceType::TABLET ],
    ],

    'GHIA!!' => [
        'GHIA 20218P'                               => [ 'Ghia', 'Any 20218P', DeviceType::TABLET ],
        'GHIA 27154P'                               => [ 'Ghia', 'Any 27154P', DeviceType::TABLET ],
        'GHIA V2.0 27158N'                          => [ 'Ghia', 'Any 27158N', DeviceType::TABLET ],
        'GHIA 27214P'                               => [ 'Ghia', 'Any 27214P', DeviceType::TABLET ],
        'GHIA 27258B'                               => [ 'Ghia', 'Any 27258B', DeviceType::TABLET ],
        'GHIA 27258N'                               => [ 'Ghia', 'Any 27258N', DeviceType::TABLET ],
        'GHIA V2.0 27258N'                          => [ 'Ghia', 'Any 27258N', DeviceType::TABLET ],
        'GHIA 29214P'                               => [ 'Ghia', 'Any 29214P', DeviceType::TABLET ],
    ],

    '(Gsmart|Gigabyte|Rio)!!' => [
        'GSmart Aku A1'                             => [ 'Gigabyte', 'GSmart Aku A1' ],
        'GSmart Alto A2'                            => [ 'Gigabyte', 'GSmart Alto A2' ],
        'GSmart Arty A3'                            => [ 'Gigabyte', 'GSmart Arty A3' ],
        'GSmart Akta A4'                            => [ 'Gigabyte', 'GSmart Akta A4' ],
        'GSmart Essence 4'                          => [ 'Gigabyte', 'GSmart Essence 4' ],
        'GSmart-G1305'                              => [ 'Gigabyte', 'GSmart G1305' ],
        'GSmart G1310'                              => [ 'Gigabyte', 'GSmart G1310' ],
        'GSmart G1315!'                             => [ 'Gigabyte', 'GSmart G1315' ],
        'GSmart G1317!'                             => [ 'Gigabyte', 'GSmart G1317' ],
        'GSmart G1342'                              => [ 'Gigabyte', 'GSmart G1342' ],
        'GSmart G1345'                              => [ 'Gigabyte', 'GSmart G1345' ],
        'GSmart G1355'                              => [ 'Gigabyte', 'GSmart G1355' ],
        'GSmart G1362'                              => [ 'Gigabyte', 'GSmart G1362' ],
        'GSmart GS202!'                             => [ 'Gigabyte', 'GSmart GS202' ],
        'GSmart Guru G1'                            => [ 'Gigabyte', 'GSmart Guru G1' ],
        'GSmart Maya M1'                            => [ 'Gigabyte', 'GSmart Maya M1' ],
        'GSmart Maya M1v2'                          => [ 'Gigabyte', 'GSmart Maya M1 v2' ],
        'GSmart Maya M1 v2'                         => [ 'Gigabyte', 'GSmart Maya M1 v2' ],
        'GSmart Mika M2'                            => [ 'Gigabyte', 'GSmart Mika M2' ],
        'GSmart Mika M3'                            => [ 'Gigabyte', 'GSmart Mika M3' ],
        'GSmart Rio R1'                             => [ 'Gigabyte', 'GSmart Rio R1' ],
        'GIGABYTE GSmart Rio R1'                    => [ 'Gigabyte', 'GSmart Rio R1' ],
        'Gigabyte RIO R1'                           => [ 'Gigabyte', 'GSmart Rio R1' ],
        'Rio R1'                                    => [ 'Gigabyte', 'GSmart Rio R1' ],
        'GSmart Roma R2'                            => [ 'Gigabyte', 'GSmart Roma R2' ],
        'GSmart Rey R3'                             => [ 'Gigabyte', 'GSmart Rey R3' ],
        'GSmart Saga S3'                            => [ 'Gigabyte', 'GSmart Saga S3' ],
        'GSmart Sierra S1'                          => [ 'Gigabyte', 'GSmart Sierra S1' ],
        'GSmart Tuku T2'                            => [ 'Gigabyte', 'GSmart Tuku T2' ],
        'GSmart T4'                                 => [ 'Gigabyte', 'GSmart T4' ],
        'Gigabyte TB100'                            => [ 'Gigabyte', 'TB100', DeviceType::TABLET ],
    ],

    'Gigaset!!' => [
        'Gigaset GS160'                             => [ 'Gigaset', 'GS160' ],
        'Gigaset GS170'                             => [ 'Gigaset', 'GS170' ],
        'Gigaset QV830'                             => [ 'Gigaset', 'QV830', DeviceType::TABLET ],
        'Gigaset QV831'                             => [ 'Gigaset', 'QV831', DeviceType::TABLET ],
        'Gigaset QV1030'                            => [ 'Gigaset', 'QV1030', DeviceType::TABLET ],
    ],

    '80-1'                                      => [ 'Gigaset', 'Maxwell 10', DeviceType::DECT ],
    'SL930'                                     => [ 'Gigaset', 'SL930', DeviceType::DECT ],

    '(GIO-)?(GiONEE[- ])?A9$!'                  => [ 'Gionee', 'A9' ],
    '(GIO-)?(GiONEE[- ])?C500!'                 => [ 'Gionee', 'C500' ],
    '(GIO-)?(GiONEE[- ])?C600!'                 => [ 'Gionee', 'C600' ],
    '(GIO-)?(GiONEE[- ])?C610!'                 => [ 'Gionee', 'C610' ],
    '(GIO-)?(GiONEE[- ])?C620!'                 => [ 'Gionee', 'C620' ],
    '(GIO-)?(GiONEE[- ])?C700!'                 => [ 'Gionee', 'C700' ],
    '(GIO-)?(GiONEE[- ])?C800!'                 => [ 'Gionee', 'C800' ],
    '(GIO-)?(GiONEE[- ])?Dream D1!'             => [ 'Gionee', 'Dream D1' ],
    '(GIO-)?(GiONEE[- ])?E3T!'                  => [ 'Gionee', 'E3T' ],
    '(GIO-)?(GiONEE[- ])?E3$!'                  => [ 'Gionee', 'E3' ],
    '(GIO-)?(GiONEE[- ])?E5$!'                  => [ 'Gionee', 'E5' ],
    '(GIO-)?(GiONEE[- ])?E6mini!'               => [ 'Gionee', 'E6 mini' ],
    '(GIO-)?(GiONEE[- ])?E6$!'                  => [ 'Gionee', 'E6' ],
    '(GIO-)?(GiONEE[- ])?E6T$!'                 => [ 'Gionee', 'E6T' ],
    '(GIO-)?(GiONEE[- ])?E7$!'                  => [ 'Gionee', 'E7' ],
    '(GIO-)?(GiONEE[- ])?F103!'                 => [ 'Gionee', 'F103' ],
    '(GIO-)?(GiONEE[- ])?F301!'                 => [ 'Gionee', 'F301' ],
    '(GIO-)?(GiONEE[- ])?GN5001!'               => [ 'Gionee', 'GN5001' ],
    '(GIO-)?(GiONEE[- ])?GN5002!'               => [ 'Gionee', 'GN5002' ],
    '(GIO-)?(GiONEE[- ])?GN8001!'               => [ 'Gionee', 'GN8001' ],
    '(GIO-)?(GiONEE[- ])?GN9000!'               => [ 'Gionee', 'GN9000' ],
    '(GIO-)?(GiONEE[- ])?GN9001!'               => [ 'Gionee', 'GN9001' ],
    '(GIO-)?(GiONEE[- ])?GN9002!'               => [ 'Gionee', 'GN9002' ],
    '(GIO-)?(GiONEE[- ])?GN9004!'               => [ 'Gionee', 'GN9004' ],
    '(GIO-)?(GiONEE[- ])?GN9005!'               => [ 'Gionee', 'GN9005' ],
    '(GIO-)?(GiONEE[- ])?GN9006!'               => [ 'Gionee', 'GN9006' ],
    '(GIO-)?(GiONEE[- ])?GN9007!'               => [ 'Gionee', 'GN9007' ],
    '(GIO-)?(GiONEE[- ])?GN9008!'               => [ 'Gionee', 'GN9008' ],
    '(GIO-)?(GiONEE[- ])?GN9010!'               => [ 'Gionee', 'GN9010' ],
    '(GIO-)?(GiONEE[- ])?GN100T!'               => [ 'Gionee', 'GN100T' ],
    '(GIO-)?(GiONEE[- ])?GN100!'                => [ 'Gionee', 'GN100' ],
    '(GIO-)?(GiONEE[- ])?GN105!'                => [ 'Gionee', 'GN105' ],
    '(GIO-)?(GiONEE[- ])?GN106!'                => [ 'Gionee', 'GN106' ],
    '(GIO-)?(GiONEE[- ])?GN107!'                => [ 'Gionee', 'GN107' ],
    '(GIO-)?(GiONEE[- ])?GN108!'                => [ 'Gionee', 'GN108' ],
    '(GIO-)?(GiONEE[- ])?GN109!'                => [ 'Gionee', 'GN109' ],
    '(GIO-)?(GiONEE[- ])?GN135!'                => [ 'Gionee', 'GN135' ],
    '(GIO-)?(GiONEE[- ])?GN136!'                => [ 'Gionee', 'GN136' ],
    '(GIO-)?(GiONEE[- ])?GN137!'                => [ 'Gionee', 'GN137' ],
    '(GIO-)?(GiONEE[- ])?GN139!'                => [ 'Gionee', 'GN139' ],
    '(GIO-)?(GiONEE[- ])?GN150!'                => [ 'Gionee', 'GN150' ],
    '(GIO-)?(GiONEE[- ])?GN151!'                => [ 'Gionee', 'GN151' ],
    '(GIO-)?(GiONEE[- ])?GN152!'                => [ 'Gionee', 'GN152' ],
    '(GIO-)?(GiONEE[- ])?GN160T!'               => [ 'Gionee', 'GN160T' ],
    '(GIO-)?(GiONEE[- ])?GN160!'                => [ 'Gionee', 'GN160' ],
    '(GIO-)?(GiONEE[- ])?GN168T!'               => [ 'Gionee', 'GN168T' ],
    '(GIO-)?(GiONEE[- ])?GN170!'                => [ 'Gionee', 'GN170' ],
    '(GIO-)?(GiONEE[- ])?GN180!'                => [ 'Gionee', 'GN180' ],
    '(GIO-)?(GiONEE[- ])?GN181!'                => [ 'Gionee', 'GN181' ],
    '(GIO-)?(GiONEE[- ])?GN200!'                => [ 'Gionee', 'GN200' ],
    '(GIO-)?(GiONEE[- ])?GN205!'                => [ 'Gionee', 'GN205' ],
    '(GIO-)?(GiONEE[- ])?GN210!'                => [ 'Gionee', 'GN210' ],
    '(GIO-)?(GiONEE[- ])?GN305!'                => [ 'Gionee', 'GN305' ],
    '(GIO-)?(GiONEE[- ])?GN320!'                => [ 'Gionee', 'GN320' ],
    '(GIO-)?(GiONEE[- ])?GN360!'                => [ 'Gionee', 'GN360' ],
    '(GIO-)?(GiONEE[- ])?GN380!'                => [ 'Gionee', 'GN380' ],
    '(GIO-)?(GiONEE[- ])?GN600!'                => [ 'Gionee', 'GN600' ],
    '(GIO-)?(GiONEE[- ])?GN700T!'               => [ 'Gionee', 'GN700T' ],
    '(GIO-)?(GiONEE[- ])?GN700W!'               => [ 'Gionee', 'GN700W' ],
    '(GIO-)?(GiONEE[- ])?GN705T!'               => [ 'Gionee', 'GN705T' ],
    '(GIO-)?(GiONEE[- ])?GN705W!'               => [ 'Gionee', 'GN705W' ],
    '(GIO-)?(GiONEE[- ])?GN706L!'               => [ 'Gionee', 'GN706L' ],
    '(GIO-)?(GiONEE[- ])?GN708T!'               => [ 'Gionee', 'GN708T' ],
    'GN 708T'                                   => [ 'Gionee', 'GN708T' ],
    '(GIO-)?(GiONEE[- ])?GN708W!'               => [ 'Gionee', 'GN708W' ],
    'GPLUS GN708W'                              => [ 'Gionee', 'GN708W' ],
    '(GIO-)?(GiONEE[- ])?GN787!'                => [ 'Gionee', 'GN787' ],
    '(GIO-)?(GiONEE[- ])?GN800!'                => [ 'Gionee', 'GN800' ],
    '(GIO-)?(GiONEE[- ])?GN810!'                => [ 'Gionee', 'GN810' ],
    '(GIO-)?(GiONEE[- ])?GN818T!'               => [ 'Gionee', 'GN818T' ],
    '(GIO-)?(GiONEE[- ])?GN858!'                => [ 'Gionee', 'GN858' ],
    '(GIO-)?(GiONEE[- ])?GN868!'                => [ 'Gionee', 'GN868' ],
    '(GIO-)?(GiONEE[- ])?GN878!'                => [ 'Gionee', 'GN878' ],
    'Gionee M1'                                 => [ 'Gionee', 'M1' ],
    'Gionee M2'                                 => [ 'Gionee', 'M2' ],
    'Gionee-M2'                                 => [ 'Gionee', 'M2' ],
    'Gionee M3S'                                => [ 'Gionee', 'M3S' ],
    'Gionee M5'                                 => [ 'Gionee', 'M5' ],
    'GPLUS N809'                                => [ 'Gionee', 'N809' ],
    '(GIO-)?(GiONEE[- ])?S101!'                 => [ 'Gionee', 'S101' ],
    'GiONEE TD500'                              => [ 'Gionee', 'TD500' ],
    '(GIO-)?(GiONEE[- ])?V182!'                 => [ 'Gionee', 'V182' ],
    '(GIO-)?(GiONEE[- ])?V185!'                 => [ 'Gionee', 'V185' ],
    '(GIO-)?(GiONEE[- ])?V188!'                 => [ 'Gionee', 'V188' ],
    '(GIO-)?(GiONEE[- ])?W800!'                 => [ 'Gionee', 'W800' ],
    '(GIO-)?(GiONEE[- ])?X817!'                 => [ 'Gionee', 'X817' ],
    '(GIO-)?(GiONEE[- ])?Ctrl V1!'              => [ 'Gionee', 'CTRL V1' ],
    '(GIO-)?(GiONEE[- ])?Ctrl V2!'              => [ 'Gionee', 'CTRL V2' ],
    '(GIO-)?(GiONEE[- ])?Ctrl V3!'              => [ 'Gionee', 'CTRL V3' ],
    '(GIO-)?(GiONEE[- ])?Ctrl V4!'              => [ 'Gionee', 'CTRL V4' ],
    '(GIO-)?(GiONEE[- ])?Ctrl V5!'              => [ 'Gionee', 'CTRL V5' ],
    '(GIO-)?(GiONEE[- ])?Pioneer P1!'           => [ 'Gionee', 'Pioneer P1' ],
    '(GIO-)?(GiONEE[- ])?Pioneer P2!'           => [ 'Gionee', 'Pioneer P2' ],
    '(GIO-)?(GiONEE[- ])?Pioneer P3!'           => [ 'Gionee', 'Pioneer P3' ],
    '(GIO-)?(GiONEE[- ])?Pioneer P4!'           => [ 'Gionee', 'Pioneer P4' ],
    'Gionee P3'                                 => [ 'Gionee', 'Pioneer P3' ],
    'Gionee P4'                                 => [ 'Gionee', 'Pioneer P4' ],
    'GiONEE S7'                                 => [ 'Gionee', 'Elife S7' ],
    '(GIO-)?(GiONEE[- ])?Gpad G1!'              => [ 'Gionee', 'GPAD G1', DeviceType::TABLET ],
    '(GIO-)?(GiONEE[- ])?Gpad G2!'              => [ 'Gionee', 'GPAD G2', DeviceType::TABLET ],
    '(GIO-)?(GiONEE[- ])?Gpad G3!'              => [ 'Gionee', 'GPAD G3', DeviceType::TABLET ],
    'GL-900'                                    => [ 'GlobusGPS', 'GL-900', DeviceType::GPS ],

    'GLX!!' => [
        'GLX Jet'                                   => [ 'GLX', 'Jet', DeviceType::TABLET ],
        'GLX Luster a'                              => [ 'GLX', 'Luster', DeviceType::TABLET ],
        'GLX SpiderI'                               => [ 'GLX', 'Spider', DeviceType::TABLET ],
    ],

    'GOCL!!' => [
        'GOCLEVER ANDROID BOX 500'                  => [ 'Goclever', 'Android Box 500', ],
        'GOCLEVER'                                  => [ 'Goclever', 'TAB', DeviceType::TABLET ],
        'GOCLEVER TAB A73'                          => [ 'Goclever', 'TAB A73', DeviceType::TABLET ],
        'GOCLEVER TAB A93'                          => [ 'Goclever', 'TAB A93', DeviceType::TABLET ],
        'GOCLEVER TAB A93.2'                        => [ 'Goclever', 'TAB A93', DeviceType::TABLET ],
        'GOCLEVER TAB A101'                         => [ 'Goclever', 'TAB A101', DeviceType::TABLET ],
        'GOCLEVER TAB A103'                         => [ 'Goclever', 'TAB A103', DeviceType::TABLET ],
        'GOCLEVER A103'                             => [ 'Goclever', 'TAB A103', DeviceType::TABLET ],
        'GOCLEVER TAB A104!'                        => [ 'Goclever', 'TAB A104', DeviceType::TABLET ],
        'GOCLEVER TAB A971'                         => [ 'Goclever', 'TAB A971', DeviceType::TABLET ],
        'GOCLEVER TAB A972BK'                       => [ 'Goclever', 'TAB A972', DeviceType::TABLET ],
        'GOCLEVER TAB I71'                          => [ 'Goclever', 'TAB I71', DeviceType::TABLET ],
        'GOCLEVER TAB M703G'                        => [ 'Goclever', 'TAB M703G', DeviceType::TABLET ],
        'GOCLEVER TAB M713G'                        => [ 'Goclever', 'TAB M713G', DeviceType::TABLET ],
        'GOCLEVER TAB M723G'                        => [ 'Goclever', 'TAB M723G', DeviceType::TABLET ],
        'GOCLEVER TAB M813G'                        => [ 'Goclever', 'TAB M813G', DeviceType::TABLET ],
        'GOCLEVER TAB R70'                          => [ 'Goclever', 'TAB R70', DeviceType::TABLET ],
        'GOCLEVER TAB R76.1'                        => [ 'Goclever', 'TAB R76', DeviceType::TABLET ],
        'GOCLEVER TAB R104'                         => [ 'Goclever', 'TAB R104', DeviceType::TABLET ],
        'GOCLEVER TAB R106'                         => [ 'Goclever', 'TAB R106', DeviceType::TABLET ],
        'GOCLEVER TAB T75'                          => [ 'Goclever', 'TAB T75', DeviceType::TABLET ],
        'GOCLEVER TAB T76'                          => [ 'Goclever', 'TAB T76', DeviceType::TABLET ],
        'GOCLEVER TAB 9300'                         => [ 'Goclever', 'TAB 9300', DeviceType::TABLET ],
        'GOCLM7000KD'                               => [ 'Goclever', 'Terra 70', DeviceType::TABLET ],
        'GOCLEVER HYBRID'                           => [ 'Goclever', 'Hybrid', DeviceType::TABLET ],
        'GOCLEVER NETBOOK I102'                     => [ 'Goclever', 'Netbook I102' ],
        'GOCLEVER NETBOOK R103'                     => [ 'Goclever', 'Netbook R103' ],
    ],

    'ARIES 101'                                 => [ 'Goclever', 'ARIES 101', DeviceType::TABLET ],
    'ARIES 785'                                 => [ 'Goclever', 'ARIES 785', DeviceType::TABLET ],
    'INSIGNIA 5'                                => [ 'Goclever', 'INSIGNIA 5' ],
    'INSIGNIA 5X'                               => [ 'Goclever', 'INSIGNIA 5X' ],
    'QUANTUM 4'                                 => [ 'Goclever', 'QUANTUM 4' ],
    'QUANTUM 700m'                              => [ 'Goclever', 'QUANTUM 700M' ],
    'QUANTUM 1010N'                             => [ 'Goclever', 'QUANTUM 1010N' ],

    'GO Live!!' => [
        'GO Live S1'                                => [ 'GoLive', 'S1' ],
        'GO Live Dual Core'                         => [ 'GoLive', 'Dual Core' ],
    ],

    'GOOPHONE!!' => [
        'GOOPHONE i5C'                              => [ 'Goophone', 'i5C' ],
        'GOOPHONE i5S'                              => [ 'Goophone', 'i5S' ],
        'Goophone i9'                               => [ 'Goophone', 'i9' ],
        'GOOPHONE M3+'                              => [ 'Goophone', 'M3+' ],
        'GooPhone S5 Pro'                           => [ 'Goophone', 'S5 Pro' ],
        'GOOPHONE X1'                               => [ 'Goophone', 'X1' ],
        'GOOPHONE X7'                               => [ 'Goophone', 'X7' ],
    ],

    'CHONG!!' => [
        'GHONG T618'                                => [ 'Guohong', 'T618' ],
        'GHONGV10'                                  => [ 'Guohong', 'V10' ],
        'GHONGV12'                                  => [ 'Guohong', 'V12' ],
        'GHONG W100'                                => [ 'Guohong', 'W100' ],
    ],

    'M758A'                                     => [ 'Gpad', 'M758A', DeviceType::TABLET ],

    'GO !!' => [
        'GO M1'                                     => [ 'GreenOrange', 'M1' ],
        'GO M2'                                     => [ 'GreenOrange', 'M2' ],
        'GO M2S'                                    => [ 'GreenOrange', 'M2S' ],
        'GO M3'                                     => [ 'GreenOrange', 'M3' ],
        'GO N1'                                     => [ 'GreenOrange', 'N1' ],
        'GO N1-Y'                                   => [ 'GreenOrange', 'N1-Y' ],
        'GO N1S'                                    => [ 'GreenOrange', 'N1S' ],
        'GO N2'                                     => [ 'GreenOrange', 'N2' ],
        'GO NX'                                     => [ 'GreenOrange', 'NX' ],
        'GO S2'                                     => [ 'GreenOrange', 'S2' ],
    ],

    'GR-TB!!' => [
        'GR-TB7'                                    => [ 'Grundig', 'Style Tab GR-TB7', DeviceType::TABLET ],
        'GR-TB10S'                                  => [ 'Grundig', 'Style Tab GR-TB10S', DeviceType::TABLET ],
    ],

    'GVON 898'                                  => [ 'Gvon', 'Aero 898' ],

    '(Haier[- ])?H[ETW]- ?[A-Z][0-9]!!' => [
        '(Haier[- ])?HE-E80!'                       => [ 'Haier', 'E80' ],
        '(Haier[- ])?HE-E617!'                      => [ 'Haier', 'E617' ],
        '(Haier[- ])?HE-E700!'                      => [ 'Haier', 'E700' ],
        '(Haier[- ])?HE-E760!'                      => [ 'Haier', 'E760' ],
        '(Haier[- ])?HT-I600!'                      => [ 'Haier', 'I600' ],
        '(Haier[- ])?HT-I617!'                      => [ 'Haier', 'I617' ],
        '(Haier[- ])?HT-I619!'                      => [ 'Haier', 'I619' ],
        '(Haier[- ])?HT-I710!'                      => [ 'Haier', 'I710' ],
        '(Haier[- ])?HT-I736!'                      => [ 'Haier', 'I736' ],
        '(Haier[- ])?HT-I756!'                      => [ 'Haier', 'I756' ],
        '(Haier[- ])?HT-I816!'                      => [ 'Haier', 'I816' ],
        '(Haier[- ])?HT-I860!'                      => [ 'Haier', 'I860' ],
        '(Haier[- ])?HT-I928!'                      => [ 'Haier', 'I928' ],
        '(Haier[- ])?HW-N66W!'                      => [ 'Haier', 'N66W' ],
        '(Haier[- ])?HW-N86W!'                      => [ 'Haier', 'N86W' ],
        '(Haier[- ])?(HW-)?N88W!'                   => [ 'Haier', 'N88W' ],
        '(Haier[- ])?HW-N620E!'                     => [ 'Haier', 'N620E' ],
        '(Haier[- ])?HW-N800!'                      => [ 'Haier', 'N800' ],
        '(Haier[- ])?(HW-)?W716!'                   => [ 'Haier', 'W716' ],
        '(Haier[- ])?(HW-)?W718!'                   => [ 'Haier', 'W718' ],
        '(Haier[- ])?HW-W820!'                      => [ 'Haier', 'W820' ],
        '(Haier[- ])?HW-W850!'                      => [ 'Haier', 'W850' ],
        '(Haier[- ])?HW-W860!'                      => [ 'Haier', 'W860' ],
        '(Haier[- ])?HW-W910!'                      => [ 'Haier', 'W910' ],
    ],

    'Haier-W700'                                => [ 'Haier', 'W700' ],
    'W757'                                      => [ 'Haier', 'W757' ],
    'Haier-SY0880'                              => [ 'Haier', 'SY0880' ],
    '(LE[0-9]{2,2}[BMU][0-9]{4,4}[A-Z]+)!'      => [ 'Haier', '$1', DeviceType::TELEVISION ],

    'Zio P2'                                    => [ 'Haier', 'Zio P2' ],

    'PAD[0-9]{3,3}!!' => [
        'PAD511'                                    => [ 'Haier', 'Pad 511', DeviceType::TABLET ],
        'PAD711'                                    => [ 'Haier', 'Pad 711', DeviceType::TABLET ],
        'PAD722'                                    => [ 'Haier', 'Pad 722', DeviceType::TABLET ],
        'PAD821'                                    => [ 'Haier', 'Pad 821', DeviceType::TABLET ],
        'PAD822'                                    => [ 'Haier', 'Pad 822', DeviceType::TABLET ],
    ],

    'I9220'                                     => [ 'Haipai', 'I9220' ],
    'GT-i9377'                                  => [ 'Haipai', 'I9377' ],
    'X710d'                                     => [ 'Haipai', 'X710D' ],
    'X720D'                                     => [ 'Haipai', 'X720D' ],

    'SN[0-9]!!' => [
        'SN10T1'                                    => [ 'HANNspree', 'HANNSpad SN10T1', DeviceType::TABLET ],
        'SN10T2'                                    => [ 'HANNspree', 'HANNSpad SN10T2', DeviceType::TABLET ],
        'SN14T71'                                   => [ 'HANNspree', 'HANNSpad SN14T71', DeviceType::TABLET ],
        'SN97T41W'                                  => [ 'HANNspree', 'HANNSpad SN97T41W', DeviceType::TABLET ],
        'SN1AT71W(B)'                               => [ 'HANNspree', 'HANNSpad SN1AT71WB', DeviceType::TABLET ],
    ],

    'HannsComb'                                 => [ 'HANNspree', 'HANNSpad', DeviceType::TABLET ],
    'Hannspadd'                                 => [ 'HANNspree', 'HANNSpad', DeviceType::TABLET ],

    'U1'                                        => [ 'HCL', 'ME U1', DeviceType::TABLET ],
    'X1'                                        => [ 'HCL', 'ME X1', DeviceType::TABLET ],
    'Y2'                                        => [ 'HCL', 'ME Y2', DeviceType::TABLET ],
    'Connect-2G-2.0'                            => [ 'HCL', 'ME Connect 2G 2.0', DeviceType::TABLET ],
    'H701'                                      => [ 'Hedy', 'H701' ],

    'HEDY!!' => [
        'HEDY H701'                                 => [ 'Hedy', 'H701' ],
        'HEDY H712'                                 => [ 'Hedy', 'H712' ],
        'HEDY H770'                                 => [ 'Hedy', 'H770' ],
        'HEDY S801'                                 => [ 'Hedy', 'S801' ],
        'HEDY S803'                                 => [ 'Hedy', 'S803' ],
        'HEDY T700'                                 => [ 'Hedy', 'T700' ],
    ],

    '9300+'                                     => [ 'Hero', '9300+' ],
    'H2000+'                                    => [ 'Hero', 'H2000+' ],
    'H7100'                                     => [ 'Hero', 'H7100' ],
    'H7500+'                                    => [ 'Hero', 'H7500+' ],
    'HERO H7500+'                               => [ 'Hero', 'H7500+' ],
    'H9500'                                     => [ 'Hero', 'H9500' ],
    'MID Ser(ai|ia)ls!'                         => [ 'Herotab', 'C8', DeviceType::TABLET ],

    '(Highscreen|Alpha|Bay|Boost|Cosmo|Explosion|Power|Prime|Zera)!!' => [
        'Alpha Ice'                                 => [ 'Highscreen', 'Alpha Ice' ],
        'Alpha GT'                                  => [ 'Highscreen', 'Alpha GT' ],
        'Alpha GTR'                                 => [ 'Highscreen', 'Alpha GTR' ],
        'HIGHSCREEN GTR'                            => [ 'Highscreen', 'Alpha GTR' ],
        'Alpha GTX'                                 => [ 'Highscreen', 'Alpha GTX' ],
        'Alpha R'                                   => [ 'Highscreen', 'Alpha R' ],
        'Alpha Rage'                                => [ 'Highscreen', 'Alpha Rage' ],
        'Bay'                                       => [ 'Highscreen', 'Bay' ],
        'HighScreen Boost'                          => [ 'Highscreen', 'Boost' ],
        'Boost II'                                  => [ 'Highscreen', 'Boost 2' ],
        'Boost IIse'                                => [ 'Highscreen', 'Boost 2 SE' ],
        'Highscreen Boost 2 SE'                     => [ 'Highscreen', 'Boost 2 SE' ],
        'Boost3'                                    => [ 'Highscreen', 'Boost 3' ],
        'Boost 3 SE'                                => [ 'Highscreen', 'Boost 3 SE' ],
        'Cosmo'                                     => [ 'Highscreen', 'Cosmo', DeviceType::TABLET ],
        'COSMO DUO'                                 => [ 'Highscreen', 'Cosmo Duo', DeviceType::TABLET ],
        'Explosion'                                 => [ 'Highscreen', 'Explosion' ],
        'HIGHSCREEN Jet Duo'                        => [ 'Highscreen', 'Jet Duo', DeviceType::TABLET ],
        'PowerFive'                                 => [ 'Highscreen', 'Power Five' ],
        'PowerFour'                                 => [ 'Highscreen', 'Power Four' ],
        'Power Ice'                                 => [ 'Highscreen', 'Power Ice' ],
        'Power Rage'                                => [ 'Highscreen', 'Power Rage' ],
        'Prime L'                                   => [ 'Highscreen', 'Prime L' ],
        'Highscreen Spark'                          => [ 'Highscreen', 'Spark' ],
        'ZeraF'                                     => [ 'Highscreen', 'Zera F' ],
        'Zera F'                                    => [ 'Highscreen', 'Zera F' ],
        'Zera f rev.S'                              => [ 'Highscreen', 'Zera F' ],
        'Zera S'                                    => [ 'Highscreen', 'Zera S' ],
        'Zera S Rev.S'                              => [ 'Highscreen', 'Zera S' ],
        'Zera-S-Power'                              => [ 'Highscreen', 'Zera S Power' ],
        'Zera U'                                    => [ 'Highscreen', 'Zera U' ],
    ],

    'HLV-T!!' => [
        'HLV-T701'                                  => [ 'Hi-Level', 'HLV-T701', DeviceType::TABLET ],
        'HLV-T702'                                  => [ 'Hi-Level', 'HLV-T702', DeviceType::TABLET ],
        'HLV-T704'                                  => [ 'Hi-Level', 'HLV-T704', DeviceType::TABLET ],
        'HLV-T707'                                  => [ 'Hi-Level', 'HLV-T707', DeviceType::TABLET ],
        'HLV-T1001W'                                => [ 'Hi-Level', 'HLV-T1001W', DeviceType::TABLET ],
        'HLV-T1002W'                                => [ 'Hi-Level', 'HLV-T1002W', DeviceType::TABLET ],
        'HLV-T9701'                                 => [ 'Hi-Level', 'HLV-T9701', DeviceType::TABLET ],
        'HLV-TN75'                                  => [ 'Hi-Level', 'HLV-TN75', DeviceType::TABLET ],
    ],

    'HIKe!!' => [
        'HIKe 716'                                  => [ 'HIKe', 'Q1' ],
        'HIKe 818'                                  => [ 'HIKe', 'Pandora 2' ],
        'HIKe 828'                                  => [ 'HIKe', 'X1' ],
        'HIKe 828A'                                 => [ 'HIKe', 'X1' ],
        'HIKe 848'                                  => [ 'HIKe', 'X2' ],
        'HIKe 868'                                  => [ 'HIKe', 'Z1' ],
    ],

    'HILIVE H7'                                 => [ 'Hilive', 'H7' ],

    'HS-[0-9]{1,2}DTB!!' => [
        'HS-7DTB4!'                                 => [ 'Hipstreet', 'Titan 7"', DeviceType::TABLET ],
        'HS-7DTB25!'                                => [ 'Hipstreet', 'Titan 2 7"', DeviceType::TABLET ],
        'HS-7DTB26!'                                => [ 'Hipstreet', 'Titan+ 7"', DeviceType::TABLET ],
        'HS-7DTB27!'                                => [ 'Hipstreet', 'Titan+ 7"', DeviceType::TABLET ],
        'HS-7DTB29!'                                => [ 'Hipstreet', 'Astro 7"', DeviceType::TABLET ],
        'HS-7DTB39!'                                => [ 'Hipstreet', 'Titan 2 7"', DeviceType::TABLET ],
        'HS-7DTB5!'                                 => [ 'Hipstreet', 'Nova 7"', DeviceType::TABLET ],
        'HS-7DTB6!'                                 => [ 'Hipstreet', 'Aurora 7"', DeviceType::TABLET ],
        'HS-785TB2!'                                => [ 'Hipstreet', 'Hyperion 7"', DeviceType::TABLET ],
        'HS-785TB3!'                                => [ 'Hipstreet', 'i8', DeviceType::TABLET ],
        'HS-8DTB!'                                  => [ 'Hipstreet', 'Flash 8"', DeviceType::TABLET ],
        'HS-9DTB4!'                                 => [ 'Hipstreet', 'Flare 9"', DeviceType::TABLET ],
        'HS-9DTB7!'                                 => [ 'Hipstreet', 'Flare 2 9"', DeviceType::TABLET ],
        'HS-9DTB37!'                                => [ 'Hipstreet', 'Flare 3 9"', DeviceType::TABLET ],
        'HS-10DTB2!'                                => [ 'Hipstreet', 'Equinox 10"', DeviceType::TABLET ],
        'HS-10DTB4!'                                => [ 'Hipstreet', 'Equinox 4 10"', DeviceType::TABLET ],
        'HS-10DTB5!'                                => [ 'Hipstreet', 'Spectrum 10"', DeviceType::TABLET ],
        'HS-10DTB8!'                                => [ 'Hipstreet', 'Equinox 3 10"', DeviceType::TABLET ],
        'HS-10DTB12!'                               => [ 'Hipstreet', 'Phoenix 10"', DeviceType::TABLET ],
    ],

    'HS-[EFHITUX][0-9]!!' => [
        'HS-X1'                                     => [ 'Hisense', 'X1' ],
        'HS-X5T'                                    => [ 'Hisense', 'X5T' ],
        'HS-X6C'                                    => [ 'Hisense', 'X6C' ],
        'HS-X8C'                                    => [ 'Hisense', 'X8C' ],
        'HS-X8T'                                    => [ 'Hisense', 'X8T' ],
        'HS-U8'                                     => [ 'Hisense', 'U8' ],
        'HS-U9'                                     => [ 'Hisense', 'U9' ],
        'HS-U98'                                    => [ 'Hisense', 'U98' ],
        'HS-U609'                                   => [ 'Hisense', 'U609' ],
        'HS-U800'                                   => [ 'Hisense', 'U800' ],
        'HS-U820'                                   => [ 'Hisense', 'U820' ],
        'HS-U850'                                   => [ 'Hisense', 'U850' ],
        'HS-U860'                                   => [ 'Hisense', 'U860' ],
        'HS-U909'                                   => [ 'Hisense', 'U909' ],
        'HS-U909B'                                  => [ 'Hisense', 'U909B' ],
        'HS-U912'                                   => [ 'Hisense', 'U912' ],
        'HS-U912C'                                  => [ 'Hisense', 'U912C' ],
        'HS-U930'                                   => [ 'Hisense', 'U930' ],
        'HS-U936'                                   => [ 'Hisense', 'U936' ],
        'HS-U939'                                   => [ 'Hisense', 'U939' ],
        'HS-U950'                                   => [ 'Hisense', 'U950' ],
        'HS-U958'                                   => [ 'Hisense', 'U958' ],
        'HS-U960Q'                                  => [ 'Hisense', 'U960' ],
        'HS-U966'                                   => [ 'Hisense', 'U966' ],
        'HS-U970'                                   => [ 'Hisense', 'U970' ],
        'HS-U971'                                   => [ 'Hisense', 'U971' ],
        'HS-U978'                                   => [ 'Hisense', 'U978' ],
        'HS-U980'                                   => [ 'Hisense', 'U980' ],
        'HS-U988'                                   => [ 'Hisense', 'U988' ],
        'HS-T9'                                     => [ 'Hisense', 'T9' ],
        'HS-T92'                                    => [ 'Hisense', 'T92' ],
        'HS-T96'                                    => [ 'Hisense', 'T96' ],
        'HS-T818'                                   => [ 'Hisense', 'T818' ],
        'HS-T820'                                   => [ 'Hisense', 'T820' ],
        'HS-T830'                                   => [ 'Hisense', 'T830' ],
        'HS-T909'                                   => [ 'Hisense', 'T909' ],
        'HS-T912'                                   => [ 'Hisense', 'T912' ],
        'HS-T928'                                   => [ 'Hisense', 'T928' ],
        'HS-T930'                                   => [ 'Hisense', 'T930' ],
        'HS-T950'                                   => [ 'Hisense', 'T950' ],
        'HS-T958'                                   => [ 'Hisense', 'T958' ],
        'HS-T959'                                   => [ 'Hisense', 'T959' ],
        'HS-T959S1'                                 => [ 'Hisense', 'T959' ],
        'HS-T967'                                   => [ 'Hisense', 'T967' ],
        'HS-T968'                                   => [ 'Hisense', 'T968' ],
        'HS-T970'                                   => [ 'Hisense', 'T970' ],
        'HS-T978'                                   => [ 'Hisense', 'T978' ],
        'HS-I630T'                                  => [ 'Hisense', 'I630T' ],
        'HS-H800T'                                  => [ 'Hisense', 'H800T' ],
        'HS-F1'                                     => [ 'Hisense', 'F1' ],
        'HS-F5180'                                  => [ 'Hisense', 'F5180' ],
        'HS-E86'                                    => [ 'Hisense', 'E86' ],
        'HS-E200T'                                  => [ 'Hisense', 'E200T' ],
        'HS-E260T'                                  => [ 'Hisense', 'E260T' ],
        'HS-E600M'                                  => [ 'Hisense', 'E600M' ],
        'HS-E620M'                                  => [ 'Hisense', 'E620M' ],
        'HS-E820'                                   => [ 'Hisense', 'E820' ],
        'HS-E830'                                   => [ 'Hisense', 'E830' ],
        'HS-E860'                                   => [ 'Hisense', 'E860' ],
        'HS-E909'                                   => [ 'Hisense', 'E909' ],
        'HS-E910'                                   => [ 'Hisense', 'E910' ],
        'HS-E912!'                                  => [ 'Hisense', 'E912' ],
        'HS-E913'                                   => [ 'Hisense', 'E913' ],
        'HS-E917'                                   => [ 'Hisense', 'E917' ],
        'HS-E920'                                   => [ 'Hisense', 'E920' ],
        'HS-E926'                                   => [ 'Hisense', 'E926' ],
        'HS-E930'                                   => [ 'Hisense', 'E930' ],
        'HS-E936'                                   => [ 'Hisense', 'E936' ],
        'HS-E956'                                   => [ 'Hisense', 'E956' ],
        'HS-E956Q'                                  => [ 'Hisense', 'E956' ],
        'HS-E968'                                   => [ 'Hisense', 'E968' ],
    ],

    'HS-E[GT][0-9]{3,3}!!' => [
        'HS-EG870'                                  => [ 'Hisense', 'EG870' ],
        'HS-EG900'                                  => [ 'Hisense', 'EG900' ],
        'HS-EG901'                                  => [ 'Hisense', 'EG901' ],
        'HS-EG902'                                  => [ 'Hisense', 'EG902' ],
        'HS-EG906'                                  => [ 'Hisense', 'EG906' ],
        'HS-EG909'                                  => [ 'Hisense', 'EG909' ],
        'HS-EG916'                                  => [ 'Hisense', 'EG916' ],
        'HS-EG929'                                  => [ 'Hisense', 'EG929' ],
        'HS-EG936D'                                 => [ 'Hisense', 'EG936' ],
        'HS-EG939'                                  => [ 'Hisense', 'EG939' ],
        'HS-EG950'                                  => [ 'Hisense', 'EG950' ],
        'HS-EG958'                                  => [ 'Hisense', 'EG958' ],
        'HS-EG966'                                  => [ 'Hisense', 'EG966' ],
        'HS-EG970'                                  => [ 'Hisense', 'EG970' ],
        'HS-EG971'                                  => [ 'Hisense', 'EG971' ],
        'HS-EG978'                                  => [ 'Hisense', 'EG978' ],
        'HS-EG980'                                  => [ 'Hisense', 'EG980' ],
        'HS-EG981'                                  => [ 'Hisense', 'EG981' ],
        'HS-ET919'                                  => [ 'Hisense', 'ET919' ],
    ],

    '(HS-)?Hisense!!' => [
        'Hisense C1'                                => [ 'Hisense', 'C1' ],
        'Hisense-U8'                                => [ 'Hisense', 'U8' ],
        'Hisense U980'                              => [ 'Hisense', 'U980' ],
        'Hisense T92'                               => [ 'Hisense', 'T92' ],
        'Hisense I639T'                             => [ 'Hisense', 'I639T' ],
        'Hisense I639M'                             => [ 'Hisense', 'I639M' ],
        'Hisense-E360M'                             => [ 'Hisense', 'E360M' ],
        'Hisense E602M'                             => [ 'Hisense', 'E602M' ],
        'Hisense HS-E910'                           => [ 'Hisense', 'E910' ],
        'Hisense EG909'                             => [ 'Hisense', 'EG909' ],
        'HS-Hisense F20T'                           => [ 'Hisense', 'F20T' ],
        'Hisense F31'                               => [ 'Hisense', 'F31' ],
        'HS-Hisense I632T'                          => [ 'Hisense', 'I632T' ],
        'HS-Hisense I635T'                          => [ 'Hisense', 'I635T' ],
        'HS-Hisense I639T'                          => [ 'Hisense', 'I639T' ],
        'HS-Hisense E602T'                          => [ 'Hisense', 'E602T' ],
        'HS-Hisense E621T'                          => [ 'Hisense', 'E621T' ],
        'HS-Hisense E625T'                          => [ 'Hisense', 'E625T' ],
    ],

    'T92'                                       => [ 'Hisense', 'T92' ],
    'E860'                                      => [ 'Hisense', 'E860' ],
    'EG98'                                      => [ 'Hisense', 'EG98' ],
    'EG680'                                     => [ 'Hisense', 'EG680' ],

    'AD683G'                                    => [ 'Hisense', 'EG909' ],
    'EG968B'                                    => [ 'Hisense', 'EG968B' ],
    'E170BS'                                    => [ 'Hisense', 'E170BS', DeviceType::TABLET ],
    'Hisense AD686G'                            => [ 'Hisense', 'AD686G' ],
    'E270BSA'                                   => [ 'Hisense', 'Sero 7 Lite', DeviceType::TABLET ],
    'M470BSA'                                   => [ 'Hisense', 'Sero 7 Pro', DeviceType::TABLET ],
    'M470BSE'                                   => [ 'Hisense', 'Sero 7 Pro', DeviceType::TABLET ],
    'E2281'                                     => [ 'Hisense', 'Sero 8', DeviceType::TABLET ],
    'xt880b'                                    => [ 'Hisense', 'XT880', DeviceType::TELEVISION ],
    'GX1210V TV'                                => [ 'Hisense', 'GX1210', DeviceType::TELEVISION ],

    '(Hisense )?(LED[0-9]{2,2}(G|K|L|EC|XT)[0-9]{2,3})!'
                                                => [ 'Hisense', '$2', DeviceType::TELEVISION ],

    'Hisense Google TV TV'                      => [ 'Hisense', 'Pulse', DeviceType::TELEVISION, Flag::GOOGLETV ],
    'hisense gx1200v'                           => [ 'Hisense', 'Pulse', DeviceType::TELEVISION, Flag::GOOGLETV ],

    '(Amaze|Hitech)!!' => [
        'Amaze HT-808'                              => [ 'Hi-Tech', 'Amaze HT-808' ],
        'Amaze S2'                                  => [ 'Hi-Tech', 'Amaze S2' ],
        'AMAZE S3'                                  => [ 'Hi-Tech', 'Amaze S3' ],
        'Amaze S5'                                  => [ 'Hi-Tech', 'Amaze S5' ],
        'Amaze S5 Plus'                             => [ 'Hi-Tech', 'Amaze S5 Plus' ],
        'Amaze S9'                                  => [ 'Hi-Tech', 'Amaze S9' ],
        'AMAZE S200'                                => [ 'Hi-Tech', 'Amaze S200' ],
        'Hitech Amaze S200 3G'                      => [ 'Hi-Tech', 'Amaze S200' ],
        'Amaze S230'                                => [ 'Hi-Tech', 'Amaze S230' ],
        'AMAZE S250'                                => [ 'Hi-Tech', 'Amaze S250' ],
        'Amaze S305'                                => [ 'Hi-Tech', 'Amaze S305' ],
        'Amaze S310'                                => [ 'Hi-Tech', 'Amaze S310' ],
        'AMAZE S330'                                => [ 'Hi-Tech', 'Amaze S330' ],
        'Amaze S400'                                => [ 'Hi-Tech', 'Amaze S400' ],
        'Amaze S405'                                => [ 'Hi-Tech', 'Amaze S405' ],
        'Amaze S406'                                => [ 'Hi-Tech', 'Amaze S406' ],
        'Amaze S430 Plus'                           => [ 'Hi-Tech', 'Amaze S430 Plus' ],
        'Hitech S450'                               => [ 'Hi-Tech', 'Amaze S450' ],
        'Amaze S500'                                => [ 'Hi-Tech', 'Amaze S500' ],
        'AMAZE TAB'                                 => [ 'Hi-Tech', 'Amaze Tab', DeviceType::TABLET ],
        'AMAZE TAB 2'                               => [ 'Hi-Tech', 'Amaze Tab 2', DeviceType::TABLET ],
        'AMAZE TAB 3'                               => [ 'Hi-Tech', 'Amaze Tab 3', DeviceType::TABLET ],
    ],

    'HITO HT-3'                                 => [ 'Hito', 'HT-3' ],
    'HKPHONE H8-3G'                             => [ 'HKPhone', 'H8 3G' ],
    'HT17Pro'                                   => [ 'Homtom', 'HT17 Pro' ],
    'HT20Pro'                                   => [ 'Homtom', 'HT20 Pro' ],
    'D7800AD'                                   => [ 'Honeywell', 'D7800AD' ],
    'Dolphin 70e Black'                         => [ 'Honeywell', 'Dolphin 70e' ],
    'D75E'                                      => [ 'Honeywell', 'Dolphin 75e' ],
    'CT50'                                      => [ 'Honeywell', 'Dolphin CT50' ],
    'CN51 [NQ]!'                                => [ 'Honeywell', 'Intermec CN51' ],

    'HOSIN!!' => [
        'HOSIN A608'                                => [ 'Hosin', 'A608' ],
        'HOSIN T70(OPEN)'                           => [ 'Hosin', 'T70' ],
        'HOSIN T70'                                 => [ 'Hosin', 'T70' ],
        'HOSIN T80'                                 => [ 'Hosin', 'T80' ],
        'HOSIN U2'                                  => [ 'Hosin', 'U2' ],
        'HOSIN U3'                                  => [ 'Hosin', 'U3' ],
        'Hosin U7'                                  => [ 'Hosin', 'U7' ],
        'HOSIN V60'                                 => [ 'Hosin', 'V60' ],
        'HOSIN V70'                                 => [ 'Hosin', 'V70' ],
        'HOSIN V708T'                               => [ 'Hosin', 'V708T' ],
    ],

    '(HP|Slate)!!' => [
        'HP 7'                                      => [ 'HP', '7', DeviceType::TABLET ],
        'HP 7.1'                                    => [ 'HP', '7.1', DeviceType::TABLET ],
        'HP 7 G2'                                   => [ 'HP', '7 G2', DeviceType::TABLET ],
        'HP 7 Plus'                                 => [ 'HP', '7 Plus', DeviceType::TABLET ],
        'HP 7 Plus G2'                              => [ 'HP', '7 Plus G2', DeviceType::TABLET ],
        'HP 8'                                      => [ 'HP', '8', DeviceType::TABLET ],
        'HP 8 G2'                                   => [ 'HP', '8 G2', DeviceType::TABLET ],
        'HP 10'                                     => [ 'HP', '10', DeviceType::TABLET ],
        'HP 10 Tablet'                              => [ 'HP', '10', DeviceType::TABLET ],
        'HP 10 G2 Tablet'                           => [ 'HP', '10 G2', DeviceType::TABLET ],
        'HP 10 G2 Tablet 2301'                      => [ 'HP', '10 G2', DeviceType::TABLET ],
        'HP 10 Plus'                                => [ 'HP', '10 Plus', DeviceType::TABLET ],
        'HP Slate 6 Voice Tab'                      => [ 'HP', 'Slate 6 Voice Tab', DeviceType::TABLET ],
        'HP Slate 6 VoiceTab Plus'                  => [ 'HP', 'Slate 6 Voice Tab Plus', DeviceType::TABLET ],
        'HP Slate 6 Voice Tab II'                   => [ 'HP', 'Slate 6 Voice Tab II', DeviceType::TABLET ],
        'HP Slate 7'                                => [ 'HP', 'Slate 7', DeviceType::TABLET ],
        'HP Slate 7 3G'                             => [ 'HP', 'Slate 7', DeviceType::TABLET ],
        'HP Slate 7 Beats Special Edition'          => [ 'HP', 'Slate 7', DeviceType::TABLET ],
        'HP Slate7 Beats Special Edition'           => [ 'HP', 'Slate 7', DeviceType::TABLET ],
        'HP Slate 7 Plus'                           => [ 'HP', 'Slate 7 Plus', DeviceType::TABLET ],
        'HP Slate 7 HD'                             => [ 'HP', 'Slate 7 HD', DeviceType::TABLET ],
        'HP Slate7 Extreme'                         => [ 'HP', 'Slate 7 Extreme', DeviceType::TABLET ],
        'HP Slate 7 Voice Tab'                      => [ 'HP', 'Slate 7 Voice Tab', DeviceType::TABLET ],
        'HP 7 VoiceTab'                             => [ 'HP', 'Slate 7 Voice Tab', DeviceType::TABLET ],
        'HP Slate 7 VoiceTab Ultra'                 => [ 'HP', 'Slate 7 Voice Tab Ultra', DeviceType::TABLET ],
        'HP Slate 8 Plus'                           => [ 'HP', 'Slate 8 Plus', DeviceType::TABLET ],
        'HP Slate 8 Pro'                            => [ 'HP', 'Slate 8 Pro', DeviceType::TABLET ],
        'HP Slate 10 HD'                            => [ 'HP', 'Slate 10 HD', DeviceType::TABLET ],
        'Slate 10 HD'                               => [ 'HP', 'Slate 10 HD', DeviceType::TABLET ],
        'HP Slate 10 Plus'                          => [ 'HP', 'Slate 10 Plus', DeviceType::TABLET ],
        'HP Slate 17'                               => [ 'HP', 'Slate 17', DeviceType::TABLET ],
        'Slate 21'                                  => [ 'HP', 'Slate 21', DeviceType::TABLET ],
        'Slate 21 Pro'                              => [ 'HP', 'Slate 21 Pro', DeviceType::TABLET ],
        'HP SlateBook 10 x2 PC'                     => [ 'HP', 'SlateBook 10 x2', DeviceType::TABLET ],
        'HP SlateBook 14 PC'                        => [ 'HP', 'SlateBook 14 HD', DeviceType::TABLET ],
        'HP Pro Slate 8'                            => [ 'HP', 'Pro Slate 8', DeviceType::TABLET ],
        'HP Pro Slate 10 EE G1'                     => [ 'HP', 'Pro Slate 10', DeviceType::TABLET ],
        'HP Pro Slate 12'                           => [ 'HP', 'Pro Slate 12', DeviceType::TABLET ],
    ],

    'HP!!' => [
        'HP Compaq ([0-9]{4,4}[a-z])!'              => [ 'HP', 'Compaq $1', DeviceType::DESKTOP ],
        'HP Compaq ([a-z]{2,2}[0-9]{4,4})!'         => [ 'HP', 'Compaq $1', DeviceType::DESKTOP ],
        'HP Elite ([0-9]{4,4})!'                    => [ 'HP', 'Elite $1', DeviceType::DESKTOP ],
        'HP EliteBook ([0-9]{4,4}[a-z])!'           => [ 'HP', 'EliteBook $1', DeviceType::DESKTOP ],
        'HP EliteBook Revolve ([0-9]{3,3})!'        => [ 'HP', 'EliteBook Revolve $1', DeviceType::DESKTOP ],
        'HP ENVY (.*) Notebook PC!'                 => [ 'HP', 'ENVY $1', DeviceType::DESKTOP ],
        'HP ENVY Sleekbook (.*) PC!'                => [ 'HP', 'ENVY Sleekbook $1', DeviceType::DESKTOP ],
        'HP ([0-9]{2,4}) Notebook PC!'              => [ 'HP', '$1', DeviceType::DESKTOP ],
        'HP ([0-9]{2,4} G[0-9]{1,2}) Notebook PC!'  => [ 'HP', '$1', DeviceType::DESKTOP ],
        'HP (G[0-9]{2,4}) Notebook PC!'             => [ 'HP', '$1', DeviceType::DESKTOP ],
        'HP Mini!'                                  => [ 'HP', 'Mini', DeviceType::DESKTOP ],
        'HP Pavilion ([0-9]+)!'                     => [ 'HP', 'Pavilion $1', DeviceType::DESKTOP ],
        'HP Pavilion ([a-z]{1,2} ?[0-9]+)!'         => [ 'HP', 'Pavilion $1', DeviceType::DESKTOP ],
        'HP Pavilion Sleekbook (.*) PC!'            => [ 'HP', 'Pavilion Sleekbook $1', DeviceType::DESKTOP ],
        'HP ProBook ([0-9]{4,4}[a-z])!'             => [ 'HP', 'ProBook $1', DeviceType::DESKTOP ],
        'HP ProBook ([0-9]{3,3} G[0-9])!'           => [ 'HP', 'ProBook $1', DeviceType::DESKTOP ],
        'HP Spectre ((?:[0-9]+ )?x2)!'              => [ 'HP', 'Spectre $1', DeviceType::DESKTOP ],
        'HP Split ((?:[0-9]+ )?x2)!'                => [ 'HP', 'Split $1', DeviceType::DESKTOP ],
    ],

    'HP-TouchPad'                               => [ 'HP', 'TouchPad', DeviceType::TABLET ],
    '(HP )?Touchpad!'                           => [ 'HP', 'TouchPad', DeviceType::TABLET ],
    '(cm|aokp) tenderloin!'                     => [ 'HP', 'TouchPad', DeviceType::TABLET ],

    'HTC!!' => [
        'HTC (Amaze|Ruby)!'                         => [ 'HTC', 'Amaze 4G' ],
        'HTC (Aria|Gratia|Liberty)!'                => [ 'HTC', 'Aria' ],
        'HTC A63(66|80)!'                           => [ 'HTC', 'Aria' ],
        'HTC Bee'                                   => [ 'HTC', 'Bee' ],
        'HTC ?ChaCha!'                              => [ 'HTC', 'ChaCha' ],
        'HTC A810e'                                 => [ 'HTC', 'ChaCha' ],
        'HTC Status'                                => [ 'HTC', 'ChaCha' ],
        'HTC PH06130'                               => [ 'HTC', 'ChaCha' ],
        'HTC A9188!'                                => [ 'HTC', 'Cullinan' ],
        'HTC Desire 10 lifestyle'                   => [ 'HTC', 'Desire 10 Lifestyle' ],
        'HTC Desire 10 pro'                         => [ 'HTC', 'Desire 10 Pro' ],
        'HTC D10i'                                  => [ 'HTC', 'Desire 10 Pro' ],
        'HTC Desire 200'                            => [ 'HTC', 'Desire 200' ],
        'HTC Desire 210 dual sim'                   => [ 'HTC', 'Desire 210' ],
        'HTC Desire 300'                            => [ 'HTC', 'Desire 300' ],
        'HTC 0P6A1'                                 => [ 'HTC', 'Desire 300' ],
        'HTC 301e'                                  => [ 'HTC', 'Desire 300' ],
        'HTC D310(n|w)!'                            => [ 'HTC', 'Desire 310' ],
        'HTC Desire 310'                            => [ 'HTC', 'Desire 310' ],
        'HTC Desire 310 dual sim'                   => [ 'HTC', 'Desire 310' ],
        'HTC 0PF11'                                 => [ 'HTC', 'Desire 310' ],
        'HTC 0PF110'                                => [ 'HTC', 'Desire 310' ],
        'HTC 0PF120'                                => [ 'HTC', 'Desire 310' ],
        'HTC V1'                                    => [ 'HTC', 'Desire 310' ],
        'HTC D316d'                                 => [ 'HTC', 'Desire 316' ],
        'HTC Desire 320'                            => [ 'HTC', 'Desire 320' ],
        'htc v01'                                   => [ 'HTC', 'Desire 320' ],
        'HTC Desire 326G dual sim'                  => [ 'HTC', 'Desire 326G' ],
        'HTC 2PNT1'                                 => [ 'HTC', 'Desire 326G' ],
        'HTC Desire 400'                            => [ 'HTC', 'Desire 400' ],
        'HTC Desire 400 dual sim'                   => [ 'HTC', 'Desire 400' ],
        'HTC Desire 500'                            => [ 'HTC', 'Desire 500' ],
        'HTC Desire 500 dual sim'                   => [ 'HTC', 'Desire 500' ],
        'HTC 5060'                                  => [ 'HTC', 'Desire 500' ],
        'HTC 0P3Z11'                                => [ 'HTC', 'Desire 500' ],
        'HTC 0PFJ50'                                => [ 'HTC', 'Desire 500' ],
        'HTC Desire 501'                            => [ 'HTC', 'Desire 501' ],
        'HTC Desire 501 dual sim'                   => [ 'HTC', 'Desire 501' ],
        'HTC 603h'                                  => [ 'HTC', 'Desire 501' ],
        'HTC PO091'                                 => [ 'HTC', 'Desire 501' ],
        'HTC Desire 510'                            => [ 'HTC', 'Desire 510' ],
        'HTC D510'                                  => [ 'HTC', 'Desire 510' ],
        'HTC 0PCV2'                                 => [ 'HTC', 'Desire 510' ],
        'HTC 0PCV20'                                => [ 'HTC', 'Desire 510' ],
        'HTC 0PCV220'                               => [ 'HTC', 'Desire 510' ],
        'HTC Desire 512'                            => [ 'HTC', 'Desire 512' ],
        'HTC D516'                                  => [ 'HTC', 'Desire 516' ],
        'HTC D516(d|t|w)!'                          => [ 'HTC', 'Desire 516' ],
        'HTC Desire 516 dual sim'                   => [ 'HTC', 'Desire 516' ],
        'HTC C2'                                    => [ 'HTC', 'Desire 516' ],
        'HTC V2'                                    => [ 'HTC', 'Desire 516' ],
        'HTC Desire 520'                            => [ 'HTC', 'Desire 520' ],
        'HTC 0PGQ1'                                 => [ 'HTC', 'Desire 520' ],
        'HTC Desire 526'                            => [ 'HTC', 'Desire 526' ],
        'HTCD100LVW'                                => [ 'HTC', 'Desire 526' ],
        'HTC D100LVW'                               => [ 'HTC', 'Desire 526' ],
        'HTC D100LVWPP'                             => [ 'HTC', 'Desire 526' ],
        'HTC 0PM31'                                 => [ 'HTC', 'Desire 526' ],
        'HTC 0PM1100'                               => [ 'HTC', 'Desire 526G' ],
        'HTC Desire 526G'                           => [ 'HTC', 'Desire 526G' ],
        'HTC Desire 526G dual sim'                  => [ 'HTC', 'Desire 526G' ],
        'HTC D526(h)!'                              => [ 'HTC', 'Desire 526G+' ],
        'HTC Desire 526GPLUS dual sim'              => [ 'HTC', 'Desire 526G+' ],
        'HTC 0PL41!'                                => [ 'HTC', 'Desire 526G+' ],
        'HTC 0PL42!'                                => [ 'HTC', 'Desire 526G+' ],
        'HTC Desire 530'                            => [ 'HTC', 'Desire 530' ],
        'HTC D530u'                                 => [ 'HTC', 'Desire 530' ],
        'HTC 2PST1!'                                => [ 'HTC', 'Desire 530' ],
        'HTC 2PST2!'                                => [ 'HTC', 'Desire 530' ],
        'HTCD160LVW'                                => [ 'HTC', 'Desire 530' ],
        'HTCD160LVWPP'                              => [ 'HTC', 'Desire 530' ],
        'HTC Desire 550'                            => [ 'HTC', 'Desire 550' ],
        'HTC Desire 555'                            => [ 'HTC', 'Desire 555' ],
        'HTC Desire 600'                            => [ 'HTC', 'Desire 600' ],
        'HTC Desire 600 dual sim'                   => [ 'HTC', 'Desire 600' ],
        'HTC PO491'                                 => [ 'HTC', 'Desire 600' ],
        'HTC PO49120'                               => [ 'HTC', 'Desire 600' ],
        'HTC Desire 600c dual sim'                  => [ 'HTC', 'Desire 600c' ],
        'HTC 609d'                                  => [ 'HTC', 'Desire 600c' ],
        'HTC Desire 601'                            => [ 'HTC', 'Desire 601' ],
        'HTC Desire 601 dual sim'                   => [ 'HTC', 'Desire 601' ],
        'HTC Desire 601-LS'                         => [ 'HTC', 'Desire 601' ],
        'HTC ?0P4E!'                                => [ 'HTC', 'Desire 601' ],
        'HTC 606w'                                  => [ 'HTC', 'Desire 606w' ],
        'HTC 608'                                   => [ 'HTC', 'Desire 608' ],
        'HTC 608t'                                  => [ 'HTC', 'Desire 608t' ],
        'HTC Desire 610'                            => [ 'HTC', 'Desire 610' ],
        'HTC D610'                                  => [ 'HTC', 'Desire 610' ],
        'HTC D610t'                                 => [ 'HTC', 'Desire 610' ],
        'HTC D610x'                                 => [ 'HTC', 'Desire 610' ],
        'HTC 0P9O110'                               => [ 'HTC', 'Desire 610' ],
        'HTC 0P9O2'                                 => [ 'HTC', 'Desire 610' ],
        'HTC331ZLVW'                                => [ 'HTC', 'Desire 610' ],
        'htc a3qhdul'                               => [ 'HTC', 'Desire 610' ],
        'HTC Desire 612'                            => [ 'HTC', 'Desire 612' ],
        'HTC331ZLVWPP'                              => [ 'HTC', 'Desire 612' ],
        'HTC 0P9O30'                                => [ 'HTC', 'Desire 612' ],
        'HTC Desire 616'                            => [ 'HTC', 'Desire 616' ],
        'HTC Desire 616 dual sim!'                  => [ 'HTC', 'Desire 616' ],
        'HTC 616 Dual Sim'                          => [ 'HTC', 'Desire 616' ],
        'HTC D616w!'                                => [ 'HTC', 'Desire 616' ],
        'HTC V3'                                    => [ 'HTC', 'Desire 616' ],
        'HTC 619d!'                                 => [ 'HTC', 'Desire 619d' ],
        'HTC D620(h|u)!'                            => [ 'HTC', 'Desire 620' ],
        'HTC Desire 620'                            => [ 'HTC', 'Desire 620' ],
        'HTC Desire 620 dual sim'                   => [ 'HTC', 'Desire 620' ],
        'HTC 0PE64!'                                => [ 'HTC', 'Desire 620' ],
        'HTC Desire 620G'                           => [ 'HTC', 'Desire 620G' ],
        'HTC Desire 620G dual sim'                  => [ 'HTC', 'Desire 620G' ],
        'HTC 0PE65'                                 => [ 'HTC', 'Desire 620G' ],
        'HTC Desire 625'                            => [ 'HTC', 'Desire 625' ],
        'HTC D626(d|q|t|w|x)!'                      => [ 'HTC', 'Desire 626' ],
        'HTC Desire 626'                            => [ 'HTC', 'Desire 626' ],
        'HTC Desire 626 dual sim'                   => [ 'HTC', 'Desire 626' ],
        'HTC 0PKX2'                                 => [ 'HTC', 'Desire 626' ],
        'HTC D630x'                                 => [ 'HTC', 'Desire 626' ],
        'HTC D200LVW'                               => [ 'HTC', 'Desire 626' ],
        'HTC D200LVWPP'                             => [ 'HTC', 'Desire 626' ],
        'HTC DESIRE 626G'                           => [ 'HTC', 'Desire 626G' ],
        'HTC Desire 626G dual sim'                  => [ 'HTC', 'Desire 626G' ],
        'HTC D626(ph)!'                             => [ 'HTC', 'Desire 626G' ],
        'HTC Desire 626GPLUS dual sim'              => [ 'HTC', 'Desire 626G+' ],
        'HTC 0PM11'                                 => [ 'HTC', 'Desire 626G+' ],
        'HTC Desire 626s'                           => [ 'HTC', 'Desire 626s' ],
        'HTC 0PM91'                                 => [ 'HTC', 'Desire 626s' ],
        'HTC 0PM912!'                               => [ 'HTC', 'Desire 626s' ],
        'HTC 0PM92'                                 => [ 'HTC', 'Desire 626s' ],
        'HTC Desire 628'                            => [ 'HTC', 'Desire 628' ],
        'HTC Desire 628 dual sim'                   => [ 'HTC', 'Desire 628' ],
        'HTC Desire 630 dual sim'                   => [ 'HTC', 'Desire 630' ],
        'HTC 2PST5'                                 => [ 'HTC', 'Desire 630' ],
        'HTC Desire 650'                            => [ 'HTC', 'Desire 650' ],
        'HTC Desire 650 dual sim'                   => [ 'HTC', 'Desire 650' ],
        'HTC 2PYR1'                                 => [ 'HTC', 'Desire 650' ],
        'HTC 2PYR2'                                 => [ 'HTC', 'Desire 650' ],
        'HTC Desire 700 dual sim'                   => [ 'HTC', 'Desire 700' ],
        'HTC 709d'                                  => [ 'HTC', 'Desire 709d' ],
        'HTC Desire 728'                            => [ 'HTC', 'Desire 728' ],
        'HTC Desire 728 dual sim'                   => [ 'HTC', 'Desire 728' ],
        'HTC D728(w|x)!'                            => [ 'HTC', 'Desire 728' ],
        'HTC Desire 728G dual sim'                  => [ 'HTC', 'Desire 728G' ],
        'HTC 2PQ83'                                 => [ 'HTC', 'Desire 728G' ],
        'HTC D816'                                  => [ 'HTC', 'Desire 816' ],
        'HTC D816(d|t|v|w|x)!'                      => [ 'HTC', 'Desire 816' ],
        'HTC D816(h)!'                              => [ 'HTC', 'Desire 816G' ],
        'HTC Desire 816'                            => [ 'HTC', 'Desire 816' ],
        'HTC Desire 816 dual sim'                   => [ 'HTC', 'Desire 816' ],
        'htc a5ul'                                  => [ 'HTC', 'Desire 816' ],
        'htc a5chl'                                 => [ 'HTC', 'Desire 816' ],
        'HTC 0P9C2'                                 => [ 'HTC', 'Desire 816' ],
        'HTC 0P9C8'                                 => [ 'HTC', 'Desire 816' ],
        'HTC D816e'                                 => [ 'HTC', 'Desire 816' ],
        'HTC Desire 816G'                           => [ 'HTC', 'Desire 816G' ],
        'HTC Desire 816G dual sim!'                 => [ 'HTC', 'Desire 816G' ],
        'HTC 816G dual sim'                         => [ 'HTC', 'Desire 816G' ],
        'HTC Desire 816W'                           => [ 'HTC', 'Desire 816W' ],
        'HTC D820(G|pi|ts|us)!'                     => [ 'HTC', 'Desire 820G' ],
        'HTC Desire 820G dual sim'                  => [ 'HTC', 'Desire 820G' ],
        'HTC Desire 820G !'                         => [ 'HTC', 'Desire 820G' ],
        'HTC Desire 820G+'                          => [ 'HTC', 'Desire 820G+' ],
        'HTC Desire 820G PLUS dual sim'             => [ 'HTC', 'Desire 820G+' ],
        'HTC D820'                                  => [ 'HTC', 'Desire 820' ],
        'HTC D820(f|m|mt|mu|s|t|u|x)!'              => [ 'HTC', 'Desire 820' ],
        'HTC Desire 820'                            => [ 'HTC', 'Desire 820' ],
        'HTC Desire 820 dual sim'                   => [ 'HTC', 'Desire 820' ],
        'HTC 0PFJ4'                                 => [ 'HTC', 'Desire 820' ],
        'htc a51dtul'                               => [ 'HTC', 'Desire 820' ],
        'HTC Desire 820q dual sim'                  => [ 'HTC', 'Desire 820q' ],
        'HTC Desire 820s'                           => [ 'HTC', 'Desire 820s' ],
        'HTC Desire 820s dual sim'                  => [ 'HTC', 'Desire 820s' ],
        'HTC D820(ys)!'                             => [ 'HTC', 'Desire 820s' ],
        'HTC Desire 820ts'                          => [ 'HTC', 'Desire 820ts' ],
        'HTC Desire 820 mini'                       => [ 'HTC', 'Desire 820 mini' ],
        'HTC Desire 825'                            => [ 'HTC', 'Desire 825' ],
        'HTC Desire 825 dual sim'                   => [ 'HTC', 'Desire 825' ],
        'HTC D825u'                                 => [ 'HTC', 'Desire 825' ],
        'HTC 2PUK2!'                                => [ 'HTC', 'Desire 825' ],
        'HTC Desire 826'                            => [ 'HTC', 'Desire 826' ],
        'HTC Desire 826 dual sim'                   => [ 'HTC', 'Desire 826' ],
        'HTC D826'                                  => [ 'HTC', 'Desire 826' ],
        'HTC D826(d|t|w|y)!'                        => [ 'HTC', 'Desire 826' ],
        'HTC D828(w|x)!'                            => [ 'HTC', 'Desire 828' ],
        'HTC Desire 828'                            => [ 'HTC', 'Desire 828' ],
        'HTC Desire 828 dual sim'                   => [ 'HTC', 'Desire 828' ],
        'HTC 2PRE2'                                 => [ 'HTC', 'Desire 828' ],
        'HTC Desire 830'                            => [ 'HTC', 'Desire 830' ],
        'HTC Desire 830 dual sim'                   => [ 'HTC', 'Desire 830' ],
        'HTC D830(u|x)!'                            => [ 'HTC', 'Desire 830' ],
        'HTC 5088'                                  => [ 'HTC', 'Desire 5088' ],
        'HTC 6160'                                  => [ 'HTC', 'Desire 6160' ],
        'HTC 7060'                                  => [ 'HTC', 'Desire 7060' ],
        'HTC ?7088!'                                => [ 'HTC', 'Desire 7088' ],
        'HTC 8060'                                  => [ 'HTC', 'Desire 8060' ],
        'HTC Desire C'                              => [ 'HTC', 'Desire C' ],
        'HTC Desire C N'                            => [ 'HTC', 'Desire C' ],
        'HTC H1000C'                                => [ 'HTC', 'Desire C' ],
        'HTC A320e'                                 => [ 'HTC', 'Desire C' ],
        'HTC Desire ?HD!'                           => [ 'HTC', 'Desire HD' ],
        'HTC A91(91|92)!'                           => [ 'HTC', 'Desire HD' ],
        'HTC 0PFH1!'                                => [ 'HTC', 'Desire Eye' ],
        'HTC 0PFH2!'                                => [ 'HTC', 'Desire Eye' ],
        'HTC Desire EYE'                            => [ 'HTC', 'Desire Eye' ],
        'HTC M910x'                                 => [ 'HTC', 'Desire Eye' ],
        'HTC Desire L dual sim'                     => [ 'HTC', 'Desire L' ],
        'HTC PM6014'                                => [ 'HTC', 'Desire L' ],
        'HTC Desire P'                              => [ 'HTC', 'Desire P' ],
        'HTC Desire Q'                              => [ 'HTC', 'Desire Q' ],
        'HTC ?Desire ?S( |$)!'                      => [ 'HTC', 'Desire S' ],
        'HTC S510(b|e)!'                            => [ 'HTC', 'Desire S' ],
        'HTC Passion S510e'                         => [ 'HTC', 'Desire S' ],
        'HTC Desire Saga'                           => [ 'HTC', 'Desire S' ],
        'HTC Saga'                                  => [ 'HTC', 'Desire S' ],
        'HTC DesireSV'                              => [ 'HTC', 'Desire SV' ],
        'HTC Desire SV'                             => [ 'HTC', 'Desire SV' ],
        'HTC DesireU'                               => [ 'HTC', 'Desire U' ],
        'HTC Desire U'                              => [ 'HTC', 'Desire U' ],
        'HTC Desire U dual sim'                     => [ 'HTC', 'Desire U' ],
        'HTC T327w'                                 => [ 'HTC', 'Desire U' ],
        'HTC Desire V'                              => [ 'HTC', 'Desire V' ],
        'HTC T328w'                                 => [ 'HTC', 'Desire V' ],
        'HTC PROMIN U'                              => [ 'HTC', 'Desire V' ],
        'HTC PRO DS'                                => [ 'HTC', 'Desire V' ],
        'HTC Desire VC'                             => [ 'HTC', 'Desire VC' ],
        'HTC Desire VC T328d'                       => [ 'HTC', 'Desire VC' ],
        'HTC T328d'                                 => [ 'HTC', 'Desire VC' ],
        'HTC PRO DD'                                => [ 'HTC', 'Desire VC' ],
        'HTC Desire VT'                             => [ 'HTC', 'Desire VT' ],
        'HTC T328t'                                 => [ 'HTC', 'Desire VT' ],
        'HTC Desire XC!'                            => [ 'HTC', 'Desire XC' ],
        'HTC Desire XS!'                            => [ 'HTC', 'Desire XS' ],
        'HTC Desire ?X!'                            => [ 'HTC', 'Desire X' ],
        'HTC T329w'                                 => [ 'HTC', 'Desire X' ],
        'HTC POO U'                                 => [ 'HTC', 'Desire X' ],
        'HTC Desire ?Z!'                            => [ 'HTC', 'Desire Z' ],
        'HTC A72(71|72|75)!'                        => [ 'HTC', 'Desire Z' ],
        'HTC ?Vision!'                              => [ 'HTC', 'Desire Z' ],
        'HTC T329d'                                 => [ 'HTC', 'T329d' ],
        'HTC ?Desire!'                              => [ 'HTC', 'Desire' ],
        'HTC Bravo'                                 => [ 'HTC', 'Desire' ],
        'HTC Bravo C'                               => [ 'HTC', 'Desire' ],
        'HTC eris'                                  => [ 'HTC', 'Desire' ],
        'HTC A81(81|83)!'                           => [ 'HTC', 'Desire' ],
        'HTC ?X06HTII!'                             => [ 'HTC', 'Desire X06HTII', 'carrier' => 'Softbank' ],
        'HTC ?X06HT!'                               => [ 'HTC', 'Desire X06HT', 'carrier' => 'Softbank' ],
        'HTC Desire CDMA'                           => [ 'HTC', 'Desire' ],
        'HTC PLS7373ADR'                            => [ 'HTC', 'Detail' ],
        'HTC 603e'                                  => [ 'HTC', 'E1' ],
        'HTC Evo'                                   => [ 'HTC', 'EVO 3D' ],
        'HTC ?EVO ?3D!'                             => [ 'HTC', 'EVO 3D' ],
        'HTC X51(5a|5c|5d|5m)!'                     => [ 'HTC', 'EVO 3D' ],
        'HTC Shooter'                               => [ 'HTC', 'EVO 3D' ],
        'htc shooteru'                              => [ 'HTC', 'EVO 3D' ],
        'HTC ?EVO ?V ?4G!'                          => [ 'HTC', 'EVO 3D' ],
        'HTC EVO 4G\+!'                             => [ 'HTC', 'EVO 4G+' ],
        'HTC X515e!'                                => [ 'HTC', 'EVO 4G+' ],
        'HTC ?EVO ?4G!'                             => [ 'HTC', 'EVO 4G' ],
        'HTC jewel'                                 => [ 'HTC', 'EVO 4G' ],
        'HTC EVO LTE'                               => [ 'HTC', 'EVO 4G' ],
        'HTC EVO G20 T9399  For Sprint'             => [ 'HTC', 'EVO 4G' ],
        'htc supersonic'                            => [ 'HTC', 'EVO 4G' ],
        'HTC ?(EVO ?)?Design ?4G!'                  => [ 'HTC', 'EVO Design 4G' ],
        'HTC EVO Design C715e!'                     => [ 'HTC', 'EVO Design 4G' ],
        'HTC C715c'                                 => [ 'HTC', 'EVO Design 4G' ],
        'HTC Acquire'                               => [ 'HTC', 'EVO Design 4G' ],
        'HTC Kingdom'                               => [ 'HTC', 'EVO Design 4G' ],
        'HTC EVO Shift!'                            => [ 'HTC', 'EVO Shift' ],
        'HTC EVO View 4G'                           => [ 'HTC', 'EVO View 4G' ],
        'HTC ?Explorer!'                            => [ 'HTC', 'Explorer' ],
        'HTC A31(0b|0e)!'                           => [ 'HTC', 'Explorer' ],
        'HTC Pico Incredible HD'                    => [ 'HTC', 'Explorer' ],
        'HTC first'                                 => [ 'HTC', 'First' ],
        'HTC PM33100'                               => [ 'HTC', 'First' ],
        'HTC Flyer!'                                => [ 'HTC', 'Flyer', DeviceType::TABLET ],
        'HTC P51(0e|2|5e)!'                         => [ 'HTC', 'Flyer', DeviceType::TABLET ],
        'HTC HD'                                    => [ 'HTC', 'HD' ],
        'HTC HD2!'                                  => [ 'HTC', 'HD2' ],
        'HTC T8585'                                 => [ 'HTC', 'HD2' ],
        'HTC HD7!'                                  => [ 'HTC', 'HD7' ],
        'HTC T92(98|99)!'                           => [ 'HTC', 'HD7' ],
        'HTC HD7S!'                                 => [ 'HTC', 'HD7s' ],
        'HTC T(93|98)99!'                           => [ 'HTC', 'HD7s' ],
        'HTC HD Mini'                               => [ 'HTC', 'HD mini' ],
        'HTC HERO200'                               => [ 'HTC', 'Hero 200' ],               /* Sprint */
        'HTC Hero ?S!'                              => [ 'HTC', 'Hero S' ],             /* US Cellular */
        'HTC Hero!'                                 => [ 'HTC', 'Hero' ],
        'HTC IMAGIO'                                => [ 'HTC', 'Imagio' ],
        'HTC Incredible'                            => [ 'HTC', 'Incredible' ],
        'HTC Incredible CDMA'                       => [ 'HTC', 'Incredible' ],
        'HTC Incredible T9199 for Vodafone'         => [ 'HTC', 'Incredible' ],
        'HTC Incredible E S715e'                    => [ 'HTC', 'Incredible E' ],
        'HTC Incredible ?S!'                        => [ 'HTC', 'Incredible S' ],
        'HTC ?Vivo!'                                => [ 'HTC', 'Incredible S' ],
        'HTC S710e!'                                => [ 'HTC', 'Incredible S' ],
        'HTC S710d'                                 => [ 'HTC', 'Incredible S' ],
        'HTC Incredible 2'                          => [ 'HTC', 'Incredible S' ],
        'HTC Innovation'                            => [ 'HTC', 'Innovation' ],
        'HTC (HD7 )?Inspire!'                       => [ 'HTC', 'Inspire 4G' ],
        'HTC J Z321e'                               => [ 'HTC', 'J' ],
        'HTC X920e'                                 => [ 'HTC', 'J Butterfly' ],
        'HTC Butterfly'                             => [ 'HTC', 'J Butterfly' ],
        'HTC J Butterfly'                           => [ 'HTC', 'J Butterfly' ],
        'HTC Butterfly J'                           => [ 'HTC', 'J Butterfly' ],
        'HTC DLX WLJ'                               => [ 'HTC', 'J Butterfly' ],
        'HTC DLX WL'                                => [ 'HTC', 'J Butterfly' ],
        'HTC DLX U'                                 => [ 'HTC', 'J Butterfly' ],
        'HTC DLXUB1'                                => [ 'HTC', 'J Butterfly' ],
        'HTC J One'                                 => [ 'HTC', 'J One' ],
        'HTC Butterfly s'                           => [ 'HTC', 'Butterfly S' ],
        'HTC Butterfly s 901s'                      => [ 'HTC', 'Butterfly S' ],
        'HTC PO68'                                  => [ 'HTC', 'Butterfly S' ],
        'HTC 9060'                                  => [ 'HTC', 'Butterfly S' ],
        'HTC 9088'                                  => [ 'HTC', 'Butterfly S' ],
        'HTC 901e'                                  => [ 'HTC', 'Butterfly S' ],
        'HTC 909d'                                  => [ 'HTC', 'Butterfly S' ],
        'HTC 919d'                                  => [ 'HTC', 'Butterfly S' ],
        'HTC B810x'                                 => [ 'HTC', 'Butterfly 2' ],
        'HTC Butterfly 2'                           => [ 'HTC', 'Butterfly 2' ],
        'HTC Butterfly 3'                           => [ 'HTC', 'Butterfly 3' ],
        'HTC B830x'                                 => [ 'HTC', 'Butterfly 3' ],
        'HTC P715!'                                 => [ 'HTC', 'Jetstream', DeviceType::TABLET ],
        'HTC PG09410'                               => [ 'HTC', 'Jetstream', DeviceType::TABLET ],
        'HTC Legend!'                               => [ 'HTC', 'Legend' ],
        'HTC Magic!'                                => [ 'HTC', 'Magic' ],
        'HTC Sapphire'                              => [ 'HTC', 'Magic' ],
        'HTC Merge'                                 => [ 'HTC', 'Merge' ],
        'HTC Lexikon'                               => [ 'HTC', 'Merge' ],
        'HTC One SC'                                => [ 'HTC', 'One SC' ],
        'HTC One SC T528d'                          => [ 'HTC', 'One SC' ],
        'HTC T528d'                                 => [ 'HTC', 'One SC' ],
        'HTC T528t'                                 => [ 'HTC', 'One ST' ],
        'HTC T528w'                                 => [ 'HTC', 'One SU' ],
        'HTC One Su'                                => [ 'HTC', 'One SU' ],
        'HTC One ?SV!'                              => [ 'HTC', 'One SV' ],
        'HTC C525c'                                 => [ 'HTC', 'One SV' ],
        'HTC C525u'                                 => [ 'HTC', 'One SV' ],
        'HTC H3000C'                                => [ 'HTC', 'One SV' ],
        'HTC K2!'                                   => [ 'HTC', 'One SV' ],
        'HTC One S'                                 => [ 'HTC', 'One S' ],
        'HTC One S !'                               => [ 'HTC', 'One S' ],
        'HTC Ville!'                                => [ 'HTC', 'One S' ],
        'HTC Z(52|56)0e!'                           => [ 'HTC', 'One S' ],
        'HTC One VX'                                => [ 'HTC', 'One VX' ],
        'htc totem'                                 => [ 'HTC', 'One VX' ],
        'HTC PM36100'                               => [ 'HTC', 'One VX' ],
        'HTC One V'                                 => [ 'HTC', 'One V' ],
        'HTC T120C'                                 => [ 'HTC', 'One V' ],
        'HTC T320e'                                 => [ 'HTC', 'One V' ],
        'HTC H2000C'                                => [ 'HTC', 'One V' ],
        'htc primou'                                => [ 'HTC', 'One V' ],
        'HTC X720d'                                 => [ 'HTC', 'One XC' ],
        'HTC ?One ?XL+!'                            => [ 'HTC', 'One XL+' ],
        'HTC ?One ?XL!'                             => [ 'HTC', 'One XL' ],
        'htc evita'                                 => [ 'HTC', 'One XL' ],
        'HTC S720t!'                                => [ 'HTC', 'One XT' ],
        'HTC One X+'                                => [ 'HTC', 'One X+' ],
        'HTC OneXplus!'                             => [ 'HTC', 'One X+' ],
        'HTC PM63100'                               => [ 'HTC', 'One X+' ],
        'HTC ?One ?X!'                              => [ 'HTC', 'One X' ],
        'HTC Endeavour!'                            => [ 'HTC', 'One X' ],
        'HTC S720e'                                 => [ 'HTC', 'One X' ],
        'HTC One X S720e'                           => [ 'HTC', 'One X' ],
        'HTC One X with Beats Audio'                => [ 'HTC', 'One X' ],
        'HTC M7'                                    => [ 'HTC', 'One' ],
        'HTC 801e'                                  => [ 'HTC', 'One' ],
        'HTC 801s'                                  => [ 'HTC', 'One' ],
        'HTC ?802d!'                                => [ 'HTC', 'One' ],
        'HTC ?802t!'                                => [ 'HTC', 'One' ],
        'HTC 802w'                                  => [ 'HTC', 'One' ],
        'HTC PN071'                                 => [ 'HTC', 'One' ],
        'HTC PN072'                                 => [ 'HTC', 'One' ],
        'HTC PN0711'                                => [ 'HTC', 'One' ],
        'HTC PN07120'                               => [ 'HTC', 'One' ],
        'HTC PN07310'                               => [ 'HTC', 'One' ],
        'HTC HTC6500LVW'                            => [ 'HTC', 'One' ],
        'HTC6500LVW'                                => [ 'HTC', 'One' ],
        'HTC6500LVW 4G'                             => [ 'HTC', 'One' ],
        'HTC6445LVW 4G'                             => [ 'HTC', 'One' ],
        'HTC One 801e'                              => [ 'HTC', 'One' ],
        'HTC One 801s'                              => [ 'HTC', 'One' ],
        'HTC one 802d'                              => [ 'HTC', 'One' ],
        'HTC One dual'                              => [ 'HTC', 'One' ],
        'HTC One dual 802d'                         => [ 'HTC', 'One' ],
        'HTC One dual sim'                          => [ 'HTC', 'One' ],
        'HTCONE'                                    => [ 'HTC', 'One' ],
        'HTC6515LVW'                                => [ 'HTC', 'One Remix' ],
        'HTC 601e'                                  => [ 'HTC', 'One Mini' ],
        'HTC PO581'                                 => [ 'HTC', 'One Mini' ],
        'HTC PO582'                                 => [ 'HTC', 'One Mini' ],
        'HTC PO58220'                               => [ 'HTC', 'One Mini' ],
        'HTC One mini'                              => [ 'HTC', 'One Mini' ],
        'HTC One mini 601e'                         => [ 'HTC', 'One Mini' ],
        'HTC 809d'                                  => [ 'HTC', 'One Max' ],
        'HTC 8060'                                  => [ 'HTC', 'One Max' ],
        'HTC 8088'                                  => [ 'HTC', 'One Max' ],
        'HTC 8160'                                  => [ 'HTC', 'One Max' ],
        'HTC ?0P3P[0-9]!'                           => [ 'HTC', 'One Max' ],
        'HTC6600LVW'                                => [ 'HTC', 'One Max' ],
        'HTC6600LVW 4G'                             => [ 'HTC', 'One Max' ],
        'HTC One max'                               => [ 'HTC', 'One Max' ],
        'HTC One max dual'                          => [ 'HTC', 'One Max' ],
        'HTC One A9'                                => [ 'HTC', 'One (A9)' ],
        'HTC A9'                                    => [ 'HTC', 'One (A9)' ],
        'HTC A9(u|w)!'                              => [ 'HTC', 'One (A9)' ],
        'HTC 2PQ910'                                => [ 'HTC', 'One (A9)' ],
        'HTC 2PQ912!'                               => [ 'HTC', 'One (A9)' ],
        'HTC One A9s'                               => [ 'HTC', 'One (A9s)' ],
        'HTC E9'                                    => [ 'HTC', 'One (E9)' ],
        'HTC One E9'                                => [ 'HTC', 'One (E9)' ],
        'HTC One E9 dual sim'                       => [ 'HTC', 'One (E9)' ],
        'HTC 0PL31'                                 => [ 'HTC', 'One (E9)' ],
        'HTCE9t'                                    => [ 'HTC', 'One (E9)' ],
        'HTC E9 Plus'                               => [ 'HTC', 'One (E9 Plus)' ],
        'HTC One E9PLUS dual sim'                   => [ 'HTC', 'One (E9 Plus)' ],
        'HTC One E9s'                               => [ 'HTC', 'One (E9s)' ],
        'HTC One E9s dual sim'                      => [ 'HTC', 'One (E9s)' ],
        'HTC D826sw'                                => [ 'HTC', 'One (E9s)' ],
        'HTC E9sx'                                  => [ 'HTC', 'One (E9s)' ],
        'HTC One M9'                                => [ 'HTC', 'One (M9)' ],
        'HTC One M9s'                               => [ 'HTC', 'One (M9)' ],
        'HTC 0PJA1!'                                => [ 'HTC', 'One (M9)' ],
        'HTC 0PJA2!'                                => [ 'HTC', 'One (M9)' ],
        'HTC6535LRA'                                => [ 'HTC', 'One (M9)' ],
        'HTC6535LVW'                                => [ 'HTC', 'One (M9)' ],
        'HTC M9(e|pt|px|u|w)!'                      => [ 'HTC', 'One (M9)' ],
        'HTC One M9PLUS'                            => [ 'HTC', 'One (M9 Plus)' ],
        'HTC One M9PLUS Prime Camera Edition'       => [ 'HTC', 'One (M9 Plus)' ],
        'HTC M9pw'                                  => [ 'HTC', 'One (M9 Plus)' ],
        'HTC 0PK71'                                 => [ 'HTC', 'One (M9 Plus)' ],
        'HTC 0PK72'                                 => [ 'HTC', 'One (M9 Plus)' ],
        'HTC X9u'                                   => [ 'HTC', 'One (X9)' ],
        'HTC 2PS5200'                               => [ 'HTC', 'One (X9)' ],
        'HTC 2PXH1'                                 => [ 'HTC', 'One (X10)' ],
        'HTC 2PXH2'                                 => [ 'HTC', 'One (X10)' ],
        'HTC 2PXH3'                                 => [ 'HTC', 'One (X10)' ],
        'HTC M9et'                                  => [ 'HTC', 'One ME' ],
        'HTC M9ew'                                  => [ 'HTC', 'One ME' ],
        'htc hima ace ml dtul'                      => [ 'HTC', 'One ME' ],
        'HTC One ME dual sim'                       => [ 'HTC', 'One ME' ],
        'HTC 0PLA1'                                 => [ 'HTC', 'One ME' ],
        'HTC One M8'                                => [ 'HTC', 'One (M8)' ],
        'HTC One M8 dual sim'                       => [ 'HTC', 'One (M8)' ],
        'HTC One(M8)'                               => [ 'HTC', 'One (M8)' ],
        'htc m8'                                    => [ 'HTC', 'One (M8)' ],
        'HTC M8(d|dug|e|si|t|v|w|x)!'               => [ 'HTC', 'One (M8)' ],
        'HTCM8t'                                    => [ 'HTC', 'One (M8)' ],
        'HTC6525LVW'                                => [ 'HTC', 'One (M8)' ],
        'HTC One M8 Eye'                            => [ 'HTC', 'One (M8 Eye)' ],
        'HTC M8(et|Et|Ew)!'                         => [ 'HTC', 'One (M8 Eye)' ],
        'HTCM8Et'                                   => [ 'HTC', 'One (M8 Eye)' ],
        'HTC 0P6B!'                                 => [ 'HTC', 'One (M8 Eye)' ],
        'htc melstuhl'                              => [ 'HTC', 'One (M8 Eye)' ],
        'HTC One M8s'                               => [ 'HTC', 'One (M8s)' ],
        'HTC 0PKV1'                                 => [ 'HTC', 'One (M8s)' ],
        'HTC One E8'                                => [ 'HTC', 'One (E8)' ],
        'HTC One E8 dual sim'                       => [ 'HTC', 'One (E8)' ],
        'HTC M8S(d|s|t|w|x|y)!'                     => [ 'HTC', 'One (E8)' ],
        'HTCM8St'                                   => [ 'HTC', 'One (E8)' ],
        'htc mecwhl'                                => [ 'HTC', 'One (E8)' ],
        'HTC 0PAJ1'                                 => [ 'HTC', 'One (E8)' ],
        'HTC 0PAJ2'                                 => [ 'HTC', 'One (E8)' ],
        'HTC 0PAJ4'                                 => [ 'HTC', 'One (E8)' ],
        'HTC E9(pw|pt|t|w|x)!'                      => [ 'HTC', 'One (E9)' ],
        'HTC One E9s dual sim'                      => [ 'HTC', 'One (E9)' ],
        'HTC 0P8B2!'                                => [ 'HTC', 'One Mini 2' ],
        'HTC M8MINx'                                => [ 'HTC', 'One Mini 2' ],
        'HTC One mini 2'                            => [ 'HTC', 'One Mini 2' ],
        'htc memul'                                 => [ 'HTC', 'One Mini 2' ],
        'HTC 10'                                    => [ 'HTC', '10' ],                     // a.k.a. HTC One (M10)
        'HTC m10'                                   => [ 'HTC', '10' ],                     // a.k.a. HTC One (M10)
        'HTC M10(h|u)!'                             => [ 'HTC', '10' ],                     // a.k.a. HTC One (M10)
        'HTC 2PS62'                                 => [ 'HTC', '10' ],                     // a.k.a. HTC One (M10)
        'HTC 2PS6200'                               => [ 'HTC', '10' ],                     // a.k.a. HTC One (M10)
        'HTC 2PS650'                                => [ 'HTC', '10' ],                     // a.k.a. HTC One (M10)
        'HTC6545LVW'                                => [ 'HTC', '10' ],                     // a.k.a. HTC One (M10)
        'HTC 10 evo'                                => [ 'HTC', '10 evo' ],
        'HTC Raider!'                               => [ 'HTC', 'Raider 4G' ],
        'HTC Holiday'                               => [ 'HTC', 'Raider 4G' ],
        'HTC X710(a|e|s)!'                          => [ 'HTC', 'Raider 4G' ],
        'HTC PH39100!'                              => [ 'HTC', 'Raider 4G' ],
        'HTCRaider'                                 => [ 'HTC', 'Raider 4G' ],
        'HTC Rezound'                               => [ 'HTC', 'Rezound' ],
        'HTC Rhyme!'                                => [ 'HTC', 'Rhyme' ],
        'HTC Bliss!'                                => [ 'HTC', 'Rhyme' ],
        'HTC S510b'                                 => [ 'HTC', 'Rhyme' ],
        'HTC Salsa!'                                => [ 'HTC', 'Salsa' ],
        'HTC C510e'                                 => [ 'HTC', 'Salsa' ],
        'HTC Sensation.*XE!'                        => [ 'HTC', 'Sensation XE' ],
        'HTC .*Z715(a|e)!'                          => [ 'HTC', 'Sensation XE' ],
        'HTC Sensation.*XL!'                        => [ 'HTC', 'Sensation XL' ],
        'HTC Runnymede'                             => [ 'HTC', 'Sensation XL' ],
        'HTC .*X315(b|e)!'                          => [ 'HTC', 'Sensation XL' ],
        'HTC G21!'                                  => [ 'HTC', 'Sensation XL' ],
        'HTC ?Sensation!'                           => [ 'HTC', 'Sensation' ],
        'HTC Pyramid!'                              => [ 'HTC', 'Sensation' ],
        'HTC .*Z710(a|e|t)?!'                       => [ 'HTC', 'Sensation' ],
        'HTC G14!'                                  => [ 'HTC', 'Sensation' ],
        'HTC Tattoo!'                               => [ 'HTC', 'Tattoo' ],
        'HTC Click'                                 => [ 'HTC', 'Tattoo' ],
        'HTC A3288'                                 => [ 'HTC', 'Tattoo' ],
        'HTC A9188'                                 => [ 'HTC', 'Tianxi' ],
        'HTC X310e'                                 => [ 'HTC', 'Titan' ],
        'HTC ETERNITY'                              => [ 'HTC', 'Titan' ],
        'HTC Polaris'                               => [ 'HTC', 'Touch Cruise' ],
        'HTC TOUCH DUAL'                            => [ 'HTC', 'Touch Dual' ],
        'HTC DiamondII EX'                          => [ 'HTC', 'Touch Diamond II' ],
        'HTC T7373'                                 => [ 'HTC', 'Touch Pro II' ],
        'HTC Touch Pro'                             => [ 'HTC', 'Touch Pro' ],
        'HTC ThunderBolt( 4G)?!'                    => [ 'HTC', 'ThunderBolt'],
        'HTC Mecha'                                 => [ 'HTC', 'ThunderBolt'],
        'HTC Kaiser'                                => [ 'HTC', 'TyTN II'],
        'HTC U Play'                                => [ 'HTC', 'U Play'],
        'HTC 2PZM3'                                 => [ 'HTC', 'U Play'],
        'HTC U Ultra'                               => [ 'HTC', 'U Ultra'],
        'HTC U-1w'                                  => [ 'HTC', 'U Ultra'],
        'HTC 2PZF1'                                 => [ 'HTC', 'U Ultra'],
        'HTC U11'                                   => [ 'HTC', 'U11'],
        'HTC U-3w '                                 => [ 'HTC', 'U11'],
        'HTC 2PZC100'                               => [ 'HTC', 'U11'],
        'HTC Velocity!'                             => [ 'HTC', 'Velocity 4G'],
        'HTCVelocity 4G'                            => [ 'HTC', 'Velocity 4G'],
        'HTC Vivid'                                 => [ 'HTC', 'Vivid'],
        'HTC ?Wildfire ?S!'                         => [ 'HTC', 'Wildfire S' ],
        'HTC .*A510(a|b|c|e)!'                      => [ 'HTC', 'Wildfire S' ],
        'HTC ?PG762!'                               => [ 'HTC', 'Wildfire S' ],
        'HTC Wildfire!'                             => [ 'HTC', 'Wildfire' ],
        'HTC Buzz!'                                 => [ 'HTC', 'Wildfire' ],
        'HTC .*A33(33|35|66|80)!'                   => [ 'HTC', 'Wildfire' ],
        'HTC A3360'                                 => [ 'HTC', 'Wildfire' ],
        'HTC A6390'                                 => [ 'HTC', 'A6390' ],
        'HTC A8180'                                 => [ 'HTC', 'A8180' ],
        'HTC S610d'                                 => [ 'HTC', 'S610d' ],
        'HTC S715e'                                 => [ 'HTC', 'S715e' ],
        'HTC T327d'                                 => [ 'HTC', 'T327d' ],
        'HTC T327t'                                 => [ 'HTC', 'T327t' ],
        'HTC T329t'                                 => [ 'HTC', 'T329t' ],
        'HTC Z510d'                                 => [ 'HTC', 'Z510d' ],
        'HTC PO681'                                 => [ 'HTC', 'Droid DNA 2' ],
        'HTC PO682'                                 => [ 'HTC', 'Butterfly S' ],
        'HTC GOF U'                                 => [ 'HTC', 'Desire C' ],
        'HTC VLE U'                                 => [ 'HTC', 'One S' ],
        'HTC VLE#U'                                 => [ 'HTC', 'One S' ],
        'HTC VIE U'                                 => [ 'HTC', 'One S' ],
        'HTC K2 UL'                                 => [ 'HTC', 'One SV' ],
        'HTC Droid DNA'                             => [ 'HTC', 'Droid DNA' ],
        'HTC6435LRA'                                => [ 'HTC', 'Droid DNA' ],
        'HTC6435LVW!'                               => [ 'HTC', 'Droid DNA' ],
        'HTC Droid Incredible'                      => [ 'HTC', 'Droid Incredible' ],
        'HTC IncredibleC'                           => [ 'HTC', 'Droid Incredible' ],
        'HTC Droid Incredible 2'                    => [ 'HTC', 'Droid Incredible 2' ],
        'HTC EVA UTL'                               => [ 'HTC', 'One X' ],
        'HTC EVA UL'                                => [ 'HTC', 'One X' ],
        'HTC ENR U'                                 => [ 'HTC', 'One X' ],
        'HTC EVARE UL'                              => [ 'HTC', 'One X+' ],
        'HTC ENRC2B'                                => [ 'HTC', 'One X+' ],
        'HTC 9089'                                  => [ 'HTC', '9089' ],                                           // COS
        'HTC ?909d!'                                => [ 'HTC', '909d' ],                                           // COS
    ],

    'DLX'                                       => [ 'HTC', 'Droid DNA' ],
    'DLXU'                                      => [ 'HTC', 'Butterfly' ],
    'ENR U'                                     => [ 'HTC', 'One X' ],

    'Amaze 4G'                                  => [ 'HTC', 'Amaze 4G' ],
    'Liberty'                                   => [ 'HTC', 'Aria' ],
    'Butterfly S'                               => [ 'HTC', 'Butterfly S' ],
    'desire200'                                 => [ 'HTC', 'Desire 200' ],
    'Desire 310 dual sim'                       => [ 'HTC', 'Desire 310' ],
    'Desire 500'                                => [ 'HTC', 'Desire 500' ],
    'Desire 500 Plus'                           => [ 'HTC', 'Desire 500' ],
    'Desire 510'                                => [ 'HTC', 'Desire 510' ],
    'Desire 610'                                => [ 'HTC', 'Desire 610' ],
    'Desire 619d'                               => [ 'HTC', 'Desire 619d' ],
    'Desire 816'                                => [ 'HTC', 'Desire 816' ],
    'Desire 816 dual sim'                       => [ 'HTC', 'Desire 816' ],
    'Desire ?HD!'                               => [ 'HTC', 'Desire HD' ],
    'Inspire HD'                                => [ 'HTC', 'Desire HD' ],
    'desirec'                                   => [ 'HTC', 'Desire C' ],
    'Desire L by HTC'                           => [ 'HTC', 'Desire L' ],
    'Desire ?S!'                                => [ 'HTC', 'Desire S' ],
    'Desire X'                                  => [ 'HTC', 'Desire X' ],
    'Desire Z'                                  => [ 'HTC', 'Desire Z' ],
    'Desire!'                                   => [ 'HTC', 'Desire' ],
    'Dream'                                     => [ 'HTC', 'Dream' ],
    'GinDream/GinMagic'                         => [ 'HTC', 'Dream' ],
    'SiRF Dream'                                => [ 'HTC', 'Dream' ],
    'Eris'                                      => [ 'HTC', 'Droid Eris' ],
    'Droid Incredible'                          => [ 'HTC', 'Droid Incredible' ],
    'Incredible'                                => [ 'HTC', 'Droid Incredible' ],   /* Verizon */
    'Incredible 2'                              => [ 'HTC', 'Droid Incredible 2' ], /* Verizon */
    'EVO'                                       => [ 'HTC', 'EVO' ],
    'Evo HD2'                                   => [ 'HTC', 'EVO HD' ],
    'EVO ?3D!'                                  => [ 'HTC', 'EVO 3D' ],
    'EVO 4G'                                    => [ 'HTC', 'EVO 4G' ],
    'Evo V 4G'                                  => [ 'HTC', 'EVO V 4G' ],
    'Explorer A310e'                            => [ 'HTC', 'Explorer' ],
    'Flyer'                                     => [ 'HTC', 'Flyer', DeviceType::TABLET ],
    'photon'                                    => [ 'HTC', 'HD mini' ],
    'HD2'                                       => [ 'HTC', 'HD2' ],
    'NexusHD2'                                  => [ 'HTC', 'HD2' ],
    'Nexus HD2'                                 => [ 'HTC', 'HD2' ],
    'HD2 LEO'                                   => [ 'HTC', 'HD2' ],
    'HD7  Pro'                                  => [ 'HTC', 'HD7 Pro' ],
    'Hero'                                      => [ 'HTC', 'Hero' ],
    'HERO CDMA'                                 => [ 'HTC', 'Hero' ],
    'HERO200'                                   => [ 'HTC', 'Hero 200' ],
    'Incredible ?S!'                            => [ 'HTC', 'Incredible S' ],
    'Incredible ?2!'                            => [ 'HTC', 'Incredible 2' ],
    'Incredible 4G LTE'                         => [ 'HTC', 'Incredible' ],
    'Inspire 4G'                                => [ 'HTC', 'Inspire 4G' ],
    'Legend'                                    => [ 'HTC', 'Legend' ],
    'Docomo HT-03A'                             => [ 'HTC', 'Magic HT-03A', 'carrier' => 'DoCoMo' ],
    'One S'                                     => [ 'HTC', 'One S' ],
    'One X'                                     => [ 'HTC', 'One X' ],
    'One X+'                                    => [ 'HTC', 'One X+' ],
    'One XL'                                    => [ 'HTC', 'One XL' ],
    'One V'                                     => [ 'HTC', 'One V' ],
    'One'                                       => [ 'HTC', 'One' ],
    'One M7'                                    => [ 'HTC', 'One' ],
    'EndeavorU'                                 => [ 'HTC', 'One X' ],
    '2PQ93'                                     => [ 'HTC', 'One (A9)' ],
    'one m8'                                    => [ 'HTC', 'One (M8)' ],
    'Rezound'                                   => [ 'HTC', 'Rezound' ],
    'MIUI.us Sensation 4G'                      => [ 'HTC', 'Sensation 4G' ],
    'SensationXE!'                              => [ 'HTC', 'Sensation XE' ],
    'SensationXL!'                              => [ 'HTC', 'Sensation XL' ],
    'Sensation XL with Beats Audio'             => [ 'HTC', 'Sensation XL' ],
    'Sensation!'                                => [ 'HTC', 'Sensation' ],
    'Pyramid'                                   => [ 'HTC', 'Sensation' ],
    'Touch Pro 2'                               => [ 'HTC', 'Touch Pro II' ],
    'TripNiCE Pyramid'                          => [ 'HTC', 'Sensation' ],
    'VitMod ExtraLite 1.6.5.fullodex for HTC HD7 Pro'       => [ 'HTC', 'HD7 Pro' ],
    'Vivid 4G'                                  => [ 'HTC', 'Vivid 4G' ],
    'Wildfire S!'                               => [ 'HTC', 'Wildfire S' ],
    'Wildfire!'                                 => [ 'HTC', 'Wildfire' ],
    'Click'                                     => [ 'HTC', 'Tattoo' ],

    'Sprint!!' => [
        'Sprint APX515CKT'                          => [ 'HTC', 'EVO 3D' ],
        'Sprint APA9292KT'                          => [ 'HTC', 'EVO 4G' ],
        'Sprint APA7373KT'                          => [ 'HTC', 'EVO Shift 4G' ],
        'Sprint APC715CKT'                          => [ 'HTC', 'EVO Design 4G' ],
        'Sprint ATP515CKIT'                         => [ 'HTC', 'EVO View 4G', DeviceType::TABLET ],
    ],

    '710C'                                      => [ 'HTC', 'Desire 816' ],
    '801a'                                      => [ 'HTC', 'One' ],
    '801s'                                      => [ 'HTC', 'One' ],
    '802w'                                      => [ 'HTC', 'One' ],
    '831C'                                      => [ 'HTC', 'One (M8)' ],
    '909d'                                      => [ 'HTC', '909d' ],                                           // COS
    '9088'                                      => [ 'HTC', '9088' ],                                           // COS

    'A320a'                                     => [ 'HTC', 'Desire C' ],
    'A3380'                                     => [ 'HTC', 'Wildfire' ],
    'A6277'                                     => [ 'HTC', 'Hero' ],
    'a7272'                                     => [ 'HTC', 'Desire Z' ],
    'A7272+(HTC DesireZ)'                       => [ 'HTC', 'Desire Z' ],
    'C525c'                                     => [ 'HTC', 'One SV' ],
    'D816(d|t|v|w|x)!'                          => [ 'HTC', 'Desire 816' ],
    'D816G'                                     => [ 'HTC', 'Desire 816G' ],
    'D820mt'                                    => [ 'HTC', 'Desire 820 Mini' ],
    'S710d'                                     => [ 'HTC', 'Droid Incredible 2' ],
    'S710D'                                     => [ 'HTC', 'Droid Incredible 2' ],
    'T320a'                                     => [ 'HTC', 'One V' ],
    'X325a'                                     => [ 'HTC', 'One X' ],
    'X515d'                                     => [ 'HTC', 'EVO 3D' ],
    'X515e'                                     => [ 'HTC', 'EVO 4G+' ],
    'X525a'                                     => [ 'HTC', 'One X+' ],
    'X710E'                                     => [ 'HTC', 'Raider 4G' ],
    'X920e'                                     => [ 'HTC', 'J Butterfly' ],
    'Z520e'                                     => [ 'HTC', 'One S' ],
    'Z520m'                                     => [ 'HTC', 'One S' ],
    'Z710'                                      => [ 'HTC', 'Sensation' ],
    'Z710e'                                     => [ 'HTC', 'Sensation' ],
    'Z715e'                                     => [ 'HTC', 'Sensation XE' ],
    'T9199h'                                    => [ 'HTC', 'T9199h' ],

    '(HTC|PCD|USCC)?ADR[0-9]{4,4}!!' => [
        'ADR6200'                                   => [ 'HTC', 'Droid Eris' ],
        'ADR6225'                                   => [ 'HTC', 'Wildfire 6225' ],
        'HTCADR6290US'                              => [ 'HTC', 'One V' ],
        'ADR6300'                                   => [ 'HTC', 'Droid Incredible' ],
        'ADR6325!'                                  => [ 'HTC', 'Merge' ],
        'ADR6330VW'                                 => [ 'HTC', 'Rhyme' ],
        'ADR6350'                                   => [ 'HTC', 'Droid Incredible 2' ],
        'ADR6400L!'                                 => [ 'HTC', 'Thunderbolt 4G' ],
        'ADR6410LRA!'                               => [ 'HTC', 'Droid Incredible 4G' ],
        'ADR6410LVW!'                               => [ 'HTC', 'Droid Incredible 4G' ],
        'ADR6410OM'                                 => [ 'HTC', 'Droid Incredible 4G' ],
        'ADR6425LVW!'                               => [ 'HTC', 'Rezound' ],
        'pcdadr6350'                                => [ 'HTC', 'Droid Incredible 2' ],
        'USCCADR6275US!'                            => [ 'HTC', 'Desire' ],
        'USCCADR6285US!'                            => [ 'HTC', 'Hero S' ],
        'USCCADR6325US!'                            => [ 'HTC', 'Merge' ],
        'USCCADR6230US!'                            => [ 'HTC', 'Wildfire S' ],
    ],

    'ERIS ADR6200'                              => [ 'HTC', 'Droid Eris' ],
    'ATP515CKIT'                                => [ 'HTC', 'EVO View 4G' ],
    'Coquettish Red'                            => [ 'HTC', 'Rezound' ],
    'PB99400'                                   => [ 'HTC', 'Desire' ],
    'PC36100!'                                  => [ 'HTC', 'EVO 4G' ],
    'PG06100'                                   => [ 'HTC', 'EVO Shift 4G' ],
    'PG41200'                                   => [ 'HTC', 'EVO View 4G', DeviceType::TABLET ],
    'PG86100!'                                  => [ 'HTC', 'EVO 3D' ],
    'PH44100'                                   => [ 'HTC', 'EVO Design 4G' ],
    'PJ83100'                                   => [ 'HTC', 'One X' ],
    'PJ35100'                                   => [ 'HTC', 'One VX' ],
    'PM36100'                                   => [ 'HTC', 'One VX' ],
    'PM63100'                                   => [ 'HTC', 'One X+' ],
    '0PCV1'                                     => [ 'HTC', 'Desire 510' ],
    '0PM92'                                     => [ 'HTC', 'Desire 626s' ],
    '0PJA1!'                                    => [ 'HTC', 'One (M9)' ],
    '0PJA2!'                                    => [ 'HTC', 'One (M9)' ],
    '0PKV1'                                     => [ 'HTC', 'One (M8s)' ],
    '0PAJ5'                                     => [ 'HTC', 'One (E8)' ],
    'M7CDTU'                                    => [ 'HTC', 'One' ],

    '[SX0][0-9]{2,2}HT!!' => [
        'S31HT'                                     => [ 'HTC', 'Aria S31HT', 'carrier' => 'EMOBILE' ],
        'X06HT'                                     => [ 'HTC', 'Desire X06HT', 'carrier' => 'Softbank' ],
        '001HT'                                     => [ 'HTC', 'Desire HD 001HT', 'carrier' => 'Softbank' ],
    ],

    'ISW[0-9]{2,2}HT!!' => [
        'ISW11HT!'                                  => [ 'HTC', 'EVO WiMAX ISW11HT', 'carrier' => 'au' ],
        'ISW12HT!'                                  => [ 'HTC', 'EVO 3D ISW12HT', 'carrier' => 'au' ],
        'ISW13HT!'                                  => [ 'HTC', 'J ISW13HT', 'carrier' => 'au' ],
    ],

    '(HTC )?HT[LV][0-9]{2,2}!!' => [
        'HTL21!'                                    => [ 'HTC', 'J Butterfly HTL21', 'carrier' => 'au' ],
        'HTL22'                                     => [ 'HTC', 'J One HTL22', 'carrier' => 'au' ],
        'HTC HTL22'                                 => [ 'HTC', 'J One HTL22', 'carrier' => 'au' ],
        'HTL23!'                                    => [ 'HTC', 'J Butterfly HTL23', 'carrier' => 'au' ],
        'HTV31!'                                    => [ 'HTC', 'J Butterfly HTV31', 'carrier' => 'au' ],
        'HTV32!'                                    => [ 'HTC', '10 HTV32', 'carrier' => 'au' ],
    ],

    'GT-T9500'                                  => [ 'HTM', 'GT-T9500' ],
    'SM-H900A'                                  => [ 'HTM', 'SM-H900A' ],
    'Z1-H39LW'                                  => [ 'HTM', 'Z1-H39LW' ],

    'Huawei MediaPad'                           => [ 'Huawei', 'MediaPad', DeviceType::TABLET ],
    'Huawei OsiMood MediaPad'                   => [ 'Huawei', 'MediaPad', DeviceType::TABLET ],
    'HUAWEI MediaPad M1 8.0'                    => [ 'Huawei', 'MediaPad M1', DeviceType::TABLET ],
    'Huawei MediaPad T1 7.0 3G'                 => [ 'Huawei', 'MediaPad T1', DeviceType::TABLET ],
    'Huawei MediaPad T1 8.0 4G'                 => [ 'Huawei', 'MediaPad T1', DeviceType::TABLET ],
    'Huawei MediaPad T1 10 4G'                  => [ 'Huawei', 'MediaPad T1', DeviceType::TABLET ],

    'MediaPad!!' => [
        'MediaPad'                                  => [ 'Huawei', 'MediaPad', DeviceType::TABLET ],
        'MediaPad 7 FHD'                            => [ 'Huawei', 'MediaPad 7', DeviceType::TABLET ],
        'MediaPad 7 Classic'                        => [ 'Huawei', 'MediaPad 7 Classic', DeviceType::TABLET ],
        'MediaPad 7 Lite'                           => [ 'Huawei', 'MediaPad 7 Lite', DeviceType::TABLET ],
        'MediaPad 7 Lite+'                          => [ 'Huawei', 'MediaPad 7 Lite+', DeviceType::TABLET ],
        'MediaPad 7 Lite II'                        => [ 'Huawei', 'MediaPad 7 Lite II', DeviceType::TABLET ],
        'MediaPad 7 Vivid'                          => [ 'Huawei', 'MediaPad 7 Vivid', DeviceType::TABLET ],
        'MediaPad 7 Vogue'                          => [ 'Huawei', 'MediaPad 7 Vogue', DeviceType::TABLET ],
        'MediaPad 7 Voguevivi'                      => [ 'Huawei', 'MediaPad 7 Vogue', DeviceType::TABLET ],
        'MediaPad 7 Youth'                          => [ 'Huawei', 'MediaPad 7 Youth', DeviceType::TABLET ],
        'MediaPad 7 Youth2'                         => [ 'Huawei', 'MediaPad 7 Youth 2', DeviceType::TABLET ],
        'MediaPad 7 Youth 2'                        => [ 'Huawei', 'MediaPad 7 Youth 2', DeviceType::TABLET ],
        'MediaPad 8 Vogue'                          => [ 'Huawei', 'MediaPad 8 Vogue', DeviceType::TABLET ],
        'MediaPad 10 FHD'                           => [ 'Huawei', 'MediaPad 10', DeviceType::TABLET ],
        'MediaPad 10 LINK'                          => [ 'Huawei', 'MediaPad 10 Link', DeviceType::TABLET ],
        'MediaPad 10 Link+'                         => [ 'Huawei', 'MediaPad 10 Link', DeviceType::TABLET ],
        'MediaPad M1 8.0'                           => [ 'Huawei', 'MediaPad M1', DeviceType::TABLET ],
        'MediaPad M1 8.0 (LTE)'                     => [ 'Huawei', 'MediaPad M1', DeviceType::TABLET ],
        'MediaPad M1 8.0 (WIFI)'                    => [ 'Huawei', 'MediaPad M1', DeviceType::TABLET ],
        'MediaPad T1 8.0'                           => [ 'Huawei', 'MediaPad T1', DeviceType::TABLET ],
        'MediaPad T1 8.0 LTE'                       => [ 'Huawei', 'MediaPad T1', DeviceType::TABLET ],
        'MediaPad T1 8.0 Pro'                       => [ 'Huawei', 'MediaPad T1 Pro', DeviceType::TABLET ],
        'MediaPad X1 7.0'                           => [ 'Huawei', 'MediaPad X1', DeviceType::TABLET ],
        'MediaPad X1'                               => [ 'Huawei', 'MediaPad X1', DeviceType::TABLET ],
        'MediaPad 7D'                               => [ 'Huawei', 'MediaPad X1', DeviceType::TABLET ],
        'MediaPad X1 S 7.0'                         => [ 'Huawei', 'MediaPad X1 S', DeviceType::TABLET ],
    ],

    '(Huawei )?[MSTX](1|2|7|8|10)\-[A-Z0-9][0-9]{2,2}!!' => [
        'Huawei S7-312u'                            => [ 'Huawei', 'MediaPad', DeviceType::TABLET ],
        'S7-721u'                                   => [ 'Huawei', 'MediaPad 7 Youth 2', DeviceType::TABLET ],
        'S10-232L'                                  => [ 'Huawei', 'MediaPad 10 Link', DeviceType::TABLET ],
        'S8-303L'                                   => [ 'Huawei', 'MediaPad M1', DeviceType::TABLET ],
        'S8-303LT'                                  => [ 'Huawei', 'MediaPad M1', DeviceType::TABLET ],
        'S8-306L'                                   => [ 'Huawei', 'MediaPad M1', DeviceType::TABLET ],
        'HUAWEI M2-A01L'                            => [ 'Huawei', 'MediaPad M2', DeviceType::TABLET ],
        'HUAWEI M2-A01W'                            => [ 'Huawei', 'MediaPad M2', DeviceType::TABLET ],
        'HUAWEI M2-801L'                            => [ 'Huawei', 'MediaPad M2', DeviceType::TABLET ],
        'HUAWEI M2-801W'                            => [ 'Huawei', 'MediaPad M2', DeviceType::TABLET ],
        'Huawei M2-802L'                            => [ 'Huawei', 'MediaPad M2', DeviceType::TABLET ],
        'HUAWEI M2-803L'                            => [ 'Huawei', 'MediaPad M2', DeviceType::TABLET ],
        'S8-701u'                                   => [ 'Huawei', 'MediaPad T1', DeviceType::TABLET ],
        'T1-A21L'                                   => [ 'Huawei', 'MediaPad T1', DeviceType::TABLET ],
        'T1-A21w'                                   => [ 'Huawei', 'MediaPad T1', DeviceType::TABLET ],
        'T1-A22L'                                   => [ 'Huawei', 'MediaPad T1', DeviceType::TABLET ],
        'T1-A23L'                                   => [ 'Huawei', 'MediaPad T1', DeviceType::TABLET ],
        'T1-701u'                                   => [ 'Huawei', 'MediaPad T1', DeviceType::TABLET ],
        'T1-701ua'                                  => [ 'Huawei', 'MediaPad T1', DeviceType::TABLET ],
        'T1-701w'                                   => [ 'Huawei', 'MediaPad T1', DeviceType::TABLET ],
        'T1-821w'                                   => [ 'Huawei', 'MediaPad T1', DeviceType::TABLET ],
        'T1-821L'                                   => [ 'Huawei', 'MediaPad T1', DeviceType::TABLET ],
        'T1-823L'                                   => [ 'Huawei', 'MediaPad T1', DeviceType::TABLET ],
        'S8-701w'                                   => [ 'Huawei', 'MediaPad T1', DeviceType::TABLET ],
        'S8-821w'                                   => [ 'Huawei', 'MediaPad T1', DeviceType::TABLET ],
    ],

    'T1 7.0'                                    => [ 'Huawei', 'MediaPad T1', DeviceType::TABLET ],
    'X1 7.0'                                    => [ 'Huawei', 'MediaPad X1', DeviceType::TABLET ],
    '7D-501u'                                   => [ 'Huawei', 'MediaPad X1', DeviceType::TABLET ],
    'HUAWEI GEM-703L'                           => [ 'Huawei', 'MediaPad X2', DeviceType::TABLET ],
    'PLE-703L'                                  => [ 'Huawei', 'MediaPad T2', DeviceType::TABLET ],
    'FDR-A01w'                                  => [ 'Huawei', 'MediaPad T2', DeviceType::TABLET ],
    'BGO-DL09'                                  => [ 'Huawei', 'MediaPad T2', DeviceType::TABLET ],
    'KOB-(L09|W09)!'                            => [ 'Huawei', 'MediaPad T3', DeviceType::TABLET ],
    'CPN-(W09|AL00)!'                           => [ 'Huawei', 'MediaPad M3 Lite', DeviceType::TABLET ],
    'BAH-(W09|AL00)!'                           => [ 'Huawei', 'MediaPad M3 Lite', DeviceType::TABLET ],

    '(HUAWEI )?(CRR|LON|MATE|MHA|MT1|MT2|MT7|M200|NXT|Z100)!!' => [
        '(HW-|HUAWEI )?MT1-(T00|U06)!'                                  => [ 'Huawei', 'Ascend Mate' ],
        '(HW-|HUAWEI )?MATE-U06!'                                       => [ 'Huawei', 'Ascend Mate' ],
        '(HW-|HUAWEI )?MT2-?(C00|L01|L02|L03|L05)!'                     => [ 'Huawei', 'Ascend Mate 2' ],
        '(HW-|HUAWEI )?MT7-(L09|J1|CL00|TL00|TL10|UL00)!'               => [ 'Huawei', 'Ascend Mate 7' ],
        '(HW-|HUAWEI )?Z100-(L09|TL00|TL10)!'                           => [ 'Huawei', 'Ascend Mate 7' ],
        '(HW-|HUAWEI )?NXT-(AL10|CL00|DL00|L09|L29|TL00|UL00|UL10)!'    => [ 'Huawei', 'Mate 8' ],
        '(HW-|HUAWEI )?M200-(UL00)!'                                    => [ 'Huawei', 'Mate 8' ],
        '(HW-|HUAWEI )?MHA-(AL00)!'                                     => [ 'Huawei', 'Mate 9' ],
        '(HW-|HUAWEI )?LON-(AL00|L29)!'                                 => [ 'Huawei', 'Mate 9 Pro' ],
        '(HW-|HUAWEI )?CRR-(L09|CL00|CL20|TL00|UL00|UL20)!'             => [ 'Huawei', 'Mate S' ],
    ],

    '(HW-|HUAWEI )?(TIT|TAG|NCE|TRT|SLA)!!' => [
        '(HW-|HUAWEI )?TIT-(AL00|CL00|CL10|L01|TL00|U02)!'              => [ 'Huawei', 'Enjoy 5' ],
        '(HW-|HUAWEI )?TAG-(AL00|CL00|L13|TL00)!'                       => [ 'Huawei', 'Enjoy 5S' ],
        '(HW-|HUAWEI )?NCE-(AL00|AL10)!'                                => [ 'Huawei', 'Enjoy 6' ],
        '(HW-|HUAWEI )?SLA-(TL10)!'                                     => [ 'Huawei', 'Enjoy 7' ],
        '(HW-|HUAWEI )?TRT-(TL10)!'                                     => [ 'Huawei', 'Enjoy 7 Plus' ],
    ],

    '(HW-|HUAWEI |HONOR )?(ATH|BLN|CHE|CHM|EDI|FRD|HN3|H30|H60|HOL|KIW|NEM|NMO|PE|PLK|SCL|KNT|CAM|STF)!!' => [
        'H30 U10'                                                       => [ 'Huawei', 'Honor 3C' ],
        '(HW-|HUAWEI )?HN3-(U00|U01)!'                                  => [ 'Huawei', 'Honor 3' ],
        '(HW-|HUAWEI |HONOR )?H30[- ](C00|L01|L02|T00|T10|U10)!'        => [ 'Huawei', 'Honor 3C' ],
        '(HW-|HUAWEI )?HOL-(T00|U10|U19|U40)!'                          => [ 'Huawei', 'Honor 3C' ],
        '(HW-|HUAWEI )?CHM-(CL00|TL00H|TL00|U01|UL00)!'                 => [ 'Huawei', 'Honor Play 4C' ],
        '(HW-|HUAWEI )?SCL-(L01|L02|L03|L04|L21|L32|L001|L004|AL00|CL00|TL00|TL00H|TL10|U23|U31)!'    => [ 'Huawei', 'Honor 4A' ],
        '(HW-|HUAWEI )?CHE-(TL00|TL00H)!'                               => [ 'Huawei', 'Honor 4X' ],
        '(HW-|HUAWEI )?Che1-(L04|CL10|CL20)!'                           => [ 'Huawei', 'Honor 4X' ],
        '(HW-|HUAWEI )?Che2-(L11|L12|L23|TL00|UL00)!'                   => [ 'Huawei', 'Honor 4X' ],
        '(HW-|HUAWEI )?NEM-(AL10|L21|L22|L51|TL00|TL00H|UL10)!'         => [ 'Huawei', 'Honor 5C' ],
        '(HW-|HUAWEI )?NMO-(L23|L31)!'                                  => [ 'Huawei', 'Honor 5C' ],
        '(HW-|HUAWEI )?KIW-(AL10|CL00|L21|L22|L24|UL00|TL00|TL00H)!'    => [ 'Huawei', 'Honor 5X' ],
        '(HW-|HUAWEI )?H60-(J1|L01|L02|L03|L04|L11|L12|L21)!'           => [ 'Huawei', 'Honor 6' ],
        '(HW-|HUAWEI )?BLN-(AL10|AL20|L21|L22|L24|TL10)!'               => [ 'Huawei', 'Honor 6X' ],
        '(HW-|HUAWEI )?PE-(CL00|TL00|TL00M|TL10|TL20|UL00)!'            => [ 'Huawei', 'Honor 6 Plus' ],
        '(HW-|HUAWEI )?PLK-(L01|AL10|CL00|UL00|TL00|TL01H)!'            => [ 'Huawei', 'Honor 7' ],
        '(HW-|HUAWEI )?ATH-(AL00|CL00|TL00|TL00H|UL00)!'                => [ 'Huawei', 'Honor 7i' ],
        '(HW-|HUAWEI )?FRD-(AL00|AL10|DL00|L02|L04|L09|L14|L19)!'       => [ 'Huawei', 'Honor 8' ],
        '(HW-|HUAWEI )?ATH-(UL01|UL06)!'                                => [ 'Huawei', 'Honor ShotX' ],
        '(HW-|HUAWEI )?KNT-(AL10|AL20|TL10|UL10)!'                      => [ 'Huawei', 'Honor V8' ],
        '(HW-|HUAWEI )?EDI-(AL10)!'                                     => [ 'Huawei', 'Honor Note 8' ],
        '(HW-|HUAWEI )?STF-(AL00|AL10|L09|TL10)!'                       => [ 'Huawei', 'Honor 9' ],
    ],

    '(HW-|HUAWEI )?(CHC|TAG|KII)!!' => [
        '(HW-|HUAWEI )?CHC-(U01|U03|U23)!'                              => [ 'Huawei', 'G Play Mini' ],
        '(HW-|HUAWEI )?TAG-(L01|L03|L21|L22|L23|L32)!'                  => [ 'Huawei', 'GR3' ],
        '(HW-|HUAWEI )?KII-(L03|L05|L21|L22|L23|L33)!'                  => [ 'Huawei', 'GR5' ],
    ],

    '(HW-|HUAWEI )?(ALE|D2|DAV|EVA|G6|G7|GRA|M100|P2|P6|P7|PRA|RIO|SC|Sophia|VIE|VKY|VNS|VTR|WAS)!!' => [
        'HUAWEI D2'                                                     => [ 'Huawei', 'Ascend D2' ],
        '(HW-|HUAWEI )?D2-(0082|2010|5000|6070|6114)!'                  => [ 'Huawei', 'Ascend D2' ],
        '(HW-|HUAWEI )?G6-(C00|L11|L22|L33|T00|U00|U10|U34|U251)!'      => [ 'Huawei', 'Ascend G6' ],
        '(HW-|HUAWEI )?G7-(L01|L02|L03|L11|TL00|UL20)!'                 => [ 'Huawei', 'Ascend G7' ],
        'HUAWEI G7'                                                     => [ 'Huawei', 'Ascend G7' ],
        '(HW-|HUAWEI )?RIO-(L01|L02|L03|AL00|UL00|CL00|TL00)!'          => [ 'Huawei', 'Ascend G8' ],
        '(HW-|HUAWEI )?SC-(CL00|UL10)!'                                 => [ 'Huawei', 'Ascend GX1' ],
        '(HW-|HUAWEI )?P2-(0000|6011|6070)!'                            => [ 'Huawei', 'Ascend P2' ],
        '(HW-|HUAWEI )?P6-(C00|U00|U06|T00|T00V|VIP)!'                  => [ 'Huawei', 'Ascend P6' ],
        '(HW-|HUAWEI )?P6 ?S-U06!'                                      => [ 'Huawei', 'Ascend P6' ],
        '(HW-|HUAWEI )?Sophia-(L07|L10)!'                               => [ 'Huawei', 'Ascend P7' ],
        '(HW-|HUAWEI )?P7-(L00|L01|L05|L07|L09|L10|L11|L12)!'           => [ 'Huawei', 'Ascend P7' ],
        '(HW-|HUAWEI )?M100-(CL00|L09|TL00|UL00)!'                      => [ 'Huawei', 'P8' ],
        '(HW-|HUAWEI )?GRA-(CL00|CL10|L09|TL00|UL00|UL10)!'             => [ 'Huawei', 'P8' ],
        '(HW-|HUAWEI )?ALE-?(L02|L04|L21|L23|CL00|TL00|UL00)!'          => [ 'Huawei', 'P8 Lite' ],
        '(HW-|HUAWEI )?PRA-?(AL00|LA1|LX1|LX2)!'                        => [ 'Huawei', 'P8 Lite (2017)' ],
        '(HW-|HUAWEI )?DAV-?(703L)!'                                    => [ 'Huawei', 'P8 Max' ],
        '(HW-|HUAWEI )?EVA-?(AL00|AL10|CL00|DL00|L09|L19|L29|TL00)!'    => [ 'Huawei', 'P9' ],
        '(HW-|HUAWEI )?VNS-?(AL00|DL00|L21|L22|L23|L31|L52|L53|L62|TL00)!'          => [ 'Huawei', 'P9 Lite' ],
        '(HW-|HUAWEI )?VIE-?(AL00|AL10|L09|L29)!'                       => [ 'Huawei', 'P9 Plus' ],
        '(HW-|HUAWEI )?VTR-?(AL00|L09|L29)!'                            => [ 'Huawei', 'P10' ],
        '(HW-|HUAWEI )?WAS-?(AL00|LX1|LX1A|LX2|LX2J|LX3|TL10)!'         => [ 'Huawei', 'P10 Lite' ],
        '(HW-|HUAWEI )?VKY-?(AL00|L09|L29)!'                            => [ 'Huawei', 'P10 Plus' ],
    ],

    '(HW-|HUAWEI )?(LUA|CUN|SCC|CAM|LYO)!!' => [
        '(HW-|HUAWEI )?LUA-(L01|L02|L03|L13|L21|L22|L23|U03|U22|U23)!'  => [ 'Huawei', 'Y3 II' ],
        '(HW-|HUAWEI )?CUN-(AL00|L01|L02|L03|L21|L22|L23||L33|TL00|U29)!'   => [ 'Huawei', 'Y5 II' ],
        '(HW-|HUAWEI )?SCC-(U21)!'                                      => [ 'Huawei', 'Y6' ],
        '(HW-|HUAWEI )?CAM-(L01|L03|L11|L21|L23|AL00|CL00|TL00)!'       => [ 'Huawei', 'Y6 II' ],
        '(HW-|HUAWEI )?LYO-(L01|L02|L21)!'                              => [ 'Huawei', 'Y6 II Compact' ],
    ],

    '(HW-|HUAWEI )?CAZ-(AL10|TL10)!'                => [ 'Huawei', 'Nova' ],
    '(HW-|HUAWEI )?CAN-(L01|L11)!'                  => [ 'Huawei', 'Nova' ],
    '(HW-|HUAWEI )?MLA-(L01|L03|L11|L12)!'          => [ 'Huawei', 'Nova Plus' ],
    '(HW-|HUAWEI )?MLA-(AL00|AL10)!'                => [ 'Huawei', 'Maimang 5' ],
    '(HW-|HUAWEI )?MLA-(TL00|TL10|UL00)!'           => [ 'Huawei', 'G9 Plus' ],

    'Huawei P7 mini'                                => [ 'Huawei', 'Ascend P7 mini' ],
    'Huawei P8max'                                  => [ 'Huawei', 'P8 Max' ],

    'G[0-9]{3,3}!!' => [
        'G350-U151'                                 => [ 'Huawei', 'Ascend G350' ],
        'G521-(L076|L176)!'                         => [ 'Huawei', 'Ascend G521' ],
        'G526-(L11|L22|L33)!'                       => [ 'Huawei', 'Ascend G526' ],
        'G527-(U081)!'                              => [ 'Huawei', 'Ascend G527' ],
        'G535-(L11)!'                               => [ 'Huawei', 'Ascend G535' ],
        'G610[ -](T00|T11|U00)!'                    => [ 'Huawei', 'Ascend G610' ],
        'G615-U10'                                  => [ 'Huawei', 'Ascend G615' ],
        'G616-T00'                                  => [ 'Huawei', 'Ascend G616' ],
        'G618'                                      => [ 'Huawei', 'Ascend G618' ],
        'G620-L75'                                  => [ 'Huawei', 'Ascend G620' ],
        'G620S-(L01|L02|L03|UL00)!'                 => [ 'Huawei', 'Ascend G620S' ],
        'G621-(TL00|TL00M)!'                        => [ 'Huawei', 'Ascend G621' ],
        'G629-(UL00)!'                              => [ 'Huawei', 'Ascend G629' ],
        'G630-(U00|U10|U20|U251)!'                  => [ 'Huawei', 'Ascend G630' ],
        'G735-(L03|L12|L23)!'                       => [ 'Huawei', 'Ascend G735' ],
        'G740-L00'                                  => [ 'Huawei', 'Ascend G740' ],
        'G750-(T00|T01)!'                           => [ 'Huawei', 'Ascend G750' ],
        'G760-(L01|TL00)!'                          => [ 'Huawei', 'Ascend G760' ],
    ],

    'Y[0-9]{3,3}!!' => [
        'Y220-(U00|U05|U10|U17)!'                   => [ 'Huawei', 'Ascend Y220' ],
        'Y220T'                                     => [ 'Huawei', 'Ascend Y220' ],
        'Y221-(U22)!'                               => [ 'Huawei', 'Ascend Y221' ],
        'Y301-(A1|A2)!'                             => [ 'Huawei', 'Valiant' ],
        'Y320-(U01|U10)!'                           => [ 'Huawei', 'Ascend Y320' ],
        'Y325-T00'                                  => [ 'Huawei', 'Ascend Y325' ],
        'Y330-U11'                                  => [ 'Huawei', 'Ascend Y330' ],
        'Y340-U081'                                 => [ 'Huawei', 'Ascend Y340' ],
        'Y511'                                      => [ 'Huawei', 'Ascend Y511' ],
        'Y511-(T00|U00|U30)!'                       => [ 'Huawei', 'Ascend Y511' ],
        'Y536A1'                                    => [ 'Huawei', 'Ascend Y536' ],
        'Y540-U01'                                  => [ 'Huawei', 'Ascend Y540' ],
        'Y541-U02'                                  => [ 'Huawei', 'Ascend Y541' ],
        'Y550-(L02|L03)!'                           => [ 'Huawei', 'Ascend Y550' ],
        'Y560-L01'                                  => [ 'Huawei', 'Ascend Y560' ],
        'Y600-U00'                                  => [ 'Huawei', 'Ascend Y600' ],
        'Y618-T00'                                  => [ 'Huawei', 'Ascend Y618' ],
        'Y635-(L01|L02|L03|L21|L22)!'               => [ 'Huawei', 'Ascend Y635' ],
    ],

    '(Huawei|Ascend|HW-)!!' => [
        'Huawei A199'                               => [ 'Huawei', 'A199' ],
        'Huawei B199'                               => [ 'Huawei', 'B199' ],
        'Huawei C199'                               => [ 'Huawei', 'C199' ],
        'HUAWEI C199s'                              => [ 'Huawei', 'C199s' ],
        'Huawei C8500!'                             => [ 'Huawei', 'C8500' ],
        'HUAWEI C8550!'                             => [ 'Huawei', 'C8550' ],
        'Huawei C8600'                              => [ 'Huawei', 'C8600' ],
        'HW-C8600!'                                 => [ 'Huawei', 'C8600' ],
        'Huawei C8650!'                             => [ 'Huawei', 'C8650' ],
        'Huawei C8655'                              => [ 'Huawei', 'Ascend Y201C' ],
        'Huawei C8800'                              => [ 'Huawei', 'IDEOS X5' ],
        'Huawei C8810!'                             => [ 'Huawei', 'Ascend G300' ],
        'Huawei C8812!'                             => [ 'Huawei', 'Ascend C8812' ],
        'Ascend C8812'                              => [ 'Huawei', 'Ascend C8812' ],
        'Huawei C8813!'                             => [ 'Huawei', 'Ascend C8813' ],
        'Ascend c8813'                              => [ 'Huawei', 'Ascend C8813' ],
        'Ascend C8813Q'                             => [ 'Huawei', 'Ascend C8813' ],
        'Huawei C8815!'                             => [ 'Huawei', 'Ascend C8815' ],
        'Huawei C8816!'                             => [ 'Huawei', 'Ascend C8816' ],
        'Huawei C8817!'                             => [ 'Huawei', 'C8817' ],
        'HW-C8817D!'                                => [ 'Huawei', 'C8817' ],
        'HUAWEI C8818!'                             => [ 'Huawei', 'C8818' ],
        'Huawei C8825D'                             => [ 'Huawei', 'Ascend G330C' ],
        'Huawei C8826D'                             => [ 'Huawei', 'Ascend G500C' ],
        'Huawei C8850'                              => [ 'Huawei', 'C8850' ],
        'Huawei C8860E'                             => [ 'Huawei', 'Honor' ],
        'Huawei C8950D'                             => [ 'Huawei', 'Honor+' ],
        'Huawei G7500'                              => [ 'Huawei', 'G7500' ],
        'Huawei CM990'                              => [ 'Huawei', 'Evolución 3' ],
        'Huawei Evolucion 3'                        => [ 'Huawei', 'Evolución 3' ],
        'Huawei H866C'                              => [ 'Huawei', 'H866C' ],
        'Huawei H867G'                              => [ 'Huawei', 'H867G' ],
        'Huawei H868C'                              => [ 'Huawei', 'Glory' ],
        'Huawei H870C'                              => [ 'Huawei', 'H870C' ],
        'Huawei H871G'                              => [ 'Huawei', 'Magna' ],
        'Huawei H881C'                              => [ 'Huawei', 'Ascend Plus' ],
        'HUAWEI H891L'                              => [ 'Huawei', 'Pronto' ],
        'HUAWEI H892L'                              => [ 'Huawei', 'Honor 4X' ],
        'Huawei M835'                               => [ 'Huawei', 'M835' ],
        'Huawei M860'                               => [ 'Huawei', 'Ascend' ],
        'Huawei M866'                               => [ 'Huawei', 'Ascend Y' ],
        'Huawei M868'                               => [ 'Huawei', 'M868' ],
        'HUAWEI M881'                               => [ 'Huawei', 'Asura' ],
        'Huawei M920'                               => [ 'Huawei', 'M920' ],
        'Huawei M921'                               => [ 'Huawei', 'M921' ],
        'Huawei M931'                               => [ 'Huawei', 'M931' ],
        'Ascend Mate 2'                             => [ 'Huawei', 'Ascend Mate 2' ],
        'Huawei S8520'                              => [ 'Huawei', 'S8520' ],
        'Huawei S8600'                              => [ 'Huawei', 'S8600' ],
        'Huawei T8100'                              => [ 'Huawei', 'T8100' ],
        'Huawei T8300'                              => [ 'Huawei', 'T8300' ],
        'Huawei ?T8500!'                            => [ 'Huawei', 'T8500' ],
        'Huawei T8600'                              => [ 'Huawei', 'T8600' ],
        'Huawei T8620'                              => [ 'Huawei', 'Ascend Y200T' ],
        'Huawei T8808D'                             => [ 'Huawei', 'Ascend G306T' ],
        'Huawei T8828'                              => [ 'Huawei', 'Ascend G305T' ],
        'Huawei T8830'                              => [ 'Huawei', 'Ascend G309T' ],
        'Huawei T8830 ?Pro!'                        => [ 'Huawei', 'Ascend G309T Pro' ],
        'Huawei T8833'                              => [ 'Huawei', 'Ascend Y300' ],
        'Huawei T8950!'                             => [ 'Huawei', 'Honor+' ],
        'Huawei T8951!'                             => [ 'Huawei', 'Ascend G510' ],
        'Huawei T9200'                              => [ 'Huawei', 'Ascend P1' ],
        'Huawei U8110'                              => [ 'Huawei', 'U8110' ],
        'Huawei U8160'                              => [ 'Huawei', 'U8160' ],
        'Huawei U8220'                              => [ 'Huawei', 'U8220' ],
        'Huawei ?U8300!'                            => [ 'Huawei', 'U8300' ],
        'Huawei ?U8500!'                            => [ 'Huawei', 'IDEOS X2' ],
        'Huawei ?U8520!'                            => [ 'Huawei', 'U8520 Duplex' ],
        'Huawei U8600'                              => [ 'Huawei', 'U8600' ],
        'Huawei ?U8650!'                            => [ 'Huawei', 'Sonic' ],
        'Huawei U8651'                              => [ 'Huawei', 'Prism' ],
        'Huawei U8652'                              => [ 'Huawei', 'Sonic' ],
        'Huawei U8661'                              => [ 'Huawei', 'Sonic+' ],
        'Huawei U8665'                              => [ 'Huawei', 'Fusion 2' ],
        'Huawei U8666!'                             => [ 'Huawei', 'Ascend Y201' ],
        'Huawei U8681'                              => [ 'Huawei', 'Ascend G312' ],
        'Huawei U8687'                              => [ 'Huawei', 'Chronos' ],
        'Huawei U8800!'                             => [ 'Huawei', 'IDEOS X5' ],
        'Huawei U8815!'                             => [ 'Huawei', 'Ascend G300' ],
        'Huawei U8818'                              => [ 'Huawei', 'Ascend G300' ],
        'Huawei U8825D'                             => [ 'Huawei', 'Ascend G330D' ],
        'Huawei U8825-1'                            => [ 'Huawei', 'Ascend G330' ],
        'HUAWEI G330-0100'                          => [ 'Huawei', 'Ascend G330' ],
        'Huawei u8833'                              => [ 'Huawei', 'Ascend Y300' ],
        'Huawei u8836d'                             => [ 'Huawei', 'Ascend G500' ],
        'Huawei U8850'                              => [ 'Huawei', 'Vision' ],
        'Huawei U8860'                              => [ 'Huawei', 'Honor' ],
        'Huawei Honor'                              => [ 'Huawei', 'Honor' ],
        'Huawei U8950!'                             => [ 'Huawei', 'Ascend G600' ],
        'HUAWEI U8951!'                             => [ 'Huawei', 'Ascend G510' ],
        'Huawei ?U9000!'                            => [ 'Huawei', 'Ascend X' ],
        'HUAWEI HONOR 2'                            => [ 'Huawei', 'Honor 2' ],
        'Huawei U9508'                              => [ 'Huawei', 'Honor 2' ],
        'Huawei ?U9508!'                            => [ 'Huawei', 'Honor 2 Quad-core' ],
        'Ascend D1'                                 => [ 'Huawei', 'Ascend D1' ],
        'Huawei U9510!'                             => [ 'Huawei', 'Ascend D quad' ],
        'Huawei EDGE'                               => [ 'Huawei', 'Ascend P6' ],
        'Huawei Ascend P6'                          => [ 'Huawei', 'Ascend P6' ],
        'Ascend P7'                                 => [ 'Huawei', 'Ascend P7' ],
        'Huawei Ideos X1'                           => [ 'Huawei', 'IDEOS X1' ],
        'Huawei IDEOS U8500'                        => [ 'Huawei', 'IDEOS X2' ],
        'Huawei IDEOS U8650'                        => [ 'Huawei', 'Sonic' ],
        'Huawei IDEOS X3'                           => [ 'Huawei', 'IDEOS X3' ],
        'Huawei Ideos X5!'                          => [ 'Huawei', 'IDEOS X5' ],
        'Huawei X6'                                 => [ 'Huawei', 'IDEOS X6' ],
        'Huawei IDEOS Y 200'                        => [ 'Huawei', 'IDEOS Y200' ],
        'Huawei SONIC'                              => [ 'Huawei', 'Sonic' ],
        'Huawei 8100-9'                             => [ 'Huawei', 'U8100' ],
        'Huawei UM840'                              => [ 'Huawei', 'UM840' ],
        'Huawei Ascend G 300'                       => [ 'Huawei', 'Ascend G300' ],
        'Huawei G300'                               => [ 'Huawei', 'Ascend G300' ],
        'Ascend G300'                               => [ 'Huawei', 'Ascend G300' ],
        'Ascend G301'                               => [ 'Huawei', 'Ascend G301' ],
        'Ascend G330'                               => [ 'Huawei', 'Ascend G330' ],
        'Huawei Ascend G 330'                       => [ 'Huawei', 'Ascend G330' ],
        'Huawei G350!'                              => [ 'Huawei', 'Ascend G350' ],
        'Huawei G506!'                              => [ 'Huawei', 'Ascend G506' ],
        'Huawei ?G510!'                             => [ 'Huawei', 'Ascend G510' ],
        'Ascend G510c'                              => [ 'Huawei', 'Ascend G510c' ],
        'Huawei Ascend G510'                        => [ 'Huawei', 'Ascend G510' ],
        'Ascend G510'                               => [ 'Huawei', 'Ascend G510' ],
        'Huawei G520!'                              => [ 'Huawei', 'Ascend G520' ],
        'HUAWEI G521!'                              => [ 'Huawei', 'Ascend G521' ],
        'Huawei G525!'                              => [ 'Huawei', 'Ascend G525' ],
        'HUAWEI Ascend G525'                        => [ 'Huawei', 'Ascend G525' ],
        'Huawei G535!'                              => [ 'Huawei', 'Ascend G535' ],
        'Ascend G600'                               => [ 'Huawei', 'Ascend G600' ],
        'Huawei G606!'                              => [ 'Huawei', 'Ascend G606' ],
        'Huawei G610!'                              => [ 'Huawei', 'Ascend G610' ],
        'Huawei G615!'                              => [ 'Huawei', 'Ascend G615' ],
        'HUAWEI G616!'                              => [ 'Huawei', 'Ascend G616' ],
        'Huawei G620!'                              => [ 'Huawei', 'Ascend G620' ],
        'Huawei G621!'                              => [ 'Huawei', 'Ascend G621' ],
        'Huawei G628!'                              => [ 'Huawei', 'Ascend G628' ],
        'Huawei G629!'                              => [ 'Huawei', 'Ascend G629' ],
        'Huawei G630!'                              => [ 'Huawei', 'Ascend G630' ],
        'HUAWEI G660!'                              => [ 'Huawei', 'Ascend G660' ],
        'Huawei G700!'                              => [ 'Huawei', 'Ascend G700' ],
        'Huawei G701!'                              => [ 'Huawei', 'Ascend G701' ],
        'Huawei ?G716!'                             => [ 'Huawei', 'Ascend G716' ],
        'Huawei G718!'                              => [ 'Huawei', 'Ascend G718' ],
        'Huawei G730!'                              => [ 'Huawei', 'Ascend G730' ],
        'Huawei G750!'                              => [ 'Huawei', 'Ascend G750' ],
        'Huawei G760-(L01|L071)!'                   => [ 'Huawei', 'Ascend G760' ],
        'Huawei G760S-(UL00)!'                      => [ 'Huawei', 'Ascend G760' ],
        'Huawei Ascend Y 210'                       => [ 'Huawei', 'Ascend Y210' ],
        'Huawei Ascend Y 210D'                      => [ 'Huawei', 'Ascend Y210' ],
        'Huawei Asend Y 210D'                       => [ 'Huawei', 'Ascend Y210' ],
        'Huawei Y210!'                              => [ 'Huawei', 'Ascend Y210' ],
        'Ascend Y201PRO'                            => [ 'Huawei', 'Ascend Y210 Pro' ],
        'Huawei Y ?220T!'                           => [ 'Huawei', 'Ascend Y220' ],
        'Huawei Y-220T'                             => [ 'Huawei', 'Ascend Y220' ],
        'Huawei Y220-(T10)!'                        => [ 'Huawei', 'Ascend Y220' ],
        'HUAWEI Y221-(U03|U12|U22|U33|U43|U53)!'    => [ 'Huawei', 'Ascend Y221' ],
        'Huawei ?Y300!'                             => [ 'Huawei', 'Ascend Y300' ],
        'Ascend Y300'                               => [ 'Huawei', 'Ascend Y300' ],
        'Huawei Ascend Y300'                        => [ 'Huawei', 'Ascend Y300' ],
        'Huawei Y301!'                              => [ 'Huawei', 'Ascend Y301' ],
        'Huawei Y310!'                              => [ 'Huawei', 'Ascend Y310' ],
        'Huawei Y320!'                              => [ 'Huawei', 'Ascend Y320' ],
        'Huawei Y321!'                              => [ 'Huawei', 'Ascend Y321' ],
        'Huawei Y325!'                              => [ 'Huawei', 'Ascend Y325' ],
        'Huawei Y330!'                              => [ 'Huawei', 'Ascend Y330' ],
        'HUAWEI Y336!'                              => [ 'Huawei', 'Ascend Y336' ],
        'HUAWEI Y360!'                              => [ 'Huawei', 'Ascend Y360' ],
        'Huawei Y500!'                              => [ 'Huawei', 'Ascend Y500' ],
        'Huawei Y511!'                              => [ 'Huawei', 'Ascend Y511' ],
        'Huawei Y516!'                              => [ 'Huawei', 'Ascend Y516' ],
        'Huawei Y518!'                              => [ 'Huawei', 'Ascend Y518' ],
        'HUAWEI Y520!'                              => [ 'Huawei', 'Ascend Y520' ],
        'Huawei Y523!'                              => [ 'Huawei', 'Ascend Y523' ],
        'Huawei Y530!'                              => [ 'Huawei', 'Ascend Y530' ],
        'HUAWEI Y535!'                              => [ 'Huawei', 'Ascend Y535' ],
        'HUAWEI Y536A1'                             => [ 'AT&T', 'Tribute' ],
        'HUAWEI Y536!'                              => [ 'Huawei', 'Ascend Y536' ],
        'HUAWEI Y540-(U01)!'                        => [ 'Huawei', 'Ascend Y540' ],
        'HUAWEI Y541!'                              => [ 'Huawei', 'Ascend Y541' ],
        'HUAWEI Y550'                               => [ 'Huawei', 'Ascend Y550' ],
        'HUAWEI Y550-(L01|L02|L03)!'                => [ 'Huawei', 'Ascend Y550' ],
        'HUAWEI Y552-(L02)!'                        => [ 'Huawei', 'Ascend Y552' ],
        'HUAWEI Y560-(CL00|L01|L02|L03|L23|U02|U03|U12|U23)!' => [ 'Huawei', 'Ascend Y560' ],
        'Huawei Y600-(U00|U20|U40|U151|U351)!'      => [ 'Huawei', 'Ascend Y600' ],
        'HUAWEI Y600D-C00'                          => [ 'Huawei', 'Ascend Y600D' ],
        'HUAWEI Y604-U155'                          => [ 'Huawei', 'Ascend Y604' ],
        'HUAWEI Y610-U00'                           => [ 'Huawei', 'Ascend Y610' ],
        'HUAWEI Y618-T00'                           => [ 'Huawei', 'Ascend Y618' ],
        'HUAWEI Y625-(U13|U21|U32|U43|U51)!'        => [ 'Huawei', 'Ascend Y625' ],
        'HUAWEI Y635!'                              => [ 'Huawei', 'Ascend Y635' ],
        'Huawei Ascend'                             => [ 'Huawei', 'Ascend' ],
        'Huawei Ascend X'                           => [ 'Huawei', 'Ascend X' ],
    ],

    'M650'                                      => [ 'Huawei', 'Express' ],
    'M660'                                      => [ 'Huawei', 'Ascend Q' ],
    'unknown M200-L09'                          => [ 'Huawei', 'Mate 8' ],
    'Honor3c2G-T'                               => [ 'Huawei', 'Honor 3C' ],
    'HUAWEI Honor 3c w'                         => [ 'Huawei', 'Honor 3C' ],
    'Orange HUAWEI GRA-L09'                     => [ 'Huawei', 'Ascend P8' ],
    'FUSIONideos'                               => [ 'Huawei', 'IDEOS' ],
    'Gnappo Ideos'                              => [ 'Huawei', 'IDEOS' ],
    'hwu8812D'                                  => [ 'Huawei', 'Ascend G302D' ],

    'IDEOS!!' => [
        'Ideos'                                     => [ 'Huawei', 'IDEOS' ],
        'IDEOS X1'                                  => [ 'Huawei', 'IDEOS X1' ],
        'IDEOS X5'                                  => [ 'Huawei', 'IDEOS X5' ],
        'IDEOS X5 PRO'                              => [ 'Huawei', 'IDEOS X5 Pro' ],
        'IDEOS S7!'                                 => [ 'Huawei', 'IDEOS S7', DeviceType::TABLET ],
    ],

    'Huawei S7'                                 => [ 'Huawei', 'IDEOS S7', DeviceType::TABLET ],
    'SONIC'                                     => [ 'Huawei', 'Sonic' ],
    'Lucky Ultra Sonic U8650'                   => [ 'Huawei', 'Sonic' ],
    'MTC Android'                               => [ 'Huawei', 'U8110' ],

    '[0-9AS][0-9]{2,2}HW!!' => [
        'A01HW'                                     => [ 'Huawei', 'A01HW', DeviceType::TABLET, 'carrier' => 'EMOBILE' ],
        'S31HW'                                     => [ 'Huawei', 'Pocket WiFi S S31HW', 'carrier' => 'EMOBILE' ],
        'S41HW'                                     => [ 'Huawei', 'Pocket WiFi S II S41HW', 'carrier' => 'EMOBILE' ],
        'S42HW'                                     => [ 'Huawei', 'smart bar S42HW', 'carrier' => 'EMOBILE' ],
        '007HW'                                     => [ 'Huawei', 'Vision 007HW', 'carrier' => 'Softbank' ],
        '201HW'                                     => [ 'Huawei', 'STREAM 201HW', 'carrier' => 'Softbank' ],
        '204HW'                                     => [ 'Huawei', '204HW', 'carrier' => 'Softbank' ],
        '301HW'                                     => [ 'Huawei', 'Pocket WiFi 301HW', 'carrier' => 'Softbank' ],
        '302HW'                                     => [ 'Huawei', 'STREAM S 302HW', 'carrier' => 'Y! Mobile' ],
        '402HW'                                     => [ 'Huawei', 'MediaPad 10 Link+ 402HW', DeviceType::TABLET, 'carrier' => 'Softbank' ],
        '403HW'                                     => [ 'Huawei', 'MediaPad M1 8.0 403HW', DeviceType::TABLET, 'carrier' => 'Y! Mobile' ],
        '503HW'                                     => [ 'Huawei', 'LUMIERE 503HW', 'carrier' => 'Y! Mobile' ],
    ],

    'CM980'                                     => [ 'Huawei', 'Evolution II' ],
    'CM990'                                     => [ 'Huawei', 'Evolución 3' ],
    'UM840'                                     => [ 'Huawei', 'Evolution' ],
    'M310'                                      => [ 'Huawei', 'MediaQ M310', DeviceType::TELEVISION ],
    'M860'                                      => [ 'Huawei', 'Ascend' ],
    'M865'                                      => [ 'Huawei', 'Ascend II' ],
    'M886'                                      => [ 'Huawei', 'Glory' ],
    'S8600'                                     => [ 'Huawei', 'S8600' ],

    'C8[0-9]{3,3}!!' => [
        'C8150'                                     => [ 'Huawei', 'IDEOS' ],
        'C8500!'                                    => [ 'Huawei', 'C8500' ],
        'C8600'                                     => [ 'Huawei', 'C8600' ],
        'C8650!'                                    => [ 'Huawei', 'C8650' ],
        'C8800'                                     => [ 'Huawei', 'C8800' ],
        'C8810'                                     => [ 'Huawei', 'Ascend G300C' ],
        'C8812!'                                    => [ 'Huawei', 'Ascend C8812' ],
        'C8815!'                                    => [ 'Huawei', 'Ascend C8815' ],
        'C8860!'                                    => [ 'Huawei', 'Honor' ],
    ],

    'T8[0-9]{3,3}!!' => [
        'T8620'                                     => [ 'Huawei', 'Ascend Y200T' ],
        'T8808!'                                    => [ 'Huawei', 'Ascend G306T' ],
        'T8830!'                                    => [ 'Huawei', 'Ascend G309T' ],
    ],

    'T9[0-9]{3,3}!!' => [
        'T9200'                                     => [ 'Huawei', 'Ascend P1' ],
        'T9510E'                                    => [ 'Huawei', 'Ascend D1 Quad XL' ],
    ],

    'U8[0-9]{3,3}!!' => [
        'U8100'                                     => [ 'Huawei', 'U8100' ],
        'U8110'                                     => [ 'Huawei', 'U8110' ],
        'U8120'                                     => [ 'Huawei', 'U8120' ],
        'U8180'                                     => [ 'Huawei', 'IDEOS X1' ],
        'U8300'                                     => [ 'Huawei', 'U8300' ],
        'U8350'                                     => [ 'Huawei', 'Boulder' ],
        'U8150'                                     => [ 'Huawei', 'IDEOS' ],
        'U8160'                                     => [ 'Huawei', 'U8160' ],
        'U8180'                                     => [ 'Huawei', 'IDEOS X1' ],
        'U8185'                                     => [ 'Huawei', 'Ascend Y100' ],
        'U8186'                                     => [ 'Huawei', 'Ascend Y101' ],
        'U8230'                                     => [ 'Huawei', 'U8230' ],
        'U8500'                                     => [ 'Huawei', 'IDEOS X2' ],
        'U8500 HiQQ'                                => [ 'Huawei', 'U8500 HiQQ Edition' ],
        'U8510!'                                    => [ 'Huawei', 'IDEOS X3' ],
        'U8520'                                     => [ 'Huawei', 'U8520 Duplex' ],
        'U8600'                                     => [ 'Huawei', 'U8600' ],
        'U8650!'                                    => [ 'Huawei', 'Sonic' ],
        'U8651!'                                    => [ 'Huawei', 'Talon U8651' ],
        'U8652!'                                    => [ 'Huawei', 'Fusion U8652' ],
        'U8655!'                                    => [ 'Huawei', 'Ascend Y200' ],
        'U8660'                                     => [ 'Huawei', 'Sonic' ],
        'U8665'                                     => [ 'Huawei', 'Fusion 2' ],
        'U8666!'                                    => [ 'Huawei', 'Ascend Y201' ],
        'U8667'                                     => [ 'Huawei', 'U8667' ],
        'U8800 ?Pro!'                               => [ 'Huawei', 'IDEOS X5 Pro' ],
        'U8800!'                                    => [ 'Huawei', 'IDEOS X5' ],
        'U8812'                                     => [ 'Huawei', 'Ascend G302D' ],
        'U8812D'                                    => [ 'Huawei', 'Ascend G302D' ],
        'U8815N'                                    => [ 'Huawei', 'Ascend G300' ],
        'U8815-51'                                  => [ 'Huawei', 'Ascend G300' ],
        'U8815'                                     => [ 'Huawei', 'Ascend G300' ],
        'U8816'                                     => [ 'Huawei', 'Ascend G301' ],
        'U8818'                                     => [ 'Huawei', 'Ascend G300' ],
        'U8820'                                     => [ 'Huawei', 'Titan' ],
        'U8832D'                                    => [ 'Huawei', 'Ascend G500' ],
        'U8836D'                                    => [ 'Huawei', 'Ascend G500' ],
        'U8850'                                     => [ 'Huawei', 'Vision' ],
        'U8860!'                                    => [ 'Huawei', 'Honor' ],
    ],

    'U9[0-9]{3,3}!!' => [
        'U9000'                                     => [ 'Huawei', 'Ascend X' ],
        'U9200!'                                    => [ 'Huawei', 'Ascend P1' ],
        'U9202!'                                    => [ 'Huawei', 'Ascend P1' ],
        'U9500'                                     => [ 'Huawei', 'Ascend D1' ],
        'U9500E'                                    => [ 'Huawei', 'Ascend D1 XL' ],
        'U9501L'                                    => [ 'Huawei', 'Ascend D LTE' ],
        'U9508'                                     => [ 'Huawei', 'Honor 2' ],
        'U9510!'                                    => [ 'Huawei', 'Ascend D quad' ],
    ],

    'Comet'                                     => [ 'Huawei', 'Comet' ],
    'Joy'                                       => [ 'Huawei', 'Joy' ],
    'DroniX-0.5'                                => [ 'Huawei', 'U8180' ],
    'TSP21'                                     => [ 'Huawei', 'U8110' ],

    'GS02'                                      => [ 'Huawei', 'GS02', 'carrier' => 'EMOBILE' ],
    'GS03'                                      => [ 'Huawei', 'GS03', 'carrier' => 'EMOBILE' ],
    'GL07S'                                     => [ 'Huawei', 'STREAM X GL07S', 'carrier' => 'EMOBILE' ],
    'HW-01E'                                    => [ 'Huawei', 'Ascend HW-01E', 'carrier' => 'DoCoMo' ],
    'HW-03E'                                    => [ 'Huawei', 'Ascend D2 HW-03E', 'carrier' => 'DoCoMo' ],
    'H866C'                                     => [ 'Huawei', 'Ascend Y H866C' ],
    'H882L'                                     => [ 'Huawei', 'Ascend Y301-A' ],

    'USCCADR[0-9]{4,4}!!' => [
        'USCCADR3305'                               => [ 'Huawei', 'Ascend II' ],
        'USCCADR3310'                               => [ 'Huawei', 'Ascend II' ],
    ],

    'HYUNDAI!!' => [
        'HYUNDAI H6'                                => [ 'Hyundai', 'Storm H6' ],
        'HYUNDAI H6 B'                              => [ 'Hyundai', 'Storm H6' ],
        'HYUNDAI H8'                                => [ 'Hyundai', 'H8' ],
        'HYUNDAI H8Q'                               => [ 'Hyundai', 'H8Q' ],
        'HYUNDAI H9'                                => [ 'Hyundai', 'H9' ],
        'HYUNDAI H10'                               => [ 'Hyundai', 'H10' ],
        'HYUNDAI H11'                               => [ 'Hyundai', 'H11' ],
        'Hyundai HT-10G'                            => [ 'Hyundai', 'HT-10G', DeviceType::TABLET ],
        'HYUNDAI Q5'                                => [ 'Hyundai', 'Q5' ],
        'HYUNDAI Q5X'                               => [ 'Hyundai', 'Q5X' ],
        'HYUNDAI T7'                                => [ 'Hyundai', 'T7', DeviceType::TABLET ],
        'HYUNDAI T7S'                               => [ 'Hyundai', 'T7s', DeviceType::TABLET ],
        'HYUNDAI T10'                               => [ 'Hyundai', 'T10', DeviceType::TABLET ],
        'HYUNDAI T31'                               => [ 'Hyundai', 'T31', DeviceType::TABLET ],
        'HYUNDAI X7'                                => [ 'Hyundai', 'X7' ],
        'HYUNDAI X900'                              => [ 'Hyundai', 'X900', DeviceType::TABLET ],
    ],

    'Ultra Air'                                 => [ 'Hyundai', 'Ultra Air' ],
    'Ultra Charm'                               => [ 'Hyundai', 'Ultra Charm' ],
    'Ultra Energy'                              => [ 'Hyundai', 'Ultra Energy' ],
    'Ultra Energy Lite'                         => [ 'Hyundai', 'Ultra Energy Lite' ],
    'Ultra Energy Plus'                         => [ 'Hyundai', 'Ultra Energy Plus' ],
    'Ultra Latitude'                            => [ 'Hyundai', 'Ultra Latitude' ],
    'Ultra Style'                               => [ 'Hyundai', 'Ultra Style' ],
    'Ultra Wave'                                => [ 'Hyundai', 'Ultra Wave' ],
    'A7 HD'                                     => [ 'Hyundai', 'A7 HD', DeviceType::TABLET ],
    'MW1031'                                    => [ 'Hyundai', 'MW1031', DeviceType::TABLET ],
    'Elektra L'                                 => [ 'i-Joy', 'Elektra L' ],
    'Elektra XL'                                => [ 'i-Joy', 'Elektra XL' ],
    'i-Joy i-Call'                              => [ 'i-Joy', 'i-Call' ],
    'i-Call 300'                                => [ 'i-Joy', 'i-Call 300' ],
    'i-Call 300v2'                              => [ 'i-Joy', 'i-Call 300' ],
    'i-Call 504'                                => [ 'i-Joy', 'i-Call 504' ],
    'DEOX'                                      => [ 'i-Joy', 'Deox', DeviceType::TABLET ],
    'Neon7'                                     => [ 'i-Joy', 'Neon7', DeviceType::TABLET ],
    'Neon9'                                     => [ 'i-Joy', 'Neon9', DeviceType::TABLET ],
    'Planet II v2'                              => [ 'i-Joy', 'Planet II', DeviceType::TABLET ],
    'Sygnus'                                    => [ 'i-Joy', 'Sygnus', DeviceType::TABLET ],

    '(NMP|MBR|XDK|XDS|XMP)\-!!' => [
        'NMP-302w'                                  => [ 'IAdea', 'MBR-1100', DeviceType::SIGNAGE ],
        'MBR-1100'                                  => [ 'IAdea', 'MBR-1100', DeviceType::SIGNAGE ],
        'XDK-1160'                                  => [ 'IAdea', 'XDK-1160', DeviceType::SIGNAGE ],
        'XDK-1560'                                  => [ 'IAdea', 'XDK-1560', DeviceType::SIGNAGE ],
        'XDS-0548'                                  => [ 'IAdea', 'XDS-0548', DeviceType::SIGNAGE ],
        'XDS-1078'                                  => [ 'IAdea', 'XDS-1078', DeviceType::SIGNAGE ],
        'XDS-2170'                                  => [ 'IAdea', 'XDS-2170', DeviceType::SIGNAGE ],
        'XDS-2370'                                  => [ 'IAdea', 'XDS-2370', DeviceType::SIGNAGE ],
        'XMP-6200'                                  => [ 'IAdea', 'XMP-6200', DeviceType::SIGNAGE ],
        'XMP-6250'                                  => [ 'IAdea', 'XMP-6250', DeviceType::SIGNAGE ],
        'XMP-6400'                                  => [ 'IAdea', 'XMP-6400', DeviceType::SIGNAGE ],
        'XMP-7300'                                  => [ 'IAdea', 'XMP-7300', DeviceType::SIGNAGE ],
    ],

    '(iBall )?Andi!!' => [
        'Andi3n'                                    => [ 'iBall', 'Andi 3n' ],
        'iBall Andi3e'                              => [ 'iBall', 'Andi 3e' ],
        'iBall Andi3.5'                             => [ 'iBall', 'Andi 3.5' ],
        'Andi 3.5i'                                 => [ 'iBall', 'Andi 3.5i' ],
        'Andi3.5r'                                  => [ 'iBall', 'Andi 3.5r' ],
        'iBall Andi3.5 Classique'                   => [ 'iBall', 'Andi 3.5 Classique' ],
        'Andi3.5F  Grabit'                          => [ 'iBall', 'Andi 3.5F Grabit' ],
        'Andi3.5KKe'                                => [ 'iBall', 'Andi 3.5KKe' ],
        'Andi 3.5KKe+'                              => [ 'iBall', 'Andi 3.5KKe Plus' ],
        'iBall Andi 3.5KKe Genius'                  => [ 'iBall', 'Andi 3.5KKe Genius' ],
        'Andi3.5KKe Glam'                           => [ 'iBall', 'Andi 3.5KKe Glam' ],
        'Andi3.5KKe Glory'                          => [ 'iBall', 'Andi 3.5KKe Glory' ],
        'Andi3.5KKe Super'                          => [ 'iBall', 'Andi 3.5KKe Super' ],
        'iBall Andi 3.5KKe Winner'                  => [ 'iBall', 'Andi 3.5KKe Winner' ],
        'Andi  3.5KKe  Winner+'                     => [ 'iBall', 'Andi 3.5KKe Winner Plus' ],
        'Andi3.5V Genius2'                          => [ 'iBall', 'Andi 3.5V Genius 2' ],
        'Andi4  Arc'                                => [ 'iBall', 'Andi 4 Arc' ],
        'Andi 4 IPS GEM(1GB)'                       => [ 'iBall', 'Andi 4 Gem' ],
        'iBall Andi 4 IPS TIGER 1GB'                => [ 'iBall', 'Andi 4 Tiger' ],
        'Andi 4 IPS Tiger'                          => [ 'iBall', 'Andi 4 Tiger' ],
        'Andi4a Projector'                          => [ 'iBall', 'Andi 4A Projector' ],
        'Andi4a Radium'                             => [ 'iBall', 'Andi 4A Radium' ],
        'iBall Andi4-B2'                            => [ 'iBall', 'Andi 4B2' ],
        'Andi4-B2 3G'                               => [ 'iBall', 'Andi 4B2' ],
        'Andi4 B20'                                 => [ 'iBall', 'Andi 4B20' ],
        'Andi4d'                                    => [ 'iBall', 'Andi 4D' ],
        'iball Andi4di'                             => [ 'iBall', 'Andi 4Di' ],
        'iBall Andi 4di+'                           => [ 'iBall', 'Andi 4Di' ],
        'Andi 4F ARC3'                              => [ 'iBall', 'Andi 4F Arc3' ],
        'Andi4F Waves'                              => [ 'iBall', 'Andi 4F Waves' ],
        'Andi4G ARC2'                               => [ 'iBall', 'Andi 4G Arc2' ],
        'Andi4H Tiger+'                             => [ 'iBall', 'Andi 4H Tiger Plus' ],
        'Andi 4P Class-X'                           => [ 'iBall', 'Andi 4P Class-X' ],
        'iBall Andi4P IPS GEM'                      => [ 'iBall', 'Andi 4P Gem' ],
        'iBall Andi4P IPS Velvet'                   => [ 'iBall', 'Andi 4P Velvet' ],
        'Andi4U Frisbee'                            => [ 'iBall', 'Andi 4U Frisbee' ],
        'Andi4U Frisbee(8GB)'                       => [ 'iBall', 'Andi 4U Frisbee' ],
        'Andi4v'                                    => [ 'iBall', 'Andi 4V' ],
        'Andi 4.3a'                                 => [ 'iBall', 'Andi 4.3A' ],
        'iBall Andi4.3J'                            => [ 'iBall', 'Andi 4.3J' ],
        'iBall Andi4.3J+'                           => [ 'iBall', 'Andi 4.3J' ],
        'Andi 4.5 O\'Buddy'                         => [ 'iBall', 'Andi 4.5 O\'Buddy' ],
        'iBall Andi4.5 Ripple 3G'                   => [ 'iBall', 'Andi 4.5 Ripple' ],
        'iBall Andi4.5 Ripple'                      => [ 'iBall', 'Andi 4.5 Ripple' ],
        'Andi4.5 Ripple 3G 1GB IPS'                 => [ 'iBall', 'Andi 4.5 Ripple' ],
        'Andi 4.5C Magnifico'                       => [ 'iBall', 'Andi 4.5C Magnifico' ],
        'Andi 4.5C Magnifico(1+8 GB)'               => [ 'iBall', 'Andi 4.5C Magnifico' ],
        'iBall Andi4.5d quadro'                     => [ 'iBall', 'Andi 4.5D Quadro' ],
        'iBALL Andi4.5h'                            => [ 'iBall', 'Andi 4.5H' ],
        'Andi4.5h'                                  => [ 'iBall', 'Andi 4.5H' ],
        'Andi4.5K6'                                 => [ 'iBall', 'Andi 4.5K6' ],
        'Andi4.5K6+'                                => [ 'iBall', 'Andi 4.5K6 Plus' ],
        'Andi4.5 K6+'                               => [ 'iBall', 'Andi 4.5K6 Plus' ],
        'Andi4.5M Enigma'                           => [ 'iBall', 'Andi 4.5M Enigma' ],
        'Andi4.5M Enigma+'                          => [ 'iBall', 'Andi 4.5M Enigma Plus' ],
        'Andi 4.5P Glitter'                         => [ 'iBall', 'Andi 4.5P Glitter' ],
        'Andi4.5P IPS Glitter'                      => [ 'iBall', 'Andi 4.5P Glitter' ],
        'iBall Andi4.5q'                            => [ 'iBall', 'Andi 4.5Q' ],
        'Andi4.5V Baby Panther'                     => [ 'iBall', 'Andi 4.5V Baby Panther' ],
        'Andi 4.5z'                                 => [ 'iBall', 'Andi 4.5Z' ],
        'iBall Cobalt Oomph 4.7D'                   => [ 'iBall', 'Andi 4.7D Cobalt Oomph' ],
        'Andi4.7G COBALT'                           => [ 'iBall', 'Andi 4.7G Cobalt' ],
        'Andi5 Stallion'                            => [ 'iBall', 'Andi 5 Stallion' ],
        'Andi5 Stallion+'                           => [ 'iBall', 'Andi 5 Stallion Plus' ],
        'Andi 5F Infinito'                          => [ 'iBall', 'Andi 5F Infinito' ],
        'Andi 5G Blink 4G'                          => [ 'iBall', 'Andi 5G Blink' ],
        'Andi5h quadro'                             => [ 'iBall', 'Andi 5H Quadro' ],
        'Andi 5K infinito2'                         => [ 'iBall', 'Andi 5K Infinito 2' ],
        'Andi5K Panther'                            => [ 'iBall', 'Andi 5K Panther' ],
        'Andi5K Sparkle'                            => [ 'iBall', 'Andi 5K Sparkle' ],
        'Andi5K Sparkle(1GB)'                       => [ 'iBall', 'Andi 5K Sparkle' ],
        'iBall Andi5L'                              => [ 'iBall', 'Andi 5L' ],
        'Andi 5L Rider'                             => [ 'iBall', 'Andi 5L Rider' ],
        'Andi5Li'                                   => [ 'iBall', 'Andi 5Li' ],
        'Andi5M Xotic 2GB'                          => [ 'iBall', 'Andi 5M Xotic' ],
        'Andi5Q Cobalt Solus'                       => [ 'iBall', 'Andi 5Q Cobalt Solus' ],
        'Andi 5Q Gold 4G'                           => [ 'iBall', 'Andi 5Q Gold' ],
        'Andi 5S Cobalt3'                           => [ 'iBall', 'Andi 5S Cobalt 3' ],
        'iBall Andi5T Cobalt2'                      => [ 'iBall', 'Andi 5T Cobalt 2' ],
        'iBall Andi 5T Cobalt2'                     => [ 'iBall', 'Andi 5T Cobalt 2' ],
        'Andi5U_Platino'                            => [ 'iBall', 'Andi 5U Platino' ],
        'Andi5U Platino(1+8GB)'                     => [ 'iBall', 'Andi 5U Platino' ],
        'iBall Andi5-E7'                            => [ 'iBall', 'Andi 5-E7' ],
        'iBall Andi5-M8'                            => [ 'iBall', 'Andi 5-M8' ],
        'Andi 5.5H Weber'                           => [ 'iBall', 'Andi 5.5H Weber' ],
        'Andi 5.5H Weber 4G'                        => [ 'iBall', 'Andi 5.5H Weber' ],
        'Andi5.5 N2'                                => [ 'iBall', 'Andi 5.5 N2' ],
        'Andi107'                                   => [ 'iBall', 'Andi 107' ],
        'Andi Avonte5'                              => [ 'iBall', 'Andi Avonte 5' ],
        'Andi Hd6'                                  => [ 'iBall', 'Andi HD6' ],
        'Andi Sprinter 4G'                          => [ 'iBall', 'Andi Sprinter 4G' ],
        'Andi Uddaan'                               => [ 'iBall', 'Andi Uddaan' ],
        'Andi Uddaan (1GB )'                        => [ 'iBall', 'Andi Uddaan' ],
        'Andi Uddaan Quad core'                     => [ 'iBall', 'Andi Uddaan' ],
        'Andi Mini Uddaan'                          => [ 'iBall', 'Andi Uddaan Mini' ],
    ],

    'iBall!!' => [
        'iBall Slide Brillante'                     => [ 'iBall', 'Slide Brillante', DeviceType::TABLET ],
        'iBall Slide i5715'                         => [ 'iBall', 'Slide i5715', DeviceType::TABLET ],
        'iBall i6012'                               => [ 'iBall', 'Slide i6012', DeviceType::TABLET ],
        'iBall Slide i6030'                         => [ 'iBall', 'Slide i6030', DeviceType::TABLET ],
        'iBall Slide 6309i'                         => [ 'iBall', 'Slide i6309', DeviceType::TABLET ],
        'iBall Slide 6318i'                         => [ 'iBall', 'Slide i6318', DeviceType::TABLET ],
        'iBall Slide i6516'                         => [ 'iBall', 'Slide i6516', DeviceType::TABLET ],
        'iBall Slide i7011'                         => [ 'iBall', 'Slide i7011', DeviceType::TABLET ],
        'iBall Slide i7119'                         => [ 'iBall', 'Slide i7119', DeviceType::TABLET ],
        'iBall Slide i9702'                         => [ 'iBall', 'Slide i9702', DeviceType::TABLET ],
        'iBall Slide 3G7271'                        => [ 'iBall', 'Slide 3G 7271', DeviceType::TABLET ],
        'iBall Slide 3G 7307'                       => [ 'iBall', 'Slide 3G 7307', DeviceType::TABLET ],
        'IBall 3G 7316'                             => [ 'iBall', 'Slide 3G 7316', DeviceType::TABLET ],
        'iBall Slide 3G 7316'                       => [ 'iBall', 'Slide 3G 7316', DeviceType::TABLET ],
        'iBall Slide 3G 7334'                       => [ 'iBall', 'Slide 3G 7334', DeviceType::TABLET ],
        'iBall Slide 3G Q45i'                       => [ 'iBall', 'Slide 3G Q45i', DeviceType::TABLET ],
        'iBall Slide 3G Q1035'                      => [ 'iBall', 'Slide 3G Q1035', DeviceType::TABLET ],
    ],

    '3G7334i'                                   => [ 'iBall', 'Slide 3G 7334', DeviceType::TABLET ],

    '(Aura|iberry|AUXUS)!!' => [
        'Aura A1'                                   => [ 'iBerry', 'Auxus Aura A1', DeviceType::TABLET ],
        'AUXUS AX01'                                => [ 'iBerry', 'Auxus AX01', DeviceType::TABLET ],
        'iberry AUXUS AX02'                         => [ 'iBerry', 'Auxus AX02', DeviceType::TABLET ],
        'AUXUS CoreX2 3G'                           => [ 'iBerry', 'Auxus CoreX2', DeviceType::TABLET ],
        'AUXUS CoreX4 3G'                           => [ 'iBerry', 'Auxus CoreX4', DeviceType::TABLET ],
        'AUXUS Nuclea N1'                           => [ 'iBerry', 'Auxus Nuclea N1' ],
        'AUXUS Nuclea N2'                           => [ 'iBerry', 'Auxus Nuclea N2' ],
    ],

    '(NetTab|NT-)!!' => [
        'NetTab iconBIT'                            => [ 'IconBit', 'NetTab', DeviceType::TABLET ],
        'NetTAB Matrix'                             => [ 'IconBit', 'NetTab Matrix', DeviceType::TABLET ],
        'NT-0704M'                                  => [ 'IconBit', 'NetTab Matrix Ultra', DeviceType::TABLET ],
        'NT-0705M'                                  => [ 'IconBit', 'NetTab Matrix Quad', DeviceType::TABLET ],
        'NetTAB MATRIX HD'                          => [ 'IconBit', 'NetTab Matrix HD', DeviceType::TABLET ],
        'NT-0708M'                                  => [ 'IconBit', 'NetTab Matrix HD', DeviceType::TABLET ],
        'NT-0709M'                                  => [ 'IconBit', 'NetTab Matrix DX', DeviceType::TABLET ],
        'NT-0711M'                                  => [ 'IconBit', 'NetTab Matrix DX', DeviceType::TABLET ],
        'NetTAB Pocket'                             => [ 'IconBit', 'NetTab Pocket', DeviceType::TABLET ],
        'NetTAB PRIDE'                              => [ 'IconBit', 'NetTab Pride', DeviceType::TABLET ],
        'NetTAB RUNE'                               => [ 'IconBit', 'NetTab Rune', DeviceType::TABLET ],
        'NT-0801C'                                  => [ 'IconBit', 'NetTab Skat RX', DeviceType::TABLET ],
        'NT-0806C'                                  => [ 'IconBit', 'NetTab Skat LE', DeviceType::TABLET ],
        'NetTAB SKY'                                => [ 'IconBit', 'NetTab Sky', DeviceType::TABLET ],
        'NT-0701S'                                  => [ 'IconBit', 'NetTab Sky Net', DeviceType::TABLET ],
        'NetTAB SKY II'                             => [ 'IconBit', 'NetTab Sky II', DeviceType::TABLET ],
        'NetTAB Space 3G'                           => [ 'IconBit', 'NetTab Space', DeviceType::TABLET ],
        'NetTAB SPACE II'                           => [ 'IconBit', 'NetTab Space II', DeviceType::TABLET ],
        'NetTAB SPACE II Plus'                      => [ 'IconBit', 'NetTab Space II Plus', DeviceType::TABLET ],
        'NetTAB SPACE III'                          => [ 'IconBit', 'NetTab Space III', DeviceType::TABLET ],
        'NT-0901S'                                  => [ 'IconBit', 'NetTab Space Quad HD', DeviceType::TABLET ],
        'NT-0902S'                                  => [ 'IconBit', 'NetTab Space Quad RX', DeviceType::TABLET ],
        'NetTAB THOR'                               => [ 'IconBit', 'NetTab Thor', DeviceType::TABLET ],
        'NetTAB THOR V4.10'                         => [ 'IconBit', 'NetTab Thor', DeviceType::TABLET ],
        'NT-0907T'                                  => [ 'IconBit', 'NetTab Thor ZX', DeviceType::TABLET ],
        'NT-0909T'                                  => [ 'IconBit', 'NetTab Thor IZ', DeviceType::TABLET ],
        'NetTAB THOR mini'                          => [ 'IconBit', 'NetTab Thor Mini', DeviceType::TABLET ],
        'NetTAB THOR-LE'                            => [ 'IconBit', 'NetTab Thor LE', DeviceType::TABLET ],
        'NT-1001T'                                  => [ 'IconBit', 'NetTab Thor LE', DeviceType::TABLET ],
        'NT-1002T'                                  => [ 'IconBit', 'NetTab Thor LE', DeviceType::TABLET ],
        'NT-1004T'                                  => [ 'IconBit', 'NetTab Thor Quad FHD', DeviceType::TABLET ],
        'NT-1005T'                                  => [ 'IconBit', 'NetTab Thor Quad', DeviceType::TABLET ],
        'NT-1006T'                                  => [ 'IconBit', 'NetTab Thor Quad MX', DeviceType::TABLET ],
        'NT-1008T'                                  => [ 'IconBit', 'NetTab Thor 3GTS', DeviceType::TABLET ],
        'NT-1009T'                                  => [ 'IconBit', 'NetTab Thor Quad II', DeviceType::TABLET ],
        'NT-1010T'                                  => [ 'IconBit', 'NetTab Thor LE', DeviceType::TABLET ],
        'NT-1011T'                                  => [ 'IconBit', 'NetTab Thor LE', DeviceType::TABLET ],
        'NT-1020T'                                  => [ 'IconBit', 'NetTab Thor LX', DeviceType::TABLET ],
        'NT-1021T'                                  => [ 'IconBit', 'NetTab Thor LX', DeviceType::TABLET ],
        'NT-1501C'                                  => [ 'IconBit', 'NetTab Callisto 100', DeviceType::WATCH ],
        'NT-3506M'                                  => [ 'IconBit', 'NetTab Mercury Quad FHD' ],
        'NT-3507M'                                  => [ 'IconBit', 'NetTab Mercury Quad' ],
        'NT-3509M'                                  => [ 'IconBit', 'NetTab Mercury Q4' ],
        'NT-3510M'                                  => [ 'IconBit', 'NetTab Mercury Q5' ],
        'NT-3513M!'                                 => [ 'IconBit', 'NetTab Mercury LX' ],
        'NT-3601P!'                                 => [ 'IconBit', 'NetTab Pocket' ],
        'NT-3602M'                                  => [ 'IconBit', 'NetTab Mercury Q7' ],
        'NT-3701S'                                  => [ 'IconBit', 'NetTab Sky 3G Duo', DeviceType::TABLET ],
        'NT-3702M'                                  => [ 'IconBit', 'NetTab Matrix 3G Duo', DeviceType::TABLET ],
        'NT-3702S'                                  => [ 'IconBit', 'NetTab Sky HD 3G', DeviceType::TABLET ],
        'NT-3710S'                                  => [ 'IconBit', 'NetTab Sky 3G Plus', DeviceType::TABLET ],
        'NT-3801P'                                  => [ 'IconBit', 'NetTab Parus 3G Duo', DeviceType::TABLET ],
        'NT-3803C'                                  => [ 'IconBit', 'NetTab Skat 3G', DeviceType::TABLET ],
        'NT-3805C'                                  => [ 'IconBit', 'NetTab Skat 3G Quad', DeviceType::TABLET ],
        'NT-3902S'                                  => [ 'IconBit', 'NetTab Space 3G Duo', DeviceType::TABLET ],
    ],

    'IconBit NetTab Thor Mini'                  => [ 'IconBit', 'NetTab Thor Mini', DeviceType::TABLET ],
    'D70W'                                      => [ 'Icoo', 'D70W', DeviceType::TABLET ],
    'D80'                                       => [ 'Icoo', 'D80', DeviceType::TABLET ],
    'AURUS III'                                 => [ 'Idea', 'Aurus III' ],

    'CT720G'                                    => [ 'IdeaUSA', 'CT720G', DeviceType::TABLET ],
    'CT720HD'                                   => [ 'IdeaUSA', 'CT720HD', DeviceType::TABLET ],
    'CT920'                                     => [ 'IdeaUSA', 'CT920', DeviceType::TABLET ],
    'CT1006'                                    => [ 'IdeaUSA', 'CT1006', DeviceType::TABLET ],

    'INFOBAR!!' => [
        'INFOBAR A01'                               => [ 'iida', 'INFOBAR A01', 'carrier' => 'au' ],               // by Sharp
        'INFOBAR A01-2'                             => [ 'iida', 'INFOBAR A01', 'carrier' => 'au' ],               // by Sharp
        'INFOBAR C01'                               => [ 'iida', 'INFOBAR C01', 'carrier' => 'au' ],               // by Sharp
    ],

    'HTX21'                                     => [ 'iida', 'INFOBAR A02', 'carrier' => 'au' ],                   // by HTC
    'KYV33'                                     => [ 'iida', 'INFOBAR A03', 'carrier' => 'au' ],                   // by Kyocera


    'IMO!!' => [
        'IMO Discovery II'                          => [ 'IMO', 'Discovery II' ],
        'IMO Discovery 2'                           => [ 'IMO', 'Discovery II' ],
        'IMO Q8'                                    => [ 'IMO', 'Q8 Clarity' ],
        'IMO S67'                                   => [ 'IMO', 'Blast S67' ],
        'IMO S68'                                   => [ 'IMO', 'Snow S68' ],
        'IMO S70'                                   => [ 'IMO', 'Miracle 2 S70' ],
        'IMO S78'                                   => [ 'IMO', 'Glory S78' ],
        'IMO S78 NEW STYLE'                         => [ 'IMO', 'Glory S78' ],
        'IMO S79'                                   => [ 'IMO', 'Explorer S79' ],
        'IMO S79 EXPLORER'                          => [ 'IMO', 'Explorer S79' ],
        'IMO S79 MIUI'                              => [ 'IMO', 'Explorer S79' ],
        'IMO S87'                                   => [ 'IMO', 'Raptor S87' ],
        'Imo Raptor S87'                            => [ 'IMO', 'Raptor S87' ],
        'IMO S88'                                   => [ 'IMO', 'Discovery S88' ],
        'IMO S89'                                   => [ 'IMO', 'Miracle S89' ],
        'IMO S90'                                   => [ 'IMO', 'Buzz S90' ],
        'IMO S98'                                   => [ 'IMO', 'Champion S98' ],
        'IMO S99'                                   => [ 'IMO', 'Ocean S99' ],
        'IMO S900'                                  => [ 'IMO', 'Groovy S900' ],
        'IMO X2'                                    => [ 'IMO', 'Normandy X2' ],
        'IMO X2 NORMANDY'                           => [ 'IMO', 'Normandy X2' ],
        'IMO TAB'                                   => [ 'IMO', 'Tab', DeviceType::TABLET ],
        'IMO X5'                                    => [ 'IMO', 'Tab X5 Mars', DeviceType::TABLET ],
        'IMO TAB X9'                                => [ 'IMO', 'Tab X9 Claire', DeviceType::TABLET ],
        'IMO Y-ONE'                                 => [ 'IMO', 'Tab Y-One', DeviceType::TABLET ],
        'IMO Y5'                                    => [ 'IMO', 'Tab Y3', DeviceType::TABLET ],
        'IMO Y5'                                    => [ 'IMO', 'Tab Y5 i-Play', DeviceType::TABLET ],
        'IMO Z-ONE'                                 => [ 'IMO', 'Tab Z-One', DeviceType::TABLET ],
        'IMO Z6'                                    => [ 'IMO', 'Tab Z6 Avengers', DeviceType::TABLET ],
        'IMO Z7'                                    => [ 'IMO', 'Tab Z7 Orion', DeviceType::TABLET ],
        'IMO Z8'                                    => [ 'IMO', 'Tab Z8 Spin', DeviceType::TABLET ],
        'IMO Z9'                                    => [ 'IMO', 'Tab Z9 Ice', DeviceType::TABLET ],
        'IMO Z10'                                   => [ 'IMO', 'Tab Z10 Fortune', DeviceType::TABLET ],
    ],

    'S88 DISCOVERY'                             => [ 'IMO', 'Discovery S88' ],

    'Im(Smart|PAD)!!' => [
        'ImSmart 1.40'                              => [ 'Impression', 'ImSMART 1.40' ],
        'ImPAD 0114'                                => [ 'Impression', 'ImPAD 0114', DeviceType::TABLET ],
        'ImPAD 0413'                                => [ 'Impression', 'ImPAD 0413', DeviceType::TABLET ],
        'ImPAD1001'                                 => [ 'Impression', 'ImPAD 1001', DeviceType::TABLET ],
        'ImPAD1311'                                 => [ 'Impression', 'ImPAD 1311', DeviceType::TABLET ],
        'ImPAD 1412'                                => [ 'Impression', 'ImPAD 1412', DeviceType::TABLET ],
        'ImPAD 1412 rev2'                           => [ 'Impression', 'ImPAD 1412', DeviceType::TABLET ],
        'ImPAD 2113'                                => [ 'Impression', 'ImPAD 2113', DeviceType::TABLET ],
        'ImPAD 2413'                                => [ 'Impression', 'ImPAD 2413', DeviceType::TABLET ],
        'ImPAD 3113'                                => [ 'Impression', 'ImPAD 3113', DeviceType::TABLET ],
        'ImPAD 3412'                                => [ 'Impression', 'ImPAD 3412', DeviceType::TABLET ],
        'ImPAD 4213'                                => [ 'Impression', 'ImPAD 4213', DeviceType::TABLET ],
        'ImPAD 4313'                                => [ 'Impression', 'ImPAD 4313', DeviceType::TABLET ],
        'ImPAD 6213M'                               => [ 'Impression', 'ImPAD 6213M', DeviceType::TABLET ],
        'ImPAD6213M v2'                             => [ 'Impression', 'ImPAD 6213M', DeviceType::TABLET ],
        'ImPAD 6413'                                => [ 'Impression', 'ImPAD 6413', DeviceType::TABLET ],
        'ImPAD 8213'                                => [ 'Impression', 'ImPAD 8213', DeviceType::TABLET ],
        'ImPAD 8901'                                => [ 'Impression', 'ImPAD 8901', DeviceType::TABLET ],
        'ImPAD 9702'                                => [ 'Impression', 'ImPAD 9702', DeviceType::TABLET ],
        'ImPAD9704'                                 => [ 'Impression', 'ImPAD 9704', DeviceType::TABLET ],
        'ImPAD 9707'                                => [ 'Impression', 'ImPAD 9707', DeviceType::TABLET ],
    ],

    'TX85'                                      => [ 'iMuz', 'TX85', DeviceType::TABLET ],
    'i3000'                                     => [ 'iNew', 'i3000' ],
    'i6000'                                     => [ 'iNew', 'i6000' ],

    'Infinix!!' => [
        'Infinix BUZZ'                              => [ 'Infinix', 'Buzz X260' ],
        'Infinix X351'                              => [ 'Infinix', 'Surf Smart X351' ],
        'Infinix X352'                              => [ 'Infinix', 'Surf Smart 2 X352' ],
        'Infinix X400'                              => [ 'Infinix', 'Race X400' ],
        'Infinix X401'                              => [ 'Infinix', 'Race Lite X401' ],
        'Infinix X402'                              => [ 'Infinix', 'Diamond X402' ],
        'Infinix X405'                              => [ 'Infinix', 'Surf Viva X405' ],
        'Infinix X450'                              => [ 'Infinix', 'Race Bolt X450' ],
        'Infinix X451'                              => [ 'Infinix', 'Race Bolt Q X451' ],
        'Infinix X452'                              => [ 'Infinix', 'Surf Goal X452' ],
        'Infinix X454'                              => [ 'Infinix', 'Race Bolt 2 X454' ],
        'Infinix X455'                              => [ 'Infinix', 'Race Bolt 3 X455' ],
        'Infinix X500'                              => [ 'Infinix', 'Race Eagle X500' ],
        'Infinix X501'                              => [ 'Infinix', 'Race Jet X501' ],
        'Infinix X502'                              => [ 'Infinix', 'Alpha Marvel X502' ],
        'Infinix X503'                              => [ 'Infinix', 'Surf Bravo X503' ],
        'Infinix X505'                              => [ 'Infinix', 'Race Jet X505' ],
        'Infinix X506'                              => [ 'Infinix', 'Zero X506' ],
        'Infinix X506S'                             => [ 'Infinix', 'Zero X506' ],
        'Infinix Zero X506'                         => [ 'Infinix', 'Zero X506' ],
        'Infinix X507'                              => [ 'Infinix', 'Hot X507' ],
        'Infinix X509'                              => [ 'Infinix', 'Zero 2 X509' ],
        'Infinix X510'                              => [ 'Infinix', 'Hot 2 X510' ],
        'Infinix Hot 2'                             => [ 'Infinix', 'Hot 2 X510' ],
        'Infinix X511'                              => [ 'Infinix', 'Hot Note X511' ],
        'Infinix-X521'                              => [ 'Infinix', 'Hot S X521' ],
        'Infinix X521'                              => [ 'Infinix', 'Hot S X521' ],
        'Infinix X530'                              => [ 'Infinix', 'Race Max Q X530' ],
        'Infinix X550'                              => [ 'Infinix', 'Alpha 8 X550' ],
        'Infinix X551'                              => [ 'Infinix', 'Hot Note X551' ],
        'Infinix-X551'                              => [ 'Infinix', 'Hot Note X551' ],
        'Infinix-X552'                              => [ 'Infinix', 'Zero 3 X552' ],
        'Infinix-X554'                              => [ 'Infinix', 'Hot 3 X554' ],
        'Infinix HOT 3'                             => [ 'Infinix', 'Hot 3 X554' ],
        'Infinix HOT 3 LTE'                         => [ 'Infinix', 'Hot 3 X554' ],
        'Infinix X556 LTE'                          => [ 'Infinix', 'Hot 4 Pro X556' ],
        'Infinix HOT 4 Pro'                         => [ 'Infinix', 'Hot 4 Pro X556' ],
        'Infinix X557'                              => [ 'Infinix', 'Hot 4 X557' ],
        'Infinix HOT 4'                             => [ 'Infinix', 'Hot 4 X557' ],
        'Infinix HOT 4 Lite'                        => [ 'Infinix', 'Hot 4 Lite X557' ],
        'Infinix X570'                              => [ 'Infinix', 'Alpha X570' ],
        'INFINIX-X600'                              => [ 'Infinix', 'Note 2 X600' ],
        'Infinix-X600-LTE'                          => [ 'Infinix', 'Note 2 X600' ],
        'Infinix NOTE 2'                            => [ 'Infinix', 'Note 2 X600' ],
        'Infinix NOTE 2 LTE'                        => [ 'Infinix', 'Note 2 X600' ],
        'Infinix X601 LTE'                          => [ 'Infinix', 'Note 3 X601' ],
        'Infinix NOTE 3'                            => [ 'Infinix', 'Note 3 X601' ],
        'Infinix NOTE 3 Pro'                        => [ 'Infinix', 'Note 3 Pro X601' ],
        'Infinix Zero 4'                            => [ 'Infinix', 'Zero 4 X602' ],
        'Infinix Zero 4 Plus'                       => [ 'Infinix', 'Zero 4 Plus X602' ],
        'Infinix X800'                              => [ 'Infinix', 'Joypad 8 X800', DeviceType::TABLET ],
        'Infinix X801'                              => [ 'Infinix', 'Joypad 8S X801', DeviceType::TABLET ],
        'Infinix X1000'                             => [ 'Infinix', 'Joypad 10 X1000', DeviceType::TABLET ],
    ],

    'IN[0-9]{3,3}!!' => [
        'IN260'                                     => [ 'InFocus', 'IN260' ],
        'IN330'                                     => [ 'InFocus', 'IN330' ],
        'IN335'                                     => [ 'InFocus', 'IN335' ],
        'IN610'                                     => [ 'InFocus', 'IN610' ],
        'IN810'                                     => [ 'InFocus', 'IN810' ],
        'IN815'                                     => [ 'InFocus', 'IN815' ],
    ],

    'M210'                                      => [ 'InFocus', 'M210' ],
    'M370i'                                     => [ 'InFocus', 'M370' ],

    'Infocus!!' => [
        'InFocus M2'                                => [ 'InFocus', 'M2' ],
        'InFocus M2 3G'                             => [ 'InFocus', 'M2' ],
        'InFocus M2PLUS'                            => [ 'InFocus', 'M2 Plus' ],
        'InFocus M260'                              => [ 'InFocus', 'M260' ],
        'InFocus M310'                              => [ 'InFocus', 'M310' ],
        'InFocus M320!'                             => [ 'InFocus', 'M320' ],
        'InFocus M330!'                             => [ 'InFocus', 'M330' ],
        'InFocus M350!'                             => [ 'InFocus', 'M350' ],
        'InFocus M415'                              => [ 'InFocus', 'M415' ],
        'InFocus M425'                              => [ 'InFocus', 'M425' ],
        'InFocus M430'                              => [ 'InFocus', 'M430' ],
        'InFocus M510!'                             => [ 'InFocus', 'M510' ],
        'InFocus M511!'                             => [ 'InFocus', 'M511' ],
        'InFocus M512!'                             => [ 'InFocus', 'M512' ],
        'InFocus M530'                              => [ 'InFocus', 'M530' ],
        'InFocus M535'                              => [ 'InFocus', 'M535' ],
        'InFocus M550!'                             => [ 'InFocus', 'M550' ],
        'InFocus M560'                              => [ 'InFocus', 'M560' ],
        'InFocus M680'                              => [ 'InFocus', 'M680' ],
        'InFocus M808!'                             => [ 'InFocus', 'M808' ],
        'InFocus M810!'                             => [ 'InFocus', 'M810' ],
        'InFocus M812!'                             => [ 'InFocus', 'M812' ],
    ],

    'M009F'                                     => [ 'Infotmic', 'M009F' ],
    'Dk1031'                                    => [ 'Infotmic', 'Flytouch 3', DeviceType::TABLET ],
    'INHON PAPILIO G1'                          => [ 'Inhon', 'Papilio G1' ],
    'intki E86'                                 => [ 'intki', 'E86' ],

    'Innos!!' => [
        'Innos D5C'                                 => [ 'Innos', 'D5C' ],
        'innos D9'                                  => [ 'Innos', 'D9' ],
        'innos D9C'                                 => [ 'Innos', 'D9C' ],
        'innos i5'                                  => [ 'Innos', 'i5' ],
        'innos i6'                                  => [ 'Innos', 'i6' ],
        'INNOS I6 (DNS S4503)'                      => [ 'Innos', 'i6' ],
        'innos i6C'                                 => [ 'Innos', 'i6C' ],
        'Innos i6cp'                                => [ 'Innos', 'i6CP' ],
    ],

    'NS-14T002'                                 => [ 'Insignia', 'Flex 8', DeviceType::TABLET ],

    '(AZ|BT)[0-9]{3,3}!!' => [
        'AZ210A'                                    => [ 'Intel', 'AZ210A' ],
        'AZ210B'                                    => [ 'Intel', 'AZ210B' ],
        'AZ510'                                     => [ 'Intel', 'AZ510' ],
        'BT210'                                     => [ 'Intel', 'BT210' ],
        'BT230'                                     => [ 'Intel', 'BT230' ],
        'BT510'                                     => [ 'Intel', 'BT510' ],
    ],

    'greenridge'                                => [ 'Intel', 'Green Ridge', DeviceType::TABLET ],

    '(Intex )?Aqua!!' => [
        'Aqua 3G'                                   => [ 'Intex', 'Aqua 3G' ],
        'Aqua 3G 512'                               => [ 'Intex', 'Aqua 3G' ],
        'Aqua 3G+'                                  => [ 'Intex', 'Aqua 3G+' ],
        'Aqua 3G mini'                              => [ 'Intex', 'Aqua 3G mini' ],
        'Aqua 3G N'                                 => [ 'Intex', 'Aqua 3G N' ],
        'Aqua 3G NS'                                => [ 'Intex', 'Aqua 3G NS' ],
        'Aqua 3G Neo'                               => [ 'Intex', 'Aqua 3G Neo' ],
        'Aqua 3G Pro'                               => [ 'Intex', 'Aqua 3G Pro' ],
        'Aqua 3G Pro Q'                             => [ 'Intex', 'Aqua 3G Pro Q' ],
        'Aqua 3G Star'                              => [ 'Intex', 'Aqua 3G Star' ],
        'Aqua 3G Strong'                            => [ 'Intex', 'Aqua 3G Strong' ],
        'Aqua 4G'                                   => [ 'Intex', 'Aqua 4G' ],
        'Aqua 4G+'                                  => [ 'Intex', 'Aqua 4G+' ],
        'Aqua 4G Strong'                            => [ 'Intex', 'Aqua 4G Strong' ],
        'Intex Aqua 3X'                             => [ 'Intex', 'Aqua 3X' ],
        'AQUA 4X'                                   => [ 'Intex', 'Aqua 4X' ],
        'Aqua 5X'                                   => [ 'Intex', 'Aqua 5X' ],
        'Intex Aqua 3.2'                            => [ 'Intex', 'Aqua 3.2' ],
        'AQUA 4.0'                                  => [ 'Intex', 'Aqua 4.0' ],
        'Intex Aqua 4.5E'                           => [ 'Intex', 'Aqua 4.5E' ],
        'Aqua 4.5Pro'                               => [ 'Intex', 'Aqua 4.5 Pro' ],
        'AQUA 5.0'                                  => [ 'Intex', 'Aqua 5.0' ],
        'Aqua 5.5 VR'                               => [ 'Intex', 'Aqua 5.5 VR' ],
        'Aqua Ace'                                  => [ 'Intex', 'Aqua Ace' ],
        'Aqua Ace II'                               => [ 'Intex', 'Aqua Ace II' ],
        'Aqua Ace Mini'                             => [ 'Intex', 'Aqua Ace Mini' ],
        'Aqua.Active'                               => [ 'Intex', 'Aqua Active' ],
        'Aqua Active'                               => [ 'Intex', 'Aqua Active' ],
        'Aqua Air'                                  => [ 'Intex', 'Aqua Air' ],
        'Aqua Air II'                               => [ 'Intex', 'Aqua Air II' ],
        'Aqua Amaze'                                => [ 'Intex', 'Aqua Amaze' ],
        'Aqua Amoled'                               => [ 'Intex', 'Aqua Amoled' ],
        'Aqua Classic'                              => [ 'Intex', 'Aqua Classic' ],
        'Aqua Cloud V'                              => [ 'Intex', 'Cloud V' ],
        'aQUa COSTA'                                => [ 'Intex', 'Aqua Costa' ],
        'Aqua Craze'                                => [ 'Intex', 'Aqua Craze' ],
        'Aqua Craze 2'                              => [ 'Intex', 'Aqua Craze 2' ],
        'Aqua Curve'                                => [ 'Intex', 'Aqua Curve' ],
        'Aqua Curve mini'                           => [ 'Intex', 'Aqua Curve Mini' ],
        'Aqua Desire'                               => [ 'Intex', 'Aqua Desire' ],
        'Intex Aqua Desire HD'                      => [ 'Intex', 'Aqua Desire HD' ],
        'Aqua Dream II'                             => [ 'Intex', 'Aqua Dream II' ],
        'Aqua Eco'                                  => [ 'Intex', 'Aqua Eco' ],
        'Aqua Eco 4G'                               => [ 'Intex', 'Aqua Eco 4G' ],
        'Aqua flash'                                => [ 'Intex', 'Aqua Flash' ],
        'Aqua Freedom'                              => [ 'Intex', 'Aqua Freedom' ],
        'Aqua GenX'                                 => [ 'Intex', 'Aqua GenX' ],
        'Aqua Glam'                                 => [ 'Intex', 'Aqua Glam' ],
        'Aqua Glory'                                => [ 'Intex', 'Aqua Glory' ],
        'Aqua Glow'                                 => [ 'Intex', 'Aqua Glow' ],
        'Aqua HD'                                   => [ 'Intex', 'Aqua HD' ],
        'Aqua HD 5.0'                               => [ 'Intex', 'Aqua HD' ],
        'Aqua HD Power'                             => [ 'Intex', 'Aqua HD Power' ],
        'Aqua Joy'                                  => [ 'Intex', 'Aqua Joy' ],
        'Aqua KAT'                                  => [ 'Intex', 'Aqua KAT' ],
        'Aqua Life'                                 => [ 'Intex', 'Aqua Life' ],
        'Aqua Life II'                              => [ 'Intex', 'Aqua Life II' ],
        'Aqua LifeIII'                              => [ 'Intex', 'Aqua Life III' ],
        'Aqua Life V'                               => [ 'Intex', 'Aqua Life V' ],
        'Aqua Lions 3G'                             => [ 'Intex', 'Aqua Lions 3G' ],
        'Aqua Lions 3G S'                           => [ 'Intex', 'Aqua Lions 3G S' ],
        'Aqua Lite'                                 => [ 'Intex', 'Aqua Lite' ],
        'Intex Aqua Marvel'                         => [ 'Intex', 'Aqua Marvel' ],
        'Aqua Music'                                => [ 'Intex', 'Aqua Music' ],
        'AQUA OCTA'                                 => [ 'Intex', 'Aqua Octa' ],
        'Intex Aqua Play'                           => [ 'Intex', 'Aqua Play' ],
        'Aqua Power'                                => [ 'Intex', 'Aqua Power' ],
        'Aqua Power+'                               => [ 'Intex', 'Aqua Power+' ],
        'Aqua Power HD'                             => [ 'Intex', 'Aqua Power HD' ],
        'Aqua Power HD-4G'                          => [ 'Intex', 'Aqua Power HD 4G' ],
        'Aqua Power II'                             => [ 'Intex', 'Aqua Power II' ],
        'Aqua Power 4G'                             => [ 'Intex', 'Aqua Power 4G' ],
        'Aqua Pride'                                => [ 'Intex', 'Aqua Pride' ],
        'Aqua Pro'                                  => [ 'Intex', 'Aqua Pro' ],
        'Aqua Pro 4G'                               => [ 'Intex', 'Aqua Pro 4G' ],
        'Aqua QWERTY'                               => [ 'Intex', 'Aqua Qwerty' ],
        'Aqua Raze'                                 => [ 'Intex', 'Aqua Raze' ],
        'Aqua Ring'                                 => [ 'Intex', 'Aqua Ring' ],
        'Aqua S'                                    => [ 'Intex', 'Aqua S' ],
        'Aqua Sx'                                   => [ 'Intex', 'Aqua Sx' ],
        'Aqua Secure'                               => [ 'Intex', 'Aqua Secure' ],
        'AquaSense5.0'                              => [ 'Intex', 'Aqua Sense 5.0' ],
        'Aqua Sense 5 1'                            => [ 'Intex', 'Aqua Sense 5.1' ],
        'Aqua Shine 4G'                             => [ 'Intex', 'Aqua Shine 4G' ],
        'Aqua Slice'                                => [ 'Intex', 'Aqua Slice' ],
        'Aqua Slice II'                             => [ 'Intex', 'Aqua Slice II' ],
        'Aqua Speed'                                => [ 'Intex', 'Aqua Speed' ],
        'Aqua Speed HD'                             => [ 'Intex', 'Aqua Speed HD' ],
        'Aqua Star'                                 => [ 'Intex', 'Aqua Star' ],
        'Aqua Star 4G'                              => [ 'Intex', 'Aqua Star 4G' ],
        'Aqua Star L'                               => [ 'Intex', 'Aqua Star L' ],
        'Aqua Star II'                              => [ 'Intex', 'Aqua Star II' ],
        'Aqua Star II 16GB'                         => [ 'Intex', 'Aqua Star II' ],
        'Aqua Star II HD'                           => [ 'Intex', 'Aqua Star II HD' ],
        'Aqua Star 5.0'                             => [ 'Intex', 'Aqua Star 5.0' ],
        'Aqua Star HD'                              => [ 'Intex', 'Aqua Star HD' ],
        'Aqua Star Power'                           => [ 'Intex', 'Aqua Star Power' ],
        'Aqua Strong 5.1'                           => [ 'Intex', 'Aqua Strong 5.1' ],
        'Aqua Style'                                => [ 'Intex', 'Aqua Style' ],
        'Aqua Style 4.0'                            => [ 'Intex', 'Aqua Style 4.0' ],
        'Aqua Style Mini'                           => [ 'Intex', 'Aqua Style Mini' ],
        'Aqua Style Pro'                            => [ 'Intex', 'Aqua Style Pro' ],
        'Aqua Style VX'                             => [ 'Intex', 'Aqua Style VX' ],
        'Aqua Style X'                              => [ 'Intex', 'Aqua Style X' ],
        'Aqua Super'                                => [ 'Intex', 'Aqua Super' ],
        'Intex Aqua Superb'                         => [ 'Intex', 'Aqua Superb' ],
        'Intex Aqua Swadesh'                        => [ 'Intex', 'Aqua Swadesh' ],
        'Aqua Trend'                                => [ 'Intex', 'Aqua Trend' ],
        'Aqua Trendy'                               => [ 'Intex', 'Aqua Trendy' ],
        'Aqua Turbo 4G'                             => [ 'Intex', 'Aqua Turbo 4G' ],
        'Aqua Twist'                                => [ 'Intex', 'Aqua Twist' ],
        'Aqua View'                                 => [ 'Intex', 'Aqua View' ],
        'Aqua Wing'                                 => [ 'Intex', 'Aqua Wing' ],
        'Aqua Wonder'                               => [ 'Intex', 'Aqua Wonder' ],
        'Aqua Wonder Quad Core'                     => [ 'Intex', 'Aqua Wonder' ],
        'Aqua X'                                    => [ 'Intex', 'Aqua X' ],
        'Aqua Xtreme'                               => [ 'Intex', 'Aqua Xtreme' ],
        'Aqua XtremeV'                              => [ 'Intex', 'Aqua Xtreme V' ],
        'Aqua Young'                                => [ 'Intex', 'Aqua Young' ],
        'Aqua i2'                                   => [ 'Intex', 'Aqua i2' ],
        'Intex Aqua I3'                             => [ 'Intex', 'Aqua i3' ],
        'Aqua I-4'                                  => [ 'Intex', 'Aqua i4' ],
        'Aqua i-4+'                                 => [ 'Intex', 'Aqua i4' ],
        'Aqua I-5'                                  => [ 'Intex', 'Aqua i5' ],
        'Aqua I5'                                   => [ 'Intex', 'Aqua i5' ],
        'Aqua i5 HD'                                => [ 'Intex', 'Aqua i5 HD' ],
        'Aqua i5 mini'                              => [ 'Intex', 'Aqua i5 mini' ],
        'Aqua I5 Octa'                              => [ 'Intex', 'Aqua i5 Octa' ],
        'Aqua i6'                                   => [ 'Intex', 'Aqua i6' ],
        'Aqua i7'                                   => [ 'Intex', 'Aqua i7' ],
        'Aqua I14'                                  => [ 'Intex', 'Aqua i14' ],
        'Aqua i15'                                  => [ 'Intex', 'Aqua i15' ],
        'Aqua A1'                                   => [ 'Intex', 'Aqua A1' ],
        'Aqua A2'                                   => [ 'Intex', 'Aqua A2' ],
        'Aqua G2'                                   => [ 'Intex', 'Aqua G2' ],
        'Aqua M5'                                   => [ 'Intex', 'Aqua M5' ],
        'Aqua N2'                                   => [ 'Intex', 'Aqua N2' ],
        'Aqua N7'                                   => [ 'Intex', 'Aqua N7' ],
        'Aqua N8'                                   => [ 'Intex', 'Aqua N8' ],
        'Aqua N15'                                  => [ 'Intex', 'Aqua N15' ],
        'Aqua N17'                                  => [ 'Intex', 'Aqua N17' ],
        'Aqua P2'                                   => [ 'Intex', 'Aqua P2' ],
        'Aqua P3'                                   => [ 'Intex', 'Aqua P3' ],
        'Aqua Q1'                                   => [ 'Intex', 'Aqua Q1' ],
        'Aqua Q1+'                                  => [ 'Intex', 'Aqua Q1' ],
        'AQUA Q2'                                   => [ 'Intex', 'Aqua Q2' ],
        'Aqua Q3'                                   => [ 'Intex', 'Aqua Q3' ],
        'Aqua Q4'                                   => [ 'Intex', 'Aqua Q4' ],
        'Aqua Q5'                                   => [ 'Intex', 'Aqua Q5' ],
        'Aqua Q7'                                   => [ 'Intex', 'Aqua Q7' ],
        'Aqua Q7N'                                  => [ 'Intex', 'Aqua Q7N' ],
        'Aqua Q7 Pro'                               => [ 'Intex', 'Aqua Q7 Pro' ],
        'Aqua R2'                                   => [ 'Intex', 'Aqua R2' ],
        'Aqua R3'                                   => [ 'Intex', 'Aqua R3' ],
        'Aqua R3+'                                  => [ 'Intex', 'Aqua R3' ],
        'Aqua R4'                                   => [ 'Intex', 'Aqua R4' ],
        'Aqua R4+'                                  => [ 'Intex', 'Aqua R4' ],
        'Aqua S7'                                   => [ 'Intex', 'Aqua S7' ],
        'Aqua T2'                                   => [ 'Intex', 'Aqua T2' ],
        'Aqua T3'                                   => [ 'Intex', 'Aqua T3' ],
        'Aqua T4'                                   => [ 'Intex', 'Aqua T4' ],
        'Aqua T6'                                   => [ 'Intex', 'Aqua T6' ],
        'Aqua V+'                                   => [ 'Intex', 'Aqua V+' ],
        'Aqua V2'                                   => [ 'Intex', 'Aqua V2' ],
        'Aqua V3'                                   => [ 'Intex', 'Aqua V3' ],
        'Aqua V3G'                                  => [ 'Intex', 'Aqua V3G' ],
        'Aqua V4'                                   => [ 'Intex', 'Aqua V4' ],
        'Aqua V5'                                   => [ 'Intex', 'Aqua V5' ],
        'Aqua X15'                                  => [ 'Intex', 'Aqua X15' ],
        'Aqua Y2'                                   => [ 'Intex', 'Aqua Y2' ],
        'Aqua Y2 1GB'                               => [ 'Intex', 'Aqua Y2' ],
        'Aqua Y2 IPS'                               => [ 'Intex', 'Aqua Y2' ],
        'Aqua Y2+'                                  => [ 'Intex', 'Aqua Y2+' ],
        'Aqua Y2 Pro'                               => [ 'Intex', 'Aqua Y2 Pro' ],
        'Aqua Y2 Power'                             => [ 'Intex', 'Aqua Y2 Power' ],
        'Aqua Y2 Remote'                            => [ 'Intex', 'Aqua Y2 Remote' ],
        'Aqua Y2 Ultra'                             => [ 'Intex', 'Aqua Y2 Ultra' ],
        'Aqua Y3'                                   => [ 'Intex', 'Aqua Y3' ],
        'Aqua Y4'                                   => [ 'Intex', 'Aqua Y3' ],
    ],

    '(Intex )?Cloud!!' => [
        'Cloud N12'                                 => [ 'Intex', 'Cloud N12' ],
        'Cloud Q11'                                 => [ 'Intex', 'Cloud Q11' ],
        'Intex Cloud X+'                            => [ 'Intex', 'Cloud X' ],
        'INTEX CLOUD X1'                            => [ 'Intex', 'Cloud X1' ],
        'Cloud X2'                                  => [ 'Intex', 'Cloud X2' ],
        'Cloud X3'                                  => [ 'Intex', 'Cloud X3' ],
        'Intex Cloud X4'                            => [ 'Intex', 'Cloud X4' ],
        'Cloud X5'                                  => [ 'Intex', 'Cloud X5' ],
        'INTEX Cloud X11'                           => [ 'Intex', 'Cloud X11' ],
        'Cloud X12'                                 => [ 'Intex', 'Cloud X12' ],
        'Intex Cloud Y1'                            => [ 'Intex', 'Cloud Y1' ],
        'Cloud Y2'                                  => [ 'Intex', 'Cloud Y2' ],
        'Cloud Y3'                                  => [ 'Intex', 'Cloud Y3' ],
        'INTEX Cloud Y4'                            => [ 'Intex', 'Cloud Y4' ],
        'INTEX Cloud Y4+'                           => [ 'Intex', 'Cloud Y4+' ],
        'Cloud Y5'                                  => [ 'Intex', 'Cloud Y5' ],
        'Intex Cloud Y7'                            => [ 'Intex', 'Cloud Y7' ],
        'Intex Cloud Y11'                           => [ 'Intex', 'Cloud Y11' ],
        'Intex Cloud y12'                           => [ 'Intex', 'Cloud Y12' ],
        'Cloud Y13 Plus'                            => [ 'Intex', 'Cloud Y13 Plus' ],
        'Cloud Y17+'                                => [ 'Intex', 'Cloud Y17 Plus' ],
        'Cloud Z5'                                  => [ 'Intex', 'Cloud Z5' ],
        'Cloud 4G Smart'                            => [ 'Intex', 'Cloud 4G Smart' ],
        'Cloud 4G Star'                             => [ 'Intex', 'Cloud 4G Star' ],
        'Cloud Cube'                                => [ 'Intex', 'Cloud Cube' ],
        'Cloud Flash'                               => [ 'Intex', 'Cloud Flash' ],
        'Cloud Force'                               => [ 'Intex', 'Cloud Force' ],
        'Cloud Gem+'                                => [ 'Intex', 'Cloud Gem+' ],
        'Cloud Jewel'                               => [ 'Intex', 'Cloud Jewel' ],
        'Cloud Pace'                                => [ 'Intex', 'Cloud Pace' ],
        'Cloud Power+'                              => [ 'Intex', 'Cloud Power+' ],
        'Cloud String HD'                           => [ 'Intex', 'Cloud String HD' ],
        'Cloud Swift'                               => [ 'Intex', 'Cloud Swift' ],
        'Cloud Zest'                                => [ 'Intex', 'Cloud Zest' ],
    ],

    'INTEX IRIS-II'                             => [ 'Intex', 'Iris 2', DeviceType::TABLET ],
    'INQ Cloud Touch'                           => [ 'INQ', 'Cloud Touch' ],
    'INQ Mayfair (EU)'                          => [ 'INQ', 'Mayfair' ],
    'A19S'                                      => [ 'ISA', 'A19S' ],
    'NS-13T001'                                 => [ 'Insignia', 'Flex Tablet', DeviceType::TABLET ],
    'IPRO i5S'                                  => [ 'IPRO', 'i5S' ],
    'TX18'                                      => [ 'Irbis', 'TX18', DeviceType::TABLET ],
    'ILT-MX100'                                 => [ 'iRiver', 'Tab', DeviceType::TABLET ],

    '(iNote|itel)!!' => [
        'iNote beyond'                              => [ 'iTel', 'iNote beyond' ],
        'iNote mini'                                => [ 'iTel', 'iNote mini' ],
        'itel IT1351'                               => [ 'iTel', 'IT1351' ],
        'itel IT1351E'                              => [ 'iTel', 'IT1351E' ],
        'itel it1400'                               => [ 'iTel', 'IT1400' ],
        'itel it1500'                               => [ 'iTel', 'IT1500' ],
        'itel it1508'                               => [ 'iTel', 'IT1508' ],
    ],

    'IVIO!!' => [
        'IVIO-DG20'                                 => [ 'Ivio', 'DG20' ],
        'IVIO DE38'                                 => [ 'Ivio', 'DE38' ],
    ],

    'iwoo i900'                                 => [ 'iwoo', 'i900' ],

    '(JIAYU|JY-)!!' => [
        'JIAYU F1'                                  => [ 'Jiayu', 'F1' ],
        'JY-F1'                                     => [ 'Jiayu', 'F1' ],
        'JY-F2'                                     => [ 'Jiayu', 'F2' ],
        'JY-G1'                                     => [ 'Jiayu', 'G1' ],
        'JY-G2'                                     => [ 'Jiayu', 'G2' ],
        'JY-G2 DualCore(Standard)'                  => [ 'Jiayu', 'G2' ],
        'JY-G2 Plus'                                => [ 'Jiayu', 'G2 Plus' ],
        'JY-G2 64'                                  => [ 'Jiayu', 'G2' ],
        'JY G2F'                                    => [ 'Jiayu', 'G2F' ],
        'JY-G2F'                                    => [ 'Jiayu', 'G2F' ],
        'JY-G2H'                                    => [ 'Jiayu', 'G2H' ],
        'JY-G2L'                                    => [ 'Jiayu', 'G2L' ],
        'JY-G2LS'                                   => [ 'Jiayu', 'G2LS' ],
        'Jiayu G2'                                  => [ 'Jiayu', 'G2' ],
        'Jiayu G2H'                                 => [ 'Jiayu', 'G2H' ],
        'Jiayu G2L'                                 => [ 'Jiayu', 'G2L' ],
        'Jiayu G2s'                                 => [ 'Jiayu', 'G2 Plus' ],
        'JY-G3'                                     => [ 'Jiayu', 'G3' ],
        'Jiayu G3'                                  => [ 'Jiayu', 'G3' ],
        'JIAYU-G3'                                  => [ 'Jiayu', 'G3' ],
        'JY-G3C'                                    => [ 'Jiayu', 'G3C' ],
        'JY-G3N!'                                   => [ 'Jiayu', 'G3N' ],
        'JYG3N'                                     => [ 'Jiayu', 'G3N' ],
        'JY-G3S'                                    => [ 'Jiayu', 'G3S' ],
        'JIAYU G3S'                                 => [ 'Jiayu', 'G3S' ],
        'JIAYU.G3S'                                 => [ 'Jiayu', 'G3S' ],
        'JY-G4'                                     => [ 'Jiayu', 'G4' ],
        'JY-G4\G5'                                  => [ 'Jiayu', 'G4' ],
        'JY-G4 G5'                                  => [ 'Jiayu', 'G4' ],
        'JY-G4C'                                    => [ 'Jiayu', 'G4C' ],
        'JY G4C'                                    => [ 'Jiayu', 'G4C' ],
        'Jiayu G4S'                                 => [ 'Jiayu', 'G4S' ],
        'JY-G4S'                                    => [ 'Jiayu', 'G4S' ],
        'JIAYU-G4S'                                 => [ 'Jiayu', 'G4S' ],
        'JY-G4T'                                    => [ 'Jiayu', 'G4T' ],
        'JY-G5'                                     => [ 'Jiayu', 'G5' ],
        'Jiayu G5S'                                 => [ 'Jiayu', 'G5S' ],
        'JY-G5S'                                    => [ 'Jiayu', 'G5S' ],
        'JY-G5S+'                                   => [ 'Jiayu', 'G5S+' ],
        'JY-G6'                                     => [ 'Jiayu', 'G6' ],
        'JY-S1'                                     => [ 'Jiayu', 'S1' ],
        'JY-S2'                                     => [ 'Jiayu', 'S2' ],
        'JY-S3'                                     => [ 'Jiayu', 'S3' ],
        'JY-S3S'                                    => [ 'Jiayu', 'S3S' ],
    ],

    'G2S'                                       => [ 'Jiayu', 'G2 Plus' ],
    'JT-Smart PC01'                             => [ 'Joy-IT', 'JT-Smart PC-01' ],
    'JJ5S+'                                     => [ 'Jugate', 'JJ5S+' ],

    'JC-A[0-9]{3,3}!!' => [
        'JC-A107'                                   => [ 'JuiCell', 'JC-A107' ],
        'JC-A109'                                   => [ 'JuiCell', 'JC-A109' ],
    ],

    'JXD!!' => [
        'JXD S601WIFI'                              => [ 'JXD', 'S601 WIFI', 'media' ],
        'JXD V5200'                                 => [ 'JXD', 'V5200', 'media' ],
        'JXD P200'                                  => [ 'JXD', 'P200', DeviceType::TABLET ],
        'JXD P300'                                  => [ 'JXD', 'P300', DeviceType::TABLET ],
        'JXD-P1000!'                                => [ 'JXD', 'P1000', DeviceType::TABLET ],
        'JXD-S80'                                   => [ 'JXD', 'S80', DeviceType::TABLET ],
        'JXD-S6600!'                                => [ 'JXD', 'S6600', DeviceType::TABLET ],
        'JXD S7600'                                 => [ 'JXD', 'S7600', DeviceType::TABLET ],
        'JXD-S8000'                                 => [ 'JXD', 'S8000', DeviceType::TABLET ],
        'JXD-S9000'                                 => [ 'JXD', 'S9000', DeviceType::TABLET ],
        'JXD-S9100'                                 => [ 'JXD', 'S9100', DeviceType::TABLET ],
    ],

    'A2'                                        => [ 'KakaTech', 'A2' ],

    'Karbonn!!' => [
        'Karbonn A1'                                => [ 'Karbonn', 'A1' ],
        'Karbonn A1 Plus Champ'                     => [ 'Karbonn', 'A1' ],
        'Karbonn A1 1 Plus Champ'                   => [ 'Karbonn', 'A1' ],
        'Karbonn A1*'                               => [ 'Karbonn', 'A1' ],
        'Karbonn A1+ Duple'                         => [ 'Karbonn', 'A1+' ],
        'Karbonn A1+ Super'                         => [ 'Karbonn', 'A1+' ],
        'Karbonn A2'                                => [ 'Karbonn', 'A2' ],
        'Karbonn A2+'                               => [ 'Karbonn', 'A2+' ],
        'Karbonn A4'                                => [ 'Karbonn', 'A4' ],
        'Karbonn A5'                                => [ 'Karbonn', 'A5' ],
        'Karbonn A5i'                               => [ 'Karbonn', 'A5i' ],
        'Karbonn A5s'                               => [ 'Karbonn', 'A5s' ],
        'Karbonn A6'                                => [ 'Karbonn', 'A6' ],
        'Karbonn A6+'                               => [ 'Karbonn', 'A6+' ],
        'Karbonn A7*'                               => [ 'Karbonn', 'A7' ],
        'Karbonn A8'                                => [ 'Karbonn', 'A8' ],
        'Karbonn A9'                                => [ 'Karbonn', 'A9' ],
        'Karbonn A9*'                               => [ 'Karbonn', 'A9' ],
        'Karbonn A9s'                               => [ 'Karbonn', 'A9s' ],
        'Karbonn A9+'                               => [ 'Karbonn', 'A9+' ],
        'Karbonn A10'                               => [ 'Karbonn', 'A10' ],
        'Karbonn A11*'                              => [ 'Karbonn', 'A11' ],
        'Karbonn A12'                               => [ 'Karbonn', 'A12' ],
        'Karbonn A12*'                              => [ 'Karbonn', 'A12' ],
        'Karbonn A12+'                              => [ 'Karbonn', 'A12+' ],
        'Karbonn A14'                               => [ 'Karbonn', 'A14' ],
        'Karbonn A18'                               => [ 'Karbonn', 'A18' ],
        'Karbonn A18+'                              => [ 'Karbonn', 'A18+' ],
        'Karbonn A19'                               => [ 'Karbonn', 'A19' ],
        'Karbonn A20'                               => [ 'Karbonn', 'A20' ],
        'Karbonn A21!'                              => [ 'Karbonn', 'A21' ],
        'Karbonn A25'                               => [ 'Karbonn', 'A25' ],
        'Karbonn A25+'                              => [ 'Karbonn', 'A25+' ],
        'Karbonn A26'                               => [ 'Karbonn', 'A26' ],
        'KarbonnA26'                                => [ 'Karbonn', 'A26' ],
        'Karbonn A27+'                              => [ 'Karbonn', 'A27' ],
        'Karbonn A30'                               => [ 'Karbonn', 'A30' ],
        'Karbonn A35'                               => [ 'Karbonn', 'A35' ],
        'Karbonn A40'                               => [ 'Karbonn', 'A40' ],
        'Karbonn A50'                               => [ 'Karbonn', 'A50' ],
        'Karbonn A51 Lite'                          => [ 'Karbonn', 'A51 Lite' ],
        'Karbonn A52+'                              => [ 'Karbonn', 'A52+' ],
        'Karbonn A66'                               => [ 'Karbonn', 'A66' ],
        'Karbonn A91'                               => [ 'Karbonn', 'A91' ],
        'Karbonn A92Plus'                           => [ 'Karbonn', 'A92 Plus' ],
        'Karbonn A93'                               => [ 'Karbonn', 'A93' ],
        'Karbonn A108'                              => [ 'Karbonn', 'A108' ],
        'Karbonn A119'                              => [ 'Karbonn', 'A119' ],
        'Karbonn A240'                              => [ 'Karbonn', 'A240' ],
        'Karbonn E8222'                             => [ 'Karbonn', 'E8222' ],
        'Karbonn ST52'                              => [ 'Karbonn', 'ST52', DeviceType::TABLET ],
        'Karbonn ST72'                              => [ 'Karbonn', 'ST72', DeviceType::TABLET ],
    ],

    'TA-FONE!!' => [
        'TA-FONE A34'                               => [ 'Karbonn', 'Ta-Fone A34' ],
        'TA-FONE A34 HD'                            => [ 'Karbonn', 'Ta-Fone A34 HD' ],
        'TA-FONE A37'                               => [ 'Karbonn', 'Ta-Fone A37' ],
        'TA-FONE A37 HD'                            => [ 'Karbonn', 'Ta-Fone A37 HD' ],
        'TA-FONE A39 HD'                            => [ 'Karbonn', 'Ta-Fone A39 HD' ],
    ],

    '(Karbonn|Titanium)!!' => [
        'Karbonn Titanium Hexa'                     => [ 'Karbonn', 'Titanium Hexa' ],
        'Titanium Octane'                           => [ 'Karbonn', 'Titanium Octane' ],
        'Titanium Octane Plus'                      => [ 'Karbonn', 'Titanium Octane Plus' ],
        'Titanium K9 Smart'                         => [ 'Karbonn', 'Titanium K9 Smart' ],
        'Titanium S1'                               => [ 'Karbonn', 'Titanium S1' ],
        'Titanium S1 Plus'                          => [ 'Karbonn', 'Titanium S1 Plus' ],
        'Karbonn Titanium S1 Plus'                  => [ 'Karbonn', 'Titanium S1 Plus' ],
        'Karbonn S2'                                => [ 'Karbonn', 'Titanium S2' ],
        'Karbonn Titanium S3'                       => [ 'Karbonn', 'Titanium S3' ],
        'Titanium S2 Plus'                          => [ 'Karbonn', 'Titanium S2 Plus' ],
        'Titanium S2Plus'                           => [ 'Karbonn', 'Titanium S2 Plus' ],
        'Karbonn Titanium S4'                       => [ 'Karbonn', 'Titanium S4' ],
        'Karbonn Titanium S4 Plus'                  => [ 'Karbonn', 'Titanium S4 Plus' ],
        'Titanium S5'                               => [ 'Karbonn', 'Titanium S5' ],
        'karbonn Titanium S5'                       => [ 'Karbonn', 'Titanium S5' ],
        'TitaniumS5-Karbonnroms'                    => [ 'Karbonn', 'Titanium S5' ],
        'Karbonn S5i'                               => [ 'Karbonn', 'Titanium S5i' ],
        'Karbonn Titanium S5 Plus'                  => [ 'Karbonn', 'Titanium S5 Plus' ],
        'Karbonn Titanium S5+'                      => [ 'Karbonn', 'Titanium S5 Plus' ],
        'Titanium S5+!'                             => [ 'Karbonn', 'Titanium S5 Plus' ],
        'Titanium S5 Ultra'                         => [ 'Karbonn', 'Titanium S5 Ultra' ],
        'Karbonn Titanium S6'                       => [ 'Karbonn', 'Titanium S6' ],
        'Karbonn Titanium S9'                       => [ 'Karbonn', 'Titanium S9' ],
        'Titanium S10'                              => [ 'Karbonn', 'Titanium S10' ],
        'Titanium S12 Delite'                       => [ 'Karbonn', 'Titanium S12 Delite' ],
        'Titanium S15'                              => [ 'Karbonn', 'Titanium S15' ],
        'Titanium S15 Ultra'                        => [ 'Karbonn', 'Titanium S15 Ultra' ],
        'Titanium S18'                              => [ 'Karbonn', 'Titanium S18' ],
        'Titanium S19'                              => [ 'Karbonn', 'Titanium S19' ],
        'Karbonn TITANIUM S20'                      => [ 'Karbonn', 'Titanium S20' ],
        'Titanium S21'                              => [ 'Karbonn', 'Titanium S21' ],
        'Titanium S22'                              => [ 'Karbonn', 'Titanium S22' ],
        'Karbonn Titanium S25'                      => [ 'Karbonn', 'Titanium S25' ],
        'Titanium S30'                              => [ 'Karbonn', 'Titanium S30' ],
        'Titanium S35'                              => [ 'Karbonn', 'Titanium S35' ],
        'Titanium S99'                              => [ 'Karbonn', 'Titanium S99' ],
        'Karbonn Titanium S99'                      => [ 'Karbonn', 'Titanium S99' ],
        'Titanium S109'                             => [ 'Karbonn', 'Titanium S109' ],
        'Titanium S200 HD'                          => [ 'Karbonn', 'Titanium S200 HD' ],
        'Titanium S201'                             => [ 'Karbonn', 'Titanium Dazzle S201' ],
        'Titanium S202'                             => [ 'Karbonn', 'Titanium Dazzle2 S202' ],
        'Titanium S203'                             => [ 'Karbonn', 'Titanium High 2 S203' ],
        'Titanium S204'                             => [ 'Karbonn', 'Titanium Dazzle3 S204' ],
        'TITANIUM S205 2GB'                         => [ 'Karbonn', 'Titanium S205' ],
        'S2052GB'                                   => [ 'Karbonn', 'Titanium S205' ],
        'Titanium S315'                             => [ 'Karbonn', 'Titanium Pop S315' ],
        'Titanium S320'                             => [ 'Karbonn', 'Titanium S320' ],
        'Titanium S360'                             => [ 'Karbonn', 'Titanium Mach Two S360' ],
        'Karbonn Titanium X'                        => [ 'Karbonn', 'Titanium X' ],
    ],

    'A7*'                                       => [ 'Karbonn', 'A7' ],
    'A7+'                                       => [ 'Karbonn', 'A7+' ],
    'A11'                                       => [ 'Karbonn', 'A11' ],
    'A21'                                       => [ 'Karbonn', 'A21' ],
    'A55i'                                      => [ 'Karbonn', 'Smart A55i' ],
    'Alfa A93 POP'                              => [ 'Karbonn', 'Alfa A93 Pop' ],
    'A111'                                      => [ 'Karbonn', 'A111' ],
    'K9 Smart 4G'                               => [ 'Karbonn', 'K9 Smart 4G' ],
    'Sparkle V'                                 => [ 'Karbonn', 'Sparkle V' ],
    'ST10'                                      => [ 'Karbonn', 'Smart Tab 10 Cosmic', DeviceType::TABLET ],
    'SmartTab1'                                 => [ 'Karbonn', 'Smart Tab 1', DeviceType::TABLET ],
    'KB901'                                     => [ 'Kaser', 'KB901', DeviceType::TABLET ],

    '(KAZAM|Thunder|Tornado|Trooper)!!' => [
        'KAZAM TV 45'                               => [ 'KAZAM', 'TV 45' ],
        'KAZAM Thunder 345'                         => [ 'KAZAM', 'Thunder 345' ],
        'KAZAM Thunder 345 LTE'                     => [ 'KAZAM', 'Thunder 345' ],
        'KAZAM Thunder 345L'                        => [ 'KAZAM', 'Thunder 345L' ],
        'Thunder 347'                               => [ 'KAZAM', 'Thunder 347' ],
        'KAZAM Thunder 350L'                        => [ 'KAZAM', 'Thunder 350L' ],
        'KAZAM Thunder 550'                         => [ 'KAZAM', 'Thunder 550' ],
        'KAZAM Thunder 550L'                        => [ 'KAZAM', 'Thunder 550L' ],
        'KAZAM Thunder Q45'                         => [ 'KAZAM', 'Thunder Q4.5' ],
        'KAZAM THUNDER2 45L'                        => [ 'KAZAM', 'Thunder 2 4.5L' ],
        'KAZAM Thunder2 50'                         => [ 'KAZAM', 'Thunder 2 5.0' ],
        'Thunder3 45 LTE'                           => [ 'KAZAM', 'Thunder 3 4.5' ],
        'Tornado 348'                               => [ 'KAZAM', 'Tornado 348' ],
        'KAZAM Tornado 350'                         => [ 'KAZAM', 'Tornado 350' ],
        'KAZAM Tornado 455L'                        => [ 'KAZAM', 'Tornado 455L' ],
        'KAZAM Tornado2 50'                         => [ 'KAZAM', 'Tornado 2 5.0' ],
        'KAZAM Trooper 440L'                        => [ 'KAZAM', 'Trooper 440L' ],
        'KAZAM Trooper 445L'                        => [ 'KAZAM', 'Trooper 445L' ],
        'KAZAM Trooper 450'                         => [ 'KAZAM', 'Trooper 450' ],
        'KAZAM Trooper 450L'                        => [ 'KAZAM', 'Trooper 450L' ],
        'KAZAM Trooper 451'                         => [ 'KAZAM', 'Trooper 451' ],
        'KAZAM Trooper 455'                         => [ 'KAZAM', 'Trooper 455' ],
        'KAZAM Trooper 540'                         => [ 'KAZAM', 'Trooper 540' ],
        'KAZAM Trooper 550'                         => [ 'KAZAM', 'Trooper 550' ],
        'KAZAM Trooper 550L'                        => [ 'KAZAM', 'Trooper 550L' ],
        'KAZAM Trooper 551'                         => [ 'KAZAM', 'Trooper 551' ],
        'KAZAM Trooper 555'                         => [ 'KAZAM', 'Trooper 555' ],
        'Trooper X35'                               => [ 'KAZAM', 'Trooper X3.5' ],
        'Trooper X40'                               => [ 'KAZAM', 'Trooper X4.0' ],
        'KAZAM Trooper X45'                         => [ 'KAZAM', 'Trooper X4.5' ],
        'KAZAM Trooper X50'                         => [ 'KAZAM', 'Trooper X5.0' ],
        'Trooper X55'                               => [ 'KAZAM', 'Trooper X5.5' ],
        'KAZAM Trooper2 40'                         => [ 'KAZAM', 'Trooper 2 4.0' ],
        'Trooper2 45'                               => [ 'KAZAM', 'Trooper 2 4.5' ],
        'KAZAM Trooper2 50'                         => [ 'KAZAM', 'Trooper 2 5.0' ],
        'Kazam Trooper2 60'                         => [ 'KAZAM', 'Trooper 2 6.0' ],
    ],

    'MT791'                                     => [ 'Keen High', 'MT791' ],

    'KENEKSI!!' => [
        'KENEKSI FIRE'                              => [ 'KENEKSI', 'Fire' ],
        'KENEKSI-Fire'                              => [ 'KENEKSI', 'Fire' ],
        'KENEKSI-Norma'                             => [ 'KENEKSI', 'Norma' ],
        'KENEKSI-SIGMA'                             => [ 'KENEKSI', 'Sigma' ],
        'KENEKSI-ZETA'                              => [ 'KENEKSI', 'Zeta' ],
    ],

    'Pro 10 dual core'                          => [ 'Kiano', 'Pro 10 Dual', DeviceType::TABLET ],
    'KIOTO 793'                                 => [ 'KIOTO', '793' ],
    'D91'                                       => [ 'KK', 'D91', DeviceType::TABLET ],
    'K080'                                      => [ 'Kobo', 'K080', DeviceType::EREADER ],
    'Vox'                                       => [ 'Kobo', 'Vox', DeviceType::EREADER ],
    'M1050S'                                    => [ 'KOCASO', 'M1050S', DeviceType::TABLET ],
    'SX9701W'                                   => [ 'KOCASO', 'SX9701W', DeviceType::TABLET ],

    '(KATBL|Agora)!!' => [
        'KATBL07AND'                                => [ 'Kogan', 'Agora' ],
        'KATBL10A16DA'                              => [ 'Kogan', 'Agora' ],
        'KATBL10A16E'                               => [ 'Kogan', 'Agora' ],
        'KATBL10AND'                                => [ 'Kogan', 'Agora' ],
        'Agora 4G'                                  => [ 'Kogan', 'Agora 4G' ],
        'Agora HD+'                                 => [ 'Kogan', 'Agora HD+' ],
        'Agora Quad Core'                           => [ 'Kogan', 'Agora Quad Core' ],
    ],

    'KOMU!!' => [
        'Komu Color'                                => [ 'Komu', 'Color' ],
        'KOMU ENERGY'                               => [ 'Komu', 'Energy' ],
        'KOMU-MINI'                                 => [ 'Komu', 'Mini' ],
    ],

    'V1'                                        => [ 'Konka', 'KOMI V1' ],

    'KONKA!!' => [
        'KONKA V615'                                => [ 'Konka', 'V615' ],
        'KONKA-V915'                                => [ 'Konka', 'V915' ],
        'KONKA V923'                                => [ 'Konka', 'V923' ],
        'KONKA V926'                                => [ 'Konka', 'V926' ],
        'KONKA V927'                                => [ 'Konka', 'V927' ],
        'KONKA V931'                                => [ 'Konka', 'V931' ],
        'KONKA V980'                                => [ 'Konka', 'V980' ],
        'KONKA V983'                                => [ 'Konka', 'V983' ],
        'konka W970'                                => [ 'Konka', 'W970' ],
        'konka W976'                                => [ 'Konka', 'W976' ],
    ],

    'K3'                                        => [ 'Konka', 'K3' ],
    'W990'                                      => [ 'Konka', 'W990' ],
    'A106'                                      => [ 'koobee', 'A160' ],
    'koobee-T550'                               => [ 'koobee', 'T550' ],

    'Koobe!!' => [
        'Koobe S7 Easy tablet'                      => [ 'Koobe', 'S7 Easy tablet', DeviceType::TABLET ],
        'Koobe X8 Slim Quadrum tablet'              => [ 'Koobe', 'X8 Slim Quadrum tablet', DeviceType::TABLET ],
    ],

    'KORIDY H15'                                => [ 'Koridy', 'H15' ],
    'KORIDY H16'                                => [ 'Koridy', 'H16' ],

    'KPT!!' => [
        'KPT A5'                                    => [ 'KPT', 'A5' ],
        'KPT A6'                                    => [ 'KPT', 'A6' ],
        'KPT A9'                                    => [ 'KPT', 'A9' ],
        'KPT A9PLUS'                                => [ 'KPT', 'A9+' ],
        'KPT A11PLUS'                               => [ 'KPT', 'A11+' ],
        'KPT A58T'                                  => [ 'KPT', 'A58T' ],
        'KPT A81PLUS'                               => [ 'KPT', 'A81+' ],
        'KPT A88'                                   => [ 'KPT', 'A88' ],
    ],

    '(EV|KM)-[ES][0-9]{3,3}!!' => [
        'EV-S100'                                   => [ 'Kttech', 'Take EV-S100' ],
        'KM-E100'                                   => [ 'Kttech', 'Take LTE KM-E100' ],
        'KM-S120'                                   => [ 'Kttech', 'Take 2 KM-S120' ],
        'KM-S200'                                   => [ 'Kttech', 'Take Janus KM-S200' ],
        'KM-S220'                                   => [ 'Kttech', 'Take Tachy KM-S220' ],
        'KM-S220H'                                  => [ 'Kttech', 'Take Tachy KM-S220' ],
        'KM-S300'                                   => [ 'Kttech', 'Take HD KM-S300' ],
        'KM-S330'                                   => [ 'Kttech', 'Take Fit KM-S330' ],
    ],

    'Kurio!!' => [
        'KurioPhone'                                => [ 'Kurio', 'Phone' ],
        'Kurio4S'                                   => [ 'Kurio', '4S' ],
        'Kurio7'                                    => [ 'Kurio', '7', DeviceType::TABLET ],
        'Kurio7S'                                   => [ 'Kurio', '7S', DeviceType::TABLET ],
        'Kurio-LTE'                                 => [ 'Kurio', '7X', DeviceType::TABLET ],
        'Kurio10S'                                  => [ 'Kurio', '10S', DeviceType::TABLET ],
        'Kurio-Lite'                                => [ 'Kurio', 'Lite', DeviceType::TABLET ],
    ],

    'Kyobo mirasol eReader'                     => [ 'Kyobo', 'eReader', DeviceType::EREADER ],
    'ISW11K'                                    => [ 'Kyocera', 'DIGNO ISW11K', 'carrier' => 'au' ],

    'KYL[0-9]{2,2}!!' => [
        'KYL21'                                     => [ 'Kyocera', 'DIGNO S KYL21', 'carrier' => 'au' ],
        'KYL22'                                     => [ 'Kyocera', 'DIGNO M KYL22', 'carrier' => 'au' ],
    ],

    'KC-01'                                     => [ 'Kyocera', 'KC-01' ],
    'KC-S301AE'                                 => [ 'Kyocera', 'S301' ],
    'KC-S701'                                   => [ 'Kyocera', 'TORQUE' ],
    'KCP01K'                                    => [ 'Kyocera', 'LUCE' ],
    'SKT01'                                     => [ 'Kyocera', 'TORQUE SKT01' ],

    'WX04K'                                     => [ 'Kyocera', 'DIGNO Dual WX04K', 'carrier' => 'Willcom' ],
    'WX06K'                                     => [ 'Kyocera', 'HONEY BEE WX06K', 'carrier' => 'Willcom' ],
    'WX10K'                                     => [ 'Kyocera', 'DIGNO Dual 2 WX10K', 'carrier' => 'Willcom' ],
    'JC-KSP8000'                                => [ 'Kyocera', 'Echo' ],
    'KSP8000'                                   => [ 'Kyocera', 'Echo' ],
    'Event'                                     => [ 'Kyocera', 'Event' ],
    'Rise'                                      => [ 'Kyocera', 'Rise' ],
    'Torque'                                    => [ 'Kyocera', 'Torque' ],
    'Zio'                                       => [ 'Kyocera', 'Zio' ],
    'E6782'                                     => [ 'Kyocera', 'Brigadier' ],
    'Hydro'                                     => [ 'Kyocera', 'Hydro' ],
    'Hydro PLUS'                                => [ 'Kyocera', 'Hydro PLUS' ],

    '(USCC-|KYOCERA-)?E[0-9]{4,4}!!' => [
        'KYOCERA-E6560'                             => [ 'Kyocera', 'DuraForce' ],
        'E6560C'                                    => [ 'Kyocera', 'DuraForce' ],
        'E6560L'                                    => [ 'Kyocera', 'DuraForce' ],
        'E6560T'                                    => [ 'Kyocera', 'DuraForce' ],
        'E6715'                                     => [ 'Kyocera', 'Torque XT' ],
        'KYOCERA-E6715'                             => [ 'Kyocera', 'Torque XT' ],
        'USCC-E6762'                                => [ 'Kyocera', 'DuraForce' ],
        'KYOCERA-E6762'                             => [ 'Kyocera', 'DuraForce' ],
        'E6782L'                                    => [ 'Kyocera', 'DuraScout' ],
        'KYOCERA-E6790'                             => [ 'Kyocera', 'DuraForce XD' ],
    ],

    '(USCC-|KYOCERA-)?C[0-9]{4,4}!!' => [
        'C51(20|21)!'                               => [ 'Kyocera', 'Milano' ],
        'C5155'                                     => [ 'Kyocera', 'Rise' ],
        'C5170'                                     => [ 'Kyocera', 'Hydro' ],
        'C5215'                                     => [ 'Kyocera', 'Hydro EDGE' ],
        'C5216'                                     => [ 'Kyocera', 'Hydro EDGE' ],
        'C6522'                                     => [ 'Kyocera', 'Hydro XTRM' ],
        'C6522N'                                    => [ 'Kyocera', 'Hydro XTRM' ],
        'USCC-C6721'                                => [ 'Kyocera', 'Hydro XTRM' ],
        'C6530'                                     => [ 'Kyocera', 'Hydro LIFE' ],
        'C6530N'                                    => [ 'Kyocera', 'Hydro LIFE' ],
        'C6725'                                     => [ 'Kyocera', 'Hydro VIBE' ],
        'C6730'                                     => [ 'Kyocera', 'Hydro ICON' ],
        'C6740'                                     => [ 'Kyocera', 'Hydro WAVE' ],
        'C6740N'                                    => [ 'Kyocera', 'Hydro WAVE' ],
        'C6742'                                     => [ 'Kyocera', 'Hydro VIEW' ],
        'KYOCERA-C6742'                             => [ 'Kyocera', 'Hydro VIEW' ],
        'C6743'                                     => [ 'Kyocera', 'Hydro REACH' ],
        'C6745'                                     => [ 'Kyocera', 'Hydro AIR' ],
        'KYOCERA-C6745'                             => [ 'Kyocera', 'Hydro AIR' ],
        'C6750'                                     => [ 'Kyocera', 'Hydro Elite' ],
    ],

    'M9300'                                     => [ 'Kyocera', 'Echo' ],

    'KY[FLTYV][0-9]{2,2}!!' => [
        'KYF31'                                     => [ 'Kyocera', 'GRATINA KYF31', 'carrier' => 'au' ],
        'KYL23'                                     => [ 'Kyocera', 'miraie KYL23', 'carrier' => 'au' ],
        'KYY21'                                     => [ 'Kyocera', 'URBANO L01', 'carrier' => 'au' ],
        'KYY22'                                     => [ 'Kyocera', 'URBANO L02', 'carrier' => 'au' ],
        'KYY23'                                     => [ 'Kyocera', 'URBANO L03', 'carrier' => 'au' ],
        'KYY24'                                     => [ 'Kyocera', 'TORQUE G01', 'carrier' => 'au' ],
        'KYV31'                                     => [ 'Kyocera', 'URBANO V01', 'carrier' => 'au' ],
        'KYV32'                                     => [ 'Kyocera', 'BASIO KYV32', 'carrier' => 'au' ],
        'KYV34'                                     => [ 'Kyocera', 'URBANO V02', 'carrier' => 'au' ],
        'KYV35'                                     => [ 'Kyocera', 'TORQUE G02', 'carrier' => 'au' ],
        'KYV36'                                     => [ 'Kyocera', 'DIGNO rafre', 'carrier' => 'au' ],
        'KYV37'                                     => [ 'Kyocera', 'Qua phone', 'carrier' => 'au' ],
        'KYT31'                                     => [ 'Kyocera', 'Qua tab', DeviceType::TABLET, 'carrier' => 'au' ],
    ],

    'URBANO PROGRESSO'                          => [ 'Kyocera', 'URBANO PROGRESSO', 'carrier' => 'au' ],

    '[0-9]0[0-9]KC?!!' => [
        '101K'                                      => [ 'Kyocera', 'HONEY BEE 101K', 'carrier' => 'Softbank' ],
        '201K'                                      => [ 'Kyocera', 'HONEY BEE 201K', 'carrier' => 'Softbank' ],
        '202K'                                      => [ 'Kyocera', 'DIGNO R 202K', 'carrier' => 'Softbank' ],
        '302KC'                                     => [ 'Kyocera', 'DIGNO T 302KC', 'carrier' => 'EMOBILE' ],
        '404KC'                                     => [ 'Kyocera', 'DIGNO C 404KC', 'carrier' => 'Y! Mobile' ],
        '503KC'                                     => [ 'Kyocera', 'DIGNO E 503KC', 'carrier' => 'Y! Mobile' ],
    ],

    'K-?Touch!!' => [
        'K-touch A9'                                => [ 'K-Touch', 'A9' ],
        'K-touch A10 Pro'                           => [ 'K-Touch', 'A10 Pro' ],
        'Ktouch A11'                                => [ 'K-Touch', 'A11' ],
        'K-touch A11plus'                           => [ 'K-Touch', 'A11+' ],
        'Ktouch A15'                                => [ 'K-Touch', 'A15' ],
        'K-Touch C666t'                             => [ 'K-Touch', 'C666' ],
        'K-Touch C960t'                             => [ 'K-Touch', 'C960' ],
        'K-Touch C966e'                             => [ 'K-Touch', 'C966' ],
        'K-Touch C980t'                             => [ 'K-Touch', 'C980' ],
        'K-Touch C986t'                             => [ 'K-Touch', 'C986' ],
        'K-Touch C986t+'                            => [ 'K-Touch', 'C986' ],
        'K-Touch C988t'                             => [ 'K-Touch', 'C988' ],
        'K-Touch C990'                              => [ 'K-Touch', 'C990' ],
        'K-Touch E7'                                => [ 'K-Touch', 'E7' ],
        'K-Touch E79'                               => [ 'K-Touch', 'E79' ],
        'K-Touch E70'                               => [ 'K-Touch', 'E70' ],
        'K-Touch E80'                               => [ 'K-Touch', 'E80' ],
        'K-Touch E88'                               => [ 'K-Touch', 'E88' ],
        'K-Touch E616'                              => [ 'K-Touch', 'E616' ],
        'K Touch E616'                              => [ 'K-Touch', 'E616' ],
        'K-Touch E619'                              => [ 'K-Touch', 'E619' ],
        'K-Touch E619+'                             => [ 'K-Touch', 'E619+' ],
        'K-Touch E621'                              => [ 'K-Touch', 'E621' ],
        'K-Touch E656'                              => [ 'K-Touch', 'E656' ],
        'K-Touch E688'                              => [ 'K-Touch', 'E688' ],
        'K-Touch E780'                              => [ 'K-Touch', 'E780' ],
        'K-Touch E800'                              => [ 'K-Touch', 'E800' ],
        'K-Touch E806'                              => [ 'K-Touch', 'E806' ],
        'K-Touch L820'                              => [ 'K-Touch', 'L820' ],
        'K-Touch Q4'                                => [ 'K-Touch', 'Q4' ],
        'K-Touch S2'                                => [ 'K-Touch', 'S2' ],
        'K-Touch S5'                                => [ 'K-Touch', 'S5' ],
        'K-Touch S5 Beiaigeqian'                    => [ 'K-Touch', 'S5' ],
        'K-Touch S5t'                               => [ 'K-Touch', 'S5t' ],
        'K-Touch Titan S100'                        => [ 'K-Touch', 'Titan S100' ],
        'K-Touch S757!'                             => [ 'K-Touch', 'S757' ],
        'K-Touch S787'                              => [ 'K-Touch', 'S787' ],
        'K-Touch T6'                                => [ 'K-Touch', 'T6' ],
        'K-Touch T60'                               => [ 'K-Touch', 'T60' ],
        'K-Touch T85+'                              => [ 'K-Touch', 'T85' ],
        'K-Touch T90'                               => [ 'K-Touch', 'T90' ],
        'K-Touch T91'                               => [ 'K-Touch', 'T91' ],
        'K-Touch T93'                               => [ 'K-Touch', 'T93' ],
        'K-Touch T96'                               => [ 'K-Touch', 'T96' ],
        'K-TouchT580'                               => [ 'K-Touch', 'T580' ],
        'K-Touch T619'                              => [ 'K-Touch', 'T619' ],
        'K-Touch T-619'                             => [ 'K-Touch', 'T619' ],
        'K-Touch T619+'                             => [ 'K-Touch', 'T619+' ],
        'K-Touch T621'                              => [ 'K-Touch', 'T621' ],
        'K-Touch T660'                              => [ 'K-Touch', 'T660' ],
        'K-Touch T760'                              => [ 'K-Touch', 'T760' ],
        'K-Touch T780'                              => [ 'K-Touch', 'T780' ],
        'K-Touch T780+'                             => [ 'K-Touch', 'T780+' ],
        'K-Touch T789'                              => [ 'K-Touch', 'T789' ],
        'K-Touch T800'                              => [ 'K-Touch', 'T800' ],
        'K-touch U2'                                => [ 'K-Touch', 'U2' ],
        'K-Touch U6'                                => [ 'K-Touch', 'U6' ],
        'K-Touch U7'                                => [ 'K-Touch', 'U7' ],
        'K-Touch U8'                                => [ 'K-Touch', 'U8' ],
        'K-Touch U9'                                => [ 'K-Touch', 'U9' ],
        'K-Touch U10'                               => [ 'K-Touch', 'U10' ],
        'K-Touch U81t'                              => [ 'K-Touch', 'U81t' ],
        'K-Touch U83t'                              => [ 'K-Touch', 'U83t' ],
        'K-Touch U86'                               => [ 'K-Touch', 'U86 Kiss' ],
        'K-Touch Kiss'                              => [ 'K-Touch', 'U86 Kiss' ],
        'K-Touch U90'                               => [ 'K-Touch', 'U90' ],
        'K-Touch V5'                                => [ 'K-Touch', 'V5' ],
        'KTouch v8'                                 => [ 'K-Touch', 'V8' ],
        'K-Touch V8'                                => [ 'K-Touch', 'V8' ],
        'KTouch v9'                                 => [ 'K-Touch', 'V9' ],
        'K-Touch V9'                                => [ 'K-Touch', 'V9' ],
        'K-Touch W68'                               => [ 'K-Touch', 'W68' ],
        'K-Touch W70'                               => [ 'K-Touch', 'W70' ],
        'K-Touch W88'                               => [ 'K-Touch', 'W88' ],
        'K-Touch W610'                              => [ 'K-Touch', 'W610' ],
        'K-TOUCH W610D'                             => [ 'K-Touch', 'W610D' ],
        'K-Touch W619!'                             => [ 'K-Touch', 'W619' ],
        'K-Touch W621'                              => [ 'K-Touch', 'W621' ],
        'K-Touch W650!'                             => [ 'K-Touch', 'W650' ],
        'K-Touch W655'                              => [ 'K-Touch', 'W655' ],
        'K-Touch W656'                              => [ 'K-Touch', 'W656' ],
        'K-Touch W658'                              => [ 'K-Touch', 'W658' ],
        'K-Touch W688'                              => [ 'K-Touch', 'W688' ],
        'K-Touch W700'                              => [ 'K-Touch', 'W700' ],
        'Ktouch w700'                               => [ 'K-Touch', 'W700' ],
        'K-Touch W700+'                             => [ 'K-Touch', 'W700+' ],
        'K-Touch W710'                              => [ 'K-Touch', 'W710' ],
        'K-Touch W719'                              => [ 'K-Touch', 'W719' ],
        'K-Touch W760'                              => [ 'K-Touch', 'W760' ],
        'K-Touch W780'                              => [ 'K-Touch', 'W780' ],
        'K-Touch W806!'                             => [ 'K-Touch', 'W806' ],
        'K-Touch W808'                              => [ 'K-Touch', 'W808' ],
        'K-Touch Kis 1'                             => [ 'K-Touch', 'Kis 1' ],
        'K-Touch Kis 2'                             => [ 'K-Touch', 'Kis 2' ],
        'K-Touch Tou ch 1'                          => [ 'K-Touch', 'Tou ch 1' ],
        'K-Touch Tou ch 2'                          => [ 'K-Touch', 'Tou ch 2' ],
        'K-Touch Tou ch2'                           => [ 'K-Touch', 'Tou ch 2' ],
        'K-Touch Tou ch 2c'                         => [ 'K-Touch', 'Tou ch 2 c' ],
        'K-Touch Tou ch 3'                          => [ 'K-Touch', 'Tou ch 3' ],
        'K-Touch Tou ch3'                           => [ 'K-Touch', 'Tou ch 3' ],
        'K-Touch Tou ch3c'                          => [ 'K-Touch', 'Tou ch 3 c' ],
        'K-Touch Tou ch3es'                         => [ 'K-Touch', 'Tou ch 3 es' ],
        'K-Touch Tou ch 5'                          => [ 'K-Touch', 'Tou ch 5' ],
    ],

    'Nibiru H1'                                 => [ 'K-Touch', 'Niburu Mars One H1' ],
    'E650'                                      => [ 'K-Touch', 'E650' ],
    'E780'                                      => [ 'K-Touch', 'E780' ],
    'E800'                                      => [ 'K-Touch', 'E800' ],
    'E815'                                      => [ 'K-Touch', 'E815' ],
    'W606'                                      => [ 'K-Touch', 'W606' ],
    'W619'                                      => [ 'K-Touch', 'W619' ],
    'W686'                                      => [ 'K-Touch', 'W686' ],
    'W700'                                      => [ 'K-Touch', 'W700' ],
    'W732'                                      => [ 'K-Touch', 'W732' ],
    'W800'                                      => [ 'K-Touch', 'W800' ],
    'W806'                                      => [ 'K-Touch', 'W806' ],
    'W808'                                      => [ 'K-Touch', 'W808' ],
    'W810'                                      => [ 'K-Touch', 'W810' ],
    'W880'                                      => [ 'K-Touch', 'W880' ],

    '(Lanix )?(Ilium|llium)!!' => [
        'ILIUM L400'                                => [ 'Lanix', 'Ilium L400' ],
        'Ilium L820'                                => [ 'Lanix', 'Ilium L820' ],
        'ILIUM L900'                                => [ 'Lanix', 'Ilium L900' ],
        'ILIUM L950'                                => [ 'Lanix', 'Ilium L950' ],
        'ILIUM L1000'                               => [ 'Lanix', 'Ilium L1000' ],
        'ILIUM L1100'                               => [ 'Lanix', 'Ilium L1100' ],
        'Ilium L1200'                               => [ 'Lanix', 'Ilium L1200' ],
        'Ilium LT500'                               => [ 'Lanix', 'Ilium LT500' ],
        'Ilium S100'                                => [ 'Lanix', 'Ilium S100' ],
        'Ilium S105'                                => [ 'Lanix', 'Ilium S105' ],
        'ILIUM S106'                                => [ 'Lanix', 'Ilium S106' ],
        'Lanix Ilium S115'                          => [ 'Lanix', 'Ilium S115' ],
        'Ilium S115'                                => [ 'Lanix', 'Ilium S115' ],
        'LANIX ILIUM S120'                          => [ 'Lanix', 'Ilium S120' ],
        'ILIUM S120'                                => [ 'Lanix', 'Ilium S120' ],
        'LANIX S120-U151'                           => [ 'Lanix', 'Ilium S120' ],
        'ILIUM S130'                                => [ 'Lanix', 'Ilium S130' ],
        'Ilium S200'                                => [ 'Lanix', 'Ilium S200' ],
        'Lanix Ilium S210'                          => [ 'Lanix', 'Ilium S210' ],
        'ILIUM S215'                                => [ 'Lanix', 'Ilium S215' ],
        'LANIX ILIUM S220'                          => [ 'Lanix', 'Ilium S220' ],
        'Lanix Ilium S400'                          => [ 'Lanix', 'Ilium S400' ],
        'Ilium S400'                                => [ 'Lanix', 'Ilium S400' ],
        'Lanix ILIUM S410'                          => [ 'Lanix', 'Ilium S410' ],
        'Lanix Ilium S420'                          => [ 'Lanix', 'Ilium S420' ],
        'Lanix Ilium S500'                          => [ 'Lanix', 'Ilium S500' ],
        'ILIUM S520'                                => [ 'Lanix', 'Ilium S520' ],
        'ILIUM S600'                                => [ 'Lanix', 'Ilium S600' ],
        'ILIUM S670'                                => [ 'Lanix', 'Ilium S670' ],
        'LANIX ILIUM S700'                          => [ 'Lanix', 'Ilium S700' ],
        'ILIUM S700'                                => [ 'Lanix', 'Ilium S700' ],
        'ILIUM X100'                                => [ 'Lanix', 'Ilium X100' ],
        'ILIUM X110'                                => [ 'Lanix', 'Ilium X110' ],
        'Ilium X200'                                => [ 'Lanix', 'Ilium X200' ],
        'ILIUM X400'                                => [ 'Lanix', 'Ilium X400' ],
        'Ilium X500B'                               => [ 'Lanix', 'Ilium X500B' ],
        'iliumPAD'                                  => [ 'Lanix', 'Ilium Pad', DeviceType::TABLET ],
        'ilium Pad E8'                              => [ 'Lanix', 'Ilium Pad E8', DeviceType::TABLET ],
        'ilium Pad E10'                             => [ 'Lanix', 'Ilium Pad E10', DeviceType::TABLET ],
        'ILIUM PAD E10Si'                           => [ 'Lanix', 'Ilium Pad E10 Si', DeviceType::TABLET ],
        'llium Pad L8'                              => [ 'Lanix', 'Ilium Pad L8', DeviceType::TABLET ],
    ],

    'Lark!!' => [
        'Lark Evolution X2 7'                       => [ 'Lark', 'Evolution X2 7', DeviceType::TABLET ],
        'Lark Evolution X2 7 3G-GPS'                => [ 'Lark', 'Evolution X2 7', DeviceType::TABLET ],
        'Lark FreeMe X2 7'                          => [ 'Lark', 'FreeMe X2 7', DeviceType::TABLET ],
        'Lark FreeMe X2 7 ver.2'                    => [ 'Lark', 'FreeMe X2 7', DeviceType::TABLET ],
    ],

    'FlairE3'                                   => [ 'Lava', 'Flair E3' ],
    'Flair P8'                                  => [ 'Lava', 'Flair P8' ],
    'Flair Z1'                                  => [ 'Lava', 'Flair Z1' ],

    'Iris!!' => [
        'Iris78W'                                   => [ 'Lava', 'Iris 78w' ],
        'iris 250'                                  => [ 'Lava', 'Iris 250' ],
        'iris310s'                                  => [ 'Lava', 'Iris 310s' ],
        'Iris 349'                                  => [ 'Lava', 'Iris 349' ],
        'Iris 349+'                                 => [ 'Lava', 'Iris 349+' ],
        'Iris349i'                                  => [ 'Lava', 'Iris 349i' ],
        'Iris349s'                                  => [ 'Lava', 'Iris 349s' ],
        'Iris 350'                                  => [ 'Lava', 'Iris 350' ],
        'iris 350m'                                 => [ 'Lava', 'Iris 350M' ],
        'iris 352Flair'                             => [ 'Lava', 'Iris 352 Flair' ],
        'iris 352E'                                 => [ 'Lava', 'Iris 352e' ],
        'iris353'                                   => [ 'Lava', 'Iris 353' ],
        'iris354'                                   => [ 'Lava', 'Iris 354' ],
        'iris 354'                                  => [ 'Lava', 'Iris 354' ],
        'iris354e'                                  => [ 'Lava', 'Iris 354e' ],
        'IRIS355'                                   => [ 'Lava', 'Iris 355' ],
        'iris356'                                   => [ 'Lava', 'Iris 356' ],
        'Iris 300'                                  => [ 'Lava', 'Iris 300' ],
        'iris 360m'                                 => [ 'Lava', 'Iris 360M' ],
        'iris400c'                                  => [ 'Lava', 'Iris 400 Colour' ],
        'iris 400s'                                 => [ 'Lava', 'Iris 400s' ],
        'iris 401e'                                 => [ 'Lava', 'Iris 401e' ],
        'IRIS402'                                   => [ 'Lava', 'Iris 402' ],
        'iris402+'                                  => [ 'Lava', 'Iris 402' ],
        'iris 402e'                                 => [ 'Lava', 'Iris 402e' ],
        'iris402e'                                  => [ 'Lava', 'Iris 402e' ],
        'iris402P'                                  => [ 'Lava', 'Iris 402P' ],
        'iris 404Flair'                             => [ 'Lava', 'Iris 404 Flair' ],
        'iris404e'                                  => [ 'Lava', 'Iris 404e' ],
        'iris405'                                   => [ 'Lava', 'Iris 405' ],
        'iris405+'                                  => [ 'Lava', 'Iris 405+' ],
        'iris 406Q'                                 => [ 'Lava', 'Iris 406Q' ],
        'iris 408e'                                 => [ 'Lava', 'Iris 408e' ],
        'iris 412'                                  => [ 'Lava', '3G 412' ],
        'Iris 415'                                  => [ 'Lava', '3G 415' ],
        'iris450'                                   => [ 'Lava', 'Iris 450' ],
        'iris 450P'                                 => [ 'Lava', 'Iris 450P' ],
        'iris454'                                   => [ 'Lava', '3G 454' ],
        'IRIS 455'                                  => [ 'Lava', 'Iris 455' ],
        'iris456'                                   => [ 'Lava', 'Iris 456' ],
        'iris458Q'                                  => [ 'Lava', 'Iris 458Q' ],
        'iris460'                                   => [ 'Lava', 'Iris 460' ],
        'iris500'                                   => [ 'Lava', 'Iris 500' ],
        'iris 500'                                  => [ 'Lava', 'Iris 500' ],
        'IRIS 501'                                  => [ 'Lava', 'Iris 501' ],
        'iris502'                                   => [ 'Lava', 'Iris 502' ],
        'iris503'                                   => [ 'Lava', 'Iris 503' ],
        'iris503e'                                  => [ 'Lava', 'Iris 503e' ],
        'iris504Q'                                  => [ 'Lava', 'Iris 504Q' ],
        'iris505'                                   => [ 'Lava', 'Iris 505' ],
        'iris 505'                                  => [ 'Lava', 'Iris 505' ],
        'iris506Q'                                  => [ 'Lava', 'Iris 506Q' ],
        'iris510'                                   => [ 'Lava', 'Iris 510' ],
        'iris 600'                                  => [ 'Lava', 'Iris 600' ],
        'iris700'                                   => [ 'Lava', 'Iris 700' ],
        'iris702'                                   => [ 'Lava', 'Iris 702' ],
        'iris 705'                                  => [ 'Lava', 'Iris 705' ],
        'iris708'                                   => [ 'Lava', 'Iris 708' ],
        'iris 750'                                  => [ 'Lava', 'Iris 750' ],
        'iris 810'                                  => [ 'Lava', 'Iris 810' ],
        'iris 870'                                  => [ 'Lava', 'Iris 870' ],
        'iris fuel10'                               => [ 'Lava', 'Iris fuel10' ],
        'iris Fuel50'                               => [ 'Lava', 'Iris fuel50' ],
        'iris Fuel60'                               => [ 'Lava', 'Iris fuel60' ],
        'Iris Fuel F1'                              => [ 'Lava', 'Iris Fuel F1' ],
        'iris pro 20'                               => [ 'Lava', 'Iris Pro 20' ],
        'iris pro 30'                               => [ 'Lava', 'Iris Pro 30' ],
        'iris SELFIE50'                             => [ 'Lava', 'Iris selfie 50' ],
        'iris X1'                                   => [ 'Lava', 'Iris X1' ],
        'irisX1+'                                   => [ 'Lava', 'Iris X1+' ],
        'iris X5'                                   => [ 'Lava', 'Iris X5' ],
        'irisX8'                                    => [ 'Lava', 'Iris X8' ],
        'Iris X8 L'                                 => [ 'Lava', 'Iris X8 L' ],
        'iris X9'                                   => [ 'Lava', 'Iris X9' ],
    ],

    '504Q'                                      => [ 'Lava', 'Iris 504Q' ],
    '504Q+'                                     => [ 'Lava', 'Iris 504Q+' ],
    '504QP'                                     => [ 'Lava', 'Iris 504QP' ],
    'Alfa L'                                    => [ 'Lava', 'Iris Alfa L' ],
    'Fuel F2'                                   => [ 'Lava', 'Iris Fuel F2' ],
    'N320'                                      => [ 'Lava', 'Iris N320' ],
    'X1 atom'                                   => [ 'Lava', 'Iris X1 Atom' ],
    'X1 atom L'                                 => [ 'Lava', 'Iris X1 Atom L' ],
    'X1 Atom s'                                 => [ 'Lava', 'Iris X1 Atom S' ],
    'X1 Beats'                                  => [ 'Lava', 'Iris X1 Beats' ],
    'X1 Grand'                                  => [ 'Lava', 'Iris X1 Grand' ],
    'X1 mini'                                   => [ 'Lava', 'Iris X1 mini' ],
    'X1 Selfie'                                 => [ 'Lava', 'Iris X1 Selfie' ],
    'X9'                                        => [ 'Lava', 'Iris X9' ],
    'LAVA iris 351'                             => [ 'Lava', 'Iris 351' ],
    'LAVA iRIS 504q'                            => [ 'Lava', 'Iris 504Q' ],

    'PixelV1'                                   => [ 'Lava', 'Pixel V1' ],
    'Pixel V2'                                  => [ 'Lava', 'Pixel V2' ],
    'Pixel V2+'                                 => [ 'Lava', 'Pixel V2+' ],

    'Lava A89'                                  => [ 'Lava', 'A89' ],
    'LAVA S12'                                  => [ 'Lava', 'S12' ],
    'LAVA V5'                                   => [ 'Lava', 'V5' ],

    'R30GT'                                     => [ 'Lavios', 'Revo R30GT', DeviceType::TABLET ],
    'LEAGOOLG13'                                => [ 'LEAGOOL', 'G13' ],

    'Le 1S'                                     => [ 'LeEco', 'Le 1s X500' ],
    'Le X500'                                   => [ 'LeEco', 'Le 1s X500' ],
    'Le X501'                                   => [ 'LeEco', 'Le 1s X501' ],
    'Le X506'                                   => [ 'LeEco', 'Le 1s X506' ],
    'Le X507'                                   => [ 'LeEco', 'Le 1s X507' ],
    'Le X509'                                   => [ 'LeEco', 'Le 1s X509' ],
    'Le X520'                                   => [ 'LeEco', 'Le 2 X520' ],
    'Le X522'                                   => [ 'LeEco', 'Le S3 X522' ],
    'Le X526'                                   => [ 'LeEco', 'Le 2 X526' ],
    'Le X527'                                   => [ 'LeEco', 'Le 2 X527' ],
    'Le X528'                                   => [ 'LeEco', 'Le 2 X528' ],
    'Le X620'                                   => [ 'LeEco', 'Le 2 Pro X620' ],
    'Le X621'                                   => [ 'LeEco', 'Le 2 Pro X621' ],
    'Le X625'                                   => [ 'LeEco', 'Le 2 Pro X625' ],
    'LEX720'                                    => [ 'LeEco', 'Le 3 Pro X720' ],
    'Le X820'                                   => [ 'LeEco', 'Le Max 2 X820' ],
    'Le X821'                                   => [ 'LeEco', 'Le Max 2 X821' ],
    'Le X822'                                   => [ 'LeEco', 'Le Max 2 X822' ],
    'Le X829'                                   => [ 'LeEco', 'Le Max 2 X829' ],
    'Le X829M'                                  => [ 'LeEco', 'Le Max 2 X829' ],
    'Le X920'                                   => [ 'LeEco', 'Le Max 3 X920' ],

    'X527'                                      => [ 'LeEco', 'Le 2 X527' ],

    'leepoo!!' => [
        'leepoo i500'                               => [ 'Leepoo', 'i500' ],
        'leepoo i580'                               => [ 'Leepoo', 'i580' ],
        'leepoo i600'                               => [ 'Leepoo', 'i600' ],
        'leepoo i800'                               => [ 'Leepoo', 'i800' ],
    ],

    'P5'                                        => [ 'Lemon', 'P5' ],
    'LEMON P7'                                  => [ 'Lemon', 'P7' ],
    'P105'                                      => [ 'Lemon', 'P105' ],
    'Lemon S3'                                  => [ 'Lemon', 'S3' ],
    'Lemon S8'                                  => [ 'Lemon', 'S8' ],

    'Lenco!!' => [
        'Lenco CARTAB-920'                          => [ 'Lenco', 'CarTab 920', DeviceType::TABLET ],
        'Lenco CARTAB-925'                          => [ 'Lenco', 'CarTab 925', DeviceType::TABLET ],
        'Lenco CoolTab-70'                          => [ 'Lenco', 'CoolTab 70', DeviceType::TABLET ],
        'Lenco CoolTAB-72'                          => [ 'Lenco', 'CoolTab 72', DeviceType::TABLET ],
        'Lenco CoolTab-80'                          => [ 'Lenco', 'CoolTab 80', DeviceType::TABLET ],
        'Lenco KidzTab-70'                          => [ 'Lenco', 'KidzTab 70', DeviceType::TABLET ],
        'Lenco KidzTab-520'                         => [ 'Lenco', 'KidzTab 520', DeviceType::TABLET ],
        'Lenco TAB-704'                             => [ 'Lenco', 'TAB 704', DeviceType::TABLET ],
        'Lenco TAB-712'                             => [ 'Lenco', 'TAB 712', DeviceType::TABLET ],
        'Lenco TAB-813'                             => [ 'Lenco', 'TAB 813', DeviceType::TABLET ],
        'Lenco TAB-832'                             => [ 'Lenco', 'TAB 832', DeviceType::TABLET ],
        'Lenco TAB-900'                             => [ 'Lenco', 'TAB 900', DeviceType::TABLET ],
        'Lenco TAB-925'                             => [ 'Lenco', 'TAB 925', DeviceType::TABLET ],
        'Lenco TAB-1014'                            => [ 'Lenco', 'TAB 1014', DeviceType::TABLET ],
        'Lenco TAB-1020'                            => [ 'Lenco', 'TAB 1020', DeviceType::TABLET ],
        'Lenco TAB-1022'                            => [ 'Lenco', 'TAB 1022', DeviceType::TABLET ],
        'Lenco TAB-1030'                            => [ 'Lenco', 'TAB 1030', DeviceType::TABLET ],
        'Lenco TAB-9720'                            => [ 'Lenco', 'TAB 9720', DeviceType::TABLET ],
    ],

    'LENCM900HZ'                                => [ 'Lenco', 'TAB 811', DeviceType::TABLET ],
    'TAB1011'                                   => [ 'Lenco', 'TAB 1011', DeviceType::TABLET ],
    'TAB-1030'                                  => [ 'Lenco', 'TAB 1030', DeviceType::TABLET ],
    'ThinkPad( Tablet)?!'                       => [ 'Lenovo', 'ThinkPad Tablet', DeviceType::TABLET ],
    'IdeaPad A1'                                => [ 'Lenovo', 'IdeaPad A1', DeviceType::TABLET ],
    'Lenovo A1-32AB0'                           => [ 'Lenovo', 'IdeaPad A1', DeviceType::TABLET ],
    'Lenovo A1-32AJ0'                           => [ 'Lenovo', 'IdeaPad A1', DeviceType::TABLET ],
    'IdeaPadA10'                                => [ 'Lenovo', 'IdeaPad A10', DeviceType::TABLET ],
    'K1'                                        => [ 'Lenovo', 'IdeaPad K1', DeviceType::TABLET ],
    'Ideapad K1!'                               => [ 'Lenovo', 'IdeaPad K1', DeviceType::TABLET ],
    'Ideapad S10-3T'                            => [ 'Lenovo', 'IdeaPad S10-3T', DeviceType::TABLET ],
    'Lenovo IdeaPad Yoga 11S'                   => [ 'Lenovo', 'IdeaPad Yoga 11S', DeviceType::TABLET ],
    'Lenovo IdeaPad Yoga 13'                    => [ 'Lenovo', 'IdeaPad Yoga 13', DeviceType::TABLET ],

    '(Lenovo ?)?(IdeaTab ?)?[AB][0-9]{4,4}!!' => [
        'Lenovo A1000L-F'                           => [ 'Lenovo', 'IdeaTab A1000', DeviceType::TABLET ],
        'IdeaTab ?A1000(-F|-G|-T)!'                 => [ 'Lenovo', 'IdeaTab A1000', DeviceType::TABLET ],
        'IdeaTab ?A1000(L-F)!'                      => [ 'Lenovo', 'IdeaTab A1000', DeviceType::TABLET ],
        'IdeaTab ?A1010(-T)!'                       => [ 'Lenovo', 'IdeaTab A1010', DeviceType::TABLET ],
        'IdeaTab ?A1020(-T)!'                       => [ 'Lenovo', 'IdeaTab A1020', DeviceType::TABLET ],
        'IdeaTab ?A1107!'                           => [ 'Lenovo', 'IdeaTab A1107', DeviceType::TABLET ],
        'Lenovo A2010-a'                            => [ 'Lenovo', 'IdeaTab A2010', DeviceType::TABLET ],
        'Lenovo A2010l36'                           => [ 'Lenovo', 'IdeaTab A2010', DeviceType::TABLET ],
        'Lenovo A2105'                              => [ 'Lenovo', 'IdeaTab A2105', DeviceType::TABLET ],
        'Lenovo A2107'                              => [ 'Lenovo', 'IdeaTab A2107', DeviceType::TABLET ],
        'IdeaTab ?A2107(A-F|A-H)!'                  => [ 'Lenovo', 'IdeaTab A2107', DeviceType::TABLET ],
        'A2107A-H'                                  => [ 'Lenovo', 'IdeaTab A2107', DeviceType::TABLET ],
        'IdeaTab ?A2109(A)!'                        => [ 'Lenovo', 'IdeaTab A2109', DeviceType::TABLET ],
        'A2109A'                                    => [ 'Lenovo', 'IdeaTab A2109', DeviceType::TABLET ],
        'IdeaTab ?A2207(A-H)!'                      => [ 'Lenovo', 'IdeaTab A2207', DeviceType::TABLET ],
        'IdeaTab ?A3000-(F|H)!'                     => [ 'Lenovo', 'IdeaTab A3000', DeviceType::TABLET ],
        'Lenovo A3000-H!'                           => [ 'Lenovo', 'IdeaTab A3000', DeviceType::TABLET ],
        'LENOVO IdeaTab A3000-H'                    => [ 'Lenovo', 'IdeaTab A3000', DeviceType::TABLET ],
        'Lenovo ?A3300(-H|-HV|-GV|-T)!'             => [ 'Lenovo', 'IdeaTab A3300', DeviceType::TABLET ],
        'Lenovo A3500(-F|-FL|-H|-HV)!'              => [ 'Lenovo', 'IdeaTab A3500', DeviceType::TABLET ],
        'IdeaTab ?A5000-E!'                         => [ 'Lenovo', 'IdeaTab A5000', DeviceType::TABLET ],
        'Lenovo A5500(-F|-HV|-H|HV)?!'              => [ 'Lenovo', 'IdeaTab A5500', DeviceType::TABLET ],
        'Lenovo A7600(-F|-HV|-H|H)!'                => [ 'Lenovo', 'IdeaTab A7600', DeviceType::TABLET ],
        'Lenovo B6000(-F|-H)!'                      => [ 'Lenovo', 'B6000 Yoga Tablet 8', DeviceType::TABLET ],
        'Lenovo B8000(-F|-H)!'                      => [ 'Lenovo', 'B8000 Yoga Tablet 10', DeviceType::TABLET ],
        'Lenovo B8080(-F|-H|-HV)!'                  => [ 'Lenovo', 'B8080 Yoga Tablet 10', DeviceType::TABLET ],
    ],

    'YOGA Tablet!!' => [
        'YOGA Tablet 2-830F'                        => [ 'Lenovo', 'Yoga Tablet 2 830F', DeviceType::TABLET ],
        'YOGA Tablet 2-830L'                        => [ 'Lenovo', 'Yoga Tablet 2 830L', DeviceType::TABLET ],
        'YOGA Tablet 2-830LC'                       => [ 'Lenovo', 'Yoga Tablet 2 830LC', DeviceType::TABLET ],
        'YOGA Tablet 2-1050F'                       => [ 'Lenovo', 'Yoga Tablet 2 1050F', DeviceType::TABLET ],
        'YOGA Tablet 2-1050L'                       => [ 'Lenovo', 'Yoga Tablet 2 1050L', DeviceType::TABLET ],
        'YOGA Tablet 2-1050LC'                      => [ 'Lenovo', 'Yoga Tablet 2 1050LC', DeviceType::TABLET ],
        'YOGA Tablet 2 Pro-1380F'                   => [ 'Lenovo', 'Yoga Tablet 2 Pro 1380F', DeviceType::TABLET ],
        'YOGA Tablet 2 Pro-1380L'                   => [ 'Lenovo', 'Yoga Tablet 2 Pro 1380L', DeviceType::TABLET ],
        'YOGA Tablet 3 Pro-1381L'                   => [ 'Lenovo', 'Yoga Tablet 3 Pro 1381L', DeviceType::TABLET ],
        'YOGA Tablet 8 Pro-1386L'                   => [ 'Lenovo', 'Yoga Tablet 8 Pro 1386L', DeviceType::TABLET ],
    ],

    'Lenovo YB1-X90L'                           => [ 'Lenovo', 'Yoga Book', DeviceType::TABLET ],
    'Lenovo YT3-X50F'                           => [ 'Lenovo', 'Yoga Tablet 3', DeviceType::TABLET ],
    'Lenovo YT3-X90L'                           => [ 'Lenovo', 'Yoga Tablet 3 Pro', DeviceType::TABLET ],

    '(Lenovo )?(Tab ?)?(2 ?)?[AS](7|8|10)!!' => [
        'Lenovo A7'                                 => [ 'Lenovo', 'Tab A7', DeviceType::TABLET ],
        'Lenovo A7-60HC'                            => [ 'Lenovo', 'Tab A7', DeviceType::TABLET ],
        'Lenovo A10-70LC'                           => [ 'Lenovo', 'Tab A10', DeviceType::TABLET ],
        'Lenovo 2 A7-30(F|HC|TC)!'                  => [ 'Lenovo', 'Tab 2 A7', DeviceType::TABLET ],
        'Tab2A7-(10|20)!'                           => [ 'Lenovo', 'Tab 2 A7', DeviceType::TABLET ],
        'Lenovo TAB 2 A7-30(D|F|H|DC|GC|HC)!'       => [ 'Lenovo', 'Tab 2 A7', DeviceType::TABLET ],
        'Lenovo 2 A8-50(F|L|LC)!'                   => [ 'Lenovo', 'Tab 2 A8', DeviceType::TABLET ],
        'Lenovo TAB 2 A8-50(F|L|LC)!'               => [ 'Lenovo', 'Tab 2 A8', DeviceType::TABLET ],
        'Lenovo TAB 2 A10-70(F|L)!'                 => [ 'Lenovo', 'Tab 2 A10', DeviceType::TABLET ],
        'Lenovo TAB S8-50(F|L|LC)!'                 => [ 'Lenovo', 'Tab S8', DeviceType::TABLET ],
        'Lenovo S8-50LC'                            => [ 'Lenovo', 'Tab S8', DeviceType::TABLET ],
    ],

    '(Lenovo ?)?(IdeaTab ?)?[KSV][0-9]{4,4}!!' => [
        'IdeaTab ?K2110A-(F)!'                      => [ 'Lenovo', 'IdeaTab K2110', DeviceType::TABLET ],
        'S2005A-H'                                  => [ 'Lenovo', 'IdeaTab S2005', DeviceType::TABLET ],
        'lenovo S2005'                              => [ 'Lenovo', 'IdeaTab S2005', DeviceType::TABLET ],
        'IdeaTab ?S2007A-(D|F|H)!'                  => [ 'Lenovo', 'IdeaTab S2007', DeviceType::TABLET ],
        'IdeaTab ?S2010A-(D|F|H)!'                  => [ 'Lenovo', 'IdeaTab S2010', DeviceType::TABLET ],
        'IdeaTab ?S2109A-(F)!'                      => [ 'Lenovo', 'IdeaTab S2109', DeviceType::TABLET ],
        'IdeaTab ?S2110(AF|AH)!'                    => [ 'Lenovo', 'IdeaTab S2110', DeviceType::TABLET ],
        'IdeaTab ?A2207A-(F)!'                      => [ 'Lenovo', 'IdeaTab S2207', DeviceType::TABLET ],
        'Lenovo S5000'                              => [ 'Lenovo', 'IdeaTab S5000', DeviceType::TABLET ],
        'Lenovo S5000-(F|H)!'                       => [ 'Lenovo', 'IdeaTab S5000', DeviceType::TABLET ],
        'IdeaTab ?S6000L?-(F|H)!'                   => [ 'Lenovo', 'IdeaTab S6000', DeviceType::TABLET ],
        'Lenovo S6000-H'                            => [ 'Lenovo', 'IdeaTab S6000', DeviceType::TABLET ],
        'Lenovo S6000L-(F|H)!'                      => [ 'Lenovo', 'IdeaTab S6000', DeviceType::TABLET ],
        'LENOVO IdeaTab S6000-H'                    => [ 'Lenovo', 'IdeaTab S6000', DeviceType::TABLET ],
        'IdeaTab ?V2007(A|A-D-I)!'                  => [ 'Lenovo', 'IdeaTab V2007', DeviceType::TABLET ],
        'IdeaTab ?V2010(A)!'                        => [ 'Lenovo', 'IdeaTab V2010', DeviceType::TABLET ],
    ],

    'Lenovo Pad A4'                             => [ 'Lenovo', 'Pad A4', DeviceType::TABLET ],

    'Lenovo'                                    => [ 'Lenovo', 'LePad', DeviceType::TABLET ],
    'A1 07'                                     => [ 'Lenovo', 'LePad', DeviceType::TABLET ],
    'lepad 001b'                                => [ 'Lenovo', 'LePad', DeviceType::TABLET ],
    'lepad 001n'                                => [ 'Lenovo', 'LePad', DeviceType::TABLET ],

    '(Lenovo |Lephone )?3GC101!'                => [ 'Lenovo', 'LePhone 3GC101' ],
    '(Lenovo |Lephone )?3GW100!'                => [ 'Lenovo', 'LePhone 3GW100' ],
    '(Lenovo |Lephone )?3GW101!'                => [ 'Lenovo', 'LePhone 3GW101' ],
    '(Lenovo )?S1[- ]37AH0!'                    => [ 'Lenovo', 'LePhone S1' ],
    '(Lenovo )?S2[- ]38A(H0|T0)!'               => [ 'Lenovo', 'LePhone S2' ],

    'Lenovo!!' => [
        'Lenovo A1000'                              => [ 'Lenovo', 'A1000' ],
        'Lenovo A1600-d'                            => [ 'Lenovo', 'A1600' ],
        'Lenovo A1900'                              => [ 'Lenovo', 'A1900' ],
        'Lenovo A2580'                              => [ 'Lenovo', 'A2580' ],
        'Lenovo A2800-d'                            => [ 'Lenovo', 'A2800' ],
        'Lenovo A2860!'                             => [ 'Lenovo', 'A2860' ],
        'Lenovo A3500'                              => [ 'Lenovo', 'A3500' ],
        'Lenovo A5000!'                             => [ 'Lenovo', 'A5000' ],
        'Lenovo A6000!'                             => [ 'Lenovo', 'A6000' ],
        'Lenovo A7000!'                             => [ 'Lenovo', 'A7000' ],
        'Lenovo A116!'                              => [ 'Lenovo', 'A116' ],
        'Lenovo A208!'                              => [ 'Lenovo', 'A208' ],
        'Lenovo A218!'                              => [ 'Lenovo', 'A218' ],
        'Lenovo A228t'                              => [ 'Lenovo', 'A228t' ],
        'Lenovo A238!'                              => [ 'Lenovo', 'A238' ],
        'Lenovo A269!'                              => [ 'Lenovo', 'A269' ],
        'Lenovo A278!'                              => [ 'Lenovo', 'A278' ],
        'Lenovo ?A288!'                             => [ 'Lenovo', 'A288' ],
        'Lenovo ?A298!'                             => [ 'Lenovo', 'A298' ],
        'Lenovo A300!'                              => [ 'Lenovo', 'A300' ],
        'Lenovo A305!'                              => [ 'Lenovo', 'A305' ],
        'Lenovo A308!'                              => [ 'Lenovo', 'A308' ],
        'Lenovo A316!'                              => [ 'Lenovo', 'A316' ],
        'Lenovo A318!'                              => [ 'Lenovo', 'A318' ],
        'Lenovo A319!'                              => [ 'Lenovo', 'A319' ],
        'Lenovo A320!'                              => [ 'Lenovo', 'A320' ],
        'Lenovo A326!'                              => [ 'Lenovo', 'A326' ],
        'Lenovo A328!'                              => [ 'Lenovo', 'A328' ],
        'Lenovo A330!'                              => [ 'Lenovo', 'A330' ],
        'Lenovo A338!'                              => [ 'Lenovo', 'A338' ],
        'Lenovo A355!'                              => [ 'Lenovo', 'A355' ],
        'Lenovo A356!'                              => [ 'Lenovo', 'A356' ],
        'Lenovo A358!'                              => [ 'Lenovo', 'A358' ],
        'Lenovo A360!'                              => [ 'Lenovo', 'A360' ],
        'Lenovo A365!'                              => [ 'Lenovo', 'A365' ],
        'Lenovo A366!'                              => [ 'Lenovo', 'A366' ],
        'Lenovo A368!'                              => [ 'Lenovo', 'A368' ],
        'Lenovo A369!'                              => [ 'Lenovo', 'A369' ],
        'Lenovo A370!'                              => [ 'Lenovo', 'A370' ],
        'Lenovo A370!'                              => [ 'Lenovo', 'A370' ],
        'Lenovo A375!'                              => [ 'Lenovo', 'A375' ],
        'Lenovo A376!'                              => [ 'Lenovo', 'A376' ],
        'Lenovo A378!'                              => [ 'Lenovo', 'A378' ],
        'Lenovo A380!'                              => [ 'Lenovo', 'A380' ],
        'Lenovo A385!'                              => [ 'Lenovo', 'A385' ],
        'Lenovo A388!'                              => [ 'Lenovo', 'A388' ],
        'Lenovo A390!'                              => [ 'Lenovo', 'A390' ],
        'Lenovo A395!'                              => [ 'Lenovo', 'A395' ],
        'Lenovo A396!'                              => [ 'Lenovo', 'A396' ],
        'Lenovo A398!'                              => [ 'Lenovo', 'A398' ],
        'Lenovo A399'                               => [ 'Lenovo', 'A399' ],
        'Lenovo A500!'                              => [ 'Lenovo', 'A505' ],
        'Lenovo A505!'                              => [ 'Lenovo', 'A500' ],
        'Lenovo A516!'                              => [ 'Lenovo', 'A516' ],
        'Lenovo A520!'                              => [ 'Lenovo', 'A520' ],
        'Lenovo A526!'                              => [ 'Lenovo', 'A526' ],
        'Lenovo A529!'                              => [ 'Lenovo', 'A529' ],
        'Lenovo A530!'                              => [ 'Lenovo', 'A530' ],
        'Lenovo A536!'                              => [ 'Lenovo', 'A536' ],
        'Lenovo A560!'                              => [ 'Lenovo', 'A560' ],
        'Lenovo A580!'                              => [ 'Lenovo', 'A580' ],
        'Lenovo A586!'                              => [ 'Lenovo', 'A586' ],
        'Lenovo ?A588!'                             => [ 'Lenovo', 'A588' ],
        'Lenovo A590!'                              => [ 'Lenovo', 'A590' ],
        'Lenovo A600!'                              => [ 'Lenovo', 'A600' ],
        'Lenovo A606!'                              => [ 'Lenovo', 'A606' ],
        'Lenovo A616!'                              => [ 'Lenovo', 'A616' ],
        'Lenovo A628!'                              => [ 'Lenovo', 'A628' ],
        'Lenovo A630!'                              => [ 'Lenovo', 'A630' ],
        'Lenovo A656!'                              => [ 'Lenovo', 'A656' ],
        'Lenovo A658!'                              => [ 'Lenovo', 'A658' ],
        'Lenovo A660!'                              => [ 'Lenovo', 'A660' ],
        'Lenovo A668!'                              => [ 'Lenovo', 'A668' ],
        'Lenovo A670!'                              => [ 'Lenovo', 'A670' ],
        'Lenovo A678!'                              => [ 'Lenovo', 'A678' ],
        'Lenovo A680!'                              => [ 'Lenovo', 'A680' ],
        'Lenovo A690!'                              => [ 'Lenovo', 'A690' ],
        'Lenovo A698!'                              => [ 'Lenovo', 'A698' ],
        'Lenovo A700!'                              => [ 'Lenovo', 'A700' ],
        'Lenovo A706!'                              => [ 'Lenovo', 'A706' ],
        'Lenovo A708!'                              => [ 'Lenovo', 'A708' ],
        'Lenovo A710!'                              => [ 'Lenovo', 'A710' ],
        'Lenovo A718!'                              => [ 'Lenovo', 'A718' ],
        'Lenovo A720!'                              => [ 'Lenovo', 'A720' ],
        'Lenovo A750!'                              => [ 'Lenovo', 'A750' ],
        'Lenovo A760!'                              => [ 'Lenovo', 'A760' ],
        'Lenovo A765!'                              => [ 'Lenovo', 'A765' ],
        'Lenovo A766!'                              => [ 'Lenovo', 'A766' ],
        'Lenovo A768t'                              => [ 'Lenovo', 'A768t' ],
        'Lenovo A770!'                              => [ 'Lenovo', 'A770' ],
        'Lenovo A780!'                              => [ 'Lenovo', 'A780' ],
        'Lenovo A785!'                              => [ 'Lenovo', 'A785' ],
        'Lenovo A788!'                              => [ 'Lenovo', 'A788' ],
        'Lenovo A789!'                              => [ 'Lenovo', 'A789' ],
        'Lenovo A790!'                              => [ 'Lenovo', 'A790' ],
        'Lenovo A798!'                              => [ 'Lenovo', 'A798' ],
        'Lenovo A800!'                              => [ 'Lenovo', 'A800' ],
        'Lenovo A805!'                              => [ 'Lenovo', 'A805' ],
        'Lenovo A806!'                              => [ 'Lenovo', 'A806' ],
        'Lenovo A808!'                              => [ 'Lenovo', 'A808' ],
        'Lenovo A816!'                              => [ 'Lenovo', 'A816' ],
        'Lenovo ?A820!'                             => [ 'Lenovo', 'A820' ],
        'lenovo-A820t'                              => [ 'Lenovo', 'A820' ],
        'Lenovo A828!'                              => [ 'Lenovo', 'A828' ],
        'Lenovo A830!'                              => [ 'Lenovo', 'A830' ],
        'Lenovo A850!'                              => [ 'Lenovo', 'A850' ],
        'Lenovo A858!'                              => [ 'Lenovo', 'A858' ],
        'Lenovo A859!'                              => [ 'Lenovo', 'A859' ],
        'Lenovo A860!'                              => [ 'Lenovo', 'A860' ],
        'Lenovo A880!'                              => [ 'Lenovo', 'A880' ],
        'Lenovo A889!'                              => [ 'Lenovo', 'A889' ],
        'Lenovo A890!'                              => [ 'Lenovo', 'A890' ],
        'Lenovo A916!'                              => [ 'Lenovo', 'A916' ],
        'Lenovo A936!'                              => [ 'Lenovo', 'A936' ],
        'Lenovo A938!'                              => [ 'Lenovo', 'A938' ],
        'Lenovo A998!'                              => [ 'Lenovo', 'A998' ],
        'Lenovo A60+?!'                             => [ 'Lenovo', 'A60' ],
        'Lenovo A65!'                               => [ 'Lenovo', 'A65' ],
        'Lenovo A66!'                               => [ 'Lenovo', 'A66' ],
        'Lenovo A68!'                               => [ 'Lenovo', 'A68' ],
        'Lenovo K800'                               => [ 'Lenovo', 'K800' ],
        'Lenovo K860!'                              => [ 'Lenovo', 'K860' ],
        'Lenovo K900!'                              => [ 'Lenovo', 'K900' ],
        'Lenovo K910!'                              => [ 'Lenovo', 'K910' ],
        'Lenovo K920!'                              => [ 'Lenovo', 'K920' ],
        'Lenovo K80M'                               => [ 'Lenovo', 'K80' ],
        'Lenovo K2'                                 => [ 'Lenovo', 'K2' ],
        'Lenovo k30'                                => [ 'Lenovo', 'K3' ],
        'Lenovo K30-T'                              => [ 'Lenovo', 'K3' ],
        'Lenovo K30-TM'                             => [ 'Lenovo', 'K3' ],
        'Lenovo K30-W'                              => [ 'Lenovo', 'K3' ],
        'Lenovo K31-t3'                             => [ 'Lenovo', 'K3' ],
        'Lenovo K3'                                 => [ 'Lenovo', 'K3' ],
        'Lenovo K50a40'                             => [ 'Lenovo', 'K3 Note' ],
        'Lenovo K50-t3s'                            => [ 'Lenovo', 'K3 Note' ],
        'Lenovo K50-T5'                             => [ 'Lenovo', 'K3 Note' ],
        'Lenovo K6'                                 => [ 'Lenovo', 'K6' ],
        'Lenovo N300'                               => [ 'Lenovo', 'N300', DeviceType::DESKTOP ],
        'Lenovo N308'                               => [ 'Lenovo', 'N308', DeviceType::DESKTOP ],
        'Lenovo N908'                               => [ 'Lenovo', 'N908' ],
        'Lenovo O3'                                 => [ 'Lenovo', 'O3' ],
        'Lenovo P70'                                => [ 'Lenovo', 'P70' ],
        'Lenovo P70-A'                              => [ 'Lenovo', 'P70' ],
        'Lenovo P70-t'                              => [ 'Lenovo', 'P70' ],
        'Lenovo P90'                                => [ 'Lenovo', 'P90' ],
        'Lenovo P700!'                              => [ 'Lenovo', 'P700' ],
        'Lenovo P770!'                              => [ 'Lenovo', 'P770' ],
        'Lenovo-P770'                               => [ 'Lenovo', 'P770' ],
        'Lenovo P780!'                              => [ 'Lenovo', 'P780' ],
        'Lenovo P786!'                              => [ 'Lenovo', 'P786' ],
        'Lenovo S60-a'                              => [ 'Lenovo', 'S60' ],
        'Lenovo S60-t'                              => [ 'Lenovo', 'S60' ],
        'Lenovo S60-w'                              => [ 'Lenovo', 'S60' ],
        'Lenovo S90-A'                              => [ 'Lenovo', 'S90' ],
        'Lenovo S90-e'                              => [ 'Lenovo', 'S90' ],
        'Lenovo S90-L'                              => [ 'Lenovo', 'S90' ],
        'Lenovo S90-t'                              => [ 'Lenovo', 'S90' ],
        'Lenovo S90-u'                              => [ 'Lenovo', 'S90' ],
        'Lenovo S560'                               => [ 'Lenovo', 'S560' ],
        'Lenovo S580'                               => [ 'Lenovo', 'S580' ],
        'Lenovo S650'                               => [ 'Lenovo', 'S650' ],
        'Lenovo S658t'                              => [ 'Lenovo', 'S658' ],
        'Lenovo S660'                               => [ 'Lenovo', 'S660' ],
        'Lenovo S668t'                              => [ 'Lenovo', 'S668' ],
        'Lenovo S680'                               => [ 'Lenovo', 'S680' ],
        'Lenovo S686'                               => [ 'Lenovo', 'S686' ],
        'Lenovo S696'                               => [ 'Lenovo', 'S696' ],
        'Lenovo S720!'                              => [ 'Lenovo', 'S720' ],
        'Lenovo S750'                               => [ 'Lenovo', 'S750' ],
        'Lenovo S760'                               => [ 'Lenovo', 'S760' ],
        'Lenovo S790'                               => [ 'Lenovo', 'S790' ],
        'Lenovo S810!'                              => [ 'Lenovo', 'S810' ],
        'Lenovo S820!'                              => [ 'Lenovo', 'S820' ],
        'Lenovo S850!'                              => [ 'Lenovo', 'S850' ],
        'Lenovo S856!'                              => [ 'Lenovo', 'S856' ],
        'Lenovo S858!'                              => [ 'Lenovo', 'S858' ],
        'Lenovo S860!'                              => [ 'Lenovo', 'S860' ],
        'Lenovo S868t'                              => [ 'Lenovo', 'S868' ],
        'Lenovo S870e'                              => [ 'Lenovo', 'S870' ],
        'Lenovo S880!'                              => [ 'Lenovo', 'S880' ],
        'Lenovo S890'                               => [ 'Lenovo', 'S890' ],
        'Lenovo S898!'                              => [ 'Lenovo', 'S898' ],
        'Lenovo ?S899!'                             => [ 'Lenovo', 'S899' ],
        'lenovo S900i'                              => [ 'Lenovo', 'S900' ],
        'Lenovo ?S920!'                             => [ 'Lenovo', 'S920' ],
        'Lenovo S930'                               => [ 'Lenovo', 'S930' ],
        'Lenovo S938!'                              => [ 'Lenovo', 'S938' ],
        'Lenovo S939'                               => [ 'Lenovo', 'S939' ],
        'Lenovo S950'                               => [ 'Lenovo', 'S950' ],
        'Lenovo S960'                               => [ 'Lenovo', 'S960' ],
        'Lenovo S968!'                              => [ 'Lenovo', 'S968' ],
        'Lenovo W100'                               => [ 'Lenovo', 'W100' ],
        'Lenovo A1010a20'                           => [ 'Lenovo', 'A Plus' ],
        'Lenovo A2016a40'                           => [ 'Lenovo', 'Vibe B' ],
        'Lenovo A7010a48'                           => [ 'Lenovo', 'Vibe K4 Note' ],
        'Lenovo A7020a40'                           => [ 'Lenovo', 'Vibe K5 Note' ],
        'Lenovo A7020a48'                           => [ 'Lenovo', 'Vibe K5 Note' ],
        'Lenovo K10a40'                             => [ 'Lenovo', 'Vibe C2' ],
        'Lenovo P2a42'                              => [ 'Lenovo', 'Vibe P2' ],
        'Lenovo S1a40'                              => [ 'Lenovo', 'Vibe S1' ],
        'Lenovo X2-(AP|CU|EU|TO|TR)!'               => [ 'Lenovo', 'Vibe X2' ],
        'Lenovo Z90!'                               => [ 'Lenovo', 'Vibe Shot' ],
        'Lenovo PB1-750M'                           => [ 'Lenovo', 'Phab' ],
        'Lenovo PB1-770(M|N|P)!'                    => [ 'Lenovo', 'Phab Plus' ],
        'Lenovo PB2-670M'                           => [ 'Lenovo', 'Phab 2 Plus' ],
        'Lenovo X910'                               => [ 'Lenovo', 'X910' ],
    ],

    'A750'                                      => [ 'Lenovo', 'A750' ],
    'A30t'                                      => [ 'Lenovo', 'A30' ],
    'OPPOLenovo A60'                            => [ 'Lenovo', 'A60' ],
    'K3 Note'                                   => [ 'Lenovo', 'K3 Note' ],
    'P700i'                                     => [ 'Lenovo', 'P700i' ],
    'S658t'                                     => [ 'Lenovo', 'S658' ],
    'S720i'                                     => [ 'Lenovo', 'S720' ],
    'S880'                                      => [ 'Lenovo', 'S880' ],

    'VIBE X2 (X2)'                              => [ 'Lenovo', 'Vibe X2' ],
    'VIBE X3'                                   => [ 'Lenovo', 'Vibe X3' ],
    'VIBE Z2 Pro (K920)'                        => [ 'Lenovo', 'Vibe Z2 Pro' ],

    'idea ?tv!!' => [
        'ideatv A21'                                => [ 'Lenovo', 'IDEA TV', DeviceType::TELEVISION ],
        'ideatv K72'                                => [ 'Lenovo', 'IDEA TV', DeviceType::TELEVISION ],
        'ideatv K82'                                => [ 'Lenovo', 'IDEA TV', DeviceType::TELEVISION ],
        'ideatv K91'                                => [ 'Lenovo', 'IDEA TV', DeviceType::TELEVISION ],
        'IDEA TV T100'                              => [ 'Lenovo', 'IDEA TV', DeviceType::TELEVISION ],
        'IDEA TV K91'                               => [ 'Lenovo', 'IDEA TV', DeviceType::TELEVISION ],
        'ideatv S9'                                 => [ 'Lenovo', 'IDEA TV', DeviceType::TELEVISION ],
        'ideatv S31'                                => [ 'Lenovo', 'IDEA TV', DeviceType::TELEVISION ],
        'ideatv S51'                                => [ 'Lenovo', 'IDEA TV', DeviceType::TELEVISION ],
        'ideatv S52'                                => [ 'Lenovo', 'IDEA TV', DeviceType::TELEVISION ],
        'ideatv S61'                                => [ 'Lenovo', 'IDEA TV', DeviceType::TELEVISION ],
    ],

    'LenovoTV 40S9'                             => [ 'Lenovo', 'TV 40S9', DeviceType::TELEVISION ],
    'LenovoTV 50S52'                            => [ 'Lenovo', 'TV 50S52', DeviceType::TELEVISION ],
    '501LV'                                     => [ 'Lenovo', 'Tab2 501LV', 'carrier' => 'Softbank' ],

    'ZUK Z1'                                    => [ 'Lenovo', 'ZUK Z1' ],
    'ZUK Z2'                                    => [ 'Lenovo', 'ZUK Z2' ],
    'ZUK Z2131'                                 => [ 'Lenovo', 'ZUK Z2' ],
    'ZUK Z2151'                                 => [ 'Lenovo', 'ZUK Z2' ],
    'ZUK Z2 Plus'                               => [ 'Lenovo', 'ZUK Z2 Plus' ],
    'Z2 Plus'                                   => [ 'Lenovo', 'ZUK Z2 Plus' ],
    'ZUK Z2132'                                 => [ 'Lenovo', 'ZUK Z2 Plus' ],
    'ZUK Z2 Pro'                                => [ 'Lenovo', 'ZUK Z2 Pro' ],
    'ZUK Z2121'                                 => [ 'Lenovo', 'ZUK Z2 Pro' ],
    'ZUK Z2122'                                 => [ 'Lenovo', 'ZUK Z2 Pro' ],

    '(BLF-)?lephone!!' => [
        'lephone 1800'                              => [ 'Lephone', '1800' ],
        'BLF-lephone 1900'                          => [ 'Lephone', '1900' ],
        'lephone 2800'                              => [ 'Lephone', '2800' ],
        'lephone 2900'                              => [ 'Lephone', '2900' ],
        'lephone T708'                              => [ 'Lephone', 'T708' ],
        'Lephone TD506'                             => [ 'Lephone', 'TD506' ],
        'Lephone TD8208'                            => [ 'Lephone', 'TD8208' ],
    ],

    'TD506'                                     => [ 'Lephone', 'TD506' ],

    'MFC[0-9]!!' => [
        'MFC190BBFR'                                => [ 'Lexibook', 'Barbie Tablet', DeviceType::TABLET ],
        'MFC150DEX'                                 => [ 'Lexibook', 'First Tablet', DeviceType::TABLET ],
        'MFC195FUDE'                                => [ 'Lexibook', 'Furby Tablet', DeviceType::TABLET ],
        'MFC195FUFR'                                => [ 'Lexibook', 'Furby Tablet', DeviceType::TABLET ],
        'MFC140FR1'                                 => [ 'Lexibook', 'LapTab', DeviceType::TABLET ],
        'MFC141FR'                                  => [ 'Lexibook', 'LapTab 2', DeviceType::TABLET ],
        'MFC162DE'                                  => [ 'Lexibook', 'Power Tablet', DeviceType::TABLET ],
        'MFC162FR'                                  => [ 'Lexibook', 'Power Tablet', DeviceType::TABLET ],
        'MFC180FR'                                  => [ 'Lexibook', 'Tablet Advanced', DeviceType::TABLET ],
        'MFC181FR'                                  => [ 'Lexibook', 'Tablet Advanced 2', DeviceType::TABLET ],
        'MFC195DCFR'                                => [ 'Lexibook', 'Tablet Disney Cars HD', DeviceType::TABLET ],
        'MFC195DPFR'                                => [ 'Lexibook', 'Tablet Disney Princesse HD', DeviceType::TABLET ],
        'MFC250FR'                                  => [ 'Lexibook', 'Tablet Junior', DeviceType::TABLET ],
        'MFC280FR'                                  => [ 'Lexibook', 'Tablet Junior 2', DeviceType::TABLET ],
        'MFC280DE'                                  => [ 'Lexibook', 'Tablet Junior 2', DeviceType::TABLET ],
        'MFC270DE'                                  => [ 'Lexibook', 'Tablet Junior Power Touch', DeviceType::TABLET ],
        'MFC270EN 09'                               => [ 'Lexibook', 'Tablet Junior Power Touch', DeviceType::TABLET ],
        'MFC270FR'                                  => [ 'Lexibook', 'Tablet Junior Power Touch', DeviceType::TABLET ],
        'mfc142fr'                                  => [ 'Lexibook', 'Tablet Kids', DeviceType::TABLET ],
        'MFC155EN 09'                               => [ 'Lexibook', 'Tablet Master', DeviceType::TABLET ],
        'MFC155ES'                                  => [ 'Lexibook', 'Tablet Master', DeviceType::TABLET ],
        'MFC155FR'                                  => [ 'Lexibook', 'Tablet Master', DeviceType::TABLET ],
        'MFC157FR'                                  => [ 'Lexibook', 'Tablet Master 2', DeviceType::TABLET ],
        'MFC157CZ'                                  => [ 'Lexibook', 'Tablet Master 2', DeviceType::TABLET ],
        'MFC163FR'                                  => [ 'Lexibook', 'Tablet Master 3', DeviceType::TABLET ],
        'MFC156FR'                                  => [ 'Lexibook', 'Tablet One', DeviceType::TABLET ],
        'MFC170FR'                                  => [ 'Lexibook', 'Tablet Ultra', DeviceType::TABLET ],
        'MFC175FR'                                  => [ 'Lexibook', 'Tablet Ultra', DeviceType::TABLET ],
        'MFC375FR'                                  => [ 'Lexibook', 'Tablet Ultra 2', DeviceType::TABLET ],
        'mfc500fr'                                  => [ 'Lexibook', 'Tablet XL', DeviceType::TABLET ],
        'MFC045FR'                                  => [ 'Lexibook', 'TabTab', DeviceType::TABLET ],
    ],

    'Le Pan TC802A'                             => [ 'Le Pan', 'Mini', DeviceType::TABLET ],
    'TC970'                                     => [ 'Le Pan', 'TC970', DeviceType::TABLET ],
    'TC970 (Wi-Fi)'                             => [ 'Le Pan', 'TC970', DeviceType::TABLET ],
    'Le Pan TC1010'                             => [ 'Le Pan', 'TC1010', DeviceType::TABLET ],
    'Le Pan TC1020'                             => [ 'Le Pan', 'TC1020', DeviceType::TABLET ],
    'LePanII'                                   => [ 'Le Pan', 'II', DeviceType::TABLET ],
    'TC975'                                     => [ 'Le Pan', 'III', DeviceType::TABLET ],
    'Le Pan S'                                  => [ 'Le Pan', 'S', DeviceType::TABLET ],
    'LG-AN160'                                  => [ 'LG', 'Fluid' ],

    'LG-?AS[0-9]{3,3}!!' => [
        'LGAS323'                                   => [ 'LG', 'L70' ],
        'LG-AS323'                                  => [ 'LG', 'L70' ],
        'LG-AS330'                                  => [ 'LG', 'K7' ],
        'LGAS375'                                   => [ 'LG', 'K8' ],
        'LG-AS680'                                  => [ 'LG', 'Optimus 2' ],
        'LG-AS695'                                  => [ 'LG', 'Optimus Plus' ],
        'LG-AS730'                                  => [ 'LG', 'Optimus Select' ],
        'LG-AS750'                                  => [ 'LG', 'L70' ],
        'LG-AS780'                                  => [ 'LG', 'Optimus F7' ],
        'LG-AS811'                                  => [ 'LG', 'G4' ],
        'LG-AS840'                                  => [ 'LG', 'Optimus Tag' ],
        'LG-AS855'                                  => [ 'LG', 'Ignite' ],
        'LG-AS870'                                  => [ 'LG', 'Optimus F5' ],
        'LG-AS876'                                  => [ 'LG', 'L70' ],
        'LG-AS9(85|90)!'                            => [ 'LG', 'G3' ],
        'LGAS991'                                   => [ 'LG', 'G4' ],
        'LG-AS9(91)!'                               => [ 'LG', 'G4' ],
        'LGAS992'                                   => [ 'LG', 'G5' ],
        'LGAS995'                                   => [ 'LG', 'G Flex 2' ],
    ],

    'LG-?C[0-9]{3,3}!!' => [
        'LG-C520'                                   => [ 'LG', 'C520' ],
        'LG-C5(50|55)!'                             => [ 'LG', 'Optimus Chat' ],
        'LGC660!'                                   => [ 'LG', 'Optimus Pro' ],
        'LG-C660!'                                  => [ 'LG', 'Optimus Pro' ],
        'LG-C710!'                                  => [ 'LG', 'Aloha' ],
        'LG-C729'                                   => [ 'LG', 'DoublePlay' ],
        'LG-C800G'                                  => [ 'LG', 'Eclypse' ],
    ],

    'LG-CX670'                                  => [ 'LG', 'Optimus One' ],

    'LG-?D[0-9]{3,3}!!' => [
        'LG-D1(00|05|07)!'                          => [ 'LG', 'L20' ],
        'LG-D1(20|23|25|27)!'                       => [ 'LG', 'L30 Sporty' ],
        'LG-D1(50|57)!'                             => [ 'LG', 'L35' ],
        'LG-D1(60|65|70|75|80)!'                    => [ 'LG', 'L40' ],
        'LG-D2(13|21|27)!'                          => [ 'LG', 'L50 Sporty' ],
        'LG-D2(80|85)!'                             => [ 'LG', 'L65' ],
        'LG-D2(90|95)!'                             => [ 'LG', 'L Fino' ],
        'LG-D3(15|17)!'                             => [ 'LG', 'F70' ],
        'LG-D3(20|21|25|29|30)!'                    => [ 'LG', 'L70' ],
        'LGD321'                                    => [ 'LG', 'L70' ],
        'LG-D3(30|31|35)!'                          => [ 'LG', 'L Bello' ],
        'LG-D3(32)!'                                => [ 'LG', 'L80+' ],
        'LG-D3(37)!'                                => [ 'LG', 'L Prime' ],
        'LG-D340!'                                  => [ 'LG', 'L70 Tri' ],
        'LG-D3(70|73|75|80|85)!'                    => [ 'LG', 'L80' ],
        'LG-D3(90|92|93)!'                          => [ 'LG', 'F60' ],
        'LG-D4(00|05|10|15)!'                       => [ 'LG', 'L90' ],
        'LG-D486!'                                  => [ 'LG', 'Wine Smart' ],
        'LGD500'                                    => [ 'LG', 'Optimus F6' ],
        'LG-D5(00|05)!'                             => [ 'LG', 'Optimus F6' ],
        'LG-D520!'                                  => [ 'LG', 'Optimus F3Q' ],
        'LG-D605!'                                  => [ 'LG', 'Optimus L9 II' ],
        'LG-D6(10|18|20|25)!'                       => [ 'LG', 'G2 mini' ],
        'LGD618'                                    => [ 'LG', 'G2 mini' ],
        'LG-D6(31)!'                                => [ 'LG', 'G3 Vista' ],
        'LG-D6(80|81|82|83|84)!'                    => [ 'LG', 'G Pro Lite' ],
        'LG-D6(85|86)!'                             => [ 'LG', 'G Pro Lite Dual' ],
        'LG-D6(90|93)!'                             => [ 'LG', 'G3 Stylus' ],
        'LG-D700!'                                  => [ 'LG', 'Optimus L9' ],
        'LG-D722J!'                                 => [ 'LG', 'G3 Beat' ],
        'LG-D7(22|24)!'                             => [ 'LG', 'G3 S' ],
        'LG-D7(23)!'                                => [ 'LG', 'G3 mini' ],
        'LG-D7(25|26|27)!'                          => [ 'LG', 'G3 Vigor' ],
        'LG-D7(28|29)!'                             => [ 'LG', 'G3 Beat' ],
        'LG-D8(00|01|02|03|05|06)!'                 => [ 'LG', 'G2' ],
        'LG-D8(20|21)!'                             => [ 'LG', 'Nexus 5' ],
        'LG-D8(30|37|38)!'                          => [ 'LG', 'G Pro 2' ],
        'LG-D8(50|51|52|55|56|58|59)!'              => [ 'LG', 'G3' ],
        'LGD850'                                    => [ 'LG', 'G3' ],
        'LGD855'                                    => [ 'LG', 'G3' ],
        'LG-D8(57)!'                                => [ 'LG', 'Titan' ],
        'LG-D9(50|51|55|56|58|59)!'                 => [ 'LG', 'G Flex' ],
    ],

    'LG-DS1203'                                 => [ 'LG', 'G2' ],

    'LG-?E[0-9]{3,3}!!' => [
        'LG-E400!'                                  => [ 'LG', 'Optimus L3' ],
        'LG-E405!'                                  => [ 'LG', 'Optimus L3 Dual' ],
        'LG-E4(10|11)!'                             => [ 'LG', 'Optimus L1 II' ],
        'LG-E4(15|20)!'                             => [ 'LG', 'Optimus L1 II Dual' ],
        'LG-E4(25|30|31)!'                          => [ 'LG', 'Optimus L3 II' ],
        'LG-E435!'                                  => [ 'LG', 'Optimus L3 II Dual' ],
        'LG-E440!'                                  => [ 'LG', 'Optimus L4 II' ],
        'LG-E445!'                                  => [ 'LG', 'Optimus L4 II Dual' ],
        'LG-E4(50|51|60)!'                          => [ 'LG', 'Optimus L5 II' ],
        'LG-E455!'                                  => [ 'LG', 'Optimus L5 II Dual' ],
        'LG-E465!'                                  => [ 'LG', 'Optimus L4 II' ],
        'LG-E467!'                                  => [ 'LG', 'Optimus L4 II Dual' ],
        'LG-E470!'                                  => [ 'LG', 'Optimus L4 II Triple' ],
        'LG-E475!'                                  => [ 'LG', 'Optimus L1 II Tri' ],
        'LG-E510!'                                  => [ 'LG', 'Optimus Hub' ],
        'LG-E6(10|12|17)!'                          => [ 'LG', 'Optimus L5' ],
        'LGE610'                                    => [ 'LG', 'Optimus L5' ],
        'LG-E6(14|15)!'                             => [ 'LG', 'Optimus L5 Dual' ],
        'LGE615F'                                   => [ 'LG', 'Optimus L5 Dual' ],
        'LG-E720!'                                  => [ 'LG', 'Optimus Chic' ],
        'LG-E730!'                                  => [ 'LG', 'Optimus Sol' ],
        'LG-E805!'                                  => [ 'LG', 'Optimus G2' ],
        'LG-E940!'                                  => [ 'LG', 'Optimus G Pro' ],
        'LG-E960!'                                  => [ 'LG', 'Nexus 4' ],
        'LG-E9(70|71|73|75|76|77|78|87)!'           => [ 'LG', 'Optimus G' ],
        'LG-E9(80|81|85|86|88|89)!'                 => [ 'LG', 'Optimus G Pro' ],
    ],

    'LG-F[0-9]{3,3}!!' => [
        'LG-F100!'                                  => [ 'LG', 'Optimus Vu' ],
        'LG-F120!'                                  => [ 'LG', 'Optimus LTE Tag' ],
        'LG-F160!'                                  => [ 'LG', 'Optimus LTE II' ],
        'LG-F180!'                                  => [ 'LG', 'Optimus G' ],
        'LG-F200!'                                  => [ 'LG', 'Optimus Vu II' ],
        'LG-F220!'                                  => [ 'LG', 'Optimus GK' ],
        'LG-F240!'                                  => [ 'LG', 'Optimus G Pro' ],
        'LG-F260!'                                  => [ 'LG', 'Optimus LTE III' ],
        'LG-F300!'                                  => [ 'LG', 'Vu 3' ],
        'LG-F310!'                                  => [ 'LG', 'GX' ],
        'LG-F320!'                                  => [ 'LG', 'G2' ],
        'LG-F340!'                                  => [ 'LG', 'G Flex' ],
        'LG-F350!'                                  => [ 'LG', 'G Pro 2' ],
        'LG-F370!'                                  => [ 'LG', 'F70' ],
        'LG-F390!'                                  => [ 'LG', 'G2 mini' ],
        'LG-F400!'                                  => [ 'LG', 'G3' ],
        'LG-F410!'                                  => [ 'LG', 'G3 A' ],
        'LG-F430!'                                  => [ 'LG', 'Gx2' ],
        'LG-F440!'                                  => [ 'LG', 'ice cream smart' ],
        'LG-F460!'                                  => [ 'LG', 'G3 Cat.6' ],
        'LG-F470!'                                  => [ 'LG', 'G3 Beat' ],
        'LG-F480!'                                  => [ 'LG', 'Wine Smart' ],
        'LG-F490!'                                  => [ 'LG', 'G3 Screen' ],
        'LG-F500!'                                  => [ 'LG', 'G4' ],
        'LG-F510!'                                  => [ 'LG', 'G Flex 2' ],
        'LG-F520!'                                  => [ 'LG', 'AKA' ],
        'LG-F540!'                                  => [ 'LG', 'Volt' ],
        'LG-F560!'                                  => [ 'LG', 'G Stylo' ],
        'LG-F570!'                                  => [ 'LG', 'band Play' ],
        'LG-F580!'                                  => [ 'LG', 'Gentle' ],
        'LG-F590!'                                  => [ 'LG', 'L5000' ],
        'LG-F600!'                                  => [ 'LG', 'V10' ],
        'LG-F610!'                                  => [ 'LG', 'Wine Smart Jazz' ],
        'LG-F620!'                                  => [ 'LG', 'Class' ],
        'LG-F640!'                                  => [ 'LG', 'Volt S' ],
        'LG-F650!'                                  => [ 'LG', 'X Screen' ],
        'LG-F670!'                                  => [ 'LG', 'K10' ],
        'LG-F700!'                                  => [ 'LG', 'G5' ],
        'LG-F720!'                                  => [ 'LG', 'Stylus 2' ],
        'LG-F740!'                                  => [ 'LG', 'X Skin' ],
        'LG-F750!'                                  => [ 'LG', 'X Power' ],
        'LG-F770!'                                  => [ 'LG', 'X5' ],
        'LG-F800!'                                  => [ 'LG', 'V20' ],
        'LG-F820!'                                  => [ 'LG', 'U' ],
    ],

    'LG-GT540!'                                 => [ 'LG', 'Optimus' ],
    'LG-GW620!'                                 => [ 'LG', 'GW620 Eve' ],

    'LG-H[0-9]{3,3}!!' => [
        'LG-H2(20|21|22)!'                          => [ 'LG', 'Joy' ],
        'LG-H3(20|24|26)!'                          => [ 'LG', 'Leon' ],
        'LG-H3(40|42|45)!'                          => [ 'LG', 'Leon' ],
        'LG-H3(43)!'                                => [ 'LG', 'Risio' ],
        'LG-H410!'                                  => [ 'LG', 'Wine Smart' ],
        'LG-H4(20|40|41)!'                          => [ 'LG', 'Spirit' ],
        'LG-H4(22|42)!'                             => [ 'LG', 'Volt' ],
        'LG-H4(43|45)!'                             => [ 'LG', 'Escape2' ],
        'LG-H5(00|02|20)!'                          => [ 'LG', 'Magna' ],
        'LG-H5(22)!'                                => [ 'LG', 'Prime Plus' ],
        'LG-H5(25)!'                                => [ 'LG', 'G4c' ],
        'LG-H5(40|42)!'                             => [ 'LG', 'G4 Stylus' ],
        'LG-H6(30|31|34|35|36)!'                    => [ 'LG', 'G Stylo' ],
        'LG-H650!'                                  => [ 'LG', 'Zero' ],
        'LG-H700!'                                  => [ 'LG', 'H700' ],
        'LG-H7(31)!'                                => [ 'LG', 'G4 Vigor' ],
        'LG-H7(34|35|36)!'                          => [ 'LG', 'G4s' ],
        'LG-H7(40)!'                                => [ 'LG', 'G Vista 2' ],
        'LG-H7(78|79|88)!'                          => [ 'LG', 'AKA' ],
        'LG-H8(10|11|12|15|18|19)!'                 => [ 'LG', 'G4' ],
        'LG-H8(20|30|31|50|60|68)!'                 => [ 'LG', 'G5' ],
        'LG-H8(40|45|48)!'                          => [ 'LG', 'G5 SE' ],
        'LG-H8(58)!'                                => [ 'LG', 'G5 Speed' ],
        'LG-H8(70|71|72|73)!'                       => [ 'LG', 'G6' ],
        'LG-H9(10|15|18)!'                          => [ 'LG', 'V20' ],
        'LG-H9(50|55|59)!'                          => [ 'LG', 'G Flex 2' ],
        'LG-H9(00|01|60|61|62|68)!'                 => [ 'LG', 'V10' ],
        'LG-H9(30|31|32)!'                          => [ 'LG', 'V30' ],
        'LG-H9(90)!'                                => [ 'LG', 'V20' ],
    ],

    'LG-K[0-9]{3,3}!!' => [
        'LG-K1(00)!'                                => [ 'LG', 'K3' ],
        'LG-K1(20|21|30)!'                          => [ 'LG', 'K4' ],
        'LG-K2(00)!'                                => [ 'LG', 'X Style' ],
        'LG-K2(10|12|20)!'                          => [ 'LG', 'X Power' ],
        'LG-K2(40)!'                                => [ 'LG', 'X Mach' ],
        'LG-K3(30|32|)!'                            => [ 'LG', 'K7' ],
        'LG-K4(10|20|25|28|30)!'                    => [ 'LG', 'K10' ],
        'LG-K4(50)!'                                => [ 'LG', 'X Power' ],
        'LG-K5(00)!'                                => [ 'LG', 'X Screen' ],
        'LG-K5(20)!'                                => [ 'LG', 'Stylus 2' ],
        'LG-K5(30|35)!'                             => [ 'LG', 'Stylus 2 Plus' ],
        'LG-K5(40)!'                                => [ 'LG', 'Stylo 2' ],
        'LG-K5(50|57)!'                             => [ 'LG', 'Stylo 2 Plus' ],
        'LG-K5(80)!'                                => [ 'LG', 'X Cam' ],
        'LG-K6(00)!'                                => [ 'LG', 'X Mach' ],
    ],

    'LG-KH5200'                                 => [ 'LG', 'Andro-1' ],
    'LG-KS1024'                                 => [ 'LG', 'KS1024' ],

    'LG-KU[0-9]{4,4}!!' => [
        'LG-KU3700'                                 => [ 'LG', 'Optimus One' ],
        'LG-KU5400!'                                => [ 'LG', 'PRADA 3.0' ],
        'LG-KU5900'                                 => [ 'LG', 'Optimus Black' ],
        'LG-KU6900'                                 => [ 'LG', 'Optimus Pad', DeviceType::TABLET ],
        'LG-KU8800'                                 => [ 'LG', 'Optimus EX' ],
    ],

    'LG-?L[0-9]{2,3}[A-Z]!!' => [
        'LG-L01F'                                   => [ 'LG', 'G2' ],
        'LGL15G!'                                   => [ 'LG', 'Sunrise' ],
        'LG-L15G'                                   => [ 'LG', 'Sunrise' ],
        'LGL16C!'                                   => [ 'LG', 'Lucky' ],
        'LGL17AG'                                   => [ 'LG', 'Classic' ],
        'LGL18VC'                                   => [ 'LG', 'Classic' ],
        'LGL21G!'                                   => [ 'LG', 'Destiny' ],
        'LGL22C!'                                   => [ 'LG', 'Power' ],
        'LGL25L'                                    => [ 'LG', 'Optimus Quest' ],
        'LG-L25L'                                   => [ 'LG', 'Optimus Quest' ],
        'LG-L30L'                                   => [ 'LG', 'F70' ],
        'LGL31L!'                                   => [ 'LG', 'Access' ],
        'LG-L31L'                                   => [ 'LG', 'Access' ],
        'LGL33L!'                                   => [ 'LG', 'Sunset' ],
        'LGL34C!'                                   => [ 'LG', 'Optimus Fuel' ],
        'LG-L34C'                                   => [ 'LG', 'Optimus Fuel' ],
        'LGL35G!'                                   => [ 'LG', 'Optimus Logic' ],
        'LG-L38C!'                                  => [ 'LG', 'Optimus Dynamic' ],
        'LGL38C!'                                   => [ 'LG', 'Optimus Dynamic' ],
        'LGL39C!'                                   => [ 'LG', 'Optimus Dynamic II' ],
        'LG-L40G'                                   => [ 'LG', 'Optimus Extreme' ],
        'LGL41C!'                                   => [ 'LG', 'Ultimate 2' ],
        'LG-L41C'                                   => [ 'LG', 'Ultimate 2' ],
        'LG-L42G'                                   => [ 'LG', 'L70' ],
        'LGL43AL!'                                  => [ 'LG', 'Rebel' ],
        'LGL44V'                                    => [ 'LG', 'Rebel' ],
        'LGL44VL!'                                  => [ 'LG', 'Rebel' ],
        'LGL45C!'                                   => [ 'LG', 'Optimus Net' ],
        'LGL51AL!'                                  => [ 'LG', 'Treasure' ],
        'LGL52VL!'                                  => [ 'LG', 'Treasure' ],
        'LGL53BL!'                                  => [ 'LG', 'X Style' ],
        'LGL55C!'                                   => [ 'LG', 'Optimus Q' ],
        'LGL56VL!'                                  => [ 'LG', 'X Style' ],
        'LGL57BL!'                                  => [ 'LG', 'Rebel 2' ],
        'LGL58VL!'                                  => [ 'LG', 'Rebel 2' ],
        'LGL59BL!'                                  => [ 'LG', 'Grace' ],
        'LGL61AL!'                                  => [ 'LG', 'Premier' ],
        'LGL62VL!'                                  => [ 'LG', 'Premier' ],
        'LGL63BL!'                                  => [ 'LG', 'Fiesta' ],
        'LGL64VL!'                                  => [ 'LG', 'Fiesta' ],
        'LGL75C!'                                   => [ 'LG', 'Optimus Zip' ],
        'LGL81AL!'                                  => [ 'LG', 'Stylo 2' ],
        'LGL82VL!'                                  => [ 'LG', 'Stylo 2' ],
        'LGL83BL!'                                  => [ 'LG', 'Stylo 3' ],
        'LGL84VL!'                                  => [ 'LG', 'Stylo 3' ],
        'LGL85C!'                                   => [ 'LG', 'Optimus Black' ],
        'LGL86C!'                                   => [ 'LG', 'Optimus Showtime' ],
        'LG-L95G!'                                  => [ 'LG', 'L95G' ],
        'LGL96G'                                    => [ 'LG', 'Ultimate' ],
        'LG-L160L'                                  => [ 'LG', 'L160L' ],                           // Unknown
        'LGL163BL'                                  => [ 'LG', 'Fiesta 2' ],
        'LGL164VL'                                  => [ 'LG', 'Fiesta' ],
        'LGL996L!'                                  => [ 'LG', 'G2' ],
    ],

    'LG-LG[0-9]{3,3}!!' => [
        'LG-LG730'                                  => [ 'LG', 'Venice' ],
        'LG-LG855'                                  => [ 'LG', 'Marquee' ],
        'LG-LG870'                                  => [ 'LG', 'Optimus F7' ],
    ],

    'LGLK430'                                   => [ 'LG', 'G Pad F 7.0', DeviceType::TABLET ],

    'LG-?LS[0-9]{3,3}!!' => [
        'LGLS450'                                   => [ 'LG', 'K3' ],
        'LG-LS620'                                  => [ 'LG', 'Realm' ],
        'LGLS620'                                   => [ 'LG', 'Realm' ],
        'LG-LS660'                                  => [ 'LG', 'Tribute' ],
        'LGLS660'                                   => [ 'LG', 'Tribute' ],
        'LGLS665'                                   => [ 'LG', 'Tribute 2' ],
        'LG-LS670'                                  => [ 'LG', 'Optimus S' ],
        'LGLS675'                                   => [ 'LG', 'M1' ],
        'LGLS676'                                   => [ 'LG', 'Tribute HD' ],
        'LG-LS685'                                  => [ 'LG', 'Optimus Net' ],
        'LG-LS696'                                  => [ 'LG', 'Elite' ],
        'LG-LS700'                                  => [ 'LG', 'Optimus Slider' ],
        'LG-LS720'                                  => [ 'LG', 'Optimus F3' ],
        'LGLS740'                                   => [ 'LG', 'Volt' ],
        'LG-LS740'                                  => [ 'LG', 'Volt' ],
        'LGLS751'                                   => [ 'LG', 'Volt 2' ],
        'LGLS755'                                   => [ 'LG', 'X Power' ],
        'LGLS770'                                   => [ 'LG', 'G Stylo' ],
        'LGLS775'                                   => [ 'LG', 'G Stylo 2' ],
        'LG-LS777'                                  => [ 'LG', 'Stylo 3' ],
        'LG-LS840'                                  => [ 'LG', 'Viper' ],
        'LG-LS855'                                  => [ 'LG', 'Marquee' ],
        'LG-LS860'                                  => [ 'LG', 'Mach' ],
        'LGLS885'                                   => [ 'LG', 'G3 Vigor' ],
        'LG-LS885'                                  => [ 'LG', 'G3 Vigor' ],
        'LG-LS970'                                  => [ 'LG', 'Optimus G' ],
        'LG-LS980'                                  => [ 'LG', 'G2' ],
        'LGLS990'                                   => [ 'LG', 'G3' ],
        'LG-LS990'                                  => [ 'LG', 'G3' ],
        'LGLS991'                                   => [ 'LG', 'G4' ],
        'LG-LS991'                                  => [ 'LG', 'G4' ],
        'LGLS992'                                   => [ 'LG', 'G5' ],
        'LG-LS993'                                  => [ 'LG', 'G6' ],
        'LG-LS995'                                  => [ 'LG', 'G Flex' ],
        'LGLS996'                                   => [ 'LG', 'G Flex 2' ],
        'LG-LS996'                                  => [ 'LG', 'G Flex 2' ],
        'LG-LS997'                                  => [ 'LG', 'V20' ],
        'LG-LS998'                                  => [ 'LG', 'V30+' ],
    ],

    'LG-LU[0-9]{4,4}!!' => [
        'LG-LU3000'                                 => [ 'LG', 'Optimus Mach' ],
        'LG-LU3100'                                 => [ 'LG', 'Optimus Chic' ],
        'LG-LU3700'                                 => [ 'LG', 'Optimus One' ],
        'LG-LU5400'                                 => [ 'LG', 'PRADA 3.0' ],
        'LG-LU6200'                                 => [ 'LG', 'Optimus LTE' ],
        'LG-LU6500'                                 => [ 'LG', 'Optimus Q2' ],
        'LG-LU6800'                                 => [ 'LG', 'Optimus Big' ],
        'LG-LU6900'                                 => [ 'LG', 'Optimus Pad', DeviceType::TABLET ],
        'LG-LU8300'                                 => [ 'LG', 'Optimus Pad LTE', DeviceType::TABLET ],
    ],

    'LG-LW690'                                  => [ 'LG', 'Optimus C' ],
    'LG-LW770'                                  => [ 'LG', 'Regard' ],

    'LG-M[0-9]{3,3}!!' => [
        'LG-M1(50)!'                                => [ 'LG', 'Phoenix 3' ],
        'LG-M1(51|60)!'                             => [ 'LG', 'K4 2017' ],
        'LG-M1(53)!'                                => [ 'LG', 'Fortune' ],
        'LG-M1(54)!'                                => [ 'LG', 'Risio 2' ],
        'LG-M2(00)!'                                => [ 'LG', 'K8 2017' ],
        'LG-M2(10)!'                                => [ 'LG', 'Aristo' ],
        'LG-M2(50)!'                                => [ 'LG', 'K10 2017' ],
        'LG-M2(55)!'                                => [ 'LG', 'K20' ],
        'LG-M2(57)!'                                => [ 'LG', 'Harmony' ],
        'LG-M3(20)!'                                => [ 'LG', 'X Power II' ],
        'LG-M3(22|27)!'                             => [ 'LG', 'X charge' ],
        'LG-M4(00)!'                                => [ 'LG', 'Stylus 3' ],
        'LG-M4(30)!'                                => [ 'LG', 'Stylo 3' ],
        'LG-M4(70)!'                                => [ 'LG', 'Stylo 3 Plus' ],
        'LG-M7(00|03)!'                             => [ 'LG', 'Q6' ],
    ],

    'LG-?MS[0-9]{3,3}!!' => [
        'LGMS323'                                   => [ 'LG', 'L70' ],
        'LG-MS323'                                  => [ 'LG', 'L70' ],
        'LGMS330'                                   => [ 'LG', 'K7' ],
        'LGMS345'                                   => [ 'LG', 'Leon' ],
        'LGMS395'                                   => [ 'LG', 'F60' ],
        'LG-MS415'                                  => [ 'LG', 'L90' ],
        'LGMS428'                                   => [ 'LG', 'K10' ],
        'LGMS500'                                   => [ 'LG', 'Optimus F6' ],
        'LG-MS500'                                  => [ 'LG', 'Optimus F6' ],
        'LGMS550'                                   => [ 'LG', 'G Stylo 2' ],
        'LGMS631'                                   => [ 'LG', 'G Stylo' ],
        'LG-MS659'                                  => [ 'LG', 'Optimus F3' ],
        'LGMS659'                                   => [ 'LG', 'Optimus F3' ],
        'LG-MS690'                                  => [ 'LG', 'Optimus M' ],
        'LGMS769'                                   => [ 'LG', 'Optimus L9' ],
        'LG-MS770'                                  => [ 'LG', 'Motion 4G' ],
        'LGMS770'                                   => [ 'LG', 'Motion 4G' ],
        'LG-MS790'                                  => [ 'LG', 'Optimus F3' ],
        'LG-MS840'                                  => [ 'LG', 'Connect 4G' ],
        'LG-MS870'                                  => [ 'LG', 'Spirit 4G' ],
        'LG-MS910'                                  => [ 'LG', 'Esteem' ],
        'LG-MS695'                                  => [ 'LG', 'Optimus M+' ],
    ],

    'LG-P[0-9]{3,3}!!' => [
        'LG-P350!'                                  => [ 'LG', 'Optimus Me' ],
        'LG-P355'                                   => [ 'LG', 'P355' ],
        'LG-P490!'                                  => [ 'LG', 'P490' ],                    // Unknown
        'LG-P5(00|03|04)!'                          => [ 'LG', 'Optimus One' ],
        'LG-P505!'                                  => [ 'LG', 'Phoenix' ],
        'LG-P506'                                   => [ 'LG', 'Thrive' ],
        'LG-P509'                                   => [ 'LG', 'Optimus T' ],
        'LG-P6(55|59)!'                             => [ 'LG', 'Optimus F3' ],
        'LG-P6(90|92|99)!'                          => [ 'LG', 'Optimus Net' ],
        'LG-P693!'                                  => [ 'LG', 'P693' ],
        'LG-P698!'                                  => [ 'LG', 'Optimus Net Dual' ],
        'LG-P7(00|05|08)!'                          => [ 'LG', 'Optimus L7' ],
        'LG-P7(10|12|13|14)!'                       => [ 'LG', 'Optimus L7 II' ],
        'LG-P7(15|16)!'                             => [ 'LG', 'Optimus L7 II Dual' ],
        'LG-P720!'                                  => [ 'LG', 'Optimus Chic' ],
        'LG-P725'                                   => [ 'LG', 'Optimus 3D Max' ],
        'LG-P7(60|65|68|69|78)!'                    => [ 'LG', 'Optimus L9' ],
        'LG-P815!'                                  => [ 'LG', 'G Pad II 8.3', DeviceType::TABLET ],
        'LG-P860'                                   => [ 'LG', 'P860' ],
        'LG-P870!'                                  => [ 'LG', 'Escape' ],
        'LG-P875!'                                  => [ 'LG', 'Optimus F5' ],
        'LG-P880!'                                  => [ 'LG', 'Optimus 4X HD' ],
        'LG-P895!'                                  => [ 'LG', 'Optimus Vu' ],
        'LG-P920!'                                  => [ 'LG', 'Optimus 3D' ],
        'LG-P9(25|29)!'                             => [ 'LG', 'Thrill' ],
        'LG-P930!'                                  => [ 'LG', 'Nitro HD' ],
        'LG-P9(35|36)!'                             => [ 'LG', 'Optimus LTE' ],
        'LG-P940!'                                  => [ 'LG', 'PRADA 3.0' ],
        'LG-P970!'                                  => [ 'LG', 'Optimus Black' ],
        'LG-P990!'                                  => [ 'LG', 'Optimus 2X Speed' ],
        'LG-P993'                                   => [ 'LG', 'Optimus 2X' ],
    ],

    'LG-SU[0-9]{3,3}!!' => [
        'LG-SU370'                                  => [ 'LG', 'Optimus One' ],
        'LG-SU540'                                  => [ 'LG', 'PRADA 3.0' ],
        'LG-SU640'                                  => [ 'LG', 'Optimus LTE' ],
        'LG-SU660'                                  => [ 'LG', 'Optimus 2X' ],
        'LG-SU760'                                  => [ 'LG', 'Optimus 3D' ],
        'LG-SU870'                                  => [ 'LG', 'Optimus 3D Cube' ],
        'LG-SU880'                                  => [ 'LG', 'Optimus EX' ],
    ],

    'LG-TP260'                                  => [ 'LG', 'K20 Plus' ],
    'LG-TP450'                                  => [ 'LG', 'Stylo 3 Plus' ],

    'LG-SU-760'                                 => [ 'LG', 'Optimus 3D' ],
    'LGUK410'                                   => [ 'LG', 'G Pad 7.0', DeviceType::TABLET ],
    'LG-UK495'                                  => [ 'LG', 'G Pad F 8.0', DeviceType::TABLET ],
    'LGUK750'                                   => [ 'LG', 'G Pad X II 10.1', DeviceType::TABLET ],
    'LGUK932'                                   => [ 'LG', 'G Pad II 10.1', DeviceType::TABLET ],
    'LG-UN350'                                  => [ 'LG', 'UN350' ],

    'LG-?US[0-9]{3,3}!!' => [
        'LGUS110'                                   => [ 'LG', 'K3 2017' ],
        'LGUS215'                                   => [ 'LG', 'K8 2017' ],
        'LGUS375'                                   => [ 'LG', 'K8' ],
        'LGUS550'                                   => [ 'LG', 'Logos' ],
        'LGUS610'                                   => [ 'LG', 'X Power' ],
        'LG-US670'                                  => [ 'LG', 'Optimus U' ],
        'LG-US701'                                  => [ 'LG', 'X venture' ],
        'LG-US730'                                  => [ 'LG', 'Splendor' ],
        'LG-US780'                                  => [ 'LG', 'Optimus F7' ],
        'LGUS990!'                                  => [ 'LG', 'G3' ],
        'LG-US990'                                  => [ 'LG', 'G3' ],
        'LGUS991!'                                  => [ 'LG', 'G4' ],
        'LGUS992'                                   => [ 'LG', 'G5' ],
        'LGUS995!'                                  => [ 'LG', 'G Flex 2' ],
        'LG-US996!'                                 => [ 'LG', 'V20' ],
        'LG-US997'                                  => [ 'LG', 'G6' ],
    ],

    'LG-V[0-9]{3,3}!!' => [
        'LG-V4(00|10|11)!'                          => [ 'LG', 'G Pad 7.0', DeviceType::TABLET ],
        'LG-V4(80|90)!'                             => [ 'LG', 'G Pad 8.0', DeviceType::TABLET ],
        'LG-V4(95|96|97|99)!'                       => [ 'LG', 'G Pad F 8.0', DeviceType::TABLET ],
        'LG-V498!'                                  => [ 'LG', 'G Pad II 8.0', DeviceType::TABLET ],
        'LG-V5(00|07)!'                             => [ 'LG', 'G Pad 8.3', DeviceType::TABLET ],
        'LG-V510!'                                  => [ 'LG', 'G Pad 8.3 (Google Edition)', DeviceType::TABLET ],
        'LG-V5(20|21)!'                             => [ 'LG', 'G Pad X 8.0', DeviceType::TABLET ],
        'LG-V5(22|25)!'                             => [ 'LG', 'G Pad III 8.0', DeviceType::TABLET ],
        'LG-V5(30)!'                                => [ 'LG', 'G Pad X 2 8.0', DeviceType::TABLET ],
        'LG-V5(33)!'                                => [ 'LG', 'G Pad IV 8.0', DeviceType::TABLET ],
        'LG-V607L'                                  => [ 'LG', 'G Pad II 8.0', DeviceType::TABLET ],
        'LG-V700!'                                  => [ 'LG', 'G Pad 10.1', DeviceType::TABLET ],
        'LG-V9(00|01)!'                             => [ 'LG', 'Optimus Pad', DeviceType::TABLET ],
        'LG-V9(05|09)!'                             => [ 'LG', 'Optimus G-Slate', DeviceType::TABLET ],
        'LG-V930'                                   => [ 'LG', 'G Pad X 10.1', DeviceType::TABLET ],
        'LG-V9(35|40)!'                             => [ 'LG', 'G Pad II 10.1', DeviceType::TABLET ],
    ],

    'LG-VK[0-9]{3,3}!!' => [
        'LG-VK410'                                  => [ 'LG', 'G Pad 7.0', DeviceType::TABLET ],
        'LG-VK700'                                  => [ 'LG', 'G Pad 10.1', DeviceType::TABLET ],
        'LG-VK810'                                  => [ 'LG', 'G Pad 8.3', DeviceType::TABLET ],
        'LG-VK815'                                  => [ 'LG', 'G Pad X 8.3', DeviceType::TABLET ],
    ],

    'LG-VN[0-9]{3,3}!!' => [
        'LG-VN170'                                  => [ 'LG', 'VN-170' ],                              // Unknown
        'LG-VN280'                                  => [ 'LG', 'Extravert 2' ],
        'LG-VN360'                                  => [ 'LG', 'Exalt' ],
    ],

    'LG-VM[0-9]{3,3}!!' => [
        'LG-VM670'                                  => [ 'LG', 'Optimus V' ],
        'LG-VM696'                                  => [ 'LG', 'Optimus Elite' ],
        'LG-VM701'                                  => [ 'LG', 'Optimus Slider' ],
        'LG-VM720'                                  => [ 'LG', 'Optimus F5' ],
    ],

    'LG-VS[0-9]{3,3}!!' => [
        'LG-VS410!'                                 => [ 'LG', 'Optimus Zone' ],
        'LG-VS415!'                                 => [ 'LG', 'Optimus Zone 2' ],                      // aka L40
        'LG-VS450!'                                 => [ 'LG', 'Optimus Exceed 2' ],                    // aka L70
        'LG-VS660'                                  => [ 'LG', 'Vortex' ],
        'LG-VS700!'                                 => [ 'LG', 'Enlighten' ],
        'LG-VS740'                                  => [ 'LG', 'Ally' ],
        'LG-VS810'                                  => [ 'LG', 'Transpyre' ],
        'LG-VS840'                                  => [ 'LG', 'Lucid' ],
        'LG-VS870'                                  => [ 'LG', 'Lucid 2' ],
        'LG-VS876'                                  => [ 'LG', 'Lucid 3' ],                         // aka F90
        'LG-VS880'                                  => [ 'LG', 'G3 Vista' ],
        'LG-VS890'                                  => [ 'LG', 'Enact' ],
        'LG-VS910'                                  => [ 'LG', 'Revolution' ],
        'LG-VS930'                                  => [ 'LG', 'Spectrum II' ],
        'LG-VS950'                                  => [ 'LG', 'Intuition' ],
        'LG-VS980!'                                 => [ 'LG', 'G2' ],
        'LG-VS985'                                  => [ 'LG', 'G3' ],
        'LG-VS995'                                  => [ 'LG', 'V20' ],
        'LG-VS999'                                  => [ 'LG', 'G4' ],
    ],

    'LG-X[0-9]{3,3}!!' => [
        'LG-X130!'                                  => [ 'LG', 'L40' ],
        'LG-X132'                                   => [ 'LG', 'L45' ],
        'LG-X1(35|40|45|47)!'                       => [ 'LG', 'L60' ],
        'LG-X137'                                   => [ 'LG', 'L60i' ],
        'LG-X150'                                   => [ 'LG', 'Bello 2' ],
        'LG-X1(55|60|65)!'                          => [ 'LG', 'Max' ],
        'LG-X1(70)!'                                => [ 'LG', 'Prime 2' ],
        'LG-X180!'                                  => [ 'LG', 'Zone' ],
        'LG-X190'                                   => [ 'LG', 'Ray' ],
        'LG-X210'                                   => [ 'LG', 'K7' ],
        'LG-X220'                                   => [ 'LG', 'K5' ],
        'LG-X230'                                   => [ 'LG', 'K7 2017' ],
        'LG-X240'                                   => [ 'LG', 'K8 2017' ],
        'LG-X760!'                                  => [ 'LG', 'G Pad III 10.1', DeviceType::TABLET ],
    ],

    'LGM-[GKVX][0-9]{3,3}!!' => [
        'LGM-G600[KLSV]!'                           => [ 'LG', 'G6' ],
        'LGM-K120[KLS]!'                            => [ 'LG', 'X300' ],
        'LGM-K121[KLS]!'                            => [ 'LG', 'X400' ],
        'LGM-V300[KLS]!'                            => [ 'LG', 'V30' ],
        'LGM-X320[KLS]!'                            => [ 'LG', 'X500' ],
        'LGM-X600[KLS]!'                            => [ 'LG', 'Q6' ],
        'LGM-X800[KLS]!'                            => [ 'LG', 'Q8' ],
    ],

    'lge-F160!'                                 => [ 'LG', 'Optimus LTE II' ],
    'LGE-E988!'                                 => [ 'LG', 'Optimus G Pro' ],
    'lgp-970'                                   => [ 'LG', 'Optimus Black' ],
    'AS740'                                     => [ 'LG', 'Axis' ],
    'AS870 4G'                                  => [ 'LG', 'Optimus F5' ],
    'AS985'                                     => [ 'LG', 'G3' ],
    'E900'                                      => [ 'LG', 'Optimus 7' ],
    'GT540'                                     => [ 'LG', 'Optimus' ],
    'GT540f'                                    => [ 'LG', 'Optimus' ],
    'GW620'                                     => [ 'LG', 'Eve' ],
    'KU9500'                                    => [ 'LG', 'Optimus Z' ],

    'LG[LSTV][0-9]{2,2}!!' => [
        'LGL21'                                     => [ 'LG', 'Optimus G LGL21', 'carrier' => 'au' ],
        'LGL22'                                     => [ 'LG', 'isai LGL22', 'carrier' => 'au' ],
        'LGL23'                                     => [ 'LG', 'G Flex LGL23', 'carrier' => 'au' ],
        'LGL24'                                     => [ 'LG', 'isai FL LGL24', 'carrier' => 'au' ],
        'LGL25'                                     => [ 'LG', 'Fx0 LGL25', 'carrier' => 'au' ],
        'LGS01'                                     => [ 'LG', 'Wine Smart LGS01', 'carrier' => 'J:COM' ],
        'LGV31'                                     => [ 'LG', 'isai VL LGV31', 'carrier' => 'au' ],
        'LGV32'                                     => [ 'LG', 'isai vivid LGV32', 'carrier' => 'au' ],
        'LGV33'                                     => [ 'LG', 'Qua phone PX LGV33', 'carrier' => 'au' ],
        'LGV34'                                     => [ 'LG', 'isai Beat LGV34', 'carrier' => 'au' ],
        'LGT31'                                     => [ 'LG', 'Qua tab PX LGT31', 'carrier' => 'au', DeviceType::TABLET ],
        'LGT32'                                     => [ 'LG', 'Qua tab PZ LGT32', 'carrier' => 'au', DeviceType::TABLET ],
    ],

    'LU2300'                                    => [ 'LG', 'Optimus Q' ],
    'LS670'                                     => [ 'LG', 'Optimus S' ],
    'LS740'                                     => [ 'LG', 'F90' ],                         // aka Volt
    'MS840 4G'                                  => [ 'LG', 'Connect 4G' ],
    'P940'                                      => [ 'LG', 'PRADA 3.0' ],
    'P990'                                      => [ 'LG', 'Optimus 2X Speed' ],

    'USCC-(LG)?US!!' => [
        'USCC-US730'                                => [ 'LG', 'Splendor' ],
        'USCC-US760'                                => [ 'LG', 'Genesis' ],
        'USCC-US780'                                => [ 'LG', 'Optimus F7' ],
        'USCC-US855'                                => [ 'LG', 'Optimus Black' ],
        'USCC-LGUS990'                              => [ 'LG', 'G3' ],
    ],

    'VK410'                                     => [ 'LG', 'G Pad 7.0', DeviceType::TABLET ],
    'VK700'                                     => [ 'LG', 'G Pad 10.1', DeviceType::TABLET ],
    'VK810 4G'                                  => [ 'LG', 'G Pad 8.3', DeviceType::TABLET ],
    'VK815'                                     => [ 'LG', 'G Pad X 8.3', DeviceType::TABLET ],
    'VM670'                                     => [ 'LG', 'Optimus V' ],

    'VS[0-9]{3,3}!!' => [
        'VS415PP'                                   => [ 'LG', 'Optimus Zone 2' ],
        'VS425PP'                                   => [ 'LG', 'Optimus Zone 3' ],
        'VS500PP'                                   => [ 'LG', 'K8 V' ],
        'VS810PP'                                   => [ 'LG', 'Transpyre' ],
        'VS820'                                     => [ 'LG', 'Lancet' ],
        'VS835'                                     => [ 'LG', 'G Stylo 2 V' ],
        'VS840PP'                                   => [ 'LG', 'Optimus Exceed' ],
        'VS840 4G'                                  => [ 'LG', 'Lucid' ],
        'VS870 4G'                                  => [ 'LG', 'Escape' ],
        'VS876'                                     => [ 'LG', 'Lucid 3' ],                         // aka F90
        'VS880'                                     => [ 'LG', 'G3 Vista' ],
        'VS880PP'                                   => [ 'LG', 'G3 Vista' ],
        'VS890 4G'                                  => [ 'LG', 'Enact' ],
        'VS900-4G'                                  => [ 'LG', 'Enlighten' ],
        'VS910 4G'                                  => [ 'LG', 'Revolution 4G' ],
        'VS920 4G'                                  => [ 'LG', 'Spectrum' ],
        'VS930 4G'                                  => [ 'LG', 'Spectrum 2' ],
        'VS950 4G'                                  => [ 'LG', 'Intuition' ],
        'VS980 4G'                                  => [ 'LG', 'G2' ],
        'VS985 4G'                                  => [ 'LG', 'G3' ],
        'VS986'                                     => [ 'LG', 'G4' ],
        'VS987'                                     => [ 'LG', 'G5' ],
        'VS990'                                     => [ 'LG', 'V10' ],
        'VS995'                                     => [ 'LG', 'V20' ],
    ],

    'L-0[0-9][A-Z]!!' => [
        'L-01D'                                     => [ 'LG', 'Optimus LTE L-01D', 'carrier' => 'DoCoMo' ],
        'L-01E'                                     => [ 'LG', 'Optimus G L-01E', 'carrier' => 'DoCoMo' ],
        'L-01F'                                     => [ 'LG', 'G2 L-01F', 'carrier' => 'DoCoMo' ],
        'L-02D'                                     => [ 'LG', 'PRADA phone L-02D', 'carrier' => 'DoCoMo' ],
        'L-02E'                                     => [ 'LG', 'Optimus LIFE L-02E', 'carrier' => 'DoCoMo' ],
        'L-02F'                                     => [ 'LG', 'WiFi STATION L-02F', 'carrier' => 'DoCoMo' ],
        'L-04C'                                     => [ 'LG', 'Optimus chat L-04C', 'carrier' => 'DoCoMo' ],
        'L-04E'                                     => [ 'LG', 'Optimus G Pro L-04E', 'carrier' => 'DoCoMo' ],
        'L-05D'                                     => [ 'LG', 'Optimus it L-05D', 'carrier' => 'DoCoMo' ],
        'L-05E'                                     => [ 'LG', 'Optimus it L-05E', 'carrier' => 'DoCoMo' ],
        'L-06C'                                     => [ 'LG', 'Optimus Pad L-06C', DeviceType::TABLET, 'carrier' => 'DoCoMo' ],
        'L-06D'                                     => [ 'LG', 'Optimus Vu L-06D', 'carrier' => 'DoCoMo' ],
        'L-06DJOJO'                                 => [ 'LG', 'JOJO L-06D', 'carrier' => 'DoCoMo' ],
        'L-07C'                                     => [ 'LG', 'Optimus bright L-07C', 'carrier' => 'DoCoMo' ],
    ],

    '[0-9]0[0-9]LG!!' => [
        '401LG'                                     => [ 'LG', '401LG', 'carrier' => 'Softbank' ],                // Unknown
        '402LG'                                     => [ 'LG', 'Spray 402LG', 'carrier' => 'Y! Mobile' ],
    ],

    'DM-01G'                                    => [ 'LG', 'DM-01G', 'carrier' => 'Disney Mobile' ],
    'DM-02H'                                    => [ 'LG', 'DM-02H', 'carrier' => 'Disney Mobile' ],

    'LG!!' => [
        'LG-Eve'                                    => [ 'LG', 'Eve' ],
        'LG-G2'                                     => [ 'LG', 'G2' ],
        'LG-G3'                                     => [ 'LG', 'G3' ],
        'LG-G3 D855'                                => [ 'LG', 'G3' ],
        'LG-Optimus One P500'                       => [ 'LG', 'Optimus One' ],
        'LG-Optimus 2X'                             => [ 'LG', 'Optimus 2X' ],
        'LG-GT540 Optimus'                          => [ 'LG', 'Optimus' ],
        'LG-Optimus'                                => [ 'LG', 'Optimus' ],
        'LG-Optimus Black'                          => [ 'LG', 'Optimus Black' ],
        'LG-OptimusG'                               => [ 'LG', 'Optimus G' ],
        'LG-Optimus G'                              => [ 'LG', 'Optimus G' ],
        'LG-gee'                                    => [ 'LG', 'Optimus G' ],
        'LG-Optimus G Pro'                          => [ 'LG', 'Optimus G Pro' ],
        'LG-G PRO'                                  => [ 'LG', 'Optimus G Pro' ],
        'LG-Optimus GK'                             => [ 'LG', 'Optimus GK' ],
        'LG-Optimus L3!'                            => [ 'LG', 'Optimus L3' ],
        'LG-Optimus LTE2'                           => [ 'LG', 'Optimus LTE2' ],
        'LG-Optimus Net'                            => [ 'LG', 'Optimus Net' ],
        'LG-Optimus One'                            => [ 'LG', 'Optimus One' ],
        'LG-Optimus V'                              => [ 'LG', 'Optimus V' ],
        'LG-OPTIMUS-L5!'                            => [ 'LG', 'Optimus L7' ],
        'LG-optimus L7'                             => [ 'LG', 'Optimus L7' ],
        'LG-Swift L9'                               => [ 'LG', 'Optimus L9' ],
        'LG-OPTIMUS HD LTE'                         => [ 'LG', 'Optimus HD' ],
        'LG-OPTIMUS LTE HD'                         => [ 'LG', 'Optimus HD' ],
        'LG-Optimus Pad L-06C'                      => [ 'LG', 'Optimus Pad', DeviceType::TABLET ],
        'LG-vortex'                                 => [ 'LG', 'Vortex' ],
    ],

    'Ally'                                      => [ 'LG', 'Ally' ],

    'Optimus!!' => [
        'Optimus'                                   => [ 'LG', 'Optimus' ],
        'OptimusBlack'                              => [ 'LG', 'Optimus Black' ],
        'Optimus G'                                 => [ 'LG', 'Optimus G' ],
        'Optimus G Pro'                             => [ 'LG', 'Optimus G Pro' ],
        'Optimus Me'                                => [ 'LG', 'Optimus Me' ],
        'optimus me p350'                           => [ 'LG', 'Optimus Me' ],
        'Optimus Net'                               => [ 'LG', 'Optimus Net' ],
        'Optimus One'                               => [ 'LG', 'Optimus One' ],
        'Optimus Pro'                               => [ 'LG', 'Optimus Pro' ],
        'Optimus 2X'                                => [ 'LG', 'Optimus 2X' ],
        'Optimus 2x'                                => [ 'LG', 'Optimus 2X' ],
        'Optimus 4X HD'                             => [ 'LG', 'Optimus 4X HD' ],
        'OptimusX4HD'                               => [ 'LG', 'Optimus 4X HD' ],
        'Optimus4XHD'                               => [ 'LG', 'Optimus 4X HD' ],
        'Optimusx4'                                 => [ 'LG', 'Optimus X4' ],
    ],

    'IS11LG'                                    => [ 'LG', 'Optimus X IS11LG', 'carrier' => 'au' ],
    'Vortex'                                    => [ 'LG', 'Vortex' ],
    'LDK-ICK v1.4'                              => [ 'LG', 'Esteem' ],
    'Prada 3.0'                                 => [ 'LG', 'PRADA 3.0' ],

    'LG-Google TV!!' => [
        'LG-Google TV'                              => [ 'LG', 'Android TV', DeviceType::TELEVISION, Flag::GOOGLETV ],
        'LG-Google TV TV'                           => [ 'LG', 'Android TV', DeviceType::TELEVISION, Flag::GOOGLETV ],
        'LG-Google TV G3'                           => [ 'LG', 'Android TV', DeviceType::TELEVISION, Flag::GOOGLETV ],
        'LG-Google TV G3 KR'                        => [ 'LG', 'Android TV', DeviceType::TELEVISION, Flag::GOOGLETV ],
        'LG-Google TV G3 TV'                        => [ 'LG', 'Android TV', DeviceType::TELEVISION, Flag::GOOGLETV ],
        'LG-Google TV G3 KR TV'                     => [ 'LG', 'Android TV', DeviceType::TELEVISION, Flag::GOOGLETV ],
    ],

    'LG-ANDROID MINI BOX'                       => [ 'LG', 'Android Mini-Box', DeviceType::TELEVISION ],
    'SH940C-LN'                                 => [ 'LG', 'Smartbox HD', DeviceType::TELEVISION ],
    'SH940C-LN TV'                              => [ 'LG', 'Smartbox HD', DeviceType::TELEVISION ],
    'SH960C-LN'                                 => [ 'LG', 'Smartbox HD', DeviceType::TELEVISION ],
    'LAP250U'                                   => [ 'LG', 'U+ tv G', DeviceType::TELEVISION, Flag::GOOGLETV ],
    'LAP255U'                                   => [ 'LG', 'U+ tv G', DeviceType::TELEVISION, Flag::GOOGLETV ],
    'TI320-DU'                                  => [ 'LG', 'U+ tv G', DeviceType::TELEVISION, Flag::GOOGLETV ],
    'TI320-DU TV'                               => [ 'LG', 'U+ tv G', DeviceType::TELEVISION, Flag::GOOGLETV ],
    'ST940I-UP'                                 => [ 'LG', 'U+ tv G 4K', DeviceType::TELEVISION, Flag::GOOGLETV ],
    'WA-U420D'                                  => [ 'LG', 'U+ tvLINK', DeviceType::TELEVISION, Flag::GOOGLETV ],
    'SFR-G8800'                                 => [ 'LG', 'SFR-G8800', DeviceType::TELEVISION, Flag::GOOGLETV ],
    'SFR-G8800 TV'                              => [ 'LG', 'SFR-G8800', DeviceType::TELEVISION, Flag::GOOGLETV ],
    'E731'                                      => [ 'Logicom', 'E731', DeviceType::TABLET ],
    'E812'                                      => [ 'Logicom', 'E812', DeviceType::TABLET ],
    'E912'                                      => [ 'Logicom', 'E912', DeviceType::TABLET ],
    'E1031'                                     => [ 'Logicom', 'E1031', DeviceType::TABLET ],
    'TAB950'                                    => [ 'Logicom', 'TAB950', DeviceType::TABLET ],
    'TAB1062'                                   => [ 'Logicom', 'TAB1062', DeviceType::TABLET ],
    'LS-4001'                                   => [ 'LYF', 'Flame 3' ],
    'LS-4002'                                   => [ 'LYF', 'Flame 5' ],
    'LS-4003'                                   => [ 'LYF', 'Flame 4' ],
    'LS-4004'                                   => [ 'LYF', 'Flame 2' ],
    'LS-4005'                                   => [ 'LYF', 'Flame 6' ],
    'LS-4006'                                   => [ 'LYF', 'Flame 7' ],
    'LYF LS-4006'                               => [ 'LYF', 'Flame 7' ],
    'LS-4008'                                   => [ 'LYF', 'Flame 7S' ],
    'LS-4503'                                   => [ 'LYF', 'Flame 1' ],
    'LS-4505'                                   => [ 'LYF', 'Flame 8' ],
    'LS-5002'                                   => [ 'LYF', 'Water 1' ],
    'LS-5004'                                   => [ 'LYF', 'Water 7' ],
    'LS-5005'                                   => [ 'LYF', 'Water 4' ],
    'LS-5006'                                   => [ 'LYF', 'Water 6' ],
    'LS-5007'                                   => [ 'LYF', 'Water 5' ],
    'LS-5008'                                   => [ 'LYF', 'Water 2' ],
    'LS-5009'                                   => [ 'LYF', 'Wind 6' ],
    'LYF LS-5009'                               => [ 'LYF', 'Wind 6' ],
    'LS-5010'                                   => [ 'LYF', 'Wind 1' ],
    'LS-5013'                                   => [ 'LYF', 'Wind 5' ],
    'LS-5014'                                   => [ 'LYF', 'Wind 4' ],
    'LS-5015'                                   => [ 'LYF', 'Water 8' ],
    'LS-5016'                                   => [ 'LYF', 'Wind 7' ],
    'LS-5017'                                   => [ 'LYF', 'Water 11' ],
    'LS-5018'                                   => [ 'LYF', 'Wind 4S' ],
    'LS-5020'                                   => [ 'LYF', 'Water 10' ],
    'LS-5021'                                   => [ 'LYF', 'Earth 2' ],
    'LS-5201'                                   => [ 'LYF', 'Water F1S' ],
    'LS-5501'                                   => [ 'LYF', 'Earth 1' ],
    'LS-5502'                                   => [ 'LYF', 'Wind 3' ],
    'LS-5503'                                   => [ 'LYF', 'Water 3' ],
    'LS-5504'                                   => [ 'LYF', 'Water 7' ],
    'LS-5505'                                   => [ 'LYF', 'Water F1' ],
    'LS-5506'                                   => [ 'LYF', 'Water 9' ],
    'LS-5507'                                   => [ 'LYF', 'Water 7S' ],
    'LS-6001'                                   => [ 'LYF', 'Wind 2' ],
    'aTab9.7 IPS'                               => [ 'M-Tech', 'aTab 9.7', DeviceType::TABLET ],
    'CRONO 22'                                  => [ 'Majestic', 'Chrono 22' ],
    'TAB192'                                    => [ 'Majestic', 'TAB-192', DeviceType::TABLET ],

    'Malata!!' => [
        'MALATA I5'                                 => [ 'Malata', 'I5' ],
        'MALATA I8'                                 => [ 'Malata', 'I8' ],
        'MALATA I10'                                => [ 'Malata', 'I10' ],
        'MALATA I50'                                => [ 'Malata', 'I50' ],
        'MALATA I60'                                => [ 'Malata', 'I60' ],
        'MALATA TD60'                               => [ 'Malata', 'TD60' ],
        'MALATA TD95'                               => [ 'Malata', 'TD95' ],
        'MALATA S501'                               => [ 'Malata', 'S501' ],
        'Malata SMBA1002'                           => [ 'Malata', 'Tablet SMB-A1002', DeviceType::TABLET ],
        'Malata SMBA9701'                           => [ 'Malata', 'Tablet SMB-A9701', DeviceType::TABLET ],
    ],

    'T6'                                        => [ 'Malata', 'Zpad T6', DeviceType::TABLET ],

    'MID[0-9]!!' => [
        'MID05V2'                                   => [ 'Manta', 'Power Tab', DeviceType::TABLET ],
        'MID06N'                                    => [ 'Manta', 'Power Tab X', DeviceType::TABLET ],
        'MID701'                                    => [ 'Manta', 'Power Tab Basic', DeviceType::TABLET ],
        'MID704'                                    => [ 'Manta', 'Power Tab 7', DeviceType::TABLET ],
        'MID705'                                    => [ 'Manta', 'Power Tab', DeviceType::TABLET ],
        'MID706A'                                   => [ 'Manta', 'Duo Power 7', DeviceType::TABLET ],
        'MID801'                                    => [ 'Manta', 'Duo Power 8 HD', DeviceType::TABLET ],
        'MID802'                                    => [ 'Manta', 'Duo Power 8 HD', DeviceType::TABLET ],
        'MID9701'                                   => [ 'Manta', 'Duo Power 9.7', DeviceType::TABLET ],
        'MID9702'                                   => [ 'Manta', 'Duo Power 9.7 HD', DeviceType::TABLET ],
        'MID1001'                                   => [ 'Manta', 'Power Tab 10.1 HD', DeviceType::TABLET ],
    ],

    'Masstel!!' => [
        'Masstel M11'                               => [ 'Masstel', 'M11' ],
        'Masstel-M11'                               => [ 'Masstel', 'M11' ],
        'Masstel M15'                               => [ 'Masstel', 'M15' ],
        'Masstel M25'                               => [ 'Masstel', 'M25' ],
        'Masstel M120'                              => [ 'Masstel', 'M120' ],
        'Masstel M250'                              => [ 'Masstel', 'M250' ],
        'Masstel M320'                              => [ 'Masstel', 'M320' ],
        'Masstel N405'                              => [ 'Masstel', 'N405' ],
        'Masstel Tab 700'                           => [ 'Masstel', 'Tab 700', DeviceType::TABLET ],
        'Masstel Tab 720'                           => [ 'Masstel', 'Tab 720', DeviceType::TABLET ],
        'Masstel Tab 720i'                          => [ 'Masstel', 'Tab 720i', DeviceType::TABLET ],
        'Masstel Tab 740'                           => [ 'Masstel', 'Tab 740', DeviceType::TABLET ],
        'Masstel Tab 750'                           => [ 'Masstel', 'Tab 750', DeviceType::TABLET ],
        'Masstel Tab 840'                           => [ 'Masstel', 'Tab 840', DeviceType::TABLET ],
        'Masstel Tab 850'                           => [ 'Masstel', 'Tab 850', DeviceType::TABLET ],
    ],

    'MASTONE!!' => [
        'MASTONE G3'                                => [ 'Mastone', 'G3' ],
        'MASTONE G4'                                => [ 'Mastone', 'G4' ],
        'MASTONE G9'                                => [ 'Mastone', 'G9' ],
        'MASTONE G13'                               => [ 'Mastone', 'G13' ],
        'MASTONE G15'                               => [ 'Mastone', 'G15' ],
        'MASTONE W16'                               => [ 'Mastone', 'W16' ],
    ],

    'M-270'                                     => [ 'Maylong', 'M-270', DeviceType::TABLET ],
    'T-200'                                     => [ 'Maylong', 'T-200', DeviceType::TABLET ],
    'M70'                                       => [ 'Maxsun', 'M70', DeviceType::TABLET ],

    'Maxtron!!' => [
        'Maxtron AMOR Ⅱ'                            => [ 'Maxtron', 'Amor 2' ],
        'Maxtron Diamond'                           => [ 'Maxtron', 'Diamond' ],
        'Maxtron Venus'                             => [ 'Maxtron', 'Venus' ],
        'Maxtron T1'                                => [ 'Maxtron', 'T1', DeviceType::TABLET ],
    ],

    'M785'                                      => [ 'Mecer', 'Xpress Smartlife M785', DeviceType::TABLET ],
    '800P31C'                                   => [ 'Mecer', 'Xpress Smartlife 800P31C', DeviceType::TABLET ],
    'X1010'                                     => [ 'Mecer', 'X1010', DeviceType::TABLET ],

    'M\-PP!!' => [
        'M-PPxG400'                                 => [ 'Mediacom', 'PhonePad Duo G400' ],
        'M-PPAG500'                                 => [ 'Mediacom', 'PhonePad Duo G500' ],
        'M-PPBG500'                                 => [ 'Mediacom', 'PhonePad Duo G500' ],
        'M-PPCG500'                                 => [ 'Mediacom', 'PhonePad Duo G500' ],
        'M-PPxG501'                                 => [ 'Mediacom', 'PhonePad Duo G501' ],
        'M-PP2G530'                                 => [ 'Mediacom', 'PhonePad Duo G530' ],
        'M-PPAG550'                                 => [ 'Mediacom', 'PhonePad Duo G550' ],
        'M-PPG700'                                  => [ 'Mediacom', 'PhonePad Duo G700' ],
        'M-PPG702'                                  => [ 'Mediacom', 'PhonePad Duo G702' ],
        'M-PPxS470'                                 => [ 'Mediacom', 'PhonePad Duo S470' ],
        'M-PP2S500'                                 => [ 'Mediacom', 'PhonePad Duo S500' ],
        'M-PP2S500B'                                => [ 'Mediacom', 'PhonePad Duo S500' ],
        'M-PP2S500C'                                => [ 'Mediacom', 'PhonePad Duo S500' ],
        'M-PPxS501'                                 => [ 'Mediacom', 'PhonePad Duo S501' ],
        'M-PPxS531'                                 => [ 'Mediacom', 'PhonePad Duo S531' ],
        'M-PP2S550'                                 => [ 'Mediacom', 'PhonePad Duo S550' ],
        'M-PPxS551U'                                => [ 'Mediacom', 'PhonePad Duo S551' ],
        'M-PP2S650'                                 => [ 'Mediacom', 'PhonePad Duo S650' ],
        'M-PP2S650C'                                => [ 'Mediacom', 'PhonePad Duo S650' ],
        'M-PPAX470U'                                => [ 'Mediacom', 'PhonePad Duo X470' ],
        'M PPAX510U'                                => [ 'Mediacom', 'PhonePad Duo X510' ],
        'M-PPxX520U'                                => [ 'Mediacom', 'PhonePad Duo X520' ],
    ],

    'M\-MP!!' => [
        'M-MP5303G'                                 => [ 'Mediacom', 'SmartPad Mini Mobile', DeviceType::TABLET ],
        'M-MP705I'                                  => [ 'Mediacom', 'SmartPad 705i', DeviceType::TABLET ],
        'M-MP706I'                                  => [ 'Mediacom', 'SmartPad 706i', DeviceType::TABLET ],
        'M-MP707i'                                  => [ 'Mediacom', 'SmartPad 707i', DeviceType::TABLET ],
        'M-MP711i'                                  => [ 'Mediacom', 'SmartPad 711i', DeviceType::TABLET ],
        'M-MP715I'                                  => [ 'Mediacom', 'SmartPad 715i', DeviceType::TABLET ],
        'M-MP720I'                                  => [ 'Mediacom', 'SmartPad 720i', DeviceType::TABLET ],
        'M-MP722I'                                  => [ 'Mediacom', 'SmartPad 722i', DeviceType::TABLET ],
        'M-MP815I'                                  => [ 'Mediacom', 'SmartPad 815i', DeviceType::TABLET ],
        'M-MP855i'                                  => [ 'Mediacom', 'SmartPad 855i', DeviceType::TABLET ],
        'M-MP860S2'                                 => [ 'Mediacom', 'SmartPad 860 S2', DeviceType::TABLET ],
        'M-MP85S23G'                                => [ 'Mediacom', 'SmartPad 875 S2', DeviceType::TABLET ],
        'M-MP875S2'                                 => [ 'Mediacom', 'SmartPad 875 S2', DeviceType::TABLET ],
        'M-MP917I'                                  => [ 'Mediacom', 'SmartPad 917i', DeviceType::TABLET ],
        'M-MP927I'                                  => [ 'Mediacom', 'SmartPad 927i', DeviceType::TABLET ],
        'M-MP940M'                                  => [ 'Mediacom', 'SmartPad 940', DeviceType::TABLET ],
        'M-MP1010i'                                 => [ 'Mediacom', 'SmartPad 1010i', DeviceType::TABLET ],
        'M-MP102S2B'                                => [ 'Mediacom', 'SmartPad 102 S2', DeviceType::TABLET ],
        'M-MP102S2W'                                => [ 'Mediacom', 'SmartPad 102 S2', DeviceType::TABLET ],
        'M-MP1040S2'                                => [ 'Mediacom', 'SmartPad 10.1 S2', DeviceType::TABLET ],
        'M-MP10S4'                                  => [ 'Mediacom', 'SmartPad 10.1 S4', DeviceType::TABLET ],
        'M-MP12S4'                                  => [ 'Mediacom', 'SmartPad 10.1 S4', DeviceType::TABLET ],
        'M-MP1040M'                                 => [ 'Mediacom', 'SmartPad 10.1 HD S4', DeviceType::TABLET ],
        'M-MP1040MC'                                => [ 'Mediacom', 'SmartPad 10.1 HD S4', DeviceType::TABLET ],
        'M-MP710GO'                                 => [ 'Mediacom', 'SmartPad 7.0 Go', DeviceType::TABLET ],
        'M-MP720GO'                                 => [ 'Mediacom', 'SmartPad 7.0 Go', DeviceType::TABLET ],
        'M-MP726GOx'                                => [ 'Mediacom', 'SmartPad 7.0 Go', DeviceType::TABLET ],
        'M-MP740GOx'                                => [ 'Mediacom', 'SmartPad 7.0 Go', DeviceType::TABLET ],
        'M-MP720M'                                  => [ 'Mediacom', 'SmartPad 7.0 Mobile', DeviceType::TABLET ],
        'M-MP721M'                                  => [ 'Mediacom', 'SmartPad 7.0 Mobile', DeviceType::TABLET ],
        'M-MP722M'                                  => [ 'Mediacom', 'SmartPad 7.0 Mobile', DeviceType::TABLET ],
        'M-MP75S23G'                                => [ 'Mediacom', 'SmartPad 7.0 S2', DeviceType::TABLET ],
        'M-MP7S2A3G'                                => [ 'Mediacom', 'SmartPad 7.0 S2', DeviceType::TABLET ],
        'M-MP7S2B3G'                                => [ 'Mediacom', 'SmartPad 7.0 S2', DeviceType::TABLET ],
        'M-MP7S2D3G'                                => [ 'Mediacom', 'SmartPad 7.0 S2', DeviceType::TABLET ],
        'M-MP7S2K3G'                                => [ 'Mediacom', 'SmartPad 7.0 S2', DeviceType::TABLET ],
        'M-MP7S4A3G'                                => [ 'Mediacom', 'SmartPad 7.0 S4', DeviceType::TABLET ],
        'M-MP840M'                                  => [ 'Mediacom', 'SmartPad 8.0 Mobile', DeviceType::TABLET ],
        'M-MP842M'                                  => [ 'Mediacom', 'SmartPad 8.0 Mobile', DeviceType::TABLET ],
        'M-MP876S2'                                 => [ 'Mediacom', 'SmartPad 8.0 S2', DeviceType::TABLET ],
        'M-MP8S23G'                                 => [ 'Mediacom', 'SmartPad 8.0 S2', DeviceType::TABLET ],
        'M-MP8S2A3G'                                => [ 'Mediacom', 'SmartPad 8.0 S2', DeviceType::TABLET ],
        'M-MP8S2B3G'                                => [ 'Mediacom', 'SmartPad 8.0 S2', DeviceType::TABLET ],
        'M-MP82S4'                                  => [ 'Mediacom', 'SmartPad 8.0 S4', DeviceType::TABLET ],
        'M-MP84S4'                                  => [ 'Mediacom', 'SmartPad 8.0 S4', DeviceType::TABLET ],
        'M-MP8S4A3G'                                => [ 'Mediacom', 'SmartPad 8.0 S4', DeviceType::TABLET ],
        'M-MP8S4B3G'                                => [ 'Mediacom', 'SmartPad 8.0 S4', DeviceType::TABLET ],
        'M-MP8PA3G'                                 => [ 'Mediacom', 'SmartPad 8.0 HD Pro', DeviceType::TABLET ],
        'M-MP9S4A3G'                                => [ 'Mediacom', 'SmartPad 9.7 S4', DeviceType::TABLET ],
        'M-MP980S4'                                 => [ 'Mediacom', 'SmartPad 9.7 HD S4', DeviceType::TABLET ],
        'M-MP99S4'                                  => [ 'Mediacom', 'SmartPad 9.7 HD S4', DeviceType::TABLET ],
        'M-MP101S2'                                 => [ 'Mediacom', 'SmartPad 10.1 S2', DeviceType::TABLET ],
        'M-MP1041S2'                                => [ 'Mediacom', 'SmartPad 10.1 S2', DeviceType::TABLET ],
        'M-MP1051S2'                                => [ 'Mediacom', 'SmartPad 10.1 S2', DeviceType::TABLET ],
        'M-MP1S2A3G'                                => [ 'Mediacom', 'SmartPad 10.1 S2', DeviceType::TABLET ],
        'M-MP1S4A3G'                                => [ 'Mediacom', 'SmartPad 10.1 S4', DeviceType::TABLET ],
        'M-MP1S4B3G'                                => [ 'Mediacom', 'SmartPad 10.1 S4', DeviceType::TABLET ],
        'M-MP10PA'                                  => [ 'Mediacom', 'SmartPad 10.1 HD Pro', DeviceType::TABLET ],
        'M-MP10PA3G'                                => [ 'Mediacom', 'SmartPad 10.1 HD Pro', DeviceType::TABLET ],
        'M-MPI7A3G'                                 => [ 'Mediacom', 'SmartPad i7', DeviceType::TABLET ],
    ],

    'M\-IPRO!!' => [
        'M-IPRO110B'                                => [ 'Mediacom', 'SmartPad 8.0 HD iPro110', DeviceType::TABLET ],
        'M-IPRO800B'                                => [ 'Mediacom', 'SmartPad 8.0 HD iPro800', DeviceType::TABLET ],
        'M-IPRO810B'                                => [ 'Mediacom', 'SmartPad 8.0 HD iPro810', DeviceType::TABLET ],
        'M-IPRO810W'                                => [ 'Mediacom', 'SmartPad 8.0 HD iPro810', DeviceType::TABLET ],
    ],

    'MP[0-9]{3,3}C!!' => [
        'MP705C'                                    => [ 'Mediacom', 'SmartPad 705c', DeviceType::TABLET ],
        'MP810C'                                    => [ 'Mediacom', 'SmartPad 810c', DeviceType::TABLET ],
        'MP907C'                                    => [ 'Mediacom', 'SmartPad 907c', DeviceType::TABLET ],
    ],

    'STM[0-9]{3,3}H!!' => [
        'STM712HCZ'                                 => [ 'Mediacom', 'SmartPad 712c', DeviceType::TABLET ],
        'STM722HC'                                  => [ 'Mediacom', 'SmartPad 722c', DeviceType::TABLET ],
        'STM722HCZ'                                 => [ 'Mediacom', 'SmartPad 722c', DeviceType::TABLET ],
        'STM803HC'                                  => [ 'Mediacom', 'SmartPad 810c', DeviceType::TABLET ],
    ],

    'SmartPad!!' => [
        'SmartPad7503G'                             => [ 'Mediacom', 'SmartPad 750', DeviceType::TABLET ],
        'SmartPad810c'                              => [ 'Mediacom', 'SmartPad 810c', DeviceType::TABLET ],
        'SmartPad 852i'                             => [ 'Mediacom', 'SmartPad 825i', DeviceType::TABLET ],
        'SmartPad870'                               => [ 'Mediacom', 'SmartPad 870 S2', DeviceType::TABLET ],
        'Smartpad 910i aka Teclast A10T'            => [ 'Mediacom', 'SmartPad 910i', DeviceType::TABLET ],
        'SmartPad 95s23G'                           => [ 'Mediacom', 'SmartPad 950 S2', DeviceType::TABLET ],
        'SmartPad970s2'                             => [ 'Mediacom', 'SmartPad 970 S2', DeviceType::TABLET ],
        'SmartPad970s23G'                           => [ 'Mediacom', 'SmartPad 970 S2', DeviceType::TABLET ],
        'SmartPad1010i'                             => [ 'Mediacom', 'SmartPad 1010i', DeviceType::TABLET ],
        'SmartPad 85S23G'                           => [ 'Mediacom', 'SmartPad 8.0 S2', DeviceType::TABLET ],
    ],

    'Mediacom 810C'                             => [ 'Mediacom', 'SmartPad 810c', DeviceType::TABLET ],
    'Xteam Smartpad 810c'                       => [ 'Mediacom', 'SmartPad 810c', DeviceType::TABLET ],
    'Xteam 4.8 Smartpad 810c'                   => [ 'Mediacom', 'SmartPad 810c', DeviceType::TABLET ],
    '932i'                                      => [ 'Mediacom', 'SmartPad 932i', DeviceType::TABLET ],

    'MT70[0-9]{2,2}!!' => [
        'MT7000'                                    => [ 'Mediadroid', 'MASTER-MID GPS', DeviceType::TABLET ],
        'MT7001'                                    => [ 'Mediadroid', 'ENGAGE HQ PRO', DeviceType::TELEVISION ],
        'MT7002'                                    => [ 'Mediadroid', 'ENGAGE HQ', DeviceType::TELEVISION ],
        'MT7003'                                    => [ 'Mediadroid', 'IMPERIUS' ],
        'MT7004'                                    => [ 'Mediadroid', 'CASSIUS', DeviceType::TABLET ],
        'MT7005'                                    => [ 'Mediadroid', 'IMPERIUS AERO' ],
        'MT7005'                                    => [ 'Mediadroid', 'IMPERIUS 4.3 HQ' ],
        'MT7007'                                    => [ 'Mediadroid', 'IMPERIUS II' ],
        'MT7008'                                    => [ 'Mediadroid', 'IMPERIUS N3XT' ],
        'MT7009'                                    => [ 'Mediadroid', 'IMPERIUS SEVEN 3G', DeviceType::TABLET ],
        'MT7010'                                    => [ 'Mediadroid', 'IMPERIUS TAB 10 LT', DeviceType::TABLET ],
        'MT7011'                                    => [ 'Mediadroid', 'IMPERIUS TAB 10', DeviceType::TABLET ],
        'MT7012'                                    => [ 'Mediadroid', 'IMPERIUS TAB 10 3G', DeviceType::TABLET ],
        'MT7013'                                    => [ 'Mediadroid', 'IMPERIUS EN3RGY' ],
        'MT7014'                                    => [ 'Mediadroid', 'IMPERIUS AERO SLIM' ],
        'MT7015'                                    => [ 'Mediadroid', 'IMPERIUS MINI' ],
        'MT7017'                                    => [ 'Mediadroid', 'IMPERIUS ALPHA' ],
    ],

    'MTK6516'                                   => [ 'Mediatek', 'MTK6516' ],

    '(MEDION|(MD )?LIFETAB)!!' => [
        'MEDION Smartphone LIFE E3501'              => [ 'Medion', 'Life E3501' ],
        'MEDION E4001'                              => [ 'Medion', 'E4001' ],
        'MEDION E4002'                              => [ 'Medion', 'E4002' ],
        'MEDION E4005'                              => [ 'Medion', 'E4005' ],
        'MEDION E4502'                              => [ 'Medion', 'E4502' ],
        'MEDION E4503'                              => [ 'Medion', 'E4503' ],
        'MEDION E4504'                              => [ 'Medion', 'E4504' ],
        'MEDION E4506'                              => [ 'Medion', 'E4506' ],
        'LIFETAB E7310'                             => [ 'Medion', 'Lifetab E7310', DeviceType::TABLET ],
        'LIFETAB E7312'                             => [ 'Medion', 'Lifetab E7312', DeviceType::TABLET ],
        'LIFETAB E7313'                             => [ 'Medion', 'Lifetab E7313', DeviceType::TABLET ],
        'LIFETAB E7316'                             => [ 'Medion', 'Lifetab E7316', DeviceType::TABLET ],
        'LIFETAB E723X'                             => [ 'Medion', 'Lifetab E723X', DeviceType::TABLET ],
        'LIFETAB E732X'                             => [ 'Medion', 'Lifetab E732X', DeviceType::TABLET ],
        'LIFETAB E733X'                             => [ 'Medion', 'Lifetab E733X', DeviceType::TABLET ],
        'LIFETAB E10310'                            => [ 'Medion', 'Lifetab E10310', DeviceType::TABLET ],
        'LIFETAB E10312'                            => [ 'Medion', 'Lifetab E10312', DeviceType::TABLET ],
        'LIFETAB E10316'                            => [ 'Medion', 'Lifetab E10316', DeviceType::TABLET ],
        'LIFETAB E10320'                            => [ 'Medion', 'Lifetab E10320', DeviceType::TABLET ],
        'LIFETAB P733X'                             => [ 'Medion', 'Lifetab P733X', DeviceType::TABLET ],
        'LIFETAB P831X'                             => [ 'Medion', 'Lifetab P831X', DeviceType::TABLET ],
        'LIFETAB P831X.2'                           => [ 'Medion', 'Lifetab P831X', DeviceType::TABLET ],
        'LIFETAB P891X'                             => [ 'Medion', 'Lifetab P891X', DeviceType::TABLET ],
        'LIFETAB P1034X'                            => [ 'Medion', 'Lifetab P1034X', DeviceType::TABLET ],
        'LIFETAB S7316'                             => [ 'Medion', 'Lifetab S7316', DeviceType::TABLET ],
        'LIFETAB S732X'                             => [ 'Medion', 'Lifetab S732X', DeviceType::TABLET ],
        'LIFETAB S785X'                             => [ 'Medion', 'Lifetab S785X', DeviceType::TABLET ],
        'LIFETAB S786X'                             => [ 'Medion', 'Lifetab S786X', DeviceType::TABLET ],
        'LIFETAB S831X'                             => [ 'Medion', 'Lifetab S831X', DeviceType::TABLET ],
        'LIFETAB S9512'                             => [ 'Medion', 'Lifetab S9512', DeviceType::TABLET ],
        'LIFETAB S9714'                             => [ 'Medion', 'Lifetab S9714', DeviceType::TABLET ],
        'LIFETAB S1033X'                            => [ 'Medion', 'Lifetab S1033X', DeviceType::TABLET ],
        'LIFETAB S1034X'                            => [ 'Medion', 'Lifetab S1034X', DeviceType::TABLET ],
        'LIFETAB S1036X'                            => [ 'Medion', 'Lifetab S1036X', DeviceType::TABLET ],
        'MEDION LIFE P4012'                         => [ 'Medion', 'Life P4012' ],
        'MEDION P4013'                              => [ 'Medion', 'Life P4013' ],
        'MEDION-P4013'                              => [ 'Medion', 'Life P4013' ],
        'MEDION LIFE P4310'                         => [ 'Medion', 'Life P4310' ],
        'MEDION P5001'                              => [ 'Medion', 'Life P5001' ],
        'MEDION X4701'                              => [ 'Medion', 'X4701' ],
        'MEDION X5004'                              => [ 'Medion', 'X5004' ],
        'MEDION X5020'                              => [ 'Medion', 'X5020' ],
        'LIFETAB P9514'                             => [ 'Medion', 'Lifetab P9514', DeviceType::TABLET ],
        'MD LIFETAB P9516'                          => [ 'Medion', 'Lifetab P9516', DeviceType::TABLET ],
    ],

    'P1050X'                                    => [ 'Medion', 'Lifetab P1050X', DeviceType::TABLET ],

    'MEEG!!' => [
        'MEEG 101'                                  => [ 'MEEG', '101' ],
        'MEEG 101M'                                 => [ 'MEEG', '101M' ],
        'MEEG 105'                                  => [ 'MEEG', '105' ],
        'MEEG 105S'                                 => [ 'MEEG', '105S' ],
        'MEEG 106'                                  => [ 'MEEG', '106' ],
        'MEEG 201'                                  => [ 'MEEG', '201' ],
        'MEEG 210R'                                 => [ 'MEEG', '210R' ],
    ],

    'meizu m1note'                              => [ 'Meizu', 'M1 Note' ],
    'm1 note'                                   => [ 'Meizu', 'M1 Note' ],
    'm2 note'                                   => [ 'Meizu', 'M2 Note' ],
    'MZ-m2 note'                                => [ 'Meizu', 'M2 Note' ],
    'M571C'                                     => [ 'Meizu', 'M2 Note' ],
    'MZ-M571C'                                  => [ 'Meizu', 'M2 Note' ],
    'M578C'                                     => [ 'Meizu', 'M2' ],
    'MEIZU M5'                                  => [ 'Meizu', 'M5' ],
    'M8'                                        => [ 'Meizu', 'M8' ],
    'M9'                                        => [ 'Meizu', 'M9' ],
    'M9-unlocked'                               => [ 'Meizu', 'M9' ],
    'MEIZU M9'                                  => [ 'Meizu', 'M9' ],
    'MEIZU MX'                                  => [ 'Meizu', 'MX' ],
    'M030'                                      => [ 'Meizu', 'MX M030' ],
    'M031'                                      => [ 'Meizu', 'MX M031' ],
    'M032'                                      => [ 'Meizu', 'MX M032' ],
    'MX2'                                       => [ 'Meizu', 'MX2' ],
    'M040'                                      => [ 'Meizu', 'MX2 M040' ],
    'M045'                                      => [ 'Meizu', 'MX2 M045' ],
    'M351'                                      => [ 'Meizu', 'MX3 M351' ],
    'M353'                                      => [ 'Meizu', 'MX3 M353' ],
    'M355'                                      => [ 'Meizu', 'MX3 M355' ],
    'M356'                                      => [ 'Meizu', 'MX3 M356' ],
    'MX4'                                       => [ 'Meizu', 'MX4' ],
    'MZ-MX4'                                    => [ 'Meizu', 'MX4' ],
    'MX4 Pro'                                   => [ 'Meizu', 'MX4 Pro' ],

    '(MEO )?Smart A!!' => [
        'meo smart a12'                             => [ 'MEO', 'Smart A12' ],
        'MEO SMART A16'                             => [ 'MEO', 'Smart A16' ],
        'MEO Smart A40'                             => [ 'MEO', 'Smart A40' ],
        'Smart A65'                                 => [ 'MEO', 'Smart A65' ],
        'Smart A66'                                 => [ 'MEO', 'Smart A66' ],
        'MEO Smart A68'                             => [ 'MEO', 'Smart A68' ],
        'meo smart a70'                             => [ 'MEO', 'Smart A70' ],
        'MEO Smart A75'                             => [ 'MEO', 'Smart A75' ],
        'MEO A75'                                   => [ 'MEO', 'Smart A75' ],
        'MEO Smart A80'                             => [ 'MEO', 'Smart A80' ],
    ],

    'MEU AN!!' => [
        'MEU AN400'                                 => [ 'MEU', 'AN400' ],
        'MEU AN500'                                 => [ 'MEU', 'AN500' ],
    ],

    'Slidepad!!' => [
        'Slidepad'                                  => [ 'Memup', 'Slidepad', DeviceType::TABLET ],
        'SlidePad 104'                              => [ 'Memup', 'Slidepad 104', DeviceType::TABLET ],
        'SlidePad 108'                              => [ 'Memup', 'Slidepad 108', DeviceType::TABLET ],
        'SlidePad704CE'                             => [ 'Memup', 'Slidepad 704CE', DeviceType::TABLET ],
        '704DC'                                     => [ 'Memup', 'Slidepad 704DC', DeviceType::TABLET ],
        'SlidePad 816P'                             => [ 'Memup', 'Slidepad 816P', DeviceType::TABLET ],
        'SlidePad Elite 9708'                       => [ 'Memup', 'Slidepad Elite 9708', DeviceType::TABLET ],
        'SlidePad Kids'                             => [ 'Memup', 'Slidepad Kids', DeviceType::TABLET ],
        'SlidePad NG 116DC'                         => [ 'Memup', 'Slidepad NG 116DC', DeviceType::TABLET ],
        'SlidePad NG 704DC'                         => [ 'Memup', 'Slidepad NG 704DC', DeviceType::TABLET ],
    ],

    'SPNG9716DC'                                => [ 'Memup', 'Slidepad NG 9716DC', DeviceType::TABLET ],
    'Mi-A402'                                   => [ 'Mi-fone', 'FAB 4.0' ],

    'Micromax!!' => [
        'Micromax A24'                              => [ 'Micromax', 'A24 Bolt' ],
        'Micromax A25'                              => [ 'Micromax', 'A25 Smarty' ],
        'Micromax A26'                              => [ 'Micromax', 'A26 Bolt' ],
        'Micromax A27'                              => [ 'Micromax', 'A27 Bolt' ],
        'Micromax A28'                              => [ 'Micromax', 'A28 Bolt' ],
        'Micromax A30'                              => [ 'Micromax', 'A30 Smarty' ],
        'Micromax A34'                              => [ 'Micromax', 'A34' ],
        'Micromax A35'                              => [ 'Micromax', 'A35 Bolt' ],
        'Micromax A36'                              => [ 'Micromax', 'A36 Bolt' ],
        'Micromax A37'                              => [ 'Micromax', 'A37 Bolt' ],
        'Micromax A37B'                             => [ 'Micromax', 'A37B Bolt' ],
        'Micromax A40'                              => [ 'Micromax', 'A40 Bolt' ],
        'Micromax A44'                              => [ 'Micromax', 'A44 Punk' ],
        'Micromax A46'                              => [ 'Micromax', 'A46 Bolt' ],
        'Micromax A47'                              => [ 'Micromax', 'A47 Bolt' ],
        'Micromax A50'                              => [ 'Micromax', 'A50 Ninja' ],
        'Micromax A51'                              => [ 'Micromax', 'A51 Bolt' ],
        'Micromax A52'                              => [ 'Micromax', 'A52 Aisha' ],
        'Micromax-Xzoom A52'                        => [ 'Micromax', 'A52 Aisha' ],
        'Micromax A54'                              => [ 'Micromax', 'A54 Ninja' ],
        'Micromax A56'                              => [ 'Micromax', 'A56 Ninja 2' ],
        'Micromax A57'                              => [ 'Micromax', 'A57 Ninja 3' ],
        'Micromax A58'                              => [ 'Micromax', 'A58 Bolt' ],
        'Micromax A59'                              => [ 'Micromax', 'A59 Bolt' ],
        'Micromax A60'                              => [ 'Micromax', 'A60 Andro' ],
        'Micromax A61'                              => [ 'Micromax', 'A61 Bolt' ],
        'Micromax A62'                              => [ 'Micromax', 'A62 Bolt' ],
        'Micromax A63'                              => [ 'Micromax', 'A63 Canvas Fun' ],
        'Micromax A65'                              => [ 'Micromax', 'A65 Smarty' ],
        'Micromax A66'                              => [ 'Micromax', 'A66 Bolt' ],
        'Micromax A67'                              => [ 'Micromax', 'A67 Bolt' ],
        'Micromax A68'                              => [ 'Micromax', 'A68 Smarty' ],
        'Micromax A69'                              => [ 'Micromax', 'A69 Bolt' ],
        'Micromax A70'                              => [ 'Micromax', 'A70 Andro' ],
        'Micromax A71'                              => [ 'Micromax', 'A71 Bolt' ],
        'Micromax A72'                              => [ 'Micromax', 'A72 Canvas Viva' ],
        'Micromax A73'                              => [ 'Micromax', 'A73 Buzz' ],
        'Micromax A74'                              => [ 'Micromax', 'A74 Canvas Fun' ],
        'Micromax A75'                              => [ 'Micromax', 'A75 Lite' ],
        'Micromax A76'                              => [ 'Micromax', 'A76 Canvas Fun' ],
        'Micromax A77'                              => [ 'Micromax', 'A77 Canvas Juice' ],
        'Micromax A78'                              => [ 'Micromax', 'A78 Gossip' ],
        'Micromax A79'                              => [ 'Micromax', 'A79 Bolt' ],
        'Micromax A80'                              => [ 'Micromax', 'A80 Infinity' ],
        'Micromax A82'                              => [ 'Micromax', 'A82 Bolt' ],
        'Micromax A84'                              => [ 'Micromax', 'A84' ],
        'Micromax A85'                              => [ 'Micromax', 'A85' ],
        'Micromax A86'                              => [ 'Micromax', 'A86 Bling 3' ],
        'Micromax A87!'                             => [ 'Micromax', 'A87 Ninja 4' ],
        'Micromax A88'                              => [ 'Micromax', 'A88 Canvas Music' ],
        'Micromax A89'                              => [ 'Micromax', 'A89 Ninja' ],
        'Micromax A90!'                             => [ 'Micromax', 'A90 Pixel' ],
        'Micromax A91'                              => [ 'Micromax', 'A91 Ninja' ],
        'Micromax A92'                              => [ 'Micromax', 'A92 Canvas Lite' ],
        'Micromax A93'                              => [ 'Micromax', 'A93 Canvas Elanza' ],
        'Micromax A94'                              => [ 'Micromax', 'A94 Canvas Mad' ],
        'Micromax A96'                              => [ 'Micromax', 'A96 Canvas Power' ],
        'Micromax A99'                              => [ 'Micromax', 'A99 Canvas Xpress' ],
        'Micromax A064'                             => [ 'Micromax', 'A064 Bolt' ],
        'Micromax A065'                             => [ 'Micromax', 'A065 Bolt' ],
        'Micromax A066'                             => [ 'Micromax', 'A066 Bolt' ],
        'Micromax A067'                             => [ 'Micromax', 'A067 Bolt' ],
        'Micromax A068'                             => [ 'Micromax', 'A068 Bolt' ],
        'Micromax A069'                             => [ 'Micromax', 'A069 Bolt' ],
        'Micromax A075'                             => [ 'Micromax', 'A075 Bolt' ],
        'Micromax A082'                             => [ 'Micromax', 'A082 Bolt' ],
        'Micromax A089'                             => [ 'Micromax', 'A089 Bolt' ],
        'Micromax A091'                             => [ 'Micromax', 'A091 Canvas Engage' ],
        'Micromax A092'                             => [ 'Micromax', 'A092 Canvas Unite' ],
        'Micromax A093'                             => [ 'Micromax', 'A093 Canvas Fire' ],
        'Micromax A096'                             => [ 'Micromax', 'A096 Canvas Fire 3' ],
        'Micromax A100'                             => [ 'Micromax', 'A100 Canvas' ],
        'Micromax A101'                             => [ 'Micromax', 'A101' ],
        'Micromax A102'                             => [ 'Micromax', 'A102 Canvas Doodle 3' ],
        'Micromax A104'                             => [ 'Micromax', 'A104 Canvas Fire' ],
        'Micromax A105'                             => [ 'Micromax', 'A105 Canvas Entice' ],
        'Micromax A106'                             => [ 'Micromax', 'A106 Unite 2' ],
        'Micromax A107'                             => [ 'Micromax', 'A107 Canvas Fire 4' ],
        'Micromax A108'                             => [ 'Micromax', 'A108 Canvas L' ],
        'Micromax A109'                             => [ 'Micromax', 'A109 Canvas XL2' ],
        'Micromax A110'                             => [ 'Micromax', 'A110 Canvas 2' ],
        'Micromax Canvas 2'                         => [ 'Micromax', 'A110 Canvas 2' ],
        'Micromax A110 (Canvas 2)'                  => [ 'Micromax', 'A110 Canvas 2' ],
        'Micromax A110Q'                            => [ 'Micromax', 'A110Q Canvas 2 Plus' ],
        'Micromax A111!'                            => [ 'Micromax', 'A111 Canvas Doodle' ],
        'Micromax A114'                             => [ 'Micromax', 'A114 Canvas 2.2' ],
        'Micromax A114R'                            => [ 'Micromax', 'A114R Canvas Beat' ],
        'Micromax A115'                             => [ 'Micromax', 'A115 Canvas 3D' ],
        'Micromax A116'                             => [ 'Micromax', 'A116 Canvas HD' ],
        'Micromax A116i'                            => [ 'Micromax', 'A116i Canvas HD' ],
        'Micromax A117'                             => [ 'Micromax', 'A117 Canvas Magnus' ],
        'Micromax A118R'                            => [ 'Micromax', 'A118 Canvas Tube' ],
        'Micromax A119'                             => [ 'Micromax', 'A119 Canvas XL' ],
        'Micromax A120'                             => [ 'Micromax', 'A120 Canvas 2 Colors' ],
        'Micromax A121'                             => [ 'Micromax', 'A120 Canvas Elanza 2' ],
        'Micromax A177'                             => [ 'Micromax', 'A177 Canvas Juice' ],
        'Micromax A190'                             => [ 'Micromax', 'A190 Canvas HD Plus' ],
        'Micromax A200'                             => [ 'Micromax', 'A200 Canvas Turbo Mini' ],
        'Micromax A210'                             => [ 'Micromax', 'A210 Canvas 4' ],
        'Micromax A240'                             => [ 'Micromax', 'A240 Canvas Doodle 2' ],
        'Micromax A250'                             => [ 'Micromax', 'A250 Canvas Turbo' ],
        'Micromax A255'                             => [ 'Micromax', 'A255 Canvas Selfie' ],
        'Micromax A290'                             => [ 'Micromax', 'A290 Canvas Knight Cameo' ],
        'Micromax A300'                             => [ 'Micromax', 'A300 Canvas Gold' ],
        'Micromax A310'                             => [ 'Micromax', 'A310 Canvas Nitro' ],
        'Micromax A311'                             => [ 'Micromax', 'A311 Canvas Nitro' ],
        'Micromax A315'                             => [ 'Micromax', 'A315 Canvas 4 Plus' ],
        'Micromax A316'                             => [ 'Micromax', 'A316 Canvas Hue 2' ],
        'Micromax A350'                             => [ 'Micromax', 'A350 Canvas Knight' ],
        'Micromax AD3520'                           => [ 'Micromax', 'AD3520 Bolt' ],
        'Micromax AE90'                             => [ 'Micromax', 'AE90 Canvas Duet' ],
        'Micromax AD4500'                           => [ 'Micromax', 'AQ4500 Bolt' ],
        'Micromax AQ4501'                           => [ 'Micromax', 'AQ4501 Canvas A1' ],
        'Micromax AQ4502'                           => [ 'Micromax', 'AQ4502 Canvas A1' ],
        'Micromax AQ5000'                           => [ 'Micromax', 'AQ5000 Canvas Hue' ],
        'Micromax AQ5001'                           => [ 'Micromax', 'AQ5001 Canvas Juice 2' ],
        'Micromax D200'                             => [ 'Micromax', 'D200 Bolt' ],
        'Micromax D303'                             => [ 'Micromax', 'D303 Bolt' ],
        'Micromax D304'                             => [ 'Micromax', 'D304 Bolt' ],
        'Micromax D321'                             => [ 'Micromax', 'D321 Bolt' ],
        'Micromax E311'                             => [ 'Micromax', 'E311 Canvas Nitro 2' ],
        'Micromax E313'                             => [ 'Micromax', 'E313 Canvas Express 2' ],
        'Micromax E352'                             => [ 'Micromax', 'E352 Canvas Nitro 3' ],
        'Micromax E353'                             => [ 'Micromax', 'E353 Canvas Mega' ],
        'Micromax E451'                             => [ 'Micromax', 'E451 Canvas Pulse 4G' ],
        'Micromax E455'                             => [ 'Micromax', 'E455 Canvas Nitro 4G' ],
        'Micromax E471'                             => [ 'Micromax', 'E471 Canvas Knight 2' ],
        'Micromax E481'                             => [ 'Micromax', 'E481 Canvas 5' ],
        'Micromax E484'                             => [ 'Micromax', 'E484 Canvas 6 Pro' ],
        'Micromax E485'                             => [ 'Micromax', 'E485 Canvas 6' ],
        'Micromax EG111'                            => [ 'Micromax', 'EG111 Canvas Duet 2' ],
        'Micromax F666'                             => [ 'Micromax', 'F666' ],
        'Micromax P250(Funbook)'                    => [ 'Micromax', 'Funbook Alpha P250', DeviceType::TABLET ],
        'Micromax P255'                             => [ 'Micromax', 'Funbook P255', DeviceType::TABLET ],
        'Micromax P275'                             => [ 'Micromax', 'Funbook Infinity P275', DeviceType::TABLET ],
        'Micromax P280'                             => [ 'Micromax', 'Funbook P280', DeviceType::TABLET ],
        'Micromax P290'                             => [ 'Micromax', 'Canvas Tab P290', DeviceType::TABLET ],
        'Micromax P350'                             => [ 'Micromax', 'Funbook P350', DeviceType::TABLET ],
        'Micromax P360'                             => [ 'Micromax', 'Funbook Talk P360', DeviceType::TABLET ],
        'Micromax P362'                             => [ 'Micromax', 'Funbook Talk P362', DeviceType::TABLET ],
        'Micromax P365'                             => [ 'Micromax', 'Funbook P365', DeviceType::TABLET ],
        'Micromax P410'                             => [ 'Micromax', 'Funbook Mini P410', DeviceType::TABLET ],
        'Micromax P410i'                            => [ 'Micromax', 'Funbook Mini P410i', DeviceType::TABLET ],
        'Micromax P470'                             => [ 'Micromax', 'Canvas Tab P470', DeviceType::TABLET ],
        'MicromaxP480'                              => [ 'Micromax', 'Canvas Tab P480', DeviceType::TABLET ],
        'Micromax P500(Funbook)'                    => [ 'Micromax', 'Funbook Pro P500', DeviceType::TABLET ],
        'Micromax P560'                             => [ 'Micromax', 'Funbook 3G P560', DeviceType::TABLET ],
        'Micromax P580'                             => [ 'Micromax', 'Funbook Ultra HD P580', DeviceType::TABLET ],
        'Micromax P600'                             => [ 'Micromax', 'Funbook 3G P600', DeviceType::TABLET ],
        'Micromax P650'                             => [ 'Micromax', 'Canvas Tab P650', DeviceType::TABLET ],
        'Micromax P666'                             => [ 'Micromax', 'Canvas Tab P666', DeviceType::TABLET ],
        'MicromaxP680'                              => [ 'Micromax', 'Canvas Tab P680', DeviceType::TABLET ],
        'Micromax P690'                             => [ 'Micromax', 'Canvas Tab P690', DeviceType::TABLET ],
        'Micromax Q300'                             => [ 'Micromax', 'Q300 Bolt Supreme' ],
        'Micromax Q301'                             => [ 'Micromax', 'Q301 Bolt Supreme 2' ],
        'Micromax Q323'                             => [ 'Micromax', 'Q323 Bolt' ],
        'Micromax Q324'                             => [ 'Micromax', 'Q324 Bolt' ],
        'Micromax Q325'                             => [ 'Micromax', 'Q325 Bolt' ],
        'Micromax Q326'                             => [ 'Micromax', 'Q326 Bolt' ],
        'Micromax Q327'                             => [ 'Micromax', 'Q327 Bolt' ],
        'Micromax Q331'                             => [ 'Micromax', 'Q331 Bolt' ],
        'Micromax Q332'                             => [ 'Micromax', 'Q332 Bolt' ],
        'Micromax Q333'                             => [ 'Micromax', 'Q333 Bolt' ],
        'Micromax Q334'                             => [ 'Micromax', 'Q334 Canvas Spark 2' ],
        'Micromax Q335'                             => [ 'Micromax', 'Q335 Bolt' ],
        'Micromax Q336'                             => [ 'Micromax', 'Q336 Bolt' ],
        'Micromax Q338'                             => [ 'Micromax', 'Q338 Bolt' ],
        'Micromax Q340'                             => [ 'Micromax', 'Q340 Canvas Selfie 2' ],
        'Micromax Q345'                             => [ 'Micromax', 'Q345 Canvas Selfie Lens' ],
        'Micromax Q346'                             => [ 'Micromax', 'Q346 Bolt' ],
        'Micromax Q348'                             => [ 'Micromax', 'Q348 Canvas Selfie 3' ],
        'Micromax Q352'                             => [ 'Micromax', 'Q355 Bolt Supreme 4' ],
        'Micromax Q355'                             => [ 'Micromax', 'Q355 Canvas Play' ],
        'Micromax Q370'                             => [ 'Micromax', 'Q370 Canvas Pep' ],
        'Micromax Q371'                             => [ 'Micromax', 'Q371 Canvas Pep' ],
        'Micromax Q372'                             => [ 'Micromax', 'Q372 Unite 3' ],
        'Micromax Q375'                             => [ 'Micromax', 'Q375 Canvas Pep' ],
        'Micromax Q379'                             => [ 'Micromax', 'Q379 Unite 3' ],
        'Micromax Q380'                             => [ 'Micromax', 'Q380 Canvas Spark' ],
        'Micromax Q380N'                            => [ 'Micromax', 'Q380 Canvas Spark' ],
        'Micromax Q381'                             => [ 'Micromax', 'Q381 Bolt' ],
        'Micromax Q382'                             => [ 'Micromax', 'Q382 Canvas Juice 4' ],
        'Micromax Q383'                             => [ 'Micromax', 'Q383 Bolt' ],
        'Micromax Q385'                             => [ 'Micromax', 'Q385 Canvas Spark 3' ],
        'Micromax Q386'                             => [ 'Micromax', 'Q386 Canvas Fire 5' ],
        'Micromax Q391'                             => [ 'Micromax', 'Q391 Canvas Doodle 4' ],
        'Micromax Q392'                             => [ 'Micromax', 'Q392 Canvas Juice 3' ],
        'Micromax Q394'                             => [ 'Micromax', 'Q394 Canvas Juice 3+' ],
        'Micromax Q395'                             => [ 'Micromax', 'Q395 Canvas Amaze' ],
        'Micromax Q400'                             => [ 'Micromax', 'Q400 Canvas Blaze' ],
        'Micromax Q411'                             => [ 'Micromax', 'Q411 Canvas Fire' ],
        'Micromax Q412'                             => [ 'Micromax', 'Q412 Canvas Play' ],
        'Micromax Q413'                             => [ 'Micromax', 'Q413 Canvas Xpress' ],
        'Micromax Q414'                             => [ 'Micromax', 'Q414 Canvas Blaze 4G+' ],
        'Micromax Q416'                             => [ 'Micromax', 'Q416 Canvas Pace' ],
        'Micromax Q417'                             => [ 'Micromax', 'Q417 Canvas Mega' ],
        'Micromax Q424'                             => [ 'Micromax', 'Q424 Bolt Selfie' ],
        'Micromax Q426'                             => [ 'Micromax', 'Q426 Canvas Mega 2' ],
        'Micromax Q450'                             => [ 'Micromax', 'Q450 Sliver 5' ],
        'Micromax Q461'                             => [ 'Micromax', 'Q461 Canvas Juice' ],
        'Micromax Q465'                             => [ 'Micromax', 'Q465 Canvas Juice 4 Gold' ],
        'Micromax Q469'                             => [ 'Micromax', 'Q469 Canvas Play' ],
        'Micromax Q491'                             => [ 'Micromax', 'Q491 Canvas Doodle 4' ],
        'Micromax Q4251'                            => [ 'Micromax', 'Q4251 Canvas Juice A1' ],
        'Micromax S300'                             => [ 'Micromax', 'S300 Bolt' ],
        'Micromax S301'                             => [ 'Micromax', 'S301 Bolt' ],
        'Micromax S302'                             => [ 'Micromax', 'S302 Bolt' ],
    ],

    'A13'                                       => [ 'Micromax', 'A13' ],
    'A45'                                       => [ 'Micromax', 'A45 Punk' ],
    'A47'                                       => [ 'Micromax', 'A47 Bolt' ],
    'A52'                                       => [ 'Micromax', 'A52 Aisha' ],
    'A87'                                       => [ 'Micromax', 'A87 Ninja 4' ],
    'A90S'                                      => [ 'Micromax', 'A90S Pixel' ],
    'A110Q'                                     => [ 'Micromax', 'A110Q Canvas 2 Plus' ],
    'A110Q Canvas 2 Plus'                       => [ 'Micromax', 'A110Q Canvas 2 Plus' ],
    'A110Q Canvas 2+'                           => [ 'Micromax', 'A110Q Canvas 2 Plus' ],
    'P300(Funbook)'                             => [ 'Micromax', 'Funbook P300', DeviceType::TABLET ],
    'P701'                                      => [ 'Micromax', 'Canvas Tab P701', DeviceType::TABLET ],

    'MLLED!!' => [
        'MLLED M1B'                                 => [ 'MLLED', 'M1B' ],
        'MLLED M2+'                                 => [ 'MLLED', 'M2+' ],
        'MLLED M3 MINI'                             => [ 'MLLED', 'M3 MINI' ],
        'MLLED M7S'                                 => [ 'MLLED', 'M7S' ],
        'MLLED M8'                                  => [ 'MLLED', 'M8' ],
        'MLLED M8S'                                 => [ 'MLLED', 'M8S' ],
        'MLLED X3S'                                 => [ 'MLLED', 'X3S' ],
    ],

    'Mio!!' => [
        'MioCARE A105'                              => [ 'Mitac', 'MioCARE A105' ],
        'MioCare 6119'                              => [ 'Mitac', 'MioCARE 6119' ],
        'MioPad 6'                                  => [ 'Mitac', 'MioPad 6', DeviceType::TABLET ],
    ],

    'MITO!!' => [
        'MITO A10'                                  => [ 'MITO', 'A10' ],
        'MITO A15'                                  => [ 'MITO', 'A15' ],
        'MITO A18'                                  => [ 'MITO', 'A18' ],
        'MITO A30'                                  => [ 'MITO', 'A30' ],
        'MITO A33'                                  => [ 'MITO', 'A33' ],
        'MITO A38'                                  => [ 'MITO', 'A38' ],
        'MITO A50'                                  => [ 'MITO', 'A50' ],
        'MITO A55'                                  => [ 'MITO', 'A55' ],
        'MITO A60'                                  => [ 'MITO', 'A60' ],
        'MITO A68'                                  => [ 'MITO', 'A68' ],
        'MITO 68'                                   => [ 'MITO', 'A68' ],
        'MITO A72'                                  => [ 'MITO', 'A72' ],
        'MITO A73'                                  => [ 'MITO', 'A73' ],
        'MITO A75'                                  => [ 'MITO', 'A75' ],
        'MITO A77'                                  => [ 'MITO', 'A77' ],
        'MITO A78'                                  => [ 'MITO', 'A78' ],
        'MITO A80'                                  => [ 'MITO', 'A80' ],
        'MITO A82'                                  => [ 'MITO', 'A82' ],
        'MITO A95'                                  => [ 'MITO', 'A95' ],
        'MITO A99'                                  => [ 'MITO', 'A99' ],
        'MITO A100'                                 => [ 'MITO', 'A100' ],
        'MITO A120'                                 => [ 'MITO', 'A120' ],
        'MITO A180'                                 => [ 'MITO', 'A180' ],
        'MITO A200'                                 => [ 'MITO', 'A200' ],
        'MITO A210'                                 => [ 'MITO', 'A210' ],
        'MITO A220'                                 => [ 'MITO', 'A220' ],
        'MITO A222'                                 => [ 'MITO', 'A222' ],
        'MITO A250'                                 => [ 'MITO', 'A250' ],
        'MITO A260'                                 => [ 'MITO', 'A260' ],
        'MITO A300'                                 => [ 'MITO', 'A300' ],
        'MITO A310'                                 => [ 'MITO', 'A310' ],
        'MITO A313'                                 => [ 'MITO', 'A313' ],
        'MITO A322'                                 => [ 'MITO', 'A322' ],
        'MITO A330'                                 => [ 'MITO', 'A330' ],
        'MITO A350'                                 => [ 'MITO', 'A350' ],
        'MITO A355'                                 => [ 'MITO', 'A355' ],
        'MITO A360'                                 => [ 'MITO', 'A360' ],
        'MITO A363'                                 => [ 'MITO', 'A363' ],
        'MITO A390'                                 => [ 'MITO', 'A390' ],
        'MITO A550'                                 => [ 'MITO', 'A550' ],
        'MITO A660'                                 => [ 'MITO', 'A660' ],
        'MITO A700'                                 => [ 'MITO', 'A700' ],
        'MITO A750'                                 => [ 'MITO', 'A750' ],
        'MITO A780'                                 => [ 'MITO', 'A780' ],
        'MITOA800'                                  => [ 'MITO', 'A800' ],
        'MITO A810'                                 => [ 'MITO', 'A810' ],
        'MITO A850'                                 => [ 'MITO', 'A850' ],
        'MITO T10'                                  => [ 'MITO', 'T10', DeviceType::TABLET ],
        'MITO T35'                                  => [ 'MITO', 'T35', DeviceType::TABLET ],
        'MITO T55'                                  => [ 'MITO', 'T55', DeviceType::TABLET ],
        'MITO T66'                                  => [ 'MITO', 'T66', DeviceType::TABLET ],
        'MITO T77'                                  => [ 'MITO', 'T77', DeviceType::TABLET ],
        'MITO T80'                                  => [ 'MITO', 'T80', DeviceType::TABLET ],
        'MITO T81'                                  => [ 'MITO', 'T81', DeviceType::TABLET ],
        'MITO T89'                                  => [ 'MITO', 'T89', DeviceType::TABLET ],
        'MITO T100'                                 => [ 'MITO', 'T100', DeviceType::TABLET ],
        'MITO t300'                                 => [ 'MITO', 'T300', DeviceType::TABLET ],
        'MITO T330'                                 => [ 'MITO', 'T330', DeviceType::TABLET ],
        'MITO t510'                                 => [ 'MITO', 'T510', DeviceType::TABLET ],
        'MITO t550'                                 => [ 'MITO', 'T550', DeviceType::TABLET ],
        'MITO T660'                                 => [ 'MITO', 'T660', DeviceType::TABLET ],
        'MITO T777'                                 => [ 'MITO', 'T777', DeviceType::TABLET ],
        'MITO T888'                                 => [ 'MITO', 'T888', DeviceType::TABLET ],
        'MITO T979'                                 => [ 'MITO', 'T979', DeviceType::TABLET ],
    ],

    'MIZ Z2'                                    => [ 'Miz', 'Z2' ],

    'iQ(Talk|Tab)!!' => [
        'iQTalk Crystal'                            => [ 'MLS', 'iQTalk Crystal' ],
        'iQTalk Crystal Max'                        => [ 'MLS', 'iQTalk Crystal Max' ],
        'iQTalk King'                               => [ 'MLS', 'iQTalk King' ],
        'iQTab'                                     => [ 'MLS', 'iQTab', DeviceType::TABLET ],
        'iQTab 3G'                                  => [ 'MLS', 'iQTab 3G', DeviceType::TABLET ],
        'iQTab Astro 3G'                            => [ 'MLS', 'iQTab Astro 3G', DeviceType::TABLET ],
    ],

    'Nova!!' => [
        'Nova A'                                    => [ 'Mobell', 'Nova A' ],
        'Nova E'                                    => [ 'Mobell', 'Nova E' ],
        'Nova F'                                    => [ 'Mobell', 'Nova F' ],
    ],

    'Mobiistar!!' => [
        'mobiistar PRIME 558'                       => [ 'Mobiistar', 'Prime 558' ],
        'Mobiistar S01'                             => [ 'Mobiistar', 'Touch S01' ],
        'Mobiistar Touch S01'                       => [ 'Mobiistar', 'Touch S01' ],
        'Mobiistar Touch S02i'                      => [ 'Mobiistar', 'Touch S02i' ],
        'Mobiistar Touch S03'                       => [ 'Mobiistar', 'Touch S03' ],
        'Mobiistar Touch S05'                       => [ 'Mobiistar', 'Touch S05' ],
        'Mobiistar Touch S06'                       => [ 'Mobiistar', 'Touch S06' ],
        'Mobiistar Touch S07'                       => [ 'Mobiistar', 'Touch S07' ],
        'Mobiistar Touch S08'                       => [ 'Mobiistar', 'Touch S08' ],
        'Mobiistar Touch S30'                       => [ 'Mobiistar', 'Touch S30' ],
        'mobiistar touch S31'                       => [ 'Mobiistar', 'Touch S31' ],
        'mobiistar touch BEAN 402'                  => [ 'Mobiistar', 'Touch Bean 402' ],
        'mobiistar touch BEAN 402c'                 => [ 'Mobiistar', 'Touch Bean 402C' ],
        'mobiistar touch Bean 402s'                 => [ 'Mobiistar', 'Touch Bean 402S' ],
        'mobiistar touch BEAN 402m'                 => [ 'Mobiistar', 'Touch Bean 402M' ],
        'Mobiistar Touch Bean 452'                  => [ 'Mobiistar', 'Touch Bean 452' ],
        'Mobiistar Touch JellyBean 452'             => [ 'Mobiistar', 'Touch Bean 452' ],
        'Mobiistar Touch Jelly Bean 452'            => [ 'Mobiistar', 'Touch Bean 452' ],
        'mobiistar touch BEAN 452T'                 => [ 'Mobiistar', 'Touch Bean 452T' ],
        'Mobiistar Bean 452T'                       => [ 'Mobiistar', 'Touch Bean 452T' ],
        'mobiistar touch BEAN 454'                  => [ 'Mobiistar', 'Touch Bean 454' ],
        'Mobiistar Touch Kem 350'                   => [ 'Mobiistar', 'Touch Kem 350' ],
        'Mobiistar Touch Kem 351'                   => [ 'Mobiistar', 'Touch Kem 351' ],
        'Mobiistar Touch Kem 402'                   => [ 'Mobiistar', 'Touch Kem 402' ],
        'Mobiistar Touch Kem 432'                   => [ 'Mobiistar', 'Touch Kem 432' ],
        'Mobiistar Touch Kem 452'                   => [ 'Mobiistar', 'Touch Kem 452' ],
        'Mobiistar Touch KEM 452 HDMI'              => [ 'Mobiistar', 'Touch Kem 452' ],
        'Mobiistar touch KEM 462'                   => [ 'Mobiistar', 'Touch Kem 462' ],
        'Mobiistar Touch Lai 502'                   => [ 'Mobiistar', 'Touch Lai 502' ],
        'mobiistar touch LAI 504'                   => [ 'Mobiistar', 'Touch Lai 504' ],
        'mobiistar LAI 504m'                        => [ 'Mobiistar', 'Touch Lai 504M' ],
        'mobiistar touch LAI 504Q'                  => [ 'Mobiistar', 'Touch Lai 504Q' ],
        'mobiistar touch LAI 512'                   => [ 'Mobiistar', 'Touch Lai 512' ],
    ],

    'BEAN 454'                                  => [ 'Mobiistar', 'Touch Bean 454' ],
    'MBS BEAN 454'                              => [ 'Mobiistar', 'Touch Bean 454' ],
    'edenTAB ET-701'                            => [ 'Mobile In Style', 'Eden TAB ET-701', DeviceType::TABLET ],

    'Cynus!!' => [
        'Cynus E1'                                  => [ 'Mobistel', 'Cynus E1' ],
        'Cynus F3'                                  => [ 'Mobistel', 'Cynus F3' ],
        'Cynus F4'                                  => [ 'Mobistel', 'Cynus F4' ],
        'Cynus F5'                                  => [ 'Mobistel', 'Cynus F5' ],
        'Cynus F6'                                  => [ 'Mobistel', 'Cynus F6' ],
        'Cynus F8'                                  => [ 'Mobistel', 'Cynus F8' ],
        'Cynus T1'                                  => [ 'Mobistel', 'Cynus T1' ],
        'Cynus T2'                                  => [ 'Mobistel', 'Cynus T2' ],
        'Cynus T5'                                  => [ 'Mobistel', 'Cynus T5' ],
        'Cynus T6'                                  => [ 'Mobistel', 'Cynus T6' ],
        'Cynus T7'                                  => [ 'Mobistel', 'Cynus T7' ],
        'Cynus T8'                                  => [ 'Mobistel', 'Cynus T8' ],
    ],

    'MOCHE SMART A16'                           => [ 'Moche', 'Smart A16' ],

    '(MODECOM )?FreeTAB!!' => [
        'FreeTAB 7.5 IPS X4 3G+'                    => [ 'Modecom', 'FreeTAB 7.5 IPS X4', DeviceType::TABLET ],
        'FreeTAB 10.1 Silver'                       => [ 'Modecom', 'FreeTAB 10.1 Silver', DeviceType::TABLET ],
        'FreeTAB 1001'                              => [ 'Modecom', 'FreeTAB 1001', DeviceType::TABLET ],
        'MODECOM FreeTab 1002 IPS X2'               => [ 'Modecom', 'FreeTAB 1002 IPS X2', DeviceType::TABLET ],
        'FreeTAB 1003'                              => [ 'Modecom', 'FreeTAB 1003', DeviceType::TABLET ],
        'FreeTAB1003'                               => [ 'Modecom', 'FreeTAB 1003', DeviceType::TABLET ],
        'FreeTAB 1014 IPS X4+'                      => [ 'Modecom', 'FreeTAB 1014 IPS X4', DeviceType::TABLET ],
        'FreeTAB 1014 IPS X4 3G+'                   => [ 'Modecom', 'FreeTAB 1014 IPS X4', DeviceType::TABLET ],
        'MODECOM FreeTAB 2096+ X2 4GB'              => [ 'Modecom', 'FreeTAB 2096 X2', DeviceType::TABLET ],
        'FreeTAB 7001 HD IC'                        => [ 'Modecom', 'FreeTAB 7001 HD IC', DeviceType::TABLET ],
        'FreeTAB 7003 HD+ X2 3G+'                   => [ 'Modecom', 'FreeTAB 7003 HD+ X2', DeviceType::TABLET ],
        'FreeTAB 7800 IPS IC'                       => [ 'Modecom', 'FreeTAB 7800 IPS IC', DeviceType::TABLET ],
        'FreeTAB 8001 IPS X2 3G+'                   => [ 'Modecom', 'FreeTAB 8001 IPS X2', DeviceType::TABLET ],
        'MODECOM FreeTAB 8001 IPS X23G'             => [ 'Modecom', 'FreeTAB 8001 IPS X2', DeviceType::TABLET ],
        'FreeTAB 8014 IPS X4'                       => [ 'Modecom', 'FreeTAB 8014 IPS X4', DeviceType::TABLET ],
        'FreeTAB 9000 IPS IC'                       => [ 'Modecom', 'FreeTAB 9000 IPS IC', DeviceType::TABLET ],
        'FreeTAB 9000 IPS ICG'                      => [ 'Modecom', 'FreeTAB 9000 IPS ICG', DeviceType::TABLET ],
        'FreeTAB 9000 IPS ICG 3G'                   => [ 'Modecom', 'FreeTAB 9000 IPS ICG', DeviceType::TABLET ],
        'FreeTAB 9701'                              => [ 'Modecom', 'FreeTAB 9701', DeviceType::TABLET ],
        'FreeTAB 9701 HD X1'                        => [ 'Modecom', 'FreeTAB 9701 HD X1', DeviceType::TABLET ],
        'FreeTAB 9701 IPS'                          => [ 'Modecom', 'FreeTAB 9701 IPS', DeviceType::TABLET ],
        'FreeTAB 9702 HD X2'                        => [ 'Modecom', 'FreeTAB 9702 HD X2', DeviceType::TABLET ],
        'FreeTAB 9702 HD X4'                        => [ 'Modecom', 'FreeTAB 9702 HD X4', DeviceType::TABLET ],
        'MODECOM FreeTAB 9702 IPS X2'               => [ 'Modecom', 'FreeTAB 9702 IPS X2', DeviceType::TABLET ],
        'FreeTAB 9704 IPS2 X4'                      => [ 'Modecom', 'FreeTAB 9704 IPS2 X4', DeviceType::TABLET ],
    ],

    'MOGU!!' => [
        'MOGU-M0'                                   => [ 'Mogu', 'M0' ],
        'MOGU M2'                                   => [ 'Mogu', 'M2' ],
        'MOGU M2 ROM'                               => [ 'Mogu', 'M2' ],
        'MOGU-M2'                                   => [ 'Mogu', 'M2' ],
    ],

    'moii!!' => [
        'moii-E502'                                 => [ 'moii', 'E502' ],
        'moii E505'                                 => [ 'moii', 'E505' ],
        'moii E598'                                 => [ 'moii', 'E598' ],
        'Moii E801'                                 => [ 'moii', 'E801' ],
        'moii E893'                                 => [ 'moii', 'E893' ],
        'Moii E990'                                 => [ 'moii', 'E990' ],
        'moii E996'                                 => [ 'moii', 'E996' ],
    ],

    'AT735'                                     => [ 'Moinstone', 'AT735', DeviceType::TABLET ],
    'MORAL N01'                                 => [ 'Moral', 'N01' ],
    'i1'                                        => [ 'Motorola', 'i1' ],
    'A853'                                      => [ 'Motorola', 'Milestone' ],
    'A953'                                      => [ 'Motorola', 'Milestone 2' ],
    'A955'                                      => [ 'Motorola', 'Droid 2' ],
    'A1680'                                     => [ 'Motorola', 'MOTO A1680' ],
    'F100'                                      => [ 'Motorola', 'MOTOACTV', DeviceType::WATCH ],

    'MB[0-9]{3,3}!!' => [
        'MB200'                                     => [ 'Motorola', 'CLIQ' ],
        'MB300'                                     => [ 'Motorola', 'BACKFLIP' ],
        'MB501'                                     => [ 'Motorola', 'CLIQ XT' ],
        'MB502'                                     => [ 'Motorola', 'CHARM' ],
        'MB508'                                     => [ 'Motorola', 'FLIPSIDE' ],
        'MB511'                                     => [ 'Motorola', 'FLIPOUT' ],
        'MB520'                                     => [ 'Motorola', 'BRAVO' ],
        'MB525!'                                    => [ 'Motorola', 'DEFY' ],
        'MB526!'                                    => [ 'Motorola', 'DEFY+' ],
        'MB610'                                     => [ 'Motorola', 'CLIQ 2' ],
        'MB611'                                     => [ 'Motorola', 'CLIQ 2' ],
        'MB612'                                     => [ 'Motorola', 'XPRT' ],
        'MB626'                                     => [ 'Motorola', 'MB632' ],
        'MB632'                                     => [ 'Motorola', 'PRO+' ],
        'MB810'                                     => [ 'Motorola', 'Droid X' ],
        'MB853'                                     => [ 'Motorola', 'Electrify' ],
        'MB855'                                     => [ 'Motorola', 'PHOTON 4G' ],
        'MB8(60|61)!'                               => [ 'Motorola', 'ATRIX' ],
        'MB865'                                     => [ 'Motorola', 'ATRIX 2' ],
        'MB870'                                     => [ 'Motorola', 'Droid X2' ],
        'MB886'                                     => [ 'Motorola', 'DINARA' ],
    ],

    'ME[0-9]{3,3}!!' => [
        'ME501'                                     => [ 'Motorola', 'CLIQ XT' ],
        'ME502'                                     => [ 'Motorola', 'CHARM' ],
        'ME511'                                     => [ 'Motorola', 'FLIPOUT' ],
        'ME525!'                                    => [ 'Motorola', 'MOTO ME525' ],
        'ME526!'                                    => [ 'Motorola', 'DEFY+' ],
        'ME600'                                     => [ 'Motorola', 'BACKFLIP' ],
        'ME611'                                     => [ 'Motorola', 'CLIQ 2' ],
        'ME632'                                     => [ 'Motorola', 'PRO+' ],
        'ME722'                                     => [ 'Motorola', 'Milestone 2' ],
        'ME811'                                     => [ 'Motorola', 'Droid X' ],
        'ME860'                                     => [ 'Motorola', 'ATRIX' ],
        'ME863'                                     => [ 'Motorola', 'Milestone 3' ],
        'ME865'                                     => [ 'Motorola', 'ATRIX 2' ],
    ],

    'MT[0-9]{3,3}!!' => [
        'MT620!'                                    => [ 'Motorola', 'MOTO MT620' ],
        'MT680'                                     => [ 'Motorola', 'MOTOLUXE MT680' ],
        'MT716'                                     => [ 'Motorola', 'MOTO MT716' ],
        'MT788'                                     => [ 'Motorola', 'RAZR i' ],
        'MT810'                                     => [ 'Motorola', 'MOTO MT810' ],
        'MT870'                                     => [ 'Motorola', 'MOTO MT870' ],
        'MT887'                                     => [ 'Motorola', 'RAZR V' ],
        'MT917'                                     => [ 'Motorola', 'MT917' ],
    ],

    'MZ[0-9]{3,3}!!' => [
        'MZ505'                                     => [ 'Motorola', 'XOOM Family Edition', DeviceType::TABLET ],
        'MZ600'                                     => [ 'Motorola', 'XOOM 4G LTE', DeviceType::TABLET ],
        'MZ601'                                     => [ 'Motorola', 'XOOM 3G', DeviceType::TABLET ],
        'MZ602'                                     => [ 'Motorola', 'XOOM 4G LTE', DeviceType::TABLET ],
        'MZ603'                                     => [ 'Motorola', 'XOOM 3G', DeviceType::TABLET ],
        'MZ604'                                     => [ 'Motorola', 'XOOM WiFi', DeviceType::TABLET ],
        'MZ605'                                     => [ 'Motorola', 'XOOM 3G', DeviceType::TABLET ],
        'MZ606'                                     => [ 'Motorola', 'XOOM WiFi', DeviceType::TABLET ],
        'MZ607'                                     => [ 'Motorola', 'XOOM 2 WiFi Media Edition', DeviceType::TABLET ],
        'MZ608'                                     => [ 'Motorola', 'XOOM 2 3G Media Edition', DeviceType::TABLET ],
        'MZ609!'                                    => [ 'Motorola', 'Droid XYBOARD 8.2', DeviceType::TABLET ],
        'MZ615'                                     => [ 'Motorola', 'XOOM 2 WiFi', DeviceType::TABLET ],
        'MZ616'                                     => [ 'Motorola', 'XOOM 2 3G', DeviceType::TABLET ],
        'MZ617!'                                    => [ 'Motorola', 'Droid XYBOARD 10.1', DeviceType::TABLET ],
    ],

    'WX[0-9]{3,3}!!' => [
        'WX435'                                     => [ 'Motorola', 'TRIUMPH WX435' ],
        'WX442'                                     => [ 'Motorola', 'CITRUS WX442' ],
        'WX445'                                     => [ 'Motorola', 'CITRUS WX445' ],
    ],

    'XT[0-9]{3,4}!!' => [
        'XT300'                                     => [ 'Motorola', 'SPICE' ],
        'XT301'                                     => [ 'Motorola', 'MOTO XT301' ],
        'XT303'                                     => [ 'Motorola', 'MOTOSMART XT303' ],
        'XT305'                                     => [ 'Motorola', 'MOTOSMART XT305' ],
        'XT311'                                     => [ 'Motorola', 'FIRE' ],
        'XT316'                                     => [ 'Motorola', 'MOTO XT316' ],
        'XT317'                                     => [ 'Motorola', 'SPICE Key' ],
        'XT319'                                     => [ 'Motorola', 'MOTO XT319' ],
        'XT3(20|21)!'                               => [ 'Motorola', 'DEFY Mini' ],
        'XT389'                                     => [ 'Motorola', 'MOTOSMART XT389' ],
        'XT390'                                     => [ 'Motorola', 'MOTOSMART XT390' ],
        'XT500'                                     => [ 'Motorola', 'MOTO XT500' ],
        'xt-500'                                    => [ 'Motorola', 'MOTO XT500' ],
        'XT502'                                     => [ 'Motorola', 'QUENCH XT5' ],
        'XT5(30|31)!'                               => [ 'Motorola', 'FIRE XT' ],
        'XT532'                                     => [ 'Motorola', 'MOTO XT532' ],
        'XT535'                                     => [ 'Motorola', 'DEFY' ],
        'XT536'                                     => [ 'Motorola', 'DEFY Diana' ],
        'XT5(50|53)!'                               => [ 'Motorola', 'MOTOSMART MIX' ],
        'XT5(55|56|57)!'                            => [ 'Motorola', 'DEFY XT' ],
        'XT560'                                     => [ 'Motorola', 'DEFY Pro' ],
        'XT603'                                     => [ 'Motorola', 'ADMIRAL' ],
        'XT605'                                     => [ 'Motorola', 'Master XT605' ],
        'XT610'                                     => [ 'Motorola', 'Droid Pro' ],
        'Pro XT610'                                 => [ 'Motorola', 'Droid Pro' ],
        'XT611'                                     => [ 'Motorola', 'MOTOSMART Flip' ],
        'XT615'                                     => [ 'Motorola', 'MOTO XT615' ],
        'XT621'                                     => [ 'Motorola', 'Primus XT621' ],
        'XT623'                                     => [ 'Motorola', 'Kairos XT623' ],
        'XT626'                                     => [ 'Motorola', 'MOTO XT626' ],
        'XT627'                                     => [ 'Motorola', 'Kairos XT627' ],
        'XT681'                                     => [ 'Motorola', 'MOTO XT681' ],
        'XT682'                                     => [ 'Motorola', 'ATRIX TV' ],
        'XT685'                                     => [ 'Motorola', 'MOTO XT685' ],
        'XT687'                                     => [ 'Motorola', 'ATRIX TV' ],
        'XT701'                                     => [ 'Motorola', 'XT701' ],
        'XT702!'                                    => [ 'Motorola', 'MOTO XT702' ],
        'XT711'                                     => [ 'Motorola', 'MOTO XT711' ],
        'XT720'                                     => [ 'Motorola', 'Milestone' ],
        'XT760'                                     => [ 'Motorola', 'MOTO XT760' ],
        'XT788'                                     => [ 'Motorola', 'XT788' ],
        'XT875'                                     => [ 'Motorola', 'Droid Bionic' ],
        'XT800W'                                    => [ 'Motorola', 'MOTO Glam' ],
        'XT800!'                                    => [ 'Motorola', 'MOTO XT800' ],
        'XT806'                                     => [ 'Motorola', 'MOTO XT806' ],
        'XT810'                                     => [ 'Motorola', 'MOTO XT810' ],
        'XT830C'                                    => [ 'Motorola', 'Moto E' ],
        'XT8(60|83)!'                               => [ 'Motorola', 'Milestone 3' ],
        'XT862'                                     => [ 'Motorola', 'Droid 3' ],
        'XT865'                                     => [ 'Motorola', 'Droid Bionic' ],
        'XT881'                                     => [ 'Motorola', 'Electrify 2' ],
        'XT882'                                     => [ 'Motorola', 'MOTO XT882' ],
        'XT8(85|86|89)!'                            => [ 'Motorola', 'RAZR V' ],
        'XT890'                                     => [ 'Motorola', 'RAZR i' ],
        'XT894!'                                    => [ 'Motorola', 'Droid 4' ],
        'XT897!'                                    => [ 'Motorola', 'PHOTON Q' ],
        'XT901'                                     => [ 'Motorola', 'Electrify M' ],
        'XT905'                                     => [ 'Motorola', 'RAZR M' ],
        'XT907!'                                    => [ 'Motorola', 'Droid RAZR M' ],
        'XT908'                                     => [ 'Motorola', 'RAZR MAXX' ],
        'XT910!'                                    => [ 'Motorola', 'RAZR' ],
        'XT912!'                                    => [ 'Motorola', 'Droid RAZR' ],
        'XT9(14|15|16|18)!'                         => [ 'Motorola', 'Droid RAZR D1' ],
        'XT9(19|20)!'                               => [ 'Motorola', 'Droid RAZR D3' ],
        'XT9(23|25|26)!'                            => [ 'Motorola', 'Droid RAZR HD' ],
        'XT928'                                     => [ 'Motorola', 'XT928' ],
        'XT939G'                                    => [ 'Motorola', 'Moto G' ],
        'XT10(19|21|22|23|25)!'                     => [ 'Motorola', 'Moto E' ],
        'XT1030!'                                   => [ 'Motorola', 'Droid Mini' ],
        'XT10(08|28|31|32|33|34|35|39|40|42|45)!'   => [ 'Motorola', 'Moto G' ],
        'XT10(02|03)!'                              => [ 'Motorola', 'Moto G Ferrari' ],
        'XT10(49|50|52|53|55|56|58|60)!'            => [ 'Motorola', 'Moto X' ],
        'XT10(63|64|68|69|72|77|78|79)!'            => [ 'Motorola', 'Moto G (2014)' ],
        'XT1080!'                                   => [ 'Motorola', 'Droid Ultra' ],
        'XT10(85|92|93|94|95|96|97|98)!'            => [ 'Motorola', 'Moto X (2014)' ],
        'XT11(00|03)!'                              => [ 'Motorola', 'Nexus 6' ],
        'XT1115!'                                   => [ 'Motorola', 'Moto X Pro' ],
        'XT1225'                                    => [ 'Motorola', 'Moto Maxx' ],
        'XT12(50|54)!'                              => [ 'Motorola', 'Droid Turbo' ],
        'XT15(14|21|23|24|26|27|28)!'               => [ 'Motorola', 'Moto E (2015)' ],
        'XT15(40|41|42|43|44|48|50)!'               => [ 'Motorola', 'Moto G (2015)' ],
        'XT1557'                                    => [ 'Motorola', 'Moto G Turbo' ],
        'XT15(62|63|64)!'                           => [ 'Motorola', 'Moto X Play' ],
        'XT1565'                                    => [ 'Motorola', 'Droid MAXX 2' ],
        'XT15(70|72|73)!'                           => [ 'Motorola', 'Moto X Style' ],
        'XT1575'                                    => [ 'Motorola', 'Moto X Pure Edition' ],
        'XT1578'                                    => [ 'Motorola', '"Clark"' ],
        'XT15(80|81)!'                              => [ 'Motorola', 'Moto X Force' ],
        'XT1585'                                    => [ 'Motorola', 'Droid Turbo 2' ],
        'XT16(06|09)!'                              => [ 'Motorola', 'Moto G4 Play' ],
        'XT1625'                                    => [ 'Motorola', 'Moto G4' ],
        'XT16(35)!'                                 => [ 'Motorola', 'Moto Z Play' ],
        'XT1644'                                    => [ 'Motorola', 'Moto G4 Plus' ],
        'XT16(50)!'                                 => [ 'Motorola', 'Moto X4' ],
        'XT16(62|63)!'                              => [ 'Motorola', 'Moto M' ],
        'XT16(80|81|83|84|85|86|87)!'               => [ 'Motorola', 'Moto G5 Plus' ],
        'XT17(00|06)!'                              => [ 'Motorola', 'Moto E (2016)' ],
        'XT17(26)!'                                 => [ 'Motorola', 'Moto C Plus' ],
        'XT17(10)!'                                 => [ 'Motorola', 'Moto Z (2017)' ],
        'XT17(55|56|57|58)!'                        => [ 'Motorola', 'Moto E4' ],
        'XT17(89)!'                                 => [ 'Motorola', 'Moto Z2 Force' ],
        'XT19(02)!'                                 => [ 'Lenovo', 'K8 Note' ],
    ],

    'Atrix 2'                                   => [ 'Motorola', 'ATRIX 2' ],
    'Atrix 2 WeifanZ'                           => [ 'Motorola', 'ATRIX 2' ],
    'Atrix 4G'                                  => [ 'Motorola', 'ATRIX 4G' ],
    'Atrix 4G ME860'                            => [ 'Motorola', 'ATRIX 4G' ],
    'Atrix 4G MB860'                            => [ 'Motorola', 'ATRIX 4G' ],
    'Atrix HD'                                  => [ 'Motorola', 'ATRIX HD' ],
    'AtrixHD'                                   => [ 'Motorola', 'ATRIX HD' ],
    'Backflip'                                  => [ 'Motorola', 'BACKFLIP' ],
    'CLIQ'                                      => [ 'Motorola', 'CLIQ' ],
    'CLIQ XT'                                   => [ 'Motorola', 'CLIQ XT' ],
    'CLIQ2'                                     => [ 'Motorola', 'CLIQ 2' ],
    'Corvair'                                   => [ 'Motorola', 'Corvair', DeviceType::TABLET ],
    'DEFY'                                      => [ 'Motorola', 'DEFY' ],
    'Defy(\\+| Plus)!'                          => [ 'Motorola', 'DEFY+' ],
    'DEDY+'                                     => [ 'Motorola', 'DEFY+' ],
    'Dext'                                      => [ 'Motorola', 'Dext' ],
    'Droid'                                     => [ 'Motorola', 'Droid' ],
    'Moto Droid'                                => [ 'Motorola', 'Droid' ],
    'Sholes'                                    => [ 'Motorola', 'Droid' ],
    'DROID'                                     => [ 'Motorola', 'Droid' ],
    'DROID ?2!'                                 => [ 'Motorola', 'Droid 2' ],
    'DROID ?3!'                                 => [ 'Motorola', 'Droid 3' ],
    'DROID ?4!'                                 => [ 'Motorola', 'Droid 4' ],
    'DroidPro'                                  => [ 'Motorola', 'Droid Pro' ],
    'DROID Pro'                                 => [ 'Motorola', 'Droid Pro' ],
    'Motorola Pro XT610'                        => [ 'Motorola', 'Droid Pro' ],
    'DROID HD'                                  => [ 'Motorola', 'Droid HD' ],
    'DROID BIONIC!'                             => [ 'Motorola', 'Droid Bionic' ],
    'DROID RAZR HD!'                            => [ 'Motorola', 'Droid RAZR HD' ],
    'DROID ?RAZR!'                              => [ 'Motorola', 'Droid RAZR' ],
    'DROID SPYDER'                              => [ 'Motorola', 'Droid RAZR' ],
    'DROID ?X2!'                                => [ 'Motorola', 'Droid X2' ],
    'DROID ?X!'                                 => [ 'Motorola', 'Droid X' ],
    'Devour'                                    => [ 'Motorola', 'Droid Devour' ],
    'calgary'                                   => [ 'Motorola', 'Droid Devour' ],
    'Electrify'                                 => [ 'Motorola', 'Electrify' ],
    'Milestone XT711'                           => [ 'Motorola', 'Milestone' ],
    'Milestone XT720'                           => [ 'Motorola', 'Milestone' ],
    'Milestone'                                 => [ 'Motorola', 'Milestone' ],
    'A853 Milestone'                            => [ 'Motorola', 'Milestone' ],
    'Milestone X'                               => [ 'Motorola', 'Milestone X' ],
    'Milestone X2'                              => [ 'Motorola', 'Milestone X2' ],
    'Milestone MAXX'                            => [ 'Motorola', 'Milestone MAXX' ],
    'Motorola Milestone MAXX'                   => [ 'Motorola', 'Milestone MAXX' ],
    'MILESTONE3'                                => [ 'Motorola', 'Milestone 3' ],
    'Backflip Me600'                            => [ 'Motorola', 'BACKFLIP' ],
    'Motorola Backflip Me600'                   => [ 'Motorola', 'BACKFLIP' ],
    'Moto ME860'                                => [ 'Motorola', 'ATRIX' ],
    '(Moto)?E2$!'                               => [ 'Motorola', 'Moto E (2015)' ],
    '(Moto)?E2\(4G-LTE\)$!'                     => [ 'Motorola', 'Moto E (2015)' ],
    'surnia'                                    => [ 'Motorola', 'Moto E (2015)' ],
    'Moto E (4) Plus'                           => [ 'Motorola', 'Moto E4 Plus' ],
    '(Moto)?G3$!'                               => [ 'Motorola', 'Moto G (2015)' ],
    '(Moto)?G3-TE$!'                            => [ 'Motorola', 'Moto G (2015)' ],
    'MOTOROLA MOTOG'                            => [ 'Motorola', 'Moto G' ],
    'Moto G Play'                               => [ 'Motorola', 'Moto G Play' ],
    'Moto G4'                                   => [ 'Motorola', 'Moto G4' ],
    'Moto G (4)'                                => [ 'Motorola', 'Moto G4' ],
    'Moto G4 Plus'                              => [ 'Motorola', 'Moto G4 Plus' ],
    'Moto G (5)'                                => [ 'Motorola', 'Moto G5' ],
    'Moto G (5) Plus'                           => [ 'Motorola', 'Moto G5 Plus' ],
    'roiX'                                      => [ 'Motorola', 'Droid X' ],
    'Moto Backflip'                             => [ 'Motorola', 'BACKFLIP' ],
    'RAZR'                                      => [ 'Motorola', 'RAZR' ],
    'RAZR HD'                                   => [ 'Motorola', 'RAZR HD' ],
    'RAZR M'                                    => [ 'Motorola', 'RAZR M' ],
    'RAZR MAXX'                                 => [ 'Motorola', 'RAZR MAXX' ],
    'Triumph'                                   => [ 'Motorola', 'TRIUMPH' ],
    'Opus One'                                  => [ 'Motorola', 'i1' ],
    'Photon'                                    => [ 'Motorola', 'PHOTON' ],
    'Photon 4G'                                 => [ 'Motorola', 'PHOTON 4G' ],
    'Photon Q'                                  => [ 'Motorola', 'PHOTON Q' ],
    'Photon Q LTE'                              => [ 'Motorola', 'PHOTON Q' ],
    'XOOM'                                      => [ 'Motorola', 'XOOM', DeviceType::TABLET ],
    'MOTOROLA XOOM MZ606'                       => [ 'Motorola', 'XOOM', DeviceType::TABLET ],
    'XOOM 2!'                                   => [ 'Motorola', 'XOOM 2', DeviceType::TABLET ],
    'XOOM MZ606'                                => [ 'Motorola', 'XOOM WiFi', DeviceType::TABLET ],
    'Xoom Wifi'                                 => [ 'Motorola', 'XOOM WiFi', DeviceType::TABLET ],
    'Xoom LTE'                                  => [ 'Motorola', 'XOOM 4G LTE', DeviceType::TABLET ],
    'Xoom 3G'                                   => [ 'Motorola', 'XOOM 3G', DeviceType::TABLET ],
    '201M'                                      => [ 'Motorola', 'RAZR M 201M', 'carrier' => 'Softbank' ],
    'ISW11M'                                    => [ 'Motorola', 'PHOTON ISW11M', 'carrier' => 'au' ],
    'IS12M'                                     => [ 'Motorola', 'RAZR IS12M', 'carrier' => 'au' ],
    'MOTOROLA RAZR'                             => [ 'Motorola', 'RAZR' ],
    'MOTWX435KT'                                => [ 'Motorola', 'TRIUMPH' ],
    'X3-Ice MIUI XT720 Memorila Classics'       => [ 'Motorola', 'Milestone' ],
    'ET1'                                       => [ 'Motorola', 'ET1 Enterprise Tablet', DeviceType::TABLET ],     /* Products of Motorola Solutions */
    'MC32N0'                                    => [ 'Motorola', 'MC32 Mobile Computer', DeviceType::POS ],
    'MC40N0'                                    => [ 'Motorola', 'MC40 Mobile Computer', DeviceType::POS ],
    'MC67NA'                                    => [ 'Motorola', 'MC67 Mobile Computer', DeviceType::POS ],
    'TC55'                                      => [ 'Motorola', 'TC55 Touch Computer' ],
    'TC55CH'                                    => [ 'Motorola', 'TC55 Touch Computer' ],
    'TC70'                                      => [ 'Motorola', 'TC70 Touch Computer' ],
    'TC75'                                      => [ 'Motorola', 'TC75 Touch Computer' ],
    'PH350'                                     => [ 'Mpman', 'PH350' ],
    'PH520'                                     => [ 'Mpman', 'PH520' ],
    'MID7C'                                     => [ 'Mpman', 'MID7C', DeviceType::TABLET ],
    'MID43C'                                    => [ 'Mpman', 'MID43C', DeviceType::TABLET ],
    'MID74C'                                    => [ 'Mpman', 'MID74C', DeviceType::TABLET ],
    'MID77C'                                    => [ 'Mpman', 'MID77C', DeviceType::TABLET ],
    'MID82C'                                    => [ 'Mpman', 'MID82C', DeviceType::TABLET ],
    'MID84C'                                    => [ 'Mpman', 'MID84C', DeviceType::TABLET ],
    'MID102C'                                   => [ 'Mpman', 'MID102C', DeviceType::TABLET ],
    'MID103C'                                   => [ 'Mpman', 'MID103C', DeviceType::TABLET ],
    'MID104C'                                   => [ 'Mpman', 'MID104C', DeviceType::TABLET ],
    'MID114C'                                   => [ 'Mpman', 'MID114C', DeviceType::TABLET ],
    'MP717'                                     => [ 'Mpman', 'MP717', DeviceType::TABLET ],
    'MP843'                                     => [ 'Mpman', 'MP843', DeviceType::TABLET ],
    'MP888'                                     => [ 'Mpman', 'MP888', DeviceType::TABLET ],
    'MP959'                                     => [ 'Mpman', 'MP959', DeviceType::TABLET ],
    'MP969'                                     => [ 'Mpman', 'MP969', DeviceType::TABLET ],
    'MP1010'                                    => [ 'Mpman', 'MP1010', DeviceType::TABLET ],
    'MP7007'                                    => [ 'Mpman', 'MP7007', DeviceType::TABLET ],
    'MPDC100 BT'                                => [ 'Mpman', 'MPDC100 BT', DeviceType::TABLET ],
    'MPDC110 BT IPS'                            => [ 'Mpman', 'MPDC110 BT', DeviceType::TABLET ],
    'MPDC112 BT IPS'                            => [ 'Mpman', 'MPDC112 BT', DeviceType::TABLET ],
    'MPDC8 BT'                                  => [ 'Mpman', 'MPDC8 BT', DeviceType::TABLET ],
    'MPDC88 BT IPS'                             => [ 'Mpman', 'MPDC88 BT', DeviceType::TABLET ],
    'MPDC706'                                   => [ 'Mpman', 'MPDC706', DeviceType::TABLET ],
    'MPDC903'                                   => [ 'Mpman', 'MPDC903', DeviceType::TABLET ],
    'MPQC704 HD'                                => [ 'Mpman', 'MPQC704 HD', DeviceType::TABLET ],
    'MPQC784 IPS'                               => [ 'Mpman', 'MPQC784', DeviceType::TABLET ],
    'MPQC804HD'                                 => [ 'Mpman', 'MPQC804 HD', DeviceType::TABLET ],
    'MPQC1010'                                  => [ 'Mpman', 'MPQC1010', DeviceType::TABLET ],
    'Primo76'                                   => [ 'MSI', 'Primo 76', DeviceType::TABLET ],
    'Primo 91'                                  => [ 'MSI', 'Primo 91', DeviceType::TABLET ],
    'Enjoy 71'                                  => [ 'MSI', 'Enjoy 71', DeviceType::TABLET ],
    'Enjoy 7 Plus'                              => [ 'MSI', 'WindPad Enjoy 7 Plus', DeviceType::TABLET ],
    'MTS-SP100'                                 => [ 'MTS', 'Lifewire SP 100' ],
    'MTS-SP101'                                 => [ 'MTS', 'Mtag 3.1 SP 101' ],
    'Multilaser Diamond'                        => [ 'Multilaser', 'Diamond', DeviceType::TABLET ],
    'Multilaser Orion'                          => [ 'Multilaser', 'Orion' ],
    'Multilaser Oxy'                            => [ 'Multilaser', 'Oxy', DeviceType::TABLET ],
    'Multilaser Titanium'                       => [ 'Multilaser', 'Titanium' ],
    'NB036'                                     => [ 'Multilaser', 'Vibe NB036', DeviceType::TABLET ],

    'M4(TEL)? SS[0-9]{3,4}!!' => [
        'M4TEL SS550'                               => [ 'M4Tel', 'Genius' ],
        'M4TEL SS880'                               => [ 'M4Tel', 'Mirage' ],
        'M4TEL SS990'                               => [ 'M4Tel', 'E-Motion' ],
        'M4 SS1050'                                 => [ 'M4Tel', 'SS1050' ],
        'M4 SS1060'                                 => [ 'M4Tel', 'M4Live' ],
        'M4 SS1070'                                 => [ 'M4Tel', 'Sense' ],
        'M4 SS1080'                                 => [ 'M4Tel', 'Max One' ],
        'M4 SS1090'                                 => [ 'M4Tel', 'Max Ultra' ],
        'M4 SS4040'                                 => [ 'M4Tel', 'SS4040' ],
        'M4 SS4041'                                 => [ 'M4Tel', 'SS4041' ],
        'M4 SS4045'                                 => [ 'M4Tel', 'SS4045' ],
    ],

    'MyPhone A818g Duo'                         => [ 'MyPhone', 'A818g Duo' ],
    'MyPhone A818 Slim Duo'                     => [ 'MyPhone', 'A818 Slim Duo' ],
    'MyPhone A848 Duo'                          => [ 'MyPhone', 'A848 Duo' ],
    'MyPhone A848i Duo'                         => [ 'MyPhone', 'A848i Duo' ],
    'MyPhone A848g Duo'                         => [ 'MyPhone', 'A848g Duo' ],
    'A878 Duo'                                  => [ 'MyPhone', 'A878 Duo' ],
    'MyPhone A888'                              => [ 'MyPhone', 'A888 Duo' ],
    'MyPhone A888 Duo'                          => [ 'MyPhone', 'A888 Duo' ],
    'My|Phone A888 Duo'                         => [ 'MyPhone', 'A888 Duo' ],
    'A898 Duo'                                  => [ 'MyPhone', 'A898 Duo' ],
    'MyPhone A919 Duo'                          => [ 'MyPhone', 'A919 Duo' ],
    'MyPhone A919 3D Duo'                       => [ 'MyPhone', 'A919 3D Duo' ],
    'MyPhone A919i'                             => [ 'MyPhone', 'A919i' ],
    'MyPhone A919i Duo'                         => [ 'MyPhone', 'A919i Duo' ],
    'MyPhone Agua Cyclone'                      => [ 'MyPhone', 'Agua Cyclone' ],
    'MyPhone Agua Hail'                         => [ 'MyPhone', 'Agua Hail' ],
    'MyPhone Agua Iceberg'                      => [ 'MyPhone', 'Agua Iceberg' ],
    'MyPhone Agua Iceberg Mini'                 => [ 'MyPhone', 'Agua Iceberg Mini' ],
    'MyPhone Agua Iceberg Slim'                 => [ 'MyPhone', 'Agua Iceberg Slim' ],
    'MyPhone Agua Infinity'                     => [ 'MyPhone', 'Agua Infinity' ],
    'MyPhone Agua Ocean Lite'                   => [ 'MyPhone', 'Agua Ocean Lite' ],
    'MyPhone Agua Ocean Mini'                   => [ 'MyPhone', 'Agua Ocean Mini' ],
    'MyPhone Agua Ocean Pro'                    => [ 'MyPhone', 'Agua Ocean Pro' ],
    'MyPhone Agua Rain 2G'                      => [ 'MyPhone', 'Agua Rain' ],
    'MyPhone Agua Rain 3G'                      => [ 'MyPhone', 'Agua Rain' ],
    'MyPhone Agua Rio'                          => [ 'MyPhone', 'Agua Rio' ],
    'MyPhone Agua Rio Fun'                      => [ 'MyPhone', 'Agua Rio Fun' ],
    'MyPhone Agua Rio Lite'                     => [ 'MyPhone', 'Agua Rio Lite' ],
    'MyPhone Agua Storm'                        => [ 'MyPhone', 'Agua Storm' ],
    'MyPhone Agua Vortex'                       => [ 'MyPhone', 'Agua Vortex' ],
    'myPhone C Smart'                           => [ 'MyPhone', 'C Smart' ],
    'myPhone Cube'                              => [ 'MyPhone', 'Cube' ],
    'myPhone Cube 16GB'                         => [ 'MyPhone', 'Cube' ],
    'myPhone Duosmart'                          => [ 'MyPhone', 'Duosmart' ],
    'myPhone FUN 2'                             => [ 'MyPhone', 'Fun 2' ],
    'myPhone Funky'                             => [ 'MyPhone', 'Funky' ],
    'myPhone Hammer'                            => [ 'MyPhone', 'Hammer' ],
    'myPhone INFINITY 3G'                       => [ 'MyPhone', 'Infinity' ],
    'myPhone NEXT'                              => [ 'MyPhone', 'NEXT' ],
    'myPhone NEXTS'                             => [ 'MyPhone', 'NEXT S' ],
    'myPhone NEXT S'                            => [ 'MyPhone', 'NEXT S' ],
    'myPhone Smart'                             => [ 'MyPhone', 'Smart' ],
    'myPhone S-line'                            => [ 'MyPhone', 'S-line' ],
    'MyPhone Rio Craze'                         => [ 'MyPhone', 'Rio Craze' ],
    'MyPhone Rio Grande'                        => [ 'MyPhone', 'Rio Grande' ],
    'MyPhone Rio Junior TV'                     => [ 'MyPhone', 'Rio Junior TV' ],
    'MyPhone Rio 2'                             => [ 'MyPhone', 'Rio 2' ],
    'MyPhone Rio 2 Fun'                         => [ 'MyPhone', 'Rio 2 Fun' ],
    'MyPhone UNO'                               => [ 'MyPhone', 'Uno' ],
    'MyPhone Xperia Rain 3G'                    => [ 'MyPhone', 'Xperia Rain' ],
    'Myphone MY25'                              => [ 'MyPhone', 'My25' ],
    'MyPhone MY26'                              => [ 'MyPhone', 'My26' ],
    'MyPhone MY28S'                             => [ 'MyPhone', 'My28S' ],
    'MyPad 2'                                   => [ 'MyPhone', 'MyPad 2', DeviceType::TABLET ],
    'MyPad 750HD'                               => [ 'MyPhone', 'MyPad 750 HD', DeviceType::TABLET ],
    'MyPad 1000 HD'                             => [ 'MyPhone', 'MyPad 1000 HD', DeviceType::TABLET ],

    'MY ?SAGA!!' => [
        'MySAGA C1'                                 => [ 'Mysaga', 'C1' ],
        'MY SAGA C2'                                => [ 'Mysaga', 'C2' ],
        'MY SAGA C3'                                => [ 'Mysaga', 'C3' ],
        'MYSAGA M1'                                 => [ 'Mysaga', 'M1' ],
    ],

    'M\.T\.T\.!!' => [
        'M.T.T. SmartFun'                           => [ 'M.T.T.', 'Smart Fun' ],
        'M.T.T.SmartMax'                            => [ 'M.T.T.', 'Smart Max' ],
        'M.T.T. Smart Multimedia'                   => [ 'M.T.T.', 'Smart Multimedia' ],
        'M.T.T. Tablet'                             => [ 'M.T.T.', 'Tablet', DeviceType::TABLET ],
    ],

    'iQ7 8GB'                                   => [ 'Navon', 'IQ7', DeviceType::TABLET ],
    'Newman K1'                                 => [ 'Newman', 'K1' ],
    'NewmanK1'                                  => [ 'Newman', 'K1' ],
    'Newman K2'                                 => [ 'Newman', 'K2' ],
    'N1'                                        => [ 'Newman', 'N1' ],
    'Newman N1'                                 => [ 'Newman', 'N1' ],
    'Newman N2!'                                => [ 'Newman', 'N2' ],
    'Newman-N2!'                                => [ 'Newman', 'N2' ],
    'Newpad'                                    => [ 'Newsmy', 'Newpad', DeviceType::TABLET ],
    'Newpad-K97'                                => [ 'Newsmy', 'Newpad K97', DeviceType::TABLET ],
    'Newpad-NP900'                              => [ 'Newsmy', 'Newpad NP900', DeviceType::TABLET ],
    'P7'                                        => [ 'Newsmy', 'Newpad P7', DeviceType::TABLET ],
    'Newpad P9'                                 => [ 'Newsmy', 'Newpad P9', DeviceType::TABLET ],
    'Newpad P72'                                => [ 'Newsmy', 'Newpad P72', DeviceType::TABLET ],
    'Newsmy P72'                                => [ 'Newsmy', 'Newpad P72', DeviceType::TABLET ],
    'Newsmy P72-C'                              => [ 'Newsmy', 'Newpad P72', DeviceType::TABLET ],
    'Newsmy T3'                                 => [ 'Newsmy', 'Newpad T3', DeviceType::TABLET ],
    'Newsmy T7II'                               => [ 'Newsmy', 'Newpad T7 II', DeviceType::TABLET ],
    'M-PAD N8'                                  => [ 'Newsmy', 'M-pad N8', DeviceType::TABLET ],

    'LTB-HS'                                    => [ 'NEC', 'LifeTouch B' ],
    'LT-TLA'                                    => [ 'NEC', 'LifeTouch L' ],
    'NEC-STR'                                   => [ 'NEC', 'LifeTouch L' ],
    'LT-NA7'                                    => [ 'NEC', 'LifeTouch Note' ],
    'LT-NA7F'                                   => [ 'NEC', 'LifeTouch Note' ],

    'D000-0000(13|18|19)-[0-9]{3,3}!'           => [ 'NEC', 'LifeTouch B' ],
    'D000-0000(01|07)-[A-Z][0-9]{2,2}!'         => [ 'NEC', 'LifeTouch S' ],
    'D000-000002-[W0][0-9]{2,2}!'               => [ 'NEC', 'LifeTouch W' ],
    'D000-0000(10|11)-N!'                       => [ 'NEC', 'LifeTouch Note' ],

    'D000 000043'                               => [ 'NEC', 'NS8368', DeviceType::TELEVISION ],

    'N-0[0-9][A-Z]!!' => [
        'N-01D'                                     => [ 'NEC', 'MEDIAS PP N-01D', 'carrier' => 'DoCoMo' ],
        'N-02E'                                     => [ 'NEC', 'MEDIAS U N-02E', 'carrier' => 'DoCoMo' ],
        'N-03E'                                     => [ 'NEC', 'N-03E', 'carrier' => 'Disney Mobile' ],
        'N-04C'                                     => [ 'NEC', 'MEDIAS N-04C', 'carrier' => 'DoCoMo' ],
        'N-04D'                                     => [ 'NEC', 'MEDIAS LTE N-04D', 'carrier' => 'DoCoMo' ],
        'N-04E'                                     => [ 'NEC', 'MEDIAS X N-04E', 'carrier' => 'DoCoMo' ],
        'N-05D'                                     => [ 'NEC', 'MEDIAS ES N-05D', 'carrier' => 'DoCoMo' ],
        'N-05E'                                     => [ 'NEC', 'MEDIAS W N-05E', 'carrier' => 'DoCoMo' ],
        'N-06C'                                     => [ 'NEC', 'MEDIAS WP N-06C', 'carrier' => 'DoCoMo' ],
        'N-06D'                                     => [ 'NEC', 'MEDIAS Tab N-06D', DeviceType::TABLET, 'carrier' => 'DoCoMo' ],
        'N-06E'                                     => [ 'NEC', 'MEDIAS X N-06E', 'carrier' => 'DoCoMo' ],
        'N-07D'                                     => [ 'NEC', 'MEDIAS X N-07D', 'carrier' => 'DoCoMo' ],
        'N-08D'                                     => [ 'NEC', 'MEDIAS Tab UL N-08D', DeviceType::TABLET, 'carrier' => 'DoCoMo' ],
    ],

    'NEC-0912'                                  => [ 'NEC', 'MEDIAS U N-02E', 'carrier' => 'DoCoMo' ],
    'IS11N'                                     => [ 'NEC', 'MEDIAS BR IS11N', 'carrier' => 'au' ],
    '101N'                                      => [ 'NEC', 'MEDIAS CH 101N', 'carrier' => 'Softbank' ],
    'NEC-101S'                                  => [ 'NEC', 'MEDIAS 101S' ],
    'NECTEL-101S'                               => [ 'NEC', 'MEDIAS 101S' ],
    'NEC-101T'                                  => [ 'NEC', 'MEDIAS 101T' ],
    '101T'                                      => [ 'NEC', 'MEDIAS 101T' ],
    'NEC-101TH'                                 => [ 'NEC', 'MEDIAS 101TH' ],
    'NEC-102'                                   => [ 'NEC', 'MEDIAS 102' ],
    'NE-103T'                                   => [ 'NEC', 'MEDIAS U 103T' ],
    'NEC909e'                                   => [ 'NEC', 'MEDIAS 909e' ],
    'NE-202'                                    => [ 'NEC', 'MEDIAS', 'carrier' => 'Biglobe' ],
    'NE-201A1A'                                 => [ 'NEC', 'Terrain' ],
    'NEC-NE-201A1A'                             => [ 'NEC', 'Terrain' ],
    'NEC-NEC-NE-201A1A'                         => [ 'NEC', 'Terrain' ],

    'LaVieTab!!' => [
        'LaVieTab PC-TE508S1'                       => [ 'NEC', 'LaVie Tab E TE508', DeviceType::TABLET ],
        'LaVieTab PC-TE510N1B'                      => [ 'NEC', 'LaVie Tab E TE510', DeviceType::TABLET ],
        'LaVieTab PC-TE510S1'                       => [ 'NEC', 'LaVie Tab E TE510', DeviceType::TABLET ],
        'LaVieTab TE510S1'                          => [ 'NEC', 'LaVie Tab E TE510', DeviceType::TABLET ],
        'LaVieTab PC-TS507N1S'                      => [ 'NEC', 'LaVie Tab S TS507', DeviceType::TABLET ],
    ],

    'PC-TE307N1W'                               => [ 'NEC', 'LaVie Tab E TE307', DeviceType::TABLET ],
    'NEC PC-TE508S1'                            => [ 'NEC', 'LaVie Tab E TE508', DeviceType::TABLET ],
    'PC-TE508BAW'                               => [ 'NEC', 'LaVie Tab E TE508', DeviceType::TABLET ],
    'PC-TS508T1W'                               => [ 'NEC', 'LaVie Tab S TS508', DeviceType::TABLET ],
    'PC-TS708T1W'                               => [ 'NEC', 'LaVie Tab S TS708', DeviceType::TABLET ],

    'N8730-411'                                 => [ 'NEC', 'AGT10', DeviceType::TABLET ],
    'N8730-41101'                               => [ 'NEC', 'AGT10', DeviceType::TABLET ],
    'N8730-41102'                               => [ 'NEC', 'AGT10', DeviceType::TABLET ],

    'OPS-DRD Digital Signage Player'            => [ 'NEC', 'OPS-DRD Digital Signage Player', DeviceType::SIGNAGE ],

    'neken!!' => [
        'neken N5'                                  => [ 'Neken', 'N5' ],
        'neken N6'                                  => [ 'Neken', 'N6' ],
        'neken NX'                                  => [ 'Neken', 'NX' ],
    ],

    'GTV100'                                    => [ 'NETGEAR', 'NeoTV Prime', DeviceType::TELEVISION, Flag::GOOGLETV ],

    'NEO!!' => [
        'NEO N01'                                   => [ 'NEO', 'N01' ],
        'NEO N002'                                  => [ 'NEO', 'N002' ],
        'NEO N002i'                                 => [ 'NEO', 'N002i' ],
    ],

    'ARA YS608'                                 => [ 'NESO', 'ARA YS608' ],

    '(Nexian )?NX-A[0-9]{3,3}!!' => [
        'NX-A712'                                   => [ 'Nexian', 'Explorer' ],
        'Nexian NX-A890'                            => [ 'Nexian', 'Journey' ],
        'NX-A890'                                   => [ 'Nexian', 'Journey' ],
        'NX-A891'                                   => [ 'Nexian', 'Ultra Journey' ],
        'NX-A895'                                   => [ 'Nexian', 'Cosmo Journey' ],
        'NX-A899'                                   => [ 'Nexian', 'Xtreme' ],
    ],

    'Nextbook Premium 7'                        => [ 'Nextbook', 'Premium 7', DeviceType::EREADER ],
    'M726HC'                                    => [ 'Nextbook', 'Premium 7', DeviceType::EREADER ],
    'Next7C12!'                                 => [ 'Nextbook', 'Premium 7', DeviceType::EREADER ],
    'Next7D12!'                                 => [ 'Nextbook', 'Premium 7', DeviceType::EREADER ],
    'Next7P12!'                                 => [ 'Nextbook', 'Premium 7', DeviceType::EREADER ],
    'Next7Q12!'                                 => [ 'Nextbook', 'Premium 7', DeviceType::EREADER ],
    'Next7P'                                    => [ 'Nextbook', 'Premium 7', DeviceType::EREADER ],
    'Next7S'                                    => [ 'Nextbook', 'Premium 7', DeviceType::EREADER ],
    'NXM726'                                    => [ 'Nextbook', 'Premium 7', DeviceType::EREADER ],
    'NXM726HN'                                  => [ 'Nextbook', 'Premium 7', DeviceType::EREADER ],
    'NXM726HN C030'                             => [ 'Nextbook', 'Premium 7', DeviceType::EREADER ],
    'NXM726HN HASTINGS'                         => [ 'Nextbook', 'Premium 7', DeviceType::EREADER ],
    'NXM727KC!'                                 => [ 'Nextbook', 'Premium 7', DeviceType::EREADER ],
    'Nextbook Premium 7 SE'                     => [ 'Nextbook', 'Premium 7 SE', DeviceType::EREADER ],
    'NEXT8P'                                    => [ 'Nextbook', 'Premium 8', DeviceType::EREADER ],
    'Next8P11'                                  => [ 'Nextbook', 'Premium 8', DeviceType::EREADER ],
    'Next8P12'                                  => [ 'Nextbook', 'Premium 8', DeviceType::EREADER ],
    'NXM803HC'                                  => [ 'Nextbook', 'Premium 8', DeviceType::EREADER ],
    'NXM803HD'                                  => [ 'Nextbook', 'Premium 8', DeviceType::EREADER ],
    'NX868QW8G'                                 => [ 'Nextbook', 'Premium 8', DeviceType::EREADER ],
    'DATAM803HC'                                => [ 'Nextbook', 'Premium 8', DeviceType::EREADER ],
    'DATAM805HC'                                => [ 'Nextbook', 'Premium 8 SE', DeviceType::EREADER ],
    'NXM805ND'                                  => [ 'Nextbook', 'Premium 8 SE', DeviceType::EREADER ],
    'NXM805ND EN'                               => [ 'Nextbook', 'Premium 8 SE', DeviceType::EREADER ],
    'DATAM819HD!'                               => [ 'Nextbook', 'Premium 8', DeviceType::EREADER ],
    'Next9P'                                    => [ 'Nextbook', 'Premium 9', DeviceType::EREADER ],
    'NXM908HC'                                  => [ 'Nextbook', 'Premium 9', DeviceType::EREADER ],
    'Next10P12'                                 => [ 'Nextbook', 'Premium 10', DeviceType::EREADER ],
    'NEXT'                                      => [ 'Nextbook', 'Next', DeviceType::EREADER ],
    'NXM703U'                                   => [ 'Nextbook', 'Next 2', DeviceType::EREADER ],
    'NXM901'                                    => [ 'Nextbook', 'Next 3', DeviceType::EREADER],
    'NXM736'                                    => [ 'Nextbook', 'Next 6', DeviceType::EREADER],
    'NX700QC'                                   => [ 'Nextbook', '7', DeviceType::TABLET],
    'NX785QC8G'                                 => [ 'Nextbook', '8', DeviceType::TABLET],
    'NXM900MC'                                  => [ 'Nextbook', '8 HD', DeviceType::TABLET],
    'ATLANTIS'                                  => [ 'NGM', 'Atlantis' ],
    'NGM Black Hole'                            => [ 'NGM', 'Black Hole' ],
    'Dynamic Fun'                               => [ 'NGM', 'Dynamic Fun' ],
    'Dynamic Jump'                              => [ 'NGM', 'Dynamic Jump' ],
    'Dynamic Maxi'                              => [ 'NGM', 'Dynamic Maxi' ],
    'Dynamic Milo'                              => [ 'NGM', 'Dynamic Milo' ],
    'Dynamic Racing 2'                          => [ 'NGM', 'Dynamic Racing 2' ],
    'NGM Dynamic Racing 2'                      => [ 'NGM', 'Dynamic Racing 2' ],
    'NGM Dynamic Racing 3'                      => [ 'NGM', 'Dynamic Racing 3' ],
    'Dynamic Raging Go'                         => [ 'NGM', 'Dynamic Racing Go' ],
    'Dynamic Shake'                             => [ 'NGM', 'Dynamic Shake' ],
    'NGM Dynamic Star'                          => [ 'NGM', 'Dynamic Star' ],
    'Stylo'                                     => [ 'NGM', 'Dynamic Stylo' ],
    'NGM Dynamic Stylo'                         => [ 'NGM', 'Dynamic Stylo' ],
    'Dynamic Wide'                              => [ 'NGM', 'Dynamic Wide' ],
    'Dynamic Wing'                              => [ 'NGM', 'Dynamic Wing' ],
    'Forward Active'                            => [ 'NGM', 'Forward Active' ],
    'Forward Art'                               => [ 'NGM', 'Forward Art' ],
    'Forward Escape'                            => [ 'NGM', 'Forward Escape' ],
    'Forward Endurance'                         => [ 'NGM', 'Forward Endurance' ],
    'ForwardEndurance'                          => [ 'NGM', 'Forward Endurance' ],
    'FORWARD EVOLVE'                            => [ 'NGM', 'Forward Evolve' ],
    'Forward Infinity'                          => [ 'NGM', 'Forward Infinity' ],
    'NGM Forward Infinity'                      => [ 'NGM', 'Forward Infinity' ],
    'Forward Next'                              => [ 'NGM', 'Forward Next' ],
    'Now'                                       => [ 'NGM', 'Forward Now' ],
    'Forward Prime'                             => [ 'NGM', 'Forward Prime' ],
    'Forward Racing 3'                          => [ 'NGM', 'Forward Racing 3' ],
    'Dynamic Racing 3'                          => [ 'NGM', 'Forward Racing 3' ],
    'NGM Forward Racing HD'                     => [ 'NGM', 'Forward Racing HD' ],
    'Forward Ruby'                              => [ 'NGM', 'Forward Ruby' ],
    'ForwardRuby'                               => [ 'NGM', 'Forward Ruby' ],
    'Forward Shake'                             => [ 'NGM', 'Forward Shake' ],
    'ForwardXtreme'                             => [ 'NGM', 'Forward Xtreme' ],
    'Forward Young'                             => [ 'NGM', 'Forward Young' ],
    'NGM Forward Young'                         => [ 'NGM', 'Forward Young' ],
    'ForwardZero'                               => [ 'NGM', 'Forward Zero' ],
    'Forward 5 5'                               => [ 'NGM', 'Forward 5.5' ],
    'Forward 5.5'                               => [ 'NGM', 'Forward 5.5' ],
    'NGM Harley'                                => [ 'NGM', 'Harley Davidson' ],
    'Infinity'                                  => [ 'NGM', 'Infinity' ],
    'Life'                                      => [ 'NGM', 'Life' ],
    'NGM Orion'                                 => [ 'NGM', 'Orion' ],
    'NGM Spirit'                                => [ 'NGM', 'Spirit' ],
    'NGM Time'                                  => [ 'NGM', 'Time' ],
    'NGM Vanity Smart'                          => [ 'NGM', 'Vanity Smart' ],
    'NGM Action'                                => [ 'NGM', 'WeMove Action' ],
    'NGM Legend'                                => [ 'NGM', 'WeMove Legend' ],
    'NGM-Legend/Legend'                         => [ 'NGM', 'WeMove Legend' ],
    'NGM Legend2'                               => [ 'NGM', 'WeMove Legend 2' ],
    'NGM LegendXL'                              => [ 'NGM', 'WeMove Legend XL' ],
    'NGM Miracle'                               => [ 'NGM', 'WeMove Miracle' ],
    'NGM P0laris'                               => [ 'NGM', 'WeMove Polaris' ],
    'NGM Wilco'                                 => [ 'NGM', 'WeMove Wilco' ],
    'NGM WINN'                                  => [ 'NGM', 'Winn' ],
    'COOLPIX S800c'                             => [ 'Nikon', 'Coolpix S800c', DeviceType::CAMERA ],
    'COOLPIX S810c'                             => [ 'Nikon', 'Coolpix S810c', DeviceType::CAMERA ],
    'i5300'                                     => [ 'Ninetology', 'Palette' ],
    'i5350'                                     => [ 'Ninetology', 'Pearl Mini' ],
    'nine i7400'                                => [ 'Ninetology', 'Black Pearl' ],
    'I 7520'                                    => [ 'Ninetology', 'Stealth' ],
    'i8400'                                     => [ 'Ninetology', 'U9 P1' ],
    'i8450'                                     => [ 'Ninetology', 'U9 Q1' ],
    'i9400'                                     => [ 'Ninetology', 'Black Pearl II' ],
    'i9430'                                     => [ 'Ninetology', 'Insight' ],
    'i9480'                                     => [ 'Ninetology', 'U9 X1' ],
    'i9500'                                     => [ 'Ninetology', 'Stealth II' ],
    'i9570'                                     => [ 'Ninetology', 'U9 Z1' ],
    'NO1 S6'                                    => [ 'No.1', 'S6' ],

    'NOAIN!!' => [
        'NOAIN A700'                                => [ 'Noain', 'A700' ],
        'NOAIN A900'                                => [ 'Noain', 'A900' ],
        'NOAIN A900S'                               => [ 'Noain', 'A900S' ],
        'NOAIN A903'                                => [ 'Noain', 'A903' ],
        'NOAIN A918'                                => [ 'Noain', 'A918' ],
    ],

    'NBX-T7013N'                                => [ 'Noblex', 'T7013N', DeviceType::TABLET ],
    'NBX-T7023N'                                => [ 'Noblex', 'T7023N', DeviceType::TABLET ],
    'Nokia N9'                                  => [ 'Nokia', 'N9' ],
    'Nokia N900'                                => [ 'Nokia', 'N900' ],
    'Nokia X'                                   => [ 'Nokia', 'X', DeviceType::MOBILE, Flag::NOKIAX ],
    'Nokia X Dual SIM'                          => [ 'Nokia', 'X', DeviceType::MOBILE, Flag::NOKIAX ],
    'RM-980'                                    => [ 'Nokia', 'X', DeviceType::MOBILE, Flag::NOKIAX ],
    'Nokia X+'                                  => [ 'Nokia', 'X+', DeviceType::MOBILE, Flag::NOKIAX ],
    'Nokia Xplus'                               => [ 'Nokia', 'X+', DeviceType::MOBILE, Flag::NOKIAX ],
    'Nokia XL 4G'                               => [ 'Nokia', 'XL', DeviceType::MOBILE, Flag::NOKIAX ],
    'Nokia XL'                                  => [ 'Nokia', 'XL', DeviceType::MOBILE, Flag::NOKIAX ],
    'Nokia XL Dual SIM'                         => [ 'Nokia', 'XL', DeviceType::MOBILE, Flag::NOKIAX ],
    'RM-1061'                                   => [ 'Nokia', 'XL', DeviceType::MOBILE, Flag::NOKIAX ],
    'Nokia X2'                                  => [ 'Nokia', 'X2', DeviceType::MOBILE, Flag::NOKIAX ],
    'NokiaX2DS'                                 => [ 'Nokia', 'X2', DeviceType::MOBILE, Flag::NOKIAX ],
    'Lumia800'                                  => [ 'Nokia', 'Lumia 800' ],
    'Lumia 900'                                 => [ 'Nokia', 'Lumia 900' ],
    'Notion Ink ADAM'                           => [ 'Notion Ink', 'ADAM', DeviceType::TABLET ],
    'Adam'                                      => [ 'Notion Ink', 'ADAM', DeviceType::TABLET ],
    'AND1'                                      => [ 'NUgen', 'AND1' ],
    'Zaffire 785'                               => [ 'Nuqleo', 'Zaffire 785', DeviceType::TABLET ],
    'Zaffire 970'                               => [ 'Nuqleo', 'Zaffire 970', DeviceType::TABLET ],
    'P4D Sirius'                                => [ 'Nvsbl', 'P4D SIRIUS', DeviceType::TABLET ],

    'Tegra!!' => [
        'Tegra Note 7'                              => [ 'Nvidia', 'Tegra Note 7', DeviceType::TABLET ],
        'Tegra Note 8'                              => [ 'Nvidia', 'Tegra Note 8', DeviceType::TABLET ],
        'TegraNote-Premium'                         => [ 'Nvidia', 'Tegra Note Premium', DeviceType::TABLET ],
        'TegraNote-P1640'                           => [ 'Nvidia', 'Tegra Note P1640', DeviceType::TABLET ],
    ],

    'NYX!!' => [
        'NYX FLY'                                   => [ 'NYX Mobile', 'Fly' ],
        'NYX FLY II'                                => [ 'NYX Mobile', 'Fly II' ],
        'NYX NOBA II'                               => [ 'NYX Mobile', 'Noba II' ],
        'NYX ZEUZ HD'                               => [ 'NYX Mobile', 'Zeuz HD' ],
    ],

    'O\+!!' => [
        'O+8.1Android'                              => [ 'O+', '8.1' ],
        'O+ 8.12 Android'                           => [ 'O+', '8.12' ],
        'O+ 8.15 Android'                           => [ 'O+', '8.15' ],
        'O+ 8.16 Android'                           => [ 'O+', '8.16' ],
        'O+ 8.31z Android'                          => [ 'O+', '8.31' ],
        'O+ 8.33 Android'                           => [ 'O+', '8.33' ],
        'O+ 8.36z Android'                          => [ 'O+', '8.36' ],
        'O+ 8.37'                                   => [ 'O+', '8.37' ],
        'O+ 8.37 Android'                           => [ 'O+', '8.37' ],
        'O+ 8.38 Android'                           => [ 'O+', '8.38' ],
        'O+ 8.5 Android'                            => [ 'O+', '8.5' ],
        'O+ 8.52 Android'                           => [ 'O+', '8.52' ],
        'O+ 8.6 Android'                            => [ 'O+', '8.6' ],
        'O+ 8.7 Android'                            => [ 'O+', '8.7' ],
        'O+ 8.75 Android'                           => [ 'O+', '8.75' ],
        'O+ 8.9 Android'                            => [ 'O+', '8.9' ],
        'O+ 8.91 Android'                           => [ 'O+', '8.91' ],
        'O+ 8.92 Android'                           => [ 'O+', '8.92' ],
        'O+ 8.93 Android'                           => [ 'O+', '8.93' ],
        'O+ 9.76'                                   => [ 'O+', '9.76' ],
        'O+ 360'                                    => [ 'O+', '360' ],
        'O+ 360 HD'                                 => [ 'O+', '360 HD' ],
        'O+ 360 HD 2.0'                             => [ 'O+', '360 HD' ],
        'O+ 360 ALPHA PLUS'                         => [ 'O+', '360 Alpha Plus' ],
        'O+ 360 Alpha Plus 2.0'                     => [ 'O+', '360 Alpha Plus' ],
        'O+ AIR'                                    => [ 'O+', 'Air' ],
        'O+ FAB 3G'                                 => [ 'O+', 'Fab' ],
        'O+FAB COLOR'                               => [ 'O+', 'Fab Color' ],
        'O+ FAB ELITE'                              => [ 'O+', 'Fab Elite' ],
        'O+ Grande'                                 => [ 'O+', 'Grande' ],
        'O+ Ultra'                                  => [ 'O+', 'Ultra' ],
        'O+ TABLET'                                 => [ 'O+', 'Tablet', DeviceType::TABLET ],
    ],

    'EFM710A'                                   => [ 'Oblio', 'Mint 7x', DeviceType::TABLET ],
    'ODYS-Chrono'                               => [ 'Odys', 'Chrono', DeviceType::TABLET ],
    'ODYS-EVO'                                  => [ 'Odys', 'Evo', DeviceType::TABLET ],
    'Loox'                                      => [ 'Odys', 'Loox', DeviceType::TABLET ],
    'Odys-Loox'                                 => [ 'Odys', 'Loox', DeviceType::TABLET ],
    'ADM816KC'                                  => [ 'Odys', 'Neo S8 Plus', DeviceType::TABLET ],
    'ADM816HC'                                  => [ 'Odys', 'Neo X', DeviceType::TABLET ],
    'ADM712HC'                                  => [ 'Odys', 'Neo X7', DeviceType::TABLET ],
    'ODYS-NOON'                                 => [ 'Odys', 'Noon', DeviceType::TABLET ],
    'PEDI'                                      => [ 'Odys', 'Pedi', DeviceType::TABLET ],
    'PRIME PLUS 3G'                             => [ 'Odys', 'Prime Plus', DeviceType::TABLET ],
    'ODYS-Q'                                    => [ 'Odys', 'Q', DeviceType::TABLET ],
    'ODYS Space'                                => [ 'Odys', 'Space', DeviceType::TABLET ],
    'ODYS Space TKI BRR233v7'                   => [ 'Odys', 'Space', DeviceType::TABLET ],
    'ODYS Space TKI BRR233v9'                   => [ 'Odys', 'Space', DeviceType::TABLET ],
    'ADM8000KP A'                               => [ 'Odys', 'Titan', DeviceType::TABLET ],
    'ADM8000KP B'                               => [ 'Odys', 'Titan', DeviceType::TABLET ],
    'UNO X8'                                    => [ 'Odys', 'Uno X8', DeviceType::TABLET ],
    'UNO X10'                                   => [ 'Odys', 'Uno X10', DeviceType::TABLET ],
    'XELIO'                                     => [ 'Odys', 'Xelio', DeviceType::TABLET ],
    'XELIO7PHONETAB'                            => [ 'Odys', 'Xelio 7 Phone Tab', DeviceType::TABLET ],
    'Xelio 7 pro'                               => [ 'Odys', 'Xelio 7 Pro', DeviceType::TABLET ],
    'XELIO7PRO'                                 => [ 'Odys', 'Xelio 7 Pro', DeviceType::TABLET ],
    'XELIO10 QUAD'                              => [ 'Odys', 'Xelio 10', DeviceType::TABLET ],
    'XELIO10 PLUS 3G'                           => [ 'Odys', 'Xelio 10 Plus', DeviceType::TABLET ],
    'XELIO10EXTREME'                            => [ 'Odys', 'Xelio 10 Extreme', DeviceType::TABLET ],
    'Xelio 10 Pro'                              => [ 'Odys', 'Xelio 10 Pro', DeviceType::TABLET ],
    'Xelio10Pro'                                => [ 'Odys', 'Xelio 10 Pro', DeviceType::TABLET ],
    'XELIOPT2'                                  => [ 'Odys', 'Xelio PT2', DeviceType::TABLET ],
    'XelioPT2Pro'                               => [ 'Odys', 'Xelio PT2 Pro', DeviceType::TABLET ],
    'Xelio PT4 Pro'                             => [ 'Odys', 'Xelio PT4 Pro', DeviceType::TABLET ],
    'ODYS-Xpress'                               => [ 'Odys', 'Xpress', DeviceType::TABLET ],
    'XPRESS PRO'                                => [ 'Odys', 'Xpress Pro', DeviceType::TABLET ],
    'ODYS Xtreme'                               => [ 'Odys', 'Xtreme', DeviceType::TABLET ],
    'Olivetti Olipad 100'                       => [ 'Olivetti', 'Olipad 100', DeviceType::TABLET ],
    'OP110'                                     => [ 'Olivetti', 'Olipad 110', DeviceType::TABLET ],
    'Graphos A10'                               => [ 'Olivetti', 'Olipad Graphos A10', DeviceType::TABLET ],
    'A0001'                                     => [ 'OnePlus', 'One' ],
    'One A0001'                                 => [ 'OnePlus', 'One' ],
    'OnePlus One'                               => [ 'OnePlus', 'One' ],
    'OnePlus One A0001'                         => [ 'OnePlus', 'One' ],
    'A1001'                                     => [ 'OnePlus', 'One' ],
    'A0002'                                     => [ 'OnePlus', '2' ],
    'ONE A2001'                                 => [ 'OnePlus', '2' ],
    'ONE A2003'                                 => [ 'OnePlus', '2' ],
    'ONE A2005'                                 => [ 'OnePlus', '2' ],
    'OnePlus2'                                  => [ 'OnePlus', '2' ],
    'ONE A3000'                                 => [ 'OnePlus', '3' ],
    'ONE A3003'                                 => [ 'OnePlus', '3' ],
    'ONEPLUS A3000'                             => [ 'OnePlus', '3' ],
    'ONEPLUS A3003'                             => [ 'OnePlus', '3' ],
    'OnePlus3'                                  => [ 'OnePlus', '3' ],
    'ONEPLUS A3010'                             => [ 'OnePlus', '3T' ],
    'ONE E1000'                                 => [ 'OnePlus', 'X' ],
    'ONE E1001'                                 => [ 'OnePlus', 'X' ],
    'ONE E1003'                                 => [ 'OnePlus', 'X' ],
    'ONE E1005'                                 => [ 'OnePlus', 'X' ],
    'ONDA MID'                                  => [ 'Onda', 'MID', DeviceType::TABLET ],
    'ONDA A9 Core4'                             => [ 'Onda', 'A9 Quad Core', DeviceType::TABLET ],
    'ONDA VI10'                                 => [ 'Onda', 'VI10', DeviceType::TABLET ],
    'V701s Core4'                               => [ 'Onda', 'V701s Quad Core', DeviceType::TABLET ],
    'V711s Core4'                               => [ 'Onda', 'V711s Quad Core', DeviceType::TABLET ],
    'V712 Core4'                                => [ 'Onda', 'V712 Quad Core', DeviceType::TABLET ],
    'V719 3G'                                   => [ 'Onda', 'V719 3G', DeviceType::TABLET ],
    'V801 Core4'                                => [ 'Onda', 'V801 Quad Core', DeviceType::TABLET ],
    'V801s Core4'                               => [ 'Onda', 'V801s Quad Core', DeviceType::TABLET ],
    'V811 Core4'                                => [ 'Onda', 'V811 Quad Core', DeviceType::TABLET ],
    'Onda V812'                                 => [ 'Onda', 'V812', DeviceType::TABLET ],
    'V812 Core4'                                => [ 'Onda', 'V812 Quad Core', DeviceType::TABLET ],
    'V813 Core4'                                => [ 'Onda', 'V813 Quad Core', DeviceType::TABLET ],
    'V813s Core4'                               => [ 'Onda', 'V813s Quad Core', DeviceType::TABLET ],
    'V818'                                      => [ 'Onda', 'V818', DeviceType::TABLET ],
    'V818mini'                                  => [ 'Onda', 'V818 Mini', DeviceType::TABLET ],
    'V819mini'                                  => [ 'Onda', 'V819 Mini', DeviceType::TABLET ],
    'V819 3G'                                   => [ 'Onda', 'V819 3G', DeviceType::TABLET ],
    'V819i'                                     => [ 'Onda', 'V819i', DeviceType::TABLET ],
    'V971 Core4'                                => [ 'Onda', 'V971 Quad Core', DeviceType::TABLET ],
    'V971s Core4'                               => [ 'Onda', 'V971s Quad Core', DeviceType::TABLET ],
    'V972 Core4'                                => [ 'Onda', 'V972 Quad Core', DeviceType::TABLET ],
    'V973 Core4'                                => [ 'Onda', 'V973 Quad Core', DeviceType::TABLET ],
    'V975 Core4'                                => [ 'Onda', 'V975 Quad Core', DeviceType::TABLET ],
    'V975i'                                     => [ 'Onda', 'V975i Quad Core', DeviceType::TABLET ],
    'V975m'                                     => [ 'Onda', 'V975m', DeviceType::TABLET ],
    'V975m Core4'                               => [ 'Onda', 'V975m Quad Core', DeviceType::TABLET ],
    'ONDA v975m'                                => [ 'Onda', 'V975m Quad Core', DeviceType::TABLET ],
    'V975s Core4'                               => [ 'Onda', 'V975s Quad Core', DeviceType::TABLET ],
    'ONDA V989'                                 => [ 'Onda', 'V989', DeviceType::TABLET ],
    'ONDA V989 Core8'                           => [ 'Onda', 'V989 Octo Core', DeviceType::TABLET ],
    'VX580A'                                    => [ 'Onda', 'VX580A', DeviceType::TABLET ],
    'VX580W'                                    => [ 'Onda', 'VX580W', DeviceType::TABLET ],
    'VX610A'                                    => [ 'Onda', 'VX610A', DeviceType::TABLET ],
    'TQ150'                                     => [ 'Onda', 'TQ150' ],
    'TT101'                                     => [ 'Onda', 'TT101', DeviceType::TABLET ],
    'DP-X1'                                     => [ 'Onkyo', 'DP-X1', DeviceType::MEDIA ],
    'N2T'                                       => [ 'ONN', 'N2T', DeviceType::TABLET ],
    'Renesas!'                                  => [ 'Opad', 'Renesas', DeviceType::TABLET ],
    'OPPO A30'                                  => [ 'Oppo', 'A30' ],
    'A31'                                       => [ 'Oppo', 'A31' ],
    'OB-OPPO A31c'                              => [ 'Oppo', 'A31c' ],
    'A31c'                                      => [ 'Oppo', 'A31c' ],
    'A31t'                                      => [ 'Oppo', 'A31t' ],
    'OPPO A31t'                                 => [ 'Oppo', 'A31t' ],
    'OPPO A33'                                  => [ 'Oppo', 'A33' ],
    'A33f'                                      => [ 'Oppo', 'A33f' ],
    'OPPO A33m'                                 => [ 'Oppo', 'A33m' ],
    'A37f'                                      => [ 'Oppo', 'A37f' ],
    'OPPO A37m'                                 => [ 'Oppo', 'A37m' ],
    'OPPO A53'                                  => [ 'Oppo', 'A53' ],
    'OPPO A53m'                                 => [ 'Oppo', 'A53m' ],
    'CPH1701'                                   => [ 'Oppo', 'A57' ],
    'OPPO A57'                                  => [ 'Oppo', 'A57' ],
    'OPPO A57t'                                 => [ 'Oppo', 'A57t' ],
    'OPPO A59m'                                 => [ 'Oppo', 'A59m' ],
    'OPPO A59s'                                 => [ 'Oppo', 'A59s' ],
    'OPPO A59st'                                => [ 'Oppo', 'A59st' ],
    'OPPO A77'                                  => [ 'Oppo', 'A77' ],
    'OPPO A77t'                                 => [ 'Oppo', 'A77t' ],
    'OPPO A800'                                 => [ 'Oppo', 'A800' ],
    'F1f'                                       => [ 'Oppo', 'F1f' ],
    'A1601'                                     => [ 'Oppo', 'F1s' ],
    'CPH1613'                                   => [ 'Oppo', 'F3 Plus' ],
    'Find 5'                                    => [ 'Oppo', 'Find 5' ],
    'X903'                                      => [ 'Oppo', 'Find Me X903' ],
    'X903S'                                     => [ 'Oppo', 'Find X903S' ],
    'X905'                                      => [ 'Oppo', 'Find 3 X905' ],
    'OPPOX905'                                  => [ 'Oppo', 'Find 3 X905' ],
    'X906'                                      => [ 'Oppo', 'Finder X906' ],
    'X907'                                      => [ 'Oppo', 'Finder X907' ],
    'OPPOX907'                                  => [ 'Oppo', 'Finder X907' ],
    'OPPO Find5'                                => [ 'Oppo', 'Find 5 X909' ],
    'OPPOX909'                                  => [ 'Oppo', 'Find 5 X909' ],
    'OPPO X909'                                 => [ 'Oppo', 'Find 5 X909' ],
    'X909'                                      => [ 'Oppo', 'Find 5 X909' ],
    'X909T'                                     => [ 'Oppo', 'Find 5 X909T' ],
    'X9000'                                     => [ 'Oppo', 'Find 7a X9000' ],
    'X9006'                                     => [ 'Oppo', 'Find 7a X9006' ],
    'X9007'                                     => [ 'Oppo', 'Find 7a X9007' ],
    'X9009'                                     => [ 'Oppo', 'F1 Plus X9009' ],
    'X9015'                                     => [ 'Oppo', 'Find X9015' ],
    'OPPOX9015'                                 => [ 'Oppo', 'Find X9015' ],
    'X9017'                                     => [ 'Oppo', 'Finder X9017' ],
    'OPPOX9017'                                 => [ 'Oppo', 'Finder X9017' ],
    'FIND7'                                     => [ 'Oppo', 'Find 7 X9070' ],
    'OPPO find7'                                => [ 'Oppo', 'Find 7 X9070' ],
    'X9070'                                     => [ 'Oppo', 'Find 7 X9070' ],
    'X9076'                                     => [ 'Oppo', 'Find 7 X9076' ],
    'X9077'                                     => [ 'Oppo', 'Find 7 X9077' ],
    'X9079'                                     => [ 'Oppo', 'R9 Plus X9079' ],
    'OPPOR601'                                  => [ 'Oppo', 'Real R601' ],
    'R801'                                      => [ 'Oppo', 'Real R801' ],
    'OPPOR801'                                  => [ 'Oppo', 'Real R801' ],
    'R801T'                                     => [ 'Oppo', 'Real R801T' ],
    'OPPOR803'                                  => [ 'Oppo', 'Real R803' ],
    'R803'                                      => [ 'Oppo', 'Real R803' ],
    'R805'                                      => [ 'Oppo', 'Real R805' ],
    'OPPOR805'                                  => [ 'Oppo', 'Real R805' ],
    'R807'                                      => [ 'Oppo', 'Real R807' ],
    'OPPOR807'                                  => [ 'Oppo', 'Real R807' ],
    'R809T'                                     => [ 'Oppo', 'R809T' ],
    'R811'                                      => [ 'Oppo', 'R811' ],
    'OPPO R811'                                 => [ 'Oppo', 'R811' ],
    'R813T'                                     => [ 'Oppo', 'R813T' ],
    'OPPO R813T'                                => [ 'Oppo', 'R813T' ],
    'OPPO R815'                                 => [ 'Oppo', 'Find Clover R815' ],
    'R815'                                      => [ 'Oppo', 'Find Clover R815' ],
    'R815T'                                     => [ 'Oppo', 'Find Clover R815T' ],
    'R815W'                                     => [ 'Oppo', 'Real R815W' ],
    'OPPOR817'                                  => [ 'Oppo', 'Real R817' ],
    'R817'                                      => [ 'Oppo', 'Real R817' ],
    'R817T'                                     => [ 'Oppo', 'Real R817T' ],
    'R819'                                      => [ 'Oppo', 'R819' ],
    'Oppo R819'                                 => [ 'Oppo', 'R819' ],
    'R819T!'                                    => [ 'Oppo', 'Real R819T' ],
    'OPPO R821'                                 => [ 'Oppo', 'Find Muse R821' ],
    'R821'                                      => [ 'Oppo', 'Find Muse R821' ],
    'R821T'                                     => [ 'Oppo', 'Find Muse R821T' ],
    'R823T'                                     => [ 'Oppo', 'R823T' ],
    'R827'                                      => [ 'Oppo', 'Find 5 mini R827' ],
    'R827T'                                     => [ 'Oppo', 'Find 5 mini R827T' ],
    'R829'                                      => [ 'Oppo', 'R1 R829' ],
    'R829T'                                     => [ 'Oppo', 'R1 R829T' ],
    'R830'                                      => [ 'Oppo', 'Neo R830' ],
    'R830S'                                     => [ 'Oppo', 'Neo R830S' ],
    'OPPO R831'                                 => [ 'Oppo', 'Neo R831' ],
    'Oppo R831 Limited Edition'                 => [ 'Oppo', 'Neo R831' ],
    'R831K'                                     => [ 'Oppo', 'Real 20 R831K' ],
    'R831L'                                     => [ 'Oppo', 'Neo 5 R831L' ],
    'R831T'                                     => [ 'Oppo', 'Neo R831T' ],
    'R831S'                                     => [ 'Oppo', 'R831S' ],
    'R831'                                      => [ 'Oppo', 'Neo R831' ],
    'R833T'                                     => [ 'Oppo', 'R833T' ],
    'R850'                                      => [ 'Oppo', 'R850' ],
    'R883T'                                     => [ 'Oppo', 'R883T' ],
    'R1001'                                     => [ 'Oppo', 'Joy R1001' ],
    'OPPO R1001'                                => [ 'Oppo', 'Joy R1001' ],
    'R1011'                                     => [ 'Oppo', 'Joy Plus R1011' ],
    'R2001'                                     => [ 'Oppo', 'Yoyo R2001' ],
    'R2010'                                     => [ 'Oppo', 'R2010' ],
    'R2017'                                     => [ 'Oppo', 'R2017' ],
    'R6006'                                     => [ 'Oppo', 'Find 7 mini R6006' ],
    'R6007'                                     => [ 'Oppo', 'R6007' ],
    'R7005'                                     => [ 'Oppo', 'R3 R7005' ],
    'R7007'                                     => [ 'Oppo', 'R3 R7007' ],
    'R8000'                                     => [ 'Oppo', 'R1S R8000' ],
    'R8001'                                     => [ 'Oppo', 'R1K R8001' ],
    'R8006'                                     => [ 'Oppo', 'R1L R8006' ],
    'R8007'                                     => [ 'Oppo', 'R1S R8007' ],
    'OPPOR8015'                                 => [ 'Oppo', 'Find Guitar R8015' ],
    'R8015'                                     => [ 'Oppo', 'Find Guitar R8015' ],
    'R8106'                                     => [ 'Oppo', 'R5 R8106' ],
    'R8107'                                     => [ 'Oppo', 'R5 R8107' ],
    'R8109'                                     => [ 'Oppo', 'R8109' ],
    'R8111'                                     => [ 'Oppo', 'Find Melody R8111' ],
    'OPPOR8111'                                 => [ 'Oppo', 'Find Melody R8111' ],
    'R8113'                                     => [ 'Oppo', 'Find Piano R8113' ],
    'R8200'                                     => [ 'Oppo', 'R1c R8200' ],
    'R8201'                                     => [ 'Oppo', 'R1x R8201' ],
    'R8205'                                     => [ 'Oppo', 'R1c R8205' ],
    'R8206'                                     => [ 'Oppo', 'R1x R8206' ],
    'R8207'                                     => [ 'Oppo', 'R1c R8207' ],
    'OPPOT29'                                   => [ 'Oppo', 'T29' ],
    '(OPPO-?)?T703!'                            => [ 'Oppo', 'T703' ],
    'OPPOU701'                                  => [ 'Oppo', 'Ulike U701' ],
    'U701'                                      => [ 'Oppo', 'Ulike U701' ],
    'U701T'                                     => [ 'Oppo', 'U701T' ],
    'U702'                                      => [ 'Oppo', 'U702' ],
    'U705'                                      => [ 'Oppo', 'U705' ],
    'U705T'                                     => [ 'Oppo', 'Ulike 2 U705T' ],
    'U705W'                                     => [ 'Oppo', 'Ulike 2 U705W' ],
    'U707'                                      => [ 'Oppo', 'Find Way S U707' ],
    'U707T'                                     => [ 'Oppo', 'Find Way S U707T' ],
    'U708'                                      => [ 'Oppo', 'U2S U708' ],
    'U7011'                                     => [ 'Oppo', 'Find Gemini U7011' ],
    'OPPOU7011'                                 => [ 'Oppo', 'Find Gemini U7011' ],
    'OPPOU7015'                                 => [ 'Oppo', 'Find Way U7015' ],
    'U7015'                                     => [ 'Oppo', 'Find Way U7015' ],
    'OPPO N1'                                   => [ 'Oppo', 'N1' ],
    'N51(10|11|16|17)!'                         => [ 'Oppo', 'N1 mini' ],
    'N52(06|07|09)!'                            => [ 'Oppo', 'N3' ],
    'OPPO R7'                                   => [ 'Oppo', 'R7' ],
    'R7f'                                       => [ 'Oppo', 'R7f' ],
    'R7i'                                       => [ 'Oppo', 'R7i' ],
    'OPPO R7s'                                  => [ 'Oppo', 'R7s' ],
    'OPPO R7sm'                                 => [ 'Oppo', 'R7sm' ],
    'OPPO R7st'                                 => [ 'Oppo', 'R7st' ],
    'OPPO R7t'                                  => [ 'Oppo', 'R7t' ],
    'OPPO R9m'                                  => [ 'Oppo', 'R9m' ],
    'OPPO R9tm'                                 => [ 'Oppo', 'R9tm' ],
    'OPPO R9km'                                 => [ 'Oppo', 'R9km' ],
    'OPPO R9s'                                  => [ 'Oppo', 'R9s' ],
    'OPPO R9sk'                                 => [ 'Oppo', 'R9sk' ],
    'OPPO R9st'                                 => [ 'Oppo', 'R9st' ],
    'OPPO R9t'                                  => [ 'Oppo', 'R9t' ],
    'OPPO R9tm'                                 => [ 'Oppo', 'R9tm' ],
    'OPPO R11'                                  => [ 'Oppo', 'R11' ],
    'OPPO R11t'                                 => [ 'Oppo', 'R11t' ],
    'OPPO R7 Plus'                              => [ 'Oppo', 'R7 Plus' ],
    'R7Plus'                                    => [ 'Oppo', 'R7 Plus' ],
    'R7plusf'                                   => [ 'Oppo', 'R7 Plus' ],
    'R7Plusm'                                   => [ 'Oppo', 'R7 Plus' ],
    'OPPO R7sPlus'                              => [ 'Oppo', 'R7s Plus' ],
    'OPPO R9 Plusm A'                           => [ 'Oppo', 'R9 Plus' ],
    'OPPO R9 Plustm A'                          => [ 'Oppo', 'R9 Plus' ],
    'CPH1611'                                   => [ 'Oppo', 'R9s Plus' ],
    'OPPO R9s Plus'                             => [ 'Oppo', 'R9s Plus' ],
    'OPPO R11 Plus'                             => [ 'Oppo', 'R11 Plus' ],
    'OPPO R11 Plusk'                            => [ 'Oppo', 'R11 Plus' ],
    'OPPO R11 Pluskt'                           => [ 'Oppo', 'R11 Plus' ],
    'W8'                                        => [ 'Oppo', 'W8' ],
    '1105'                                      => [ 'Oppo', '1105' ],
    '1107'                                      => [ 'Oppo', '1107' ],
    'OB-OPPO 3005'                              => [ 'Oppo', '3005' ],

    'OPSSON!!' => [
        'OPSSON D1'                                 => [ 'Opsson', 'D1' ],
        'OPSSON D1s'                                => [ 'Opsson', 'D1s' ],
        'OPSSON S1'                                 => [ 'Opsson', 'S1' ],
        'OPSSON S7'                                 => [ 'Opsson', 'S7' ],
        'OPSSON X5'                                 => [ 'Opsson', 'X5' ],
        'OPSSON IDO 5000'                           => [ 'Opsson', 'IDO 5000' ],
        'OPSSON IDO5300'                            => [ 'Opsson', 'IDO 5300' ],
        'OPSSON IDO 5311'                           => [ 'Opsson', 'IDO 5311' ],
        'OPSSON IDO 5322'                           => [ 'Opsson', 'IDO 5322' ],
        'OPSSON IDO5355'                            => [ 'Opsson', 'IDO 5355' ],
        'OPSSON iMO850'                             => [ 'Opsson', 'IMO 850' ],
        'OPSSON iMO1000'                            => [ 'Opsson', 'IMO 1000' ],
        'OPSSON IVO6600'                            => [ 'Opsson', 'IVO 6600' ],
        'OPSSON IVO6622'                            => [ 'Opsson', 'IVO 6622' ],
        'OPSSON IVO6633'                            => [ 'Opsson', 'IVO 6633' ],
        'OPSSON IVO6655'                            => [ 'Opsson', 'IVO 6655' ],
        'OPSSON IVO6666'                            => [ 'Opsson', 'IVO 6666' ],
        'OPSSON IVO 6677'                           => [ 'Opsson', 'IVO 6677' ],
        'OPSSON IVO 8800'                           => [ 'Opsson', 'IVO 8800' ],
    ],

    'OP0118-12'                                 => [ 'Oregon Scientific', 'Meep!', DeviceType::TABLET ],

    '(OV-|Overmax|Vertis)!!' => [
        'OV-TB-07B'                                 => [ 'Overmax', 'TB-07B', DeviceType::TABLET ],
        'OV-TB-08 II'                               => [ 'Overmax', 'TB-08 II', DeviceType::TABLET ],
        'OV-TB-O9C'                                 => [ 'Overmax', 'TB-09C', DeviceType::TABLET ],
        'OV-BaseCore10'                             => [ 'Overmax', 'BaseCore 10', DeviceType::TABLET ],
        'OV-BaseoneII'                              => [ 'Overmax', 'BaseOne II', DeviceType::TABLET ],
        'OV-BasicTab'                               => [ 'Overmax', 'BasicTab', DeviceType::TABLET ],
        'OV-DualDriveMax2'                          => [ 'Overmax', 'DualDrive Max II', DeviceType::TABLET ],
        'OV-Newbase2'                               => [ 'Overmax', 'NewBase 2', DeviceType::TABLET ],
        'OV-Quattor10'                              => [ 'Overmax', 'Quatttor 10', DeviceType::TABLET ],
        'OV-Quattor 10+'                            => [ 'Overmax', 'Quatttor 10+', DeviceType::TABLET ],
        'OV-Solution 7II'                           => [ 'Overmax', 'Solution 7 II', DeviceType::TABLET ],
        'OV-Solution 10II'                          => [ 'Overmax', 'Solution 10 II', DeviceType::TABLET ],
        'OV-SteelCore7'                             => [ 'Overmax', 'SteelCore 7', DeviceType::TABLET ],
        'OV-STEELCORE 10+ (Z)'                      => [ 'Overmax', 'SteelCore 10+', DeviceType::TABLET ],
        'OV-SteelCore10+II'                         => [ 'Overmax', 'SteelCore 10+ II', DeviceType::TABLET ],
        'OV-Steelcore10III'                         => [ 'Overmax', 'SteelCore 10 III', DeviceType::TABLET ],
        'OV-Steelcore 10III(Z)'                     => [ 'Overmax', 'SteelCore 10 III', DeviceType::TABLET ],
        'Overmax Vertis'                            => [ 'Overmax', 'Vertis 01' ],
        'Overmax Vertis 01'                         => [ 'Overmax', 'Vertis 01' ],
        'OV-Vertis-01'                              => [ 'Overmax', 'Vertis 01' ],
        'OV-Vertis-02'                              => [ 'Overmax', 'Vertis 02' ],
        'Vertis Expi'                               => [ 'Overmax', 'Vertis Expi' ],
        'Vertis Famy'                               => [ 'Overmax', 'Vertis Famy' ],
    ],

    'Oysters Pacific 800'                       => [ 'Oysters', 'Pacific 800' ],
    'Oysters T3 3G'                             => [ 'Oysters', 'T3' ],
    'Oysters T7B 3G'                            => [ 'Oysters', 'T7B' ],
    'Oysters T7X 3G'                            => [ 'Oysters', 'T7X' ],
    'OYSTERS T14N 3G'                           => [ 'Oysters', 'T14N' ],
    'Oysters T37'                               => [ 'Oysters', 'T37' ],
    'Oysters T72H 3G'                           => [ 'Oysters', 'T72' ],
    'Oysters T72HRi 3G'                         => [ 'Oysters', 'T72' ],
    'OYSTERS T80 3G'                            => [ 'Oysters', 'T80' ],
    'Liberty Tab G100'                          => [ 'Packard Bell', 'Liberty Tab G100', DeviceType::TABLET ],
    'G100W'                                     => [ 'Packard Bell', 'Liberty Tab G100', DeviceType::TABLET ],

    'P-0[0-9][A-Z]!!' => [
        'P-01D'                                     => [ 'Panasonic', 'P-01D', 'carrier' => 'DoCoMo' ],
        'P-02D'                                     => [ 'Panasonic', 'LUMIX Phone P-02D', 'carrier' => 'DoCoMo' ],
        'P-02E'                                     => [ 'Panasonic', 'ELUGA X P-02E', 'carrier' => 'DoCoMo' ],
        'P-03E'                                     => [ 'Panasonic', 'ELUGA P P-03E', 'carrier' => 'DoCoMo' ],
        'P-04D'                                     => [ 'Panasonic', 'P-04D', 'carrier' => 'DoCoMo' ],
        'P-05D'                                     => [ 'Panasonic', 'P-05D', 'carrier' => 'Disney Mobile' ],
        'P-06D'                                     => [ 'Panasonic', 'ELUGA V P-06D', 'carrier' => 'DoCoMo' ],
        'P-07C'                                     => [ 'Panasonic', 'P-07C', 'carrier' => 'DoCoMo' ],
        'P-07D'                                     => [ 'Panasonic', 'ELUGA power P-07D', 'carrier' => 'DoCoMo' ],
        'P-08D'                                     => [ 'Panasonic', 'ELUGA Live P-08D', DeviceType::TABLET, 'carrier' => 'DoCoMo' ],
    ],

    '003P'                                      => [ 'Panasonic', 'Sweety 003P', 'carrier' => 'Softbank' ],
    '101P'                                      => [ 'Panasonic', 'LUMIX Phone 101P', 'carrier' => 'Softbank' ],
    '102P'                                      => [ 'Panasonic', 'ELUGA dL1 102P', 'carrier' => 'Softbank' ],

    'DMC-CM1'                                   => [ 'Panasonic', 'Lumix DMC-CM1', DeviceType::CAMERA ],
    'dL1'                                       => [ 'Panasonic', 'Eluga dL1' ],
    'EB-4063-X'                                 => [ 'Panasonic', 'Eluga X' ],

    'Panasonic!!' => [
        'Panasonic dL1'                             => [ 'Panasonic', 'Eluga dL1' ],
        'Panasonic ELUGA A'                         => [ 'Panasonic', 'Eluga A' ],
        'Panasonic ELUGA A2'                        => [ 'Panasonic', 'Eluga A2' ],
        'Panasonic ELUGA I'                         => [ 'Panasonic', 'Eluga I' ],
        'Panasonic Eluga I3'                        => [ 'Panasonic', 'Eluga I3' ],
        'Panasonic ELUGA L 4G'                      => [ 'Panasonic', 'Eluga L' ],
        'Panasonic ELUGA L2'                        => [ 'Panasonic', 'Eluga L2' ],
        'Panasonic ELUGA S'                         => [ 'Panasonic', 'Eluga S' ],
        'Panasonic ELUGA S Mini'                    => [ 'Panasonic', 'Eluga S Mini' ],
        'Panasonic ELUGA U'                         => [ 'Panasonic', 'Eluga U' ],
        'Panasonic ELUGA U2'                        => [ 'Panasonic', 'Eluga U2' ],
        'Panasonic ELUGA Arc'                       => [ 'Panasonic', 'Eluga Arc' ],
        'Panasonic ELUGA Icon'                      => [ 'Panasonic', 'Eluga Icon' ],
        'Panasonic ELUGA Icon 2'                    => [ 'Panasonic', 'Eluga Icon 2' ],
        'Panasonic ELUGA Mark'                      => [ 'Panasonic', 'Eluga Mark' ],
        'Panasonic ELUGA Switch'                    => [ 'Panasonic', 'Eluga Switch' ],
        'Panasonic ELUGA Tapp'                      => [ 'Panasonic', 'Eluga Tapp' ],
        'Panasonic ELUGA Z'                         => [ 'Panasonic', 'Eluga Z' ],
        'Panasonic P01 Novo'                        => [ 'Panasonic', 'P01 Novo' ],
        'Panasonic P02 Novo'                        => [ 'Panasonic', 'P02 Novo' ],
        'Panasonic P11'                             => [ 'Panasonic', 'P11' ],
        'Panasonic P31'                             => [ 'Panasonic', 'P31' ],
        'Panasonic P41'                             => [ 'Panasonic', 'P41' ],
        'Panasonic P41HD'                           => [ 'Panasonic', 'P41 HD' ],
        'Panasonic P51'                             => [ 'Panasonic', 'P51' ],
        'Panasonic P50'                             => [ 'Panasonic', 'P50' ],
        'Panasonic P55'                             => [ 'Panasonic', 'P55' ],
        'Panasonic P55 Novo'                        => [ 'Panasonic', 'P55 Novo' ],
        'Panasonic P61'                             => [ 'Panasonic', 'P61' ],
        'Panasonic P75'                             => [ 'Panasonic', 'P75' ],
        'Panasonic P77'                             => [ 'Panasonic', 'P77' ],
        'PanasonicP81'                              => [ 'Panasonic', 'P81' ],
        'Panasonic P81'                             => [ 'Panasonic', 'P81' ],
        'Panasonic T9'                              => [ 'Panasonic', 'T9' ],
        'Panasonic T11'                             => [ 'Panasonic', 'T11' ],
        'Panasonic T21'                             => [ 'Panasonic', 'T21' ],
        'Panasonic T30'                             => [ 'Panasonic', 'T30' ],
        'Panasonic T31'                             => [ 'Panasonic', 'T31' ],
        'Panasonic T33'                             => [ 'Panasonic', 'T33' ],
        'Panasonic T35'                             => [ 'Panasonic', 'T35' ],
        'Panasonic T40'                             => [ 'Panasonic', 'T40' ],
        'Panasonic T41'                             => [ 'Panasonic', 'T41' ],
        'Panasonic T44'                             => [ 'Panasonic', 'T44' ],
        'Panasonic T45 4G'                          => [ 'Panasonic', 'T45' ],
        'Panasonic T50'                             => [ 'Panasonic', 'T50' ],
        'Panasonic KX-PRXA10'                       => [ 'Panasonic', 'KX-PRXA10', DeviceType::DECT ],
        'Panasonic KX-PRXA15'                       => [ 'Panasonic', 'KX-PRXA15', DeviceType::DECT ],
        'Panasonic SV-ME970'                        => [ 'Panasonic', 'Viera SV-ME970', DeviceType::TABLET ],
        'Panasonic SV-ME1000'                       => [ 'Panasonic', 'Viera SV-ME1000', DeviceType::TABLET ],
        'Panasonic SV-MV100'                        => [ 'Panasonic', 'SV-MV100', DeviceType::MEDIA ],
        'Panasonic UN-MT300'                        => [ 'Panasonic', 'UN-MT300', DeviceType::MEDIA ],
        'Panasonic UN-W700'                         => [ 'Panasonic', 'Multimedia System UN-W700', DeviceType::MEDIA ],
        'Panasonic UT-PB1'                          => [ 'Panasonic', 'Raboo UT-PB1', DeviceType::EREADER ],
    ],

    'Eluga A2'                                  => [ 'Panasonic', 'Eluga A2' ],
    'ELUGA I2'                                  => [ 'Panasonic', 'Eluga I2' ],
    'ELUGA Note'                                => [ 'Panasonic', 'Eluga Note' ],
    'ELUGA Turbo'                               => [ 'Panasonic', 'Eluga Turbo' ],

    'JT-H580VT'                                 => [ 'Panasonic', 'BizPad 7', DeviceType::TABLET ],
    'JT-H581VT'                                 => [ 'Panasonic', 'BizPad 10', DeviceType::TABLET ],
    'JT-B1'                                     => [ 'Panasonic', 'Toughpad JT-B1', DeviceType::TABLET ],
    'FZ-A1(A|B)!'                               => [ 'Panasonic', 'Toughpad FZ-A1', DeviceType::TABLET ],
    'FZ-B2(B|D)!'                               => [ 'Panasonic', 'Toughpad FZ-B1', DeviceType::TABLET ],
    'FZ-N1'                                     => [ 'Panasonic', 'Toughpad FZ-N1' ],
    'FZ-X1'                                     => [ 'Panasonic', 'Toughpad FZ-X1' ],

    'Altus 18'                                  => [ 'Panasonic', 'Altus 18', DeviceType::INFLIGHT ],
    'Altus 24'                                  => [ 'Panasonic', 'Altus 24', DeviceType::INFLIGHT ],
    'Elite'                                     => [ 'Panasonic', 'Elite', DeviceType::INFLIGHT ],
    'Elite 11'                                  => [ 'Panasonic', 'Elite', DeviceType::INFLIGHT ],
    'Eco9 v1'                                   => [ 'Panasonic', 'Eco 9', DeviceType::INFLIGHT ],
    'Eco9 v2'                                   => [ 'Panasonic', 'Eco 9', DeviceType::INFLIGHT ],
    'Eco11 v2'                                  => [ 'Panasonic', 'Eco 11', DeviceType::INFLIGHT ],
    'Smart Monitor 17'                          => [ 'Panasonic', 'Smart Monitor 17', DeviceType::INFLIGHT ],

    '(48|50|55)AX600C!'                         => [ 'Panasonic', 'Viera AX600C', DeviceType::TELEVISION ],
    'AX600C'                                    => [ 'Panasonic', 'Viera AX600C', DeviceType::TELEVISION ],
    'AS650C'                                    => [ 'Panasonic', 'Viera AS650C', DeviceType::TELEVISION ],

    'VW RCBKK1'                                 => [ 'Panasonic', 'Boukenkun Reciever VW-RCBKK1', DeviceType::TELEVISION ],
    'SMARTTVBOX'                                => [ 'Panasonic', 'SmartTVBox', DeviceType::TELEVISION ],

    'pandigital9hr'                             => [ 'Pandigital', '9HR', DeviceType::TABLET ],
    'pandigital9hr2'                            => [ 'Pandigital', '9HR2', DeviceType::TABLET ],
    'pandigitalopc1'                            => [ 'Pandigital', 'OPC1', DeviceType::TABLET ],
    'pandigitalopp1'                            => [ 'Pandigital', 'OPP1', DeviceType::TABLET ],
    'pandigitalp1hr'                            => [ 'Pandigital', 'p1hr', DeviceType::TABLET ],

    '(SKY )?IM[- ][A-Z][0-9]{3,3}!!' => [
        'SKY IM-A600S'                              => [ 'Pantech', 'SIRIUS α' ],
        'IM-A600!'                                  => [ 'Pantech', 'SIRIUS α' ],
        'SKY IM-A630K'                              => [ 'Pantech', 'Izar' ],
        'IM-A630!'                                  => [ 'Pantech', 'Izar' ],
        'SKY IM-A650S'                              => [ 'Pantech', 'Vega' ],
        'IM-A650!'                                  => [ 'Pantech', 'Vega' ],
        'IM-A690!'                                  => [ 'Pantech', 'Mirach' ],
        'IM[- ]A7(10|20)!'                          => [ 'Pantech', 'VegaXpress' ],
        'IM-A725!'                                  => [ 'Pantech', 'Vega X+' ],
        'IM-A730!'                                  => [ 'Pantech', 'Vega S' ],
        'IM-A7(40|50)!'                             => [ 'Pantech', 'Mirach A' ],
        'IM-A7(60|70|75|80)!'                       => [ 'Pantech', 'Vega Racer' ],
        'IM-A800!'                                  => [ 'Pantech', 'Vega LTE' ],
        'IM-A810!'                                  => [ 'Pantech', 'Vega LTE M' ],
        'IM-A820!'                                  => [ 'Pantech', 'Vega LTE EX' ],
        'IM-A830!'                                  => [ 'Pantech', 'Vega Racer 2' ],
        'IM-A840!'                                  => [ 'Pantech', 'Vega S5' ],
        'IM-A850!'                                  => [ 'Pantech', 'Vega R3' ],
        'IM-A860!'                                  => [ 'Pantech', 'Vega N˚ 6' ],
        'IM-A870!'                                  => [ 'Pantech', 'Vega Iron' ],
        'IM-A880!'                                  => [ 'Pantech', 'Vega LTE-A' ],
        'IM-A890!'                                  => [ 'Pantech', 'Vega Secret Note' ],
        'IM-A900!'                                  => [ 'Pantech', 'Vega Secret Up' ],
        'IM-A910!'                                  => [ 'Pantech', 'Vega Iron 2' ],
        'IM-A920!'                                  => [ 'Pantech', 'IM-A920' ],
        'IM-A930!'                                  => [ 'Pantech', 'IM-A930' ],
        'IM-T100K'                                  => [ 'Pantech', 'Vega N˚ 5', DeviceType::TABLET ],
    ],

    'VEGA NO.6'                                 => [ 'Pantech', 'Vega N˚ 6' ],
    'PLANET'                                    => [ 'Pantech', 'Pocket' ],
    'ADR8995!'                                  => [ 'Pantech', 'Breakout' ],
    'ADR910L'                                   => [ 'Pantech', 'Marauder' ],
    'ADR910L 4G'                                => [ 'Pantech', 'Marauder' ],
    'ADR930L'                                   => [ 'Pantech', 'Perception' ],
    'ADR930L 4G'                                => [ 'Pantech', 'Perception' ],

    'PantechP!!' => [
        'PantechP4100!'                             => [ 'Pantech', 'Element', DeviceType::TABLET ],
        'PantechP7050!'                             => [ 'Pantech', 'P7050' ],
        'PantechP8000!'                             => [ 'Pantech', 'Crossover' ],
        'PantechP8010!'                             => [ 'Pantech', 'Flex' ],
        'PantechP9060!'                             => [ 'Pantech', 'Pocket' ],
        'PantechP9070!'                             => [ 'Pantech', 'Burst' ],
        'PantechP9090!'                             => [ 'Pantech', 'Magnus' ],
    ],

    'IS06'                                      => [ 'Pantech', 'SIRIUS α IS06', 'carrier' => 'au' ],
    'PTL21'                                     => [ 'Pantech', 'Vega PTL21', 'carrier' => 'au' ],
    'IS11PT'                                    => [ 'Pantech', 'Mirach IS11PT', 'carrier' => 'au' ],
    'EIS01PT'                                   => [ 'Pantech', 'EIS01PT', 'carrier' => 'au' ],

    'FC6100'                                    => [ 'Parrot', 'FC6100', DeviceType::CAR ],
    'chagall'                                   => [ 'Pegatron', 'Chagall', DeviceType::TABLET ],
    'PAT712W'                                   => [ 'Perfeo', '712 W', DeviceType::TABLET ],
    '7500IPS'                                   => [ 'Perfeo', '7500 IPS', DeviceType::TABLET ],
    'PATG7506HD'                                => [ 'Perfeo', '7506 HD', DeviceType::TABLET ],
    'X7G'                                       => [ 'Pearl', 'Touchlet X7G', DeviceType::TABLET ],
    'Touchlet X10.dual'                         => [ 'Pearl', 'Touchlet X10.dual', DeviceType::TABLET ],
    'PP4MT-7'                                   => [ 'Pendo', 'Pendopad 4', DeviceType::TABLET ],
    'PP4MT-9'                                   => [ 'Pendo', 'Pendopad 4', DeviceType::TABLET ],
    'PNDPP4MT9G2'                               => [ 'Pendo', 'Pendopad 4', DeviceType::TABLET ],
    'PNDPP44QC7'                                => [ 'Pendo', 'Pendopad 7', DeviceType::TABLET ],
    'PNDPP48GP'                                 => [ 'Pendo', 'Pendopad 8', DeviceType::TABLET ],
    'PNDPP4MT9G3'                               => [ 'Pendo', 'Pendopad 9.7', DeviceType::TABLET ],
    'PNDPP410GP'                                => [ 'Pendo', 'Pendopad 10.1', DeviceType::TABLET ],

    'Penta!!' => [
        'Penta IS701C'                              => [ 'Penta', 'T-Pad IS701C', DeviceType::TABLET ],
        'Penta IS703C'                              => [ 'Penta', 'T-Pad IS703C', DeviceType::TABLET ],
        'Penta WS702C'                              => [ 'Penta', 'T-Pad WS702C', DeviceType::TABLET ],
        'Penta WS704X'                              => [ 'Penta', 'T-Pad WS704X', DeviceType::TABLET ],
        'Penta WS707C'                              => [ 'Penta', 'T-Pad WS707C', DeviceType::TABLET ],
        'Penta WS802C'                              => [ 'Penta', 'T-Pad WS802C', DeviceType::TABLET ],
        'Penta WS907Q'                              => [ 'Penta', 'T-Pad WS907Q', DeviceType::TABLET ],
        'Penta PS650'                               => [ 'Penta', 'PS650', DeviceType::TABLET ],
    ],

    'IS703C'                                    => [ 'Penta', 'T-Pad IS703C', DeviceType::TABLET ],
    'IS801C'                                    => [ 'Penta', 'T-Pad IS801C', DeviceType::TABLET ],

    'Pentagram!!' => [
        'Pentagram Ego'                             => [ 'Pentagram', 'Ego' ],
        'PENTAGRAM EON PRIX'                        => [ 'Pentagram', 'Eon PRIX', DeviceType::TABLET ],
        'Pentagram Monster'                         => [ 'Pentagram', 'Monster' ],
        'PENTAGRAM TAB 7.3'                         => [ 'Pentagram', 'Tab 7.3', DeviceType::TABLET ],
        'PENTAGRAM TAB 7.5'                         => [ 'Pentagram', 'Tab 7.5', DeviceType::TABLET ],
        'PentagramTAB7.6'                           => [ 'Pentagram', 'Tab 7.6', DeviceType::TABLET ],
        'PENTAGRAM TAB Quadra 9.7'                  => [ 'Pentagram', 'Quadra 9.7', DeviceType::TABLET ],
    ],

    'PHICOMM!!' => [
        'PHICOMM CLUE L'                            => [ 'Phicomm', 'Clue L' ],
        'PHICOMM ENERGY M'                          => [ 'Phicomm', 'Energy M' ],
        'PHICOMM Energy M+'                         => [ 'Phicomm', 'Energy M+' ],
        'PHICOMM CLUE C230'                         => [ 'Phicomm', 'C230' ],
        'PHICOMM C230v'                             => [ 'Phicomm', 'C230v' ],
        'Phicomm C230w'                             => [ 'Phicomm', 'C230w' ],
        'PHICOMM C630'                              => [ 'Phicomm', 'C630' ],
        'PHICOMM-E561Lv'                            => [ 'Phicomm', 'E561Lv' ],
        'PHICOMM E653'                              => [ 'Phicomm', 'E653' ],
        'PHICOMM i360'                              => [ 'Phicomm', 'i360' ],
        'PHICOMM i370'                              => [ 'Phicomm', 'i370' ],
        'PHICOMM i508'                              => [ 'Phicomm', 'i508' ],
        'PHICOMM i600'                              => [ 'Phicomm', 'i600' ],
        'PHICOMM-i700v'                             => [ 'Phicomm', 'i700v' ],
        'PHICOMM i800'                              => [ 'Phicomm', 'i800' ],
        'PHICOMM i803'                              => [ 'Phicomm', 'i803' ],
        'PHICOMM i803wa'                            => [ 'Phicomm', 'i803wa' ],
        'PHICOMM i813'                              => [ 'Phicomm', 'i813' ],
        'PHICOMM X100w'                             => [ 'Phicomm', 'X100w' ],
        'PHICOMM X100wEU'                           => [ 'Phicomm', 'X100w' ],
        'PHICOMM X130v'                             => [ 'Phicomm', 'X130v' ],
        'PHICOMM X130va'                            => [ 'Phicomm', 'X130va' ],
        'PHICOMM X130wEU'                           => [ 'Phicomm', 'X130W' ],
    ],

    'FWS[0-9]{3,3}!!' => [
        'FWS610'                                    => [ 'Phicomm', 'FWS610' ],
        'FWS610 EU'                                 => [ 'Phicomm', 'FWS610' ],
        'FWS710'                                    => [ 'Phicomm', 'FWS710' ],
        'FWS710EU'                                  => [ 'Phicomm', 'FWS710' ],
        'FWS710a'                                   => [ 'Phicomm', 'FWS710' ],
        'FWS810'                                    => [ 'Phicomm', 'FWS810' ],
    ],

    'i803w'                                     => [ 'Phicomm', 'i803w' ],
    'Philips I908'                              => [ 'Philips', 'I908' ],
    'Philips I928'                              => [ 'Philips', 'I928' ],
    'Philips S301'                              => [ 'Philips', 'S301' ],
    'Philips S307'                              => [ 'Philips', 'S307' ],
    'Philips S308'                              => [ 'Philips', 'S308' ],
    'Philips S309'                              => [ 'Philips', 'S309' ],
    'Philips S316T'                             => [ 'Philips', 'S316T' ],
    'Philips S326'                              => [ 'Philips', 'S326' ],
    'Philips S337'                              => [ 'Philips', 'S337' ],
    'Philips S358'                              => [ 'Philips', 'S358' ],
    'Philips S388!'                             => [ 'Philips', 'S388' ],
    'Philips S396'                              => [ 'Philips', 'S396' ],
    'Philips S398'                              => [ 'Philips', 'S398' ],
    'Philips S616'                              => [ 'Philips', 'S616' ],
    'Philips T3500'                             => [ 'Philips', 'T3500' ],
    'Philips T3566'                             => [ 'Philips', 'T3566' ],

    'Philips V377'                              => [ 'Philips', 'Xenium V377' ],
    'Philips V387'                              => [ 'Philips', 'Xenium V387' ],
    'Philips V526'                              => [ 'Philips', 'Xenium V526' ],
    'Philips V787'                              => [ 'Philips', 'Xenium V787' ],
    'Philips Xenium V787'                       => [ 'Philips', 'Xenium V787' ],
    'Philips X588'                              => [ 'Philips', 'Xenium X588' ],


    'Philips W336'                              => [ 'Philips', 'W336' ],
    'W337'                                      => [ 'Philips', 'W337' ],
    'Philips W536'                              => [ 'Philips', 'W536' ],
    'Philips W626'                              => [ 'Philips', 'W626' ],
    'W626'                                      => [ 'Philips', 'W626' ],
    'Philips W632'                              => [ 'Philips', 'W632' ],
    'Philips W635'                              => [ 'Philips', 'W635' ],
    'PhilipsW635'                               => [ 'Philips', 'W635' ],
    'Philips W737'                              => [ 'Philips', 'W737' ],
    'Philips W832'                              => [ 'Philips', 'W832' ],
    'Philips W3500'                             => [ 'Philips', 'W3500' ],
    'Philips W3509'                             => [ 'Philips', 'W3509' ],
    'Philips W3550'                             => [ 'Philips', 'W3550' ],
    'Philips W3568'                             => [ 'Philips', 'W3568' ],
    'W3620'                                     => [ 'Philips', 'W3620' ],
    'W5510'                                     => [ 'Philips', 'W5510' ],
    'W6350'                                     => [ 'Philips', 'W6350' ],
    'Philips W6350'                             => [ 'Philips', 'W6350' ],
    'PhilipsW6350'                              => [ 'Philips', 'W6350' ],
    'W6360'                                     => [ 'Philips', 'W6360' ],
    'W6500'                                     => [ 'Philips', 'W6500' ],
    'Philips W6610'                             => [ 'Philips', 'W6610' ],
    'W6620'                                     => [ 'Philips', 'W6620' ],
    'Philips W6618'                             => [ 'Philips', 'W6618' ],
    'Philips W7555'                             => [ 'Philips', 'W7555' ],
    'Philips-W7555'                             => [ 'Philips', 'W7555' ],
    'Philips-W8500'                             => [ 'Philips', 'W8500' ],
    'Philips W8510'                             => [ 'Philips', 'W8510' ],
    'Philips W8555'                             => [ 'Philips', 'W8555' ],
    'Philips W8560'                             => [ 'Philips', 'W8560' ],

    'SA3CNT'                                    => [ 'Philips', 'GoGear', DeviceType::MEDIA ],
    'Philips GoGear Connect'                    => [ 'Philips', 'GoGear Connect', DeviceType::MEDIA ],

    'PI2000'                                    => [ 'Philips', 'PI2000', DeviceType::TABLET ],
    'PI2010'                                    => [ 'Philips', 'PI2010', DeviceType::TABLET ],
    'PI2011'                                    => [ 'Philips', 'PI2011', DeviceType::TABLET ],
    'PI3100'                                    => [ 'Philips', 'PI3100', DeviceType::TABLET ],
    'PI3100-93'                                 => [ 'Philips', 'PI3100', DeviceType::TABLET ],
    'PI3100Z3 93'                               => [ 'Philips', 'PI3100', DeviceType::TABLET ],
    'PI3105'                                    => [ 'Philips', 'PI3105', DeviceType::TABLET ],
    'PI3106'                                    => [ 'Philips', 'PI3106', DeviceType::TABLET ],
    'PI3110'                                    => [ 'Philips', 'PI3110', DeviceType::TABLET ],
    'PI3205G'                                   => [ 'Philips', 'PI3205', DeviceType::TABLET ],
    'PI3210G'                                   => [ 'Philips', 'PI3210', DeviceType::TABLET ],
    'PI3900'                                    => [ 'Philips', 'PI3900', DeviceType::TABLET ],
    'PI3900-93'                                 => [ 'Philips', 'PI3900', DeviceType::TABLET ],
    'PI3910'                                    => [ 'Philips', 'PI3910', DeviceType::TABLET ],
    'PI4010G'                                   => [ 'Philips', 'PI4010', DeviceType::TABLET ],
    'Philips PI5000'                            => [ 'Philips', 'PI5000', DeviceType::TABLET ],
    'PI7000'                                    => [ 'Philips', 'PI7000', DeviceType::TABLET ],
    'PI7100 93'                                 => [ 'Philips', 'PI7100', DeviceType::TABLET ],

    '[0-9]{2,2}PFH6[0-9]{3,3}!'                 => [ 'Philips', '6000 Series', DeviceType::TELEVISION ],
    'AND1E'                                     => [ 'Philips', 'Android TV (2014)', DeviceType::TELEVISION ],
    'AND1E TV'                                  => [ 'Philips', 'Android TV (2014)', DeviceType::TELEVISION ],
    'HMP8100 ATV 93'                            => [ 'Philips', 'Smart TV Box', DeviceType::TELEVISION ],
    'HMP8100 ATV INT'                           => [ 'Philips', 'Smart TV Box', DeviceType::TELEVISION ],

    'G2SMNT'                                    => [ 'Philips', 'Smart All-in-One', DeviceType::MONITOR ],
    'G3SMNTS22'                                 => [ 'Philips', 'Smart All-in-One', DeviceType::MONITOR ],
    'G3SMNTS23'                                 => [ 'Philips', 'Smart All-in-One', DeviceType::MONITOR ],

    'BIP-6000'                                  => [ 'Pidion', 'BIP-6000' ],

    'XDP-100R'                                  => [ 'Pioneer', 'XDP-100R', DeviceType::MEDIA ],

    '(PNR-)?Pioneer!!' => [
        'Pioneer E71t'                              => [ 'Pioneer', 'E71t' ],
        'Pioneer E80w'                              => [ 'Pioneer', 'E80w' ],
        'Pioneer E81c'                              => [ 'Pioneer', 'E81c' ],
        'PNR-Pioneer E81c'                          => [ 'Pioneer', 'E81c' ],
        'Pioneer E90w'                              => [ 'Pioneer', 'E90w' ],
        'Pioneer P81'                               => [ 'Pioneer', 'P81' ],
        'Pioneer S90w'                              => [ 'Pioneer', 'S90w' ],
    ],

    'E60w'                                      => [ 'Pioneer', 'E60w' ],

    'M6'                                        => [ 'PiPO', 'M6', DeviceType::TABLET ],
    'M8 pro'                                    => [ 'PiPO', 'M8 Pro', DeviceType::TABLET ],
    'M9 pro'                                    => [ 'PiPO', 'M9 Pro', DeviceType::TABLET ],

    'PIRANHA!!' => [
        'PIRANHA BUSINESS TAB 7"'                   => [ 'Piranha', 'Business Tab 7.0', DeviceType::TABLET ],
        'PIRANHA BUSINESS TAB 10.1'                 => [ 'Piranha', 'Business Tab 10.1', DeviceType::TABLET ],
        'PIRANHA BUSINESS TAB 10.1 ZEUS WHITE'      => [ 'Piranha', 'Business Tab 10.1', DeviceType::TABLET ],
        'PIRANHA BUSINESS II TAB 9.0'               => [ 'Piranha', 'Business II Tab 9.0', DeviceType::TABLET ],
        'PIRANHA BUSINESS II TAB 9"'                => [ 'Piranha', 'Business II Tab 9.0', DeviceType::TABLET ],
        'PIRANHA BUSINESS III TAB 10.1 ZEUS WHITE'  => [ 'Piranha', 'Business III Tab 10.1', DeviceType::TABLET ],
        'PIRANHA BUSINESS III TAB 10.1'             => [ 'Piranha', 'Business III Tab 10.1', DeviceType::TABLET ],
        'PIRANHA Pro II Tab 7.0'                    => [ 'Piranha', 'Pro II Tab 7.0', DeviceType::TABLET ],
        'PIRANHA Ultra Tab 7.0'                     => [ 'Piranha', 'Ultra Tab 7.0', DeviceType::TABLET ],
        'PIRANHA Ultra Tab Zeus White 10.1'         => [ 'Piranha', 'Ultra Tab 10.1', DeviceType::TABLET ],
        'PIRANHA ULTRA TAB 10.1"'                   => [ 'Piranha', 'Ultra Tab 10.1', DeviceType::TABLET ],
        'PIRANHA ULTRA II TAB 7'                    => [ 'Piranha', 'Ultra II Tab 7.0', DeviceType::TABLET ],
        'PIRANHA Ultra II TAB 9.0'                  => [ 'Piranha', 'Ultra II Tab 9.0', DeviceType::TABLET ],
    ],

    'PGM 398'                                   => [ 'Pixcom', 'PGM 398' ],
    'Playboy PB-S3'                             => [ 'Playboy', 'Note 5' ],

    '(PLOYER-)?MOMO!!' => [
        'PLOYER-MOMO'                               => [ 'Ployer', 'MOMO', DeviceType::TABLET ],
        'MOMO'                                      => [ 'Ployer', 'MOMO', DeviceType::TABLET ],
        'momo-mini'                                 => [ 'Ployer', 'MOMO Mini', DeviceType::TABLET ],
        'MOMO7'                                     => [ 'Ployer', 'MOMO7', DeviceType::TABLET ],
        'MOMO7star'                                 => [ 'Ployer', 'MOMO7 Star', DeviceType::TABLET ],
        'MOMO7 Talent'                              => [ 'Ployer', 'MOMO7 Talent', DeviceType::TABLET ],
        'MOMO8'                                     => [ 'Ployer', 'MOMO8', DeviceType::TABLET ],
        'MOMO8A'                                    => [ 'Ployer', 'MOMO8 A', DeviceType::TABLET ],
        'MOMO8 bird'                                => [ 'Ployer', 'MOMO8 Bird', DeviceType::TABLET ],
        'MOMO8 Star!'                               => [ 'Ployer', 'MOMO8 Star', DeviceType::TABLET ],
        'MOMO8 Xing!'                               => [ 'Ployer', 'MOMO8 Xing', DeviceType::TABLET ],
        'MOMO9'                                     => [ 'Ployer', 'MOMO9', DeviceType::TABLET ],
        'MOMO93G'                                   => [ 'Ployer', 'MOMO9 3G', DeviceType::TABLET ],
        'MOMO9 3G'                                  => [ 'Ployer', 'MOMO9 3G', DeviceType::TABLET ],
        'MOMO9-V P706'                              => [ 'Ployer', 'MOMO9 V', DeviceType::TABLET ],
        'MOMO9 STAR'                                => [ 'Ployer', 'MOMO9 Star', DeviceType::TABLET ],
        'MOMO9star'                                 => [ 'Ployer', 'MOMO9 Star', DeviceType::TABLET ],
        'MOMO9 plus III'                            => [ 'Ployer', 'MOMO9 Plus III', DeviceType::TABLET ],
        'MOMO9-3'                                   => [ 'Ployer', 'MOMO9 III', DeviceType::TABLET ],
        'MOMO9-3S'                                  => [ 'Ployer', 'MOMO9 III', DeviceType::TABLET ],
        'MOMO9 Plus-3'                              => [ 'Ployer', 'MOMO9 III', DeviceType::TABLET ],
        'MOMO9 3GQ'                                 => [ 'Ployer', 'MOMO9 3GQ', DeviceType::TABLET ],
        'MOMO11'                                    => [ 'Ployer', 'MOMO11', DeviceType::TABLET ],
        'MOMO11 III'                                => [ 'Ployer', 'MOMO11 III', DeviceType::TABLET ],
        'MOMO11-3'                                  => [ 'Ployer', 'MOMO11 III', DeviceType::TABLET ],
        'MOMO11 bird'                               => [ 'Ployer', 'MOMO11 Bird', DeviceType::TABLET ],
        'MOMO11bird3'                               => [ 'Ployer', 'MOMO11 Bird 3', DeviceType::TABLET ],
        'MOMO11 bird3'                              => [ 'Ployer', 'MOMO11 Bird 3', DeviceType::TABLET ],
        'MOMO11Master'                              => [ 'Ployer', 'MOMO11 Master', DeviceType::TABLET ],
        'MOMO11Speed'                               => [ 'Ployer', 'MOMO11 Speed', DeviceType::TABLET ],
        'MOMO11speed3'                              => [ 'Ployer', 'MOMO11 Speed 3', DeviceType::TABLET ],
        'MOMO12'                                    => [ 'Ployer', 'MOMO12', DeviceType::TABLET ],
        'MOMO15'                                    => [ 'Ployer', 'MOMO15', DeviceType::TABLET ],
        'MOMO19'                                    => [ 'Ployer', 'MOMO19', DeviceType::TABLET ],
        'MOMO19HD'                                  => [ 'Ployer', 'MOMO19 HD', DeviceType::TABLET ],
        'MOMO20'                                    => [ 'Ployer', 'MOMO20', DeviceType::TABLET ],
        'MOMO20-AU'                                 => [ 'Ployer', 'MOMO20', DeviceType::TABLET ],
        'MOMO20S'                                   => [ 'Ployer', 'MOMO20', DeviceType::TABLET ],
    ],

    'PocketBook A7'                             => [ 'PocketBook', 'A7', DeviceType::TABLET ],
    'PocketBook A10'                            => [ 'PocketBook', 'A10', DeviceType::TABLET ],
    'PocketBook A10 3G'                         => [ 'PocketBook', 'A10 3G', DeviceType::TABLET ],
    'Obreey SURFpad'                            => [ 'PocketBook', 'SURFpad', DeviceType::TABLET ],
    'PocketBook SURFpad2'                       => [ 'PocketBook', 'SURFpad 2', DeviceType::TABLET ],
    'PocketBook SURFpad 3 (7,85")'              => [ 'PocketBook', 'SURFpad 3', DeviceType::TABLET ],
    'PocketBook SURFpad 4 S'                    => [ 'PocketBook', 'SURFpad 4 S', DeviceType::TABLET ],
    'PocketBook SURFpad 4 M'                    => [ 'PocketBook', 'SURFpad 4 M', DeviceType::TABLET ],
    'PocketBook SURFpad 4 L'                    => [ 'PocketBook', 'SURFpad 4 L', DeviceType::TABLET ],
    'MOB-5045'                                  => [ 'Point Of View', 'Mobii Phone 5045' ],
    'Mobii 7'                                   => [ 'Point Of View', 'Mobii 7', DeviceType::TABLET ],
    'POV-Mobii-7'                               => [ 'Point Of View', 'Mobii 7', DeviceType::TABLET ],
    'POV Mobii 7'                               => [ 'Point Of View', 'Mobii 7', DeviceType::TABLET ],
    'POV TAB-P506!'                             => [ 'Point Of View', 'Mobii 506', DeviceType::TABLET ],
    'POV TAB-P517!'                             => [ 'Point Of View', 'Mobii 517', DeviceType::TABLET ],
    'POV TAB-P527!'                             => [ 'Point Of View', 'Mobii 527', DeviceType::TABLET ],
    'POV TAB-P629!'                             => [ 'Point Of View', 'Mobii 629', DeviceType::TABLET ],
    'POV TAB-P701!'                             => [ 'Point Of View', 'Mobii 701', DeviceType::TABLET ],
    'POV TAB-P703!'                             => [ 'Point Of View', 'Mobii 703', DeviceType::TABLET ],
    'POV TAB-P720!'                             => [ 'Point Of View', 'Mobii 720', DeviceType::TABLET ],
    'POV TAB-P721A!'                            => [ 'Point Of View', 'Mobii 721A', DeviceType::TABLET ],
    'POV TAB-P721!'                             => [ 'Point Of View', 'Mobii 721', DeviceType::TABLET ],
    'POV TAB-P722C!'                            => [ 'Point Of View', 'Mobii 722C', DeviceType::TABLET ],
    'POV TAB-P731N!'                            => [ 'Point Of View', 'Mobii 731N', DeviceType::TABLET ],
    'POV TAB-P825!'                             => [ 'Point Of View', 'Mobii 825', DeviceType::TABLET ],
    'POV TAB-P925!'                             => [ 'Point Of View', 'Mobii 925', DeviceType::TABLET ],
    'POV TAB-PR945!'                            => [ 'Point Of View', 'Mobii 945 HD+', DeviceType::TABLET ],
    'POV TAB-P1025!'                            => [ 'Point Of View', 'Mobii 1025', DeviceType::TABLET ],
    'POV TAB-P1030!'                            => [ 'Point Of View', 'Mobii 1030', DeviceType::TABLET ],
    'POV TAB-PI1045!'                           => [ 'Point Of View', 'Mobii 1045', DeviceType::TABLET ],
    'POV TAB-P1325!'                            => [ 'Point Of View', 'Mobii 1325', DeviceType::TABLET ],
    'PlayTabPro'                                => [ 'Point Of View', 'PlayTabPro', DeviceType::TABLET ],
    '(POV )?TAB-PLAYTABPRO!'                    => [ 'Point Of View', 'PlayTabPro', DeviceType::TABLET ],
    '(POV )?TAB-PROTAB25!'                      => [ 'Point Of View', 'ProTab 25', DeviceType::TABLET ],
    '(POV )?TAB-PROTAB26!'                      => [ 'Point Of View', 'ProTab 26', DeviceType::TABLET ],
    'POV TAB-PROTAB27'                          => [ 'Point Of View', 'ProTab 27', DeviceType::TABLET ],
    '(POV )?TAB-PROTAB30!'                      => [ 'Point Of View', 'ProTab 30', DeviceType::TABLET ],
    'TAB-PROTAB2-IPS9'                          => [ 'Point Of View', 'ProTab2', DeviceType::TABLET ],
    'TAB-PROTAB2-IPS-3G'                        => [ 'Point Of View', 'ProTab2', DeviceType::TABLET ],
    'TAB-PROTAB2-IPS-16'                        => [ 'Point Of View', 'ProTab2', DeviceType::TABLET ],
    'TAB-PROTAB2.4'                             => [ 'Point Of View', 'ProTab2 4', DeviceType::TABLET ],
    'TAB-PROTAB2XL'                             => [ 'Point Of View', 'ProTab2 XL', DeviceType::TABLET ],
    'TAB-PROTAB2.4XL'                           => [ 'Point Of View', 'ProTab2 XL 4', DeviceType::TABLET ],
    'PROTAB2XXL'                                => [ 'Point Of View', 'ProTab2 XXL', DeviceType::TABLET ],
    'TAB-PROTAB2XXL'                            => [ 'Point Of View', 'ProTab2 XXL', DeviceType::TABLET ],
    'TAB-PROTAB2XXL(4)'                         => [ 'Point Of View', 'ProTab2 XXL', DeviceType::TABLET ],
    '(POV )?TAB-PROTAB2XXL(4)!'                 => [ 'Point Of View', 'ProTab2 XXL', DeviceType::TABLET ],
    '(POV )?TAB NAVI7 3G M!'                    => [ 'Point Of View', 'Onyx 507', DeviceType::TABLET ],
    'POV_TAB-NAVI7-3G-M'                        => [ 'Point Of View', 'Onyx 507', DeviceType::TABLET ],
    'POV TAB-P547(v1.0)'                        => [ 'Point Of View', 'Onyx 547', DeviceType::TABLET ],
    'POV TV-HDMI-200BT'                         => [ 'Point Of View', 'Smart TV', DeviceType::TELEVISION ],
    'POV TV-HDMI-200BT(V2.0)'                   => [ 'Point Of View', 'Smart TV', DeviceType::TELEVISION ],
    'POV TV-HDMI-210'                           => [ 'Point Of View', 'Smart TV', DeviceType::TELEVISION ],
    'POV TV-HDMI-KB-01'                         => [ 'Point Of View', 'Smart TV', DeviceType::TELEVISION ],
    'POV TV-SMARTTV-500'                        => [ 'Point Of View', 'Smart TV', DeviceType::TELEVISION ],

    'MID[C012]!!' => [
        'MIDC409'                                   => [ 'Polaroid', 'Diamond III 9', DeviceType::TABLET ],
        'MIDC410'                                   => [ 'Polaroid', 'Diamond 10.1', DeviceType::TABLET ],
        'MID2407'                                   => [ 'Polaroid', 'Infinite 7', DeviceType::TABLET ],
        'MID1014'                                   => [ 'Polaroid', 'Pearl 10.1', DeviceType::TABLET ],
        'MID1047'                                   => [ 'Polaroid', 'Platinum 10.1', DeviceType::TABLET ],
        'MIDC407'                                   => [ 'Polaroid', 'Rainbow 7', DeviceType::TABLET ],
        'MID0714'                                   => [ 'Polaroid', 'MID0714', DeviceType::TABLET ],
        'MID0714PCE01'                              => [ 'Polaroid', 'MID0714', DeviceType::TABLET ],
        'MID0714PGE02.133'                          => [ 'Polaroid', 'MID0714', DeviceType::TABLET ],
        'MIDC010PR001'                              => [ 'Polaroid', 'MIDC010', DeviceType::TABLET ],
        'MIDC110'                                   => [ 'Polaroid', 'MIDC110', DeviceType::TABLET ],
        'MIDC124'                                   => [ 'Polaroid', 'MIDC124', DeviceType::TABLET ],
        'MIDC127'                                   => [ 'Polaroid', 'MIDC127', DeviceType::TABLET ],
        'MIDC128'                                   => [ 'Polaroid', 'MIDC128', DeviceType::TABLET ],
        'MIDC408'                                   => [ 'Polaroid', 'MIDC408', DeviceType::TABLET ],
        'MIDC408PR002'                              => [ 'Polaroid', 'MIDC408', DeviceType::TABLET ],
        'MIDC410PR'                                 => [ 'Polaroid', 'MIDC410', DeviceType::TABLET ],
        'MIDC430'                                   => [ 'Polaroid', 'MIDC430', DeviceType::TABLET ],
        'MIDC497'                                   => [ 'Polaroid', 'MIDC497', DeviceType::TABLET ],
        'MIDC700PR001'                              => [ 'Polaroid', 'MIDC700', DeviceType::TABLET ],
        'MIDC800PR001'                              => [ 'Polaroid', 'MIDC800', DeviceType::TABLET ],
        'MIDC801'                                   => [ 'Polaroid', 'MIDC801', DeviceType::TABLET ],
        'MIDC802'                                   => [ 'Polaroid', 'MIDC802', DeviceType::TABLET ],
        'MIDC901'                                   => [ 'Polaroid', 'MIDC901', DeviceType::TABLET ],
        'MIDC970'                                   => [ 'Polaroid', 'MIDC970', DeviceType::TABLET ],
        'MIDCD10'                                   => [ 'Polaroid', 'MIDCD10', DeviceType::TABLET ],
        'MIDCD97'                                   => [ 'Polaroid', 'MIDCD97', DeviceType::TABLET ],
    ],

    'PMID!!' => [
        'PMID70C'                                   => [ 'Polaroid', 'PMID 70c', DeviceType::TABLET ],
        'PMID70DC'                                  => [ 'Polaroid', 'PMID 70dc', DeviceType::TABLET ],
        'PMID71C'                                   => [ 'Polaroid', 'PMID 71c', DeviceType::TABLET ],
        'PMID80C'                                   => [ 'Polaroid', 'PMID 80c', DeviceType::TABLET ],
        'PMID700'                                   => [ 'Polaroid', 'PMID 700', DeviceType::TABLET ],
        'PMID700BF'                                 => [ 'Polaroid', 'PMID 700bf', DeviceType::TABLET ],
        'PMID701C'                                  => [ 'Polaroid', 'PMID 701c', DeviceType::TABLET ],
        'PMID701DC'                                 => [ 'Polaroid', 'PMID 701dc', DeviceType::TABLET ],
        'PMID702DC'                                 => [ 'Polaroid', 'PMID 702dc', DeviceType::TABLET ],
        'PMID703C'                                  => [ 'Polaroid', 'PMID 703c', DeviceType::TABLET ],
        'PMID703DC'                                 => [ 'Polaroid', 'PMID 703dc', DeviceType::TABLET ],
        'PMID703GK'                                 => [ 'Polaroid', 'PMID 703gk', DeviceType::TABLET ],
        'PMID704G'                                  => [ 'Polaroid', 'PMID 704g', DeviceType::TABLET ],
        'PMID704GK'                                 => [ 'Polaroid', 'PMID 704gk', DeviceType::TABLET ],
        'PMID705'                                   => [ 'Polaroid', 'PMID 705', DeviceType::TABLET ],
        'PMID705X'                                  => [ 'Polaroid', 'PMID 705x', DeviceType::TABLET ],
        'PMID706'                                   => [ 'Polaroid', 'PMID 706', DeviceType::TABLET ],
        'PMID720'                                   => [ 'Polaroid', 'PMID 720', DeviceType::TABLET ],
        'PMID800'                                   => [ 'Polaroid', 'PMID 800', DeviceType::TABLET ],
        'PMID901'                                   => [ 'Polaroid', 'PMID 901', DeviceType::TABLET ],
        'PMID920'                                   => [ 'Polaroid', 'PMID 920', DeviceType::TABLET ],
        'PMID-973G'                                 => [ 'Polaroid', 'PMID 973g', DeviceType::TABLET ],
        'PMID1000B'                                 => [ 'Polaroid', 'PMID 1000b', DeviceType::TABLET ],
        'PMID1000B V2'                              => [ 'Polaroid', 'PMID 1000b', DeviceType::TABLET ],
        'PMID-1000DC'                               => [ 'Polaroid', 'PMID 1000dc', DeviceType::TABLET ],
        'PMID1000!'                                 => [ 'Polaroid', 'PMID 1000', DeviceType::TABLET ],
        'PMID4311'                                  => [ 'Polaroid', 'PMID 4311', DeviceType::TABLET ],
        'PMID4312'                                  => [ 'Polaroid', 'PMID 4312', DeviceType::TABLET ],
    ],

    'PSPT350'                                   => [ 'Polaroid', 'PSPT350' ],
    'Polaroid PSPT401'                          => [ 'Polaroid', 'Turbo 401' ],
    'Polaroid PSPC505'                          => [ 'Polaroid', 'Cosmo 505' ],
    'Polaroid P4005A'                           => [ 'Polaroid', 'P4005A' ],

    'PROV!!' => [
        'PROV350'                                   => [ 'Polaroid', 'PROV350' ],
        'PROV400'                                   => [ 'Polaroid', 'PROV400' ],
    ],

    'PRO!!' => [
        'PRO400B'                                   => [ 'Polaroid', 'PRO400B' ],
        'PRO450B'                                   => [ 'Polaroid', 'PRO450B' ],
        'PRO4006'                                   => [ 'Polaroid', 'PRO4006' ],
        'PRO4611PR201'                              => [ 'Polaroid', 'PRO4611' ],
        'PRO5701'                                   => [ 'Polaroid', 'PRO5701' ],
        'PRO7111'                                   => [ 'Polaroid', 'PRO7111' ],
        ],

    'POLY ?PAD!!' => [
        'POLY PAD 8208HD'                           => [ 'Polypad', '8208 HD', DeviceType::TABLET ],
        'POLY PAD 8216HD'                           => [ 'Polypad', '8216 HD', DeviceType::TABLET ],
        'POLY PAD 9708HD'                           => [ 'Polypad', '9708 HD', DeviceType::TABLET ],
        'POLY PAD 9716HD'                           => [ 'Polypad', '9716 HD', DeviceType::TABLET ],
        'Polypad C508'                              => [ 'Polypad', 'C508', DeviceType::TABLET ],
    ],

    'POLYTRON!!' => [
        'POLYTRON L501'                             => [ 'Polytron', 'L501 Rocket 4G C1' ],
        'POLYTRON P520'                             => [ 'Polytron', 'P520 Prime 7s' ],
        'POLYTRON R1500'                            => [ 'Polytron', 'R1500 Rocket Q-Five' ],
        'POLYTRON R2403'                            => [ 'Polytron', 'R2403 Rocket R1' ],
        'POLYTRON R2406'                            => [ 'Polytron', 'R2406 Rocket R2' ],
        'POLYTRON R2407'                            => [ 'Polytron', 'R2407 Rocket R3' ],
        'POLYTRON R2452'                            => [ 'Polytron', 'R2452 Rocket S1' ],
        'POLYTRON-R2457'                            => [ 'Polytron', 'R2457 Rocket S2' ],
        'POLYTRON R2501'                            => [ 'Polytron', 'R2501 Rocket T1' ],
        'POLYTRON-R2507'                            => [ 'Polytron', 'R2507 Rocket T3' ],
        'POLYTRON R2506'                            => [ 'Polytron', 'R2506 Rocket T4' ],
        'POLYTRON R3450'                            => [ 'Polytron', 'R3450 Rocket Jetz' ],
        'POLYTRON R3500'                            => [ 'Polytron', 'R3500 Jetz 5.0' ],
        'POLYTRON S2350'                            => [ 'Polytron', 'S2350 Rocket' ],
        'POLYTRON T7800'                            => [ 'Polytron', 'T7800 Cosmica' ],
        'Polytron W1320'                            => [ 'Polytron', 'W1320' ],
        'POLYTRON W1400'                            => [ 'Polytron', 'W1400 Rocket Jetz 4.0' ],
        'POLYTRON W2430'                            => [ 'Polytron', 'W2430 Wizard Twins' ],
        'POLYTRON W2500'                            => [ 'Polytron', 'W2500 Wizard Twins' ],
        'POLYTRON W3430'                            => [ 'Polytron', 'W3430 Wizard Crystal' ],
        'POLYTRON W6450'                            => [ 'Polytron', 'W6450 Rocket Star' ],
        'POLYTRON W7430'                            => [ 'Polytron', 'W7430 Wizard Quadra Mini' ],
        'POLYTRON W7450'                            => [ 'Polytron', 'W7450 Wizard Quadra' ],
        'POLYTRON W7451'                            => [ 'Polytron', 'W7451 Quadra S' ],
        'POLYTRON W7452'                            => [ 'Polytron', 'W7452 Quadra S2' ],
        'POLYTRON W7531'                            => [ 'Polytron', 'W7531 Wizard Quadra V' ],
        'POLYTRON W7550 LITE'                       => [ 'Polytron', 'W7550 Rocket Quadra Lite' ],
        'POLYTRON W8470'                            => [ 'Polytron', 'W8470 Wizard Quadra HD' ],
        'POLYTRON 4G551'                            => [ 'Polytron', '4G551 Zap 6 Posh Note' ],
    ],

    'POMP!!' => [
        'POMP C6'                                   => [ 'POMP', 'C6' ],
        'POMP P8'                                   => [ 'POMP', 'P8' ],
        'POMP W88'                                  => [ 'POMP', 'W88' ],
        'POMP-W88A'                                 => [ 'POMP', 'W88A' ],
        'POMP-W88S'                                 => [ 'POMP', 'W88S' ],
        'POMP W89'                                  => [ 'POMP', 'W89' ],
        'POMP-W89'                                  => [ 'POMP', 'W89' ],
        'POMP W99'                                  => [ 'POMP', 'W99' ],
        'POMP W99A'                                 => [ 'POMP', 'W99A' ],
    ],

    'ACT2000'                                   => [ 'Poptronix', 'ACT2000', DeviceType::TABLET ],

    'Air!!' => [
        'Air 7.85 3G'                               => [ 'Roverpad', 'Air 7.85 3G', DeviceType::TABLET ],
        'Air 10.1 3G'                               => [ 'Roverpad', 'Air 10.1 3G', DeviceType::TABLET ],
        'Air S70'                                   => [ 'Roverpad', 'Air S70', DeviceType::TABLET ],
    ],

    'PMP[0-9]{4,4}!!' => [
        'PMP3007C'                                  => [ 'Prestigio', 'Multipad Rider 7.0', DeviceType::TABLET ],
        'PMP3007C3G'                                => [ 'Prestigio', 'Multipad Rider 7.0 3G', DeviceType::TABLET ],
        'PMP3074B'                                  => [ 'Prestigio', 'Multipad 3074', DeviceType::TABLET ],
        'PMP3074BRU'                                => [ 'Prestigio', 'Multipad 3074', DeviceType::TABLET ],
        'PMP3084B'                                  => [ 'Prestigio', 'Multipad 3084', DeviceType::TABLET ],
        'PMP3084BA'                                 => [ 'Prestigio', 'Multipad 3084', DeviceType::TABLET ],
        'PMP3084BPL'                                => [ 'Prestigio', 'Multipad 3084', DeviceType::TABLET ],
        'PMP3084BRU'                                => [ 'Prestigio', 'Multipad 3084', DeviceType::TABLET ],
        'PMP3170B'                                  => [ 'Prestigio', 'Multipad 3170 Pro', DeviceType::TABLET ],
        'PMP3170BEN'                                => [ 'Prestigio', 'Multipad 3170 Pro', DeviceType::TABLET ],
        'PMP3270B'                                  => [ 'Prestigio', 'Multipad 3270 Prime', DeviceType::TABLET ],
        'PMP3370B'                                  => [ 'Prestigio', 'Multipad 3370', DeviceType::TABLET ],
        'PMP3384B'                                  => [ 'Prestigio', 'Multipad 3384', DeviceType::TABLET ],
        'PMP3384BRU'                                => [ 'Prestigio', 'Multipad 3384', DeviceType::TABLET ],
        'PMP3470B'                                  => [ 'Prestigio', 'Multipad 3470 Prime+', DeviceType::TABLET ],
        'PMP3570C'                                  => [ 'Prestigio', 'Multipad 7.0 Ultra+', DeviceType::TABLET ],
        'PMP3670B'                                  => [ 'Prestigio', 'Multipad 3670 Ultra+', DeviceType::TABLET ],
        'PMP3670B-WH'                               => [ 'Prestigio', 'Multipad 3670 Ultra+', DeviceType::TABLET ],
        'PMP3770B'                                  => [ 'Prestigio', 'Multipad 3770', DeviceType::TABLET ],
        'PMP3970B'                                  => [ 'Prestigio', 'Multipad 3970 Duo', DeviceType::TABLET ],
        'PMP5080B'                                  => [ 'Prestigio', 'Multipad 5080', DeviceType::TABLET ],
        'PMP5080BRU'                                => [ 'Prestigio', 'Multipad 5080', DeviceType::TABLET ],
        'PMP5080CPRO'                               => [ 'Prestigio', 'Multipad 5080 Pro', DeviceType::TABLET ],
        'PMP5097CPRO'                               => [ 'Prestigio', 'Multipad 5097 Pro', DeviceType::TABLET ],
        'PMP5101C QUAD'                             => [ 'Prestigio', 'Multipad 4 Quantum 10.1', DeviceType::TABLET ],
        'PMP5101C3G QUAD'                           => [ 'Prestigio', 'Multipad 4 Quantum 10.1 3G', DeviceType::TABLET ],
        'PMP5101D QUAD'                             => [ 'Prestigio', 'Multipad 4 Quantum 10.1', DeviceType::TABLET ],
        'PMP5101D3G QUAD'                           => [ 'Prestigio', 'Multipad 4 Quantum 10.1 3G', DeviceType::TABLET ],
        'PMP5197DULTRA'                             => [ 'Prestigio', 'Multipad 5197 Ultra', DeviceType::TABLET ],
        'PMP5297C QUAD'                             => [ 'Prestigio', 'Multipad 4 Quantum 9.7', DeviceType::TABLET ],
        'PMP5570C'                                  => [ 'Prestigio', 'Multipad 5570 Pro', DeviceType::TABLET ],
        'PMP5580C'                                  => [ 'Prestigio', 'Multipad 5580 Prime', DeviceType::TABLET ],
        'PMP5588C'                                  => [ 'Prestigio', 'Multipad 8.0 HD', DeviceType::TABLET ],
        'PMP5597D'                                  => [ 'Prestigio', 'Multipad 5597 Ultra Duo', DeviceType::TABLET ],
        'PMP5670C DUO'                              => [ 'Prestigio', 'Multipad 2 Pro Duo 7.0', DeviceType::TABLET ],
        'PMP5770D'                                  => [ 'Prestigio', 'Multipad 5770 Pro', DeviceType::TABLET ],
        'PMP5785C3G QUAD'                           => [ 'Prestigio', 'Multipad 4 Quantum 7.85 3G', DeviceType::TABLET ],
        'PMP7100D3G QUAD'                           => [ 'Prestigio', 'Multipad 7100', DeviceType::TABLET ],
        'PMP7280D3G QUAD'                           => [ 'Prestigio', 'Multipad 7280', DeviceType::TABLET ],
        'PMP7480D3G QUAD'                           => [ 'Prestigio', 'Multipad 7480', DeviceType::TABLET ],
        'PMP7880D3G'                                => [ 'Prestigio', 'Multipad 7880', DeviceType::TABLET ],
        'PMP5780D'                                  => [ 'Prestigio', 'Multipad 2 Prime Duo 8.0', DeviceType::TABLET ],
        'PMP5785C QUAD'                             => [ 'Prestigio', 'Multipad 4 Quantum 7.85', DeviceType::TABLET ],
        'PMP5870C'                                  => [ 'Prestigio', 'Multipad 7.0 Ultra Duo', DeviceType::TABLET ],
        'PMP5880D'                                  => [ 'Prestigio', 'Multipad 8.0 Ultra Duo', DeviceType::TABLET ],
        'PMP7070C3G'                                => [ 'Prestigio', 'Multipad 4 Diamond 7.0 3G', DeviceType::TABLET ],
        'PMP7074B3G'                                => [ 'Prestigio', 'Multipad 7074', DeviceType::TABLET ],
        'PMP7074B3GRU'                              => [ 'Prestigio', 'Multipad 7074', DeviceType::TABLET ],
        'PMP7079D QUAD'                             => [ 'Prestigio', 'Multipad 4 Diamond 7.85', DeviceType::TABLET ],
        'PMP7079D3G QUAD'                           => [ 'Prestigio', 'Multipad 4 Diamond 7.85 3G', DeviceType::TABLET ],
        'PMP7079E3G QUAD'                           => [ 'Prestigio', 'Multipad 4 Diamond 7.85 3G', DeviceType::TABLET ],
        'PMP7100D'                                  => [ 'Prestigio', 'Multipad 4 10.1 Ultimate', DeviceType::TABLET ],
        'PMP7100D3G'                                => [ 'Prestigio', 'Multipad 4 10.1 Ultimate 3G', DeviceType::TABLET ],
        'PMP7100D3G QUAD'                           => [ 'Prestigio', 'Multipad 4 10.1 Ultimate 3G', DeviceType::TABLET ],
        'PMP7110D3G'                                => [ 'Prestigio', 'Multipad 4 Diamond 10.1 3G', DeviceType::TABLET ],
        'PMP7170B3G'                                => [ 'Prestigio', 'Multipad 7.0 Prime 3G', DeviceType::TABLET ],
        'PMP7170B3GCE'                              => [ 'Prestigio', 'Multipad 7.0 Prime 3G', DeviceType::TABLET ],
        'PMP7170B3G DUO'                            => [ 'Prestigio', 'Multipad 7.0 Prime Duo 3G', DeviceType::TABLET ],
        'PMP7280C'                                  => [ 'Prestigio', 'Multipad 2 Ultra Duo 8.0', DeviceType::TABLET ],
        'PMP7280C3G'                                => [ 'Prestigio', 'Multipad 2 Ultra Duo 8.0 3G', DeviceType::TABLET ],
        'PMP7280C3G DUO'                            => [ 'Prestigio', 'Multipad 2 Ultra Duo 8.0 3G', DeviceType::TABLET ],
        'PMP7280C3G QUAD'                           => [ 'Prestigio', 'Multipad 4 Ultra Quad 8.0 3G', DeviceType::TABLET ],
        'PMP7380D3G'                                => [ 'Prestigio', 'Multipad 2 Pro Duo 8.0 3G', DeviceType::TABLET ],
        'PMP7380D3G QUAD'                           => [ 'Prestigio', 'Multipad 2 Pro Quad 8.0 3G', DeviceType::TABLET ],
    ],

    'PMT[0-9]{4,4}!!' => [
        'PMT3008 WI C'                              => [ 'Prestigio', 'Multipad Wize 3008', DeviceType::TABLET ],
        'PMT3009 Wi C'                              => [ 'Prestigio', 'Multipad Wize 3009', DeviceType::TABLET ],
        'PMT3011 3G'                                => [ 'Prestigio', 'Multipad Wize 3011', DeviceType::TABLET ],
        'PMT3017 WI'                                => [ 'Prestigio', 'Multipad Wize 3017', DeviceType::TABLET ],
        'PMT3018 WI'                                => [ 'Prestigio', 'Multipad Wize 3018', DeviceType::TABLET ],
        'PMT3021 3G'                                => [ 'Prestigio', 'Multipad Wize 3021', DeviceType::TABLET ],
        'PMT3031 3G'                                => [ 'Prestigio', 'Multipad Wize 3031', DeviceType::TABLET ],
        'PMT3037 3G'                                => [ 'Prestigio', 'Multipad Wize 3037', DeviceType::TABLET ],
        'PMT3038 3G'                                => [ 'Prestigio', 'Multipad Wize 3038', DeviceType::TABLET ],
        'PMT3047 3G'                                => [ 'Prestigio', 'Multipad 3047', DeviceType::TABLET ],
        'PMT3077 3G'                                => [ 'Prestigio', 'Multipad Rider 7.0 3G', DeviceType::TABLET ],
        'PMT3108 3G'                                => [ 'Prestigio', 'Multipad Wize 3108', DeviceType::TABLET ],
        'PMT3111 Wi'                                => [ 'Prestigio', 'Multipad Wize 3111', DeviceType::TABLET ],
        'PMT3177 3G'                                => [ 'Prestigio', 'Multipad Journey 7.0 3G', DeviceType::TABLET ],
        'PMT3277 3G'                                => [ 'Prestigio', 'Multipad Ranger 7.0 3G', DeviceType::TABLET ],
        'PMT3287 3G'                                => [ 'Prestigio', 'Multipad Ranger 8.0 3G', DeviceType::TABLET ],
        'PMT3308 3G'                                => [ 'Prestigio', 'Multipad Wize 3308', DeviceType::TABLET ],
        'PMT3331 3G'                                => [ 'Prestigio', 'Multipad Wize 3331', DeviceType::TABLET ],
        'PMT3341 3G'                                => [ 'Prestigio', 'Multipad Wize 3341', DeviceType::TABLET ],
        'PMT3377 Wi'                                => [ 'Prestigio', 'Multipad Thunder 7.0i', DeviceType::TABLET ],
        'PMT3677 Wi'                                => [ 'Prestigio', 'Multipad Ultra+ 7.0', DeviceType::TABLET ],
        'PMT3757 3G'                                => [ 'Prestigio', 'Multipad Wize 3757', DeviceType::TABLET ],
        'PMT3777 3G'                                => [ 'Prestigio', 'Multipad Color 2 3G', DeviceType::TABLET ],
        'PMT3787 3G'                                => [ 'Prestigio', 'Multipad Wize 3787', DeviceType::TABLET ],
        'PMT5001 3G'                                => [ 'Prestigio', 'Multipad Muze 5001 3G', DeviceType::TABLET ],
        'PMT5002 Wi'                                => [ 'Prestigio', 'Multipad Wize 5002', DeviceType::TABLET ],
        'PMT5008 3G'                                => [ 'Prestigio', 'Multipad Muze 5008 3G', DeviceType::TABLET ],
        'PMT5287 4G'                                => [ 'Prestigio', 'Multipad Ranger 8.0 4G', DeviceType::TABLET ],
        'PMT5487 3G'                                => [ 'Prestigio', 'Multipad Quantum 8.0 3G', DeviceType::TABLET ],
        'PMT5587 Wi'                                => [ 'Prestigio', 'Multipad 8.0 HD', DeviceType::TABLET ],
        'PMT5777 3G'                                => [ 'Prestigio', 'Multipad Color 7.0 3G', DeviceType::TABLET ],
        'PMT5887 3G'                                => [ 'Prestigio', 'Multipad Color 8.0 3G', DeviceType::TABLET ],
        'PMT7008 4G'                                => [ 'Prestigio', 'Multipad Consul 7008 4G', DeviceType::TABLET ],
        'PMT7077 3G'                                => [ 'Prestigio', 'Multipad 4 Diamond 7.85 3G', DeviceType::TABLET ],
        'PMT7177 3G'                                => [ 'Prestigio', 'Multipad 4 Diamond 10.1 3G', DeviceType::TABLET ],
        'PMT7287 3G'                                => [ 'Prestigio', 'Multipad 4 Ultra Quad 8.0 3G', DeviceType::TABLET ],
    ],

    'PAP[0-9]{4,4}!!' => [
        'PAP3350DUO'                                => [ 'Prestigio', 'Multiphone 3350 Duo' ],
        'PAP3400DUO'                                => [ 'Prestigio', 'Multiphone 3400 Duo' ],
        'PAP3500 DUO'                               => [ 'Prestigio', 'Multiphone 3500 Duo' ],
        'PAP3501DUO'                                => [ 'Prestigio', 'Multiphone 3501 Duo' ],
        'PAP3540DUO'                                => [ 'Prestigio', 'Multiphone 3540 Duo' ],
        'PAP4020DUO'                                => [ 'Prestigio', 'Multiphone 4020 Duo' ],
        'PAP4040 DUO'                               => [ 'Prestigio', 'Multiphone 4040 Duo' ],
        'PAP4044DUO'                                => [ 'Prestigio', 'Multiphone 4044 Duo' ],
        'PAP4055DUO'                                => [ 'Prestigio', 'Multiphone 4055 Duo' ],
        'PAP4300'                                   => [ 'Prestigio', 'Multiphone 4300' ],
        'PAP4300 DUO'                               => [ 'Prestigio', 'Multiphone 4300 Duo' ],
        'PAP4322DUO'                                => [ 'Prestigio', 'Multiphone 4322 Duo' ],
        'PAP4500DUO'                                => [ 'Prestigio', 'Multiphone 4500 Duo' ],
        'PAP4500TDUO'                               => [ 'Prestigio', 'Multiphone 4500 Duo' ],
        'PAP4505DUO'                                => [ 'Prestigio', 'Multiphone 4505 Duo' ],
        'PAP5000DUO'                                => [ 'Prestigio', 'Multiphone 5000 Duo' ],
        'PAP5000TDUO'                               => [ 'Prestigio', 'Multiphone 5000 Duo' ],
        'PAP5044DUO'                                => [ 'Prestigio', 'Multiphone 5044 Duo' ],
        'PAP5300DUO'                                => [ 'Prestigio', 'Multiphone 5300 Duo' ],
        'PAP5400DUO'                                => [ 'Prestigio', 'Multiphone 5400 Duo' ],
        'PAP5430'                                   => [ 'Prestigio', 'Multiphone 5430' ],
        'PAP5450'                                   => [ 'Prestigio', 'Multiphone 5450' ],
        'PAP5450DUO'                                => [ 'Prestigio', 'Multiphone 5450 Duo' ],
        'PAP5451DUO'                                => [ 'Prestigio', 'Multiphone 5451 Duo' ],
        'PAP5500DUO'                                => [ 'Prestigio', 'Multiphone 5500 Duo' ],
        'PAP5501'                                   => [ 'Prestigio', 'Multiphone 5501' ],
        'PAP5503'                                   => [ 'Prestigio', 'Multiphone 5503' ],
        'PAP5503DUO'                                => [ 'Prestigio', 'Multiphone 5503 Duo' ],
        'PAP7500'                                   => [ 'Prestigio', 'Multiphone 7500' ],
        'PAP7600DUO'                                => [ 'Prestigio', 'Multiphone 7600 Duo' ],
    ],

    'PSP[0-9]{4,4}!!' => [
        'PSP3404DUO'                                => [ 'Prestigio', 'Multiphone 3404 Duo' ],
        'PSP3405DUO'                                => [ 'Prestigio', 'Multiphone 3405 Duo' ],
        'PSP3450'                                   => [ 'Prestigio', 'Multiphone 3450' ],
        'PSP3450DUO'                                => [ 'Prestigio', 'Multiphone 3450 Duo' ],
        'PSP3452DUO'                                => [ 'Prestigio', 'Multiphone Muze A3' ],
        'PSP3453DUO'                                => [ 'Prestigio', 'Multiphone Wize A3' ],
        'PSP3455DUO'                                => [ 'Prestigio', 'Multiphone Grace X3' ],
        'PSP3456DUO'                                => [ 'Prestigio', 'Multiphone 3456 Duo' ],
        'PSP3502DUO'                                => [ 'Prestigio', 'Multiphone 3502 Duo' ],
        'PSP3503DUO'                                => [ 'Prestigio', 'Multiphone 3503 Duo' ],
        'PSP3504DUO'                                => [ 'Prestigio', 'Multiphone 3504 Duo' ],
        'PSP3505DUO'                                => [ 'Prestigio', 'Multiphone 3505 Duo' ],
        'PSP3530DUO'                                => [ 'Prestigio', 'Multiphone 3530 Duo' ],
        'PSP3531DUO'                                => [ 'Prestigio', 'Multiphone 3531 Duo' ],
        'PSP5047DUO'                                => [ 'Prestigio', 'Multiphone 5048 Duo' ],
        'PSP5307DUO'                                => [ 'Prestigio', 'Multiphone 5307 Duo' ],
        'PSP5453DUO'                                => [ 'Prestigio', 'Multiphone 5453 Duo' ],
        'PSP5454DUO'                                => [ 'Prestigio', 'Multiphone 5454 Duo' ],
        'PSP5455DUO'                                => [ 'Prestigio', 'Multiphone 5455 Duo' ],
        'PSP5457DUO'                                => [ 'Prestigio', 'Multiphone 5457 Duo' ],
        'PSP5470DUO'                                => [ 'Prestigio', 'Multiphone Grace X5' ],
        'PSP5504DUO'                                => [ 'Prestigio', 'Multiphone 5504 Duo' ],
        'PSP5505DUO'                                => [ 'Prestigio', 'Multiphone 5505 Duo' ],
        'PSP5507DUO'                                => [ 'Prestigio', 'Multiphone 5507 Duo' ],
        'PSP5508DUO'                                => [ 'Prestigio', 'Multiphone 5508 Duo' ],
        'PSP5517DUO'                                => [ 'Prestigio', 'Multiphone 5517 Duo' ],
        'PSP5550DUO'                                => [ 'Prestigio', 'Multiphone 5550 Duo' ],
        'PSP7505DUO'                                => [ 'Prestigio', 'Multiphone Grace X7' ],
        'PSP7557'                                   => [ 'Prestigio', 'Multiphone 7557 Grace' ],
    ],

    'Prestigio PAP5000TDUO'                     => [ 'Prestigio', 'Multiphone 5000 Duo' ],
    '5080C Pro'                                 => [ 'Prestigio', 'Multipad 5080 Pro', DeviceType::TABLET ],
    'PRBT 100'                                  => [ 'Probook', 'PRBT 100', DeviceType::TABLET ],

    'MD-[0-9]{4,4}!!' => [
        'MD-0651'                                   => [ 'Prolink', 'MD-0651', DeviceType::TABLET ],
        'MD-0696B'                                  => [ 'Prolink', 'MD-0696B', DeviceType::TABLET ],
        'MD-0697'                                   => [ 'Prolink', 'MD-0697', DeviceType::TABLET ],
    ],

    'PLT!!' => [
        'PLT1044'                                   => [ 'Proscan', 'PLT1044', DeviceType::TABLET ],
        'PLT1066'                                   => [ 'Proscan', 'PLT1066', DeviceType::TABLET ],
        'PLT1077G'                                  => [ 'Proscan', 'PLT1077G', DeviceType::TABLET ],
        'PLT4311'                                   => [ 'Proscan', 'PLT4311', DeviceType::TABLET ],
        'PLT7035'                                   => [ 'Proscan', 'PLT7035', DeviceType::TABLET ],
        'PLT7035-B'                                 => [ 'Proscan', 'PLT7035', DeviceType::TABLET ],
        'PLT7035-C'                                 => [ 'Proscan', 'PLT7035', DeviceType::TABLET ],
        'PLT7035-PL'                                => [ 'Proscan', 'PLT7035', DeviceType::TABLET ],
        'PLT7044K'                                  => [ 'Proscan', 'PLT7044K', DeviceType::TABLET ],
        'PLT7044K-B'                                => [ 'Proscan', 'PLT7044K', DeviceType::TABLET ],
        'PLT7050'                                   => [ 'Proscan', 'PLT7050', DeviceType::TABLET ],
        'PLT7100G'                                  => [ 'Proscan', 'PLT7100G', DeviceType::TABLET ],
        'PLT7223G'                                  => [ 'Proscan', 'PLT7223G', DeviceType::TABLET ],
        'PLT7602G'                                  => [ 'Proscan', 'PLT7602G', DeviceType::TABLET ],
        'PLT7777'                                   => [ 'Proscan', 'PLT7777', DeviceType::TABLET ],
        'PLT7802'                                   => [ 'Proscan', 'PLT7802', DeviceType::TABLET ],
        'PLT7803G'                                  => [ 'Proscan', 'PLT7803G', DeviceType::TABLET ],
        'PLT7804G'                                  => [ 'Proscan', 'PLT7804G', DeviceType::TABLET ],
        'PLT7810K'                                  => [ 'Proscan', 'PLT7810K', DeviceType::TABLET ],
        'PLT8088'                                   => [ 'Proscan', 'PLT8088', DeviceType::TABLET ],
        'PLT8223G'                                  => [ 'Proscan', 'PLT8223G', DeviceType::TABLET ],
        'PLT8235G'                                  => [ 'Proscan', 'PLT8235G', DeviceType::TABLET ],
        'PLT8802G'                                  => [ 'Proscan', 'PLT8802G', DeviceType::TABLET ],
        'PLT8816K'                                  => [ 'Proscan', 'PLT8816K', DeviceType::TABLET ],
        'PLT9045K'                                  => [ 'Proscan', 'PLT9045K', DeviceType::TABLET ],
        'PLT9045K-BLACK'                            => [ 'Proscan', 'PLT9045K', DeviceType::TABLET ],
        'PLT9602G'                                  => [ 'Proscan', 'PLT9602G', DeviceType::TABLET ],
        'PLT9606G'                                  => [ 'Proscan', 'PLT9606G', DeviceType::TABLET ],
    ],

    'Positivo Mini'                             => [ 'Positivo', 'Mini', DeviceType::TABLET ],
    'YPY-72SIM'                                 => [ 'Positivo', 'YPY 72SIM', DeviceType::TABLET ],
    'YPY-73G'                                   => [ 'Positivo', 'YPY 73G', DeviceType::TABLET ],
    'TB07FTA'                                   => [ 'Positivo', 'YPY 07FTA', DeviceType::TABLET ],
    'Ypy 7 - TB07FTA'                           => [ 'Positivo', 'YPY 07FTA', DeviceType::TABLET ],
    'YPY 07FTA'                                 => [ 'Positivo', 'YPY 07FTA', DeviceType::TABLET ],
    'YPY 07FTAB'                                => [ 'Positivo', 'YPY 07FTAB', DeviceType::TABLET ],
    'YPY 07FTAB PA'                             => [ 'Positivo', 'YPY 07FTAB', DeviceType::TABLET ],
    'YPY 07FTB'                                 => [ 'Positivo', 'YPY 07FTB', DeviceType::TABLET ],
    'POSITIVO YPY 07FTB'                        => [ 'Positivo', 'YPY 07FTB', DeviceType::TABLET ],
    'YPY 07FTBF'                                => [ 'Positivo', 'YPY 07FTBF', DeviceType::TABLET ],
    'Ypy 7 - TB07STA'                           => [ 'Positivo', 'YPY 07STA', DeviceType::TABLET ],
    'YPY 07STB'                                 => [ 'Positivo', 'YPY 07STB', DeviceType::TABLET ],
    'YPY 07STBF'                                => [ 'Positivo', 'YPY 07STBF', DeviceType::TABLET ],
    'YPY 10FTA'                                 => [ 'Positivo', 'YPY 10FTA', DeviceType::TABLET ],
    'YPY10FTA'                                  => [ 'Positivo', 'YPY 10FTA', DeviceType::TABLET ],
    'YPY 10FTB'                                 => [ 'Positivo', 'YPY 10FTB', DeviceType::TABLET ],
    'YPY 10FTBF'                                => [ 'Positivo', 'YPY 10FTBF', DeviceType::TABLET ],
    'YPY 10STB'                                 => [ 'Positivo', 'YPY 10STB', DeviceType::TABLET ],
    'YPY 10STBF'                                => [ 'Positivo', 'YPY 10STBF', DeviceType::TABLET ],
    'YPY AB7D'                                  => [ 'Positivo', 'YPY AB7D', DeviceType::TABLET ],
    'YPY AB7DC'                                 => [ 'Positivo', 'YPY AB7DC', DeviceType::TABLET ],
    'Positivo Ypy AB7E'                         => [ 'Positivo', 'YPY AB7E', DeviceType::TABLET ],
    'Positivo Ypy AB7EC'                        => [ 'Positivo', 'YPY AB7EC', DeviceType::TABLET ],
    'Positivo Ypy AB7F'                         => [ 'Positivo', 'YPY AB7F', DeviceType::TABLET ],
    'Positivo AB7F'                             => [ 'Positivo', 'YPY AB7F', DeviceType::TABLET ],
    'Positivo Ypy AB7H'                         => [ 'Positivo', 'YPY AB7H', DeviceType::TABLET ],
    'YPY AB10D'                                 => [ 'Positivo', 'YPY AB10D', DeviceType::TABLET ],
    'YPY AB10DC'                                => [ 'Positivo', 'YPY AB10DC', DeviceType::TABLET ],
    'Positivo Ypy AB10E'                        => [ 'Positivo', 'YPY AB10E', DeviceType::TABLET ],
    'Positivo Ypy AB10EC'                       => [ 'Positivo', 'YPY AB10EC', DeviceType::TABLET ],
    'Positivo Ypy AB10H'                        => [ 'Positivo', 'YPY AB10H', DeviceType::TABLET ],
    'YPY ABXD'                                  => [ 'Positivo', 'YPY ABXD', DeviceType::TABLET ],
    'YPY J213'                                  => [ 'Positivo', 'YPY J213' ],
    'Positivo BGH Ypy L700'                     => [ 'Positivo', 'YPY L700', DeviceType::TABLET ],
    'Positivo Ypy L700'                         => [ 'Positivo', 'YPY L700', DeviceType::TABLET ],
    'Positivo Ypy L700 Ed. Especial'            => [ 'Positivo', 'YPY L700 Edição Especial', DeviceType::TABLET ],
    'Positivo Ypy L700+'                        => [ 'Positivo', 'YPY L700+', DeviceType::TABLET ],
    'Positivo Ypy L700 Kids'                    => [ 'Positivo', 'YPY L700 Kids', DeviceType::TABLET ],
    'Positivo BGH Ypy L700 Kids'                => [ 'Positivo', 'YPY L700 Kids', DeviceType::TABLET ],
    'Positivo Ypy L700+ Kids'                   => [ 'Positivo', 'YPY L700+ Kids', DeviceType::TABLET ],
    'Positivo Ypy L1000'                        => [ 'Positivo', 'YPY L1000', DeviceType::TABLET ],
    'Positivo Ypy L1000AB'                      => [ 'Positivo', 'YPY L1000AB', DeviceType::TABLET ],
    'Positivo Ypy L1000F'                       => [ 'Positivo', 'YPY L1000F', DeviceType::TABLET ],
    'Positivo Ypy L1050'                        => [ 'Positivo', 'YPY L1050', DeviceType::TABLET ],
    'Positivo Ypy L1050E'                       => [ 'Positivo', 'YPY L1050E', DeviceType::TABLET ],
    'Positivo Ypy L1050F'                       => [ 'Positivo', 'YPY L1050F', DeviceType::TABLET ],
    'YPY S350'                                  => [ 'Positivo', 'YPY S350' ],
    'YPY S350 PLUS'                             => [ 'Positivo', 'YPY S350 Plus' ],
    'Positivo S380'                             => [ 'Positivo', 'YPY S380' ],
    'YPY S400'                                  => [ 'Positivo', 'YPY S400' ],
    'YPY S405'                                  => [ 'Positivo', 'YPY S405' ],
    'Positivo S440'                             => [ 'Positivo', 'YPY S440' ],
    'YPY S450'                                  => [ 'Positivo', 'YPY S450' ],
    'YPY S460'                                  => [ 'Positivo', 'YPY S460' ],
    'Positivo S480'                             => [ 'Positivo', 'YPY S480' ],
    'YPY S500'                                  => [ 'Positivo', 'YPY S500' ],
    'Positivo S550'                             => [ 'Positivo', 'YPY S550' ],
    'Positivo X400'                             => [ 'Positivo', 'YPY X400' ],
    'Positivo X800'                             => [ 'Positivo', 'YPY X800' ],
    'YPY TQ7'                                   => [ 'Positivo', 'YPY TQ7', DeviceType::TABLET ],
    'PULID F6'                                  => [ 'PULID', 'F6' ],
    'PULID F7'                                  => [ 'PULID', 'F7' ],
    'PULID F11'                                 => [ 'PULID', 'F11' ],
    'F13'                                       => [ 'PULID', 'F13' ],
    'F15'                                       => [ 'PULID', 'F15' ],
    'PULID T3'                                  => [ 'PULID', 'T3' ],

    'Q-Wave!!' => [
        'Q-Wave70M'                                 => [ 'Quantum', 'Q-Wave 70M', DeviceType::TABLET ],
        'Q-Wave70M2'                                => [ 'Quantum', 'Q-Wave 70M2', DeviceType::TABLET ],
        'Q-Wave71'                                  => [ 'Quantum', 'Q-Wave 71', DeviceType::TABLET ],
        'Q-Wave71M'                                 => [ 'Quantum', 'Q-Wave 71M', DeviceType::TABLET ],
        'Q-Wave71N'                                 => [ 'Quantum', 'Q-Wave 71N', DeviceType::TABLET ],
        'Q-Wave781N'                                => [ 'Quantum', 'Q-Wave 781N', DeviceType::TABLET ],
        'Q-WaveA101'                                => [ 'Quantum', 'Q-Wave A101', DeviceType::TABLET ],
        'Q-Wave L70N'                               => [ 'Quantum', 'Q-Wave L70N', DeviceType::TABLET ],
    ],

    'Quechua Phone 5'                           => [ 'Quechua', 'Phone 5' ],

    'QUBE[ -](B[0-9]S?\+?)!'                    => [ 'Qube', '$1' ],
    'QUBE[ -](T[0-9])!'                         => [ 'Qube', '$1', DeviceType::TABLET ],
    'QUMO[ -]QUEST[ -]?([0-9]+i?)!'             => [ 'QUMO', 'Quest $1' ],
    'QUMO Altair ([0-9]+i?)!'                   => [ 'QUMO', 'Altair $1', DeviceType::TABLET ],
    'QUMO Vega ([0-9]+i?)!'                     => [ 'QUMO', 'Vega $1', DeviceType::TABLET ],


    'QW ?TB-[0-9]{4,4}!!' => [
        'QW TB-1007'                                => [ 'Qware', 'Pro3 (7.0 inch, 1st gen)', DeviceType::TABLET ],
        'QW TB-1207'                                => [ 'Qware', 'Pro3 (7.0 inch, 2nd gen)', DeviceType::TABLET ],
        'QW TB-1217'                                => [ 'Qware', 'Pro3 (7.0 inch, 3nd gen)', DeviceType::TABLET ],
        'QW TB-1210'                                => [ 'Qware', 'Pro3 (10.0 inch)', DeviceType::TABLET ],
        'QW TB-9718'                                => [ 'Qware', 'Pro4 Slim 9.7', DeviceType::TABLET ],
        'QWTB-9718HD'                               => [ 'Qware', 'Pro4 Slim HD 9.7', DeviceType::TABLET ],
        'QW TB-1317Q'                               => [ 'Qware', 'Pro5 HD 7.0', DeviceType::TABLET ],
        'QW TB-1380QHD'                             => [ 'Qware', 'Pro5 QHD 8.0', DeviceType::TABLET ],
        'QW TB-9718QHD'                             => [ 'Qware', 'Pro5 QHD 9.7', DeviceType::TABLET ],
        'QW TB-1517'                                => [ 'Qware', 'Tabby', DeviceType::TABLET ],
        'QW TB-1517D'                               => [ 'Qware', 'Tabby2', DeviceType::TABLET ],
    ],

    'ramos i7s  '                               => [ 'Ramos', 'I7s', DeviceType::TABLET ],
    'Ramos i7s Series'                          => [ 'Ramos', 'I7s', DeviceType::TABLET ],
    'Ramosi8'                                   => [ 'Ramos', 'I8', DeviceType::TABLET ],
    'Ramosi8c'                                  => [ 'Ramos', 'I8c', DeviceType::TABLET ],
    'Ramosi9'                                   => [ 'Ramos', 'I9', DeviceType::TABLET ],
    'Ramosi9-3G'                                => [ 'Ramos', 'I9 3G', DeviceType::TABLET ],
    'Ramos i9s'                                 => [ 'Ramos', 'I9s', DeviceType::TABLET ],
    'Ramos i9s Series'                          => [ 'Ramos', 'I9s', DeviceType::TABLET ],
    'Ramos i9s pro'                             => [ 'Ramos', 'I9s Pro', DeviceType::TABLET ],
    'Ramosi10'                                  => [ 'Ramos', 'I10', DeviceType::TABLET ],
    'Ramos i11 pro'                             => [ 'Ramos', 'I11 Pro', DeviceType::TABLET ],
    'Ramosi12c'                                 => [ 'Ramos', 'I12c', DeviceType::TABLET ],
    'Ramos i100 pro'                            => [ 'Ramos', 'I100 Pro', DeviceType::TABLET ],
    'Ramos K100'                                => [ 'Ramos', 'K100', DeviceType::TABLET ],
    'Ramos K300'                                => [ 'Ramos', 'K300', DeviceType::TABLET ],
    'Ramos M7'                                  => [ 'Ramos', 'M7' ],
    'ramos R9'                                  => [ 'Ramos', 'R9' ],
    'W6'                                        => [ 'Ramos', 'W6', DeviceType::TABLET ],
    'W6HD ICS'                                  => [ 'Ramos', 'W6HD', DeviceType::TABLET ],
    'W6HD ICS FULL'                             => [ 'Ramos', 'W6HD', DeviceType::TABLET ],
    'Ramos W6HD'                                => [ 'Ramos', 'W6HD', DeviceType::TABLET ],
    'W10'                                       => [ 'Ramos', 'W10', DeviceType::TABLET ],
    'W10 V2.0'                                  => [ 'Ramos', 'W10 v2.0', DeviceType::TABLET ],
    'Ramos W12'                                 => [ 'Ramos', 'W12', DeviceType::TABLET ],
    'Ramos W12HD'                               => [ 'Ramos', 'W12HD', DeviceType::TABLET ],
    'w13pro'                                    => [ 'Ramos', 'W13 Pro', DeviceType::TABLET ],
    'W13PRO V2.0'                               => [ 'Ramos', 'W13 Pro', DeviceType::TABLET ],
    'Ramos W17Pro V3.0'                         => [ 'Ramos', 'W17 Pro', DeviceType::TABLET ],
    'W17PRO(Dualcore)'                          => [ 'Ramos', 'W17 Pro', DeviceType::TABLET ],
    'W17PRO JB Dualcore'                        => [ 'Ramos', 'W17 Pro', DeviceType::TABLET ],
    'Ramos W21'                                 => [ 'Ramos', 'W21', DeviceType::TABLET ],
    'W22PRO'                                    => [ 'Ramos', 'W22 Pro', DeviceType::TABLET ],
    'W22PRO 3G'                                 => [ 'Ramos', 'W22 Pro 3G', DeviceType::TABLET ],
    'Ramos W25HD'                               => [ 'Ramos', 'W25HD', DeviceType::TABLET ],
    'Ramos W27Pro'                              => [ 'Ramos', 'W27 Pro', DeviceType::TABLET ],
    'W27(Dualcore)'                             => [ 'Ramos', 'W27 Dual Core', DeviceType::TABLET ],
    'W28(Dualcore)'                             => [ 'Ramos', 'W28 Dual Core', DeviceType::TABLET ],
    'W30(QuadCore)'                             => [ 'Ramos', 'W30 Quad Core', DeviceType::TABLET ],
    'w30hd(QuadCore)'                           => [ 'Ramos', 'W30HD Quad Core', DeviceType::TABLET ],
    'W30HDPRO'                                  => [ 'Ramos', 'W30HD Pro', DeviceType::TABLET ],
    'Ramos W31'                                 => [ 'Ramos', 'W31', DeviceType::TABLET ],
    'Ramos w36'                                 => [ 'Ramos', 'W36', DeviceType::TABLET ],
    'Ramos W41'                                 => [ 'Ramos', 'W41', DeviceType::TABLET ],
    'Ramos W41 QuadCore'                        => [ 'Ramos', 'W41 Quad Core', DeviceType::TABLET ],
    'w42(QuadCore)'                             => [ 'Ramos', 'W42 Quad Core', DeviceType::TABLET ],
    'Ramos X10 PRO!'                            => [ 'Ramos', 'X10 Pro', DeviceType::TABLET ],
    'T11AD!'                                    => [ 'Ramos', 'T11AD', DeviceType::TABLET ],

    'Rayhov!!' => [
        'Rayhov X3'                                 => [ 'Rayhov', 'X3' ],
        'Rayhov X6'                                 => [ 'Rayhov', 'X6' ],
        'Rayhov X9'                                 => [ 'Rayhov', 'X9' ],
    ],

    'Readboy!!' => [
        'Readboy G12'                               => [ 'Readboy', 'G12', DeviceType::TABLET ],
        'Readboy G18'                               => [ 'Readboy', 'G18', DeviceType::TABLET ],
        'Readboy G50'                               => [ 'Readboy', 'G50', DeviceType::TABLET ],
        'Readboy G100'                              => [ 'Readboy', 'G100', DeviceType::TABLET ],
    ],

    'ReederA8R'                                 => [ 'Reeder', 'A8R', DeviceType::TABLET ],
    'reeder A8i Quad 2'                         => [ 'Reeder', 'A8i Quad 2', DeviceType::TABLET ],
    'RCT6973W43'                                => [ 'RCA', 'Voyager III', DeviceType::TABLET ],
    'PlayBook'                                  => [ 'RIM', 'BlackBerry PlayBook', DeviceType::TABLET ],
    'RBK-490'                                   => [ 'Ritmix', 'RBK-490', DeviceType::TABLET ],

    '(Ritmix )?RM[DP]-?[0-9]{3,3}!!' => [
        'RMD-720'                                   => [ 'Ritmix', 'RMD-720', DeviceType::TABLET ],
        'RMD-721'                                   => [ 'Ritmix', 'RMD-721', DeviceType::TABLET ],
        'RMD-722'                                   => [ 'Ritmix', 'RMD-722', DeviceType::TABLET ],
        'RITMIX RMD-740'                            => [ 'Ritmix', 'RMD-740', DeviceType::TABLET ],
        'Ritmix RMD745'                             => [ 'Ritmix', 'RMD-745', DeviceType::TABLET ],
        'RMD-755'                                   => [ 'Ritmix', 'RMD-755', DeviceType::TABLET ],
        'RMD-757'                                   => [ 'Ritmix', 'RMD-757', DeviceType::TABLET ],
        'RMD-770'                                   => [ 'Ritmix', 'RMD-770', DeviceType::TABLET ],
        'RMD-785'                                   => [ 'Ritmix', 'RMD-785', DeviceType::TABLET ],
        'RMD-787'                                   => [ 'Ritmix', 'RMD-787', DeviceType::TABLET ],
        'Ritmix RMD840'                             => [ 'Ritmix', 'RMD-840', DeviceType::TABLET ],
        'RMD-855'                                   => [ 'Ritmix', 'RMD-855', DeviceType::TABLET ],
        'RMD-900'                                   => [ 'Ritmix', 'RMD-900', DeviceType::TABLET ],
        'RMD-1026'                                  => [ 'Ritmix', 'RMD-1026', DeviceType::TABLET ],
        'RMD-1027'                                  => [ 'Ritmix', 'RMD-1027', DeviceType::TABLET ],
        'RMD-1030'                                  => [ 'Ritmix', 'RMD-1030', DeviceType::TABLET ],
        'RMD-1035'                                  => [ 'Ritmix', 'RMD-1035', DeviceType::TABLET ],
        'RMD-1040'                                  => [ 'Ritmix', 'RMD-1040', DeviceType::TABLET ],
        'RMD-1050'                                  => [ 'Ritmix', 'RMD-1050', DeviceType::TABLET ],
        'RMD-1055'                                  => [ 'Ritmix', 'RMD-1055', DeviceType::TABLET ],
        'RMD-1058'                                  => [ 'Ritmix', 'RMD-1058', DeviceType::TABLET ],
        'RMD-1070'                                  => [ 'Ritmix', 'RMD-1070', DeviceType::TABLET ],
        'RMP400'                                    => [ 'Ritmix', 'RMP-400', DeviceType::TABLET ],
        'RMP-450'                                   => [ 'Ritmix', 'RMP-450', DeviceType::TABLET ],
        'RMP-530'                                   => [ 'Ritmix', 'RMP-530', DeviceType::TABLET ],
        'RMP-600'                                   => [ 'Ritmix', 'RMP-600', DeviceType::TABLET ],
    ],

    '(?:RIVO )?RHYTHM RX ?([0-9]+)!'              => [ 'Rivo', 'Rhythm RX$1' ],

    'RMD-[0-9]{2,3}G!!' => [
        'RMD-73G'                                   => [ 'Ross&Moor', 'RMD-73G', DeviceType::TABLET ],
        'RMD-917G'                                  => [ 'Ross&Moor', 'RMD-917G', DeviceType::TABLET ],
        'RMD-973G'                                  => [ 'Ross&Moor', 'RMD-973G', DeviceType::TABLET ],
    ],

    'RoverPad 3W T71D'                          => [ 'RoverPad', '3W T71D', DeviceType::TABLET ],

    'Snexian!!' => [
        'Snexian Mi320'                             => [ 'S Nexian', 'Chronos Mi320' ],
        'Snexian Mi430'                             => [ 'S Nexian', 'Xtreme2 Mi430' ],
    ],

    'Mi438S'                                    => [ 'S Nexian', 'Journey One Mi438' ],
    'A8HD'                                      => [ 'Saayi', 'Dropad A8HD', DeviceType::TABLET ],
    'Salora E1'                                 => [ 'Salora', 'ValuMaxx E1' ],

    'Sansui[ -]([A-Z]{1,2}[0-9]+[A-Z]?\+?)!'    => [ 'Sansui', '$1' ],
    'Sansui Cosmic SP ([0-9]+)!'                => [ 'Sansui', 'Cosmic SP$1' ],
    'SANSUI ETAB ([0-9]+) ?VP!'                 => [ 'Sansui', 'Etab $1VP', DeviceType::TABLET ],

    'DPH-D710'                                  => [ 'Samsung', 'Galaxy S II' ],

    'EK-[GK][CN][0-9]{3,3}!!' => [
        'EK-GC100!'                             => [ 'Samsung', 'Galaxy Camera', DeviceType::CAMERA ],
        'EK-GC110!'                             => [ 'Samsung', 'Galaxy Camera', DeviceType::CAMERA ],
        'EK-GC120!'                             => [ 'Samsung', 'Galaxy Camera LTE', DeviceType::CAMERA ],
        'EK-GC200!'                             => [ 'Samsung', 'Galaxy Camera 2', DeviceType::CAMERA ],
        'EK-GN100!'                             => [ 'Samsung', 'Galaxy NX', DeviceType::CAMERA ],
        'EK-GN120!'                             => [ 'Samsung', 'Galaxy NX', DeviceType::CAMERA ],
        'EK-KC100!'                             => [ 'Samsung', 'Galaxy Camera', DeviceType::CAMERA ],
        'EK-KC120!'                             => [ 'Samsung', 'Galaxy Camera LTE', DeviceType::CAMERA ],
    ],

    'GT-B[0-9]{4,4}!!' => [
        'GT-B5330!'                             => [ 'Samsung', 'Galaxy Chat' ],
        'GT-B5510!'                             => [ 'Samsung', 'Galaxy Y Pro' ],
        'GT-B5512!'                             => [ 'Samsung', 'Galaxy Y Pro Duos' ],
        'GT-B7510!'                             => [ 'Samsung', 'Galaxy Pro' ],
        'GT-B7810!'                             => [ 'Samsung', 'Galaxy M Pro 2' ],
        'GT-B9062!'                             => [ 'Samsung', 'GT-B9062' ],
        'GT-B9120!'                             => [ 'Samsung', 'GT-B9120' ],
        'GT-B9150!'                             => [ 'Samsung', 'Galaxy HomeSync', DeviceType::TELEVISION ],
        'GT-B9388!'                             => [ 'Samsung', 'GT-B9388' ],
    ],

    'GT-I[0-9]{3,4}!!' => [
        'GT-I55(00|03|08)!'                     => [ 'Samsung', 'Galaxy Europa' ],
        'GT-I5510!'                             => [ 'Samsung', 'Galaxy 551' ],
        'GT-I5700!'                             => [ 'Samsung', 'Galaxy Spica' ],
        'GT-I58(00|01)!'                        => [ 'Samsung', 'Galaxy Apollo' ],
        'GT-I6500!'                             => [ 'Samsung', 'Saturn' ],
        'GT-I7500!'                             => [ 'Samsung', 'Galaxy' ],
        'GT-I777!'                              => [ 'Samsung', 'Singa' ],
        'GT-I8000!'                             => [ 'Samsung', 'Omnia 2' ],
        'GT-I8150!'                             => [ 'Samsung', 'Galaxy W' ],
        'GT-I8160!'                             => [ 'Samsung', 'Galaxy Ace 2' ],
        'GT-I81(90|91)!'                        => [ 'Samsung', 'Galaxy S III Mini' ],
        'GT-I8200!'                             => [ 'Samsung', 'Galaxy S III Mini Value Edition' ],
        'GT-I8240!'                             => [ 'Samsung', 'GT-I8240' ],
        'GT-I8245!'                             => [ 'Samsung', 'GT-I8245' ],
        'GT-I8250!'                             => [ 'Samsung', 'Galaxy Beam' ],
        'GT-I8258!'                             => [ 'Samsung', 'Galaxy M Style' ],
        'GT-I82(60|62)!'                        => [ 'Samsung', 'Galaxy Core' ],
        'GT-I8268!'                             => [ 'Samsung', 'GT-I8268' ],
        'GT-I85(20|30)!'                        => [ 'Samsung', 'Galaxy Beam' ],
        'GT-I85(50|52|58)!'                     => [ 'Samsung', 'Galaxy Win' ],
        'GT-I8580'                              => [ 'Samsung', 'Galaxy Core Advance' ],
        'GT-I8730!'                             => [ 'Samsung', 'Galaxy Express' ],
        'GT-I90(00|08|18|88)!'                  => [ 'Samsung', 'Galaxy S' ],
        'GT-I9001!'                             => [ 'Samsung', 'Galaxy S Plus' ],
        'GT-I9003!'                             => [ 'Samsung', 'Galaxy SL' ],
        'GT-I9010!'                             => [ 'Samsung', 'Galaxy S Giorgio Armani' ],
        'GT-I9050!'                             => [ 'Samsung', 'GT-I9050' ],
        'GT-I9060!'                             => [ 'Samsung', 'Galaxy Grand Neo' ],
        'GT-I9063!'                             => [ 'Samsung', 'Galaxy Grand Neo Duos' ],
        'GT-I9070!'                             => [ 'Samsung', 'Galaxy S Advance' ],
        'GT-I9080!'                             => [ 'Samsung', 'Galaxy Grand' ],
        'GT-I9082!'                             => [ 'Samsung', 'Galaxy Grand Duos' ],
        'GT-I91(00|08)!'                        => [ 'Samsung', 'Galaxy S II' ],
        'GT-I9103!'                             => [ 'Samsung', 'Galaxy R' ],
        'GT-I9105!'                             => [ 'Samsung', 'Galaxy S II Plus' ],
        'GT-I91(18|28)!'                        => [ 'Samsung', 'Galaxy Grand' ],
        'GT-I91(50|58)!'                        => [ 'Samsung', 'Galaxy Mega 5.8' ],
        'GT-I9152!'                             => [ 'Samsung', 'Galaxy Mega 5.8 Plus' ],
        'GT-I9168!'                             => [ 'Samsung', 'Galaxy Grand Neo+' ],
        'GT-I9188!'                             => [ 'Samsung', 'GT-I9188' ],
        'GT-I91(90|95|97)!'                     => [ 'Samsung', 'Galaxy S4 Mini' ],
        'GT-I9192!'                             => [ 'Samsung', 'Galaxy S4 Mini Duos' ],
        'GT-I92(00|05|08)!'                     => [ 'Samsung', 'Galaxy Mega 6.3' ],
        'GT-I9210!'                             => [ 'Samsung', 'Galaxy S II LTE' ],
        'GT-I92(20|28)!'                        => [ 'Samsung', 'Galaxy Note' ],
        'GT-I92(30|35)!'                        => [ 'Samsung', 'Galaxy Golden' ],
        'GT-I9250!'                             => [ 'Samsung', 'Galaxy Nexus' ],
        'GT-I92(60|68)!'                        => [ 'Samsung', 'Galaxy Premier' ],
        'GT-I9295!'                             => [ 'Samsung', 'Galaxy S4 Active' ],
        'GT-I93(00|03|05|08)!'                  => [ 'Samsung', 'Galaxy S III' ],
        'GT-I93(01)!'                           => [ 'Samsung', 'Galaxy S3 Neo' ],
        'GT-I9400'                              => [ 'Samsung', 'GT-I9400' ],                               // Unknown
        'GT-I9405!'                             => [ 'Samsung', 'GT-I9405' ],                               // Unknown
        'GT-I9406!'                             => [ 'Samsung', 'GT-I9406' ],                               // Unknown
        'GT-I95(00|05|07)!'                     => [ 'Samsung', 'Galaxy S4' ],
        'GT-I95(02|08)!'                        => [ 'Samsung', 'Galaxy S4 Duos' ],
        'GT-I95(06)!'                           => [ 'Samsung', 'Galaxy S4 Advance' ],
        'GT-I9515!'                             => [ 'Samsung', 'Galaxy S4 Neo' ],                          // Maybe
        'GT-I9600!'                             => [ 'Samsung', 'GT-I9600' ],                               // Unknown
        'GT-I9800!'                             => [ 'Samsung', 'GT-I9800' ],                               // Unknown
    ],

    'GT-N[0-9]{4,4}!!' => [
        'GT-N51(00|05|10|20)!'                  => [ 'Samsung', 'Galaxy Note 8.0', DeviceType::TABLET ],
        'GT-N70(00|05)!'                        => [ 'Samsung', 'Galaxy Note' ],
        'GT-N71(00|02|05|08)!'                  => [ 'Samsung', 'Galaxy Note II' ],
        'GT-N7200!'                             => [ 'Samsung', 'Galaxy Note 3' ],                          // Fake?
        'GT-N80(00|05|10|13|20)!'               => [ 'Samsung', 'Galaxy Note 10.1', DeviceType::TABLET ],
        'GT-N90(00|02||05|06|08)!'              => [ 'Samsung', 'Galaxy Note 3' ],
    ],

    'GT-P[0-9]{4,4}!!' => [
        'GT-P10(00|10|13)!'                     => [ 'Samsung', 'Galaxy Tab 7.0', DeviceType::TABLET ],
        'GT-P31(00|05|08|10|13)!'               => [ 'Samsung', 'Galaxy Tab 2 7.0', DeviceType::TABLET ],
        'GT-P32(00|10)!'                        => [ 'Samsung', 'Galaxy Tab 3 7.0', DeviceType::TABLET ],
        'GT-P51(00|10|13)!'                     => [ 'Samsung', 'Galaxy Tab 2 10.1', DeviceType::TABLET ],
        'GT-P52(00|10|20)!'                     => [ 'Samsung', 'Galaxy Tab 3 10.1', DeviceType::TABLET ],
        'GT-P62(00|10)!'                        => [ 'Samsung', 'Galaxy Tab 7.0 Plus', DeviceType::TABLET ],
        'GT-P62(01|11)!'                        => [ 'Samsung', 'Galaxy Tab 7.0 Plus N', DeviceType::TABLET ],
        'GT-P68(00|10|13)!'                     => [ 'Samsung', 'Galaxy Tab 7.7', DeviceType::TABLET ],
        'GT-P7100!'                             => [ 'Samsung', 'Galaxy Tab 10.1V', DeviceType::TABLET ],
        'GT-P73(00|10|20)!'                     => [ 'Samsung', 'Galaxy Tab 8.9', DeviceType::TABLET ],
        'GT-P75(00|03|10)!'                     => [ 'Samsung', 'Galaxy Tab 10.1', DeviceType::TABLET ],
        'GT-P75(01|11)!'                        => [ 'Samsung', 'Galaxy Tab 10.1N', DeviceType::TABLET ],
        'GT-P7580!'                             => [ 'Samsung', 'Galaxy Tab 10.1', DeviceType::TABLET ],
        'GT-P8110!'                             => [ 'Samsung', 'Nexus 10', DeviceType::TABLET ],
        'GT-P8200!'                             => [ 'Samsung', 'Galaxy Tab 3 Plus (10.1)', DeviceType::TABLET ],
    ],

    'GT-S[0-9]{4,4}!!' => [
        'GT-S52(80|82)!'                        => [ 'Samsung', 'Galaxy Star' ],
        'GT-S5283!'                             => [ 'Samsung', 'Galaxy Star Trios' ],
        'GT-S5300!'                             => [ 'Samsung', 'Galaxy Pocket' ],
        'GT-S5301!'                             => [ 'Samsung', 'Galaxy Pocket Plus' ],
        'GT-S5302!'                             => [ 'Samsung', 'Galaxy Pocket Duos' ],
        'GT-S5303!'                             => [ 'Samsung', 'Galaxy Y Plus' ],
        'GT-S5310!'                             => [ 'Samsung', 'Galaxy Pocket Neo' ],
        'GT-S5312!'                             => [ 'Samsung', 'Galaxy Pocket Neo Duos' ],
        'GT-S53(60|63|68|69)!'                  => [ 'Samsung', 'Galaxy Y' ],
        'GT-S5367!'                             => [ 'Samsung', 'Galaxy Y TV' ],
        'GT-S55(70|78)!'                        => [ 'Samsung', 'Galaxy Mini' ],
        'GT-S5660!'                             => [ 'Samsung', 'Galaxy Gio' ],
        'GT-S5670!'                             => [ 'Samsung', 'Galaxy Fit' ],
        'GT-S56(90|98)!'                        => [ 'Samsung', 'Galaxy Xcover' ],
        'GT-S58(20|30|31|38|39)!'               => [ 'Samsung', 'Galaxy Ace' ],
        'GT-S6010!'                             => [ 'Samsung', 'Galaxy Music' ],
        'GT-S6012!'                             => [ 'Samsung', 'Galaxy Music Duos' ],
        'GT-S6102!'                             => [ 'Samsung', 'Galaxy Y Duos' ],
        'GT-S6108!'                             => [ 'Samsung', 'Galaxy Y Pop' ],
        'GT-S6293!'                             => [ 'Samsung', 'Galaxy Young Plus' ],
        'GT-S6310!'                             => [ 'Samsung', 'Galaxy Young' ],
        'GT-S6312!'                             => [ 'Samsung', 'Galaxy Young Duos' ],
        'GT-S6313!'                             => [ 'Samsung', 'Galaxy Y Duos TV' ],
        'GT-S6352!'                             => [ 'Samsung', 'Galaxy Ace Duos' ],
        'GT-S6358!'                             => [ 'Samsung', 'Galaxy Ace' ],
        'GT-S6500!'                             => [ 'Samsung', 'Galaxy Mini 2' ],
        'GT-S6702!'                             => [ 'Samsung', 'Galaxy Y Duos' ],
        'GT-S6790!'                             => [ 'Samsung', 'Galaxy Fame Lite' ],
        'GT-S6792!'                             => [ 'Samsung', 'Galaxy Fame Lite Duos' ],
        'GT-S6800!'                             => [ 'Samsung', 'Galaxy Ace Advance' ],
        'GT-S6802!'                             => [ 'Samsung', 'Galaxy Ace Duos' ],
        'GT-S68(10|12|18)!'                     => [ 'Samsung', 'Galaxy Fame' ],
        'GT-S72(60|62)!'                        => [ 'Samsung', 'Galaxy Star Pro' ],
        'GT-S72(70|75|78)!'                     => [ 'Samsung', 'Galaxy Ace 3' ],
        'GT-S7273T'                             => [ 'Samsung', 'Galaxy S II TV' ],
        'GT-S72(72|73)!'                        => [ 'Samsung', 'Galaxy Ace 3 Duos' ],
        'GT-S7390!'                             => [ 'Samsung', 'Galaxy Trend Lite' ],                      // Aka Galaxy Fresh
        'GT-S7392!'                             => [ 'Samsung', 'Galaxy Trend' ],
        'GT-S75(00|08)!'                        => [ 'Samsung', 'Galaxy Ace Plus' ],
        'GT-S7560!'                             => [ 'Samsung', 'Galaxy Ace II x' ],
        'GT-S75(62|66|68)!'                     => [ 'Samsung', 'Galaxy S Duos' ],
        'GT-S7570!'                             => [ 'Samsung', 'Galaxy Trend II' ],
        'GT-S7572!'                             => [ 'Samsung', 'Galaxy Trend II Duos' ],
        'GT-S75(80|83)!'                        => [ 'Samsung', 'Galaxy Trend Plus' ],
        'GT-S75(82)!'                           => [ 'Samsung', 'Galaxy S Duos 2' ],
        'GT-S7710!'                             => [ 'Samsung', 'Galaxy Xcover 2' ],
        'GT-S7898!'                             => [ 'Samsung', 'Galaxy Trend 2' ],
        'GT-S8500'                              => [ 'Samsung', 'Wave' ],
        'GT-S8530'                              => [ 'Samsung', 'Wave II' ],
        'GT-S9081'                              => [ 'Samsung', 'GT-S9081' ],                               // Unknown
    ],

    'GT-T959!'                                  => [ 'Samsung', 'Galaxy S Vibrant' ],

    'SCH-[iI][0-9]{3,3}!!' => [
        'SCH-i509!'                                 => [ 'Samsung', 'Galaxy Y' ],
        'SCH-i559'                                  => [ 'Samsung', 'Galaxy Pop' ],
        'SCH-i569'                                  => [ 'Samsung', 'Galaxy Gio' ],
        'SCH-i579'                                  => [ 'Samsung', 'Galaxy Ace' ],
        'SCH-i589'                                  => [ 'Samsung', 'Galaxy Ace Duos' ],
        'SCH-i705!'                                 => [ 'Samsung', 'Galaxy Tab 2 7.0', DeviceType::TABLET ],
        'SCH-i809'                                  => [ 'Samsung', 'Galaxy S' ],
        'SCH-i889'                                  => [ 'Samsung', 'Galaxy Note' ],
        'SCH-i899'                                  => [ 'Samsung', 'Galaxy' ],
        'SCH-i909'                                  => [ 'Samsung', 'Galaxy S' ],
        'SCH-i919'                                  => [ 'Samsung', 'Galaxy S Duos' ],
        'SCH-i929'                                  => [ 'Samsung', 'Galaxy S II Duos' ],
        'SCH-I100'                                  => [ 'Samsung', 'Gem' ],
        'SCH-I110'                                  => [ 'Samsung', 'Illusion' ],
        'SCH-I200PP'                                => [ 'Samsung', 'Galaxy Legend' ],
        'SCH-I200( 4G)?$!'                          => [ 'Samsung', 'Galaxy Stellar' ],
        'SCH-I339'                                  => [ 'Samsung', 'SCH-I339' ],
        'SCH-I400'                                  => [ 'Samsung', 'Continuum' ],
        'SCH-I405( 4G)?$!'                          => [ 'Samsung', 'Stratosphere' ],
        'SCH-I405U'                                 => [ 'Samsung', 'Galaxy Metrix' ],
        'SCH-I415( 4G)?$!'                          => [ 'Samsung', 'Stratosphere II' ],
        'SCH-I425'                                  => [ 'Samsung', 'Stratosphere 3' ],
        'SCH-I435!'                                 => [ 'Samsung', 'Galaxy S4 Mini' ],
        'SCH-I500'                                  => [ 'Samsung', 'Fascinate' ],
        'SCH-I510'                                  => [ 'Samsung', 'Stealth V' ],
        'SCH-I510 4G'                               => [ 'Samsung', 'Droid Charge' ],
        'SCH-I515'                                  => [ 'Samsung', 'Galaxy Nexus' ],
        'SCH-I519'                                  => [ 'Samsung', 'SCH-I519' ],
        'SCH-I535!'                                 => [ 'Samsung', 'Galaxy S III' ],
        'SCH-I545!'                                 => [ 'Samsung', 'Galaxy S4' ],
        'SCH-I605!'                                 => [ 'Samsung', 'Galaxy Note II' ],
        'SCH-I619'                                  => [ 'Samsung', 'Galaxy Ace A+' ],
        'SCH-I629'                                  => [ 'Samsung', 'Galaxy Fame' ],
        'SCH-I639'                                  => [ 'Samsung', 'SCH-I639' ],
        'SCH-I659'                                  => [ 'Samsung', 'Galaxy Ace Plus' ],
        'SCH-I665'                                  => [ 'Samsung', 'SCH-I665' ],                               // Unknown
        'SCH-I679'                                  => [ 'Samsung', 'SCH-I679' ],
        'SCH-I699!'                                 => [ 'Samsung', 'Galaxy Trend' ],
        'SCH-I739'                                  => [ 'Samsung', 'Galaxy Trend 2' ],
        'SCH-I747'                                  => [ 'Samsung', 'Galaxy S III' ],
        'SCH-I759'                                  => [ 'Samsung', 'Galaxy Infinite' ],
        'SCH-I779'                                  => [ 'Samsung', 'Saga' ],
        'SCH-I800'                                  => [ 'Samsung', 'Galaxy Tab 7.0', DeviceType::TABLET ],
        'SCH-I815!'                                 => [ 'Samsung', 'Galaxy Tab 7.7', DeviceType::TABLET ],
        'SCH-I829'                                  => [ 'Samsung', 'Galaxy Style Duos' ],
        'SCH-I869'                                  => [ 'Samsung', 'Galaxy Win' ],
        'SCH-I879!'                                 => [ 'Samsung', 'Galaxy Grand' ],
        'SCH-I905!'                                 => [ 'Samsung', 'Galaxy Tab 10.1', DeviceType::TABLET ],
        'SCH-I909'                                  => [ 'Samsung', 'Galaxy S' ],
        'SCH-I915!'                                 => [ 'Samsung', 'Galaxy Tab 2 10.1', DeviceType::TABLET ],
        'SCH-I919!'                                 => [ 'Samsung', 'Galaxy S Duos' ],
        'SCH-I925!'                                 => [ 'Samsung', 'Galaxy Note 10.1', DeviceType::TABLET ],
        'SCH-I939!'                                 => [ 'Samsung', 'Galaxy S III' ],
        'SCH-I959'                                  => [ 'Samsung', 'Galaxy S4' ],
    ],

    'SCH-L710!'                                 => [ 'Samsung', 'Galaxy S III' ],
    'SCH-M828!'                                 => [ 'Samsung', 'Galaxy Precedent' ],
    'SCH-N719'                                  => [ 'Samsung', 'Galaxy Note II' ],

    'SCH-P[0-9]{3,3}!!' => [
        'SCH-P709!'                                 => [ 'Samsung', 'Galaxy Mega 5.8' ],
        'SCH-P729'                                  => [ 'Samsung', 'Galaxy Mega 6.3' ],
        'SCH-P739'                                  => [ 'Samsung', 'Galaxy Tab 8.9', DeviceType::TABLET ],
    ],

    'SCH-R[0-9]{3,3}!!' => [
        'SCH-R530!'                                 => [ 'Samsung', 'Galaxy S III' ],
        'SCH-R680!'                                 => [ 'Samsung', 'Repp' ],
        'SCH-R710!'                                 => [ 'Samsung', 'Suede' ],
        'SCH-R720!'                                 => [ 'Samsung', 'Admire' ],
        'SCH-R730!'                                 => [ 'Samsung', 'Transfix' ],
        'SCH-R740!'                                 => [ 'Samsung', 'Galaxy Discover' ],
        'SCH-R760!'                                 => [ 'Samsung', 'Galaxy S II' ],
        'SCH-R820!'                                 => [ 'Samsung', 'Admire' ],
        'SCH-R830!'                                 => [ 'Samsung', 'Galaxy Axiom' ],
        'SCH-R880!'                                 => [ 'Samsung', 'Acclaim' ],
        'SCH-R890!'                                 => [ 'Samsung', 'SCH-R890' ],
        'SCH-R910!'                                 => [ 'Samsung', 'Galaxy Indulge 4G' ],
        'SCH-R915!'                                 => [ 'Samsung', 'Galaxy Indulge' ],
        'SCH-R920!'                                 => [ 'Samsung', 'Galaxy Attain 4G' ],
        'SCH-R930!'                                 => [ 'Samsung', 'Galaxy S Aviator' ],
        'SCH-R940!'                                 => [ 'Samsung', 'Galaxy S Lightray' ],
        'SCH-R950!'                                 => [ 'Samsung', 'Galaxy Note II' ],
        'SCH-R960!'                                 => [ 'Samsung', 'Galaxy Mega 6.3' ],
        'SCH-R970!'                                 => [ 'Samsung', 'Galaxy S4' ],
    ],

    'SCH-S[0-9]{3,3}!!' => [
        'SCH-S720!'                                 => [ 'Samsung', 'Galaxy Proclaim' ],
        'SCH-S735!'                                 => [ 'Samsung', 'Galaxy Discover' ],
        'SCH-S738!'                                 => [ 'Samsung', 'Galaxy Centura' ],
        'SCH-S950!'                                 => [ 'Samsung', 'Galaxy S Showcase' ],
        'SCH-S9(60|68)!'                            => [ 'Samsung', 'Galaxy S III' ],
    ],

    'SCH-V727'                                  => [ 'Samsung', 'Galaxy S4' ],

    'SCH-W[0-9]{3,4}!!' => [
        'SCH-W789!'                                 => [ 'Samsung', 'SCH-W789' ],
        'SCH-W799!'                                 => [ 'Samsung', 'SCH-W799' ],
        'SCH-W899'                                  => [ 'Samsung', 'SCH-W899' ],
        'SCH-W999'                                  => [ 'Samsung', 'SCH-W999' ],
        'SCH-W2013'                                 => [ 'Samsung', 'SCH-W2013' ],
        'SCH-W9913'                                 => [ 'Samsung', 'SCH-W9913' ],
    ],

    'SGH-[EILNMS][0-9]{3,4}!!' => [
        'SGH-E258'                                  => [ 'Samsung', 'SGH-E258' ],
        'SGH-I317!'                                 => [ 'Samsung', 'Galaxy Note II' ],
        'SGH-I237!'                                 => [ 'Samsung', 'SGH-I237' ],                               // Developer device
        'SGH-I257!'                                 => [ 'Samsung', 'Galaxy S4 Mini' ],
        'SGH-I317!'                                 => [ 'Samsung', 'Galaxy Note II' ],
        'SGH-I337!'                                 => [ 'Samsung', 'Galaxy S4' ],
        'SGH-I407!'                                 => [ 'Samsung', 'Galaxy Amp' ],
        'SGH-I437!'                                 => [ 'Samsung', 'Galaxy Express' ],
        'SGH-I467!'                                 => [ 'Samsung', 'Galaxy Note 8.0', DeviceType::TABLET ],
        'SGH-I497'                                  => [ 'Samsung', 'Galaxy Tab 2 10.1', DeviceType::TABLET ],
        'SGH-I527!'                                 => [ 'Samsung', 'Galaxy Mega 6.3' ],
        'SGH-I535!'                                 => [ 'Samsung', 'Galaxy S III' ],
        'SGH-I537!'                                 => [ 'Samsung', 'Galaxy S4 Active' ],
        'SGH-I545!'                                 => [ 'Samsung', 'Galaxy S4' ],
        'SGH-I547!'                                 => [ 'Samsung', 'Galaxy Rugby Pro' ],
        'SGH-I577!'                                 => [ 'Samsung', 'Galaxy Exhilarate' ],
        'SGH-I717!'                                 => [ 'Samsung', 'Galaxy Note' ],
        'SGH-I727R'                                 => [ 'Samsung', 'Galaxy S II' ],
        'SGH-I727!'                                 => [ 'Samsung', 'Galaxy S II Skyrocket' ],
        'SGH-I7(47|48)!'                            => [ 'Samsung', 'Galaxy S III' ],
        'SGH-I757!'                                 => [ 'Samsung', 'Galaxy S II Skyrocket HD' ],
        'SGH-I9?777!'                               => [ 'Samsung', 'Galaxy S II' ],
        'SGH-I807'                                  => [ 'Samsung', 'SGH-I807' ],
        'SGH-I827!'                                 => [ 'Samsung', 'Galaxy Appeal' ],
        'SGH-I847'                                  => [ 'Samsung', 'Rugby Smart' ],
        'SGH-I857'                                  => [ 'Samsung', 'DoubleTime' ],
        'SGH-I8(96|97)!'                            => [ 'Samsung', 'Captivate' ],
        'SGH-I927!'                                 => [ 'Samsung', 'Captivate Glide' ],
        'SGH-I957!'                                 => [ 'Samsung', 'Galaxy Tab 8.9', DeviceType::TABLET ],
        'SGH-I987'                                  => [ 'Samsung', 'Galaxy Tab 7.0', DeviceType::TABLET ],
        'SGH-I997!'                                 => [ 'Samsung', 'Infuse 4G' ],
        'SGH-I9000'                                 => [ 'Samsung', 'Galaxy S' ],
        'SGH-I9300'                                 => [ 'Samsung', 'Galaxy S III' ],
        'SGH-L710'                                  => [ 'Samsung', 'Galaxy S III' ],
        'SGH-N014!'                                 => [ 'Samsung', 'GALAXY Tab 10.1 LTE SC-01D', DeviceType::TABLET, 'carrier' => 'DoCoMo' ],
        'SGH-N075!'                                 => [ 'Samsung', 'GALAXY J SC-02F', 'carrier' => 'DoCoMo' ],
        'SGH-M819!'                                 => [ 'Samsung', 'Galaxy Mega 6.3' ],
        'SGH-M909!'                                 => [ 'Samsung', 'Galaxy S III' ],
        'SGH-M919!'                                 => [ 'Samsung', 'Galaxy S4' ],
        'SGH-S730!'                                 => [ 'Samsung', 'Galaxy Discover' ],
        'SGH-S959!'                                 => [ 'Samsung', 'Galaxy S II' ],
        'SGH-S970G'                                 => [ 'Samsung', 'Galaxy S4' ],
    ],

    'SGH-T[0-9]{3,3}!!' => [
        'SGH-T289!'                                 => [ 'Samsung', 'Gravity Q' ],
        'SGH-T399!'                                 => [ 'Samsung', 'Galaxy Light' ],                           // Codename Garda
        'SGH-T499!'                                 => [ 'Samsung', 'Dart' ],
        'SGH-T499[VY]!'                             => [ 'Samsung', 'Galaxy Mini' ],
        'SGH-T589!'                                 => [ 'Samsung', 'Gravity Smart' ],
        'SGH-T599!'                                 => [ 'Samsung', 'Galaxy Exhibit' ],
        'SGH-T679!'                                 => [ 'Samsung', 'Galaxy Exhibit II' ],
        'SGH-T699'                                  => [ 'Samsung', 'Galaxy S Relay' ],
        'SGH-T727'                                  => [ 'Samsung', 'Galaxy S II Skyrocket' ],
        'SGH-T759'                                  => [ 'Samsung', 'Exhibit 4G' ],
        'SGH-T769'                                  => [ 'Samsung', 'Galaxy S Blaze' ],
        'SGH-T779'                                  => [ 'Samsung', 'Galaxy Tab 2 10.1', DeviceType::TABLET ],
        'SGH-T839!'                                 => [ 'Samsung', 'T-Mobile Sidekick' ],
        'SGH-T849'                                  => [ 'Samsung', 'Galaxy Tab 7.0', DeviceType::TABLET ],
        'SGH-T859'                                  => [ 'Samsung', 'Galaxy Tab 10.1', DeviceType::TABLET ],
        'SGH-T869'                                  => [ 'Samsung', 'Galaxy Tab 7.0 Plus', DeviceType::TABLET ],
        'SGH-T879'                                  => [ 'Samsung', 'Galaxy Note' ],
        'SGH-T889!'                                 => [ 'Samsung', 'Galaxy Note II' ],
        'SGH-T959'                                  => [ 'Samsung', 'Vibrant' ],
        'SGH-T959D'                                 => [ 'Samsung', 'Galaxy S Fascinate 3G+' ],
        'SGH-T959P'                                 => [ 'Samsung', 'Galaxy S Fascinate 4G' ],
        'SGH-T959V'                                 => [ 'Samsung', 'Galaxy S 4G' ],
        'SGH-T959W'                                 => [ 'Samsung', 'Galaxy S 4G' ],
        'SGH-T989'                                  => [ 'Samsung', 'Galaxy S II' ],
        'SGH-T989D'                                 => [ 'Samsung', 'Galaxy S II X' ],
        'SGH-T999!'                                 => [ 'Samsung', 'Galaxy S III' ],
    ],

    'SGH-U468!'                                 => [ 'Samsung', 'Galaxy S4' ],
    'SGH-W2013!'                                => [ 'Samsung', 'SGH-W2013' ],

    'SHV-E[0-9]{3,3}!!' => [
        'SHV-E120!'                                 => [ 'Samsung', 'Galaxy S II HD LTE' ],
        'SHV-E110!'                                 => [ 'Samsung', 'Galaxy S II LTE' ],
        'SHV-E140!'                                 => [ 'Samsung', 'Galaxy Tab 8.9', DeviceType::TABLET ],
        'SHV-E150!'                                 => [ 'Samsung', 'Galaxy Tab 7.7', DeviceType::TABLET ],
        'SHV-E160!'                                 => [ 'Samsung', 'Galaxy Note' ],
        'SHV-E170!'                                 => [ 'Samsung', 'Galaxy R' ],
        'SHV-E210!'                                 => [ 'Samsung', 'Galaxy S III' ],
        'SHV-E220!'                                 => [ 'Samsung', 'Galaxy Pop' ],
        'SHV-E230!'                                 => [ 'Samsung', 'Galaxy Note 10.1', DeviceType::TABLET ],
        'SHV-E250!'                                 => [ 'Samsung', 'Galaxy Note II' ],
        'SHV-E2(70|75)!'                            => [ 'Samsung', 'Galaxy Grand' ],
        'SHV-E300!'                                 => [ 'Samsung', 'Galaxy S4' ],
        'SHV-E310!'                                 => [ 'Samsung', 'Galaxy Mega 6.3' ],
        'SHV-E330!'                                 => [ 'Samsung', 'Galaxy S4' ],
        'SHV-E370!'                                 => [ 'Samsung', 'Galaxy S4 Mini' ],
        'SHV-E400!'                                 => [ 'Samsung', 'Galaxy Folder' ],
        'SHV-E470!'                                 => [ 'Samsung', 'Galaxy S4 Active' ],
        'SHV-E500!'                                 => [ 'Samsung', 'Galaxy Win' ],
        'SHV-E510!'                                 => [ 'Samsung', 'SHV-E510' ],
    ],

    'SHW-M[0-9]{3,3}!!' => [
        'SHW-M100!'                                 => [ 'Samsung', 'Galaxy A' ],
        'SHW-M110!'                                 => [ 'Samsung', 'Galaxy S' ],
        'SHW-M115!'                                 => [ 'Samsung', 'SHW-M115' ],
        'SHW-M130L!'                                => [ 'Samsung', 'Galaxy U' ],
        'SHW-M130K!'                                => [ 'Samsung', 'Galaxy K' ],
        'SHW-M135!'                                 => [ 'Samsung', 'Galaxy W' ],
        'SHW-M1(80|85)!'                            => [ 'Samsung', 'Galaxy Tab 7.0', DeviceType::TABLET ],
        'SHW-M190!'                                 => [ 'Samsung', 'Galaxy S Hoppin' ],
        'SHW-M220!'                                 => [ 'Samsung', 'Galaxy Neo' ],
        'SHW-M240!'                                 => [ 'Samsung', 'Galaxy Ace' ],
        'SHW ?-M250!'                               => [ 'Samsung', 'Galaxy S II' ],
        'SHW-M280!'                                 => [ 'Samsung', 'SHW-M280' ],
        'SHW-M290!'                                 => [ 'Samsung', 'Galaxy Gio' ],
        'SHW-M300!'                                 => [ 'Samsung', 'Galaxy Tab 10.1', DeviceType::TABLET ],
        'SHW-M305!'                                 => [ 'Samsung', 'Galaxy Tab 8.9', DeviceType::TABLET ],
        'SHW-M340!'                                 => [ 'Samsung', 'Galaxy M Style' ],
        'SHW-M380!'                                 => [ 'Samsung', 'Galaxy Tab 10.1', DeviceType::TABLET ],
        'SHW-M420!'                                 => [ 'Samsung', 'Galaxy Nexus' ],
        'SHW-M430!'                                 => [ 'Samsung', 'Galaxy Tab 7.0 Plus', DeviceType::TABLET ],
        'SHW-M440!'                                 => [ 'Samsung', 'Galaxy S III' ],
        'SHW-M460!'                                 => [ 'Samsung', 'Galaxy Ace Plus' ],
        'SHW-M4(80|85|86)!'                         => [ 'Samsung', 'Galaxy Note 10.1', DeviceType::TABLET ],
        'SHW-M500!'                                 => [ 'Samsung', 'Galaxy Note 8.0', DeviceType::TABLET ],
        'SHW-M550!'                                 => [ 'Samsung', 'SHW-M550' ],                               // Unknown
        'SHW-M570!'                                 => [ 'Samsung', 'Galaxy Core Advance' ],
        'SHW-M5(80|85)!'                            => [ 'Samsung', 'Galaxy Core Safe' ],
    ],

    'SMT-E5015'                                 => [ 'Samsung', 'Olleh SkyLife Smart Settopbox', DeviceType::TELEVISION ],
    'SMT-i9100'                                 => [ 'Samsung', 'Galaxy Tab 7.0', DeviceType::TABLET ],

    'SM-A[0-9]{3,3}!!' => [
        'SM-A300!'                                  => [ 'Samsung', 'Galaxy A3' ],
        'SM-A310!'                                  => [ 'Samsung', 'Galaxy A3 (2016)' ],
        'SM-A320!'                                  => [ 'Samsung', 'Galaxy A3 (2017)' ],
        'SM-A430!'                                  => [ 'Samsung', 'Galaxy A4' ],
        'SM-A500!'                                  => [ 'Samsung', 'Galaxy A5' ],
        'SM-A510!'                                  => [ 'Samsung', 'Galaxy A5 (2016)' ],
        'SM-A520!'                                  => [ 'Samsung', 'Galaxy A5 (2017)' ],
        'SM-A530!'                                  => [ 'Samsung', 'Galaxy A5 (2018)' ],
        'SM-A700!'                                  => [ 'Samsung', 'Galaxy A7' ],
        'SM-A710!'                                  => [ 'Samsung', 'Galaxy A7 (2016)' ],
        'SM-A720!'                                  => [ 'Samsung', 'Galaxy A7 (2017)' ],
        'SM-A800!'                                  => [ 'Samsung', 'Galaxy A8' ],
        'SM-A810!'                                  => [ 'Samsung', 'Galaxy A8 (2016)' ],
        'SM-A850!'                                  => [ 'Samsung', 'Galaxy Alpha' ],
        'SM-A900!'                                  => [ 'Samsung', 'Galaxy A9 (2016)' ],
        'SM-A910!'                                  => [ 'Samsung', 'Galaxy A9 Pro' ],
    ],

    'SM-C[0-9]{3,3}!!' => [
        'SM-C10[15]!'                               => [ 'Samsung', 'Galaxy S4 Zoom' ],
        'SM-C11[15]!'                               => [ 'Samsung', 'Galaxy K Zoom' ],
        'SM-C500!'                                  => [ 'Samsung', 'Galaxy C5' ],
        'SM-C501!'                                  => [ 'Samsung', 'Galaxy C5 Pro' ],
        'SM-C700!'                                  => [ 'Samsung', 'Galaxy C7' ],
        'SM-C701!'                                  => [ 'Samsung', 'Galaxy C7 Pro' ],
        'SM-C710!'                                  => [ 'Samsung', 'Galaxy C7 (2017)' ],
        'SM-C900!'                                  => [ 'Samsung', 'Galaxy C9' ],
    ],

    'SM-E[0-9]{3,3}!!' => [
        'SM-E500!'                                  => [ 'Samsung', 'Galaxy E5' ],
        'SM-E700!'                                  => [ 'Samsung', 'Galaxy E7' ],
    ],

    'SM-G[0-9]{3,3}!!' => [
        'SM-G110!'                                  => [ 'Samsung', 'Galaxy Pocket 2' ],
        'SM-G130BT'                                 => [ 'Samsung', 'Galaxy Young 2' ],
        'SM-G130BU'                                 => [ 'Samsung', 'Galaxy Young 2' ],
        'SM-G130E'                                  => [ 'Samsung', 'Galaxy Star 2' ],
        'SM-G130H'                                  => [ 'Samsung', 'Galaxy Young 2' ],
        'SM-G130U'                                  => [ 'Samsung', 'Galaxy Young 2' ],
        'SM-G130HN'                                 => [ 'Samsung', 'Galaxy Young 2 Duos' ],
        'SM-G130M'                                  => [ 'Samsung', 'Galaxy Young 2 Duos' ],
        'SM-G1(50|55)!'                             => [ 'Samsung', 'Galaxy Folder' ],
        'SM-G160!'                                  => [ 'Samsung', 'Galaxy Folder 2' ],
        'SM-G310H'                                  => [ 'Samsung', 'Galaxy Ace 4' ],
        'SM-G310HN'                                 => [ 'Samsung', 'Galaxy Ace Style' ],
        'SM-G310R5'                                 => [ 'Samsung', 'GreatCall Touch 3' ],
        'SM-G313HU!'                                => [ 'Samsung', 'Galaxy S Duos 3' ],
        'SM-G313!'                                  => [ 'Samsung', 'Galaxy Ace 4' ],
        'SM-G316HU!'                                => [ 'Samsung', 'Galaxy S Duos 3-VE' ],
        'SM-G316!'                                  => [ 'Samsung', 'Galaxy Ace 4' ],
        'SM-G318!'                                  => [ 'Samsung', 'Galaxy Ace 4 Neo' ],
        'SM-G350[289]!'                             => [ 'Samsung', 'Galaxy Trend 3' ],
        'SM-G350!'                                  => [ 'Samsung', 'Galaxy Core Plus' ],
        'SM-G3518!'                                 => [ 'Samsung', 'Galaxy Core' ],
        'SM-G355!'                                  => [ 'Samsung', 'Galaxy Core 2' ],
        'SM-G3568!'                                 => [ 'Samsung', 'Galaxy Core Mini' ],
        'SM-G357!'                                  => [ 'Samsung', 'Galaxy Ace Style' ],
        'SM-G358[689]!'                             => [ 'Samsung', 'Galaxy Core Lite' ],
        'SM-G360BT'                                 => [ 'Samsung', 'Galaxy Win 2 Duos TV' ],
        'SM-G360AZ'                                 => [ 'Samsung', 'Galaxy Core Prime' ],
        'SM-G360R6!'                                => [ 'Samsung', 'Galaxy Core Prime' ],
        'SM-G360[FGHMPTV689]!'                      => [ 'Samsung', 'Galaxy Core Prime' ],
        'SM-G361!'                                  => [ 'Samsung', 'Galaxy Core Prime VE' ],
        'SM-G3812B!'                                => [ 'Samsung', 'Galaxy S III Slim' ],
        'SM-G3812'                                  => [ 'Samsung', 'Galaxy Win Pro' ],
        'SM-G3815'                                  => [ 'Samsung', 'Galaxy Express 2' ],
        'SM-G381[89]!'                              => [ 'Samsung', 'Galaxy Win Pro' ],
        'SM-G3858!'                                 => [ 'Samsung', 'Galaxy Beam 2' ],
        'SM-G386!'                                  => [ 'Samsung', 'Galaxy Core' ],                            // LTE variant
        'SM-G388!'                                  => [ 'Samsung', 'Galaxy Xcover 3' ],
        'SM-G389!'                                  => [ 'Samsung', 'Galaxy Xcover 3 VE' ],
        'SM-G390!'                                  => [ 'Samsung', 'Galaxy Xcover 4' ],
        'SM-G420!'                                  => [ 'Samsung', 'SM-G420' ],                                // Unknown
        'SM-G430!'                                  => [ 'Samsung', 'SM-G430' ],                                // Unknown
        'SM-G480!'                                  => [ 'Samsung', 'Galaxy S8' ],
        'SM-G485!'                                  => [ 'Samsung', 'Galaxy S8+' ],
        'SM-G510!'                                  => [ 'Samsung', 'Galaxy Core Max' ],
        'SM-G530!'                                  => [ 'Samsung', 'Galaxy Grand Prime' ],
        'SM-G531!'                                  => [ 'Samsung', 'Galaxy Grand Prime VE' ],
        'SM-G532!'                                  => [ 'Samsung', 'Galaxy Grand Prime+' ],
        'SM-G550!'                                  => [ 'Samsung', 'Galaxy On5' ],
        'SM-G55[12]!'                               => [ 'Samsung', 'Galaxy On5 (2016)' ],
        'SM-G570!'                                  => [ 'Samsung', 'Galaxy J5 Prime' ],
        'SM-G600!'                                  => [ 'Samsung', 'Galaxy On7' ],
        'SM-G610!'                                  => [ 'Samsung', 'Galaxy J7 Prime' ],
        'SM-G615!'                                  => [ 'Samsung', 'Galaxy J7 Max' ],
        'SM-G710!'                                  => [ 'Samsung', 'Galaxy Grand 2' ],
        'SM-G720!'                                  => [ 'Samsung', 'Galaxy Grand 3' ],
        'SM-G730!'                                  => [ 'Samsung', 'Galaxy S III Mini' ],
        'SM-G750!'                                  => [ 'Samsung', 'Galaxy Mega 2 ' ],
        'SM-G770!'                                  => [ 'Samsung', 'Galaxy On7' ],
        'SM-G800!'                                  => [ 'Samsung', 'Galaxy S5 Mini' ],
        'SM-G850!'                                  => [ 'Samsung', 'Galaxy Alpha' ],
        'SM-G860!'                                  => [ 'Samsung', 'Galaxy S5 Sport' ],
        'SM-G870!'                                  => [ 'Samsung', 'Galaxy S5 Active' ],
        'SM-G880!'                                  => [ 'Samsung', 'Galaxy S7 mini' ],
        'SM-G890!'                                  => [ 'Samsung', 'Galaxy S6 Active' ],
        'SM-G891!'                                  => [ 'Samsung', 'Galaxy S7 Active' ],
        'SM-G892!'                                  => [ 'Samsung', 'Galaxy S8 Active' ],
        'SM-G90[016]!'                              => [ 'Samsung', 'Galaxy S5' ],
        'SM-G903!'                                  => [ 'Samsung', 'Galaxy S5 Neo' ],
        'SM-G9092!'                                 => [ 'Samsung', 'Galaxy G9092' ],
        'SM-G9098!'                                 => [ 'Samsung', 'Galaxy G9098' ],
        'SM-G909D'                                  => [ 'Samsung', 'Galaxy S5' ],                              // Chinese dual sim variant
        'SM-G910!'                                  => [ 'Samsung', 'Galaxy Round' ],
        'SM-G919!'                                  => [ 'Samsung', 'SM-G9198' ],
        'SM-G920!'                                  => [ 'Samsung', 'Galaxy S6' ],
        'SM-G925!'                                  => [ 'Samsung', 'Galaxy S6 Edge' ],
        'SM-G928!'                                  => [ 'Samsung', 'Galaxy S6 Edge+' ],
        'SM-G930!'                                  => [ 'Samsung', 'Galaxy S7' ],
        'SM-G935!'                                  => [ 'Samsung', 'Galaxy S7 Edge' ],
        'SM-G950!'                                  => [ 'Samsung', 'Galaxy S8' ],
        'SM-G955!'                                  => [ 'Samsung', 'Galaxy S8+' ],
    ],

    'SM-I9500'                                      => [ 'Samsung', 'Galaxy S4' ],

    'SM-J[0-9]{3,3}!!' => [
        'SM-J100!'                                  => [ 'Samsung', 'Galaxy J1' ],
        'SM-J105!'                                  => [ 'Samsung', 'Galaxy J1 Mini' ],
        'SM-J106!'                                  => [ 'Samsung', 'Galaxy J1 Mini Prime' ],
        'SM-J11[01]!'                               => [ 'Samsung', 'Galaxy J1 Ace' ],
        'SM-J120!'                                  => [ 'Samsung', 'Galaxy J1 (2016)' ],
        'SM-J200!'                                  => [ 'Samsung', 'Galaxy J2' ],
        'SM-J210!'                                  => [ 'Samsung', 'Galaxy J2 (2106)' ],
        'SM-J3(10|20)!'                             => [ 'Samsung', 'Galaxy J3' ],
        'SM-J311!'                                  => [ 'Samsung', 'Galaxy J3 (2016)' ],
        'SM-J321!'                                  => [ 'Samsung', 'Galaxy Sol' ],
        'SM-J326!'                                  => [ 'Samsung', 'Galaxy Sol 2' ],
        'SM-J327!'                                  => [ 'Samsung', 'Galaxy J3 Emerge' ],
        'SM-J330!'                                  => [ 'Samsung', 'Galaxy J3 (2017)' ],
        'SM-J500!'                                  => [ 'Samsung', 'Galaxy J5' ],
        'SM-J510!'                                  => [ 'Samsung', 'Galaxy J5 (2016)' ],
        'SM-J530!'                                  => [ 'Samsung', 'Galaxy J5 (2017)' ],
        'SM-J700!'                                  => [ 'Samsung', 'Galaxy J7' ],
        'SM-J701!'                                  => [ 'Samsung', 'Galaxy J7 Core' ],
        'SM-J710!'                                  => [ 'Samsung', 'Galaxy J7 (2016)' ],
        'SM-J727!'                                  => [ 'Samsung', 'Galaxy J7 Perx' ],
        'SM-J730!'                                  => [ 'Samsung', 'Galaxy J7 (2017)' ],
        'SM-J800!'                                  => [ 'Samsung', 'Galaxy J8' ],
        'SM-J900!'                                  => [ 'Samsung', 'Galaxy J9' ],
    ],

    'SM-N[0-9]{3,4}!!' => [
        'SM-N750[025789][QV]?!'                     => [ 'Samsung', 'Galaxy Note 3 Neo' ],
        'SM-N750[LS]?!'                             => [ 'Samsung', 'Galaxy Note 3 Neo' ],
        'SM-N8000'                                  => [ 'Samsung', 'Galaxy Note 800', DeviceType::TABLET ],
        'SM-N900[0256789]?!'                        => [ 'Samsung', 'Galaxy Note 3' ],
        'SM-N900!'                                  => [ 'Samsung', 'Galaxy Note 3' ],
        'SM-N910[06]'                               => [ 'Samsung', 'Galaxy Note 4' ],
        'SM-N91[06]!'                               => [ 'Samsung', 'Galaxy Note 4' ],
        'SM-N915!'                                  => [ 'Samsung', 'Galaxy Note Edge' ],
        'SM-N920!'                                  => [ 'Samsung', 'Galaxy Note 5' ],
        'SM-N930!'                                  => [ 'Samsung', 'Galaxy Note 7' ],
        'SM-N935!'                                  => [ 'Samsung', 'Galaxy Note FE' ],
        'SM-N950!'                                  => [ 'Samsung', 'Galaxy Note 8' ],
    ],

    'SM-P[0-9]{3,3}!!' => [
        'SM-P35[015]!'                              => [ 'Samsung', 'Galaxy Tab A Plus 8.0', DeviceType::TABLET ],
        'SM-P55[015]!'                              => [ 'Samsung', 'Galaxy Tab A Plus 9.7', DeviceType::TABLET ],
        'SM-P58[058]!'                              => [ 'Samsung', 'Galaxy Tab A 10.1 with S Pen (2016)', DeviceType::TABLET ],
        'SM-P60[01257]!'                            => [ 'Samsung', 'Galaxy Note 10.1 (2014)', DeviceType::TABLET ],
        'SM-P90[01257]!'                            => [ 'Samsung', 'Galaxy Note Pro', DeviceType::TABLET ],
    ],

    'SM-S[0-9]{3,3}!!' => [
        'SM-S120VL'                                 => [ 'Samsung', 'Galaxy Luna' ],
        'SM-S320VL'                                 => [ 'Samsung', 'Galaxy Sky' ],
        'SM-S327VL'                                 => [ 'Samsung', 'Galaxy J3 Luna Pro' ],
        'SM-S337TL'                                 => [ 'Samsung', 'Galaxy J3 Luna Pro' ],
        'SM-S550TL'                                 => [ 'Samsung', 'Galaxy On5' ],
        'SM-S727VL'                                 => [ 'Samsung', 'Galaxy J7 Sky Pro' ],
        'SM-S765C'                                  => [ 'Samsung', 'Galaxy Ace Style' ],
        'SM-S766C'                                  => [ 'Samsung', 'Galaxy Stardust' ],
        'SM-S777C'                                  => [ 'Samsung', 'Galaxy J1' ],
        'SM-S780L'                                  => [ 'Samsung', 'Galaxy Mega 6.3' ],
        'SM-S820L'                                  => [ 'Samsung', 'Galaxy Core Prime' ],
        'SM-S890L'                                  => [ 'Samsung', 'Galaxy S4 Mini' ],
        'SM-S902L'                                  => [ 'Samsung', 'Galaxy S5' ],
        'SM-S903VL'                                 => [ 'Samsung', 'Galaxy S5' ],
        'SM-S906L'                                  => [ 'Samsung', 'Galaxy S6' ],
        'SM-S907VL'                                 => [ 'Samsung', 'Galaxy S6' ],
        'SM-S920L'                                  => [ 'Samsung', 'Galaxy Grand Prime' ],
        'SM-S975L'                                  => [ 'Samsung', 'Galaxy S4' ],
        'SM-S978L'                                  => [ 'Samsung', 'Galaxy E5' ],
    ],

    'SM-T[0-9]{3,3}!!' => [
        'SM-T11[01]!'                               => [ 'Samsung', 'Galaxy Tab 3 Lite', DeviceType::TABLET ],
        'SM-T11[36]!'                               => [ 'Samsung', 'Galaxy Tab 3V 7.0', DeviceType::TABLET ],
        'SM-T2105'                                  => [ 'Samsung', 'Galaxy Tab 3 Kids', DeviceType::TABLET ],
        'SM-T21[01257]!'                            => [ 'Samsung', 'Galaxy Tab 3 7.0', DeviceType::TABLET ],
        'SM-T2519'                                  => [ 'Samsung', 'Galaxy Tab Q' ],
        'SM-T255[68S]!'                             => [ 'Samsung', 'Galaxy Tab Q' ],
        'SM-T23[012579]!'                           => [ 'Samsung', 'Galaxy Tab 4 7.0', DeviceType::TABLET ],
        'SM-T28[057]!'                              => [ 'Samsung', 'Galaxy Tab A 7.0', DeviceType::TABLET ],
        'SM-T31[0125]!'                             => [ 'Samsung', 'Galaxy Tab 3 8.0', DeviceType::TABLET ],
        'SM-T32[0125]!'                             => [ 'Samsung', 'Galaxy Tab Pro 8.4', DeviceType::TABLET ],
        'SM-T33[01257]!'                            => [ 'Samsung', 'Galaxy Tab 4 8.0', DeviceType::TABLET ],
        'SM-T33[3]!'                                => [ 'Samsung', 'Galaxy Tab 4 8.0 (2015)', DeviceType::TABLET ],
        'SM-T35[0157]!'                             => [ 'Samsung', 'Galaxy Tab A 8.0', DeviceType::TABLET ],
        'SM-T36[05]!'                               => [ 'Samsung', 'Galaxy Tab Active 8.0', DeviceType::TABLET ],
        'SM-T37[578]!'                              => [ 'Samsung', 'Galaxy Tab E 8.0', DeviceType::TABLET ],
        'SM-T38[05]!'                               => [ 'Samsung', 'Galaxy Tab A 8.0 (2017)', DeviceType::TABLET ],
        'SM-T39[5]!'                                => [ 'Samsung', 'Galaxy Tab Active2 8.0', DeviceType::TABLET ],
    